#!perl -T

BEGIN { require './t/test.pl' }

use Test::More tests => 2673;
use strict;
use utf8;

# Test 1: See if the module loads
BEGIN { use_ok('JE') };


my $j = new JE;


# Tests 2-3: Bind the ok and diag functions
isa_ok( $j->new_function( ok  => \&ok   ), 'JE::Object::Function' );
isa_ok( $j->new_function( diag => \&diag ), 'JE::Object::Function' );
$j->new_function(is=>\&is);


# JS tests
defined $j->eval( <<'--end--' ) or die;

// OK, I admit it. I've gone a bit overboard with the number of tests. (But
// that's how you find bugs, right?)

// ===================================================
// 11.6.1 <<
// ===================================================

/* Tests 4-51: type convernsion */

ok( void 0  <<  void 0           === 0,     "undefined << undefined")
ok( void 0  <<  null             === 0,     "undefined << null")
ok( void 0  <<  true             === 0,     "undefined << boolean")
ok( void 0  << "string"          === 0,     "undefined << string")
ok( void 0  <<  73               === 0,     "undefined << number")
ok( void 0  <<  {}               === 0,     "undefined << object")
ok( void 0  <<  new Number(34.2) === 0,     "undefined << number object")
ok( null    <<  void 0           === 0,     "null << undefined")
ok( null    <<  null             === 0,     "null << null")
ok( null    <<  true             === 0,     "null << boolean")
ok( null    << "string"          === 0,     "null << string")
ok( null    <<  73               === 0,     "null << number")
ok( null    <<  {}               === 0,     "null << object")
ok( null    <<  new Number(34.2) === 0,     "null << number object")
ok( true    <<  void 0           === 1,     "boolean << undefined")
ok( true    <<  null             === 1,     "boolean << null")
ok( true    <<  true             === 2,     "boolean << boolean")
ok( true    << "string"          === 1,     "boolean << string")
ok( true    <<  73               === 512,   "boolean << number")
ok( true    <<  {}               === 1,     "boolean << object")
ok( true    <<  new Number(34.2) === 4,     "boolean << number object")
ok("string" <<  void 0           === 0,     "string << undefined")
ok("string" <<  null             === 0,     "string << null")
ok("string" <<  true             === 0,     "string << boolean")
ok("string" << "string"          === 0,     "string << string")
ok("string" <<  73               === 0,     "string << number")
ok("string" <<  {}               === 0,     "string << object")
ok("string" <<  new Number(34.2) === 0,     "string << number object")
ok( 73      <<  void 0           === 73,    "number << undefined")
ok( 73      <<  null             === 73,    "number << null")
ok( 73      <<  true             === 146,   "number << boolean")
ok( 73      << "string"          === 73,    "number << string")
ok( 73      <<  {}               === 73,    "number << object")
ok( 73      <<  new Number(34.2) === 292,   "number << number object")
ok( {}      <<  void 0           === 0,     "object << undefined")
ok( {}      <<  null             === 0,     "object << null")
ok( {}      <<  true             === 0,     "object << boolean")
ok( {}      << "string"          === 0,     "object << string")
ok( {}      <<  73               === 0,     "object << number")
ok( {}      <<  {}               === 0,     "object << object")
ok( {}      <<  new Number(34.2) === 0,     "object << number object")
ok( new Number(34.2) <<  void 0  === 34,    "number object << undefined")
ok( new Number(34.2) <<  null    === 34,    "number object << null")
ok( new Number(34.2) <<  true    === 68,    "number object << boolean")
ok( new Number(34.2) << "string" === 34,    "number object << string")
ok( new Number(34.2) <<  73      === 17408, "number object << number")
ok( new Number(34.2) <<  {}      === 34,    "number object << object")
ok( new Number(34.2) <<  new Number(34.2) === 136,
	"number object << number object")

/* Tests 52-892: number << number */

n2n = [
	[NaN, NaN, 0],
	[NaN, +0, 0],
	[NaN, -0, 0],
	[NaN, Infinity, 0],
	[NaN, -Infinity, 0],
	[NaN, 1, 0],
	[NaN, 32.5, 0],
	[NaN, 2147483648, 0],
	[NaN, 3000000000, 0],
	[NaN, 4000000000.23, 0],
	[NaN, 5000000000, 0],
	[NaN, 4294967296, 0],
	[NaN, 4294967298.479, 0],
	[NaN, 6442450942, 0],
	[NaN, 6442450943.674, 0],
	[NaN, 6442450944, 0],
	[NaN, 6442450945, 0],
	[NaN, 6442450946.74, 0],
	[NaN, -1, 0],
	[NaN, -32.5, 0],
	[NaN, -3000000000, 0],
	[NaN, -4000000000.23, 0],
	[NaN, -5000000000, 0],
	[NaN, -4294967298.479, 0],
	[NaN, -6442450942, 0],
	[NaN, -6442450943.674, 0],
	[NaN, -6442450944, 0],
	[NaN, -6442450945, 0],
	[NaN, -6442450946.74, 0],
	[+0, NaN, 0],
	[+0, +0, 0],
	[+0, -0, 0],
	[+0, Infinity, 0],
	[+0, -Infinity, 0],
	[+0, 1, 0],
	[+0, 32.5, 0],
	[+0, 2147483648, 0],
	[+0, 3000000000, 0],
	[+0, 4000000000.23, 0],
	[+0, 5000000000, 0],
	[+0, 4294967296, 0],
	[+0, 4294967298.479, 0],
	[+0, 6442450942, 0],
	[+0, 6442450943.674, 0],
	[+0, 6442450944, 0],
	[+0, 6442450945, 0],
	[+0, 6442450946.74, 0],
	[+0, -1, 0],
	[+0, -32.5, 0],
	[+0, -3000000000, 0],
	[+0, -4000000000.23, 0],
	[+0, -5000000000, 0],
	[+0, -4294967298.479, 0],
	[+0, -6442450942, 0],
	[+0, -6442450943.674, 0],
	[+0, -6442450944, 0],
	[+0, -6442450945, 0],
	[+0, -6442450946.74, 0],
	[-0, NaN, 0],
	[-0, +0, 0],
	[-0, -0, 0],
	[-0, Infinity, 0],
	[-0, -Infinity, 0],
	[-0, 1, 0],
	[-0, 32.5, 0],
	[-0, 2147483648, 0],
	[-0, 3000000000, 0],
	[-0, 4000000000.23, 0],
	[-0, 5000000000, 0],
	[-0, 4294967296, 0],
	[-0, 4294967298.479, 0],
	[-0, 6442450942, 0],
	[-0, 6442450943.674, 0],
	[-0, 6442450944, 0],
	[-0, 6442450945, 0],
	[-0, 6442450946.74, 0],
	[-0, -1, 0],
	[-0, -32.5, 0],
	[-0, -3000000000, 0],
	[-0, -4000000000.23, 0],
	[-0, -5000000000, 0],
	[-0, -4294967298.479, 0],
	[-0, -6442450942, 0],
	[-0, -6442450943.674, 0],
	[-0, -6442450944, 0],
	[-0, -6442450945, 0],
	[-0, -6442450946.74, 0],
	[Infinity, NaN, 0],
	[Infinity, +0, 0],
	[Infinity, -0, 0],
	[Infinity, Infinity, 0],
	[Infinity, -Infinity, 0],
	[Infinity, 1, 0],
	[Infinity, 32.5, 0],
	[Infinity, 2147483648, 0],
	[Infinity, 3000000000, 0],
	[Infinity, 4000000000.23, 0],
	[Infinity, 5000000000, 0],
	[Infinity, 4294967296, 0],
	[Infinity, 4294967298.479, 0],
	[Infinity, 6442450942, 0],
	[Infinity, 6442450943.674, 0],
	[Infinity, 6442450944, 0],
	[Infinity, 6442450945, 0],
	[Infinity, 6442450946.74, 0],
	[Infinity, -1, 0],
	[Infinity, -32.5, 0],
	[Infinity, -3000000000, 0],
	[Infinity, -4000000000.23, 0],
	[Infinity, -5000000000, 0],
	[Infinity, -4294967298.479, 0],
	[Infinity, -6442450942, 0],
	[Infinity, -6442450943.674, 0],
	[Infinity, -6442450944, 0],
	[Infinity, -6442450945, 0],
	[Infinity, -6442450946.74, 0],
	[-Infinity, NaN, 0],
	[-Infinity, +0, 0],
	[-Infinity, -0, 0],
	[-Infinity, Infinity, 0],
	[-Infinity, -Infinity, 0],
	[-Infinity, 1, 0],
	[-Infinity, 32.5, 0],
	[-Infinity, 2147483648, 0],
	[-Infinity, 3000000000, 0],
	[-Infinity, 4000000000.23, 0],
	[-Infinity, 5000000000, 0],
	[-Infinity, 4294967296, 0],
	[-Infinity, 4294967298.479, 0],
	[-Infinity, 6442450942, 0],
	[-Infinity, 6442450943.674, 0],
	[-Infinity, 6442450944, 0],
	[-Infinity, 6442450945, 0],
	[-Infinity, 6442450946.74, 0],
	[-Infinity, -1, 0],
	[-Infinity, -32.5, 0],
	[-Infinity, -3000000000, 0],
	[-Infinity, -4000000000.23, 0],
	[-Infinity, -5000000000, 0],
	[-Infinity, -4294967298.479, 0],
	[-Infinity, -6442450942, 0],
	[-Infinity, -6442450943.674, 0],
	[-Infinity, -6442450944, 0],
	[-Infinity, -6442450945, 0],
	[-Infinity, -6442450946.74, 0],
	[1, NaN, 1],
	[1, +0, 1],
	[1, -0, 1],
	[1, Infinity, 1],
	[1, -Infinity, 1],
	[1, 1, 2],
	[1, 32.5, 1],
	[1, 2147483648, 1],
	[1, 3000000000, 1],
	[1, 4000000000.23, 1],
	[1, 5000000000, 1],
	[1, 4294967296, 1],
	[1, 4294967298.479, 4],
	[1, 6442450942, 1073741824],
	[1, 6442450943.674, -2147483648],
	[1, 6442450944, 1],
	[1, 6442450945, 2],
	[1, 6442450946.74, 4],
	[1, -1, -2147483648],
	[1, -32.5, 1],
	[1, -3000000000, 1],
	[1, -4000000000.23, 1],
	[1, -5000000000, 1],
	[1, -4294967298.479, 1073741824],
	[1, -6442450942, 4],
	[1, -6442450943.674, 2],
	[1, -6442450944, 1],
	[1, -6442450945, -2147483648],
	[1, -6442450946.74, 1073741824],
	[32.5, NaN, 32],
	[32.5, +0, 32],
	[32.5, -0, 32],
	[32.5, Infinity, 32],
	[32.5, -Infinity, 32],
	[32.5, 1, 64],
	[32.5, 32.5, 32],
	[32.5, 2147483648, 32],
	[32.5, 3000000000, 32],
	[32.5, 4000000000.23, 32],
	[32.5, 5000000000, 32],
	[32.5, 4294967296, 32],
	[32.5, 4294967298.479, 128],
	[32.5, 6442450942, 0],
	[32.5, 6442450943.674, 0],
	[32.5, 6442450944, 32],
	[32.5, 6442450945, 64],
	[32.5, 6442450946.74, 128],
	[32.5, -1, 0],
	[32.5, -32.5, 32],
	[32.5, -3000000000, 32],
	[32.5, -4000000000.23, 32],
	[32.5, -5000000000, 32],
	[32.5, -4294967298.479, 0],
	[32.5, -6442450942, 128],
	[32.5, -6442450943.674, 64],
	[32.5, -6442450944, 32],
	[32.5, -6442450945, 0],
	[32.5, -6442450946.74, 0],
	[2147483648, NaN, -2147483648],
	[2147483648, +0, -2147483648],
	[2147483648, -0, -2147483648],
	[2147483648, Infinity, -2147483648],
	[2147483648, -Infinity, -2147483648],
	[2147483648, 1, 0],
	[2147483648, 32.5, -2147483648],
	[2147483648, 2147483648, -2147483648],
	[2147483648, 3000000000, -2147483648],
	[2147483648, 4000000000.23, -2147483648],
	[2147483648, 5000000000, -2147483648],
	[2147483648, 4294967296, -2147483648],
	[2147483648, 4294967298.479, 0],
	[2147483648, 6442450942, 0],
	[2147483648, 6442450943.674, 0],
	[2147483648, 6442450944, -2147483648],
	[2147483648, 6442450945, 0],
	[2147483648, 6442450946.74, 0],
	[2147483648, -1, 0],
	[2147483648, -32.5, -2147483648],
	[2147483648, -3000000000, -2147483648],
	[2147483648, -4000000000.23, -2147483648],
	[2147483648, -5000000000, -2147483648],
	[2147483648, -4294967298.479, 0],
	[2147483648, -6442450942, 0],
	[2147483648, -6442450943.674, 0],
	[2147483648, -6442450944, -2147483648],
	[2147483648, -6442450945, 0],
	[2147483648, -6442450946.74, 0],
	[3000000000, NaN, -1294967296],
	[3000000000, +0, -1294967296],
	[3000000000, -0, -1294967296],
	[3000000000, Infinity, -1294967296],
	[3000000000, -Infinity, -1294967296],
	[3000000000, 1, 1705032704],
	[3000000000, 32.5, -1294967296],
	[3000000000, 2147483648, -1294967296],
	[3000000000, 3000000000, -1294967296],
	[3000000000, 4000000000.23, -1294967296],
	[3000000000, 5000000000, -1294967296],
	[3000000000, 4294967296, -1294967296],
	[3000000000, 4294967298.479, -884901888],
	[3000000000, 6442450942, 0],
	[3000000000, 6442450943.674, 0],
	[3000000000, 6442450944, -1294967296],
	[3000000000, 6442450945, 1705032704],
	[3000000000, 6442450946.74, -884901888],
	[3000000000, -1, 0],
	[3000000000, -32.5, -1294967296],
	[3000000000, -3000000000, -1294967296],
	[3000000000, -4000000000.23, -1294967296],
	[3000000000, -5000000000, -1294967296],
	[3000000000, -4294967298.479, 0],
	[3000000000, -6442450942, -884901888],
	[3000000000, -6442450943.674, 1705032704],
	[3000000000, -6442450944, -1294967296],
	[3000000000, -6442450945, 0],
	[3000000000, -6442450946.74, 0],
	[4000000000.23, NaN, -294967296],
	[4000000000.23, +0, -294967296],
	[4000000000.23, -0, -294967296],
	[4000000000.23, Infinity, -294967296],
	[4000000000.23, -Infinity, -294967296],
	[4000000000.23, 1, -589934592],
	[4000000000.23, 32.5, -294967296],
	[4000000000.23, 2147483648, -294967296],
	[4000000000.23, 3000000000, -294967296],
	[4000000000.23, 4000000000.23, -294967296],
	[4000000000.23, 5000000000, -294967296],
	[4000000000.23, 4294967296, -294967296],
	[4000000000.23, 4294967298.479, -1179869184],
	[4000000000.23, 6442450942, 0],
	[4000000000.23, 6442450943.674, 0],
	[4000000000.23, 6442450944, -294967296],
	[4000000000.23, 6442450945, -589934592],
	[4000000000.23, 6442450946.74, -1179869184],
	[4000000000.23, -1, 0],
	[4000000000.23, -32.5, -294967296],
	[4000000000.23, -3000000000, -294967296],
	[4000000000.23, -4000000000.23, -294967296],
	[4000000000.23, -5000000000, -294967296],
	[4000000000.23, -4294967298.479, 0],
	[4000000000.23, -6442450942, -1179869184],
	[4000000000.23, -6442450943.674, -589934592],
	[4000000000.23, -6442450944, -294967296],
	[4000000000.23, -6442450945, 0],
	[4000000000.23, -6442450946.74, 0],
	[5000000000, NaN, 705032704],
	[5000000000, +0, 705032704],
	[5000000000, -0, 705032704],
	[5000000000, Infinity, 705032704],
	[5000000000, -Infinity, 705032704],
	[5000000000, 1, 1410065408],
	[5000000000, 32.5, 705032704],
	[5000000000, 2147483648, 705032704],
	[5000000000, 3000000000, 705032704],
	[5000000000, 4000000000.23, 705032704],
	[5000000000, 5000000000, 705032704],
	[5000000000, 4294967296, 705032704],
	[5000000000, 4294967298.479, -1474836480],
	[5000000000, 6442450942, 0],
	[5000000000, 6442450943.674, 0],
	[5000000000, 6442450944, 705032704],
	[5000000000, 6442450945, 1410065408],
	[5000000000, 6442450946.74, -1474836480],
	[5000000000, -1, 0],
	[5000000000, -32.5, 705032704],
	[5000000000, -3000000000, 705032704],
	[5000000000, -4000000000.23, 705032704],
	[5000000000, -5000000000, 705032704],
	[5000000000, -4294967298.479, 0],
	[5000000000, -6442450942, -1474836480],
	[5000000000, -6442450943.674, 1410065408],
	[5000000000, -6442450944, 705032704],
	[5000000000, -6442450945, 0],
	[5000000000, -6442450946.74, 0],
	[4294967296, NaN, 0],
	[4294967296, +0, 0],
	[4294967296, -0, 0],
	[4294967296, Infinity, 0],
	[4294967296, -Infinity, 0],
	[4294967296, 1, 0],
	[4294967296, 32.5, 0],
	[4294967296, 2147483648, 0],
	[4294967296, 3000000000, 0],
	[4294967296, 4000000000.23, 0],
	[4294967296, 5000000000, 0],
	[4294967296, 4294967296, 0],
	[4294967296, 4294967298.479, 0],
	[4294967296, 6442450942, 0],
	[4294967296, 6442450943.674, 0],
	[4294967296, 6442450944, 0],
	[4294967296, 6442450945, 0],
	[4294967296, 6442450946.74, 0],
	[4294967296, -1, 0],
	[4294967296, -32.5, 0],
	[4294967296, -3000000000, 0],
	[4294967296, -4000000000.23, 0],
	[4294967296, -5000000000, 0],
	[4294967296, -4294967298.479, 0],
	[4294967296, -6442450942, 0],
	[4294967296, -6442450943.674, 0],
	[4294967296, -6442450944, 0],
	[4294967296, -6442450945, 0],
	[4294967296, -6442450946.74, 0],
	[4294967298.479, NaN, 2],
	[4294967298.479, +0, 2],
	[4294967298.479, -0, 2],
	[4294967298.479, Infinity, 2],
	[4294967298.479, -Infinity, 2],
	[4294967298.479, 1, 4],
	[4294967298.479, 32.5, 2],
	[4294967298.479, 2147483648, 2],
	[4294967298.479, 3000000000, 2],
	[4294967298.479, 4000000000.23, 2],
	[4294967298.479, 5000000000, 2],
	[4294967298.479, 4294967296, 2],
	[4294967298.479, 4294967298.479, 8],
	[4294967298.479, 6442450942, -2147483648],
	[4294967298.479, 6442450943.674, 0],
	[4294967298.479, 6442450944, 2],
	[4294967298.479, 6442450945, 4],
	[4294967298.479, 6442450946.74, 8],
	[4294967298.479, -1, 0],
	[4294967298.479, -32.5, 2],
	[4294967298.479, -3000000000, 2],
	[4294967298.479, -4000000000.23, 2],
	[4294967298.479, -5000000000, 2],
	[4294967298.479, -4294967298.479, -2147483648],
	[4294967298.479, -6442450942, 8],
	[4294967298.479, -6442450943.674, 4],
	[4294967298.479, -6442450944, 2],
	[4294967298.479, -6442450945, 0],
	[4294967298.479, -6442450946.74, -2147483648],
	[6442450942, NaN, 2147483646],
	[6442450942, +0, 2147483646],
	[6442450942, -0, 2147483646],
	[6442450942, Infinity, 2147483646],
	[6442450942, -Infinity, 2147483646],
	[6442450942, 1, -4],
	[6442450942, 32.5, 2147483646],
	[6442450942, 2147483648, 2147483646],
	[6442450942, 3000000000, 2147483646],
	[6442450942, 4000000000.23, 2147483646],
	[6442450942, 5000000000, 2147483646],
	[6442450942, 4294967296, 2147483646],
	[6442450942, 4294967298.479, -8],
	[6442450942, 6442450942, -2147483648],
	[6442450942, 6442450943.674, 0],
	[6442450942, 6442450944, 2147483646],
	[6442450942, 6442450945, -4],
	[6442450942, 6442450946.74, -8],
	[6442450942, -1, 0],
	[6442450942, -32.5, 2147483646],
	[6442450942, -3000000000, 2147483646],
	[6442450942, -4000000000.23, 2147483646],
	[6442450942, -5000000000, 2147483646],
	[6442450942, -4294967298.479, -2147483648],
	[6442450942, -6442450942, -8],
	[6442450942, -6442450943.674, -4],
	[6442450942, -6442450944, 2147483646],
	[6442450942, -6442450945, 0],
	[6442450942, -6442450946.74, -2147483648],
	[6442450943.674, NaN, 2147483647],
	[6442450943.674, +0, 2147483647],
	[6442450943.674, -0, 2147483647],
	[6442450943.674, Infinity, 2147483647],
	[6442450943.674, -Infinity, 2147483647],
	[6442450943.674, 1, -2],
	[6442450943.674, 32.5, 2147483647],
	[6442450943.674, 2147483648, 2147483647],
	[6442450943.674, 3000000000, 2147483647],
	[6442450943.674, 4000000000.23, 2147483647],
	[6442450943.674, 5000000000, 2147483647],
	[6442450943.674, 4294967296, 2147483647],
	[6442450943.674, 4294967298.479, -4],
	[6442450943.674, 6442450942, -1073741824],
	[6442450943.674, 6442450943.674, -2147483648],
	[6442450943.674, 6442450944, 2147483647],
	[6442450943.674, 6442450945, -2],
	[6442450943.674, 6442450946.74, -4],
	[6442450943.674, -1, -2147483648],
	[6442450943.674, -32.5, 2147483647],
	[6442450943.674, -3000000000, 2147483647],
	[6442450943.674, -4000000000.23, 2147483647],
	[6442450943.674, -5000000000, 2147483647],
	[6442450943.674, -4294967298.479, -1073741824],
	[6442450943.674, -6442450942, -4],
	[6442450943.674, -6442450943.674, -2],
	[6442450943.674, -6442450944, 2147483647],
	[6442450943.674, -6442450945, -2147483648],
	[6442450943.674, -6442450946.74, -1073741824],
	[6442450944, NaN, -2147483648],
	[6442450944, +0, -2147483648],
	[6442450944, -0, -2147483648],
	[6442450944, Infinity, -2147483648],
	[6442450944, -Infinity, -2147483648],
	[6442450944, 1, 0],
	[6442450944, 32.5, -2147483648],
	[6442450944, 2147483648, -2147483648],
	[6442450944, 3000000000, -2147483648],
	[6442450944, 4000000000.23, -2147483648],
	[6442450944, 5000000000, -2147483648],
	[6442450944, 4294967296, -2147483648],
	[6442450944, 4294967298.479, 0],
	[6442450944, 6442450942, 0],
	[6442450944, 6442450943.674, 0],
	[6442450944, 6442450944, -2147483648],
	[6442450944, 6442450945, 0],
	[6442450944, 6442450946.74, 0],
	[6442450944, -1, 0],
	[6442450944, -32.5, -2147483648],
	[6442450944, -3000000000, -2147483648],
	[6442450944, -4000000000.23, -2147483648],
	[6442450944, -5000000000, -2147483648],
	[6442450944, -4294967298.479, 0],
	[6442450944, -6442450942, 0],
	[6442450944, -6442450943.674, 0],
	[6442450944, -6442450944, -2147483648],
	[6442450944, -6442450945, 0],
	[6442450944, -6442450946.74, 0],
	[6442450945, NaN, -2147483647],
	[6442450945, +0, -2147483647],
	[6442450945, -0, -2147483647],
	[6442450945, Infinity, -2147483647],
	[6442450945, -Infinity, -2147483647],
	[6442450945, 1, 2],
	[6442450945, 32.5, -2147483647],
	[6442450945, 2147483648, -2147483647],
	[6442450945, 3000000000, -2147483647],
	[6442450945, 4000000000.23, -2147483647],
	[6442450945, 5000000000, -2147483647],
	[6442450945, 4294967296, -2147483647],
	[6442450945, 4294967298.479, 4],
	[6442450945, 6442450942, 1073741824],
	[6442450945, 6442450943.674, -2147483648],
	[6442450945, 6442450944, -2147483647],
	[6442450945, 6442450945, 2],
	[6442450945, 6442450946.74, 4],
	[6442450945, -1, -2147483648],
	[6442450945, -32.5, -2147483647],
	[6442450945, -3000000000, -2147483647],
	[6442450945, -4000000000.23, -2147483647],
	[6442450945, -5000000000, -2147483647],
	[6442450945, -4294967298.479, 1073741824],
	[6442450945, -6442450942, 4],
	[6442450945, -6442450943.674, 2],
	[6442450945, -6442450944, -2147483647],
	[6442450945, -6442450945, -2147483648],
	[6442450945, -6442450946.74, 1073741824],
	[6442450946.74, NaN, -2147483646],
	[6442450946.74, +0, -2147483646],
	[6442450946.74, -0, -2147483646],
	[6442450946.74, Infinity, -2147483646],
	[6442450946.74, -Infinity, -2147483646],
	[6442450946.74, 1, 4],
	[6442450946.74, 32.5, -2147483646],
	[6442450946.74, 2147483648, -2147483646],
	[6442450946.74, 3000000000, -2147483646],
	[6442450946.74, 4000000000.23, -2147483646],
	[6442450946.74, 5000000000, -2147483646],
	[6442450946.74, 4294967296, -2147483646],
	[6442450946.74, 4294967298.479, 8],
	[6442450946.74, 6442450942, -2147483648],
	[6442450946.74, 6442450943.674, 0],
	[6442450946.74, 6442450944, -2147483646],
	[6442450946.74, 6442450945, 4],
	[6442450946.74, 6442450946.74, 8],
	[6442450946.74, -1, 0],
	[6442450946.74, -32.5, -2147483646],
	[6442450946.74, -3000000000, -2147483646],
	[6442450946.74, -4000000000.23, -2147483646],
	[6442450946.74, -5000000000, -2147483646],
	[6442450946.74, -4294967298.479, -2147483648],
	[6442450946.74, -6442450942, 8],
	[6442450946.74, -6442450943.674, 4],
	[6442450946.74, -6442450944, -2147483646],
	[6442450946.74, -6442450945, 0],
	[6442450946.74, -6442450946.74, -2147483648],
	[-1, NaN, -1],
	[-1, +0, -1],
	[-1, -0, -1],
	[-1, Infinity, -1],
	[-1, -Infinity, -1],
	[-1, 1, -2],
	[-1, 32.5, -1],
	[-1, 2147483648, -1],
	[-1, 3000000000, -1],
	[-1, 4000000000.23, -1],
	[-1, 5000000000, -1],
	[-1, 4294967296, -1],
	[-1, 4294967298.479, -4],
	[-1, 6442450942, -1073741824],
	[-1, 6442450943.674, -2147483648],
	[-1, 6442450944, -1],
	[-1, 6442450945, -2],
	[-1, 6442450946.74, -4],
	[-1, -1, -2147483648],
	[-1, -32.5, -1],
	[-1, -3000000000, -1],
	[-1, -4000000000.23, -1],
	[-1, -5000000000, -1],
	[-1, -4294967298.479, -1073741824],
	[-1, -6442450942, -4],
	[-1, -6442450943.674, -2],
	[-1, -6442450944, -1],
	[-1, -6442450945, -2147483648],
	[-1, -6442450946.74, -1073741824],
	[-32.5, NaN, -32],
	[-32.5, +0, -32],
	[-32.5, -0, -32],
	[-32.5, Infinity, -32],
	[-32.5, -Infinity, -32],
	[-32.5, 1, -64],
	[-32.5, 32.5, -32],
	[-32.5, 2147483648, -32],
	[-32.5, 3000000000, -32],
	[-32.5, 4000000000.23, -32],
	[-32.5, 5000000000, -32],
	[-32.5, 4294967296, -32],
	[-32.5, 4294967298.479, -128],
	[-32.5, 6442450942, 0],
	[-32.5, 6442450943.674, 0],
	[-32.5, 6442450944, -32],
	[-32.5, 6442450945, -64],
	[-32.5, 6442450946.74, -128],
	[-32.5, -1, 0],
	[-32.5, -32.5, -32],
	[-32.5, -3000000000, -32],
	[-32.5, -4000000000.23, -32],
	[-32.5, -5000000000, -32],
	[-32.5, -4294967298.479, 0],
	[-32.5, -6442450942, -128],
	[-32.5, -6442450943.674, -64],
	[-32.5, -6442450944, -32],
	[-32.5, -6442450945, 0],
	[-32.5, -6442450946.74, 0],
	[-3000000000, NaN, 1294967296],
	[-3000000000, +0, 1294967296],
	[-3000000000, -0, 1294967296],
	[-3000000000, Infinity, 1294967296],
	[-3000000000, -Infinity, 1294967296],
	[-3000000000, 1, -1705032704],
	[-3000000000, 32.5, 1294967296],
	[-3000000000, 2147483648, 1294967296],
	[-3000000000, 3000000000, 1294967296],
	[-3000000000, 4000000000.23, 1294967296],
	[-3000000000, 5000000000, 1294967296],
	[-3000000000, 4294967296, 1294967296],
	[-3000000000, 4294967298.479, 884901888],
	[-3000000000, 6442450942, 0],
	[-3000000000, 6442450943.674, 0],
	[-3000000000, 6442450944, 1294967296],
	[-3000000000, 6442450945, -1705032704],
	[-3000000000, 6442450946.74, 884901888],
	[-3000000000, -1, 0],
	[-3000000000, -32.5, 1294967296],
	[-3000000000, -3000000000, 1294967296],
	[-3000000000, -4000000000.23, 1294967296],
	[-3000000000, -5000000000, 1294967296],
	[-3000000000, -4294967298.479, 0],
	[-3000000000, -6442450942, 884901888],
	[-3000000000, -6442450943.674, -1705032704],
	[-3000000000, -6442450944, 1294967296],
	[-3000000000, -6442450945, 0],
	[-3000000000, -6442450946.74, 0],
	[-4000000000.23, NaN, 294967296],
	[-4000000000.23, +0, 294967296],
	[-4000000000.23, -0, 294967296],
	[-4000000000.23, Infinity, 294967296],
	[-4000000000.23, -Infinity, 294967296],
	[-4000000000.23, 1, 589934592],
	[-4000000000.23, 32.5, 294967296],
	[-4000000000.23, 2147483648, 294967296],
	[-4000000000.23, 3000000000, 294967296],
	[-4000000000.23, 4000000000.23, 294967296],
	[-4000000000.23, 5000000000, 294967296],
	[-4000000000.23, 4294967296, 294967296],
	[-4000000000.23, 4294967298.479, 1179869184],
	[-4000000000.23, 6442450942, 0],
	[-4000000000.23, 6442450943.674, 0],
	[-4000000000.23, 6442450944, 294967296],
	[-4000000000.23, 6442450945, 589934592],
	[-4000000000.23, 6442450946.74, 1179869184],
	[-4000000000.23, -1, 0],
	[-4000000000.23, -32.5, 294967296],
	[-4000000000.23, -3000000000, 294967296],
	[-4000000000.23, -4000000000.23, 294967296],
	[-4000000000.23, -5000000000, 294967296],
	[-4000000000.23, -4294967298.479, 0],
	[-4000000000.23, -6442450942, 1179869184],
	[-4000000000.23, -6442450943.674, 589934592],
	[-4000000000.23, -6442450944, 294967296],
	[-4000000000.23, -6442450945, 0],
	[-4000000000.23, -6442450946.74, 0],
	[-5000000000, NaN, -705032704],
	[-5000000000, +0, -705032704],
	[-5000000000, -0, -705032704],
	[-5000000000, Infinity, -705032704],
	[-5000000000, -Infinity, -705032704],
	[-5000000000, 1, -1410065408],
	[-5000000000, 32.5, -705032704],
	[-5000000000, 2147483648, -705032704],
	[-5000000000, 3000000000, -705032704],
	[-5000000000, 4000000000.23, -705032704],
	[-5000000000, 5000000000, -705032704],
	[-5000000000, 4294967296, -705032704],
	[-5000000000, 4294967298.479, 1474836480],
	[-5000000000, 6442450942, 0],
	[-5000000000, 6442450943.674, 0],
	[-5000000000, 6442450944, -705032704],
	[-5000000000, 6442450945, -1410065408],
	[-5000000000, 6442450946.74, 1474836480],
	[-5000000000, -1, 0],
	[-5000000000, -32.5, -705032704],
	[-5000000000, -3000000000, -705032704],
	[-5000000000, -4000000000.23, -705032704],
	[-5000000000, -5000000000, -705032704],
	[-5000000000, -4294967298.479, 0],
	[-5000000000, -6442450942, 1474836480],
	[-5000000000, -6442450943.674, -1410065408],
	[-5000000000, -6442450944, -705032704],
	[-5000000000, -6442450945, 0],
	[-5000000000, -6442450946.74, 0],
	[-4294967298.479, NaN, -2],
	[-4294967298.479, +0, -2],
	[-4294967298.479, -0, -2],
	[-4294967298.479, Infinity, -2],
	[-4294967298.479, -Infinity, -2],
	[-4294967298.479, 1, -4],
	[-4294967298.479, 32.5, -2],
	[-4294967298.479, 2147483648, -2],
	[-4294967298.479, 3000000000, -2],
	[-4294967298.479, 4000000000.23, -2],
	[-4294967298.479, 5000000000, -2],
	[-4294967298.479, 4294967296, -2],
	[-4294967298.479, 4294967298.479, -8],
	[-4294967298.479, 6442450942, -2147483648],
	[-4294967298.479, 6442450943.674, 0],
	[-4294967298.479, 6442450944, -2],
	[-4294967298.479, 6442450945, -4],
	[-4294967298.479, 6442450946.74, -8],
	[-4294967298.479, -1, 0],
	[-4294967298.479, -32.5, -2],
	[-4294967298.479, -3000000000, -2],
	[-4294967298.479, -4000000000.23, -2],
	[-4294967298.479, -5000000000, -2],
	[-4294967298.479, -4294967298.479, -2147483648],
	[-4294967298.479, -6442450942, -8],
	[-4294967298.479, -6442450943.674, -4],
	[-4294967298.479, -6442450944, -2],
	[-4294967298.479, -6442450945, 0],
	[-4294967298.479, -6442450946.74, -2147483648],
	[-6442450942, NaN, -2147483646],
	[-6442450942, +0, -2147483646],
	[-6442450942, -0, -2147483646],
	[-6442450942, Infinity, -2147483646],
	[-6442450942, -Infinity, -2147483646],
	[-6442450942, 1, 4],
	[-6442450942, 32.5, -2147483646],
	[-6442450942, 2147483648, -2147483646],
	[-6442450942, 3000000000, -2147483646],
	[-6442450942, 4000000000.23, -2147483646],
	[-6442450942, 5000000000, -2147483646],
	[-6442450942, 4294967296, -2147483646],
	[-6442450942, 4294967298.479, 8],
	[-6442450942, 6442450942, -2147483648],
	[-6442450942, 6442450943.674, 0],
	[-6442450942, 6442450944, -2147483646],
	[-6442450942, 6442450945, 4],
	[-6442450942, 6442450946.74, 8],
	[-6442450942, -1, 0],
	[-6442450942, -32.5, -2147483646],
	[-6442450942, -3000000000, -2147483646],
	[-6442450942, -4000000000.23, -2147483646],
	[-6442450942, -5000000000, -2147483646],
	[-6442450942, -4294967298.479, -2147483648],
	[-6442450942, -6442450942, 8],
	[-6442450942, -6442450943.674, 4],
	[-6442450942, -6442450944, -2147483646],
	[-6442450942, -6442450945, 0],
	[-6442450942, -6442450946.74, -2147483648],
	[-6442450943.674, NaN, -2147483647],
	[-6442450943.674, +0, -2147483647],
	[-6442450943.674, -0, -2147483647],
	[-6442450943.674, Infinity, -2147483647],
	[-6442450943.674, -Infinity, -2147483647],
	[-6442450943.674, 1, 2],
	[-6442450943.674, 32.5, -2147483647],
	[-6442450943.674, 2147483648, -2147483647],
	[-6442450943.674, 3000000000, -2147483647],
	[-6442450943.674, 4000000000.23, -2147483647],
	[-6442450943.674, 5000000000, -2147483647],
	[-6442450943.674, 4294967296, -2147483647],
	[-6442450943.674, 4294967298.479, 4],
	[-6442450943.674, 6442450942, 1073741824],
	[-6442450943.674, 6442450943.674, -2147483648],
	[-6442450943.674, 6442450944, -2147483647],
	[-6442450943.674, 6442450945, 2],
	[-6442450943.674, 6442450946.74, 4],
	[-6442450943.674, -1, -2147483648],
	[-6442450943.674, -32.5, -2147483647],
	[-6442450943.674, -3000000000, -2147483647],
	[-6442450943.674, -4000000000.23, -2147483647],
	[-6442450943.674, -5000000000, -2147483647],
	[-6442450943.674, -4294967298.479, 1073741824],
	[-6442450943.674, -6442450942, 4],
	[-6442450943.674, -6442450943.674, 2],
	[-6442450943.674, -6442450944, -2147483647],
	[-6442450943.674, -6442450945, -2147483648],
	[-6442450943.674, -6442450946.74, 1073741824],
	[-6442450944, NaN, -2147483648],
	[-6442450944, +0, -2147483648],
	[-6442450944, -0, -2147483648],
	[-6442450944, Infinity, -2147483648],
	[-6442450944, -Infinity, -2147483648],
	[-6442450944, 1, 0],
	[-6442450944, 32.5, -2147483648],
	[-6442450944, 2147483648, -2147483648],
	[-6442450944, 3000000000, -2147483648],
	[-6442450944, 4000000000.23, -2147483648],
	[-6442450944, 5000000000, -2147483648],
	[-6442450944, 4294967296, -2147483648],
	[-6442450944, 4294967298.479, 0],
	[-6442450944, 6442450942, 0],
	[-6442450944, 6442450943.674, 0],
	[-6442450944, 6442450944, -2147483648],
	[-6442450944, 6442450945, 0],
	[-6442450944, 6442450946.74, 0],
	[-6442450944, -1, 0],
	[-6442450944, -32.5, -2147483648],
	[-6442450944, -3000000000, -2147483648],
	[-6442450944, -4000000000.23, -2147483648],
	[-6442450944, -5000000000, -2147483648],
	[-6442450944, -4294967298.479, 0],
	[-6442450944, -6442450942, 0],
	[-6442450944, -6442450943.674, 0],
	[-6442450944, -6442450944, -2147483648],
	[-6442450944, -6442450945, 0],
	[-6442450944, -6442450946.74, 0],
	[-6442450945, NaN, 2147483647],
	[-6442450945, +0, 2147483647],
	[-6442450945, -0, 2147483647],
	[-6442450945, Infinity, 2147483647],
	[-6442450945, -Infinity, 2147483647],
	[-6442450945, 1, -2],
	[-6442450945, 32.5, 2147483647],
	[-6442450945, 2147483648, 2147483647],
	[-6442450945, 3000000000, 2147483647],
	[-6442450945, 4000000000.23, 2147483647],
	[-6442450945, 5000000000, 2147483647],
	[-6442450945, 4294967296, 2147483647],
	[-6442450945, 4294967298.479, -4],
	[-6442450945, 6442450942, -1073741824],
	[-6442450945, 6442450943.674, -2147483648],
	[-6442450945, 6442450944, 2147483647],
	[-6442450945, 6442450945, -2],
	[-6442450945, 6442450946.74, -4],
	[-6442450945, -1, -2147483648],
	[-6442450945, -32.5, 2147483647],
	[-6442450945, -3000000000, 2147483647],
	[-6442450945, -4000000000.23, 2147483647],
	[-6442450945, -5000000000, 2147483647],
	[-6442450945, -4294967298.479, -1073741824],
	[-6442450945, -6442450942, -4],
	[-6442450945, -6442450943.674, -2],
	[-6442450945, -6442450944, 2147483647],
	[-6442450945, -6442450945, -2147483648],
	[-6442450945, -6442450946.74, -1073741824],
	[-6442450946.74, NaN, 2147483646],
	[-6442450946.74, +0, 2147483646],
	[-6442450946.74, -0, 2147483646],
	[-6442450946.74, Infinity, 2147483646],
	[-6442450946.74, -Infinity, 2147483646],
	[-6442450946.74, 1, -4],
	[-6442450946.74, 32.5, 2147483646],
	[-6442450946.74, 2147483648, 2147483646],
	[-6442450946.74, 3000000000, 2147483646],
	[-6442450946.74, 4000000000.23, 2147483646],
	[-6442450946.74, 5000000000, 2147483646],
	[-6442450946.74, 4294967296, 2147483646],
	[-6442450946.74, 4294967298.479, -8],
	[-6442450946.74, 6442450942, -2147483648],
	[-6442450946.74, 6442450943.674, 0],
	[-6442450946.74, 6442450944, 2147483646],
	[-6442450946.74, 6442450945, -4],
	[-6442450946.74, 6442450946.74, -8],
	[-6442450946.74, -1, 0],
	[-6442450946.74, -32.5, 2147483646],
	[-6442450946.74, -3000000000, 2147483646],
	[-6442450946.74, -4000000000.23, 2147483646],
	[-6442450946.74, -5000000000, 2147483646],
	[-6442450946.74, -4294967298.479, -2147483648],
	[-6442450946.74, -6442450942, -8],
	[-6442450946.74, -6442450943.674, -4],
	[-6442450946.74, -6442450944, 2147483646],
	[-6442450946.74, -6442450945, 0],
	[-6442450946.74, -6442450946.74, -2147483648],
];

for(var i in n2n) {
	item = n2n[i]
	ok(item[0] << item[1] === item[2], item[0] + ' << ' + item[1])
}

/* Test 893 */
expr = 1
is(expr << (expr = 2), 4, 'lvalue << expr modifying the lvalue');


// ===================================================
// 11.6.2 >>
// ===================================================

/* Tests 894-941: type conversion (48 tests) */

ok(void 0 >> void 0 === 0, "undefined >> undefined")
ok(void 0 >> null === 0, "undefined >> null")
ok(void 0 >> true === 0, "undefined >> boolean")
ok(void 0 >> "3" === 0, "undefined >> string")
ok(void 0 >> 73 === 0, "undefined >> number")
ok(void 0 >> {} === 0, "undefined >> object")
ok(void 0 >> new Number(34.2) === 0, "undefined >> number object")
ok(null >> void 0 === 0, "null >> undefined")
ok(null >> null === 0, "null >> null")
ok(null >> true === 0, "null >> boolean")
ok(null >> "3" === 0, "null >> string")
ok(null >> 73 === 0, "null >> number")
ok(null >> {} === 0, "null >> object")
ok(null >> new Number(34.2) === 0, "null >> number object")
ok(true >> void 0 === 1, "boolean >> undefined")
ok(true >> null === 1, "boolean >> null")
ok(true >> true === 0, "boolean >> boolean")
ok(true >> "3" === 0, "boolean >> string")
ok(true >> 73 === 0, "boolean >> number")
ok(true >> {} === 1, "boolean >> object")
ok(true >> new Number(34.2) === 0, "boolean >> number object")
ok("3" >> void 0 === 3, "string >> undefined")
ok("3" >> null === 3, "string >> null")
ok("3" >> true === 1, "string >> boolean")
ok("3" >> "3" === 0, "string >> string")
ok("3" >> 73 === 0, "string >> number")
ok("3" >> {} === 3, "string >> object")
ok("3" >> new Number(34.2) === 0, "string >> number object")
ok(73 >> void 0 === 73, "number >> undefined")
ok(73 >> null === 73, "number >> null")
ok(73 >> true === 36, "number >> boolean")
ok(73 >> "3" === 9, "number >> string")
ok(73 >> {} === 73, "number >> object")
ok(73 >> new Number(34.2) === 18, "number >> number object")
ok({} >> void 0 === 0, "object >> undefined")
ok({} >> null === 0, "object >> null")
ok({} >> true === 0, "object >> boolean")
ok({} >> "3" === 0, "object >> string")
ok({} >> 73 === 0, "object >> number")
ok({} >> {} === 0, "object >> object")
ok({} >> new Number(34.2) === 0, "object >> number object")
ok(new Number(34.2) >> void 0 === 34, "number object >> undefined")
ok(new Number(34.2) >> null === 34, "number object >> null")
ok(new Number(34.2) >> true === 17, "number object >> boolean")
ok(new Number(34.2) >> "3" === 4, "number object >> string")
ok(new Number(34.2) >> 73 === 0, "number object >> number")
ok(new Number(34.2) >> {} === 34, "number object >> object")
ok(new Number(34.2) >> new Number(34.2) === 8, "number object >> number object")

/* Tests 942-1782: numebr >> number */

n2n = [
	[NaN, NaN, 0],
	[NaN, +0, 0],
	[NaN, -0, 0],
	[NaN, Infinity, 0],
	[NaN, -Infinity, 0],
	[NaN, 1, 0],
	[NaN, 32.5, 0],
	[NaN, 2147483648, 0],
	[NaN, 3000000000, 0],
	[NaN, 4000000000.23, 0],
	[NaN, 5000000000, 0],
	[NaN, 4294967296, 0],
	[NaN, 4294967298.479, 0],
	[NaN, 6442450942, 0],
	[NaN, 6442450943.674, 0],
	[NaN, 6442450944, 0],
	[NaN, 6442450945, 0],
	[NaN, 6442450946.74, 0],
	[NaN, -1, 0],
	[NaN, -32.5, 0],
	[NaN, -3000000000, 0],
	[NaN, -4000000000.23, 0],
	[NaN, -5000000000, 0],
	[NaN, -4294967298.479, 0],
	[NaN, -6442450942, 0],
	[NaN, -6442450943.674, 0],
	[NaN, -6442450944, 0],
	[NaN, -6442450945, 0],
	[NaN, -6442450946.74, 0],
	[+0, NaN, 0],
	[+0, +0, 0],
	[+0, -0, 0],
	[+0, Infinity, 0],
	[+0, -Infinity, 0],
	[+0, 1, 0],
	[+0, 32.5, 0],
	[+0, 2147483648, 0],
	[+0, 3000000000, 0],
	[+0, 4000000000.23, 0],
	[+0, 5000000000, 0],
	[+0, 4294967296, 0],
	[+0, 4294967298.479, 0],
	[+0, 6442450942, 0],
	[+0, 6442450943.674, 0],
	[+0, 6442450944, 0],
	[+0, 6442450945, 0],
	[+0, 6442450946.74, 0],
	[+0, -1, 0],
	[+0, -32.5, 0],
	[+0, -3000000000, 0],
	[+0, -4000000000.23, 0],
	[+0, -5000000000, 0],
	[+0, -4294967298.479, 0],
	[+0, -6442450942, 0],
	[+0, -6442450943.674, 0],
	[+0, -6442450944, 0],
	[+0, -6442450945, 0],
	[+0, -6442450946.74, 0],
	[-0, NaN, 0],
	[-0, +0, 0],
	[-0, -0, 0],
	[-0, Infinity, 0],
	[-0, -Infinity, 0],
	[-0, 1, 0],
	[-0, 32.5, 0],
	[-0, 2147483648, 0],
	[-0, 3000000000, 0],
	[-0, 4000000000.23, 0],
	[-0, 5000000000, 0],
	[-0, 4294967296, 0],
	[-0, 4294967298.479, 0],
	[-0, 6442450942, 0],
	[-0, 6442450943.674, 0],
	[-0, 6442450944, 0],
	[-0, 6442450945, 0],
	[-0, 6442450946.74, 0],
	[-0, -1, 0],
	[-0, -32.5, 0],
	[-0, -3000000000, 0],
	[-0, -4000000000.23, 0],
	[-0, -5000000000, 0],
	[-0, -4294967298.479, 0],
	[-0, -6442450942, 0],
	[-0, -6442450943.674, 0],
	[-0, -6442450944, 0],
	[-0, -6442450945, 0],
	[-0, -6442450946.74, 0],
	[Infinity, NaN, 0],
	[Infinity, +0, 0],
	[Infinity, -0, 0],
	[Infinity, Infinity, 0],
	[Infinity, -Infinity, 0],
	[Infinity, 1, 0],
	[Infinity, 32.5, 0],
	[Infinity, 2147483648, 0],
	[Infinity, 3000000000, 0],
	[Infinity, 4000000000.23, 0],
	[Infinity, 5000000000, 0],
	[Infinity, 4294967296, 0],
	[Infinity, 4294967298.479, 0],
	[Infinity, 6442450942, 0],
	[Infinity, 6442450943.674, 0],
	[Infinity, 6442450944, 0],
	[Infinity, 6442450945, 0],
	[Infinity, 6442450946.74, 0],
	[Infinity, -1, 0],
	[Infinity, -32.5, 0],
	[Infinity, -3000000000, 0],
	[Infinity, -4000000000.23, 0],
	[Infinity, -5000000000, 0],
	[Infinity, -4294967298.479, 0],
	[Infinity, -6442450942, 0],
	[Infinity, -6442450943.674, 0],
	[Infinity, -6442450944, 0],
	[Infinity, -6442450945, 0],
	[Infinity, -6442450946.74, 0],
	[-Infinity, NaN, 0],
	[-Infinity, +0, 0],
	[-Infinity, -0, 0],
	[-Infinity, Infinity, 0],
	[-Infinity, -Infinity, 0],
	[-Infinity, 1, 0],
	[-Infinity, 32.5, 0],
	[-Infinity, 2147483648, 0],
	[-Infinity, 3000000000, 0],
	[-Infinity, 4000000000.23, 0],
	[-Infinity, 5000000000, 0],
	[-Infinity, 4294967296, 0],
	[-Infinity, 4294967298.479, 0],
	[-Infinity, 6442450942, 0],
	[-Infinity, 6442450943.674, 0],
	[-Infinity, 6442450944, 0],
	[-Infinity, 6442450945, 0],
	[-Infinity, 6442450946.74, 0],
	[-Infinity, -1, 0],
	[-Infinity, -32.5, 0],
	[-Infinity, -3000000000, 0],
	[-Infinity, -4000000000.23, 0],
	[-Infinity, -5000000000, 0],
	[-Infinity, -4294967298.479, 0],
	[-Infinity, -6442450942, 0],
	[-Infinity, -6442450943.674, 0],
	[-Infinity, -6442450944, 0],
	[-Infinity, -6442450945, 0],
	[-Infinity, -6442450946.74, 0],
	[1, NaN, 1],
	[1, +0, 1],
	[1, -0, 1],
	[1, Infinity, 1],
	[1, -Infinity, 1],
	[1, 1, 0],
	[1, 32.5, 1],
	[1, 2147483648, 1],
	[1, 3000000000, 1],
	[1, 4000000000.23, 1],
	[1, 5000000000, 1],
	[1, 4294967296, 1],
	[1, 4294967298.479, 0],
	[1, 6442450942, 0],
	[1, 6442450943.674, 0],
	[1, 6442450944, 1],
	[1, 6442450945, 0],
	[1, 6442450946.74, 0],
	[1, -1, 0],
	[1, -32.5, 1],
	[1, -3000000000, 1],
	[1, -4000000000.23, 1],
	[1, -5000000000, 1],
	[1, -4294967298.479, 0],
	[1, -6442450942, 0],
	[1, -6442450943.674, 0],
	[1, -6442450944, 1],
	[1, -6442450945, 0],
	[1, -6442450946.74, 0],
	[32.5, NaN, 32],
	[32.5, +0, 32],
	[32.5, -0, 32],
	[32.5, Infinity, 32],
	[32.5, -Infinity, 32],
	[32.5, 1, 16],
	[32.5, 32.5, 32],
	[32.5, 2147483648, 32],
	[32.5, 3000000000, 32],
	[32.5, 4000000000.23, 32],
	[32.5, 5000000000, 32],
	[32.5, 4294967296, 32],
	[32.5, 4294967298.479, 8],
	[32.5, 6442450942, 0],
	[32.5, 6442450943.674, 0],
	[32.5, 6442450944, 32],
	[32.5, 6442450945, 16],
	[32.5, 6442450946.74, 8],
	[32.5, -1, 0],
	[32.5, -32.5, 32],
	[32.5, -3000000000, 32],
	[32.5, -4000000000.23, 32],
	[32.5, -5000000000, 32],
	[32.5, -4294967298.479, 0],
	[32.5, -6442450942, 8],
	[32.5, -6442450943.674, 16],
	[32.5, -6442450944, 32],
	[32.5, -6442450945, 0],
	[32.5, -6442450946.74, 0],
	[2147483648, NaN, -2147483648],
	[2147483648, +0, -2147483648],
	[2147483648, -0, -2147483648],
	[2147483648, Infinity, -2147483648],
	[2147483648, -Infinity, -2147483648],
	[2147483648, 1, -1073741824],
	[2147483648, 32.5, -2147483648],
	[2147483648, 2147483648, -2147483648],
	[2147483648, 3000000000, -2147483648],
	[2147483648, 4000000000.23, -2147483648],
	[2147483648, 5000000000, -2147483648],
	[2147483648, 4294967296, -2147483648],
	[2147483648, 4294967298.479, -536870912],
	[2147483648, 6442450942, -2],
	[2147483648, 6442450943.674, -1],
	[2147483648, 6442450944, -2147483648],
	[2147483648, 6442450945, -1073741824],
	[2147483648, 6442450946.74, -536870912],
	[2147483648, -1, -1],
	[2147483648, -32.5, -2147483648],
	[2147483648, -3000000000, -2147483648],
	[2147483648, -4000000000.23, -2147483648],
	[2147483648, -5000000000, -2147483648],
	[2147483648, -4294967298.479, -2],
	[2147483648, -6442450942, -536870912],
	[2147483648, -6442450943.674, -1073741824],
	[2147483648, -6442450944, -2147483648],
	[2147483648, -6442450945, -1],
	[2147483648, -6442450946.74, -2],
	[3000000000, NaN, -1294967296],
	[3000000000, +0, -1294967296],
	[3000000000, -0, -1294967296],
	[3000000000, Infinity, -1294967296],
	[3000000000, -Infinity, -1294967296],
	[3000000000, 1, -647483648],
	[3000000000, 32.5, -1294967296],
	[3000000000, 2147483648, -1294967296],
	[3000000000, 3000000000, -1294967296],
	[3000000000, 4000000000.23, -1294967296],
	[3000000000, 5000000000, -1294967296],
	[3000000000, 4294967296, -1294967296],
	[3000000000, 4294967298.479, -323741824],
	[3000000000, 6442450942, -2],
	[3000000000, 6442450943.674, -1],
	[3000000000, 6442450944, -1294967296],
	[3000000000, 6442450945, -647483648],
	[3000000000, 6442450946.74, -323741824],
	[3000000000, -1, -1],
	[3000000000, -32.5, -1294967296],
	[3000000000, -3000000000, -1294967296],
	[3000000000, -4000000000.23, -1294967296],
	[3000000000, -5000000000, -1294967296],
	[3000000000, -4294967298.479, -2],
	[3000000000, -6442450942, -323741824],
	[3000000000, -6442450943.674, -647483648],
	[3000000000, -6442450944, -1294967296],
	[3000000000, -6442450945, -1],
	[3000000000, -6442450946.74, -2],
	[4000000000.23, NaN, -294967296],
	[4000000000.23, +0, -294967296],
	[4000000000.23, -0, -294967296],
	[4000000000.23, Infinity, -294967296],
	[4000000000.23, -Infinity, -294967296],
	[4000000000.23, 1, -147483648],
	[4000000000.23, 32.5, -294967296],
	[4000000000.23, 2147483648, -294967296],
	[4000000000.23, 3000000000, -294967296],
	[4000000000.23, 4000000000.23, -294967296],
	[4000000000.23, 5000000000, -294967296],
	[4000000000.23, 4294967296, -294967296],
	[4000000000.23, 4294967298.479, -73741824],
	[4000000000.23, 6442450942, -1],
	[4000000000.23, 6442450943.674, -1],
	[4000000000.23, 6442450944, -294967296],
	[4000000000.23, 6442450945, -147483648],
	[4000000000.23, 6442450946.74, -73741824],
	[4000000000.23, -1, -1],
	[4000000000.23, -32.5, -294967296],
	[4000000000.23, -3000000000, -294967296],
	[4000000000.23, -4000000000.23, -294967296],
	[4000000000.23, -5000000000, -294967296],
	[4000000000.23, -4294967298.479, -1],
	[4000000000.23, -6442450942, -73741824],
	[4000000000.23, -6442450943.674, -147483648],
	[4000000000.23, -6442450944, -294967296],
	[4000000000.23, -6442450945, -1],
	[4000000000.23, -6442450946.74, -1],
	[5000000000, NaN, 705032704],
	[5000000000, +0, 705032704],
	[5000000000, -0, 705032704],
	[5000000000, Infinity, 705032704],
	[5000000000, -Infinity, 705032704],
	[5000000000, 1, 352516352],
	[5000000000, 32.5, 705032704],
	[5000000000, 2147483648, 705032704],
	[5000000000, 3000000000, 705032704],
	[5000000000, 4000000000.23, 705032704],
	[5000000000, 5000000000, 705032704],
	[5000000000, 4294967296, 705032704],
	[5000000000, 4294967298.479, 176258176],
	[5000000000, 6442450942, 0],
	[5000000000, 6442450943.674, 0],
	[5000000000, 6442450944, 705032704],
	[5000000000, 6442450945, 352516352],
	[5000000000, 6442450946.74, 176258176],
	[5000000000, -1, 0],
	[5000000000, -32.5, 705032704],
	[5000000000, -3000000000, 705032704],
	[5000000000, -4000000000.23, 705032704],
	[5000000000, -5000000000, 705032704],
	[5000000000, -4294967298.479, 0],
	[5000000000, -6442450942, 176258176],
	[5000000000, -6442450943.674, 352516352],
	[5000000000, -6442450944, 705032704],
	[5000000000, -6442450945, 0],
	[5000000000, -6442450946.74, 0],
	[4294967296, NaN, 0],
	[4294967296, +0, 0],
	[4294967296, -0, 0],
	[4294967296, Infinity, 0],
	[4294967296, -Infinity, 0],
	[4294967296, 1, 0],
	[4294967296, 32.5, 0],
	[4294967296, 2147483648, 0],
	[4294967296, 3000000000, 0],
	[4294967296, 4000000000.23, 0],
	[4294967296, 5000000000, 0],
	[4294967296, 4294967296, 0],
	[4294967296, 4294967298.479, 0],
	[4294967296, 6442450942, 0],
	[4294967296, 6442450943.674, 0],
	[4294967296, 6442450944, 0],
	[4294967296, 6442450945, 0],
	[4294967296, 6442450946.74, 0],
	[4294967296, -1, 0],
	[4294967296, -32.5, 0],
	[4294967296, -3000000000, 0],
	[4294967296, -4000000000.23, 0],
	[4294967296, -5000000000, 0],
	[4294967296, -4294967298.479, 0],
	[4294967296, -6442450942, 0],
	[4294967296, -6442450943.674, 0],
	[4294967296, -6442450944, 0],
	[4294967296, -6442450945, 0],
	[4294967296, -6442450946.74, 0],
	[4294967298.479, NaN, 2],
	[4294967298.479, +0, 2],
	[4294967298.479, -0, 2],
	[4294967298.479, Infinity, 2],
	[4294967298.479, -Infinity, 2],
	[4294967298.479, 1, 1],
	[4294967298.479, 32.5, 2],
	[4294967298.479, 2147483648, 2],
	[4294967298.479, 3000000000, 2],
	[4294967298.479, 4000000000.23, 2],
	[4294967298.479, 5000000000, 2],
	[4294967298.479, 4294967296, 2],
	[4294967298.479, 4294967298.479, 0],
	[4294967298.479, 6442450942, 0],
	[4294967298.479, 6442450943.674, 0],
	[4294967298.479, 6442450944, 2],
	[4294967298.479, 6442450945, 1],
	[4294967298.479, 6442450946.74, 0],
	[4294967298.479, -1, 0],
	[4294967298.479, -32.5, 2],
	[4294967298.479, -3000000000, 2],
	[4294967298.479, -4000000000.23, 2],
	[4294967298.479, -5000000000, 2],
	[4294967298.479, -4294967298.479, 0],
	[4294967298.479, -6442450942, 0],
	[4294967298.479, -6442450943.674, 1],
	[4294967298.479, -6442450944, 2],
	[4294967298.479, -6442450945, 0],
	[4294967298.479, -6442450946.74, 0],
	[6442450942, NaN, 2147483646],
	[6442450942, +0, 2147483646],
	[6442450942, -0, 2147483646],
	[6442450942, Infinity, 2147483646],
	[6442450942, -Infinity, 2147483646],
	[6442450942, 1, 1073741823],
	[6442450942, 32.5, 2147483646],
	[6442450942, 2147483648, 2147483646],
	[6442450942, 3000000000, 2147483646],
	[6442450942, 4000000000.23, 2147483646],
	[6442450942, 5000000000, 2147483646],
	[6442450942, 4294967296, 2147483646],
	[6442450942, 4294967298.479, 536870911],
	[6442450942, 6442450942, 1],
	[6442450942, 6442450943.674, 0],
	[6442450942, 6442450944, 2147483646],
	[6442450942, 6442450945, 1073741823],
	[6442450942, 6442450946.74, 536870911],
	[6442450942, -1, 0],
	[6442450942, -32.5, 2147483646],
	[6442450942, -3000000000, 2147483646],
	[6442450942, -4000000000.23, 2147483646],
	[6442450942, -5000000000, 2147483646],
	[6442450942, -4294967298.479, 1],
	[6442450942, -6442450942, 536870911],
	[6442450942, -6442450943.674, 1073741823],
	[6442450942, -6442450944, 2147483646],
	[6442450942, -6442450945, 0],
	[6442450942, -6442450946.74, 1],
	[6442450943.674, NaN, 2147483647],
	[6442450943.674, +0, 2147483647],
	[6442450943.674, -0, 2147483647],
	[6442450943.674, Infinity, 2147483647],
	[6442450943.674, -Infinity, 2147483647],
	[6442450943.674, 1, 1073741823],
	[6442450943.674, 32.5, 2147483647],
	[6442450943.674, 2147483648, 2147483647],
	[6442450943.674, 3000000000, 2147483647],
	[6442450943.674, 4000000000.23, 2147483647],
	[6442450943.674, 5000000000, 2147483647],
	[6442450943.674, 4294967296, 2147483647],
	[6442450943.674, 4294967298.479, 536870911],
	[6442450943.674, 6442450942, 1],
	[6442450943.674, 6442450943.674, 0],
	[6442450943.674, 6442450944, 2147483647],
	[6442450943.674, 6442450945, 1073741823],
	[6442450943.674, 6442450946.74, 536870911],
	[6442450943.674, -1, 0],
	[6442450943.674, -32.5, 2147483647],
	[6442450943.674, -3000000000, 2147483647],
	[6442450943.674, -4000000000.23, 2147483647],
	[6442450943.674, -5000000000, 2147483647],
	[6442450943.674, -4294967298.479, 1],
	[6442450943.674, -6442450942, 536870911],
	[6442450943.674, -6442450943.674, 1073741823],
	[6442450943.674, -6442450944, 2147483647],
	[6442450943.674, -6442450945, 0],
	[6442450943.674, -6442450946.74, 1],
	[6442450944, NaN, -2147483648],
	[6442450944, +0, -2147483648],
	[6442450944, -0, -2147483648],
	[6442450944, Infinity, -2147483648],
	[6442450944, -Infinity, -2147483648],
	[6442450944, 1, -1073741824],
	[6442450944, 32.5, -2147483648],
	[6442450944, 2147483648, -2147483648],
	[6442450944, 3000000000, -2147483648],
	[6442450944, 4000000000.23, -2147483648],
	[6442450944, 5000000000, -2147483648],
	[6442450944, 4294967296, -2147483648],
	[6442450944, 4294967298.479, -536870912],
	[6442450944, 6442450942, -2],
	[6442450944, 6442450943.674, -1],
	[6442450944, 6442450944, -2147483648],
	[6442450944, 6442450945, -1073741824],
	[6442450944, 6442450946.74, -536870912],
	[6442450944, -1, -1],
	[6442450944, -32.5, -2147483648],
	[6442450944, -3000000000, -2147483648],
	[6442450944, -4000000000.23, -2147483648],
	[6442450944, -5000000000, -2147483648],
	[6442450944, -4294967298.479, -2],
	[6442450944, -6442450942, -536870912],
	[6442450944, -6442450943.674, -1073741824],
	[6442450944, -6442450944, -2147483648],
	[6442450944, -6442450945, -1],
	[6442450944, -6442450946.74, -2],
	[6442450945, NaN, -2147483647],
	[6442450945, +0, -2147483647],
	[6442450945, -0, -2147483647],
	[6442450945, Infinity, -2147483647],
	[6442450945, -Infinity, -2147483647],
	[6442450945, 1, -1073741824],
	[6442450945, 32.5, -2147483647],
	[6442450945, 2147483648, -2147483647],
	[6442450945, 3000000000, -2147483647],
	[6442450945, 4000000000.23, -2147483647],
	[6442450945, 5000000000, -2147483647],
	[6442450945, 4294967296, -2147483647],
	[6442450945, 4294967298.479, -536870912],
	[6442450945, 6442450942, -2],
	[6442450945, 6442450943.674, -1],
	[6442450945, 6442450944, -2147483647],
	[6442450945, 6442450945, -1073741824],
	[6442450945, 6442450946.74, -536870912],
	[6442450945, -1, -1],
	[6442450945, -32.5, -2147483647],
	[6442450945, -3000000000, -2147483647],
	[6442450945, -4000000000.23, -2147483647],
	[6442450945, -5000000000, -2147483647],
	[6442450945, -4294967298.479, -2],
	[6442450945, -6442450942, -536870912],
	[6442450945, -6442450943.674, -1073741824],
	[6442450945, -6442450944, -2147483647],
	[6442450945, -6442450945, -1],
	[6442450945, -6442450946.74, -2],
	[6442450946.74, NaN, -2147483646],
	[6442450946.74, +0, -2147483646],
	[6442450946.74, -0, -2147483646],
	[6442450946.74, Infinity, -2147483646],
	[6442450946.74, -Infinity, -2147483646],
	[6442450946.74, 1, -1073741823],
	[6442450946.74, 32.5, -2147483646],
	[6442450946.74, 2147483648, -2147483646],
	[6442450946.74, 3000000000, -2147483646],
	[6442450946.74, 4000000000.23, -2147483646],
	[6442450946.74, 5000000000, -2147483646],
	[6442450946.74, 4294967296, -2147483646],
	[6442450946.74, 4294967298.479, -536870912],
	[6442450946.74, 6442450942, -2],
	[6442450946.74, 6442450943.674, -1],
	[6442450946.74, 6442450944, -2147483646],
	[6442450946.74, 6442450945, -1073741823],
	[6442450946.74, 6442450946.74, -536870912],
	[6442450946.74, -1, -1],
	[6442450946.74, -32.5, -2147483646],
	[6442450946.74, -3000000000, -2147483646],
	[6442450946.74, -4000000000.23, -2147483646],
	[6442450946.74, -5000000000, -2147483646],
	[6442450946.74, -4294967298.479, -2],
	[6442450946.74, -6442450942, -536870912],
	[6442450946.74, -6442450943.674, -1073741823],
	[6442450946.74, -6442450944, -2147483646],
	[6442450946.74, -6442450945, -1],
	[6442450946.74, -6442450946.74, -2],
	[-1, NaN, -1],
	[-1, +0, -1],
	[-1, -0, -1],
	[-1, Infinity, -1],
	[-1, -Infinity, -1],
	[-1, 1, -1],
	[-1, 32.5, -1],
	[-1, 2147483648, -1],
	[-1, 3000000000, -1],
	[-1, 4000000000.23, -1],
	[-1, 5000000000, -1],
	[-1, 4294967296, -1],
	[-1, 4294967298.479, -1],
	[-1, 6442450942, -1],
	[-1, 6442450943.674, -1],
	[-1, 6442450944, -1],
	[-1, 6442450945, -1],
	[-1, 6442450946.74, -1],
	[-1, -1, -1],
	[-1, -32.5, -1],
	[-1, -3000000000, -1],
	[-1, -4000000000.23, -1],
	[-1, -5000000000, -1],
	[-1, -4294967298.479, -1],
	[-1, -6442450942, -1],
	[-1, -6442450943.674, -1],
	[-1, -6442450944, -1],
	[-1, -6442450945, -1],
	[-1, -6442450946.74, -1],
	[-32.5, NaN, -32],
	[-32.5, +0, -32],
	[-32.5, -0, -32],
	[-32.5, Infinity, -32],
	[-32.5, -Infinity, -32],
	[-32.5, 1, -16],
	[-32.5, 32.5, -32],
	[-32.5, 2147483648, -32],
	[-32.5, 3000000000, -32],
	[-32.5, 4000000000.23, -32],
	[-32.5, 5000000000, -32],
	[-32.5, 4294967296, -32],
	[-32.5, 4294967298.479, -8],
	[-32.5, 6442450942, -1],
	[-32.5, 6442450943.674, -1],
	[-32.5, 6442450944, -32],
	[-32.5, 6442450945, -16],
	[-32.5, 6442450946.74, -8],
	[-32.5, -1, -1],
	[-32.5, -32.5, -32],
	[-32.5, -3000000000, -32],
	[-32.5, -4000000000.23, -32],
	[-32.5, -5000000000, -32],
	[-32.5, -4294967298.479, -1],
	[-32.5, -6442450942, -8],
	[-32.5, -6442450943.674, -16],
	[-32.5, -6442450944, -32],
	[-32.5, -6442450945, -1],
	[-32.5, -6442450946.74, -1],
	[-3000000000, NaN, 1294967296],
	[-3000000000, +0, 1294967296],
	[-3000000000, -0, 1294967296],
	[-3000000000, Infinity, 1294967296],
	[-3000000000, -Infinity, 1294967296],
	[-3000000000, 1, 647483648],
	[-3000000000, 32.5, 1294967296],
	[-3000000000, 2147483648, 1294967296],
	[-3000000000, 3000000000, 1294967296],
	[-3000000000, 4000000000.23, 1294967296],
	[-3000000000, 5000000000, 1294967296],
	[-3000000000, 4294967296, 1294967296],
	[-3000000000, 4294967298.479, 323741824],
	[-3000000000, 6442450942, 1],
	[-3000000000, 6442450943.674, 0],
	[-3000000000, 6442450944, 1294967296],
	[-3000000000, 6442450945, 647483648],
	[-3000000000, 6442450946.74, 323741824],
	[-3000000000, -1, 0],
	[-3000000000, -32.5, 1294967296],
	[-3000000000, -3000000000, 1294967296],
	[-3000000000, -4000000000.23, 1294967296],
	[-3000000000, -5000000000, 1294967296],
	[-3000000000, -4294967298.479, 1],
	[-3000000000, -6442450942, 323741824],
	[-3000000000, -6442450943.674, 647483648],
	[-3000000000, -6442450944, 1294967296],
	[-3000000000, -6442450945, 0],
	[-3000000000, -6442450946.74, 1],
	[-4000000000.23, NaN, 294967296],
	[-4000000000.23, +0, 294967296],
	[-4000000000.23, -0, 294967296],
	[-4000000000.23, Infinity, 294967296],
	[-4000000000.23, -Infinity, 294967296],
	[-4000000000.23, 1, 147483648],
	[-4000000000.23, 32.5, 294967296],
	[-4000000000.23, 2147483648, 294967296],
	[-4000000000.23, 3000000000, 294967296],
	[-4000000000.23, 4000000000.23, 294967296],
	[-4000000000.23, 5000000000, 294967296],
	[-4000000000.23, 4294967296, 294967296],
	[-4000000000.23, 4294967298.479, 73741824],
	[-4000000000.23, 6442450942, 0],
	[-4000000000.23, 6442450943.674, 0],
	[-4000000000.23, 6442450944, 294967296],
	[-4000000000.23, 6442450945, 147483648],
	[-4000000000.23, 6442450946.74, 73741824],
	[-4000000000.23, -1, 0],
	[-4000000000.23, -32.5, 294967296],
	[-4000000000.23, -3000000000, 294967296],
	[-4000000000.23, -4000000000.23, 294967296],
	[-4000000000.23, -5000000000, 294967296],
	[-4000000000.23, -4294967298.479, 0],
	[-4000000000.23, -6442450942, 73741824],
	[-4000000000.23, -6442450943.674, 147483648],
	[-4000000000.23, -6442450944, 294967296],
	[-4000000000.23, -6442450945, 0],
	[-4000000000.23, -6442450946.74, 0],
	[-5000000000, NaN, -705032704],
	[-5000000000, +0, -705032704],
	[-5000000000, -0, -705032704],
	[-5000000000, Infinity, -705032704],
	[-5000000000, -Infinity, -705032704],
	[-5000000000, 1, -352516352],
	[-5000000000, 32.5, -705032704],
	[-5000000000, 2147483648, -705032704],
	[-5000000000, 3000000000, -705032704],
	[-5000000000, 4000000000.23, -705032704],
	[-5000000000, 5000000000, -705032704],
	[-5000000000, 4294967296, -705032704],
	[-5000000000, 4294967298.479, -176258176],
	[-5000000000, 6442450942, -1],
	[-5000000000, 6442450943.674, -1],
	[-5000000000, 6442450944, -705032704],
	[-5000000000, 6442450945, -352516352],
	[-5000000000, 6442450946.74, -176258176],
	[-5000000000, -1, -1],
	[-5000000000, -32.5, -705032704],
	[-5000000000, -3000000000, -705032704],
	[-5000000000, -4000000000.23, -705032704],
	[-5000000000, -5000000000, -705032704],
	[-5000000000, -4294967298.479, -1],
	[-5000000000, -6442450942, -176258176],
	[-5000000000, -6442450943.674, -352516352],
	[-5000000000, -6442450944, -705032704],
	[-5000000000, -6442450945, -1],
	[-5000000000, -6442450946.74, -1],
	[-4294967298.479, NaN, -2],
	[-4294967298.479, +0, -2],
	[-4294967298.479, -0, -2],
	[-4294967298.479, Infinity, -2],
	[-4294967298.479, -Infinity, -2],
	[-4294967298.479, 1, -1],
	[-4294967298.479, 32.5, -2],
	[-4294967298.479, 2147483648, -2],
	[-4294967298.479, 3000000000, -2],
	[-4294967298.479, 4000000000.23, -2],
	[-4294967298.479, 5000000000, -2],
	[-4294967298.479, 4294967296, -2],
	[-4294967298.479, 4294967298.479, -1],
	[-4294967298.479, 6442450942, -1],
	[-4294967298.479, 6442450943.674, -1],
	[-4294967298.479, 6442450944, -2],
	[-4294967298.479, 6442450945, -1],
	[-4294967298.479, 6442450946.74, -1],
	[-4294967298.479, -1, -1],
	[-4294967298.479, -32.5, -2],
	[-4294967298.479, -3000000000, -2],
	[-4294967298.479, -4000000000.23, -2],
	[-4294967298.479, -5000000000, -2],
	[-4294967298.479, -4294967298.479, -1],
	[-4294967298.479, -6442450942, -1],
	[-4294967298.479, -6442450943.674, -1],
	[-4294967298.479, -6442450944, -2],
	[-4294967298.479, -6442450945, -1],
	[-4294967298.479, -6442450946.74, -1],
	[-6442450942, NaN, -2147483646],
	[-6442450942, +0, -2147483646],
	[-6442450942, -0, -2147483646],
	[-6442450942, Infinity, -2147483646],
	[-6442450942, -Infinity, -2147483646],
	[-6442450942, 1, -1073741823],
	[-6442450942, 32.5, -2147483646],
	[-6442450942, 2147483648, -2147483646],
	[-6442450942, 3000000000, -2147483646],
	[-6442450942, 4000000000.23, -2147483646],
	[-6442450942, 5000000000, -2147483646],
	[-6442450942, 4294967296, -2147483646],
	[-6442450942, 4294967298.479, -536870912],
	[-6442450942, 6442450942, -2],
	[-6442450942, 6442450943.674, -1],
	[-6442450942, 6442450944, -2147483646],
	[-6442450942, 6442450945, -1073741823],
	[-6442450942, 6442450946.74, -536870912],
	[-6442450942, -1, -1],
	[-6442450942, -32.5, -2147483646],
	[-6442450942, -3000000000, -2147483646],
	[-6442450942, -4000000000.23, -2147483646],
	[-6442450942, -5000000000, -2147483646],
	[-6442450942, -4294967298.479, -2],
	[-6442450942, -6442450942, -536870912],
	[-6442450942, -6442450943.674, -1073741823],
	[-6442450942, -6442450944, -2147483646],
	[-6442450942, -6442450945, -1],
	[-6442450942, -6442450946.74, -2],
	[-6442450943.674, NaN, -2147483647],
	[-6442450943.674, +0, -2147483647],
	[-6442450943.674, -0, -2147483647],
	[-6442450943.674, Infinity, -2147483647],
	[-6442450943.674, -Infinity, -2147483647],
	[-6442450943.674, 1, -1073741824],
	[-6442450943.674, 32.5, -2147483647],
	[-6442450943.674, 2147483648, -2147483647],
	[-6442450943.674, 3000000000, -2147483647],
	[-6442450943.674, 4000000000.23, -2147483647],
	[-6442450943.674, 5000000000, -2147483647],
	[-6442450943.674, 4294967296, -2147483647],
	[-6442450943.674, 4294967298.479, -536870912],
	[-6442450943.674, 6442450942, -2],
	[-6442450943.674, 6442450943.674, -1],
	[-6442450943.674, 6442450944, -2147483647],
	[-6442450943.674, 6442450945, -1073741824],
	[-6442450943.674, 6442450946.74, -536870912],
	[-6442450943.674, -1, -1],
	[-6442450943.674, -32.5, -2147483647],
	[-6442450943.674, -3000000000, -2147483647],
	[-6442450943.674, -4000000000.23, -2147483647],
	[-6442450943.674, -5000000000, -2147483647],
	[-6442450943.674, -4294967298.479, -2],
	[-6442450943.674, -6442450942, -536870912],
	[-6442450943.674, -6442450943.674, -1073741824],
	[-6442450943.674, -6442450944, -2147483647],
	[-6442450943.674, -6442450945, -1],
	[-6442450943.674, -6442450946.74, -2],
	[-6442450944, NaN, -2147483648],
	[-6442450944, +0, -2147483648],
	[-6442450944, -0, -2147483648],
	[-6442450944, Infinity, -2147483648],
	[-6442450944, -Infinity, -2147483648],
	[-6442450944, 1, -1073741824],
	[-6442450944, 32.5, -2147483648],
	[-6442450944, 2147483648, -2147483648],
	[-6442450944, 3000000000, -2147483648],
	[-6442450944, 4000000000.23, -2147483648],
	[-6442450944, 5000000000, -2147483648],
	[-6442450944, 4294967296, -2147483648],
	[-6442450944, 4294967298.479, -536870912],
	[-6442450944, 6442450942, -2],
	[-6442450944, 6442450943.674, -1],
	[-6442450944, 6442450944, -2147483648],
	[-6442450944, 6442450945, -1073741824],
	[-6442450944, 6442450946.74, -536870912],
	[-6442450944, -1, -1],
	[-6442450944, -32.5, -2147483648],
	[-6442450944, -3000000000, -2147483648],
	[-6442450944, -4000000000.23, -2147483648],
	[-6442450944, -5000000000, -2147483648],
	[-6442450944, -4294967298.479, -2],
	[-6442450944, -6442450942, -536870912],
	[-6442450944, -6442450943.674, -1073741824],
	[-6442450944, -6442450944, -2147483648],
	[-6442450944, -6442450945, -1],
	[-6442450944, -6442450946.74, -2],
	[-6442450945, NaN, 2147483647],
	[-6442450945, +0, 2147483647],
	[-6442450945, -0, 2147483647],
	[-6442450945, Infinity, 2147483647],
	[-6442450945, -Infinity, 2147483647],
	[-6442450945, 1, 1073741823],
	[-6442450945, 32.5, 2147483647],
	[-6442450945, 2147483648, 2147483647],
	[-6442450945, 3000000000, 2147483647],
	[-6442450945, 4000000000.23, 2147483647],
	[-6442450945, 5000000000, 2147483647],
	[-6442450945, 4294967296, 2147483647],
	[-6442450945, 4294967298.479, 536870911],
	[-6442450945, 6442450942, 1],
	[-6442450945, 6442450943.674, 0],
	[-6442450945, 6442450944, 2147483647],
	[-6442450945, 6442450945, 1073741823],
	[-6442450945, 6442450946.74, 536870911],
	[-6442450945, -1, 0],
	[-6442450945, -32.5, 2147483647],
	[-6442450945, -3000000000, 2147483647],
	[-6442450945, -4000000000.23, 2147483647],
	[-6442450945, -5000000000, 2147483647],
	[-6442450945, -4294967298.479, 1],
	[-6442450945, -6442450942, 536870911],
	[-6442450945, -6442450943.674, 1073741823],
	[-6442450945, -6442450944, 2147483647],
	[-6442450945, -6442450945, 0],
	[-6442450945, -6442450946.74, 1],
	[-6442450946.74, NaN, 2147483646],
	[-6442450946.74, +0, 2147483646],
	[-6442450946.74, -0, 2147483646],
	[-6442450946.74, Infinity, 2147483646],
	[-6442450946.74, -Infinity, 2147483646],
	[-6442450946.74, 1, 1073741823],
	[-6442450946.74, 32.5, 2147483646],
	[-6442450946.74, 2147483648, 2147483646],
	[-6442450946.74, 3000000000, 2147483646],
	[-6442450946.74, 4000000000.23, 2147483646],
	[-6442450946.74, 5000000000, 2147483646],
	[-6442450946.74, 4294967296, 2147483646],
	[-6442450946.74, 4294967298.479, 536870911],
	[-6442450946.74, 6442450942, 1],
	[-6442450946.74, 6442450943.674, 0],
	[-6442450946.74, 6442450944, 2147483646],
	[-6442450946.74, 6442450945, 1073741823],
	[-6442450946.74, 6442450946.74, 536870911],
	[-6442450946.74, -1, 0],
	[-6442450946.74, -32.5, 2147483646],
	[-6442450946.74, -3000000000, 2147483646],
	[-6442450946.74, -4000000000.23, 2147483646],
	[-6442450946.74, -5000000000, 2147483646],
	[-6442450946.74, -4294967298.479, 1],
	[-6442450946.74, -6442450942, 536870911],
	[-6442450946.74, -6442450943.674, 1073741823],
	[-6442450946.74, -6442450944, 2147483646],
	[-6442450946.74, -6442450945, 0],
	[-6442450946.74, -6442450946.74, 1],
];

for(var i in n2n) {
	item = n2n[i]
	ok(item[0] >> item[1] === item[2], item[0] + ' >> ' + item[1])
}


/* Test 1783 */
expr = 4
is(expr >> (expr = 2), 1, 'lvalue >> expr modifying the lvalue');


// ===================================================
// 11.6.2 >>>
// ===================================================

/* Tests 1784-1831: type conversion (48 tests) */

ok(void 0 >>> void 0 === 0, "undefined >>> undefined")
ok(void 0 >>> null === 0, "undefined >>> null")
ok(void 0 >>> true === 0, "undefined >>> boolean")
ok(void 0 >>> "3" === 0, "undefined >>> string")
ok(void 0 >>> 73 === 0, "undefined >>> number")
ok(void 0 >>> {} === 0, "undefined >>> object")
ok(void 0 >>> new Number(34.2) === 0, "undefined >>> number object")
ok(null >>> void 0 === 0, "null >>> undefined")
ok(null >>> null === 0, "null >>> null")
ok(null >>> true === 0, "null >>> boolean")
ok(null >>> "3" === 0, "null >>> string")
ok(null >>> 73 === 0, "null >>> number")
ok(null >>> {} === 0, "null >>> object")
ok(null >>> new Number(34.2) === 0, "null >>> number object")
ok(true >>> void 0 === 1, "boolean >>> undefined")
ok(true >>> null === 1, "boolean >>> null")
ok(true >>> true === 0, "boolean >>> boolean")
ok(true >>> "3" === 0, "boolean >>> string")
ok(true >>> 73 === 0, "boolean >>> number")
ok(true >>> {} === 1, "boolean >>> object")
ok(true >>> new Number(34.2) === 0, "boolean >>> number object")
ok("3" >>> void 0 === 3, "string >>> undefined")
ok("3" >>> null === 3, "string >>> null")
ok("3" >>> true === 1, "string >>> boolean")
ok("3" >>> "3" === 0, "string >>> string")
ok("3" >>> 73 === 0, "string >>> number")
ok("3" >>> {} === 3, "string >>> object")
ok("3" >>> new Number(34.2) === 0, "string >>> number object")
ok(73 >>> void 0 === 73, "number >>> undefined")
ok(73 >>> null === 73, "number >>> null")
ok(73 >>> true === 36, "number >>> boolean")
ok(73 >>> "3" === 9, "number >>> string")
ok(73 >>> {} === 73, "number >>> object")
ok(73 >>> new Number(34.2) === 18, "number >>> number object")
ok({} >>> void 0 === 0, "object >>> undefined")
ok({} >>> null === 0, "object >>> null")
ok({} >>> true === 0, "object >>> boolean")
ok({} >>> "3" === 0, "object >>> string")
ok({} >>> 73 === 0, "object >>> number")
ok({} >>> {} === 0, "object >>> object")
ok({} >>> new Number(34.2) === 0, "object >>> number object")
ok(new Number(34.2) >>> void 0 === 34, "number object >>> undefined")
ok(new Number(34.2) >>> null === 34, "number object >>> null")
ok(new Number(34.2) >>> true === 17, "number object >>> boolean")
ok(new Number(34.2) >>> "3" === 4, "number object >>> string")
ok(new Number(34.2) >>> 73 === 0, "number object >>> number")
ok(new Number(34.2) >>> {} === 34, "number object >>> object")
ok(new Number(34.2) >>> new Number(34.2) === 8, "number object >>> number object")

/* Tests 1332-2672 */

n2n = [
	[NaN, NaN, 0],
	[NaN, +0, 0],
	[NaN, -0, 0],
	[NaN, Infinity, 0],
	[NaN, -Infinity, 0],
	[NaN, 1, 0],
	[NaN, 32.5, 0],
	[NaN, 2147483648, 0],
	[NaN, 3000000000, 0],
	[NaN, 4000000000.23, 0],
	[NaN, 5000000000, 0],
	[NaN, 4294967296, 0],
	[NaN, 4294967298.479, 0],
	[NaN, 6442450942, 0],
	[NaN, 6442450943.674, 0],
	[NaN, 6442450944, 0],
	[NaN, 6442450945, 0],
	[NaN, 6442450946.74, 0],
	[NaN, -1, 0],
	[NaN, -32.5, 0],
	[NaN, -3000000000, 0],
	[NaN, -4000000000.23, 0],
	[NaN, -5000000000, 0],
	[NaN, -4294967298.479, 0],
	[NaN, -6442450942, 0],
	[NaN, -6442450943.674, 0],
	[NaN, -6442450944, 0],
	[NaN, -6442450945, 0],
	[NaN, -6442450946.74, 0],
	[+0, NaN, 0],
	[+0, +0, 0],
	[+0, -0, 0],
	[+0, Infinity, 0],
	[+0, -Infinity, 0],
	[+0, 1, 0],
	[+0, 32.5, 0],
	[+0, 2147483648, 0],
	[+0, 3000000000, 0],
	[+0, 4000000000.23, 0],
	[+0, 5000000000, 0],
	[+0, 4294967296, 0],
	[+0, 4294967298.479, 0],
	[+0, 6442450942, 0],
	[+0, 6442450943.674, 0],
	[+0, 6442450944, 0],
	[+0, 6442450945, 0],
	[+0, 6442450946.74, 0],
	[+0, -1, 0],
	[+0, -32.5, 0],
	[+0, -3000000000, 0],
	[+0, -4000000000.23, 0],
	[+0, -5000000000, 0],
	[+0, -4294967298.479, 0],
	[+0, -6442450942, 0],
	[+0, -6442450943.674, 0],
	[+0, -6442450944, 0],
	[+0, -6442450945, 0],
	[+0, -6442450946.74, 0],
	[-0, NaN, 0],
	[-0, +0, 0],
	[-0, -0, 0],
	[-0, Infinity, 0],
	[-0, -Infinity, 0],
	[-0, 1, 0],
	[-0, 32.5, 0],
	[-0, 2147483648, 0],
	[-0, 3000000000, 0],
	[-0, 4000000000.23, 0],
	[-0, 5000000000, 0],
	[-0, 4294967296, 0],
	[-0, 4294967298.479, 0],
	[-0, 6442450942, 0],
	[-0, 6442450943.674, 0],
	[-0, 6442450944, 0],
	[-0, 6442450945, 0],
	[-0, 6442450946.74, 0],
	[-0, -1, 0],
	[-0, -32.5, 0],
	[-0, -3000000000, 0],
	[-0, -4000000000.23, 0],
	[-0, -5000000000, 0],
	[-0, -4294967298.479, 0],
	[-0, -6442450942, 0],
	[-0, -6442450943.674, 0],
	[-0, -6442450944, 0],
	[-0, -6442450945, 0],
	[-0, -6442450946.74, 0],
	[Infinity, NaN, 0],
	[Infinity, +0, 0],
	[Infinity, -0, 0],
	[Infinity, Infinity, 0],
	[Infinity, -Infinity, 0],
	[Infinity, 1, 0],
	[Infinity, 32.5, 0],
	[Infinity, 2147483648, 0],
	[Infinity, 3000000000, 0],
	[Infinity, 4000000000.23, 0],
	[Infinity, 5000000000, 0],
	[Infinity, 4294967296, 0],
	[Infinity, 4294967298.479, 0],
	[Infinity, 6442450942, 0],
	[Infinity, 6442450943.674, 0],
	[Infinity, 6442450944, 0],
	[Infinity, 6442450945, 0],
	[Infinity, 6442450946.74, 0],
	[Infinity, -1, 0],
	[Infinity, -32.5, 0],
	[Infinity, -3000000000, 0],
	[Infinity, -4000000000.23, 0],
	[Infinity, -5000000000, 0],
	[Infinity, -4294967298.479, 0],
	[Infinity, -6442450942, 0],
	[Infinity, -6442450943.674, 0],
	[Infinity, -6442450944, 0],
	[Infinity, -6442450945, 0],
	[Infinity, -6442450946.74, 0],
	[-Infinity, NaN, 0],
	[-Infinity, +0, 0],
	[-Infinity, -0, 0],
	[-Infinity, Infinity, 0],
	[-Infinity, -Infinity, 0],
	[-Infinity, 1, 0],
	[-Infinity, 32.5, 0],
	[-Infinity, 2147483648, 0],
	[-Infinity, 3000000000, 0],
	[-Infinity, 4000000000.23, 0],
	[-Infinity, 5000000000, 0],
	[-Infinity, 4294967296, 0],
	[-Infinity, 4294967298.479, 0],
	[-Infinity, 6442450942, 0],
	[-Infinity, 6442450943.674, 0],
	[-Infinity, 6442450944, 0],
	[-Infinity, 6442450945, 0],
	[-Infinity, 6442450946.74, 0],
	[-Infinity, -1, 0],
	[-Infinity, -32.5, 0],
	[-Infinity, -3000000000, 0],
	[-Infinity, -4000000000.23, 0],
	[-Infinity, -5000000000, 0],
	[-Infinity, -4294967298.479, 0],
	[-Infinity, -6442450942, 0],
	[-Infinity, -6442450943.674, 0],
	[-Infinity, -6442450944, 0],
	[-Infinity, -6442450945, 0],
	[-Infinity, -6442450946.74, 0],
	[1, NaN, 1],
	[1, +0, 1],
	[1, -0, 1],
	[1, Infinity, 1],
	[1, -Infinity, 1],
	[1, 1, 0],
	[1, 32.5, 1],
	[1, 2147483648, 1],
	[1, 3000000000, 1],
	[1, 4000000000.23, 1],
	[1, 5000000000, 1],
	[1, 4294967296, 1],
	[1, 4294967298.479, 0],
	[1, 6442450942, 0],
	[1, 6442450943.674, 0],
	[1, 6442450944, 1],
	[1, 6442450945, 0],
	[1, 6442450946.74, 0],
	[1, -1, 0],
	[1, -32.5, 1],
	[1, -3000000000, 1],
	[1, -4000000000.23, 1],
	[1, -5000000000, 1],
	[1, -4294967298.479, 0],
	[1, -6442450942, 0],
	[1, -6442450943.674, 0],
	[1, -6442450944, 1],
	[1, -6442450945, 0],
	[1, -6442450946.74, 0],
	[32.5, NaN, 32],
	[32.5, +0, 32],
	[32.5, -0, 32],
	[32.5, Infinity, 32],
	[32.5, -Infinity, 32],
	[32.5, 1, 16],
	[32.5, 32.5, 32],
	[32.5, 2147483648, 32],
	[32.5, 3000000000, 32],
	[32.5, 4000000000.23, 32],
	[32.5, 5000000000, 32],
	[32.5, 4294967296, 32],
	[32.5, 4294967298.479, 8],
	[32.5, 6442450942, 0],
	[32.5, 6442450943.674, 0],
	[32.5, 6442450944, 32],
	[32.5, 6442450945, 16],
	[32.5, 6442450946.74, 8],
	[32.5, -1, 0],
	[32.5, -32.5, 32],
	[32.5, -3000000000, 32],
	[32.5, -4000000000.23, 32],
	[32.5, -5000000000, 32],
	[32.5, -4294967298.479, 0],
	[32.5, -6442450942, 8],
	[32.5, -6442450943.674, 16],
	[32.5, -6442450944, 32],
	[32.5, -6442450945, 0],
	[32.5, -6442450946.74, 0],
	[2147483648, NaN, 2147483648],
	[2147483648, +0, 2147483648],
	[2147483648, -0, 2147483648],
	[2147483648, Infinity, 2147483648],
	[2147483648, -Infinity, 2147483648],
	[2147483648, 1, 1073741824],
	[2147483648, 32.5, 2147483648],
	[2147483648, 2147483648, 2147483648],
	[2147483648, 3000000000, 2147483648],
	[2147483648, 4000000000.23, 2147483648],
	[2147483648, 5000000000, 2147483648],
	[2147483648, 4294967296, 2147483648],
	[2147483648, 4294967298.479, 536870912],
	[2147483648, 6442450942, 2],
	[2147483648, 6442450943.674, 1],
	[2147483648, 6442450944, 2147483648],
	[2147483648, 6442450945, 1073741824],
	[2147483648, 6442450946.74, 536870912],
	[2147483648, -1, 1],
	[2147483648, -32.5, 2147483648],
	[2147483648, -3000000000, 2147483648],
	[2147483648, -4000000000.23, 2147483648],
	[2147483648, -5000000000, 2147483648],
	[2147483648, -4294967298.479, 2],
	[2147483648, -6442450942, 536870912],
	[2147483648, -6442450943.674, 1073741824],
	[2147483648, -6442450944, 2147483648],
	[2147483648, -6442450945, 1],
	[2147483648, -6442450946.74, 2],
	[3000000000, NaN, 3000000000],
	[3000000000, +0, 3000000000],
	[3000000000, -0, 3000000000],
	[3000000000, Infinity, 3000000000],
	[3000000000, -Infinity, 3000000000],
	[3000000000, 1, 1500000000],
	[3000000000, 32.5, 3000000000],
	[3000000000, 2147483648, 3000000000],
	[3000000000, 3000000000, 3000000000],
	[3000000000, 4000000000.23, 3000000000],
	[3000000000, 5000000000, 3000000000],
	[3000000000, 4294967296, 3000000000],
	[3000000000, 4294967298.479, 750000000],
	[3000000000, 6442450942, 2],
	[3000000000, 6442450943.674, 1],
	[3000000000, 6442450944, 3000000000],
	[3000000000, 6442450945, 1500000000],
	[3000000000, 6442450946.74, 750000000],
	[3000000000, -1, 1],
	[3000000000, -32.5, 3000000000],
	[3000000000, -3000000000, 3000000000],
	[3000000000, -4000000000.23, 3000000000],
	[3000000000, -5000000000, 3000000000],
	[3000000000, -4294967298.479, 2],
	[3000000000, -6442450942, 750000000],
	[3000000000, -6442450943.674, 1500000000],
	[3000000000, -6442450944, 3000000000],
	[3000000000, -6442450945, 1],
	[3000000000, -6442450946.74, 2],
	[4000000000.23, NaN, 4000000000],
	[4000000000.23, +0, 4000000000],
	[4000000000.23, -0, 4000000000],
	[4000000000.23, Infinity, 4000000000],
	[4000000000.23, -Infinity, 4000000000],
	[4000000000.23, 1, 2000000000],
	[4000000000.23, 32.5, 4000000000],
	[4000000000.23, 2147483648, 4000000000],
	[4000000000.23, 3000000000, 4000000000],
	[4000000000.23, 4000000000.23, 4000000000],
	[4000000000.23, 5000000000, 4000000000],
	[4000000000.23, 4294967296, 4000000000],
	[4000000000.23, 4294967298.479, 1000000000],
	[4000000000.23, 6442450942, 3],
	[4000000000.23, 6442450943.674, 1],
	[4000000000.23, 6442450944, 4000000000],
	[4000000000.23, 6442450945, 2000000000],
	[4000000000.23, 6442450946.74, 1000000000],
	[4000000000.23, -1, 1],
	[4000000000.23, -32.5, 4000000000],
	[4000000000.23, -3000000000, 4000000000],
	[4000000000.23, -4000000000.23, 4000000000],
	[4000000000.23, -5000000000, 4000000000],
	[4000000000.23, -4294967298.479, 3],
	[4000000000.23, -6442450942, 1000000000],
	[4000000000.23, -6442450943.674, 2000000000],
	[4000000000.23, -6442450944, 4000000000],
	[4000000000.23, -6442450945, 1],
	[4000000000.23, -6442450946.74, 3],
	[5000000000, NaN, 705032704],
	[5000000000, +0, 705032704],
	[5000000000, -0, 705032704],
	[5000000000, Infinity, 705032704],
	[5000000000, -Infinity, 705032704],
	[5000000000, 1, 352516352],
	[5000000000, 32.5, 705032704],
	[5000000000, 2147483648, 705032704],
	[5000000000, 3000000000, 705032704],
	[5000000000, 4000000000.23, 705032704],
	[5000000000, 5000000000, 705032704],
	[5000000000, 4294967296, 705032704],
	[5000000000, 4294967298.479, 176258176],
	[5000000000, 6442450942, 0],
	[5000000000, 6442450943.674, 0],
	[5000000000, 6442450944, 705032704],
	[5000000000, 6442450945, 352516352],
	[5000000000, 6442450946.74, 176258176],
	[5000000000, -1, 0],
	[5000000000, -32.5, 705032704],
	[5000000000, -3000000000, 705032704],
	[5000000000, -4000000000.23, 705032704],
	[5000000000, -5000000000, 705032704],
	[5000000000, -4294967298.479, 0],
	[5000000000, -6442450942, 176258176],
	[5000000000, -6442450943.674, 352516352],
	[5000000000, -6442450944, 705032704],
	[5000000000, -6442450945, 0],
	[5000000000, -6442450946.74, 0],
	[4294967296, NaN, 0],
	[4294967296, +0, 0],
	[4294967296, -0, 0],
	[4294967296, Infinity, 0],
	[4294967296, -Infinity, 0],
	[4294967296, 1, 0],
	[4294967296, 32.5, 0],
	[4294967296, 2147483648, 0],
	[4294967296, 3000000000, 0],
	[4294967296, 4000000000.23, 0],
	[4294967296, 5000000000, 0],
	[4294967296, 4294967296, 0],
	[4294967296, 4294967298.479, 0],
	[4294967296, 6442450942, 0],
	[4294967296, 6442450943.674, 0],
	[4294967296, 6442450944, 0],
	[4294967296, 6442450945, 0],
	[4294967296, 6442450946.74, 0],
	[4294967296, -1, 0],
	[4294967296, -32.5, 0],
	[4294967296, -3000000000, 0],
	[4294967296, -4000000000.23, 0],
	[4294967296, -5000000000, 0],
	[4294967296, -4294967298.479, 0],
	[4294967296, -6442450942, 0],
	[4294967296, -6442450943.674, 0],
	[4294967296, -6442450944, 0],
	[4294967296, -6442450945, 0],
	[4294967296, -6442450946.74, 0],
	[4294967298.479, NaN, 2],
	[4294967298.479, +0, 2],
	[4294967298.479, -0, 2],
	[4294967298.479, Infinity, 2],
	[4294967298.479, -Infinity, 2],
	[4294967298.479, 1, 1],
	[4294967298.479, 32.5, 2],
	[4294967298.479, 2147483648, 2],
	[4294967298.479, 3000000000, 2],
	[4294967298.479, 4000000000.23, 2],
	[4294967298.479, 5000000000, 2],
	[4294967298.479, 4294967296, 2],
	[4294967298.479, 4294967298.479, 0],
	[4294967298.479, 6442450942, 0],
	[4294967298.479, 6442450943.674, 0],
	[4294967298.479, 6442450944, 2],
	[4294967298.479, 6442450945, 1],
	[4294967298.479, 6442450946.74, 0],
	[4294967298.479, -1, 0],
	[4294967298.479, -32.5, 2],
	[4294967298.479, -3000000000, 2],
	[4294967298.479, -4000000000.23, 2],
	[4294967298.479, -5000000000, 2],
	[4294967298.479, -4294967298.479, 0],
	[4294967298.479, -6442450942, 0],
	[4294967298.479, -6442450943.674, 1],
	[4294967298.479, -6442450944, 2],
	[4294967298.479, -6442450945, 0],
	[4294967298.479, -6442450946.74, 0],
	[6442450942, NaN, 2147483646],
	[6442450942, +0, 2147483646],
	[6442450942, -0, 2147483646],
	[6442450942, Infinity, 2147483646],
	[6442450942, -Infinity, 2147483646],
	[6442450942, 1, 1073741823],
	[6442450942, 32.5, 2147483646],
	[6442450942, 2147483648, 2147483646],
	[6442450942, 3000000000, 2147483646],
	[6442450942, 4000000000.23, 2147483646],
	[6442450942, 5000000000, 2147483646],
	[6442450942, 4294967296, 2147483646],
	[6442450942, 4294967298.479, 536870911],
	[6442450942, 6442450942, 1],
	[6442450942, 6442450943.674, 0],
	[6442450942, 6442450944, 2147483646],
	[6442450942, 6442450945, 1073741823],
	[6442450942, 6442450946.74, 536870911],
	[6442450942, -1, 0],
	[6442450942, -32.5, 2147483646],
	[6442450942, -3000000000, 2147483646],
	[6442450942, -4000000000.23, 2147483646],
	[6442450942, -5000000000, 2147483646],
	[6442450942, -4294967298.479, 1],
	[6442450942, -6442450942, 536870911],
	[6442450942, -6442450943.674, 1073741823],
	[6442450942, -6442450944, 2147483646],
	[6442450942, -6442450945, 0],
	[6442450942, -6442450946.74, 1],
	[6442450943.674, NaN, 2147483647],
	[6442450943.674, +0, 2147483647],
	[6442450943.674, -0, 2147483647],
	[6442450943.674, Infinity, 2147483647],
	[6442450943.674, -Infinity, 2147483647],
	[6442450943.674, 1, 1073741823],
	[6442450943.674, 32.5, 2147483647],
	[6442450943.674, 2147483648, 2147483647],
	[6442450943.674, 3000000000, 2147483647],
	[6442450943.674, 4000000000.23, 2147483647],
	[6442450943.674, 5000000000, 2147483647],
	[6442450943.674, 4294967296, 2147483647],
	[6442450943.674, 4294967298.479, 536870911],
	[6442450943.674, 6442450942, 1],
	[6442450943.674, 6442450943.674, 0],
	[6442450943.674, 6442450944, 2147483647],
	[6442450943.674, 6442450945, 1073741823],
	[6442450943.674, 6442450946.74, 536870911],
	[6442450943.674, -1, 0],
	[6442450943.674, -32.5, 2147483647],
	[6442450943.674, -3000000000, 2147483647],
	[6442450943.674, -4000000000.23, 2147483647],
	[6442450943.674, -5000000000, 2147483647],
	[6442450943.674, -4294967298.479, 1],
	[6442450943.674, -6442450942, 536870911],
	[6442450943.674, -6442450943.674, 1073741823],
	[6442450943.674, -6442450944, 2147483647],
	[6442450943.674, -6442450945, 0],
	[6442450943.674, -6442450946.74, 1],
	[6442450944, NaN, 2147483648],
	[6442450944, +0, 2147483648],
	[6442450944, -0, 2147483648],
	[6442450944, Infinity, 2147483648],
	[6442450944, -Infinity, 2147483648],
	[6442450944, 1, 1073741824],
	[6442450944, 32.5, 2147483648],
	[6442450944, 2147483648, 2147483648],
	[6442450944, 3000000000, 2147483648],
	[6442450944, 4000000000.23, 2147483648],
	[6442450944, 5000000000, 2147483648],
	[6442450944, 4294967296, 2147483648],
	[6442450944, 4294967298.479, 536870912],
	[6442450944, 6442450942, 2],
	[6442450944, 6442450943.674, 1],
	[6442450944, 6442450944, 2147483648],
	[6442450944, 6442450945, 1073741824],
	[6442450944, 6442450946.74, 536870912],
	[6442450944, -1, 1],
	[6442450944, -32.5, 2147483648],
	[6442450944, -3000000000, 2147483648],
	[6442450944, -4000000000.23, 2147483648],
	[6442450944, -5000000000, 2147483648],
	[6442450944, -4294967298.479, 2],
	[6442450944, -6442450942, 536870912],
	[6442450944, -6442450943.674, 1073741824],
	[6442450944, -6442450944, 2147483648],
	[6442450944, -6442450945, 1],
	[6442450944, -6442450946.74, 2],
	[6442450945, NaN, 2147483649],
	[6442450945, +0, 2147483649],
	[6442450945, -0, 2147483649],
	[6442450945, Infinity, 2147483649],
	[6442450945, -Infinity, 2147483649],
	[6442450945, 1, 1073741824],
	[6442450945, 32.5, 2147483649],
	[6442450945, 2147483648, 2147483649],
	[6442450945, 3000000000, 2147483649],
	[6442450945, 4000000000.23, 2147483649],
	[6442450945, 5000000000, 2147483649],
	[6442450945, 4294967296, 2147483649],
	[6442450945, 4294967298.479, 536870912],
	[6442450945, 6442450942, 2],
	[6442450945, 6442450943.674, 1],
	[6442450945, 6442450944, 2147483649],
	[6442450945, 6442450945, 1073741824],
	[6442450945, 6442450946.74, 536870912],
	[6442450945, -1, 1],
	[6442450945, -32.5, 2147483649],
	[6442450945, -3000000000, 2147483649],
	[6442450945, -4000000000.23, 2147483649],
	[6442450945, -5000000000, 2147483649],
	[6442450945, -4294967298.479, 2],
	[6442450945, -6442450942, 536870912],
	[6442450945, -6442450943.674, 1073741824],
	[6442450945, -6442450944, 2147483649],
	[6442450945, -6442450945, 1],
	[6442450945, -6442450946.74, 2],
	[6442450946.74, NaN, 2147483650],
	[6442450946.74, +0, 2147483650],
	[6442450946.74, -0, 2147483650],
	[6442450946.74, Infinity, 2147483650],
	[6442450946.74, -Infinity, 2147483650],
	[6442450946.74, 1, 1073741825],
	[6442450946.74, 32.5, 2147483650],
	[6442450946.74, 2147483648, 2147483650],
	[6442450946.74, 3000000000, 2147483650],
	[6442450946.74, 4000000000.23, 2147483650],
	[6442450946.74, 5000000000, 2147483650],
	[6442450946.74, 4294967296, 2147483650],
	[6442450946.74, 4294967298.479, 536870912],
	[6442450946.74, 6442450942, 2],
	[6442450946.74, 6442450943.674, 1],
	[6442450946.74, 6442450944, 2147483650],
	[6442450946.74, 6442450945, 1073741825],
	[6442450946.74, 6442450946.74, 536870912],
	[6442450946.74, -1, 1],
	[6442450946.74, -32.5, 2147483650],
	[6442450946.74, -3000000000, 2147483650],
	[6442450946.74, -4000000000.23, 2147483650],
	[6442450946.74, -5000000000, 2147483650],
	[6442450946.74, -4294967298.479, 2],
	[6442450946.74, -6442450942, 536870912],
	[6442450946.74, -6442450943.674, 1073741825],
	[6442450946.74, -6442450944, 2147483650],
	[6442450946.74, -6442450945, 1],
	[6442450946.74, -6442450946.74, 2],
	[-1, NaN, 4294967295],
	[-1, +0, 4294967295],
	[-1, -0, 4294967295],
	[-1, Infinity, 4294967295],
	[-1, -Infinity, 4294967295],
	[-1, 1, 2147483647],
	[-1, 32.5, 4294967295],
	[-1, 2147483648, 4294967295],
	[-1, 3000000000, 4294967295],
	[-1, 4000000000.23, 4294967295],
	[-1, 5000000000, 4294967295],
	[-1, 4294967296, 4294967295],
	[-1, 4294967298.479, 1073741823],
	[-1, 6442450942, 3],
	[-1, 6442450943.674, 1],
	[-1, 6442450944, 4294967295],
	[-1, 6442450945, 2147483647],
	[-1, 6442450946.74, 1073741823],
	[-1, -1, 1],
	[-1, -32.5, 4294967295],
	[-1, -3000000000, 4294967295],
	[-1, -4000000000.23, 4294967295],
	[-1, -5000000000, 4294967295],
	[-1, -4294967298.479, 3],
	[-1, -6442450942, 1073741823],
	[-1, -6442450943.674, 2147483647],
	[-1, -6442450944, 4294967295],
	[-1, -6442450945, 1],
	[-1, -6442450946.74, 3],
	[-32.5, NaN, 4294967264],
	[-32.5, +0, 4294967264],
	[-32.5, -0, 4294967264],
	[-32.5, Infinity, 4294967264],
	[-32.5, -Infinity, 4294967264],
	[-32.5, 1, 2147483632],
	[-32.5, 32.5, 4294967264],
	[-32.5, 2147483648, 4294967264],
	[-32.5, 3000000000, 4294967264],
	[-32.5, 4000000000.23, 4294967264],
	[-32.5, 5000000000, 4294967264],
	[-32.5, 4294967296, 4294967264],
	[-32.5, 4294967298.479, 1073741816],
	[-32.5, 6442450942, 3],
	[-32.5, 6442450943.674, 1],
	[-32.5, 6442450944, 4294967264],
	[-32.5, 6442450945, 2147483632],
	[-32.5, 6442450946.74, 1073741816],
	[-32.5, -1, 1],
	[-32.5, -32.5, 4294967264],
	[-32.5, -3000000000, 4294967264],
	[-32.5, -4000000000.23, 4294967264],
	[-32.5, -5000000000, 4294967264],
	[-32.5, -4294967298.479, 3],
	[-32.5, -6442450942, 1073741816],
	[-32.5, -6442450943.674, 2147483632],
	[-32.5, -6442450944, 4294967264],
	[-32.5, -6442450945, 1],
	[-32.5, -6442450946.74, 3],
	[-3000000000, NaN, 1294967296],
	[-3000000000, +0, 1294967296],
	[-3000000000, -0, 1294967296],
	[-3000000000, Infinity, 1294967296],
	[-3000000000, -Infinity, 1294967296],
	[-3000000000, 1, 647483648],
	[-3000000000, 32.5, 1294967296],
	[-3000000000, 2147483648, 1294967296],
	[-3000000000, 3000000000, 1294967296],
	[-3000000000, 4000000000.23, 1294967296],
	[-3000000000, 5000000000, 1294967296],
	[-3000000000, 4294967296, 1294967296],
	[-3000000000, 4294967298.479, 323741824],
	[-3000000000, 6442450942, 1],
	[-3000000000, 6442450943.674, 0],
	[-3000000000, 6442450944, 1294967296],
	[-3000000000, 6442450945, 647483648],
	[-3000000000, 6442450946.74, 323741824],
	[-3000000000, -1, 0],
	[-3000000000, -32.5, 1294967296],
	[-3000000000, -3000000000, 1294967296],
	[-3000000000, -4000000000.23, 1294967296],
	[-3000000000, -5000000000, 1294967296],
	[-3000000000, -4294967298.479, 1],
	[-3000000000, -6442450942, 323741824],
	[-3000000000, -6442450943.674, 647483648],
	[-3000000000, -6442450944, 1294967296],
	[-3000000000, -6442450945, 0],
	[-3000000000, -6442450946.74, 1],
	[-4000000000.23, NaN, 294967296],
	[-4000000000.23, +0, 294967296],
	[-4000000000.23, -0, 294967296],
	[-4000000000.23, Infinity, 294967296],
	[-4000000000.23, -Infinity, 294967296],
	[-4000000000.23, 1, 147483648],
	[-4000000000.23, 32.5, 294967296],
	[-4000000000.23, 2147483648, 294967296],
	[-4000000000.23, 3000000000, 294967296],
	[-4000000000.23, 4000000000.23, 294967296],
	[-4000000000.23, 5000000000, 294967296],
	[-4000000000.23, 4294967296, 294967296],
	[-4000000000.23, 4294967298.479, 73741824],
	[-4000000000.23, 6442450942, 0],
	[-4000000000.23, 6442450943.674, 0],
	[-4000000000.23, 6442450944, 294967296],
	[-4000000000.23, 6442450945, 147483648],
	[-4000000000.23, 6442450946.74, 73741824],
	[-4000000000.23, -1, 0],
	[-4000000000.23, -32.5, 294967296],
	[-4000000000.23, -3000000000, 294967296],
	[-4000000000.23, -4000000000.23, 294967296],
	[-4000000000.23, -5000000000, 294967296],
	[-4000000000.23, -4294967298.479, 0],
	[-4000000000.23, -6442450942, 73741824],
	[-4000000000.23, -6442450943.674, 147483648],
	[-4000000000.23, -6442450944, 294967296],
	[-4000000000.23, -6442450945, 0],
	[-4000000000.23, -6442450946.74, 0],
	[-5000000000, NaN, 3589934592],
	[-5000000000, +0, 3589934592],
	[-5000000000, -0, 3589934592],
	[-5000000000, Infinity, 3589934592],
	[-5000000000, -Infinity, 3589934592],
	[-5000000000, 1, 1794967296],
	[-5000000000, 32.5, 3589934592],
	[-5000000000, 2147483648, 3589934592],
	[-5000000000, 3000000000, 3589934592],
	[-5000000000, 4000000000.23, 3589934592],
	[-5000000000, 5000000000, 3589934592],
	[-5000000000, 4294967296, 3589934592],
	[-5000000000, 4294967298.479, 897483648],
	[-5000000000, 6442450942, 3],
	[-5000000000, 6442450943.674, 1],
	[-5000000000, 6442450944, 3589934592],
	[-5000000000, 6442450945, 1794967296],
	[-5000000000, 6442450946.74, 897483648],
	[-5000000000, -1, 1],
	[-5000000000, -32.5, 3589934592],
	[-5000000000, -3000000000, 3589934592],
	[-5000000000, -4000000000.23, 3589934592],
	[-5000000000, -5000000000, 3589934592],
	[-5000000000, -4294967298.479, 3],
	[-5000000000, -6442450942, 897483648],
	[-5000000000, -6442450943.674, 1794967296],
	[-5000000000, -6442450944, 3589934592],
	[-5000000000, -6442450945, 1],
	[-5000000000, -6442450946.74, 3],
	[-4294967298.479, NaN, 4294967294],
	[-4294967298.479, +0, 4294967294],
	[-4294967298.479, -0, 4294967294],
	[-4294967298.479, Infinity, 4294967294],
	[-4294967298.479, -Infinity, 4294967294],
	[-4294967298.479, 1, 2147483647],
	[-4294967298.479, 32.5, 4294967294],
	[-4294967298.479, 2147483648, 4294967294],
	[-4294967298.479, 3000000000, 4294967294],
	[-4294967298.479, 4000000000.23, 4294967294],
	[-4294967298.479, 5000000000, 4294967294],
	[-4294967298.479, 4294967296, 4294967294],
	[-4294967298.479, 4294967298.479, 1073741823],
	[-4294967298.479, 6442450942, 3],
	[-4294967298.479, 6442450943.674, 1],
	[-4294967298.479, 6442450944, 4294967294],
	[-4294967298.479, 6442450945, 2147483647],
	[-4294967298.479, 6442450946.74, 1073741823],
	[-4294967298.479, -1, 1],
	[-4294967298.479, -32.5, 4294967294],
	[-4294967298.479, -3000000000, 4294967294],
	[-4294967298.479, -4000000000.23, 4294967294],
	[-4294967298.479, -5000000000, 4294967294],
	[-4294967298.479, -4294967298.479, 3],
	[-4294967298.479, -6442450942, 1073741823],
	[-4294967298.479, -6442450943.674, 2147483647],
	[-4294967298.479, -6442450944, 4294967294],
	[-4294967298.479, -6442450945, 1],
	[-4294967298.479, -6442450946.74, 3],
	[-6442450942, NaN, 2147483650],
	[-6442450942, +0, 2147483650],
	[-6442450942, -0, 2147483650],
	[-6442450942, Infinity, 2147483650],
	[-6442450942, -Infinity, 2147483650],
	[-6442450942, 1, 1073741825],
	[-6442450942, 32.5, 2147483650],
	[-6442450942, 2147483648, 2147483650],
	[-6442450942, 3000000000, 2147483650],
	[-6442450942, 4000000000.23, 2147483650],
	[-6442450942, 5000000000, 2147483650],
	[-6442450942, 4294967296, 2147483650],
	[-6442450942, 4294967298.479, 536870912],
	[-6442450942, 6442450942, 2],
	[-6442450942, 6442450943.674, 1],
	[-6442450942, 6442450944, 2147483650],
	[-6442450942, 6442450945, 1073741825],
	[-6442450942, 6442450946.74, 536870912],
	[-6442450942, -1, 1],
	[-6442450942, -32.5, 2147483650],
	[-6442450942, -3000000000, 2147483650],
	[-6442450942, -4000000000.23, 2147483650],
	[-6442450942, -5000000000, 2147483650],
	[-6442450942, -4294967298.479, 2],
	[-6442450942, -6442450942, 536870912],
	[-6442450942, -6442450943.674, 1073741825],
	[-6442450942, -6442450944, 2147483650],
	[-6442450942, -6442450945, 1],
	[-6442450942, -6442450946.74, 2],
	[-6442450943.674, NaN, 2147483649],
	[-6442450943.674, +0, 2147483649],
	[-6442450943.674, -0, 2147483649],
	[-6442450943.674, Infinity, 2147483649],
	[-6442450943.674, -Infinity, 2147483649],
	[-6442450943.674, 1, 1073741824],
	[-6442450943.674, 32.5, 2147483649],
	[-6442450943.674, 2147483648, 2147483649],
	[-6442450943.674, 3000000000, 2147483649],
	[-6442450943.674, 4000000000.23, 2147483649],
	[-6442450943.674, 5000000000, 2147483649],
	[-6442450943.674, 4294967296, 2147483649],
	[-6442450943.674, 4294967298.479, 536870912],
	[-6442450943.674, 6442450942, 2],
	[-6442450943.674, 6442450943.674, 1],
	[-6442450943.674, 6442450944, 2147483649],
	[-6442450943.674, 6442450945, 1073741824],
	[-6442450943.674, 6442450946.74, 536870912],
	[-6442450943.674, -1, 1],
	[-6442450943.674, -32.5, 2147483649],
	[-6442450943.674, -3000000000, 2147483649],
	[-6442450943.674, -4000000000.23, 2147483649],
	[-6442450943.674, -5000000000, 2147483649],
	[-6442450943.674, -4294967298.479, 2],
	[-6442450943.674, -6442450942, 536870912],
	[-6442450943.674, -6442450943.674, 1073741824],
	[-6442450943.674, -6442450944, 2147483649],
	[-6442450943.674, -6442450945, 1],
	[-6442450943.674, -6442450946.74, 2],
	[-6442450944, NaN, 2147483648],
	[-6442450944, +0, 2147483648],
	[-6442450944, -0, 2147483648],
	[-6442450944, Infinity, 2147483648],
	[-6442450944, -Infinity, 2147483648],
	[-6442450944, 1, 1073741824],
	[-6442450944, 32.5, 2147483648],
	[-6442450944, 2147483648, 2147483648],
	[-6442450944, 3000000000, 2147483648],
	[-6442450944, 4000000000.23, 2147483648],
	[-6442450944, 5000000000, 2147483648],
	[-6442450944, 4294967296, 2147483648],
	[-6442450944, 4294967298.479, 536870912],
	[-6442450944, 6442450942, 2],
	[-6442450944, 6442450943.674, 1],
	[-6442450944, 6442450944, 2147483648],
	[-6442450944, 6442450945, 1073741824],
	[-6442450944, 6442450946.74, 536870912],
	[-6442450944, -1, 1],
	[-6442450944, -32.5, 2147483648],
	[-6442450944, -3000000000, 2147483648],
	[-6442450944, -4000000000.23, 2147483648],
	[-6442450944, -5000000000, 2147483648],
	[-6442450944, -4294967298.479, 2],
	[-6442450944, -6442450942, 536870912],
	[-6442450944, -6442450943.674, 1073741824],
	[-6442450944, -6442450944, 2147483648],
	[-6442450944, -6442450945, 1],
	[-6442450944, -6442450946.74, 2],
	[-6442450945, NaN, 2147483647],
	[-6442450945, +0, 2147483647],
	[-6442450945, -0, 2147483647],
	[-6442450945, Infinity, 2147483647],
	[-6442450945, -Infinity, 2147483647],
	[-6442450945, 1, 1073741823],
	[-6442450945, 32.5, 2147483647],
	[-6442450945, 2147483648, 2147483647],
	[-6442450945, 3000000000, 2147483647],
	[-6442450945, 4000000000.23, 2147483647],
	[-6442450945, 5000000000, 2147483647],
	[-6442450945, 4294967296, 2147483647],
	[-6442450945, 4294967298.479, 536870911],
	[-6442450945, 6442450942, 1],
	[-6442450945, 6442450943.674, 0],
	[-6442450945, 6442450944, 2147483647],
	[-6442450945, 6442450945, 1073741823],
	[-6442450945, 6442450946.74, 536870911],
	[-6442450945, -1, 0],
	[-6442450945, -32.5, 2147483647],
	[-6442450945, -3000000000, 2147483647],
	[-6442450945, -4000000000.23, 2147483647],
	[-6442450945, -5000000000, 2147483647],
	[-6442450945, -4294967298.479, 1],
	[-6442450945, -6442450942, 536870911],
	[-6442450945, -6442450943.674, 1073741823],
	[-6442450945, -6442450944, 2147483647],
	[-6442450945, -6442450945, 0],
	[-6442450945, -6442450946.74, 1],
	[-6442450946.74, NaN, 2147483646],
	[-6442450946.74, +0, 2147483646],
	[-6442450946.74, -0, 2147483646],
	[-6442450946.74, Infinity, 2147483646],
	[-6442450946.74, -Infinity, 2147483646],
	[-6442450946.74, 1, 1073741823],
	[-6442450946.74, 32.5, 2147483646],
	[-6442450946.74, 2147483648, 2147483646],
	[-6442450946.74, 3000000000, 2147483646],
	[-6442450946.74, 4000000000.23, 2147483646],
	[-6442450946.74, 5000000000, 2147483646],
	[-6442450946.74, 4294967296, 2147483646],
	[-6442450946.74, 4294967298.479, 536870911],
	[-6442450946.74, 6442450942, 1],
	[-6442450946.74, 6442450943.674, 0],
	[-6442450946.74, 6442450944, 2147483646],
	[-6442450946.74, 6442450945, 1073741823],
	[-6442450946.74, 6442450946.74, 536870911],
	[-6442450946.74, -1, 0],
	[-6442450946.74, -32.5, 2147483646],
	[-6442450946.74, -3000000000, 2147483646],
	[-6442450946.74, -4000000000.23, 2147483646],
	[-6442450946.74, -5000000000, 2147483646],
	[-6442450946.74, -4294967298.479, 1],
	[-6442450946.74, -6442450942, 536870911],
	[-6442450946.74, -6442450943.674, 1073741823],
	[-6442450946.74, -6442450944, 2147483646],
	[-6442450946.74, -6442450945, 0],
	[-6442450946.74, -6442450946.74, 1],
];

for(var i in n2n) {
	item = n2n[i]
	ok(item[0] >>> item[1] === item[2], item[0] + ' >>> ' + item[1])
}

/* Test 2673 */
expr = 4
is(expr >>> (expr = 2), 1, 'lvalue >>> expr modifying the lvalue');

--end--
