use strict;
use warnings;
use Test::More;
use Digest::JH qw(jh_224 jh_224_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::JH->new(224)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            jh_224_hex($data), $digest,
            "jh_224_hex: $len bits of $msg"
        );
        ok(
            jh_224($data) eq pack('H*', $digest),
            "jh_224: $len bits of $msg"
        );
    }

    my $md = Digest::JH->new(224)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

done_testing;

__DATA__
00|2c99df889b019309051c60fecc2bd285a774940e43175b76b2626630
00|88f4dce7c6221151432031cbc4a109c350be601d388d2d20f3af6342
C0|038f509783751d6688bbc9ef7b0870f32b1589dc0873856422b94c5c
C0|d676be9ba0b65d953a264ce77756b3e698faada292a2977a532daa35
80|1c9074b542e41750e1a855a43aba97e7781540a9c4ce997c51d945f1
48|0284955d682f55a09b482e03678ecebcb9a7cedc61b838e8ca5e6c5c
50|bf7d6672af2465709c838035f75ee123970b1fa0ca7e61dd0a10aca5
98|a82f14e71c249155bf07c6c5632c54a9c4e07a0a45eb5ffeb843c4e7
CC|f79c791ac9b9d80ec934312d6b26748481198e3ca78ebb01b2c9ca51
9800|177d8b1908177c6d645914c702411971d6f4725ab9be6a558764432a
9D40|812e7c89548516db8329ebaaace0515b95d3ea8cb7b73df74660e3cb
AA80|48f2acf7ddae3d7c0df2c7315a06c13ad2769045c9284604ee5b8630
9830|5aa84adc5e7b04ccb893912d61732879f4a7f61ee5363f104318ab20
5030|516a17242e9564867834209d115a01df643f6672b5e7dd01c84518ed
4D24|a3d2b7ea0e1de01028c7fb7a87e2f0e66bd293397f3c86a95e4b37a5
CBDE|8b49acee6c12c37791f9576a851db9d5c94af174f7fea81acf7eb53a
41FB|bf3ea0f2bc680aaf4aba50167fd8cd661e8cc63df10641ee093dd2ae
4FF400|147a361d26deecb52fdd1ce47cc1600fb3877ed7c31758f9241daa2e
FD0440|25834265599f7cd16455823b9ae2bc52dcbd8672e7f3aa79a4593454
424D00|45d4e77f86214bf0ce835718ce721ec02a71f1629fae0a0ed8aae472
3FDEE0|f513d946fec7e08ff1f40aa0bbfe939b4b42d4eb9a4769f2d057fb94
335768|c8d2f4c67e86fa5a2be8ed1e9975a94e6353c6421b55e91890b0ae49
051E7C|8ffec042b5853b0b454f28d357f85b610146f1a86e149241283d6517
717F8C|f830b6c0967af86c5b9c69be4428655fcd32aeb6583c2b1268274822
1F877C|385d05cface35fdb84dc180d766330afdce0f8f0c751f8f245192057
EB35CF80|950ac9a5d7dd56dd62ca4a43de4fb91df9ac228e35fcd8babb3179e6
B406C480|874ba47d16e15d5f05bf2e523b5496574d60c73704428fb0011886be
CEE88040|239bff355ca6f039afff185eb4eb28881e8124c876b88ed93fba765b
C584DB70|8fe02112037a6f4c66480035c0bfd70c7c3cc25d2da1a91a9a5521c1
53587BC8|b2d4bca283a21b5dc23f61b17195ad57ebdcae9d08670a4b1584d0b1
69A305B0|153784954adf9a47ea469bc554175c32a45b3c4808a151fab1b5fa9a
C9375ECE|263ffcd1d0411232ee92d9ff9ad9bc9b74d741111b409990909fe104
C1ECFDFC|1c9aa60c55022e1a416448980ca6ca9bf8d2fac5324570846aa80c02
8D73E8A280|4cfe00de9e23cb6fb19893427d374e7284c7e8060e0a4ee9bc6e8bb9
06F2522080|b3e7d22ec18f6efb34c5c52297a75fc0ca83a9be48f7b3a788090815
3EF6C36F20|75d943cbeed6d3d1e4086fc4d6c21b693f786850d3a0b5c4fee2eedc
0127A1D340|56ba4006e1df38a6dda4474c5f29372c499852f11b2a08dd5aef693b
6A6AB6C210|5b3e5f393471afcf3cb3123b439da4551436d31ad095a47945cced70
AF3175E160|7bf0ab5fc1c6bb72c7fd279c4bb4d6e9aa3ea61d29089438f4bfb13c
B66609ED86|3dabe65d2cb47cb53003ecb8d91bdc65bb3aca8f4b7aecd257c34295
21F134AC57|89162bb97600960c5d0543a77bfa92a7f9ccc89ea619cbdb98679924
3DC2AADFFC80|a2ceeb0523d05fe0876ab9cca2e722395381eb84acae3c47a8cc91e5
9202736D2240|aa895dae707bd9b91129a352d389258deba6922bf6a29bf271939422
F219BD629820|c26de74c167fff625a2a213396aac3f75c407c798c9550831c45327a
F3511EE2C4B0|fc63feca7989cf69b4fd287936d03731e524ad768471d44170a2432c
3ECAB6BF7720|5826736fa5a32281e7af93752d83fa13982c8eeeea41eccff1c50558
CD62F688F498|d8af31dfa3e4a45baa3405b444b2642d9995789c2b4f8f8afc433837
C2CBAA33A9F8|ce82cf407d5ee622b74c4968186d0ff4186b37315d6351fed26275ff
C6F50BB74E29|279293d376a373875b179040003ba3614af942531c763e3c9d250703
79F1B4CCC62A00|abd4279ea11276813b564d118b08fe1a05c061f9bf685f677e7214f8
