# Generated by default/object.tt
package Paws::AmplifyBackend::CreateBackendAuthUserPoolConfig;
  use Moose;
  has ForgotPassword => (is => 'ro', isa => 'Paws::AmplifyBackend::CreateBackendAuthForgotPasswordConfig', request_name => 'forgotPassword', traits => ['NameInRequest']);
  has Mfa => (is => 'ro', isa => 'Paws::AmplifyBackend::CreateBackendAuthMFAConfig', request_name => 'mfa', traits => ['NameInRequest']);
  has OAuth => (is => 'ro', isa => 'Paws::AmplifyBackend::CreateBackendAuthOAuthConfig', request_name => 'oAuth', traits => ['NameInRequest']);
  has PasswordPolicy => (is => 'ro', isa => 'Paws::AmplifyBackend::CreateBackendAuthPasswordPolicyConfig', request_name => 'passwordPolicy', traits => ['NameInRequest']);
  has RequiredSignUpAttributes => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'requiredSignUpAttributes', traits => ['NameInRequest'], required => 1);
  has SignInMethod => (is => 'ro', isa => 'Str', request_name => 'signInMethod', traits => ['NameInRequest'], required => 1);
  has UserPoolName => (is => 'ro', isa => 'Str', request_name => 'userPoolName', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AmplifyBackend::CreateBackendAuthUserPoolConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AmplifyBackend::CreateBackendAuthUserPoolConfig object:

  $service_obj->Method(Att1 => { ForgotPassword => $value, ..., UserPoolName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AmplifyBackend::CreateBackendAuthUserPoolConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->ForgotPassword

=head1 DESCRIPTION

Describes the Amazon Cognito user pool configuration for the auth
resource to be configured for your Amplify project.

=head1 ATTRIBUTES


=head2 ForgotPassword => L<Paws::AmplifyBackend::CreateBackendAuthForgotPasswordConfig>

Describes the forgotten password policy for your Amazon Cognito user
pool, configured as a part of your Amplify project.


=head2 Mfa => L<Paws::AmplifyBackend::CreateBackendAuthMFAConfig>

Describes whether multi-factor authentication policies should be
applied for your Amazon Cognito user pool configured as a part of your
Amplify project.


=head2 OAuth => L<Paws::AmplifyBackend::CreateBackendAuthOAuthConfig>

Describes the OAuth policy and rules for your Amazon Cognito user pool,
configured as a part of your Amplify project.


=head2 PasswordPolicy => L<Paws::AmplifyBackend::CreateBackendAuthPasswordPolicyConfig>

Describes the password policy for your Amazon Cognito user pool,
configured as a part of your Amplify project.


=head2 B<REQUIRED> RequiredSignUpAttributes => ArrayRef[Str|Undef]

The required attributes to sign up new users in the user pool.


=head2 B<REQUIRED> SignInMethod => Str

Describes the sign-in methods that your Amplify app users use to log in
using the Amazon Cognito user pool, configured as a part of your
Amplify project.


=head2 B<REQUIRED> UserPoolName => Str

The Amazon Cognito user pool name.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AmplifyBackend>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

