##############################
#
# Bio::MAGE::BioSequence::BioSequence
#
##############################
# C O P Y R I G H T   N O T I C E
#  Copyright (c) 2001-2002 by:
#    * The MicroArray Gene Expression Database Society (MGED)
#    * Rosetta Inpharmatics
#
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, sublicense, and/or sell copies of the Software,
# and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
# BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
# ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

package Bio::MAGE::BioSequence::BioSequence;

use strict;
use Carp;
use Bio::MAGE::Base;
use Bio::MAGE::Association;
use Bio::MAGE::Identifiable;


use vars qw($VERSION @ISA @EXPORT @EXPORT_OK $__ASSOCIATIONS);

require Exporter;

@ISA = qw(Bio::MAGE::Base Bio::MAGE::Identifiable Exporter);
$VERSION = 20020902.6;

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT_OK = qw();


=head1 Bio::MAGE::BioSequence::BioSequence

=head2 SYNOPSIS

  use Bio::MAGE::BioSequence::BioSequence;

    # creating an empty instance
  my $biosequence = Bio::MAGE::BioSequence::BioSequence->new();

    # creating an already populated instance
  my $biosequence = Bio::MAGE::BioSequence::BioSequence->new(isCircular=>$isCircular_value,
			isApproximateLength=>$isApproximateLength_value,
			length=>$length_value,
			sequence=>$sequence_value,
			seqFeatures=>$seqFeatures_value,
			polymerType=>$polymerType_value,
			type=>$type_value,
			species=>$species_value,
			ontologyEntries=>$ontologyEntries_value,
			sequenceDatabases=>$sequenceDatabases_value);

    # setting and retrieving object attributes
  my $isCircular_val = $biosequence->isCircular();
  $biosequence->isCircular($value);

  my $isApproximateLength_val = $biosequence->isApproximateLength();
  $biosequence->isApproximateLength($value);

  my $length_val = $biosequence->length();
  $biosequence->length($value);

  my $sequence_val = $biosequence->sequence();
  $biosequence->sequence($value);

    # setting and retrieving object associations
  my $seqFeatures_val = $biosequence->seqFeatures();
  $biosequence->seqFeatures($value);

  my $polymerType_val = $biosequence->polymerType();
  $biosequence->polymerType($value);

  my $type_val = $biosequence->type();
  $biosequence->type($value);

  my $species_val = $biosequence->species();
  $biosequence->species($value);

  my $ontologyEntries_val = $biosequence->ontologyEntries();
  $biosequence->ontologyEntries($value);

  my $sequenceDatabases_val = $biosequence->sequenceDatabases();
  $biosequence->sequenceDatabases($value);


=head2 DESCRIPTION

From the MAGE-OM documentation for the C<BioSequence> class:

A BioSequence is a representation of a DNA, RNA, or protein sequence.  It can be represented by a Clone, Gene, or the sequence.



=cut


=head2 INHERITANCE


Bio::MAGE::BioSequence::BioSequence has the following super classes

=over 


=item * Bio::MAGE::Identifiable


=back


=head2 CLASS METHODS

The following methods can all be called without first having an
instance of the class via the Bio::MAGE::BioSequence::BioSequence->methodname() syntax.


=item new()

=item new(%args)


The object constructor C<new()> accepts the following optional
named-value style arguments:

=over


=item * isCircular

Sets the value of the isCircular attribute (this attribute was inherited
from class C<Bio::MAGE::BioSequence::BioSequence>).



=item * isApproximateLength

Sets the value of the isApproximateLength attribute (this attribute was inherited
from class C<Bio::MAGE::BioSequence::BioSequence>).



=item * length

Sets the value of the length attribute (this attribute was inherited
from class C<Bio::MAGE::BioSequence::BioSequence>).



=item * sequence

Sets the value of the sequence attribute (this attribute was inherited
from class C<Bio::MAGE::BioSequence::BioSequence>).



=item * seqFeatures

Sets the value of the seqFeatures association (this association was inherited
from class C<Bio::MAGE::BioSequence::BioSequence>).

The value will be of type C<SeqFeature>.


=item * polymerType

Sets the value of the polymerType association (this association was inherited
from class C<Bio::MAGE::BioSequence::BioSequence>).

The value will be of type C<OntologyEntry>.


=item * type

Sets the value of the type association (this association was inherited
from class C<Bio::MAGE::BioSequence::BioSequence>).

The value will be of type C<OntologyEntry>.


=item * ontologyEntries

Sets the value of the ontologyEntries association (this association was inherited
from class C<Bio::MAGE::BioSequence::BioSequence>).

The value will be of type C<OntologyEntry>.


=item * species

Sets the value of the species association (this association was inherited
from class C<Bio::MAGE::BioSequence::BioSequence>).

The value will be of type C<OntologyEntry>.


=item * sequenceDatabases

Sets the value of the sequenceDatabases association (this association was inherited
from class C<Bio::MAGE::BioSequence::BioSequence>).

The value will be of type C<DatabaseEntry>.


=item * identifier

Sets the value of the identifier attribute (this attribute was inherited
from class C<Bio::MAGE::Identifiable>).



=item * name

Sets the value of the name attribute (this attribute was inherited
from class C<Bio::MAGE::Identifiable>).



=item * descriptions

Sets the value of the descriptions association (this association was inherited
from class C<Bio::MAGE::Describable>).

The value will be of type C<Description>.


=item * security

Sets the value of the security association (this association was inherited
from class C<Bio::MAGE::Describable>).

The value will be of type C<Security>.


=item * auditTrail

Sets the value of the auditTrail association (this association was inherited
from class C<Bio::MAGE::Describable>).

The value will be of type C<Audit>.


=item * propertySets

Sets the value of the propertySets association (this association was inherited
from class C<Bio::MAGE::Extendable>).

The value will be of type C<NameValueType>.


=back



=cut

#
# code for new() inherited from Base.pm
#

=item $obj->set_slots(%parameters)

=item $obj->set_slots(\@name_list, \@value_list)

The C<set_slots()> method is used to set a number of slots at the same
time. It has two different invocation methods. The first takes a named
parameter list, and the second takes two array references.

B<Return value>: none

B<Side effects>: will call C<croak()> if a slot_name is used that the class
does not define.

=cut

#
# code for set_slots() inherited from Base.pm
#

=item $obj->get_slots(@name_list)

The C<get_slots()> method is used to get the values of a number of
slots at the same time.

B<Return value>: a list of instance objects

B<Side effects>: none

=cut

#
# code for get_slots() inherited from Base.pm
#

=item $val = $obj->set_slot($name,$val)

The C<set_slot()> method sets the slot C<$name> to the value C<$val>

B<Return value>: the new value of the slot, i.e. C<$val>

B<Side effects>: none

=cut

#
# code for set_slot() inherited from Base.pm
#

=item $val = $obj->get_slot($name)

The C<get_slot()> method is used to get the values of a number of
slots at the same time.

B<Return value>: a single slot value, or undef if the slot has not been
initialized.

B<Side effects>: none

=cut

#
# code for get_slot() inherited from Base.pm
#

=item @names = $obj->get_slot_names()

The C<get_slot_names()> method is used to retrieve the name of all
slots defined for a given object.

B<Return value>: a single slot value, or undef if the slot has not been
initialized.

B<Side effects>: none

=cut

#
# code for get_slot_names() inherited from Base.pm
#



=item $name = class_name()

Returns the full class name for this class, Bio::MAGE::BioSequence::BioSequence.

=cut

sub class_name {
  return q[Bio::MAGE::BioSequence::BioSequence];
}

=item $package_name = package()

Returns the unresolved package name (i.e. no 'Bio::MAGE::') of the
package that contains class, Bio::MAGE::BioSequence::BioSequence.

=cut

sub package {
  return q[BioSequence];
}

=item @classes = subclasses()

returns the list of subclasses for this class.

=cut

sub subclasses {
  my @list = ();
  return @list;
}

=item @classes = superclasses()

returns the list of superclasses for this class.

=cut

sub superclasses {
  my @list = ('Bio::MAGE::Identifiable');
  return @list;
}

=item @methods = attribute_methods()

returns the list of attribute accessor methods for this class.

=cut

sub attribute_methods {
  my $class = shift;
  my @list = ('isCircular',
'isApproximateLength',
'length',
'sequence');
  if ($class->superclasses()) {
    foreach ($class->superclasses()) {
      push(@list,$_->attribute_methods());
    }
  }
  return @list;
}

=item @methods = association_methods()

returns the list of association accessor methods for this class.

=cut

sub association_methods {
  my $class = shift;
  my @list = ('seqFeatures',
'polymerType',
'type',
'species',
'ontologyEntries',
'sequenceDatabases');
  if ($class->superclasses()) {
    foreach ($class->superclasses()) {
      push(@list,$_->association_methods());
    }
  }
  return @list;
}

=item %assns = associations()

returns the association meta-information in a hash where the keys are
the association names and the values are C<Bio::MAGE::Association>
objects that provide the meta-information for the association.

=cut

sub associations {
  my $class = shift;
  my @list = ();
  # superclasses first
  if ($class->superclasses()) {
    foreach ($class->superclasses()) {
      push(@list,$_->associations());
    }
  }
  # then associations from this class
  if (defined $__ASSOCIATIONS) {
    push(@list,@{$__ASSOCIATIONS})
  }
  return @list;
}


=head2 ATTRIBUTES

Attributes are simple data types that belong to a single instance of a
class. In the Perl implementation of the MAGE-OM classes, the
interface to attributes is implemented using separate setter and
getter methods for each attribute.

Bio::MAGE::BioSequence::BioSequence: has the following attribute accessor methods:

=over


=item isCircular

From the MAGE-OM documentation for the C<isCircular> attribute:

Indicates if the BioSequence is circular in nature.



=over


=item $val = $biosequence->setIsCircular($val)

The restricted setter method for the isCircular attribute.

Input parameters: the value to which the isCircular attribute will be set 

Return value: the current value of the isCircular attribute 

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified, or
if too many input parameters are specified 

=cut

sub setIsCircular {
  my $self = shift;
  croak(__PACKAGE__ . "::setIsCircular: no arguments passed to setter")
    unless @_;
  croak(__PACKAGE__ . "::setIsCircular: too many arguments passed to setter")
    if @_ > 1;
  my $val = shift;
  
  return $self->{__ISCIRCULAR} = $val;
}



=item $val = $biosequence->getIsCircular()

The restricted getter method for the isCircular attribute.

Input parameters: none

Return value: the current value of the isCircular attribute 

Side effects: none

Exceptions: will call C<croak()> if any input parameters are specified

=cut

sub getIsCircular {
  my $self = shift;
  croak(__PACKAGE__ . "::getIsCircular: arguments passed to getter")
    if @_;
  return $self->{__ISCIRCULAR};
}




=back


=item isApproximateLength

From the MAGE-OM documentation for the C<isApproximateLength> attribute:

If length not positively known will be true



=over


=item $val = $biosequence->setIsApproximateLength($val)

The restricted setter method for the isApproximateLength attribute.

Input parameters: the value to which the isApproximateLength attribute will be set 

Return value: the current value of the isApproximateLength attribute 

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified, or
if too many input parameters are specified 

=cut

sub setIsApproximateLength {
  my $self = shift;
  croak(__PACKAGE__ . "::setIsApproximateLength: no arguments passed to setter")
    unless @_;
  croak(__PACKAGE__ . "::setIsApproximateLength: too many arguments passed to setter")
    if @_ > 1;
  my $val = shift;
  
  return $self->{__ISAPPROXIMATELENGTH} = $val;
}



=item $val = $biosequence->getIsApproximateLength()

The restricted getter method for the isApproximateLength attribute.

Input parameters: none

Return value: the current value of the isApproximateLength attribute 

Side effects: none

Exceptions: will call C<croak()> if any input parameters are specified

=cut

sub getIsApproximateLength {
  my $self = shift;
  croak(__PACKAGE__ . "::getIsApproximateLength: arguments passed to getter")
    if @_;
  return $self->{__ISAPPROXIMATELENGTH};
}




=back


=item length

From the MAGE-OM documentation for the C<length> attribute:

The number of residues in the biosequence.



=over


=item $val = $biosequence->setLength($val)

The restricted setter method for the length attribute.

Input parameters: the value to which the length attribute will be set 

Return value: the current value of the length attribute 

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified, or
if too many input parameters are specified 

=cut

sub setLength {
  my $self = shift;
  croak(__PACKAGE__ . "::setLength: no arguments passed to setter")
    unless @_;
  croak(__PACKAGE__ . "::setLength: too many arguments passed to setter")
    if @_ > 1;
  my $val = shift;
  
  return $self->{__LENGTH} = $val;
}



=item $val = $biosequence->getLength()

The restricted getter method for the length attribute.

Input parameters: none

Return value: the current value of the length attribute 

Side effects: none

Exceptions: will call C<croak()> if any input parameters are specified

=cut

sub getLength {
  my $self = shift;
  croak(__PACKAGE__ . "::getLength: arguments passed to getter")
    if @_;
  return $self->{__LENGTH};
}




=back


=item sequence

From the MAGE-OM documentation for the C<sequence> attribute:

The actual components of the sequence, for instance, for DNA a string consisting of A,T,C and G.

The attribute is optional and instead of specified here, can be found through the DatabaseEntry. 



=over


=item $val = $biosequence->setSequence($val)

The restricted setter method for the sequence attribute.

Input parameters: the value to which the sequence attribute will be set 

Return value: the current value of the sequence attribute 

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified, or
if too many input parameters are specified 

=cut

sub setSequence {
  my $self = shift;
  croak(__PACKAGE__ . "::setSequence: no arguments passed to setter")
    unless @_;
  croak(__PACKAGE__ . "::setSequence: too many arguments passed to setter")
    if @_ > 1;
  my $val = shift;
  
  return $self->{__SEQUENCE} = $val;
}



=item $val = $biosequence->getSequence()

The restricted getter method for the sequence attribute.

Input parameters: none

Return value: the current value of the sequence attribute 

Side effects: none

Exceptions: will call C<croak()> if any input parameters are specified

=cut

sub getSequence {
  my $self = shift;
  croak(__PACKAGE__ . "::getSequence: arguments passed to getter")
    if @_;
  return $self->{__SEQUENCE};
}




=back

Attributes Inherited from Bio::MAGE::Identifiable


=item identifier

From the MAGE-OM documentation for the C<identifier> attribute:

An identifier is an unambiguous string that is unique within the scope (i.e. a document, a set of related documents, or a repository) of its use.



=over


=item $val = $identifiable->setIdentifier($val)

The restricted setter method for the identifier attribute.

Input parameters: the value to which the identifier attribute will be set 

Return value: the current value of the identifier attribute 

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified, or
if too many input parameters are specified 

=cut


=item $val = $identifiable->getIdentifier()

The restricted getter method for the identifier attribute.

Input parameters: none

Return value: the current value of the identifier attribute 

Side effects: none

Exceptions: will call C<croak()> if any input parameters are specified

=cut



=back


=item name

From the MAGE-OM documentation for the C<name> attribute:

The potentially ambiguous common identifier.



=over


=item $val = $identifiable->setName($val)

The restricted setter method for the name attribute.

Input parameters: the value to which the name attribute will be set 

Return value: the current value of the name attribute 

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified, or
if too many input parameters are specified 

=cut


=item $val = $identifiable->getName()

The restricted getter method for the name attribute.

Input parameters: none

Return value: the current value of the name attribute 

Side effects: none

Exceptions: will call C<croak()> if any input parameters are specified

=cut



=back



=back


=cut



BEGIN {
  $__ASSOCIATIONS = [
          'sequenceDatabases',
          bless( {
                   '__OTHER' => bless( {
                                         '__IS_REF' => 1,
                                         '__RANK' => '1',
                                         '__CARDINALITY' => '0..N',
                                         '__DOCUMENTATION' => 'References an entry in a species database, like GenBank, UniGene, etc.',
                                         '__NAME' => 'sequenceDatabases',
                                         '__ORDERED' => 0,
                                         '__CLASS_NAME' => 'DatabaseEntry'
                                       }, 'Bio::MAGE::Association::End' ),
                   '__SELF' => bless( {
                                        '__IS_REF' => 0,
                                        '__RANK' => undef,
                                        '__CARDINALITY' => '1',
                                        '__DOCUMENTATION' => 'References an entry in a species database, like GenBank, UniGene, etc.',
                                        '__NAME' => undef,
                                        '__ORDERED' => undef,
                                        '__CLASS_NAME' => 'BioSequence'
                                      }, 'Bio::MAGE::Association::End' )
                 }, 'Bio::MAGE::Association' ),
          'ontologyEntries',
          bless( {
                   '__OTHER' => bless( {
                                         '__IS_REF' => 1,
                                         '__RANK' => '2',
                                         '__CARDINALITY' => '0..N',
                                         '__DOCUMENTATION' => 'Ontology entries referring to common values associated with BioSequences, such as gene names, go ids, etc.',
                                         '__NAME' => 'ontologyEntries',
                                         '__ORDERED' => 0,
                                         '__CLASS_NAME' => 'OntologyEntry'
                                       }, 'Bio::MAGE::Association::End' ),
                   '__SELF' => bless( {
                                        '__IS_REF' => 0,
                                        '__RANK' => undef,
                                        '__CARDINALITY' => '1',
                                        '__DOCUMENTATION' => 'Ontology entries referring to common values associated with BioSequences, such as gene names, go ids, etc.',
                                        '__NAME' => undef,
                                        '__ORDERED' => undef,
                                        '__CLASS_NAME' => 'BioSequence'
                                      }, 'Bio::MAGE::Association::End' )
                 }, 'Bio::MAGE::Association' ),
          'polymerType',
          bless( {
                   '__OTHER' => bless( {
                                         '__IS_REF' => 1,
                                         '__RANK' => '3',
                                         '__CARDINALITY' => '1',
                                         '__DOCUMENTATION' => 'A choice of protein, RNA, or DNA.',
                                         '__NAME' => 'polymerType',
                                         '__ORDERED' => 0,
                                         '__CLASS_NAME' => 'OntologyEntry'
                                       }, 'Bio::MAGE::Association::End' ),
                   '__SELF' => bless( {
                                        '__IS_REF' => 0,
                                        '__RANK' => undef,
                                        '__CARDINALITY' => '1',
                                        '__DOCUMENTATION' => 'A choice of protein, RNA, or DNA.',
                                        '__NAME' => undef,
                                        '__ORDERED' => undef,
                                        '__CLASS_NAME' => 'BioSequence'
                                      }, 'Bio::MAGE::Association::End' )
                 }, 'Bio::MAGE::Association' ),
          'type',
          bless( {
                   '__OTHER' => bless( {
                                         '__IS_REF' => 1,
                                         '__RANK' => '4',
                                         '__CARDINALITY' => '1',
                                         '__DOCUMENTATION' => 'The type of biosequence, i.e. gene, exon, UniGene cluster, fragment, BAC, EST, etc.',
                                         '__NAME' => 'type',
                                         '__ORDERED' => 0,
                                         '__CLASS_NAME' => 'OntologyEntry'
                                       }, 'Bio::MAGE::Association::End' ),
                   '__SELF' => bless( {
                                        '__IS_REF' => 0,
                                        '__RANK' => undef,
                                        '__CARDINALITY' => '1',
                                        '__DOCUMENTATION' => 'The type of biosequence, i.e. gene, exon, UniGene cluster, fragment, BAC, EST, etc.',
                                        '__NAME' => undef,
                                        '__ORDERED' => undef,
                                        '__CLASS_NAME' => 'BioSequence'
                                      }, 'Bio::MAGE::Association::End' )
                 }, 'Bio::MAGE::Association' ),
          'species',
          bless( {
                   '__OTHER' => bless( {
                                         '__IS_REF' => 1,
                                         '__RANK' => '5',
                                         '__CARDINALITY' => '0..1',
                                         '__DOCUMENTATION' => 'The organism from which this sequence was obtained.',
                                         '__NAME' => 'species',
                                         '__ORDERED' => 0,
                                         '__CLASS_NAME' => 'OntologyEntry'
                                       }, 'Bio::MAGE::Association::End' ),
                   '__SELF' => bless( {
                                        '__IS_REF' => 0,
                                        '__RANK' => undef,
                                        '__CARDINALITY' => '1',
                                        '__DOCUMENTATION' => 'The organism from which this sequence was obtained.',
                                        '__NAME' => undef,
                                        '__ORDERED' => undef,
                                        '__CLASS_NAME' => 'BioSequence'
                                      }, 'Bio::MAGE::Association::End' )
                 }, 'Bio::MAGE::Association' ),
          'seqFeatures',
          bless( {
                   '__OTHER' => bless( {
                                         '__IS_REF' => 1,
                                         '__RANK' => '6',
                                         '__CARDINALITY' => '0..N',
                                         '__DOCUMENTATION' => 'Association to annotations for subsequences.  Corresponds to the GenBank Frame Table.',
                                         '__NAME' => 'seqFeatures',
                                         '__ORDERED' => 0,
                                         '__CLASS_NAME' => 'SeqFeature'
                                       }, 'Bio::MAGE::Association::End' ),
                   '__SELF' => bless( {
                                        '__IS_REF' => 0,
                                        '__RANK' => undef,
                                        '__CARDINALITY' => '1',
                                        '__DOCUMENTATION' => 'Association to annotations for subsequences.  Corresponds to the GenBank Frame Table.',
                                        '__NAME' => undef,
                                        '__ORDERED' => undef,
                                        '__CLASS_NAME' => 'BioSequence'
                                      }, 'Bio::MAGE::Association::End' )
                 }, 'Bio::MAGE::Association' )
        ]

}

=head2 ASSOCIATIONS

Associations are references to other class objects which can be shared
by multiple class instances at the same time. In the Perl
implementation of MAGE-OM classes, associations are implemented using
three separate methods:

=over

=item get*

Retrieves the current value. If the association has list cardinality,
an array reference is returned.

=item set*

Sets the current value B<replacing> any existing value. If the
association has list cardinality, the argument must be an array
reference. Unless you know what you are doing, you probably should be
using the add* methods.

=item add*

This method exists only for associations with list cardinality. It
appends a list of objects to any values that may already be stored in
the association.

=back

Bio::MAGE::BioSequence::BioSequence: has the following association accessor methods:

=over


=item seqFeatures


From the MAGE-OM documentation for the C<seqFeatures> association:

Association to annotations for subsequences.  Corresponds to the GenBank Frame Table.



=over


=item $array_ref = $biosequence->setSeqFeatures($array_ref)

The restricted setter method for the seqFeatures association.

Input parameters: the value to which the seqFeatures association will be set : a reference to an array of objects of type C<Bio::MAGE::BioSequence::SeqFeature>

Return value: the current value of the seqFeatures association : a reference to an array of objects of type C<Bio::MAGE::BioSequence::SeqFeature>

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified, or
if too many input parameters are specified , or if $array_ref is not a reference to an array class C<Bio::MAGE::BioSequence::SeqFeature> instances

=cut

sub setSeqFeatures {
  my $self = shift;
  croak(__PACKAGE__ . "::setSeqFeatures: no arguments passed to setter")
    unless @_;
  croak(__PACKAGE__ . "::setSeqFeatures: too many arguments passed to setter")
    if @_ > 1;
  my $val = shift;
    croak(__PACKAGE__ . "::setSeqFeatures: expected array reference, got $self")
    unless UNIVERSAL::isa($val,'ARRAY');
  foreach my $val (@{$val}) {
    croak(__PACKAGE__ . "::setSeqFeatures: wrong type: " . ref($val) . " expected Bio::MAGE::BioSequence::SeqFeature")
      unless UNIVERSAL::isa($val,'Bio::MAGE::BioSequence::SeqFeature');
  }

  return $self->{__SEQFEATURES} = $val;
}



=item $array_ref = $biosequence->getSeqFeatures()

The restricted getter method for the seqFeatures association.

Input parameters: none

Return value: the current value of the seqFeatures association : a reference to an array of objects of type C<Bio::MAGE::BioSequence::SeqFeature>

Side effects: none

Exceptions: will call C<croak()> if any input parameters are specified

=cut

sub getSeqFeatures {
  my $self = shift;
  croak(__PACKAGE__ . "::getSeqFeatures: arguments passed to getter")
    if @_;
  return $self->{__SEQFEATURES};
}



=item $biosequence->addSeqFeatures(@vals)

Because the seqFeatures association has list cardinality, it may store more
than one value. This method adds the current list of objects in the seqFeatures
association.

Input parameters: the list of values C<@vals> to add to the seqFeatures
association. B<NOTE>: submitting a single value is permitted.

Return value: none

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified
, or if any of the objects in @vals is not an instance of class C<Bio::MAGE::BioSequence::SeqFeature>

=cut

sub addSeqFeatures {
  my $self = shift;
  croak(__PACKAGE__ . "::addSeqFeatures: no arguments passed to setter")
    unless @_;
  my @vals = @_;
    foreach my $val (@vals) {
    croak(__PACKAGE__ . "::addSeqFeatures: wrong type: " . ref($val) . " expected Bio::MAGE::BioSequence::SeqFeature")
      unless UNIVERSAL::isa($val,'Bio::MAGE::BioSequence::SeqFeature');
  }

  push(@{$self->{__SEQFEATURES}},@vals);
}



=back


=item polymerType


From the MAGE-OM documentation for the C<polymerType> association:

A choice of protein, RNA, or DNA.



=over


=item $val = $biosequence->setPolymerType($val)

The restricted setter method for the polymerType association.

Input parameters: the value to which the polymerType association will be set : an instance of type C<Bio::MAGE::Description::OntologyEntry>.

Return value: the current value of the polymerType association : an instance of type C<Bio::MAGE::Description::OntologyEntry>.

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified, or
if too many input parameters are specified , or if $val is not an instance of class C<Bio::MAGE::Description::OntologyEntry>

=cut

sub setPolymerType {
  my $self = shift;
  croak(__PACKAGE__ . "::setPolymerType: no arguments passed to setter")
    unless @_;
  croak(__PACKAGE__ . "::setPolymerType: too many arguments passed to setter")
    if @_ > 1;
  my $val = shift;
  croak(__PACKAGE__ . "::setPolymerType: wrong type: " . ref($val) . " expected Bio::MAGE::Description::OntologyEntry") unless UNIVERSAL::isa($val,'Bio::MAGE::Description::OntologyEntry');
  return $self->{__POLYMERTYPE} = $val;
}



=item $val = $biosequence->getPolymerType()

The restricted getter method for the polymerType association.

Input parameters: none

Return value: the current value of the polymerType association : an instance of type C<Bio::MAGE::Description::OntologyEntry>.

Side effects: none

Exceptions: will call C<croak()> if any input parameters are specified

=cut

sub getPolymerType {
  my $self = shift;
  croak(__PACKAGE__ . "::getPolymerType: arguments passed to getter")
    if @_;
  return $self->{__POLYMERTYPE};
}




=back


=item type


From the MAGE-OM documentation for the C<type> association:

The type of biosequence, i.e. gene, exon, UniGene cluster, fragment, BAC, EST, etc.



=over


=item $val = $biosequence->setType($val)

The restricted setter method for the type association.

Input parameters: the value to which the type association will be set : an instance of type C<Bio::MAGE::Description::OntologyEntry>.

Return value: the current value of the type association : an instance of type C<Bio::MAGE::Description::OntologyEntry>.

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified, or
if too many input parameters are specified , or if $val is not an instance of class C<Bio::MAGE::Description::OntologyEntry>

=cut

sub setType {
  my $self = shift;
  croak(__PACKAGE__ . "::setType: no arguments passed to setter")
    unless @_;
  croak(__PACKAGE__ . "::setType: too many arguments passed to setter")
    if @_ > 1;
  my $val = shift;
  croak(__PACKAGE__ . "::setType: wrong type: " . ref($val) . " expected Bio::MAGE::Description::OntologyEntry") unless UNIVERSAL::isa($val,'Bio::MAGE::Description::OntologyEntry');
  return $self->{__TYPE} = $val;
}



=item $val = $biosequence->getType()

The restricted getter method for the type association.

Input parameters: none

Return value: the current value of the type association : an instance of type C<Bio::MAGE::Description::OntologyEntry>.

Side effects: none

Exceptions: will call C<croak()> if any input parameters are specified

=cut

sub getType {
  my $self = shift;
  croak(__PACKAGE__ . "::getType: arguments passed to getter")
    if @_;
  return $self->{__TYPE};
}




=back


=item species


From the MAGE-OM documentation for the C<species> association:

The organism from which this sequence was obtained.



=over


=item $val = $biosequence->setSpecies($val)

The restricted setter method for the species association.

Input parameters: the value to which the species association will be set : an instance of type C<Bio::MAGE::Description::OntologyEntry>.

Return value: the current value of the species association : an instance of type C<Bio::MAGE::Description::OntologyEntry>.

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified, or
if too many input parameters are specified , or if $val is not an instance of class C<Bio::MAGE::Description::OntologyEntry>

=cut

sub setSpecies {
  my $self = shift;
  croak(__PACKAGE__ . "::setSpecies: no arguments passed to setter")
    unless @_;
  croak(__PACKAGE__ . "::setSpecies: too many arguments passed to setter")
    if @_ > 1;
  my $val = shift;
  croak(__PACKAGE__ . "::setSpecies: wrong type: " . ref($val) . " expected Bio::MAGE::Description::OntologyEntry") unless UNIVERSAL::isa($val,'Bio::MAGE::Description::OntologyEntry');
  return $self->{__SPECIES} = $val;
}



=item $val = $biosequence->getSpecies()

The restricted getter method for the species association.

Input parameters: none

Return value: the current value of the species association : an instance of type C<Bio::MAGE::Description::OntologyEntry>.

Side effects: none

Exceptions: will call C<croak()> if any input parameters are specified

=cut

sub getSpecies {
  my $self = shift;
  croak(__PACKAGE__ . "::getSpecies: arguments passed to getter")
    if @_;
  return $self->{__SPECIES};
}




=back


=item ontologyEntries


From the MAGE-OM documentation for the C<ontologyEntries> association:

Ontology entries referring to common values associated with BioSequences, such as gene names, go ids, etc.



=over


=item $array_ref = $biosequence->setOntologyEntries($array_ref)

The restricted setter method for the ontologyEntries association.

Input parameters: the value to which the ontologyEntries association will be set : a reference to an array of objects of type C<Bio::MAGE::Description::OntologyEntry>

Return value: the current value of the ontologyEntries association : a reference to an array of objects of type C<Bio::MAGE::Description::OntologyEntry>

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified, or
if too many input parameters are specified , or if $array_ref is not a reference to an array class C<Bio::MAGE::Description::OntologyEntry> instances

=cut

sub setOntologyEntries {
  my $self = shift;
  croak(__PACKAGE__ . "::setOntologyEntries: no arguments passed to setter")
    unless @_;
  croak(__PACKAGE__ . "::setOntologyEntries: too many arguments passed to setter")
    if @_ > 1;
  my $val = shift;
    croak(__PACKAGE__ . "::setOntologyEntries: expected array reference, got $self")
    unless UNIVERSAL::isa($val,'ARRAY');
  foreach my $val (@{$val}) {
    croak(__PACKAGE__ . "::setOntologyEntries: wrong type: " . ref($val) . " expected Bio::MAGE::Description::OntologyEntry")
      unless UNIVERSAL::isa($val,'Bio::MAGE::Description::OntologyEntry');
  }

  return $self->{__ONTOLOGYENTRIES} = $val;
}



=item $array_ref = $biosequence->getOntologyEntries()

The restricted getter method for the ontologyEntries association.

Input parameters: none

Return value: the current value of the ontologyEntries association : a reference to an array of objects of type C<Bio::MAGE::Description::OntologyEntry>

Side effects: none

Exceptions: will call C<croak()> if any input parameters are specified

=cut

sub getOntologyEntries {
  my $self = shift;
  croak(__PACKAGE__ . "::getOntologyEntries: arguments passed to getter")
    if @_;
  return $self->{__ONTOLOGYENTRIES};
}



=item $biosequence->addOntologyEntries(@vals)

Because the ontologyEntries association has list cardinality, it may store more
than one value. This method adds the current list of objects in the ontologyEntries
association.

Input parameters: the list of values C<@vals> to add to the ontologyEntries
association. B<NOTE>: submitting a single value is permitted.

Return value: none

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified
, or if any of the objects in @vals is not an instance of class C<Bio::MAGE::Description::OntologyEntry>

=cut

sub addOntologyEntries {
  my $self = shift;
  croak(__PACKAGE__ . "::addOntologyEntries: no arguments passed to setter")
    unless @_;
  my @vals = @_;
    foreach my $val (@vals) {
    croak(__PACKAGE__ . "::addOntologyEntries: wrong type: " . ref($val) . " expected Bio::MAGE::Description::OntologyEntry")
      unless UNIVERSAL::isa($val,'Bio::MAGE::Description::OntologyEntry');
  }

  push(@{$self->{__ONTOLOGYENTRIES}},@vals);
}



=back


=item sequenceDatabases


From the MAGE-OM documentation for the C<sequenceDatabases> association:

References an entry in a species database, like GenBank, UniGene, etc.



=over


=item $array_ref = $biosequence->setSequenceDatabases($array_ref)

The restricted setter method for the sequenceDatabases association.

Input parameters: the value to which the sequenceDatabases association will be set : a reference to an array of objects of type C<Bio::MAGE::Description::DatabaseEntry>

Return value: the current value of the sequenceDatabases association : a reference to an array of objects of type C<Bio::MAGE::Description::DatabaseEntry>

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified, or
if too many input parameters are specified , or if $array_ref is not a reference to an array class C<Bio::MAGE::Description::DatabaseEntry> instances

=cut

sub setSequenceDatabases {
  my $self = shift;
  croak(__PACKAGE__ . "::setSequenceDatabases: no arguments passed to setter")
    unless @_;
  croak(__PACKAGE__ . "::setSequenceDatabases: too many arguments passed to setter")
    if @_ > 1;
  my $val = shift;
    croak(__PACKAGE__ . "::setSequenceDatabases: expected array reference, got $self")
    unless UNIVERSAL::isa($val,'ARRAY');
  foreach my $val (@{$val}) {
    croak(__PACKAGE__ . "::setSequenceDatabases: wrong type: " . ref($val) . " expected Bio::MAGE::Description::DatabaseEntry")
      unless UNIVERSAL::isa($val,'Bio::MAGE::Description::DatabaseEntry');
  }

  return $self->{__SEQUENCEDATABASES} = $val;
}



=item $array_ref = $biosequence->getSequenceDatabases()

The restricted getter method for the sequenceDatabases association.

Input parameters: none

Return value: the current value of the sequenceDatabases association : a reference to an array of objects of type C<Bio::MAGE::Description::DatabaseEntry>

Side effects: none

Exceptions: will call C<croak()> if any input parameters are specified

=cut

sub getSequenceDatabases {
  my $self = shift;
  croak(__PACKAGE__ . "::getSequenceDatabases: arguments passed to getter")
    if @_;
  return $self->{__SEQUENCEDATABASES};
}



=item $biosequence->addSequenceDatabases(@vals)

Because the sequenceDatabases association has list cardinality, it may store more
than one value. This method adds the current list of objects in the sequenceDatabases
association.

Input parameters: the list of values C<@vals> to add to the sequenceDatabases
association. B<NOTE>: submitting a single value is permitted.

Return value: none

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified
, or if any of the objects in @vals is not an instance of class C<Bio::MAGE::Description::DatabaseEntry>

=cut

sub addSequenceDatabases {
  my $self = shift;
  croak(__PACKAGE__ . "::addSequenceDatabases: no arguments passed to setter")
    unless @_;
  my @vals = @_;
    foreach my $val (@vals) {
    croak(__PACKAGE__ . "::addSequenceDatabases: wrong type: " . ref($val) . " expected Bio::MAGE::Description::DatabaseEntry")
      unless UNIVERSAL::isa($val,'Bio::MAGE::Description::DatabaseEntry');
  }

  push(@{$self->{__SEQUENCEDATABASES}},@vals);
}



=back

Associations Inherited from Bio::MAGE::Describable


=item security


From the MAGE-OM documentation for the C<security> association:

Information on the security for the instance of the class.



=over


=item $val = $describable->setSecurity($val)

The restricted setter method for the security association.

Input parameters: the value to which the security association will be set : an instance of type C<Bio::MAGE::AuditAndSecurity::Security>.

Return value: the current value of the security association : an instance of type C<Bio::MAGE::AuditAndSecurity::Security>.

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified, or
if too many input parameters are specified , or if $val is not an instance of class C<Bio::MAGE::AuditAndSecurity::Security>

=cut


=item $val = $describable->getSecurity()

The restricted getter method for the security association.

Input parameters: none

Return value: the current value of the security association : an instance of type C<Bio::MAGE::AuditAndSecurity::Security>.

Side effects: none

Exceptions: will call C<croak()> if any input parameters are specified

=cut



=back


=item auditTrail


From the MAGE-OM documentation for the C<auditTrail> association:

A list of Audit instances that track changes to the instance of Describable.



=over


=item $array_ref = $describable->setAuditTrail($array_ref)

The restricted setter method for the auditTrail association.

Input parameters: the value to which the auditTrail association will be set : a reference to an array of objects of type C<Bio::MAGE::AuditAndSecurity::Audit>

Return value: the current value of the auditTrail association : a reference to an array of objects of type C<Bio::MAGE::AuditAndSecurity::Audit>

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified, or
if too many input parameters are specified , or if $array_ref is not a reference to an array class C<Bio::MAGE::AuditAndSecurity::Audit> instances

=cut


=item $array_ref = $describable->getAuditTrail()

The restricted getter method for the auditTrail association.

Input parameters: none

Return value: the current value of the auditTrail association : a reference to an array of objects of type C<Bio::MAGE::AuditAndSecurity::Audit>

Side effects: none

Exceptions: will call C<croak()> if any input parameters are specified

=cut


=item $describable->addAuditTrail(@vals)

Because the auditTrail association has list cardinality, it may store more
than one value. This method adds the current list of objects in the auditTrail
association.

Input parameters: the list of values C<@vals> to add to the auditTrail
association. B<NOTE>: submitting a single value is permitted.

Return value: none

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified
, or if any of the objects in @vals is not an instance of class C<Bio::MAGE::AuditAndSecurity::Audit>

=cut



=back


=item descriptions


From the MAGE-OM documentation for the C<descriptions> association:

Free hand text descriptions.  Makes available the associations of Description to an instance of Describable.



=over


=item $array_ref = $describable->setDescriptions($array_ref)

The restricted setter method for the descriptions association.

Input parameters: the value to which the descriptions association will be set : a reference to an array of objects of type C<Bio::MAGE::Description::Description>

Return value: the current value of the descriptions association : a reference to an array of objects of type C<Bio::MAGE::Description::Description>

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified, or
if too many input parameters are specified , or if $array_ref is not a reference to an array class C<Bio::MAGE::Description::Description> instances

=cut


=item $array_ref = $describable->getDescriptions()

The restricted getter method for the descriptions association.

Input parameters: none

Return value: the current value of the descriptions association : a reference to an array of objects of type C<Bio::MAGE::Description::Description>

Side effects: none

Exceptions: will call C<croak()> if any input parameters are specified

=cut


=item $describable->addDescriptions(@vals)

Because the descriptions association has list cardinality, it may store more
than one value. This method adds the current list of objects in the descriptions
association.

Input parameters: the list of values C<@vals> to add to the descriptions
association. B<NOTE>: submitting a single value is permitted.

Return value: none

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified
, or if any of the objects in @vals is not an instance of class C<Bio::MAGE::Description::Description>

=cut



=back

Associations Inherited from Bio::MAGE::Extendable


=item propertySets


From the MAGE-OM documentation for the C<propertySets> association:

Allows specification of name/value pairs.  Meant to primarily help in-house, pipeline processing of instances by providing a place for values that aren't part of the specification proper.



=over


=item $array_ref = $extendable->setPropertySets($array_ref)

The restricted setter method for the propertySets association.

Input parameters: the value to which the propertySets association will be set : a reference to an array of objects of type C<Bio::MAGE::NameValueType>

Return value: the current value of the propertySets association : a reference to an array of objects of type C<Bio::MAGE::NameValueType>

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified, or
if too many input parameters are specified , or if $array_ref is not a reference to an array class C<Bio::MAGE::NameValueType> instances

=cut


=item $array_ref = $extendable->getPropertySets()

The restricted getter method for the propertySets association.

Input parameters: none

Return value: the current value of the propertySets association : a reference to an array of objects of type C<Bio::MAGE::NameValueType>

Side effects: none

Exceptions: will call C<croak()> if any input parameters are specified

=cut


=item $extendable->addPropertySets(@vals)

Because the propertySets association has list cardinality, it may store more
than one value. This method adds the current list of objects in the propertySets
association.

Input parameters: the list of values C<@vals> to add to the propertySets
association. B<NOTE>: submitting a single value is permitted.

Return value: none

Side effects: none

Exceptions: will call C<croak()> if no input parameters are specified
, or if any of the objects in @vals is not an instance of class C<Bio::MAGE::NameValueType>

=cut



=back



=back


=cut



sub initialize {
  my $self = shift;
  return 1;
}



=head1 BUGS

Please send bug reports to mged-mage@lists.sf.net

=head1 AUTHOR

Jason E. Stewart (www.openinformatics.com)

=head1 SEE ALSO

perl(1).

=cut

#
# End the module by returning a true value
#
1;

