# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl old.t'

use Test::More tests => 2493;

BEGIN { use_ok('Business::KontoCheck') };

$ok_cnt=$nok_cnt=0;
# initialization with init level set to 0 is sufficient for these tests (should work always)
$retval=lut_init("blz.lut",0);
$ret_txt=$kto_retval{$retval};
if($retval>0){$ok_cnt++;}else{$nok_cnt++;}
ok($retval gt 0,"init: $retval => $ret_txt (ok: $ok_cnt, nok: $nok_cnt)");

if($retval>0){
   while(<DATA>){
      chomp;
      ($ret,$blz,$kto)=split(/ /);
      $retval=kto_check($blz,$kto,"blz.lut");
      $ret_txt=$kto_retval{$retval};
      if($retval==$ret){$ok_cnt++;}else{$nok_cnt++;}
      ok($retval eq $ret,"BLZ/KTO (alt) $blz $kto: $retval (Soll: $ret) => $ret_txt (ok: $ok_cnt, nok: $nok_cnt)");
   }
}

__DATA__
1 00 1501824
1 00 1501832
1 00 539290858
1 00 9290701
1 06 5073321010
1 06 94012341
1 10 12345008
1 10 87654008
1 17 0446786040
1 19 0200520016
1 19 0240334000
1 24 1306118605
1 24 0000138301
1 24 3307118608
1 24 9307118603
1 25 521382181
1 26 0005501024
1 26 0520309001
1 26 1111118111
1 27 2847169488
1 28 19999000
1 28 9130000201
1 29 3145863029
1 31 1000000524
1 31 1000000583
1 32 0121114867
1 32 0122116979
1 32 1709107983
1 32 9030101192
1 32 9141405
1 32 9245500460
1 33 48658
1 33 84956
1 34 9913000700
1 34 9914001000
1 35 0000101599
1 35 0000101709
1 35 0000102349
1 35 0000102921
1 35 0000107451
1 35 0000108443
1 35 101599
1 35 108443
1 36 113178
1 36 146666
1 37 624315
1 37 632500
1 38 1100660
1 38 191919
1 39 10019400
1 39 200205
1 40 1258345
1 40 3231963
1 41 0166805317
1 41 4013410024
1 41 4016660195
1 41 4019151002
1 41 4019310079
1 41 4019340829
1 42 59498
1 42 59510
1 43 6135244
1 43 9516893476
1 44 2618040504
1 44 889006
2 45 0000012340
2 45 0100114240
2 45 0994681254
2 45 1000199999
1 45 3545343232
1 45 4013410024
1 46 0235468612
1 46 0837890901
1 46 1041447600
1 47 1003554450
1 47 1018000
1 50 4000005001
1 50 4444442001
1 51 0000156071
1 51 0000156078
1 51 0001156071
1 51 0001156136
1 51 3199500501
1 54 4900010987
1 54 4964137395
1 56 290545005
1 56 9718304037
2 57 1909700805
2 57 5001050352
2 57 5045090090
1 57 7500021766
2 57 7777778800
1 57 7800028282
1 57 8100244186
1 57 9400001734
1 58 1015222224
1 58 1800293377
1 58 1800881120
1 58 3703169668
1 58 9200654108
1 61 0260760481
1 61 2063099200
1 62 5029076701
1 63 1234566
1 63 123456600
1 64 1206473010
1 64 5016511020
1 65 1234567400
1 65 1234567590
1 66 100150502
1 66 100154508
1 66 100154516
1 66 101154508
1 66 101154516
1 68 8889654328
1 68 987654324
1 68 987654328
1 69 1234567006
1 69 1234567900
1 69 9721134869
1 71 7101234007
1 73 3503398
1 73 7899100003
1 74 239314
1 74 239319
1 76 0006543200
1 76 123456
1 76 12345600
1 76 7876543100
1 76 9012345600
1 77 10338
1 77 1234554321
1 77 13844
1 77 65354
1 77 69258
1 78 7581499
1 78 9999999981
1 79 1550167850
1 79 3230012688
1 79 4230028872
1 79 5440001898
1 79 6330001063
1 79 7000149349
1 79 8000003577
1 79 9011200140
1 80 3199500501
1 80 340966
1 80 340968
1 81 0646440
1 81 1359100
1 81 3199500501
1 82 123897
1 82 3199500501
1 83 0000156071
1 83 0000156078
1 83 0001156071
1 83 0001156136
1 83 0099100002
1 84 100005
1 84 3199500501
1 84 393814
1 84 950360
1 85 0000156071
1 85 0000156078
1 85 0001156071
1 85 0001156136
1 85 3199100002
1 86 1001171
1 86 1009588
1 86 123897
1 86 3199500501
1 86 340968
1 87 0000000406
1 87 0000051768
1 87 0000100005
1 87 0000393814
1 87 0000950360
1 87 0010701590
1 87 0010720185
1 87 3199500501
1 88 1000500
1 88 2525259
1 88 90013000
1 88 92525253
1 88 99913003
1 89 1098506
1 89 218433000
1 89 32028008
1 90 0000156071
1 90 0000156073
1 90 0000156077
1 90 0000156132
1 90 0001156132
1 90 0001156136
1 90 0099100002
1 91 2974117000
1 91 2974118000
1 91 5281741000
1 91 5281770000
1 91 9952810000
1 91 9952812000
1 93 0000127783
1 93 0000127791
1 93 0000306754
1 93 0000671479
1 93 1277830000
1 93 1277910000
1 93 3067540000
1 93 6714790000
1 94 6782533003
1 95 0068007003
1 95 0847321750
1 95 6450060494
1 95 6454000003
1 96 0000000208
1 96 0000254100
2 96 0001300000
2 96 0099399999
1 96 0101115152
1 96 0301204301
1 96 9421000009
1 97 24010019
1 98 3009800016
1 98 5989800173
1 98 6719430018
1 98 9619319999
1 98 9619439213
1 98 9619509976
1 98 9619608118
1 99 0068007003
1 99 0847321750
1 a0 18761
1 a0 28290
1 a0 3287
1 a0 521003287
1 a0 54500
1 a1 0010030005
1 a1 0010030997
1 a1 1010030054
1 a21 3456789019
1 a21 5678901231
1 a21 6789012348
1 a22 3456789012
1 a31 1234567897
1 a31 0123456782
1 a32 9876543210
1 a32 1234567890
1 a32 0123456789
1 a41 0004711173
1 a41 0007093330
1 a42 0004711172
1 a42 0007093335
1 a43 1199503010
1 a43 8499421235
1 a44 9058440000
1 a44 0000905844
1 a44 5030101099
1 a45 8623420000
1 a45 0000862342
1 a51 9941510001
1 a51 9961230019
1 a51 9380027210
1 a51 9932290910
1 a52 0000251437
1 a52 0007948344
1 a52 0000159590
1 a52 0000051640
1 a61 800048548
1 a61 0855000014
1 a62 17
1 a62 55300030
1 a62 150178033
1 a62 600003555
1 a62 900291823
1 a71 19010008
1 a71 19010438
1 a72 19010660
1 a72 19010876
1 a72 209010892
1 a81 7436661
1 a81 7436670
1 a81 1359100
1 a82 7436660
1 a82 7436678
1 a82 0003503398
1 a82 0001340967
1 a83 0199100002
1 a83 0099100010
1 a83 2599100002
1 a84 0199100004
1 a84 2599100003
1 a84 3199204090
1 a91 5043608
1 a91 86725
1 a92 504360
1 a92 822035
1 a92 32577083
1 b0 1000000406
1 b0 1035791538
1 b0 1126939724
1 b0 1197423460
1 b11 1434253150
1 b11 2746315471
1 b12 7414398260
1 b12 8347251693
1 b21 0020012357
1 b21 0080012345
1 b21 0926801910
1 b21 1002345674
1 b22 8000990054
1 b22 9000481805
1 b31 1000000060
1 b31 0000000140
1 b31 0000000019
1 b31 1002798417
1 b31 8409915001
1 b32 9635000101
1 b32 9730200100
1 b41 9941510001
1 b41 9961230019
1 b41 9380027210
1 b41 9932290910
1 b42 0000251437
1 b42 0007948344
1 b42 0000051640
1 b51 0159006955
1 b51 2000123451
1 b51 1151043216
1 b51 9000939033
1 b52 0123456782
1 b52 0130098767
1 b52 1045000252 
1 B61 9110000000
1 B71 0700001529
1 B71 0730000019
1 B71 0001001008
1 B71 0001057887
1 B71 0001007222
1 B71 0810011825
1 B71 0800107653
1 B71 0005922372
1 B81 0734192657
1 B81 6932875274
1 B82 3145863029
1 B82 2938692523
1 B91 87920182
1 B91 87920187
1 B91 87920187
1 B91 41203755
1 B91 81069577
1 B91 61287958
1 B91 58467232
1 B92 7125633
1 B92 1253657
1 B92 4353631
1 C02 0082335729
1 C02 0734192657
1 C02 6932875274
1 C11 0446786040
1 C11 0478046940
1 C11 0701625830
1 C11 0701625840
1 C11 0882095630
1 C12 5432112349
1 C12 5543223456
1 C12 5654334563
1 C12 5765445670
1 C12 5876556788
1 C21 2394871426
1 C21 4218461950
1 C21 7352569148
1 C22 5127485166
1 C22 8738142564
1 c31 9294182
1 c31 4431276
1 c31 19919
1 c32 9000420530
1 c32 9000010006
1 c32 9000577650
1 c41 0000000019
1 c41 0000292932
1 c41 0000094455
1 c42 9000420530
1 c42 9000010006
1 c42 9000577650
-3 a1 0110030005
0 a1 0010030998
-3 a1 0000030005
0 a21 3456789012
0 a21 1234567890
0 a22 1234567890
0 a22 0123456789
0 a31 9876543210
0 a31 1234567890
0 a31 6543217890
0 a31 0543216789
0 a32 6543217890
0 a32 0543216789
0 a41 0004711172
0 a41 8623420004
0 a42 8623420000
0 a42 0001123458
0 a43 1299503117
0 a43 6099702031
0 a44 3994430000
0 a44 0000399443
0 a44 5533130000
0 a44 0000553313
0 a51 9941510002
0 a51 9961230020
0 a52 0000251438
0 a52 0007948345
0 a61 860000817
0 a61 810033652
0 a62 305888
0 a62 200071280
0 a71 19010660
0 a71 19010876
0 a71 209010892
0 a71 209010893
0 a72 209010893
0 a81 7436660
0 a81 7436678
0 a82 7436666
0 a82 7436677
0 a82 7436666
0 a82 7436677
0 a83 0199100004
0 a83 2599100003
0 a83 0099345678
0 a84 0099345678
0 a84 0099100110
0 a84 0199100040
0 a91 504360
0 a91 822035
0 a91 32577083
0 a91 86724
0 a92 86724
0 a92 292497
0 a92 30767208
0 b0 1000000405
0 b0 1035791539
-3 b0 8035791532
-3 b0 535791830
-3 b0 51234901
0 b11 7414398260
0 b11 8347251693
0 b11 0123456789
0 b11 2345678901
0 b11 5678901234
0 b12 0123456789
0 b12 2345678901
0 b12 5678901234
-3 b21 0020012399
0 b21 0080012347
-3 b21 0080012370
0 b21 0932100027
0 b21 3310123454
0 b22 8000990057
0 b22 8011000126
0 b22 9000481800
0 b22 9980480111
0 b31 0002799899
0 b31 1000000111
0 b32 9635100101
0 b32 9730300100
0 b41 9941510002
0 b41 9961230020
0 b42 0000251438
0 b42 0007948345
-3 b42 0000159590
0 b51 7414398260
0 b51 8347251693
0 b51 1151043211
0 b51 2345678901
0 b51 5678901234
0 b51 9000293707
0 b52 0159004165
0 b52 0023456787
0 b52 0056789018
0 b52 3045000333
0 B61 9111000000
0 B71 0001057886
0 B71 0003815570
0 B71 0005620516
0 B71 0740912243
0 B71 0893524479
0 B81 3145863029
0 B81 2938692523
0 B81 0132572975
0 B82 0132572975
0 B91 88034023
0 B91 43025432
0 B91 86521362
0 B91 61256523
0 B91 54352684
0 B92 2356412
0 B92 5435886
0 B92 9435414
0 C02 0132572975
0 C02 3038752371
0 C11 0446786240
0 C11 0478046340
0 C11 0701625730
0 C11 0701625440
0 C11 0882095130
0 C12 5432112341
0 C12 5543223458
0 C12 5654334565
0 C12 5765445672
0 C12 5876556780
0 C21 5127485166
0 C21 8738142564
0 C21 0328705282
0 C21 9024675131
0 C22 0328705282
0 C22 9024675131
0 c31 17002
0 c31 123451
0 c31 122448
0 c32 9000726558
0 c32 9001733457
0 c32 9000732000
0 c4a 0000000017
0 c4a 0000292933
0 c4a 0000094459
0 c4b 9000726558
0 c4b 9001733457
0 c4b 9000732000
1 c5 0000301168
1 c5 0000302554
1 c5 0300020050
1 c5 0300566000
1 c5 1000061378
1 c5 1000061412
1 c5 4450164064
1 c5 4863476104
1 c5 5000000028
1 c5 5000000391
1 c5 6450008149
1 c5 6800001016
1 c5 9000100012
1 c5 9000210017
1 c5 3060188103
1 c5 3070402023
2 c5 0030001230
2 c5 0040230000
2 c5 0050044000
2 c5 0059999999
2 c5 7000000000
2 c5 7023445000
2 c5 7000334560
2 c5 7099999999
2 c5 8500000000
2 c5 8502334450
2 c5 8599999999
1 c51 0000301168
1 c51 0000302554
1 c51 0300020050
1 c51 0300566000
1 c52 1000061378
1 c52 1000061412
1 c52 4450164064
1 c52 4863476104
1 c52 5000000028
1 c52 5000000391
1 c52 6450008149
1 c52 6800001016
1 c52 9000100012
1 c52 9000210017
1 c53 3060188103
1 c53 3070402023
1 C6 0000065516
1 C6 0203178249
1 C6 1031405209
1 C6 1082012201
1 C6 2003455189
1 C6 2004001016
1 C6 3110150986
1 C6 3068459207
1 C6 4012660028
1 C6 4100235626
1 C6 5035105948
1 C6 5286102149
1 C6 6028426119
1 C6 6861001755
1 C6 7008199027
1 C6 7002000023
1 C6 8526080015
1 C6 8711072264
1 C6 9000430223
1 C6 9000781153
1 c73 3500022
1 c71 38150900
1 c71 600103660
1 c71 39101181
1 c72 94012341
1 c72 5073321010
1 c7 3500022
1 c7 38150900
1 c7 600103660
1 c7 39101181
1 c72 94012341
1 c72 5073321010
1 C72 94012341
1 C72 5073321010
1 C81 3456789019
1 C81 5678901231
1 C82 3456789012
1 C83 0123456789
1 C91 3456789019
1 C91 5678901231
1 C92 0123456789
1 D0 6100272324
1 D0 6100273479
2 D0 5724434334
2 D0 5721233334
2 D0 5723453334
0 D1 1000005016
0 D1 1000004019
0 D1 4000008014
0 D1 6100020013
-3 D1 8300042011
0 c5 0000302589
0 c5 0000507336
0 c5 0302555000
0 c5 0302589000
0 c5 1000061457
0 c5 1000061498
0 c5 4864446015
0 c5 4865038012
0 c5 5000001028
0 c5 5000001075
0 c5 6450008150
0 c5 6542812818
0 c5 9000110012
0 c5 9000300310
0 c5 3081000783
0 c5 3081308871
0 c51 0000302589
0 c51 0000507336
0 c51 0302555000
0 c51 0302589000
0 c52 1000061457
0 c52 1000061498
0 c52 4864446015
0 c52 4865038012
0 c52 5000001028
0 c52 5000001075
0 c52 6450008150
0 c52 6542812818
0 c52 9000110012
0 c52 9000300310
0 c53 3081000783
0 c53 3081308871
0 C6 0525111212
0 C6 0091423614
0 C6 1082311275
0 C6 1000118821
0 C6 2004306518
0 C6 2016001206
0 C6 3462816371
0 C6 3622548632
0 C6 4232300158
0 C6 4000456126
0 C6 5002684526
0 C6 5564123850
0 C6 6295473774
0 C6 6640806317
0 C6 7000062022
0 C6 7006003027
0 C6 8348300002
0 C6 8654216984
0 C6 9000641509
0 C6 9000260986
0 c71 94012341
-3 c71 5073321010
0 c72 1234517892
0 c72 987614325
0 C81 3456789012
0 C81 0123456789
0 C81 1234567890
0 C81 9012345678
0 C82 0123456789
0 C82 1234567890
0 C82 9012345678
0 C82 0123456789
-3 C83 1234567890
0 C83 9012345678
0 C91 3456789012
0 C91 0123456789
0 C91 1234567890
0 C91 9012345678
-3 C92 1234567890
0 C92 9012345678
0 D0 6100272885
0 D0 6100273377
0 D0 6100274012
1 D21 189912137
1 D21 235308215
1 D22 4455667784
1 D22 1234567897
1 D23 51181008
1 D23 71214205
0 D21 4455667784
0 D21 1234567897
0 D21 51181008
0 D21 71214205
0 D21 6414241
0 D21 179751314
0 D22 51181008
0 D22 71214205
0 D22 6414241
0 D22 179751314
0 D23 6414241
0 D23 179751314
1 D31 1600169591
1 D31 1600189151
1 D31 1800084079
1 D32 6019937007
1 D32 6021354007
1 D32 6030642006
0 D31 1600166307
0 D31 1600176485
0 D31 1600201934
0 D32 6025017009
0 D32 6028267003
0 D32 6019835001
1 D4 3000005012
1 D4 4143406984
1 D4 5926485111
1 D4 9002364588
1 D4 1000062025
-3 D4 0006003027
0 D4 8003306026
0 D4 9916524534
0 D4 5212744564
0 D4 3000255397
1 D51 5999242133
1 D51 5999718138
1 D51 1799222116
1 D51 0099632004
1 D52 0004711173
1 D52 0007093330
1 D52 0000127787
1 D53 0004711172
1 D53 0007093335
1 D54 0004711174
1 D54 0000100062
1 D54 0000100088
0 D51 3299632008  
0 D51 1999204293  
0 D51 0399242139  
0 D52 0004711172  
0 D52 8623420004  
0 D52 0001123458  
0 D53 0001123458  
0 D54 0000100084  
0 D54 0000100085  
1 D61 3409
1 D61 585327
1 D61 1650513
1 D62 3601671056
1 D62 4402001046
1 D62 6100268241
1 D63 7001000681
1 D63 9000111105
1 D63 9001291005
0 D61 33394
0 D61 595795
0 D61 16400501
0 D62 3615071237
0 D62 6039267013
0 D62 6039316014
0 D63 7004017653
0 D63 9002720007
0 D63 9017483524
1 D7 0500018205
1 D7 0301000434
1 D7 0420001202
1 D7 0201005939
1 D7 0230103715
1 D7 0330035104
1 D7 0134637709
1 D7 0602006999
1 D8 1403414848
1 D8 6800000439
1 D8 6899999954 
2 D8 0012349954 
2 D8 0092349954 
0 D7 0501006102
0 D7 0301005331
0 D7 0420001302
0 D7 0202005939
0 D7 0231307867
0 D7 0330034104
0 D7 0135638809
0 D7 0601006977
0 D8 3012084101
0 D8 1062813622
-3 D8 0000260986
-3 D8 0500260986
1 10220500 1274149044
1 12030000 3263769782
1 10130800 5940471945
1 25010600 2977768624
1 45050001 2288183599
1 47850065 5726866900
1 55350010 2438345181
1 30030500 3880596634
1 52050353 3016209847
1 10060198 7752585797
1 10090000 5439402743
1 70220800 5142570618
1 70220800 1780466242
1 30022000 5411925745
1 30025500 8129326651
2 30050000 5023
2 40022000 2223
2 40050000 48121
1 44050000 69989
2 10000000 1369645762
2 10010424 5274638157
1 12030900 3870204737
1 20030133 7009109478
1 51420200 4591157792
1 74350000 4379111449
1 10040000 790666201
1 10040005 43165842
1 10040048 60058263
1 10030700 9155353713
1 20120700 8329612121
1 10110600 8384260957
1 51420300 8507351863
1 29020100 3058491657
1 30120500 1808803475
1 10220600 6233660482
1 20030600 7215368308
1 13050000 8887687170
1 14051000 7861663811
1 26851620 8160276174
1 26851620 6574029843
1 72020700 4073657056
1 72020700 8066825482
1 72020700 3287300649
1 72020700 5503507671
1 72020700 8211213008
1 72020700 2821117401
1 72020700 2468425693
1 72020700 4958926546
1 72020700 8668736168
1 72020700 9092137229
1 72020700 5043743531
1 72020700 7427654024
1 72020700 9628555714
1 72020700 6099661326
1 72020700 7271565219
1 72020700 1358073898
1 72020700 8167777299
1 72020700 3153886014
1 72020700 4545389988
1 72020700 7593996798
1 72020700 5180090203
1 10010010 1586469859
1 20010020 1506934031
1 25010030 2288024970
1 36010043 2356984919
1 37010050 7133566670
1 37011000 7460160387
1 44010046 8935611205
1 50010060 8358635829
1 54510067 3811016704
1 59010066 3351375618
1 60010070 4231294119
1 66010075 4771490946
1 70010080 5121247204
1 76010085 5151612747
1 86010090 6021481204
1 10010010 6701628690
1 10010010 3412279425
1 20010020 3032715294
1 25010030 4752407036
1 36010043 4482666117
1 37010050 5012881000
1 37011000 5212452495
1 44010046 6832598476
1 50010060 6232413482
1 54510067 3213246624
1 59010066 3153194570
1 60010070 4773514098
1 66010075 4443339439
1 70010080 5713352667
1 76010085 5223595496
1 86010090 6863404157
1 10010010 6553976675
1 10010010 3235083895
1 20010020 3345310512
1 25010030 4455091671
1 36010043 4375854027
1 37010050 5205215340
1 37011000 5765859983
1 44010046 6435671151
1 50010060 6085109618
1 54510067 3796971140
1 59010066 3296318867
1 60010070 4876208878
1 66010075 4026634781
1 70010080 5876035557
1 76010085 5816212305
1 86010090 6506158250
1 10010010 3177769140
1 10010010 3947428710
1 20010020 4997050011
1 25010030 4057260919
1 36010043 5967194177
1 37010050 6377183129
1 37011000 6967485690
1 44010046 3928830382
1 50010060 3118760552
1 54510067 4878840089
1 59010066 4548269248
1 60010070 5758572627
1 66010075 5068943135
1 70010080 6008349998
1 76010085 6718850165
1 86010090 3779803093
1 10010010 3829980978
1 10010010 4519819758
1 20010020 4349223118
1 25010030 5649850187
1 36010043 5409951411
1 37010050 6689741249
1 37011000 6969023188
1 44010046 9211179496
1 50010060 9901472501
1 54510067 9442950879
1 59010066 9833562340
1 60010070 9734462223
1 66010075 9514455251
1 70010080 9935833852
1 76010085 9715495586
1 86010090 9606861582
1 10010010 9066955249
1 10010010 9947020460
1 20010020 9677375489
1 25010030 9398018039
1 36010043 9078902155
1 37010050 9569531053
1 42050001 955387400
2 25055500 28742169
1 72012300 85503847
2 25055500 5239152096
2 25055500 3430653233
1 25050000 357323229
1 59050000 815678875
1 25050000 6498824076
1 25050000 1534907877
1 16062008 7644558571
1 20069780 8486323443
1 20069782 65998343
1 29050000 4267223773
1 29050000 9196736162
1 52420600 2278977013
2 70120600 8490373506
1 50324000 9367166737
1 50324040 8645442353
1 13061008 8283881636
1 20069125 5177553999
1 20069144 9368125849
1 36060488 9962831524
1 40060265 1265445892
1 40060300 64523939
1 38621500 1498042854
1 56061151 7550434343
1 35060386 8261309010
1 25020600 5879513474
1 25020600 7429879164
1 25020600 2722994726
1 25020600 1737406635
1 66661454 7729441032
1 66661454 4478476035
1 66690000 9651587735
1 66690000 7816441896
1 30060010 1101677468
1 40060000 3278950321
2 29020000 650228826
2 29020000 870658499
2 29020000 7597150492
2 29020000 6962170738
2 29020000 6501892589
2 29020000 9955782512
1 50310400 5013936057
1 27290087 9613671767
1 20190109 5608759706
1 21092023 4210217706
1 76050101 1291701348
1 76050101 5111152459
1 76050101 3796914641
1 20090700 8706913132
1 20090745 8212341474
1 26991066 5454891
1 51220910 1941100
1 33060592 1419649473
1 36060591 6803488228
1 37060590 8000832634
1 33060592 3378462209
1 33060592 5505876887
1 36060591 6580424655
1 37060590 6950764555
1 33060592 7017939650
1 33060592 6509831073
1 36060591 8693176538
1 37060590 4690728020
1 33060592 8590041450
1 13051172 38404498
1 13051172 49402471
1 16052072 261651630
1 16052072 483566268
1 76035000 3827920604
1 30030100 6695397141
1 30020900 5309910976
2 30020900 7777774112
2 30020900 7777775271
2 30020900 8888885332
2 30020900 4003301311
2 30020900 4015111074
2 30020900 5014224799
2 30020900 5099272020
2 30020900 9138843272
2 30020900 9186271060
2 30020900 9933119450
2 30020900 9940397576
2 30020900 185125434
2 30020900 185125434
2 55050000 85911519
1 55050000 786609230
1 55050000 198909988
1 55050000 2666358557
1 55050000 1483824767
1 10020200 3096063722
1 20120200 2978843471
1 25621327 1516756294
1 26520017 3062589150
1 26521703 7207091889
1 26522319 4830674986
1 10070000 7367956
1 10070024 225226005
1 10070100 285981700
1 57090000 6786710033
1 57090000 5342288093
1 60020030 6631861943
1 66020020 4662647902
1 60020030 1245672493
1 60020030 5816728796
1 50120500 821156051
2 50120500 907189627
1 50120500 189485580
1 50120500 102422847
1 50120500 230871254
1 50120500 267467585
1 50120500 365441547
1 50120500 387381447
1 50120500 445388976
1 50120500 465269535
1 50120500 584375274
1 50120500 587854601
1 50120500 696024726
1 50120500 640665781
1 50120500 795545835
1 50120500 794597631
1 50120500 818317798
1 50120500 802025410
2 50120500 931918366
2 50120500 955496108
1 70013000 8825419828
2 20030000 464277651
2 20030000 471208247
1 20030000 9589917956
1 20030000 7309402629
1 20030000 299321
1 20030000 243394
1 20030000 5108808
1 20030000 1934827
1 20030000 40721862
1 20030000 59864884
1 20030000 714916517
1 20030000 369357827
1 20030000 483966
1 20030000 589895
1 20030000 2739987
1 20030000 8337212
1 20030000 39934596
1 20030000 39516716
1 20030000 945931650
2 20030000 436697199
2 20030000 409347365
2 20030000 482496493
1 65110200 7698981148
1 65110200 2438643901
1 50090500 5743348919
1 50090500 5275587293
1 50090500 8926281042
1 50090500 9740295360
1 50090500 8583021337
1 50090500 1871352724
1 50090500 1479940633
1 50090500 3936513565
1 50090500 8791175240
1 50090500 8995018956
1 21050170 1616440
1 21050170 38305462
1 21050170 73712663
1 21050170 752218982
1 21050170 305982712
1 21050170 4079001188
1 21050170 8976493398
1 21050170 141754
1 21050170 765263
1 21050170 463690
1 10080000 4108710
1 10080005 4694202
1 10080006 67229435
1 10080055 22054122
1 10080057 297887851
1 10080088 360355674
1 10080900 7763842508
1 12080000 54884
1 13080000 23760
1 14080000 165177
1 14080011 943678
1 15080000 4204505
1 16080000 87766063
1 17080000 71141521
1 18080000 49398284
2 36050105 97124819
2 36050105 53978125
1 36050105 7917494762
1 36050105 9686892317
1 20090500 2902689960
2 25090500 9304176707
1 70090500 5617689438
1 76090500 3923744361
1 20090500 9132576120
1 20090500 6131921649
2 25090500 8343515346
1 70090500 1843696812
1 76090500 1955158397
1 20090500 5356583784
1 20090500 9462065240
2 25090500 1163876250
1 70090500 6676240429
1 76090500 8676492231
1 20090500 7680841110
1 20090500 2480544027
2 25090500 8199876051
1 70090500 2295035605
1 72090500 2948894265
1 75090500 9940570583
1 72090500 4736691993
1 72090500 1489154385
1 75090500 4580093766
1 72090500 2990882601
1 72090500 9193567880
1 40060560 2143857239
1 40060560 4701570471
1 40060560 7733340600
1 40060560 4859256757
1 40060560 2483046802
1 40060560 9303143824
1 40060560 9699493411
1 60090800 5054614319
1 60090800 3081454990
1 60090800 465534
1 60090800 173681
1 60090800 681490
1 60090800 1573969
1 60090800 3202771
1 60090800 90459423
1 60090800 97794660
1 60090800 98597680
1 60090800 93574835
1 10030600 2687699999
1 70090100 7479597069
1 70091500 6390224710
1 70091600 6796989904
2 55090500 7306924328
2 55090500 2506486272
2 55090500 1306943053
2 55090500 2900618503
2 55090500 2908960665
2 55090500 5104753473
2 55090500 4902229946
2 55090500 2102420795
2 55090500 9905756835
2 55090500 6617311451
2 55090500 9811208438
2 55090500 7510713147
2 55090500 7117402028
2 55090500 9815572975
2 55090500 2810361910
2 55090500 5111632012
2 55090500 5517710740
2 55090500 7516038598
2 55090500 6023972437
2 55090500 7322915952
2 55090500 5327225363
2 55090500 3123277738
2 55090500 9029028313
2 55090500 5225384614
2 55090500 3124651226
2 55090500 2422947905
2 55090500 8524033168
2 55090500 7333912655
2 55090500 2837049277
2 55090500 1434570672
2 55090500 5539439614
2 55090500 6535431784
2 55090500 9633082233
2 55090500 5037770767
2 55090500 2636823798
2 55090500 2432758146
2 55090500 8147137354
2 55090500 7049422854
2 55090500 9745232564
2 55090500 4449188611
2 55090500 1640230496
2 55090500 2842643250
2 55090500 6848062656
2 55090500 6744756802
2 55090500 1241971946
2 55090500 4840546658
2 55090500 9955646510
2 55090500 3958222534
2 55090500 4356190083
2 55090500 9759686582
2 55090500 5054169600
2 55090500 2256256554
2 55090500 1852094053
2 55090500 5650040494
2 55090500 1963408892
2 55090500 4060592579
2 55090500 2062861081
2 55090500 6967190152
2 55090500 9164941826
2 55090500 8864147176
2 55090500 7965204510
2 55090500 7463278165
2 55090500 4363556037
2 55090500 8765739617
2 55090500 7078418896
2 55090500 9571457620
2 55090500 3679524450
2 55090500 9370338292
2 55090500 6279429433
2 55090500 6673479304
2 55090500 4572239196
2 55090500 6077164294
2 55090500 9578190116
2 55090500 5283697967
2 55090500 3684722892
2 55090500 4287464503
2 55090500 8787489522
2 55090500 8187262513
2 55090500 3583173893
2 55090500 2687637051
2 55090500 7480923670
2 55090500 8388894578
2 55090500 8382387549
2 55090500 7997683140
2 55090500 7093716559
1 10090900 4030320760
1 20090900 1119656706
1 21090900 2526731068
1 25090900 3361028273
1 27090900 8459006454
1 67230000 6915892093
1 67230001 8254942449
1 10120100 2685721914
1 50110801 6910515958
2 70020270 1214884
2 70020270 1639337
2 70020270 9679962
2 70020270 9961017
2 70020270 11453733
2 70020270 14162206
2 70020270 20578661
2 70020270 20690329
2 70020270 21544578
2 70020270 21332999
2 70020270 22168977
2 70020270 22860137
2 70020270 23924697
2 70020270 23047734
2 70020270 24401083
2 70020270 24938093
2 70020270 25930772
2 70020270 25710609
2 70020270 396970881
2 70020270 396069453
2 70020270 397166625
2 70020270 397004198
2 70020270 398549886
2 70020270 398900912
2 70020270 399716997
2 70020270 399206096
2 70020270 426738198
2 70020270 437643505
2 70020270 780301829
2 70020270 797317723
2 70020270 913456694
2 70020270 912054061
2 70020270 923202040
2 70020270 925907211
2 70020270 932595232
2 70020270 936420739
2 70020270 943349102
2 70020270 941019033
2 70020270 956325260
2 70020270 952622514
2 70020270 961556379
2 70020270 965538997
2 70020270 972743992
2 70020270 978726853
2 70020270 988119332
2 70020270 984154364
1 70020270 1796262644
1 70020270 9722027091
1 50050201 8296303863
1 50050201 6129992199
1 50050201 8541521228
1 50050201 4504935661
2 50050201 1321014
2 50050201 1456579
2 50050201 1490916
2 50050201 1510021
2 50050201 1509026
2 50050201 1661699
2 50050201 1625383
2 50050201 1789130
2 50050201 1757240
2 50050201 1863301
2 50050201 1819831
2 50050201 1927109
2 50050201 1955654
2 50050201 2362594
2 50050201 2363976
2 50050201 3690760
2 50050201 3509657
2 50050201 4840309
2 50050201 4496635
2 50050201 5322391
2 50050201 5679648
2 50050201 6876768
2 50050201 6455345
2 50050201 7458874
2 50050201 7537988
2 50050201 8658520
2 50050201 8836747
2 50050201 9810185
2 50050201 9952686
2 50050201 10720109
2 50050201 10836785
2 50050201 20700285
2 50050201 30400633
2 50050201 30486324
2 50050201 40868653
2 50050201 50779165
2 50050201 50822550
2 50050201 60019936
2 50050201 60252423
2 50050201 70885429
2 50050201 70564330
2 50050201 80235214
2 50050201 80039792
2 50050201 90626934
2 50050201 90034945
2 50050201 91087128
2 50050201 91991019
2 50050201 92731809
2 50050201 92242148
2 50050201 93611569
2 50050201 93406497
2 50050201 94129516
2 50050201 94168545
2 50050201 95218438
2 50050201 95304313
2 50050201 96301623
2 50050201 96129685
2 50050201 97801523
2 50050201 97873598
2 50050201 98018474
2 50050201 98341661
1 50050201 99447541
2 50050201 99140725
2 50050201 99120652
2 50050201 99233052
2 50050201 99205669
2 50050201 99303739
2 50050201 99358300
1 74290100 9017152107
1 74290100 2409835623
1 74290100 8124999525
1 74290100 8232286513
1 10020890 9768038268
1 16020086 5959116069
1 17020086 396910824
1 18020086 396306868
1 20730023 397472831
1 30220190 397157169
1 33020190 398485795
1 36020186 398266756
1 37020090 399222728
1 38020090 399181003
1 44020090 472491581
1 48020086 429354002
1 21051275 3675449163
1 21452030 6369255689
2 21852310 2404000082
1 22150000 8396669553
1 25050180 7370583663
1 25050299 1588595072
1 60030000 2133935401
1 25050180 2431903761
1 10090603 3302558548
1 12090640 4301204149
1 20090602 4815508592
1 21090619 8922514605
1 23092620 5129329307
1 25090608 2930223000
1 26560625 2939516000
1 27090618 7349890041
1 28090633 2942015471
1 29090605 4351253140
1 30060601 4763932320
1 33060616 1066522360
1 35060632 3770937436
1 36060610 9085730163
1 37060615 5982285460
1 39060630 1460632864
1 40060614 1951661752
1 44060604 5561159577
1 50090607 5092418568
1 50890634 8063285561
1 51090636 5393741400
1 52090611 1884312503
1 53390635 1544016505
1 54690623 1385376823
1 55060831 4105537657
1 57060612 2446041558
1 59090626 2916494587
1 60090609 4547012837
1 66090621 3207401418
1 67090617 5928051194
1 68090622 2268391270
1 70090606 7318439830
1 75090629 8316915214
1 76090613 6421932402
1 77390628 4423720751
1 79090624 6436727863
1 10090603 8837987051
1 10090603 4745598110
1 12090640 7547550980
1 20090602 1654605673
1 21090619 8954265933
1 23092620 3666289935
1 25090608 8366348135
1 26560625 4176045122
1 27090618 4874935876
1 28090633 3084858681
1 29090605 2988042305
1 30060601 6601204135
1 33060616 6671467555
1 35060632 5482223933
1 36060610 2822738973
1 37060615 1083216473
1 39060630 9853948923
1 40060614 7684550175
1 44060604 9634767880
1 50090607 2835280186
1 50890634 1605163844
1 51090636 3176623245
1 52090611 1586264245
1 53390635 8897848214
1 54690623 4177616992
1 55060831 3818352292
1 57060612 4688156852
1 59090626 2999506010
1 60090609 5099680125
1 66090621 695300
1 67090617 462152
1 68090622 4997147334
1 70090606 9865545384
1 76450000 9188037577
1 76450000 1838376174
1 76450000 590122401
1 76450000 246687517
1 76450000 1342713664
1 76450000 2462326189
1 76450000 3806523576
1 76450000 3208702744
1 76450000 4583099320
1 76450000 4907734018
1 76450000 5870173353
1 76450000 5800880018
1 76450000 6873436143
1 76450000 6599757839
1 76450000 7066463102
1 76450000 7912672214
1 76450000 8214460417
1 76450000 8447054420
1 53250000 3883014825
1 53250000 4096356238
1 53250000 2092042184
1 53250000 6169417246
1 53250000 1175213752
1 53250000 8201302877
1 53250000 8223052655
1 53250000 6313798405
1 53250000 9339799272
1 53250000 5473721760
1 53250000 3458077792
1 53250000 5503595677
1 53250000 1520335618
1 53250000 5645619064
1 53250000 4635188166
1 53250000 8799029961
1 53250000 6770089362
1 53250000 9954692527
1 53250000 5972370399
1 21352240 6442648348
1 21352240 6542882037
1 21352240 2303016792
1 12096597 4501201662
1 12096597 7109841792
1 12096597 4810577758
1 12096597 6819722882
1 12096597 7522801612
1 12096597 4123707121
1 12096597 2037263511
1 12096597 2839047735
1 12096597 2045829402
1 12096597 6840553492
1 12096597 1757482930
1 12096597 3158962170
1 12096597 1765562775
1 12096597 8663009149
1 12096597 6772611929
1 12096597 5871806289
1 12096597 2686010466
1 12096597 9788660158
1 12096597 6602415909
1 12096597 6112453447
1 12096597 3228843229
1 12096597 7425247523
1 12096597 2539240680
1 12096597 9931591759
1 12096597 6846042923
1 12096597 8441608934
1 12096597 9652989705
1 12096597 8850357863
1 12096597 3663422573
1 12096597 9365725478
1 12096597 8070818518
1 12096597 9176329296
1 12096597 6280092841
1 12096597 1281996974
1 12096597 2399659670
1 12096597 1898951233
1 25950001 4366148482
1 25950130 6547196811
1 25950001 5071596146
1 25950001 4661047075
1 54051660 247264946
1 56250030 131355309
1 54051660 1895132743
1 54051660 2270680779
1 56250030 2433979867
1 54051660 3295781461
1 54051660 3973563839
1 56250030 4729187104
1 54051660 4227371162
1 54051660 5004091206
1 56250030 5664461825
1 54051660 6445315104
1 54051660 6450305863
1 56250030 7373952209
1 54051660 8726835971
1 54051660 8703197098
1 56250030 9184208040
1 54051660 9194590973
1 66090800 159737723
1 66090800 260657425
1 66090800 1753964183
1 66090800 1812829339
1 66090800 2208034796
1 66090800 2990231738
1 66090800 3435591708
1 66090800 3818843023
1 66090800 4067970889
1 66090800 4192433796
1 66090800 5739701672
1 66090800 6403236277
1 66090800 6660864587
1 66090800 7317175663
1 66090800 7170043010
1 66090800 8064875214
1 66090800 8378395071
1 66090800 9044928172
1 66090800 9324331589
1 37050299 4069086375
1 37050299 6746783012
1 37050299 598318400
1 37050299 864702816
1 37050299 1678718600
1 37050299 1302508153
1 37050299 2059082863
1 37050299 2569728229
1 37050299 3018007728
1 37050299 3996274712
1 37050299 4194650877
1 37050299 4351384013
1 37050299 5507448313
1 37050299 5961810099
1 37050299 6498207155
1 37050299 6742452581
1 37050299 7545727294
1 37050299 7976395017
1 80053762 1048169100
1 80053762 1888782591
1 80053762 2000002628
1 80053762 2728739601
1 80053762 3993443143
1 80053762 3075402086
1 80053762 4584785851
1 80053762 4299178780
1 80053762 5288980952
1 80053762 5240886972
1 80053762 6836598338
1 80053762 6402087074
1 80053762 7270457411
1 80053762 7021130907
1 80053762 8787220157
1 80053762 8965018367
1 80053762 9909973984
1 80053762 9794434253
1 80053762 269148256
1 80053762 269194533
1 80053762 269293507
1 80053762 269296930
1 80053762 269389369
1 80053762 269392831
1 80053762 269447865
1 80053762 269441590
1 80053762 269566040
1 80053762 269551468
1 80053762 269643389
1 80053762 269616985
1 80053762 269753052
1 80053762 269736999
1 80053762 269879846
1 80053762 269820809
1 80053762 269924337
1 80053762 269926429
1 80053762 568072195
1 80053772 844933769
1 80053782 644624563
1 50010700 1630400
1 50010700 2272496
1 50010700 2766995
1 50010700 3059780
1 50010700 3144499
1 50010700 4532048
1 50010700 4722377
1 50010700 5364404
1 50010700 5524828
1 50010700 729491158
1 50010700 739857689
1 50010700 827561681
1 50010700 854956331
1 10050000 7315054256
1 10050020 2680356356
1 10050000 1752543248
1 10050000 5818391313
2 10050020 5179953030
2 10050000 5183938894
2 10050000 5267226016
2 10050020 5220265560
2 10050000 5371922006
1 10050000 5301246787
2 10050020 5465526823
2 10050000 5487937440
2 10050000 5580698142
2 10050020 5692253747
2 10050000 5782545681
1 10050000 5770760909
1 10050020 5851502184
1 10050000 5815154768
2 10050000 5986365687
2 10050020 5955121024
2 10050000 9015642005
2 10050000 9011017322
2 10050020 9024011167
2 10050000 9021373411
2 10050000 9038370118
2 10050020 9031813662
2 10050000 9045794502
1 10050000 9041900818
1 10050020 9051087446
2 10050000 9055169542
2 10050000 9064766439
2 10050020 9068413674
1 10050000 9079771594
1 10050000 9079716827
2 10050020 9087082747
2 10050000 9082244730
2 10050000 9098853172
2 10050020 9093067219
2 10050000 9105924327
2 10050000 9108197669
1 13051172 70798378
1 13051042 6879159743
1 14051462 1980422156
1 50010517 698524029
1 50010517 663640305
1 50010517 1119255073
1 50010517 2878827971
1 50010517 2269495167
1 50010517 3142443422
1 50010517 4184410167
1 50010517 4370230766
1 50010517 6802803063
1 50010517 6656519994
1 50010517 7530907847
1 50010517 7554150558
1 50010517 8362336298
1 50010517 8875820684
1 50010517 9826211875
1 50010517 9823511377
1 50010517 5936323451
1 50010517 5302845641
1 21450000 9894299224
1 21450000 9010334983
1 21450000 5973473431
1 21450000 1813202148
1 20030400 532463650
1 20030400 920481116
1 20030400 1110814181
1 20030400 1038833412
1 20030400 2305550408
1 20030400 2333082697
1 20030400 3252611714
1 20030400 3345366516
1 20030400 4108970684
1 20030400 4967892524
1 20030400 5231097816
1 20030400 5754100443
1 20030400 6234731310
1 20030400 6834443241
1 20030400 7725136274
1 20030400 7108513339
1 20030400 8954832096
1 20030400 8001255069
1 20030400 9119060887
1 20030400 9868130052
1 20050000 129460
1 21050000 121053
1 23050000 247650
1 20050000 290593
1 20050000 389494
1 21050000 426155
1 23050000 442566
1 20050000 584896
1 20050000 537035
1 21050000 694869
1 23050000 798108
1 20050000 795377
1 20050000 807172
1 21050000 196824658
1 23050000 152637649
1 20050000 259374366
1 20050000 233619346
1 21050000 367268599
1 23050000 332403969
1 20050000 474213671
1 20050000 438184081
1 21050000 514943380
1 23050000 557652159
1 20050000 621631372
1 20050000 695940008
1 21050000 702126533
1 23050000 733287950
1 20050000 811356815
1 20050000 862334277
1 21050000 1671184337
1 23050000 1145029018
1 20050000 4853744952
1 20050000 4435019439
1 21050000 5260344952
1 23050000 5041185406
1 20050000 6317032334
1 20050000 6383359795
1 21050000 9177590644
1 23050000 3608999946
1 20050000 3063791424
2 20050000 36529174
2 21050000 35504430
2 23050000 48915551
2 20050000 43720450
2 20050000 53232404
2 21050000 52466942
2 23050000 7098484906
2 20050000 7057391169
2 20050000 8533713008
2 21050000 8508134188
1 10050005 8585087638
1 76026000 8085313
1 76026000 617085695
1 76026000 726301536
1 76026000 7559596099
1 76026000 4554452111
1 21750000 3968482319
1 21750000 1333436267
1 21750000 9424125250
1 21750000 7596277033
1 21750000 6976522824
1 21750000 9945218700
1 59252046 5546237917
1 59252046 8431066060
1 59252046 7394325148
1 59252046 5781213317
1 86055592 1311838577
1 86055592 9795150879
2 86055592 5788837416
2 86055592 5779058940
1 10050006 867505777
1 10050006 691299951
1 10050006 1912177984
1 10050006 1795922928
1 10050006 2536596500
1 10050006 2243620627
1 10050006 3604736283
1 10050006 3729622392
1 10050006 4019419945
1 10050006 4891394182
1 10050006 5048518896
1 10050006 5968602126
1 10050006 6288697929
1 10050006 7320860186
1 10050006 7651435558
1 10050006 9144047354
1 10050006 9966559544
2 70120500 1610001
2 70120500 9797300
2 70120500 12386976
2 70120500 18667858
2 70120500 20077483
2 70120500 20182445
2 70120500 21944234
2 70120500 21436398
2 70120500 22306233
2 70120500 23831024
2 70120500 23159472
2 70120500 24268055
2 70120500 24899736
2 70120500 25743524
2 70120500 25804726
2 70120500 396139991
2 70120500 396636925
2 70120500 397897760
2 70120500 397794655
2 70120500 398702285
2 70120500 398286254
2 70120500 399742594
2 70120500 399593131
2 70120500 476441892
2 70120500 413514738
2 70120500 771763834
2 70120500 723389224
1 70120500 2542130442
1 70120500 5581719053
1 70120500 2506824511
1 70120500 4350652931
2 70120500 421640432
2 70120500 477689547
1 70120500 9479806555
1 70120500 7409870809
2 70120500 711127
2 70120500 595074
1 70120500 7880385
1 70120500 5667162
1 70120500 48202416
1 70120500 54795641
1 70120500 363427242
1 70120500 878296154
2 70120500 115733
2 70120500 999185
2 70120500 1898080
1 70120500 6246538
1 70120500 67980037
1 70120500 30256727
1 70120500 134072628
1 70120500 101986297
2 70120500 418388616
2 70120500 437193748
1 10050007 1763608451
1 10050007 2414407541
1 10050007 2530345203
1 10050007 3043688766
1 10050007 3451696434
1 10050007 4393529766
1 10050007 4370483961
1 10050007 5342762507
1 10050007 6167724119
1 10050007 6783265943
1 10050007 7103473001
1 10050007 7459791873
1 10050007 8997688258
1 10050007 8043585961
1 10050007 9120353745
1 10050007 9320640008
1 20690500 9199941600
1 20690500 6699177129
1 20690500 9673931889
1 20690500 9667979177
1 20690500 1120096701
1 20690500 5562158584
1 20690500 7579811474
1 20690500 2745186974
1 22151730 3603609727
1 22151730 4360555733
1 22151730 9348726439
1 22151730 3329513101
1 22151730 4620808414
1 22151730 2443323479
1 57020500 4082378603
1 57020500 8203513051
1 27020000 6673639776
1 27020001 9876057317
2 27020003 24046194
2 27020004 75875731
1 50120383 9922450177
1 50120383 6519922594
1 50120383 2735389126
1 20120400 5445672852
1 20120400 3265539111
1 50131000 360467603
1 50131000 503501932
1 10050008 3498821122
1 02 9021882650
1 03 4322636238
1 06 7109230973
1 08 8229495463
2 08 0000003175
1 08 0000079996
2 09 8172888070
1 10 1711149195
1 11 6249393331
1 13b 0036683304
1 16 9152384197
1 17 5392798950
1 18 7727646429
1 19 2022114791
1 20 6245269480
1 22 6041709537
1 23 9603190804
1 23 5861004252
1 23 8025215393
1 23 5233429226
1 23 6647138312
1 23 6488242275
1 23 1931059898
1 23 7459866908
1 23 3555178349
1 23 5755689564
1 23 7826990108
1 24 1690683070
1 24 2056230186
1 24 8630761587
1 24 3211737218
1 24 4021131473
1 24 5781934549
1 24 6351535357
1 24 3442716159
1 24 4102329117
1 24 5192657508
1 24 6092991219
1 24 3953290632
1 24 4403071999
1 24 5883308532
1 24 3475945688
1 24 4165534569
1 24 5045344511
1 24 6555710127
1 24 3376863017
1 24 4186306778
1 24 5246082027
1 24 3227790255
1 24 4687706148
1 24 5517200278
1 24 6787024365
1 24 3948103849
1 24 4438032060
1 24 6398449887
1 24 3879968280
1 24 4479357994
1 24 5579482700
1 24 6659102646
1 24 9001892841
1 24 9532318630
1 24 9753511987
1 24 9494759733
1 24 9225259983
1 24 9336264569
1 24 9387925242
1 24 9558761595
1 24 9609518160
1 25 0996820620
1 26 0056393013
1 26 5297794000
1 27 0600280374
1 27 2408327685
1 28 3037643218
1 29 1237623320
1 30 4372535629
1 32 9322112329
1 33 8160890014
1 34 9902411680
1 38 3059081062
1 40 6020036294
1 41 3419466699
1 41 2240833471
1 43 8618294990
1 44 8769402528
2 45 0267143820
2 45 1194102585
1 45 1061828578
1 46 1848950617
1 47 1725083817
1 48 7776272115
1 49a 9421577355
1 49b 9810824563
1 50a 5299969974
1 50a 0008907692
1 51d 2173236953
1 51a 1707397011
1 51b 2521987808
1 51c 1221023415
1 51d 9049087323
1 51e 3097496979
1 51f 1692761145
1 55 9715717593
1 56 2301244196
2 57a 7777770688
2 57a 8888885940
2 57c 4071913662
2 57c 5020252383
2 57c 9118241676
2 57c 9904363226
2 57d 0185125434
2 59 0088315540
1 59 0602440562
1 59 9247775274
1 60 4449834849
1 61a 1553949798
1 61b 6874878488
1 63a 0167635291
1 64 8488290064
1 65 7034234028
1 65 1967601699
1 66a 0161731556
1 66a 0149536893
1 66a 0259418479
1 66a 0421142489
1 66a 0573979676
1 66a 0635002676
1 66a 0708779186
1 66a 0848326762
2 66b 0932504705
2 68 0454161475
1 68b 0000291146
1 68b 0007307762
1 68b 0072312317
1 68b 0863040283
1 68b 0000451369
1 68c 0006979161
1 68c 0944821380
2 68 0413415667
1 71 1482898121
1 73a 8726466528
1 73b 5614566398
1 73c 2736020785
1 73d 9594859116
1 74a 0005167333
1 74a 0608123832
1 74a 8717246022
1 74a 0000125815
1 74b 0000625074
1 76a 0019443833
1 76b 0000084712
1 76b 0007772920
1 76b 0095268795
2 78 0056729576
1 78 1037908587
1 81a 3604882571
1 81a 5414341015
1 81a 8827718071
1 81a 8330621960
1 81a 5648239584
1 81a 8653080676
1 81a 6878369127
1 81a 5082860082
1 81b 1591622697
1 84a 3426257354
1 84c 9965992877
1 84d 5695953310
1 85a 7905507421
1 85b 9751122998
1 85c 4146108356
1 87a 8356690325
1 87b 0000714747
1 87b 0000122777
1 87d 0005645115
1 87e 0094103925
1 87e 0095731245
1 88 5705455626
1 88 5790964608
1 90a 6306053076
1 90b 3504523771
1 90c 7501928273
1 90d 4805900260
1 90e 2208855801
1 90a 9515787467
1 90b 4617768073
1 90c 2714294646
1 90a 8914295978
1 90b 7814376906
1 90a 8322818639
1 90b 7524408344
1 90c 3622660484
1 90d 6120241925
1 90a 8134764099
1 90a 5430926450
1 90d 2531027420
1 90a 9635028515
1 90a 7441155407
1 90b 9844362603
1 90c 3842353902
1 90a 6045429951
1 90c 2841270041
1 90a 6356310419
1 90b 5158555363
1 90a 7453297730
1 90c 4955684486
1 90a 9054820630
1 90a 1266698158
1 90b 9167957399
1 90c 3069011485
1 90d 1266312946
1 90e 1566319188
1 90a 1574970896
1 90b 3373618748
1 90c 5279084963
1 90c 9672569393
1 90a 2070479411
1 90a 3789675221
1 90a 5480329576
1 90c 4587774705
1 90e 8080369638
1 91b 4144269694
1 92 5070230540
1 94 6655564450
2 95 0001051535
2 95 0009306274
2 95 0017638651
2 95 0020244286
2 95 0021063001
2 95 0022613974
2 95 0023874419
2 95 0025965157
2 95 0396834772
2 95 0397129137
2 95 0398520979
2 95 0399381817
2 95 0401558692
2 95 0713349558
2 95 0913548807
2 95 0924316116
2 95 0939375567
2 95 0947970261
2 95 0953172382
2 95 0971328603
2 95 0987517919
1 95 3698302894
1 96a 9753021015
2 96c 0001369677
2 96c 0001410713
2 96c 0001512024
2 96c 0001644195
2 96c 0001740218
2 96c 0001867104
2 96c 0001924687
2 96c 0002369888
2 96c 0003046120
2 96c 0004237754
2 96c 0005485483
2 96c 0006941857
2 96c 0007254789
2 96c 0008259892
2 96c 0009652743
2 96c 0010951610
2 96c 0020546307
2 96c 0030584583
2 96c 0040507449
2 96c 0050756448
2 96c 0060693474
2 96c 0070800983
2 96c 0080831792
2 96c 0090401484
2 96c 0091161648
2 96c 0092576672
2 96c 0093491773
2 96c 0094331598
2 96c 0095022930
2 96c 0096121633
2 96c 0097982700
2 96c 0098222028
2 96c 0099113754
2 96c 0099116570
2 96c 0099265865
2 96c 0099334635
1 98a 3687764455
1 98b 2885921490
1 99 1154444579
1 99 0396143786
1 99 0397848986
1 99 0398567589
1 99 0399547874
1 99 0436534365
1 A2a 5435275283
1 A2b 7839700231
1 A3a 3887487878
1 A3b 6943966588
1 A4a 5907129289
1 A4a 7017011466
1 A4a 1423405222
1 A4a 1039129758
1 A4a 3948574227
1 A4a 9550038687
1 A4a 6168748241
1 A4a 1171484036
1 A4a 4281875116
1 A4a 1282042606
1 A4a 6813649792
1 A4a 3534584074
1 A4a 4915376904
1 A4a 1146504515
1 A4a 9247556934
1 A4a 8608821798
1 A4b 6510719473
1 A4b 9426815921
1 A4b 3734395612
1 A4b 9743431293
1 A4b 6051500535
1 A4b 3465490024
1 A4b 2770119095
1 A4b 5787792904
1 A4b 3831595282
1 A4b 7592688863
1 A4b 4393147250
1 A4b 6435024660
1 A4b 2208967480
1 A4c 4199451428
1 A4a 0000704440
1 A5a 3981448099
1 A5b 0909664838
1 A5b 2818217105
1 A5b 3700396465
1 A5b 4099425100
1 A5b 5230747420
1 A5b 6744435973
1 A5b 7191187247
1 A5b 8105604620
1 A6a 3827534284
1 A6b 7048187043
1 A6b 8124378139
1 A6b 5267852546
1 A6b 8308085736
1 A6b 8481090703
1 A6b 3511745198
1 A6b 8621320185
1 A6b 4712932819
1 A7b 2348286053
1 A8a 6909842462
1 A8a 5717400381
1 A8a 2028424497
1 A8a 6039142347
1 A8a 9542011565
1 A8a 5954568702
1 A8a 8867789475
1 A8a 1171299441
1 A8a 2784560914
1 A8b 3129836974
1 A8b 2342309276
1 A8b 3359178948
1 A8b 8967696685
1 A8a 1778913170
1 A8b 9681678754
1 A8c 1291516056
1 A8d 3695593270
1 A9a 3453897661
1 B1a 9331596239
1 B2a 1106536557
1 B2a 2411704296
1 B2a 5258110350
1 B2a 6790431482
1 B2a 7555631319
1 B2b 8443274140
1 B2b 9123509169
1 B3a 0450667617
1 B3a 1498069433
1 B3a 2464216342
1 B3a 4441243527
1 B3a 5941341480
1 B3a 6880353825
1 B3a 7751336746
1 B3a 8152026783
1 B3b 9647556598
1 B5a 4102003707
1 B5b 0422834085
1 B5b 1421378421
1 B5b 2263948412
1 B5b 3494454659
1 B5b 4055571022
1 B5a 5856757298
1 B5b 6639886388
1 B5b 7463027255
1 B6a 1077181651
1 B6a 2013201420
1 B6a 4760609267
1 B6a 5557176014
1 B6a 6050798735
1 B6a 7032309733
1 B6a 8722078020
1 B6a 9337604164
1 B6a 0269178295
1 B6a 0269214330
1 B6a 0269393404
1 B6a 0269411682
1 B6a 0269576088
1 B6a 0269675914
1 B6a 0269759638
1 B6a 0269897062
1 B6a 0269931155
1 B7a 0001329357
1 B7a 0002547413
1 B7a 0004169693
1 B7a 0005352186
1 B7a 0726027594
1 B7a 0850914755
1 B8a 6503231804
1 B8b 3788228642
2 B8c 5182831998
2 B8c 5201851041
2 B8c 5349924352
2 B8c 5464316536
2 B8c 5705780821
1 B8b 5892892704
2 B8c 5981942749
2 B8c 9019076705
2 B8c 9021182033
2 B8c 9035007145
2 B8c 9051221877
1 B8a 9065998451
2 B8c 9078571888
2 B8c 9088843082
2 B8c 9099947521
2 B8c 9100685109
1 C0b 1016844561
1 C1a 0504120984
1 C1a 1041815480
1 C1a 2613063044
1 C1a 3175672872
1 C1a 4596215720
1 C1a 7125515914
1 C1a 8675838080
1 C1a 9409953086
1 C1b 5736045773
1 C2a 6165185392
1 C2b 3853466161
1 C3a 0810178657
1 C3a 1229510621
1 C3a 2971368523
1 C3a 3439201918
1 C3a 4342122753
1 C3a 5856920680
1 C3a 6933518679
1 C3a 7029125676
1 C3a 8346993085
1 C3b 9911237426
1 C5a 0000132845
1 C5a 0000204362
1 C5a 0000358283
1 C5a 0000567578
1 C5a 0000637843
1 C5a 0000797340
1 C5a 0162115302
1 C5a 0215855526
1 C5a 0390625689
1 C5a 0551143600
1 C5a 0655878409
1 C5a 0766147628
1 C5a 0840918574
1 C5b 1753888758
1 C5b 4425538549
1 C5b 5612499966
1 C5b 6721866845
1 C5b 9572568524
1 C5c 3337689826
2 C5d 0038974109
2 C5d 0045507779
2 C5d 0051911500
2 C5d 7091028088
2 C5d 8579928507
1 C6 8540945052
1 C7a 0368381034
1 C7b 7540422219
1 C8a 2428936534
1 C8b 4048395037
1 C8c 1745761152
1 C9a 5458622643
1 C9b 6223004427
1 D0a 6944830831
2 D0b 5782606095
1 D1 0830490032
1 D1 1408862479
1 D1 2068881148
1 D1 3537867247
1 D1 4788738301
1 D1 5398577062
1 D1 6492168501
1 D1 7724155688
1 D1 9036324465
2 D2a 0001817988
2 D2a 0009939324
2 D2a 0012471573
2 D2a 0020153314
2 D2a 0022652793
2 D2a 0023120460
2 D2a 0024523666
2 D2a 0025972562
2 D2a 0396155849
2 D2a 0397964742
2 D2a 0398535999
2 D2a 0399328079
2 D2a 0415806496
2 D2a 0779115661
1 D2a 9097800674
1 D2b 1721888145
2 D2a 0432233433
1 D2c 5409440488
2 D2a 0000548958
1 D2c 0006666461
1 D2c 0031479014
1 D2c 0377644887
2 D2a 0000940510
2 D2a 0009886424
2 D2a 0018831446
2 D2a 0476262781
2 D2a 0419795999
1 D3a 6087461999
1 D3b 9353200122
1 D4 1372137587
1 D4 3734626984
1 D4 4871153055
1 D4 5245232707
1 D4 6892234848
1 D4 8518158930
1 D4 9376657401
1 D5a 3899845652
1 D5b 4238826838
1 D5c 5658509631
1 D5d 9784901664
1 D6a 7292254586
1 D6a 1465245928
1 D6b 3276106074
2 D8b 0054726152
1 D9b 2160983950
1 D9c 6633913960
1 E0 8774581330
1 E1 0900276665
1 E2 3412117938
