/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.HsqlException;
import org.hsqldb.Node;
import org.hsqldb.rowio.RowOutputInterface;

abstract class BaseMemoryNode
extends Node {
    protected Node nLeft;
    protected Node nRight;
    protected Node nParent;

    BaseMemoryNode() {
    }

    void delete() {
        this.iBalance = -2;
        this.nParent = null;
        this.nRight = null;
        this.nLeft = null;
    }

    Node getLeft() throws HsqlException {
        return this.nLeft;
    }

    void setLeft(Node node) throws HsqlException {
        this.nLeft = node;
    }

    Node getRight() throws HsqlException {
        return this.nRight;
    }

    void setRight(Node node) throws HsqlException {
        this.nRight = node;
    }

    Node getParent() throws HsqlException {
        return this.nParent;
    }

    boolean isRoot() {
        return this.nParent == null;
    }

    void setParent(Node node) throws HsqlException {
        this.nParent = node;
    }

    void setBalance(int n) throws HsqlException {
        this.iBalance = n;
    }

    boolean isFromLeft() throws HsqlException {
        if (this.isRoot()) {
            return true;
        }
        Node node = this.getParent();
        return this.equals(node.getLeft());
    }

    boolean equals(Node node) {
        return node == this;
    }

    void write(RowOutputInterface rowOutputInterface) throws IOException {
    }
}

