/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import net.sourceforge.plantuml.golem.MinMaxDouble;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.USegment;
import net.sourceforge.plantuml.ugraphic.USegmentType;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.g2d.DriverLineG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverShadowedG2d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverPathG2d
extends DriverShadowedG2d
implements UDriver<Graphics2D> {
    private final double dpiFactor;

    public DriverPathG2d(double d) {
        this.dpiFactor = d;
    }

    @Override
    public void draw(UShape uShape, double d, double d2, ColorMapper colorMapper, UParam uParam, Graphics2D graphics2D) {
        Object object;
        Object object2;
        UPath uPath = (UPath)uShape;
        DriverLineG2d.manageStroke(uParam, graphics2D);
        GeneralPath generalPath = new GeneralPath();
        boolean bl = false;
        MinMaxDouble minMaxDouble = new MinMaxDouble();
        minMaxDouble.manage(d, d2);
        Object object3 = uPath.iterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            USegmentType uSegmentType = ((USegment)object2).getSegmentType();
            object = ((USegment)object2).getCoord();
            if (uSegmentType == USegmentType.SEG_MOVETO) {
                generalPath.moveTo((float)(d + object[0]), (float)(d2 + object[1]));
                minMaxDouble.manage(d + object[0], d2 + object[1]);
                continue;
            }
            if (uSegmentType == USegmentType.SEG_LINETO) {
                generalPath.lineTo((float)(d + object[0]), (float)(d2 + object[1]));
                minMaxDouble.manage(d + object[0], d2 + object[1]);
                continue;
            }
            if (uSegmentType == USegmentType.SEG_CUBICTO) {
                generalPath.curveTo((float)(d + object[0]), (float)(d2 + object[1]), (float)(d + object[2]), (float)(d2 + object[3]), (float)(d + object[4]), (float)(d2 + object[5]));
                minMaxDouble.manage(d + object[4], d2 + object[5]);
                bl = true;
                continue;
            }
            throw new UnsupportedOperationException();
        }
        if (uPath.getDeltaShadow() != 0.0) {
            if (bl) {
                this.drawShadow(graphics2D, generalPath, uPath.getDeltaShadow(), this.dpiFactor);
            } else {
                double d3 = 0.0;
                double d4 = 0.0;
                for (USegment uSegment : uPath) {
                    USegmentType uSegmentType = uSegment.getSegmentType();
                    double[] dArray = uSegment.getCoord();
                    if (uSegmentType == USegmentType.SEG_MOVETO) {
                        d3 = d + dArray[0];
                        d4 = d2 + dArray[1];
                        continue;
                    }
                    if (uSegmentType == USegmentType.SEG_LINETO) {
                        Line2D.Double double_ = new Line2D.Double(d3, d4, d + dArray[0], d2 + dArray[1]);
                        this.drawShadow(graphics2D, double_, uPath.getDeltaShadow(), this.dpiFactor);
                        d3 = d + dArray[0];
                        d4 = d2 + dArray[1];
                        continue;
                    }
                    throw new UnsupportedOperationException();
                }
            }
        }
        if ((object3 = uParam.getBackcolor()) instanceof HtmlColorGradient) {
            object2 = (HtmlColorGradient)object3;
            char c = ((HtmlColorGradient)object2).getPolicy();
            object = c == '|' ? (Object)new GradientPaint((float)minMaxDouble.getMinX(), (float)minMaxDouble.getMaxY() / 2.0f, colorMapper.getMappedColor(((HtmlColorGradient)object2).getColor1()), (float)minMaxDouble.getMaxX(), (float)minMaxDouble.getMaxY() / 2.0f, colorMapper.getMappedColor(((HtmlColorGradient)object2).getColor2())) : (c == '\\' ? (Object)new GradientPaint((float)minMaxDouble.getMinX(), (float)minMaxDouble.getMaxY(), colorMapper.getMappedColor(((HtmlColorGradient)object2).getColor1()), (float)minMaxDouble.getMaxX(), (float)minMaxDouble.getMinY(), colorMapper.getMappedColor(((HtmlColorGradient)object2).getColor2())) : (c == '-' ? (Object)new GradientPaint((float)minMaxDouble.getMaxX() / 2.0f, (float)minMaxDouble.getMinY(), colorMapper.getMappedColor(((HtmlColorGradient)object2).getColor1()), (float)minMaxDouble.getMaxX() / 2.0f, (float)minMaxDouble.getMaxY(), colorMapper.getMappedColor(((HtmlColorGradient)object2).getColor2())) : (Object)new GradientPaint((float)d, (float)d2, colorMapper.getMappedColor(((HtmlColorGradient)object2).getColor1()), (float)minMaxDouble.getMaxX(), (float)minMaxDouble.getMaxY(), colorMapper.getMappedColor(((HtmlColorGradient)object2).getColor2()))));
            graphics2D.setPaint((Paint)object);
            graphics2D.fill(generalPath);
        } else if (object3 != null) {
            graphics2D.setColor(colorMapper.getMappedColor((HtmlColor)object3));
            graphics2D.fill(generalPath);
        }
        if (uParam.getColor() != null) {
            graphics2D.setColor(colorMapper.getMappedColor(uParam.getColor()));
            graphics2D.draw(generalPath);
        }
    }
}

