package Ion::Util;
# ABSTRACT: Helpers to make Ion more Util
$Ion::Util::VERSION = '0.07_01'; # TRIAL

$Ion::Util::VERSION = '0.0701';use common::sense;
use Coro;

use parent 'Exporter';

our @EXPORT = qw(
  gen
);

sub gen (&) {
  my $fn  = shift;
  my $in  = Coro::Channel->new;
  my $out = Coro::Channel->new;

  my $gen = async_pool{
    my ($in, $out) = @_;
    while (my $msg = $in->get) {
      $out->put($fn->(@$msg));
    }
  } $in, $out;

  return sub{
    $out->put(@_);
    $in->get;
  };
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Ion::Util - Helpers to make Ion more Util

=head1 VERSION

version 0.07_01

=head1 AUTHOR

Jeff Ober <sysread@fastmail.fm>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Jeff Ober.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
