/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;

public class ServletRequestWrappingHttpRequest
extends HttpRequest {
    private final HttpServletRequest req;

    public ServletRequestWrappingHttpRequest(HttpServletRequest req) {
        super(HttpMethod.valueOf(req.getMethod()), req.getPathInfo() == null ? "/" : req.getPathInfo());
        this.req = req;
    }

    @Override
    public Iterable<String> getHeaderNames() {
        return Collections.list(this.req.getHeaderNames());
    }

    @Override
    public Iterable<String> getHeaders(String name) {
        return Collections.list(this.req.getHeaders(name));
    }

    @Override
    public String getHeader(String name) {
        return this.req.getHeader(name);
    }

    @Override
    public void removeHeader(String name) {
        throw new UnsupportedOperationException("removeHeader");
    }

    @Override
    public void setHeader(String name, String value) {
        throw new UnsupportedOperationException("setHeader");
    }

    @Override
    public void addHeader(String name, String value) {
        throw new UnsupportedOperationException("addHeader");
    }

    @Override
    public String getQueryParameter(String name) {
        String[] allValues = this.req.getParameterMap().get(name);
        if (allValues == null || allValues.length == 0) {
            return null;
        }
        return allValues[0];
    }

    @Override
    public void addQueryParameter(String name, String value) {
        throw new UnsupportedOperationException("addQueryParameter");
    }

    @Override
    public Iterable<String> getQueryParameterNames() {
        return this.req.getParameterMap().keySet();
    }

    @Override
    public Iterable<String> getQueryParameters(String name) {
        String[] allValues = this.req.getParameterMap().get(name);
        if (allValues == null) {
            return Collections.emptySet();
        }
        return () -> Arrays.stream(allValues).iterator();
    }

    @Override
    public void setContent(byte[] data) {
        throw new UnsupportedOperationException("setContent");
    }

    @Override
    public void setContent(InputStream toStreamFrom) {
        throw new UnsupportedOperationException("setContent");
    }

    @Override
    public InputStream consumeContentStream() {
        try {
            return this.req.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

