package JIRA::API::WebhookDetails 0.01;
# DO NOT EDIT! This is an autogenerated file.
use 5.020;
use Moo 2;
use experimental 'signatures';
use Types::Standard qw(Str Bool Num Int Object ArrayRef);
use MooX::TypeTiny;

=head1 NAME

JIRA::API::WebhookDetails -

=head1 SYNOPSIS

  my $obj = JIRA::API::WebhookDetails->new();
  ...

=cut

sub as_hash( $self ) {
    return { $self->%* }
}

=head1 PROPERTIES

=head2 C<< events >>

The Jira events that trigger the webhook.

=cut

has 'events' => (
    is       => 'ro',
    isa      => ArrayRef[Str],
    required => 1,
);

=head2 C<< fieldIdsFilter >>

A list of field IDs. When the issue changelog contains any of the fields, the webhook `jira:issue_updated` is sent. If this parameter is not present, the app is notified about all field updates.

=cut

has 'fieldIdsFilter' => (
    is       => 'ro',
    isa      => ArrayRef[Str],
);

=head2 C<< issuePropertyKeysFilter >>

A list of issue property keys. A change of those issue properties triggers the `issue_property_set` or `issue_property_deleted` webhooks. If this parameter is not present, the app is notified about all issue property updates.

=cut

has 'issuePropertyKeysFilter' => (
    is       => 'ro',
    isa      => ArrayRef[Str],
);

=head2 C<< jqlFilter >>

The JQL filter that specifies which issues the webhook is sent for. Only a subset of JQL can be used. The supported elements are:

 *  Fields: `issueKey`, `project`, `issuetype`, `status`, `assignee`, `reporter`, `issue.property`, and `cf[id]`. For custom fields (`cf[id]`), only the epic label custom field is supported.".
 *  Operators: `=`, `!=`, `IN`, and `NOT IN`.

=cut

has 'jqlFilter' => (
    is       => 'ro',
    isa      => Str,
    required => 1,
);


1;
