/*                                                                
**  Copyright (C) 1996,2007  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 3 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */

/* pline.c
**/

#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include "pfile.h"
#include "ptemplat.h"
#include "parameter.h"

static int Pline( char *fname, char **argv, int argc, int docl,
		  int dopset, char *prefix );

int
main(int argc, char *argv[])
{
  int doprefix=0;
  int docl=0;
  int dopset=0;
  int pname=1;
  int i;
  char *prefix;

  /* make sure we have something to pline */
  if ( argc == 1 ){
    fprintf(stderr, "pline: no paramfiles to list\n");
    exit(1);
  }

  /* look for flags */
  for(i=1; i<argc && argv[i][0] == '-'; i++){
    if( !strcmp(argv[i], "-pset") ){
      dopset = 1;
      pname++;
    }
    if( !strcmp(argv[i], "-task") ){
      doprefix = 1;
      pname++;
    }
    else if( !strcmp(argv[i], "-cl") ){
      docl = 1;
      pname++;
    }
  }

  if( doprefix ){
    if( (prefix=strrchr(argv[pname], '.')) != NULL )
      prefix++;
    else
      prefix = argv[pname];
  }
  else
    prefix = NULL;

  /* this is the business end of the program */
  Pline(argv[pname], &argv[pname], argc - pname, docl, dopset, prefix);
  printf("\n");

  exit(0);
}

#define SZ_VAL 32

/*
 *
 * Pline -- recursively dump parameters to a command line
 *
 */
int 
Pline (char *fname, char **argv, int argc, int docl, int dopset, char *prefix)
{
  int i;
  static int rlevel=0;
  paramfile pfile;
  pmatchlist pml;
  char pmode[SZ_VAL], ptype[SZ_VAL], pvalue[SZ_PFLINE];
  char pmin[SZ_VAL], pmax[SZ_VAL], pprompt[SZ_PFLINE];
  char *name;
  char *pset;
  char value[SZ_PFLINE];

  if ( (pfile = paramopen(fname, argv, argc, "rH")) == NULL ) {
    fprintf(stderr, "pline: can't open parameter file: %s\n", pfilelast());
    exit(1);
  }

  /* open the match list for all params */
  pml = pmatchopen(pfile, NULL);
  /* display each param value in name='value' format */
  for(i=0; (name=pmatchnext(pml)) != NULL; i++ ){
    /* we need ParamInfo to check for various special conditions but ... */
    if( ParamInfo(pfile, name, pmode, ptype, pvalue, pmin, pmax, pprompt)){
      /* ... we need pgetstr also because ParamInfo does not deal with
	 command line values properly!!! */
      pgetstr(pfile, name, value, SZ_PFLINE);
      /* IRAF CL style output */
      if( docl ){
        if( (i != 0) || (rlevel !=0) )
	  printf(",");
	if( prefix != NULL )
	  printf("%s.", prefix);
	/* print string values with quotes */
        if (ptype[0] == 's' || ptype[0] == 'f')
	  printf("%s=\"%s\"", name, value);
        else{
	  /* 0 values come back as null strings -- watch out! */
	  if (strlen(value) == 0)
	    printf("%s=0", name);
	  else
	    printf("%s=%s", name, value);
	}
      }
      /* Unix style output */
      else{
        if( (i != 0) || (rlevel !=0) )
	  printf(" ");
	if( prefix != NULL )
	  printf("%s.", prefix);
	printf("%s='%s'", name, value);
      }
    }
    /* if this param was a pset, we may have to recurse on it */
    if( dopset && !strcmp(ptype, "pset") ){
      if ( *value == '\0' )
	pset = name;
      else
	pset = value;
      rlevel++;
      Pline(pset, argv, argc, docl, dopset, pset);
    }
  }
  /* close the match list */
  pmatchclose(pml);
  paramclose(pfile);

  return 0;
}
