package Google::Ads::AdWords::v201806::OrderIdOfflineConversionAdjustmentFeed;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201806' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201806::OfflineConversionAdjustmentFeed);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %conversionName_of :ATTR(:get<conversionName>);
my %adjustmentTime_of :ATTR(:get<adjustmentTime>);
my %adjustmentType_of :ATTR(:get<adjustmentType>);
my %adjustedValue_of :ATTR(:get<adjustedValue>);
my %adjustedValueCurrencyCode_of :ATTR(:get<adjustedValueCurrencyCode>);
my %OfflineConversionAdjustmentFeed__Type_of :ATTR(:get<OfflineConversionAdjustmentFeed__Type>);
my %orderId_of :ATTR(:get<orderId>);

__PACKAGE__->_factory(
    [ qw(        conversionName
        adjustmentTime
        adjustmentType
        adjustedValue
        adjustedValueCurrencyCode
        OfflineConversionAdjustmentFeed__Type
        orderId

    ) ],
    {
        'conversionName' => \%conversionName_of,
        'adjustmentTime' => \%adjustmentTime_of,
        'adjustmentType' => \%adjustmentType_of,
        'adjustedValue' => \%adjustedValue_of,
        'adjustedValueCurrencyCode' => \%adjustedValueCurrencyCode_of,
        'OfflineConversionAdjustmentFeed__Type' => \%OfflineConversionAdjustmentFeed__Type_of,
        'orderId' => \%orderId_of,
    },
    {
        'conversionName' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'adjustmentTime' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'adjustmentType' => 'Google::Ads::AdWords::v201806::OfflineConversionAdjustmentType',
        'adjustedValue' => 'SOAP::WSDL::XSD::Typelib::Builtin::double',
        'adjustedValueCurrencyCode' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'OfflineConversionAdjustmentFeed__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'orderId' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'conversionName' => 'conversionName',
        'adjustmentTime' => 'adjustmentTime',
        'adjustmentType' => 'adjustmentType',
        'adjustedValue' => 'adjustedValue',
        'adjustedValueCurrencyCode' => 'adjustedValueCurrencyCode',
        'OfflineConversionAdjustmentFeed__Type' => 'OfflineConversionAdjustmentFeed.Type',
        'orderId' => 'orderId',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201806::OrderIdOfflineConversionAdjustmentFeed

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
OrderIdOfflineConversionAdjustmentFeed from the namespace https://adwords.google.com/api/adwords/cm/v201806.

A conversion adjustment record for conversions uploaded with order ID. Inherits from abstract class OfflineConversionAdjustmentFeed. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * orderId




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

