package Google::Ads::AdWords::v201802::BidLandscape::LandscapePoint;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201802' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %bid_of :ATTR(:get<bid>);
my %clicks_of :ATTR(:get<clicks>);
my %cost_of :ATTR(:get<cost>);
my %impressions_of :ATTR(:get<impressions>);
my %promotedImpressions_of :ATTR(:get<promotedImpressions>);
my %requiredBudget_of :ATTR(:get<requiredBudget>);
my %biddableConversions_of :ATTR(:get<biddableConversions>);
my %biddableConversionsValue_of :ATTR(:get<biddableConversionsValue>);
my %bidModifier_of :ATTR(:get<bidModifier>);
my %totalLocalImpressions_of :ATTR(:get<totalLocalImpressions>);
my %totalLocalClicks_of :ATTR(:get<totalLocalClicks>);
my %totalLocalCost_of :ATTR(:get<totalLocalCost>);
my %totalLocalPromotedImpressions_of :ATTR(:get<totalLocalPromotedImpressions>);

__PACKAGE__->_factory(
    [ qw(        bid
        clicks
        cost
        impressions
        promotedImpressions
        requiredBudget
        biddableConversions
        biddableConversionsValue
        bidModifier
        totalLocalImpressions
        totalLocalClicks
        totalLocalCost
        totalLocalPromotedImpressions

    ) ],
    {
        'bid' => \%bid_of,
        'clicks' => \%clicks_of,
        'cost' => \%cost_of,
        'impressions' => \%impressions_of,
        'promotedImpressions' => \%promotedImpressions_of,
        'requiredBudget' => \%requiredBudget_of,
        'biddableConversions' => \%biddableConversions_of,
        'biddableConversionsValue' => \%biddableConversionsValue_of,
        'bidModifier' => \%bidModifier_of,
        'totalLocalImpressions' => \%totalLocalImpressions_of,
        'totalLocalClicks' => \%totalLocalClicks_of,
        'totalLocalCost' => \%totalLocalCost_of,
        'totalLocalPromotedImpressions' => \%totalLocalPromotedImpressions_of,
    },
    {
        'bid' => 'Google::Ads::AdWords::v201802::Money',
        'clicks' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'cost' => 'Google::Ads::AdWords::v201802::Money',
        'impressions' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'promotedImpressions' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'requiredBudget' => 'Google::Ads::AdWords::v201802::Money',
        'biddableConversions' => 'SOAP::WSDL::XSD::Typelib::Builtin::double',
        'biddableConversionsValue' => 'SOAP::WSDL::XSD::Typelib::Builtin::double',
        'bidModifier' => 'SOAP::WSDL::XSD::Typelib::Builtin::double',
        'totalLocalImpressions' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'totalLocalClicks' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'totalLocalCost' => 'Google::Ads::AdWords::v201802::Money',
        'totalLocalPromotedImpressions' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
    },
    {

        'bid' => 'bid',
        'clicks' => 'clicks',
        'cost' => 'cost',
        'impressions' => 'impressions',
        'promotedImpressions' => 'promotedImpressions',
        'requiredBudget' => 'requiredBudget',
        'biddableConversions' => 'biddableConversions',
        'biddableConversionsValue' => 'biddableConversionsValue',
        'bidModifier' => 'bidModifier',
        'totalLocalImpressions' => 'totalLocalImpressions',
        'totalLocalClicks' => 'totalLocalClicks',
        'totalLocalCost' => 'totalLocalCost',
        'totalLocalPromotedImpressions' => 'totalLocalPromotedImpressions',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201802::BidLandscape::LandscapePoint

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
BidLandscape.LandscapePoint from the namespace https://adwords.google.com/api/adwords/cm/v201802.

A set of estimates for a criterion's performance for a specific bid amount. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * bid


=item * clicks


=item * cost


=item * impressions


=item * promotedImpressions


=item * requiredBudget


=item * biddableConversions


=item * biddableConversionsValue


=item * bidModifier


=item * totalLocalImpressions


=item * totalLocalClicks


=item * totalLocalCost


=item * totalLocalPromotedImpressions




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

