/*
 * Decompiled with CFR 0.152.
 */
package junit.runner;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipFile;

public class TestCaseClassLoader
extends ClassLoader {
    private Vector fPathItems;
    private String[] defaultExclusions = new String[]{"junit.framework.", "junit.extensions.", "junit.runner."};
    static final String EXCLUDED_FILE = "excluded.properties";
    private Vector fExcluded;

    public TestCaseClassLoader() {
        this(System.getProperty("java.class.path"));
    }

    public TestCaseClassLoader(String classPath) {
        this.scanPath(classPath);
        this.readExcludedPackages();
    }

    private void scanPath(String classPath) {
        String separator = System.getProperty("path.separator");
        this.fPathItems = new Vector(10);
        StringTokenizer st = new StringTokenizer(classPath, separator);
        while (st.hasMoreTokens()) {
            this.fPathItems.addElement(st.nextToken());
        }
    }

    public URL getResource(String name) {
        return ClassLoader.getSystemResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        return ClassLoader.getSystemResourceAsStream(name);
    }

    public boolean isExcluded(String name) {
        int i = 0;
        while (i < this.fExcluded.size()) {
            if (name.startsWith((String)this.fExcluded.elementAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        if (this.isExcluded(name)) {
            try {
                c = this.findSystemClass(name);
                return c;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (c == null) {
            byte[] data = this.lookupClassData(name);
            if (data == null) {
                throw new ClassNotFoundException();
            }
            c = this.defineClass(name, data, 0, data.length);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private byte[] lookupClassData(String className) throws ClassNotFoundException {
        byte[] data = null;
        int i = 0;
        while (i < this.fPathItems.size()) {
            String path = (String)this.fPathItems.elementAt(i);
            String fileName = String.valueOf(className.replace('.', '/')) + ".class";
            data = this.isJar(path) ? this.loadJarData(path, fileName) : this.loadFileData(path, fileName);
            if (data != null) {
                return data;
            }
            ++i;
        }
        throw new ClassNotFoundException(className);
    }

    boolean isJar(String pathEntry) {
        return pathEntry.endsWith(".jar") || pathEntry.endsWith(".zip");
    }

    private byte[] loadFileData(String path, String fileName) {
        File file = new File(path, fileName);
        if (file.exists()) {
            return this.getClassData(file);
        }
        return null;
    }

    private byte[] getClassData(File f) {
        try {
            int n;
            FileInputStream stream = new FileInputStream(f);
            ByteArrayOutputStream out = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = stream.read(b)) != -1) {
                out.write(b, 0, n);
            }
            stream.close();
            out.close();
            return out.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] loadJarData(String path, String fileName) {
        block15: {
            zipFile = null;
            stream = null;
            archive = new File(path);
            if (!archive.exists()) {
                return null;
            }
            try {
                zipFile = new ZipFile(archive);
            }
            catch (IOException io) {
                return null;
            }
            entry = zipFile.getEntry(fileName);
            if (entry == null) {
                return null;
            }
            size = (int)entry.getSize();
            try {
                try {
                    stream = zipFile.getInputStream(entry);
                    data = new byte[size];
                    pos = 0;
                    while (true) {
                        if (pos >= size) {
                            zipFile.close();
                            var13_13 = data;
                            var11_14 = null;
                            break;
                        }
                        n = stream.read(data, pos, data.length - pos);
                        pos += n;
                    }
                }
                catch (IOException var8_10) {
                    break block15;
                }
            }
            catch (Throwable var12_20) {
                var11_15 = null;
                try {
                    if (stream == null) throw var12_20;
                    stream.close();
                    throw var12_20;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw var12_20;
            }
            ** try [egrp 3[TRYBLOCK] [3 : 150->163)] { 
lbl44:
            // 1 sources

            if (stream == null) return var13_13;
            stream.close();
            return var13_13;
lbl47:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return var13_13;
        }
        var11_16 = null;
        try {}
        catch (IOException e) {
            return null;
        }
        if (stream == null) return null;
        stream.close();
        return null;
    }

    private void readExcludedPackages() {
        this.fExcluded = new Vector(10);
        int i = 0;
        while (i < this.defaultExclusions.length) {
            this.fExcluded.addElement(this.defaultExclusions[i]);
            ++i;
        }
        InputStream is = this.getClass().getResourceAsStream(EXCLUDED_FILE);
        if (is == null) {
            return;
        }
        Properties p = new Properties();
        try {
            try {
                p.load(is);
            }
            catch (IOException e) {
                Object var4_6 = null;
                try {
                    is.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            try {
                is.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
        Object var4_8 = null;
        try {
            is.close();
        }
        catch (IOException e2) {
            // empty catch block
        }
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("excluded.")) continue;
            String path = p.getProperty(key);
            if ((path = path.trim()).endsWith("*")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.length() <= 0) continue;
            this.fExcluded.addElement(path);
        }
    }
}

