package OpenInteract::Handler::Group;

# $Id: Group.pm,v 1.9 2002/04/13 16:42:35 lachoy Exp $

use strict;
use Data::Dumper  qw( Dumper );
use OpenInteract::CommonHandler;
use OpenInteract::Handler::GenericDispatcher qw( DEFAULT_SECURITY_KEY );
use SPOPS::Secure qw( :level );
use SPOPS::Utility;

@OpenInteract::Handler::Group::ISA     = qw(  OpenInteract::CommonHandler SPOPS::Secure );
$OpenInteract::Handler::Group::VERSION = sprintf("%d.%02d", q$Revision: 1.9 $ =~ /(\d+)\.(\d+)/);

$OpenInteract::Handler::Group::author            = 'chris@cwinters.com';
$OpenInteract::Handler::Group::default_method    = 'search';
@OpenInteract::Handler::Group::forbidden_methods = ();
%OpenInteract::Handler::Group::security          = (
 DEFAULT_SECURITY_KEY() => SEC_LEVEL_READ,
 edit => SEC_LEVEL_WRITE, remove => SEC_LEVEL_WRITE,
);

use constant MEMBER_FIELD => 'group_members';

sub MY_PACKAGE                 { return 'base_group' }
sub MY_HANDLER_PATH            { return '/Group' }
sub MY_OBJECT_TYPE             { return 'group' }
sub MY_OBJECT_CLASS            { return OpenInteract::Request->instance->group }

sub MY_ALLOW_SEARCH_FORM       { return undef }

sub MY_ALLOW_SEARCH            { return 1 }
sub MY_SEARCH_FIELDS           { return qw( name ) }
sub MY_SEARCH_RESULTS_TITLE    { return 'Group Listing' }
sub MY_SEARCH_RESULTS_TEMPLATE { return 'group_list' }
sub MY_SEARCH_RESULTS_ORDER    { return 'name' }

sub MY_ALLOW_CREATE            { return 1 }
sub MY_ALLOW_SHOW              { return 1 }
sub MY_OBJECT_FORM_TITLE       { return 'Group Detail' }
sub MY_OBJECT_FORM_TEMPLATE    { return 'group_detail' }
sub MY_SHOW_FAIL_TASK          { return 'search' }

sub MY_ALLOW_EDIT              { return 1 }
sub MY_EDIT_RETURN_URL         { return '/Group/' }
sub MY_EDIT_FIELDS             { return qw( name notes ) }
sub MY_EDIT_DISPLAY_TASK       { return '_post_save' }
sub MY_EDIT_FAIL_TASK          { return 'search' }

sub MY_ALLOW_REMOVE            { return 1 }
sub MY_REMOVE_DISPLAY_TASK     { return 'search' }

sub MY_ALLOW_NOTIFY            { return 1 }


sub _show_customize {
    my ( $class, $params ) = @_;
    my $R = OpenInteract::Request->instance;

    my $group = $params->{group};

    # Retrieve the member users

    my $group_members = eval { $group->user } || [];
    if ( $@ ) {
        $params->{error_msg} .= "Failed to retrieve user listing: $SPOPS::Error::system_msg";
        return;
    }

    my @member_info = map { { id   => $_->id,
                              name => $_->{login_name} } } @{ $group_members };

    my $can_write = ( $params->{task_security} >= SEC_LEVEL_WRITE and
                      ( $group->{tmp_security_level} >= SEC_LEVEL_WRITE or ! $group->is_saved ) );
    my $do_edit   = ( $params->{do_edit} and $can_write );

    # If the user has WRITE access to tool **plus** WRITE access to
    # the object, change the template and retrieve some additional
    # info

    if ( $do_edit ) {
        $params->{template_name} = 'base_group::group_form';
        my $all_users = eval { $R->user->fetch_group } || [];
        if ( $@ ) {
            OpenInteract::Error->set( SPOPS::Error->get );
            $R->throw( { code => 403 } );
            $params->{error_msg} = "Cannot retrieve all users. Error logged.";
        }
        my %all_nonmember_info = map { $_->id => $_->{login_name} } @{ $all_users };
        for ( @member_info ) { delete $all_nonmember_info{ $_->{id} } }
        my @sorted_nonmember_info = map { { id   => $_,
                                            name => $all_nonmember_info{ $_ } } }
                                    sort { $all_nonmember_info{ $a } cmp $all_nonmember_info{ $b } }
                                    keys %all_nonmember_info;
        $params->{member_field}     = MEMBER_FIELD;
        $params->{all_user_list}    = \@sorted_nonmember_info;
    }
    $params->{member_user_list} = \@member_info;
}


# Find the specified members for saving.
#
# First get the existing members, then split apart the members
# specified in the form. Give both pieces of information to
# the list_process method to separate them out into removals,
# additions and keepers.

sub _post_save {
    my ( $class, $show_params ) = @_;
    if ( $show_params->{error_msg} ) {
        $show_params->{do_edit}++;
        return $class->show( $show_params );
    }

    my $R = OpenInteract::Request->instance;
    my $group = $show_params->{group};

    my $existing_user_list = eval { $group->user } || [];
    my @existing_uid = map { $_->id } @{ $existing_user_list };
    my @member_uid   = split ';', $R->apache->param( MEMBER_FIELD );
    $R->DEBUG && $R->scrib( 1, "User IDs retrieved: ", join( '/', @member_uid ) );

    my $member_status = SPOPS::Utility->list_process( \@existing_uid, \@member_uid );
    $R->DEBUG && $R->scrib( 1, "After processing: ", Dumper( $member_status ) );

    my $removed = eval { $group->user_remove( $member_status->{remove} ); };
    if ( $@ ) { $R->scrib( 0, "Error removing users from group: $@" ) }
    $R->DEBUG && $R->scrib( 1, "Removed ($removed) of (", scalar @{ $member_status->{remove} }, ")" );

    my $added   = eval { $group->user_add( $member_status->{add} ); };
    if ( $@ ) { $R->scrib( 0, "Error adding users to group: $@" ) }
    $R->DEBUG && $R->scrib( 1, "Added ($added) of (", scalar @{ $member_status->{add} }, ")" );

    # always display this group: if we had an error, then they can
    # edit the information again; if they didn't have an error,
    # then they'll see that something happened.

    $show_params->{status_msg} .= '<br>Group membership information updated.';
    return $class->show( $show_params );
}

1;
