package GFX::Enhancer::SystemOnEnergy;

sub new {
	my ($class, $pngfilename) = @_;

        my $self = { length => 0, index => 0, energystream => undef, bytestream => undef}; 

	### init PNG file bytes
	$reader = GFX::Enhancer::PNGReader->new("");
	$reader->read_in_byte_array($filename);
	my $s;
	$self->{bytestream} = \$s;
	$reader->cast_to_imagebytestream($self->{bytestream});

	### init energy floats
	my @fls;
	for (my $i = 0; $i < $reader->{length}; $i++) {
		### read in colours (RGBA values) into floats list
		push (@{fls}, $self->{bytestream}->next);
	}

	my $self->{length} = $reader->{length};
	$self->{energystream} = GFX::Enhancer::EnergyStream($self->{length}, @fls);	

	$class = ref($class) || $class;
	bless $self, $class;
}

### public methods

sub get_energy_colour_with_index {
	my ($self, $index) = @_;
	
	return $self->{energystream}->{listoffloats}[$index];
}

sub set_energy_colour_with_index {
	my ($self, $value, $index) = @_;

	$self->{energystream}->edit($value, $index);
}


1;
