use 5.006;
use strict;
use warnings;

# this test was generated with Dist::Zilla::Plugin::Test::Compile 2.040

use Test::More  tests => 26 + ($ENV{AUTHOR_TESTING} ? 1 : 0);



my @module_files = (
    'WWW/LogicBoxes.pm',
    'WWW/LogicBoxes/Contact.pm',
    'WWW/LogicBoxes/Contact/CA.pm',
    'WWW/LogicBoxes/Contact/CA/Agreement.pm',
    'WWW/LogicBoxes/Contact/Factory.pm',
    'WWW/LogicBoxes/Contact/US.pm',
    'WWW/LogicBoxes/Customer.pm',
    'WWW/LogicBoxes/Domain.pm',
    'WWW/LogicBoxes/Domain/Factory.pm',
    'WWW/LogicBoxes/DomainAvailability.pm',
    'WWW/LogicBoxes/DomainRequest.pm',
    'WWW/LogicBoxes/DomainRequest/Registration.pm',
    'WWW/LogicBoxes/DomainRequest/Transfer.pm',
    'WWW/LogicBoxes/DomainTransfer.pm',
    'WWW/LogicBoxes/PhoneNumber.pm',
    'WWW/LogicBoxes/PrivateNameServer.pm',
    'WWW/LogicBoxes/Role/Command.pm',
    'WWW/LogicBoxes/Role/Command/Contact.pm',
    'WWW/LogicBoxes/Role/Command/Customer.pm',
    'WWW/LogicBoxes/Role/Command/Domain.pm',
    'WWW/LogicBoxes/Role/Command/Domain/Availability.pm',
    'WWW/LogicBoxes/Role/Command/Domain/PrivateNameServer.pm',
    'WWW/LogicBoxes/Role/Command/Domain/Registration.pm',
    'WWW/LogicBoxes/Role/Command/Domain/Transfer.pm',
    'WWW/LogicBoxes/Role/Command/Raw.pm',
    'WWW/LogicBoxes/Types.pm'
);



# no fake home requested

my $inc_switch = -d 'blib' ? '-Mblib' : '-Ilib';

use File::Spec;
use IPC::Open3;
use IO::Handle;

open my $stdin, '<', File::Spec->devnull or die "can't open devnull: $!";

my @warnings;
for my $lib (@module_files)
{
    # see L<perlfaq8/How can I capture STDERR from an external command?>
    my $stderr = IO::Handle->new;

    my $pid = open3($stdin, '>&STDERR', $stderr, $^X, $inc_switch, '-e', "require q[$lib]");
    binmode $stderr, ':crlf' if $^O eq 'MSWin32';
    my @_warnings = <$stderr>;
    waitpid($pid, 0);
    is($?, 0, "$lib loaded ok");

    if (@_warnings)
    {
        warn @_warnings;
        push @warnings, @_warnings;
    }
}



is(scalar(@warnings), 0, 'no warnings found') if $ENV{AUTHOR_TESTING};


