# Copyright (C) 1998 Tuomas J. Lukka
# DISTRIBUTED WITH NO WARRANTY, EXPRESS OR IMPLIED.
# See the GNU General Public License (file COPYING in the distribution)
# for conditions of use and redistribution.

#
# Config system idea from PDL
#

$VERSION = "0.10";

BEGIN{
 eval "use 5.004";
 die "VRML::Browser requires Perl v5.004 or later -- go to http://www.perl.com"
  if $@;
}

# Remove our config argument
@ARGV = map {
	if(/^CONF=(.*)$/) {
		$vrml_conf_file = $1; ();
	} else {
		$_
	}
} @ARGV;

if(!defined $vrml_conf_file) {
	my $defname = "$ENV{HOME}/.vrml.conf";
	if(-e $defname) {
		$vrml_conf_file = $defname;
	}
}

require './vrml.conf';
%VRML_CONFIG_DIST = %VRML_CONFIG;

if(defined $vrml_conf_file) {
 if(!-e $vrml_conf_file) {
	die("Invalid config file '$vrml_conf_file' specified");
 }
 print "Reading configuration from file '$vrml_conf_file'\n";
 require $vrml_conf_file;
}

for(keys %VRML_CONFIG) {
	if(!exists($VRML_CONFIG_DIST{$_})) {
		die("Invalid key '$_' found in user supplied file '$vrml_conf_file'.
This key may no longer be in use, or someone may have garbled the 'vrml.conf' 
file in the distribution. Please correct and try again");
	}
}

%VRML_CONFIG = (%VRML_CONFIG_DIST, %VRML_CONFIG);

print STDERR "Writing Config.pm\n";
open OUT, ">Config.pm" or die("Couldn't write to Config.pm");
print OUT "# AUTOMATICALLY GENERATED BY TOP-LEVEL MAKEFILE.PL -- DO NOT EDIT
\%VRML::Config = (
";
for(keys %VRML_CONFIG) {
	print OUT "\t$_\t=>\t";
	if(defined $VRML_CONFIG{$_}) {
                print OUT '"',quotemeta($VRML_CONFIG{$_}),'"';
	} else {
		print OUT "undef";
	}
	print OUT ",\n";
}
print OUT "VERSION => \"$VERSION\"\n";
print OUT ");\n1;\n";
close OUT;

use ExtUtils::MakeMaker;
WriteMakefile(
	NAME => "VRML::VRMLFunc",
	DISTNAME => "FreeWRL",
 	dist => {
		COMPRESS => 'gzip -9', SUFFIX => 'gz',
	},
	VERSION => $VERSION,
    DEFINE => $VRML_CONFIG{OPENGL_DEFINE},
    INC => $VRML_CONFIG{OPENGL_INC},
    EXE_FILES => ['freewrl'],
    PL_FILES => {'freewrl.PL' => 'freewrl'},
);

sub MY::postamble {
	'
VRMLFunc.pm VRMLFunc.xs: VRMLC.pm VRMLFields.pm VRMLNodes.pm VRMLRend.pm
	$(PERL) VRMLC.pm
'
}
