# Generated by default/object.tt
package Paws::SageMaker::ImageConfig;
  use Moose;
  has RepositoryAccessMode => (is => 'ro', isa => 'Str', required => 1);
  has RepositoryAuthConfig => (is => 'ro', isa => 'Paws::SageMaker::RepositoryAuthConfig');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::ImageConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::ImageConfig object:

  $service_obj->Method(Att1 => { RepositoryAccessMode => $value, ..., RepositoryAuthConfig => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::ImageConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->RepositoryAccessMode

=head1 DESCRIPTION

Specifies whether the model container is in Amazon ECR or a private
Docker registry accessible from your Amazon Virtual Private Cloud
(VPC).

=head1 ATTRIBUTES


=head2 B<REQUIRED> RepositoryAccessMode => Str

Set this to one of the following values:

=over

=item *

C<Platform> - The model image is hosted in Amazon ECR.

=item *

C<Vpc> - The model image is hosted in a private Docker registry in your
VPC.

=back



=head2 RepositoryAuthConfig => L<Paws::SageMaker::RepositoryAuthConfig>

(Optional) Specifies an authentication configuration for the private
docker registry where your model image is hosted. Specify a value for
this property only if you specified C<Vpc> as the value for the
C<RepositoryAccessMode> field, and the private Docker registry where
the model image is hosted requires authentication.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

