#!/usr/bin/perl -w

my @ciphers =
(
	'Blowfish',
	'Blowfish_PP',
	'Camellia',
	'Camellia_PP',
	'CAST5',
	'CAST5_PP',
	'DES',
	'DES_PP',
	'IDEA',
	'Rijndael',
	'Rijndael_PP',
	'Twofish',
	'Twofish2',
	'XTEA',
	'XTEA_PP',
);

my %padstyles =
(
	'standard'		=> "\x02\x02",
	'zeroes'		=> "\x00\x02",
	'oneandzeroes'		=> "\x80\x00",
	'rijndael_compat'	=> "\x80\x00",
	'space'			=> "\x20\x20",
	'null'			=> "\x00\x00",
);

use Test::More;

BEGIN { use_ok (Crypt::ECB) }

my $text = "This_is_just_some_dummy_text!\n";
my $key  = "This is an at least 56 Byte long test key!!! It really is.";

my $ecb = Crypt::ECB->new;

foreach my $cipher (@ciphers)
{
	eval { $ecb->cipher($cipher) };

	SKIP: {	skip "$cipher not installed", 2*(keys %padstyles) if $@;

		my $ks = $ecb->keysize || 56;
		$ecb->key( substr($key, 0, $ks) );

		foreach my $padstyle (keys %padstyles)
		{
			$ecb->padding($padstyle);
			my $enc = $ecb->encrypt($text);
			ok($ecb->decrypt($enc) eq $text, 				"$cipher, $padstyle padding: en- and decryption");

			$ecb->padding('none');
			ok($ecb->decrypt($enc) eq $text . $padstyles{$padstyle},	"$cipher, $padstyle padding: padded bytes");
		}
	}
}

done_testing( 2 * @ciphers * (keys %padstyles) + 1 );
