/* -*- buffer-read-only: t -*-
 *
 *    regcharclass.h
 *
 *    Copyright (C) 2007, 2011 by Larry Wall and others
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 * This file is built by regen/regcharclass.pl.
 * Any changes made here will be lost!
 * WARNING: These macros are for internal Perl core use only, and may be
 * changed or removed without notice.
 */


#ifndef H_REGCHARCLASS   /* Guard against nested #includes */
#define H_REGCHARCLASS 1

#if 'A' == 65 /* ASCII/Latin1 */
/*
	LNBREAK: Line Break: \R

	"\x0D\x0A"      # CRLF - Network (Windows) line ending
	\p{VertSpace}
*/
/*** GENERATED CODE ***/
#define is_LNBREAK_safe(s,e,is_utf8)                                        \
( ((e)-(s) > 2) ?                                                           \
    ( ( 0x0A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0C ) ? 1                    \
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x0A == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : ( is_utf8 ) ?                                                         \
	( ( 0xC2 == ((U8*)s)[0] ) ?                                         \
	    ( ( 0x85 == ((U8*)s)[1] ) ? 2 : 0 )                             \
	: ( ( ( 0xE2 == ((U8*)s)[0] ) && ( 0x80 == ((U8*)s)[1] ) ) && ( ( ((U8*)s)[2] & 0xFE ) == 0xA8 ) ) ? 3 : 0 )\
    : ( 0x85 == ((U8*)s)[0] ) )                                             \
: ((e)-(s) > 1) ?                                                           \
    ( ( 0x0A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0C ) ? 1                    \
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x0A == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : ( is_utf8 ) ?                                                         \
	( ( ( 0xC2 == ((U8*)s)[0] ) && ( 0x85 == ((U8*)s)[1] ) ) ? 2 : 0 )  \
    : ( 0x85 == ((U8*)s)[0] ) )                                             \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0D ) ? 1                    \
    : ( !( is_utf8 ) ) ?                                                    \
	( 0x85 == ((U8*)s)[0] )                                             \
    : 0 )                                                                   \
: 0 )

/*** GENERATED CODE ***/
#define is_LNBREAK_utf8_safe(s,e)                                           \
( ((e)-(s) > 2) ?                                                           \
    ( ( 0x0A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0C ) ? 1                    \
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x0A == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : ( 0xC2 == ((U8*)s)[0] ) ?                                             \
	( ( 0x85 == ((U8*)s)[1] ) ? 2 : 0 )                                 \
    : ( ( ( 0xE2 == ((U8*)s)[0] ) && ( 0x80 == ((U8*)s)[1] ) ) && ( ( ((U8*)s)[2] & 0xFE ) == 0xA8 ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( 0x0A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0C ) ? 1                    \
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x0A == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : ( ( 0xC2 == ((U8*)s)[0] ) && ( 0x85 == ((U8*)s)[1] ) ) ? 2 : 0 )      \
: ((e)-(s) > 0) ?                                                           \
    ( 0x0A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0D )                          \
: 0 )

/*** GENERATED CODE ***/
#define is_LNBREAK_latin1_safe(s,e)                                         \
( ((e)-(s) > 1) ?                                                           \
    ( ( ( 0x0A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0C ) || 0x85 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x0A == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0D ) || 0x85 == ((U8*)s)[0] )\
: 0 )

/*
	HORIZWS: Horizontal Whitespace: \h \H

	\p{HorizSpace}
*/
/*** GENERATED CODE ***/
#define is_HORIZWS_high(s)                                                  \
( ( 0xE1 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x9A == ((U8*)s)[1] ) && ( 0x80 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xE2 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x80 == ((U8*)s)[1] ) ?                                             \
	( ( ( ((U8*)s)[2] <= 0x8A ) || 0xAF == ((U8*)s)[2] ) ? 3 : 0 )      \
    : ( ( 0x81 == ((U8*)s)[1] ) && ( 0x9F == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( ( ( 0xE3 == ((U8*)s)[0] ) && ( 0x80 == ((U8*)s)[1] ) ) && ( 0x80 == ((U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_HORIZWS_cp_high(cp)                                              \
( 0x1680 == cp || ( 0x1680 < cp &&                                          \
( ( 0x2000 <= cp && cp <= 0x200A ) || ( 0x200A < cp &&                      \
( 0x202F == cp || ( 0x202F < cp &&                                          \
( 0x205F == cp || 0x3000 == cp ) ) ) ) ) ) )

/*
	VERTWS: Vertical Whitespace: \v \V

	\p{VertSpace}
*/
/*** GENERATED CODE ***/
#define is_VERTWS_high(s)                                                   \
( ( ( ( 0xE2 == ((U8*)s)[0] ) && ( 0x80 == ((U8*)s)[1] ) ) && ( ( ((U8*)s)[2] & 0xFE ) == 0xA8 ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_VERTWS_cp_high(cp)                                               \
( 0x2028 == cp || 0x2029 == cp )

/*
	XDIGIT: Hexadecimal digits

	\p{XDigit}
*/
/*** GENERATED CODE ***/
#define is_XDIGIT_high(s)                                                   \
( ( 0xEF == ((U8*)s)[0] ) ?                                                 \
    ( ( 0xBC == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x90 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x99 ) || ( 0xA1 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0xA6 ) ) ? 3 : 0 )\
    : ( ( 0xBD == ((U8*)s)[1] ) && ( 0x81 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x86 ) ) ? 3 : 0 )\
: 0 )

/*** GENERATED CODE ***/
#define is_XDIGIT_cp_high(cp)                                               \
( ( 0xFF10 <= cp && cp <= 0xFF19 ) || ( 0xFF19 < cp &&                      \
( ( 0xFF21 <= cp && cp <= 0xFF26 ) || ( 0xFF41 <= cp && cp <= 0xFF46 ) ) ) )

/*
	XPERLSPACE: \p{XPerlSpace}

	\p{XPerlSpace}
*/
/*** GENERATED CODE ***/
#define is_XPERLSPACE_high(s)                                               \
( ( 0xE1 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x9A == ((U8*)s)[1] ) && ( 0x80 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xE2 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x80 == ((U8*)s)[1] ) ?                                             \
	( ( ( ((U8*)s)[2] <= 0x8A ) || ( ((U8*)s)[2] & 0xFE ) == 0xA8 || 0xAF == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( ( 0x81 == ((U8*)s)[1] ) && ( 0x9F == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( ( ( 0xE3 == ((U8*)s)[0] ) && ( 0x80 == ((U8*)s)[1] ) ) && ( 0x80 == ((U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_XPERLSPACE_cp_high(cp)                                           \
( 0x1680 == cp || ( 0x1680 < cp &&                                          \
( ( 0x2000 <= cp && cp <= 0x200A ) || ( 0x200A < cp &&                      \
( 0x2028 == cp || ( 0x2028 < cp &&                                          \
( 0x2029 == cp || ( 0x2029 < cp &&                                          \
( 0x202F == cp || ( 0x202F < cp &&                                          \
( 0x205F == cp || 0x3000 == cp ) ) ) ) ) ) ) ) ) ) )

/*
	REPLACEMENT: Unicode REPLACEMENT CHARACTER

	0xFFFD
*/
/*** GENERATED CODE ***/
#define is_REPLACEMENT_utf8_safe(s,e)                                       \
( ( ( ( ( ((e) - (s)) >= 3 ) && ( 0xEF == ((U8*)s)[0] ) ) && ( 0xBF == ((U8*)s)[1] ) ) && ( 0xBD == ((U8*)s)[2] ) ) ? 3 : 0 )

/*
	NONCHAR: Non character code points

	\p{Nchar}
*/
/*** GENERATED CODE ***/
#define is_NONCHAR_utf8(s)                                                  \
( ( 0xEF == ((U8*)s)[0] ) ?                                                 \
    ( ( 0xB7 == ((U8*)s)[1] ) ?                                             \
	( ( 0x90 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0xAF ) ? 3 : 0 )          \
    : ( ( 0xBF == ((U8*)s)[1] ) && ( ((U8*)s)[2] >= 0xBE ) ) ? 3 : 0 )      \
: ( 0xF0 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ( ((U8*)s)[1] == 0x9F || ( ( ((U8*)s)[1] & 0xEF ) == 0xAF ) ) && ( 0xBF == ((U8*)s)[2] ) ) && ( ((U8*)s)[3] >= 0xBE ) ) ? 4 : 0 )\
: ( 0xF1 <= ((U8*)s)[0] && ((U8*)s)[0] <= 0xF3 ) ?                          \
    ( ( ( ( ( ((U8*)s)[1] & 0xCF ) == 0x8F ) && ( 0xBF == ((U8*)s)[2] ) ) && ( ((U8*)s)[3] >= 0xBE ) ) ? 4 : 0 )\
: ( ( ( ( 0xF4 == ((U8*)s)[0] ) && ( 0x8F == ((U8*)s)[1] ) ) && ( 0xBF == ((U8*)s)[2] ) ) && ( ((U8*)s)[3] >= 0xBE ) ) ? 4 : 0 )

/*
	SURROGATE: Surrogate characters

	\p{Gc=Cs}
*/
/*** GENERATED CODE ***/
#define is_SURROGATE_utf8(s)                                                \
( ( ( 0xED == ((U8*)s)[0] ) && ( ((U8*)s)[1] >= 0xA0 ) ) ? 3 : 0 )

/*
	GCB_L: Grapheme_Cluster_Break=L

	\p{_X_GCB_L}
*/
/*** GENERATED CODE ***/
#define is_GCB_L_utf8(s)                                                    \
( ( 0xE1 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x84 == ((U8*)s)[1] ) ?                                             \
	3                                                                   \
    : ( ( 0x85 == ((U8*)s)[1] ) && ( ((U8*)s)[2] <= 0x9F ) ) ? 3 : 0 )      \
: ( ( ( 0xEA == ((U8*)s)[0] ) && ( 0xA5 == ((U8*)s)[1] ) ) && ( 0xA0 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0xBC ) ) ? 3 : 0 )

/*
	GCB_LV_LVT_V: Grapheme_Cluster_Break=(LV or LVT or V)

	\p{_X_LV_LVT_V}
*/
/*** GENERATED CODE ***/
#define is_GCB_LV_LVT_V_utf8(s)                                             \
( ( 0xE1 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x85 == ((U8*)s)[1] ) ?                                             \
	( ( ((U8*)s)[2] >= 0xA0 ) ? 3 : 0 )                                 \
    : ( ( 0x86 == ((U8*)s)[1] ) && ( ((U8*)s)[2] <= 0xA7 ) ) ? 3 : 0 )      \
: ( 0xEA == ((U8*)s)[0] ) ?                                                 \
    ( ( ((U8*)s)[1] >= 0xB0 ) ?                                             \
	3                                                                   \
    : 0 )                                                                   \
: ( 0xEB == ((U8*)s)[0] || 0xEC == ((U8*)s)[0] ) ?                          \
    3                                                                       \
: ( 0xED == ((U8*)s)[0] ) ?                                                 \
    ( ( ((U8*)s)[1] <= 0x9D ) ?                                             \
	3                                                                   \
    : ( 0x9E == ((U8*)s)[1] ) ?                                             \
	( ( ( ((U8*)s)[2] <= 0xA3 ) || ( ((U8*)s)[2] >= 0xB0 ) ) ? 3 : 0 )  \
    : ( ( 0x9F == ((U8*)s)[1] ) && ( ((U8*)s)[2] <= 0x86 ) ) ? 3 : 0 )      \
: 0 )

/*
	GCB_Prepend: Grapheme_Cluster_Break=Prepend

	\p{_X_GCB_Prepend}
*/
/*** GENERATED CODE ***/
#define is_GCB_Prepend_utf8(s)                                              \
( 0 )

/*
	GCB_RI: Grapheme_Cluster_Break=RI

	\p{_X_RI}
*/
/*** GENERATED CODE ***/
#define is_GCB_RI_utf8(s)                                                   \
( ( ( ( ( 0xF0 == ((U8*)s)[0] ) && ( 0x9F == ((U8*)s)[1] ) ) && ( 0x87 == ((U8*)s)[2] ) ) && ( ((U8*)s)[3] >= 0xA6 ) ) ? 4 : 0 )

/*
	GCB_SPECIAL_BEGIN_START: Grapheme_Cluster_Break=special_begin_starts

	\p{_X_Special_Begin_Start}
*/
/*** GENERATED CODE ***/
#define is_GCB_SPECIAL_BEGIN_START_utf8(s)                                  \
( ( 0xE1 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ((U8*)s)[1] & 0xFC ) == 0x84 ) ?                                  \
	3                                                                   \
    : 0 )                                                                   \
: ( 0xEA == ((U8*)s)[0] ) ?                                                 \
    ( ( 0xA5 == ((U8*)s)[1] ) ?                                             \
	( ( 0xA0 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0xBC ) ? 3 : 0 )          \
    : ( ((U8*)s)[1] >= 0xB0 ) ?                                             \
	3                                                                   \
    : 0 )                                                                   \
: ( 0xEB == ((U8*)s)[0] || 0xEC == ((U8*)s)[0] ) ?                          \
    3                                                                       \
: ( 0xED == ((U8*)s)[0] ) ?                                                 \
    ( ( ((U8*)s)[1] <= 0x9D ) ?                                             \
	3                                                                   \
    : ( 0x9E == ((U8*)s)[1] ) ?                                             \
	( ( ( ((U8*)s)[2] <= 0xA3 ) || ( ((U8*)s)[2] >= 0xB0 ) ) ? 3 : 0 )  \
    : ( ( 0x9F == ((U8*)s)[1] ) && ( ( ((U8*)s)[2] <= 0x86 ) || ( 0x8B <= ((U8*)s)[2] && ((U8*)s)[2] <= 0xBB ) ) ) ? 3 : 0 )\
: ( ( ( ( 0xF0 == ((U8*)s)[0] ) && ( 0x9F == ((U8*)s)[1] ) ) && ( 0x87 == ((U8*)s)[2] ) ) && ( ((U8*)s)[3] >= 0xA6 ) ) ? 4 : 0 )

/*
	GCB_T: Grapheme_Cluster_Break=T

	\p{_X_GCB_T}
*/
/*** GENERATED CODE ***/
#define is_GCB_T_utf8(s)                                                    \
( ( 0xE1 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x86 == ((U8*)s)[1] ) ?                                             \
	( ( ((U8*)s)[2] >= 0xA8 ) ? 3 : 0 )                                 \
    : ( 0x87 == ((U8*)s)[1] ) ?                                             \
	3                                                                   \
    : 0 )                                                                   \
: ( ( ( 0xED == ((U8*)s)[0] ) && ( 0x9F == ((U8*)s)[1] ) ) && ( 0x8B <= ((U8*)s)[2] && ((U8*)s)[2] <= 0xBB ) ) ? 3 : 0 )

/*
	GCB_V: Grapheme_Cluster_Break=V

	\p{_X_GCB_V}
*/
/*** GENERATED CODE ***/
#define is_GCB_V_utf8(s)                                                    \
( ( 0xE1 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x85 == ((U8*)s)[1] ) ?                                             \
	( ( ((U8*)s)[2] >= 0xA0 ) ? 3 : 0 )                                 \
    : ( ( 0x86 == ((U8*)s)[1] ) && ( ((U8*)s)[2] <= 0xA7 ) ) ? 3 : 0 )      \
: ( 0xED == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x9E == ((U8*)s)[1] ) ?                                             \
	( ( ((U8*)s)[2] >= 0xB0 ) ? 3 : 0 )                                 \
    : ( ( 0x9F == ((U8*)s)[1] ) && ( ((U8*)s)[2] <= 0x86 ) ) ? 3 : 0 )      \
: 0 )

/*
	QUOTEMETA: Meta-characters that \Q should quote

	\p{_Perl_Quotemeta}
*/
/*** GENERATED CODE ***/
#define is_QUOTEMETA_high(s)                                                \
( ( 0xCD == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x8F == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xD8 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x9C == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xE1 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x85 == ((U8*)s)[1] ) ?                                             \
	( ( 0x9F == ((U8*)s)[2] || 0xA0 == ((U8*)s)[2] ) ? 3 : 0 )          \
    : ( 0x9A == ((U8*)s)[1] ) ?                                             \
	( ( 0x80 == ((U8*)s)[2] ) ? 3 : 0 )                                 \
    : ( 0x9E == ((U8*)s)[1] ) ?                                             \
	( ( ( ((U8*)s)[2] & 0xFE ) == 0xB4 ) ? 3 : 0 )                      \
    : ( ( 0xA0 == ((U8*)s)[1] ) && ( 0x8B <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x8E ) ) ? 3 : 0 )\
: ( 0xE2 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x80 == ((U8*)s)[1] ) ?                                             \
	( ( ((U8*)s)[2] <= 0xBE ) ? 3 : 0 )                                 \
    : ( 0x81 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x81 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x93 ) || ( 0x95 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0xAF ) ) ? 3 : 0 )\
    : ( 0x86 == ((U8*)s)[1] ) ?                                             \
	( ( ((U8*)s)[2] >= 0x90 ) ? 3 : 0 )                                 \
    : ( ( 0x87 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x90 ) || ( 0x94 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x9C ) || ( 0x9F <= ((U8*)s)[1] && ((U8*)s)[1] <= 0xAF ) || ( ((U8*)s)[1] & 0xFE ) == 0xB8 ) ?\
	3                                                                   \
    : ( 0x91 == ((U8*)s)[1] ) ?                                             \
	( ( ((U8*)s)[2] <= 0x9F ) ? 3 : 0 )                                 \
    : ( 0x9D == ((U8*)s)[1] ) ?                                             \
	( ( ((U8*)s)[2] <= 0xB5 ) ? 3 : 0 )                                 \
    : ( ( 0x9E == ((U8*)s)[1] ) && ( ((U8*)s)[2] >= 0x94 ) ) ? 3 : 0 )      \
: ( 0xE3 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x80 == ((U8*)s)[1] ) ?                                             \
	( ( ( ((U8*)s)[2] <= 0x83 ) || ( 0x88 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0xA0 ) || 0xB0 == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( ( 0x85 == ((U8*)s)[1] ) && ( 0xA4 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xEF == ((U8*)s)[0] ) ?                                                 \
    ( ( 0xB4 == ((U8*)s)[1] ) ?                                             \
	( ( ((U8*)s)[2] >= 0xBE ) ? 3 : 0 )                                 \
    : ( 0xB8 == ((U8*)s)[1] ) ?                                             \
	( ( ((U8*)s)[2] <= 0x8F ) ? 3 : 0 )                                 \
    : ( 0xB9 == ((U8*)s)[1] ) ?                                             \
	( ( 0x85 == ((U8*)s)[2] || 0x86 == ((U8*)s)[2] ) ? 3 : 0 )          \
    : ( 0xBB == ((U8*)s)[1] ) ?                                             \
	( ( 0xBF == ((U8*)s)[2] ) ? 3 : 0 )                                 \
    : ( 0xBE == ((U8*)s)[1] ) ?                                             \
	( ( 0xA0 == ((U8*)s)[2] ) ? 3 : 0 )                                 \
    : ( ( 0xBF == ((U8*)s)[1] ) && ( 0xB0 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0xB8 ) ) ? 3 : 0 )\
: ( 0xF0 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x9B == ((U8*)s)[1] ) ?                                             \
	( ( ( 0xB2 == ((U8*)s)[2] ) && ( ( ((U8*)s)[3] & 0xFC ) == 0xA0 ) ) ? 4 : 0 )\
    : ( ( ( 0x9D == ((U8*)s)[1] ) && ( 0x85 == ((U8*)s)[2] ) ) && ( 0xB3 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0xBA ) ) ? 4 : 0 )\
: ( ( 0xF3 == ((U8*)s)[0] ) && ( 0xA0 == ((U8*)s)[1] ) ) ? 4 : 0 )

/*
	MULTI_CHAR_FOLD: multi-char strings that are folded to by a single character

	&regcharclass_multi_char_folds::multi_char_folds(1)
*/
/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part0(s,e)                             \
( ( 0x61 == ((U8*)s)[0] ) ?                                                 \
	( ( ( 0xCA == ((U8*)s)[1] ) && ( 0xBE == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x66 == ((U8*)s)[0] ) ?                                             \
	( ( 0x66 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x69 == ((U8*)s)[2] || 0x6C == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x69 == ((U8*)s)[1] || 0x6C == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x68 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0xB1 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x69 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x87 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x6A == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x8C == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x73 == ((U8*)s)[0] ) ?                                             \
	( ( 0x73 == ((U8*)s)[1] || 0x74 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x74 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x88 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x77 == ((U8*)s)[0] || 0x79 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x8A == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xC5 == ((U8*)s)[0] ) ?                                             \
	( ( ( ( 0xBF == ((U8*)s)[1] ) && ( 0xC5 == ((U8*)s)[2] ) ) && ( 0xBF == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xCA == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xBC == ((U8*)s)[1] ) && ( 0x6E == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xCE == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFD ) == 0xAC ) ?                              \
	    ( ( ( 0xCE == ((U8*)s)[2] ) && ( 0xB9 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0xB1 == ((U8*)s)[1] || 0xB7 == ((U8*)s)[1] ) ?                  \
	    ( ( 0xCD == ((U8*)s)[2] ) ?                                     \
		( ( 0x82 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xCE == ((U8*)s)[2] ) && ( 0xB9 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0xB9 == ((U8*)s)[1] ) && ( 0xCD == ((U8*)s)[2] ) ) && ( 0x82 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xCF == ((U8*)s)[0] ) ?                                             \
	( ( 0x81 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xCC == ((U8*)s)[2] ) && ( 0x93 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x85 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xCC == ((U8*)s)[2] ) ?                                     \
		( ( 0x93 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xCD == ((U8*)s)[2] ) && ( 0x82 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x89 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xCD == ((U8*)s)[2] ) ?                                     \
		( ( 0x82 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xCE == ((U8*)s)[2] ) && ( 0xB9 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x8E == ((U8*)s)[1] ) && ( 0xCE == ((U8*)s)[2] ) ) && ( 0xB9 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xD5 == ((U8*)s)[0] ) ?                                             \
	( ( 0xA5 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xD6 == ((U8*)s)[2] ) && ( 0x82 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0xB4 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xD5 == ((U8*)s)[2] ) && ( ( ( ((U8*)s)[3] & 0xF7 ) == 0xA5 ) || ((U8*)s)[3] == 0xAB || ((U8*)s)[3] == 0xB6 ) ) ? 4 : 0 )\
	: ( ( ( 0xBE == ((U8*)s)[1] ) && ( 0xD5 == ((U8*)s)[2] ) ) && ( 0xB6 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xE1 == ((U8*)s)[0] ) ?                                             \
	( ( 0xBC == ((U8*)s)[1] ) ?                                         \
	    ( ( ( ( ( ((U8*)s)[2] & 0xD8 ) == 0x80 ) && ( 0xCE == ((U8*)s)[3] ) ) && ( 0xB9 == ((U8*)s)[4] ) ) ? 5 : 0 )\
	: ( ( ( ( 0xBD == ((U8*)s)[1] ) && ( ( ( ((U8*)s)[2] & 0xF8 ) == 0xA0 ) || ( ( ((U8*)s)[2] & 0xFB ) == 0xB0 ) || ((U8*)s)[2] == 0xBC ) ) && ( 0xCE == ((U8*)s)[3] ) ) && ( 0xB9 == ((U8*)s)[4] ) ) ? 5 : 0 )\
    : 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part1(s,e)                             \
( ((e)-(s) > 3) ?                                                           \
    ( ( 0x61 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCA == ((U8*)s)[1] ) && ( 0xBE == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x66 == ((U8*)s)[0] ) ?                                             \
	( ( 0x66 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x69 == ((U8*)s)[2] || 0x6C == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x69 == ((U8*)s)[1] || 0x6C == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x68 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0xB1 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x69 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x87 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x6A == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x8C == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x73 == ((U8*)s)[0] ) ?                                             \
	( ( 0x73 == ((U8*)s)[1] || 0x74 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x74 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x88 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x77 == ((U8*)s)[0] || 0x79 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x8A == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xC5 == ((U8*)s)[0] ) ?                                             \
	( ( ( ( 0xBF == ((U8*)s)[1] ) && ( 0xC5 == ((U8*)s)[2] ) ) && ( 0xBF == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xCA == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xBC == ((U8*)s)[1] ) && ( 0x6E == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xCE == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFD ) == 0xAC ) ?                              \
	    ( ( ( 0xCE == ((U8*)s)[2] ) && ( 0xB9 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0xB1 == ((U8*)s)[1] || 0xB7 == ((U8*)s)[1] ) ?                  \
	    ( ( 0xCD == ((U8*)s)[2] ) ?                                     \
		( ( 0x82 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xCE == ((U8*)s)[2] ) && ( 0xB9 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0xB9 == ((U8*)s)[1] ) && ( 0xCD == ((U8*)s)[2] ) ) && ( 0x82 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xCF == ((U8*)s)[0] ) ?                                             \
	( ( 0x81 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xCC == ((U8*)s)[2] ) && ( 0x93 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x85 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xCC == ((U8*)s)[2] ) ?                                     \
		( ( 0x93 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xCD == ((U8*)s)[2] ) && ( 0x82 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x89 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xCD == ((U8*)s)[2] ) ?                                     \
		( ( 0x82 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xCE == ((U8*)s)[2] ) && ( 0xB9 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x8E == ((U8*)s)[1] ) && ( 0xCE == ((U8*)s)[2] ) ) && ( 0xB9 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xD5 == ((U8*)s)[0] ) ?                                             \
	( ( 0xA5 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xD6 == ((U8*)s)[2] ) && ( 0x82 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0xB4 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xD5 == ((U8*)s)[2] ) && ( ( ( ((U8*)s)[3] & 0xF7 ) == 0xA5 ) || ((U8*)s)[3] == 0xAB || ((U8*)s)[3] == 0xB6 ) ) ? 4 : 0 )\
	: ( ( ( 0xBE == ((U8*)s)[1] ) && ( 0xD5 == ((U8*)s)[2] ) ) && ( 0xB6 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ((e)-(s) > 2) ?                                                           \
    ( ( 0x61 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCA == ((U8*)s)[1] ) && ( 0xBE == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x66 == ((U8*)s)[0] ) ?                                             \
	( ( 0x66 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x69 == ((U8*)s)[2] || 0x6C == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x69 == ((U8*)s)[1] || 0x6C == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x68 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0xB1 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x69 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x87 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x6A == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x8C == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x73 == ((U8*)s)[0] ) ?                                             \
	( ( 0x73 == ((U8*)s)[1] || 0x74 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x74 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x88 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x77 == ((U8*)s)[0] || 0x79 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x8A == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( ( ( 0xCA == ((U8*)s)[0] ) && ( 0xBC == ((U8*)s)[1] ) ) && ( 0x6E == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( 0x66 == ((U8*)s)[0] ) ?                                             \
	( ( 0x66 == ((U8*)s)[1] || 0x69 == ((U8*)s)[1] || 0x6C == ((U8*)s)[1] ) ? 2 : 0 )\
    : ( ( 0x73 == ((U8*)s)[0] ) && ( 0x73 == ((U8*)s)[1] || 0x74 == ((U8*)s)[1] ) ) ? 2 : 0 )\
: 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe(s,e)                                   \
( ((e)-(s) > 5) ?                                                           \
    ( ( 0x61 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCA == ((U8*)s)[1] ) && ( 0xBE == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x66 == ((U8*)s)[0] ) ?                                             \
	( ( 0x66 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x69 == ((U8*)s)[2] || 0x6C == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x69 == ((U8*)s)[1] || 0x6C == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x68 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0xB1 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x69 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x87 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x6A == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x8C == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x73 == ((U8*)s)[0] ) ?                                             \
	( ( 0x73 == ((U8*)s)[1] || 0x74 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x74 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x88 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x77 == ((U8*)s)[0] || 0x79 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xCC == ((U8*)s)[1] ) && ( 0x8A == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xC5 == ((U8*)s)[0] ) ?                                             \
	( ( ( ( 0xBF == ((U8*)s)[1] ) && ( 0xC5 == ((U8*)s)[2] ) ) && ( 0xBF == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xCA == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xBC == ((U8*)s)[1] ) && ( 0x6E == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xCE == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFD ) == 0xAC ) ?                              \
	    ( ( ( 0xCE == ((U8*)s)[2] ) && ( 0xB9 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0xB1 == ((U8*)s)[1] || 0xB7 == ((U8*)s)[1] ) ?                  \
	    ( ( 0xCD == ((U8*)s)[2] ) ?                                     \
		( ( 0x82 == ((U8*)s)[3] ) ?                                 \
		    ( ( ( 0xCE == ((U8*)s)[4] ) && ( 0xB9 == ((U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xCE == ((U8*)s)[2] ) && ( 0xB9 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0xB9 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xCC == ((U8*)s)[2] ) ?                                     \
		( ( 0x88 == ((U8*)s)[3] ) ?                                 \
		    ( ( 0xCC == ((U8*)s)[4] ) ?                             \
			( ( ( ((U8*)s)[5] & 0xFE ) == 0x80 ) ? 6 : 0 )      \
		    : ( ( 0xCD == ((U8*)s)[4] ) && ( 0x82 == ((U8*)s)[5] ) ) ? 6 : 0 )\
		: 0 )                                                       \
	    : ( ( 0xCD == ((U8*)s)[2] ) && ( 0x82 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: 0 )                                                               \
    : ( 0xCF == ((U8*)s)[0] ) ?                                             \
	( ( 0x81 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xCC == ((U8*)s)[2] ) && ( 0x93 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x85 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xCC == ((U8*)s)[2] ) ?                                     \
		( ( 0x88 == ((U8*)s)[3] ) ?                                 \
		    ( ( 0xCC == ((U8*)s)[4] ) ?                             \
			( ( ( ((U8*)s)[5] & 0xFE ) == 0x80 ) ? 6 : 0 )      \
		    : ( ( 0xCD == ((U8*)s)[4] ) && ( 0x82 == ((U8*)s)[5] ) ) ? 6 : 0 )\
		: ( 0x93 == ((U8*)s)[3] ) ?                                 \
		    ( ( 0xCC == ((U8*)s)[4] ) ?                             \
			( ( ( ((U8*)s)[5] & 0xFE ) == 0x80 ) ? 6 : 4 )      \
		    : ( ( 0xCD == ((U8*)s)[4] ) && ( 0x82 == ((U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xCD == ((U8*)s)[2] ) && ( 0x82 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x89 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xCD == ((U8*)s)[2] ) ?                                     \
		( ( 0x82 == ((U8*)s)[3] ) ?                                 \
		    ( ( ( 0xCE == ((U8*)s)[4] ) && ( 0xB9 == ((U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xCE == ((U8*)s)[2] ) && ( 0xB9 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x8E == ((U8*)s)[1] ) && ( 0xCE == ((U8*)s)[2] ) ) && ( 0xB9 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xD5 == ((U8*)s)[0] ) ?                                             \
	( ( 0xA5 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xD6 == ((U8*)s)[2] ) && ( 0x82 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0xB4 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xD5 == ((U8*)s)[2] ) && ( ( ( ((U8*)s)[3] & 0xF7 ) == 0xA5 ) || ((U8*)s)[3] == 0xAB || ((U8*)s)[3] == 0xB6 ) ) ? 4 : 0 )\
	: ( ( ( 0xBE == ((U8*)s)[1] ) && ( 0xD5 == ((U8*)s)[2] ) ) && ( 0xB6 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xE1 == ((U8*)s)[0] ) ?                                             \
	( ( 0xBC == ((U8*)s)[1] ) ?                                         \
	    ( ( ( ( ( ((U8*)s)[2] & 0xD8 ) == 0x80 ) && ( 0xCE == ((U8*)s)[3] ) ) && ( 0xB9 == ((U8*)s)[4] ) ) ? 5 : 0 )\
	: ( ( ( ( 0xBD == ((U8*)s)[1] ) && ( ( ( ((U8*)s)[2] & 0xF8 ) == 0xA0 ) || ( ( ((U8*)s)[2] & 0xFB ) == 0xB0 ) || ((U8*)s)[2] == 0xBC ) ) && ( 0xCE == ((U8*)s)[3] ) ) && ( 0xB9 == ((U8*)s)[4] ) ) ? 5 : 0 )\
    : 0 )                                                                   \
: ((e)-(s) > 4) ? is_MULTI_CHAR_FOLD_utf8_safe_part0(s,e) : is_MULTI_CHAR_FOLD_utf8_safe_part1(s,e) )

/*
	MULTI_CHAR_FOLD: multi-char strings that are folded to by a single character

	&regcharclass_multi_char_folds::multi_char_folds(0)
*/
/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_latin1_safe(s,e)                                 \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( ((U8*)s)[0] & 0xDF ) == 0x46 ) ?                                  \
	( ( ( ((U8*)s)[1] & 0xDF ) == 0x46 ) ?                              \
	    ( ( ( ( ((U8*)s)[2] & 0xDF ) == 0x49 ) || ( ( ((U8*)s)[2] & 0xDF ) == 0x4C ) ) ? 3 : 2 )\
	: ( ( ( ((U8*)s)[1] & 0xDF ) == 0x49 ) || ( ( ((U8*)s)[1] & 0xDF ) == 0x4C ) ) ? 2 : 0 )\
    : ( ( ( ((U8*)s)[0] & 0xDF ) == 0x53 ) && ( ( ( ((U8*)s)[1] & 0xDF ) == 0x53 ) || ( ( ((U8*)s)[1] & 0xDF ) == 0x54 ) ) ) ? 2 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( ((U8*)s)[0] & 0xDF ) == 0x46 ) ?                                  \
	( ( ( ( ((U8*)s)[1] & 0xDF ) == 0x46 ) || ( ( ((U8*)s)[1] & 0xDF ) == 0x49 ) || ( ( ((U8*)s)[1] & 0xDF ) == 0x4C ) ) ? 2 : 0 )\
    : ( ( ( ((U8*)s)[0] & 0xDF ) == 0x53 ) && ( ( ( ((U8*)s)[1] & 0xDF ) == 0x53 ) || ( ( ((U8*)s)[1] & 0xDF ) == 0x54 ) ) ) ? 2 : 0 )\
: 0 )

/*
	FOLDS_TO_MULTI: characters that fold to multi-char strings

	\p{_Perl_Folds_To_Multi_Char}
*/
/*** GENERATED CODE ***/
#define is_FOLDS_TO_MULTI_utf8(s)                                           \
( ( 0xC3 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x9F == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xC4 == ((U8*)s)[0] || 0xC7 == ((U8*)s)[0] ) ?                          \
    ( ( 0xB0 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xC5 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x89 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xCE == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ((U8*)s)[1] & 0xDF ) == 0x90 ) ? 2 : 0 )                          \
: ( 0xD6 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x87 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xE1 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0xBA == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x96 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x9A ) || 0x9E == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( 0xBD == ((U8*)s)[1] ) ?                                             \
	( ( ( ((U8*)s)[2] & 0xF9 ) == 0x90 ) ? 3 : 0 )                      \
    : ( 0xBE == ((U8*)s)[1] ) ?                                             \
	( ( ( ( ((U8*)s)[2] & 0xE0 ) == 0x80 ) || ( ( ((U8*)s)[2] & 0xF0 ) == 0xA0 ) || ( ( ((U8*)s)[2] & 0xFA ) == 0xB2 ) || ( ( ((U8*)s)[2] & 0xF7 ) == 0xB4 ) ) ? 3 : 0 )\
    : ( ( 0xBF == ((U8*)s)[1] ) && ( ( ( ((U8*)s)[2] & 0xCA ) == 0x82 ) || ( ( ((U8*)s)[2] & 0xF7 ) == 0x84 ) || ((U8*)s)[2] == 0xA4 || ( ( ((U8*)s)[2] & 0xF7 ) == 0xB4 ) ) ) ? 3 : 0 )\
: ( ( ( 0xEF == ((U8*)s)[0] ) && ( 0xAC == ((U8*)s)[1] ) ) && ( ( ((U8*)s)[2] <= 0x86 ) || ( 0x93 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x97 ) ) ) ? 3 : 0 )

/*
	PROBLEMATIC_LOCALE_FOLD: characters whose fold is problematic under locale

	\p{_Perl_Problematic_Locale_Folds}
*/
/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLD_utf8(s)                                  \
( ( ((U8*)s)[0] <= 0x7F ) ? 1                                               \
: ( ( ((U8*)s)[0] & 0xFE ) == 0xC2 ) ?                                      \
    2                                                                       \
: ( 0xC4 == ((U8*)s)[0] || 0xC7 == ((U8*)s)[0] ) ?                          \
    ( ( 0xB0 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xC5 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x89 == ((U8*)s)[1] || 0xB8 == ((U8*)s)[1] || 0xBF == ((U8*)s)[1] ) ? 2 : 0 )\
: ( 0xCE == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ((U8*)s)[1] & 0xDF ) == 0x9C ) ? 2 : 0 )                          \
: ( 0xE1 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0xBA == ((U8*)s)[1] ) && ( ( 0x96 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x9A ) || 0x9E == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xE2 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x84 == ((U8*)s)[1] ) && ( ( ((U8*)s)[2] & 0xFE ) == 0xAA ) ) ? 3 : 0 )\
: ( ( ( 0xEF == ((U8*)s)[0] ) && ( 0xAC == ((U8*)s)[1] ) ) && ( ((U8*)s)[2] <= 0x86 ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLD_cp(cp)                                   \
( cp <= 0xFF || ( 0xFF < cp &&                                              \
( 0x130 == cp || ( 0x130 < cp &&                                            \
( 0x149 == cp || ( 0x149 < cp &&                                            \
( 0x178 == cp || ( 0x178 < cp &&                                            \
( 0x17F == cp || ( 0x17F < cp &&                                            \
( 0x1F0 == cp || ( 0x1F0 < cp &&                                            \
( 0x39C == cp || ( 0x39C < cp &&                                            \
( 0x3BC == cp || ( 0x3BC < cp &&                                            \
( ( 0x1E96 <= cp && cp <= 0x1E9A ) || ( 0x1E9A < cp &&                      \
( 0x1E9E == cp || ( 0x1E9E < cp &&                                          \
( 0x212A == cp || ( 0x212A < cp &&                                          \
( 0x212B == cp || ( 0xFB00 <= cp && cp <= 0xFB06 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

/*
	PROBLEMATIC_LOCALE_FOLDEDS_START: The first folded character of folds which are problematic under locale

	\p{_Perl_Problematic_Locale_Foldeds_Start}
*/
/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLDEDS_START_utf8(s)                         \
( ( ((U8*)s)[0] <= 0x7F ) ? 1                                               \
: ( ( ((U8*)s)[0] & 0xFE ) == 0xC2 ) ?                                      \
    2                                                                       \
: ( 0xC4 == ((U8*)s)[0] || 0xC7 == ((U8*)s)[0] ) ?                          \
    ( ( 0xB0 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xC5 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x89 == ((U8*)s)[1] || 0xB8 == ((U8*)s)[1] || 0xBF == ((U8*)s)[1] ) ? 2 : 0 )\
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( 0xBC == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xCE == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ((U8*)s)[1] & 0xDF ) == 0x9C ) ? 2 : 0 )                          \
: ( 0xE1 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0xBA == ((U8*)s)[1] ) && ( ( 0x96 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x9A ) || 0x9E == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xE2 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x84 == ((U8*)s)[1] ) && ( ( ((U8*)s)[2] & 0xFE ) == 0xAA ) ) ? 3 : 0 )\
: ( ( ( 0xEF == ((U8*)s)[0] ) && ( 0xAC == ((U8*)s)[1] ) ) && ( ((U8*)s)[2] <= 0x86 ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLDEDS_START_cp(cp)                          \
( cp <= 0xFF || ( 0xFF < cp &&                                              \
( 0x130 == cp || ( 0x130 < cp &&                                            \
( 0x149 == cp || ( 0x149 < cp &&                                            \
( 0x178 == cp || ( 0x178 < cp &&                                            \
( 0x17F == cp || ( 0x17F < cp &&                                            \
( 0x1F0 == cp || ( 0x1F0 < cp &&                                            \
( 0x2BC == cp || ( 0x2BC < cp &&                                            \
( 0x39C == cp || ( 0x39C < cp &&                                            \
( 0x3BC == cp || ( 0x3BC < cp &&                                            \
( ( 0x1E96 <= cp && cp <= 0x1E9A ) || ( 0x1E9A < cp &&                      \
( 0x1E9E == cp || ( 0x1E9E < cp &&                                          \
( 0x212A == cp || ( 0x212A < cp &&                                          \
( 0x212B == cp || ( 0xFB00 <= cp && cp <= 0xFB06 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

/*
	PATWS: pattern white space

	\p{PatWS}
*/
/*** GENERATED CODE ***/
#define is_PATWS_safe(s,e,is_utf8)                                          \
( ( LIKELY((e) > (s)) ) ?                                                   \
    ( ( ( 0x09 <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0D ) || 0x20 == ((U8*)s)[0] ) ? 1\
    : (! is_utf8 ) ?                                                        \
	    ( 0x85 == ((U8*)s)[0] )                                         \
	: ( LIKELY(((e) - (s)) >= UTF8SKIP(s)) ) ?                          \
	    ( ( 0xC2 == ((U8*)s)[0] ) ?                                     \
		( ( 0x85 == ((U8*)s)[1] ) ? 2 : 0 )                         \
	    : ( ( ( 0xE2 == ((U8*)s)[0] ) && ( 0x80 == ((U8*)s)[1] ) ) && ( ( ((U8*)s)[2] & 0xFE ) == 0x8E || ( ((U8*)s)[2] & 0xFE ) == 0xA8 ) ) ? 3 : 0 )\
	: 0 )                                                               \
: 0 )

/*** GENERATED CODE ***/
#define is_PATWS_cp(cp)                                                     \
( ( 0x09 <= cp && cp <= 0x0D ) || ( 0x0D < cp &&                            \
( 0x20 == cp || ( 0x20 < cp &&                                              \
( 0x85 == cp || ( 0x85 < cp &&                                              \
( 0x200E == cp || ( 0x200E < cp &&                                          \
( 0x200F == cp || ( 0x200F < cp &&                                          \
( 0x2028 == cp || 0x2029 == cp ) ) ) ) ) ) ) ) ) ) )

#endif	/* ASCII/Latin1 */

#if 'A' == 193 /* EBCDIC 1047 */ \
     && '\\' == 224 && '[' == 173 && ']' == 189 && '{' == 192 && '}' == 208 \
     && '^' == 95 && '~' == 161 && '!' == 90 && '#' == 123 && '|' == 79 \
     && '$' == 91 && '@' == 124 && '`' == 121
/*
	LNBREAK: Line Break: \R

	"\x0D\x0A"      # CRLF - Network (Windows) line ending
	\p{VertSpace}
*/
/*** GENERATED CODE ***/
#define is_LNBREAK_safe(s,e,is_utf8)                                        \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( 0x0B == ((U8*)s)[0] || 0x0C == ((U8*)s)[0] ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x15 == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : ( ( ( ( is_utf8 ) && ( 0xCA == ((U8*)s)[0] ) ) && ( 0x42 == ((U8*)s)[1] ) ) && ( 0x49 == ((U8*)s)[2] || 0x4A == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( 0x0B == ((U8*)s)[0] || 0x0C == ((U8*)s)[0] ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x15 == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0B <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0D ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] )\
: 0 )

/*** GENERATED CODE ***/
#define is_LNBREAK_utf8_safe(s,e)                                           \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( 0x0B == ((U8*)s)[0] || 0x0C == ((U8*)s)[0] ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x15 == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : ( ( ( 0xCA == ((U8*)s)[0] ) && ( 0x42 == ((U8*)s)[1] ) ) && ( 0x49 == ((U8*)s)[2] || 0x4A == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( 0x0B == ((U8*)s)[0] || 0x0C == ((U8*)s)[0] ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x15 == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0B <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0D ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] )\
: 0 )

/*** GENERATED CODE ***/
#define is_LNBREAK_latin1_safe(s,e)                                         \
( ((e)-(s) > 1) ?                                                           \
    ( ( ( 0x0B == ((U8*)s)[0] || 0x0C == ((U8*)s)[0] ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x15 == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0B <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0D ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] )\
: 0 )

/*
	HORIZWS: Horizontal Whitespace: \h \H

	\p{HorizSpace}
*/
/*** GENERATED CODE ***/
#define is_HORIZWS_high(s)                                                  \
( ( 0xBC == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x63 == ((U8*)s)[1] ) && ( 0x41 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x41 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || 0x51 == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x42 == ((U8*)s)[1] ) ?                                             \
	( ( 0x56 == ((U8*)s)[2] ) ? 3 : 0 )                                 \
    : ( ( 0x43 == ((U8*)s)[1] ) && ( 0x73 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( ( ( 0xCE == ((U8*)s)[0] ) && ( 0x41 == ((U8*)s)[1] ) ) && ( 0x41 == ((U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_HORIZWS_cp_high(cp)                                              \
( 0x1680 == cp || ( 0x1680 < cp &&                                          \
( ( 0x2000 <= cp && cp <= 0x200A ) || ( 0x200A < cp &&                      \
( 0x202F == cp || ( 0x202F < cp &&                                          \
( 0x205F == cp || 0x3000 == cp ) ) ) ) ) ) )

/*
	VERTWS: Vertical Whitespace: \v \V

	\p{VertSpace}
*/
/*** GENERATED CODE ***/
#define is_VERTWS_high(s)                                                   \
( ( ( ( 0xCA == ((U8*)s)[0] ) && ( 0x42 == ((U8*)s)[1] ) ) && ( 0x49 == ((U8*)s)[2] || 0x4A == ((U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_VERTWS_cp_high(cp)                                               \
( 0x2028 == cp || 0x2029 == cp )

/*
	XDIGIT: Hexadecimal digits

	\p{XDigit}
*/
/*** GENERATED CODE ***/
#define is_XDIGIT_high(s)                                                   \
( ( ( 0xDD == ((U8*)s)[0] ) && ( 0x73 == ((U8*)s)[1] ) ) ? ( ( 0x67 == ((U8*)s)[2] ) ?\
	    ( ( ( 0x57 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x68 ) ) ? 4 : 0 )\
	: ( ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) && ( 0x42 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) ) ? 4 : 0 ) : 0 )

/*** GENERATED CODE ***/
#define is_XDIGIT_cp_high(cp)                                               \
( ( 0xFF10 <= cp && cp <= 0xFF19 ) || ( 0xFF19 < cp &&                      \
( ( 0xFF21 <= cp && cp <= 0xFF26 ) || ( 0xFF41 <= cp && cp <= 0xFF46 ) ) ) )

/*
	XPERLSPACE: \p{XPerlSpace}

	\p{XPerlSpace}
*/
/*** GENERATED CODE ***/
#define is_XPERLSPACE_high(s)                                               \
( ( 0xBC == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x63 == ((U8*)s)[1] ) && ( 0x41 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x41 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || 0x51 == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x42 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x49 == ((U8*)s)[2] || 0x4A == ((U8*)s)[2] ) || 0x56 == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( ( 0x43 == ((U8*)s)[1] ) && ( 0x73 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( ( ( 0xCE == ((U8*)s)[0] ) && ( 0x41 == ((U8*)s)[1] ) ) && ( 0x41 == ((U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_XPERLSPACE_cp_high(cp)                                           \
( 0x1680 == cp || ( 0x1680 < cp &&                                          \
( ( 0x2000 <= cp && cp <= 0x200A ) || ( 0x200A < cp &&                      \
( 0x2028 == cp || ( 0x2028 < cp &&                                          \
( 0x2029 == cp || ( 0x2029 < cp &&                                          \
( 0x202F == cp || ( 0x202F < cp &&                                          \
( 0x205F == cp || 0x3000 == cp ) ) ) ) ) ) ) ) ) ) )

/*
	REPLACEMENT: Unicode REPLACEMENT CHARACTER

	0xFFFD
*/
/*** GENERATED CODE ***/
#define is_REPLACEMENT_utf8_safe(s,e)                                       \
( ( ( ( ( ( ((e) - (s)) >= 4 ) && ( 0xDD == ((U8*)s)[0] ) ) && ( 0x73 == ((U8*)s)[1] ) ) && ( 0x73 == ((U8*)s)[2] ) ) && ( 0x71 == ((U8*)s)[3] ) ) ? 4 : 0 )

/*
	NONCHAR: Non character code points

	\p{Nchar}
*/
/*** GENERATED CODE ***/
#define is_NONCHAR_utf8(s)                                                  \
( ( 0xDD == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x73 == ((U8*)s)[1] ) ?                                             \
	( ( 0x55 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( 0x57 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( ((U8*)s)[3] & 0xFC ) == 0x70 ) ? 4 : 0 )\
	: ( 0x56 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x56 ) ) ? 4 : 0 )\
	: ( ( 0x73 == ((U8*)s)[2] ) && ( ( ((U8*)s)[3] & 0xFE ) == 0x72 ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ( 0xDF == ((U8*)s)[0] || 0xEA == ((U8*)s)[0] || 0xEC == ((U8*)s)[0] ) ?   \
    ( ( ( ( 0x73 == ((U8*)s)[1] ) && ( 0x73 == ((U8*)s)[2] ) ) && ( ( ((U8*)s)[3] & 0xFE ) == 0x72 ) ) ? 4 : 0 )\
: ( 0xED == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ( ( ((U8*)s)[1] == 0x4A || ((U8*)s)[1] == 0x52 || ( ( ((U8*)s)[1] & 0xFD ) == 0x54 ) || ((U8*)s)[1] == 0x58 || ((U8*)s)[1] == 0x62 || ( ( ((U8*)s)[1] & 0xFD ) == 0x64 ) || ( ( ((U8*)s)[1] & 0xFD ) == 0x68 ) || ( ( ((U8*)s)[1] & 0xFD ) == 0x71 ) ) && ( 0x73 == ((U8*)s)[2] ) ) && ( 0x73 == ((U8*)s)[3] ) ) && ( ( ((U8*)s)[4] & 0xFE ) == 0x72 ) ) ? 5 : 0 )\
: ( ( ( ( ( 0xEE == ((U8*)s)[0] ) && ( 0x42 == ((U8*)s)[1] ) ) && ( 0x73 == ((U8*)s)[2] ) ) && ( 0x73 == ((U8*)s)[3] ) ) && ( ( ((U8*)s)[4] & 0xFE ) == 0x72 ) ) ? 5 : 0 )

/*
	SURROGATE: Surrogate characters

	\p{Gc=Cs}
*/
/*** GENERATED CODE ***/
#define is_SURROGATE_utf8(s)                                                \
( ( ( ( ( 0xDD == ((U8*)s)[0] ) && ( 0x65 == ((U8*)s)[1] || 0x66 == ((U8*)s)[1] ) ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFC ) == 0x70 ) ) && ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( ((U8*)s)[3] & 0xFC ) == 0x70 ) ) ? 4 : 0 )

/*
	GCB_L: Grapheme_Cluster_Break=L

	\p{_X_GCB_L}
*/
/*** GENERATED CODE ***/
#define is_GCB_L_utf8(s)                                                    \
( ( 0xBB == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ( 0x49 == ((U8*)s)[1] || 0x4A == ((U8*)s)[1] ) || 0x51 == ((U8*)s)[1] ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFC ) == 0x70 ) ) ? 3 : 0 )\
: ( ( ( ( 0xDD == ((U8*)s)[0] ) && ( 0x51 == ((U8*)s)[1] ) ) && ( 0x52 == ((U8*)s)[2] ) ) && ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || 0x70 == ((U8*)s)[3] ) ) ? 4 : 0 )

/*
	GCB_LV_LVT_V: Grapheme_Cluster_Break=(LV or LVT or V)

	\p{_X_LV_LVT_V}
*/
/*** GENERATED CODE ***/
#define is_GCB_LV_LVT_V_utf8(s)                                             \
( ( 0xBB == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ((U8*)s)[1] & 0xFE ) == 0x52 ) ?                                  \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFC ) == 0x70 ) ? 3 : 0 )\
    : ( ( 0x54 == ((U8*)s)[1] ) && ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x48 ) ) ? 3 : 0 )\
: ( 0xDD == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x52 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || ( ((U8*)s)[1] & 0xFE ) == 0x62 ) ?\
	( ( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFC ) == 0x70 ) && ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( ((U8*)s)[3] & 0xFC ) == 0x70 ) ) ? 4 : 0 )\
    : ( 0x64 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || 0x70 == ((U8*)s)[2] ) ?\
	    ( ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( ((U8*)s)[3] & 0xFC ) == 0x70 ) ? 4 : 0 )\
	: ( 0x71 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x44 ) || ( 0x57 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( ((U8*)s)[3] & 0xFC ) == 0x70 ) ? 4 : 0 )\
	: ( ( 0x72 == ((U8*)s)[2] ) && ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: 0 )

/*
	GCB_Prepend: Grapheme_Cluster_Break=Prepend

	\p{_X_GCB_Prepend}
*/
/*** GENERATED CODE ***/
#define is_GCB_Prepend_utf8(s)                                              \
( 0 )

/*
	GCB_RI: Grapheme_Cluster_Break=RI

	\p{_X_RI}
*/
/*** GENERATED CODE ***/
#define is_GCB_RI_utf8(s)                                                   \
( ( ( ( ( 0xDF == ((U8*)s)[0] ) && ( 0x70 == ((U8*)s)[1] ) ) && ( 0x56 == ((U8*)s)[2] ) ) && ( ( 0x47 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( ((U8*)s)[3] & 0xFC ) == 0x70 ) ) ? 4 : 0 )

/*
	GCB_SPECIAL_BEGIN_START: Grapheme_Cluster_Break=special_begin_starts

	\p{_X_Special_Begin_Start}
*/
/*** GENERATED CODE ***/
#define is_GCB_SPECIAL_BEGIN_START_utf8(s)                                  \
( ( 0xBB == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ( 0x49 == ((U8*)s)[1] || 0x4A == ((U8*)s)[1] ) || ( 0x51 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x56 ) ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFC ) == 0x70 ) ) ? 3 : 0 )\
: ( 0xDD == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x51 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x52 == ((U8*)s)[2] ) && ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || 0x70 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( ( 0x52 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || ( ((U8*)s)[1] & 0xFE ) == 0x62 ) ?\
	( ( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFC ) == 0x70 ) && ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( ((U8*)s)[3] & 0xFC ) == 0x70 ) ) ? 4 : 0 )\
    : ( 0x64 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || 0x70 == ((U8*)s)[2] ) ?\
	    ( ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( ((U8*)s)[3] & 0xFC ) == 0x70 ) ? 4 : 0 )\
	: ( 0x71 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x44 ) || ( 0x57 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( ((U8*)s)[3] & 0xFC ) == 0x70 ) ? 4 : 0 )\
	: ( 0x72 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) || ( 0x52 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( ((U8*)s)[3] & 0xFC ) == 0x70 ) ? 4 : 0 )\
	: ( ( 0x73 == ((U8*)s)[2] ) && ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ( ( ( ( 0xDF == ((U8*)s)[0] ) && ( 0x70 == ((U8*)s)[1] ) ) && ( 0x56 == ((U8*)s)[2] ) ) && ( ( 0x47 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( ((U8*)s)[3] & 0xFC ) == 0x70 ) ) ? 4 : 0 )

/*
	GCB_T: Grapheme_Cluster_Break=T

	\p{_X_GCB_T}
*/
/*** GENERATED CODE ***/
#define is_GCB_T_utf8(s)                                                    \
( ( 0xBB == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x54 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x49 == ((U8*)s)[2] || 0x4A == ((U8*)s)[2] ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFC ) == 0x70 ) ? 3 : 0 )\
    : ( ( 0x55 == ((U8*)s)[1] || 0x56 == ((U8*)s)[1] ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFC ) == 0x70 ) ) ? 3 : 0 )\
: ( ( 0xDD == ((U8*)s)[0] ) && ( 0x64 == ((U8*)s)[1] ) ) ? ( ( 0x72 == ((U8*)s)[2] ) ?\
	    ( ( ( 0x52 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( ((U8*)s)[3] & 0xFC ) == 0x70 ) ? 4 : 0 )\
	: ( ( 0x73 == ((U8*)s)[2] ) && ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) ) ) ? 4 : 0 ) : 0 )

/*
	GCB_V: Grapheme_Cluster_Break=V

	\p{_X_GCB_V}
*/
/*** GENERATED CODE ***/
#define is_GCB_V_utf8(s)                                                    \
( ( 0xBB == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ((U8*)s)[1] & 0xFE ) == 0x52 ) ?                                  \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFC ) == 0x70 ) ? 3 : 0 )\
    : ( ( 0x54 == ((U8*)s)[1] ) && ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x48 ) ) ? 3 : 0 )\
: ( ( 0xDD == ((U8*)s)[0] ) && ( 0x64 == ((U8*)s)[1] ) ) ? ( ( 0x71 == ((U8*)s)[2] ) ?\
	    ( ( ( 0x57 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( ((U8*)s)[3] & 0xFC ) == 0x70 ) ? 4 : 0 )\
	: ( ( 0x72 == ((U8*)s)[2] ) && ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) ) ? 4 : 0 ) : 0 )

/*
	UTF8_CHAR: Matches legal UTF-EBCDIC encoded characters from 2 through 3 bytes

	0xA0 - 0x3FFF
*/
/*** GENERATED CODE ***/
#define is_UTF8_CHAR_utf8_no_length_checks(s)                               \
( ( 0x80 == ((U8*)s)[0] || ( 0x8A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x90 ) || ( 0x9A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0xA0 ) || ( 0xAA <= ((U8*)s)[0] && ((U8*)s)[0] <= 0xAC ) || ( 0xAE <= ((U8*)s)[0] && ((U8*)s)[0] <= 0xB6 ) ) ?\
    ( ( ( 0x41 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x4A ) || ( 0x51 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x6A ) || ( ((U8*)s)[1] & 0xFC ) == 0x70 ) ? 2 : 0 )\
: ( ( ( ( ( ((U8*)s)[0] & 0xFC ) == 0xB8 ) || ((U8*)s)[0] == 0xBC || ( ( ((U8*)s)[0] & 0xFE ) == 0xBE ) || ( ( ((U8*)s)[0] & 0xEE ) == 0xCA ) || ( ( ((U8*)s)[0] & 0xFC ) == 0xCC ) ) && ( ( 0x41 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x4A ) || ( 0x51 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x6A ) || ( ((U8*)s)[1] & 0xFC ) == 0x70 ) ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFC ) == 0x70 ) ) ? 3 : 0 )

/*
	QUOTEMETA: Meta-characters that \Q should quote

	\p{_Perl_Quotemeta}
*/
/*** GENERATED CODE ***/
#define is_QUOTEMETA_high(s)                                                \
( ( 0xB1 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x56 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xB8 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x57 == ((U8*)s)[1] ) && ( 0x70 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xBB == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x51 == ((U8*)s)[1] ) ?                                             \
	( ( 0x73 == ((U8*)s)[2] ) ? 3 : 0 )                                 \
    : ( ( 0x52 == ((U8*)s)[1] ) && ( 0x41 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xBC == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x63 == ((U8*)s)[1] ) ?                                             \
	( ( 0x41 == ((U8*)s)[2] ) ? 3 : 0 )                                 \
    : ( ( 0x71 == ((U8*)s)[1] ) && ( 0x63 == ((U8*)s)[2] || 0x64 == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xBE == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x41 == ((U8*)s)[1] ) && ( 0x52 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x55 ) ) ? 3 : 0 )\
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x41 == ((U8*)s)[1] || ( 0x54 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x6A ) || ( ((U8*)s)[1] & 0xFC ) == 0x70 ) ?\
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFC ) == 0x70 ) ? 3 : 0 )\
    : ( 0x42 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ? 3 : 0 )\
    : ( 0x43 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x42 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x62 == ((U8*)s)[2] || ( 0x64 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFC ) == 0x70 ) ? 3 : 0 )\
    : ( 0x44 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x56 ) ) ? 3 : 0 )\
    : ( ( 0x53 == ((U8*)s)[1] ) && ( ( 0x57 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFC ) == 0x70 ) ) ? 3 : 0 )\
: ( 0xCB == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ( ((U8*)s)[1] & 0xE7 ) == 0x41 ) || ( ( ((U8*)s)[1] & 0xCE ) == 0x42 ) || ((U8*)s)[1] == 0x4A || ( ( ((U8*)s)[1] & 0xFC ) == 0x54 ) || ((U8*)s)[1] == 0x58 || ( ( ((U8*)s)[1] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[1] & 0xFE ) == 0x68 ) || ((U8*)s)[1] == 0x71 ) ?\
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFC ) == 0x70 ) ? 3 : 0 )\
    : ( 0x6A == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x64 ) ) ? 3 : 0 )\
    : ( ( 0x70 == ((U8*)s)[1] ) && ( ( 0x63 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFC ) == 0x70 ) ) ? 3 : 0 )\
: ( 0xCC == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ( 0x41 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x4A ) || ( 0x51 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x6A ) || ( ((U8*)s)[1] & 0xFC ) == 0x70 ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFC ) == 0x70 ) ) ? 3 : 0 )\
: ( 0xCD == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ( 0x57 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || 0x62 == ((U8*)s)[1] ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFC ) == 0x70 ) ) ? 3 : 0 )\
: ( 0xCE == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x41 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x44 ) || ( 0x49 == ((U8*)s)[2] || 0x4A == ((U8*)s)[2] ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFC ) == 0x70 ) ? 3 : 0 )\
    : ( 0x42 == ((U8*)s)[1] ) ?                                             \
	( ( 0x41 == ((U8*)s)[2] || 0x57 == ((U8*)s)[2] ) ? 3 : 0 )          \
    : ( ( 0x52 == ((U8*)s)[1] ) && ( 0x45 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xDD == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x73 == ((U8*)s)[1] ) ?                                             \
	( ( 0x4A == ((U8*)s)[2] ) ?                                         \
	    ( ( ( ((U8*)s)[3] & 0xFE ) == 0x72 ) ? 4 : 0 )                  \
	: ( 0x57 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x56 ) ) ? 4 : 0 )\
	: ( 0x59 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( ((U8*)s)[3] & 0xFE ) == 0x46 ) ? 4 : 0 )                  \
	: ( 0x66 == ((U8*)s)[2] ) ?                                         \
	    ( ( 0x73 == ((U8*)s)[3] ) ? 4 : 0 )                             \
	: ( 0x71 == ((U8*)s)[2] ) ?                                         \
	    ( ( 0x41 == ((U8*)s)[3] ) ? 4 : 0 )                             \
	: ( ( 0x73 == ((U8*)s)[2] ) && ( ( 0x57 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x67 ) ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ( 0xDF == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x56 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x46 == ((U8*)s)[2] ) && ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x44 ) ) ? 4 : 0 )\
    : ( ( ( 0x63 == ((U8*)s)[1] ) && ( 0x52 == ((U8*)s)[2] ) ) && ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x69 ) ) ? 4 : 0 )\
: ( ( ( ( ( 0xED == ((U8*)s)[0] ) && ( 0x70 == ((U8*)s)[1] ) ) && ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x44 ) ) && ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( ((U8*)s)[3] & 0xFC ) == 0x70 ) ) && ( ( 0x41 <= ((U8*)s)[4] && ((U8*)s)[4] <= 0x4A ) || ( 0x51 <= ((U8*)s)[4] && ((U8*)s)[4] <= 0x59 ) || ( 0x62 <= ((U8*)s)[4] && ((U8*)s)[4] <= 0x6A ) || ( ((U8*)s)[4] & 0xFC ) == 0x70 ) ) ? 5 : 0 )

/*
	MULTI_CHAR_FOLD: multi-char strings that are folded to by a single character

	&regcharclass_multi_char_folds::multi_char_folds(1)
*/
/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part0(s,e)                             \
( ( 0x81 == ((U8*)s)[0] ) ?                                                 \
	( ( ( 0xAB == ((U8*)s)[1] ) && ( 0x72 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x86 == ((U8*)s)[0] ) ?                                             \
	( ( 0x86 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x89 == ((U8*)s)[2] || 0x93 == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x89 == ((U8*)s)[1] || 0x93 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x88 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xB0 == ((U8*)s)[1] ) && ( 0x58 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x89 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x48 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x8F == ((U8*)s)[0] ) ?                                             \
	( ( ( ( 0x73 == ((U8*)s)[1] ) && ( 0x8F == ((U8*)s)[2] ) ) && ( 0x73 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0x91 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x53 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA2 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                      \
    : ( 0xA3 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x49 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA6 == ((U8*)s)[0] || 0xA8 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x51 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xAB == ((U8*)s)[0] ) ?                                             \
	( ( ( 0x70 == ((U8*)s)[1] ) && ( 0x95 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xB4 == ((U8*)s)[0] ) ?                                             \
	( ( 0x53 == ((U8*)s)[1] || 0x55 == ((U8*)s)[1] ) ?                  \
	    ( ( ( 0xB4 == ((U8*)s)[2] ) && ( 0x68 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x58 == ((U8*)s)[1] || 0x66 == ((U8*)s)[1] ) ?                  \
	    ( ( 0xB1 == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB4 == ((U8*)s)[2] ) && ( 0x68 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x68 == ((U8*)s)[1] ) && ( 0xB1 == ((U8*)s)[2] ) ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xB5 == ((U8*)s)[0] ) ?                                             \
	( ( 0x42 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xAF == ((U8*)s)[2] ) && ( 0x62 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x46 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xAF == ((U8*)s)[2] ) ?                                     \
		( ( 0x62 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB1 == ((U8*)s)[2] ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x4A == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xB1 == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB4 == ((U8*)s)[2] ) && ( 0x68 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x55 == ((U8*)s)[1] ) && ( 0xB4 == ((U8*)s)[2] ) ) && ( 0x68 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xBF == ((U8*)s)[0] ) ?                                             \
	( ( 0x67 == ((U8*)s)[1] || 0x68 == ((U8*)s)[1] ) ?                  \
	    ( ( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x48 ) && ( 0xB4 == ((U8*)s)[3] ) ) && ( 0x68 == ((U8*)s)[4] ) ) ? 5 : 0 )\
	: ( ( ( ( 0x6A == ((U8*)s)[1] ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x48 ) || 0x57 == ((U8*)s)[2] || 0x63 == ((U8*)s)[2] || 0x70 == ((U8*)s)[2] ) ) && ( 0xB4 == ((U8*)s)[3] ) ) && ( 0x68 == ((U8*)s)[4] ) ) ? 5 : 0 )\
    : 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part1(s,e)                             \
( ((e)-(s) > 3) ?                                                           \
    ( ( 0x81 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAB == ((U8*)s)[1] ) && ( 0x72 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x86 == ((U8*)s)[0] ) ?                                             \
	( ( 0x86 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x89 == ((U8*)s)[2] || 0x93 == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x89 == ((U8*)s)[1] || 0x93 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x88 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xB0 == ((U8*)s)[1] ) && ( 0x58 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x89 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x48 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x8F == ((U8*)s)[0] ) ?                                             \
	( ( ( ( 0x73 == ((U8*)s)[1] ) && ( 0x8F == ((U8*)s)[2] ) ) && ( 0x73 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0x91 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x53 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA2 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                      \
    : ( 0xA3 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x49 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA6 == ((U8*)s)[0] || 0xA8 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x51 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xAB == ((U8*)s)[0] ) ?                                             \
	( ( ( 0x70 == ((U8*)s)[1] ) && ( 0x95 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xB4 == ((U8*)s)[0] ) ?                                             \
	( ( 0x53 == ((U8*)s)[1] || 0x55 == ((U8*)s)[1] ) ?                  \
	    ( ( ( 0xB4 == ((U8*)s)[2] ) && ( 0x68 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x58 == ((U8*)s)[1] || 0x66 == ((U8*)s)[1] ) ?                  \
	    ( ( 0xB1 == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB4 == ((U8*)s)[2] ) && ( 0x68 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x68 == ((U8*)s)[1] ) && ( 0xB1 == ((U8*)s)[2] ) ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xB5 == ((U8*)s)[0] ) ?                                             \
	( ( 0x42 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xAF == ((U8*)s)[2] ) && ( 0x62 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x46 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xAF == ((U8*)s)[2] ) ?                                     \
		( ( 0x62 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB1 == ((U8*)s)[2] ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x4A == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xB1 == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB4 == ((U8*)s)[2] ) && ( 0x68 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x55 == ((U8*)s)[1] ) && ( 0xB4 == ((U8*)s)[2] ) ) && ( 0x68 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ((e)-(s) > 2) ?                                                           \
    ( ( 0x81 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAB == ((U8*)s)[1] ) && ( 0x72 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x86 == ((U8*)s)[0] ) ?                                             \
	( ( 0x86 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x89 == ((U8*)s)[2] || 0x93 == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x89 == ((U8*)s)[1] || 0x93 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x88 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xB0 == ((U8*)s)[1] ) && ( 0x58 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x89 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x48 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x91 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x53 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA2 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                      \
    : ( 0xA3 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x49 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA6 == ((U8*)s)[0] || 0xA8 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x51 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( ( ( 0xAB == ((U8*)s)[0] ) && ( 0x70 == ((U8*)s)[1] ) ) && ( 0x95 == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( 0x86 == ((U8*)s)[0] ) ?                                             \
	( ( 0x86 == ((U8*)s)[1] || 0x89 == ((U8*)s)[1] || 0x93 == ((U8*)s)[1] ) ? 2 : 0 )\
    : ( ( 0xA2 == ((U8*)s)[0] ) && ( ( ((U8*)s)[1] & 0xFE ) == 0xA2 ) ) ? 2 : 0 )\
: 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe(s,e)                                   \
( ((e)-(s) > 5) ?                                                           \
    ( ( 0x81 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAB == ((U8*)s)[1] ) && ( 0x72 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x86 == ((U8*)s)[0] ) ?                                             \
	( ( 0x86 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x89 == ((U8*)s)[2] || 0x93 == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x89 == ((U8*)s)[1] || 0x93 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x88 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xB0 == ((U8*)s)[1] ) && ( 0x58 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x89 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x48 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x8F == ((U8*)s)[0] ) ?                                             \
	( ( ( ( 0x73 == ((U8*)s)[1] ) && ( 0x8F == ((U8*)s)[2] ) ) && ( 0x73 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0x91 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x53 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA2 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                      \
    : ( 0xA3 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x49 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA6 == ((U8*)s)[0] || 0xA8 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x51 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xAB == ((U8*)s)[0] ) ?                                             \
	( ( ( 0x70 == ((U8*)s)[1] ) && ( 0x95 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xB4 == ((U8*)s)[0] ) ?                                             \
	( ( 0x53 == ((U8*)s)[1] || 0x55 == ((U8*)s)[1] ) ?                  \
	    ( ( ( 0xB4 == ((U8*)s)[2] ) && ( 0x68 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x58 == ((U8*)s)[1] || 0x66 == ((U8*)s)[1] ) ?                  \
	    ( ( 0xB1 == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ?                                 \
		    ( ( ( 0xB4 == ((U8*)s)[4] ) && ( 0x68 == ((U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xB4 == ((U8*)s)[2] ) && ( 0x68 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x68 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xAF == ((U8*)s)[2] ) ?                                     \
		( ( 0x49 == ((U8*)s)[3] ) ?                                 \
		    ( ( 0xAF == ((U8*)s)[4] ) ?                             \
			( ( 0x41 == ((U8*)s)[5] || 0x42 == ((U8*)s)[5] ) ? 6 : 0 )\
		    : ( ( 0xB1 == ((U8*)s)[4] ) && ( 0x43 == ((U8*)s)[5] ) ) ? 6 : 0 )\
		: 0 )                                                       \
	    : ( ( 0xB1 == ((U8*)s)[2] ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: 0 )                                                               \
    : ( 0xB5 == ((U8*)s)[0] ) ?                                             \
	( ( 0x42 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xAF == ((U8*)s)[2] ) && ( 0x62 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x46 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xAF == ((U8*)s)[2] ) ?                                     \
		( ( 0x49 == ((U8*)s)[3] ) ?                                 \
		    ( ( 0xAF == ((U8*)s)[4] ) ?                             \
			( ( 0x41 == ((U8*)s)[5] || 0x42 == ((U8*)s)[5] ) ? 6 : 0 )\
		    : ( ( 0xB1 == ((U8*)s)[4] ) && ( 0x43 == ((U8*)s)[5] ) ) ? 6 : 0 )\
		: ( 0x62 == ((U8*)s)[3] ) ?                                 \
		    ( ( 0xAF == ((U8*)s)[4] ) ?                             \
			( ( 0x41 == ((U8*)s)[5] || 0x42 == ((U8*)s)[5] ) ? 6 : 4 )\
		    : ( ( 0xB1 == ((U8*)s)[4] ) && ( 0x43 == ((U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xB1 == ((U8*)s)[2] ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x4A == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xB1 == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ?                                 \
		    ( ( ( 0xB4 == ((U8*)s)[4] ) && ( 0x68 == ((U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xB4 == ((U8*)s)[2] ) && ( 0x68 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x55 == ((U8*)s)[1] ) && ( 0xB4 == ((U8*)s)[2] ) ) && ( 0x68 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xB8 == ((U8*)s)[0] ) ?                                             \
	( ( 0x52 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x46 == ((U8*)s)[2] ) ?                                     \
		( ( ( ( 0xB8 == ((U8*)s)[3] ) && ( 0x53 == ((U8*)s)[4] ) ) && ( 0x43 == ((U8*)s)[5] ) ) ? 6 : 0 )\
	    : ( 0x63 == ((U8*)s)[2] ) ?                                     \
		( ( ( ( 0xB8 == ((U8*)s)[3] ) && ( 0x52 == ((U8*)s)[4] ) ) && ( 0x46 == ((U8*)s)[5] || 0x52 == ((U8*)s)[5] || 0x54 == ((U8*)s)[5] || 0x65 == ((U8*)s)[5] ) ) ? 6 : 0 )\
	    : ( ( ( ( 0x72 == ((U8*)s)[2] ) && ( 0xB8 == ((U8*)s)[3] ) ) && ( 0x52 == ((U8*)s)[4] ) ) && ( 0x65 == ((U8*)s)[5] ) ) ? 6 : 0 )\
	: 0 )                                                               \
    : ( 0xBF == ((U8*)s)[0] ) ?                                             \
	( ( 0x67 == ((U8*)s)[1] || 0x68 == ((U8*)s)[1] ) ?                  \
	    ( ( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x48 ) && ( 0xB4 == ((U8*)s)[3] ) ) && ( 0x68 == ((U8*)s)[4] ) ) ? 5 : 0 )\
	: ( ( ( ( 0x6A == ((U8*)s)[1] ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x48 ) || 0x57 == ((U8*)s)[2] || 0x63 == ((U8*)s)[2] || 0x70 == ((U8*)s)[2] ) ) && ( 0xB4 == ((U8*)s)[3] ) ) && ( 0x68 == ((U8*)s)[4] ) ) ? 5 : 0 )\
    : 0 )                                                                   \
: ((e)-(s) > 4) ? is_MULTI_CHAR_FOLD_utf8_safe_part0(s,e) : is_MULTI_CHAR_FOLD_utf8_safe_part1(s,e) )

/*
	MULTI_CHAR_FOLD: multi-char strings that are folded to by a single character

	&regcharclass_multi_char_folds::multi_char_folds(0)
*/
/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_latin1_safe(s,e)                                 \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( ((U8*)s)[0] & 0xBF ) == 0x86 ) ?                                  \
	( ( ( ((U8*)s)[1] & 0xBF ) == 0x86 ) ?                              \
	    ( ( ( ( ((U8*)s)[2] & 0xBF ) == 0x89 ) || ( ( ((U8*)s)[2] & 0xBF ) == 0x93 ) ) ? 3 : 2 )\
	: ( ( ( ((U8*)s)[1] & 0xBF ) == 0x89 ) || ( ( ((U8*)s)[1] & 0xBF ) == 0x93 ) ) ? 2 : 0 )\
    : ( ( ( ((U8*)s)[0] & 0xBF ) == 0xA2 ) && ( ( ((U8*)s)[1] & 0xBE ) == 0xA2 ) ) ? 2 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( ((U8*)s)[0] & 0xBF ) == 0x86 ) ?                                  \
	( ( ( ( ((U8*)s)[1] & 0xBF ) == 0x86 ) || ( ( ((U8*)s)[1] & 0xBF ) == 0x89 ) || ( ( ((U8*)s)[1] & 0xBF ) == 0x93 ) ) ? 2 : 0 )\
    : ( ( ( ((U8*)s)[0] & 0xBF ) == 0xA2 ) && ( ( ((U8*)s)[1] & 0xBE ) == 0xA2 ) ) ? 2 : 0 )\
: 0 )

/*
	FOLDS_TO_MULTI: characters that fold to multi-char strings

	\p{_Perl_Folds_To_Multi_Char}
*/
/*** GENERATED CODE ***/
#define is_FOLDS_TO_MULTI_utf8(s)                                           \
( ( 0x8A == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x73 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8D == ((U8*)s)[0] || 0x9C == ((U8*)s)[0] || ( 0xB3 == ((U8*)s)[0] || 0xB4 == ((U8*)s)[0] ) ) ?\
    ( ( 0x57 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8E == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x4A == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xB8 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x53 == ((U8*)s)[1] ) && ( 0x48 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xBF == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x63 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x65 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x69 ) || 0x72 == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x69 == ((U8*)s)[1] ) ?                                             \
	( ( 0x57 == ((U8*)s)[2] || 0x59 == ((U8*)s)[2] || 0x63 == ((U8*)s)[2] || 0x65 == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x70 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFC ) == 0x70 ) ? 3 : 0 )\
    : ( 0x71 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x56 ) || 0x59 == ((U8*)s)[2] || ( ((U8*)s)[2] & 0xFE ) == 0x62 || ( 0x65 == ((U8*)s)[2] || 0x66 == ((U8*)s)[2] ) || 0x70 == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x72 == ((U8*)s)[1] ) ?                                             \
	( ( ( ( ((U8*)s)[2] & 0xFB ) == 0x43 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x44 ) || ((U8*)s)[2] == 0x48 || ((U8*)s)[2] == 0x53 || ((U8*)s)[2] == 0x59 || ( ( ((U8*)s)[2] & 0xFB ) == 0x62 ) || ((U8*)s)[2] == 0x65 ) ? 3 : 0 )\
    : ( ( 0x73 == ((U8*)s)[1] ) && ( ( ( ((U8*)s)[2] & 0xFB ) == 0x43 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x44 ) || ((U8*)s)[2] == 0x48 || ((U8*)s)[2] == 0x59 || ( ( ((U8*)s)[2] & 0xFE ) == 0x62 ) || ((U8*)s)[2] == 0x65 || ((U8*)s)[2] == 0x66 || ((U8*)s)[2] == 0x70 ) ) ? 3 : 0 )\
: ( ( ( ( 0xDD == ((U8*)s)[0] ) && ( 0x72 == ((U8*)s)[1] ) ) && ( 0x67 == ((U8*)s)[2] ) ) && ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x66 ) ) ) ? 4 : 0 )

/*
	PROBLEMATIC_LOCALE_FOLD: characters whose fold is problematic under locale

	\p{_Perl_Problematic_Locale_Folds}
*/
/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLD_utf8(s)                                  \
( ( ( ( ((U8*)s)[0] & 0xC0 ) == 0x00 ) || ( ( ((U8*)s)[0] & 0xEF ) == 0x40 ) || ( ( ((U8*)s)[0] & 0xDF ) == 0x4B ) || ( ( ((U8*)s)[0] & 0xCC ) == 0x4C ) || ( ( ((U8*)s)[0] & 0xDE ) == 0x5A ) || ( ( ((U8*)s)[0] & 0xFE ) == 0x60 ) || ((U8*)s)[0] == 0x79 || ( ( ((U8*)s)[0] & 0xEF ) == 0x81 ) || ( ( ((U8*)s)[0] & 0xEE ) == 0x82 ) || ( ( ((U8*)s)[0] & 0xEC ) == 0x84 ) || ( ( ((U8*)s)[0] & 0xEE ) == 0x88 ) || ((U8*)s)[0] == 0xA1 || ( ( ((U8*)s)[0] & 0xBE ) == 0xA2 ) || ( ( ((U8*)s)[0] & 0xBC ) == 0xA4 ) || ( ( ((U8*)s)[0] & 0xFE ) == 0xA8 ) || ( ( ((U8*)s)[0] & 0xEF ) == 0xAD ) || ( ( ((U8*)s)[0] & 0xE8 ) == 0xC0 ) || ( ( ((U8*)s)[0] & 0xCE ) == 0xC8 ) || ((U8*)s)[0] == 0xE0 || ( ( ((U8*)s)[0] & 0xF8 ) == 0xF0 ) || ((U8*)s)[0] == 0xFF ) ? 1\
: ( 0x80 == ((U8*)s)[0] || ( ((U8*)s)[0] & 0xFE ) == 0x8A ) ?               \
    ( ( ( 0x41 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x4A ) || ( 0x51 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x6A ) || ( ((U8*)s)[1] & 0xFC ) == 0x70 ) ? 2 : 0 )\
: ( 0x8D == ((U8*)s)[0] || 0x9C == ((U8*)s)[0] ) ?                          \
    ( ( 0x57 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8E == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x4A == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8F == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x67 == ((U8*)s)[1] || 0x73 == ((U8*)s)[1] ) ? 2 : 0 )              \
: ( 0xB3 == ((U8*)s)[0] || 0xB4 == ((U8*)s)[0] ) ?                          \
    ( ( 0x70 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xBF == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x63 == ((U8*)s)[1] ) && ( ( 0x65 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x69 ) || 0x72 == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x4A == ((U8*)s)[1] ) && ( 0x51 == ((U8*)s)[2] || 0x52 == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ( ( ( ( 0xDD == ((U8*)s)[0] ) && ( 0x72 == ((U8*)s)[1] ) ) && ( 0x67 == ((U8*)s)[2] ) ) && ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) ) ? 4 : 0 )

/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLD_cp(cp)                                   \
( cp <= 0xFF || ( 0xFF < cp &&                                              \
( 0x130 == cp || ( 0x130 < cp &&                                            \
( 0x149 == cp || ( 0x149 < cp &&                                            \
( 0x178 == cp || ( 0x178 < cp &&                                            \
( 0x17F == cp || ( 0x17F < cp &&                                            \
( 0x1F0 == cp || ( 0x1F0 < cp &&                                            \
( 0x39C == cp || ( 0x39C < cp &&                                            \
( 0x3BC == cp || ( 0x3BC < cp &&                                            \
( ( 0x1E96 <= cp && cp <= 0x1E9A ) || ( 0x1E9A < cp &&                      \
( 0x1E9E == cp || ( 0x1E9E < cp &&                                          \
( 0x212A == cp || ( 0x212A < cp &&                                          \
( 0x212B == cp || ( 0xFB00 <= cp && cp <= 0xFB06 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

/*
	PROBLEMATIC_LOCALE_FOLDEDS_START: The first folded character of folds which are problematic under locale

	\p{_Perl_Problematic_Locale_Foldeds_Start}
*/
/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLDEDS_START_utf8(s)                         \
( ( ( ( ((U8*)s)[0] & 0xC0 ) == 0x00 ) || ( ( ((U8*)s)[0] & 0xEF ) == 0x40 ) || ( ( ((U8*)s)[0] & 0xDF ) == 0x4B ) || ( ( ((U8*)s)[0] & 0xCC ) == 0x4C ) || ( ( ((U8*)s)[0] & 0xDE ) == 0x5A ) || ( ( ((U8*)s)[0] & 0xFE ) == 0x60 ) || ((U8*)s)[0] == 0x79 || ( ( ((U8*)s)[0] & 0xEF ) == 0x81 ) || ( ( ((U8*)s)[0] & 0xEE ) == 0x82 ) || ( ( ((U8*)s)[0] & 0xEC ) == 0x84 ) || ( ( ((U8*)s)[0] & 0xEE ) == 0x88 ) || ((U8*)s)[0] == 0xA1 || ( ( ((U8*)s)[0] & 0xBE ) == 0xA2 ) || ( ( ((U8*)s)[0] & 0xBC ) == 0xA4 ) || ( ( ((U8*)s)[0] & 0xFE ) == 0xA8 ) || ( ( ((U8*)s)[0] & 0xEF ) == 0xAD ) || ( ( ((U8*)s)[0] & 0xE8 ) == 0xC0 ) || ( ( ((U8*)s)[0] & 0xCE ) == 0xC8 ) || ((U8*)s)[0] == 0xE0 || ( ( ((U8*)s)[0] & 0xF8 ) == 0xF0 ) || ((U8*)s)[0] == 0xFF ) ? 1\
: ( 0x80 == ((U8*)s)[0] || ( ((U8*)s)[0] & 0xFE ) == 0x8A ) ?               \
    ( ( ( 0x41 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x4A ) || ( 0x51 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x6A ) || ( ((U8*)s)[1] & 0xFC ) == 0x70 ) ? 2 : 0 )\
: ( 0x8D == ((U8*)s)[0] || 0x9C == ((U8*)s)[0] ) ?                          \
    ( ( 0x57 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8E == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x4A == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8F == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x67 == ((U8*)s)[1] || 0x73 == ((U8*)s)[1] ) ? 2 : 0 )              \
: ( 0xAB == ((U8*)s)[0] || ( 0xB3 == ((U8*)s)[0] || 0xB4 == ((U8*)s)[0] ) ) ?\
    ( ( 0x70 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xBF == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x63 == ((U8*)s)[1] ) && ( ( 0x65 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x69 ) || 0x72 == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x4A == ((U8*)s)[1] ) && ( 0x51 == ((U8*)s)[2] || 0x52 == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ( ( ( ( 0xDD == ((U8*)s)[0] ) && ( 0x72 == ((U8*)s)[1] ) ) && ( 0x67 == ((U8*)s)[2] ) ) && ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) ) ? 4 : 0 )

/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLDEDS_START_cp(cp)                          \
( cp <= 0xFF || ( 0xFF < cp &&                                              \
( 0x130 == cp || ( 0x130 < cp &&                                            \
( 0x149 == cp || ( 0x149 < cp &&                                            \
( 0x178 == cp || ( 0x178 < cp &&                                            \
( 0x17F == cp || ( 0x17F < cp &&                                            \
( 0x1F0 == cp || ( 0x1F0 < cp &&                                            \
( 0x2BC == cp || ( 0x2BC < cp &&                                            \
( 0x39C == cp || ( 0x39C < cp &&                                            \
( 0x3BC == cp || ( 0x3BC < cp &&                                            \
( ( 0x1E96 <= cp && cp <= 0x1E9A ) || ( 0x1E9A < cp &&                      \
( 0x1E9E == cp || ( 0x1E9E < cp &&                                          \
( 0x212A == cp || ( 0x212A < cp &&                                          \
( 0x212B == cp || ( 0xFB00 <= cp && cp <= 0xFB06 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

/*
	PATWS: pattern white space

	\p{PatWS}
*/
/*** GENERATED CODE ***/
#define is_PATWS_safe(s,e,is_utf8)                                          \
( ( LIKELY((e) > (s)) ) ?                                                   \
    ( ( ( ( ((U8*)s)[0] & 0xEF ) == 0x05 ) || ((U8*)s)[0] == 0x0B || ( ( ((U8*)s)[0] & 0xFE ) == 0x0C ) || ((U8*)s)[0] == 0x25 || ((U8*)s)[0] == 0x40 ) ? 1\
    : ( ( is_utf8 && LIKELY(((e) - (s)) >= UTF8SKIP(s)) ) && ( 0xCA == ((U8*)s)[0] ) ) ? ( ( 0x41 == ((U8*)s)[1] ) ?\
		    ( ( 0x55 == ((U8*)s)[2] || 0x56 == ((U8*)s)[2] ) ? 3 : 0 )\
		: ( ( 0x42 == ((U8*)s)[1] ) && ( 0x49 == ((U8*)s)[2] || 0x4A == ((U8*)s)[2] ) ) ? 3 : 0 ) : 0 )\
: 0 )

/*** GENERATED CODE ***/
#define is_PATWS_cp(cp)                                                     \
( 0x05 == cp || ( 0x05 < cp &&                                              \
( ( 0x0B <= cp && cp <= 0x0D ) || ( 0x0D < cp &&                            \
( 0x15 == cp || ( 0x15 < cp &&                                              \
( 0x25 == cp || ( 0x25 < cp &&                                              \
( 0x40 == cp || ( 0x40 < cp &&                                              \
( 0x200E == cp || ( 0x200E < cp &&                                          \
( 0x200F == cp || ( 0x200F < cp &&                                          \
( 0x2028 == cp || 0x2029 == cp ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

#endif	/* EBCDIC 1047 */

#if 'A' == 193 /* EBCDIC 037 */ \
     && '\\' == 224 && '[' == 186 && ']' == 187 && '{' == 192 && '}' == 208 \
     && '^' == 176 && '~' == 161 && '!' == 90 && '#' == 123 && '|' == 79 \
     && '$' == 91 && '@' == 124 && '`' == 121
/*
	LNBREAK: Line Break: \R

	"\x0D\x0A"      # CRLF - Network (Windows) line ending
	\p{VertSpace}
*/
/*** GENERATED CODE ***/
#define is_LNBREAK_safe(s,e,is_utf8)                                        \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( 0x0B == ((U8*)s)[0] || 0x0C == ((U8*)s)[0] ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x25 == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : ( ( ( ( is_utf8 ) && ( 0xCA == ((U8*)s)[0] ) ) && ( 0x42 == ((U8*)s)[1] ) ) && ( 0x49 == ((U8*)s)[2] || 0x4A == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( 0x0B == ((U8*)s)[0] || 0x0C == ((U8*)s)[0] ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x25 == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0B <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0D ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] )\
: 0 )

/*** GENERATED CODE ***/
#define is_LNBREAK_utf8_safe(s,e)                                           \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( 0x0B == ((U8*)s)[0] || 0x0C == ((U8*)s)[0] ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x25 == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : ( ( ( 0xCA == ((U8*)s)[0] ) && ( 0x42 == ((U8*)s)[1] ) ) && ( 0x49 == ((U8*)s)[2] || 0x4A == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( 0x0B == ((U8*)s)[0] || 0x0C == ((U8*)s)[0] ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x25 == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0B <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0D ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] )\
: 0 )

/*** GENERATED CODE ***/
#define is_LNBREAK_latin1_safe(s,e)                                         \
( ((e)-(s) > 1) ?                                                           \
    ( ( ( 0x0B == ((U8*)s)[0] || 0x0C == ((U8*)s)[0] ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x25 == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0B <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0D ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] )\
: 0 )

/*
	HORIZWS: Horizontal Whitespace: \h \H

	\p{HorizSpace}
*/
/*** GENERATED CODE ***/
#define is_HORIZWS_high(s)                                                  \
( ( 0xBD == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x62 == ((U8*)s)[1] ) && ( 0x41 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x41 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || 0x51 == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x42 == ((U8*)s)[1] ) ?                                             \
	( ( 0x56 == ((U8*)s)[2] ) ? 3 : 0 )                                 \
    : ( ( 0x43 == ((U8*)s)[1] ) && ( 0x72 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( ( ( 0xCE == ((U8*)s)[0] ) && ( 0x41 == ((U8*)s)[1] ) ) && ( 0x41 == ((U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_HORIZWS_cp_high(cp)                                              \
( 0x1680 == cp || ( 0x1680 < cp &&                                          \
( ( 0x2000 <= cp && cp <= 0x200A ) || ( 0x200A < cp &&                      \
( 0x202F == cp || ( 0x202F < cp &&                                          \
( 0x205F == cp || 0x3000 == cp ) ) ) ) ) ) )

/*
	VERTWS: Vertical Whitespace: \v \V

	\p{VertSpace}
*/
/*** GENERATED CODE ***/
#define is_VERTWS_high(s)                                                   \
( ( ( ( 0xCA == ((U8*)s)[0] ) && ( 0x42 == ((U8*)s)[1] ) ) && ( 0x49 == ((U8*)s)[2] || 0x4A == ((U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_VERTWS_cp_high(cp)                                               \
( 0x2028 == cp || 0x2029 == cp )

/*
	XDIGIT: Hexadecimal digits

	\p{XDigit}
*/
/*** GENERATED CODE ***/
#define is_XDIGIT_high(s)                                                   \
( ( ( 0xDD == ((U8*)s)[0] ) && ( 0x72 == ((U8*)s)[1] ) ) ? ( ( 0x66 == ((U8*)s)[2] ) ?\
	    ( ( ( ( ((U8*)s)[3] & 0xF7 ) == 0x57 ) || ( ( ((U8*)s)[3] & 0xFE ) == 0x58 ) || ( ( ((U8*)s)[3] & 0xFE ) == 0x62 ) || ( ( ((U8*)s)[3] & 0xFC ) == 0x64 ) ) ? 4 : 0 )\
	: ( ( 0x67 == ((U8*)s)[2] || 0x68 == ((U8*)s)[2] ) && ( 0x42 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) ) ? 4 : 0 ) : 0 )

/*** GENERATED CODE ***/
#define is_XDIGIT_cp_high(cp)                                               \
( ( 0xFF10 <= cp && cp <= 0xFF19 ) || ( 0xFF19 < cp &&                      \
( ( 0xFF21 <= cp && cp <= 0xFF26 ) || ( 0xFF41 <= cp && cp <= 0xFF46 ) ) ) )

/*
	XPERLSPACE: \p{XPerlSpace}

	\p{XPerlSpace}
*/
/*** GENERATED CODE ***/
#define is_XPERLSPACE_high(s)                                               \
( ( 0xBD == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x62 == ((U8*)s)[1] ) && ( 0x41 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x41 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || 0x51 == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x42 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x49 == ((U8*)s)[2] || 0x4A == ((U8*)s)[2] ) || 0x56 == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( ( 0x43 == ((U8*)s)[1] ) && ( 0x72 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( ( ( 0xCE == ((U8*)s)[0] ) && ( 0x41 == ((U8*)s)[1] ) ) && ( 0x41 == ((U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_XPERLSPACE_cp_high(cp)                                           \
( 0x1680 == cp || ( 0x1680 < cp &&                                          \
( ( 0x2000 <= cp && cp <= 0x200A ) || ( 0x200A < cp &&                      \
( 0x2028 == cp || ( 0x2028 < cp &&                                          \
( 0x2029 == cp || ( 0x2029 < cp &&                                          \
( 0x202F == cp || ( 0x202F < cp &&                                          \
( 0x205F == cp || 0x3000 == cp ) ) ) ) ) ) ) ) ) ) )

/*
	REPLACEMENT: Unicode REPLACEMENT CHARACTER

	0xFFFD
*/
/*** GENERATED CODE ***/
#define is_REPLACEMENT_utf8_safe(s,e)                                       \
( ( ( ( ( ( ((e) - (s)) >= 4 ) && ( 0xDD == ((U8*)s)[0] ) ) && ( 0x72 == ((U8*)s)[1] ) ) && ( 0x72 == ((U8*)s)[2] ) ) && ( 0x70 == ((U8*)s)[3] ) ) ? 4 : 0 )

/*
	NONCHAR: Non character code points

	\p{Nchar}
*/
/*** GENERATED CODE ***/
#define is_NONCHAR_utf8(s)                                                  \
( ( 0xDD == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x72 == ((U8*)s)[1] ) ?                                             \
	( ( 0x55 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( 0x57 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || 0x5F == ((U8*)s)[3] || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( 0x70 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x72 ) ) ? 4 : 0 )\
	: ( 0x56 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x56 ) ) ? 4 : 0 )\
	: ( ( 0x72 == ((U8*)s)[2] ) && ( 0x71 == ((U8*)s)[3] || 0x72 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ( 0xDF == ((U8*)s)[0] || 0xEA == ((U8*)s)[0] || 0xEC == ((U8*)s)[0] ) ?   \
    ( ( ( ( 0x72 == ((U8*)s)[1] ) && ( 0x72 == ((U8*)s)[2] ) ) && ( 0x71 == ((U8*)s)[3] || 0x72 == ((U8*)s)[3] ) ) ? 4 : 0 )\
: ( 0xED == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ( ( ((U8*)s)[1] == 0x4A || ((U8*)s)[1] == 0x52 || ( ( ((U8*)s)[1] & 0xFD ) == 0x54 ) || ((U8*)s)[1] == 0x58 || ((U8*)s)[1] == 0x5F || ((U8*)s)[1] == 0x63 || ( ( ((U8*)s)[1] & 0xFD ) == 0x65 ) || ((U8*)s)[1] == 0x69 || ( ( ((U8*)s)[1] & 0xFD ) == 0x70 ) ) && ( 0x72 == ((U8*)s)[2] ) ) && ( 0x72 == ((U8*)s)[3] ) ) && ( 0x71 == ((U8*)s)[4] || 0x72 == ((U8*)s)[4] ) ) ? 5 : 0 )\
: ( ( ( ( ( 0xEE == ((U8*)s)[0] ) && ( 0x42 == ((U8*)s)[1] ) ) && ( 0x72 == ((U8*)s)[2] ) ) && ( 0x72 == ((U8*)s)[3] ) ) && ( 0x71 == ((U8*)s)[4] || 0x72 == ((U8*)s)[4] ) ) ? 5 : 0 )

/*
	SURROGATE: Surrogate characters

	\p{Gc=Cs}
*/
/*** GENERATED CODE ***/
#define is_SURROGATE_utf8(s)                                                \
( ( ( ( ( 0xDD == ((U8*)s)[0] ) && ( ( ((U8*)s)[1] & 0xFE ) == 0x64 ) ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ) && ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || 0x5F == ((U8*)s)[3] || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( 0x70 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x72 ) ) ) ? 4 : 0 )

/*
	GCB_L: Grapheme_Cluster_Break=L

	\p{_X_GCB_L}
*/
/*** GENERATED CODE ***/
#define is_GCB_L_utf8(s)                                                    \
( ( 0xBC == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ( 0x49 == ((U8*)s)[1] || 0x4A == ((U8*)s)[1] ) || 0x51 == ((U8*)s)[1] ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ) ? 3 : 0 )\
: ( ( ( ( 0xDD == ((U8*)s)[0] ) && ( 0x51 == ((U8*)s)[1] ) ) && ( 0x52 == ((U8*)s)[2] ) ) && ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || 0x5F == ((U8*)s)[3] || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) ) ) ? 4 : 0 )

/*
	GCB_LV_LVT_V: Grapheme_Cluster_Break=(LV or LVT or V)

	\p{_X_LV_LVT_V}
*/
/*** GENERATED CODE ***/
#define is_GCB_LV_LVT_V_utf8(s)                                             \
( ( 0xBC == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ((U8*)s)[1] & 0xFE ) == 0x52 ) ?                                  \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ? 3 : 0 )\
    : ( ( 0x54 == ((U8*)s)[1] ) && ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x48 ) ) ? 3 : 0 )\
: ( 0xDD == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x52 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || 0x5F == ((U8*)s)[1] || 0x62 == ((U8*)s)[1] ) ?\
	( ( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) && ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || 0x5F == ((U8*)s)[3] || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( 0x70 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x72 ) ) ) ? 4 : 0 )\
    : ( 0x63 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) ) ?\
	    ( ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || 0x5F == ((U8*)s)[3] || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( 0x70 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x72 ) ) ? 4 : 0 )\
	: ( 0x70 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x44 ) || ( 0x57 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || 0x5F == ((U8*)s)[3] || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( 0x70 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x72 ) ) ? 4 : 0 )\
	: ( ( 0x71 == ((U8*)s)[2] ) && ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: 0 )

/*
	GCB_Prepend: Grapheme_Cluster_Break=Prepend

	\p{_X_GCB_Prepend}
*/
/*** GENERATED CODE ***/
#define is_GCB_Prepend_utf8(s)                                              \
( 0 )

/*
	GCB_RI: Grapheme_Cluster_Break=RI

	\p{_X_RI}
*/
/*** GENERATED CODE ***/
#define is_GCB_RI_utf8(s)                                                   \
( ( ( ( ( 0xDF == ((U8*)s)[0] ) && ( 0x6A == ((U8*)s)[1] ) ) && ( 0x56 == ((U8*)s)[2] ) ) && ( ( 0x47 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || 0x5F == ((U8*)s)[3] || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( 0x70 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x72 ) ) ) ? 4 : 0 )

/*
	GCB_SPECIAL_BEGIN_START: Grapheme_Cluster_Break=special_begin_starts

	\p{_X_Special_Begin_Start}
*/
/*** GENERATED CODE ***/
#define is_GCB_SPECIAL_BEGIN_START_utf8(s)                                  \
( ( 0xBC == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ( 0x49 == ((U8*)s)[1] || 0x4A == ((U8*)s)[1] ) || ( 0x51 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x56 ) ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ) ? 3 : 0 )\
: ( 0xDD == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x51 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x52 == ((U8*)s)[2] ) && ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || 0x5F == ((U8*)s)[3] || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) ) ) ? 4 : 0 )\
    : ( ( 0x52 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || 0x5F == ((U8*)s)[1] || 0x62 == ((U8*)s)[1] ) ?\
	( ( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) && ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || 0x5F == ((U8*)s)[3] || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( 0x70 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x72 ) ) ) ? 4 : 0 )\
    : ( 0x63 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) ) ?\
	    ( ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || 0x5F == ((U8*)s)[3] || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( 0x70 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x72 ) ) ? 4 : 0 )\
	: ( 0x70 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x44 ) || ( 0x57 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || 0x5F == ((U8*)s)[3] || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( 0x70 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x72 ) ) ? 4 : 0 )\
	: ( 0x71 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) || ( 0x52 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || 0x5F == ((U8*)s)[3] || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( 0x70 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x72 ) ) ? 4 : 0 )\
	: ( ( 0x72 == ((U8*)s)[2] ) && ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || 0x5F == ((U8*)s)[3] || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x69 ) ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ( ( ( ( 0xDF == ((U8*)s)[0] ) && ( 0x6A == ((U8*)s)[1] ) ) && ( 0x56 == ((U8*)s)[2] ) ) && ( ( 0x47 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || 0x5F == ((U8*)s)[3] || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( 0x70 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x72 ) ) ) ? 4 : 0 )

/*
	GCB_T: Grapheme_Cluster_Break=T

	\p{_X_GCB_T}
*/
/*** GENERATED CODE ***/
#define is_GCB_T_utf8(s)                                                    \
( ( 0xBC == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x54 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x49 == ((U8*)s)[2] || 0x4A == ((U8*)s)[2] ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ? 3 : 0 )\
    : ( ( 0x55 == ((U8*)s)[1] || 0x56 == ((U8*)s)[1] ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ) ? 3 : 0 )\
: ( ( 0xDD == ((U8*)s)[0] ) && ( 0x63 == ((U8*)s)[1] ) ) ? ( ( 0x71 == ((U8*)s)[2] ) ?\
	    ( ( ( 0x52 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || 0x5F == ((U8*)s)[3] || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( 0x70 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x72 ) ) ? 4 : 0 )\
	: ( ( 0x72 == ((U8*)s)[2] ) && ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || 0x5F == ((U8*)s)[3] || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x69 ) ) ) ? 4 : 0 ) : 0 )

/*
	GCB_V: Grapheme_Cluster_Break=V

	\p{_X_GCB_V}
*/
/*** GENERATED CODE ***/
#define is_GCB_V_utf8(s)                                                    \
( ( 0xBC == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ((U8*)s)[1] & 0xFE ) == 0x52 ) ?                                  \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ? 3 : 0 )\
    : ( ( 0x54 == ((U8*)s)[1] ) && ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x48 ) ) ? 3 : 0 )\
: ( ( 0xDD == ((U8*)s)[0] ) && ( 0x63 == ((U8*)s)[1] ) ) ? ( ( 0x70 == ((U8*)s)[2] ) ?\
	    ( ( ( 0x57 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || 0x5F == ((U8*)s)[3] || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( 0x70 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x72 ) ) ? 4 : 0 )\
	: ( ( 0x71 == ((U8*)s)[2] ) && ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) ) ? 4 : 0 ) : 0 )

/*
	UTF8_CHAR: Matches legal UTF-EBCDIC encoded characters from 2 through 3 bytes

	0xA0 - 0x3FFF
*/
/*** GENERATED CODE ***/
#define is_UTF8_CHAR_utf8_no_length_checks(s)                               \
( ( 0x78 == ((U8*)s)[0] || 0x80 == ((U8*)s)[0] || ( 0x8A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x90 ) || ( 0x9A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0xA0 ) || ( 0xAA <= ((U8*)s)[0] && ((U8*)s)[0] <= 0xAF ) || ( 0xB1 <= ((U8*)s)[0] && ((U8*)s)[0] <= 0xB5 ) ) ?\
    ( ( ( 0x41 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x4A ) || ( 0x51 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || 0x5F == ((U8*)s)[1] || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x6A ) || ( 0x70 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x72 ) ) ? 2 : 0 )\
: ( ( ( ((U8*)s)[0] == 0xB7 || ( ( ((U8*)s)[0] & 0xFE ) == 0xB8 ) || ( ( ((U8*)s)[0] & 0xFC ) == 0xBC ) || ( ( ((U8*)s)[0] & 0xEE ) == 0xCA ) || ( ( ((U8*)s)[0] & 0xFC ) == 0xCC ) ) && ( ( 0x41 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x4A ) || ( 0x51 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || 0x5F == ((U8*)s)[1] || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x6A ) || ( 0x70 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x72 ) ) ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ) ? 3 : 0 )

/*
	QUOTEMETA: Meta-characters that \Q should quote

	\p{_Perl_Quotemeta}
*/
/*** GENERATED CODE ***/
#define is_QUOTEMETA_high_part0(s)                                          \
( ( 0x51 == ((U8*)s)[1] ) ?                                                 \
	( ( 0x72 == ((U8*)s)[2] ) ? 3 : 0 )                                 \
    : ( ( 0x52 == ((U8*)s)[1] ) && ( 0x41 == ((U8*)s)[2] ) ) ? 3 : 0 )


/*** GENERATED CODE ***/
#define is_QUOTEMETA_high_part1(s)                                          \
( ( 0xBD == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x62 == ((U8*)s)[1] ) ?                                             \
	( ( 0x41 == ((U8*)s)[2] ) ? 3 : 0 )                                 \
    : ( ( 0x70 == ((U8*)s)[1] ) && ( ( ((U8*)s)[2] & 0xFE ) == 0x62 ) ) ? 3 : 0 )\
: ( 0xBE == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x41 == ((U8*)s)[1] ) && ( 0x52 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x55 ) ) ? 3 : 0 )\
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x41 == ((U8*)s)[1] || ( 0x54 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || 0x5F == ((U8*)s)[1] || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x6A ) || ( 0x70 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x72 ) ) ?\
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ? 3 : 0 )\
    : ( 0x42 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( ((U8*)s)[2] & 0xFE ) == 0x70 ) ? 3 : 0 )\
    : ( 0x43 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x42 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x63 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ? 3 : 0 )\
    : ( 0x44 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x56 ) ) ? 3 : 0 )\
    : ( ( 0x53 == ((U8*)s)[1] ) && ( ( 0x57 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ) ? 3 : 0 )\
: ( 0xCB == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x41 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x43 ) || ( 0x49 == ((U8*)s)[1] || 0x4A == ((U8*)s)[1] ) || ( 0x51 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || 0x5F == ((U8*)s)[1] || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x68 ) || ( 0x70 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x72 ) ) ?\
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ? 3 : 0 )\
    : ( 0x69 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( ((U8*)s)[2] & 0xFE ) == 0x62 ) ? 3 : 0 )\
    : ( ( 0x6A == ((U8*)s)[1] ) && ( ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ) ? 3 : 0 )\
: ( 0xCC == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ( 0x41 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x4A ) || ( 0x51 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || 0x5F == ((U8*)s)[1] || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x6A ) || ( 0x70 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x72 ) ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ) ? 3 : 0 )\
: ( 0xCD == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ( ( ((U8*)s)[1] & 0xF7 ) == 0x57 ) || ( ( ((U8*)s)[1] & 0xFE ) == 0x58 ) ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ) ? 3 : 0 )\
: ( 0xCE == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x41 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x44 ) || ( 0x49 == ((U8*)s)[2] || 0x4A == ((U8*)s)[2] ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ? 3 : 0 )\
    : ( 0x42 == ((U8*)s)[1] ) ?                                             \
	( ( 0x41 == ((U8*)s)[2] || 0x57 == ((U8*)s)[2] ) ? 3 : 0 )          \
    : ( ( 0x52 == ((U8*)s)[1] ) && ( 0x45 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xDD == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x72 == ((U8*)s)[1] ) ?                                             \
	( ( 0x4A == ((U8*)s)[2] ) ?                                         \
	    ( ( 0x71 == ((U8*)s)[3] || 0x72 == ((U8*)s)[3] ) ? 4 : 0 )      \
	: ( 0x57 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x56 ) ) ? 4 : 0 )\
	: ( 0x59 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( ((U8*)s)[3] & 0xFE ) == 0x46 ) ? 4 : 0 )                  \
	: ( 0x65 == ((U8*)s)[2] ) ?                                         \
	    ( ( 0x72 == ((U8*)s)[3] ) ? 4 : 0 )                             \
	: ( 0x70 == ((U8*)s)[2] ) ?                                         \
	    ( ( 0x41 == ((U8*)s)[3] ) ? 4 : 0 )                             \
	: ( ( 0x72 == ((U8*)s)[2] ) && ( ( 0x57 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || 0x5F == ((U8*)s)[3] || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x66 ) ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ( 0xDF == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x56 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x46 == ((U8*)s)[2] ) && ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x44 ) ) ? 4 : 0 )\
    : ( ( ( 0x62 == ((U8*)s)[1] ) && ( 0x52 == ((U8*)s)[2] ) ) && ( 0x5F == ((U8*)s)[3] || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x68 ) ) ) ? 4 : 0 )\
: ( ( ( ( ( 0xED == ((U8*)s)[0] ) && ( 0x6A == ((U8*)s)[1] ) ) && ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x44 ) ) && ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || 0x5F == ((U8*)s)[3] || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x6A ) || ( 0x70 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x72 ) ) ) && ( ( 0x41 <= ((U8*)s)[4] && ((U8*)s)[4] <= 0x4A ) || ( 0x51 <= ((U8*)s)[4] && ((U8*)s)[4] <= 0x59 ) || 0x5F == ((U8*)s)[4] || ( 0x62 <= ((U8*)s)[4] && ((U8*)s)[4] <= 0x6A ) || ( 0x70 <= ((U8*)s)[4] && ((U8*)s)[4] <= 0x72 ) ) ) ? 5 : 0 )


/*** GENERATED CODE ***/
#define is_QUOTEMETA_high(s)                                                \
( ( 0xAF == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x56 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xB7 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x57 == ((U8*)s)[1] ) && ( 0x6A == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xBC == ((U8*)s)[0] ) ? is_QUOTEMETA_high_part0(s) : is_QUOTEMETA_high_part1(s) )

/*
	MULTI_CHAR_FOLD: multi-char strings that are folded to by a single character

	&regcharclass_multi_char_folds::multi_char_folds(1)
*/
/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part0(s,e)                             \
( ( 0x81 == ((U8*)s)[0] ) ?                                                 \
	( ( ( 0xAA == ((U8*)s)[1] ) && ( 0x71 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x86 == ((U8*)s)[0] ) ?                                             \
	( ( 0x86 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x89 == ((U8*)s)[2] || 0x93 == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x89 == ((U8*)s)[1] || 0x93 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x88 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x58 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x89 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x48 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x8E == ((U8*)s)[0] ) ?                                             \
	( ( ( ( 0x72 == ((U8*)s)[1] ) && ( 0x8E == ((U8*)s)[2] ) ) && ( 0x72 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0x91 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x53 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA2 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                      \
    : ( 0xA3 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x49 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA6 == ((U8*)s)[0] || 0xA8 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x51 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xAA == ((U8*)s)[0] ) ?                                             \
	( ( ( 0x6A == ((U8*)s)[1] ) && ( 0x95 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xB3 == ((U8*)s)[0] ) ?                                             \
	( ( 0x53 == ((U8*)s)[1] || 0x55 == ((U8*)s)[1] ) ?                  \
	    ( ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x67 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x58 == ((U8*)s)[1] || 0x65 == ((U8*)s)[1] ) ?                  \
	    ( ( 0xAF == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x67 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x67 == ((U8*)s)[1] ) && ( 0xAF == ((U8*)s)[2] ) ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xB4 == ((U8*)s)[0] ) ?                                             \
	( ( 0x42 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xAD == ((U8*)s)[2] ) && ( 0x5F == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x46 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xAD == ((U8*)s)[2] ) ?                                     \
		( ( 0x5F == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xAF == ((U8*)s)[2] ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x4A == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xAF == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x67 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x55 == ((U8*)s)[1] ) && ( 0xB3 == ((U8*)s)[2] ) ) && ( 0x67 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xBF == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0x66 ) ?                              \
	    ( ( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x48 ) && ( 0xB3 == ((U8*)s)[3] ) ) && ( 0x67 == ((U8*)s)[4] ) ) ? 5 : 0 )\
	: ( ( ( ( 0x69 == ((U8*)s)[1] ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x48 ) || 0x57 == ((U8*)s)[2] || 0x62 == ((U8*)s)[2] || 0x6A == ((U8*)s)[2] ) ) && ( 0xB3 == ((U8*)s)[3] ) ) && ( 0x67 == ((U8*)s)[4] ) ) ? 5 : 0 )\
    : 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part1(s,e)                             \
( ((e)-(s) > 3) ?                                                           \
    ( ( 0x81 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAA == ((U8*)s)[1] ) && ( 0x71 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x86 == ((U8*)s)[0] ) ?                                             \
	( ( 0x86 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x89 == ((U8*)s)[2] || 0x93 == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x89 == ((U8*)s)[1] || 0x93 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x88 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x58 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x89 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x48 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x8E == ((U8*)s)[0] ) ?                                             \
	( ( ( ( 0x72 == ((U8*)s)[1] ) && ( 0x8E == ((U8*)s)[2] ) ) && ( 0x72 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0x91 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x53 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA2 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                      \
    : ( 0xA3 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x49 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA6 == ((U8*)s)[0] || 0xA8 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x51 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xAA == ((U8*)s)[0] ) ?                                             \
	( ( ( 0x6A == ((U8*)s)[1] ) && ( 0x95 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xB3 == ((U8*)s)[0] ) ?                                             \
	( ( 0x53 == ((U8*)s)[1] || 0x55 == ((U8*)s)[1] ) ?                  \
	    ( ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x67 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x58 == ((U8*)s)[1] || 0x65 == ((U8*)s)[1] ) ?                  \
	    ( ( 0xAF == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x67 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x67 == ((U8*)s)[1] ) && ( 0xAF == ((U8*)s)[2] ) ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xB4 == ((U8*)s)[0] ) ?                                             \
	( ( 0x42 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xAD == ((U8*)s)[2] ) && ( 0x5F == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x46 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xAD == ((U8*)s)[2] ) ?                                     \
		( ( 0x5F == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xAF == ((U8*)s)[2] ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x4A == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xAF == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x67 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x55 == ((U8*)s)[1] ) && ( 0xB3 == ((U8*)s)[2] ) ) && ( 0x67 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ((e)-(s) > 2) ?                                                           \
    ( ( 0x81 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAA == ((U8*)s)[1] ) && ( 0x71 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x86 == ((U8*)s)[0] ) ?                                             \
	( ( 0x86 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x89 == ((U8*)s)[2] || 0x93 == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x89 == ((U8*)s)[1] || 0x93 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x88 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x58 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x89 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x48 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x91 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x53 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA2 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                      \
    : ( 0xA3 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x49 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA6 == ((U8*)s)[0] || 0xA8 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x51 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( ( ( 0xAA == ((U8*)s)[0] ) && ( 0x6A == ((U8*)s)[1] ) ) && ( 0x95 == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( 0x86 == ((U8*)s)[0] ) ?                                             \
	( ( 0x86 == ((U8*)s)[1] || 0x89 == ((U8*)s)[1] || 0x93 == ((U8*)s)[1] ) ? 2 : 0 )\
    : ( ( 0xA2 == ((U8*)s)[0] ) && ( ( ((U8*)s)[1] & 0xFE ) == 0xA2 ) ) ? 2 : 0 )\
: 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe(s,e)                                   \
( ((e)-(s) > 5) ?                                                           \
    ( ( 0x81 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAA == ((U8*)s)[1] ) && ( 0x71 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x86 == ((U8*)s)[0] ) ?                                             \
	( ( 0x86 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x89 == ((U8*)s)[2] || 0x93 == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x89 == ((U8*)s)[1] || 0x93 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x88 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x58 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x89 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x48 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x8E == ((U8*)s)[0] ) ?                                             \
	( ( ( ( 0x72 == ((U8*)s)[1] ) && ( 0x8E == ((U8*)s)[2] ) ) && ( 0x72 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0x91 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x53 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA2 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                      \
    : ( 0xA3 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x49 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA6 == ((U8*)s)[0] || 0xA8 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xAD == ((U8*)s)[1] ) && ( 0x51 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xAA == ((U8*)s)[0] ) ?                                             \
	( ( ( 0x6A == ((U8*)s)[1] ) && ( 0x95 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xB3 == ((U8*)s)[0] ) ?                                             \
	( ( 0x53 == ((U8*)s)[1] || 0x55 == ((U8*)s)[1] ) ?                  \
	    ( ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x67 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x58 == ((U8*)s)[1] || 0x65 == ((U8*)s)[1] ) ?                  \
	    ( ( 0xAF == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ?                                 \
		    ( ( ( 0xB3 == ((U8*)s)[4] ) && ( 0x67 == ((U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x67 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x67 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xAD == ((U8*)s)[2] ) ?                                     \
		( ( 0x49 == ((U8*)s)[3] ) ?                                 \
		    ( ( 0xAD == ((U8*)s)[4] ) ?                             \
			( ( 0x41 == ((U8*)s)[5] || 0x42 == ((U8*)s)[5] ) ? 6 : 0 )\
		    : ( ( 0xAF == ((U8*)s)[4] ) && ( 0x43 == ((U8*)s)[5] ) ) ? 6 : 0 )\
		: 0 )                                                       \
	    : ( ( 0xAF == ((U8*)s)[2] ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: 0 )                                                               \
    : ( 0xB4 == ((U8*)s)[0] ) ?                                             \
	( ( 0x42 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xAD == ((U8*)s)[2] ) && ( 0x5F == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x46 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xAD == ((U8*)s)[2] ) ?                                     \
		( ( 0x49 == ((U8*)s)[3] ) ?                                 \
		    ( ( 0xAD == ((U8*)s)[4] ) ?                             \
			( ( 0x41 == ((U8*)s)[5] || 0x42 == ((U8*)s)[5] ) ? 6 : 0 )\
		    : ( ( 0xAF == ((U8*)s)[4] ) && ( 0x43 == ((U8*)s)[5] ) ) ? 6 : 0 )\
		: ( 0x5F == ((U8*)s)[3] ) ?                                 \
		    ( ( 0xAD == ((U8*)s)[4] ) ?                             \
			( ( 0x41 == ((U8*)s)[5] || 0x42 == ((U8*)s)[5] ) ? 6 : 4 )\
		    : ( ( 0xAF == ((U8*)s)[4] ) && ( 0x43 == ((U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xAF == ((U8*)s)[2] ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x4A == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xAF == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ?                                 \
		    ( ( ( 0xB3 == ((U8*)s)[4] ) && ( 0x67 == ((U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x67 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x55 == ((U8*)s)[1] ) && ( 0xB3 == ((U8*)s)[2] ) ) && ( 0x67 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xB7 == ((U8*)s)[0] ) ?                                             \
	( ( 0x52 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x46 == ((U8*)s)[2] ) ?                                     \
		( ( ( ( 0xB7 == ((U8*)s)[3] ) && ( 0x53 == ((U8*)s)[4] ) ) && ( 0x43 == ((U8*)s)[5] ) ) ? 6 : 0 )\
	    : ( 0x62 == ((U8*)s)[2] ) ?                                     \
		( ( ( ( 0xB7 == ((U8*)s)[3] ) && ( 0x52 == ((U8*)s)[4] ) ) && ( 0x46 == ((U8*)s)[5] || 0x52 == ((U8*)s)[5] || 0x54 == ((U8*)s)[5] || 0x64 == ((U8*)s)[5] ) ) ? 6 : 0 )\
	    : ( ( ( ( 0x71 == ((U8*)s)[2] ) && ( 0xB7 == ((U8*)s)[3] ) ) && ( 0x52 == ((U8*)s)[4] ) ) && ( 0x64 == ((U8*)s)[5] ) ) ? 6 : 0 )\
	: 0 )                                                               \
    : ( 0xBF == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0x66 ) ?                              \
	    ( ( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x48 ) && ( 0xB3 == ((U8*)s)[3] ) ) && ( 0x67 == ((U8*)s)[4] ) ) ? 5 : 0 )\
	: ( ( ( ( 0x69 == ((U8*)s)[1] ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x48 ) || 0x57 == ((U8*)s)[2] || 0x62 == ((U8*)s)[2] || 0x6A == ((U8*)s)[2] ) ) && ( 0xB3 == ((U8*)s)[3] ) ) && ( 0x67 == ((U8*)s)[4] ) ) ? 5 : 0 )\
    : 0 )                                                                   \
: ((e)-(s) > 4) ? is_MULTI_CHAR_FOLD_utf8_safe_part0(s,e) : is_MULTI_CHAR_FOLD_utf8_safe_part1(s,e) )

/*
	MULTI_CHAR_FOLD: multi-char strings that are folded to by a single character

	&regcharclass_multi_char_folds::multi_char_folds(0)
*/
/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_latin1_safe(s,e)                                 \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( ((U8*)s)[0] & 0xBF ) == 0x86 ) ?                                  \
	( ( ( ((U8*)s)[1] & 0xBF ) == 0x86 ) ?                              \
	    ( ( ( ( ((U8*)s)[2] & 0xBF ) == 0x89 ) || ( ( ((U8*)s)[2] & 0xBF ) == 0x93 ) ) ? 3 : 2 )\
	: ( ( ( ((U8*)s)[1] & 0xBF ) == 0x89 ) || ( ( ((U8*)s)[1] & 0xBF ) == 0x93 ) ) ? 2 : 0 )\
    : ( ( ( ((U8*)s)[0] & 0xBF ) == 0xA2 ) && ( ( ((U8*)s)[1] & 0xBE ) == 0xA2 ) ) ? 2 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( ((U8*)s)[0] & 0xBF ) == 0x86 ) ?                                  \
	( ( ( ( ((U8*)s)[1] & 0xBF ) == 0x86 ) || ( ( ((U8*)s)[1] & 0xBF ) == 0x89 ) || ( ( ((U8*)s)[1] & 0xBF ) == 0x93 ) ) ? 2 : 0 )\
    : ( ( ( ((U8*)s)[0] & 0xBF ) == 0xA2 ) && ( ( ((U8*)s)[1] & 0xBE ) == 0xA2 ) ) ? 2 : 0 )\
: 0 )

/*
	FOLDS_TO_MULTI: characters that fold to multi-char strings

	\p{_Perl_Folds_To_Multi_Char}
*/
/*** GENERATED CODE ***/
#define is_FOLDS_TO_MULTI_utf8(s)                                           \
( ( 0x80 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x72 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8C == ((U8*)s)[0] || 0x9B == ((U8*)s)[0] || ( ((U8*)s)[0] & 0xFE ) == 0xB2 ) ?\
    ( ( 0x57 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8D == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x4A == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xB7 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x53 == ((U8*)s)[1] ) && ( 0x48 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xBF == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x62 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x64 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x68 ) || 0x71 == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x68 == ((U8*)s)[1] ) ?                                             \
	( ( 0x57 == ((U8*)s)[2] || 0x59 == ((U8*)s)[2] || 0x62 == ((U8*)s)[2] || 0x64 == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x6A == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || 0x5F == ((U8*)s)[2] || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ? 3 : 0 )\
    : ( 0x70 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x56 ) || 0x59 == ((U8*)s)[2] || 0x5F == ((U8*)s)[2] || 0x62 == ((U8*)s)[2] || ( ((U8*)s)[2] & 0xFE ) == 0x64 || 0x6A == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x71 == ((U8*)s)[1] ) ?                                             \
	( ( ( ( ((U8*)s)[2] & 0xFB ) == 0x43 ) || ( ( ((U8*)s)[2] & 0xDE ) == 0x44 ) || ((U8*)s)[2] == 0x48 || ((U8*)s)[2] == 0x53 || ((U8*)s)[2] == 0x59 || ((U8*)s)[2] == 0x5F ) ? 3 : 0 )\
    : ( ( 0x72 == ((U8*)s)[1] ) && ( ( ( ((U8*)s)[2] & 0xFB ) == 0x43 ) || ( ( ((U8*)s)[2] & 0xDE ) == 0x44 ) || ((U8*)s)[2] == 0x48 || ((U8*)s)[2] == 0x59 || ((U8*)s)[2] == 0x5F || ( ( ((U8*)s)[2] & 0xF7 ) == 0x62 ) ) ) ? 3 : 0 )\
: ( ( ( ( 0xDD == ((U8*)s)[0] ) && ( 0x71 == ((U8*)s)[1] ) ) && ( 0x66 == ((U8*)s)[2] ) ) && ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) || 0x5F == ((U8*)s)[3] || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x65 ) ) ) ? 4 : 0 )

/*
	PROBLEMATIC_LOCALE_FOLD: characters whose fold is problematic under locale

	\p{_Perl_Problematic_Locale_Folds}
*/
/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLD_utf8(s)                                  \
( ( ( ( ((U8*)s)[0] & 0xC0 ) == 0x00 ) || ( ( ((U8*)s)[0] & 0xEF ) == 0x40 ) || ( ( ((U8*)s)[0] & 0xDF ) == 0x4B ) || ( ( ((U8*)s)[0] & 0xFC ) == 0x4C ) || ( ( ((U8*)s)[0] & 0xDE ) == 0x5A ) || ( ( ((U8*)s)[0] & 0xFE ) == 0x5C ) || ((U8*)s)[0] == 0x5E || ( ( ((U8*)s)[0] & 0xFE ) == 0x60 ) || ( ( ((U8*)s)[0] & 0xEC ) == 0x6C ) || ((U8*)s)[0] == 0x79 || ( ( ((U8*)s)[0] & 0xEF ) == 0x81 ) || ( ( ((U8*)s)[0] & 0xEE ) == 0x82 ) || ( ( ((U8*)s)[0] & 0xEC ) == 0x84 ) || ( ( ((U8*)s)[0] & 0xEE ) == 0x88 ) || ((U8*)s)[0] == 0xA1 || ( ( ((U8*)s)[0] & 0xBE ) == 0xA2 ) || ( ( ((U8*)s)[0] & 0xBC ) == 0xA4 ) || ( ( ((U8*)s)[0] & 0xFE ) == 0xA8 ) || ((U8*)s)[0] == 0xB0 || ( ( ((U8*)s)[0] & 0xFE ) == 0xBA ) || ( ( ((U8*)s)[0] & 0xE8 ) == 0xC0 ) || ( ( ((U8*)s)[0] & 0xCE ) == 0xC8 ) || ((U8*)s)[0] == 0xE0 || ( ( ((U8*)s)[0] & 0xF8 ) == 0xF0 ) || ((U8*)s)[0] == 0xFF ) ? 1\
: ( 0x78 == ((U8*)s)[0] || 0x80 == ((U8*)s)[0] || 0x8A == ((U8*)s)[0] ) ?   \
    ( ( ( 0x41 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x4A ) || ( 0x51 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || 0x5F == ((U8*)s)[1] || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x6A ) || ( 0x70 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x72 ) ) ? 2 : 0 )\
: ( 0x8C == ((U8*)s)[0] || 0x9B == ((U8*)s)[0] ) ?                          \
    ( ( 0x57 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8D == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x4A == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8E == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x66 == ((U8*)s)[1] || 0x72 == ((U8*)s)[1] ) ? 2 : 0 )              \
: ( ( ((U8*)s)[0] & 0xFE ) == 0xB2 ) ?                                      \
    ( ( 0x6A == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xBF == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x62 == ((U8*)s)[1] ) && ( ( 0x64 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x68 ) || 0x71 == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x4A == ((U8*)s)[1] ) && ( 0x51 == ((U8*)s)[2] || 0x52 == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ( ( ( ( 0xDD == ((U8*)s)[0] ) && ( 0x71 == ((U8*)s)[1] ) ) && ( 0x66 == ((U8*)s)[2] ) ) && ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) ) ? 4 : 0 )

/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLD_cp(cp)                                   \
( cp <= 0xFF || ( 0xFF < cp &&                                              \
( 0x130 == cp || ( 0x130 < cp &&                                            \
( 0x149 == cp || ( 0x149 < cp &&                                            \
( 0x178 == cp || ( 0x178 < cp &&                                            \
( 0x17F == cp || ( 0x17F < cp &&                                            \
( 0x1F0 == cp || ( 0x1F0 < cp &&                                            \
( 0x39C == cp || ( 0x39C < cp &&                                            \
( 0x3BC == cp || ( 0x3BC < cp &&                                            \
( ( 0x1E96 <= cp && cp <= 0x1E9A ) || ( 0x1E9A < cp &&                      \
( 0x1E9E == cp || ( 0x1E9E < cp &&                                          \
( 0x212A == cp || ( 0x212A < cp &&                                          \
( 0x212B == cp || ( 0xFB00 <= cp && cp <= 0xFB06 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

/*
	PROBLEMATIC_LOCALE_FOLDEDS_START: The first folded character of folds which are problematic under locale

	\p{_Perl_Problematic_Locale_Foldeds_Start}
*/
/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLDEDS_START_utf8(s)                         \
( ( ( ( ((U8*)s)[0] & 0xC0 ) == 0x00 ) || ( ( ((U8*)s)[0] & 0xEF ) == 0x40 ) || ( ( ((U8*)s)[0] & 0xDF ) == 0x4B ) || ( ( ((U8*)s)[0] & 0xFC ) == 0x4C ) || ( ( ((U8*)s)[0] & 0xDE ) == 0x5A ) || ( ( ((U8*)s)[0] & 0xFE ) == 0x5C ) || ((U8*)s)[0] == 0x5E || ( ( ((U8*)s)[0] & 0xFE ) == 0x60 ) || ( ( ((U8*)s)[0] & 0xEC ) == 0x6C ) || ((U8*)s)[0] == 0x79 || ( ( ((U8*)s)[0] & 0xEF ) == 0x81 ) || ( ( ((U8*)s)[0] & 0xEE ) == 0x82 ) || ( ( ((U8*)s)[0] & 0xEC ) == 0x84 ) || ( ( ((U8*)s)[0] & 0xEE ) == 0x88 ) || ((U8*)s)[0] == 0xA1 || ( ( ((U8*)s)[0] & 0xBE ) == 0xA2 ) || ( ( ((U8*)s)[0] & 0xBC ) == 0xA4 ) || ( ( ((U8*)s)[0] & 0xFE ) == 0xA8 ) || ((U8*)s)[0] == 0xB0 || ( ( ((U8*)s)[0] & 0xFE ) == 0xBA ) || ( ( ((U8*)s)[0] & 0xE8 ) == 0xC0 ) || ( ( ((U8*)s)[0] & 0xCE ) == 0xC8 ) || ((U8*)s)[0] == 0xE0 || ( ( ((U8*)s)[0] & 0xF8 ) == 0xF0 ) || ((U8*)s)[0] == 0xFF ) ? 1\
: ( 0x78 == ((U8*)s)[0] || 0x80 == ((U8*)s)[0] || 0x8A == ((U8*)s)[0] ) ?   \
    ( ( ( 0x41 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x4A ) || ( 0x51 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || 0x5F == ((U8*)s)[1] || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x6A ) || ( 0x70 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x72 ) ) ? 2 : 0 )\
: ( 0x8C == ((U8*)s)[0] || 0x9B == ((U8*)s)[0] ) ?                          \
    ( ( 0x57 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8D == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x4A == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8E == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x66 == ((U8*)s)[1] || 0x72 == ((U8*)s)[1] ) ? 2 : 0 )              \
: ( 0xAA == ((U8*)s)[0] || ( ((U8*)s)[0] & 0xFE ) == 0xB2 ) ?               \
    ( ( 0x6A == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xBF == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x62 == ((U8*)s)[1] ) && ( ( 0x64 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x68 ) || 0x71 == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x4A == ((U8*)s)[1] ) && ( 0x51 == ((U8*)s)[2] || 0x52 == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ( ( ( ( 0xDD == ((U8*)s)[0] ) && ( 0x71 == ((U8*)s)[1] ) ) && ( 0x66 == ((U8*)s)[2] ) ) && ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) ) ? 4 : 0 )

/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLDEDS_START_cp(cp)                          \
( cp <= 0xFF || ( 0xFF < cp &&                                              \
( 0x130 == cp || ( 0x130 < cp &&                                            \
( 0x149 == cp || ( 0x149 < cp &&                                            \
( 0x178 == cp || ( 0x178 < cp &&                                            \
( 0x17F == cp || ( 0x17F < cp &&                                            \
( 0x1F0 == cp || ( 0x1F0 < cp &&                                            \
( 0x2BC == cp || ( 0x2BC < cp &&                                            \
( 0x39C == cp || ( 0x39C < cp &&                                            \
( 0x3BC == cp || ( 0x3BC < cp &&                                            \
( ( 0x1E96 <= cp && cp <= 0x1E9A ) || ( 0x1E9A < cp &&                      \
( 0x1E9E == cp || ( 0x1E9E < cp &&                                          \
( 0x212A == cp || ( 0x212A < cp &&                                          \
( 0x212B == cp || ( 0xFB00 <= cp && cp <= 0xFB06 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

/*
	PATWS: pattern white space

	\p{PatWS}
*/
/*** GENERATED CODE ***/
#define is_PATWS_safe(s,e,is_utf8)                                          \
( ( LIKELY((e) > (s)) ) ?                                                   \
    ( ( ( ( ((U8*)s)[0] & 0xEF ) == 0x05 ) || ((U8*)s)[0] == 0x0B || ( ( ((U8*)s)[0] & 0xFE ) == 0x0C ) || ((U8*)s)[0] == 0x25 || ((U8*)s)[0] == 0x40 ) ? 1\
    : ( ( is_utf8 && LIKELY(((e) - (s)) >= UTF8SKIP(s)) ) && ( 0xCA == ((U8*)s)[0] ) ) ? ( ( 0x41 == ((U8*)s)[1] ) ?\
		    ( ( 0x55 == ((U8*)s)[2] || 0x56 == ((U8*)s)[2] ) ? 3 : 0 )\
		: ( ( 0x42 == ((U8*)s)[1] ) && ( 0x49 == ((U8*)s)[2] || 0x4A == ((U8*)s)[2] ) ) ? 3 : 0 ) : 0 )\
: 0 )

/*** GENERATED CODE ***/
#define is_PATWS_cp(cp)                                                     \
( 0x05 == cp || ( 0x05 < cp &&                                              \
( ( 0x0B <= cp && cp <= 0x0D ) || ( 0x0D < cp &&                            \
( 0x15 == cp || ( 0x15 < cp &&                                              \
( 0x25 == cp || ( 0x25 < cp &&                                              \
( 0x40 == cp || ( 0x40 < cp &&                                              \
( 0x200E == cp || ( 0x200E < cp &&                                          \
( 0x200F == cp || ( 0x200F < cp &&                                          \
( 0x2028 == cp || 0x2029 == cp ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

#endif	/* EBCDIC 037 */

#if 'A' == 193 /* EBCDIC POSIX-BC */ \
     && '\\' == 188 && '[' == 187 && ']' == 189 && '{' == 251 && '}' == 253 \
     && '^' == 106 && '~' == 255 && '!' == 90 && '#' == 123 && '|' == 79 \
     && '$' == 91 && '@' == 124 && '`' == 74
/*
	LNBREAK: Line Break: \R

	"\x0D\x0A"      # CRLF - Network (Windows) line ending
	\p{VertSpace}
*/
/*** GENERATED CODE ***/
#define is_LNBREAK_safe(s,e,is_utf8)                                        \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( 0x0B == ((U8*)s)[0] || 0x0C == ((U8*)s)[0] ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x15 == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : ( ( ( ( is_utf8 ) && ( 0xCA == ((U8*)s)[0] ) ) && ( 0x42 == ((U8*)s)[1] ) ) && ( 0x49 == ((U8*)s)[2] || 0x51 == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( 0x0B == ((U8*)s)[0] || 0x0C == ((U8*)s)[0] ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x15 == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0B <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0D ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] )\
: 0 )

/*** GENERATED CODE ***/
#define is_LNBREAK_utf8_safe(s,e)                                           \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( 0x0B == ((U8*)s)[0] || 0x0C == ((U8*)s)[0] ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x15 == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : ( ( ( 0xCA == ((U8*)s)[0] ) && ( 0x42 == ((U8*)s)[1] ) ) && ( 0x49 == ((U8*)s)[2] || 0x51 == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( 0x0B == ((U8*)s)[0] || 0x0C == ((U8*)s)[0] ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x15 == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0B <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0D ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] )\
: 0 )

/*** GENERATED CODE ***/
#define is_LNBREAK_latin1_safe(s,e)                                         \
( ((e)-(s) > 1) ?                                                           \
    ( ( ( 0x0B == ((U8*)s)[0] || 0x0C == ((U8*)s)[0] ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] ) ? 1\
    : ( 0x0D == ((U8*)s)[0] ) ?                                             \
	( ( 0x15 == ((U8*)s)[1] ) ? 2 : 1 )                                 \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0B <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x0D ) || 0x15 == ((U8*)s)[0] || 0x25 == ((U8*)s)[0] )\
: 0 )

/*
	HORIZWS: Horizontal Whitespace: \h \H

	\p{HorizSpace}
*/
/*** GENERATED CODE ***/
#define is_HORIZWS_high(s)                                                  \
( ( 0xBE == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x64 == ((U8*)s)[1] ) && ( 0x41 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x41 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x49 ) || ( 0x51 == ((U8*)s)[2] || 0x52 == ((U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x42 == ((U8*)s)[1] ) ?                                             \
	( ( 0x57 == ((U8*)s)[2] ) ? 3 : 0 )                                 \
    : ( ( 0x43 == ((U8*)s)[1] ) && ( 0x75 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( ( ( 0xCE == ((U8*)s)[0] ) && ( 0x41 == ((U8*)s)[1] ) ) && ( 0x41 == ((U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_HORIZWS_cp_high(cp)                                              \
( 0x1680 == cp || ( 0x1680 < cp &&                                          \
( ( 0x2000 <= cp && cp <= 0x200A ) || ( 0x200A < cp &&                      \
( 0x202F == cp || ( 0x202F < cp &&                                          \
( 0x205F == cp || 0x3000 == cp ) ) ) ) ) ) )

/*
	VERTWS: Vertical Whitespace: \v \V

	\p{VertSpace}
*/
/*** GENERATED CODE ***/
#define is_VERTWS_high(s)                                                   \
( ( ( ( 0xCA == ((U8*)s)[0] ) && ( 0x42 == ((U8*)s)[1] ) ) && ( 0x49 == ((U8*)s)[2] || 0x51 == ((U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_VERTWS_cp_high(cp)                                               \
( 0x2028 == cp || 0x2029 == cp )

/*
	XDIGIT: Hexadecimal digits

	\p{XDigit}
*/
/*** GENERATED CODE ***/
#define is_XDIGIT_high(s)                                                   \
( ( ( 0xDC == ((U8*)s)[0] ) && ( 0x75 == ((U8*)s)[1] ) ) ? ( ( 0x68 == ((U8*)s)[2] ) ?\
	    ( ( ( ((U8*)s)[3] & 0xFE ) == 0x58 || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x69 ) ) ? 4 : 0 )\
	: ( ( 0x69 == ((U8*)s)[2] || 0x70 == ((U8*)s)[2] ) && ( 0x42 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) ) ? 4 : 0 ) : 0 )

/*** GENERATED CODE ***/
#define is_XDIGIT_cp_high(cp)                                               \
( ( 0xFF10 <= cp && cp <= 0xFF19 ) || ( 0xFF19 < cp &&                      \
( ( 0xFF21 <= cp && cp <= 0xFF26 ) || ( 0xFF41 <= cp && cp <= 0xFF46 ) ) ) )

/*
	XPERLSPACE: \p{XPerlSpace}

	\p{XPerlSpace}
*/
/*** GENERATED CODE ***/
#define is_XPERLSPACE_high(s)                                               \
( ( 0xBE == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x64 == ((U8*)s)[1] ) && ( 0x41 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x41 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x49 ) || ( 0x51 == ((U8*)s)[2] || 0x52 == ((U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x42 == ((U8*)s)[1] ) ?                                             \
	( ( 0x49 == ((U8*)s)[2] || 0x51 == ((U8*)s)[2] || 0x57 == ((U8*)s)[2] ) ? 3 : 0 )\
    : ( ( 0x43 == ((U8*)s)[1] ) && ( 0x75 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( ( ( 0xCE == ((U8*)s)[0] ) && ( 0x41 == ((U8*)s)[1] ) ) && ( 0x41 == ((U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_XPERLSPACE_cp_high(cp)                                           \
( 0x1680 == cp || ( 0x1680 < cp &&                                          \
( ( 0x2000 <= cp && cp <= 0x200A ) || ( 0x200A < cp &&                      \
( 0x2028 == cp || ( 0x2028 < cp &&                                          \
( 0x2029 == cp || ( 0x2029 < cp &&                                          \
( 0x202F == cp || ( 0x202F < cp &&                                          \
( 0x205F == cp || 0x3000 == cp ) ) ) ) ) ) ) ) ) ) )

/*
	REPLACEMENT: Unicode REPLACEMENT CHARACTER

	0xFFFD
*/
/*** GENERATED CODE ***/
#define is_REPLACEMENT_utf8_safe(s,e)                                       \
( ( ( ( ( ( ((e) - (s)) >= 4 ) && ( 0xDC == ((U8*)s)[0] ) ) && ( 0x75 == ((U8*)s)[1] ) ) && ( 0x75 == ((U8*)s)[2] ) ) && ( 0x73 == ((U8*)s)[3] ) ) ? 4 : 0 )

/*
	NONCHAR: Non character code points

	\p{Nchar}
*/
/*** GENERATED CODE ***/
#define is_NONCHAR_utf8(s)                                                  \
( ( 0xDC == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x75 == ((U8*)s)[1] ) ?                                             \
	( ( 0x56 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( ((U8*)s)[3] & 0xFE ) == 0x58 || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x69 ) || ( 0x70 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x75 ) ) ? 4 : 0 )\
	: ( 0x57 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x49 ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x57 ) ) ? 4 : 0 )\
	: ( ( 0x75 == ((U8*)s)[2] ) && ( ( ((U8*)s)[3] & 0xFE ) == 0x74 ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ( 0xDE == ((U8*)s)[0] || 0xE0 == ((U8*)s)[0] || 0xEA == ((U8*)s)[0] ) ?   \
    ( ( ( ( 0x75 == ((U8*)s)[1] ) && ( 0x75 == ((U8*)s)[2] ) ) && ( ( ((U8*)s)[3] & 0xFE ) == 0x74 ) ) ? 4 : 0 )\
: ( 0xEB == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ( ( ( ( ((U8*)s)[1] & 0xF9 ) == 0x51 ) || ((U8*)s)[1] == 0x59 || ((U8*)s)[1] == 0x63 || ( ( ((U8*)s)[1] & 0xFD ) == 0x65 ) || ((U8*)s)[1] == 0x69 || ( ( ((U8*)s)[1] & 0xFD ) == 0x71 ) || ((U8*)s)[1] == 0x75 ) && ( 0x75 == ((U8*)s)[2] ) ) && ( 0x75 == ((U8*)s)[3] ) ) && ( ( ((U8*)s)[4] & 0xFE ) == 0x74 ) ) ? 5 : 0 )\
: ( ( ( ( ( 0xEC == ((U8*)s)[0] ) && ( 0x42 == ((U8*)s)[1] ) ) && ( 0x75 == ((U8*)s)[2] ) ) && ( 0x75 == ((U8*)s)[3] ) ) && ( ( ((U8*)s)[4] & 0xFE ) == 0x74 ) ) ? 5 : 0 )

/*
	SURROGATE: Surrogate characters

	\p{Gc=Cs}
*/
/*** GENERATED CODE ***/
#define is_SURROGATE_utf8(s)                                                \
( ( ( ( ( 0xDC == ((U8*)s)[0] ) && ( ( ((U8*)s)[1] & 0xFE ) == 0x66 ) ) && ( ( ( ((U8*)s)[2] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[2] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[2] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[2] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[2] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFA ) == 0x70 ) ) ) && ( ( ( ((U8*)s)[3] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[3] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[3] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[3] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[3] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[3] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[3] & 0xFA ) == 0x70 ) ) ) ? 4 : 0 )

/*
	GCB_L: Grapheme_Cluster_Break=L

	\p{_X_GCB_L}
*/
/*** GENERATED CODE ***/
#define is_GCB_L_utf8(s)                                                    \
( ( 0xBA == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x49 == ((U8*)s)[1] || ( 0x51 == ((U8*)s)[1] || 0x52 == ((U8*)s)[1] ) ) && ( ( ( ((U8*)s)[2] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[2] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[2] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[2] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[2] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFA ) == 0x70 ) ) ) ? 3 : 0 )\
: ( ( ( ( 0xDC == ((U8*)s)[0] ) && ( 0x52 == ((U8*)s)[1] ) ) && ( 0x53 == ((U8*)s)[2] ) ) && ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x49 ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x69 ) || ( 0x70 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x72 ) ) ) ? 4 : 0 )

/*
	GCB_LV_LVT_V: Grapheme_Cluster_Break=(LV or LVT or V)

	\p{_X_LV_LVT_V}
*/
/*** GENERATED CODE ***/
#define is_GCB_LV_LVT_V_utf8(s)                                             \
( ( 0xBA == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x53 == ((U8*)s)[1] || 0x54 == ((U8*)s)[1] ) ?                      \
	( ( ( ( ((U8*)s)[2] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[2] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[2] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[2] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[2] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFA ) == 0x70 ) ) ? 3 : 0 )\
    : ( ( 0x55 == ((U8*)s)[1] ) && ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x48 ) ) ? 3 : 0 )\
: ( 0xDC == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x53 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x64 ) ) ?\
	( ( ( ( ( ((U8*)s)[2] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[2] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[2] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[2] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[2] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFA ) == 0x70 ) ) && ( ( ( ((U8*)s)[3] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[3] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[3] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[3] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[3] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[3] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[3] & 0xFA ) == 0x70 ) ) ) ? 4 : 0 )\
    : ( 0x65 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x49 ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x69 ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ?\
	    ( ( ( ( ((U8*)s)[3] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[3] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[3] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[3] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[3] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[3] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[3] & 0xFA ) == 0x70 ) ) ? 4 : 0 )\
	: ( 0x73 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x44 ) || ( ((U8*)s)[3] & 0xFE ) == 0x58 || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x69 ) || ( 0x70 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x75 ) ) ? 4 : 0 )\
	: ( ( 0x74 == ((U8*)s)[2] ) && ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: 0 )

/*
	GCB_Prepend: Grapheme_Cluster_Break=Prepend

	\p{_X_GCB_Prepend}
*/
/*** GENERATED CODE ***/
#define is_GCB_Prepend_utf8(s)                                              \
( 0 )

/*
	GCB_RI: Grapheme_Cluster_Break=RI

	\p{_X_RI}
*/
/*** GENERATED CODE ***/
#define is_GCB_RI_utf8(s)                                                   \
( ( ( ( ( 0xDE == ((U8*)s)[0] ) && ( 0x72 == ((U8*)s)[1] ) ) && ( 0x57 == ((U8*)s)[2] ) ) && ( ( 0x47 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x49 ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x69 ) || ( 0x70 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x75 ) ) ) ? 4 : 0 )

/*
	GCB_SPECIAL_BEGIN_START: Grapheme_Cluster_Break=special_begin_starts

	\p{_X_Special_Begin_Start}
*/
/*** GENERATED CODE ***/
#define is_GCB_SPECIAL_BEGIN_START_utf8(s)                                  \
( ( 0xBA == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x49 == ((U8*)s)[1] || ( 0x51 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x57 ) ) && ( ( ( ((U8*)s)[2] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[2] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[2] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[2] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[2] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFA ) == 0x70 ) ) ) ? 3 : 0 )\
: ( 0xDC == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x52 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x53 == ((U8*)s)[2] ) && ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x49 ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x69 ) || ( 0x70 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x72 ) ) ) ? 4 : 0 )\
    : ( ( 0x53 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x64 ) ) ?\
	( ( ( ( ( ((U8*)s)[2] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[2] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[2] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[2] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[2] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFA ) == 0x70 ) ) && ( ( ( ((U8*)s)[3] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[3] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[3] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[3] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[3] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[3] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[3] & 0xFA ) == 0x70 ) ) ) ? 4 : 0 )\
    : ( 0x65 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x49 ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x69 ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x72 ) ) ?\
	    ( ( ( ( ((U8*)s)[3] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[3] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[3] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[3] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[3] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[3] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[3] & 0xFA ) == 0x70 ) ) ? 4 : 0 )\
	: ( 0x73 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x44 ) || ( ((U8*)s)[3] & 0xFE ) == 0x58 || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x69 ) || ( 0x70 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x75 ) ) ? 4 : 0 )\
	: ( 0x74 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) || ( 0x53 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x69 ) || ( 0x70 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x75 ) ) ? 4 : 0 )\
	: ( ( 0x75 == ((U8*)s)[2] ) && ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x49 ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x69 ) || ( ((U8*)s)[3] & 0xFE ) == 0x70 ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ( ( ( ( 0xDE == ((U8*)s)[0] ) && ( 0x72 == ((U8*)s)[1] ) ) && ( 0x57 == ((U8*)s)[2] ) ) && ( ( 0x47 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x49 ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x69 ) || ( 0x70 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x75 ) ) ) ? 4 : 0 )

/*
	GCB_T: Grapheme_Cluster_Break=T

	\p{_X_GCB_T}
*/
/*** GENERATED CODE ***/
#define is_GCB_T_utf8(s)                                                    \
( ( 0xBA == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x55 == ((U8*)s)[1] ) ?                                             \
	( ( 0x49 == ((U8*)s)[2] || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x69 ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x75 ) ) ? 3 : 0 )\
    : ( ( ( ((U8*)s)[1] & 0xFE ) == 0x56 ) && ( ( ( ((U8*)s)[2] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[2] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[2] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[2] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[2] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFA ) == 0x70 ) ) ) ? 3 : 0 )\
: ( ( 0xDC == ((U8*)s)[0] ) && ( 0x65 == ((U8*)s)[1] ) ) ? ( ( 0x74 == ((U8*)s)[2] ) ?\
	    ( ( ( 0x53 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x69 ) || ( 0x70 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x75 ) ) ? 4 : 0 )\
	: ( ( 0x75 == ((U8*)s)[2] ) && ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x49 ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x69 ) || ( ((U8*)s)[3] & 0xFE ) == 0x70 ) ) ? 4 : 0 ) : 0 )

/*
	GCB_V: Grapheme_Cluster_Break=V

	\p{_X_GCB_V}
*/
/*** GENERATED CODE ***/
#define is_GCB_V_utf8(s)                                                    \
( ( 0xBA == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x53 == ((U8*)s)[1] || 0x54 == ((U8*)s)[1] ) ?                      \
	( ( ( ( ((U8*)s)[2] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[2] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[2] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[2] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[2] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFA ) == 0x70 ) ) ? 3 : 0 )\
    : ( ( 0x55 == ((U8*)s)[1] ) && ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x48 ) ) ? 3 : 0 )\
: ( ( 0xDC == ((U8*)s)[0] ) && ( 0x65 == ((U8*)s)[1] ) ) ? ( ( 0x73 == ((U8*)s)[2] ) ?\
	    ( ( ( ((U8*)s)[3] & 0xFE ) == 0x58 || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x69 ) || ( 0x70 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x75 ) ) ? 4 : 0 )\
	: ( ( 0x74 == ((U8*)s)[2] ) && ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) ) ? 4 : 0 ) : 0 )

/*
	UTF8_CHAR: Matches legal UTF-EBCDIC encoded characters from 2 through 3 bytes

	0xA0 - 0x3FFF
*/
/*** GENERATED CODE ***/
#define is_UTF8_CHAR_utf8_no_length_checks(s)                               \
( ( ( 0x8A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x90 ) || ( 0x9A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0xA1 ) || ( 0xAA <= ((U8*)s)[0] && ((U8*)s)[0] <= 0xB5 ) ) ?\
    ( ( ( ( ((U8*)s)[1] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[1] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[1] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[1] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[1] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[1] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[1] & 0xFA ) == 0x70 ) ) ? 2 : 0 )\
: ( ( ( ( 0xB7 <= ((U8*)s)[0] && ((U8*)s)[0] <= 0xBA ) || ( 0xBE <= ((U8*)s)[0] && ((U8*)s)[0] <= 0xC0 ) || ( 0xCA <= ((U8*)s)[0] && ((U8*)s)[0] <= 0xD0 ) || 0xDA == ((U8*)s)[0] ) && ( ( ( ((U8*)s)[1] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[1] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[1] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[1] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[1] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[1] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[1] & 0xFA ) == 0x70 ) ) ) && ( ( ( ((U8*)s)[2] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[2] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[2] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[2] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[2] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFA ) == 0x70 ) ) ) ? 3 : 0 )

/*
	QUOTEMETA: Meta-characters that \Q should quote

	\p{_Perl_Quotemeta}
*/
/*** GENERATED CODE ***/
#define is_QUOTEMETA_high_part0(s)                                          \
( ( 0x64 == ((U8*)s)[1] ) ?                                                 \
	( ( 0x41 == ((U8*)s)[2] ) ? 3 : 0 )                                 \
    : ( ( 0x73 == ((U8*)s)[1] ) && ( ( ((U8*)s)[2] & 0xFE ) == 0x64 ) ) ? 3 : 0 )


/*** GENERATED CODE ***/
#define is_QUOTEMETA_high_part1(s)                                          \
( ( 0xBF == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x41 == ((U8*)s)[1] ) && ( 0x53 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x56 ) ) ? 3 : 0 )\
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x41 == ((U8*)s)[1] || ( 0x55 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x69 ) || ( 0x70 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x75 ) ) ?\
	( ( ( ( ((U8*)s)[2] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[2] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[2] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[2] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[2] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFA ) == 0x70 ) ) ? 3 : 0 )\
    : ( 0x42 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x49 ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x69 ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x74 ) ) ? 3 : 0 )\
    : ( 0x43 == ((U8*)s)[1] ) ?                                             \
	( ( ( ( ((U8*)s)[2] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[2] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[2] & 0xEE ) == 0x48 ) || ((U8*)s)[2] == 0x51 || ((U8*)s)[2] == 0x65 || ( ( ((U8*)s)[2] & 0xFE ) == 0x66 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFA ) == 0x70 ) ) ? 3 : 0 )\
    : ( 0x44 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x49 ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x57 ) ) ? 3 : 0 )\
    : ( ( 0x54 == ((U8*)s)[1] ) && ( ( ((U8*)s)[2] & 0xFE ) == 0x58 || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x69 ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x75 ) ) ) ? 3 : 0 )\
: ( 0xCB == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x41 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x43 ) || 0x49 == ((U8*)s)[1] || ( 0x51 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x59 ) || ( 0x62 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x69 ) || 0x70 == ((U8*)s)[1] || ( 0x73 <= ((U8*)s)[1] && ((U8*)s)[1] <= 0x75 ) ) ?\
	( ( ( ( ((U8*)s)[2] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[2] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[2] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[2] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[2] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFA ) == 0x70 ) ) ? 3 : 0 )\
    : ( 0x71 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x49 ) || ( 0x51 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x65 ) ) ? 3 : 0 )\
    : ( ( 0x72 == ((U8*)s)[1] ) && ( ( 0x64 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x69 ) || ( 0x70 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x75 ) ) ) ? 3 : 0 )\
: ( 0xCC == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ( ( ((U8*)s)[1] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[1] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[1] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[1] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[1] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[1] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[1] & 0xFA ) == 0x70 ) ) && ( ( ( ((U8*)s)[2] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[2] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[2] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[2] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[2] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFA ) == 0x70 ) ) ) ? 3 : 0 )\
: ( 0xCD == ((U8*)s)[0] ) ?                                                 \
    ( ( ( ( ((U8*)s)[1] & 0xFE ) == 0x58 || ( ((U8*)s)[1] & 0xFE ) == 0x62 ) && ( ( ( ((U8*)s)[2] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[2] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[2] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[2] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[2] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFA ) == 0x70 ) ) ) ? 3 : 0 )\
: ( 0xCE == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x41 == ((U8*)s)[1] ) ?                                             \
	( ( ( ( ((U8*)s)[2] & 0xE7 ) == 0x41 ) || ( ( ((U8*)s)[2] & 0xCE ) == 0x42 ) || ((U8*)s)[2] == 0x44 || ( ( ((U8*)s)[2] & 0xFC ) == 0x54 ) || ((U8*)s)[2] == 0x58 || ( ( ((U8*)s)[2] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFA ) == 0x70 ) ) ? 3 : 0 )\
    : ( 0x42 == ((U8*)s)[1] ) ?                                             \
	( ( 0x41 == ((U8*)s)[2] || 0x58 == ((U8*)s)[2] ) ? 3 : 0 )          \
    : ( ( 0x53 == ((U8*)s)[1] ) && ( 0x45 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xDC == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x75 == ((U8*)s)[1] ) ?                                             \
	( ( 0x51 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( ((U8*)s)[3] & 0xFE ) == 0x74 ) ? 4 : 0 )                  \
	: ( 0x58 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x49 ) || ( 0x51 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x57 ) ) ? 4 : 0 )\
	: ( 0x62 == ((U8*)s)[2] ) ?                                         \
	    ( ( ( ((U8*)s)[3] & 0xFE ) == 0x46 ) ? 4 : 0 )                  \
	: ( 0x67 == ((U8*)s)[2] ) ?                                         \
	    ( ( 0x75 == ((U8*)s)[3] ) ? 4 : 0 )                             \
	: ( 0x73 == ((U8*)s)[2] ) ?                                         \
	    ( ( 0x41 == ((U8*)s)[3] ) ? 4 : 0 )                             \
	: ( ( 0x75 == ((U8*)s)[2] ) && ( ( ((U8*)s)[3] & 0xFE ) == 0x58 || ( 0x62 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x68 ) ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ( 0xDE == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x57 == ((U8*)s)[1] ) ?                                             \
	( ( ( 0x46 == ((U8*)s)[2] ) && ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x44 ) ) ? 4 : 0 )\
    : ( ( ( 0x64 == ((U8*)s)[1] ) && ( 0x53 == ((U8*)s)[2] ) ) && ( ( 0x63 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x69 ) || 0x70 == ((U8*)s)[3] ) ) ? 4 : 0 )\
: ( ( ( ( ( 0xEB == ((U8*)s)[0] ) && ( 0x72 == ((U8*)s)[1] ) ) && ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x44 ) ) && ( ( ( ((U8*)s)[3] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[3] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[3] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[3] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[3] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[3] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[3] & 0xFA ) == 0x70 ) ) ) && ( ( ( ((U8*)s)[4] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[4] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[4] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[4] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[4] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[4] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[4] & 0xFA ) == 0x70 ) ) ) ? 5 : 0 )


/*** GENERATED CODE ***/
#define is_QUOTEMETA_high(s)                                                \
( ( 0xB0 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x57 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xB7 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x58 == ((U8*)s)[1] ) && ( 0x72 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xBA == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x52 == ((U8*)s)[1] ) ?                                             \
	( ( 0x75 == ((U8*)s)[2] ) ? 3 : 0 )                                 \
    : ( ( 0x53 == ((U8*)s)[1] ) && ( 0x41 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xBE == ((U8*)s)[0] ) ? is_QUOTEMETA_high_part0(s) : is_QUOTEMETA_high_part1(s) )

/*
	MULTI_CHAR_FOLD: multi-char strings that are folded to by a single character

	&regcharclass_multi_char_folds::multi_char_folds(1)
*/
/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part0(s,e)                             \
( ( 0x81 == ((U8*)s)[0] ) ?                                                 \
	( ( ( 0xAB == ((U8*)s)[1] ) && ( 0x74 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x86 == ((U8*)s)[0] ) ?                                             \
	( ( 0x86 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x89 == ((U8*)s)[2] || 0x93 == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x89 == ((U8*)s)[1] || 0x93 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x88 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x59 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x89 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x48 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x90 == ((U8*)s)[0] ) ?                                             \
	( ( ( ( 0x75 == ((U8*)s)[1] ) && ( 0x90 == ((U8*)s)[2] ) ) && ( 0x75 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0x91 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x54 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA2 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                      \
    : ( 0xA3 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x49 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA6 == ((U8*)s)[0] || 0xA8 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x52 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xAB == ((U8*)s)[0] ) ?                                             \
	( ( ( 0x72 == ((U8*)s)[1] ) && ( 0x95 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xB3 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFD ) == 0x54 ) ?                              \
	    ( ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x69 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x59 == ((U8*)s)[1] || 0x67 == ((U8*)s)[1] ) ?                  \
	    ( ( 0xB0 == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x69 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x69 == ((U8*)s)[1] ) && ( 0xB0 == ((U8*)s)[2] ) ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xB4 == ((U8*)s)[0] ) ?                                             \
	( ( 0x42 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xAE == ((U8*)s)[2] ) && ( 0x63 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x46 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xAE == ((U8*)s)[2] ) ?                                     \
		( ( 0x63 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB0 == ((U8*)s)[2] ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x51 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xB0 == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x69 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x56 == ((U8*)s)[1] ) && ( 0xB3 == ((U8*)s)[2] ) ) && ( 0x69 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xC0 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0x68 ) ?                              \
	    ( ( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x48 ) && ( 0xB3 == ((U8*)s)[3] ) ) && ( 0x69 == ((U8*)s)[4] ) ) ? 5 : 0 )\
	: ( ( ( ( 0x71 == ((U8*)s)[1] ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x48 ) || 0x58 == ((U8*)s)[2] || 0x64 == ((U8*)s)[2] || 0x72 == ((U8*)s)[2] ) ) && ( 0xB3 == ((U8*)s)[3] ) ) && ( 0x69 == ((U8*)s)[4] ) ) ? 5 : 0 )\
    : 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part1(s,e)                             \
( ((e)-(s) > 3) ?                                                           \
    ( ( 0x81 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAB == ((U8*)s)[1] ) && ( 0x74 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x86 == ((U8*)s)[0] ) ?                                             \
	( ( 0x86 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x89 == ((U8*)s)[2] || 0x93 == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x89 == ((U8*)s)[1] || 0x93 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x88 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x59 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x89 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x48 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x90 == ((U8*)s)[0] ) ?                                             \
	( ( ( ( 0x75 == ((U8*)s)[1] ) && ( 0x90 == ((U8*)s)[2] ) ) && ( 0x75 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0x91 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x54 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA2 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                      \
    : ( 0xA3 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x49 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA6 == ((U8*)s)[0] || 0xA8 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x52 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xAB == ((U8*)s)[0] ) ?                                             \
	( ( ( 0x72 == ((U8*)s)[1] ) && ( 0x95 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xB3 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFD ) == 0x54 ) ?                              \
	    ( ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x69 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x59 == ((U8*)s)[1] || 0x67 == ((U8*)s)[1] ) ?                  \
	    ( ( 0xB0 == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x69 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x69 == ((U8*)s)[1] ) && ( 0xB0 == ((U8*)s)[2] ) ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xB4 == ((U8*)s)[0] ) ?                                             \
	( ( 0x42 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xAE == ((U8*)s)[2] ) && ( 0x63 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x46 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xAE == ((U8*)s)[2] ) ?                                     \
		( ( 0x63 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB0 == ((U8*)s)[2] ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x51 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xB0 == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ? 4 : 0 )                         \
	    : ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x69 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x56 == ((U8*)s)[1] ) && ( 0xB3 == ((U8*)s)[2] ) ) && ( 0x69 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ((e)-(s) > 2) ?                                                           \
    ( ( 0x81 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAB == ((U8*)s)[1] ) && ( 0x74 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x86 == ((U8*)s)[0] ) ?                                             \
	( ( 0x86 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x89 == ((U8*)s)[2] || 0x93 == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x89 == ((U8*)s)[1] || 0x93 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x88 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x59 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x89 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x48 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x91 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x54 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA2 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                      \
    : ( 0xA3 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x49 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA6 == ((U8*)s)[0] || 0xA8 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x52 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( ( ( 0xAB == ((U8*)s)[0] ) && ( 0x72 == ((U8*)s)[1] ) ) && ( 0x95 == ((U8*)s)[2] ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( 0x86 == ((U8*)s)[0] ) ?                                             \
	( ( 0x86 == ((U8*)s)[1] || 0x89 == ((U8*)s)[1] || 0x93 == ((U8*)s)[1] ) ? 2 : 0 )\
    : ( ( 0xA2 == ((U8*)s)[0] ) && ( ( ((U8*)s)[1] & 0xFE ) == 0xA2 ) ) ? 2 : 0 )\
: 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe(s,e)                                   \
( ((e)-(s) > 5) ?                                                           \
    ( ( 0x81 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAB == ((U8*)s)[1] ) && ( 0x74 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x86 == ((U8*)s)[0] ) ?                                             \
	( ( 0x86 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x89 == ((U8*)s)[2] || 0x93 == ((U8*)s)[2] ) ? 3 : 2 )      \
	: ( 0x89 == ((U8*)s)[1] || 0x93 == ((U8*)s)[1] ) ? 2 : 0 )          \
    : ( 0x88 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAF == ((U8*)s)[1] ) && ( 0x59 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x89 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x48 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0x90 == ((U8*)s)[0] ) ?                                             \
	( ( ( ( 0x75 == ((U8*)s)[1] ) && ( 0x90 == ((U8*)s)[2] ) ) && ( 0x75 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0x91 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x54 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA2 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                      \
    : ( 0xA3 == ((U8*)s)[0] ) ?                                             \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x49 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xA6 == ((U8*)s)[0] || 0xA8 == ((U8*)s)[0] ) ?                      \
	( ( ( 0xAE == ((U8*)s)[1] ) && ( 0x52 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xAB == ((U8*)s)[0] ) ?                                             \
	( ( ( 0x72 == ((U8*)s)[1] ) && ( 0x95 == ((U8*)s)[2] ) ) ? 3 : 0 )  \
    : ( 0xB3 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFD ) == 0x54 ) ?                              \
	    ( ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x69 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x59 == ((U8*)s)[1] || 0x67 == ((U8*)s)[1] ) ?                  \
	    ( ( 0xB0 == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ?                                 \
		    ( ( ( 0xB3 == ((U8*)s)[4] ) && ( 0x69 == ((U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x69 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x69 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xAE == ((U8*)s)[2] ) ?                                     \
		( ( 0x49 == ((U8*)s)[3] ) ?                                 \
		    ( ( 0xAE == ((U8*)s)[4] ) ?                             \
			( ( 0x41 == ((U8*)s)[5] || 0x42 == ((U8*)s)[5] ) ? 6 : 0 )\
		    : ( ( 0xB0 == ((U8*)s)[4] ) && ( 0x43 == ((U8*)s)[5] ) ) ? 6 : 0 )\
		: 0 )                                                       \
	    : ( ( 0xB0 == ((U8*)s)[2] ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: 0 )                                                               \
    : ( 0xB4 == ((U8*)s)[0] ) ?                                             \
	( ( 0x42 == ((U8*)s)[1] ) ?                                         \
	    ( ( ( 0xAE == ((U8*)s)[2] ) && ( 0x63 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x46 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xAE == ((U8*)s)[2] ) ?                                     \
		( ( 0x49 == ((U8*)s)[3] ) ?                                 \
		    ( ( 0xAE == ((U8*)s)[4] ) ?                             \
			( ( 0x41 == ((U8*)s)[5] || 0x42 == ((U8*)s)[5] ) ? 6 : 0 )\
		    : ( ( 0xB0 == ((U8*)s)[4] ) && ( 0x43 == ((U8*)s)[5] ) ) ? 6 : 0 )\
		: ( 0x63 == ((U8*)s)[3] ) ?                                 \
		    ( ( 0xAE == ((U8*)s)[4] ) ?                             \
			( ( 0x41 == ((U8*)s)[5] || 0x42 == ((U8*)s)[5] ) ? 6 : 4 )\
		    : ( ( 0xB0 == ((U8*)s)[4] ) && ( 0x43 == ((U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xB0 == ((U8*)s)[2] ) && ( 0x43 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x51 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0xB0 == ((U8*)s)[2] ) ?                                     \
		( ( 0x43 == ((U8*)s)[3] ) ?                                 \
		    ( ( ( 0xB3 == ((U8*)s)[4] ) && ( 0x69 == ((U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xB3 == ((U8*)s)[2] ) && ( 0x69 == ((U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x56 == ((U8*)s)[1] ) && ( 0xB3 == ((U8*)s)[2] ) ) && ( 0x69 == ((U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xB7 == ((U8*)s)[0] ) ?                                             \
	( ( 0x53 == ((U8*)s)[1] ) ?                                         \
	    ( ( 0x46 == ((U8*)s)[2] ) ?                                     \
		( ( ( ( 0xB7 == ((U8*)s)[3] ) && ( 0x54 == ((U8*)s)[4] ) ) && ( 0x43 == ((U8*)s)[5] ) ) ? 6 : 0 )\
	    : ( 0x64 == ((U8*)s)[2] ) ?                                     \
		( ( ( ( 0xB7 == ((U8*)s)[3] ) && ( 0x53 == ((U8*)s)[4] ) ) && ( ( ( ((U8*)s)[5] & 0xDF ) == 0x46 ) || ((U8*)s)[5] == 0x53 || ((U8*)s)[5] == 0x55 ) ) ? 6 : 0 )\
	    : ( ( ( ( 0x74 == ((U8*)s)[2] ) && ( 0xB7 == ((U8*)s)[3] ) ) && ( 0x53 == ((U8*)s)[4] ) ) && ( 0x66 == ((U8*)s)[5] ) ) ? 6 : 0 )\
	: 0 )                                                               \
    : ( 0xC0 == ((U8*)s)[0] ) ?                                             \
	( ( ( ((U8*)s)[1] & 0xFE ) == 0x68 ) ?                              \
	    ( ( ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x48 ) && ( 0xB3 == ((U8*)s)[3] ) ) && ( 0x69 == ((U8*)s)[4] ) ) ? 5 : 0 )\
	: ( ( ( ( 0x71 == ((U8*)s)[1] ) && ( ( 0x41 <= ((U8*)s)[2] && ((U8*)s)[2] <= 0x48 ) || 0x58 == ((U8*)s)[2] || 0x64 == ((U8*)s)[2] || 0x72 == ((U8*)s)[2] ) ) && ( 0xB3 == ((U8*)s)[3] ) ) && ( 0x69 == ((U8*)s)[4] ) ) ? 5 : 0 )\
    : 0 )                                                                   \
: ((e)-(s) > 4) ? is_MULTI_CHAR_FOLD_utf8_safe_part0(s,e) : is_MULTI_CHAR_FOLD_utf8_safe_part1(s,e) )

/*
	MULTI_CHAR_FOLD: multi-char strings that are folded to by a single character

	&regcharclass_multi_char_folds::multi_char_folds(0)
*/
/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_latin1_safe(s,e)                                 \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( ((U8*)s)[0] & 0xBF ) == 0x86 ) ?                                  \
	( ( ( ((U8*)s)[1] & 0xBF ) == 0x86 ) ?                              \
	    ( ( ( ( ((U8*)s)[2] & 0xBF ) == 0x89 ) || ( ( ((U8*)s)[2] & 0xBF ) == 0x93 ) ) ? 3 : 2 )\
	: ( ( ( ((U8*)s)[1] & 0xBF ) == 0x89 ) || ( ( ((U8*)s)[1] & 0xBF ) == 0x93 ) ) ? 2 : 0 )\
    : ( ( ( ((U8*)s)[0] & 0xBF ) == 0xA2 ) && ( ( ((U8*)s)[1] & 0xBE ) == 0xA2 ) ) ? 2 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( ((U8*)s)[0] & 0xBF ) == 0x86 ) ?                                  \
	( ( ( ( ((U8*)s)[1] & 0xBF ) == 0x86 ) || ( ( ((U8*)s)[1] & 0xBF ) == 0x89 ) || ( ( ((U8*)s)[1] & 0xBF ) == 0x93 ) ) ? 2 : 0 )\
    : ( ( ( ((U8*)s)[0] & 0xBF ) == 0xA2 ) && ( ( ((U8*)s)[1] & 0xBE ) == 0xA2 ) ) ? 2 : 0 )\
: 0 )

/*
	FOLDS_TO_MULTI: characters that fold to multi-char strings

	\p{_Perl_Folds_To_Multi_Char}
*/
/*** GENERATED CODE ***/
#define is_FOLDS_TO_MULTI_utf8(s)                                           \
( ( 0x8B == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x75 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8E == ((U8*)s)[0] || 0x9D == ((U8*)s)[0] || ( ((U8*)s)[0] & 0xFE ) == 0xB2 ) ?\
    ( ( 0x58 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8F == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x51 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xB7 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x54 == ((U8*)s)[1] ) && ( 0x48 == ((U8*)s)[2] ) ) ? 3 : 0 )      \
: ( 0xC0 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x64 == ((U8*)s)[1] ) ?                                             \
	( ( ( ( ((U8*)s)[2] & 0xFE ) == 0x66 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFB ) == 0x70 ) ) ? 3 : 0 )\
    : ( 0x70 == ((U8*)s)[1] ) ?                                             \
	( ( ((U8*)s)[2] == 0x58 || ((U8*)s)[2] == 0x62 || ( ( ((U8*)s)[2] & 0xFD ) == 0x64 ) ) ? 3 : 0 )\
    : ( 0x72 == ((U8*)s)[1] ) ?                                             \
	( ( ( ( ((U8*)s)[2] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[2] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[2] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[2] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[2] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFA ) == 0x70 ) ) ? 3 : 0 )\
    : ( 0x73 == ((U8*)s)[1] ) ?                                             \
	( ( ( ( ((U8*)s)[2] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[2] & 0xEE ) == 0x42 ) || ( ( ((U8*)s)[2] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x48 ) || ( ( ((U8*)s)[2] & 0xFA ) == 0x62 ) || ((U8*)s)[2] == 0x64 || ((U8*)s)[2] == 0x72 ) ? 3 : 0 )\
    : ( 0x74 == ((U8*)s)[1] ) ?                                             \
	( ( ( ( ((U8*)s)[2] & 0xFB ) == 0x43 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x44 ) || ((U8*)s)[2] == 0x48 || ((U8*)s)[2] == 0x54 || ( ( ((U8*)s)[2] & 0xFA ) == 0x62 ) ) ? 3 : 0 )\
    : ( ( 0x75 == ((U8*)s)[1] ) && ( ( ( ((U8*)s)[2] & 0xFB ) == 0x43 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x44 ) || ((U8*)s)[2] == 0x48 || ( ( ((U8*)s)[2] & 0xFA ) == 0x62 ) || ((U8*)s)[2] == 0x64 || ((U8*)s)[2] == 0x72 ) ) ? 3 : 0 )\
: ( ( ( ( 0xDC == ((U8*)s)[0] ) && ( 0x74 == ((U8*)s)[1] ) ) && ( 0x68 == ((U8*)s)[2] ) ) && ( ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) || ( 0x63 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x67 ) ) ) ? 4 : 0 )

/*
	PROBLEMATIC_LOCALE_FOLD: characters whose fold is problematic under locale

	\p{_Perl_Problematic_Locale_Folds}
*/
/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLD_utf8(s)                                  \
( ( ( ( ((U8*)s)[0] & 0xC0 ) == 0x00 ) || ( ( ((U8*)s)[0] & 0xEF ) == 0x40 ) || ( ( ((U8*)s)[0] & 0xCE ) == 0x4A ) || ( ( ((U8*)s)[0] & 0xCC ) == 0x4C ) || ( ( ((U8*)s)[0] & 0xFE ) == 0x60 ) || ( ( ((U8*)s)[0] & 0xAF ) == 0x81 ) || ( ( ((U8*)s)[0] & 0xEE ) == 0x82 ) || ( ( ((U8*)s)[0] & 0xEC ) == 0x84 ) || ( ( ((U8*)s)[0] & 0xEE ) == 0x88 ) || ( ( ((U8*)s)[0] & 0xFE ) == 0xA2 ) || ( ( ((U8*)s)[0] & 0xFC ) == 0xA4 ) || ( ( ((U8*)s)[0] & 0xFE ) == 0xA8 ) || ( ( ((U8*)s)[0] & 0xBF ) == 0xBB ) || ( ( ((U8*)s)[0] & 0xFE ) == 0xBC ) || ( ( ((U8*)s)[0] & 0xCE ) == 0xC2 ) || ( ( ((U8*)s)[0] & 0xCC ) == 0xC4 ) || ( ( ((U8*)s)[0] & 0xCE ) == 0xC8 ) || ( ( ((U8*)s)[0] & 0xFE ) == 0xF0 ) || ( ( ((U8*)s)[0] & 0xFD ) == 0xFD ) ) ? 1\
: ( 0x8A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x8C ) ?                          \
    ( ( ( ( ((U8*)s)[1] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[1] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[1] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[1] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[1] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[1] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[1] & 0xFA ) == 0x70 ) ) ? 2 : 0 )\
: ( 0x8E == ((U8*)s)[0] || 0x9D == ((U8*)s)[0] ) ?                          \
    ( ( 0x58 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8F == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x51 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x90 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x68 == ((U8*)s)[1] || 0x75 == ((U8*)s)[1] ) ? 2 : 0 )              \
: ( ( ((U8*)s)[0] & 0xFE ) == 0xB2 ) ?                                      \
    ( ( 0x72 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xC0 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x64 == ((U8*)s)[1] ) && ( ( ( ((U8*)s)[2] & 0xFE ) == 0x66 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFB ) == 0x70 ) ) ) ? 3 : 0 )\
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x51 == ((U8*)s)[1] ) && ( ( ((U8*)s)[2] & 0xFE ) == 0x52 ) ) ? 3 : 0 )\
: ( ( ( ( 0xDC == ((U8*)s)[0] ) && ( 0x74 == ((U8*)s)[1] ) ) && ( 0x68 == ((U8*)s)[2] ) ) && ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) ) ? 4 : 0 )

/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLD_cp(cp)                                   \
( cp <= 0xFF || ( 0xFF < cp &&                                              \
( 0x130 == cp || ( 0x130 < cp &&                                            \
( 0x149 == cp || ( 0x149 < cp &&                                            \
( 0x178 == cp || ( 0x178 < cp &&                                            \
( 0x17F == cp || ( 0x17F < cp &&                                            \
( 0x1F0 == cp || ( 0x1F0 < cp &&                                            \
( 0x39C == cp || ( 0x39C < cp &&                                            \
( 0x3BC == cp || ( 0x3BC < cp &&                                            \
( ( 0x1E96 <= cp && cp <= 0x1E9A ) || ( 0x1E9A < cp &&                      \
( 0x1E9E == cp || ( 0x1E9E < cp &&                                          \
( 0x212A == cp || ( 0x212A < cp &&                                          \
( 0x212B == cp || ( 0xFB00 <= cp && cp <= 0xFB06 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

/*
	PROBLEMATIC_LOCALE_FOLDEDS_START: The first folded character of folds which are problematic under locale

	\p{_Perl_Problematic_Locale_Foldeds_Start}
*/
/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLDEDS_START_utf8(s)                         \
( ( ( ( ((U8*)s)[0] & 0xC0 ) == 0x00 ) || ( ( ((U8*)s)[0] & 0xEF ) == 0x40 ) || ( ( ((U8*)s)[0] & 0xCE ) == 0x4A ) || ( ( ((U8*)s)[0] & 0xCC ) == 0x4C ) || ( ( ((U8*)s)[0] & 0xFE ) == 0x60 ) || ( ( ((U8*)s)[0] & 0xAF ) == 0x81 ) || ( ( ((U8*)s)[0] & 0xEE ) == 0x82 ) || ( ( ((U8*)s)[0] & 0xEC ) == 0x84 ) || ( ( ((U8*)s)[0] & 0xEE ) == 0x88 ) || ( ( ((U8*)s)[0] & 0xFE ) == 0xA2 ) || ( ( ((U8*)s)[0] & 0xFC ) == 0xA4 ) || ( ( ((U8*)s)[0] & 0xFE ) == 0xA8 ) || ( ( ((U8*)s)[0] & 0xBF ) == 0xBB ) || ( ( ((U8*)s)[0] & 0xFE ) == 0xBC ) || ( ( ((U8*)s)[0] & 0xCE ) == 0xC2 ) || ( ( ((U8*)s)[0] & 0xCC ) == 0xC4 ) || ( ( ((U8*)s)[0] & 0xCE ) == 0xC8 ) || ( ( ((U8*)s)[0] & 0xFE ) == 0xF0 ) || ( ( ((U8*)s)[0] & 0xFD ) == 0xFD ) ) ? 1\
: ( 0x8A <= ((U8*)s)[0] && ((U8*)s)[0] <= 0x8C ) ?                          \
    ( ( ( ( ((U8*)s)[1] & 0xEF ) == 0x41 ) || ( ( ((U8*)s)[1] & 0xCE ) == 0x42 ) || ( ( ((U8*)s)[1] & 0xEC ) == 0x44 ) || ( ( ((U8*)s)[1] & 0xEE ) == 0x48 ) || ( ( ((U8*)s)[1] & 0xFC ) == 0x64 ) || ( ( ((U8*)s)[1] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[1] & 0xFA ) == 0x70 ) ) ? 2 : 0 )\
: ( 0x8E == ((U8*)s)[0] || 0x9D == ((U8*)s)[0] ) ?                          \
    ( ( 0x58 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x8F == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x51 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0x90 == ((U8*)s)[0] ) ?                                                 \
    ( ( 0x68 == ((U8*)s)[1] || 0x75 == ((U8*)s)[1] ) ? 2 : 0 )              \
: ( 0xAB == ((U8*)s)[0] || ( ((U8*)s)[0] & 0xFE ) == 0xB2 ) ?               \
    ( ( 0x72 == ((U8*)s)[1] ) ? 2 : 0 )                                     \
: ( 0xC0 == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x64 == ((U8*)s)[1] ) && ( ( ( ((U8*)s)[2] & 0xFE ) == 0x66 ) || ( ( ((U8*)s)[2] & 0xFE ) == 0x68 ) || ( ( ((U8*)s)[2] & 0xFB ) == 0x70 ) ) ) ? 3 : 0 )\
: ( 0xCA == ((U8*)s)[0] ) ?                                                 \
    ( ( ( 0x51 == ((U8*)s)[1] ) && ( ( ((U8*)s)[2] & 0xFE ) == 0x52 ) ) ? 3 : 0 )\
: ( ( ( ( 0xDC == ((U8*)s)[0] ) && ( 0x74 == ((U8*)s)[1] ) ) && ( 0x68 == ((U8*)s)[2] ) ) && ( 0x41 <= ((U8*)s)[3] && ((U8*)s)[3] <= 0x47 ) ) ? 4 : 0 )

/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLDEDS_START_cp(cp)                          \
( cp <= 0xFF || ( 0xFF < cp &&                                              \
( 0x130 == cp || ( 0x130 < cp &&                                            \
( 0x149 == cp || ( 0x149 < cp &&                                            \
( 0x178 == cp || ( 0x178 < cp &&                                            \
( 0x17F == cp || ( 0x17F < cp &&                                            \
( 0x1F0 == cp || ( 0x1F0 < cp &&                                            \
( 0x2BC == cp || ( 0x2BC < cp &&                                            \
( 0x39C == cp || ( 0x39C < cp &&                                            \
( 0x3BC == cp || ( 0x3BC < cp &&                                            \
( ( 0x1E96 <= cp && cp <= 0x1E9A ) || ( 0x1E9A < cp &&                      \
( 0x1E9E == cp || ( 0x1E9E < cp &&                                          \
( 0x212A == cp || ( 0x212A < cp &&                                          \
( 0x212B == cp || ( 0xFB00 <= cp && cp <= 0xFB06 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

/*
	PATWS: pattern white space

	\p{PatWS}
*/
/*** GENERATED CODE ***/
#define is_PATWS_safe(s,e,is_utf8)                                          \
( ( LIKELY((e) > (s)) ) ?                                                   \
    ( ( ( ( ((U8*)s)[0] & 0xEF ) == 0x05 ) || ((U8*)s)[0] == 0x0B || ( ( ((U8*)s)[0] & 0xFE ) == 0x0C ) || ((U8*)s)[0] == 0x25 || ((U8*)s)[0] == 0x40 ) ? 1\
    : ( ( is_utf8 && LIKELY(((e) - (s)) >= UTF8SKIP(s)) ) && ( 0xCA == ((U8*)s)[0] ) ) ? ( ( 0x41 == ((U8*)s)[1] ) ?\
		    ( ( ( ((U8*)s)[2] & 0xFE ) == 0x56 ) ? 3 : 0 )          \
		: ( ( 0x42 == ((U8*)s)[1] ) && ( 0x49 == ((U8*)s)[2] || 0x51 == ((U8*)s)[2] ) ) ? 3 : 0 ) : 0 )\
: 0 )

/*** GENERATED CODE ***/
#define is_PATWS_cp(cp)                                                     \
( 0x05 == cp || ( 0x05 < cp &&                                              \
( ( 0x0B <= cp && cp <= 0x0D ) || ( 0x0D < cp &&                            \
( 0x15 == cp || ( 0x15 < cp &&                                              \
( 0x25 == cp || ( 0x25 < cp &&                                              \
( 0x40 == cp || ( 0x40 < cp &&                                              \
( 0x200E == cp || ( 0x200E < cp &&                                          \
( 0x200F == cp || ( 0x200F < cp &&                                          \
( 0x2028 == cp || 0x2029 == cp ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

#endif	/* EBCDIC POSIX-BC */

#endif /* H_REGCHARCLASS */

/* ex: set ro: */
