use Unicode::Collate::CJK::Zhuyin;
+{
   locale_version => 0.94,
   overrideCJK => \&Unicode::Collate::CJK::Zhuyin::weightZhuyin,
   entry => <<'ENTRY', # for DUCET v6.2.0
02C9      ; [.0000.0199.0002.02C9] # MODIFIER LETTER MACRON
02CA      ; [.019A.0020.0002.02CA] # MODIFIER LETTER ACUTE ACCENT
02C7      ; [.019B.0020.0002.02C7] # CARON
02CB      ; [.019C.0020.0002.02CB] # MODIFIER LETTER GRAVE ACCENT
02D9      ; [.019D.0020.0002.02D9] # DOT ABOVE
02EA      ; [.019E.0020.0002.02EA] # MODIFIER LETTER YIN DEPARTING TONE MARK
02EB      ; [.019F.0020.0002.02EB] # MODIFIER LETTER YANG DEPARTING TONE MARK
0101      ; [.15EF.001C.0002.0101] # LATIN SMALL LETTER A WITH MACRON
0061 0304 ; [.15EF.001C.0002.0101] # LATIN SMALL LETTER A WITH MACRON
0100      ; [.15EF.001C.0008.0100] # LATIN CAPITAL LETTER A WITH MACRON
0041 0304 ; [.15EF.001C.0008.0100] # LATIN CAPITAL LETTER A WITH MACRON
00E1      ; [.15EF.001D.0002.00E1] # LATIN SMALL LETTER A WITH ACUTE
0061 0301 ; [.15EF.001D.0002.00E1] # LATIN SMALL LETTER A WITH ACUTE
0061 0341 ; [.15EF.001D.0002.00E1] # LATIN SMALL LETTER A WITH ACUTE
00C1      ; [.15EF.001D.0008.00C1] # LATIN CAPITAL LETTER A WITH ACUTE
0041 0301 ; [.15EF.001D.0008.00C1] # LATIN CAPITAL LETTER A WITH ACUTE
0041 0341 ; [.15EF.001D.0008.00C1] # LATIN CAPITAL LETTER A WITH ACUTE
01CE      ; [.15EF.001E.0002.01CE] # LATIN SMALL LETTER A WITH CARON
0061 030C ; [.15EF.001E.0002.01CE] # LATIN SMALL LETTER A WITH CARON
01CD      ; [.15EF.001E.0008.01CD] # LATIN CAPITAL LETTER A WITH CARON
0041 030C ; [.15EF.001E.0008.01CD] # LATIN CAPITAL LETTER A WITH CARON
00E0      ; [.15EF.001F.0002.00E0] # LATIN SMALL LETTER A WITH GRAVE
0061 0300 ; [.15EF.001F.0002.00E0] # LATIN SMALL LETTER A WITH GRAVE
0061 0340 ; [.15EF.001F.0002.00E0] # LATIN SMALL LETTER A WITH GRAVE
00C0      ; [.15EF.001F.0008.00C0] # LATIN CAPITAL LETTER A WITH GRAVE
0041 0300 ; [.15EF.001F.0008.00C0] # LATIN CAPITAL LETTER A WITH GRAVE
0041 0340 ; [.15EF.001F.0008.00C0] # LATIN CAPITAL LETTER A WITH GRAVE
0113      ; [.164C.001C.0002.0113] # LATIN SMALL LETTER E WITH MACRON
0065 0304 ; [.164C.001C.0002.0113] # LATIN SMALL LETTER E WITH MACRON
0112      ; [.164C.001C.0008.0112] # LATIN CAPITAL LETTER E WITH MACRON
0045 0304 ; [.164C.001C.0008.0112] # LATIN CAPITAL LETTER E WITH MACRON
00E9      ; [.164C.001D.0002.00E9] # LATIN SMALL LETTER E WITH ACUTE
0065 0301 ; [.164C.001D.0002.00E9] # LATIN SMALL LETTER E WITH ACUTE
0065 0341 ; [.164C.001D.0002.00E9] # LATIN SMALL LETTER E WITH ACUTE
00C9      ; [.164C.001D.0008.00C9] # LATIN CAPITAL LETTER E WITH ACUTE
0045 0301 ; [.164C.001D.0008.00C9] # LATIN CAPITAL LETTER E WITH ACUTE
0045 0341 ; [.164C.001D.0008.00C9] # LATIN CAPITAL LETTER E WITH ACUTE
011B      ; [.164C.001E.0002.011B] # LATIN SMALL LETTER E WITH CARON
0065 030C ; [.164C.001E.0002.011B] # LATIN SMALL LETTER E WITH CARON
011A      ; [.164C.001E.0008.011A] # LATIN CAPITAL LETTER E WITH CARON
0045 030C ; [.164C.001E.0008.011A] # LATIN CAPITAL LETTER E WITH CARON
00E8      ; [.164C.001F.0002.00E8] # LATIN SMALL LETTER E WITH GRAVE
0065 0300 ; [.164C.001F.0002.00E8] # LATIN SMALL LETTER E WITH GRAVE
0065 0340 ; [.164C.001F.0002.00E8] # LATIN SMALL LETTER E WITH GRAVE
00C8      ; [.164C.001F.0008.00C8] # LATIN CAPITAL LETTER E WITH GRAVE
0045 0300 ; [.164C.001F.0008.00C8] # LATIN CAPITAL LETTER E WITH GRAVE
0045 0340 ; [.164C.001F.0008.00C8] # LATIN CAPITAL LETTER E WITH GRAVE
00EA 0304 ; [.164C.0021.0002.00EA] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING MACRON>
00CA 0304 ; [.164C.0021.0008.00CA] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING MACRON>
0065 0302 0304 ; [.164C.0021.0002.00EA] # <LATIN SMALL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING MACRON>
0045 0302 0304 ; [.164C.0021.0008.00CA] # <LATIN CAPITAL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING MACRON>
1EBF      ; [.164C.0022.0002.1EBF] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
0065 0302 0301 ; [.164C.0022.0002.1EBF] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
0065 0302 0341 ; [.164C.0022.0002.1EBF] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
1EBE      ; [.164C.0022.0008.1EBE] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
0045 0302 0301 ; [.164C.0022.0008.1EBE] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
0045 0302 0341 ; [.164C.0022.0008.1EBE] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
00EA 0301 ; [.164C.0022.0002.1EBF] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE ACCENT>
00EA 0341 ; [.164C.0022.0002.1EBF] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE TONE MARK>
00CA 0301 ; [.164C.0022.0008.1EBE] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE ACCENT>
00CA 0341 ; [.164C.0022.0008.1EBE] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE TONE MARK>
00EA 030C ; [.164C.0023.0002.00EA] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING CARON>
00CA 030C ; [.164C.0023.0008.00CA] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING CARON>
0065 0302 030C ; [.164C.0023.0002.00EA] # <LATIN SMALL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING CARON>
0045 0302 030C ; [.164C.0023.0008.00CA] # <LATIN CAPITAL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING CARON>
1EC1      ; [.164C.0024.0002.1EC1] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
0065 0302 0300 ; [.164C.0024.0002.1EC1] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
0065 0302 0340 ; [.164C.0024.0002.1EC1] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
1EC0      ; [.164C.0024.0008.1EC0] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
0045 0302 0300 ; [.164C.0024.0008.1EC0] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
0045 0302 0340 ; [.164C.0024.0008.1EC0] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
00EA 0300 ; [.164C.0024.0002.1EC1] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE ACCENT>
00EA 0340 ; [.164C.0024.0002.1EC1] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE TONE MARK>
00CA 0300 ; [.164C.0024.0008.1EC0] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE ACCENT>
00CA 0340 ; [.164C.0024.0008.1EC0] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE TONE MARK>
00EA      ; [.164C.0025.0002.00EA] # LATIN SMALL LETTER E WITH CIRCUMFLEX
0065 0302 ; [.164C.0025.0002.00EA] # LATIN SMALL LETTER E WITH CIRCUMFLEX
00CA      ; [.164C.0025.0008.00CA] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX
0045 0302 ; [.164C.0025.0008.00CA] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX
1EC5      ; [.164C.0025.0002.00EA][.0000.004E.0002.0303] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
1EC4      ; [.164C.0025.0008.00CA][.0000.004E.0002.0303] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
1EC3      ; [.164C.0025.0002.00EA][.0000.0064.0002.0309] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
1EC2      ; [.164C.0025.0008.00CA][.0000.0064.0002.0309] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
1EC7      ; [.164C.0025.0002.00EA][.0000.0070.0002.0323] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
1EC6      ; [.164C.0025.0008.00CA][.0000.0070.0002.0323] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
012B      ; [.16CD.001C.0002.012B] # LATIN SMALL LETTER I WITH MACRON
0069 0304 ; [.16CD.001C.0002.012B] # LATIN SMALL LETTER I WITH MACRON
012A      ; [.16CD.001C.0008.012A] # LATIN CAPITAL LETTER I WITH MACRON
0049 0304 ; [.16CD.001C.0008.012A] # LATIN CAPITAL LETTER I WITH MACRON
00ED      ; [.16CD.001D.0002.00ED] # LATIN SMALL LETTER I WITH ACUTE
0069 0301 ; [.16CD.001D.0002.00ED] # LATIN SMALL LETTER I WITH ACUTE
0069 0341 ; [.16CD.001D.0002.00ED] # LATIN SMALL LETTER I WITH ACUTE
00CD      ; [.16CD.001D.0008.00CD] # LATIN CAPITAL LETTER I WITH ACUTE
0049 0301 ; [.16CD.001D.0008.00CD] # LATIN CAPITAL LETTER I WITH ACUTE
0049 0341 ; [.16CD.001D.0008.00CD] # LATIN CAPITAL LETTER I WITH ACUTE
01D0      ; [.16CD.001E.0002.01D0] # LATIN SMALL LETTER I WITH CARON
0069 030C ; [.16CD.001E.0002.01D0] # LATIN SMALL LETTER I WITH CARON
01CF      ; [.16CD.001E.0008.01CF] # LATIN CAPITAL LETTER I WITH CARON
0049 030C ; [.16CD.001E.0008.01CF] # LATIN CAPITAL LETTER I WITH CARON
00EC      ; [.16CD.001F.0002.00EC] # LATIN SMALL LETTER I WITH GRAVE
0069 0300 ; [.16CD.001F.0002.00EC] # LATIN SMALL LETTER I WITH GRAVE
0069 0340 ; [.16CD.001F.0002.00EC] # LATIN SMALL LETTER I WITH GRAVE
00CC      ; [.16CD.001F.0008.00CC] # LATIN CAPITAL LETTER I WITH GRAVE
0049 0300 ; [.16CD.001F.0008.00CC] # LATIN CAPITAL LETTER I WITH GRAVE
0049 0340 ; [.16CD.001F.0008.00CC] # LATIN CAPITAL LETTER I WITH GRAVE
006D 0304 ; [.1741.001C.0002.006D] # <LATIN SMALL LETTER M, COMBINING MACRON>
004D 0304 ; [.1741.001C.0008.004D] # <LATIN CAPITAL LETTER M, COMBINING MACRON>
1E3F      ; [.1741.001D.0002.1E3F] # LATIN SMALL LETTER M WITH ACUTE
006D 0301 ; [.1741.001D.0002.1E3F] # LATIN SMALL LETTER M WITH ACUTE
006D 0341 ; [.1741.001D.0002.1E3F] # LATIN SMALL LETTER M WITH ACUTE
1E3E      ; [.1741.001D.0008.1E3E] # LATIN CAPITAL LETTER M WITH ACUTE
004D 0301 ; [.1741.001D.0008.1E3E] # LATIN CAPITAL LETTER M WITH ACUTE
004D 0341 ; [.1741.001D.0008.1E3E] # LATIN CAPITAL LETTER M WITH ACUTE
006D 030C ; [.1741.001E.0002.006D] # <LATIN SMALL LETTER M, COMBINING CARON>
004D 030C ; [.1741.001E.0008.004D] # <LATIN CAPITAL LETTER M, COMBINING CARON>
006D 0300 ; [.1741.001F.0002.006D] # <LATIN SMALL LETTER M, COMBINING GRAVE ACCENT>
006D 0340 ; [.1741.001F.0002.006D] # <LATIN SMALL LETTER M, COMBINING GRAVE TONE MARK>
004D 0300 ; [.1741.001F.0008.004D] # <LATIN CAPITAL LETTER M, COMBINING GRAVE ACCENT>
004D 0340 ; [.1741.001F.0008.004D] # <LATIN CAPITAL LETTER M, COMBINING GRAVE TONE MARK>
006E 0304 ; [.174F.001C.0002.006E] # <LATIN SMALL LETTER N, COMBINING MACRON>
004E 0304 ; [.174F.001C.0008.004E] # <LATIN CAPITAL LETTER N, COMBINING MACRON>
0144      ; [.174F.001D.0002.0144] # LATIN SMALL LETTER N WITH ACUTE
006E 0301 ; [.174F.001D.0002.0144] # LATIN SMALL LETTER N WITH ACUTE
006E 0341 ; [.174F.001D.0002.0144] # LATIN SMALL LETTER N WITH ACUTE
0143      ; [.174F.001D.0008.0143] # LATIN CAPITAL LETTER N WITH ACUTE
004E 0301 ; [.174F.001D.0008.0143] # LATIN CAPITAL LETTER N WITH ACUTE
004E 0341 ; [.174F.001D.0008.0143] # LATIN CAPITAL LETTER N WITH ACUTE
0148      ; [.174F.001E.0002.0148] # LATIN SMALL LETTER N WITH CARON
006E 030C ; [.174F.001E.0002.0148] # LATIN SMALL LETTER N WITH CARON
0147      ; [.174F.001E.0008.0147] # LATIN CAPITAL LETTER N WITH CARON
004E 030C ; [.174F.001E.0008.0147] # LATIN CAPITAL LETTER N WITH CARON
01F9      ; [.174F.001F.0002.01F9] # LATIN SMALL LETTER N WITH GRAVE
006E 0300 ; [.174F.001F.0002.01F9] # LATIN SMALL LETTER N WITH GRAVE
006E 0340 ; [.174F.001F.0002.01F9] # LATIN SMALL LETTER N WITH GRAVE
01F8      ; [.174F.001F.0008.01F8] # LATIN CAPITAL LETTER N WITH GRAVE
004E 0300 ; [.174F.001F.0008.01F8] # LATIN CAPITAL LETTER N WITH GRAVE
004E 0340 ; [.174F.001F.0008.01F8] # LATIN CAPITAL LETTER N WITH GRAVE
014D      ; [.1771.001C.0002.014D] # LATIN SMALL LETTER O WITH MACRON
006F 0304 ; [.1771.001C.0002.014D] # LATIN SMALL LETTER O WITH MACRON
014C      ; [.1771.001C.0008.014C] # LATIN CAPITAL LETTER O WITH MACRON
004F 0304 ; [.1771.001C.0008.014C] # LATIN CAPITAL LETTER O WITH MACRON
00F3      ; [.1771.001D.0002.00F3] # LATIN SMALL LETTER O WITH ACUTE
006F 0301 ; [.1771.001D.0002.00F3] # LATIN SMALL LETTER O WITH ACUTE
006F 0341 ; [.1771.001D.0002.00F3] # LATIN SMALL LETTER O WITH ACUTE
00D3      ; [.1771.001D.0008.00D3] # LATIN CAPITAL LETTER O WITH ACUTE
004F 0301 ; [.1771.001D.0008.00D3] # LATIN CAPITAL LETTER O WITH ACUTE
004F 0341 ; [.1771.001D.0008.00D3] # LATIN CAPITAL LETTER O WITH ACUTE
01D2      ; [.1771.001E.0002.01D2] # LATIN SMALL LETTER O WITH CARON
006F 030C ; [.1771.001E.0002.01D2] # LATIN SMALL LETTER O WITH CARON
01D1      ; [.1771.001E.0008.01D1] # LATIN CAPITAL LETTER O WITH CARON
004F 030C ; [.1771.001E.0008.01D1] # LATIN CAPITAL LETTER O WITH CARON
00F2      ; [.1771.001F.0002.00F2] # LATIN SMALL LETTER O WITH GRAVE
006F 0300 ; [.1771.001F.0002.00F2] # LATIN SMALL LETTER O WITH GRAVE
006F 0340 ; [.1771.001F.0002.00F2] # LATIN SMALL LETTER O WITH GRAVE
00D2      ; [.1771.001F.0008.00D2] # LATIN CAPITAL LETTER O WITH GRAVE
004F 0300 ; [.1771.001F.0008.00D2] # LATIN CAPITAL LETTER O WITH GRAVE
004F 0340 ; [.1771.001F.0008.00D2] # LATIN CAPITAL LETTER O WITH GRAVE
016B      ; [.1836.001C.0002.016B] # LATIN SMALL LETTER U WITH MACRON
0075 0304 ; [.1836.001C.0002.016B] # LATIN SMALL LETTER U WITH MACRON
016A      ; [.1836.001C.0008.016A] # LATIN CAPITAL LETTER U WITH MACRON
0055 0304 ; [.1836.001C.0008.016A] # LATIN CAPITAL LETTER U WITH MACRON
00FA      ; [.1836.001D.0002.00FA] # LATIN SMALL LETTER U WITH ACUTE
0075 0301 ; [.1836.001D.0002.00FA] # LATIN SMALL LETTER U WITH ACUTE
0075 0341 ; [.1836.001D.0002.00FA] # LATIN SMALL LETTER U WITH ACUTE
00DA      ; [.1836.001D.0008.00DA] # LATIN CAPITAL LETTER U WITH ACUTE
0055 0301 ; [.1836.001D.0008.00DA] # LATIN CAPITAL LETTER U WITH ACUTE
0055 0341 ; [.1836.001D.0008.00DA] # LATIN CAPITAL LETTER U WITH ACUTE
01D4      ; [.1836.001E.0002.01D4] # LATIN SMALL LETTER U WITH CARON
0075 030C ; [.1836.001E.0002.01D4] # LATIN SMALL LETTER U WITH CARON
01D3      ; [.1836.001E.0008.01D3] # LATIN CAPITAL LETTER U WITH CARON
0055 030C ; [.1836.001E.0008.01D3] # LATIN CAPITAL LETTER U WITH CARON
00F9      ; [.1836.001F.0002.00F9] # LATIN SMALL LETTER U WITH GRAVE
0075 0300 ; [.1836.001F.0002.00F9] # LATIN SMALL LETTER U WITH GRAVE
0075 0340 ; [.1836.001F.0002.00F9] # LATIN SMALL LETTER U WITH GRAVE
00D9      ; [.1836.001F.0008.00D9] # LATIN CAPITAL LETTER U WITH GRAVE
0055 0300 ; [.1836.001F.0008.00D9] # LATIN CAPITAL LETTER U WITH GRAVE
0055 0340 ; [.1836.001F.0008.00D9] # LATIN CAPITAL LETTER U WITH GRAVE
01D6      ; [.1836.0021.0002.01D6] # LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
0075 0308 0304 ; [.1836.0021.0002.01D6] # LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
01D5      ; [.1836.0021.0008.01D5] # LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
0055 0308 0304 ; [.1836.0021.0008.01D5] # LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
00FC 0304 ; [.1836.0021.0002.01D6] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING MACRON>
00DC 0304 ; [.1836.0021.0008.01D5] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING MACRON>
01D8      ; [.1836.0022.0002.01D8] # LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
0075 0308 0301 ; [.1836.0022.0002.01D8] # LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
0075 0308 0341 ; [.1836.0022.0002.01D8] # LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
01D7      ; [.1836.0022.0008.01D7] # LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
0055 0308 0301 ; [.1836.0022.0008.01D7] # LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
0055 0308 0341 ; [.1836.0022.0008.01D7] # LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
00FC 0301 ; [.1836.0022.0002.01D8] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING ACUTE ACCENT>
00FC 0341 ; [.1836.0022.0002.01D8] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING ACUTE TONE MARK>
00DC 0301 ; [.1836.0022.0008.01D7] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING ACUTE ACCENT>
00DC 0341 ; [.1836.0022.0008.01D7] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING ACUTE TONE MARK>
01DA      ; [.1836.0023.0002.01DA] # LATIN SMALL LETTER U WITH DIAERESIS AND CARON
0075 0308 030C ; [.1836.0023.0002.01DA] # LATIN SMALL LETTER U WITH DIAERESIS AND CARON
01D9      ; [.1836.0023.0008.01D9] # LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
0055 0308 030C ; [.1836.0023.0008.01D9] # LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
00FC 030C ; [.1836.0023.0002.01DA] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING CARON>
00DC 030C ; [.1836.0023.0008.01D9] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING CARON>
01DC      ; [.1836.0024.0002.01DC] # LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
0075 0308 0300 ; [.1836.0024.0002.01DC] # LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
0075 0308 0340 ; [.1836.0024.0002.01DC] # LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
01DB      ; [.1836.0024.0008.01DB] # LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
0055 0308 0300 ; [.1836.0024.0008.01DB] # LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
0055 0308 0340 ; [.1836.0024.0008.01DB] # LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
00FC 0300 ; [.1836.0024.0002.01DC] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING GRAVE ACCENT>
00FC 0340 ; [.1836.0024.0002.01DC] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING GRAVE TONE MARK>
00DC 0300 ; [.1836.0024.0008.01DB] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING GRAVE ACCENT>
00DC 0340 ; [.1836.0024.0008.01DB] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING GRAVE TONE MARK>
00FC      ; [.1836.0025.0002.00FC] # LATIN SMALL LETTER U WITH DIAERESIS
0075 0308 ; [.1836.0025.0002.00FC] # LATIN SMALL LETTER U WITH DIAERESIS
00DC      ; [.1836.0025.0008.00DC] # LATIN CAPITAL LETTER U WITH DIAERESIS
0055 0308 ; [.1836.0025.0008.00DC] # LATIN CAPITAL LETTER U WITH DIAERESIS
FDD0 3105 ; [.8000.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER B>
2E8A      ; [.80B5.0020.0002.2E8A] # CJK RADICAL DIVINATION
FDD0 3106 ; [.83B1.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER P>
FDD0 3107 ; [.8626.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER M>
FDD0 3108 ; [.897F.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER F>
2ECF      ; [.8BC0.0020.0002.2ECF] # CJK RADICAL CITY
2ED6      ; [.8BC1.0020.0002.2ED6] # CJK RADICAL MOUND TWO
FDD0 3109 ; [.8C0D.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER D>
2E88      ; [.8C86.0020.0002.2E88] # CJK RADICAL KNIFE ONE
FDD0 310A ; [.901F.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER T>
FDD0 310B ; [.93D9.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER N>
2EA7      ; [.9525.0020.0002.2EA7] # CJK RADICAL COW
FDD0 310C ; [.95D9.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER L>
3007      ; [.9A41.0020.0002.3007] # IDEOGRAPHIC NUMBER ZERO
FDD0 310D ; [.9C5F.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER G>
2EE3      ; [.9E0A.0020.0002.2EE3] # CJK RADICAL BONE
FDD0 310E ; [.9FD2.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER K>
FDD0 310F ; [.A223.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER H>
FDD0 3110 ; [.A697.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER J>
2E95      ; [.A762.0020.0002.2E95] # CJK RADICAL SNOUT TWO
2E86      ; [.AD18.0020.0002.2E86] # CJK RADICAL BOX
FDD0 3111 ; [.AD38.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER Q>
FDD0 3112 ; [.B164.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER X>
2E8C      ; [.B383.0020.0002.2E8C] # CJK RADICAL SMALL ONE
2E8D      ; [.B384.0020.0002.2E8D] # CJK RADICAL SMALL TWO
FDD0 3113 ; [.B6E9.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER ZH>
2EA5      ; [.B8AC.0020.0002.2EA5] # CJK RADICAL PAW TWO
FDD0 3114 ; [.BBAC.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER CH>
2ECC      ; [.BE9D.0020.0002.2ECC] # CJK RADICAL SIMPLIFIED WALK
2ECD      ; [.BE9E.0020.0002.2ECD] # CJK RADICAL WALK ONE
FDD0 3115 ; [.BF5A.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER SH>
2EAC      ; [.BFBC.0020.0002.2EAC] # CJK RADICAL SPIRIT ONE
2EAE      ; [.BFC1.0020.0002.2EAE] # CJK RADICAL BAMBOO
FDD0 3116 ; [.C2A2.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER R>
2E9C      ; [.C2A3.0020.0002.2E9C] # CJK RADICAL SUN
2EBC      ; [.C2D3.0020.0002.2EBC] # CJK RADICAL MEAT
2EB6      ; [.C311.0020.0002.2EB6] # CJK RADICAL SHEEP
FDD0 3117 ; [.C402.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER Z>
FDD0 3118 ; [.C630.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER C>
2EBE      ; [.C6CA.0020.0002.2EBE] # CJK RADICAL GRASS ONE
FDD0 3119 ; [.C7F6.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER S>
FDD0 311A ; [.CA13.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER A>
FDD0 311B ; [.CA19.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER O>
FDD0 311C ; [.CA1E.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER E>
FDD0 311E ; [.CAA0.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER AI>
FDD0 311F ; [.CAE8.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER EI>
FDD0 3120 ; [.CAEB.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER AU>
FDD0 3121 ; [.CB2E.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER OU>
FDD0 3122 ; [.CB51.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER AN>
FDD0 3123 ; [.CB8B.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER EN>
FDD0 3124 ; [.CB94.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER ANG>
FDD0 3125 ; [.CBA0.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER ENG>
FDD0 3126 ; [.CBA2.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER ER>
FDD0 3127 ; [.CBDB.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER I>
2E84      ; [.CDB5.0020.0002.2E84] # CJK RADICAL SECOND THREE
2E80      ; [.CEDF.0020.0002.2E80] # CJK RADICAL REPEAT
FDD0 3128 ; [.D16F.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER U>
FDD0 3129 ; [.D403.0020.0002.FDD0] # <noncharacter-FDD0, BOPOMOFO LETTER IU>
2ED7      ; [.D47E.0020.0002.2ED7] # CJK RADICAL RAIN
2E9D      ; [.D53B.0020.0002.2E9D] # CJK RADICAL MOON
3220      ; [*02FB.0020.0004.3220][.CBDC.0020.0004.3220][*02FC.0020.001F.3220] # PARENTHESIZED IDEOGRAPH ONE
3226      ; [*02FB.0020.0004.3226][.AD39.0020.0004.3226][*02FC.0020.001F.3226] # PARENTHESIZED IDEOGRAPH SEVEN
3222      ; [*02FB.0020.0004.3222][.C8DF.0020.0004.3222][*02FC.0020.001F.3222] # PARENTHESIZED IDEOGRAPH THREE
3228      ; [*02FB.0020.0004.3228][.A95D.0020.0004.3228][*02FC.0020.001F.3228] # PARENTHESIZED IDEOGRAPH NINE
3221      ; [*02FB.0020.0004.3221][.CBCD.0020.0004.3221][*02FC.0020.001F.3221] # PARENTHESIZED IDEOGRAPH TWO
3224      ; [*02FB.0020.0004.3224][.D1A9.0020.0004.3224][*02FC.0020.001F.3224] # PARENTHESIZED IDEOGRAPH FIVE
3239      ; [*02FB.0020.0004.3239][.8C57.0020.0004.3239][*02FC.0020.001F.3239] # PARENTHESIZED IDEOGRAPH REPRESENT
323D      ; [*02FB.0020.0004.323D][.ADC1.0020.0004.323D][*02FC.0020.001F.323D] # PARENTHESIZED IDEOGRAPH ENTERPRISE
3241      ; [*02FB.0020.0004.3241][.B3A8.0020.0004.3241][*02FC.0020.001F.3241] # PARENTHESIZED IDEOGRAPH REST
3227      ; [*02FB.0020.0004.3227][.8001.0020.0004.3227][*02FC.0020.001F.3227] # PARENTHESIZED IDEOGRAPH EIGHT
3225      ; [*02FB.0020.0004.3225][.9953.0020.0004.3225][*02FC.0020.001F.3225] # PARENTHESIZED IDEOGRAPH SIX
3238      ; [*02FB.0020.0004.3238][.969E.0020.0004.3238][*02FC.0020.001F.3238] # PARENTHESIZED IDEOGRAPH LABOR
3229      ; [*02FB.0020.0004.3229][.BF85.0020.0004.3229][*02FC.0020.001F.3229] # PARENTHESIZED IDEOGRAPH TEN
323F      ; [*02FB.0020.0004.323F][.B2BC.0020.0004.323F][*02FC.0020.001F.323F] # PARENTHESIZED IDEOGRAPH ALLIANCE
3234      ; [*02FB.0020.0004.3234][.892A.0020.0004.3234][*02FC.0020.001F.3234] # PARENTHESIZED IDEOGRAPH NAME
323A      ; [*02FB.0020.0004.323A][.A3B5.0020.0004.323A][*02FC.0020.001F.323A] # PARENTHESIZED IDEOGRAPH CALL
3223      ; [*02FB.0020.0004.3223][.C82E.0020.0004.3223][*02FC.0020.001F.3223] # PARENTHESIZED IDEOGRAPH FOUR
322F      ; [*02FB.0020.0004.322F][.92EA.0020.0004.322F][*02FC.0020.001F.322F] # PARENTHESIZED IDEOGRAPH EARTH
323B      ; [*02FB.0020.0004.323B][.B5F0.0020.0004.323B][*02FC.0020.001F.323B] # PARENTHESIZED IDEOGRAPH STUDY
3230      ; [*02FB.0020.0004.3230][.C2A4.0020.0004.3230][*02FC.0020.001F.3230] # PARENTHESIZED IDEOGRAPH SUN
322A      ; [*02FB.0020.0004.322A][.D53C.0020.0004.322A][*02FC.0020.001F.322A] # PARENTHESIZED IDEOGRAPH MOON
3232      ; [*02FB.0020.0004.3232][.CEC7.0020.0004.3232][*02FC.0020.001F.3232] # PARENTHESIZED IDEOGRAPH HAVE
322D      ; [*02FB.0020.0004.322D][.895F.0020.0004.322D][*02FC.0020.001F.322D] # PARENTHESIZED IDEOGRAPH WOOD
3231      ; [*02FB.0020.0004.3231][.BA36.0020.0004.3231][*02FC.0020.001F.3231] # PARENTHESIZED IDEOGRAPH STOCK
322C      ; [*02FB.0020.0004.322C][.C26E.0020.0004.322C][*02FC.0020.001F.322C] # PARENTHESIZED IDEOGRAPH WATER
322B      ; [*02FB.0020.0004.322B][.A48C.0020.0004.322B][*02FC.0020.001F.322B] # PARENTHESIZED IDEOGRAPH FIRE
3235      ; [*02FB.0020.0004.3235][.9060.0020.0004.3235][*02FC.0020.001F.3235] # PARENTHESIZED IDEOGRAPH SPECIAL
323C      ; [*02FB.0020.0004.323C][.A9B3.0020.0004.323C][*02FC.0020.001F.323C] # PARENTHESIZED IDEOGRAPH SUPERVISE
3233      ; [*02FB.0020.0004.3233][.C05E.0020.0004.3233][*02FC.0020.001F.3233] # PARENTHESIZED IDEOGRAPH SOCIETY
3237      ; [*02FB.0020.0004.3237][.BA90.0020.0004.3237][*02FC.0020.001F.3237] # PARENTHESIZED IDEOGRAPH CONGRATULATION
3240      ; [*02FB.0020.0004.3240][.A78C.0020.0004.3240][*02FC.0020.001F.3240] # PARENTHESIZED IDEOGRAPH FESTIVAL
3242      ; [*02FB.0020.0004.3242][.C457.0020.0004.3242][*02FC.0020.001F.3242] # PARENTHESIZED IDEOGRAPH SELF
3243      ; [*02FB.0020.0004.3243][.B766.0020.0004.3243][*02FC.0020.001F.3243] # PARENTHESIZED IDEOGRAPH REACH
3236      ; [*02FB.0020.0004.3236][.C69F.0020.0004.3236][*02FC.0020.001F.3236] # PARENTHESIZED IDEOGRAPH FINANCIAL
323E      ; [*02FB.0020.0004.323E][.C421.0020.0004.323E][*02FC.0020.001F.323E] # PARENTHESIZED IDEOGRAPH RESOURCE
322E      ; [*02FB.0020.0004.322E][.AA72.0020.0004.322E][*02FC.0020.001F.322E] # PARENTHESIZED IDEOGRAPH METAL
3358      ; [.15E5.0020.0004.3358][.8E99.0020.001F.3358] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ZERO
33E9      ; [.15E6.0020.0004.33E9][.15E5.0020.0004.33E9][.C2A4.0020.001F.33E9] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TEN
32C9      ; [.15E6.0020.0004.32C9][.15E5.0020.0004.32C9][.D53C.0020.001F.32C9] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR OCTOBER
3362      ; [.15E6.0020.0004.3362][.15E5.0020.0004.3362][.8E99.0020.001F.3362] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TEN
33EA      ; [.15E6.0020.0004.33EA][.15E6.0020.0004.33EA][.C2A4.0020.001F.33EA] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ELEVEN
32CA      ; [.15E6.0020.0004.32CA][.15E6.0020.0004.32CA][.D53C.0020.001F.32CA] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR NOVEMBER
3363      ; [.15E6.0020.0004.3363][.15E6.0020.0004.3363][.8E99.0020.001F.3363] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ELEVEN
33EB      ; [.15E6.0020.0004.33EB][.15E7.0020.0004.33EB][.C2A4.0020.001F.33EB] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWELVE
32CB      ; [.15E6.0020.0004.32CB][.15E7.0020.0004.32CB][.D53C.0020.001F.32CB] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DECEMBER
3364      ; [.15E6.0020.0004.3364][.15E7.0020.0004.3364][.8E99.0020.001F.3364] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWELVE
33EC      ; [.15E6.0020.0004.33EC][.15E8.0020.0004.33EC][.C2A4.0020.001F.33EC] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTEEN
3365      ; [.15E6.0020.0004.3365][.15E8.0020.0004.3365][.8E99.0020.001F.3365] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THIRTEEN
33ED      ; [.15E6.0020.0004.33ED][.15E9.0020.0004.33ED][.C2A4.0020.001F.33ED] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOURTEEN
3366      ; [.15E6.0020.0004.3366][.15E9.0020.0004.3366][.8E99.0020.001F.3366] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOURTEEN
33EE      ; [.15E6.0020.0004.33EE][.15EA.0020.0004.33EE][.C2A4.0020.001F.33EE] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIFTEEN
3367      ; [.15E6.0020.0004.3367][.15EA.0020.0004.3367][.8E99.0020.001F.3367] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIFTEEN
33EF      ; [.15E6.0020.0004.33EF][.15EB.0020.0004.33EF][.C2A4.0020.001F.33EF] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIXTEEN
3368      ; [.15E6.0020.0004.3368][.15EB.0020.0004.3368][.8E99.0020.001F.3368] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIXTEEN
33F0      ; [.15E6.0020.0004.33F0][.15EC.0020.0004.33F0][.C2A4.0020.001F.33F0] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVENTEEN
3369      ; [.15E6.0020.0004.3369][.15EC.0020.0004.3369][.8E99.0020.001F.3369] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVENTEEN
33F1      ; [.15E6.0020.0004.33F1][.15ED.0020.0004.33F1][.C2A4.0020.001F.33F1] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHTEEN
336A      ; [.15E6.0020.0004.336A][.15ED.0020.0004.336A][.8E99.0020.001F.336A] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHTEEN
33F2      ; [.15E6.0020.0004.33F2][.15EE.0020.0004.33F2][.C2A4.0020.001F.33F2] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINETEEN
336B      ; [.15E6.0020.0004.336B][.15EE.0020.0004.336B][.8E99.0020.001F.336B] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINETEEN
33E0      ; [.15E6.0020.0004.33E0][.C2A4.0020.001F.33E0] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ONE
32C0      ; [.15E6.0020.0004.32C0][.D53C.0020.001F.32C0] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR JANUARY
3359      ; [.15E6.0020.0004.3359][.8E99.0020.001F.3359] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ONE
33F3      ; [.15E7.0020.0004.33F3][.15E5.0020.0004.33F3][.C2A4.0020.001F.33F3] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY
336C      ; [.15E7.0020.0004.336C][.15E5.0020.0004.336C][.8E99.0020.001F.336C] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY
33F4      ; [.15E7.0020.0004.33F4][.15E6.0020.0004.33F4][.C2A4.0020.001F.33F4] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-ONE
336D      ; [.15E7.0020.0004.336D][.15E6.0020.0004.336D][.8E99.0020.001F.336D] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-ONE
33F5      ; [.15E7.0020.0004.33F5][.15E7.0020.0004.33F5][.C2A4.0020.001F.33F5] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-TWO
336E      ; [.15E7.0020.0004.336E][.15E7.0020.0004.336E][.8E99.0020.001F.336E] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-TWO
33F6      ; [.15E7.0020.0004.33F6][.15E8.0020.0004.33F6][.C2A4.0020.001F.33F6] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-THREE
336F      ; [.15E7.0020.0004.336F][.15E8.0020.0004.336F][.8E99.0020.001F.336F] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-THREE
33F7      ; [.15E7.0020.0004.33F7][.15E9.0020.0004.33F7][.C2A4.0020.001F.33F7] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FOUR
3370      ; [.15E7.0020.0004.3370][.15E9.0020.0004.3370][.8E99.0020.001F.3370] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-FOUR
33F8      ; [.15E7.0020.0004.33F8][.15EA.0020.0004.33F8][.C2A4.0020.001F.33F8] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FIVE
33F9      ; [.15E7.0020.0004.33F9][.15EB.0020.0004.33F9][.C2A4.0020.001F.33F9] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SIX
33FA      ; [.15E7.0020.0004.33FA][.15EC.0020.0004.33FA][.C2A4.0020.001F.33FA] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SEVEN
33FB      ; [.15E7.0020.0004.33FB][.15ED.0020.0004.33FB][.C2A4.0020.001F.33FB] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-EIGHT
33FC      ; [.15E7.0020.0004.33FC][.15EE.0020.0004.33FC][.C2A4.0020.001F.33FC] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-NINE
33E1      ; [.15E7.0020.0004.33E1][.C2A4.0020.001F.33E1] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWO
32C1      ; [.15E7.0020.0004.32C1][.D53C.0020.001F.32C1] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR FEBRUARY
335A      ; [.15E7.0020.0004.335A][.8E99.0020.001F.335A] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWO
33FD      ; [.15E8.0020.0004.33FD][.15E5.0020.0004.33FD][.C2A4.0020.001F.33FD] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY
33FE      ; [.15E8.0020.0004.33FE][.15E6.0020.0004.33FE][.C2A4.0020.001F.33FE] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY-ONE
33E2      ; [.15E8.0020.0004.33E2][.C2A4.0020.001F.33E2] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THREE
32C2      ; [.15E8.0020.0004.32C2][.D53C.0020.001F.32C2] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR MARCH
335B      ; [.15E8.0020.0004.335B][.8E99.0020.001F.335B] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THREE
33E3      ; [.15E9.0020.0004.33E3][.C2A4.0020.001F.33E3] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOUR
32C3      ; [.15E9.0020.0004.32C3][.D53C.0020.001F.32C3] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR APRIL
335C      ; [.15E9.0020.0004.335C][.8E99.0020.001F.335C] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOUR
33E4      ; [.15EA.0020.0004.33E4][.C2A4.0020.001F.33E4] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIVE
32C4      ; [.15EA.0020.0004.32C4][.D53C.0020.001F.32C4] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR MAY
335D      ; [.15EA.0020.0004.335D][.8E99.0020.001F.335D] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIVE
33E5      ; [.15EB.0020.0004.33E5][.C2A4.0020.001F.33E5] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIX
32C5      ; [.15EB.0020.0004.32C5][.D53C.0020.001F.32C5] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR JUNE
335E      ; [.15EB.0020.0004.335E][.8E99.0020.001F.335E] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIX
33E6      ; [.15EC.0020.0004.33E6][.C2A4.0020.001F.33E6] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVEN
32C6      ; [.15EC.0020.0004.32C6][.D53C.0020.001F.32C6] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR JULY
335F      ; [.15EC.0020.0004.335F][.8E99.0020.001F.335F] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVEN
33E7      ; [.15ED.0020.0004.33E7][.C2A4.0020.001F.33E7] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHT
32C7      ; [.15ED.0020.0004.32C7][.D53C.0020.001F.32C7] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR AUGUST
3360      ; [.15ED.0020.0004.3360][.8E99.0020.001F.3360] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHT
33E8      ; [.15EE.0020.0004.33E8][.C2A4.0020.001F.33E8] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINE
32C8      ; [.15EE.0020.0004.32C8][.D53C.0020.001F.32C8] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR SEPTEMBER
3361      ; [.15EE.0020.0004.3361][.8E99.0020.001F.3361] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINE
1F241     ; [*0359.0020.0004.1F241][.C8DF.0020.0004.1F241][*035A.0020.001F.1F241] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-4E09
1F242     ; [*0359.0020.0004.1F242][.CBCD.0020.0004.1F242][*035A.0020.001F.1F242] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-4E8C
1F247     ; [*0359.0020.0004.1F247][.C1CC.0020.0004.1F247][*035A.0020.001F.1F247] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-52DD
1F243     ; [*0359.0020.0004.1F243][.CB52.0020.0004.1F243][*035A.0020.001F.1F243] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-5B89
1F245     ; [*0359.0020.0004.1F245][.8C38.0020.0004.1F245][*035A.0020.001F.1F245] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-6253
1F248     ; [*0359.0020.0004.1F248][.80CD.0020.0004.1F248][*035A.0020.001F.1F248] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-6557
1F240     ; [*0359.0020.0004.1F240][.819A.0020.0004.1F240][*035A.0020.001F.1F240] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-672C
1F244     ; [*0359.0020.0004.1F244][.8E99.0020.0004.1F244][*035A.0020.001F.1F244] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-70B9
1F246     ; [*0359.0020.0004.1F246][.8CA9.0020.0004.1F246][*035A.0020.001F.1F246] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-76D7
2F00      ; [.CBDC.0020.0004.2F00] # KANGXI RADICAL ONE
3192      ; [.CBDC.0020.0014.3192] # IDEOGRAPHIC ANNOTATION ONE MARK
3280      ; [.CBDC.0020.0006.3280] # CIRCLED IDEOGRAPH ONE
1F229     ; [.CBDC.0020.001C.1F229] # SQUARED CJK UNIFIED IDEOGRAPH-4E00
319C      ; [.8EC1.0020.0014.319C] # IDEOGRAPHIC ANNOTATION FOURTH MARK
3286      ; [.AD39.0020.0006.3286] # CIRCLED IDEOGRAPH SEVEN
3194      ; [.C8DF.0020.0014.3194] # IDEOGRAPHIC ANNOTATION THREE MARK
3282      ; [.C8DF.0020.0006.3282] # CIRCLED IDEOGRAPH THREE
1F22A     ; [.C8DF.0020.001C.1F22A] # SQUARED CJK UNIFIED IDEOGRAPH-4E09
3196      ; [.C19C.0020.0014.3196] # IDEOGRAPHIC ANNOTATION TOP MARK
32A4      ; [.C19C.0020.0006.32A4] # CIRCLED IDEOGRAPH HIGH
3198      ; [.B2A0.0020.0014.3198] # IDEOGRAPHIC ANNOTATION BOTTOM MARK
32A6      ; [.B2A0.0020.0006.32A6] # CIRCLED IDEOGRAPH LOW
319B      ; [.8355.0020.0014.319B] # IDEOGRAPHIC ANNOTATION THIRD MARK
2F01      ; [.9F64.0020.0004.2F01] # KANGXI RADICAL LINE
3197      ; [.BB6D.0020.0014.3197] # IDEOGRAPHIC ANNOTATION MIDDLE MARK
32A5      ; [.BB6D.0020.0006.32A5] # CIRCLED IDEOGRAPH CENTRE
1F22D     ; [.BB6D.0020.001C.1F22D] # SQUARED CJK UNIFIED IDEOGRAPH-4E2D
2F02      ; [.BA6A.0020.0004.2F02] # KANGXI RADICAL DOT
2F03      ; [.8558.0020.0004.2F03] # KANGXI RADICAL SLASH
2F04      ; [.CC59.0020.0004.2F04] # KANGXI RADICAL SECOND
319A      ; [.CC59.0020.0014.319A] # IDEOGRAPHIC ANNOTATION SECOND MARK
3288      ; [.A95D.0020.0006.3288] # CIRCLED IDEOGRAPH NINE
2F05      ; [.AC3C.0020.0004.2F05] # KANGXI RADICAL HOOK
2F06      ; [.CBCD.0020.0004.2F06] # KANGXI RADICAL TWO
3193      ; [.CBCD.0020.0014.3193] # IDEOGRAPHIC ANNOTATION TWO MARK
3281      ; [.CBCD.0020.0006.3281] # CIRCLED IDEOGRAPH TWO
1F214     ; [.CBCD.0020.001C.1F214] # SQUARED CJK UNIFIED IDEOGRAPH-4E8C
3284      ; [.D1A9.0020.0006.3284] # CIRCLED IDEOGRAPH FIVE
2F07      ; [.90D4.0020.0004.2F07] # KANGXI RADICAL LID
1F218     ; [.A8BE.0020.001C.1F218] # SQUARED CJK UNIFIED IDEOGRAPH-4EA4
2F08      ; [.C2EF.0020.0004.2F08] # KANGXI RADICAL MAN
319F      ; [.C2EF.0020.0014.319F] # IDEOGRAPHIC ANNOTATION MAN MARK
32AD      ; [.ADC1.0020.0006.32AD] # CIRCLED IDEOGRAPH ENTERPRISE
32A1      ; [.B3A8.0020.0006.32A1] # CIRCLED IDEOGRAPH REST
329D      ; [.CE97.0020.0006.329D] # CIRCLED IDEOGRAPH EXCELLENT
2F09      ; [.CBA3.0020.0004.2F09] # KANGXI RADICAL LEGS
2F0A      ; [.C376.0020.0004.2F0A] # KANGXI RADICAL ENTER
2F0B      ; [.8001.0020.0004.2F0B] # KANGXI RADICAL EIGHT
3287      ; [.8001.0020.0006.3287] # CIRCLED IDEOGRAPH EIGHT
3285      ; [.9953.0020.0006.3285] # CIRCLED IDEOGRAPH SIX
2F0C      ; [.AD19.0020.0004.2F0C] # KANGXI RADICAL DOWN BOX
1F21E     ; [.C4C2.0020.001C.1F21E] # SQUARED CJK UNIFIED IDEOGRAPH-518D
2F0D      ; [.8867.0020.0004.2F0D] # KANGXI RADICAL COVER
32A2      ; [.B2E9.0020.0006.32A2] # CIRCLED IDEOGRAPH COPY
2F0E      ; [.834E.0020.0004.2F0E] # KANGXI RADICAL ICE
2F0F      ; [.A74C.0020.0004.2F0F] # KANGXI RADICAL TABLE
2F10      ; [.AF59.0020.0004.2F10] # KANGXI RADICAL OPEN BOX
2F11      ; [.8C87.0020.0004.2F11] # KANGXI RADICAL KNIFE
1F220     ; [.BE3B.0020.001C.1F220] # SQUARED CJK UNIFIED IDEOGRAPH-521D
1F21C     ; [.AF3B.0020.001C.1F21C] # SQUARED CJK UNIFIED IDEOGRAPH-524D
1F239     ; [.9C7B.0020.001C.1F239] # SQUARED CJK UNIFIED IDEOGRAPH-5272
2F12      ; [.9804.0020.0004.2F12] # KANGXI RADICAL POWER
3298      ; [.969E.0020.0006.3298] # CIRCLED IDEOGRAPH LABOR
2F13      ; [.811A.0020.0004.2F13] # KANGXI RADICAL WRAP
2F14      ; [.81FC.0020.0004.2F14] # KANGXI RADICAL SPOON
2F15      ; [.8A9F.0020.0004.2F15] # KANGXI RADICAL RIGHT OPEN BOX
2F16      ; [.B224.0020.0004.2F16] # KANGXI RADICAL HIDING ENCLOSURE
32A9      ; [.CBE1.0020.0006.32A9] # CIRCLED IDEOGRAPH MEDICINE
2F17      ; [.BF85.0020.0004.2F17] # KANGXI RADICAL TEN
3038      ; [.BF85.0020.0004.3038] # HANGZHOU NUMERAL TEN
3289      ; [.BF85.0020.0006.3289] # CIRCLED IDEOGRAPH TEN
3039      ; [.954F.0020.0004.3039] # HANGZHOU NUMERAL TWENTY
303A      ; [.C861.0020.0004.303A] # HANGZHOU NUMERAL THIRTY
32AF      ; [.B2BC.0020.0006.32AF] # CIRCLED IDEOGRAPH ALLIANCE
2F18      ; [.80B6.0020.0004.2F18] # KANGXI RADICAL DIVINATION
2F19      ; [.A84F.0020.0004.2F19] # KANGXI RADICAL SEAL
329E      ; [.D06B.0020.0006.329E] # CIRCLED IDEOGRAPH PRINT
2F1A      ; [.BDC0.0020.0004.2F1A] # KANGXI RADICAL CLIFF
2F1B      ; [.C7F7.0020.0004.2F1B] # KANGXI RADICAL PRIVATE
2F1C      ; [.CEE0.0020.0004.2F1C] # KANGXI RADICAL AGAIN
1F212     ; [.C28A.0020.001C.1F212] # SQUARED CJK UNIFIED IDEOGRAPH-53CC
2F1D      ; [.A070.0020.0004.2F1D] # KANGXI RADICAL MOUTH
1F251     ; [.A007.0020.0006.1F251] # CIRCLED IDEOGRAPH ACCEPT
32A8      ; [.CEE1.0020.0006.32A8] # CIRCLED IDEOGRAPH RIGHT
1F22E     ; [.CEE1.0020.001C.1F22E] # SQUARED CJK UNIFIED IDEOGRAPH-53F3
1F234     ; [.A232.0020.001C.1F234] # SQUARED CJK UNIFIED IDEOGRAPH-5408
3294      ; [.892A.0020.0006.3294] # CIRCLED IDEOGRAPH NAME
1F225     ; [.BEBE.0020.001C.1F225] # SQUARED CJK UNIFIED IDEOGRAPH-5439
3244      ; [.D3B7.0020.0006.3244] # CIRCLED IDEOGRAPH QUESTION
1F23A     ; [.D120.0020.001C.1F23A] # SQUARED CJK UNIFIED IDEOGRAPH-55B6
2F1E      ; [.D27D.0020.0004.2F1E] # KANGXI RADICAL ENCLOSURE
3195      ; [.C82E.0020.0014.3195] # IDEOGRAPHIC ANNOTATION FOUR MARK
3283      ; [.C82E.0020.0006.3283] # CIRCLED IDEOGRAPH FOUR
2F1F      ; [.92EA.0020.0004.2F1F] # KANGXI RADICAL EARTH
328F      ; [.92EA.0020.0006.328F] # CIRCLED IDEOGRAPH EARTH
319E      ; [.8C4B.0020.0014.319E] # IDEOGRAPHIC ANNOTATION EARTH MARK
2F20      ; [.BFB5.0020.0004.2F20] # KANGXI RADICAL SCHOLAR
1F224     ; [.C1A8.0020.001C.1F224] # SQUARED CJK UNIFIED IDEOGRAPH-58F0
2F21      ; [.B740.0020.0004.2F21] # KANGXI RADICAL GO
2F22      ; [.C986.0020.0004.2F22] # KANGXI RADICAL GO SLOWLY
2F23      ; [.B165.0020.0004.2F23] # KANGXI RADICAL EVENING
1F215     ; [.8F35.0020.001C.1F215] # SQUARED CJK UNIFIED IDEOGRAPH-591A
32B0      ; [.CDD7.0020.0006.32B0] # CIRCLED IDEOGRAPH NIGHT
2F24      ; [.8C39.0020.0004.2F24] # KANGXI RADICAL BIG
337D      ; [.8C39.0020.001C.337D][.BA1E.0020.001C.337D] # SQUARE ERA NAME TAISYOU
319D      ; [.923B.0020.0014.319D] # IDEOGRAPHIC ANNOTATION HEAVEN MARK
1F217     ; [.923B.0020.001C.1F217] # SQUARED CJK UNIFIED IDEOGRAPH-5929
2F25      ; [.95CC.0020.0004.2F25] # KANGXI RADICAL WOMAN
329B      ; [.95CC.0020.0006.329B] # CIRCLED IDEOGRAPH FEMALE
2F26      ; [.C466.0020.0004.2F26] # KANGXI RADICAL CHILD
1F211     ; [.C456.0020.001C.1F211] # SQUARED CJK UNIFIED IDEOGRAPH-5B57
32AB      ; [.B5F0.0020.0006.32AB] # CIRCLED IDEOGRAPH STUDY
2F27      ; [.88BF.0020.0004.2F27] # KANGXI RADICAL ROOF
32AA      ; [.C5ED.0020.0006.32AA] # CIRCLED IDEOGRAPH RELIGION
2F28      ; [.C7B4.0020.0004.2F28] # KANGXI RADICAL INCH
2F29      ; [.B385.0020.0004.2F29] # KANGXI RADICAL SMALL
2F2A      ; [.CE9E.0020.0004.2F2A] # KANGXI RADICAL LAME
2F2B      ; [.BF5B.0020.0004.2F2B] # KANGXI RADICAL CORPSE
2F2C      ; [.BC63.0020.0004.2F2C] # KANGXI RADICAL SPROUT
2F2D      ; [.C0C5.0020.0004.2F2D] # KANGXI RADICAL MOUNTAIN
2F2E      ; [.BED1.0020.0004.2F2E] # KANGXI RADICAL RIVER
2F2F      ; [.9F9E.0020.0004.2F2F] # KANGXI RADICAL WORK
32A7      ; [.C593.0020.0006.32A7] # CIRCLED IDEOGRAPH LEFT
1F22C     ; [.C593.0020.001C.1F22C] # SQUARED CJK UNIFIED IDEOGRAPH-5DE6
2F30      ; [.A74D.0020.0004.2F30] # KANGXI RADICAL ONESELF
2F31      ; [.AA6D.0020.0004.2F31] # KANGXI RADICAL TURBAN
2F32      ; [.9D7F.0020.0004.2F32] # KANGXI RADICAL DRY
337B      ; [.85BF.0020.001C.337B][.BDFC.0020.001C.337B] # SQUARE ERA NAME HEISEI
2F33      ; [.CE11.0020.0004.2F33] # KANGXI RADICAL SHORT THREAD
3245      ; [.CEE2.0020.0006.3245] # CIRCLED IDEOGRAPH KINDERGARTEN
2F34      ; [.9F8F.0020.0004.2F34] # KANGXI RADICAL DOTTED CLIFF
2F35      ; [.D04E.0020.0004.2F35] # KANGXI RADICAL LONG STRIDE
2F36      ; [.9FBB.0020.0004.2F36] # KANGXI RADICAL TWO HANDS
2F37      ; [.CC86.0020.0004.2F37] # KANGXI RADICAL SHOOT
2F38      ; [.9F9F.0020.0004.2F38] # KANGXI RADICAL BOW
2F39      ; [.A763.0020.0004.2F39] # KANGXI RADICAL SNOUT
2F3A      ; [.C0C6.0020.0004.2F3A] # KANGXI RADICAL BRISTLE
2F3B      ; [.BBF9.0020.0004.2F3B] # KANGXI RADICAL STEP
1F21D     ; [.A30D.0020.001C.1F21D] # SQUARED CJK UNIFIED IDEOGRAPH-5F8C
1F250     ; [.8C4D.0020.0006.1F250] # CIRCLED IDEOGRAPH ADVANTAGE
2F3C      ; [.B4AB.0020.0004.2F3C] # KANGXI RADICAL HEART
2F3D      ; [.9C6C.0020.0004.2F3D] # KANGXI RADICAL HALBERD
2F3E      ; [.A40C.0020.0004.2F3E] # KANGXI RADICAL DOOR
2F3F      ; [.C0AE.0020.0004.2F3F] # KANGXI RADICAL HAND
1F210     ; [.C0AE.0020.001C.1F210] # SQUARED CJK UNIFIED IDEOGRAPH-624B
1F231     ; [.8C38.0020.001C.1F231] # SQUARED CJK UNIFIED IDEOGRAPH-6253
1F227     ; [.90D6.0020.001C.1F227] # SQUARED CJK UNIFIED IDEOGRAPH-6295
1F22F     ; [.B753.0020.001C.1F22F] # SQUARED CJK UNIFIED IDEOGRAPH-6307
1F228     ; [.838E.0020.001C.1F228] # SQUARED CJK UNIFIED IDEOGRAPH-6355
2F40      ; [.B6EB.0020.0004.2F40] # KANGXI RADICAL BRANCH
2F41      ; [.85EC.0020.0004.2F41] # KANGXI RADICAL RAP
2F42      ; [.D38D.0020.0004.2F42] # KANGXI RADICAL SCRIPT
3246      ; [.D38D.0020.0006.3246] # CIRCLED IDEOGRAPH SCHOOL
2F43      ; [.8CCF.0020.0004.2F43] # KANGXI RADICAL DIPPER
1F21B     ; [.9905.0020.001C.1F21B] # SQUARED CJK UNIFIED IDEOGRAPH-6599
2F44      ; [.AA6F.0020.0004.2F44] # KANGXI RADICAL AXE
1F21F     ; [.B4BC.0020.001C.1F21F] # SQUARED CJK UNIFIED IDEOGRAPH-65B0
2F45      ; [.8AA0.0020.0004.2F45] # KANGXI RADICAL SQUARE
2F46      ; [.D18A.0020.0004.2F46] # KANGXI RADICAL NOT
2F47      ; [.C2A4.0020.0004.2F47] # KANGXI RADICAL SUN
3290      ; [.C2A4.0020.0006.3290] # CIRCLED IDEOGRAPH SUN
337E      ; [.892B.0020.001C.337E][.B773.0020.001C.337E] # SQUARE ERA NAME MEIZI
1F219     ; [.D15D.0020.001C.1F219] # SQUARED CJK UNIFIED IDEOGRAPH-6620
337C      ; [.B884.0020.001C.337C][.A237.0020.001C.337C] # SQUARE ERA NAME SYOUWA
2F48      ; [.D533.0020.0004.2F48] # KANGXI RADICAL SAY
2F49      ; [.D53C.0020.0004.2F49] # KANGXI RADICAL MOON
328A      ; [.D53C.0020.0006.328A] # CIRCLED IDEOGRAPH MOON
1F237     ; [.D53C.0020.001C.1F237] # SQUARED CJK UNIFIED IDEOGRAPH-6708
3292      ; [.CEC7.0020.0006.3292] # CIRCLED IDEOGRAPH HAVE
1F236     ; [.CEC7.0020.001C.1F236] # SQUARED CJK UNIFIED IDEOGRAPH-6709
2F4A      ; [.895F.0020.0004.2F4A] # KANGXI RADICAL TREE
328D      ; [.895F.0020.0006.328D] # CIRCLED IDEOGRAPH WOOD
3291      ; [.BA36.0020.0006.3291] # CIRCLED IDEOGRAPH STOCK
337F      ; [.BA36.0020.001C.337F][.BFBF.0020.001C.337F][.A51A.0020.001C.337F][.C05E.0020.001C.337F] # SQUARE CORPORATION
2F4B      ; [.AF68.0020.0004.2F4B] # KANGXI RADICAL LACK
2F4C      ; [.B741.0020.0004.2F4C] # KANGXI RADICAL STOP
32A3      ; [.BA1E.0020.0006.32A3] # CIRCLED IDEOGRAPH CORRECT
2F4D      ; [.8C53.0020.0004.2F4D] # KANGXI RADICAL DEATH
2F4E      ; [.C1D9.0020.0004.2F4E] # KANGXI RADICAL WEAPON
2F4F      ; [.D18B.0020.0004.2F4F] # KANGXI RADICAL DO NOT
2E9F      ; [.894D.0020.0004.2E9F] # CJK RADICAL MOTHER
2F50      ; [.81FD.0020.0004.2F50] # KANGXI RADICAL COMPARE
2F51      ; [.8727.0020.0004.2F51] # KANGXI RADICAL FUR
2F52      ; [.BFB6.0020.0004.2F52] # KANGXI RADICAL CLAN
2F53      ; [.ADDA.0020.0004.2F53] # KANGXI RADICAL STEAM
2F54      ; [.C26E.0020.0004.2F54] # KANGXI RADICAL WATER
328C      ; [.C26E.0020.0006.328C] # CIRCLED IDEOGRAPH WATER
329F      ; [.BA84.0020.0006.329F] # CIRCLED IDEOGRAPH ATTENTION
1F235     ; [.8793.0020.001C.1F235] # SQUARED CJK UNIFIED IDEOGRAPH-6E80
1F226     ; [.CF75.0020.001C.1F226] # SQUARED CJK UNIFIED IDEOGRAPH-6F14
2F55      ; [.A48C.0020.0004.2F55] # KANGXI RADICAL FIRE
328B      ; [.A48C.0020.0006.328B] # CIRCLED IDEOGRAPH FIRE
1F21A     ; [.D19A.0020.001C.1F21A] # SQUARED CJK UNIFIED IDEOGRAPH-7121
2F56      ; [.B88D.0020.0004.2F56] # KANGXI RADICAL CLAW
2F57      ; [.8BC3.0020.0004.2F57] # KANGXI RADICAL FATHER
2F58      ; [.CE21.0020.0004.2F58] # KANGXI RADICAL DOUBLE X
2F59      ; [.8453.0020.0004.2F59] # KANGXI RADICAL HALF TREE TRUNK
2F5A      ; [.8593.0020.0004.2F5A] # KANGXI RADICAL SLICE
2F5B      ; [.CD78.0020.0004.2F5B] # KANGXI RADICAL FANG
2F5C      ; [.9526.0020.0004.2F5C] # KANGXI RADICAL COW
3295      ; [.9060.0020.0006.3295] # CIRCLED IDEOGRAPH SPECIAL
2F5D      ; [.B123.0020.0004.2F5D] # KANGXI RADICAL DOG
2F5E      ; [.B63A.0020.0004.2F5E] # KANGXI RADICAL PROFOUND
2F5F      ; [.D4A7.0020.0004.2F5F] # KANGXI RADICAL JADE
2F60      ; [.9E4D.0020.0004.2F60] # KANGXI RADICAL MELON
2F61      ; [.D216.0020.0004.2F61] # KANGXI RADICAL TILE
2F62      ; [.9D4E.0020.0004.2F62] # KANGXI RADICAL SWEET
2F63      ; [.C1A6.0020.0004.2F63] # KANGXI RADICAL LIFE
1F222     ; [.C1A6.0020.001C.1F222] # SQUARED CJK UNIFIED IDEOGRAPH-751F
2F64      ; [.D68B.0020.0004.2F64] # KANGXI RADICAL USE
2F65      ; [.9245.0020.0004.2F65] # KANGXI RADICAL FIELD
3199      ; [.A814.0020.0014.3199] # IDEOGRAPHIC ANNOTATION FIRST MARK
1F238     ; [.C125.0020.001C.1F238] # SQUARED CJK UNIFIED IDEOGRAPH-7533
329A      ; [.9459.0020.0006.329A] # CIRCLED IDEOGRAPH MALE
2F66      ; [.852E.0020.0004.2F66] # KANGXI RADICAL BOLT OF CLOTH
2F67      ; [.93F9.0020.0004.2F67] # KANGXI RADICAL SICKNESS
2F68      ; [.8046.0020.0004.2F68] # KANGXI RADICAL DOTTED TENT
2F69      ; [.80BD.0020.0004.2F69] # KANGXI RADICAL WHITE
2F6A      ; [.8504.0020.0004.2F6A] # KANGXI RADICAL SKIN
2F6B      ; [.890B.0020.0004.2F6B] # KANGXI RADICAL DISH
32AC      ; [.A9B3.0020.0006.32AC] # CIRCLED IDEOGRAPH SUPERVISE
2F6C      ; [.8962.0020.0004.2F6C] # KANGXI RADICAL EYE
2F6D      ; [.8728.0020.0004.2F6D] # KANGXI RADICAL SPEAR
2F6E      ; [.BFA9.0020.0004.2F6E] # KANGXI RADICAL ARROW
2F6F      ; [.BF87.0020.0004.2F6F] # KANGXI RADICAL STONE
2F70      ; [.BFBD.0020.0004.2F70] # KANGXI RADICAL SPIRIT
3293      ; [.C05E.0020.0006.3293] # CIRCLED IDEOGRAPH SOCIETY
3297      ; [.BA90.0020.0006.3297] # CIRCLED IDEOGRAPH CONGRATULATION
1F232     ; [.AAB2.0020.001C.1F232] # SQUARED CJK UNIFIED IDEOGRAPH-7981
2F71      ; [.C2BD.0020.0004.2F71] # KANGXI RADICAL TRACK
2F72      ; [.A231.0020.0004.2F72] # KANGXI RADICAL GRAIN
3299      ; [.8871.0020.0006.3299] # CIRCLED IDEOGRAPH SECRET
2F73      ; [.B5ED.0020.0004.2F73] # KANGXI RADICAL CAVE
1F233     ; [.A211.0020.001C.1F233] # SQUARED CJK UNIFIED IDEOGRAPH-7A7A
2F74      ; [.9808.0020.0004.2F74] # KANGXI RADICAL STAND
2F75      ; [.BA53.0020.0004.2F75] # KANGXI RADICAL BAMBOO
3247      ; [.BA0D.0020.0006.3247] # CIRCLED IDEOGRAPH KOTO
2F76      ; [.8856.0020.0004.2F76] # KANGXI RADICAL RICE
2F77      ; [.8868.0020.0004.2F77] # KANGXI RADICAL SILK
1F221     ; [.BB7F.0020.001C.1F221] # SQUARED CJK UNIFIED IDEOGRAPH-7D42
2F78      ; [.89F6.0020.0004.2F78] # KANGXI RADICAL JAR
2F79      ; [.D3D1.0020.0004.2F79] # KANGXI RADICAL NET
2F7A      ; [.D08F.0020.0004.2F7A] # KANGXI RADICAL SHEEP
2F7B      ; [.D47D.0020.0004.2F7B] # KANGXI RADICAL FEATHER
2F7C      ; [.96B7.0020.0004.2F7C] # KANGXI RADICAL OLD
2F7D      ; [.CBA4.0020.0004.2F7D] # KANGXI RADICAL AND
2F7E      ; [.966B.0020.0004.2F7E] # KANGXI RADICAL PLOW
2F7F      ; [.CBBF.0020.0004.2F7F] # KANGXI RADICAL EAR
2F80      ; [.D4AA.0020.0004.2F80] # KANGXI RADICAL BRUSH
2F81      ; [.C2D4.0020.0004.2F81] # KANGXI RADICAL MEAT
2F82      ; [.BD5B.0020.0004.2F82] # KANGXI RADICAL MINISTER
2F83      ; [.C457.0020.0004.2F83] # KANGXI RADICAL SELF
2F84      ; [.B766.0020.0004.2F84] # KANGXI RADICAL ARRIVE
2F85      ; [.A96D.0020.0004.2F85] # KANGXI RADICAL MORTAR
2F86      ; [.C053.0020.0004.2F86] # KANGXI RADICAL TONGUE
2F87      ; [.BEE4.0020.0004.2F87] # KANGXI RADICAL OPPOSE
2F88      ; [.B8B0.0020.0004.2F88] # KANGXI RADICAL BOAT
2F89      ; [.9D94.0020.0004.2F89] # KANGXI RADICAL STOPPING
2F8A      ; [.C870.0020.0004.2F8A] # KANGXI RADICAL COLOR
2F8B      ; [.C6C2.0020.0004.2F8B] # KANGXI RADICAL GRASS
2F8C      ; [.A3B4.0020.0004.2F8C] # KANGXI RADICAL TIGER
2F8D      ; [.BF4A.0020.0004.2F8D] # KANGXI RADICAL INSECT
2F8E      ; [.B604.0020.0004.2F8E] # KANGXI RADICAL BLOOD
2F8F      ; [.B543.0020.0004.2F8F] # KANGXI RADICAL WALK ENCLOSURE
2F90      ; [.CBE0.0020.0004.2F90] # KANGXI RADICAL CLOTHES
2F91      ; [.CD9C.0020.0004.2F91] # KANGXI RADICAL WEST
2F92      ; [.AA1C.0020.0004.2F92] # KANGXI RADICAL SEE
2F93      ; [.A8EB.0020.0004.2F93] # KANGXI RADICAL HORN
1F216     ; [.A898.0020.001C.1F216] # SQUARED CJK UNIFIED IDEOGRAPH-89E3
2F94      ; [.CF21.0020.0004.2F94] # KANGXI RADICAL SPEECH
2F95      ; [.9E07.0020.0004.2F95] # KANGXI RADICAL VALLEY
2F96      ; [.8CD0.0020.0004.2F96] # KANGXI RADICAL BEAN
2F97      ; [.BFAB.0020.0004.2F97] # KANGXI RADICAL PIG
2F98      ; [.B76C.0020.0004.2F98] # KANGXI RADICAL BADGER
2F99      ; [.80EB.0020.0004.2F99] # KANGXI RADICAL SHELL
3296      ; [.C69F.0020.0006.3296] # CIRCLED IDEOGRAPH FINANCIAL
1F223     ; [.8A4B.0020.001C.1F223] # SQUARED CJK UNIFIED IDEOGRAPH-8CA9
32AE      ; [.C421.0020.0006.32AE] # CIRCLED IDEOGRAPH RESOURCE
2F9A      ; [.BBFE.0020.0004.2F9A] # KANGXI RADICAL RED
2F9B      ; [.C50C.0020.0004.2F9B] # KANGXI RADICAL RUN
1F230     ; [.C50C.0020.001C.1F230] # SQUARED CJK UNIFIED IDEOGRAPH-8D70
2F9C      ; [.C571.0020.0004.2F9C] # KANGXI RADICAL FOOT
2F9D      ; [.C129.0020.0004.2F9D] # KANGXI RADICAL BODY
2F9E      ; [.BC58.0020.0004.2F9E] # KANGXI RADICAL CART
2F9F      ; [.B4AE.0020.0004.2F9F] # KANGXI RADICAL BITTER
2FA0      ; [.BD5F.0020.0004.2FA0] # KANGXI RADICAL MORNING
2FA1      ; [.BEA0.0020.0004.2FA1] # KANGXI RADICAL WALK
1F22B     ; [.CEBC.0020.001C.1F22B] # SQUARED CJK UNIFIED IDEOGRAPH-904A
329C      ; [.BFFC.0020.0006.329C] # CIRCLED IDEOGRAPH SUITABLE
2FA2      ; [.CC9C.0020.0004.2FA2] # KANGXI RADICAL CITY
2FA3      ; [.CECA.0020.0004.2FA3] # KANGXI RADICAL WINE
2FA4      ; [.8308.0020.0004.2FA4] # KANGXI RADICAL DISTINGUISH
2FA5      ; [.97EB.0020.0004.2FA5] # KANGXI RADICAL VILLAGE
2FA6      ; [.AA72.0020.0004.2FA6] # KANGXI RADICAL GOLD
328E      ; [.AA72.0020.0006.328E] # CIRCLED IDEOGRAPH METAL
2FA7      ; [.B9D1.0020.0004.2FA7] # KANGXI RADICAL LONG
2FA8      ; [.87B7.0020.0004.2FA8] # KANGXI RADICAL GATE
2FA9      ; [.8BCB.0020.0004.2FA9] # KANGXI RADICAL MOUND
2FAA      ; [.9819.0020.0004.2FAA] # KANGXI RADICAL SLAVE
2FAB      ; [.BAFD.0020.0004.2FAB] # KANGXI RADICAL SHORT TAILED BIRD
2FAC      ; [.D47F.0020.0004.2FAC] # KANGXI RADICAL RAIN
2FAD      ; [.B01B.0020.0004.2FAD] # KANGXI RADICAL BLUE
2FAE      ; [.89A9.0020.0004.2FAE] # KANGXI RADICAL WRONG
2FAF      ; [.88EB.0020.0004.2FAF] # KANGXI RADICAL FACE
2FB0      ; [.9C8F.0020.0004.2FB0] # KANGXI RADICAL LEATHER
2FB1      ; [.D288.0020.0004.2FB1] # KANGXI RADICAL TANNED LEATHER
2FB2      ; [.A965.0020.0004.2FB2] # KANGXI RADICAL LEEK
2FB3      ; [.CFF8.0020.0004.2FB3] # KANGXI RADICAL SOUND
2FB4      ; [.CDDC.0020.0004.2FB4] # KANGXI RADICAL LEAF
32A0      ; [.B520.0020.0006.32A0] # CIRCLED IDEOGRAPH ITEM
2FB5      ; [.8AD5.0020.0004.2FB5] # KANGXI RADICAL WIND
2FB6      ; [.89AA.0020.0004.2FB6] # KANGXI RADICAL FLY
2FB7      ; [.BF93.0020.0004.2FB7] # KANGXI RADICAL EAT
2FB8      ; [.C0B1.0020.0004.2FB8] # KANGXI RADICAL HEAD
2FB9      ; [.B4E1.0020.0004.2FB9] # KANGXI RADICAL FRAGRANT
2FBA      ; [.8637.0020.0004.2FBA] # KANGXI RADICAL HORSE
2FBB      ; [.9E10.0020.0004.2FBB] # KANGXI RADICAL BONE
2FBC      ; [.9CEC.0020.0004.2FBC] # KANGXI RADICAL TALL
2FBD      ; [.82AD.0020.0004.2FBD] # KANGXI RADICAL HAIR
2FBE      ; [.8CD4.0020.0004.2FBE] # KANGXI RADICAL FIGHT
2FBF      ; [.BDCE.0020.0004.2FBF] # KANGXI RADICAL SACRIFICIAL WINE
2FC0      ; [.9C94.0020.0004.2FC0] # KANGXI RADICAL CAULDRON
2FC1      ; [.9EF1.0020.0004.2FC1] # KANGXI RADICAL GHOST
2FC2      ; [.D436.0020.0004.2FC2] # KANGXI RADICAL FISH
2FC3      ; [.9519.0020.0004.2FC3] # KANGXI RADICAL BIRD
2FC4      ; [.9AD5.0020.0004.2FC4] # KANGXI RADICAL SALT
2FC5      ; [.9AFD.0020.0004.2FC5] # KANGXI RADICAL DEER
2FC6      ; [.86CC.0020.0004.2FC6] # KANGXI RADICAL WHEAT
2FC7      ; [.862D.0020.0004.2FC7] # KANGXI RADICAL HEMP
2FC8      ; [.A607.0020.0004.2FC8] # KANGXI RADICAL YELLOW
2FC9      ; [.C20C.0020.0004.2FC9] # KANGXI RADICAL MILLET
2FCA      ; [.A2AD.0020.0004.2FCA] # KANGXI RADICAL BLACK
2FCB      ; [.B762.0020.0004.2FCB] # KANGXI RADICAL EMBROIDERY
2FCC      ; [.88E4.0020.0004.2FCC] # KANGXI RADICAL FROG
2FCD      ; [.8ED2.0020.0004.2FCD] # KANGXI RADICAL TRIPOD
2FCE      ; [.9E1D.0020.0004.2FCE] # KANGXI RADICAL DRUM
2FCF      ; [.C210.0020.0004.2FCF] # KANGXI RADICAL RAT
2FD0      ; [.81FB.0020.0004.2FD0] # KANGXI RADICAL NOSE
2FD1      ; [.ADA1.0020.0004.2FD1] # KANGXI RADICAL EVEN
2FD2      ; [.BBF7.0020.0004.2FD2] # KANGXI RADICAL TOOTH
2FD3      ; [.9BE4.0020.0004.2FD3] # KANGXI RADICAL DRAGON
2FD4      ; [.9ED7.0020.0004.2FD4] # KANGXI RADICAL TURTLE
2EF3      ; [.9EB8.0020.0004.2EF3] # CJK RADICAL C-SIMPLIFIED TURTLE
2FD5      ; [.D560.0020.0004.2FD5] # KANGXI RADICAL FLUTE
F967      ; [.8392.0020.0002.4E0D] # CJK COMPATIBILITY IDEOGRAPH-F967
FA70      ; [.836F.0020.0002.4E26] # CJK COMPATIBILITY IDEOGRAPH-FA70
F905      ; [.BEEB.0020.0002.4E32] # CJK COMPATIBILITY IDEOGRAPH-F905
2F801     ; [.D334.0020.0002.4E38] # CJK COMPATIBILITY IDEOGRAPH-2F801
F95E      ; [.8CEB.0020.0002.4E39] # CJK COMPATIBILITY IDEOGRAPH-F95E
2F800     ; [.980B.0020.0002.4E3D] # CJK COMPATIBILITY IDEOGRAPH-2F800
2F802     ; [.CC07.0020.0002.4E41] # CJK COMPATIBILITY IDEOGRAPH-2F802
F91B      ; [.9BA8.0020.0002.4E82] # CJK COMPATIBILITY IDEOGRAPH-F91B
F9BA      ; [.9615.0020.0002.4E86] # CJK COMPATIBILITY IDEOGRAPH-F9BA
F977      ; [.9A32.0020.0002.4EAE] # CJK COMPATIBILITY IDEOGRAPH-F977
F9FD      ; [.C151.0020.0002.4EC0] # CJK COMPATIBILITY IDEOGRAPH-F9FD
2F819     ; [.834F.0020.0002.4ECC] # CJK COMPATIBILITY IDEOGRAPH-2F819
F9A8      ; [.9A9B.0020.0002.4EE4] # CJK COMPATIBILITY IDEOGRAPH-F9A8
2F804     ; [.94AF.0020.0002.4F60] # CJK COMPATIBILITY IDEOGRAPH-2F804
FA73      ; [.B546.0020.0002.4F80] # CJK COMPATIBILITY IDEOGRAPH-FA73
F92D      ; [.9619.0020.0002.4F86] # CJK COMPATIBILITY IDEOGRAPH-F92D
F9B5      ; [.9811.0020.0002.4F8B] # CJK COMPATIBILITY IDEOGRAPH-F9B5
FA30      ; [.D1B4.0020.0002.4FAE] # CJK COMPATIBILITY IDEOGRAPH-FA30
2F805     ; [.D1B4.0020.0002.4FAE] # CJK COMPATIBILITY IDEOGRAPH-2F805
2F806     ; [.935A.0020.0002.4FBB] # CJK COMPATIBILITY IDEOGRAPH-2F806
F965      ; [.830C.0020.0002.4FBF] # CJK COMPATIBILITY IDEOGRAPH-F965
2F807     ; [.8373.0020.0002.5002] # CJK COMPATIBILITY IDEOGRAPH-2F807
F9D4      ; [.9BB2.0020.0002.502B] # CJK COMPATIBILITY IDEOGRAPH-F9D4
2F808     ; [.C477.0020.0002.507A] # CJK COMPATIBILITY IDEOGRAPH-2F808
2F809     ; [.80FF.0020.0002.5099] # CJK COMPATIBILITY IDEOGRAPH-2F809
2F80B     ; [.B522.0020.0002.50CF] # CJK COMPATIBILITY IDEOGRAPH-2F80B
F9BB      ; [.98D4.0020.0002.50DA] # CJK COMPATIBILITY IDEOGRAPH-F9BB
FA31      ; [.C90E.0020.0002.50E7] # CJK COMPATIBILITY IDEOGRAPH-FA31
2F80A     ; [.C90E.0020.0002.50E7] # CJK COMPATIBILITY IDEOGRAPH-2F80A
FA0C      ; [.D1CB.0020.0002.5140] # CJK COMPATIBILITY IDEOGRAPH-FA0C
FA74      ; [.BF37.0020.0002.5145] # CJK COMPATIBILITY IDEOGRAPH-FA74
FA32      ; [.88D2.0020.0002.514D] # CJK COMPATIBILITY IDEOGRAPH-FA32
2F80E     ; [.88D2.0020.0002.514D] # CJK COMPATIBILITY IDEOGRAPH-2F80E
2F80F     ; [.92F0.0020.0002.5154] # CJK COMPATIBILITY IDEOGRAPH-2F80F
2F810     ; [.A627.0020.0002.5164] # CJK COMPATIBILITY IDEOGRAPH-2F810
2F814     ; [.9422.0020.0002.5167] # CJK COMPATIBILITY IDEOGRAPH-2F814
FA72      ; [.B0F4.0020.0002.5168] # CJK COMPATIBILITY IDEOGRAPH-FA72
F978      ; [.9A28.0020.0002.5169] # CJK COMPATIBILITY IDEOGRAPH-F978
F9D1      ; [.9953.0020.0002.516D] # CJK COMPATIBILITY IDEOGRAPH-F9D1
2F811     ; [.ABF3.0020.0002.5177] # CJK COMPATIBILITY IDEOGRAPH-2F811
FA75      ; [.A7A9.0020.0002.5180] # CJK COMPATIBILITY IDEOGRAPH-FA75
2F815     ; [.C4C2.0020.0002.518D] # CJK COMPATIBILITY IDEOGRAPH-2F815
2F8D2     ; [.874F.0020.0002.5192] # CJK COMPATIBILITY IDEOGRAPH-2F8D2
2F8D3     ; [.88DA.0020.0002.5195] # CJK COMPATIBILITY IDEOGRAPH-2F8D3
2F817     ; [.C3F9.0020.0002.5197] # CJK COMPATIBILITY IDEOGRAPH-2F817
2F818     ; [.D571.0020.0002.51A4] # CJK COMPATIBILITY IDEOGRAPH-2F818
2F81A     ; [.8FE3.0020.0002.51AC] # CJK COMPATIBILITY IDEOGRAPH-2F81A
FA71      ; [.A1F5.0020.0002.51B5] # CJK COMPATIBILITY IDEOGRAPH-FA71
2F81B     ; [.A1F5.0020.0002.51B5] # CJK COMPATIBILITY IDEOGRAPH-2F81B
F92E      ; [.9793.0020.0002.51B7] # CJK COMPATIBILITY IDEOGRAPH-F92E
F979      ; [.9A18.0020.0002.51C9] # CJK COMPATIBILITY IDEOGRAPH-F979
F955      ; [.9A51.0020.0002.51CC] # CJK COMPATIBILITY IDEOGRAPH-F955
F954      ; [.99F8.0020.0002.51DC] # CJK COMPATIBILITY IDEOGRAPH-F954
FA15      ; [.B1BC.0020.0002.51DE] # CJK COMPATIBILITY IDEOGRAPH-FA15
2F81D     ; [.AF59.0020.0002.51F5] # CJK COMPATIBILITY IDEOGRAPH-2F81D
2F81E     ; [.C305.0020.0002.5203] # CJK COMPATIBILITY IDEOGRAPH-2F81E
FA00      ; [.AE24.0020.0002.5207] # CJK COMPATIBILITY IDEOGRAPH-FA00
2F850     ; [.AE24.0020.0002.5207] # CJK COMPATIBILITY IDEOGRAPH-2F850
F99C      ; [.98A1.0020.0002.5217] # CJK COMPATIBILITY IDEOGRAPH-F99C
F9DD      ; [.980C.0020.0002.5229] # CJK COMPATIBILITY IDEOGRAPH-F9DD
F9FF      ; [.C66A.0020.0002.523A] # CJK COMPATIBILITY IDEOGRAPH-F9FF
2F820     ; [.A014.0020.0002.523B] # CJK COMPATIBILITY IDEOGRAPH-2F820
2F821     ; [.9B64.0020.0002.5246] # CJK COMPATIBILITY IDEOGRAPH-2F821
2F822     ; [.9C7B.0020.0002.5272] # CJK COMPATIBILITY IDEOGRAPH-2F822
2F823     ; [.BD2E.0020.0002.5277] # CJK COMPATIBILITY IDEOGRAPH-2F823
F9C7      ; [.9926.0020.0002.5289] # CJK COMPATIBILITY IDEOGRAPH-F9C7
F98A      ; [.9804.0020.0002.529B] # CJK COMPATIBILITY IDEOGRAPH-F98A
F99D      ; [.98A2.0020.0002.52A3] # CJK COMPATIBILITY IDEOGRAPH-F99D
2F992     ; [.969D.0020.0002.52B3] # CJK COMPATIBILITY IDEOGRAPH-2F992
FA76      ; [.D671.0020.0002.52C7] # CJK COMPATIBILITY IDEOGRAPH-FA76
2F825     ; [.D671.0020.0002.52C7] # CJK COMPATIBILITY IDEOGRAPH-2F825
FA33      ; [.88D5.0020.0002.52C9] # CJK COMPATIBILITY IDEOGRAPH-FA33
2F826     ; [.88D5.0020.0002.52C9] # CJK COMPATIBILITY IDEOGRAPH-2F826
F952      ; [.964C.0020.0002.52D2] # CJK COMPATIBILITY IDEOGRAPH-F952
F92F      ; [.96A5.0020.0002.52DE] # CJK COMPATIBILITY IDEOGRAPH-F92F
FA34      ; [.AFAD.0020.0002.52E4] # CJK COMPATIBILITY IDEOGRAPH-FA34
2F827     ; [.AFAD.0020.0002.52E4] # CJK COMPATIBILITY IDEOGRAPH-2F827
F97F      ; [.985C.0020.0002.52F5] # CJK COMPATIBILITY IDEOGRAPH-F97F
FA77      ; [.C096.0020.0002.52FA] # CJK COMPATIBILITY IDEOGRAPH-FA77
2F828     ; [.C096.0020.0002.52FA] # CJK COMPATIBILITY IDEOGRAPH-2F828
2F829     ; [.811B.0020.0002.5305] # CJK COMPATIBILITY IDEOGRAPH-2F829
2F82A     ; [.C7B7.0020.0002.5306] # CJK COMPATIBILITY IDEOGRAPH-2F82A
F963      ; [.80E5.0020.0002.5317] # CJK COMPATIBILITY IDEOGRAPH-F963
2F82B     ; [.80E5.0020.0002.5317] # CJK COMPATIBILITY IDEOGRAPH-2F82B
F9EB      ; [.94CA.0020.0002.533F] # CJK COMPATIBILITY IDEOGRAPH-F9EB
2F82C     ; [.A518.0020.0002.5349] # CJK COMPATIBILITY IDEOGRAPH-2F82C
FA35      ; [.80D7.0020.0002.5351] # CJK COMPATIBILITY IDEOGRAPH-FA35
2F82D     ; [.80D7.0020.0002.5351] # CJK COMPATIBILITY IDEOGRAPH-2F82D
2F82E     ; [.807E.0020.0002.535A] # CJK COMPATIBILITY IDEOGRAPH-2F82E
2F82F     ; [.A6FF.0020.0002.5373] # CJK COMPATIBILITY IDEOGRAPH-2F82F
F91C      ; [.9BA5.0020.0002.5375] # CJK COMPATIBILITY IDEOGRAPH-F91C
2F830     ; [.A70A.0020.0002.537D] # CJK COMPATIBILITY IDEOGRAPH-2F830
2F831     ; [.B020.0020.0002.537F] # CJK COMPATIBILITY IDEOGRAPH-2F831
2F832     ; [.B020.0020.0002.537F] # CJK COMPATIBILITY IDEOGRAPH-2F832
2F833     ; [.B020.0020.0002.537F] # CJK COMPATIBILITY IDEOGRAPH-2F833
F96B      ; [.C6D2.0020.0002.53C3] # CJK COMPATIBILITY IDEOGRAPH-F96B
2F836     ; [.A6FB.0020.0002.53CA] # CJK COMPATIBILITY IDEOGRAPH-2F836
2F837     ; [.C8D2.0020.0002.53DF] # CJK COMPATIBILITY IDEOGRAPH-2F837
F906      ; [.ABEE.0020.0002.53E5] # CJK COMPATIBILITY IDEOGRAPH-F906
2F839     ; [.A922.0020.0002.53EB] # CJK COMPATIBILITY IDEOGRAPH-2F839
2F83A     ; [.BBFA.0020.0002.53F1] # CJK COMPATIBILITY IDEOGRAPH-2F83A
2F83B     ; [.CE13.0020.0002.5406] # CJK COMPATIBILITY IDEOGRAPH-2F83B
F9DE      ; [.9809.0020.0002.540F] # CJK COMPATIBILITY IDEOGRAPH-F9DE
F9ED      ; [.9A03.0020.0002.541D] # CJK COMPATIBILITY IDEOGRAPH-F9ED
2F83D     ; [.B16A.0020.0002.5438] # CJK COMPATIBILITY IDEOGRAPH-2F83D
F980      ; [.9C24.0020.0002.5442] # CJK COMPATIBILITY IDEOGRAPH-F980
2F83E     ; [.BDFE.0020.0002.5448] # CJK COMPATIBILITY IDEOGRAPH-2F83E
2F83F     ; [.B8B3.0020.0002.5468] # CJK COMPATIBILITY IDEOGRAPH-2F83F
2F83C     ; [.B473.0020.0002.549E] # CJK COMPATIBILITY IDEOGRAPH-2F83C
2F840     ; [.CA56.0020.0002.54A2] # CJK COMPATIBILITY IDEOGRAPH-2F840
F99E      ; [.CF9A.0020.0002.54BD] # CJK COMPATIBILITY IDEOGRAPH-F99E
2F841     ; [.8891.0020.0002.54F6] # CJK COMPATIBILITY IDEOGRAPH-2F841
2F842     ; [.9144.0020.0002.5510] # CJK COMPATIBILITY IDEOGRAPH-2F842
2F843     ; [.ADCE.0020.0002.5553] # CJK COMPATIBILITY IDEOGRAPH-2F843
FA79      ; [.90B6.0020.0002.5555] # CJK COMPATIBILITY IDEOGRAPH-FA79
2F844     ; [.B415.0020.0002.5563] # CJK COMPATIBILITY IDEOGRAPH-2F844
2F845     ; [.C100.0020.0002.5584] # CJK COMPATIBILITY IDEOGRAPH-2F845
2F846     ; [.C100.0020.0002.5584] # CJK COMPATIBILITY IDEOGRAPH-2F846
F90B      ; [.95E6.0020.0002.5587] # CJK COMPATIBILITY IDEOGRAPH-F90B
FA7A      ; [.A52B.0020.0002.5599] # CJK COMPATIBILITY IDEOGRAPH-FA7A
2F847     ; [.A52B.0020.0002.5599] # CJK COMPATIBILITY IDEOGRAPH-2F847
FA36      ; [.A22D.0020.0002.559D] # CJK COMPATIBILITY IDEOGRAPH-FA36
FA78      ; [.A22D.0020.0002.559D] # CJK COMPATIBILITY IDEOGRAPH-FA78
2F848     ; [.BBB6.0020.0002.55AB] # CJK COMPATIBILITY IDEOGRAPH-2F848
2F849     ; [.B7F6.0020.0002.55B3] # CJK COMPATIBILITY IDEOGRAPH-2F849
FA0D      ; [.A422.0020.0002.55C0] # CJK COMPATIBILITY IDEOGRAPH-FA0D
2F84A     ; [.CE34.0020.0002.55C2] # CJK COMPATIBILITY IDEOGRAPH-2F84A
FA7B      ; [.D21D.0020.0002.55E2] # CJK COMPATIBILITY IDEOGRAPH-FA7B
FA37      ; [.912C.0020.0002.5606] # CJK COMPATIBILITY IDEOGRAPH-FA37
2F84C     ; [.912C.0020.0002.5606] # CJK COMPATIBILITY IDEOGRAPH-2F84C
2F84E     ; [.A2BD.0020.0002.5651] # CJK COMPATIBILITY IDEOGRAPH-2F84E
FA38      ; [.ADFD.0020.0002.5668] # CJK COMPATIBILITY IDEOGRAPH-FA38
2F84F     ; [.847B.0020.0002.5674] # CJK COMPATIBILITY IDEOGRAPH-2F84F
F9A9      ; [.9A44.0020.0002.56F9] # CJK COMPATIBILITY IDEOGRAPH-F9A9
2F84B     ; [.92DB.0020.0002.5716] # CJK COMPATIBILITY IDEOGRAPH-2F84B
2F84D     ; [.92DC.0020.0002.5717] # CJK COMPATIBILITY IDEOGRAPH-2F84D
2F855     ; [.B548.0020.0002.578B] # CJK COMPATIBILITY IDEOGRAPH-2F855
2F852     ; [.BE03.0020.0002.57CE] # CJK COMPATIBILITY IDEOGRAPH-2F852
2F853     ; [.B720.0020.0002.57F4] # CJK COMPATIBILITY IDEOGRAPH-2F853
2F854     ; [.92F2.0020.0002.580D] # CJK COMPATIBILITY IDEOGRAPH-2F854
2F857     ; [.8151.0020.0002.5831] # CJK COMPATIBILITY IDEOGRAPH-2F857
2F856     ; [.C642.0020.0002.5832] # CJK COMPATIBILITY IDEOGRAPH-2F856
FA39      ; [.85EA.0020.0002.5840] # CJK COMPATIBILITY IDEOGRAPH-FA39
FA10      ; [.BB92.0020.0002.585A] # CJK COMPATIBILITY IDEOGRAPH-FA10
FA7C      ; [.BB92.0020.0002.585A] # CJK COMPATIBILITY IDEOGRAPH-FA7C
F96C      ; [.C892.0020.0002.585E] # CJK COMPATIBILITY IDEOGRAPH-F96C
FA3A      ; [.86A0.0020.0002.58A8] # CJK COMPATIBILITY IDEOGRAPH-FA3A
2F858     ; [.8E0D.0020.0002.58AC] # CJK COMPATIBILITY IDEOGRAPH-2F858
FA7D      ; [.8A7A.0020.0002.58B3] # CJK COMPATIBILITY IDEOGRAPH-FA7D
F94A      ; [.9679.0020.0002.58D8] # CJK COMPATIBILITY IDEOGRAPH-F94A
F942      ; [.9C0B.0020.0002.58DF] # CJK COMPATIBILITY IDEOGRAPH-F942
2F851     ; [.BB63.0020.0002.58EE] # CJK COMPATIBILITY IDEOGRAPH-2F851
2F85A     ; [.86C6.0020.0002.58F2] # CJK COMPATIBILITY IDEOGRAPH-2F85A
2F85B     ; [.A3DA.0020.0002.58F7] # CJK COMPATIBILITY IDEOGRAPH-2F85B
2F85C     ; [.8AFA.0020.0002.5906] # CJK COMPATIBILITY IDEOGRAPH-2F85C
2F85D     ; [.8F35.0020.0002.591A] # CJK COMPATIBILITY IDEOGRAPH-2F85D
2F85E     ; [.882A.0020.0002.5922] # CJK COMPATIBILITY IDEOGRAPH-2F85E
FA7E      ; [.CF5B.0020.0002.5944] # CJK COMPATIBILITY IDEOGRAPH-FA7E
F90C      ; [.9410.0020.0002.5948] # CJK COMPATIBILITY IDEOGRAPH-F90C
F909      ; [.ADE9.0020.0002.5951] # CJK COMPATIBILITY IDEOGRAPH-F909
FA7F      ; [.8193.0020.0002.5954] # CJK COMPATIBILITY IDEOGRAPH-FA7F
2F85F     ; [.C04A.0020.0002.5962] # CJK COMPATIBILITY IDEOGRAPH-2F85F
F981      ; [.95CC.0020.0002.5973] # CJK COMPATIBILITY IDEOGRAPH-F981
2F865     ; [.8598.0020.0002.59D8] # CJK COMPATIBILITY IDEOGRAPH-2F865
2F862     ; [.A6AD.0020.0002.59EC] # CJK COMPATIBILITY IDEOGRAPH-2F862
2F863     ; [.D42A.0020.0002.5A1B] # CJK COMPATIBILITY IDEOGRAPH-2F863
2F864     ; [.935B.0020.0002.5A27] # CJK COMPATIBILITY IDEOGRAPH-2F864
FA80      ; [.8232.0020.0002.5A62] # CJK COMPATIBILITY IDEOGRAPH-FA80
2F866     ; [.8BDA.0020.0002.5A66] # CJK COMPATIBILITY IDEOGRAPH-2F866
2F986     ; [.D15F.0020.0002.5AB5] # CJK COMPATIBILITY IDEOGRAPH-2F986
2F869     ; [.C2B1.0020.0002.5B08] # CJK COMPATIBILITY IDEOGRAPH-2F869
FA81      ; [.C657.0020.0002.5B28] # CJK COMPATIBILITY IDEOGRAPH-FA81
2F86A     ; [.9741.0020.0002.5B3E] # CJK COMPATIBILITY IDEOGRAPH-2F86A
2F86B     ; [.9741.0020.0002.5B3E] # CJK COMPATIBILITY IDEOGRAPH-2F86B
FA04      ; [.B874.0020.0002.5B85] # CJK COMPATIBILITY IDEOGRAPH-FA04
2F86D     ; [.D575.0020.0002.5BC3] # CJK COMPATIBILITY IDEOGRAPH-2F86D
2F86E     ; [.B7AB.0020.0002.5BD8] # CJK COMPATIBILITY IDEOGRAPH-2F86E
F95F      ; [.9570.0020.0002.5BE7] # CJK COMPATIBILITY IDEOGRAPH-F95F
F9AA      ; [.9570.0020.0002.5BE7] # CJK COMPATIBILITY IDEOGRAPH-F9AA
2F86F     ; [.9570.0020.0002.5BE7] # CJK COMPATIBILITY IDEOGRAPH-2F86F
F9BC      ; [.98DC.0020.0002.5BEE] # CJK COMPATIBILITY IDEOGRAPH-F9BC
2F870     ; [.8143.0020.0002.5BF3] # CJK COMPATIBILITY IDEOGRAPH-2F870
2F872     ; [.C0B3.0020.0002.5BFF] # CJK COMPATIBILITY IDEOGRAPH-2F872
2F873     ; [.AAD5.0020.0002.5C06] # CJK COMPATIBILITY IDEOGRAPH-2F873
2F875     ; [.CE9E.0020.0002.5C22] # CJK COMPATIBILITY IDEOGRAPH-2F875
F9BD      ; [.9522.0020.0002.5C3F] # CJK COMPATIBILITY IDEOGRAPH-F9BD
2F877     ; [.92CA.0020.0002.5C60] # CJK COMPATIBILITY IDEOGRAPH-2F877
F94B      ; [.9C34.0020.0002.5C62] # CJK COMPATIBILITY IDEOGRAPH-F94B
FA3B      ; [.C71D.0020.0002.5C64] # CJK COMPATIBILITY IDEOGRAPH-FA3B
F9DF      ; [.9C36.0020.0002.5C65] # CJK COMPATIBILITY IDEOGRAPH-F9DF
FA3C      ; [.BC63.0020.0002.5C6E] # CJK COMPATIBILITY IDEOGRAPH-FA3C
2F878     ; [.BC63.0020.0002.5C6E] # CJK COMPATIBILITY IDEOGRAPH-2F878
2F87A     ; [.AEFF.0020.0002.5C8D] # CJK COMPATIBILITY IDEOGRAPH-2F87A
2F879     ; [.B3C8.0020.0002.5CC0] # CJK COMPATIBILITY IDEOGRAPH-2F879
F9D5      ; [.9BB6.0020.0002.5D19] # CJK COMPATIBILITY IDEOGRAPH-F9D5
2F87C     ; [.CF66.0020.0002.5D43] # CJK COMPATIBILITY IDEOGRAPH-2F87C
F921      ; [.970A.0020.0002.5D50] # CJK COMPATIBILITY IDEOGRAPH-F921
2F87F     ; [.C416.0020.0002.5D6B] # CJK COMPATIBILITY IDEOGRAPH-2F87F
2F87E     ; [.8E87.0020.0002.5D6E] # CJK COMPATIBILITY IDEOGRAPH-2F87E
2F880     ; [.BD30.0020.0002.5D7C] # CJK COMPATIBILITY IDEOGRAPH-2F880
2F9F4     ; [.B1BE.0020.0002.5DB2] # CJK COMPATIBILITY IDEOGRAPH-2F9F4
F9AB      ; [.9A9A.0020.0002.5DBA] # CJK COMPATIBILITY IDEOGRAPH-F9AB
2F881     ; [.B68C.0020.0002.5DE1] # CJK COMPATIBILITY IDEOGRAPH-2F881
2F882     ; [.BC98.0020.0002.5DE2] # CJK COMPATIBILITY IDEOGRAPH-2F882
2F884     ; [.B6C0.0020.0002.5DFD] # CJK COMPATIBILITY IDEOGRAPH-2F884
2F885     ; [.C26F.0020.0002.5E28] # CJK COMPATIBILITY IDEOGRAPH-2F885
2F886     ; [.8758.0020.0002.5E3D] # CJK COMPATIBILITY IDEOGRAPH-2F886
2F887     ; [.8A7B.0020.0002.5E69] # CJK COMPATIBILITY IDEOGRAPH-2F887
F98E      ; [.9537.0020.0002.5E74] # CJK COMPATIBILITY IDEOGRAPH-F98E
FA01      ; [.8F28.0020.0002.5EA6] # CJK COMPATIBILITY IDEOGRAPH-FA01
2F88B     ; [.8372.0020.0002.5EB0] # CJK COMPATIBILITY IDEOGRAPH-2F88B
2F88C     ; [.8233.0020.0002.5EB3] # CJK COMPATIBILITY IDEOGRAPH-2F88C
2F88D     ; [.C22B.0020.0002.5EB6] # CJK COMPATIBILITY IDEOGRAPH-2F88D
F9A2      ; [.996E.0020.0002.5EC9] # CJK COMPATIBILITY IDEOGRAPH-F9A2
F928      ; [.9766.0020.0002.5ECA] # CJK COMPATIBILITY IDEOGRAPH-F928
2F88E     ; [.9766.0020.0002.5ECA] # CJK COMPATIBILITY IDEOGRAPH-2F88E
FA82      ; [.CAF7.0020.0002.5ED2] # CJK COMPATIBILITY IDEOGRAPH-FA82
FA0B      ; [.A11E.0020.0002.5ED3] # CJK COMPATIBILITY IDEOGRAPH-FA0B
FA83      ; [.CCFF.0020.0002.5ED9] # CJK COMPATIBILITY IDEOGRAPH-FA83
F982      ; [.9AB9.0020.0002.5EEC] # CJK COMPATIBILITY IDEOGRAPH-F982
2F890     ; [.9FBB.0020.0002.5EFE] # CJK COMPATIBILITY IDEOGRAPH-2F890
F943      ; [.95C8.0020.0002.5F04] # CJK COMPATIBILITY IDEOGRAPH-F943
2F894     ; [.9097.0020.0002.5F22] # CJK COMPATIBILITY IDEOGRAPH-2F894
2F895     ; [.9097.0020.0002.5F22] # CJK COMPATIBILITY IDEOGRAPH-2F895
2F874     ; [.8D4C.0020.0002.5F53] # CJK COMPATIBILITY IDEOGRAPH-2F874
2F899     ; [.B544.0020.0002.5F62] # CJK COMPATIBILITY IDEOGRAPH-2F899
FA84      ; [.C6A8.0020.0002.5F69] # CJK COMPATIBILITY IDEOGRAPH-FA84
2F89A     ; [.8E55.0020.0002.5F6B] # CJK COMPATIBILITY IDEOGRAPH-2F89A
F9D8      ; [.9C41.0020.0002.5F8B] # CJK COMPATIBILITY IDEOGRAPH-F9D8
2F89C     ; [.8FF3.0020.0002.5F9A] # CJK COMPATIBILITY IDEOGRAPH-2F89C
F966      ; [.8BDF.0020.0002.5FA9] # CJK COMPATIBILITY IDEOGRAPH-F966
FA85      ; [.CE36.0020.0002.5FAD] # CJK COMPATIBILITY IDEOGRAPH-FA85
2F89D     ; [.C2FD.0020.0002.5FCD] # CJK COMPATIBILITY IDEOGRAPH-2F89D
2F89E     ; [.B768.0020.0002.5FD7] # CJK COMPATIBILITY IDEOGRAPH-2F89E
F9A3      ; [.9551.0020.0002.5FF5] # CJK COMPATIBILITY IDEOGRAPH-F9A3
2F89F     ; [.A1E7.0020.0002.5FF9] # CJK COMPATIBILITY IDEOGRAPH-2F89F
F960      ; [.958F.0020.0002.6012] # CJK COMPATIBILITY IDEOGRAPH-F960
F9AC      ; [.9965.0020.0002.601C] # CJK COMPATIBILITY IDEOGRAPH-F9AC
FA6B      ; [.A524.0020.0002.6075] # CJK COMPATIBILITY IDEOGRAPH-FA6B
2F8A0     ; [.D572.0020.0002.6081] # CJK COMPATIBILITY IDEOGRAPH-2F8A0
FA3D      ; [.A510.0020.0002.6094] # CJK COMPATIBILITY IDEOGRAPH-FA3D
2F8A3     ; [.A510.0020.0002.6094] # CJK COMPATIBILITY IDEOGRAPH-2F8A3
2F8A5     ; [.8FBB.0020.0002.60C7] # CJK COMPATIBILITY IDEOGRAPH-2F8A5
FA86      ; [.D3D6.0020.0002.60D8] # CJK COMPATIBILITY IDEOGRAPH-FA86
F9B9      ; [.CA70.0020.0002.60E1] # CJK COMPATIBILITY IDEOGRAPH-F9B9
FA88      ; [.D4DB.0020.0002.6108] # CJK COMPATIBILITY IDEOGRAPH-FA88
F9D9      ; [.9846.0020.0002.6144] # CJK COMPATIBILITY IDEOGRAPH-F9D9
2F8A6     ; [.C64C.0020.0002.6148] # CJK COMPATIBILITY IDEOGRAPH-2F8A6
2F8A7     ; [.A5FA.0020.0002.614C] # CJK COMPATIBILITY IDEOGRAPH-2F8A7
2F8A9     ; [.A5FA.0020.0002.614C] # CJK COMPATIBILITY IDEOGRAPH-2F8A9
FA87      ; [.C178.0020.0002.614E] # CJK COMPATIBILITY IDEOGRAPH-FA87
2F8A8     ; [.C178.0020.0002.614E] # CJK COMPATIBILITY IDEOGRAPH-2F8A8
FA8A      ; [.CB23.0020.0002.6160] # CJK COMPATIBILITY IDEOGRAPH-FA8A
FA3E      ; [.A03D.0020.0002.6168] # CJK COMPATIBILITY IDEOGRAPH-FA3E
2F8AA     ; [.96E1.0020.0002.617A] # CJK COMPATIBILITY IDEOGRAPH-2F8AA
FA3F      ; [.C55C.0020.0002.618E] # CJK COMPATIBILITY IDEOGRAPH-FA3F
FA89      ; [.C55C.0020.0002.618E] # CJK COMPATIBILITY IDEOGRAPH-FA89
2F8AB     ; [.C55C.0020.0002.618E] # CJK COMPATIBILITY IDEOGRAPH-2F8AB
F98F      ; [.997C.0020.0002.6190] # CJK COMPATIBILITY IDEOGRAPH-F98F
2F8AD     ; [.8A96.0020.0002.61A4] # CJK COMPATIBILITY IDEOGRAPH-2F8AD
2F8AE     ; [.C6EB.0020.0002.61AF] # CJK COMPATIBILITY IDEOGRAPH-2F8AE
2F8AC     ; [.B498.0020.0002.61B2] # CJK COMPATIBILITY IDEOGRAPH-2F8AC
2F8AF     ; [.8803.0020.0002.61DE] # CJK COMPATIBILITY IDEOGRAPH-2F8AF
FA40      ; [.BE2C.0020.0002.61F2] # CJK COMPATIBILITY IDEOGRAPH-FA40
FA8B      ; [.BE2C.0020.0002.61F2] # CJK COMPATIBILITY IDEOGRAPH-FA8B
2F8B0     ; [.BE2C.0020.0002.61F2] # CJK COMPATIBILITY IDEOGRAPH-2F8B0
F90D      ; [.9742.0020.0002.61F6] # CJK COMPATIBILITY IDEOGRAPH-F90D
2F8B1     ; [.9742.0020.0002.61F6] # CJK COMPATIBILITY IDEOGRAPH-2F8B1
F990      ; [.99C4.0020.0002.6200] # CJK COMPATIBILITY IDEOGRAPH-F990
2F8B2     ; [.BDFC.0020.0002.6210] # CJK COMPATIBILITY IDEOGRAPH-2F8B2
2F8B3     ; [.A802.0020.0002.621B] # CJK COMPATIBILITY IDEOGRAPH-2F8B3
F9D2      ; [.9B16.0020.0002.622E] # CJK COMPATIBILITY IDEOGRAPH-F9D2
FA8C      ; [.8C7A.0020.0002.6234] # CJK COMPATIBILITY IDEOGRAPH-FA8C
2F8B4     ; [.A0E3.0020.0002.625D] # CJK COMPATIBILITY IDEOGRAPH-2F8B4
2F8B5     ; [.814B.0020.0002.62B1] # CJK COMPATIBILITY IDEOGRAPH-2F8B5
F925      ; [.95DB.0020.0002.62C9] # CJK COMPATIBILITY IDEOGRAPH-F925
F95B      ; [.93DB.0020.0002.62CF] # CJK COMPATIBILITY IDEOGRAPH-F95B
FA02      ; [.9037.0020.0002.62D3] # CJK COMPATIBILITY IDEOGRAPH-FA02
2F8B6     ; [.801D.0020.0002.62D4] # CJK COMPATIBILITY IDEOGRAPH-2F8B6
2F8BA     ; [.8599.0020.0002.62FC] # CJK COMPATIBILITY IDEOGRAPH-2F8BA
F973      ; [.C00F.0020.0002.62FE] # CJK COMPATIBILITY IDEOGRAPH-F973
2F8B9     ; [.D348.0020.0002.633D] # CJK COMPATIBILITY IDEOGRAPH-2F8B9
2F8B7     ; [.ACA2.0020.0002.6350] # CJK COMPATIBILITY IDEOGRAPH-2F8B7
2F8BB     ; [.C05A.0020.0002.6368] # CJK COMPATIBILITY IDEOGRAPH-2F8BB
F9A4      ; [.9540.0020.0002.637B] # CJK COMPATIBILITY IDEOGRAPH-F9A4
2F8BC     ; [.C8AF.0020.0002.6383] # CJK COMPATIBILITY IDEOGRAPH-2F8BC
F975      ; [.CA67.0020.0002.63A0] # CJK COMPATIBILITY IDEOGRAPH-F975
2F8C1     ; [.CF63.0020.0002.63A9] # CJK COMPATIBILITY IDEOGRAPH-2F8C1
FA8D      ; [.D43E.0020.0002.63C4] # CJK COMPATIBILITY IDEOGRAPH-FA8D
2F8C0     ; [.CF39.0020.0002.63C5] # CJK COMPATIBILITY IDEOGRAPH-2F8C0
2F8BD     ; [.A70F.0020.0002.63E4] # CJK COMPATIBILITY IDEOGRAPH-2F8BD
FA8E      ; [.C8BD.0020.0002.641C] # CJK COMPATIBILITY IDEOGRAPH-FA8E
2F8BF     ; [.AAB0.0020.0002.6422] # CJK COMPATIBILITY IDEOGRAPH-2F8BF
FA8F      ; [.8365.0020.0002.6452] # CJK COMPATIBILITY IDEOGRAPH-FA8F
2F8C3     ; [.865D.0020.0002.6469] # CJK COMPATIBILITY IDEOGRAPH-2F8C3
2F8C6     ; [.A904.0020.0002.6477] # CJK COMPATIBILITY IDEOGRAPH-2F8C6
2F8C4     ; [.AB0A.0020.0002.647E] # CJK COMPATIBILITY IDEOGRAPH-2F8C4
F991      ; [.9546.0020.0002.649A] # CJK COMPATIBILITY IDEOGRAPH-F991
2F8C5     ; [.A4F3.0020.0002.649D] # CJK COMPATIBILITY IDEOGRAPH-2F8C5
F930      ; [.9ADE.0020.0002.64C4] # CJK COMPATIBILITY IDEOGRAPH-F930
FA41      ; [.8915.0020.0002.654F] # CJK COMPATIBILITY IDEOGRAPH-FA41
2F8C8     ; [.8915.0020.0002.654F] # CJK COMPATIBILITY IDEOGRAPH-2F8C8
FA90      ; [.CAF2.0020.0002.6556] # CJK COMPATIBILITY IDEOGRAPH-FA90
2F8C9     ; [.AB74.0020.0002.656C] # CJK COMPATIBILITY IDEOGRAPH-2F8C9
F969      ; [.C23A.0020.0002.6578] # CJK COMPATIBILITY IDEOGRAPH-F969
F9BE      ; [.9905.0020.0002.6599] # CJK COMPATIBILITY IDEOGRAPH-F9BE
F983      ; [.9C2B.0020.0002.65C5] # CJK COMPATIBILITY IDEOGRAPH-F983
FA42      ; [.A775.0020.0002.65E2] # CJK COMPATIBILITY IDEOGRAPH-FA42
2F8CB     ; [.A789.0020.0002.65E3] # CJK COMPATIBILITY IDEOGRAPH-2F8CB
F9E0      ; [.CCA3.0020.0002.6613] # CJK COMPATIBILITY IDEOGRAPH-F9E0
2F8CD     ; [.AAA5.0020.0002.6649] # CJK COMPATIBILITY IDEOGRAPH-2F8CD
FA12      ; [.B034.0020.0002.6674] # CJK COMPATIBILITY IDEOGRAPH-FA12
FA91      ; [.B034.0020.0002.6674] # CJK COMPATIBILITY IDEOGRAPH-FA91
F9C5      ; [.D5E6.0020.0002.6688] # CJK COMPATIBILITY IDEOGRAPH-F9C5
FA43      ; [.C20B.0020.0002.6691] # CJK COMPATIBILITY IDEOGRAPH-FA43
2F8CF     ; [.C20B.0020.0002.6691] # CJK COMPATIBILITY IDEOGRAPH-2F8CF
2F8D5     ; [.AAB8.0020.0002.669C] # CJK COMPATIBILITY IDEOGRAPH-2F8D5
FA06      ; [.8156.0020.0002.66B4] # CJK COMPATIBILITY IDEOGRAPH-FA06
F98B      ; [.9855.0020.0002.66C6] # CJK COMPATIBILITY IDEOGRAPH-F98B
F901      ; [.9DDE.0020.0002.66F4] # CJK COMPATIBILITY IDEOGRAPH-F901
2F8CC     ; [.C1E5.0020.0002.66F8] # CJK COMPATIBILITY IDEOGRAPH-2F8CC
2F8D4     ; [.C5BD.0020.0002.6700] # CJK COMPATIBILITY IDEOGRAPH-2F8D4
F929      ; [.9775.0020.0002.6717] # CJK COMPATIBILITY IDEOGRAPH-F929
FA92      ; [.9775.0020.0002.6717] # CJK COMPATIBILITY IDEOGRAPH-FA92
2F8D8     ; [.9775.0020.0002.6717] # CJK COMPATIBILITY IDEOGRAPH-2F8D8
FA93      ; [.D3E7.0020.0002.671B] # CJK COMPATIBILITY IDEOGRAPH-FA93
2F8D9     ; [.D3E7.0020.0002.671B] # CJK COMPATIBILITY IDEOGRAPH-2F8D9
2F8DA     ; [.C5F8.0020.0002.6721] # CJK COMPATIBILITY IDEOGRAPH-2F8DA
F9E1      ; [.9897.0020.0002.674E] # CJK COMPATIBILITY IDEOGRAPH-F9E1
2F8DC     ; [.82A9.0020.0002.6753] # CJK COMPATIBILITY IDEOGRAPH-2F8DC
FA94      ; [.B9DA.0020.0002.6756] # CJK COMPATIBILITY IDEOGRAPH-FA94
2F8DB     ; [.ADC7.0020.0002.675E] # CJK COMPATIBILITY IDEOGRAPH-2F8DB
F9C8      ; [.BCDE.0020.0002.677B] # CJK COMPATIBILITY IDEOGRAPH-F9C8
2F8E0     ; [.A6A7.0020.0002.6785] # CJK COMPATIBILITY IDEOGRAPH-2F8E0
F9F4      ; [.99CA.0020.0002.6797] # CJK COMPATIBILITY IDEOGRAPH-F9F4
F9C9      ; [.9944.0020.0002.67F3] # CJK COMPATIBILITY IDEOGRAPH-F9C9
2F8DF     ; [.9EAD.0020.0002.67FA] # CJK COMPATIBILITY IDEOGRAPH-2F8DF
F9DA      ; [.9826.0020.0002.6817] # CJK COMPATIBILITY IDEOGRAPH-F9DA
2F8E5     ; [.8196.0020.0002.681F] # CJK COMPATIBILITY IDEOGRAPH-2F8E5
2F8E1     ; [.C902.0020.0002.6852] # CJK COMPATIBILITY IDEOGRAPH-2F8E1
F97A      ; [.9A19.0020.0002.6881] # CJK COMPATIBILITY IDEOGRAPH-F97A
FA44      ; [.86DF.0020.0002.6885] # CJK COMPATIBILITY IDEOGRAPH-FA44
2F8E2     ; [.86DF.0020.0002.6885] # CJK COMPATIBILITY IDEOGRAPH-2F8E2
2F8E4     ; [.CAEF.0020.0002.688E] # CJK COMPATIBILITY IDEOGRAPH-2F8E4
F9E2      ; [.979F.0020.0002.68A8] # CJK COMPATIBILITY IDEOGRAPH-F9E2
2F8E6     ; [.C417.0020.0002.6914] # CJK COMPATIBILITY IDEOGRAPH-2F8E6
2F8E8     ; [.B7F9.0020.0002.6942] # CJK COMPATIBILITY IDEOGRAPH-2F8E8
2F8E9     ; [.CE3D.0020.0002.69A3] # CJK COMPATIBILITY IDEOGRAPH-2F8E9
2F8EA     ; [.9CE5.0020.0002.69EA] # CJK COMPATIBILITY IDEOGRAPH-2F8EA
F914      ; [.9610.0020.0002.6A02] # CJK COMPATIBILITY IDEOGRAPH-F914
F95C      ; [.9610.0020.0002.6A02] # CJK COMPATIBILITY IDEOGRAPH-F95C
F9BF      ; [.9610.0020.0002.6A02] # CJK COMPATIBILITY IDEOGRAPH-F9BF
F94C      ; [.96E3.0020.0002.6A13] # CJK COMPATIBILITY IDEOGRAPH-F94C
2F8EB     ; [.C052.0020.0002.6AA8] # CJK COMPATIBILITY IDEOGRAPH-2F8EB
F931      ; [.9AE5.0020.0002.6AD3] # CJK COMPATIBILITY IDEOGRAPH-F931
2F8ED     ; [.B7D3.0020.0002.6ADB] # CJK COMPATIBILITY IDEOGRAPH-2F8ED
F91D      ; [.9726.0020.0002.6B04] # CJK COMPATIBILITY IDEOGRAPH-F91D
2F8EF     ; [.C667.0020.0002.6B21] # CJK COMPATIBILITY IDEOGRAPH-2F8EF
2F8F1     ; [.B58D.0020.0002.6B54] # CJK COMPATIBILITY IDEOGRAPH-2F8F1
2F8F3     ; [.C9AB.0020.0002.6B72] # CJK COMPATIBILITY IDEOGRAPH-2F8F3
F98C      ; [.9856.0020.0002.6B77] # CJK COMPATIBILITY IDEOGRAPH-F98C
FA95      ; [.8C53.0020.0002.6B79] # CJK COMPATIBILITY IDEOGRAPH-FA95
2F8F4     ; [.D380.0020.0002.6B9F] # CJK COMPATIBILITY IDEOGRAPH-2F8F4
F9A5      ; [.99BD.0020.0002.6BAE] # CJK COMPATIBILITY IDEOGRAPH-F9A5
F970      ; [.C025.0020.0002.6BBA] # CJK COMPATIBILITY IDEOGRAPH-F970
FA96      ; [.C025.0020.0002.6BBA] # CJK COMPATIBILITY IDEOGRAPH-FA96
2F8F5     ; [.C025.0020.0002.6BBA] # CJK COMPATIBILITY IDEOGRAPH-2F8F5
2F8F6     ; [.AE8A.0020.0002.6BBB] # CJK COMPATIBILITY IDEOGRAPH-2F8F6
2F8FA     ; [.8A3E.0020.0002.6C4E] # CJK COMPATIBILITY IDEOGRAPH-2F8FA
2F8FE     ; [.AF01.0020.0002.6C67] # CJK COMPATIBILITY IDEOGRAPH-2F8FE
F972      ; [.BD5D.0020.0002.6C88] # CJK COMPATIBILITY IDEOGRAPH-F972
2F8FC     ; [.CF25.0020.0002.6CBF] # CJK COMPATIBILITY IDEOGRAPH-2F8FC
F968      ; [.886C.0020.0002.6CCC] # CJK COMPATIBILITY IDEOGRAPH-F968
2F8FD     ; [.8194.0020.0002.6CCD] # CJK COMPATIBILITY IDEOGRAPH-2F8FD
F9E3      ; [.9490.0020.0002.6CE5] # CJK COMPATIBILITY IDEOGRAPH-F9E3
2F8FF     ; [.D193.0020.0002.6D16] # CJK COMPATIBILITY IDEOGRAPH-2F8FF
F915      ; [.9B72.0020.0002.6D1B] # CJK COMPATIBILITY IDEOGRAPH-F915
FA05      ; [.900E.0020.0002.6D1E] # CJK COMPATIBILITY IDEOGRAPH-FA05
2F907     ; [.85C8.0020.0002.6D34] # CJK COMPATIBILITY IDEOGRAPH-2F907
2F900     ; [.83F9.0020.0002.6D3E] # CJK COMPATIBILITY IDEOGRAPH-2F900
F9CA      ; [.9912.0020.0002.6D41] # CJK COMPATIBILITY IDEOGRAPH-F9CA
FA97      ; [.9912.0020.0002.6D41] # CJK COMPATIBILITY IDEOGRAPH-FA97
2F902     ; [.9912.0020.0002.6D41] # CJK COMPATIBILITY IDEOGRAPH-2F902
2F903     ; [.A2D9.0020.0002.6D69] # CJK COMPATIBILITY IDEOGRAPH-2F903
F92A      ; [.9781.0020.0002.6D6A] # CJK COMPATIBILITY IDEOGRAPH-F92A
FA45      ; [.A29A.0020.0002.6D77] # CJK COMPATIBILITY IDEOGRAPH-FA45
2F901     ; [.A29A.0020.0002.6D77] # CJK COMPATIBILITY IDEOGRAPH-2F901
2F904     ; [.AAA7.0020.0002.6D78] # CJK COMPATIBILITY IDEOGRAPH-2F904
2F905     ; [.94E1.0020.0002.6D85] # CJK COMPATIBILITY IDEOGRAPH-2F905
F9F5      ; [.99D1.0020.0002.6DCB] # CJK COMPATIBILITY IDEOGRAPH-F9F5
F94D      ; [.9688.0020.0002.6DDA] # CJK COMPATIBILITY IDEOGRAPH-F94D
F9D6      ; [.9BB8.0020.0002.6DEA] # CJK COMPATIBILITY IDEOGRAPH-F9D6
2F90E     ; [.CF08.0020.0002.6DF9] # CJK COMPATIBILITY IDEOGRAPH-2F90E
FA46      ; [.BA70.0020.0002.6E1A] # CJK COMPATIBILITY IDEOGRAPH-FA46
2F908     ; [.9DB6.0020.0002.6E2F] # CJK COMPATIBILITY IDEOGRAPH-2F908
2F909     ; [.CF0D.0020.0002.6E6E] # CJK COMPATIBILITY IDEOGRAPH-2F909
F9CB      ; [.990C.0020.0002.6E9C] # CJK COMPATIBILITY IDEOGRAPH-F9CB
F9EC      ; [.94CE.0020.0002.6EBA] # CJK COMPATIBILITY IDEOGRAPH-F9EC
2F90C     ; [.8E88.0020.0002.6EC7] # CJK COMPATIBILITY IDEOGRAPH-2F90C
FA99      ; [.C419.0020.0002.6ECB] # CJK COMPATIBILITY IDEOGRAPH-FA99
2F90B     ; [.C419.0020.0002.6ECB] # CJK COMPATIBILITY IDEOGRAPH-2F90B
F904      ; [.A44F.0020.0002.6ED1] # CJK COMPATIBILITY IDEOGRAPH-F904
FA98      ; [.D03B.0020.0002.6EDB] # CJK COMPATIBILITY IDEOGRAPH-FA98
F94E      ; [.96FC.0020.0002.6F0F] # CJK COMPATIBILITY IDEOGRAPH-F94E
FA47      ; [.A368.0020.0002.6F22] # CJK COMPATIBILITY IDEOGRAPH-FA47
FA9A      ; [.A368.0020.0002.6F22] # CJK COMPATIBILITY IDEOGRAPH-FA9A
F992      ; [.9974.0020.0002.6F23] # CJK COMPATIBILITY IDEOGRAPH-F992
2F90F     ; [.BCA0.0020.0002.6F6E] # CJK COMPATIBILITY IDEOGRAPH-2F90F
2F912     ; [.8A7C.0020.0002.6FC6] # CJK COMPATIBILITY IDEOGRAPH-2F912
F922      ; [.9751.0020.0002.6FEB] # CJK COMPATIBILITY IDEOGRAPH-F922
F984      ; [.9C51.0020.0002.6FFE] # CJK COMPATIBILITY IDEOGRAPH-F984
2F915     ; [.D142.0020.0002.701B] # CJK COMPATIBILITY IDEOGRAPH-2F915
FA9B      ; [.AB83.0020.0002.701E] # CJK COMPATIBILITY IDEOGRAPH-FA9B
2F914     ; [.AB83.0020.0002.701E] # CJK COMPATIBILITY IDEOGRAPH-2F914
2F913     ; [.D563.0020.0002.7039] # CJK COMPATIBILITY IDEOGRAPH-2F913
2F917     ; [.AF57.0020.0002.704A] # CJK COMPATIBILITY IDEOGRAPH-2F917
2F835     ; [.A4D6.0020.0002.7070] # CJK COMPATIBILITY IDEOGRAPH-2F835
2F919     ; [.BB35.0020.0002.7077] # CJK COMPATIBILITY IDEOGRAPH-2F919
2F918     ; [.C4B5.0020.0002.707D] # CJK COMPATIBILITY IDEOGRAPH-2F918
F9FB      ; [.B774.0020.0002.7099] # CJK COMPATIBILITY IDEOGRAPH-F9FB
2F91A     ; [.9126.0020.0002.70AD] # CJK COMPATIBILITY IDEOGRAPH-2F91A
F99F      ; [.98B0.0020.0002.70C8] # CJK COMPATIBILITY IDEOGRAPH-F99F
F916      ; [.96C6.0020.0002.70D9] # CJK COMPATIBILITY IDEOGRAPH-F916
2F91C     ; [.8FAD.0020.0002.7145] # CJK COMPATIBILITY IDEOGRAPH-2F91C
F993      ; [.99B6.0020.0002.7149] # CJK COMPATIBILITY IDEOGRAPH-F993
FA48      ; [.BA72.0020.0002.716E] # CJK COMPATIBILITY IDEOGRAPH-FA48
FA9C      ; [.BA72.0020.0002.716E] # CJK COMPATIBILITY IDEOGRAPH-FA9C
2F91E     ; [.C7CA.0020.0002.719C] # CJK COMPATIBILITY IDEOGRAPH-2F91E
F9C0      ; [.98E3.0020.0002.71CE] # CJK COMPATIBILITY IDEOGRAPH-F9C0
F9EE      ; [.99E0.0020.0002.71D0] # CJK COMPATIBILITY IDEOGRAPH-F9EE
F932      ; [.9AC1.0020.0002.7210] # CJK COMPATIBILITY IDEOGRAPH-F932
F91E      ; [.9753.0020.0002.721B] # CJK COMPATIBILITY IDEOGRAPH-F91E
2F920     ; [.C7A8.0020.0002.7228] # CJK COMPATIBILITY IDEOGRAPH-2F920
FA49      ; [.B8AD.0020.0002.722B] # CJK COMPATIBILITY IDEOGRAPH-FA49
FA9E      ; [.AC81.0020.0002.7235] # CJK COMPATIBILITY IDEOGRAPH-FA9E
2F921     ; [.AC81.0020.0002.7235] # CJK COMPATIBILITY IDEOGRAPH-2F921
2F922     ; [.B809.0020.0002.7250] # CJK COMPATIBILITY IDEOGRAPH-2F922
F946      ; [.969F.0020.0002.7262] # CJK COMPATIBILITY IDEOGRAPH-F946
2F924     ; [.B19A.0020.0002.7280] # CJK COMPATIBILITY IDEOGRAPH-2F924
2F925     ; [.810B.0020.0002.7295] # CJK COMPATIBILITY IDEOGRAPH-2F925
FA9F      ; [.8A3C.0020.0002.72AF] # CJK COMPATIBILITY IDEOGRAPH-FA9F
F9FA      ; [.BB66.0020.0002.72C0] # CJK COMPATIBILITY IDEOGRAPH-F9FA
F92B      ; [.975E.0020.0002.72FC] # CJK COMPATIBILITY IDEOGRAPH-F92B
FA16      ; [.BA3A.0020.0002.732A] # CJK COMPATIBILITY IDEOGRAPH-FA16
FAA0      ; [.BA3A.0020.0002.732A] # CJK COMPATIBILITY IDEOGRAPH-FAA0
F9A7      ; [.98C3.0020.0002.7375] # CJK COMPATIBILITY IDEOGRAPH-F9A7
2F928     ; [.9034.0020.0002.737A] # CJK COMPATIBILITY IDEOGRAPH-2F928
F961      ; [.9C43.0020.0002.7387] # CJK COMPATIBILITY IDEOGRAPH-F961
F9DB      ; [.9C43.0020.0002.7387] # CJK COMPATIBILITY IDEOGRAPH-F9DB
2F929     ; [.D3CA.0020.0002.738B] # CJK COMPATIBILITY IDEOGRAPH-2F929
2F92B     ; [.D544.0020.0002.73A5] # CJK COMPATIBILITY IDEOGRAPH-2F92B
F9AD      ; [.9A4F.0020.0002.73B2] # CJK COMPATIBILITY IDEOGRAPH-F9AD
F917      ; [.9B76.0020.0002.73DE] # CJK COMPATIBILITY IDEOGRAPH-F917
F9E4      ; [.97F2.0020.0002.7406] # CJK COMPATIBILITY IDEOGRAPH-F9E4
F9CC      ; [.9914.0020.0002.7409] # CJK COMPATIBILITY IDEOGRAPH-F9CC
FA4A      ; [.C58E.0020.0002.7422] # CJK COMPATIBILITY IDEOGRAPH-FA4A
2F92E     ; [.8C72.0020.0002.7447] # CJK COMPATIBILITY IDEOGRAPH-2F92E
2F92F     ; [.D44E.0020.0002.745C] # CJK COMPATIBILITY IDEOGRAPH-2F92F
F9AE      ; [.D131.0020.0002.7469] # CJK COMPATIBILITY IDEOGRAPH-F9AE
FAA1      ; [.B9AB.0020.0002.7471] # CJK COMPATIBILITY IDEOGRAPH-FAA1
2F930     ; [.B9AB.0020.0002.7471] # CJK COMPATIBILITY IDEOGRAPH-2F930
2F931     ; [.C979.0020.0002.7485] # CJK COMPATIBILITY IDEOGRAPH-2F931
F994      ; [.999F.0020.0002.7489] # CJK COMPATIBILITY IDEOGRAPH-F994
F9EF      ; [.99E1.0020.0002.7498] # CJK COMPATIBILITY IDEOGRAPH-F9EF
2F932     ; [.B15E.0020.0002.74CA] # CJK COMPATIBILITY IDEOGRAPH-2F932
FAA2      ; [.C64D.0020.0002.7506] # CJK COMPATIBILITY IDEOGRAPH-FAA2
2F934     ; [.C397.0020.0002.7524] # CJK COMPATIBILITY IDEOGRAPH-2F934
FAA3      ; [.A462.0020.0002.753B] # CJK COMPATIBILITY IDEOGRAPH-FAA3
2F936     ; [.C4B7.0020.0002.753E] # CJK COMPATIBILITY IDEOGRAPH-2F936
F9CD      ; [.9915.0020.0002.7559] # CJK COMPATIBILITY IDEOGRAPH-F9CD
F976      ; [.CA68.0020.0002.7565] # CJK COMPATIBILITY IDEOGRAPH-F976
F962      ; [.CCD0.0020.0002.7570] # CJK COMPATIBILITY IDEOGRAPH-F962
2F938     ; [.CCD0.0020.0002.7570] # CJK COMPATIBILITY IDEOGRAPH-2F938
F9E5      ; [.983F.0020.0002.75E2] # CJK COMPATIBILITY IDEOGRAPH-F9E5
2F93A     ; [.D494.0020.0002.7610] # CJK COMPATIBILITY IDEOGRAPH-2F93A
FAA4      ; [.9F2F.0020.0002.761D] # CJK COMPATIBILITY IDEOGRAPH-FAA4
FAA5      ; [.D382.0020.0002.761F] # CJK COMPATIBILITY IDEOGRAPH-FAA5
F9C1      ; [.98E8.0020.0002.7642] # CJK COMPATIBILITY IDEOGRAPH-F9C1
F90E      ; [.9649.0020.0002.7669] # CJK COMPATIBILITY IDEOGRAPH-F90E
FA17      ; [.CCC7.0020.0002.76CA] # CJK COMPATIBILITY IDEOGRAPH-FA17
FAA6      ; [.CCC7.0020.0002.76CA] # CJK COMPATIBILITY IDEOGRAPH-FAA6
FAA7      ; [.C1CA.0020.0002.76DB] # CJK COMPATIBILITY IDEOGRAPH-FAA7
F933      ; [.9AB5.0020.0002.76E7] # CJK COMPATIBILITY IDEOGRAPH-F933
FAA8      ; [.B71A.0020.0002.76F4] # CJK COMPATIBILITY IDEOGRAPH-FAA8
2F940     ; [.B71A.0020.0002.76F4] # CJK COMPATIBILITY IDEOGRAPH-2F940
F96D      ; [.C1C2.0020.0002.7701] # CJK COMPATIBILITY IDEOGRAPH-F96D
2F945     ; [.B959.0020.0002.771E] # CJK COMPATIBILITY IDEOGRAPH-2F945
2F946     ; [.B95A.0020.0002.771F] # CJK COMPATIBILITY IDEOGRAPH-2F946
2F947     ; [.B95A.0020.0002.771F] # CJK COMPATIBILITY IDEOGRAPH-2F947
FAAA      ; [.B869.0020.0002.7740] # CJK COMPATIBILITY IDEOGRAPH-FAAA
FAA9      ; [.ACC5.0020.0002.774A] # CJK COMPATIBILITY IDEOGRAPH-FAA9
2F948     ; [.ACC5.0020.0002.774A] # CJK COMPATIBILITY IDEOGRAPH-2F948
2F94A     ; [.BD55.0020.0002.778B] # CJK COMPATIBILITY IDEOGRAPH-2F94A
FA9D      ; [.AE77.0020.0002.77A7] # CJK COMPATIBILITY IDEOGRAPH-FA9D
2F94E     ; [.B54F.0020.0002.784E] # CJK COMPATIBILITY IDEOGRAPH-2F94E
F9CE      ; [.9918.0020.0002.786B] # CJK COMPATIBILITY IDEOGRAPH-F9CE
F93B      ; [.9B0A.0020.0002.788C] # CJK COMPATIBILITY IDEOGRAPH-F93B
2F94F     ; [.9B0A.0020.0002.788C] # CJK COMPATIBILITY IDEOGRAPH-2F94F
FA4B      ; [.80DF.0020.0002.7891] # CJK COMPATIBILITY IDEOGRAPH-FA4B
F947      ; [.9673.0020.0002.78CA] # CJK COMPATIBILITY IDEOGRAPH-F947
FAAB      ; [.9259.0020.0002.78CC] # CJK COMPATIBILITY IDEOGRAPH-FAAB
2F950     ; [.9259.0020.0002.78CC] # CJK COMPATIBILITY IDEOGRAPH-2F950
F964      ; [.845F.0020.0002.78FB] # CJK COMPATIBILITY IDEOGRAPH-F964
F985      ; [.9878.0020.0002.792A] # CJK COMPATIBILITY IDEOGRAPH-F985
FA18      ; [.97EA.0020.0002.793C] # CJK COMPATIBILITY IDEOGRAPH-FA18
FA4C      ; [.C05E.0020.0002.793E] # CJK COMPATIBILITY IDEOGRAPH-FA4C
FA4E      ; [.AD73.0020.0002.7948] # CJK COMPATIBILITY IDEOGRAPH-FA4E
FA4D      ; [.B757.0020.0002.7949] # CJK COMPATIBILITY IDEOGRAPH-FA4D
FA4F      ; [.CEF0.0020.0002.7950] # CJK COMPATIBILITY IDEOGRAPH-FA4F
FA50      ; [.C583.0020.0002.7956] # CJK COMPATIBILITY IDEOGRAPH-FA50
2F953     ; [.C583.0020.0002.7956] # CJK COMPATIBILITY IDEOGRAPH-2F953
FA51      ; [.BA90.0020.0002.795D] # CJK COMPATIBILITY IDEOGRAPH-FA51
FA19      ; [.C153.0020.0002.795E] # CJK COMPATIBILITY IDEOGRAPH-FA19
FA1A      ; [.B4FF.0020.0002.7965] # CJK COMPATIBILITY IDEOGRAPH-FA1A
F93C      ; [.9B0B.0020.0002.797F] # CJK COMPATIBILITY IDEOGRAPH-F93C
FA52      ; [.A4A7.0020.0002.798D] # CJK COMPATIBILITY IDEOGRAPH-FA52
FA53      ; [.B971.0020.0002.798E] # CJK COMPATIBILITY IDEOGRAPH-FA53
FA1B      ; [.8B8D.0020.0002.798F] # CJK COMPATIBILITY IDEOGRAPH-FA1B
2F956     ; [.8B8D.0020.0002.798F] # CJK COMPATIBILITY IDEOGRAPH-2F956
F9B6      ; [.97FC.0020.0002.79AE] # CJK COMPATIBILITY IDEOGRAPH-F9B6
F995      ; [.9538.0020.0002.79CA] # CJK COMPATIBILITY IDEOGRAPH-F995
2F957     ; [.C201.0020.0002.79EB] # CJK COMPATIBILITY IDEOGRAPH-2F957
F956      ; [.978F.0020.0002.7A1C] # CJK COMPATIBILITY IDEOGRAPH-F956
FA54      ; [.9E24.0020.0002.7A40] # CJK COMPATIBILITY IDEOGRAPH-FA54
2F959     ; [.9E24.0020.0002.7A40] # CJK COMPATIBILITY IDEOGRAPH-2F959
2F95A     ; [.A79C.0020.0002.7A4A] # CJK COMPATIBILITY IDEOGRAPH-2F95A
2F95B     ; [.D3B2.0020.0002.7A4F] # CJK COMPATIBILITY IDEOGRAPH-2F95B
FA55      ; [.92B6.0020.0002.7A81] # CJK COMPATIBILITY IDEOGRAPH-FA55
FAAC      ; [.9231.0020.0002.7AB1] # CJK COMPATIBILITY IDEOGRAPH-FAAC
F9F7      ; [.9808.0020.0002.7ACB] # CJK COMPATIBILITY IDEOGRAPH-F9F7
2F95F     ; [.85BC.0020.0002.7AEE] # CJK COMPATIBILITY IDEOGRAPH-2F95F
F9F8      ; [.9833.0020.0002.7B20] # CJK COMPATIBILITY IDEOGRAPH-F9F8
FA56      ; [.A87C.0020.0002.7BC0] # CJK COMPATIBILITY IDEOGRAPH-FA56
FAAD      ; [.A87C.0020.0002.7BC0] # CJK COMPATIBILITY IDEOGRAPH-FAAD
2F962     ; [.BB3E.0020.0002.7BC6] # CJK COMPATIBILITY IDEOGRAPH-2F962
2F963     ; [.BA5F.0020.0002.7BC9] # CJK COMPATIBILITY IDEOGRAPH-2F963
F9A6      ; [.9992.0020.0002.7C3E] # CJK COMPATIBILITY IDEOGRAPH-F9A6
F944      ; [.9BF8.0020.0002.7C60] # CJK COMPATIBILITY IDEOGRAPH-F944
FAAE      ; [.9686.0020.0002.7C7B] # CJK COMPATIBILITY IDEOGRAPH-FAAE
F9F9      ; [.9834.0020.0002.7C92] # CJK COMPATIBILITY IDEOGRAPH-F9F9
FA1D      ; [.AB32.0020.0002.7CBE] # CJK COMPATIBILITY IDEOGRAPH-FA1D
2F966     ; [.8114.0020.0002.7CD2] # CJK COMPATIBILITY IDEOGRAPH-2F966
FA03      ; [.915F.0020.0002.7CD6] # CJK COMPATIBILITY IDEOGRAPH-FA03
2F969     ; [.C8EE.0020.0002.7CE3] # CJK COMPATIBILITY IDEOGRAPH-2F969
F97B      ; [.9A24.0020.0002.7CE7] # CJK COMPATIBILITY IDEOGRAPH-F97B
2F968     ; [.AB10.0020.0002.7CE8] # CJK COMPATIBILITY IDEOGRAPH-2F968
2F96A     ; [.A778.0020.0002.7D00] # CJK COMPATIBILITY IDEOGRAPH-2F96A
F9CF      ; [.952E.0020.0002.7D10] # CJK COMPATIBILITY IDEOGRAPH-F9CF
F96A      ; [.C970.0020.0002.7D22] # CJK COMPATIBILITY IDEOGRAPH-F96A
F94F      ; [.9689.0020.0002.7D2F] # CJK COMPATIBILITY IDEOGRAPH-F94F
FAAF      ; [.90A1.0020.0002.7D5B] # CJK COMPATIBILITY IDEOGRAPH-FAAF
2F96C     ; [.81D3.0020.0002.7D63] # CJK COMPATIBILITY IDEOGRAPH-2F96C
F93D      ; [.9C4A.0020.0002.7DA0] # CJK COMPATIBILITY IDEOGRAPH-F93D
F957      ; [.9A73.0020.0002.7DBE] # CJK COMPATIBILITY IDEOGRAPH-F957
2F96E     ; [.C427.0020.0002.7DC7] # CJK COMPATIBILITY IDEOGRAPH-2F96E
F996      ; [.99BA.0020.0002.7DF4] # CJK COMPATIBILITY IDEOGRAPH-F996
FA57      ; [.99BA.0020.0002.7DF4] # CJK COMPATIBILITY IDEOGRAPH-FA57
FAB0      ; [.99BA.0020.0002.7DF4] # CJK COMPATIBILITY IDEOGRAPH-FAB0
2F96F     ; [.C61F.0020.0002.7E02] # CJK COMPATIBILITY IDEOGRAPH-2F96F
FA58      ; [.AAC3.0020.0002.7E09] # CJK COMPATIBILITY IDEOGRAPH-FA58
F950      ; [.9C3C.0020.0002.7E37] # CJK COMPATIBILITY IDEOGRAPH-F950
FA59      ; [.8A28.0020.0002.7E41] # CJK COMPATIBILITY IDEOGRAPH-FA59
2F970     ; [.C8A7.0020.0002.7E45] # CJK COMPATIBILITY IDEOGRAPH-2F970
FAB1      ; [.85D7.0020.0002.7F3E] # CJK COMPATIBILITY IDEOGRAPH-FAB1
FA5A      ; [.C20E.0020.0002.7F72] # CJK COMPATIBILITY IDEOGRAPH-FA5A
F9E6      ; [.97C3.0020.0002.7F79] # CJK COMPATIBILITY IDEOGRAPH-F9E6
2F976     ; [.BCA2.0020.0002.7F7A] # CJK COMPATIBILITY IDEOGRAPH-2F976
F90F      ; [.9B52.0020.0002.7F85] # CJK COMPATIBILITY IDEOGRAPH-F90F
2F978     ; [.D0D3.0020.0002.7F95] # CJK COMPATIBILITY IDEOGRAPH-2F978
F9AF      ; [.9A62.0020.0002.7F9A] # CJK COMPATIBILITY IDEOGRAPH-F9AF
FA1E      ; [.D47D.0020.0002.7FBD] # CJK COMPATIBILITY IDEOGRAPH-FA1E
2F979     ; [.CB06.0020.0002.7FFA] # CJK COMPATIBILITY IDEOGRAPH-2F979
F934      ; [.96B7.0020.0002.8001] # CJK COMPATIBILITY IDEOGRAPH-F934
FA5B      ; [.B856.0020.0002.8005] # CJK COMPATIBILITY IDEOGRAPH-FA5B
FAB2      ; [.B856.0020.0002.8005] # CJK COMPATIBILITY IDEOGRAPH-FAB2
2F97A     ; [.B856.0020.0002.8005] # CJK COMPATIBILITY IDEOGRAPH-2F97A
F9B0      ; [.9A64.0020.0002.8046] # CJK COMPATIBILITY IDEOGRAPH-F9B0
2F97D     ; [.85BA.0020.0002.8060] # CJK COMPATIBILITY IDEOGRAPH-2F97D
F997      ; [.9989.0020.0002.806F] # CJK COMPATIBILITY IDEOGRAPH-F997
2F97F     ; [.C7D5.0020.0002.8070] # CJK COMPATIBILITY IDEOGRAPH-2F97F
F945      ; [.9BF9.0020.0002.807E] # CJK COMPATIBILITY IDEOGRAPH-F945
F953      ; [.9600.0020.0002.808B] # CJK COMPATIBILITY IDEOGRAPH-F953
2F8D6     ; [.93E7.0020.0002.80AD] # CJK COMPATIBILITY IDEOGRAPH-2F8D6
2F982     ; [.D4B0.0020.0002.80B2] # CJK COMPATIBILITY IDEOGRAPH-2F982
2F983     ; [.C780.0020.0002.8103] # CJK COMPATIBILITY IDEOGRAPH-2F983
2F985     ; [.851D.0020.0002.813E] # CJK COMPATIBILITY IDEOGRAPH-2F985
F926      ; [.95F4.0020.0002.81D8] # CJK COMPATIBILITY IDEOGRAPH-F926
F9F6      ; [.99E7.0020.0002.81E8] # CJK COMPATIBILITY IDEOGRAPH-F9F6
FA5C      ; [.BCE6.0020.0002.81ED] # CJK COMPATIBILITY IDEOGRAPH-FA5C
2F893     ; [.D42F.0020.0002.8201] # CJK COMPATIBILITY IDEOGRAPH-2F893
2F98B     ; [.D42F.0020.0002.8201] # CJK COMPATIBILITY IDEOGRAPH-2F98B
2F98C     ; [.B23F.0020.0002.8204] # CJK COMPATIBILITY IDEOGRAPH-2F98C
FA6D      ; [.9F3F.0020.0002.8218] # CJK COMPATIBILITY IDEOGRAPH-FA6D
F97C      ; [.9A16.0020.0002.826F] # CJK COMPATIBILITY IDEOGRAPH-F97C
FA5D      ; [.C6CB.0020.0002.8279] # CJK COMPATIBILITY IDEOGRAPH-FA5D
FA5E      ; [.C6CB.0020.0002.8279] # CJK COMPATIBILITY IDEOGRAPH-FA5E
2F990     ; [.D4AD.0020.0002.828B] # CJK COMPATIBILITY IDEOGRAPH-2F990
2F98F     ; [.ADCA.0020.0002.8291] # CJK COMPATIBILITY IDEOGRAPH-2F98F
2F991     ; [.B6F7.0020.0002.829D] # CJK COMPATIBILITY IDEOGRAPH-2F991
2F993     ; [.A43F.0020.0002.82B1] # CJK COMPATIBILITY IDEOGRAPH-2F993
2F994     ; [.8AA5.0020.0002.82B3] # CJK COMPATIBILITY IDEOGRAPH-2F994
2F995     ; [.CD7E.0020.0002.82BD] # CJK COMPATIBILITY IDEOGRAPH-2F995
F974      ; [.C386.0020.0002.82E5] # CJK COMPATIBILITY IDEOGRAPH-F974
2F998     ; [.C386.0020.0002.82E5] # CJK COMPATIBILITY IDEOGRAPH-2F998
2F996     ; [.A0F5.0020.0002.82E6] # CJK COMPATIBILITY IDEOGRAPH-2F996
2F999     ; [.BC82.0020.0002.831D] # CJK COMPATIBILITY IDEOGRAPH-2F999
2F99C     ; [.D198.0020.0002.8323] # CJK COMPATIBILITY IDEOGRAPH-2F99C
F9FE      ; [.BC3C.0020.0002.8336] # CJK COMPATIBILITY IDEOGRAPH-F9FE
FAB3      ; [.A5F7.0020.0002.8352] # CJK COMPATIBILITY IDEOGRAPH-FAB3
2F9A0     ; [.85CF.0020.0002.8353] # CJK COMPATIBILITY IDEOGRAPH-2F9A0
2F99A     ; [.C3D3.0020.0002.8363] # CJK COMPATIBILITY IDEOGRAPH-2F99A
2F99B     ; [.A86D.0020.0002.83AD] # CJK COMPATIBILITY IDEOGRAPH-2F99B
2F99D     ; [.87E9.0020.0002.83BD] # CJK COMPATIBILITY IDEOGRAPH-2F99D
F93E      ; [.9B03.0020.0002.83C9] # CJK COMPATIBILITY IDEOGRAPH-F93E
2F9A1     ; [.ABC4.0020.0002.83CA] # CJK COMPATIBILITY IDEOGRAPH-2F9A1
2F9A2     ; [.ACE3.0020.0002.83CC] # CJK COMPATIBILITY IDEOGRAPH-2F9A2
2F9A3     ; [.C6B0.0020.0002.83DC] # CJK COMPATIBILITY IDEOGRAPH-2F9A3
2F99E     ; [.8DE0.0020.0002.83E7] # CJK COMPATIBILITY IDEOGRAPH-2F99E
FAB4      ; [.A44D.0020.0002.83EF] # CJK COMPATIBILITY IDEOGRAPH-FAB4
F958      ; [.9A69.0020.0002.83F1] # CJK COMPATIBILITY IDEOGRAPH-F958
F918      ; [.9B7C.0020.0002.843D] # CJK COMPATIBILITY IDEOGRAPH-F918
F96E      ; [.CDE9.0020.0002.8449] # CJK COMPATIBILITY IDEOGRAPH-F96E
FA5F      ; [.B86A.0020.0002.8457] # CJK COMPATIBILITY IDEOGRAPH-FA5F
2F99F     ; [.B86A.0020.0002.8457] # CJK COMPATIBILITY IDEOGRAPH-2F99F
F999      ; [.9980.0020.0002.84EE] # CJK COMPATIBILITY IDEOGRAPH-F999
2F9A8     ; [.85DC.0020.0002.84F1] # CJK COMPATIBILITY IDEOGRAPH-2F9A8
2F9A9     ; [.AA97.0020.0002.84F3] # CJK COMPATIBILITY IDEOGRAPH-2F9A9
F9C2      ; [.98FD.0020.0002.84FC] # CJK COMPATIBILITY IDEOGRAPH-F9C2
2F9AA     ; [.C74F.0020.0002.8516] # CJK COMPATIBILITY IDEOGRAPH-2F9AA
2F9AC     ; [.C399.0020.0002.8564] # CJK COMPATIBILITY IDEOGRAPH-2F9AC
F923      ; [.971B.0020.0002.85CD] # CJK COMPATIBILITY IDEOGRAPH-F923
F9F0      ; [.9A11.0020.0002.85FA] # CJK COMPATIBILITY IDEOGRAPH-F9F0
F935      ; [.9AC4.0020.0002.8606] # CJK COMPATIBILITY IDEOGRAPH-F935
FA20      ; [.AEF5.0020.0002.8612] # CJK COMPATIBILITY IDEOGRAPH-FA20
F91F      ; [.9728.0020.0002.862D] # CJK COMPATIBILITY IDEOGRAPH-F91F
F910      ; [.9B5D.0020.0002.863F] # CJK COMPATIBILITY IDEOGRAPH-F910
2F9B3     ; [.95D6.0020.0002.8650] # CJK COMPATIBILITY IDEOGRAPH-2F9B3
F936      ; [.9AD8.0020.0002.865C] # CJK COMPATIBILITY IDEOGRAPH-F936
2F9B4     ; [.9AD8.0020.0002.865C] # CJK COMPATIBILITY IDEOGRAPH-2F9B4
2F9B5     ; [.A14D.0020.0002.8667] # CJK COMPATIBILITY IDEOGRAPH-2F9B5
2F9B6     ; [.B256.0020.0002.8669] # CJK COMPATIBILITY IDEOGRAPH-2F9B6
2F9B8     ; [.AF15.0020.0002.8688] # CJK COMPATIBILITY IDEOGRAPH-2F9B8
2F9B7     ; [.BBB2.0020.0002.86A9] # CJK COMPATIBILITY IDEOGRAPH-2F9B7
2F9BA     ; [.85D9.0020.0002.86E2] # CJK COMPATIBILITY IDEOGRAPH-2F9BA
2F9B9     ; [.D57F.0020.0002.870E] # CJK COMPATIBILITY IDEOGRAPH-2F9B9
2F9BC     ; [.8E3B.0020.0002.8728] # CJK COMPATIBILITY IDEOGRAPH-2F9BC
2F9BD     ; [.BA44.0020.0002.876B] # CJK COMPATIBILITY IDEOGRAPH-2F9BD
FAB5      ; [.D5EE.0020.0002.8779] # CJK COMPATIBILITY IDEOGRAPH-FAB5
2F9BB     ; [.D5EE.0020.0002.8779] # CJK COMPATIBILITY IDEOGRAPH-2F9BB
2F9BE     ; [.C674.0020.0002.8786] # CJK COMPATIBILITY IDEOGRAPH-2F9BE
F911      ; [.9B51.0020.0002.87BA] # CJK COMPATIBILITY IDEOGRAPH-F911
2F9C0     ; [.9EFE.0020.0002.87E1] # CJK COMPATIBILITY IDEOGRAPH-2F9C0
2F9C1     ; [.B510.0020.0002.8801] # CJK COMPATIBILITY IDEOGRAPH-2F9C1
F927      ; [.95F9.0020.0002.881F] # CJK COMPATIBILITY IDEOGRAPH-F927
FA08      ; [.B543.0020.0002.884C] # CJK COMPATIBILITY IDEOGRAPH-FA08
2F9C3     ; [.BB4D.0020.0002.8860] # CJK COMPATIBILITY IDEOGRAPH-2F9C3
2F9C4     ; [.CBE0.0020.0002.8863] # CJK COMPATIBILITY IDEOGRAPH-2F9C4
F9A0      ; [.98B8.0020.0002.88C2] # CJK COMPATIBILITY IDEOGRAPH-F9A0
F9E7      ; [.97F6.0020.0002.88CF] # CJK COMPATIBILITY IDEOGRAPH-F9E7
2F9C6     ; [.9919.0020.0002.88D7] # CJK COMPATIBILITY IDEOGRAPH-2F9C6
2F9C7     ; [.C276.0020.0002.88DE] # CJK COMPATIBILITY IDEOGRAPH-2F9C7
F9E8      ; [.989C.0020.0002.88E1] # CJK COMPATIBILITY IDEOGRAPH-F9E8
F912      ; [.9B67.0020.0002.88F8] # CJK COMPATIBILITY IDEOGRAPH-F912
2F9C9     ; [.CF76.0020.0002.88FA] # CJK COMPATIBILITY IDEOGRAPH-2F9C9
FA60      ; [.A282.0020.0002.8910] # CJK COMPATIBILITY IDEOGRAPH-FA60
FAB6      ; [.B011.0020.0002.8941] # CJK COMPATIBILITY IDEOGRAPH-FAB6
F924      ; [.9724.0020.0002.8964] # CJK COMPATIBILITY IDEOGRAPH-F924
FAB7      ; [.8BFE.0020.0002.8986] # CJK COMPATIBILITY IDEOGRAPH-FAB7
FA0A      ; [.AA1C.0020.0002.898B] # CJK COMPATIBILITY IDEOGRAPH-FA0A
FA61      ; [.BFE1.0020.0002.8996] # CJK COMPATIBILITY IDEOGRAPH-FA61
FAB8      ; [.BFE1.0020.0002.8996] # CJK COMPATIBILITY IDEOGRAPH-FAB8
2F9CF     ; [.BE22.0020.0002.8AA0] # CJK COMPATIBILITY IDEOGRAPH-2F9CF
F96F      ; [.C24F.0020.0002.8AAA] # CJK COMPATIBILITY IDEOGRAPH-F96F
F9A1      ; [.C24F.0020.0002.8AAA] # CJK COMPATIBILITY IDEOGRAPH-F9A1
FAB9      ; [.8E75.0020.0002.8ABF] # CJK COMPATIBILITY IDEOGRAPH-FAB9
FABB      ; [.B047.0020.0002.8ACB] # CJK COMPATIBILITY IDEOGRAPH-FABB
F97D      ; [.9A3C.0020.0002.8AD2] # CJK COMPATIBILITY IDEOGRAPH-F97D
F941      ; [.9BCB.0020.0002.8AD6] # CJK COMPATIBILITY IDEOGRAPH-F941
FABE      ; [.D502.0020.0002.8AED] # CJK COMPATIBILITY IDEOGRAPH-FABE
2F9D0     ; [.D502.0020.0002.8AED] # CJK COMPATIBILITY IDEOGRAPH-2F9D0
FA22      ; [.BA48.0020.0002.8AF8] # CJK COMPATIBILITY IDEOGRAPH-FA22
FABA      ; [.BA48.0020.0002.8AF8] # CJK COMPATIBILITY IDEOGRAPH-FABA
F95D      ; [.95A4.0020.0002.8AFE] # CJK COMPATIBILITY IDEOGRAPH-F95D
FABD      ; [.95A4.0020.0002.8AFE] # CJK COMPATIBILITY IDEOGRAPH-FABD
FA62      ; [.CDF9.0020.0002.8B01] # CJK COMPATIBILITY IDEOGRAPH-FA62
FABC      ; [.CDF9.0020.0002.8B01] # CJK COMPATIBILITY IDEOGRAPH-FABC
FA63      ; [.AA9A.0020.0002.8B39] # CJK COMPATIBILITY IDEOGRAPH-FA63
FABF      ; [.AA9A.0020.0002.8B39] # CJK COMPATIBILITY IDEOGRAPH-FABF
F9FC      ; [.C017.0020.0002.8B58] # CJK COMPATIBILITY IDEOGRAPH-F9FC
F95A      ; [.8F10.0020.0002.8B80] # CJK COMPATIBILITY IDEOGRAPH-F95A
FAC0      ; [.831E.0020.0002.8B8A] # CJK COMPATIBILITY IDEOGRAPH-FAC0
2F9D1     ; [.831E.0020.0002.8B8A] # CJK COMPATIBILITY IDEOGRAPH-2F9D1
F900      ; [.ADCC.0020.0002.8C48] # CJK COMPATIBILITY IDEOGRAPH-F900
2F9D2     ; [.BFAB.0020.0002.8C55] # CJK COMPATIBILITY IDEOGRAPH-2F9D2
2F9D4     ; [.9F4B.0020.0002.8CAB] # CJK COMPATIBILITY IDEOGRAPH-2F9D4
2F9D5     ; [.8245.0020.0002.8CC1] # CJK COMPATIBILITY IDEOGRAPH-2F9D5
F948      ; [.9B0D.0020.0002.8CC2] # CJK COMPATIBILITY IDEOGRAPH-F948
F903      ; [.A822.0020.0002.8CC8] # CJK COMPATIBILITY IDEOGRAPH-F903
FA64      ; [.8331.0020.0002.8CD3] # CJK COMPATIBILITY IDEOGRAPH-FA64
FA65      ; [.C56B.0020.0002.8D08] # CJK COMPATIBILITY IDEOGRAPH-FA65
FAC1      ; [.C56B.0020.0002.8D08] # CJK COMPATIBILITY IDEOGRAPH-FAC1
2F9D6     ; [.9D8F.0020.0002.8D1B] # CJK COMPATIBILITY IDEOGRAPH-2F9D6
2F9D7     ; [.ADCD.0020.0002.8D77] # CJK COMPATIBILITY IDEOGRAPH-2F9D7
2F9DB     ; [.A9FA.0020.0002.8DBC] # CJK COMPATIBILITY IDEOGRAPH-2F9DB
2F9DA     ; [.8024.0020.0002.8DCB] # CJK COMPATIBILITY IDEOGRAPH-2F9DA
F937      ; [.9B0E.0020.0002.8DEF] # CJK COMPATIBILITY IDEOGRAPH-F937
2F9DC     ; [.8589.0020.0002.8DF0] # CJK COMPATIBILITY IDEOGRAPH-2F9DC
F902      ; [.BC58.0020.0002.8ECA] # CJK COMPATIBILITY IDEOGRAPH-F902
2F9DE     ; [.C321.0020.0002.8ED4] # CJK COMPATIBILITY IDEOGRAPH-2F9DE
F998      ; [.9549.0020.0002.8F26] # CJK COMPATIBILITY IDEOGRAPH-F998
F9D7      ; [.9BC2.0020.0002.8F2A] # CJK COMPATIBILITY IDEOGRAPH-F9D7
FAC2      ; [.C1FB.0020.0002.8F38] # CJK COMPATIBILITY IDEOGRAPH-FAC2
2F9DF     ; [.C1FB.0020.0002.8F38] # CJK COMPATIBILITY IDEOGRAPH-2F9DF
FA07      ; [.8B97.0020.0002.8F3B] # CJK COMPATIBILITY IDEOGRAPH-FA07
F98D      ; [.988A.0020.0002.8F62] # CJK COMPATIBILITY IDEOGRAPH-F98D
2F98D     ; [.C64B.0020.0002.8F9E] # CJK COMPATIBILITY IDEOGRAPH-2F98D
F971      ; [.BD5F.0020.0002.8FB0] # CJK COMPATIBILITY IDEOGRAPH-F971
FA66      ; [.BE9F.0020.0002.8FB6] # CJK COMPATIBILITY IDEOGRAPH-FA66
F99A      ; [.996B.0020.0002.9023] # CJK COMPATIBILITY IDEOGRAPH-F99A
FA25      ; [.CCEA.0020.0002.9038] # CJK COMPATIBILITY IDEOGRAPH-FA25
FA67      ; [.CCEA.0020.0002.9038] # CJK COMPATIBILITY IDEOGRAPH-FA67
FAC3      ; [.BBE0.0020.0002.9072] # CJK COMPATIBILITY IDEOGRAPH-FAC3
F9C3      ; [.98E6.0020.0002.907C] # CJK COMPATIBILITY IDEOGRAPH-F9C3
F913      ; [.9B5E.0020.0002.908F] # CJK COMPATIBILITY IDEOGRAPH-F913
2F9E2     ; [.ADC4.0020.0002.9094] # CJK COMPATIBILITY IDEOGRAPH-2F9E2
F92C      ; [.975C.0020.0002.90CE] # CJK COMPATIBILITY IDEOGRAPH-F92C
FA2E      ; [.975F.0020.0002.90DE] # CJK COMPATIBILITY IDEOGRAPH-FA2E
2F9E3     ; [.85CC.0020.0002.90F1] # CJK COMPATIBILITY IDEOGRAPH-2F9E3
FA26      ; [.8CC2.0020.0002.90FD] # CJK COMPATIBILITY IDEOGRAPH-FA26
2F9E4     ; [.C423.0020.0002.9111] # CJK COMPATIBILITY IDEOGRAPH-2F9E4
2F9E6     ; [.BC9D.0020.0002.911B] # CJK COMPATIBILITY IDEOGRAPH-2F9E6
F919      ; [.96C8.0020.0002.916A] # CJK COMPATIBILITY IDEOGRAPH-F919
FAC4      ; [.C8CB.0020.0002.9199] # CJK COMPATIBILITY IDEOGRAPH-FAC4
F9B7      ; [.97FF.0020.0002.91B4] # CJK COMPATIBILITY IDEOGRAPH-F9B7
F9E9      ; [.97EB.0020.0002.91CC] # CJK COMPATIBILITY IDEOGRAPH-F9E9
F97E      ; [.9A3A.0020.0002.91CF] # CJK COMPATIBILITY IDEOGRAPH-F97E
F90A      ; [.AA72.0020.0002.91D1] # CJK COMPATIBILITY IDEOGRAPH-F90A
F9B1      ; [.9A6E.0020.0002.9234] # CJK COMPATIBILITY IDEOGRAPH-F9B1
2F9E7     ; [.8086.0020.0002.9238] # CJK COMPATIBILITY IDEOGRAPH-2F9E7
FAC5      ; [.B553.0020.0002.9276] # CJK COMPATIBILITY IDEOGRAPH-FAC5
2F9EA     ; [.8369.0020.0002.927C] # CJK COMPATIBILITY IDEOGRAPH-2F9EA
2F9E8     ; [.B62C.0020.0002.92D7] # CJK COMPATIBILITY IDEOGRAPH-2F9E8
2F9E9     ; [.A455.0020.0002.92D8] # CJK COMPATIBILITY IDEOGRAPH-2F9E9
F93F      ; [.9B23.0020.0002.9304] # CJK COMPATIBILITY IDEOGRAPH-F93F
F99B      ; [.99BE.0020.0002.934A] # CJK COMPATIBILITY IDEOGRAPH-F99B
2F9EB     ; [.B013.0020.0002.93F9] # CJK COMPATIBILITY IDEOGRAPH-2F9EB
2F9EC     ; [.C516.0020.0002.9415] # CJK COMPATIBILITY IDEOGRAPH-2F9EC
2F9EE     ; [.A032.0020.0002.958B] # CJK COMPATIBILITY IDEOGRAPH-2F9EE
F986      ; [.9C1F.0020.0002.95AD] # CJK COMPATIBILITY IDEOGRAPH-F986
2F9F0     ; [.C083.0020.0002.95B7] # CJK COMPATIBILITY IDEOGRAPH-2F9F0
F9C6      ; [.C3B3.0020.0002.962E] # CJK COMPATIBILITY IDEOGRAPH-F9C6
F951      ; [.96FA.0020.0002.964B] # CJK COMPATIBILITY IDEOGRAPH-F951
FA09      ; [.AB03.0020.0002.964D] # CJK COMPATIBILITY IDEOGRAPH-FA09
F959      ; [.9A68.0020.0002.9675] # CJK COMPATIBILITY IDEOGRAPH-F959
F9D3      ; [.9AFC.0020.0002.9678] # CJK COMPATIBILITY IDEOGRAPH-F9D3
FAC6      ; [.BA71.0020.0002.967C] # CJK COMPATIBILITY IDEOGRAPH-FAC6
F9DC      ; [.9BDC.0020.0002.9686] # CJK COMPATIBILITY IDEOGRAPH-F9DC
F9F1      ; [.99DD.0020.0002.96A3] # CJK COMPATIBILITY IDEOGRAPH-F9F1
FA2F      ; [.9859.0020.0002.96B7] # CJK COMPATIBILITY IDEOGRAPH-FA2F
F9B8      ; [.985F.0020.0002.96B8] # CJK COMPATIBILITY IDEOGRAPH-F9B8
2F9F3     ; [.AF18.0020.0002.96C3] # CJK COMPATIBILITY IDEOGRAPH-2F9F3
F9EA      ; [.97D0.0020.0002.96E2] # CJK COMPATIBILITY IDEOGRAPH-F9EA
FA68      ; [.9467.0020.0002.96E3] # CJK COMPATIBILITY IDEOGRAPH-FA68
FAC7      ; [.9467.0020.0002.96E3] # CJK COMPATIBILITY IDEOGRAPH-FAC7
F9B2      ; [.9A70.0020.0002.96F6] # CJK COMPATIBILITY IDEOGRAPH-F9B2
F949      ; [.964D.0020.0002.96F7] # CJK COMPATIBILITY IDEOGRAPH-F949
2F9F5     ; [.D625.0020.0002.9723] # CJK COMPATIBILITY IDEOGRAPH-2F9F5
F938      ; [.9B37.0020.0002.9732] # CJK COMPATIBILITY IDEOGRAPH-F938
F9B3      ; [.9A8D.0020.0002.9748] # CJK COMPATIBILITY IDEOGRAPH-F9B3
FA1C      ; [.AB77.0020.0002.9756] # CJK COMPATIBILITY IDEOGRAPH-FA1C
FAC8      ; [.AB77.0020.0002.9756] # CJK COMPATIBILITY IDEOGRAPH-FAC8
FAC9      ; [.80D4.0020.0002.97DB] # CJK COMPATIBILITY IDEOGRAPH-FAC9
2F9FA     ; [.8286.0020.0002.97E0] # CJK COMPATIBILITY IDEOGRAPH-2F9FA
FA69      ; [.B512.0020.0002.97FF] # CJK COMPATIBILITY IDEOGRAPH-FA69
FACA      ; [.B512.0020.0002.97FF] # CJK COMPATIBILITY IDEOGRAPH-FACA
FACB      ; [.CA47.0020.0002.980B] # CJK COMPATIBILITY IDEOGRAPH-FACB
2F9FE     ; [.CA47.0020.0002.980B] # CJK COMPATIBILITY IDEOGRAPH-2F9FE
2F9FF     ; [.CA47.0020.0002.980B] # CJK COMPATIBILITY IDEOGRAPH-2F9FF
F9B4      ; [.9A99.0020.0002.9818] # CJK COMPATIBILITY IDEOGRAPH-F9B4
2FA00     ; [.85BD.0020.0002.9829] # CJK COMPATIBILITY IDEOGRAPH-2FA00
FA6A      ; [.85A6.0020.0002.983B] # CJK COMPATIBILITY IDEOGRAPH-FA6A
FACC      ; [.85A6.0020.0002.983B] # CJK COMPATIBILITY IDEOGRAPH-FACC
F9D0      ; [.9693.0020.0002.985E] # CJK COMPATIBILITY IDEOGRAPH-F9D0
2FA02     ; [.A6B2.0020.0002.98E2] # CJK COMPATIBILITY IDEOGRAPH-2FA02
FA2A      ; [.8A4D.0020.0002.98EF] # CJK COMPATIBILITY IDEOGRAPH-FA2A
FA2B      ; [.C84E.0020.0002.98FC] # CJK COMPATIBILITY IDEOGRAPH-FA2B
FA2C      ; [.9F41.0020.0002.9928] # CJK COMPATIBILITY IDEOGRAPH-FA2C
2FA04     ; [.CA8F.0020.0002.9929] # CJK COMPATIBILITY IDEOGRAPH-2FA04
2FA05     ; [.D5F2.0020.0002.99A7] # CJK COMPATIBILITY IDEOGRAPH-2FA05
2FA06     ; [.813C.0020.0002.99C2] # CJK COMPATIBILITY IDEOGRAPH-2FA06
F91A      ; [.9B82.0020.0002.99F1] # CJK COMPATIBILITY IDEOGRAPH-F91A
2FA07     ; [.9361.0020.0002.99FE] # CJK COMPATIBILITY IDEOGRAPH-2FA07
F987      ; [.97E7.0020.0002.9A6A] # CJK COMPATIBILITY IDEOGRAPH-F987
FACD      ; [.B997.0020.0002.9B12] # CJK COMPATIBILITY IDEOGRAPH-FACD
2FA0A     ; [.B997.0020.0002.9B12] # CJK COMPATIBILITY IDEOGRAPH-2FA0A
F939      ; [.9ADD.0020.0002.9B6F] # CJK COMPATIBILITY IDEOGRAPH-F939
2FA0B     ; [.A7C3.0020.0002.9C40] # CJK COMPATIBILITY IDEOGRAPH-2FA0B
F9F2      ; [.99F1.0020.0002.9C57] # CJK COMPATIBILITY IDEOGRAPH-F9F2
2FA0C     ; [.A9BB.0020.0002.9CFD] # CJK COMPATIBILITY IDEOGRAPH-2FA0C
2FA0F     ; [.8528.0020.0002.9D67] # CJK COMPATIBILITY IDEOGRAPH-2FA0F
FA2D      ; [.A28C.0020.0002.9DB4] # CJK COMPATIBILITY IDEOGRAPH-FA2D
F93A      ; [.9B3A.0020.0002.9DFA] # CJK COMPATIBILITY IDEOGRAPH-F93A
F920      ; [.9BA4.0020.0002.9E1E] # CJK COMPATIBILITY IDEOGRAPH-F920
F940      ; [.9AFD.0020.0002.9E7F] # CJK COMPATIBILITY IDEOGRAPH-F940
F988      ; [.9871.0020.0002.9E97] # CJK COMPATIBILITY IDEOGRAPH-F988
F9F3      ; [.99F2.0020.0002.9E9F] # CJK COMPATIBILITY IDEOGRAPH-F9F3
2FA15     ; [.862D.0020.0002.9EBB] # CJK COMPATIBILITY IDEOGRAPH-2FA15
F989      ; [.97C2.0020.0002.9ECE] # CJK COMPATIBILITY IDEOGRAPH-F989
2FA17     ; [.B762.0020.0002.9EF9] # CJK COMPATIBILITY IDEOGRAPH-2FA17
2FA18     ; [.88D4.0020.0002.9EFE] # CJK COMPATIBILITY IDEOGRAPH-2FA18
2FA19     ; [.B715.0020.0002.9F05] # CJK COMPATIBILITY IDEOGRAPH-2FA19
2FA1A     ; [.8885.0020.0002.9F0F] # CJK COMPATIBILITY IDEOGRAPH-2FA1A
2FA1B     ; [.8A85.0020.0002.9F16] # CJK COMPATIBILITY IDEOGRAPH-2FA1B
2FA1C     ; [.81FB.0020.0002.9F3B] # CJK COMPATIBILITY IDEOGRAPH-2FA1C
FAD8      ; [.CA9A.0020.0002.9F43] # CJK COMPATIBILITY IDEOGRAPH-FAD8
F9C4      ; [.9BE4.0020.0002.9F8D] # CJK COMPATIBILITY IDEOGRAPH-F9C4
FAD9      ; [.8497.0020.0002.9F8E] # CJK COMPATIBILITY IDEOGRAPH-FAD9
F907      ; [.9ED7.0020.0002.9F9C] # CJK COMPATIBILITY IDEOGRAPH-F907
F908      ; [.9ED7.0020.0002.9F9C] # CJK COMPATIBILITY IDEOGRAPH-F908
FACE      ; [.9ED7.0020.0002.9F9C] # CJK COMPATIBILITY IDEOGRAPH-FACE
2F81F     ; [.8505.0020.0002.34DF] # CJK COMPATIBILITY IDEOGRAPH-2F81F
2F888     ; [.87AA.0020.0002.3862] # CJK COMPATIBILITY IDEOGRAPH-2F888
2F8D0     ; [.D37C.0020.0002.3B08] # CJK COMPATIBILITY IDEOGRAPH-2F8D0
2F8CE     ; [.D2E0.0020.0002.3B19] # CJK COMPATIBILITY IDEOGRAPH-2F8CE
2F8DE     ; [.A447.0020.0002.3B49] # CJK COMPATIBILITY IDEOGRAPH-2F8DE
2F8EE     ; [.CC56.0020.0002.3C18] # CJK COMPATIBILITY IDEOGRAPH-2F8EE
2F90A     ; [.9C08.0020.0002.3D33] # CJK COMPATIBILITY IDEOGRAPH-2F90A
2F92C     ; [.85CD.0020.0002.3EB8] # CJK COMPATIBILITY IDEOGRAPH-2F92C
2F92D     ; [.85CD.0020.0002.3EB8] # CJK COMPATIBILITY IDEOGRAPH-2F92D
FAD4      ; [.A871.0020.0002.4039] # CJK COMPATIBILITY IDEOGRAPH-FAD4
2F949     ; [.A871.0020.0002.4039] # CJK COMPATIBILITY IDEOGRAPH-2F949
2F960     ; [.85E0.0020.0002.4202] # CJK COMPATIBILITY IDEOGRAPH-2F960
2F96D     ; [.CE1D.0020.0002.4301] # CJK COMPATIBILITY IDEOGRAPH-2F96D
2F8D7     ; [.9118.0020.0002.43D9] # CJK COMPATIBILITY IDEOGRAPH-2F8D7
2FA0E     ; [.A746.0020.0002.4CED] # CJK COMPATIBILITY IDEOGRAPH-2FA0E
ENTRY
};
