# Generated by default/object.tt
package Paws::Kendra::ServiceNowKnowledgeArticleConfiguration;
  use Moose;
  has CrawlAttachments => (is => 'ro', isa => 'Bool');
  has DocumentDataFieldName => (is => 'ro', isa => 'Str', required => 1);
  has DocumentTitleFieldName => (is => 'ro', isa => 'Str');
  has ExcludeAttachmentFilePatterns => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has FieldMappings => (is => 'ro', isa => 'ArrayRef[Paws::Kendra::DataSourceToIndexFieldMapping]');
  has FilterQuery => (is => 'ro', isa => 'Str');
  has IncludeAttachmentFilePatterns => (is => 'ro', isa => 'ArrayRef[Str|Undef]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Kendra::ServiceNowKnowledgeArticleConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Kendra::ServiceNowKnowledgeArticleConfiguration object:

  $service_obj->Method(Att1 => { CrawlAttachments => $value, ..., IncludeAttachmentFilePatterns => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Kendra::ServiceNowKnowledgeArticleConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->CrawlAttachments

=head1 DESCRIPTION

Provides configuration information for crawling knowledge articles in
the ServiceNow site.

=head1 ATTRIBUTES


=head2 CrawlAttachments => Bool

Indicates whether Amazon Kendra should index attachments to knowledge
articles.


=head2 B<REQUIRED> DocumentDataFieldName => Str

The name of the ServiceNow field that is mapped to the index document
contents field in the Amazon Kendra index.


=head2 DocumentTitleFieldName => Str

The name of the ServiceNow field that is mapped to the index document
title field.


=head2 ExcludeAttachmentFilePatterns => ArrayRef[Str|Undef]

List of regular expressions applied to knowledge articles. Items that
don't match the inclusion pattern are not indexed. The regex is applied
to the field specified in the C<PatternTargetField>


=head2 FieldMappings => ArrayRef[L<Paws::Kendra::DataSourceToIndexFieldMapping>]

Mapping between ServiceNow fields and Amazon Kendra index fields. You
must create the index field before you map the field.


=head2 FilterQuery => Str

A query that selects the knowledge articles to index. The query can
return articles from multiple knowledge bases, and the knowledge bases
can be public or private.

The query string must be one generated by the ServiceNow console. For
more information, see Specifying documents to index with a query
(https://docs.aws.amazon.com/kendra/latest/dg/servicenow-query.html).


=head2 IncludeAttachmentFilePatterns => ArrayRef[Str|Undef]

List of regular expressions applied to knowledge articles. Items that
don't match the inclusion pattern are not indexed. The regex is applied
to the field specified in the C<PatternTargetField>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Kendra>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

