#!perl -w

use strict;
use warnings;

=head1 NAME

passwd_keyring

=head1 SYNOPSIS

   passwd_keyring configure

   passwd_keyring set-password --group=PwdGroup blahblah.com

   passwd_keyring set-password --group=PwdGroup --backend=Gnome  blahblah.com

   passwd_keyring clear-password --group=PwdGroup blahblah.com

=head1 DESCRIPTION

Helper tool for L<Passwd::Keyring::Auto>, making it easier for the user to configure
his or her preferences and to manage saved passwords.

=head1 COMMANDS

=head2 configure

Asks a few questions and saves configuration file (with keyring
preference rules) according to the user replies.

=head2 set-password

Sets (or changes) password for given site in given password group.

If backend parameter is given, uses this very backend, otherwise picks one just like
L<Passwd::Keyring::Auto> does.

=head2 clear-password

Removes password for given site in given password group.

If backend parameter is given, uses this very backend, otherwise picks one just like
L<Passwd::Keyring::Auto> does.

=cut

die "Unfortunately passwd_keyring script is not yet implemented\n";
