package Test::AutomationFramework; 
use 5.010001;
use strict;
use warnings;
use Date::Manip;
use File::Path;
use Getopt::Long;
use File::Copy;
use File::Copy::Recursive qw(fcopy rcopy dircopy fmove rmove dirmove);
use File::Find;
use File::Which;
use Regexp::Assemble;
use Cwd;
use IO::Socket;			# might not work in http mode
use Scalar::Util qw(looks_like_number);
use HTML::Entities;
use LWP::Simple;
use Archive::Extract;
use Archive::Zip  qw( :ERROR_CODES :CONSTANTS ) ;
use threads;
use threads::shared;


use Win32::OLE qw(in with);			# this is for window version ? 
use Win32::OLE::Const 'Microsoft Excel';	

#if ($^O  =~ /win32/i) { use Term::ReadKey; }
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);
$| = 1;
require Exporter;
our @ISA = qw(Exporter);
our %EXPORT_TAGS = ( 'all' => [ qw(
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );
our @EXPORT = qw(
help
processTCs
processTC
processProperty
genDriver_taf_pl
genDriver_taf_cgi
genDriver_taf_svr
initTAF
resetTAFLocation
resetTAF
printVersion
printTAFVersion
printOSVersion
fetchmail
installTestbed
deleteTestbed
refreshHost
refreshTS
generateTAF
spawnTAF
updateTestSuitPropertyRootNoUse
updateTestSuitPropertyRootUse
webUIStyleColorHide
webUIStyleColorHideNo
generateSeleniumTS
);


our $VERSION = '0.060.05g';   	

###################### TAF Global Variables ###############################
	my %tsProperty			; my %tsPropertyRoot; my %tafProperty	; my %tafPropertyRev; my $propertyOp='';	my $regression=0; my $help=0; my $sleep4Display = 1; my $notUsegetTCName= 0; my %recordTags=();
	my $tcIdCtr=0			; my $tsDriver = "null" ;	 				# cmd-line-overwrite $testDriverName (generated by -e .. index.pl or index.ps1)
 	my $pr2Screen = 1		; my $tcIdMin= 0	; my $reportHtmlSummaryStr = ''; 	# String for mouse-over display TC summary
	my $Execution_24_7	= "n";
	my $Execution_24_7_title= "y";
	my $Execution_local_only= "n";
	my $Execution_from_cgi  = "n";
	my $NofExecution	= "1"; my $NofExecutionCtr=0; my $NofExecutionCtrExec=0;
	my $ExecutionLength	= "10000 hour";
	my $ExecutionType 	= '>'; 
	my @tcDesc;		 my $tsFilter=".*";
	my $exitTAFTCId		;
	my $tcComment1		="Comment1";
	my $tcComment2		="PlaceHolderforComment2";
	my $message             = '';
	my $automationRequest   = '';
	my $MaxTCExecTime 	= 10	; 
	my $NofPropertyExecCtr	= 0	;
	my $NofPropertyExec     = 0	;
	my $tags		="_full_,_smoke_,_smoketest_,_regression_,_regressiontest_,_bat_,_32bit_,_64bit_,_list_,_load_,_erase_,_install_";
	my $TSHookIsPerl	= "n";
	my $outputFormat	= "text"; 	# noOutput
	my $htmlRefreshRate     = 200;
	my $htmlRefreshRateWebUI= 200;
	my $htmlRefreshRateLogUI= 200;
	my $createOrAppendTS    = "create"; 	#"append";	# create
	my $outputPause 	= 0;
	my $titleStatus		= "";
	my $perl 		= $^X;  $perl =~ s/\\/\\\//g;	 # todo3 \\ linux
	my $perl_ 		= $^X; $perl_=~ s/\\/\//g;	 # todo3 \\
	my $listAll_var		="";
	my $simulatedResults	="";
	my @simulatedResults;
	my %simulatedResults;
	my $tc_comment;
	my $tc_stdout;
###################### TAF Generated Variables ###############################
	my $scriptName 			= $0; $scriptName =~ s/\\/\//g;  # linux
	my $workingDir			= getcwd(); 
	my $TSDescName 			= "index.txt";
	my $TSHookName 			= "index.pl";
	my $TSHookNameParent 		= "indexindex.pl";
	my $TSHookNameGenerated 	= "index.pl";
	my $createTS_index		= "createTS_index.pl";
	my $createTS_indexindex		= "createTS_indexindex.pl";
	my $TSDescFName			= "index.txt";
###################### TAF Default Variables ###############################
	my $overWriteTC			= "y";
	my $interact 			= "n";

	my $tcPropertyPatternName 	= "tcRunResult";
	my $tcPropertyPatternPattern 	= ".*"; 
	my $tcPropertyPatternName1 	= "tcRunResult";
	my $tcPropertyPatternPattern1 	= ".*"; 
	my $tcPropertyPatternName2 	= "tcRunResult";
	my $tcPropertyPatternPattern2 	= ".*"; 
	my $tcPropertyPatternName3 	= "tcRunResult";
	my $tcPropertyPatternPattern3	= ".*"; 
	my $tcPropertyName 		= "all";
	my $tcPropertyPattern		= Regexp::Assemble->new; 
	my $tcNamePattern		= "TC*"; 		
	my $tcOp			= 'list';	
	my $tcCtr  			= 0;
	my $tcDelta			= 20;	
	my $tcFrom			= "";
	my $markSymbol			= '|';
	my $cgi_bin  			= "";					if ( $^O =~ /MSWin32/ ) {; } elsif ($^O =~ /linux/i) { $cgi_bin = "" ;		}
	my $c				= "c:"; 				if ( $^O =~ /MSWin32/ ) {; } elsif ($^O =~ /linux/i) { $c= "/tmp/var/www/cgi-bin" ;	}
	my $ping			= "C:/Windows/System32/ping.exe -n 1 "; if ( $^O =~ /MSWin32/ ) {; } elsif ($^O =~ /linux/i) { $ping = "/bin/ping -c 1 " ;	}
	my $deli			= ";"; 					if ( $^O =~ /MSWin32/ ) {; } elsif ($^O =~ /linux/i) { $deli = '~' ;			}
	my $copy			= "copy"; 				if ( $^O =~ /MSWin32/ ) {; } elsif ($^O =~ /linux/i) { $copy= 'copy' ;			}
	my $http_port			= ":8080";				if ( $^O =~ /MSWin32/ ) {; } elsif ($^O =~ /linux/i) { $http_port= ":1234" ;		}
	my $http_port_IIS		= ":18080";				if ( $^O =~ /MSWin32/ ) {; } elsif ($^O =~ /linux/i) { $http_port= ":1234" ;		}
	my $_realSemi_			= ";";					if ( $^O =~ /MSWin32/ ) {; } elsif ($^O =~ /linux/i) { $_realSemi_ = '&' ;		}	
	my $http_port_mime		= ":18080"; 
	my $http_port_exec		= ":8080"; 
	my $taf				= "taf.pl";
	my $taf_txt			= "taf.htm";
	my $tafCGI			= "taf.cgi";
	my $SUTSymbol			= "_";
	my $tsFilterDefault 		= "_";
	my $tcFilterDefault 		= ".*";
	my $_ZippedTS			= "_ZippedTS";
	my $_UploadedTS			= "_UploadedTS";
	my $TaaS			= "TaaS";
	my $_TAF			= "_TAF";				# very useful variable 
	my $NofTCinTSTemplate  		= -1;					# very useful variable 
	my $NofTSinTSTemplate  		= 1;					# very useful variable 
	my $index_pl_arguments 		= "";					
	my $manual_result     		= "";					
	my $manual_results     		= "";					
	my $comment2            	= "";					
	my $SvrDrive 			= $c.'/'.$_TAF; 			# *:will be reset later in generated variable section
	my $SvrProjName 		= '_testsuite1_'; 
	my $SvrProjNameSub 		= ''; 
	my $SvrTCName 			= '_testcase1_';
	my $SvrTCNamePattern 		= "*"; 
	my $SvrPropNamePattern 		= '.*';
	my $SvrPropValuePattern 	= ".*";

	my $SvrTCNameExecPattern 	= ".".$SvrTCNamePattern;  		# * 
	my $SvrLogDir 			= ''.$SvrProjName.''; 			# * 
	my $ps1_args 			= "-ps1_args___powershell_args";  	# should not include -ps1_args 
	my $exitTAFGracefullyLock   	= $c.'/'.$_TAF.'/'."_exitTAFGracefully_.txt"; # *
	my $exitTAFGracefullyString	= 1;
	my $performanceMode		= "slow4webUI"; 			# fast4cmd
 	my $executionMode  		= "testcase"; 			# fast4cmd
	my $generateTestsuiteBAT	= $c.'/'.$_TAF."/taf_generateTestsuite.bat"; 	# *
	my $tsFrom			="";
	my $tsTo   			="";
	my $resetTSFileName		="";
	my $externalLogName		="$c/$_TAF/externalLog.txt";		# *
	my $_cmdLogs_txt   		= "_cmdLogs.htm";
	my $commandLogName		="$c/$_TAF/$_cmdLogs_txt";		# *
	my $_tafGlobalVars_txt		="_tafGlobalVars.htm"	;
	my $commandLogLifeSpan		= "-3 days";
	my $queueSizeLimit		= 10000;
	my $formatResult		= "n";
	my $blocking_time 		= 5000000 ;  # in sec
	my $NofExec			= 1;
	my $text_delimiter = "\t"; 
	
	my $main_css			=<<EOFSummary_dot;
<link rel='stylesheet' href="/main.css" type='text/css' media='all' />
EOFSummary_dot
	my $main_css_raw		= '<link rel=\'stylesheet\' href=\"/main.css\" type=\'text/css\' media=\'all\' />';
###################### TAF WebUI Default Settings ###############################


	my $webUIStyleColorHide		= "#CEF6F5";
	   $webUIStyleColorHide		= "#A9A9A9";
	#my $webUIStyleColorHide		= "#FFFFFF";
	#my $webUIStyleColorHide		= "#808080";
	#my $webUIStyleColor   		= "style=\"color:$webUIStyleColorHide\"";	# redefined from _tafGlobal.txt 	css  CSS
	my $webUIStyleColor   		= ""; 
	my $webUITreeViewLevel		= 20;
	my $main_cmd_width		= 20;
	my $excelReportColumnWidth 	= 9; 
	my $AutomationtsName		="Automation_MVSDK";
 	my $makeMark			= 'n'; my $makeMarkComment		= '';
 	my $makeMarkLastDay		= &getExecDay();
	my $web_ui_title		="Test Automation Framework"; 
	my $webUI_TCDescWidth 		= 120; 					# <<<<<<<<<<<<<<
	my $scrollAmount		= 0; 
	my $borderWidth			= 0; 
	my $borderStyle			= "SOLID"; 
	my $passFailDisplayWidth	= 8;					# TS Variable. Should be reset for each TS execution 
	my $maxPassFailDisplayWidth	= 40; 
	my $reportHtmlSummaryScale 	= 3600; 				# in seconds
	my $reportHtmlSummaryScaleMajor = 12; 					# in seconds
	#my $tsProperty_txt		= 'tsProperty.txt';
	my $tsProperty_txt		= 'tsProperty.htm';
	my $tsPropertyWidth		= 150;					# <<<<<<<<<<<<<<<<<
	my $testcaseNode		= "testcase"	; 			
	my $testType    		= "ts";					# ts for testsuite
	my $reportHtml  		= 'index.htm';
	my $reportHtml1 		= '_tcReport_.html';
	my $reportHtmlHistory		= '_tcReportHistory_.html';
	my $reportHtmlSummary   	= '_tcReportSummary_.html';
	my $reportHtmlSummaryDot 	= '_tcReportSummaryDot_.html';
	my $topPanelHtml		= '_topPanelHtml.htm';
	my $tc_pl			= "tc.pl";
	my $tc_args			= "tc_args.txt";
	my $tc_vali			= "tc_vali.txt";
	my $tc_cgi			= "tc.cgi";
	my $codeWidth			=180		;			# used for the tsDriver code format
	my $reportHtml_http  		= 'index_http.htm'; 			# $reportHtml."_http";
	my $index_http_htm		= $reportHtml_http;
	my $reportHtml1_http 		= '_tcReport_.html'."_http";
	my $reportHtmlHistory_http	= '_tcReportHistory_.html'."_http";



	my $web_ui_title_tip 		= "Run TAF-Team Version based on IIS/httpd";
	my $hostname 			= "localhost";
	my $ip 				= "127.0.0.1";


 	if (1 == 1) {			# manually modify it for demo mode
 	my $rst 			= `$ping $hostname`; 
  	if    ($rst =~ /Ping request could not/i) { $web_ui_title_tip = "Click to update every TAF testsuites";}
  	elsif ($rst  =~ /unknown/i)                { $web_ui_title_tip = "Click to update every TAF testsuites";}
  	else {
  		$hostname 		= `hostname`; chop $hostname; 
  		$ip			= inet_ntoa((gethostbyname($hostname))[4]);
  	}
 	}

	# $ip = $hostname			; # avoid to use IP address 
	# to handel AWS private and publich ip	Temporal Solution
	if ( -e 'C:\Program Files\Amazon\Ec2ConfigService') { my $aws_http_publicIP = 'http://169.254.169.254/latest/meta-data/public-ipv4'; $ip= get( 'http://169.254.169.254/latest/meta-data/public-ipv4') or die 'Unable to get page'; }
	if ( -e "$c/$_TAF" ) 		{;} else { mkpath "$c/$_TAF"; }
	if ( -e "$c/$_TAF/$_ZippedTS" ) {;} else { mkpath "$c/$_TAF/$_ZippedTS"; open Ftmp, "> $c/$_TAF/$_ZippedTS/_placeHolder_.zip"; close Ftmp; }
	if ( -e "$c/$_TAF/$_UploadedTS" ) {;} else { mkpath "$c/$_TAF/$_UploadedTS"; open Ftmp, "> $c/$_TAF/$_UploadedTS/_placeHolder_.zip"; close Ftmp;}

	my $queueFName 			= "taf.queue.htm";
	my $queueFName_active 		= "taf.queue.active.htm";
	if (-e "$c/$_TAF/$_tafGlobalVars_txt") { &readTAFGlobalVars(); } else { &printTAFGlobalVars(); &addHtmlToolBar("$c/$_TAF/$_tafGlobalVars_txt","Default Settings");}  # Global Variables 
	if ( -e 'C:\Program Files\Amazon\Ec2ConfigService') { my $aws_http_publicIP = 'http://169.254.169.254/latest/meta-data/public-ipv4'; $ip= get( 'http://169.254.169.254/latest/meta-data/public-ipv4') or die 'Unable to get page'; }

	my $ruby		= which('ruby'); 
	my $gcc			= which('gcc');
	my $c_plusplus		= which('c++');
	my $g_plusplus		= which('g++');
	my $java		= which('java');
	my $javac		= which('javac');
	my $csc   		= which('csc');
	my $autoit		= which('autoit3');
	my $jmeter		= which('jmeter.bat');
	my $apacheBench		= which('ab');
	my $jmeter_bat     	= which('jmeter.bat');

	my $jmeter_url		= "apache.apache.org";


if ( -e "$c/$_TAF/_cmdPath.txt"	) {;} else {

	$ruby 		=~ s/\\/\//g;
	$gcc 		=~ s/\\/\//g;
	$c_plusplus 	=~ s/\\/\//g;
	$g_plusplus 	=~ s/\\/\//g;
	$java 		=~ s/\\/\//g;
	$javac 		=~ s/\\/\//g;
	$csc   		=~ s/\\/\//g;
	$autoit		=~ s/\\/\//g;
	$jmeter 	=~ s/\\/\//g;
	$apacheBench	=~ s/\\/\//g;

	open FoutPath, "> $c/$_TAF/_cmdPath.txt";
print FoutPath<<EOF_path;	

	\$ruby		= "$ruby";
	\$gcc		= "$gcc";
	\$c_plusplus		= "$c_plusplus";
	\$g_plusplus		= "$g_plusplus";
	\$java		= "$java";
	\$javac		= "$javac";
	\$csc  		= "$csc";
	\$autoit	= "$autoit";
	\$jmeter	= "$jmeter";
	\$apacheBench	= "$apacheBench";
	\$jmeter_bat	= "$jmeter_bat";

EOF_path
	close FoutPath;
	print " -> $c/$_TAF/_cmdPath.txt\n";
}

##### manual modification from c:\_TAF\_cmdPath.txt 
#
#


	$ruby		= "C:/Ruby21-x64/bin/ruby.EXE";
	$gcc		= "C:/strawberry/c/bin/gcc.EXE";
	$c_plusplus		= "C:/strawberry/c/bin/c++.EXE";
	$g_plusplus		= "C:/strawberry/c/bin/g++.EXE";
	$java		= "C:/ProgramData/Oracle/Java/javapath/java.EXE";
	$javac		= "C:/Program Files/Java/jdk1.7.0_51/bin/javac.EXE";
	$csc  		= "C:/Windows/Microsoft.NET/Framework64/v2.0.50727/csc.EXE";
	$autoit	= "C:/Program Files (x86)/AutoIt3/autoit3.EXE";
	$jmeter	= "C:/apache-jmeter-2.11/bin/jmeter.bat";
	$apacheBench	= "C:/Apache24/bin/ab.EXE";



	$ruby 		=~ s/\\/\//g;
	$gcc 		=~ s/\\/\//g;
	$c_plusplus 	=~ s/\\/\//g;
	$g_plusplus 	=~ s/\\/\//g;
	$java 		=~ s/\\/\//g;
	$javac 		=~ s/\\/\//g;
	$csc   		=~ s/\\/\//g;
	$autoit		=~ s/\\/\//g;
	$jmeter		=~ s/\\/\//g;
	$apacheBench	=~ s/\\/\//g;


	######### Generated Variables 
	$SvrDrive 			= $c.'/'.$_TAF; 
	$exitTAFGracefullyLock   	= $c.'/'.$_TAF.'/'."_exitTAFGracefully_.txt";
	$SvrTCNameExecPattern 	= ".".$SvrTCNamePattern;  				# * 
	$SvrLogDir 			= ''.$SvrProjName.''; 				# * 
	$generateTestsuiteBAT	= $c.'/'.$_TAF."/taf_generateTestsuite.bat"; 		# *
	$externalLogName		="$c/$_TAF/externalLog.txt";			# *
	#$commandLogName		="$c/$_TAF/$_cmdLogs_txt";				# *
	######### Generated Variables $webUIStyleColor   		= "style=\"color:$webUIStyleColorHide\"";

	my $lockFName 			= "$c/$_TAF/taf.lock";
	my $url 			= 'file:///'.$SvrDrive;  		# will be updated in the sub-processTCs
	my $urlHttp			= 'http://'.$ip.$http_port;		# will be updated in the sub-processTCs
	my $urlHttp_IIS			= 'http://'.$ip.$http_port_IIS;		# will be updated in the sub-processTCs
	my $indexTitleRefresh   = sprintf("<a $webUIStyleColor href=\"${url}/$reportHtml\" onClick=\"RunFile('$perl $scriptName SysDrive=$SvrDrive;_TAF=$_TAF;generateTestsuiteAgain')\" title=\"Refresh *all* TAF UIs\" >%-${main_cmd_width}s</a>", "Refresh All TS");
	my $indexTitleRefreshCGI= sprintf("<a $webUIStyleColor href=\"${urlHttp}/${cgi_bin}$tafCGI?tafArgs=SysDrive=${SvrDrive}_semi_generateTestsuiteAgain;tafRedirectory=${urlHttp_IIS}/$reportHtml_http\" title=\"Refresh *all* TAF Testsuites\">%-${main_cmd_width}s</a>","Refresh All TS");
	
	my $indexTitleRefreshRoot   = sprintf("<a $webUIStyleColor href=\"${url}/$reportHtml\" onClick=\"RunFile('$perl $scriptName SysDrive=$SvrDrive;_TAF=$_TAF;refreshHost')\" title=\"Refresh TAF Web UI\" >%-${main_cmd_width}s</a>","Refresh");
	my $indexTitleRefreshCGIRoot= sprintf("<a $webUIStyleColor href=\"${urlHttp}/${cgi_bin}$tafCGI?tafArgs=SysDrive=${SvrDrive}_semi_refreshHost;tafRedirectory=${urlHttp_IIS}/$reportHtml_http\" title=\"Refresh TAF Web UI\">%-${main_cmd_width}s</a>","Refresh");

	#my $indexTitleRefreshRoot   = sprintf("<a $webUIStyleColor href=\"${url}/$reportHtml\" onClick=\"RunFile('$perl $scriptName SysDrive=$SvrDrive;_TAF=$_TAF;generateRootIndex')\" title=\"Refresh TAF Web UI\" >%-${main_cmd_width}s</a>","Refresh");
	#my $indexTitleRefreshCGIRoot= sprintf("<a $webUIStyleColor href=\"${urlHttp}/${cgi_bin}$tafCGI?tafArgs=SysDrive=${SvrDrive}_semi_generateRootIndex;tafRedirectory=${urlHttp_IIS}/$reportHtml_http\" title=\"Refresh TAF Web UI\">%-${main_cmd_width}s</a>","Refresh");




sub new { my $package = shift; return bless({}, $package); }

sub tcLoop {			###### Testsuite Loop #####
	my $returnValue;
	if (-e "$c/$_TAF/$SvrProjName/$_tafGlobalVars_txt") { &readTAFTSVars();} # TS Global Variables will overwrite TAF Global Variables
	while ((($Execution_24_7 eq 'y') || ($NofExecution > $NofExecutionCtr)) && ($NofPropertyExec >= $NofPropertyExecCtr )) {
	#### while ((($Execution_24_7 eq 'y') || ($NofExecution > $NofExecutionCtr))) {
		&markDaily();
		 $NofExecutionCtr++;
		my $tcOp_ = $tcOp; if ($tcOp_ =~ /list/) {$tcOp_ = "list & update";}
    		my $currentTime  = &UnixDate( "now", "%m/%d/%Y %H:%M:%S %Z" );
		if ($pr2Screen == 1) { if (($NofExecution == 1) && ($Execution_24_7 ne 'y')){ print "Processing           $c/$_TAF/$SvrProjName     ($tcOp_)          <- Testsuite \n" if ($outputFormat =~ /text/i) ; } else {print "Processing ($NofExecutionCtrExec\/$NofExecution) ......\n" ; } } else { print "";}

		if (($propertyOp =~ /^\s*$/) || ($propertyOp =~ /tcDescAuto/i)) { $NofExecutionCtrExec++; 
			&tcPre(); 
			&tcMain_(); 
			&tcPost(); 
		} else { 
			#&xtcMain_(); if ($NofPropertyExec =~ /y/i) { $propertyExecCtrEqZero = "y"; $propertyOp = ""; } else {$NofPropertyExecCtr++;}
			&tcMain_();  $NofPropertyExecCtr++;
		} # TC Property Process
		#### uncomment for debugging if ($pr2Screen==1) { if ($propertyOp) { print " -> $SvrDrive/$SvrProjName/_${propertyOp}.txt\n"; }	print " - Completed -\n"; } else { print "";} 
	}
	return $returnValue;
}
sub tcPre {
	# if (-e $SvrDrive.'/'.$SvrProjName) {;} else { print "$SvrDrive/$SvrProjName doesn't exist.\n"; exit; }	# Fix 2013/04/13 
	##################### PrePRocessor #####################
	if ($tcOp =~ /create/i) {
		if (-e $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml1) {;} else { &createFile_($SvrDrive.'/'.$SvrProjName.'/'.$reportHtml1,"<html><title>$web_ui_title</title><body>")	}; 
		if (-e $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml1_http) {;} else { &createFile_($SvrDrive.'/'.$SvrProjName.'/'.$reportHtml1_http,"<html><title>$web_ui_title</title><body>--- _tcReport_.htm will be available after list/update operation ---</body></html>")	}; 
		if (-e $SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlSummary) {;} else { &createFile_($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlSummary,"<html><title>$web_ui_title</title><body>--- summary file will be available after list/update operation ---</body></html>")	}; 
		if (-e $SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory) {;} else { &createFile_($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory,"<html><title>$web_ui_title</title><body>--- history file will be available after list/update operation ---</body></html>"); 	&addHtmlToolBar($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory);}; 
 
	}
	&readTestSuitProperty();
	########################################################
}

sub tcMain_ { $notUsegetTCName= 1; find( {preprocess=>sub {return sort @_;}, wanted=>\&recursiveSearchtcMain}, $SvrDrive); }
sub recursiveSearchtcMain() { 
	my $returnValue ='';
	if ($SvrTCNamePattern eq '*') { $SvrTCNamePattern = '.*';} 
	if (($File::Find::name =~ /tc.pl\s*$/) && ($File::Find::name =~ /$SvrDrive\/$SvrProjName\/$testcaseNode/i) && ($File::Find::name =~ /$SvrTCNamePattern/i))  # TC Filter
	{	
		$tcIdCtr++;
		my $eachTC 	= &getRoot($File::Find::name);	
		$SvrTCName 	= &getDir ($File::Find::name);
		$eachTC	 	= &getRoot($eachTC);
		if (-e "$SvrTCName/$_tafGlobalVars_txt") { &readTAFTCVars();} # TC Global Variables will overwrite TAF Global Variables
		&getWeb_($eachTC) =~ /scrollAmount\s*=\s*(\d+)/; $scrollAmount = $1; if ($scrollAmount) {;} else {$scrollAmount =0;}
		&getWeb_($eachTC) =~ /borderWidth\s*=\s*(\d+)/ ; $borderWidth  = $1; if ($borderWidth) {;} else {$borderWidth=0;}
		&getWeb_($eachTC) =~ /borderStyle\s*=\s*(.+)/  ; $borderStyle  = $1; if ($borderStyle) {;} else {$borderStyle=0;}

		if (    ($tcOp !~ /^\s*$/)&&($SvrTCName =~/$SvrTCNameExecPattern/)&&($tcIdCtr >= $tcIdMin) 
			&& (&getProperties(&getTCName($SvrTCName) , $tcPropertyPatternName, "value") =~ /$tcPropertyPatternPattern/i)
			&& (&getProperties(&getTCName($SvrTCName) , $tcPropertyPatternName1, "value") =~ /$tcPropertyPatternPattern1/i)
			&& (&getProperties(&getTCName($SvrTCName) , $tcPropertyPatternName2, "value") =~ /$tcPropertyPatternPattern2/i)
			&& (&getProperties(&getTCName($SvrTCName) , $tcPropertyPatternName3, "value") =~ /$tcPropertyPatternPattern3/i)
		)  { 		# Property/testcaseExec Filter
		   if ($propertyOp) {								# Property Processor
		        ##################### Property OPeration Start ####################
			if ($propertyOp =~ /tcDescAuto/) {					# add tcDesc when generateTestsuite
				my $tcDescAuto="";
				if ($#tcDesc eq 0 ) {;} else { $tcDescAuto = "add=tcDesc:".shift @tcDesc; }
				my $tcDescAuto_ = $tcDescAuto; $tcDescAuto =~ s/_space_/ /g; $tcDescAuto =~ s/_column_/:/g; $tcDescAuto =~ s/_eq_/=/g; 
				printf "%-20s %s %s\n", "processProperty:", &getTCName($File::Find::name),$tcDescAuto;
				&processProperty("",&getTCName($File::Find::name), $tcDescAuto_);
			} elsif (($propertyOp =~ /_doit_/i) || ($propertyOp =~ /^\s*_?get_/i) || ($propertyOp =~ /^\s*_?list_/i)) {   	# property Operation (_doit_)
				my $propertyOp_  = $propertyOp; 
				$propertyOp_  =~ s/_doit_//g; 
				my $rst = &processProperty("",&getTCName($File::Find::name), $propertyOp_);
				my $File_Find_name = $File::Find::name; $File_Find_name =~ s/\/$tc_pl//g;
				if ($rst =~ /\n/) {
 					&appendtoFile_	($SvrDrive.'/'.$SvrProjName.'/'."_$propertyOp_.txt","$File_Find_name\t$propertyOp_=\n$rst\n")				;
				} else {
 					&appendtoFile_	($SvrDrive.'/'.$SvrProjName.'/'."_$propertyOp_.txt","$File_Find_name\t$propertyOp_=$rst\n")				;
				}
			} else {
				print "[TS/TC=$File::Find::name]  propertyOp=$propertyOp    _doit_\n"; # property Operation (print it)
			}
		        ##################### Property OPeration End   ####################
		   } # else 
		   if (($propertyOp =~ /tcDescAuto/i) || ($propertyOp =~ /^\s*$/)) {			# TC Exec Processor
			##################### TC Operation Start ######################
			if ($scrollAmount ==0 and $borderWidth ==0) { 					# TC Execution
				my $scrollAmount_ = 1 ; if ($tcOp =~ /list/) { $scrollAmount_ = 0; } 
				if ($tcOp =~ /exec/i) { &updateWeb_(&getDir($File::Find::name),$scrollAmount_, $borderWidth, "SOLID", $ExecutionType); &generateRootIndex ()	; } # update RootIndex
				$returnValue = $returnValue. &processTC("","$tcOp=$eachTC",$pr2Screen)."\n"; 
					&logTC($eachTC);						# TC Logging	  -> tesesuite\testcase\_tcLog.html
				if ($performanceMode =~ /slow4WebUI/i) {
					&reportTCHistory($eachTC);					# TC ReporHistory -> testsuite\_tcReportHistory_.html
					&reportTCSummary ();
					&updateTestsuitePassFail ()	;
					&Queue("updateQueue");
				}
				&updateWeb_(&getDir($File::Find::name),0, $borderWidth, "SOLID");
				if (($tcOp !~ /list/) && ($tcOp !~ /mark/)) { sleep $sleep4Display;}
			} elsif ( $scrollAmount != 0 ) {						# Handle different TC exec state - handle concurrency 
				if       (($scrollAmount != 0 and $borderWidth== 0 )) { $borderWidth = 1; $borderStyle = "DOTTED"; }
				elsif    (($scrollAmount != 0 and $borderStyle =~ /DOTTED/i)) {$borderWidth =1; $borderStyle = "SOLID"; }
				elsif    (($scrollAmount != 0 and $borderStyle =~ /SOLID/i)) {$scrollAmount=0; $borderWidth =0; $borderStyle = "SOLID"; }
					&logTC($eachTC);						# TC Logging	  -> tesesuite\testcase\_tcLog.html
				if ($performanceMode =~ /slow4WebUI/i) {
					#### &reportTCHistory($eachTC);					# TC ReporHistory -> testsuite\_tcReportHistory_.html
					&reportTCSummary ();
					&updateWeb_(&getDir($File::Find::name),$scrollAmount, $borderWidth, $borderStyle);
				}
			} ##################### TC Operation End ######################
			if ((&getExitTAFGracefullyLock() eq &getRoot_2($File::Find::name)) || (&getExitTAFGracefullyLock() eq "exitTAF" ) ) { print "TAF exited gracefully\n"; &tcPost();  &releaseExitTAFGracefullyLock(); exit; } 
			# &generateRootIndex ()	; 
		   } 
		} else {	# to handle no-run execution add to ts/tc/thProperty.txt
				if ($formatResult =~ /y/i) { &dumyTC_(); }
		}

		$scrollAmount = 0; $borderWidth = 0; $borderStyle = "SOLID";
		#}	# Property Filter 							# Passing $scrollAmount, $borderWidth, $borderStyle, 
	} # TC Filter
 	elsif (($File::Find::name =~ /tc.pl\s*$/) && ($File::Find::name =~ /$SvrDrive\/$SvrProjName\/$testcaseNode/i))  # TC Filter
 	{
		if ($formatResult =~ /y/i) {
 		####################### Handl dumyTC
 		if (($propertyOp =~ /tcDescAuto/i) || ($propertyOp =~ /^\s*$/)) {
		my $tmp = &getDir($File::Find::name);
   		$returnValue = $returnValue. &processTC("","dumy=$tmp",$pr2Screen)."\n"; 
   		&logTC("tc");
 		&reportTCHistory("tc");					# TC ReporHistory -> testsuite\_tcReportHistory_.html
  		}
 		####################### Handl dumyTC
		}
 	}

}
sub tcPost {
	##################### Post PRocessor ###################
	if (-e $SvrDrive.'/'.$SvrProjName ) {				# fix 2013/04/13
	&createFile_($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory,"")				;
	&reportTCHistory("null");					# TC ReporHistory -> testsuite\_tcReportHistory_.html
	&appendtoFile_($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory,"<html><title>$web_ui_title</title><body><pre>\n")	;
 	&appendtoFile_		($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory,"</pre></body></html>\n")				;
 	&addHtmlToolBar		($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory)				;

   	&mergeFile_		($SvrDrive.'/'.$SvrProjName.'/'.$reportHtml, $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml1)		;
   	&mergeFile_		($SvrDrive.'/'.$SvrProjName.'/'.$reportHtml_http, $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml1_http)	;
	&prHtml1()			;
	&appendtoFileFile_	($SvrDrive.'/'.$SvrProjName.'/'.$reportHtml1,      $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml)	;
	&appendtoFileFile_	($SvrDrive.'/'.$SvrProjName.'/'.$reportHtml1_http, $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml_http);
	&prHtml2()			;
	&reportTCSummary ();
	&generateRootIndex      ()	; 
	&updateTestsuiteHTA     ()	;
	&updateTestsuitePassFail()	;
	$AutomationtsName   = "$SvrProjName";
     	&generateExcelReport	() 	;	$pr2Screen = 1;
	&sortCmdLog();
	&addHtmlToolBar("$c/$_TAF/$queueFName", "Completed Jobs"); 
	&addHtmlToolBar("$c/$_TAF/$queueFName_active", "Active Jobs"); 
	&generateDotSummary();
	&processTCs("","refreshHost");
	}
	sleep $outputPause;
	########################################################
} 

sub generateDotSummary {
open FinIndexHttp, "$c/$_TAF/$SvrProjName/$reportHtml_http";
#print " <-- $c/$_TAF/$SvrProjName/$reportHtml_http\n";
#print " --> $c/$_TAF/$SvrProjName/$reportHtmlSummaryDot\n";
open FoutDotSummary  , "> $c/$_TAF/$SvrProjName/$reportHtmlSummaryDot";
open FoutDotSummary_ , "> $c/$_TAF/$SvrProjName/${reportHtmlSummaryDot}_";
	my $ctr=1;
	print FoutDotSummary_ "<html><title>$web_ui_title</title><pre>\n";
	print FoutDotSummary<<EOFSummary_dot;
<html> <title>$web_ui_title</title><link rel='stylesheet' href="/main.css" type='text/css' media='all' />
EOFSummary_dot
		my $fhandle = \*FoutDotSummary; &prTopTitle($fhandle); print FoutDotSummary "<pre>";
while($_ = <FinIndexHttp>) {  chop ;
	if ($_ =~ /Automation Host:/i) {
		my $str = $_;
		$str =~ /(\d+\.\d+\.\d+\.\d+:\d+)/; my $ip = $1; $str =~ /httpd">\s*(\S+)\s*<\/a>\s*<\/div>\s*<div\s+id=/; my $tsName = $1; my $tsNameDisplay = sprintf "%-50s",$tsName;
		my $tsUrl = '<hr>Testsuite    <a href="http://'.$ip.'/'.$tsName.'/index_http.htm">'.$tsNameDisplay.'</a>';
		my $hostUrl = '    <a href="http://'.$ip.'/index_http.htm">(Automation Host: w-PC/'.$ip.')</a><hr>';
		print FoutDotSummary  "$tsUrl   $hostUrl \n";		
		print FoutDotSummary_ "$tsUrl   $hostUrl \n";		
	} elsif ($_ =~ /^\s*(<span style.*?)<a href/i) {
	printf FoutDotSummary "testcase%04s $1\n", $ctr++;
	printf FoutDotSummary_ "testcase%04s $1\n", $ctr++;
	}
}
	print FoutDotSummary "</pre></html>\n";
	print FoutDotSummary_ "</pre></html>\n";

close FinIndexHttp;
close FoutDotSummary;
close FoutDotSummary_;
# print " --> $c/$_TAF/$SvrProjName/$reportHtmlSummaryDot\n";
}
sub printVersion { printf "<taf>%s</taf>\n",$VERSION ; }
sub printTAFVersion { printf "%s\n",$VERSION ; }

sub resetTAFLocation {
	my $force = shift;
	if ( ( -e "$c/$_TAF/taf._TAF" ) && (!$force)) {;} 
	else {
		open Fout_setTAF, "> $c/$_TAF/taf._TAF"; print Fout_setTAF "$_TAF "; close Fout_setTAF; print " --> $c/$_TAF/taf._TAF\n";
	}
}
sub printOSVersion { 
	if ($^O =~ /win32/i) {	printf "%s\n",$^O; }
	elsif ($^O =~ /linux/i) { 
		if (-e "/etc/centos-release") {
		printf "%s\n", `/usr/bin/sudo /bin/cat /etc/centos-release`; 
		} else {
		printf "%s\n", "pre centOS 6.2";
		}
	
	}

}

sub heartBeat { print "This is heartBeat\n";}
# sub heartBeat { goto &fetchmail}

sub installTAFDefaultTS {
	&generateTAFDefaultTS ();
	my $cmd = "$c/$_TAF/_taf_default_ts.bat";
	my $rst = `$cmd`;
	print $rst;

}
sub generateTAFDefaultTS {
	if ( -e "$c/$_TAF") {;} else { mkdir "$c/$_TAF"; }
open Fout_TAFDefault, "> $c/$_TAF/_taf_default_ts.bat"; print " -> $c/$_TAF/_taf_default_ts.bat\n";
print Fout_TAFDefault<<EOF;
$c/$_TAF/$taf testsuite=c:/perlTS;generateTAFTestsuitePerl;refreshHost
$c/$_TAF/$taf testsuite=c:/RubyTS;generateTAFTestsuiteRuby;refreshHost
$c/$_TAF/$taf testsuite=c:/AutoItTS;generateTAFTestsuiteAutoIt;refreshHost
$c/$_TAF/$taf testsuite=c:/SeleniumTS;generateTAFTestsuiteSelenium;refreshHost
$c/$_TAF/$taf testsuite=c:/Jmeter_test_TS;generateTAFTestsuiteJmeter;refreshHost
$c/$_TAF/$taf testsuite=c:/TaaS;generateTAFTestsuiteTaaS;refreshHost
$c/$_TAF/$taf testsuite=c:/AutoIt_Training;generateTAFTestsuiteAutoItTraining;refreshHost
$c/$_TAF/$taf testsuite=c:/Jira_Integration;index_pl_arguments=CompanyNameIs_TAFLLC_ProjectNameIs_TAFN;generateTAFTestsuiteJira;refreshHost
EOF

close Fout_TAFDefault;

}
sub spawnTAF {goto &generateTAF}
sub generateTAF {
	my $_TAF_new 	  = shift;
	my $_TAF_new_col  = $_TAF_new;  $_TAF_new_col =~ s/\//::/g;
	my $_TAF_location = $INC{"Test/AutomationFramework.pm"};	
	my $_TAF_current  =  &getDir($_TAF_location);
	my $_TAF_created  =  &getDir($_TAF_location)."/$_TAF_new";


	if ($_TAF_new =~ /\//) {
		if ( -e $_TAF_created ) {;} else { mkpath $_TAF_created; }
	open FinTAF, $_TAF_location; 
	open FoutTAF, "> $_TAF_created/AutomationFramework.pm";
	while ($_ = <FinTAF>) {
		if ( $_ =~ /^\s*use\s+Test::AutomationFramework\s*;/     	) { $_ = "use Test::${_TAF_new_col}::AutomationFramework; #### <-- Modified by generateTAF \n"; }
		elsif ( $_ =~ /^\s*package\s+Test::AutomationFramework/  	) { $_ = "package Test::${_TAF_new_col}::AutomationFramework;\n";}
		elsif ( $_ =~ /my\s+\$_TAF\s*=\s*\"_TAF\"\s*;/           	) { $_ = "	my \$_TAF			= \"$_TAF_new\";  #### <-- Modified by generateTAF \n"; }
		elsif ( $_ =~ /TAF\s*=\s*new\s+Test::AutomationFramework\s*;/   ) { $_ = "	my \\\$TAF			= new Test::${_TAF_new_col}::AutomationFramework;  #### <-- Modified by generateTAF \n"; }
		print FoutTAF $_;
	}
	close FoutTAF;
	close FinTAF;
		print " ->  $_TAF_created/AutomationFramework.pm \n"; 
		print "     $perl_ -MTest::${_TAF_new_col}::AutomationFramework -e \"help\"\n"; 
		print "     $perl_ $c/$_TAF_new/taf.svr \n";
	} else { print "Warning: TAF->generateTAF: doesn\'t have a valid TAF name, like _proj1/_subProj1 \n"; print   '         perl -MTest::AutomationFramework -e "generateTAF(\\"_Proj1/proj2\\")" '."\n";  }
}
sub fetchmail { 	# this is window version
my $WinUser 		= "w";				# window user name is the cygwin user name
my $gmail 		= "wripcity\@gmail.com";	# gmail address
my $GmailPassword 	= "beaverton";			# gmail password

my $tcId = 1; $tcId = shift if @_; 
my $fetchMailDate ="";

	my $fetchMailChmodFName = "c:/cygwin/home/$WinUser/fetchmailChmod.bat" 	;
	my $fetchMailBATFName 	= "c:/cygwin/home/$WinUser/fetchmail.bat" 		;
	my $fetchMailRCFName  	= "c:/cygwin/home/$WinUser/.fetchmailrc" 		;

	my $str="poll pop.gmail.com with proto POP3 and options no dns user '$gmail' there with password '$GmailPassword' is '$WinUser' here  options ssl";
	mkpath "c:/cygwin/home/$WinUser";	
	open Fout, ">$fetchMailRCFName"; print Fout $str; close Fout; 					#print " -> $fetchMailRCFName\n";

	$str="/usr/bin/fetchmail.exe -vk";
 	open Fout, ">$fetchMailBATFName"; print Fout $str; close Fout; 					# print " -> $fetchMailBATFName\n";

	$str= "chmod 0600 /home/$WinUser/.fetchmailrc";
	open Fout, ">$fetchMailChmodFName"; print Fout $str; close Fout; 				# print " -> $fetchMailChmodFName\n";


 	my $cmd = 'c:\cygwin\bin\bash.exe -l /home/'.$WinUser.'/fetchmailChmod.bat';  my $rst = `$cmd 2>&1`;  
 	   $cmd = 'c:\cygwin\bin\bash.exe -l /home/'.$WinUser.'/fetchmail.bat';          $rst = `$cmd 2>&1`;  
 	foreach my $each (split /\n/, $rst) { if ($each =~ /protocol POP3\) at\s*(.+): poll completed/) { $fetchMailDate = $1; } }
 	copy ('c:/cygwin/var/spool/mail/'.$WinUser, 'c:/_TAF/_gmail_.txt'); 
 	$rst = "log is skipped\n";
 	return "---------- Start  ".(caller(0))[3]."-----------\n$cmd\n".$rst."----------  End   ".  (caller(0))[3]. "-----------\n";
}
 

sub getTAFArgsFromFile {
	my $fname = "$c/$_TAF/_tafArgs.txt";
	my $return="";
	if (-e $fname) { open Fin, $fname; while ($_ =<Fin>) { chop; $return .=";$_";	}	close Fin; }
	$return =~ s/^\s*;+//g; $return =~ s/;+/;/g;
       	$return =~ s/\s*//g; 
	unlink $fname;
	return $return;
}
sub markDaily {
	if ((($makeMarkLastDay  < &getExecDay()) && ($makeMark =~ /n/)) or (($tcCtr)%($tcDelta)== 0)) {
		$makeMarkLastDay = &getExecDay(); $makeMark = 'y'; 
	} else {
			$makeMark = 'n';
	}
	$tcCtr++;
}

sub getExecDay {
	my $initStartTime = &UnixDate( "Jan 1, 2012", "%m/%d/%Y %H:%M:%S %Z" );
	my $endStartTime  = &UnixDate( "now" , "%m/%d/%Y %H:%M:%S %Z" );
	my $totalTimeSpan = &DateCalc(&ParseDate($initStartTime),&ParseDate($endStartTime));  #### => YY:MM:WK:DD:HH:MM:SS  the years, months, etc. between the two
	my ($Y,$M,$W,$D,$H,$MIN,$S) = split /:/, $totalTimeSpan;
	my $makeMarkLastDay_Local =  int ($H/24); 
	return $makeMarkLastDay_Local;
}

sub generateTAFGlobalVars   {goto &printTAFGlobalVars}
sub generateTAFVars   {goto &printTAFGlobalVars}
sub generateTAFTSVars {goto &printTAFTSVars}
sub generateTAFTCVars {goto &printTAFTCVars}

sub printTAFGlobalVars { if (-e "$c/$_TAF/$_tafGlobalVars_txt") 				{;} else {mkpath "$c/$_TAF"					;} ;  open Fout, ">$c/$_TAF/$_tafGlobalVars_txt"				; print Fout &printGlobalVars()  ; close Fout; &addHtmlToolBar("$c/$_TAF/$_tafGlobalVars_txt","Default Settings"); print " -> $c/$_TAF/$_tafGlobalVars_txt\n"; }
sub printTAFTSVars     { if (-e "$c/$_TAF/$SvrProjName/$_tafGlobalVars_txt")			{;} else {mkpath "$c/$_TAF/$SvrProjName" 			;} ;  open Fout, ">$c/$_TAF/$SvrProjName/$_tafGlobalVars_txt"			; print Fout &printTSGlobalVars(); close Fout; &addHtmlToolBar("$c/$_TAF/$SvrProjName/$_tafGlobalVars_txt","Default Settings"); print " -> $c/$_TAF/$SvrProjName/$_tafGlobalVars_txt\n"; }
sub printTAFTCVars     { if (-e "$c/$_TAF/$SvrProjName/$SvrTCNamePattern/$_tafGlobalVars_txt")	{;} else {mkpath "$c/$_TAF/$SvrProjName/$SvrTCNamePattern" 	;} ;  open Fout, ">$c/$_TAF/$SvrProjName/$SvrTCNamePattern/$_tafGlobalVars_txt"	; print Fout &printTCGlobalVars(); close Fout; &addHtmlToolBar("$c/$_TAF/$SvrProjName/$SvrTCNamePattern/$_tafGlobalVars_txt","Default Settings"); print " -> $c/$_TAF/$SvrProjName/$SvrTCNamePattern/$_tafGlobalVars_txt\n"; }

sub updateTAFGlobalVarsColorHide { &updateTAFGlobalVars ("webUIStyleColorHide 	= #FFFFFF\n");  &generateRootIndex();}
sub updateTAFGlobalVarsColorHideNo { &updateTAFGlobalVars ("webUIStyleColorHide 	= #808080\n"); &generateRootIndex(); }
sub updateTAFGlobalVars { my $str =  "testcaseNode                  =$testcaseNode\n"; $str = shift if @_; 
			if (-e "$c/$_TAF/$_tafGlobalVars_txt") {
				open Fout, ">>$c/$_TAF/$_tafGlobalVars_txt"		 ; print Fout $str	; close Fout; print " ->> $c/$_TAF/$_tafGlobalVars_txt\n"; 
				 &addHtmlToolBar("$c/$_TAF/$_tafGlobalVars_txt","Default Settings");
			} else { print "updateTAFGlobalVars: $c:/$_TAF/$_tafGlobalVars_txt does *NOT* exist\n"; }
		
		}

sub noDemoMode { goto &updateTAFGlobalVarsIP}
sub demoModeNo { goto &updateTAFGlobalVarsIP}
sub updateTAFGlobalVarsIP { my $str =  "testcaseNode                  =$testcaseNode\n"; $str = shift if @_; 
			my $hostname 		= `hostname`; chop $hostname; 
			my $ip			= inet_ntoa((gethostbyname($hostname))[4]);
			if (-e "$c/$_TAF/$_tafGlobalVars_txt") {
				open Fout, ">>$c/$_TAF/$_tafGlobalVars_txt"		 ; print Fout "ip		=	$ip\n"	; close Fout; print " ->> $c/$_TAF/$_tafGlobalVars_txt\n"; 
				 &addHtmlToolBar("$c/$_TAF/$_tafGlobalVars_txt","Default Settings");
			} else { print "updateTAFGlobalVars: $c:/$_TAF/$_tafGlobalVars_txt does *NOT* exist\n"; }
			&updateIPHtml();
			return 1;
}
sub demoMode { goto &updateTAFGlobalVarsIP_loopback}
sub updateTAFGlobalVarsIP_loopback { my $str =  "testcaseNode                  =$testcaseNode\n"; $str = shift if @_; 
			my $ip			= "127.0.0.1";
			if (-e "$c/$_TAF/$_tafGlobalVars_txt") {
				open Fout, ">>$c/$_TAF/$_tafGlobalVars_txt"		 ; print Fout "ip		=	$ip\n"	; close Fout; print " ->> $c/$_TAF/$_tafGlobalVars_txt\n"; 
				 &addHtmlToolBar("$c/$_TAF/$_tafGlobalVars_txt","Default Settings");
			} else { print "updateTAFGlobalVars: $c:/$_TAF/$_tafGlobalVars_txt does *NOT* exist\n"; }
			&updateIPHtml();
			return 1;
}

sub updateTAFTSVars     { my $str="Execution_24_7_title          =n\nExecution_local_only           =y\n";  $str = shift if @_; 
			  my	$SvrProjName_ = $SvrProjName; $SvrProjName_ =~ s/$c\///;  $SvrProjName_ =~ s/^\///g; 
			if (-e "$c/$_TAF/$SvrProjName_/$_tafGlobalVars_txt") {
				open Fout, ">>$c/$_TAF/$SvrProjName_/$_tafGlobalVars_txt"; print Fout $str; close Fout; print " ->> $c/$_TAF/$SvrProjName_/$_tafGlobalVars_txt\n"; 
				&addHtmlToolBar("$c/$_TAF/$SvrProjName_/$_tafGlobalVars_txt","Default Settings");
			} else { 
				print "updateTAFTSVars: $c/$_TAF/$SvrProjName_/$_tafGlobalVars_txt does *NOT* exist. - Created\n"; 
				mkpath("$c/$_TAF/$SvrProjName_");
			open Fout, ">$c/$_TAF/$SvrProjName_/$_tafGlobalVars_txt"; print Fout $str; close Fout; print " -> $c/$_TAF/$SvrProjName_/$_tafGlobalVars_txt\n"; 
			}
}

sub updateTAFTCVars     { my $str="Execution_24_7_title          =n\nExecution_local_only           =y\n";  $str = shift if @_; 
			  my	$SvrProjName_ = $SvrProjName; $SvrProjName_ =~ s/$c\///; $SvrProjName_ =~ s/^\///g;
			if (-e "$c/$_TAF/$SvrProjName_/$SvrTCNamePattern/$_tafGlobalVars_txt") {
				open Fout, ">>$c/$_TAF/$SvrProjName_/$SvrTCNamePattern/$_tafGlobalVars_txt"; print Fout $str; close Fout; print " ->> $c/$_TAF/$SvrProjName_/$SvrTCNamePattern/$_tafGlobalVars_txt\n"; 
				&addHtmlToolBar("$c/$_TAF/$SvrProjName_/$SvrTCNamePattern/$_tafGlobalVars_txt","Default Settings");
			} else { 
				print "updateTAFTCVars: $c:/$_TAF/$SvrProjName_/$SvrTCNamePattern/$_tafGlobalVars_txt does *NOT* exist. - created\n"; 
				mkpath("$c/$_TAF/$SvrProjName_");
				open Fout, ">$c/$_TAF/$SvrProjName_/$SvrTCNamePattern/$_tafGlobalVars_txt"; print Fout $str; close Fout; print " -> $c/$_TAF/$SvrProjName_/$SvrTCNamePattern/$_tafGlobalVars_txt\n"; 
				&addHtmlToolBar("$c/$_TAF/$SvrProjName_/$SvrTCNamePattern/$_tafGlobalVars_txt","Default Settings");
			
			}
			}


sub clearTAFGlobalVars { unlink "$c/$_TAF/$_tafGlobalVars_txt"		 			; print " -rm-> $c/$_TAF/$_tafGlobalVars_txt\n"; 				}
sub clearTAFTSVars     { unlink "$c/$_TAF/$SvrProjName/$_tafGlobalVars_txt" 			; print " -rm-> $c/$_TAF/$SvrProjName/$_tafGlobalVars_txt"; 			}
sub clearTAFTCVars     { unlink "$c/$_TAF/$SvrProjName/$SvrTCNamePattern/$_tafGlobalVars_txt"	; print " -rm-> $c/$_TAF/$SvrProjName/$SvrTCNamePattern/$_tafGlobalVars_txt\n"; }
####################### remove duplicate records in file
sub removeDuplicate { 
	my $fname  = shift;
	if ($fname ) {;} else { print "remvoeDuplicate: needs filename\n"; exit; }
	if (-e $fname ) {;} else { print "remvoeDuplicate: $fname doesn't exist\n"; exit; }
	my $fname_tmp = $fname."_.htm"; 
open FILE , $fname; 
open FILE_tmp , "> $fname_tmp";
my $firstOccurence = "_firstOccurence_";
while ($_ = <FILE>) { if (($firstOccurence !~ /^_firstOccurence_$/) and ($_ ne $firstOccurence)) { print FILE_tmp $_; $firstOccurence = $_; } }
close FILE;
close FILE_tmp;
copy ($fname_tmp, $fname);
}

####################### copy Testsuite                  
sub copyTestsuite { goto copyTS}
sub copyTS        { shift; 
	$tsFrom =~ s/\\/\//g; $tsTo =~ s/\\/\//g;
	if (-e $tsFrom) {;} else { print "Warning: Testsuite ($tsFrom) doesn't exist. copyTS exits.\n"; return -1; }	
	if (-e "$tsFrom/$TSDescName") {;} else { print "Warning: TestDesc ($tsFrom/$TSDescName doesn't exist. copyTS exits.\n"; return -1; }	
	if (-e $tsTo  ) {;} else { print "Info   : $tsTo   doesn't exist. It is created.\n"; mkdir $tsTo  ; }	
	dircopy ($tsFrom, $tsTo) or die $!; 	print "$copy $tsFrom -> $tsTo\n"; 

open F_from, "$tsFrom/$TSDescName" ||  die "Can't find $tsFrom:$!" ;
open F_to  , ">$tsTo/$TSDescName"   ||  die "Can't open $tsTo:$!" ;
while ($_ = <F_from>) { $tsFrom =~ s/\\/\//g; $tsTo =~ s/\\/\//g; $_ =~ s/$c\\/$c\//g; $_ =~ s/$tsFrom/$tsTo/ig; print F_to $_; }
close F_to;
close F_from;	
return 1;
}
############

sub generatePropertyTestsuite {goto &generateTestsuiteByDesc}
sub generateTestsuiteBasedOnProperty{
$SvrProjName =~ s/\\/\//g;
&tcMain_1(); 
1;
}
#######################generate Property TCs from desc

sub generateTestsuiteByDesc { $SvrProjName =~ s/\\/\//g; &tcMain_1(); 1; }
sub tcMain_1 { 
	print "	Scanning for testsuites at $SvrProjName ......\n"; 	
	find({preprocess=> sub {return reverse sort @_;}, wanted=> \&recursiveSearchtcMain_1}, $SvrProjName); 				# print "	[fyi: -> $generateTestsuiteBAT]\n"; 
1;
}
sub recursiveSearchtcMain_1() { 
	if (($File::Find::name =~ /\/$TSHookName\s*$/) && ($tcPropertyName !~ /_all_/i))	# bug 04/26/2013
	{ 	
		&readTCDesc($File::Find::name);
	 	$tcPropertyPattern->add($tcPropertyName ); 
		my @property = split ("\/", $File::Find::name) ; 
		my $tags_ = $tags; $tags_ =~ s/,/\|/g; $tags_ = "($tags_)"; 
		if ($property[$#property -1] =~ /$tags_/ ) {;} 			####  stop recursivly creating property test suite
		else {		
			&generateTS ($File::Find::name, $tcPropertyName); 
		}
	}
}


sub generateTestsuiteAgain {
my $SvrProjName_ = $SvrProjName; $SvrProjName = "$c\\$_TAF"; $SvrProjName =~ s/\\/\//g; # linux todo
&tcMain_2(); 
$SvrProjName=$SvrProjName_; $SvrProjName =~ s/\\/\//g; &readTAFProperty(); &generateRootIndex("exit");
1;
}

sub tcMain_2 { 
	print "	Scanning for testsuites at $SvrProjName ......\n"; 	
	find({preprocess=> sub {return reverse sort @_;}, wanted=>\&recursiveSearchtcMain_2}, $SvrProjName); print "	[fyi: -> $generateTestsuiteBAT]\n"; 
1;
}
sub recursiveSearchtcMain_2() { 
	if (($File::Find::name =~ /$reportHtml\s*$/))
	{ 	
		my $cmd = $File::Find::name; 
		$cmd =~ s/\/?$reportHtml//;
		$cmd =~ s/$c\/$_TAF//;
		$cmd =~ s/^\s*\///;
		if ($cmd) { $cmd = "testsuite=$cmd;performanceMode=fast;list"; 
		$passFailDisplayWidth	= 8;					# TS Variable. Should be reset for each TS execution 
		&processTCs("", $cmd); 
		
		}
	}
}

sub generateTestsuiteScript {
	my $testsuite; 								# ="c:/_CRB_/AppBuildpath/_automated_testsuites_/_testsuite_pl"; 
	$testsuite = $SvrProjName; my $testsuiteTAF = $SvrProjName; $testsuiteTAF =~ s/c://g; # here
	foreach my $each (split /,/, $tags) {
print <<EOF;
REM $c/$_TAF/taf.pl -processTSs create=$testsuite							rem create Tag     TS
$c/$_TAF/taf.pl tcPropertyName=$each;testsuite=$testsuite;generateTestsuiteByDesc			rem create Tag     TS
$c/$_TAF/taf.pl testsuite=$testsuite/$each;generateTestsuite						rem create TAF-tag TS
$c/$_TAF/taf.pl testsuite=$testsuite;testcaseNode=testcase;generateTestsuite				rem create TAF     TS
$c/$_TAF/taf.pl testsuite=$testsuiteTAF;testcaseNode=testcase;list

EOF
;
}

}
sub generateTS {
	my $str; 
	my $tsHook 		= "index.pl"	; $tsHook 		= shift if @_			;  
	my $tcPropertyNameLocal = "_smoketest_"	; $tcPropertyNameLocal 	= shift if @_			;
	my $tsDir 		= $tsHook	; $tsDir		=~ s/(\/$TSHookName\s*$)//g	;  
	my $tsHookChild 	= "$tsDir/${tcPropertyName}/$TSHookNameGenerated"			; # c:\_TAF
	my $tsDirChild 		= "$tsDir/$tcPropertyNameLocal"						; # c:\...			

	my $otherCmd = "$copy (\"$tsDir/_tcLogAppend.txt\", \"$tsDirChild/_tcLogAppend.txt\")";
	$ps1_args =~ s/\\/\//g;
	
	if ($tsHook =~ /\.ps1\s*$/)	{ $tsHook	= "powershell -executionpolicy unrestricted -file $tsHook "; } # change1   # solve the ps1->pl cerversion bug

my $perlCode=<<EOF_;
#!$perl_
use File::Copy;
if (\$ARGV[0]) { 
	#_cmd_holder_#
} else {
print \<\<EOF;
#_desc_holder_#
EOF
;
}
EOF_
;

	############ TS - > subTS maping Table _tcMap.txt 
	my $ctr_local=1; 
	for (my $i = 1; $i <= $#tcDesc; $i++) { 
		if ( $tcDesc[$i] =~ /($tcPropertyPattern)/i ) {		
			my $tmp = sprintf ("$tsDir\/testcase%04d => $tsDirChild/testcase%04d", $i, $ctr_local);
			&appendtoFileUniqly("$tsDir/_tcMap.txt", $tmp);
			$ctr_local++;
		}
	}

	########## read the Mapping to %_tcMap my %_tcMap; open Fin, "$tsDir/_tcMap.txt"; while ($_=<Fin>) { $_ =~ /(.+)=>(.+)/; $_tcMap{$2}=$1; } close Fin;

	$ctr_local=1;
	for (my $i = 1; $i <= $#tcDesc; $i++) { 
		if ( $tcDesc[$i] =~ /($tcPropertyPattern)/i ) {		
		$tcDesc[$i] = &removeTags($tcDesc[$i]);
		my $i_tmp = $i ; 
		my $tmpStr = "if (\$ARGV[0] == $ctr_local) { \$rst = \`$tsHook $i_tmp -ps1_args $ps1_args\` ; $otherCmd; print \$rst; } \n";	  # change 2
		$perlCode =~ s/#_cmd_holder_#/$tmpStr\t#_cmd_holder_#/;
		$tmpStr = "$tcDesc[$i]\n";			# remove tcDesc Serial Number
		$tmpStr =~ s/\\/\//g;  
		$perlCode =~ s/#_desc_holder_#/$tmpStr#_desc_holder_#/;		$ctr_local++;
		}
	}
	if ($ctr_local > 1) {

	if (-e $tsDirChild) {;} else { mkpath $tsDirChild;}
		$perlCode =~ s/#_cmd_holder_#//g;
		$perlCode =~ s/#_desc_holder_#//g;
		open Fout , ">$tsHookChild"; print Fout $perlCode; close Fout; print  "	-> $tsHookChild\n";
	}
}

sub tsTags {goto &readTCDesc}
sub readTCDesc {
	my $cmd = shift; my $ctr = 1; my $tags="";
	if ($cmd) {;} else { $cmd= "$SvrProjName/$TSHookName"; }		# improvement 05/10/2013
	$#tcDesc = -1;		
	if ($cmd =~ /\.ps1\s*$/) { $cmd = "powershell -executionpolicy unrestricted -file $cmd -ps1_args $ps1_args"; } 		# change 3
	else { $cmd = "$perl_ $cmd "; } 		# change 3		# linux Bug: with -ps2 args, the index.pl return nothing
	
 	foreach my $each (split /\n/, `$cmd`) {
 		if ($each =~ /^\s*$/) {; }
 		elsif ($each =~ /^\s*_test/) { ; } 
 		else {
			#### $tcDesc[$ctr++] = $each; original before add _full_ 
 			$tcDesc[$ctr++] = $each." _full_";	# _full_ bug fix 05/12/2013 (see 6 line below)
 			# $tcDesc[$ctr++] = $each.", full,";	# _full_ bug fix 05/12/2013
			$tags = $tags.",".&getTags($each);
 		}
 	}
	# $tags = "$tags,full";
	return &uniq($tags);
}

sub getTags {
	my $tags=""; my $str = shift; @_ = split (/_/, $str);
	foreach my $each (@_) { if (($str =~ /_${each}_\s*/) && ($each !~ /^\s*$/)) { $tags = $tags.','.$each; }	}
	$tags =~ s/^\s*,//g;
	$tags =~ s/,\s*$//g;
	return $tags;
}

sub uniq {
	my $str = shift; my %record;
	@_ = split (/,/,$str); 
	foreach my $each (@_) { $record{$each} = $each; }
	$str = "";
	foreach my $each (sort keys %record) { $str = $str.",".$each; }
	$str =~ s/^\s*,//g; $str =~ s/,\s*$//g; $str =~ s/^\s*,//g; $str =~ s/,\s*$//g; $str =~ s/^\s*,//g; $str =~ s/,\s*$//g; 
	$str =~ s/^\s*,//g; $str =~ s/,\s*$//g; $str =~ s/^\s*,//g; $str =~ s/,\s*$//g; $str =~ s/^\s*,//g; $str =~ s/,\s*$//g;
	return $str;
}

#######################generate Property TCs from desc
sub scanTestsuites {					######### generate index.htm
	shift; my $doit="n";  my @dir;
	if ($tsFilter =~/_doit_/i) { $doit='y'; $tsFilter =~ s/_doit_//i;} 
	elsif ($tsFilterDefault =~/_doit_/i) { $doit='y'; $tsFilterDefault =~ s/_doit_//i;} 
	elsif ($SvrProjName =~ /_doit_/i) { $doit = 'y'; $SvrProjName =~ s/_doit_//i; }
	
	if ($tsFilterDefault =~ /^$c/)	 {
		@dir = glob "${tsFilterDefault}*"; 
	} else {
		@dir = glob "${c}/${tsFilterDefault}*"; 	# c:\_filter is added to the search pattern
	}

 	if ($SvrProjName !~ /_testSuit_/i) {
 		if ($SvrProjName =~ /^$c/)	 {
 			@dir = glob "${SvrProjName}*"; 
 		} else {
 			@dir = glob "${c}/${SvrProjName}*"; 
 		}
 	}

foreach my $each (@dir) {
	$each =~ s/\\/\//g;
find( { preprocess => sub {return reverse sort @_;}, wanted => sub { if (($File::Find::name =~ /index\.\w+$/i) && ($File::Find::name !~ /${c}\/${_TAF}/i)&&($File::Find::name !~ /${c}.${_TAF}/i))  # todo1 \\
		{
			my $dirName =  $File::Find::name; $dirName =~ s/[\\|\/]index..+$//g; $tsFilterDefault =~ s/\\/\//g;
			if ($dirName =~ /$tsFilterDefault/i) {
			$ps1_args =~ s/ /___/g; 
			$notUsegetTCName = 0; 
			my $cmd = sprintf "$SvrDrive/$taf testsuite=$dirName;web_ui_title=$dirName;ps1_args=$ps1_args;generateTestsuite" ;  
			print "scanTestsuites: $cmd\n"; 
			if ($doit =~ /\by\b/) { # $cmd =~ s/\//\\/g;  # todo2 \\
				print "Running ... >>>>\n$cmd\n<<<<\n"; 
				$workingDir = $dirName; $SvrProjName = $dirName; $web_ui_title = $dirName; $ps1_args = $ps1_args; &generateTestsuite();
			}
			}
		}
	 }}, $each);
}
	1;
}
sub getWeb_ {
	my  %tsProperty;
 	my $tcname 		= 'TC_tc1'	; $tcname = shift if @_;	
 	my $scrollamount 	= -1 		; 
 	my $borderwidth  	= -1  		; 
 	my $borderStyle  	= 'SOLID'  	; 
	$tcname = &getTCName($tcname); $tcname =~ s/\\/\//g;

	if (-e $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml) {
		open Fin, $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml;
 		while ($_ = <Fin>) {
 			my $tcnameTmp = $tcname;
 			if ( $_ =~ /$tcnameTmp/i) {
 				$_ =~  /scrollamount=\s*(\d+)\s*/; $scrollamount = $1;
 				$_ =~  /border:RED\s+(\d+)\s*px/; $borderwidth = $1;
 				$_ =~  /\d+\s*px\s+(\w+)\s*"/; $borderStyle= $1;
 			} 
 		}
 		close Fin;
	}
	return "borderWidth=$borderwidth;scrollAmount=$scrollamount;borderStyle=$borderStyle";
}

sub getTSMaxScrollAmount{
	my $testsuite= "$c/$_TAF/_testsuite2_"; $testsuite = shift if @_;
	my $scrollAmount = -1; 
		if (-e "$testsuite/$reportHtml") {
		open Fin, "$testsuite/$reportHtml";
 		while ($_ = <Fin>) {
			if ($_ =~  /scrollamount=\s*(\d+)\s*/) {
				my $scrollamount = $1; 
				if ($scrollamount > $scrollAmount) { $scrollAmount = $scrollamount; }
 			}
		}
 		close Fin;
	}
	return $scrollAmount;
}



# Html1
#######################generateRootIndex {
sub generateRootIndex {					######### generate index.htm
	my %tafUI; my %tafUITreeView; my %tafRootProperty; my $exit_y_n = "NO" ; 
	$exit_y_n = shift if @_; 

	my $queueSizeUI		; my $queueSizeUICGI		; my $queueSize=0; $queueSize = &Queue("", "queueSize");  my $queueSizeAll = &Queue ("", "AllqueueSize");
	my $queueSizeUI_active	; my $queueSizeUICGI_active	;   

	$queueSizeUI    	=  sprintf "<a $webUIStyleColor href=\"$url/${queueFName}\" title=\"View completed jobs\">%-${main_cmd_width}s</a>","Completed Jobs ($queueSizeAll)";
	$queueSizeUI_active    	=  sprintf "<a $webUIStyleColor href=\"$url/${queueFName}_active\" title=\"View active jobs\">%-${main_cmd_width}s</a>","Active Jobs ($queueSize)";
	$queueSizeUICGI 	=  sprintf "<a $webUIStyleColor href=\"$urlHttp_IIS/${queueFName}\" title=\"View completed jobs see $c/$_TAF/${queueFName}\">%-${main_cmd_width}s</a>","Completed Jobs ($queueSizeAll)";
	$queueSizeUICGI_active 	=  sprintf "<a $webUIStyleColor href=\"$urlHttp_IIS/$queueFName_active\" title=\"View active jobs see $c/$_TAF/$queueFName_active\">%-${main_cmd_width}s</a>","Active Jobs ($queueSize)";

	my $resetTAF            = sprintf("<a $webUIStyleColor href=\"$url/$SvrProjName/$reportHtml\" onClick=\"RunFile('$perl $scriptName SysDrive=$SvrDrive;performanceMode=fast;testcaseNode=$testcaseNode;$tcPropertyPatternName=$tcPropertyPatternName;testsuit=$SvrProjName;testcaseNode=testcase;resetTAF')\" title=\"Reset TAF\">%-${main_cmd_width}s</a>","Reset TAF");
	my $listTSUnderTest     = sprintf("<a $webUIStyleColor href=\"$url/$SvrProjName/$reportHtml\" onClick=\"RunFile('$perl $scriptName SysDrive=$SvrDrive;performanceMode=fast;testcaseNode=$testcaseNode;$tcPropertyPatternName=$tcPropertyPatternName;testsuit=$SvrProjName;testcaseNode=testcase;titleStatus=(UnderTestDontUse);updateTestSuitPropertyRootNoUse;generateRootIndex')\" title=\"Display UnderTestDontUser\">%-${main_cmd_width}s</a>","Mark as in Use");
	my $listTSUnderTestNull = sprintf("<a $webUIStyleColor href=\"$url/$SvrProjName/$reportHtml\" onClick=\"RunFile('$perl $scriptName SysDrive=$SvrDrive;performanceMode=fast;testcaseNode=$testcaseNode;$tcPropertyPatternName=$tcPropertyPatternName;testsuit=$SvrProjName;testcaseNode=testcase;titleStatus=;updateTestSuitPropertyRootUse;generateRootIndex')\" title=\"set titleStatus to Null \">%-${main_cmd_width}s</a>","Use");

	my $cycleColorScheme   		=  sprintf("<a $webUIStyleColor href=\"${urlHttp}/${cgi_bin}$tafCGI?tafArgs=generateTAFCSS_realSemi_tafRedirectory=${urlHttp_IIS}/$reportHtml_http\" title=\"Cycle Color Scheme\">%-${main_cmd_width}s</a>","Cycle Color Scheme");
	my $resetTAFCGI        		=  sprintf("<a $webUIStyleColor href=\"${urlHttp}/${cgi_bin}$tafCGI?tafArgs=SysDrive=$SvrDrive;performanceMode=fast;testcaseNode=$testcaseNode;$tcPropertyPatternName=$tcPropertyPatternName;testsuit=$SvrProjName;testcaseNode=testcase;titleStatus=(UnderTestDontUse);updateTestSuitPropertyRootNoUse;resetTAF_realSemi_tafRedirectory=${urlHttp_IIS}/$reportHtml_http\" title=\"Reset TAF\">%-${main_cmd_width}s</a>","Reset TAF");
	my $listTSUnderTestCGI 		=  sprintf("<a $webUIStyleColor href=\"${urlHttp}/${cgi_bin}$tafCGI?tafArgs=SysDrive=$SvrDrive;performanceMode=fast;testcaseNode=$testcaseNode;$tcPropertyPatternName=$tcPropertyPatternName;testsuit=$SvrProjName;testcaseNode=testcase;titleStatus=(UnderTestDontUse);updateTestSuitPropertyRootNoUse;generateRootIndex_realSemi_tafRedirectory=${urlHttp_IIS}/$reportHtml_http\" title=\"Display Don't Use Sign\">%-${main_cmd_width}s</a>","Mark as in Use");
	my $listTSUnderTestNullCGI 	=  sprintf("<a $webUIStyleColor href=\"${urlHttp}/${cgi_bin}$tafCGI?tafArgs=SysDrive=$SvrDrive;performanceMode=fast;testcaseNode=$testcaseNode;$tcPropertyPatternName=$tcPropertyPatternName;testsuit=$SvrProjName;testcaseNode=testcase;titleStatus=;updateTestSuitPropertyRootUse;generateRootIndex_realSemi_tafRedirectory=${urlHttp_IIS}/$reportHtml_http\" title=\"unset Don't Use Sign\">%-${main_cmd_width}s</a>","Mark as Available");
	my $hideHelpCGI        		=  sprintf("<a $webUIStyleColor href=\"${urlHttp}/${cgi_bin}$tafCGI?tafArgs=SysDrive=$SvrDrive;performanceMode=fast;testcaseNode=$testcaseNode;$tcPropertyPatternName=$tcPropertyPatternName;testsuit=$SvrProjName;testcaseNode=testcase;titleStatus=(UnderTestDontUse);updateTAFGlobalVarsColorHide_realSemi_tafRedirectory=${urlHttp_IIS}/$reportHtml_http\" title=\"Hide Commands\">%-${main_cmd_width}s</a>","Hide Commands");
	my $hideHelpNoCGI        	=  sprintf("<a $webUIStyleColor href=\"${urlHttp}/${cgi_bin}$tafCGI?tafArgs=SysDrive=$SvrDrive;performanceMode=fast;testcaseNode=$testcaseNode;$tcPropertyPatternName=$tcPropertyPatternName;testsuit=$SvrProjName;testcaseNode=testcase;titleStatus=(UnderTestDontUse);updateTAFGlobalVarsColorHideNo_realSemi_tafRedirectory=${urlHttp_IIS}/$reportHtml_http\" title=\"unHide Commands\">%-${main_cmd_width}s</a>","unHide Commands");

	$resetTAFCGI        		=~ s/;/_semi_/g; $resetTAFCGI        	 =~ s/_realSemi_/$_realSemi_/g;
	$cycleColorScheme   		=~ s/;/_semi_/g; $cycleColorScheme   	 =~ s/_realSemi_/$_realSemi_/g;
	$listTSUnderTestCGI 		=~ s/;/_semi_/g; $listTSUnderTestCGI 	 =~ s/_realSemi_/$_realSemi_/g;
	$listTSUnderTestNullCGI 	=~ s/;/_semi_/g; $listTSUnderTestNullCGI =~ s/_realSemi_/$_realSemi_/g;
	$hideHelpCGI            	=~ s/;/_semi_/g; $hideHelpCGI            =~ s/_realSemi_/$_realSemi_/g;
	$hideHelpNoCGI             	=~ s/;/_semi_/g; $hideHelpNoCGI          =~ s/_realSemi_/$_realSemi_/g;

	my $listTAFSourceCode   = sprintf("<a $webUIStyleColor href=\"${urlHttp_IIS}/taf.pm.txt\" title=\"Display TAF Source Code\">%-${main_cmd_width}s</a>","TAF Source Code");
	#my $listTAFTestBed      = sprintf("<a $webUIStyleColor href=\"${urlHttp_IIS}/$taf_txt\" title=\"Display TAF Sample Commands in Testbed scripts\">%-${main_cmd_width}s</a>","TAF Sample Commands");
	my $listTAFTestBed      = sprintf("<a $webUIStyleColor href=\"${urlHttp_IIS}/$taf_txt\" title=\"Display TAF Sample Commands in Testbed scripts\">%-${main_cmd_width}s</a>","TaaS Trainings");
	my $listZippedTS        = sprintf("<a $webUIStyleColor href=\"${urlHttp_IIS}/$_ZippedTS/_ZippedTS.cgi\" title=\"Display Zipped Testsuite\">%-${main_cmd_width}s</a>","Zipped TS (Cloud)");
	my $indexthProperty 	= sprintf("<a $webUIStyleColor href=\"${urlHttp_IIS}/$tsProperty_txt\" title=\"Display TS property\">%-${main_cmd_width}s</a>","TS UI Settings");
	my $tafGlobalVars 	= sprintf("<a $webUIStyleColor href=\"${urlHttp_IIS}/$_tafGlobalVars_txt\" title=\"Display TAF Global Variables\">%-${main_cmd_width}s</a>","Default Settings");
	my $indexCmdLog   	= sprintf("<a $webUIStyleColor href=\"${urlHttp_IIS}/$_cmdLogs_txt\" title=\"Display TAF Cmd History\">%-${main_cmd_width}s</a>","Cmd History");
	my $TaaS          	= sprintf("<a $webUIStyleColor href=\"${urlHttp_IIS}/TaaS/index.cgi\" title=\"Goto TaaS\">%-${main_cmd_width}s</a>","TaaS");

	&readTAFProperty(); &readTestSuitPropertyRoot(); &readWebTitle($SvrDrive);

	#### part 1 ####
open INDEX, ">$SvrDrive/index.htm_"; 
open INDEX_Simple, ">$SvrDrive/index.htm_Simple"; 
print INDEX &prJScript2();

print INDEX "<body onload=\"addEvents();\"><pre> <div id=\"main-nav\"> <a $webUIStyleColor> Display:</a> $indexCmdLog $queueSizeUI_active     $queueSizeUI     $indexthProperty    $tafGlobalVars   \n<a $webUIStyleColor>  Action :</a> $TaaS              $resetTAF <ul id=\"LinkedList1\" class=\"LinkedList\"> \n<a href=\"$urlHttp/$reportHtml_http\" title=\"$web_ui_title_tip over Network\"> $web_ui_title </a> </div>";

find({preprocess=> sub {return sort @_;}, wanted=>sub { if ($File::Find::name =~ /index\.htm$/i) {

			my $tmp= $File::Find::name; $tmp=~ s/$SvrDrive//;
			my $tmp1 = $File::Find::name; $tmp1 =~ s/\/index.htm//g; $tmp1 =~ s/\/$reportHtml//;  
			my $tmp2 = $File::Find::name; $tmp2 =~ s/\/index.htm//g;
			my $testsuite = $tmp2; my $tsDir = $tmp2;
			if ($tafProperty{$tmp2}) { $tmp2 = $tafProperty{$tmp2}; } else { $tmp2 = $tmp2; }
			if ($tafProperty{$tmp2}) { $tmp2 = sprintf("%-${tsPropertyWidth}s", $tafProperty{$tmp2}); }  else { $tmp2 = sprintf("%-${tsPropertyWidth}s", $tmp2); }
			my $tmp3 = $tmp2;
			$tmp2 = sprintf("%-${tsPropertyWidth}s", $tmp2);
			my $tmp4 = $tmp2; $tmp4 =~ s/^\s*\d+\s*//g;
			if ($tafRootProperty{$tmp3}) { $tafRootProperty{$tmp3}=$tafRootProperty{$tmp3};} else  {$tafRootProperty{$tmp3} = $tmp2;}	### < TreeView text
			$tafUI{$tmp2}=" <marquee style=\"border:RED 0px SOLID\" width=48 direction=right behavior=alternate loop=10000 scrollamount=".&getTSMaxScrollAmount($testsuite).">*</marquee> <a href=\"$url".$tmp."\">$tafRootProperty{$tmp3}</a><a style=\"color:white\">$SvrDrive$tmp</a>\n" if ($tmp ne "/index.htm");
			my $tmp2TreeView = &getRoot_N($tsDir, $webUITreeViewLevel) ; 
			if (defined $tafUITreeView{$tmp2TreeView} ) {;} else { $tafUITreeView{$tmp2TreeView} ="";}
			if (defined $tafUI{$tmp2} ) {;} else { $tafUI{$tmp2} ="";}
			if (($tmp2TreeView !~ /^\s*$c\/$_TAF\s*$/) && ($tafUI{$tmp2} !~ /_noShow_/i)) {
 			$tafUITreeView{$tmp2TreeView} = $tafUITreeView{$tmp2TreeView}."<li>".$tafUI{$tmp2}."</li>" ;  
			$tafUITreeView{$tmp2TreeView} =~ s/\n//g; $tafUITreeView{$tmp2TreeView} =~ s/^\s*//g;  	# extra line webUI
			}
		}
	 }}, $SvrDrive);
  	foreach my $each1 (sort keys %tafUI) { print INDEX_Simple $tafUI{$each1} if (($each1 !~ /^\s*$c\/$_TAF\s*$/) && ($tafUI{$each1} !~ /_noShow_/i)); }

	foreach my $each (sort { &get1stColumn($tafProperty{$a}) cmp &get1stColumn($tafProperty{$b})} keys %tafUITreeView ) { 
		# foreach my $each (sort keys %tafUITreeView ) { 
		@_ = split(/<li>/,$tafUITreeView{$each}); my $NofTS; $NofTS = $#_; 
		my $tsDesc ;  if ($tsPropertyRoot{$each}) { $tsDesc = "<a title=\"$each\">$tsPropertyRoot{$each}"; } else { $tsDesc = $each;}
		if ($NofTS >2 ) {	print INDEX "<li>$tsDesc<ul>$tafUITreeView{$each}"."</ul></li>" if ($each !~ /$c\/$_TAF\s*$/i); }
		else 		  {	print INDEX "$tafUITreeView{$each}" if ($each !~ /$c\/$_TAF\s*$/i); }
	}

print INDEX <<EOF;
</ul>
</pre></body></html>
<style type="text/css"> a { text-decoration:none} </style>
EOF
;
close INDEX;
close INDEX_Simple;
  		move ($SvrDrive.'/index.htm_', $SvrDrive.'/'."index.htm");
		&generateTaaSLandingPage ();
	#### part 1 ####
	#################################### Generate Root tsProperty.txt ##################################
	if (-e "$SvrDrive/$tsProperty_txt" ) {;} else {
	my $ctr=1;
	open FoutRootProperty, ">$SvrDrive/$tsProperty_txt";
	print FoutRootProperty "web_ui_title:  Test Automation Framework : web_ui_title\n";
	foreach my $each (sort keys %tafRootProperty) { 
		$each =~ s/\s*$//g;
		printf FoutRootProperty "%-60s\|%04d  %-60s\n", $each, $ctr++, $each if ($each !~ /$SvrDrive\s*$/i); 
	}
	close FoutRootProperty;
	}
	&addHtmlToolBar ("$SvrDrive/$tsProperty_txt","TS UI Settings");
	#################################### Generate Root tsProperty.txt ##################################
	#### part 2 ####
	%tafUITreeView=();
open INDEX, ">$SvrDrive/index_http.htm_";		########## generate index_http.htm 

print INDEX &prJScript2();


	open  Fout_topPanelHtml, ">$c/$_TAF/$topPanelHtml"; #print " --> $c/$_TAF/$topPanelHtml\n";
	print Fout_topPanelHtml "<div id=\"main-nav\"> <a id=\"logo\" href=\"$urlHttp_IIS/index_http.htm\">TaaS <span>Cloud</span></a> <div id=\"menu-nav-display\" class=\"menu-section\"> <div class=\"main-title-description\" > Display :</div>$indexCmdLog$queueSizeUICGI_active$queueSizeUICGI$indexthProperty$tafGlobalVars$listZippedTS$listTAFTestBed\n<div class=\"main-title-action\">  Action  : </div>$TaaS${indexTitleRefreshCGIRoot}${indexTitleRefreshCGI}${listTSUnderTestCGI}${listTSUnderTestNullCGI}$resetTAFCGI${cycleColorScheme}</div></div>\n<div id=\"container\">\n";
	close Fout_topPanelHtml;
# ADisplay
print INDEX "<body onload=\"addEvents();\">\n\n<div id=\"main-nav\"> <a id=\"logo\" href=\"$urlHttp_IIS/index_http.htm\">TaaS <span>Cloud</span></a> <div id=\"menu-nav-display\" class=\"menu-section\"> <div class=\"main-title-description\" > Display : </div>$indexCmdLog$queueSizeUICGI_active$queueSizeUICGI$indexthProperty$tafGlobalVars$listZippedTS$listTAFTestBed\n<div class=\"main-title-action\">  Action  : </div>$TaaS${indexTitleRefreshCGIRoot}${indexTitleRefreshCGI}${listTSUnderTestCGI}${listTSUnderTestNullCGI}$resetTAFCGI${cycleColorScheme}</div></div>\n<div id=\"container\">\n";
print INDEX "<div id=\"main-title\"><a href=\"$urlHttp_IIS/$reportHtmlSummaryDot\" title=\"Click to view *all* Testsuites\"> $web_ui_title </a> </div> <div id=\"main-title2\">(Automation host: $hostname/$ip)</div>\n<ul id=\"LinkedList1\" class=\"LinkedList\"><pre>\n";

			        open FoutDot, ">$c/$_TAF/$reportHtmlSummaryDot"; 
				print FoutDot "$main_css\n"; 
				my $fhandle = \*FoutDot; &prTopTitle($fhandle); 
				 
				 close FoutDot;
find({preprocess=> sub {return sort @_;}, wanted=>sub { if ($File::Find::name =~ /index_http\.htm$/i) {
			my $tmp = $File::Find::name; $tmp =~ s/$SvrDrive//; my $tsPath = $File::Find::name;  $tsPath =~ s/$c\/$_TAF\/(.+)\/$index_http_htm/$c\/$1/; 
			my $tmp2 = $File::Find::name; $tmp2 =~ s/\/index_http.htm//g;
			my $testsuite = $tmp2; my $tsDir = $tmp2;
			if (-e "$testsuite/${reportHtmlSummaryDot}_") { &appendtoFileFile_("$testsuite/${reportHtmlSummaryDot}_", "$c/$_TAF/$reportHtmlSummaryDot") ;}

			if ($tafProperty{$tmp2} ) { $tmp2 = sprintf("%-${tsPropertyWidth}s", $tafProperty{$tmp2}); }  
			else { $tmp2 = sprintf("%-${tsPropertyWidth}s", $tmp2); }
			my $tmp3 = $tmp2;
			$tmp2 = sprintf("%-${tsPropertyWidth}s", $tmp2);
			my $tmp4 = $tmp2;
			$tmp4 =~ s/^\s*\d+\s*//g;
			if ($tafRootProperty{$tmp3}) {;} else  {$tafRootProperty{$tmp3} = $tmp4;}
			$tafUI{$tmp2}="<tr> <td><marquee style=\"border:RED 0px SOLID\" width=48 direction=right behavior=alternate loop=10000 scrollamount=".&getTSMaxScrollAmount($testsuite).">*</marquee></td> <td><a href=\"$urlHttp_IIS".$tmp."\">$tafRootProperty{$tmp3}</a></td><td><a style=\"color:grey\">$tsPath</a></td></tr>\n" if ($tmp ne "/index.htm");
			my $tmp2TreeView = &getRoot_N($tsDir, $webUITreeViewLevel) ; 
			if (defined $tafUITreeView{$tmp2TreeView} ) {;} else { $tafUITreeView{$tmp2TreeView} ="";}
			if (defined $tafUI{$tmp2} ) {;} else { $tafUI{$tmp2} ="";}

			if (($tmp2 !~ /^\s*$c\/$_TAF\s*$/) && ($tafUI{$tmp2} !~ /_noShow_/i)) {
 			$tafUITreeView{$tmp2TreeView} = $tafUITreeView{$tmp2TreeView}."<li>".$tafUI{$tmp2}."</li>";  
			$tafUITreeView{$tmp2TreeView} =~ s/\n//g; $tafUITreeView{$tmp2TreeView} =~ s/^\s*//g; # $tafUITreeView{$tmp2TreeView} =~ s/\s*$/\n/g; 
			}

		}
	 }}, $SvrDrive);

print INDEX<<'EOF_index';
    <table id="main-test-suites-list">
  	<tr>
    	<th>Result</th>
    	<th>Test Name</th>
    	<th>Path</th>
    </tr>
EOF_index
	open Fout_tsName, ">$c/$_TAF/_tsName.txt";
	foreach my $each (sort { &get1stColumn($tafProperty{$a}) cmp &get1stColumn($tafProperty{$b})} keys %tafUITreeView ) { 
		print Fout_tsName "$each\n";
		my $NofTS; @_ = split(/<li>/,$tafUITreeView{$each}); $NofTS = $#_; 
		my $tsDesc ;  if ($tsPropertyRoot{$each}) { $tsDesc = "<a title=\"$each\">$tsPropertyRoot{$each}"; } else { $tsDesc = $each; }
		if ($NofTS >2 ) {	
			if ($each !~ /$c\/$_TAF\s*$/i) {
				print INDEX "<li>$tsDesc<ul>$tafUITreeView{$each}"."</ul></li>\n"} 
		} else 		  {	
			print INDEX "$tafUITreeView{$each}\n" if ($each !~ /$c\/$_TAF\s*$/i); }
	}
	close Fout_tsName;


print INDEX <<EOF;
</table>
</pre>
</ul>
</html>
<style type="text/css"> a { text-decoration:none} </style>
EOF
;
close INDEX;
  		move ($SvrDrive.'/index_http.htm_', $SvrDrive.'/'."index_http.htm");
	#### part 2 ####
	if ($exit_y_n =~ /exit/) { sleep $outputPause; exit; }
1;
}

sub generateTaaSLandingPage {
	if (-e "$c/$_TAF") {;} { mkpath "$c/$_TAF"; } 
	open Fout_LandingPage, ">$c/$_TAF/index.htm";
print Fout_LandingPage<<EOF;
<html>
	<body>
		<a href="http://$ip$http_port_IIS/index_http.htm">TaaS</a>
	</body>
</html>
EOF
	close Fout_LandingPage;
1;
}
sub get1stColumn { my $str = shift;  if ($str){;} else {$str ="";}  $str =~ s/^\s*//g; @_ = split (/\s+/,$str); my $return = $_[0];  if ($return) {;} else {$return = "0000"; } return $return; }

####################### read Testsuite web_ui_title
sub readWebTitle{ 
	my $dir = shift;  my %prop; my $webTitle = "Test Automation Framework";
	if (-e "$dir/$tsProperty_txt") { 	# todo hardcoded variable
		open Fin, "$dir/$tsProperty_txt"; 
		while ($_ =<Fin>) {
			my $tmp=""; /(\s*)/; $_ =~ /^\s*(.+)\|/       ; $tmp = $1; $prop{$tmp}=$_; 
			if ($_ =~ /web_ui_title\s*:\s*(.+)\s*:\s*web_ui_title/) {$webTitle = $1;}
		} close Fin; 
	}
	return $webTitle;
}


####################### get Testsuite Total Exec Time 
sub getTestsuiteTotalExecTime {
	my $index= shift; my $index_; my $tsTotalExecTime = 0;
		if (-e $index) {
		open FinTS, $index; 
		while ($_ = <FinTS>) { if ($_ =~ /^\s*<span\s+style="color:black;/i) { 
				# $_ =~ /(\d+)\s*\(s\)/; $tsTotalExecTime = $tsTotalExecTime + $1;} 
				if ($_ =~ /(\d\d):(\d\d):(\d\d)\s*\(s\)/) { $tsTotalExecTime = $tsTotalExecTime + $1 * 3600 + $2 * 60 + $3;}
				elsif ($_ =~ /(\d+)\s*\(s\)/) { $tsTotalExecTime = $tsTotalExecTime + $1;}
			} 
		}
		close FinTS;
		} 
	return &timeConvert($tsTotalExecTime); 
}
####################### get Testsuite Total Exec Time 


####################### get Testsuite Total Exec Time 
sub getTestsuiteTotalExecTimeTotal {
	my $index= shift; my $index_; my $tsTotalExecTimeTotal = 0;
		if (-e $index) {
		open FinTS, $index; 
		while ($_ = <FinTS>) { 

			if ($_ =~ /^\s*\w+\s+(\d+)s/)  {
				$tsTotalExecTimeTotal = $tsTotalExecTimeTotal + $1;
			}

			#if ($_ =~ /^\s*<span\s+style="color:black;/i) { 
			#	# $_ =~ /(\d+)\s*\(s\)/; $tsTotalExecTime = $tsTotalExecTime + $1;} 
			#	if ($_ =~ /(\d\d):(\d\d):(\d\d)\s*\(s\)/) { $tsTotalExecTime = $tsTotalExecTime + $1 * 3600 + $2 * 60 + $3;}
			#	elsif ($_ =~ /(\d+)\s*\(s\)/) { $tsTotalExecTime = $tsTotalExecTime + $1;}
			#} 
		}
		close FinTS;
		} 
	return &timeConvert($tsTotalExecTimeTotal); 
}
####################### get Testsuite Total Exec Time 



sub timeConvert {
	my $totalTime = shift; 
	my $hr  = int ($totalTime/3600); 
	my $min = int (($totalTime - $hr*3600) / 60);
	my $sec = int (($totalTime - $hr*3600 - $min * 60));
	$totalTime = sprintf "%02d:%02d:%02d",$hr,$min,$sec;
}

#######################generateFailedTCHtml {
sub createTestsuitePassFailedHtml {
	my $index= shift; my $index_;

	####################### failed.htm #####################
	if ($index=~ /index\.htm\s*$/ ) {
		$index_ = $index;
		$index_ =~ s/\.htm/_failed\.htm/;
		if (-e $index) {
		open Fin, $index; open Fout, ">$index_";
		while ($_ = <Fin>) {
			if ($_ =~ /tcPropertyPatternPattern/) { $_ =~ s/tcPropertyPatternPattern=\.\*/tcPropertyPatternPattern=fail/g; }
			if ($_ =~ /RunFile/) { $_ =~ s/index\.htm/index_failed\.htm/g; }
			if (&getLatestPassFail($_) =~ /color:gray;/i) { ;
			} elsif (&getLatestPassFail($_) =~ /color:green;/i) { ;
			} elsif (&getLatestPassFail($_) =~ /color:black;/i) { ;
			} else { 
				print Fout $_; }
			}
		close Fout; close Fin;
		}

	} elsif ($index=~ /index_http\.htm\s*$/ ) {
		$index_ = $index;
		$index_ =~ s/\.htm/_failed\.htm/;

		if (-e $index) {
		open Fin, $index; open Fout, ">$index_";
		while ($_ = <Fin>) {
			if ($_ =~ /tcPropertyPatternPattern/) { $_ =~ s/tcPropertyPatternPattern=\.\*/tcPropertyPatternPattern=fail/g; }
			if ($_ =~ /RunFile/) { $_ =~ s/index_http\.htm/index_failed_http\.htm/g; }
			if (&getLatestPassFail($_) =~ /color:gray;/i) { ;
			} elsif (&getLatestPassFail($_) =~ /color:green;/i) { ;
			} elsif (&getLatestPassFail($_) =~ /color:black;/i) { ;
			} else { print Fout $_; }
		}
		close Fout; close Fin;
		}
	}	
	####################### failed.htm #####################

	####################### pass.htm #####################
	if ($index=~ /index\.htm\s*$/ ) {
		$index_ = $index;
		$index_ =~ s/\.htm/_passed\.htm/;

		if (-e $index) {
		open Fin, $index; open Fout, ">$index_";
		while ($_ = <Fin>) {
			if ($_ =~ /tcPropertyPatternPattern/) { $_ =~ s/tcPropertyPatternPattern=\.\*/tcPropertyPatternPattern=pass/g; }
			if ($_ =~ /RunFile/) { $_ =~ s/index\.htm/index_passed\.htm/g; }
			if (&getLatestPassFail($_) =~ /color:gray;/i) { ;
			} elsif (&getLatestPassFail($_) =~ /color:black;/i) { ;
			} elsif (&getLatestPassFail($_) =~ /color:red;/i) { ;
			} else { 
				print Fout $_; }
			}
		close Fout; close Fin;
		}

	} elsif ($index=~ /index_http\.htm\s*$/ ) {
		$index_ = $index;
		$index_ =~ s/\.htm/_passed\.htm/;

		if (-e $index) {
		open Fin, $index; open Fout, ">$index_";
		while ($_ = <Fin>) {
			if ($_ =~ /tcPropertyPatternPattern/) { $_ =~ s/tcPropertyPatternPattern=\.\*/tcPropertyPatternPattern=pass/g; }
			if ($_ =~ /RunFile/) { $_ =~ s/index_http\.htm/index_passed_http\.htm/g; }
			if (&getLatestPassFail($_) =~ /color:gray;/i) { ;
			} elsif (&getLatestPassFail($_) =~ /color:black;/i) { ;
			} elsif (&getLatestPassFail($_) =~ /color:red;/i) { ;
			} else { print Fout $_; }
		}
		close Fout; close Fin;
		}
	}	
	####################### pass.htm #####################
	####################### other.htm #####################
	if ($index=~ /index\.htm\s*$/ ) {
		$index_ = $index;
		$index_ =~ s/\.htm/_others\.htm/;

		if (-e $index) {
			open Fin, $index; open Fout, ">$index_";
			while ($_ = <Fin>) {
				if ($_ =~ /tcPropertyPatternPattern/) { $_ =~ s/tcPropertyPatternPattern=\.\*/tcPropertyPatternPattern=\\\\d+_pipe_null/g; }
				if ($_ =~ /RunFile/) { $_ =~ s/index\.htm/index_others\.htm/g; }
				if (&getLatestPassFail($_) =~ /color:green;/i) { ;
				} elsif (&getLatestPassFail($_) =~ /color:red;/i) { ;
				} else { print Fout $_; }
			}
			close Fout; close Fin;
		}

	} elsif ($index=~ /index_http\.htm\s*$/ ) {
		$index_ = $index;
		$index_ =~ s/\.htm/_others\.htm/;

		if (-e $index) {
			open Fin, $index; open Fout, ">$index_";
			while ($_ = <Fin>) {
				if ($_ =~ /tcPropertyPatternPattern/) { $_ =~ s/tcPropertyPatternPattern=\.\*/tcPropertyPatternPattern=\\\\d+_pipe_null/g; }
				if ($_ =~ /RunFile/) { $_ =~ s/index_http\.htm/index_others_http\.htm/g; }
				if (&getLatestPassFail($_) =~ /color:green;/i) { 
				} elsif (&getLatestPassFail($_) =~ /color:red;/i) { ;
				} else { print Fout $_; }
			}
			close Fout; close Fin;
		}
	}	
	####################### other.htm #####################
}

#######################generateFailedTCHtml 

#######################generate_tagsHtml
sub generateTagHtml {
	my $index= shift; my $index_;
	my $tagName = "_smoke_"; 
	if ($index=~ /index\.htm\s*$/ ) {
		$index_ = $index;
		$index_ =~ s/\.htm/_$tagName\.htm/;

		if (-e $index) {
			open Fin, $index; open Fout, ">$index_";
			while ($_ = <Fin>) {
				if ($_ =~ /tcPropertyPatternPattern/) { $_ =~ s/tcPropertyPatternPattern=\.\*/tcPropertyPatternPattern=\\\\d+_pipe_null/g; }
				if ($_ =~ /RunFile/) { $_ =~ s/index\.htm/index_${tagName}\.htm/g; }
				if (&processProperties("","dir", $tagName) =~ /color:green;/i) { print Fout $_; } # here to start
			}
			close Fout; close Fin;
		}

	} elsif ($index=~ /index_http\.htm\s*$/ ) {
		$index_ = $index;
		$index_ =~ s/\.htm/_others\.htm/;

		if (-e $index) {
			open Fin, $index; open Fout, ">$index_";
			while ($_ = <Fin>) {
				if (&getLatestPassFail($_) =~ /color:green;/i) { 
				} elsif (&getLatestPassFail($_) =~ /color:red;/i) { ;
				} else { print Fout $_; }
			}
			close Fout; close Fin;
		}
	}	
}
#######################generate_tagsHtml

sub getLatestPassFail {
	$_ = shift; my $color; my @symbol = $_ =~ />.<\/a><a\s+style=/g; my @color  = $_ =~ /<a style=\"color:\w+\"/g; 
for (my $i = 0; $i < $#symbol; $i++) { 
	$symbol[$i] =~ />(.)</; $symbol[$i] = $1;
	if ($symbol[$i] =~ /^\s*$/) {;}  # dumy 
	elsif ($symbol[$i] =~ /\|/) {;}  # mark
	elsif (!$color[$i]) {;} 
	elsif (($color[$i] =~ /\"(color:\w+)\"/)) {return "$1;"; }
}
return "";
}

sub getLatestPassFail_v2_0 {
	$_ = shift; my $color; my @symbol = $_ =~ />.<\/a><a\s+style=/g; my @color  = $_ =~ /<a style=\"color:\w+\"/g; 
for (my $i = 0; $i < $#symbol; $i++) { 
	$symbol[$i] =~ />(.)</; $symbol[$i] = $1;
	if ($symbol[$i] =~ /^\s*$/) {;}  # dumy 
	elsif ($symbol[$i] =~ /\|/) {;}  # mark
	else { $color[$i] =~ /\"(color:\w+)\"/; return "$1;"; }
}
return "";
}


sub getLatestPassFail_old {
	$_ = shift; my $color;
	if ($_ =~ /^\s*<span\s+style="color:black;">/) {
		if ($_ =~ /^\s*<span\s+style="color:black;">\s*<a\s+style="color:\s*(\w+)"/) {$color = $1;} else {$color = "black";}
	}
	if ($color) { return "color:$color;";} else {return "_";}
}


sub updateWeb {
	my  %tsProperty;
 	my $tcname = 'TC_tc1'; $tcname = shift if @_		;	
 	my $scrollamount = 0 ; $scrollamount = shift if @_	;
	$tcname = &getTCName($tcname); $tcname =~ s/\\/\//g	;

	if (-e $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml) {
 		open Fin, $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml		;
 		open Fout, ">".$SvrDrive.'/'.$SvrProjName.'/'.$reportHtml."_"	;
 		while ($_ = <Fin>) {
 			my $tcnameTmp = $tcname;
 			if ( $_ =~ /$tcnameTmp/i) {
 				$_ =~ /scrollamount=\s*(\d+)\s*/;
 				$_ =~ s/scrollamount=\s*$1\s*/scrollamount=$scrollamount/;
 			} 
 				print Fout $_;
 		}
 		close Fout;
 		close Fin;

  		move ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtml."_", $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml);
	}
	return "tcCtr_Dynamics=$scrollamount";
}

################################################################################
#        
################################################################################
sub hungryMatch {    # hungryMatch("startStr_returnStr_endStr","startStr","endStr")
    my $str        = shift; my $startStr    = shift; my $endStr    = shift;

    if (index($str, $startStr) < 0) { return "";}
    if (index($str, $endStr  ) < 0) { return "";}
    my $offset     = index($str,$startStr) + length $startStr;
    my $len     = index($str,$endStr)  - $offset;
    if ($len < 0) { $len = 0; }
    return substr ($str, $offset, $len);
}
sub match1stRegexp { my $str = shift; my $pattern = shift; @_ = split (/$pattern/, $str); return $_[0]; }
sub matchRestRegexp { my $str = shift; my $pattern = shift; @_ = split (/$pattern/, $str); $str =~ s/^\s*$_[0]//; $str =~ s/^\s*$pattern//; return $str;}
sub removeTags { my $str = shift; @_ = ($str=~ /\b_\S+_\b/ig); foreach my $each (@_) {
		if ($each !~ /\//) { $str =~ s/\b$each\b//g ; 
		}
	
	} 
	
	return $str; }
sub updateTestsuiteHTA {
	open Fin, $SvrDrive."/index.htm" || die "Can't open index.htm";
	while ($_ = <Fin>) { chop; if ( &hungryMatch($_,"\/\/\/","index.htm") ) { my $ts= &hungryMatch($_,"\/\/\/","index.htm") ; &createTestsuiteHTA ($ts); } }
	close Fin;
}

sub tsPostProcessPlugin {
	open Fin, $SvrDrive."/index.htm" || die "Can't open index.htm";
	while ($_ = <Fin>) { chop; if ( &hungryMatch($_,"/\/\/\/","index.htm")) { my $ts= &hungryMatch($_,"\/\/\/","index.htm"); print "postProcessPlugin: $ts\n";} }
	close Fin;
}
sub updateTestsuitePassFail {
	#if (-e $SvrDrive."/index.htm" ) {
	#open FinIndex, $SvrDrive."/index.htm" || die "Can't open index.htm";
	if (-e $SvrDrive."/index.htm_Simple" ) {
	open FinIndex, $SvrDrive."/index.htm_Simple" || die "Can't open index.htm";
	while ($_ = <FinIndex>) { chop; 
		if ( &hungryMatch($_, "\/\/\/","index.htm" )) { 
			my $ts     = &hungryMatch($_,"\/\/\/","index.htm")."index.htm" ;  &createTestsuitePassFailedHtml ($ts); 
			my $ts_http = $ts; $ts_http =~ s/index\.htm/index_http\.htm/; &createTestsuitePassFailedHtml ($ts_http); 
		} 
	}
	close FinIndex;
	}
}

sub createTestsuiteHTA {
	my $tsDir = shift; @_ = split /\//, $tsDir; my $testsuite = $_[$#_];
	&createFile_( $tsDir.'ts.hta', 
"
<html>
<title>$web_ui_title</title>
<head>
	<script language=\"JavaScript\">
		function RunFileHTTP(testsuite, testcase) {
//			alert(\"testsuite is \" + testsuite + \" testcase is \" + testcase );
			 WshShell = new ActiveXObject(\"WScript.Shell\");
		    	 cmd= '$c\\\\windows\\\\system32\\\\schtasks.exe /delete /tn TAF_'+ testsuite + ' /f'; 
			sleep (1000);
 //alert (cmd);
			 WshShell.Run(cmd, 1, false);
			 cmd = '$c\\\\windows\\\\system32\\\\schtasks.exe /create /TR \"$c\\\\$_TAF\\\\taf.pl testsuit='+testsuite+';testcaseExec='+testcase+';exec\" /TN TAF_'+testsuite+' /sc monthly /mo 1 /F'; 
			sleep (1000);
 //alert (cmd);
			 WshShell.Run(cmd, 1, false);
    		  	 cmd= '$c\\\\windows\\\\system32\\\\schtasks.exe /run /tn TAF_'+testsuite; 
			sleep (1000);
 //alert (cmd);
			 WshShell.Run(cmd, 1, false);
		}

	function sleep(milliseconds) {
	  var start = new Date().getTime();
	  for (var i = 0; i < 1e7; i++) {
	    if ((new Date().getTime() - start) > milliseconds){
	      break;
	    }
  	}
}

	</script>

</head>
<body onLoad =\"RunFileHTTP(\'$testsuite\', \'.*\')\">Run $testsuite\/ts.hta</button> <p>
</body>
</html>

")
;

}	

################################################################################
#        
################################################################################
sub initTAF {
	foreach my $each (split /\n/, `schtasks /query`) {
		if ($each =~ /TAF_/i) {
			$each =~ /^\s*(.+)\s+(\d+\/\d+\/\d+)\s+/;
			my $processName = $1; my $cmd = "schtasks /delete /tn $processName /f"; `$cmd`;
		}
	}
}

################################################################################
#        
################################################################################

sub readTestSuitProperty {
	if ( -e $SvrDrive.'/'.$SvrProjName.'/'."$tsProperty_txt") {
	open Fin, $SvrDrive.'/'.$SvrProjName.'/'."$tsProperty_txt";
	while ($_ = <Fin>) { chop;
 		if ($_ =~ /web_ui_title\s*:\s*(.+)\s*:\s*web_ui_title/)  { $web_ui_title = $1; }
		# else { $web_ui_title = "Test Automation Framework"; }
		my $tcname, my $tcdesc;
		($tcname, $tcdesc) = split /[\|]/, $_;
		if ($tcdesc) {
		#### Remove xml tags from the tcDesc for property display 
		$tcdesc =~ s/<.*>//g;
		$tcname =~ s/^\s*//; $tcname =~ s/\s*$//;  # $tcdesc =~ s/^\s*//;
		$tsProperty{$tcname}= $tcdesc;
		}
	}
	close Fin;
	}
}

sub readTestSuitPropertyRoot {
	if ( -e $SvrDrive.'/'."$tsProperty_txt") {
	open Fin, $SvrDrive.'/'."$tsProperty_txt";
	while ($_ = <Fin>) { chop;
 		if ($_ =~ /web_ui_title\s*:\s*(.+)\s*:\s*web_ui_title/)  { $web_ui_title = $1; }
		my $tcname, my $tcdesc;
		($tcname, $tcdesc) = split /[\|]/, $_;
		if ($tcdesc) {
		#### Remove xml tags from the tcDesc for property display 
		$tcdesc =~ s/<.*>//g;
		$tcname =~ s/^\s*//; $tcname =~ s/\s*$//;  # $tcdesc =~ s/^\s*//;
		#### Remove _TAF 
		$tcdesc =~ s/$c\/$_TAF/$c/;
		$tsPropertyRoot{$tcname}= $tcdesc;
		}
	}
	close Fin;
	}
}

sub updateTestSuitPropertyRootNoUse {
	if ( -e $SvrDrive.'/'."$tsProperty_txt") {
	open Fout_root, ">>$SvrDrive/$tsProperty_txt";
	print Fout_root "web_ui_title: Under Testing. Don't Use This Machine! Test Automation Framework : web_ui_title\n";
	print Fout_root "web_ui_title:  <div id=\"in-use-banner\">Under Testing. Don't Use This Machine!</div> Test Automation Framework : web_ui_title\n";
	close Fout_root;
	&addHtmlToolBar("$SvrDrive/$tsProperty_txt");
	}
}

sub updateTestSuitPropertyRootUse {
	if ( -e $SvrDrive.'/'."$tsProperty_txt") {
	open Fout_root, ">>$SvrDrive/$tsProperty_txt";
	print Fout_root "web_ui_title: Test Automation Framework : web_ui_title\n";
	close Fout_root;
	&addHtmlToolBar($SvrDrive/$tsProperty_txt);
	}
}

################################################################################
#        
################################################################################

sub readTAFProperty {
	if ( -e $SvrDrive.'/'.$tsProperty_txt) {
	open Fin, $SvrDrive.'/'.$tsProperty_txt;
	while ($_ = <Fin>) {
		chop;
 		if ($_ =~ /web_ui_title\s*:(.+):\s*web_ui_title/)  { $web_ui_title = $1; }
		my $tcname, my $tcdesc;
		($tcname, $tcdesc) = split /[\|]/, $_;
		if ($tcdesc) {
		$tcname =~ s/^\s*//; $tcname =~ s/\s*$//;  # $tcdesc =~ s/^\s*//;
		$tafProperty{$tcname}= $tcdesc;
		$tafPropertyRev{$tcdesc} = $tcname;
		}
	}
	close Fin;
	}
}

################################################################################
#        
################################################################################
sub getTSNameFromTSDesc {
	&readTAFProperty();
	my $tcDesc = "018"; $tcDesc = shift if @_;
	foreach my $each (keys %tafPropertyRev) {
		if ($each =~ /$tcDesc/i) { my $tmp = $tafPropertyRev{$each}; $tmp =~ s/$c\/$_TAF\///; return $tmp; }
	}
}
################################################################################
#        
################################################################################
sub runFromGmailService {
while (1==1) {
`$c/$_TAF/$taf runFromGmail`; 
sleep 10;
}
}

sub runFromGmail {

my %cmd_from_gmail; my %cmd_from_gmail_completed; my %cmd_from_gmail_email; my $cmd_from_gmail_fname = "$c/$_TAF/taf.gmail.txt"; my %cmd_from_gmail_status;
my $passwd = "beaverton"; my $email = 'wripcity@gmail.com';
my $cmd = '"C:/Program Files/cURL/bin/curl" -u wripcity:beaverton --silent "https://mail.google.com/mail/feed/atom" '; 
my $rst = `$cmd`; $rst =~ s/\n//g;

if (-e $cmd_from_gmail_fname) {
	open Fin_gmail, "$cmd_from_gmail_fname"; 
	while ($_=<Fin_gmail>) { $_ =~ s/\#.*$//g; my @_split = split /\s*;\s*/, $_; $cmd_from_gmail_completed{$_split[0]} = $_split[1]; }
	close Fin_gmail;
}

foreach my $each (split /<entry>/, $rst) {
	$each =~ /<issued>(.+)<\/issued>/; 	my $issued  = $1;
	$each =~ /<title>(.+)<\/title>/; 	my $subject = $1;
	$each =~ /<email>(.+)<\/email>/; 	my $email   = $1;
	$cmd_from_gmail{$issued} = $subject if ($issued);
	$cmd_from_gmail_email{$issued} = $email if ($issued);
	if ($subject =~ /^\s*Task:\s*(\S+)\s+Status=(\S+):\s*/) { 
		my $key = $1; my $value = $2;
		if (defined $cmd_from_gmail_status{$key}) {;} else { $cmd_from_gmail_status{$key} = "";}
		$cmd_from_gmail_status{$key} = $value if ($cmd_from_gmail_status{$key} !~ /done/i) ; 
	}
}

foreach my $each (reverse sort keys %cmd_from_gmail) {
	if (defined $cmd_from_gmail_status{$each} ) {;} else { $cmd_from_gmail_status{$each} = ""; }
	if (($each !~ /^\s*$/) && ($cmd_from_gmail{$each} =~ /^\s*TAF/i) && ($cmd_from_gmail_status{$each} !~ /done/i)) {
	print "                  Gmail cmd {\"$each\"} : $cmd_from_gmail{$each}  Status = $cmd_from_gmail_status{$each}\n";
		############### Status = Start
open Fout_gmail_send, ">$c/$_TAF/_taf.gmail_send.txt";
print Fout_gmail_send<<EOF_gmail_send;
From: "TAF User" <$cmd_from_gmail_email{$each}>
To: "TAF User" <$email>
Subject: Task: $each  Status=START: $cmd_from_gmail{$each} 
This email notifies the job "$cmd_from_gmail{$each}" initialized by $cmd_from_gmail_email{$each} at $each by is started at [todo_host]
EOF_gmail_send

close Fot_gmail_send;

my $cmd = '"c:/Program Files/cURL/bin/curl" --url "smtps://smtp.gmail.com:465" --ssl-reqd  --mail-from "'.$email.'" --mail-rcpt "'.$email.'"  --upload-file c:/_TAF/_taf.gmail_send.txt --user "'."$email:$passwd\" --insecure";
my $rst = `$cmd`; $rst =~ s/\n//g;

		############### Status = Start
	open Fout_gmail, ">>$cmd_from_gmail_fname"; print Fout_gmail "$each ; $cmd_from_gmail{$each}		# by $cmd_from_gmail_email{$each}\n"; close Fout_gmail;

 		if ($cmd_from_gmail{$each} =~ /autoIt/i) {
 			my $cmd = "$perl_ $c/$_TAF/$taf testsuite=AutoItTestsuite;tc_comment='\"Requested by $cmd_from_gmail_email{$each} at $each\";exec"; 
 			print "Running Gmail cmd: $cmd\n";   $rst = `$cmd`;
 		} elsif ($cmd_from_gmail{$each} =~ /selenium/i) {
 			my $cmd = "$perl_ $c/$_TAF/$taf testsuite=seleniumWD;tc_comment='\"Requested by $cmd_from_gmail_email{$each} at $each\";exec"; 
 			print "Running Gmail cmd: $cmd\n";   $rst = `$cmd`;
 		}
		############### Status = Completed
open Fout_gmail_send, ">$c/$_TAF/_taf.gmail_send.txt";
print Fout_gmail_send<<EOF_gmail_send;
From: "TAF User" <$cmd_from_gmail_email{$each}>
To: "TAF User" <$email>
Subject: Task: $each  Status=DONE: $cmd_from_gmail{$each} 
This email notifies the job "$cmd_from_gmail{$each}" initialized by $cmd_from_gmail_email{$each} at $each by is compeleted at [todo_host]
EOF_gmail_send

close Fot_gmail_send;

   $cmd = '"c:/Program Files/cURL/bin/curl" --url "smtps://smtp.gmail.com:465" --ssl-reqd  --mail-from "'.$email.'" --mail-rcpt "'.$email.'"  --upload-file c:/_TAF/_taf.gmail_send.txt --user "'."$email:$passwd\" --insecure";
   $rst = `$cmd`; $rst =~ s/\n//g;
		############### Status = Completed


	}
}	
1;
}

sub runFromGmail_v2 {

my %cmd_from_gmail; my %cmd_from_gmail_completed; my %cmd_from_gmail_email; my $cmd_from_gmail_fname = "$c/$_TAF/taf.gmail.txt";
my $cmd = '"C:/Program Files/cURL/bin/curl" -u wripcity:beaverton --silent "https://mail.google.com/mail/feed/atom" '; 
my $rst = `$cmd`; $rst =~ s/\n//g;

if (-e $cmd_from_gmail_fname) {
	open Fin_gmail, "$cmd_from_gmail_fname"; 
	while ($_=<Fin_gmail>) { $_ =~ s/\#.*$//g; my @_split = split /\s*;\s*/, $_; $cmd_from_gmail_completed{$_split[0]} = $_split[1]; }
	close Fin_gmail;
}

foreach my $each (split /<entry>/, $rst) {
	$each =~ /<issued>(.+)<\/issued>/; 	my $issued  = $1;
	$each =~ /<title>(.+)<\/title>/; 	my $subject = $1;
	$each =~ /<email>(.+)<\/email>/; 	my $email   = $1;
	$cmd_from_gmail{$issued} = $subject if ($issued);
	$cmd_from_gmail_email{$issued} = $email if ($issued);
}

foreach my $each (reverse sort keys %cmd_from_gmail) {
	if ($cmd_from_gmail_completed{$each}) {
		# print "                  Gmail cmd \"$each\" is completed \n";
	} else {
	if ($each !~ /^\s*$/) {
	print "                  Gmail cmd {\"$each\"} : $cmd_from_gmail{$each}\n";
	open Fout_gmail, ">>$cmd_from_gmail_fname";
	print Fout_gmail "$each ; $cmd_from_gmail{$each}		# by $cmd_from_gmail_email{$each}\n";
	close Fout_gmail;
		if ($cmd_from_gmail{$each} =~ /autoIt/i) {
			my $cmd = "$perl_ $c/$_TAF/$taf testsuite=AutoItTestsuite;tc_comment='\"Requested by $cmd_from_gmail_email{$each} at $each\";exec"; 
			print "Running Gmail cmd: $cmd\n";  # exec $cmd;
		} elsif ($cmd_from_gmail{$each} =~ /selenium/i) {
			my $cmd = "$perl_ $c/$_TAF/$taf testsuite=seleniumWD;tc_comment='\"Requested by $cmd_from_gmail_email{$each} at $each\";exec"; 
			print "Running Gmail cmd: $cmd\n";  # exec $cmd;
		}
	}
	}
}	
1;
}

sub runFromGmail_v1 {
	my %record; my $value; my $key; my %record_file			; 
	my $fetchmailFName      = "/var/spool/mail/qa_user"		; 
	my $fetchmailFNameLocal = "/usr/local/iiiiiiii/bin/qa_user"	;
	if (-e $fetchmailFNameLocal) { open Fin1, $fetchmailFNameLocal; while ($_= <Fin1>) { $_ = /_date_(.+)_subject_(.+)/; $record_file{$1}=$2;} close Fin2; }               # read local history file
	if (-e $fetchmailFName     ) { open Fin , $fetchmailFName     ; while ($_= <Fin> ) { if (/^\s*Date:/) { chop; $key=$_; } elsif (/^\s*Subject: /) { chop; $value = $_; $record{$key}= $value;} } close Fin; }
	else { print " $fetchmailFName doesn't exit\n"; exit;}
	foreach my $each (sort keys %record) { if ($record_file{$each}) { print "$each already exist\n"; } else {
	&runIndex($record{$each}); open Fout , ">>$fetchmailFNameLocal" ; print Fout "_date_${each}_subject_$record{$each}\n"; close Fout; } }
}

sub runIndex {
# todo
}
sub runFromGmail_old_win32 {
my $cmd='c:\cygwin\bin\bash.exe -l /home/yongyan.wang/fetchmail.bat'; my $rst = `$cmd`;
# my $gmailFName = 'c:/cygwin/var/spool/mail/w'; my $testsuite="";
my $gmailFName = 'c:/cygwin/var/spool/mail/yongyan.wang'; my $testsuite="";

if ( -e $gmailFName) { open Fin, $gmailFName; while ($_ = <Fin>) { if ($_ =~ /^\s*subject:\s+Run\s*(.+)\s*$/i) { $testsuite=$1; } } close Fin; }

if ($testsuite =~ /^\s*\d+/) {
	my $cmd = "$perl_ $c/$_TAF/$taf testsuite=".&getTSNameFromTSDesc($testsuite).";exec";
	my $rst = `$cmd`;
	print ">>$cmd\n$rst\n";
} else { print "\nPlease input the testsuite *Number* (not $testsuite)\n"; }

unlink $gmailFName;
}




################################################################################
#	Subroutine Name : logTC
#		Function: create TC _tcLog.html for each TC
#	Input Parameters: Test Case name
#	Output/Returns  : c:\inetpub\wwwroot\*.html
################################################################################
sub logTC {		# 	Update TC Log on webUI (TH:WebUI)
    my $currentTime  = &UnixDate( "now", "%m/%d/%Y %H:%M:%S %Z" );
    my $tcname       ; $tcname = &getTCName ($tcname);
    my $dirRoot = &getRoot($tcname); 
    #$tcname = &getTCName_TAF_no ($tcname);
    my $tcnameUrlHttp = "<a href=\"$urlHttp_IIS/$SvrProjName/$reportHtml_http\">Back</a>";
	 if (&getTCLogFname($tcname) =~ /_tcLog\.txt\s*$/ ) { 
	    my 	$webLogText =  &readFile("$tcname/_tcLog.html");
	       	$webLogText =~ s/<html>\s*<body>\s*<pre>\s*//;
	       	$webLogText =~ s/<\/pre>\s*<\/body>\s*<\/html>\s*//;
	       	$webLogText =~ s/\n/_nl_/g;
	       	$webLogText =~ s/\s*_nl_\s*/\n/g;
    		my $fileText = &readFile(&getTCLogFname($tcname)); 
    		my $fileText_= &readFile(&getTCLogFname_($tcname));   # for _tcLogAppendix_.txt (pyAnvil logs)
    		my $fileText__= &readFile(&getTCLogFname__($tcname)); # for _tcLogAppendix_.txt (pyAnvil logs)
    		if (-e $tcname) {;} else {mkpath $tcname;}
	 	open Fout, "> $tcname/_tcLog.html" || die "Warning: $tcname/_tcLog.html doesn't exist\n";
		my $fhandle = \*Fout; &prTopTitle($fhandle); print Fout "<body><pre>";
         	print Fout "==================== Update on $currentTime Start =====================\n";
    		my $tcnameB = &getTCName_TAF_no ($tcname);
		print Fout "<a href=\"http://$ip$http_port_IIS/$SvrProjName/$dirRoot/$tc_cgi\">Edit     $tcnameB</a>					   $tcnameUrlHttp\n";
		print Fout "$tc_comment\n" if ($tc_comment);
    		print Fout  $fileText__ if ($fileText__);
    		print Fout  $fileText_ if ($fileText_);
    		print Fout  $fileText;
		print Fout "\nSTDOUT--start-----------------------------------------------------------\n$tc_stdout\n" if ($tc_stdout);
		print Fout "STDOUT--end-------------------------------------------------------------\n" if ($tc_stdout);
		print Fout "\n==================== Update on $currentTime End   ===================== $tcnameUrlHttp\n\n"; 
         	print Fout "</pre></div></body></html>\n";
		print Fout "<style type=\"text/css\"> a { text-decoration:none} </style>\n";
         	close Fout;
		&addHtmlToolBar("$tcname/_tcLog.html");
	 } elsif ((&getTCLogFname ($tcname) =~ /_tcLogAppend\.txt\s*$/) || (&getTCLogFname_ ($tcname) =~ /_tcLogAppend_\.txt\s*$/) ||(&getTCLogFname__ ($tcname) =~ /_tcLogAppend__\.txt\s*$/) ){ 
	    	my $webLogText =  &readFile("$tcname/_tcLog.html");
		my $dirRoot = &getRoot($tcname); 
	        $webLogText =~ s/<html>\s*<body>\s*<pre>\s*//;
	        $webLogText =~ s/<\/pre>\s*<\/body>\s*<\/html>\s*//;
	        $webLogText =~ s/\n/_nl_/g;
       		$webLogText =~ s/\s*_nl_\s*/\n/g;
       		$webLogText =~ s/^\s*//g; 

    		my $fileText = &readFile(&getTCLogFname($tcname)); 
    		my $fileText_ = &readFile(&getTCLogFname_($tcname));  # for _tcLogAppendix_.txt (pyAnvil logs)
    		my $fileText__= &readFile(&getTCLogFname__($tcname)); # for _tcLogAppendix_.txt (pyAnvil logs)

		######## add html tags to $fileText_ #######  
		if ($fileText_) {$fileText_ = &addURLs($fileText_); }
		if ($fileText ) {$fileText  = &addURLs($fileText ); }
		######## add html tags to $fileText_ ####### 

    		if (-e $tcname) {;} else {mkpath $tcname;}
		open Fout, "> $tcname/_tcLog.html" || die "Warning: $tcname/_tcLog.html doesn't exist\n";
    		my $tcnameB = &getTCName_TAF_no ($tcname);
		my $fhandle = \*Fout; &prTopTitle($fhandle); print Fout "<body><pre>";
         	print Fout "==================== Update on $currentTime Start =====================\n";
		#print Fout "<a href=\"http://$ip$http_port_IIS/$SvrProjName/$dirRoot/$tc_cgi\">Edit       $tcname</a>					   $tcnameUrlHttp\n";
		print Fout "<a href=\"http://$ip$http_port_IIS/$SvrProjName/$dirRoot/$tc_cgi\">Edit       $tcnameB</a>						$tcnameUrlHttp\n";
		print Fout "$tc_comment\n" if ($tc_comment);
    		print Fout  $fileText__ if ($fileText__);
    		print Fout  $fileText_ if ($fileText_);
    		print Fout  $fileText;
		print Fout "\nSTDOUT--start-----------------------------------------------------------\n$tc_stdout\n" if ($tc_stdout);
		print Fout "STDOUT--end-------------------------------------------------------------\n" if ($tc_stdout);
		print Fout "\n==================== Update on $currentTime End   ===================== $tcnameUrlHttp\n\n"; 
		print Fout $webLogText;
         	print Fout "</pre></div></body></html>\n";
		print Fout "<style type=\"text/css\"> a { text-decoration:none} </style>\n";
         	close Fout;
		&addHtmlToolBar("$tcname/_tcLog.html");
	 } else {
    		if (-e "$tcname/_tcLog.html") {;} else {mkpath $tcname;
		open Fout, "> $tcname/_tcLog.html" || die "Warning: $tcname/_tcLog.html doesn't exist\n";
		#print Fout &prJScript(); print Fout "<body><pre>";
		my $dirRoot = &getRoot($tcname); 
    		my $tcPropertyPatternPattern_ = ".*"; ####################### Reset the tcPropertyPatternPattern for index.htm
		my $runTCOnce = "<a href=\"${url}/$SvrProjName/$reportHtml\" onClick=\"RunFile('$perl $scriptName SysDrive=$SvrDrive;performanceMode=fast;tcPropertyPatternName=$tcPropertyPatternName;tcPropertyPatternPattern=$tcPropertyPatternPattern_;testsuit=$SvrProjName;testcase=$dirRoot;ExecutionType=runTC;exec')\"  title=\"**JScript**: Generate Logs e.g. $tcname/_tcLogAppend.txt \">St</a>";
		my $runTCOnceHttp = "<a href=\"${urlHttp}/${cgi_bin}$tafCGI?tafArgs=SysDrive=$SvrDrive;tcPropertyPatternName=$tcPropertyPatternName;tcPropertyPatternPattern=$tcPropertyPatternPattern_;testsuit=$SvrProjName;testcase=$dirRoot;ExecutionType=runTC;exec_realSemi_tafRedirectory=${urlHttp_IIS}/$SvrProjName/$reportHtml_http\"  title=\"**Http**: Generate Logs e.g. $tcname/_tcLogAppend.txt\">Art</a>";
		$runTCOnceHttp =~ s/;/_semi_/g; $runTCOnceHttp=~ s/_realSemi_/$_realSemi_/g;
		# $runTCOnceHttp =~ s/;/_semi_/g; $runTCOnceHttp=~ s/_realSemi_/;/g; linux porting
		my $fhandle = \*Fout; &prTopTitle($fhandle);
    		my $tcnameB = &getTCName_TAF_no ($tcname);
         	print Fout "==================== Update on $currentTime ${runTCOnce}$runTCOnceHttp =====================\n";
		print Fout "<a href=\"http://$ip$http_port_IIS/$SvrProjName/$dirRoot/$tc_cgi\">Edit       $tcnameB</a>					   $tcnameUrlHttp\n";
		print Fout "\nSTDOUT--start-----------------------------------------------------------\n$tc_stdout\n" if ($tc_stdout);
		print Fout "STDOUT--end-------------------------------------------------------------\n" if ($tc_stdout);
		print Fout "$tc_comment\n" if ($tc_comment);
    		print Fout " $tcname has no log\n";
		print Fout "==================== Update on $currentTime End   ===================== \n\n"; 
		print Fout "\n\n<font color=\"white\">-------------------------AutomationFramework generated tcDriver -----------------------\n $tcname/tc.pl:\n". &readFile ("$tcname/$tc_pl") ;
		print Fout "-------------------------AutomationFramework generated tcDriver ------------------------<font>"; 
         	print Fout "</pre></div></body></html>\n";
		print Fout "<style type=\"text/css\"> a { text-decoration:none} </style>\n";
         	close Fout;
		&addHtmlToolBar("$tcname/_tcLog.html");
		}

	 } 
 	 rmtree &getTCLogFname ($tcname) ;
 	 rmtree &getTCLogFname_ ($tcname) ;
 	 rmtree &getTCLogFname__ ($tcname) ;
	 return " tcLog[Append].[txt|html] are refreshed";
}

sub prTopTitle_save {
	my $fout = $_[0];
	if ( -e "$c/$_TAF/$index_http_htm") { ;} else { return; }
	open Fin_prTopTitle, "$c/$_TAF/$index_http_htm";
	my $inSearch = "n";
	while ($_ = <Fin_prTopTitle>) {
		if ($_ =~ /\"main-nav\"/)  { $inSearch = "y"; }
		if ($inSearch =~ /y/i) { print {$fout} $_;}
		if ($_ =~ /\"container\"/) { $inSearch = "n"; }
	}
	close Fin_prTopTitle;
}

sub prTopTitle {
	my $fout = shift; my $item = ""; $item = shift if @_; 
	if ($item =~ /^\s*$/) { $item = "unMatchableChar";}
	if ( -e "$c/$_TAF/$index_http_htm") { ;} else { return; }
	open Fin_prTopTitle, "$c/$_TAF/$index_http_htm";
	my $inSearch = "n";
	while ($_ = <Fin_prTopTitle>) {
		if ($_ =~ /\"main-nav\"/)  { $inSearch = "y"; }
		if ($inSearch =~ /y/i) { $_ =~ s/(>)($item.*?)(<\/a>)/$1<b>$2<\/b>$3/; print {$fout} $_; } # print "pc: $_"; }
		if ($_ =~ /\"container\"/) { $inSearch = "n"; }
	}
	close Fin_prTopTitle;
}
sub tmp { my $item ="Cmd History"; my $fhandle = \*STDOUT; &prTopTitle_($fhandle); }


sub addURLs {
	my $return="";	
	my $logNamePatterns = "log";
	foreach my $each (split "\n", shift ) {
		$_ = $each;
		#### The followings are for Powershell only 
		#s/_/_underscore_/g; s/\s/_ws_/g; s/\./_dot_/g; s/\\/_backslash_/g; s/\//_slash_/g; s/:/_col_/g; s/-/_dash_/g; s/\(/_leftPara/g; s/\)/_rightPara/g; s/</_lessThan/g; s/>/_greaterThan/g;s/=/_equal/g;
		#s/"/_doubleQuote/g; s/'/_singleQuote/g; s/\$/_dollar_/g; s/\%/_percentage_/g; s/\@/_at_/g; s/;/_semiColumn_/g;
		#s/\W//g;
		#s/\_ws_/ /g; s/_dot_/\./g; s/_backslash_/\\/g; s/_slash_/\//g; s/_col_/:/g; s/_dash_/-/g; s/_underscore_/_/g; s/_leftPara/\(/g; s/_rightPara/\)/g; s/_lessThan/</g; s/_greaterThan/>/g;s/_equal/=/g;
		#s/_doubleQuote/"/g; s/_singleQuote/'/g; s/_dollar_/\$/g; s/_percentage_/\%/g; s/_at_/\@/g; s/_semiColumn_/;/g;
		#### The above are for Powershell only 

		my $c_ = $c; my $_TAF_ = $_TAF; my $SvrProjName_ = $SvrProjName; 
		if ($SvrProjName_ =~ s/^$c_// ) { ; } else { ; # print "\nInfo: $SvrProjName_ might have problem with the build-in file link (*.txt) \n($SvrProjName_ !~ $c_)\n\n" if ($^O =~ /linux/);  #### debug info: 
		}
		if (($_ !~ /_mime_file/i) && ($_ !~ /_no_txt_file_parsing_/) && ($_ !~ /href=\"/) && ($_ =~ /\.(txt|json|xml|gif|htm|xls|log|cgi)/i) &&($_ !~ /_url_line_/i) && ($_ !~ /---\s*cmd\s*---/i)&&($_ !~ /_cmd_line_/i) && ($_ !~ /\-runAsCmd/i)) { # convert c:\abc.txt or c:/efg.txt <a href file= abc.txt </a>


			$_ =~ s/</__lt__/g; $_ =~ s/>/__gt__/g; 


			$_ =~ /(.+\s+)?(\S+\.(txt|json|xml|gif|xls|htm|log|cgi))\s+(.+)?/i;

			########## handle white space in log name ############
			$_ =~ /(\w:[\\|\/])/; my $matchStart = $1;
			$_ =~ /(.+\s+)?($matchStart.+\.(txt|json|xml|gif|xls|htm|log|cgi))[\n|\r|\s+](.+)?/i;
			########## handle white space in log name ############

			my $match1 = ""; if ($1) {$match1 = $1 ;} 
			my $logNameInLog = ""; if ($2) { $logNameInLog = $2; }
			my $match3=""; if ($3) {$match3 = $3."\n";}
			if ($4) {$match3 = $4."\n";}


			if ($match3 =~ /(txt|json|xml|gif|xls|htm|log|cgi)/) { $match3 = ""; }
			$match1 =~ s/$c\///gi;
			if ($match3 =~ /[\n|\r]/) {;} else {$match3 = "$match3\n";}		# fixign extra \n in Log File: line 

#if ($^O =~ /win32/i) { $logNameInLog = "$c/$logNameInLog";} elsif ($^O =~ /linux/i) { $logNameInLog = "/$logNameInLog"; }		# todo : need investigation in linux deployment
			if ($^O =~ /win32/i) { $logNameInLog = "$logNameInLog";} elsif ($^O =~ /linux/i) { $logNameInLog = "$logNameInLog"; }
			if (($logNameInLog =~ /\.txt\s*$/) || ($logNameInLog =~ /\.htm\s*$/)) { 
				$logNameInLog =~ s/\\/\//g;
				my $currentTime  = &UnixDate( "now", "%m-%d-%Y-%H_%M_%S" );
				my $fileFrom = $logNameInLog ; 
				my $fileToFile   = &getTCName()."/".&getRoot_4($logNameInLog); $fileToFile =~ s/\.txt\s*$/_$currentTime\.txt/;
				my $fileToHttp   = &getTCName()."/".&getRoot_4($logNameInLog); $fileToHttp =~ s/\.txt\s*$/_$currentTime\.txt/;
				$_ =~ s/__lt__/&lt;/g; $_ =~ s/__gt__/&gt;/g;

				if ( -e $fileFrom ) { 
					if ( -e &getDir($fileToFile)){ ; } else {mkpath &getDir($fileToFile); }
					# copy ($fileFrom, $fileToFile);
					&addHtml ($fileFrom, $fileToFile);
					$fileToHttp =~ s/$c\/$_TAF/${ip}${http_port}/;	
					$return = $return.$match1."<a href=\"http://$fileToHttp\"  >$fileFrom</a> $match3";
					#### tech reserver $return = $return.$match1."<a href=\"file:////$fileToFile\">(file:$fileFrom)</a> $match3";
				} else {
					$return = $return.$match1."Warning: Log $fileFrom doesn't exist! $match3";
				}
				##
			} elsif (($logNameInLog =~ /\.json\s*$/i)) { 
				$logNameInLog =~ s/\\/\//g;
				my $currentTime  = &UnixDate( "now", "%m-%d-%Y-%H_%M_%S" );
				my $fileFrom = $logNameInLog ; 
				my $fileToFile   = &getTCName()."/".&getRoot_4($logNameInLog); $fileToFile =~ s/\.json\s*$/_$currentTime\.json/;
				my $fileToHttp   = &getTCName()."/".&getRoot_4($logNameInLog); $fileToHttp =~ s/\.json\s*$/_$currentTime\.json/;
				$_ =~ s/__lt__/&lt;/g; $_ =~ s/__gt__/&gt;/g;
				if ( -e $fileFrom ) { 
					if ( -e &getDir($fileToFile)){ ; } else {mkpath &getDir($fileToFile); }
					# copy ($fileFrom, $fileToFile);
					&addHtml ($fileFrom, $fileToFile);
					$fileToHttp =~ s/$c\/$_TAF/${ip}${http_port}/;	
					$return = $return.$match1."<a href=\"http://$fileToHttp\"  >$fileFrom</a> $match3";
					#### tech reserver $return = $return.$match1."<a href=\"file:////$fileToFile\">(file:$fileFrom)</a> $match3";
				} else {
					$return = $return.$match1."Warning: Log $fileFrom doesn't exist! $match3";
				}
				##
			} elsif ($logNameInLog =~ /\.xml\s*$/i) {

				$logNameInLog =~ s/\\/\//g;
				my $currentTime  = &UnixDate( "now", "%m-%d-%Y-%H_%M_%S" );
				my $fileFrom = $logNameInLog ; 
				my $fileToFile   = &getTCName()."/".&getRoot_4($logNameInLog); $fileToFile =~ s/\.xml\s*$/_$currentTime\.xml/;
				my $fileToHttp   = &getTCName()."/".&getRoot_4($logNameInLog); $fileToHttp =~ s/\.xml\s*$/_$currentTime\.xml/;
				$_ =~ s/__lt__/&lt;/g; $_ =~ s/__gt__/&gt;/g;
				if ( -e $fileFrom ) { 
					if ( -e &getDir($fileToFile)){ ; } else {mkpath &getDir($fileToFile); }
					# copy ($fileFrom, $fileToFile);
					&addHtml ($fileFrom, $fileToFile);
					$fileToHttp =~ s/$c\/$_TAF/${ip}${http_port}/;	
					$return = $return.$match1."<a href=\"http://$fileToHttp\"  >$fileFrom</a> $match3";
					#### tech reserver $return = $return.$match1."<a href=\"file:////$fileToFile\">(file:$fileFrom)</a> $match3";
				} else {
					$return = $return.$match1."Warning: Log $fileFrom doesn't exist! $match3";
				}

				##

			} elsif ($logNameInLog =~ /\.gif\s*$/i) {

				$logNameInLog =~ s/\\/\//g;
				my $currentTime  = &UnixDate( "now", "%m-%d-%Y-%H_%M_%S" );
				my $fileFrom = $logNameInLog ; 
				my $fileToFile   = &getTCName()."/".&getRoot_4($logNameInLog); $fileToFile =~ s/\.gif\s*$/_$currentTime\.gif/;
				my $fileToHttp   = &getTCName()."/".&getRoot_4($logNameInLog); $fileToHttp =~ s/\.gif\s*$/_$currentTime\.gif/;
				$_ =~ s/__lt__/&lt;/g; $_ =~ s/__gt__/&gt;/g;
				if ( -e $fileFrom ) { 
					if ( -e &getDir($fileToFile)){ ; } else {mkpath &getDir($fileToFile); }
					 copy ($fileFrom, $fileToFile);
					 copy ($fileFrom, &getTCName_TAF($logNameInLog));
					$fileToHttp =~ s/$c\/$_TAF/${ip}${http_port_IIS}/;	
					$return = $return.$match1."<a href=\"http://$fileToHttp\"  >$fileFrom</a> $match3";
					#### tech reserver $return = $return.$match1."<a href=\"file:////$fileToFile\">(file:$fileFrom)</a> $match3";
				} else {
					$return = $return.$match1."Warning: Log $fileFrom doesn't exist! $match3";
				}

				####

			} elsif ($logNameInLog =~ /\.cgi\s*$/i) {

				$logNameInLog =~ s/\\/\//g;
				my $currentTime  = &UnixDate( "now", "%m-%d-%Y-%H_%M_%S" );
				my $fileFrom = $logNameInLog ; 
				my $fileToFile   = &getTCName()."/".&getRoot_4($logNameInLog); $fileToFile =~ s/\.cgi\s*$/_$currentTime\.cgi\.txt/;
				my $fileToHttp   = &getTCName()."/".&getRoot_4($logNameInLog); $fileToHttp =~ s/\.cgi\s*$/_$currentTime\.cgi\.txt/;
				$_ =~ s/__lt__/&lt;/g; $_ =~ s/__gt__/&gt;/g;
				if ( -e $fileFrom ) { 
					if ( -e &getDir($fileToFile)){ ; } else {mkpath &getDir($fileToFile); }
					 copy ($fileFrom, $fileToFile);
					 copy ($fileFrom, &getTCName_TAF($logNameInLog));
					$fileToHttp =~ s/$c\/$_TAF/${ip}${http_port_IIS}/;	
					$return = $return.$match1."<a href=\"http://$fileToHttp\"  >$fileFrom</a> $match3";
					#### tech reserver $return = $return.$match1."<a href=\"file:////$fileToFile\">(file:$fileFrom)</a> $match3";
				} else {
					$return = $return.$match1."Warning: Log $fileFrom doesn't exist! $match3";
				}	


				####
			} elsif ($logNameInLog =~ /\.log\s*$/i) {

				$logNameInLog =~ s/\\/\//g;
				my $currentTime  = &UnixDate( "now", "%m-%d-%Y-%H_%M_%S" );
				my $fileFrom = $logNameInLog ; 
				my $fileToFile   = &getTCName()."/".&getRoot_4($logNameInLog); $fileToFile =~ s/\.log\s*$/_$currentTime\.log\.txt/;
				my $fileToHttp   = &getTCName()."/".&getRoot_4($logNameInLog); $fileToHttp =~ s/\.log\s*$/_$currentTime\.log\.txt/;
				$_ =~ s/__lt__/&lt;/g; $_ =~ s/__gt__/&gt;/g;
				if ( -e $fileFrom ) { 
					if ( -e &getDir($fileToFile)){ ; } else {mkpath &getDir($fileToFile); }
					 copy ($fileFrom, $fileToFile);
					 copy ($fileFrom, &getTCName_TAF($logNameInLog));
					$fileToHttp =~ s/$c\/$_TAF/${ip}${http_port_IIS}/;	
					$return = $return.$match1."<a href=\"http://$fileToHttp\"  >$fileFrom</a> $match3";
					#### tech reserver $return = $return.$match1."<a href=\"file:////$fileToFile\">(file:$fileFrom)</a> $match3";
				} else {
					$return = $return.$match1."Warning: Log $fileFrom doesn't exist! $match3";
				}

			} elsif ($logNameInLog =~ /\.xls\s*$/i) {

				$logNameInLog =~ s/\\/\//g;
				my $currentTime  = &UnixDate( "now", "%m-%d-%Y-%H_%M_%S" );
				my $fileFrom = $logNameInLog ; 
				my $fileToFile   = &getTCName()."/".&getRoot_4($logNameInLog); $fileToFile =~ s/\.xls\s*$/_$currentTime\.xls/;
				my $fileToHttp   = &getTCName()."/".&getRoot_4($logNameInLog); $fileToHttp =~ s/\.xls\s*$/_$currentTime\.xls/;
				$_ =~ s/__lt__/&lt;/g; $_ =~ s/__gt__/&gt;/g;
				if ( -e $fileFrom ) { 
					if ( -e &getDir($fileToFile)){ ; } else {mkpath &getDir($fileToFile); }
					 copy ($fileFrom, $fileToFile);
					 copy ($fileFrom, &getTCName_TAF($logNameInLog));
					$fileToHttp =~ s/$c\/$_TAF/${ip}${http_port_IIS}/;	
					$return = $return.$match1."<a href=\"http://$fileToHttp\"  >$fileFrom</a> $match3";
					#### tech reserver $return = $return.$match1."<a href=\"file:////$fileToFile\">(file:$fileFrom)</a> $match3";
				} else {
					$return = $return.$match1."Warning: Log $fileFrom doesn't exist! $match3";
				}


				##



			  } else {


				$return = $return.$_."\n";
			}
		} else { 
			if (($_ =~ s/_url_line_//i) || ($_ =~ s/_no_txt_file_parsing_//i)) {;} else {
			$_ =~ s/</__lt__/g; $_ =~ s/>/__gt__/g; 
			$_ =~ s/__lt__/&lt;/g; $_ =~ s/__gt__/&gt;/g;
			}
			if ($_ =~ /_mime_file_(.*)_mime_file_/i) {
				my $mime_file = $1; my $mime_name = $mime_file;
					if ($_ =~ s/_mime_name_(.+)_mime_name_//g) {
						$mime_name = $1;
					}
				$_ = "<a href=\"http://${ip}${http_port_mime}/$SvrProjName/$mime_file\">$mime_name</a>"; 
				if ( -e "$c/$SvrProjName/$mime_file") {
					copy ("$c/$SvrProjName/$mime_file", "$c/$_TAF/$SvrProjName/$mime_file");
				} else { 
					print "Warning: $c/$SvrProjName/$mime_file doens't exist\n"; 
				}
			}
			$return = $return.$_."\n";
		}
	} 
			$return =~ s/__lt__/&lt;/g; $return =~ s/__gt__/&gt;/g; ### 
$return ;
}
sub addURLs_old {
	my $return="";	
	foreach my $each (split "\n", shift ) {

		$_ = $each;
		s/_/_underscore_/g; s/\s/_ws_/g; s/\./_dot_/g; s/\\/_backslash_/g; s/\//_slash_/g; s/:/_col_/g; s/-/_dash_/g; s/\(/_leftPara/g; s/\)/_rightPara/g; s/</_lessThan/g; s/>/_greaterThan/g;s/=/_equal/g;
		s/"/_doubleQuote/g;
		s/'/_singleQuote/g;
		s/\$/_dollar_/g;
		s/\%/_percentage_/g;
		s/\@/_at_/g;
		s/;/_semiColumn_/g;
		s/\W//g;
		s/\_ws_/ /g; s/_dot_/\./g; s/_backslash_/\\/g; s/_slash_/\//g; s/_col_/:/g; s/_dash_/-/g; s/_underscore_/_/g; s/_leftPara/\(/g; s/_rightPara/\)/g; s/_lessThan/</g; s/_greaterThan/>/g;s/_equal/=/g;
		s/_doubleQuote/"/g;
		s/_singleQuote/'/g;
		s/_dollar_/\$/g;
		s/_percentage_/\%/g;
		s/_at_/\@/g;
		s/_semiColumn_/;/g;
		if (($_ !~ /href=\"/) && ($_ =~ /(.+)($c\S+)\s?(.+)?/i)) { # convert c:\abc.txt  <a href file= abc.txt </a>
			my $match1 = $1; my $match2 = $2; my $match3=""; if ($3) {$match3 = $3;}

			if ($match2 =~ /\.txt\s*$/) { 
			my $currentTime  = &UnixDate( "now", "%m-%d-%Y-%H_%M_%S" );
			my $fileFrom = $match2; 
			my $fileTo   = $match2; $fileTo =~ s/\.txt\s*$/_$currentTime\.txt/;
			#copy ($fileFrom, $fileTo);
			&addHtml ($fileFrom, $fileTo);
			$return = $return.$match1."<a href=\"file:////$fileTo\">$fileTo</a>$match3\n";
			} else {
			$return = $return.$_."\n";
			}
		} else { 
			$return = $return.$_."\n";
		}
	} 

$return ;
}

sub addHtml {
	my $FNameFrom	= shift; my $FNameTo  	= shift; my $str;
	if (-e &getDir($FNameTo)) {;} else { mkpath &getDir($FNameTo);}
	if (-e $FNameFrom) {
		open FNameTo  , ">$FNameTo"; 
		open FNameFrom, $FNameFrom ; @_ = <FNameFrom>; $str .= "@_"; close FNameFrom;
	   if ($FNameFrom !~ /xml\s*$/) {	
		$str =~ s/\r|\n/_realReturn_/ig; 
		$str =~ s/\x{d}/_return_/ig; $str =~ s/\s*\x{8}//ig; 	# processing return and BS 
		$str =~ s/_return_/....../g; # $str =~ s/\s+/_space_/g; $str =~ s/_space_/ /g;
		#$str =~ s/</      ..../ig if ($str !~ /<a/); 
		# $str =~ s/>/      ..../ig if ($str !~ /a>/);
		$str =~ s/</&lt;/ig if ($str !~ /<a/); 
		$str =~ s/>/&gt;/ig if ($str !~ /a>/);
		$str =~ s/(_realReturn_)+/\n/g;
		$str = "\n<pre>\n$str\n</pre>\n";
           }
		print FNameTo $str;
		close FNameTo;
	} else {
	print "Warning: addHtml: $FNameFrom deesn't exist!\n";
	}

}
sub addHtml_v2 {
	my $FNameFrom	= shift; my $FNameTo  	= shift; my $str;
	if (-e &getDir($FNameTo)) {;} else { mkpath &getDir($FNameTo);}
	if (-e $FNameFrom) {
		open FNameTo  , ">$FNameTo"; 
		open FNameFrom, $FNameFrom ; @_ = <FNameFrom>; $str .= "@_"; close FNameFrom;
	
		$str =~ s/\r|\n/_realReturn_/ig; 
		$str =~ s/\x{d}/_return_/ig; $str =~ s/\s*\x{8}//ig; 	# processing return and BS 
		$str =~ s/_return_/....../g; # $str =~ s/\s+/_space_/g; $str =~ s/_space_/ /g;
		$str =~ s/</      ..../ig if ($str !~ /<a/);
		$str =~ s/>/      ..../ig if ($str !~ /a>/);
		$str =~ s/(_realReturn_)+/\n/g;
		$str = "\n<pre>\n$str\n</pre>\n";

		print FNameTo $str;
		close FNameTo;
	} else {
	print "Warning: addHtml: $FNameFrom deesn't exist!\n";
	}

}
sub addHtml_v1 {
	my $FNameFrom	= shift; my $FNameTo  	= shift; my $str;
	if (-e &getDir($FNameTo)) {;} else { mkpath &getDir($FNameTo);}
	if (-e $FNameFrom) {
		open FNameTo  , ">$FNameTo"; 
		open FNameFrom, $FNameFrom ; @_ = <FNameFrom>; $str .= "@_"; close FNameFrom;
		
		$str =~ s/\r|\n/_realReturn_/ig; 
		$str =~ s/\x{d}/_return_/ig; $str =~ s/\s*\x{8}//ig; 	# processing return and BS 
		$str =~ s/_return_/....../g; $str =~ s/\s+/_space_/g; $str =~ s/_space_/ /g;
		$str =~ s/</      ..../ig ; #if ($str !~ /<a/);
		$str =~ s/>/      ..../ig ; # if ($str !~ /a>/);
		$str =~ s/(_realReturn_)+/\n/g;
		$str = "\n<pre>\n$str\n</pre>\n";

		print FNameTo $str;
		close FNameTo;
	} else {
	print "Warning: addHtml: $FNameFrom deesn't exist!\n";
	}

}
sub addHtml_v0 {
	my $FNameFrom	= shift; my $FNameTo  	= shift;
	if (-e &getDir($FNameTo)) {;} else { mkpath &getDir($FNameTo);}
	if (-e $FNameFrom) {
		open FNameTo  , ">$FNameTo"; 
		print FNameTo "\n<pre>\n";
		open FNameFrom, $FNameFrom ; @_ = <FNameFrom>; 
		my $str = "@_"; 
		$str =~ s/\x{d}+/_rtn_/ig;	
		$str =~ s/\x{d}+/_rtn_/ig;	
		$str =~ s/\x{d}+/_rtn_/ig;	
		$str =~ s/\x{d}+/_rtn_/ig;	
		$str =~ s/\x{d}+/_rtn_/ig;	
		$str =~ s/\s*\x{8}/_bs_/ig;	
		#print FNameTo "@_";
		print FNameTo $str;
		print FNameTo "</pre>\n";
		close FNameFrom;
		close FNameTo;
	} else {
	print "Warning: addHtml: $FNameFrom deesn't exist!\n";
	}

}

sub ps12txt {
	my $return="";	
	foreach my $each (split "\n", shift ) {
		$_ = $each;
		s/_/_underscore_/g; s/\s/_ws_/g; s/\./_dot_/g; s/\\/_backslash_/g; s/\//_slash_/g; s/:/_col_/g; s/-/_dash_/g; 
		s/\W//g;
		s/\_ws_/ /g; s/_dot_/\./g; s/_backslash_/\\/g; s/_slash_/\//g; s/_col_/:/g; s/_dash_/-/g; s/_underscore_/_/g;
		s/^\s*//g;
		$return = $return."\n".$_;
	} 
	$return ;
}

sub addUrl {
	my $return; my $str = shift;
	foreach my $each (split /\n/, $str) {
		if ($each =~ /^\s*(.+\.html)/)  { 
			my $line = $1;
			$line =~ s/^\s*//g;
			$line =~ s/\s*$//g;
			$line =~ s/\\/\//g;
			$line =~ s/HTML:\s*/file:\/\/\//i;
			$line =~ s//file:\/\/\//;
			$return = $return.  "<a href=\"$line\">$each</a>\n";
		} elsif ($each =~ /^\s*(.+\.xml)/)  { 
			my $line = $1;
			$line =~ s/^\s*//g;
			$line =~ s/\s*$//g;
			$line =~ s/\\/\//g;
			$line =~ s/XML:\s*/file:\/\/\//i;
			$line =~ s//file:\/\/\//;
			$return = $return.  "<a href=\"$line\">$each</a>\n";
		} else {
			$return = $return.$each."\n";
		}
	}
	return $return;
}

################################################################################
#	Subroutine Name : getTCLogFname
#		Function: get valid Log (new log) fname 
#	Input Parameters: c:\TC*\_thLog.txt
#	Output/Returns  : noLog or hasWWWLog
################################################################################
sub getTCLogFname	{    	# 	Determine if a log exists (TH:TC Report)
    my $tcName  = shift;
    my ( $dev,  $ino,   $mode,  $nlink, $uid,     $gid, $rdev,
		$size, $atime, $mtimePropertyFile, $ctime, $blksize, $blocks
	    );
	my $mtimeLogWeb; 

    if (-e $tcName.'/thProperty.txt' )
     {
	    (
		$dev,  $ino,   $mode,  $nlink, $uid,     $gid, $rdev,
		$size, $atime, $mtimePropertyFile, $ctime, $blksize, $blocks
	    ) = stat($tcName.'/'.'thProperty.txt');
    }
    my $tcNameLog = $tcName."/_tcLogAppend.txt";
    if (-e $tcNameLog) {
	    my (
		$dev,  $ino,   $mode,  $nlink, $uid,     $gid, $rdev,
		$size, $atime, $mtimeLog, $ctime, $blksize, $blocks
	    ) = stat($tcNameLog);
		if ($mtimePropertyFile - $mtimeLog>= 0 ) { return $tcNameLog; }
    }

    $tcNameLog = "$tcName/_tcLog.txt";
    if (-e $tcNameLog) {
	    my (
		$dev,  $ino,   $mode,  $nlink, $uid,     $gid, $rdev,
		$size, $atime, $mtimeLog, $ctime, $blksize, $blocks
	    ) = stat($tcNameLog);
	    if ( $mtimePropertyFile - $mtimeLog>= 2 ) { return $tcNameLog; }
    }
    return "noLog"; 
}

sub getTCLogFname_	{    	# 	Determine if a log exists (TH:TC Report)
    my $tcName  = shift;
    my ( $dev,  $ino,   $mode,  $nlink, $uid,     $gid, $rdev,
		$size, $atime, $mtimePropertyFile, $ctime, $blksize, $blocks
	    );
	my $mtimeLogWeb; 

    if (-e $tcName.'/thProperty.txt' )
     {
	    (
		$dev,  $ino,   $mode,  $nlink, $uid,     $gid, $rdev,
		$size, $atime, $mtimePropertyFile, $ctime, $blksize, $blocks
	    ) = stat($tcName.'/'.'thProperty.txt');
    }

    my $tcNameLog = $tcName."/_tcLogAppend_.txt";
    if (-e $tcNameLog) {
	    my (
		$dev,  $ino,   $mode,  $nlink, $uid,     $gid, $rdev,
		$size, $atime, $mtimeLog, $ctime, $blksize, $blocks
	    ) = stat($tcNameLog);
		if ($mtimePropertyFile - $mtimeLog>= 0 ) { return $tcNameLog; }
    }

    $tcNameLog = "$tcName/_tcLog_.txt";
    if (-e $tcNameLog) {
	    my (
		$dev,  $ino,   $mode,  $nlink, $uid,     $gid, $rdev,
		$size, $atime, $mtimeLog, $ctime, $blksize, $blocks
	    ) = stat($tcNameLog);
	    if ( $mtimePropertyFile - $mtimeLog>= 2 ) { return $tcNameLog; }
    }
    return "noLog"; 
}

sub getTCLogFname__	{    	# 	Determine if a log exists (TH:TC Report)
    my $tcName  = shift;
    my ( $dev,  $ino,   $mode,  $nlink, $uid,     $gid, $rdev,
		$size, $atime, $mtimePropertyFile, $ctime, $blksize, $blocks
	    );
	my $mtimeLogWeb; 

    if (-e $tcName.'/thProperty.txt' )
     {
	    (
		$dev,  $ino,   $mode,  $nlink, $uid,     $gid, $rdev,
		$size, $atime, $mtimePropertyFile, $ctime, $blksize, $blocks
	    ) = stat($tcName.'/'.'thProperty.txt');
    }

    my $tcNameLog = $tcName."/_tcLogAppend__.txt";
    if (-e $tcNameLog) {
	    my (
		$dev,  $ino,   $mode,  $nlink, $uid,     $gid, $rdev,
		$size, $atime, $mtimeLog, $ctime, $blksize, $blocks
	    ) = stat($tcNameLog);
		if ($mtimePropertyFile - $mtimeLog>= 0 ) { return $tcNameLog; }
    }

    $tcNameLog = "$tcName/_tcLog__.txt";
    if (-e $tcNameLog) {
	    my (
		$dev,  $ino,   $mode,  $nlink, $uid,     $gid, $rdev,
		$size, $atime, $mtimeLog, $ctime, $blksize, $blocks
	    ) = stat($tcNameLog);
	    if ( $mtimePropertyFile - $mtimeLog>= 2 ) { return $tcNameLog; }
    }
    return "noLog"; 
}

sub sortOnDate {
	my $return; my %record; my $str = shift;  if ($str =~ /^\s*$/) { return " ";}
	if ($str =~ /^\s*$/) { return "";}
	@_ = split(/\n/, $str); 
	foreach my $each (@_) { if ($each =~ /^\s*(\S+)\s+\S+\s+(\d+-\d+-\d+\s+\d+:\d+:\d+\s+).+$/) { my $rst = $1; $record{$2}=$each if ($rst !~ /mark/i && $rst !~ /dumy/i);}}
	foreach my $each (reverse sort keys %record) { 
		my $record_str = $record{$each}; 

		if ($record_str =~ /^\s*(\w+)\s+(\d+\s*\w+)\s+(\d+-\d+-\d+\s+\d+:\d+:\d+)\s+(\w+\s+\w+\s+\(\w+\))\s+(.+)/) {

		my $_passFail 	= ""; $_passFail = $1; 
		my $_time 	= ""; $_time	= $2;
		my $_date 	= ""; $_date	= $3;
	       	my $_comment1	= ""; $_comment1=$4;
		my $_comment2	= $5; $_comment2=$5;
		#print  " -------> <tr><td>$_passFail</td><td>$_time</td><td>$_date</td><td>$_comment1</td><td>$_comment2</td></tr>\n";
		$record_str = "<tr><td>$_passFail</td><td>$_time</td><td>$_date</td><td>$_comment1</td><td>$_comment2</td></tr>\n";
		$return = $return."$record_str"; }
		#$return = $return."$record{$each}\n"; } 
	}
	return $return;
}


sub sortOnDate_orig {
	my $return; my %record; my $str = shift;  if ($str =~ /^\s*$/) { return " ";}
	if ($str =~ /^\s*$/) { return "";}
	@_ = split(/\n/, $str); 
	foreach my $each (@_) { if ($each =~ /^\s*(\S+)\s+\S+\s+(\d+-\d+-\d+\s+\d+:\d+:\d+\s+).+$/) { my $rst = $1; $record{$2}=$each if ($rst !~ /mark/i && $rst !~ /dumy/i);}}
	foreach my $each (reverse sort keys %record) { $return = $return."$record{$each}\n"; } 
	return $return;
}
sub reportTCSummary {
	$reportHtmlSummaryStr = '';  

	if ( -e "$SvrDrive/$SvrProjName/$reportHtmlHistory" ) {;} else { return; }
	open Fin, "$SvrDrive/$SvrProjName/$reportHtmlHistory" || die "Can't open _tcReportHistory.html";

	my $fname_ =	$SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlSummary."_"; 
	while (-e $SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlSummary."_") { my $mtime = ( stat $fname_)[9]; my $current_time = time;  my $diff = $current_time - $mtime; if ($diff > $MaxTCExecTime) { last; } sleep 1; }

	open Fout, "> $SvrDrive/$SvrProjName/$reportHtmlSummary"."_" || die "Can't open _tcReportSummary_.html";

	$reportHtmlSummaryStr = "<html><title>$web_ui_title</title><body><pre>\n"; $reportHtmlSummaryStr = $reportHtmlSummaryStr . "<META http-equiv=\"refresh\" content=\"$htmlRefreshRateWebUI\"> ";
	$reportHtmlSummaryStr = $reportHtmlSummaryStr .  "\n_replace_here_";
 	my $passFail ; my $dateTime; my $date1; my $date2; my %tcResult; my $tcName; my $passCtr=0;
	my $initStartTime = &UnixDate( "Jan 1, 2050", "%m/%d/%Y %H:%M:%S %Z" );
	my $endStartTime  = &UnixDate( "Jan 1, 1950", "%m/%d/%Y %H:%M:%S %Z" );
while ($_ =<Fin>) { 
	chop;
	if (($_ =~ /(testcase\d+)/) &&( $passCtr ==0 )) {
		$tcName = $1;	
		$reportHtmlSummaryStr = $reportHtmlSummaryStr . "\n$tcName: ";
		$_ = <Fin>;
		if ($_ =~ /^\s+(\w+)\s+\w+\s+(\d+\-\d+\-\d+\s+\d+:\d+:\d+)\s+/) { # always skip
		$_ =~ /^\s+(\w+)\s+\w+\s+(\d+\-\d+\-\d+\s+\d+:\d+:\d+)\s+/;
		$passFail = $1; $dateTime= $2; $date1=&ParseDate($dateTime);  my $title=" title=\"$dateTime\"";
		if (&Date_Cmp( &ParseDate($initStartTime), &ParseDate($dateTime) ) >=0 ) { $initStartTime = $dateTime; }
		if (&Date_Cmp( &ParseDate($endStartTime),  &ParseDate($dateTime) ) <=0 ) { $endStartTime  = $dateTime; }
		if    ($passFail =~ /pass/i) { $passFail = '<a style="color:green"'.$title.'>*</a>';	} 
		elsif ($passFail =~ /fail/i) { $passFail = '<a style="color:red"'.$title.'>*</a>';} 
		elsif ($passFail =~ /mark/i) {$passFail ="<a style=\"color:black\"$title>$markSymbol<\/a>";}
		elsif ($passFail =~ /Perf/i) {$passFail ="<a style=\"color:black\"$title>.<\/a>";}
		elsif ($passFail =~ /null/i) {$passFail ="<a style=\"color:black\"$title>.<\/a>";}
		elsif ($passFail =~ /dumy/i) {$passFail ="<a style=\"color:black\"$title> <\/a>";}
		elsif ($passFail =~ /expF/i) {$passFail ="<a style=\"color:black\"$title>*<\/a>";}
		elsif ($passFail =~ /bugF/i) {$passFail ="<a style=\"color:blue\"$title>*<\/a>";}
		$reportHtmlSummaryStr = $reportHtmlSummaryStr . $passFail;
		}
	} elsif (/^\s+(\w+)\s+\w+\s+(\d+\-\d+\-\d+\s+\d+:\d+:\d+\s+)/) {
		$_ =~ /^\s+(\w+)\s+\w+\s+(\d+\-\d+\-\d+\s+\d+:\d+:\d+)\s+(.+)/;
		my $note=$3;
		$passFail = $1; $dateTime= $2; $date2=&ParseDate($dateTime); 
		my $title = " title=\"$dateTime $note\""; 

		if ($passFail =~ /pass/i) { $passFail = '<a style="color:green"'.$title.'>*</a>';	} 
		elsif ($passFail =~ /fail/i)  { $passFail = '<a style="color:red"'.$title.'>*</a>';} 
		elsif ($passFail =~ /null/i) { $passFail = '<a style="color:black"'.$title.'>.</a>';}
		elsif ($passFail =~ /mark/i) {$passFail ="<a style=\"color:black\"$title>$markSymbol<\/a>";}
		elsif ($passFail =~ /Perf/i) {$passFail ="<a style=\"color:black\"$title>.<\/a>";}
		elsif ($passFail =~ /null/i) {$passFail ="<a style=\"color:black\"$title>.<\/a>";}
		elsif ($passFail =~ /dumy/i) {$passFail ="<a style=\"color:black\"$title> <\/a>";}
		elsif ($passFail =~ /expF/i) {$passFail ="<a style=\"color:black\"$title>*<\/a>";}
		elsif ($passFail =~ /bugF/i) {$passFail ="<a style=\"color:blue\"$title>*<\/a>";}
		if (&Date_Cmp( &ParseDate($initStartTime), &ParseDate($dateTime) ) >=0 ) { $initStartTime = $dateTime; }
		if (&Date_Cmp( &ParseDate($endStartTime),  &ParseDate($dateTime) ) <=0 ) { $endStartTime  = $dateTime; }

		my $delta=&DateCalc($date2,$date1); $delta =~ s/\+//g; my ($Y,$M,$W,$D,$H,$MIN,$S) = split /:/, $delta;
		my $totalMIN ;
		if ($Y && $M && $D && $H && $MIN && $S && $reportHtmlSummaryScale) {	
		$totalMIN = int ((((($Y*365 + $M * 30 + $D) * 24 + $H) * 60 + $MIN) * 60 + $S)/$reportHtmlSummaryScale) ;
		} else {
		$totalMIN = 0;
		}
		$reportHtmlSummaryStr = $reportHtmlSummaryStr . $passFail;
	}
}

 	my $totalTimeSpan = &DateCalc($initStartTime,$endStartTime);  my ($Y,$M,$W,$D,$H,$MIN,$S) = split /:/, $totalTimeSpan;
	my $NofX          = int ((((($Y*365 + $M * 30 + $D) * 24 + $H) * 60 + $MIN) * 60 + $S)/$reportHtmlSummaryScale) ;
	my $X_Unit = int (3600/$reportHtmlSummaryScale);	

	$reportHtmlSummaryStr = $reportHtmlSummaryStr. "\n_replace_here_\n";
	$reportHtmlSummaryStr = $reportHtmlSummaryStr .  "</pre></body></html>\n";

	my $tmp = "---------- |<marquee width = 50><--</marquee> ".&UnixDate($endStartTime, "%m/%d/%Y %H:%M:%S %Z")." ---------- $SvrDrive/$SvrProjName Test Summary -----...... <marquee width = 50><--</marquee>|". &UnixDate($initStartTime,  "%m/%d/%Y %H:%M:%S %Z" );
	$reportHtmlSummaryStr =~  s/_replace_here_/$tmp/g;
	print Fout $reportHtmlSummaryStr;
	close Fout;
	close Fin;
	move ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlSummary."_", $SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlSummary);

}
################################################################################
#	Subroutine Name : reportTCHistory
#		Function: append TC result History to htmlLog
#	Input Parameters: Test Case name
################################################################################
sub reportTCHistory_ {
	my $tcname = shift;
	my $fileText = sprintf "%10s %s", "", &reportTC($tcname,"","History");
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, " ---------------------- TestCase: <a name=\"".&getTCName($tcname)."\"> ".&getTCName($tcname)." </a>-----------------------\n");
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, $fileText);
}


sub reportTCHistory {
	my $tcIdCtr_ = $tcIdCtr;
	my $tcname = shift;
	$tcIdCtr=1;
 	&createFile_($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory,"");
 	&appendtoFile_($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory,"<html><title>$web_ui_title</title><body><pre>\n");
###### Great Discovery for dumy  temporal find({ preprocess => sub {return sort @_;}, wanted=> sub {if (  ($File::Find::name =~ /tc.pl\s*$/) && ($File::Find::name =~ /$SvrDrive\/$SvrProjName\/$testcaseNode/i) && ($File::Find::name =~ /$SvrTCNamePattern/i)  ) { # fix tcDesc tag related 



find({ preprocess => sub {return sort @_;}, wanted=> sub {if (  ($File::Find::name =~ /tc.pl\s*$/) && ($File::Find::name =~ /$SvrDrive\/$SvrProjName\/$testcaseNode/i)  ) { # fix tcDesc tag related 
			$SvrTCName = $File::Find::name; 
			$SvrTCName =~ s/\/tc.pl//g;
	my $fileText = sprintf "%10s %s", "", &reportTC($tcname,"","History");  if ($fileText =~ /^\s*$/) { $fileText = " ";}
	$fileText = &sortOnDate($fileText); 
	if ($tcDesc[$tcIdCtr]) {;} else { $tcDesc[$tcIdCtr] ="tcDesc is unavailable. It will be updated in next \"list\"";}
	#&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, " ---- TestCase $tcIdCtr: <a name=\"".&getTCName($tcname)."\"> ".&processProperty("",$SvrTCName, "get_tcDesc")."</a>----\n");
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, '<h3 class="tc-history-tc-name">TestCase'.$tcIdCtr.': <a name="'.&getTCName($tcname).'">'.&processProperty("",$SvrTCName, "get_tcDesc").'</a></h3><div class="tc-results-history">'."\n");
	if (defined $fileText) { ; } else { $fileText="";}
	#&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "$fileText") if ( $fileText !~ /^\s*$/) ;
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "<table>\n<thead><tr>\n<th>Pass/Fail</th>\n<th>Run Time</th>\n<th>Time &amp; Date</th>\n<th>Name</th>\n<th>Comment</th>\n</tr></thead>\n") ;
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "$fileText") if ( $fileText !~ /^\s*$/) ;
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "<tbody></table></div>\n") ;

	$tcIdCtr++;
		}
	 }}, "$SvrDrive/$SvrProjName");
	##&appendtoFile_($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory,"</pre></body></html>\n")				;
	#&addHtmlToolBar($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory)				;

	$tcIdCtr = $tcIdCtr_;
}


sub reportTCHistory_mokup_version {
	my $tcIdCtr_ = $tcIdCtr;
	my $tcname = shift;
	$tcIdCtr=1;
 	&createFile_($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory,"");
 	&appendtoFile_($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory,"<html><title>$web_ui_title</title><body><pre>\n");
###### Great Discovery for dumy  temporal find({ preprocess => sub {return sort @_;}, wanted=> sub {if (  ($File::Find::name =~ /tc.pl\s*$/) && ($File::Find::name =~ /$SvrDrive\/$SvrProjName\/$testcaseNode/i) && ($File::Find::name =~ /$SvrTCNamePattern/i)  ) { # fix tcDesc tag related 



find({ preprocess => sub {return sort @_;}, wanted=> sub {if (  ($File::Find::name =~ /tc.pl\s*$/) && ($File::Find::name =~ /$SvrDrive\/$SvrProjName\/$testcaseNode/i)  ) { # fix tcDesc tag related 
			$SvrTCName = $File::Find::name; 
			$SvrTCName =~ s/\/tc.pl//g;
	my $fileText = sprintf "%10s %s", "", &reportTC($tcname,"","History");  if ($fileText =~ /^\s*$/) { $fileText = " ";}
	$fileText = &sortOnDate($fileText); 
	if ($tcDesc[$tcIdCtr]) {;} else { $tcDesc[$tcIdCtr] ="tcDesc is unavailable. It will be updated in next \"list\"";}
	#&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, " ---- TestCase $tcIdCtr: <a name=\"".&getTCName($tcname)."\"> ".&processProperty("",$SvrTCName, "get_tcDesc")."</a>----\n");
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, '<h3 class="tc-history-tc-name">TestCase'.$tcIdCtr.': <a name="'.&getTCName($tcname).'">'.&processProperty("",$SvrTCName, "get_tcDesc").'</a></h3><div class="tc-results-history">'."\n");
	if (defined $fileText) { ; } else { $fileText="";}
	#&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "$fileText") if ( $fileText !~ /^\s*$/) ;
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "<table><thead><tr><th>Pass/Fail</th><th>Run Time</th><th>Time &amp; Date</th><th>Name</th><th>Comment</th></tr></thead>\n") ;
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "<tr><td>Pass</td><td>57s</td><td>13434-343 23:34:34</td><td>Function Test (pass)</td><td>PlaceHolder Comment</td></tr>\n") ;
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "<tr><td>Pass</td><td>57s</td><td>13434-343 23:34:34</td><td>Function Test (pass)</td><td>PlaceHolder Comment</td></tr>\n") ;
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "<tr><td>Pass</td><td>57s</td><td>13434-343 23:34:34</td><td>Function Test (pass)</td><td>PlaceHolder Comment</td></tr>\n") ;
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "<tr><td>Pass</td><td>57s</td><td>13434-343 23:34:34</td><td>Function Test (pass)</td><td>PlaceHolder Comment</td></tr>\n") ;
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "<tr><td>Pass</td><td>57s</td><td>13434-343 23:34:34</td><td>Function Test (pass)</td><td>PlaceHolder Comment</td></tr>\n") ;
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "<tr><td>Pass</td><td>57s</td><td>13434-343 23:34:34</td><td>Function Test (pass)</td><td>PlaceHolder Comment</td></tr>\n") ;
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "<tr><td>Pass</td><td>57s</td><td>13434-343 23:34:34</td><td>Function Test (pass)</td><td>PlaceHolder Comment</td></tr>\n") ;
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "<tr><td>Pass</td><td>57s</td><td>13434-343 23:34:34</td><td>Function Test (pass)</td><td>PlaceHolder Comment</td></tr>\n") ;
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "<tr><td>Pass</td><td>57s</td><td>13434-343 23:34:34</td><td>Function Test (pass)</td><td>PlaceHolder Comment</td></tr>\n") ;
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "<tr><td>Pass</td><td>57s</td><td>13434-343 23:34:34</td><td>Function Test (pass)</td><td>PlaceHolder Comment</td></tr>\n") ;
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "<tr><td>Pass</td><td>57s</td><td>13434-343 23:34:34</td><td>Function Test (pass)</td><td>PlaceHolder Comment</td></tr>\n") ;
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "<tr><td>Pass</td><td>57s</td><td>13434-343 23:34:34</td><td>Function Test (pass)</td><td>PlaceHolder Comment</td></tr>\n") ;
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "<tr><td>Pass</td><td>57s</td><td>13434-343 23:34:34</td><td>Function Test (pass)</td><td>PlaceHolder Comment</td></tr>\n") ;
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "<tr><td>Pass</td><td>57s</td><td>13434-343 23:34:34</td><td>Function Test (pass)</td><td>PlaceHolder Comment</td></tr>\n") ;
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "<tr><td>Pass</td><td>57s</td><td>13434-343 23:34:34</td><td>Function Test (pass)</td><td>PlaceHolder Comment</td></tr>\n") ;
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "<tr><td>Pass</td><td>57s</td><td>13434-343 23:34:34</td><td>Function Test (pass)</td><td>PlaceHolder Comment</td></tr>\n") ;
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "<tr><td>Pass</td><td>57s</td><td>13434-343 23:34:34</td><td>Function Test (pass)</td><td>PlaceHolder Comment</td></tr>\n") ;
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "<tr><td>Pass</td><td>57s</td><td>13434-343 23:34:34</td><td>Function Test (pass)</td><td>PlaceHolder Comment</td></tr>\n") ;
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "<tr><td>Pass</td><td>57s</td><td>13434-343 23:34:34</td><td>Function Test (pass)</td><td>PlaceHolder Comment</td></tr>\n") ;
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "<tr><td>Pass</td><td>57s</td><td>13434-343 23:34:34</td><td>Function Test (pass)</td><td>PlaceHolder Comment</td></tr>\n") ;
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "<tr><td>Pass</td><td>57s</td><td>13434-343 23:34:34</td><td>Function Test (pass)</td><td>PlaceHolder Comment</td></tr>\n") ;
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "<tr><td>Pass</td><td>57s</td><td>13434-343 23:34:34</td><td>Function Test (pass)</td><td>PlaceHolder Comment</td></tr>\n") ;
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "<tr><td>Pass</td><td>57s</td><td>13434-343 23:34:34</td><td>Function Test (pass)</td><td>PlaceHolder Comment</td></tr>\n") ;
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "<tbody></table></div>\n") ;

	$tcIdCtr++;
		}
	 }}, "$SvrDrive/$SvrProjName");
	##&appendtoFile_($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory,"</pre></body></html>\n")				;
	#&addHtmlToolBar($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory)				;

	$tcIdCtr = $tcIdCtr_;
}

sub reportTCHistory_orig {
	my $tcIdCtr_ = $tcIdCtr;
	my $tcname = shift;
	$tcIdCtr=1;
 	&createFile_($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory,"");
 	&appendtoFile_($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory,"<html><title>$web_ui_title</title><body><pre>\n");
###### Great Discovery for dumy  temporal find({ preprocess => sub {return sort @_;}, wanted=> sub {if (  ($File::Find::name =~ /tc.pl\s*$/) && ($File::Find::name =~ /$SvrDrive\/$SvrProjName\/$testcaseNode/i) && ($File::Find::name =~ /$SvrTCNamePattern/i)  ) { # fix tcDesc tag related 
find({ preprocess => sub {return sort @_;}, wanted=> sub {if (  ($File::Find::name =~ /tc.pl\s*$/) && ($File::Find::name =~ /$SvrDrive\/$SvrProjName\/$testcaseNode/i)  ) { # fix tcDesc tag related 
			$SvrTCName = $File::Find::name; 
			$SvrTCName =~ s/\/tc.pl//g;
	my $fileText = sprintf "%10s %s", "", &reportTC($tcname,"","History");  if ($fileText =~ /^\s*$/) { $fileText = " ";}
	$fileText = &sortOnDate($fileText); 
	if ($tcDesc[$tcIdCtr]) {;} else { $tcDesc[$tcIdCtr] ="tcDesc is unavailable. It will be updated in next \"list\"";}
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, " ---- TestCase $tcIdCtr: <a name=\"".&getTCName($tcname)."\"> ".&processProperty("",$SvrTCName, "get_tcDesc")."</a>----\n");
	if (defined $fileText) { ; } else { $fileText="";}
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "$fileText") if ( $fileText !~ /^\s*$/) ;
	$tcIdCtr++;
		}
	 }}, "$SvrDrive/$SvrProjName");
	#&appendtoFile_($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory,"</pre></body></html>\n")				;
 	&addHtmlToolBar($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory)				;
	$tcIdCtr = $tcIdCtr_;
}



################################################################################
#	Subroutine Name : reportTC
#		Function: report TC results on STDOUT and Update TCProj HTML
#	Input Parameters: TC Name
#			  TC PropertyName = tcRunResult
#			  TC Report Type: 0 = latest 1 = historyical
#	Output/Returns  : TC Reports displayed on webUI
################################################################################
sub reportTC() {		# TC Report Function (TH:TC Report)
    my $tcPropertyPatternPattern_ = ".*"; ####################### Reset the tcPropertyPatternPattern for index.htm
    my $cmd=''; $cmd = shift; if ($cmd !~ /^\s*cmd\s*=/i) { unshift @_, $cmd; } ;
    my $timeSpan  = "2000!now"; 
    my $tcname          = $_[0]; my $propertyPattern = $_[1]; my $reportType = $_[2]; 
    $tcname = &getTCName($tcname);
    my ($timeSpanStart, $timeSpanEnd, $isInSpan, $beautifiedStr, $beautifiedStr4Web); 
    my $returnValue="";
    my ($propertyName, $startTime, $endTime, $comment1, $comment2) ;
    my $passCtr =0; my $failCtr = 0; my $nullCtr = 0 ; my $totalTime=0; my $avgResponseTime; my $propertyValue ='';
    my $totalTimeDummy; my $passFailDisplay=""; my $passFailDisplay_ =""; my $tcTags="";
	&readTestSuitProperty();
    if( $propertyPattern =~ /^\s*$/) {   $propertyPattern = 'tcRunResult';}
    if( $reportType =~ /^\s*$/) {   $reportType = 'lastValue';}

    if ($timeSpan) { $_ = $timeSpan;
 	    ($timeSpanStart, $timeSpanEnd ) = split( /!|\|/, $timeSpan );
 	    $timeSpanStart = &ParseDate($timeSpanStart);
 	    $timeSpanEnd   = &ParseDate($timeSpanEnd);
    }
     my $tcPassFailDisplayWidth = 0; 
#    ############ get maxPassFailDisplayWidth #################
#      open Fin, "$tcname/thProperty.txt" || die "Can't open file:$!"; 	################## Read Property File
#    ############################## Read Property File to update reportHtmlHistory ###########################
#         while ( $_ = <Fin> ) { chop;

local @ARGV ; 
my  $propertyFName = "$tcname/thPropertyLink.txt"; if (-e $propertyFName) { open Fin, $propertyFName; @_ = <Fin>; close Fin; foreach my $each (@_) { chop $each; if (-e $each) { push @ARGV, $each."/thProperty.txt"; } } }
    $propertyFName = "$tcname/thProperty.txt"; push @ARGV, $propertyFName if (-e $propertyFName );
       while ( $_ = <> ) { chop;
          if ( $_ =~ /$propertyPattern/i ) {
                 ( $propertyName, $propertyValue, $startTime, $endTime, $totalTimeDummy, $comment1, $comment2) = split( '\|', $_);
                 my $flag1 = &Date_Cmp( &ParseDate($startTime), &ParseDate($timeSpanStart) );
                 my $flag2 = &Date_Cmp( &ParseDate($timeSpanEnd), &ParseDate($endTime) );
                  if   ( ( $flag1 >= 0 ) && ( $flag2 >= 0 ) ) { $isInSpan = 1; }
                  else                                        { $isInSpan = -1; }
 		my $date1=&ParseDate($startTime); my $date2=&ParseDate($endTime); my $delta=&DateCalc($date1,$date2); $delta =~ s/\+//g;
 		my ($Y,$M,$W,$D,$H,$MIN,$S) = split /:/, $delta;
 		my $totalSec = $D * 24 * 3600 + $H * 3600 + $MIN * 60 + $S;
 		if ($propertyValue =~ /^\s*[\d|.]+\s*$/) { $totalSec = $propertyValue; $propertyValue = "Perf";}
              if ( $isInSpan == 1 ) {;
 		 if ( $propertyPattern =~ /tcRunResult/i ) {
     			$tcPassFailDisplayWidth= $tcPassFailDisplayWidth + 1 ;
                 }  
   	     } # endif for InSpan
          }    # endif for /propertyPattern= tcRunResult/
          elsif ($_=~ /^\s*tcTags\s*\|(.+)\|?/) {
                 ( $propertyName, $propertyValue, $startTime, $endTime, $totalTimeDummy, $comment1, $comment2) = split( '\|', $_);
		$tcTags = $propertyValue;
	  }
     }		
     close Fin;
     if ($tcTags) {
     $tcTags =~ s/_//g; 
     $tcTags =~ s/\t//g;
     $tcTags =~ s/null/    /g;
     } 

    my $passFailDisplayWidth_1st= 0;
#    ############ get maxPassFailDisplayWidth #################
#    open Fin, "$tcname/thProperty.txt" || die "Can't open file:$!"; 	################## Read Property File
#    ############################## Read Property File to update reportHtmlHistory ###########################
#     while ( $_ = <Fin> ) { chop;
	
	      # local @ARGV ;  $propertyFName = "$tcname/thProperty.txt"; 		# Merge Ts 04/27/2013
	      # push @ARGV, $propertyFName if (-e $propertyFName );
  #$propertyFName = "$tcname/thPropertyLink.txt"; 
  #if (-e $propertyFName) { open Fin, $propertyFName; @_ = <Fin>; close Fin; foreach my $each (@_) { if (-e $each) { push @ARGV, $each."/thProperty.txt"; } } }
local @ARGV ; 
    $propertyFName = "$tcname/thPropertyLink.txt"; if (-e $propertyFName) { open Fin, $propertyFName; @_ = <Fin>; close Fin; foreach my $each (@_) { chop $each; if (-e $each) { push @ARGV, $each."/thProperty.txt"; } } }
    $propertyFName = "$tcname/thProperty.txt"; push @ARGV, $propertyFName if (-e $propertyFName );
      while ( $_ = <> ) { chop;

         if ( $_ =~ /$propertyPattern/i ) {
		 
                ( $propertyName, $propertyValue, $startTime, $endTime, $totalTimeDummy, $comment1, $comment2) = split( '\|', $_);
                my $flag1 = &Date_Cmp( &ParseDate($startTime), &ParseDate($timeSpanStart) );
                my $flag2 = &Date_Cmp( &ParseDate($timeSpanEnd), &ParseDate($endTime) );
                if   ( ( $flag1 >= 0 ) && ( $flag2 >= 0 ) ) { $isInSpan = 1; } else                                        { $isInSpan = -1; }
		my $date1=&ParseDate($startTime); my $date2=&ParseDate($endTime); my $delta=&DateCalc($date1,$date2); $delta =~ s/\+//g;
		my ($Y,$M,$W,$D,$H,$MIN,$S) = split /:/, $delta;
		my $totalSec = $D * 24 * 3600 + $H * 3600 + $MIN * 60 + $S;
		if (&looks_like_number($propertyValue)) { $totalSec = $propertyValue; $propertyValue = "Perf"; $comment2 = "Perf Test = ${propertyValue}s"; }
		#if ($propertyValue =~ /^\s*([\d|.]+)\s*$/) { $totalSec = $propertyValue; $propertyValue = "Perf"; $comment2 = "Perf Test = ${1}s";}
		if ($propertyValue =~ /null/i) 		   {                           ;                        ; $comment2 = "TC returns NULL";}
		if ($propertyValue =~ /pass/i) 		   {                           ;                        ; $comment2 = "Test Passed"  ;}
		if ($propertyValue =~ /fail/i) 		   {                           ;                        ; $comment2 = "Test Failed"  ;}
		if ($propertyValue =~ /bugF/i) 		   {                           ;                        ; $comment2 = "Failed BugID : <TBD>"  ;}
		if ($propertyValue =~ /expF/i) 		   {                           ;                        ; $comment2 = "Expected Fail"  ;}
		if ($propertyValue =~ /expected_f_a_i_l/i) {                           ; $propertyValue = "expF"; $comment2 = "Expected Fail"  ;}
             if ( $isInSpan == 1 ) {
		 if ( $propertyPattern =~ /tcRunResult/i ) {
		      $beautifiedStr = sprintf "%15s %-15s %-25s%-20s Note: %s", $propertyValue, $totalSec.'s', $startTime, $comment1, $comment2; # add comment2 for mouse-over display
		      if ($propertyValue =~ /pass/i) {$passCtr++; $totalTime =$totalTime + $totalSec; $passFailDisplay = $passFailDisplay."p";}
		      if ($propertyValue =~ /fail/i) {$failCtr++; $totalTime =$totalTime + $totalSec; $passFailDisplay = $passFailDisplay."f";}
		      if ($propertyValue =~ /mark/i) {          ; $totalTime =$totalTime + $totalSec; $passFailDisplay = $passFailDisplay."m";}
		      if ($propertyValue =~ /Perf/i) {          ; $totalTime =$totalTime + $totalSec; $passFailDisplay = $passFailDisplay."e";}
		      if ($propertyValue =~ /null/i) {$nullCtr++; $totalTime =$totalTime + $totalSec; $passFailDisplay = $passFailDisplay."n";}
		      if ($propertyValue =~ /expF/i) {$nullCtr++; $totalTime =$totalTime + $totalSec; $passFailDisplay = $passFailDisplay."x";}
		      if ($propertyValue =~ /bugF/i) {$nullCtr++; $totalTime =$totalTime + $totalSec; $passFailDisplay = $passFailDisplay."b";}
		      if ($propertyValue =~ /dumy/i) {          ;                                   ; $passFailDisplay = $passFailDisplay."d";}
		      #if ($propertyValue =~ /dumy/i) {$nullCtr++;                                   ; $passFailDisplay = $passFailDisplay."d";}
		      if ($propertyValue =~ /expected_F_a_i_l/i) {; $totalTime =$totalTime + $totalSec; $passFailDisplay = $passFailDisplay."x";}

		      if ($propertyValue =~ /pass/i) {                                                $passFailDisplay_ = $passFailDisplay_."p $startTime: ${comment2}_|_";}
		      if ($propertyValue =~ /fail/i) {                                                $passFailDisplay_ = $passFailDisplay_."f $startTime: ${comment2}_|_";}
		      if ($propertyValue =~ /mark/i) {                                                $passFailDisplay_ = $passFailDisplay_."m $startTime: ${comment2}_|_";}
		      if ($propertyValue =~ /Perf/i) {                                                $passFailDisplay_ = $passFailDisplay_."e $startTime: ${comment2}_|_";}
		      if ($propertyValue =~ /null/i) {                                                $passFailDisplay_ = $passFailDisplay_."n $startTime: ${comment2}_|_";}
		      if ($propertyValue =~ /expF/i) {                                                $passFailDisplay_ = $passFailDisplay_."x $startTime: ${comment2}_|_";}
		      if ($propertyValue =~ /bugF/i) {                                                $passFailDisplay_ = $passFailDisplay_."b $startTime: ${comment2}_|_";}
		      if ($propertyValue =~ /dumy/i) {                                                $passFailDisplay_ = $passFailDisplay_."d $startTime: ${comment2}_|_";}
		      if ($propertyValue =~ /expected_f_a_i_l/i) {  				      $passFailDisplay_ = $passFailDisplay_."x $startTime: ${comment2}_|_";}
		      if ($propertyValue =~ /pass|fail|mark|Perf|null|bugF|expF/i) { $passFailDisplayWidth_1st ++ ; }
		 } else { $beautifiedStr = $_; }    # endif for /tcRunResult/

		 if    ( $reportType =~ /history/i ) {   $returnValue = "$beautifiedStr\n$returnValue"; }
                 elsif ( $reportType =~ /lastValue/i ) {    $returnValue = $beautifiedStr; }
                 elsif ( $reportType =~ /forWeb/i ) { $returnValue .= $beautifiedStr4Web; }
	     } # endif for InSpan
         }    # endif for /propertyPattern/
    }									##################### 


    ############################## Adjust passFailDisplayWidth by _1st and max ###########################
 	if ( $passFailDisplayWidth < $passFailDisplayWidth_1st ) { $passFailDisplayWidth = $passFailDisplayWidth_1st;}
 	if ( $passFailDisplayWidth > $maxPassFailDisplayWidth  ) { $passFailDisplayWidth = $maxPassFailDisplayWidth ;}
    ############################## Read Property File to update reportHtmlHistory ###########################
    	if ($passCtr + $failCtr + $nullCtr == 0) {				##########  Generate TC webUI string 
	$avgResponseTime = 0; } else {
	$avgResponseTime = $totalTime / ($passCtr + $failCtr + $nullCtr); 
	}
	my $qtpHost; my $ATResultFname; my %color; my $color = 'gray'; my @color; my $colorIndex = 0; my $QASvrName; my $expFailure=""; my $bugFailure="";
	if ($propertyValue =~ /pass/i) { $color = "Green"; } elsif ($propertyValue =~ /fail/i) { $color = 'Red'; } elsif ($propertyValue =~ /bugF/i) {$color = "blue";}
	elsif ($propertyValue =~ /expected\s*fail/i) { $expFailure = "_Expected_Failure_ "; }

	$color[0]=1;

	##### testcase desc #### 
	my $TCDesc_displayTip = "Click to view TC logs";
	my $TCDesc_display ; my $TCDesc_display_ ;


#	if ($tsProperty{$tcname}) { 
#		###### Handle expected failure 
#		if (($tsProperty{$tcname} =~ /_expected_fail_/i) && ($propertyValue =~ /fail/i)){ $color = "Green"; }
#		if (($tsProperty{$tcname} =~ /_expected_fail_/i) && ($propertyValue =~ /pass/i)){ $color = "Red"; }
#		###### Handle expected failure 
#		$TCDesc_display_ = $expFailure.$tsProperty{$tcname};
#
#		my $TCDesc_display__ = $TCDesc_display_;
#
#		#### tcDesc can hae <>&$%()
#
#		$TCDesc_display__ =~ s/&lt;|&gt;|&amp;|&#37;|&#36;|&#166;|&#40;|&#41;/X/g;
#
#		my $n1 = ()  = $TCDesc_display_ =~ /&lt;|&gt;/g;
#		my $n2 = ()  = $TCDesc_display_ =~ /&amp;|&#37;|&#36;|&#40;|&#401;/g;
#		my $n3 = ()  = $TCDesc_display_ =~ /&#166;/g;
#		my $extra = $n1 * 3 + $n2 * 4 + $n3 * 5; 
#
#		my $webUI_TCDescWidth_extra = $webUI_TCDescWidth + $extra ;
#
#		if (length($TCDesc_display__) <= $webUI_TCDescWidth ) { 
#		$TCDesc_display = sprintf "%-${webUI_TCDescWidth}s", $TCDesc_display_; 
#		} else {
#		$TCDesc_display = sprintf "%-${webUI_TCDescWidth}s", substr $TCDesc_display_, 0, $webUI_TCDescWidth_extra; 
#		$TCDesc_displayTip = $tsProperty{$tcname}; 
#		}
#
#	} else { $TCDesc_display = sprintf "%-${webUI_TCDescWidth}s", $tcname; }





	if ($tsProperty{$tcname}) { 
		###### Handle expected failure 
		if (($tsProperty{$tcname} =~ /_expected_fail_/i) && ($propertyValue =~ /fail/i)){ $color = "Green"; }
		if (($tsProperty{$tcname} =~ /_expected_fail_/i) && ($propertyValue =~ /pass/i)){ $color = "Red"; }
		###### Handle expected failure 
		$TCDesc_display_ = $expFailure.$tsProperty{$tcname};

		my $TCDesc_display__ = $TCDesc_display_;

		my $TCDesc_display__decoded = decode_entities($TCDesc_display__);

		#$TCDesc_display__ =~ s/&lt;|&gt;|&amp;|&#37;|&#36;|&#166;|&#40;|&#41;/X/g;

		my $n1 = ()  = $TCDesc_display_ =~ /&lt;|&gt;/g;
		my $n2 = ()  = $TCDesc_display_ =~ /&amp;|&#37;|&#36;|&#40;|&#401;/g;
		my $n3 = ()  = $TCDesc_display_ =~ /&#166;/g;
		my $extra = $n1 * 3 + $n2 * 4 + $n3 * 5; 

		my $webUI_TCDescWidth_extra = $webUI_TCDescWidth + $extra ;

		if (length($TCDesc_display__decoded) <= $webUI_TCDescWidth ) { 
		$TCDesc_display = sprintf "%-${webUI_TCDescWidth}s", $TCDesc_display_; 
		} else {
			 $TCDesc_display__decoded = substr $TCDesc_display__decoded, 0, $webUI_TCDescWidth;
			 my $TCDesc_display__encoded = encode_entities($TCDesc_display__decoded);

			 #$TCDesc_display = sprintf "%-${webUI_TCDescWidth}s", $TCDesc_display__encoded;
		$TCDesc_display = sprintf "%-s", $TCDesc_display__encoded;
		$TCDesc_displayTip = $tsProperty{$tcname}; 
		}

	} else { $TCDesc_display = sprintf "%-${webUI_TCDescWidth}s", $tcname; }





	# prHtml3 mark for search


	my $tcSerialN = $TCDesc_display; 
	if ($tcSerialN =~ /^\s*\d+\D+/) {$tcSerialN =~ /^\s*(\d+)\D+/; $tcSerialN = "$1"; if ($tcSerialN) {;} else {$tcSerialN = "";}}
	my $dirRoot = &getRoot($tcname); 
	my $TCCtrToolTip = sprintf "Run Test (Testcase Number == $tcSerialN [%s])", &timeConvert($avgResponseTime); 
	my $TCCtrToolTipMin = sprintf "Run Tests (Testcase Number >= $tcSerialN)" ; 
	my $TCScrollAmount = 0; my $CtrSeparator = "|";
	$passFailDisplay  = &genPassFailDisplay ($passFailDisplay);
	$passFailDisplay = &genPassFailDisplay_ ($passFailDisplay_);


	my $stopTS    = "<a href=\"${url}/$SvrProjName/$reportHtml\" onClick=\"RunFile('$perl $scriptName Execution_from_cgi=$Execution_from_cgi;Execution_local_only=$Execution_local_only;exitTAFGracefullyString=$tcname;exitTAF')\" title=\"Stop Test (Testcase Number = $tcSerialN)\" >.</a>";
	my $runTS24_7 = "<a href=\"${url}/$SvrProjName/$reportHtml\" onClick=\"RunFile('$perl $scriptName Execution_from_cgi=$Execution_from_cgi;Execution_local_only=$Execution_local_only;drive=$SvrDrive;tcPropertyPatternName=$tcPropertyPatternName;tcPropertyPatternPattern=$tcPropertyPatternPattern_;testsuit=$SvrProjName;testcase=$dirRoot;ExecutionType=runTC;Execution_24_7=y;exec')\"  title=\"Exec Test 24/7 (Testcase Number == $tcSerialN)\"> ,</a>"; 
	my $runTCOnce = "<a href=\"${url}/$SvrProjName/$reportHtml\" onClick=\"RunFile('$perl $scriptName Execution_from_cgi=$Execution_from_cgi;Execution_local_only=$Execution_local_only;drive=$SvrDrive;tcPropertyPatternName=$tcPropertyPatternName;tcPropertyPatternPattern=$tcPropertyPatternPattern_;testsuit=$SvrProjName;testcase=$dirRoot;ExecutionType=runTC;exec')\"  title=\"$TCCtrToolTip\">></a>";
	my $runTSOnce = "<a href=\"${url}/$SvrProjName/$reportHtml\" onClick=\"RunFile('$perl $scriptName Execution_from_cgi=$Execution_from_cgi;Execution_local_only=$Execution_local_only;drive=$SvrDrive;tcPropertyPatternName=$tcPropertyPatternName;tcPropertyPatternPattern=$tcPropertyPatternPattern_;tcIdMin=$tcIdCtr;testsuit=$SvrProjName;ExecutionType=runTS;exec')\"  title=\"$TCCtrToolTipMin\"><marquee style=\"border:RED ${borderWidth}px ${borderStyle}\" width=48 direction=right behavior=alternate loop=10000 scrollamount=$scrollAmount>>\|</marquee></a>"; 
	my $html = sprintf( "<span style=\"color:black;\">$passFailDisplay${stopTS}$runTS24_7<font color=\"$color[$colorIndex]\"> $runTCOnce $runTSOnce</font><a href=\"${url}/$SvrProjName/".&getTCNameStr($SvrTCName)."/_tcLog.html\" title=\"$TCDesc_displayTip\">%-${webUI_TCDescWidth}s</a> <a href=\"${url}/$SvrProjName/${reportHtmlHistory}#$tcname\" title=\"Click to see Pass/Fail history\">%5d/%-5d</a> %10s   $tcTags    <font color=\"white\" onmouseover=\"this.style.color='#3172A1'\" onmouseout=\"this.style.color='white'\"> %s </font> </span>\n",
		    $TCDesc_display,
                    $passCtr,
                    $failCtr,
                    &formatSeconds($avgResponseTime),
		    $tcname.'/tc.pl',
                );

	# http

	$stopTS    = "<a href=\"${urlHttp}/${cgi_bin}$tafCGI?tafArgs=Execution_from_cgi=y;Execution_local_only=$Execution_local_only;exitTAFGracefullyString=$tcname;exitTAF=_null__realSemi_tafRedirectory=${urlHttp_IIS}/$SvrProjName/$reportHtml_http\" title=\"Stop Test (Testcase Number = $tcSerialN)\" >.</a>";
	$runTS24_7 = "<a href=\"${urlHttp}/${cgi_bin}$tafCGI?tafArgs=Execution_from_cgi=y;Execution_local_only=$Execution_local_only;SysDrive=$SvrDrive;tcPropertyPatternName=$tcPropertyPatternName;tcPropertyPatternPattern=$tcPropertyPatternPattern_;testsuit=$SvrProjName;testcase=$dirRoot;ExecutionType=runTC;Execution_24_7=y;exec_realSemi_tafRedirectory=${urlHttp_IIS}/$SvrProjName/$reportHtml_http\"  title=\"Exec Test 24/7 (Testcase Number == $tcSerialN)\"> ,</a>"; 
	$runTCOnce = "<a href=\"${urlHttp}/${cgi_bin}$tafCGI?tafArgs=Execution_from_cgi=y;Execution_local_only=$Execution_local_only;SysDrive=$SvrDrive;tcPropertyPatternName=$tcPropertyPatternName;tcPropertyPatternPattern=$tcPropertyPatternPattern_;testsuit=$SvrProjName;testcase=$dirRoot;ExecutionType=runTC;exec_realSemi_tafRedirectory=${urlHttp_IIS}/$SvrProjName/$reportHtml_http\"  title=\"$TCCtrToolTip\">></a>";
	$runTSOnce = "<a href=\"${urlHttp}/${cgi_bin}$tafCGI?tafArgs=Execution_from_cgi=y;Execution_local_only=$Execution_local_only;SysDrive=$SvrDrive;tcPropertyPatternName=$tcPropertyPatternName;tcPropertyPatternPattern=$tcPropertyPatternPattern_;tcIdMin=$tcIdCtr;testsuit=$SvrProjName;ExecutionType=runTS;exec_realSemi_tafRedirectory=${urlHttp_IIS}/$SvrProjName/$reportHtml_http\"  title=\"$TCCtrToolTipMin\"><marquee style=\"border:RED ${borderWidth}px ${borderStyle}\" width=48 direction=right behavior=alternate loop=10000 scrollamount=$scrollAmount>>\|</marquee></a>"; 

	$stopTS =~ s/;/_semi_/g;  $stopTS =~ s/_realSemi_/$_realSemi_/g;	# todo: taf.cgi need to handle exitGracefully scenario
	$runTS24_7=~ s/;/_semi_/g; $runTS24_7=~ s/_realSemi_/$_realSemi_/g;
	$runTCOnce=~ s/;/_semi_/g; $runTCOnce=~ s/_realSemi_/$_realSemi_/g;
	$runTSOnce=~ s/;/_semi_/g; $runTSOnce=~ s/_realSemi_/$_realSemi_/g;
	#my $html_http = sprintf( "<span style=\"color:black;\">$passFailDisplay${stopTS}$runTS24_7<font color=\"$color[$colorIndex]\"> $runTCOnce $runTSOnce</font><a href=\"${urlHttp_IIS}/$SvrProjName/".&getTCNameStr($SvrTCName)."/_tcLog.html\" title=\"$TCDesc_displayTip\">%-${webUI_TCDescWidth}s</a> <a href=\"${urlHttp}/$SvrProjName/${reportHtmlHistory}#$tcname\" title=\"Click to see Pass/Fail history\">%5d/%-5d</a> %10s   $tcTags    <font color=\"white\" onmouseover=\"this.style.color='#3172A1'\" onmouseout=\"this.style.color='white'\"> %s </font> </span>\n",
	#my $html_http = sprintf( "<span style=\"color:black;\"><tr><td>$passFailDisplay</td><td>${stopTS}$runTS24_7<font color=\"$color[$colorIndex]\"> $runTCOnce $runTSOnce</font></td><td><a href=\"${urlHttp_IIS}/$SvrProjName/".&getTCNameStr($SvrTCName)."/_tcLog.html\" title=\"$TCDesc_displayTip\">%-${webUI_TCDescWidth}s</a> </td><td><a href=\"${urlHttp}/$SvrProjName/${reportHtmlHistory}#$tcname\" title=\"Click to see Pass/Fail history\">%5d/%-5d</a> </td><td>%10s   </td><td>$tcTags    <font color=\"white\" onmouseover=\"this.style.color='#3172A1'\" onmouseout=\"this.style.color='white'\"> %s </font> </td></span>\n",
	#my $html_http = sprintf( "<span style=\"color:black;\"><tr><td>$passFailDisplay</td><td>${stopTS}$runTS24_7<font color=\"$color[$colorIndex]\"> $runTCOnce $runTSOnce</font></td><td><a href=\"${urlHttp_IIS}/$SvrProjName/".&getTCNameStr($SvrTCName)."/_tcLog.html\" title=\"$TCDesc_displayTip\">%-${webUI_TCDescWidth}s</a> </td><td><a href=\"${urlHttp_IIS}/$SvrProjName/${reportHtmlHistory}#$tcname\" title=\"Click to see Pass/Fail history\">%5d/%-5d</a> </td><td>%10s   </td><td>$tcTags %s </td></span>\n",
	my $html_http = sprintf( "<span style=\"color:black;\"><tr><td class=\"tc-results\">$passFailDisplay</td><td class=\"tc-actions\"> ${stopTS}$runTS24_7<font color=\"$color[$colorIndex]\"> $runTCOnce $runTSOnce</font></td><td class=\"tc-description\"> <a href=\"${urlHttp_IIS}/$SvrProjName/".&getTCNameStr($SvrTCName)."/_tcLog.html\" title=\"$TCDesc_displayTip\">%-${webUI_TCDescWidth}s</a> </td><td class=\"tc-history\"> <a href=\"${urlHttp_IIS}/$SvrProjName/${reportHtmlHistory}#$tcname\" title=\"Click to see Pass/Fail history\">%5d/%-5d</a> </td><td class=\"tc-time\"> %10s   </td><td class=\"tc-path\">$tcTags  %s </td></span>\n",
		    $TCDesc_display,
                    $passCtr,
                    $failCtr,
                    &formatSeconds($avgResponseTime),
		    $tcname,
		    #$tcname.'/tc.pl',
                );


		if ($cmd =~ /noprint/i) {;} else { 
			&appendtoFileUniq_( $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml1, $html 		);
			&updateWeb1_( $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml, $html			);  

			&appendtoFileUniq_( $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml1_http, $html_http); 
			&updateWeb1Http_( $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml_http, $html_http	); 

		 } 
     	close Fin;
     	if ($returnValue) {$returnValue =~ s/^\s*//g;} else {$returnValue = "";} 
	# &appendtoFile($reportHtmlSummaryB, $passFailDisplay) ;
     	return $returnValue;
}

sub genPassFailDisplay {
	my $str = shift;
	$str = reverse $str;	
	$str = $str. "                                                        ";	 
	$str = substr ($str, 0, $passFailDisplayWidth);
	$str =~ s/p/<a style=\"color:green\">*<\/a>/g;
	$str =~ s/f/<a style=\"color:red\">*<\/a>/g;
	$str =~ s/m/|/g;
	if ($str =~ /^\s*$/) { $str = &genStr($passFailDisplayWidth);}
	return $str; 
}

sub genPassFailDisplay_ {
	my $str = shift; my $str_ =""; my $strLenCtr=0; my $mark4One=0;
	@_ = split /_\|_/, $str; $str="";
	for (my $i=$#_; $i >= 0; $i--) { 
		my $tcResult ; 
		if( $_[$i] =~ s/^\s*(\w)\s+//g) {
			$tcResult = $1; $str_ = $_[$i];  $strLenCtr++;
			if ($tcResult =~ /p/i)    { $str = $str."<a style=\"color:green\" title=\"$str_\">*<\/a>"; }
			elsif ($tcResult =~ /f/i) { $str = $str."<a style=\"color:red\" title=\"$str_\">*<\/a>";   }
			elsif ($tcResult =~ /m/i) { 
				#if ($mark4One == 2) { ; } else {
				$str = $str."<a style=\"color:black\" title=\"$str_\">$markSymbol<\/a>"; 
				#$mark4One = 0; 
			}

			elsif ($tcResult =~ /b/i) { $str = $str."<a style=\"color:blue\" title=\"$str_\">*<\/a>"; }
			elsif ($tcResult =~ /e/i) { $str = $str."<a style=\"color:black\" title=\"$str_\">.<\/a>"; }
			elsif ($tcResult =~ /n/i) { $str = $str."<a style=\"color:black\" title=\"$str_\">.<\/a>"; }
			elsif ($tcResult =~ /x/i) { $str = $str."<a style=\"color:black\" title=\"$str_\">*<\/a>"; }
			elsif ($tcResult =~ /d/i) { $str = $str."<a style=\"color:black\" title=\"$str_\"> <\/a>"; }
			elsif ($tcResult =~ /_/i) { $str = $str."<a style=\"color:black\" title=\"$str_\">.<\/a>"; }
		}
			$mark4One++; 
		if ($strLenCtr + 1 > $passFailDisplayWidth) { return $str; }
	} 
	if ($strLenCtr < $passFailDisplayWidth) { for (my $i = $strLenCtr; $i < $passFailDisplayWidth; $i++) { $str = $str . "<a style=\"color:black\"> <\/a>"; } }
	return $str; 
}

sub genPassFailDisplay_old {
	my $str = shift; my $str_ =""; my $strLenCtr=0;
	@_ = split /_\|_/, $str; $str="";
	for (my $i=$#_; $i >= 0; $i--) { 
		my $tcResult ; 
		if( $_[$i] =~ s/^\s*(\w)\s+//g) {
			$tcResult = $1; $str_ = $_[$i];  $strLenCtr++;
			if ($tcResult =~ /p/i)    { $str = $str."<a style=\"color:green\" title=\"$str_\">*<\/a>"; }
			elsif ($tcResult =~ /f/i) { $str = $str."<a style=\"color:red\" title=\"$str_\">*<\/a>";   }
			elsif ($tcResult =~ /m/i) { $str = $str."<a style=\"color:black\" title=\"$str_\">|<\/a>"; }
		}
		if ($strLenCtr + 1 > $passFailDisplayWidth) { return $str; }
	} 
	if ($strLenCtr < $passFailDisplayWidth) { for (my $i = $strLenCtr; $i < $passFailDisplayWidth; $i++) { $str = $str . "<a style=\"color:blank\"> <\/a>"; } }
	return $str; 
}

sub genStr { my $strLen = shift; my $return=""; for (my $i = 0; $i < $strLen; $i++) { $return  .= " "; } $return; }

sub processTSs{
	shift;
 	my $each = shift;
		if ($each !~ /=/) {
			if ($each =~ /\bmarkblablaaaaa\b/i) { 							;
			} else  {
				  my %record;
					&processTCs("", "listAll");  
					my $rst = $listAll_var; 
					@_ = split (/\n|\r/, $rst);
					foreach my $each (@_) { 
						$each =~ s/^$c//g;
						$each =~ s/^[\/|\\]//g;
						$each =~ s/^$_TAF//g;
						$each =~ s/^[\/|\\]//g;
						$each =~ s/testcase\d\d\d\d.*$//g;
						$each =~ s/[\/|\\]\s*$//g;
						$record{$each}=$each;
						}
				if ($each =~ /listTS/i) { # list all available TS 
					foreach my $each (sort keys %record) { print "$each\n"; }
				} elsif ($each =~ /deleteTSs/i) { 
					foreach my $each (sort keys %record) { 
						# &deleteTAFTestsuite();
					
					}
				}


 				#print "pd: $SvrProjName,  $each\n"; my $str =  "\&$each();"; my $rst = eval $str; next				;  
			}
		} else {
			$each =~ /^\s*(\S+)\s*=\s*(\S+)\s*/; my $varName = $1; my $varValue = $2		;
			if (($varName !~ /^\s*$/) && ($varValue !~ /^\s*$/)) {
				if ($varName =~ /\bcreate\b/i) { &createTS($varValue); }
				elsif ($varName =~ /\badd\b/i) 	{ &addTS($varValue); }
				elsif ($varName =~ /\bdelete\b/i) { &deleteTS($varValue); }
				elsif ($varName =~ /\bcheckStatus\b/i) { &checkStatusTS($varValue); }
				else {
					print "Unrecognized Testsuite Command: $varName\n"; 		
				}
			}
		}
}

sub checkStatusTS {
	; # print "pass a: ".shift."\n";
}
sub processTCs{
	shift;
	my $isBatchProcessing = 1;
	my $tmp = shift;
	if (defined $tmp ) {;} else { return; }
	@_ = split /;/, $tmp; &do_();
	&genDriver_taf_pl ();
	&genDriver_taf_cgi ();
		&appendtoFile($commandLogName, "\n".&UnixDate( "now", "%m/%d/%Y %H:%M:%S %Z")."> ");
		&appendtoFile($commandLogName,"$c/$_TAF/$taf ");
	foreach my $each (@_) {
		#### uncomment for debugging   print " cmd> $each\n";
		&appendtoFile($commandLogName,$each.";");
		if ($each !~ /=/) {
			$isBatchProcessing = 0;
			if (($each =~ /\blistVars\b/i) || ($each =~ /\bgetVars\b/i)) { return &printGlobalVars();
			} elsif ($each =~ /\bprintVars\b/i) { print &printGlobalVars(); next 			;
			} elsif ($each =~ /\bexec\b/i) { 							;
				&setGlobalVars("","tcOP=exec")							;
				$isBatchProcessing = 1								;
			} elsif ($each =~ /\blistTcFilters|printTcFilters\b/i) { 				;
				&setGlobalVars("","tcOP=listtcfilters")						;
				$isBatchProcessing = 1								;
			} elsif ($each =~ /\blist\b/i) { 							;
				&setGlobalVars("","tcOP=list")							;
				$isBatchProcessing = 1								;
			} elsif ($each =~ /\blistHistory\b/i) { 						;
				&setGlobalVars("","tcOP=listHistory")						;
				$isBatchProcessing = 1								;
			} elsif ($each =~ /\bmark\b/i) { 							;
				&setGlobalVars("","tcOP=mark")							;
				$isBatchProcessing = 1								;
			} elsif ($each =~ /\blistAll\b/i) { 							;
			 	$SvrTCNamePattern =".*";  print &listAll()					; 
				$isBatchProcessing = 0								;		
			} elsif ($each =~ /refreshTS/i) {							;
				&deleteTAFTestsuite()								;
				&generateTAFTestsuite()								;
				$isBatchProcessing = 0								;		
			} elsif ($each =~ /refreshHost/i) {							;
				unlink "$c/$_TAF/$tsProperty_txt";
				&generateRootIndex()								;
				&generateRootIndex()								;
				$isBatchProcessing = 0								;		
			} elsif ($each =~ /releaseLock|refreshLock|refreshQueue|resetLock|resetQueue/i) {							;
				&Queue("","releaseLock");
				# &generateTAFTestsuite()								;
				$isBatchProcessing = 0								;		
			} elsif ($each =~ /customer1/i) {
				&customer1();
			} else  {
				my $str =  "\&$each();"; 
				my $rst = eval $str; 
				if ($rst) { 
					print "\`$each\` = \"$rst\"\n" if ($pr2Screen == 1);
			       
				} else { print "\`$each\` is not a TAF command."; }
				next;  
			}
		} else {
			if ( $each =~ /^\s*(\S+)\s*=\s*(.+)$/ ) {
				$each =~ /^\s*(\S+)\s*=\s*(.+)$/; my $varName = $1; my $varValue = $2		;
				if (($varName !~ /^\s*$/) && ($varValue !~ /^\s*$/)) {
					if ($varName =~ /propertyOp/) { $isBatchProcessing = 1; } else { $isBatchProcessing = 0;} # 1 for propertyOp
					if (&setGlobalVars ("","$varName=$varValue;") == 1 ) 				    { ; } # Process value assginment
					else { 
						my $rst = &processTC("",$each) 			; 				} # Process TC
				}
			} else { next; } 
		}
		if ($isBatchProcessing == 1) { if ($Execution_24_7 !~ /y/i) {$NofExecutionCtrExec=0}; $NofExecutionCtr = 0;  &tcLoop(); }		# NofExecutionCtr reset for each list/exec
	} 

}

################################################################################
#	Subroutine Name : process Test Case
#		Function: wrapper for Test Case management functions
#	Input Parameters: PropertyOP
#	Output/Returns  : tcName and propertyO/proc
################################################################################
sub processTC {
	    my $tcname; my $cmd=""; &do_();
	    shift; my $tcOP= ''; $tcOP = shift if (@_); 
	    my $prMsg = '' ; $prMsg= shift if @_;
	    $tcOP =~ /\s*([\w|\d]+)\s*(=)?\s*(\w+)?\s*([;|\/])?(\s*\S+\s*)?/;  
	    $tcOP = $1; $tcname = $3; $cmd = $5; $prMsg = $pr2Screen;
		if ($cmd) {$cmd =~ s/\n//g;} else { $cmd ="";}
	    ######## This is for TCs processing (Batching)
		if ($tcOP =~ /\blistAll\b/i) {
			# SvrTCName as a regExp
			if ($tcname =~ /^\s*$/) { $SvrTCNamePattern =".*";} else { $SvrTCNamePattern = $tcname; } 
			print &listAll(); 
			return; 
			}
	    ######## The following are for TC processing 	    
 	    if ((defined $tcname) && ($tcname =~ /^.$/) && ($cmd =~ /:[\\|\/]/)) {
 			$tcname = $tcname.$cmd; # handle -s delete=c:\_ts1_
 	    }
	    if ($tcOP =~ /dumy/i) {$SvrTCName = $tcname;} 
	    $tcname =  &getTCName($tcname); 

	    if ((-e $tcname)||($tcOP =~ /create/i)) { printf "%-20s %-40s ", "processTC:", $tcname   if (($outputFormat =~ /text/i) && ($pr2Screen ==1)) ; } # print for webUI 1/2


	    # printf "%-20s %-40s ", "processTC:", $tcname   if (($outputFormat =~ /text/i) && ($pr2Screen ==1)) ; # print for webUI 1/2
	    my $tmp = sprintf "%-20s %-40s\n", "processTC: ", $tcname   ;
 	    &appendtoFile_($SvrDrive.'/'.$SvrProjName.'/'."_listHistory.txt", "$tmp");
	    my $rst; 
	    if ( $tcOP =~ /^\s*create/i ) {
		    if ($cmd) { $rst = &createTC("cmd=$cmd",$tcname); }
		    else { $rst = &createTC($tcname); }
            } elsif ( $tcOP =~ /^\s*exec\b/i ) {
		    #### dummy if (($NofExecutionCtr== 1 ) &&($simulatedResults =~ /^\s*$/)) {$rst = &markTC_($tcname);}
		    $rst = &execTC_($tcname);
		    my $rst1 = &mapTC($tcname);
	    } elsif ( $tcOP =~ /^\s*dumy\b/i ) {
		    #### dummy if (($NofExecutionCtr== 1 ) &&($simulatedResults =~ /^\s*$/)) {$rst = &markTC_($tcname);}
		    $rst = &dumyTC_($tcname); 
		    my $rst1 = &mapTC($tcname);
            } elsif ( $tcOP =~ /^\s*mark\b/i ) {
		    $rst = &markTC_($tcname);
            } elsif ( $tcOP =~ /^\s*execAll/i ) {
		    $rst = &tcLoop();
		        return $rst;
            } elsif ( $tcOP =~ /^\s*UpdateWeb/i ) {
		    if (defined $cmd) {;} else { $cmd = 0;}
		    $rst = &updateWeb_($tcname,$cmd);
	    } elsif ( $tcOP =~ /^\s*getWeb_/i ) {
		    $rst = &getWeb_($tcname);
            } elsif ( $tcOP =~ /^\s*log/i ) {
		    $rst = &logTC($tcname);
            } elsif ( $tcOP =~ /^\s*detect/i ) {
		    $rst = &detectTC($tcname, $SvrProjName, $SvrDrive); 
            } elsif ( $tcOP =~ /^\s*getLogName/i ) {
		    $rst = &getTCLogFname(&getTCName($tcname)); 
	    } elsif ( $tcOP =~ /^\s*listTCFilters/i ) {
		    $rst = &getProperties(&getTCName($tcname) , '.*_all_', 'latest');
	    } elsif ( $tcOP =~ /^\s*printtcFilters/i ) {
		    $rst = &getProperties(&getTCName($tcname) , '.*_all_', 'latest');
            } elsif ( $tcOP =~ /^\s*listHistory/i ) {
		    $rst = &getProperties(&getTCName($tcname) , 'tcRunResult', 'history');
            } elsif ( $tcOP =~ /^\s*printResult/i ) {

	    } elsif ( $tcOP =~ /^\s*list|get\b/i ) {
		    $rst = &getProperties(&getTCName($tcname) , 'tcRunResult', 'last');	   # return last valid TC result
		    my $rst1 = &mapTC($tcname);
            } elsif ( $tcOP =~ /^\s*delete/i ) {
		    $tcOP =~ s/^\s*delete\s*=//g;
		    $tcOP =~ s/\s*$//g;
		    $rst = &deleteTC($tcname);
            } else {
		    if ( -e $tcname ) {
		    print "<- Test suite \n" if $prMsg;
	    		}	
		return "_noProcessedTC_";
	    }
	     	printf "%s\n",  $rst  if (($outputFormat =~ /text/i)&&($pr2Screen == 1)) ; # print for webUI 2/2
 	        &appendtoFile_($SvrDrive.'/'.$SvrProjName.'/'."_listHistory.txt","$rst\n")				;
	 	$rst = sprintf "%-20s %-40s %s", "processTC:", $tcname,  $rst ;
		return $rst;
}

sub Queue {					# &Queue(push,"pushedContenet")  $rst = &Queue(pop)
	shift;
	my $currentTime  = &UnixDate( "now", "%m/%d/%Y %H:%M:%S" );
	my @pushQueue; my @popQueue; $#pushQueue=0, $#popQueue=0;
	my $operation = "push"; $operation = shift if @_;
	my $tafCmd = shift; 
	my $pushQueueSize; my $queueLength=0; my $queueSize=0;

	################# Set/release/check Lock ###################
	if ($operation =~ /setLock/i) {
		open Fin, ">$lockFName"; print Fin "lock is ON\n"; close Fin; return; 
	} elsif ($operation =~ /releaseLock/i) {
		unlink $lockFName; 
	} elsif ($operation =~ /checkLock/i) {
		if (-e $lockFName) { return 1;} 
		else { return 0; }
	}
	################# Set/release/check Lock ###################
	if (-e "$c/$_TAF/$queueFName") {;} else { open Fout, ">$c/$_TAF/$queueFName"; close Fout ; }
	open Fin, "$c/$_TAF/$queueFName" ;
	while ($_ = <Fin>) {
		if ($_ =~ /\s*(pushed|popped)\s*\((.+)\):\s*(.+)\s*$/) {
			my $status = $1; my $index = $2; my $content = $3;
			if ($status =~ /pushed/) { $pushQueue[$index] = $content;}
			if ($status =~ /popped/ ) { $popQueue[$index] = $content;}
		}
	}
	close Fin;

	################# generate Active Queue & update Queue Operation ###################
	if ( -e "$c/$_TAF/$queueFName_active" ) { ; } else { open Fout_tmp, ">$c/$_TAF/$queueFName_active"; close Fout_tmp; }
 	if (($#popQueue < $#pushQueue ) || ($operation =~ /updateQueue/i)) { open Fin_tmp, ">$c/$_TAF/$queueFName_active"; 
 		for (my $i = $#popQueue+1; $i<=$#pushQueue; $i++) { printf Fin_tmp "<pre> [%5d] %s </pre>\n", $i, $pushQueue[$i] if (defined $pushQueue[$i]);  }
		if ($#popQueue+1 > $#pushQueue) { print Fin_tmp "No task to proceed\n";}
 		close Fin_tmp;  
		#&addHtmlToolBar("$c/$_TAF/$queueFName_active"); 
	}
	################# generate Active Queue & reset Queue Operation ###################
 	if (($#popQueue < $#pushQueue ) || ($operation =~ /reset/i)) { open Fin, ">$c/$_TAF/$queueFName_active"; 
 		for (my $i = $#popQueue+1; $i<=$#pushQueue; $i++) { printf Fin "<pre> [%5d] %s </pre>\n", $i, $pushQueue[$i] if (defined $pushQueue[$i]);  }
		if ($#popQueue+1 > $#pushQueue) { print Fin "No task to proceed\n";}
 		close Fin;  
		#&addHtmlToolBar("$c/$_TAF/$queueFName_active"); 
	}

	################# autoReset Operation ###################
	if (($#popQueue > $queueSizeLimit ) || ($operation =~ /reset/i)) { open Fin, ">$c/$_TAF/$queueFName"; close Fin;  print " --> $c/$_TAF/$queueFName\n"; return; }
	if (($#popQueue > $queueSizeLimit ) || ($operation =~ /reset/i)) { open Fin, ">$c/$_TAF/$queueFName_active"; close Fin; print " --> $c/$_TAF/$queueFName_active\n"; return; }
	
	$pushQueueSize = $#pushQueue + 1;
	################# QueueSize ###################
	if ($operation =~ /\bqueueSize\b/i) {
		if ($#pushQueue < $#popQueue) { print "Warning: Need to reset Queue size by running $c/$_TAF/taf.pl resetTAF\n";}
		return ($#pushQueue - $#popQueue); 	
	}

	################# AllQueueSize ###################
	if ($operation =~ /allqueueSize/i) {
		return $#pushQueue; 	
	}


	################# Push Operation ###################
	if ($operation =~ /push/i) { 

		if (defined $tafCmd) {
		if (($tafCmd =~ /set_property[1-2]/i) || ($tafCmd =~ /get_property[1-2]/i) || ($tafCmd =~ /printTcFilters/i)) { ;
		} else {
			#open Fin, ">>$c/$_TAF/$queueFName"; print Fin "<pre>$currentTime  pushed ($pushQueueSize): $tafCmd </pre>\n"; close Fin; 
		&addHtmlPre("$c/$_TAF/$queueFName", "$currentTime  pushed  ($pushQueueSize): $tafCmd","n"); 
		return; 
		}
		}
	}

	################# Pop Operation ###################
	elsif ($operation =~ /pop/i) {
		for (my $i = 1; $i <= $#pushQueue; $i++ ) { 
			if  (defined $popQueue[$i] ) { ; } else {	# already popped
				if ((defined $pushQueue[$i]) && ($pushQueue[$i] !~ /_notPushed_ignored/i)) {
					#open Fin, ">>$c/$_TAF/$queueFName"; print Fin "<pre>$currentTime  poped  ($i): $pushQueue[$i] </pre>\n"; close Fin;
					&addHtmlPre ("$c/$_TAF/$queueFName","$currentTime  popped  ($i): $pushQueue[$i] ","n"); 
					return $pushQueue[$i];
				} else {
					#open Fin, ">>$c/$_TAF/$queueFName"; print Fin "<pre>$currentTime  poped  ($i): _notPushed_ignored </pre>\n"; close Fin;
					&addHtmlPre ("$c/$_TAF/$queueFName", "$currentTime  popped  ($i): _notPushed_ignored ","n");
					return "_notPushed_ignored";
				}
			}
		} 
	} 
	################# check Operation ###################
	elsif ($operation =~ /checkQueue/i) { 
		for (my $i = 0; $i <= $#pushQueue; $i++ ) { 
			if  (defined $popQueue[$i] ) { ; } else {	# already popped
				return $pushQueue[$i];
			}
		}
	}

}

sub Queue_v1_0 {					# &Queue(push,"pushedContenet")  $rst = &Queue(pop)
	shift;
	my @pushQueue; my @popQueue; $#pushQueue=0, $#popQueue=0;
	my $operation = "push"; $operation = shift if @_;
	my $tafCmd = shift; 
	my $pushQueueSize; my $queueLength=0; my $queueSize=0;

	################# Set/release/check Lock ###################
	if ($operation =~ /setLock/i) {
		open Fin, ">$lockFName"; print Fin "lock is ON\n"; close Fin; return; 
	} elsif ($operation =~ /releaseLock/i) {
		unlink $lockFName; 
	} elsif ($operation =~ /checkLock/i) {
		if (-e $lockFName) { return 1;} 
		else { return 0; }
	}
	################# Set/release/check Lock ###################
	if (-e "$c/$_TAF/$queueFName") {;} else { open Fout, ">$c/$_TAF/$queueFName"; close Fout ; }
	open Fin, "$c/$_TAF/$queueFName" ;
	while ($_ = <Fin>) {
		if ($_ =~ /^\s*(pushed|popped)\s*\((.+)\):\s*(.+)\s*$/) {
			my $status = $1; my $index = $2; my $content = $3;
			if ($status =~ /pushed/) { $pushQueue[$index] = $content;}
			if ($status =~ /popped/ ) { $popQueue[$index] = $content;}
		}
	}
	close Fin;

	################# generate Active Queue & update Queue Operation ###################
	if ( -e "$c/$_TAF/$queueFName_active" ) { ; } else { open Fout_tmp, ">$c/$_TAF/$queueFName_active"; close Fout_tmp; }
 	if (($#popQueue < $#pushQueue ) || ($operation =~ /updateQueue/i)) { open Fin_tmp, ">$c/$_TAF/$queueFName_active"; 
 		for (my $i = $#popQueue+1; $i<=$#pushQueue; $i++) { printf Fin_tmp "[%5d] %s    \n", $i, $pushQueue[$i] if (defined $pushQueue[$i]);  }
		if ($#popQueue+1 > $#pushQueue) { print Fin_tmp "No task to proceed\n";}
 		close Fin_tmp;  }
	################# generate Active Queue & reset Queue Operation ###################
 	if (($#popQueue < $#pushQueue ) || ($operation =~ /reset/i)) { open Fin, ">$c/$_TAF/$queueFName_active"; 
 		for (my $i = $#popQueue+1; $i<=$#pushQueue; $i++) { printf Fin "[%5d] %s\n", $i, $pushQueue[$i] if (defined $pushQueue[$i]);  }
		if ($#popQueue+1 > $#pushQueue) { print Fin "No task to proceed\n";}
 		close Fin;  }

	################# autoReset Operation ###################
	if (($#popQueue > $queueSizeLimit ) || ($operation =~ /reset/i)) { open Fin, ">$c/$_TAF/$queueFName"; close Fin; return; }
	
	$pushQueueSize = $#pushQueue + 1;
	################# QueueSize ###################
	if ($operation =~ /queueSize/i) {
		return ($#pushQueue - $#popQueue); 	
	}

	################# Push Operation ###################
	if ($operation =~ /push/i) { 

		if (defined $tafCmd) {
		if (($tafCmd =~ /set_property[1-2]/i) || ($tafCmd =~ /get_property[1-2]/i) || ($tafCmd =~ /printTcFilters/i)) { ;
		} else {
		open Fin, ">>$c/$_TAF/$queueFName"; print Fin "pushed  ($pushQueueSize): $tafCmd\n"; close Fin; 
		return; 
		}
		}
	}

	################# Pop Operation ###################
	elsif ($operation =~ /pop/i) {
		for (my $i = 1; $i <= $#pushQueue; $i++ ) { 
			if  (defined $popQueue[$i] ) { ; } else {	# already popped
				if ((defined $pushQueue[$i]) && ($pushQueue[$i] !~ /_notPushed_ignored/i)) {
					open Fin, ">>$c/$_TAF/$queueFName"; print Fin "popped  ($i): $pushQueue[$i]\n"; close Fin;
					return $pushQueue[$i];
				} else {
					open Fin, ">>$c/$_TAF/$queueFName"; print Fin "popped  ($i): _notPushed_ignored\n"; close Fin;
					return "_notPushed_ignored";
				}
			}
		} 
	} 
	################# check Operation ###################
	elsif ($operation =~ /checkQueue/i) { 
		for (my $i = 0; $i <= $#pushQueue; $i++ ) { 
			if  (defined $popQueue[$i] ) { ; } else {	# already popped
				return $pushQueue[$i];
			}
		}
	}

}

sub listAll { find({preprocess=> sub {return reverse sort @_;}, wanted=> \&recursiveSearchListAll}, $SvrDrive); }
sub recursiveSearchListAll() { print "pa: $SvrDrive\n"; if (($File::Find::name =~ /tc.pl/) && ($File::Find::name =~ /$SvrTCNamePattern/i)) {	print "$File::Find::name\n"; } }

sub updateIPHtml { $SvrProjName = ".*"; find({preprocess=> sub {return reverse sort @_;}, wanted=> \&recursiveSearchListHtml}, $SvrDrive); 1;}
sub recursiveSearchListHtml() { if ((($File::Find::name =~ /\.html?/) || ($File::Find::name =~ /\.cgi\s*$/))&& ($File::Find::name =~ /$SvrProjName/i)) {	
		if (($File::Find::name =~ /_bak.htm/i) || ($File::Find::name =~ /_bak.cgi/) || ($File::Find::name =~ /.htm[~|_]/) || ($File::Find::name =~ /htm.s/)) {;} elsif ($File::Find::name =~ /\.html\S/) {;} else { &updateIP($File::Find::name, $ip);}
	} 
}



sub createTS {		# Create Testsuite for Testbed 
	# 1 create index.pl from /tmp/createTS_indexindex.pl	
	# 2 create index.pl from /tmp/createTS_index.pl
	# 2.5 create index.pl from c:/tsname/index.txt
	# 3 create powershell HelloWorld TS (index.pl and index.ps)
	# 4 create Perl       HelloWorld TS (index.pl)
	# &generateTAFTestsuie() displays TS on webUI


	if ($SvrProjName !~ /$c/i) { print "Warning: testcase should start with $c\n"; }
	my $tsName = $SvrProjName; $tsName = shift if @_;
	$SvrProjName = $tsName; if (-e $SvrProjName) {;} else { mkdir $SvrProjName; }

	if (-e "$SvrProjName/$TSHookNameParent") {
		my $rst = `$perl $SvrProjName/$TSHookNameParent`;
		print "$SvrProjName/$TSHookName is generated from $SvrProjName/$TSHookNameParent\n";
		;
	} elsif (-e "$c/$_TAF/$createTS_indexindex" ) {
		print " --> Create $SvrProjName    <- from $c/$_TAF/$createTS_indexindex\n"; 
		copy ("$c/$_TAF/$createTS_indexindex", "$SvrProjName/$createTS_indexindex");
		print "$SvrProjName/$createTS_indexindex is running ......\n";
		my $rst = `$perl $SvrProjName/$createTS_indexindex`;
		print "$SvrProjName/$createTS_indexindex is completed.....\n";
	} elsif (-e "$c/$_TAF/$createTS_index" ) {
		print " --> Create $SvrProjName    <- from $c/$_TAF/$createTS_index\n"; 
		move ("$c/$_TAF/$createTS_index", "$SvrProjName/$TSHookNameGenerated");
	} elsif (-e "$SvrProjName/$TSDescName" ) {
		print " --> Create $SvrProjName    <- from $c/$TSDescFName\n"; 
		&generateTSFromDesc();
	} elsif ($SvrProjName =~ s/_powershell_//i)  { 
		print " --> Create Powershell Testsuite: $SvrProjName\n"; &generatePowershell_ps1_template($SvrProjName); 
	} elsif ($NofTCinTSTemplate != -1 ) {
		&createTS_B($SvrProjName);
	} else { 
		print " --> Create Perl Testsuite: $SvrProjName\n";       &generatePerl_pl_template($SvrProjName); 
	}
	&generateTAFTestsuite ();
1;
}

################## Add a new Testcase based on tcIdFrom by changing the arguments 
sub addTCToDesc {
my $name; my $driver; my $description; my $dependencies; my $automationId; my $ctr = 0; my @desc; my $postProcessors; my @post; my $preProcessors;
my $logs; my $executors;  my $arguments; my $tcId; my %tcDescFrom;  my $validator;  my $tcDescFrom=""; my $editFiles="";


my $tcIdFrom 		= $tcFrom 		; $tcIdFrom  = shift if @_; 
my $argumentsInput 	= $index_pl_arguments	; $arguments = shift if @_;
my $index_pl 		= $TSHookName;


if (-e "$SvrProjName/$TSDescName") {;} else { print "Warning: $SvrProjName/$TSDescName doesn't exist. addTCToDesc exites\n"; exit; }
open Fin_index, "$SvrProjName/$TSDescName"; @_ = <Fin_index>; close Fin_index;  	print " <- $SvrProjName/$TSDescName\n";
open Fout_index, "> $SvrProjName/${TSDescName}_"; 					print " -> $SvrProjName/${TSDescName}_ ->$SvrProjName/${TSDescName}\n";
foreach my $each (@_) {
	if ($each =~ /^\s*Automation:\s*(\d+)?\s*/i) { 
		$tcId = $1;
		print Fout_index "$each";
	} else {
		print Fout_index "$each";

		if (($tcId) && ($tcId == $tcIdFrom ) && ($each =~ /^\s*(\S+)\s*:\s*(.+)\s*$/)) {
			my $fieldName = $1; my $fieldValue = $2; $fieldName =~ s/^\s*//g; $fieldName =~ s/\s*$//g; $fieldValue=~ s/^\s*//g; $fieldValue=~ s/\s*$//g;

			if ($fieldName =~ /^\s*name\b/i) {                                  				; $tcDescFrom{'name'} 		.= sprintf "    %-50s  : %-50s\n", $fieldName , $fieldValue;}
			if ($fieldName =~ /^\s*driver\b/i) { $executors .= $fieldValue."_|_"				; $tcDescFrom{'executor'} 	.= sprintf "    %-50s  : %-50s\n", $fieldName , $fieldValue;}
			if ($fieldName =~ /^\s*arguments\b/i) { $arguments .= $fieldValue."_|_"				; $tcDescFrom{'arguments'} 	.= sprintf "    %-50s  : %-50s\n", $fieldName , $fieldValue;}
			if ($fieldName =~ /^\s*validator\b/i) { $validator  = $fieldValue      				; $tcDescFrom{'validator'} 	 = sprintf "    %-50s  : %-50s\n", $fieldName , $fieldValue;}
			if ($fieldName =~ /^\s*Executor\b/i) { $executors .= $fieldValue."_|_"				; $tcDescFrom{'executor'} 	.= sprintf "    %-50s  : %-50s\n", $fieldName , $fieldValue;}
			if ($fieldName =~ /^\s*description\b/i) { $description = $fieldValue; push(@desc, $fieldValue)	; $tcDescFrom{'description'}	.= sprintf "    %-50s  : %-50s\n", $fieldName , $fieldValue;}
			if ($fieldName =~ /^\s*PostProcessor\b/i) { $postProcessors .= $fieldValue."_|_"		; $tcDescFrom{'PostProcessor'}	.= sprintf "    %-50s  : %-50s\n", $fieldName , $fieldValue;}
			if ($fieldName =~ /^\s*PreProcessor\b/i) { $preProcessors .= $fieldValue."_|_"			; $tcDescFrom{'PreProcessor'}	.= sprintf "    %-50s  : %-50s\n", $fieldName , $fieldValue;}
			if ($fieldName =~ /^\s*dependency\b/i) { $dependencies .= $fieldValue."_|_"			; $tcDescFrom{'dependency'}	.= sprintf "    %-50s  : %-50s\n", $fieldName , $fieldValue;}
			if ($fieldName =~ /^\s*preRequsite\b/i) { $dependencies .= $fieldValue."_|_"			; $tcDescFrom{'preRequsite'}	.= sprintf "    %-50s  : %-50s\n", $fieldName , $fieldValue;}
			if ($fieldName =~ /^\s*logs\b/i) { $logs .= $fieldValue."_|_"	 				; $tcDescFrom{'log'} 		.= sprintf "    %-50s  : %-50s\n", $fieldName , $fieldValue;}	
			if ($fieldName =~ /^\s*log\b/i) { $logs .= $fieldValue."_|_"	 				; $tcDescFrom{'log'} 		.= sprintf "    %-50s  : %-50s\n", $fieldName , $fieldValue;}	
			if ($fieldName =~ /^\s*File\b/i) { $editFiles .= $fieldValue."_|_"	 			; $tcDescFrom{'editFiles'} 	.= sprintf "    %-50s  : %-50s\n", $fieldName , $fieldValue;}	
		}
	}
}

$tcId ++; 


if (!$tcDescFrom{'name'}         ) { $tcDescFrom{'name'} 		=""	;} chop $tcDescFrom{'name'} 		;
if (!$tcDescFrom{'dependency'}   ) { $tcDescFrom{'dependency'}		=""	;} chop $tcDescFrom{'dependency'}	;
if (!$tcDescFrom{'preRequsite'}  ) { $tcDescFrom{'preRequsite'}		=""	;} chop $tcDescFrom{'preRequsite'}	;
if (!$tcDescFrom{'PreProcessor'} ) { $tcDescFrom{'PreProcessor'}	=""	;} chop $tcDescFrom{'PreProcessor'}	;
if (!$tcDescFrom{'executor'}     ) { $tcDescFrom{'executor'} 		=""	;} chop $tcDescFrom{'executor'} 	;
if (!$tcDescFrom{'validator'}    ) { $tcDescFrom{'validator'} 		=""	;} chop $tcDescFrom{'validator'} 	;
if (!$tcDescFrom{'arguments'}    ) { $tcDescFrom{'arguments'} 		=""	;} chop $tcDescFrom{'arguments'} 	;
if (!$tcDescFrom{'description'}  ) { $tcDescFrom{'description'}		=""	;} chop $tcDescFrom{'description'}	;
if (!$tcDescFrom{'PostProcessor'}) { $tcDescFrom{'PostProcessor'}	=""	;} chop $tcDescFrom{'PostProcessor'}	;
if (!$tcDescFrom{'log'}          ) { $tcDescFrom{'log'}			=""	;} chop $tcDescFrom{'log'}		;
if (!$tcDescFrom{'editFiles'}    ) { $tcDescFrom{'editFiles'}		=""	;} chop $tcDescFrom{'editFiles'}		;

$tcDescFrom{'arguments'} = sprintf "    %-50s  : %-50s", "Arguments", $argumentsInput	;

$tcDescFrom{'description'} =~ s/(^\s*Description\s*:)/$1 $tcId <- $tcFrom/;


print Fout_index<<EOF;

#########################################
#            added TC 			#
#########################################

Automation: $tcId
$tcDescFrom{'name'} 
$tcDescFrom{'description'}
$tcDescFrom{'preRequsite'}
$tcDescFrom{'dependency'}
$tcDescFrom{'PreProcessor'}
$tcDescFrom{'executor'} 
$tcDescFrom{'arguments'} 
$tcDescFrom{'validator'} 
$tcDescFrom{'PostProcessor'}
$tcDescFrom{'log'}
$tcDescFrom{'editFiles'}


EOF
close Fin_index;
close Fout_index;

	if ( -e  "$SvrProjName/$TSDescName") { move ("$SvrProjName/$TSDescName", "$SvrProjName/${TSDescName}.bak"); }
	move ("$SvrProjName/${TSDescName}_",  "$SvrProjName/${TSDescName}");
}

####
sub getTSName_from_TSDesc {		# e.g. Name		: c:/_perl1     return c:/_perl1
	if ( -e "$SvrProjName/$TSDescName") {;} else { print "Warning: $SvrProjName/$TSDescName doens't exist. return -1 from generateTSFromDesc\n"; return "-1"; }
	open Fin_index, "$SvrProjName/$TSDescName"; @_ = <Fin_index>; close Fin_index;  	print " <- $SvrProjName/$TSDescName\n";
	foreach my $each (@_) {
		if ($each =~ /^\s*(\S+)\s*:\s*(.+)\s*$/) {
			my $fieldName = $1; my $fieldValue = $2; $fieldName =~ s/^\s*//g; $fieldName =~ s/\s*$//g; $fieldValue=~ s/^\s*//g; $fieldValue=~ s/\s*$//g;
			if ($fieldName =~ /^\s*name\b/i			) { $fieldValue 	 =~ s/$c[\/|\\]//ig		; 
					$fieldValue =~ s/^\s*(\S):[\\|\/]//ig;	
				return $fieldValue; }
		}
	}
	print "Warning: getTSName_from_TSDesc: $SvrProjName/$TSDescName is in wrong format. It doens't have name. Exit.\n";  exit;
}
####


##################

sub generateTSFromDesc {
my $name=""; my $driver; my $description; my $dependencies; my $automationId; my $ctr = 0; my @desc; my @automations; my $postProcessors; my @post; my $preProcessors;
my $logs; my $editFiles; my $executors; my $arguments; my %tcDescFrom; my $validator;  my $tcDescFrom="";

my $SvrProjName_current = &getTSName_from_TSDesc(); 

if ($SvrProjName_current =~ /\-1/) { print "$SvrProjName/$TSDescName doens't exist; return -1\n"; return -1; }

my $index_pl = $TSHookName;

if ( -e "$SvrProjName/$TSDescName") {;} else { print "Warning: $SvrProjName/$TSDescName doens't exist. Returned from generateTSFromDesc\n"; return -1; }
	my $SvrProjName_C_no = &getTCName_C_no ($SvrProjName);	

	&gen_ts_tc_cgi($c, $ip, $SvrProjName_C_no, $TSDescName);
	&gen_ts_tc_cgi($c, $ip, $SvrProjName_C_no, $TSHookName);
open Fin_index, "$SvrProjName/$TSDescName"; @_ = <Fin_index>; close Fin_index;  	print " <- $SvrProjName/$TSDescName\n";
open Fout_index, "> $SvrProjName/$TSHookName"; 						print " -> $SvrProjName/$TSHookName\n";
print Fout_index<<EOF_index;
use threads;
use threads::shared;
EOF_index
print Fout_index "#### Main ####\n";
print Fout_index "\$c = \"c:\"; \$_TAF=\"$_TAF\"; \n";
foreach my $each (@_) {
	$each =~ s/\\/\\\\/g;	# bug fix  csharp compile bug fix 
	# $each =~ s/\\/_bs_/g;	# bug fix 
	# $each =~ s/\\/\//g;	# bug fix 
	if    ($each =~ /#/) { my @tmp = split (/\#/, $each); $each = $tmp[0]; }		# temporal solution for comment
	if    ($each =~ /^\s*$/) {;}
	elsif ($each =~ /#/) {;}
	elsif ($each =~ /^\s*Automation\s*:\s*(\d+)?\s*/i) {
		$automationId = $1;
		push (@automations, $automationId);
		if ($ctr >=1) {if ($name =~ /^\s*$/) { print "Error: The $TSDescName doesn't have name property. Exit!\n"; }
		                &genTC($c,$name,$description, $dependencies, $logs, $editFiles, $preProcessors, $executors, $arguments, $validator, $postProcessors, $ctr, $tcDescFrom); 
		$name 	= "" ; $driver = "" ; $description = ""; $dependencies  = "";  $postProcessors = ""; $preProcessors = ""; $logs = ""; $editFiles=""; $executors=""; $arguments =""; $validator="";
		$tcDescFrom = "";
			}
		$ctr ++; 
	} else {
		$each =~ s/$c\/$SvrProjName_current/$SvrProjName/ig;
		$tcDescFrom .= $each;
		if ($each =~ /^\s*(\S+)\s*:\s*(.+)\s*$/) {
			my $fieldName = $1; my $fieldValue = $2; $fieldName =~ s/^\s*//g; $fieldName =~ s/\s*$//g; $fieldValue=~ s/^\s*//g; $fieldValue=~ s/\s*$//g;



			if ($fieldName =~ /^\s*name\b/i			) { $fieldValue 	 =~ s/$c[\/|\\]//ig		; $name = $fieldValue; $name =~ s/"|'//g; $tcDescFrom{'name'} = $name; }
			if ($fieldName =~ /^\s*location\b/i			) { $fieldValue 	 =~ s/$c[\/|\\]//ig	; $name = $fieldValue; $name =~ s/"|'//g; $tcDescFrom{'name'} = $name; }
			if ($fieldName =~ /^\s*driver\b/i		) { $executors 		.= $fieldValue."_|_"		; $tcDescFrom{'executor'} = $executors; }
			if ($fieldName =~ /^\s*arguments\b/i		) { 
									    if ($fieldValue =~ /-/) { $fieldValue =~ s/\"//g; }	
				                                            $arguments 		.= $fieldValue."_|_"		; $tcDescFrom{'arguments'} = $arguments;}
			if ($fieldName =~ /^\s*validator\b/i		) { $validator 		 = $fieldValue      		; $tcDescFrom{'validator'} = $validator;}
			if ($fieldName =~ /^\s*executor\b/i		) { $executors 		.= $fieldValue."_|_"		; $tcDescFrom{'executor'} = $executors;}
			if ($fieldName =~ /^\s*description\b/i		) { $description 	 = $fieldValue; push(@desc, $fieldValue)	; $tcDescFrom{'description'}= $description; }
			if ($fieldName =~ /^\s*PostProcessor\b/i	) { $postProcessors 	.= $fieldValue."_|_"		; $tcDescFrom{'PostProcessor'}= $postProcessors;}
			if ($fieldName =~ /^\s*PreProcessor\b/i		) { $preProcessors 	.= $fieldValue."_|_"		; $tcDescFrom{'PreProcessor'}= $preProcessors; }
			if ($fieldName =~ /^\s*dependency\b/i		) { $dependencies 	.= $fieldValue."_|_"		; $tcDescFrom{'dependency'}= $dependencies;}
			if ($fieldName =~ /^\s*preRequsite\b/i		) { $dependencies 	.= $fieldValue."_|_"		; $tcDescFrom{'preRequsite'}= $dependencies;}
			if ($fieldName =~ /^\s*logs\b/i			) { $logs 		.= $fieldValue."_|_"		; $tcDescFrom{'log'} = $logs; }	
			if ($fieldName =~ /^\s*log\b/i			) { $logs 		.= $fieldValue."_|_"		; $tcDescFrom{'log'} = $logs; }	
			if ($fieldName =~ /^\s*editFiles\b/i		) { $editFiles 		.= $fieldValue."_|_"		; $tcDescFrom{'editFile'} = $editFiles; }	
			if ($fieldName =~ /^\s*files\b/i		) { $editFiles 		.= $fieldValue."_|_"		; $tcDescFrom{'editFile'} = $editFiles; }	
			if ($fieldName =~ /^\s*file\b/i			) { $editFiles 		.= $fieldValue."_|_"		; $tcDescFrom{'editFile'} = $editFiles; }	
		}
	}
}
# &genTCDefintion($tcDescFrom, $ctr) ;
if ($validator) {;} else { $validator = 0; }

&genTC($c,$name,$description, $dependencies, $logs, $editFiles, $preProcessors, $executors, $arguments, $validator, $postProcessors, $ctr, $tcDescFrom);
# $name 	= "" ; $driver = "" ; $description = ""; $dependencies  = "";  $postProcessors = ""; $preProcessors = ""; $logs = ""; $editFiles=""; $executors=""; $arguments =""; $validator="";
		$tcDescFrom = "";
$ctr++;

print Fout_index<<'EOF';

sub readArgumentsFromFile {
	my $arguments = shift if @_;
	my $return = "";
	if (-e $arguments ) {
		open File_arg, $arguments; while ($_ = <File_arg>) { $_ =~ s/\n//gi; $return .= $_; } close File_arg;
		return $return;
	}
}


sub runBackground {
	my $cmd = shift;
#print "Starting backgroun job \n";
my @threads;
for ( my $count = 1; $count <= 1; $count++) {
        my $t = threads->new(\&background, $cmd);
         push(@threads,$t);
}
foreach (@threads) { my $num = $_->join; } # print "done with $num\n"; }
}

sub background { my $cmd = shift; my $rst = system $cmd; }


sub generateTmpLog {
	my $fname = shift;
	my $msg   = shift;
	open Fout_tmpLog, "> $fname";
	print Fout_tmpLog "This is a temp log file $msg\n";
	close Fout_tmpLog;
}


sub passFail {
	my $fname = shift; 
	if ( -e $fname ) {;} else { return " $fname does not exist"; }
	open Fin, $fname; @_ = <Fin>; close Fin;
	foreach my $each (@_) { if ($each =~ /(error|fail)\b/i) {return "< fail (=~ error|fail)";} }
	return "";
}


sub updateReturn {
	my $return_old = shift; 	my $return_new = shift; 	

	if (($return_old =~ /^\s*$/) || ($return_old =~ /null/i)){ $return = $return_new; }
	if (($return_old =~ /pass/i) && ($return_new =~ /fail/i)) { $return = "fail"; }
	if (($return_old =~ /pass/i) && ($return_new =~ /pass/i)) { $return = "pass"; }
	if (($return_old =~ /pass/i) && ($return_new =~ /^\s*$/i)){ $return = "pass"; }
	if ($return_old =~ /fail/i) { $return = "fail"; }
	return $return;
}
EOF
print Fout_index<<EOF; 

#### Main ####
\$name = \"$name\"; 
if (\$ARGV[0]) { 
	open Fout, ">\$c/\$name/_tcLogAppend.txt";
EOF
	for (my $i =0; $i <= $#desc; $i++ ) {
		my $_i = $i + 1;
	print Fout_index "\tif (\$ARGV[0] == $_i) { print &tc$_i();}\n";
	}

print Fout_index <<EOF1; 
	close Fout;
} else {
print<<EOF;
EOF1

	for (my $i =0; $i <= $#desc; $i++ ) { print Fout_index "$desc[$i]\n"; }

print Fout_index <<EOF1; 
EOF
;
}
EOF1

}

############
sub gen_ts_tc_cgi {
my $c 		= shift;
my $ip 		= shift;
my $tsName 	= shift;  
my $finName 	= shift;
my $foutName 	= shift;
my $title	= "Edit Test";
if ($finName =~ /index\.txt/i) { $title = "Test Suite Description"; }
if ($finName =~ /index\.pl/i ) { $title = "Test Suite Driver"; }
$foutName = $finName;
$foutName = "$c/$_TAF/$tsName/$foutName.cgi";



if (-e "$c/$tsName/$finName") {;} else { 
	mkpath "$c/$tsName";		# bug fix 
	open Fout_ts_tc, ">$c/$tsName/$finName";  # todo: file check is needed 
	print Fout_ts_tc "The file \"$c/$tsName/$finName\" doens't exist. (index.txt might not exist. This is normal.)\n"; 
	close Fout_ts_tc; }

if (-e "$c/$_TAF/$tsName") {;} else { mkpath "$c/$_TAF/$tsName" }

my $str=<<'EOF';
use CGI qw/:standard/;
my $c 		= "c:";
my $_TAF 	= "___TAF__";
my $tstcName	= "__tstcName__";		$tstcName =~ s/^\s*$c\///g;
my $tsName	= "__tsName__";		$tsName =~ s/^\s*$c\///g;
my $ip     	= "__ip__"; 
my $orig_url 	= "${ip}__http_port__/$tsName/index_http.htm";
my $this_url 	= "${ip}__http_port_IIS__/$tsName/ts.cgi";
my $fname	= "$c/$tstcName/__finName__";
my $fnameB	= "$c/$_TAF/$tstcName/__finName__";
my $cgiDesc 	= "__title__ ($fname)";
my $index_http_htm = "index_http.htm";
my $main_css			=<<EOFSummary_dot;
<link rel='stylesheet' href="/main.css" type='text/css' media='all' />
EOFSummary_dot
my $main_script=<<'EOF_script';

<script src="//code.jquery.com/jquery-git.js"></script>
<script src="http://__ip__/ace-builds-master/src-min-noconflict/ace.js" type="text/javascript" charset="utf-8"></script>
<script src="http://__ip__/ace-builds-master/src-min-noconflict/keybinding-vim.js"></script>

<script>
    // Hook up ACE editor to all textareas with data-editor attribute
    $(function () {
        $('textarea[TCProperty]').each(function () {
            var textarea = $(this);
            var mode = textarea.data('editor');
            var editDiv = $('<div>', {
                position: 'absolute',
                width: textarea.width(),
                height: textarea.height(),
                'class': textarea.attr('class')
            }).insertBefore(textarea);

            textarea.css('visibility', 'hidden');

            var editor = ace.edit(editDiv[0]);
            editor.renderer.setShowGutter(false);
            editor.getSession().setValue(textarea.val());
            // editor.getSession().setMode("ace/mode/" + mode);
            editor.getSession().setMode("ace/mode/perl");
            editor.setKeyboardHandler("ace/keyboard/vim");
             editor.setTheme("ace/theme/idle_fingers");
            // editor.setTheme("ace/theme/twilight");
            
            // copy back to textarea on form submit...
            textarea.closest('form').submit(function () {
                textarea.val(editor.getSession().getValue());
            })

        });
    });
</script>

EOF_script

print  header, start_html("$cgiDesc"), h2(""), $main_css;
my $fhandle = \*STDOUT; &prTopTitle($fhandle); 

if ( !param() ) { 
open FinTSDesc, $fname; @_ = <FinTSDesc>; close FinTSDesc; my $tsDesc = "@_"; $tsDesc =~ s/\n\s/\n/g;

print start_form();
print "$cgiDesc";
print submit(-value=>'Update',-name=>"Update");
print submit(-value=>'Back', -name=>"Back");
print "<br>";
print textarea(-NAME=>'TCProperty', -TCProperty=>"markdown", -id=>'textarea-adjustable-width', -default=>$tsDesc, -wrap=>'OFF', -rows=>50). "<br><br>";

print end_form();

} else { 

$value_properties = param('TCProperty'); $value_properties =~ s/\r//g;
$value_Update= param('Update'); $value_Update=~ s/\r//g;
$value_Back= param('Back'); $value_Back=~ s/\r//g;

open  Fout_out, "> $fname"; print Fout_out "$value_properties\n"   ; close Fout_out;
open  Fout_out, "> $fnameB"; print Fout_out "$value_properties\n"   ; close Fout_out;

#if ($value_Back) 	{ print "<a href=\"http://$orig_url\">Goto Testsuite </a>"; 		}
#if ($value_Update) 	{ print "<a href=\"http://$orig_url\">Update is completed. Continue editing</a>";}
if ($value_Back) 	{ &redirect(); }
if ($value_Update) 	{ &redirect(); }
}

print end_html;
print $main_script;
sub prTopTitle {
	my $fout = $_[0];
	if ( -e "$c/$_TAF/$index_http_htm") { ;} else { return; }
	open Fin_prTopTitle, "$c/$_TAF/$index_http_htm";
	my $inSearch = "n";
	while ($_ = <Fin_prTopTitle>) {
		if ($_ =~ /\"main-nav\"/)  { $inSearch = "y"; }
		if ($inSearch =~ /y/i) { print {$fout} $_;}
		if ($_ =~ /\"container\"/) { $inSearch = "n"; }
	}
	close Fin_prTopTitle;
}

sub redirect {
print<<EOF_redirect;
<html>
<head>
<title>Test Automation Framework</title>
<meta http-equiv="Content-Type" $content="text/html; charset=iso-8859-1" />
</head>
<body>
<pre><div id=\"running-cmd\">Running at __ip__ ......</div>
</pre>
<meta http-equiv="refresh" content="1; url=http://__ip____http_port_IIS__/$tsName/__index_http_htm__">
</body>
</html>

<script src="//code.jquery.com/jquery-git.js"></script>
<script src="http://localhost/ace-builds-master/src-min-noconflict/ace.js" type="text/javascript" charset="utf-8"></script>
<script src="http://localhost/ace-builds-master/src-min-noconflict/keybinding-vim.js"></script>

<script>
    // Hook up ACE editor to all textareas with data-editor attribute
    $(function () {
        $('textarea[TCProperty]').each(function () {
            var textarea = $(this);
            var mode = textarea.data('editor');
            var editDiv = $('<div>', {
                position: 'absolute',
                width: textarea.width(),
                height: textarea.height(),
                'class': textarea.attr('class')
            }).insertBefore(textarea);

            textarea.css('visibility', 'hidden');

            var editor = ace.edit(editDiv[0]);
            editor.renderer.setShowGutter(false);
            editor.getSession().setValue(textarea.val());
            // editor.getSession().setMode("ace/mode/" + mode);
            editor.getSession().setMode("ace/mode/perl");
            editor.setKeyboardHandler("ace/keyboard/vim");
             editor.setTheme("ace/theme/idle_fingers");
            // editor.setTheme("ace/theme/twilight");
            
            // copy back to textarea on form submit...
            textarea.closest('form').submit(function () {
                textarea.val(editor.getSession().getValue());
            })

        });
    });
</script>

EOF_redirect
}





EOF
$str =~ s/__tstcName__/$tsName/g;
$str = &template2TS($str);
#$str =~ s/c:/$c/gi; $str =~ s/__ip__/$ip/gi; $str =~ s/__tsName__/$tsName/gi; 

$str =~ s/__finName__/$finName/gi;
$str =~ s/__title__/$title/gi;
open Fout, "> $foutName";
print Fout $str;
close Fout;
print " -> $foutName\n";
return 1;
}
############

sub aws{
	# sync AWS
#my $cmd='robocopy \\\\tsclient\C\strawberry\perl\site\lib\Test c:\strawberry\perl\site\lib\Test    AutomationFramework.pm'; my $rst = `$cmd`; print $rst;
#   $cmd='robocopy \\\\tsclient\C\strawberry\perl\site\lib\Test c:\Perdir
#   l64\site\lib\Test             AutomationFramework.pm';    $rst = `$cmd`; print $rst;
	# gen initAWS
if ( -e "$c/$_TAF") {;} else { mkdir "$c/$_TAF"; }
print " -> $c/$_TAF/_taf_schedule.bat\n";
open FoutScheduler , "> $c/$_TAF/_taf_schedule.bat";
print FoutScheduler<<EOF;

perl $c\\$_TAF\\taf.svr
EOF
close FoutScheduler;

print " -> $c/$_TAF/taf_startup.pl\n";
open FoutStartup, "> $c/$_TAF/taf_startup.pl";
print FoutStartup<<EOF;
print "checking ... $c/$_TAF/taf_setup.done\n";
if (-e "$c/$_TAF/taf_setup.done") {
;
} else {
open F, ">$c/$_TAF/taf_setup.done"; close F;
my \$cmd = 'c:\\strawberry\\perl\\bin\\perl -MTest::AutomationFramework -e "resetTAF"';
my \$rst = `\$cmd`; print \$rst;
}
EOF
close FoutStartup;

print<<'EOF';
schtasks  /create  /TN TaaSSvr     /TR "perl c:\_TAF\taf.svr"        /sc onstart /RU support /RP amazon123 /RL HIGHEST
schtasks  /create  /TN TaaSStartup /TR "perl c:\_TAF\taf_startup.pl" /sc onstart /RU support /RP amazon123 /RL HIGHEST
EOF
}

sub genTCDefinition {
	my $tcDescFrom 	= shift if @_;
	my $testcaseN   = shift if @_;


}


sub genTC {
	my $c 		= $c;	$c 		= shift if @_;
	my $name 	= "";	$name 		= shift if @_;
	my $description = ""; 	$description 	= shift if @_;
	my $dependencies= ""; 	$dependencies	= shift if @_;
	my $logs 	= "";	$logs 		= shift if @_;
	my $editFiles	= "";	$editFiles 	= shift if @_;  
	my $preProcessors =""; 	$preProcessors 	= shift if @_;
	my $executors 	= ""; 	$executors   	= shift if @_;
	my $arguments	= "";	$arguments   	= shift if @_;	if (defined($arguments)) {;} else { $arguments ="";} $arguments =~ s/_\|_/ /g  ; # $arguments =~ s/\s+//g;
	my $validator	= "";	$validator	= shift if @_; 
	my $postProcessors="";	$postProcessors = shift if @_;
	my $ctr		=0;	$ctr  		= shift if @_;
	my $tcDescFrom	= "";	$tcDescFrom	= shift if @_;
if ($validator) {;} else { $validator = 0;}
	my $TC_taf_path	=sprintf "$c/$_TAF/%s/testcase%04s",&getTSName_dir($SvrProjName),$ctr;
	if ( -e  $TC_taf_path ) {;} else { mkpath $TC_taf_path; }
	if (-e "$TC_taf_path/index.txt"  ) {;} else {open Fout_def, "> $TC_taf_path/index.txt"  ; print Fout_def $tcDescFrom; close Fout_def;}
	if (-e "$TC_taf_path/tc_def.txt" ) {;} else {open Fout_def, "> $TC_taf_path/tc_def.txt" ; print Fout_def $tcDescFrom; close Fout_def;}
	if (-e "$TC_taf_path/tc_args.txt") {;} else {open Fout_def, "> $TC_taf_path/tc_args.txt"; print Fout_def $arguments ; close Fout_def;}
	if (-e "$TC_taf_path/tc_vali.txt") {;} else {open Fout_def, "> $TC_taf_path/tc_vali.txt"; print Fout_def $validator ; close Fout_def;}
	if (-e "$TC_taf_path/tc_exec.txt") {;} else {open Fout_def, "> $TC_taf_path/tc_exec.txt"; print Fout_def $executors ; close Fout_def;}

	if ($c			) {;} else { $c			= "";} 
	if ($name 		) {;} else { $name 		= "";} 
	if ($description 	) {;} else { $description 	= "";} 
	if ($dependencies	) {;} else { $dependencies	= "";} 
	if ($logs		) {;} else { $logs 		= "";} 
	if ($editFiles	 	) {;} else { $editFiles 	= "";} 
	if ($preProcessors	) {;} else { $preProcessors 	= "";} 
	if ($executors 		) {;} else { $executors   	= "";} 
	if ($arguments		) {;} else { $arguments   	= "";} 
	#if (($validator		) || ($validator == 0)){;} else { $validator		= "";} 
	if (($validator		) ){;} else { $validator		= "";} 
	if ($postProcessors	) {;} else { $postProcessors 	= "";} 
	if ($ctr		) {;} else { $ctr  		= "";}
	if ($tcDescFrom		) {;} else { $tcDescFrom	= "";} 


#	$dependencies	=~ s/\\\"/_back_doubleQuote_/ig; 
#	$preProcessors	=~ s/\\\"/_back_doubleQuote_/ig; 
	$executors  	=~ s/\\\"/_back_doubleQuote_/ig; 
#	$arguments  	=~ s/\\\"/_back_doubleQuote_/ig; 
#	$postProcessors =~ s/\\\"/_back_doubleQuote_/ig; 

 	$dependencies  =~ s/"/\\"/g;
 	$preProcessors =~ s/"/\\"/g;
 	$executors     =~ s/"/\\"/g; 
 	$arguments     =~ s/"/\\"/g;
 	$postProcessors=~ s/"/\\"/g;

#	$dependencies	=~ s/_back_doubleQuote_/\\\"/ig; 
#	$preProcessors	=~ s/_back_doubleQuote_/\\\"/ig; 
	$executors	=~ s/_back_doubleQuote_/\\\"/ig; 
#	$arguments	=~ s/_back_doubleQuote_/\\\"/ig; 
#	$postProcessors	=~ s/_back_doubleQuote_/\\\"/ig; 

	my $cmd = sprintf "$c/$name/manual_tc_testcase%04d,  $c/$_TAF/$name/testcase%04d/tc_note.txt", $ctr, $ctr;
	my $copyfrom = sprintf "$c/$name/manual_tc_testcase%04d", $ctr;
	my $copyto   = sprintf "$c/$_TAF/$name/testcase%04d/tc_note.txt", $ctr;
	copy ($copyfrom, $copyto); 	# update the manual step
	print " -> $copyfrom -cp-> $copyto\n"; 
print Fout_index<<EOF;

sub tc$ctr {
	######################### List of Test Case Info ########################
	\$name 		= \"$name\";
	\$description	= \"$description\";
	\$dependencies 	= \"$dependencies\";
	\$preProcessors	= \"$preProcessors\";   
	\$executors	= \"$executors\";
	\$arguments	= \"$arguments\";	my \$pr_exec= "y"; if (\$arguments =~ s/__no_print_executor__//i) { \$pr_exec = "n";} 
	\$validator	= \"$validator\";  if (\$validator =~ /^\\s*\$/) { \$validator = "_no_validator_";} 
	\$logs		= \"$logs\";
	\$editFiles	= \"$editFiles\";
	\$postProcessors\t= \"$postProcessors\";
	\$c 		= \"$c\";
	######################### List of Test Case Info ########################
EOF

print Fout_index<<'EOF';

	#########################  preRequsite/Dependency Verification ##########
	foreach my $eachDependency (split /_\|_/, $dependencies) { 
		my $dependencyURL ;
		if ($eachDependency =~ s/\s*#\s*(.+)\s*$//g) { $dependencyURL = $1;} 
		$eachDependency =~ s/^\s*"//g;
		$eachDependency =~ s/"\s*$//g;
		if ( -e $eachDependency) {;} else { print "warning: dependency check failed. $eachDependency doens't exist. $dependencyURL\n"; return -1;}	
	}

#	open Fout_log, ">$c/$name/_tcLogAppend.txt"; 

	#########################  PreProcessor           Execution    ##########

EOF

	foreach my $eachPre  (split /_\|_/, $preProcessors  ) { 
		$eachPre =~ s/\\\"/"/g;
		$eachPre =~ s/_doublequote_/\\\"/g;
		$eachPre =~ s/\"/\\\"/g;
		if ($eachPre =~ /&/) {; 
			$eachPre =~ s/&//g;
		print Fout_index "\tmy \$rstPre = &runBackground(\"start \\\"\\\" $eachPre\"); \n"; 

		#		&runBackground("start \"\" \"C:/strawberry/perl/bin/perl.exe\" \"c:/perlTS1/Program Files/wait.pl\" "); 
		} else {
		print Fout_index "\tmy \$rstPre = `$eachPre`  ;	\n"; 
		}
	
	}



	my $txt_FName = sprintf "$c/$_TAF/\$name/testcase%04d/$tc_args", $ctr;
	my $vali_FName = sprintf "$c/$_TAF/\$name/testcase%04d/$tc_vali", $ctr;
print Fout_index<<EOF;
#	\$txt_FName = \"$txt_FName\";
#	\$vali_FName = \"$vali_FName\";
# read for each TC	if (&readArgumentsFromFile(\$txt_FName)) { \$arguments = &readArgumentsFromFile(\$txt_FName);}
# read for each TC	if (&readArgumentsFromFile(\$vali_FName)) { \$validator= &readArgumentsFromFile(\$vali_FName);}
EOF

	print Fout_index "\n\t#########################  Executor               Execution    ##########\n\n";
	my $argumentFname = sprintf "$c/$_TAF/$name/testcase%04d/$tc_args", $ctr;
	foreach my $eachExec  (split /_\|_/, $executors     ) { 
		# fix autoIt bug:		$eachExec =~ s/\\\"/"/g;
								print Fout_index "\tmy \$rst = `$eachExec \$arguments 2>&1`    ;\n"; 
								$eachExec =~ s/^\s*"//g;
								$eachExec =~ s/\s*"\s*$//g;
								print Fout_index " 	print Fout \"Executor : $eachExec \$arguments = \$rst\\n\" if (\$pr_exec =~ /y/i) ;";	

																		}

	print Fout_index "\n\n\t#########################  Validator           Verification    ##########\n";
#	print Fout_index "\$validator =~ s\/_bs_\/\\\\\/g;\n";
	                                                        print Fout_index "	if (\$validator =~ /null|^\\\.\$/i) { \$return = \"null\"; } elsif ((\$rst =~ /error/i) || (\$rst =~ /fail/i)){ \$return = \"fail\"; } else { \$return = \"null\";}\n";
								print Fout_index "      if (\$validator =~ \/_no_validator_\/i) { \$return = \"null\";} else { ";
	                                                        print Fout_index "	if (\$validator =~ /null|^\\\.\$/i) { \$return = \"null\"; } elsif (\$rst =~ /\$validator/i ) { \$return = \"pass\";} else {\$return = \"fail\"; }\n";
								print Fout_index "      }\n";
								print Fout_index "	\$rst =~ s\/\\n|\\r//g; \n";
								#print Fout_index "	print Fout \"Validator: \$validator (expected value) =~ \$rst (actual value)\\n\";"; 	
								print Fout_index "	print Fout \"Validator: \$rst (actual value) =~ \$validator (expected value)\\n\" if (\$validator !~ /_no_validator_/i);"; 	
		
	print Fout_index "\n\n\t#########################  Post Processor         Execution    ##########\n\n";
	foreach my $eachPost  (split /_\|_/, $postProcessors) { print Fout_index "\tmy \$rstPost = `$eachPost`; \n"; }
	print Fout_index "\n\n\t#########################  Edit Files                          ##########\n\n";
	foreach my $eachEdit  (split /_\|_/, $editFiles     ) { 
 		$eachEdit =~ s/^\s*$c\///; 
		my $root = &getRoot($eachEdit);
		my $dir  = &getDir ($eachEdit);

		$dir =~ s/^\s*\S:[\\|\/]//g;		# bug fix line 3900
		&gen_ts_tc_cgi($c, $ip, $dir, $root);
print Fout_index<<EOF1;
	print Fout "Edit Test: <a href =\\\"http://$ip$http_port_IIS/${eachEdit}.cgi\\\">$c/$eachEdit</a> _url_line_\\n"; 
EOF1
	}
	print Fout_index "\n\n\t#########################  Logger                Collection    ##########\n\n";

print Fout_index<<EOF1_genTmpLog;
	&generateTmpLog ("$c/$name/_log1.txt","_log1.txt");
	&generateTmpLog ("$c/$name/_log2.txt","_log2.txt");
EOF1_genTmpLog

	foreach my $eachLog (split /_\|_/, $logs ) { 
		if ($eachLog =~ /_tcLogAppend.txt/i) {;} 
		else {


			# print Fout "Log  File: $eachLog \\n\\n"; 
print Fout_index<<EOF1;
	print Fout "Log  Test: $eachLog ".&passFail ("$eachLog")."\\n"; 
EOF1
		}
	}

	foreach my $eachLog (split /_\|_/, $logs ) { 
		if ($eachLog =~ /_tcLogAppend.txt/i) {;} 
		else {
print Fout_index<<EOF1;
	# if ( &passFail ("$eachLog") =~ /fail/i) { \$return = "fail"; return \$return; }
	\$return = &updateReturn(\$return, &passFail("$eachLog")); 
EOF1
		}
	}




print Fout_index<<'EOF';
	return $return;
}
EOF

}

sub readArgumentsFromFile {
	my $arguments = shift if @_;
	my $return = "";
	if (-e $arguments ) {
		open File_arg, $arguments; while ($_ = <File_arg>) { chop; $return .= $_; } close File_arg;
		return $return;
	}

}

sub generate_input_customTS_restoreDB {
	if (-e $SvrProjName) { ; } else { mkpath $SvrProjName; }
open Fout_generateIndex_txt, ">$SvrProjName/_plinkk_.bat.rst.txt";
print " ->$SvrProjName/_plinkk_.bat.rst.txt\n";
my $str =<<'EOF_c';
/pg_backups/prod_backups/pdxprcoredb01/tor.sql

/pg_backups/prod_backups/pdxprcoredb01/import:
import_20140223.sql
import_20140224.sql
import_20140225.sql
import_20140226.sql
import_20140227.sql
import_20140228.sql
import_20140301.sql
import_20140302.sql
import_20140303.sql

/pg_backups/prod_backups/pdxprcoredb01/sync:
sync_20131023.sql.gz
sync_20140223.sql
sync_20140224.sql
sync_20140225.sql
sync_20140226.sql
sync_20140227.sql
sync_20140228.sql
sync_20140301.sql
sync_20140302.sql
sync_20140303.sql

/pg_backups/prod_backups/pdxprcoredb01/configs:
postgresql_92.conf.20130902
postgresql_92.conf.20130909
postgresql_92.conf.20130916
postgresql_92.conf.20130923
postgresql_92.conf.20130930
postgresql_92.conf.20131007
postgresql_92.conf.20131014
postgresql_92.conf.20131125
postgresql_92.conf.20131223

/pg_backups/prod_backups/pdxprcoredb01/config:
config_20140223.sql
config_20140224.sql
config_20140225.sql
config_20140226.sql
config_20140227.sql
config_20140228.sql
config_20140301.sql
config_20140302.sql
config_20140303.sql
ee.sql
e.sql

/pg_backups/prod_backups/pdxprcoredb01/history:
history_20140223.sql
history_20140224.sql
history_20140225.sql
history_20140226.sql
history_20140227.sql
history_20140228.sql
history_20140301.sql
history_20140302.sql
history_20140303.sql

/pg_backups/prod_backups/pdxprcoredb01/references:
references_20140223.sql
references_20140224.sql
references_20140225.sql
references_20140226.sql
references_20140227.sql
references_20140228.sql
references_20140301.sql
references_20140302.sql
references_20140303.sql

/pg_backups/prod_backups/pdxprcoredb01/representation:
representation_20131023.sql.gz
representation_20140223.sql
representation_20140224.sql
representation_20140225.sql
representation_20140226.sql
representation_20140227.sql
representation_20140228.sql
representation_20140301.sql
representation_20140302.sql
representation_20140303.sql

/pg_backups/prod_backups/pdxprcoredb01/tmpconfig:
tmpconfig_20140223.sql
tmpconfig_20140224.sql
tmpconfig_20140225.sql
tmpconfig_20140226.sql
tmpconfig_20140227.sql
tmpconfig_20140228.sql
tmpconfig_20140301.sql
tmpconfig_20140302.sql
tmpconfig_20140303.sql

EOF_c
print Fout_generateIndex_txt $str;
close Fout_generateIndex_txt;

}

sub generate_index_customTS_restoreDB {
	if (-e $SvrProjName) { ; } else { mkpath $SvrProjName; }
open Fout_generateIndex_txt, ">$SvrProjName/index.pl";
print " ->$SvrProjName/index.pl\n";
my $str =<<'EOF_c';
#!C:/strawberry/perl/bin/perl.exe
use File::Path;
if ($^O =~ /win32/i) { $c= "c:"; } if ($^O =~ /linux/i) { $c = "/tmp/var/www/cgi-bin"; } 
$tsName = "__tsName__";
$tsName_no_c = "__no_c_tsName__";


if ($ARGV[0]) { 
	open Fout, ">$tsName/_tcLogAppend.txt";
	if ($ARGV[0] == 1) { print &tc1(); } 
	if ($ARGV[0] == 2) { print &tc2(); } 
	if ($ARGV[0] == 3) { print &tc3(); } 
	if ($ARGV[0] == 4) { print &tc4(); } 
	if ($ARGV[0] == 5) { print &tc5(); } 
	if ($ARGV[0] == 6) { print &tc6(); } 
	close Fout;
} else {
print <<EOF;
1. Scan DB restoration info on pdxdvpg11.tafllc.com
2. Display DB restoration Shell scripts and Jenkins scripts
3. webUI Prototype (Apache on linuxVM and IIS on window7) 
4. tbd
5. tbd
6. tbd
EOF
;
}


sub tc1 { 
open Fout_bat, ">$tsName/_plinkk_.bat";
print Fout_bat<<EOF;
/usr/bin/sudo /bin/chmod -R ugo+rwx /tmp  
/usr/bin/sudo /bin/ls -1  --ignore *bucardo* /pg_backups/prod_backups/pdxprcoredb01/*
/usr/bin/sudo /bin/chmod -R ugo+rwx /tmp  
EOF
close Fout_bat;	

#my $cmd= "c:/TAFLLC/AutomationFramework/plinkk.pl -batch $tsName/_plinkk_.bat";  my $rst = `$cmd`; 
#$rst =~ s/\n|\r/      \n/g;
#print Fout "---info--- The cmd update DB backups info at pdxdvpg11.tafllc.com \n";
#print Fout "---cmd--- $cmd\n---rst--- $rst\n";

return "null"; } 

sub tc2 { &generateIndexCGI(); 

print Fout<<EOF;

<a href=\"http://localhost:18080/__no_c_tsName__/index.cgi\" >Database Restore WebUI of localhost  _url_line_ </a>


EOF

	return "null"; } 
sub tc3 { 
print Fout<<EOF;
<a href=\"http://__ip__:18080;/database_restore_.cgi\" >Database Backup WebUI (server is on linuxVM) _url_line_ </a>
<a href=\"http://__ip__:18080/__no_c_tsName__/index.cgi\" >Database Backup WebUI (server is on Yong's laptop)_url_line_ </a>
EOF
	
	return "null"; } 
sub tc4 { return "null"; } 
sub tc5 { return "null"; } 
sub tc6 { return "null"; } 

sub generateIndexCGI {
	if (-e "$c/_TAF/$tsName_no_c") {;} else { mkpath "$c/_TAF/$tsName_no_c"; } 
open Fout_cgi, "> $c/_TAF/$tsName_no_c/index.cgi";
print Fout_cgi<<'EOF_cgi';
use Date::Manip;
use CGI qw/:standard/;

print header, start_html('TAFLLC DB Restoration'), h1('TAFLLC DB Restoration');
my %dbNames; my %dbNames_backup_dates; my $dbNames_backup_dates;

my @hosts 	= ["pdxdvpg11.TAFLLCnp.com", "pdxdvdm01.TAFLLCnp.com", "pdxqacoredb01.TAFLLCnp.com"];
my $QAs 	= ["qa1","qa2", "qa3","qa4","qa5","qa6","qa7", "qa8","qa9", "qa10"];


my %QAs_fullName = (
"qa1" => "qa1.TAFLLC", 
"qa2" => "qa2.TAFLLC", 
"qa3" => "qa3.TAFLLC", 
"qa4" => "qa4.TAFLLC", 
"qa5" => "qa5.TAFLLC", 
"qa6" => "qa6.TAFLLC", 
"qa7" => "qa7.TAFLLC", 
"qa8" => "qa8.TAFLLC", 
"qa9" => "qa9.TAFLLC", 
"qa10" => "qa10.TAFLLC");

#open Fin_pulldown, "c:/_TAF/TAFLLC/DatabaseRestoration/_plinkk_.bat.rst.txt"; @_ = <Fin_pulldown>; close Fin_pulldown; 
# open Fin_pulldown, "c:/TAFLLC/DatabaseRestoration/_plinkk_.bat.rst.txt"; @_ = <Fin_pulldown>; close Fin_pulldown; 
open Fin_pulldown, "__tsName__/_plinkk_.bat.rst.txt"; @_ = <Fin_pulldown>; close Fin_pulldown; 

foreach my $each (@_) { if ($each =~ /^\s*(\w+)_(\d+).sql\s*$/)  { $dbNames{$1} = "";}}
foreach my $each (@_) { if ($each =~ /^\s*(\w+)_(\d+).sql\s*$/)  { $dbNames{$1} .= "${1}_${2}\n";   push (@$dbNames_backup_dates,"${1}_${2}"); } }

my $dbNames; foreach my $each (keys %dbNames) { push (@$dbNames, $each); }
my $dbNames_restore; foreach my $each (keys %dbNames) { foreach my $each1 (@$QAs) { push (@$dbNames_restore, "${each}_$each1");} }

# my $admin_users    ; foreach my $each (keys %dbNames) { foreach my $each1 (@$QAs) { push (@$admin_users, "${each}_$each1");} }


#my $admin_users    ; foreach my $each (keys %dbNames) { push (@$admin_users, "${each}");} 
my $admin_users    ; foreach my $each (keys %QAs_fullName) { push (@$admin_users, "$QAs_fullName{$each}");} 





#my $admin_users    ; foreach my $each (keys %dbNames) { foreach my $each1 (@$QAs) { push (@$admin_users, "${each}_$each1");} }





my %options = (
  main      => ["option1", "option2", "option3"],
  option1 => ["option1a", "option1b", "option1c"],
  option2 => ["option2a", "option2b", "option2c"],
  option3 => ["option3a", "option3b", "option3c"]
);

# my @hosts 	= ["pdxdvpg11.TAFLLCnp.com", "pdxdvdm01.TAFLLCnp.com", "pdxqacoredb01.TAFLLCnp.com","hello"];
my @DBs   	= ["batch", "configuration", "evid_history","references","repconfig"];
my @dates 	= ["2014_02_20", "2014_02_21", "2014_02_22"];
my @DBs_restore = ["configDB_firebug1", "referenceDB_firebug2", "reportDB_firebug3"];

my %options_host 		= ( main      => @hosts);
my %options_restore_from_db   	= ( main      => $dbNames);
my %options_restore_from_db_date= ( main      => $dbNames_backup_dates);
my %options_restore_to_db     	= ( main      => $dbNames_restore);
my %options_admin_users       	= ( main      => $admin_users);



if ( !param() ) { 
$values_ref = $options{'main'};
$values_ref_host = $options_host{'main'};
$values_ref_restore_from_db = $options_restore_from_db{'main'};
$values_ref_restore_from_db_date = $options_restore_from_db_date{'main'};
$values_ref_restore_to_db = $options_restore_to_db{'main'};
$values_ref_admin_users   = $options_admin_users{'main'};

my $date = &genDate();

print start_form();
print " Restore Database on Host: ";
print popup_menu( -name    => 'distros_menu_host'			, -values  => $values_ref_host, -default => 'pdxdvpg11.TAFLLCnp.com');
print " Database Name: ";
print popup_menu( -name    => 'distros_menu_restore_from_db'		, -values  => $values_ref_restore_from_db, -default => 'configuration');
print " Backup Date: ";
print popup_menu( -name    => 'distros_menu_restore_from_db_date'	, -values  => $values_ref_restore_from_db_date, -default => "configuration_$date");
print " to: (";
print popup_menu( -name    => 'distros_menu_restore_to_db'		, -values  => $values_ref_restore_to_db, -default => 'configuration_qa10');
print " OR ";
print textfield( -name => 'values_ref_restore_to_db_text_field', -value => "configuration_qa10", -size => 20, -maxlength => 128); 
print ")";
print "<br><br>";
print " Restore Admin User (post): ";
print popup_menu( -name    => 'distros_menu_admin_users'		, -values  => $values_ref_admin_users  , -default => 'stephenie.blackmon');
print " AND ";
print textfield( -name => 'values_ref_admin_users_text_field', -value => "qa10", -size => 20, -maxlength => 128); 
print "";


print "<br><br><br>";
print submit('Click me to Restore DB ');
print endform;


} else { 
$values_ref = param('distros_menu');
$values_ref_host 		= param('distros_menu_host');
$values_ref_restore_from_db 	= param('distros_menu_restore_from_db');
$values_ref_restore_from_db_date= param('distros_menu_restore_from_db_date');
$values_ref_restore_to_db   	= param('distros_menu_restore_to_db');
$values_ref_restore_to_db_text_field =  param('values_ref_restore_to_db_text_field');

$values_ref_admin_users     		= param('distros_menu_admin_users');
$values_ref_admin_users_text_field 	= param('values_ref_admin_users_text_field');



my $dbname = "configurationTmp"; my $qaname = "yong"; my $qaFullName = "Yongyan.Wang";

if ($values_ref_restore_to_db  =~ /(\w+)_(\w+)\b/) {$dbname = $1 ;$qaname = $2; }


if ($values_ref_restore_to_db  !~  /$values_ref_restore_to_db_text_field/i) {$values_ref_restore_to_db  =  $values_ref_restore_to_db_text_field ;}


#### DB Restore rule checking ####

if (($values_ref_restore_from_db !~ /$dbname/i) || ($values_ref_restore_from_db_date !~ /$dbname/i) ) {

print<<EOF;
Warning! ( $values_ref_restore_from_db  || $values_ref_restore_from_db_date || $values_ref_restore_to_db  )    !~    $dbname               Exited.  Please Navigate to Back <br>  
EOF
exit;
} 

$values_ref_restore_from_db_date =~ s/^\s*(\w+)_(\d+)\s*$/$2/g;


print <<EOF;
Restore DB: $dbname <br>
Cut-and-Paste Shell to $values_ref_host  :>>>  /usr/bin/sudo /bin/su postgres /home/postgres/db_scripts/db_restore.sh    ${values_ref_restore_to_db}_     $values_ref_restore_from_db_date  <<<    <br>
<br>

EOF

print "Update Admin Users<br>\n";
print "Cut-and-Paste Shell to $values_ref_host  :>>>  /usr/bin/sudo /bin/su postgres /home/postgres/db_scripts/user_config.sh   ${values_ref_restore_to_db}_     $values_ref_admin_users  <<< <br>\n";
foreach my $each (split /\s*,\s*/, $values_ref_admin_users_text_field) {
print "Cut-and-Paste Shell to $values_ref_host  :>>>  /usr/bin/sudo /bin/su postgres /home/postgres/db_scripts/user_config.sh   ${values_ref_restore_to_db}_     $each  <<< <br>\n";
}
print "Cut-and-Paste Shell to $values_ref_host  :>>>  /usr/bin/sudo /bin/su postgres /home/postgres/db_scripts/user_config.sh   ${values_ref_restore_to_db}_     $QAs_fullName{$qaname}  <<< <br>\n";


print <<EOF;
<br>
Jenkins Integration  : C:/strawberry/perl/bin/perl C:/TAFLLC/RuleConfigAutomation/index.pl 4 -BRE_login  ieSnare/yongyan.wang:temp1234  -dbHost $values_ref_host -dbName  ${values_ref_restore_to_db} -dbUser postgres -dbPassword devonly  



EOF

}



print end_html;

sub genDate {	#### calc Date = currentTime - 3 days 
 	my $currentTime  = &UnixDate( "now", "%m/%d/%Y %H:%M:%S %Z" );
	my $deltastr = "3 days ago";
	my $date = DateCalc($currentTime,$deltastr);
	my $date3DaysAgo = &UnixDate( $date , "%Y%m%d" );
	return $date3DaysAgo;
}


EOF_cgi
;
close Fout_cgi;

	}

EOF_c
$str = &template2TS($str);
print Fout_generateIndex_txt $str;
close Fout_generateIndex_txt;
1;
}

##############
sub generate_index_jmeter_cgi {
	my $SvrProjName_C_no = &getTCName_C_no ($SvrProjName);	
	if (-e $SvrProjName) { ; } else { mkpath $SvrProjName; }
	if (-e "$c/$_TAF/$SvrProjName_C_no") { ; } else { mkpath "$c/$_TAF/$SvrProjName_C_no"; }

open Fout_generateIndex_txt, ">$c/$_TAF/$SvrProjName_C_no/index.cgi";
print " ->$c/$_TAF/$SvrProjName_C_no/index.cgi\n";
my $str=<<'EOF_AB_CGI';
use CGI qw/:standard/;
use File::Path;
my $c = "c:"; $_TAF = "_TAF"; my $tsName = "JmeterTS"; my $tcName = "testcase0001"; 
my $http_port_IIS = "__http_port_IIS__";
    print
    header,
    start_html('Web Performance Test using Jmeter'),
    h1('Web Performance Test using Jmeter');

print 
start_form, 
"<pre>",

"URL = ", textfield(-name=>'URL', -default=>"localhost"), " ",
"NofThreads= ",popup_menu(-name=>'NofThreads', -values=>['1','10','20','40','80','100','1000','5000'])," ",
"Rampup= ", popup_menu(-name=>'rampup_Time', -values=>['1','10','20','60','100','500','1000','5000'])," ",
"Iterations = ", popup_menu(-name=>'NofIterations', -values=>['1','2','4','10','20','40','60','80','100','500','1000','5000'])," ",
" ", 
submit(-name=>'submit'), "      ",
"or      ",submit(-name=>'updateTC'),
"[testcase",popup_menu(-name=>'testcase', -values=>['0001','0002','0003','0004','0005']), "]",

end_form, hr,"\n";

$tc_args = "__perl__ C:/_TAF/jmeter.pl -targetURL ".param(URL). " -NofThreads ".param('NofThreads')." -rampUp ".param('rampup_Time')." -NofIterations ".param('NofIterations'); 
if (param('submit')) {
print 
"<pre>",
"----cmd---- $tc_args ",p,
;

# `$tc_args`;
print $tc_args, `$tc_args`,
"<a href=\"http://__ip__$http_port_IIS/JmeterTS/index_http.htm\">Jmeter Automations</a>", " and the ", "<a href=\"http://__ip__$http_port_IIS/JmeterTS/testcase0001/_tcLog.html\">Test Result</a>",
"<hr>",
"</pre>",
hr,
end_html;

}
if (param('updateTC')) {
$tc_args = "C:/_TAF/jmeter.pl -targetURL ".param(URL). " -NofThreads ".param('NofThreads')." -rampUp ".param('rampup_Time')." -NofIterations ".param('NofIterations'); 
$tcName = "testcase".param('testcase');
if ( -e "$c/$_TAF/$tsName/$tcName") {; } else { mkpath "$c/$_TAF/$tsName/$tcName"; }

open Fout,  "> $c/$_TAF/$tsName/$tcName/_cmd.txt"; print Fout $tc_args; close Fout;
open Fout,  "> $c/$tsName/$tcName/_cmd.txt"; print Fout $tc_args; close Fout;
print "$c/$_TAF/$tsName/$tcName/_cmd.txt is Updated";
print hr, end_html;
}

EOF_AB_CGI
$str =~ s/__tsName__/$SvrProjName/gi;
$str = &template2TS($str);
print Fout_generateIndex_txt $str;
close Fout_generateIndex_txt;
1;
}



##############



sub generate_index_ab_cgi {
	my $SvrProjName_C_no = &getTCName_C_no ($SvrProjName);	
	if (-e $SvrProjName) { ; } else { mkpath $SvrProjName; }
	if (-e "$c/$_TAF/$SvrProjName_C_no") { ; } else { mkpath "$c/$_TAF/$SvrProjName_C_no"; }

open Fout_generateIndex_txt, ">$c/$_TAF/$SvrProjName_C_no/index.cgi";
print " ->$c/$_TAF/$SvrProjName_C_no/index.cgi\n";
my $str=<<'EOF_AB_CGI';
use CGI qw/:standard/;
use File::Path;
my $c = "__c__"; $_TAF = "___TAF__"; my $tsName = "__no_c_tsName__"; my $tcName = "testcase0001"; 
my $http_port_IIS = "__http_port_IIS__";
    print
    header,
    start_html('Web Performance Test'),
    h1('Web Performance Test');

print 
start_form, 
"<pre>",

"URL = ", textfield(-name=>'name', -default=>"localhost$http_port_IIS/"), " ",
"Number of Users = ", popup_menu(-name=>'NofUsers', -values=>['1','10','100','1000','5000'])," ",
"Number of Concurrent Users= ",popup_menu(-name=>'NofConcurrentUsers', -values=>['1','10','100','1000','5000']),
" ", 
submit(-name=>'submit'), "      ",
"or      ",submit(-name=>'updateTC'),
"[testcase",popup_menu(-name=>'testcase', -values=>['0001','0002','0003','0004','0005']), "]",

end_form, hr,"\n";

$tc_args = "C:/Apache24/bin/ab  -n ".param('NofUsers')." -c ".param('NofConcurrentUsers')." ".param('name'); 
if (param('submit')) {
print 
"<pre>",
"----cmd---- $tc_args ",p,
;

print `$tc_args`,
"</pre>",
hr,
end_html;

}
if (param('updateTC')) {
$tc_args = "C:/Apache24/bin/ab  -n ".param('NofUsers')." -c ".param('NofConcurrentUsers')." ".param('name'); 
$tcName = "testcase".param('testcase');
if ( -e "$c/$_TAF/$tsName/$tcName") {; } else { mkpath "$c/$_TAF/$tsName/$tcName"; }

open Fout,  "> $c/$_TAF/$tsName/$tcName/_cmd.txt"; print Fout $tc_args; close Fout;
open Fout,  "> $c/$tsName/$tcName/_cmd.txt"; print Fout $tc_args; close Fout;
print "$c/$_TAF/$tsName/$tcName/_cmd.txt is Updated";
print hr, end_html;
}


EOF_AB_CGI
$str =~ s/__tsName__/$SvrProjName/gi;
$str = &template2TS($str);
print Fout_generateIndex_txt $str;
close Fout_generateIndex_txt;
1;
}



##############
sub generate_index_ab_pl {
	if (-e $SvrProjName) { ; } else { mkpath $SvrProjName; }
open Fout_generateIndex_txt, ">$SvrProjName/index.pl";
print " ->$SvrProjName/index.pl\n";
my $str=<<'EOF_AB';
#!C:/strawberry/perl/bin/perl.exe
use Getopt::Long;
my $descPattern = "_nothing_";

$c 	= "__c__"; 		if ($^O =~ /win32/i) { $c = "c:"; } if ($^O =~ /linux/i) { $_TAF = "/tmp/var/www/cgi-bin"; } 
$_TAF 	= "___TAF__";
$_cmd 	= "_cmd.txt"; 
$tsName = "__no_c_tsName__";
$apacheBench = "__apacheBench__";


my $result = GetOptions ( "descPattern=s"  		=> \$descPattern);



my $desc=<<EOF;
1. Simple web performance measurements (Inputs: URL, N of Users, N of concurrency)
2. Simple web performance measurements (Inputs: URL, N of Users, N of concurrency)
3. Simple web performance measurements (Inputs: URL, N of Users, N of concurrency)
4. Simple web performance measurements (Inputs: URL, N of Users, N of concurrency)
5. Simple web performance measurements (Inputs: URL, N of Users, N of concurrency)
6. Simple web performance measurements (Inputs: URL, N of Users, N of concurrency)
EOF
;

my $index = 1; foreach $each (split /\n/, $desc) { if ($each =~ /$descPattern/i) { push (@ARGV, " $index");  $index++; } }

$tcIndexMap[1] = 1;
$tcIndexMap[2] = 2;
$tcIndexMap[3] = 3;
$tcIndexMap[4] = 4;
$tcIndexMap[5] = 5;
$tcIndexMap[6] = 6;


if ($ARGV[0]) { 
	foreach my $eachTC (@ARGV) {
	if ($eachTC =~ /^\s*(-?\d+)\s*$/) { $eachTC = $1;
	open Fout, ">$c/$tsName/_tcLogAppend.txt";
		if (($eachTC == $tcIndexMap[1]) || ($eachTC == -1) ) { print &tc1(); } 
		if (($eachTC == $tcIndexMap[2]) || ($eachTC == -1) ) { print &tc2(); } 
		if (($eachTC == $tcIndexMap[3]) || ($eachTC == -1) ) { print &tc3(); } 
		if (($eachTC == $tcIndexMap[4]) || ($eachTC == -1) ) { print &tc4(); } 
		if (($eachTC == $tcIndexMap[5]) || ($eachTC == -1) ) { print &tc5(); } 
		if (($eachTC == $tcIndexMap[6]) || ($eachTC == -1) ) { print &tc6(); } 
	close Fout;
	}
	}
} else { print $desc; }


sub tc1 { $tcName = "testcase0001"; &runFromCmdFile($tcName); }
sub tc2 { $tcName = "testcase0002"; &runFromCmdFile($tcName); }
sub tc3 { $tcName = "testcase0003"; &runFromCmdFile($tcName); }
sub tc4 { $tcName = "testcase0004"; &runFromCmdFile($tcName); }
sub tc5 { $tcName = "testcase0005"; &runFromCmdFile($tcName); }
sub tc6 { $tcName = "testcase0006"; &runFromCmdFile($tcName); }


sub runFromCmdFile { 
	my $tcName = "testcase0001"; $tcName = shift if @_; 
	if ( -e "$c/$_TAF/$tsName/$tcName/$_cmd") { open FinCmd, "$c/$_TAF/$tsName/$tcName/$_cmd";  $cmd = <FinCmd>; close FinCmd; }
	else { $cmd = $apacheBench.'  -n 100 -c 1 localhost:18080/'; }
	$rst = `$cmd`; 
	print Fout "\nLog File: $c/$tsName/_log.txt     \n\n";
	open FoutRst , ">$c/$tsName/_log.txt"; print FoutRst " ----cmd----\n$cmd\n----cmd----\n$rst"; close FoutRst; 

}



EOF_AB
$str =~ s/__tsName__/$SvrProjName/gi;
$str = &template2TS($str);
print Fout_generateIndex_txt $str;
close Fout_generateIndex_txt;

open Fout_generateIndex_txt, ">$SvrProjName/ab.pl";
print " ->$SvrProjName/ab.pl\n";
print Fout_generateIndex_txt $str;
close Fout_generateIndex_txt;

1;
}






sub generate_index_C_plusplus {
	if (-e $SvrProjName) { ; } else { mkpath $SvrProjName; }
open Fout_generateIndex_txt, ">$SvrProjName/index.cpp";
print " ->$SvrProjName/index.cpp\n";
my $str =<<'EOF_c';
#include <iostream>
#include <fstream>
#include <sstream>
using namespace std;


int main(int argc, char* argv[])
{
    int i;
    double multiplier1[] = { 7, 7.5, 7, 7.5 };
    double multiplier2[] = { 8, 8, 0, 8.5 };
    double expectedResult[] = { 56, 56, 0, 58.5 };

    if (argc==1)
    {
        for(i=0; i<4; i++)
        {            
            cout << (i+1) << ". C++ Calculator Test case : integer * integer ";
            cout << " ( " << multiplier1[i];
            cout << " * " << multiplier2[i];
            cout << " = " << multiplier1[i];
            cout << " )";                                
            cout << endl;
        }
    } else {        
        stringstream  ss(argv[1]);
        ss >> i;
        if (i>=1 && i<=4)
        {
            i--;
            ofstream outfile("__tsName__/_tcLogAppend.txt");
            if (outfile)
            {
                outfile << "Input: " << multiplier1[i] << " * " << multiplier2[i] << endl;
                outfile << "Output: " << ((int)multiplier1[i]*(int)multiplier2[i]) << endl;
                outfile << "Expected output: " << expectedResult[i] << endl;
                if ((double)((int)multiplier1[i]*(int)multiplier2[i])!=expectedResult[i])
                {
                    outfile << "fail" << endl;
                    cout << "fail" << endl;
                } else {
                    outfile << "pass" << endl;
                    cout << "pass" << endl;
                }

                outfile.close();
            } else {
                cout << "Cannot open file to log" << endl;
            }
        }
    }

    return 0;
}

EOF_c
$str =~ s/__tsName__/$SvrProjName/gi;
print Fout_generateIndex_txt $str;
close Fout_generateIndex_txt;
1;
}
sub generate_index_C {
	if (-e $SvrProjName) { ; } else { mkpath $SvrProjName; }
open Fout_generateIndex_txt, ">$SvrProjName/index.c";
print " ->$SvrProjName/index.c\n";
my $str=<<'EOF_c';
#include <stdio.h>
#include <stdlib.h>


int main(int argc, char* argv[])
{
    int i;
    double multiplier1[] = { 7, 7.5, 7, 7.5 };
    double multiplier2[] = { 8, 8, 0, 8.5 };
    double expectedResult[] = { 56, 56, 0, 58.5 };

    if (argc==1)
    {
        for(i=0; i<4; i++)
        {            
            printf("%d. C Calculator Test case : integer * integer ", i+1);
            printf(" ( %.1f * %.1f = %.1f )", multiplier1[i], multiplier2[i], expectedResult[i]);
            printf("\n");
        }
    } else {
        FILE* f;
        int i = atoi(argv[1]);
        if (i>=1 && i<=4)
        {
            i--;
            f = fopen("__tsName__/_tcLogAppend.txt", "w+");
            if (f)
            {
                fprintf(f, "Input: %.1f * %.1f\n", multiplier1[i], multiplier2[i]);
                fprintf(f, "Output: %d\n", (int)multiplier1[i]*(int)multiplier2[i]);
                fprintf(f, "Expected output: %.1f\n", expectedResult[i]);
                if ((double)((int)multiplier1[i]*(int)multiplier2[i])!=expectedResult[i])
                {
                    fprintf(f, "fail\n");
                    printf("fail\n");
                } else {
                    fprintf(f, "pass\n");
                    printf("pass\n");
                }

                fclose(f);
            } else {
                printf("Cannot open file to log\n\n");
            }
        }
    }

    return 0;
}

EOF_c
$str =~ s/__tsName__/$SvrProjName/gi;
print Fout_generateIndex_txt $str;
close Fout_generateIndex_txt;
1;
}


sub generateTSDescC{
	if (-e "$SvrProjName") {;} else { mkpath "$SvrProjName";}
open Fout_generateIndex_txt, ">$SvrProjName/$TSDescName";
print " ->$SvrProjName/$TSDescName\n";
my $str =<<'EOF_c';
####################################################
# This is generated by TaaS code generator
####################################################

Automation: 1 
	Name		: __tsName__
	Description	: 1. C Calculator Test case : integer * integer ( 7 * 8) 
#	Dependency 	: "__gcc__"
	PreRequsite 	: __tsName__/index.c
	PreProcessor    : c:/_TAF/taf.pl testsuite=__tsName__;rmTSTempFiles
	PreProcessor	: "__gcc__" __tsName__/index.c -o  __tsName__/index
	Driver      	: "__tsName__/index"
	Arguments       : 1
	Validator       : pass
	PostProcessor   : dir
	Log		: __tsName__/_log1.txt
	File     	: __tsName__/manual_tc_testcase0001.txt

Automation: 2 
	Name		: __tsName__
	Description	: 2. C Calculator Test case : integer * integer ( 7 * 8) 
#	Dependency 	: "__gcc__"
	PreRequsite 	: __tsName__/index.c
	PreProcessor    : c:/_TAF/taf.pl testsuite=__tsName__;rmTSTempFiles
	PreProcessor	: "__gcc__" __tsName__/index.c -o  __tsName__/index
	Driver      	: "__tsName__/index"
	Arguments       : 2
	Validator       : pass
	PostProcessor   : dir
	Log		: __tsName__/_log1.txt
	File		: __tsName__/manual_tc_testcase0002.txt

Automation: 3 
	Name		: __tsName__
	Description	: 3. C Calculator Test case : integer * integer ( 7 * 8) 
#	Dependency 	: "__gcc__"
	PreRequsite 	: __tsName__/index.c
	PreProcessor    : c:/_TAF/taf.pl testsuite=__tsName__;rmTSTempFiles
	PreProcessor	: "__gcc__" __tsName__/index.c -o  __tsName__/index
	Driver      	: "__tsName__/index"
	Arguments       : 3
	Validator       : pass
	PostProcessor   : dir
	Log 		: __tsName__/_log1.txt
	File		: __tsName__/manual_tc_testcase0003.txt

Automation: 4 
	Name		: __tsName__
	Description	: 4. C Calculator Test case : integer * integer ( 7 * 8) 
#	Dependency 	: "__gcc__"
	PreRequsite 	: __tsName__/index.c
	PreProcessor    : c:/_TAF/taf.pl testsuite=__tsName__;rmTSTempFiles
	PreProcessor	: "__gcc__" __tsName__/index.c -o  __tsName__/index
	Driver      	: "__tsName__/index"
	Arguments       : 4
	Validator       : pass
	PostProcessor   : dir
	Log		: __tsName__/_log1.txt
	File		: __tsName__/manual_tc_testcase0004.txt

EOF_c
$str =~ s/__tsName__/$SvrProjName/gi;
$str = &template2TS($str);
print Fout_generateIndex_txt $str;

close Fout_generateIndex_txt;
1;
}


sub generateTSDescC_plusplus{
	if ( -e "$SvrProjName") {;} else { mkpath "$SvrProjName"; }
open Fout_generateIndex_txt, ">$SvrProjName/$TSDescName";
print " ->$SvrProjName / $TSDescName\n";
my $str = <<'EOF_c';
####################################################
# This is generated by TaaS code generator
####################################################

Automation: 1 
	Name		: __tsName__
	Description	: 1. C++ Calculator Test case : integer * integer ( 7 * 8) 
	Dependency 	: "__g_plusplus__"
	PreRequsite 	: __tsName__/index.cpp
	PreProcessor    : c:/_TAF/taf.pl testsuite=__tsName__;rmTSTempFiles
	PreProcessor	: "__g_plusplus__" __tsName__/index.cpp -o  __tsName__/index
	Driver      	: "__tsName__/index"
	Arguments       : 1
	Validator       : pass
	PostProcessor   : dir
	Log 		: __tsName__/_log1.txt
	File     	: __tsName__/manual_tc_testcase0001.txt

Automation: 2 
	Name		: __tsName__
	Description	: 2. C++ Calculator Test case : integer * integer ( 7 * 8) 
	Dependency 	: "__g_plusplus"
	PreRequsite 	: __tsName__/index.cpp
	PreProcessor    : c:/_TAF/taf.pl testsuite=__tsName__;rmTSTempFiles
	PreProcessor	: "__g_plusplus" __tsName__/index.cpp -o  __tsName__/index
	Driver      	: "__tsName__/index"
	Arguments       : 2
	Validator       : pass
	PostProcessor   : dir
	Log 		: __tsName__/_log1.txt
	File     	: __tsName__/manual_tc_testcase0002.txt

Automation: 3 
	Name		: __tsName__
	Description	: 3. C++ Calculator Test case : integer * integer ( 7 * 8) 
	Dependency 	: "__g_plusplus__"
	PreRequsite 	: __tsName__/index.cpp
	PreProcessor    : c:/_TAF/taf.pl testsuite=__tsName__;rmTSTempFiles
	PreProcessor	: "__g_plusplus__" __tsName__/index.cpp -o  __tsName__/index
	Driver      	: "__tsName__/index"
	Arguments       : 3
	Validator       : pass
	PostProcessor   : dir
	Log 		: __tsName__/_log1.txt
	File     	: __tsName__/manual_tc_testcase0003.txt

Automation: 4 
	Name		: __tsName__
	Description	: 4. C++ Calculator Test case : integer * integer ( 7 * 8) 
	Dependency 	: "__g_plusplus__"
	PreRequsite 	: __tsName__/index.cpp
	PreProcessor    : c:/_TAF/taf.pl testsuite=__tsName__;rmTSTempFiles
	PreProcessor	: "__g_plusplus__" __tsName__/index.cpp -o  __tsName__/index
	Driver      	: "__tsName__/index"
	Arguments       : 4
	Validator       : pass
	PostProcessor   : dir
	Log 		: __tsName__/_log1.txt
	File     	: __tsName__/manual_tc_testcase0004.txt

EOF_c

$str =~ s/__tsName__/$SvrProjName/gi;
$str = &template2TS($str); 
print Fout_generateIndex_txt $str;
close Fout_generateIndex_txt;
1;
}

######## selenium desc ######
sub generateTSDescSelenium{
	if ( -e "$SvrProjName") {;} else { mkpath "$SvrProjName"; }
open Fout_generateIndex_txt, ">$SvrProjName/$TSDescName";
print " ->$SvrProjName/$TSDescName\n";
my $str = <<'EOF_c';
####################################################
# This is generated by TaaS code generator
####################################################

Automation: 1 
 	Name		: __tsName__
 	Description	: 1. Selenium Demo 
 	Driver		: "__ruby__"
 	Arguments	: " -v"
 	Validator       : pass
 	File     	: __tsName__/manual_tc_testcase0001.txt

Automation: 2 
 	Name		: __tsName__
 	Description	: 2. Selenium Demo : google title 
 	Driver		: "__ruby__"
 	Arguments	: "__tsName__/_tc2_hello.rb"
 	Validator       : google
 	Log 		: __tsName__/_log2.log
 	File      	: __tsName__/_tc2_hello.rb
 	File     	: __tsName__/manual_tc_testcase0002.txt

Automation: 3 
 	Name		: __tsName__
 	Description	: 3. Selenium Demo : TaaS title 
 	Driver		: "__ruby__"
 	Arguments	: "__tsName__/_tc3_hello.rb"
 	Validator       : testsuite1
 	Log 		: __tsName__/_log3.log
 	File      	: __tsName__/_tc3_hello.rb
 	File     	: __tsName__/manual_tc_testcase0003.txt

Automation: 4 
 	Name		: __tsName__
 	Description	: 4. Selenium Demo : google title
 	Driver		: "__ruby__"
 	Arguments	: "__tsName__/_tc4_hello.rb"
 	Log 		: __tsName__/_log4.log
 	File      	: __tsName__/_tc4_hello.rb
 	File     	: __tsName__/manual_tc_testcase0004.txt

EOF_c

$str =~ s/__tsName__/$SvrProjName/gi;
$str = &template2TS($str); 
print Fout_generateIndex_txt $str;
close Fout_generateIndex_txt;
1;
}

######## selenium desc ######
sub generate_index_java {
	if (-e $SvrProjName) { ; } else { mkpath $SvrProjName; }
open Fout_generateIndex_txt, ">$SvrProjName/index.java";
print " ->$SvrProjName/index.java\n";
my $str=<<'EOF_java';
import java.io.*; 
import java.text.*;

public class index {
	public static void main(String [] args) {

		double[] multiplier1 = { 7, 7.5, 7, 7.5 };
		double[] multiplier2 = { 8, 8, 0, 8.5 };
                double[] expectedResult = { 56, 56, 0, 58.5 };

		DecimalFormat df = new DecimalFormat("###.##");

		if (args.length==0) {

			for(int i=0; i<4; i++) {

				System.out.print(String.format("%d. Java Calculator Test case : integer * integer ", i+1));

				System.out.print("( ");
				System.out.print(df.format(multiplier1[i]));
				System.out.print(" * ");
				System.out.print(df.format(multiplier2[i]));
				System.out.print(" = ");
				System.out.print(df.format(expectedResult[i]));
				System.out.print(" )");

				System.out.println();
			}
		} else {
			try {				
				int number = Integer.parseInt(args[0]);
				if (number>4)
					number = 4;

				FileWriter fstream = new FileWriter("__tsName__/_tcLogAppend_java.txt", false);
				BufferedWriter fbw = new BufferedWriter(fstream);

				for(int i=number-1; i<number; i++) {
					int m1 = (int)multiplier1[i];
					int m2 = (int)multiplier2[i];

					fbw.write("Input: ");
					fbw.write(df.format(multiplier1[i]));
					fbw.write(" * ");
					fbw.write(df.format(multiplier2[i]));
		        		fbw.newLine();
					fbw.write("Output: ");
					fbw.write(df.format(m1*m2));
		        		fbw.newLine();
					fbw.write("Expected output: ");
					fbw.write(df.format(expectedResult[i]));
		        		fbw.newLine();
					fbw.write("Test result: ");

					if (m1*m2!=expectedResult[i]) {
						System.out.println("fail");
						fbw.write("fail");
                                        } else {
						System.out.println("pass");
						fbw.write("pass");
					}
		        		fbw.newLine();
					fbw.newLine();					
				}

				fbw.close();
			}

			catch(IOException ex) {
				System.out.println(ex);
			}
		}
	}
}


EOF_java

$str =~ s/__tsName__/$SvrProjName/g;
print Fout_generateIndex_txt $str;
close Fout_generateIndex_txt;
1;
}

sub generate_index_Csharp {
	if ( -e $SvrProjName) {;} else { mkpath $SvrProjName; }
open Fout_generateIndex_txt, ">$SvrProjName/index.cs";
my $str =<<'EOF_c_sharp';
using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace index_c_sharp
{
    class Program
    {
        //const string logFile = "__c__/___TAF__/_no_c_tsName__/_tcLogAppend.txt";
        const string logFile = "__tsName__/_tcLogAppend_cs.txt";
        static Random rnd;
        
        static void Main(string[] args)
        {
            rnd = new Random();

            string tcValue = string.Empty;

            //Console.Write("Please input the tc: ");

            if (args.Length > 0) tcValue = args[0];

            //tcValue = Console.ReadLine();

            switch (tcValue)
            {
                case "1":
                    tc1();
                    break;

                case "2":
                    tc2();
                    break;

                case "3":
                    tc3();
                    break;

                case "4":
                    tc4();
                    break;

                default:
                    Console.WriteLine("1. Test case: multiplication method (integer * integer)");
                    Console.WriteLine("2. Test case: division method (integer / integer)");
                    Console.WriteLine("3. Test case: subtraction method (integer - integer)");
                    Console.WriteLine("4. Test case: addition method (integer + integer)");
                    break;
            }
        }

        /// <summary>
        /// multiplication method
        /// </summary>
        private static void tc1()
        {
            string value;
            double firstParam = 0, secondParam = 0;
            bool isNumeric = false;
            int step = 1;
            string log = string.Empty;

            log = string.Format("Log for test case 1 - {0} -----start at {1} -----", DateTime.Now.Date.ToString("dd/MM/yyyy"), DateTime.Now.ToString("hh:MM:ss"));
            writeLog(log, false);

            while (true)
            {
                if (step == 1)
                {
                    value = rnd.Next(10, 25).ToString();
                    
                    isNumeric = double.TryParse(value, out firstParam);
                    if (!isNumeric)
                    {
                        Console.WriteLine("Invalid value");
                        log = "User input the first parameter is " + value + ". Invalid value";
                        writeLog(log, true);
                    }
                    else
                    {
                        step = 2;
                        log = "User input the first parameter is " + value;
                        writeLog(log, true);
                    }                    
                }
                else
                {
                    value = rnd.Next(1, 10).ToString();
                    
                    isNumeric = double.TryParse(value, out secondParam);
                    if (!isNumeric)
                    {
                        Console.WriteLine("Invalid value");
                        log = "User input the second parameter is " + value + ". Invalid value";
                        writeLog(log, true);
                    }
                    else
                    {
                        log = "User input the second parameter is " + value;
                        writeLog(log, true);
                        break;
                    }
                }
            }

            log = string.Format("the result of tc1 is: {0} * {1} = {2}", firstParam, secondParam, firstParam * secondParam);
            writeLog(log, true);
            Console.WriteLine("pass");
            log = string.Format("-----finish at {0} -----", DateTime.Now.ToString("hh:MM:ss"));
            writeLog(log, true);
        }

        /// <summary>
        /// division method
        /// </summary>
        private static void tc2()
        {
            string value;
            double firstParam = 0, secondParam = 0;
            bool isNumeric = false;
            int step = 1;
            string log = string.Empty;

            log = string.Format("Log for test case 2 - {0} -----start at {1} -----", DateTime.Now.Date.ToString("dd/MM/yyyy"), DateTime.Now.ToString("hh:MM:ss"));
            writeLog(log, false);

            while (true)
            {
                if (step == 1)
                {
                    value = rnd.Next(34, 100).ToString();
                    
                    isNumeric = double.TryParse(value, out firstParam);
                    if (!isNumeric)
                    {
                        Console.WriteLine("Invalid value");
                        log = "User input the first parameter is " + value + ". Invalid value";
                        writeLog(log, true);
                    }
                    else
                    {
                        step = 2;
                        log = "User input the first parameter is " + value;
                        writeLog(log, true);
                    }
                }
                else
                {
                    value = rnd.Next(2, 15).ToString();
                    
                    isNumeric = double.TryParse(value, out secondParam);
                    if (!isNumeric)
                    {
                        Console.WriteLine("Invalid value");
                        log = "User input the second parameter is " + value + ". Invalid value";
                        writeLog(log, true);
                    }
                    else if (secondParam == 0)
                    {
                        Console.WriteLine("Invalid value");
                        log = "User input the second parameter is " + value + ". Invalid value";
                        writeLog(log, true);
                    }
                    else
                    {
                        log = "User input the second parameter is " + value;
                        writeLog(log, true);
                        break;
                    }
                }
            }

            log = string.Format("the result of tc2 is: {0} / {1} = {2}", firstParam, secondParam, firstParam / secondParam);
            writeLog(log, true);
            Console.WriteLine("pass");
            log = string.Format("-----finish at {0} -----", DateTime.Now.ToString("hh:MM:ss"));
            writeLog(log, true);
        }

        /// <summary>
        /// subtraction method
        /// </summary>
        private static void tc3()
        {
            string value;
            double firstParam = 0, secondParam = 0;
            bool isNumeric = false;
            int step = 1;
            string log = string.Empty;

            log = string.Format("Log for test case 3 - {0} -----start at {1} -----", DateTime.Now.Date.ToString("dd/MM/yyyy"), DateTime.Now.ToString("hh:MM:ss"));
            writeLog(log, false);

            while (true)
            {
                if (step == 1)
                {
                    value = rnd.Next(50, 200).ToString();
                    
                    isNumeric = double.TryParse(value, out firstParam);
                    if (!isNumeric)
                    {
                        Console.WriteLine("Invalid value");
                        log = "User input the first parameter is " + value + ". Invalid value";
                        writeLog(log, true);
                    }
                    else
                    {
                        step = 2;
                        log = "User input the first parameter is " + value;
                        writeLog(log, true);
                    }
                }
                else
                {
                    value = rnd.Next(10, 50).ToString();
                    
                    isNumeric = double.TryParse(value, out secondParam);
                    if (!isNumeric)
                    {
                        Console.WriteLine("Invalid value");
                        log = "User input the second parameter is " + value + ". Invalid value";
                        writeLog(log, true);
                    }
                    else
                    {
                        log = "User input the second parameter is " + value;
                        writeLog(log, true);
                        break;
                    }
                }
            }

            log = string.Format("the result of tc3 is: {0} - {1} = {2}", firstParam, secondParam, firstParam - secondParam);
            writeLog(log, true);
            Console.WriteLine("pass");
            log = string.Format("-----finish at {0} -----", DateTime.Now.ToString("hh:MM:ss"));
            writeLog(log, true);
        }

        /// <summary>
        /// addition method
        /// </summary>
        private static void tc4()
        {
            string value;
            double firstParam = 0, secondParam = 0;
            bool isNumeric = false;
            int step = 1;
            string log = string.Empty;

            log = string.Format("Log for test case 4 - {0} -----start at {1} -----", DateTime.Now.Date.ToString("dd/MM/yyyy"), DateTime.Now.ToString("hh:MM:ss"));
            writeLog(log, false);

            while (true)
            {
                if (step == 1)
                {
                    value = rnd.Next(2, 52).ToString();
                    
                    isNumeric = double.TryParse(value, out firstParam);
                    if (!isNumeric)
                    {
                        Console.WriteLine("Invalid value");
                        log = "User input the first parameter is " + value + ". Invalid value";
                        writeLog(log, true);
                    }
                    else
                    {
                        step = 2;
                        log = "User input the first parameter is " + value;
                        writeLog(log, true);
                    }
                }
                else
                {
                    value = rnd.Next(0, 100).ToString();
                    
                    isNumeric = double.TryParse(value, out secondParam);
                    if (!isNumeric)
                    {
                        Console.WriteLine("Invalid value");
                        log = "User input the second parameter is " + value + ". Invalid value";
                        writeLog(log, true);
                    }
                    else
                    {
                        log = "User input the second parameter is " + value;
                        writeLog(log, true);
                        break;
                    }
                }
            }

            log = string.Format("the result of tc4 is: {0} + {1} = {2}", firstParam, secondParam, firstParam + secondParam);
            writeLog(log, true);
            Console.WriteLine("pass");
            log = string.Format("-----finish at {0} -----", DateTime.Now.ToString("hh:MM:ss"));
            writeLog(log, true);
        }

        /// <summary>
        /// write log to log file
        /// </summary>
        /// <param name="strLog">log's value</param>
        /// <returns>true if success else false</returns>
        private static bool writeLog(string strLog, bool append)
        {
            try
            {
                string pathFile = Path.Combine(Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location), logFile);

                using (StreamWriter writer = new StreamWriter(pathFile, append))
                {
                    writer.WriteLine(strLog);
                    writer.Flush();
                    writer.Close();
                }

                return true;
            }
            catch (Exception ex)
            {
                Console.WriteLine("error: " + ex.Message);
            }
            return false;
        }
    }
}


EOF_c_sharp

$str = &template2TS($str,"csharp");
print Fout_generateIndex_txt $str;
	close Fout_generateIndex_txt;
print " ->$SvrProjName/index.cs\n";
1;
}


sub generateTSDescCsharp {
	if ( -e $SvrProjName) {;} else { mkpath $SvrProjName; }
open Fout_generateIndex_txt, ">$SvrProjName/$TSDescName";
print " ->$SvrProjName/$TSDescName\n";
my $str =<<'EOF_Csharp';

Automation: 1 
	Name		: __tsName__
	Description	: 1. C_sharp Calculator Test case : integer * integer ( 7 * 8) 
	Dependency 	: "__csc__"
	PreRequsite 	: __tsName__/index.cs
	PreProcessor    : c:/_TAF/taf.pl testsuite=__tsName__;rmTSTempFiles
	PreProcessor	: "__csc__"  /t:exe /out:__tsName_bs__\index.exe __tsName_bs__\index.cs
	Driver      	: __tsName__/index.exe 
	Arguments       : 1
	Validator       : pass
	PostProcessor   : dir
	Log 		: __tsName__/_tcLogAppend_cs.txt
	File     	: __tsName__/manual_tc_testcase0001.txt


Automation: 2 
	Name		: __tsName__
	Description	: 2. C_sharp Calculator Test case : integer * integer ( 7 * 8) 
	Dependency 	: "__csc__"
	PreRequsite 	: __tsName__/index.cs
	PreProcessor    : c:/_TAF/taf.pl testsuite=__tsName__;rmTSTempFiles
	PreProcessor	: "__csc__"  /t:exe /out:__tsName_bs__\index.exe __tsName_bs__\index.cs
	Driver      	: __tsName__/index.exe 
	Arguments       : 2
	Validator       : pass
	PostProcessor   : dir
	Log 		: __tsName__/_tcLogAppend_cs.txt
	File     	: __tsName__/manual_tc_testcase0002.txt

Automation: 3 
	Name		: __tsName__
	Description	: 3. C_sharp Calculator Test case : integer * integer ( 7 * 8) 
	Dependency 	: "__csc__"
	PreRequsite 	: __tsName__/index.cs
	PreProcessor    : c:/_TAF/taf.pl testsuite=__tsName__;rmTSTempFiles
	PreProcessor	: "__csc__"  /t:exe /out:__tsName_bs__\index.exe __tsName_bs__\index.cs
	Driver      	: __tsName__/index.exe 
	Arguments       : 3
	Validator       : pass
	PostProcessor   : dir
	Log 		: __tsName__/_tcLogAppend_cs.txt
	File     	: __tsName__/manual_tc_testcase0003.txt

Automation: 4 
	Name		: __tsName__
	Description	: 4. C_sharp Calculator Test case : integer * integer ( 7 * 8) 
	Dependency 	: "__csc__"
	PreRequsite 	: __tsName__/index.cs
	PreProcessor    : c:/_TAF/taf.pl testsuite=__tsName__;rmTSTempFiles
	PreProcessor	: "__csc__"  /t:exe /out:__tsName_bs__\index.exe __tsName_bs__\index.cs
	Driver      	: __tsName__/index.exe 
	Arguments       : 4
	Validator       : pass
	PostProcessor   : dir
	Log 		: __tsName__/_tcLogAppend_cs.txt
	File     	: __tsName__/manual_tc_testcase0004.txt

EOF_Csharp

$str = &template2TS($str, "csharp");
print Fout_generateIndex_txt $str;
close Fout_generateIndex_txt;
1;
}

sub updateIP { 			# &updateIP("_tcLog.html", "127.0.0.1", $http_port);
my $file = "c:/_TAF/_bbb/testcase0002/_tcLog.html" ; $file 	= shift if @_; 
my $newIP = "127.0.0.1"  ; $newIP 	= shift if @_; 
my $http_port = ":8080"  ; $http_port 	= shift if @_;
my $http_IIS_port = ":18080"  ; $http_port 	= shift if @_;

my $file_tmp= $file; 

if    (($file_tmp =~ /\.cgi\b/) && ($file_tmp !~ /_bak\.cgi/)) { $file_tmp =~ s/\.cgi/_bak.cgi/ig ; }
elsif (($file_tmp =~ /\.htm\b/) && ($file_tmp !~ /_bak\.htm/)) { $file_tmp =~ s/\.htm/_bak.htm/ig ; }
elsif (($file_tmp =~ /\.html\b/)&& ($file_tmp !~ /_bak\.html/)) { $file_tmp =~ s/\.html/_bak.html/ig ; }


my %ip_in_file;

    open(Fin_html,$file) or die $!;
    while($_ = <Fin_html>)
    {
	    if ($_ =~ /(\d+\.\d+\.\d+\.\d+)$http_port/) 	{ $ip_in_file{$1}=$1; }
	    elsif ($_ =~ /(\d+\.\d+\.\d+\.\d+)$http_IIS_port/) 	{ $ip_in_file{$1}=$1; }

    }

    my $NofIP=0;
foreach my $each (keys %ip_in_file) {
	$NofIP++;
	print " $each (current IP) 	-->   $newIP (new IP)   in  $file\n";
}
if ($NofIP > 1) { print "Info: multi TAF IP exist\n";}

    seek Fin_html, 0, 0;
	open Fout_html, "> $file_tmp"; 
	while($_ = <Fin_html>)
    {
	    if    ($_ =~ s/(\d+\.\d+\.\d+\.\d+$http_port)/$newIP$http_port/g) 		{ $_ =~ s/(\d+\.\d+\.\d+\.\d+$http_IIS_port)/$newIP$http_IIS_port/g; print Fout_html "$_"; }
	    elsif ($_ =~ s/(\d+\.\d+\.\d+\.\d+$http_IIS_port)/$newIP$http_IIS_port/g) 	{ $_ =~ s/(\d+\.\d+\.\d+\.\d+$http_port)/$newIP$http_port/g        ; print Fout_html "$_"; }
	    else { 	 print Fout_html  $_; }
    }
   close Fin_html  ;
   close Fout_html;
   copy ($file_tmp, $file);
1;
}

sub generateTSDescJava {
	if ( -e $SvrProjName) {;} else { mkpath $SvrProjName; }
open Fout_generateIndex_txt, ">$SvrProjName/$TSDescName";
print " ->$SvrProjName/$TSDescName\n";
my $str =<<'EOF_java';
####################################################
# This is generated by TaaS code generator
####################################################

Automation: 1 
	Name		: __tsName__
	Description	: 1. Java Calculator Test case : integer * integer ( 7 * 8) 
	Dependency 	: "__java__"
	Dependency 	: "__javac__"
	PreRequsite 	: __tsName__/index.java
	PreProcessor    : c:/_TAF/taf.pl testsuite=__tsName__;rmTSTempFiles
	PreProcessor	: "__javac__"   -d __tsName__ __tsName__/index.java
	Driver      	: "__java__"  
	Arguments       : -cp __tsName__ index 1
	Validator       : pass
	PostProcessor   : dir
	Log 		: __tsName__/_tcLogAppend_java_.txt
	File     	: __tsName__/manual_tc_testcase0001.txt

Automation: 2 
	Name		: __tsName__
	Description	: 2. Java Calculator Test case : integer * integer ( 7 * 8) 
	Dependency 	: "__java__"
	Dependency 	: "__javac__"
	PreRequsite 	: __tsName__/index.java
	PreProcessor    : c:/_TAF/taf.pl testsuite=__tsName__;rmTSTempFiles
	PreProcessor	: "__javac__"   -d __tsName__ __tsName__/index.java
	Driver      	: "__java__"  
	Arguments       : -cp __tsName__ index 2
	Validator       : pass
	PostProcessor   : dir
	Log 		: __tsName__/_tcLogAppend_java_.txt
	File     	: __tsName__/manual_tc_testcase0002.txt

Automation: 3 
	Name		: __tsName__
	Description	: 3. Java Calculator Test case : integer * integer ( 7 * 8) 
	Dependency 	: "__java__"
	Dependency 	: "__javac__"
	PreRequsite 	: __tsName__/index.java
	PreProcessor    : c:/_TAF/taf.pl testsuite=__tsName__;rmTSTempFiles
	PreProcessor	: "__javac__"   -d __tsName__ __tsName__/index.java
	Driver      	: "__java__"  
	Arguments       : -cp __tsName__ index 3
	Validator       : pass
	PostProcessor   : dir
	Log 		: __tsName__/_tcLogAppend_java_.txt
	File     	: __tsName__/manual_tc_testcase0003.txt

Automation: 4 
	Name		: __tsName__
	Description	: 4. Java Calculator Test case : integer * integer ( 7 * 8) 
	Dependency 	: "__java__"
	Dependency 	: "__javac__"
	PreRequsite 	: __tsName__/index.java
	PreProcessor    : c:/_TAF/taf.pl testsuite=__tsName__;rmTSTempFiles
	PreProcessor	: "__javac__"   -d __tsName__ __tsName__/index.java
	Driver      	: "__java__"
	Arguments       : -cp __tsName__ index 4
	Validator       : pass
	PostProcessor   : dir
	Log 		: __tsName__/_tcLogAppend_java_.txt
	File     	: __tsName__/manual_tc_testcase0004.txt


EOF_java

#$str =~ s/__tsName__/$SvrProjName/gi;
$str = &template2TS($str);
print Fout_generateIndex_txt $str;
	close Fout_generateIndex_txt;
1;
}	


sub generateTSDescAutoIt {goto &genTCDesc}
sub generateTSDesc {goto &genTCDesc}
sub genTCDesc {

if (-e $SvrProjName) {;} else { mkpath $SvrProjName;}
open Fout_generateIndex_txt, ">$SvrProjName/$TSDescName";
print " ->$SvrProjName/$TSDescName\n";
my $str=<<EOF;
####################################################
# This is generated by TaaS code generator
####################################################


Automation: 1 
	Name		: __tsName__
	PreRequsite	: "__autoit__" 
	PreRequsite	: "__tsName__/calc.au3"				# c:/_TAF/taf.pl testsuite=c:/_autoIt2;generateAutoItTS
	PreProcessor    : "$c/$_TAF/$taf testsuite=__tsName__;rmTSTempFiles"
	Driver		: "__autoit__" 
	Arguments	: "__tsName__/calc.au3"
	Arguments	: " 7 "
	Arguments	: " 8 "
	Description	: 1. Test case : integer * integer ( 7 * 8) 
	Validator	: pass
	PostProcessor   : dir
	Dependency 	: C:/Program Files (x86)/AutoIt3/AutoIt3.exe	# url=http://www.autoit.com
	Dependency 	: __tsName__/calc.au3				# c:/_TAF/taf.pl testsuite=c:/_autoIt2;generateAutoItTS
	Log 		: __tsName__/_tcLogAppend_autoit_.txt
	Log 		: __tsName__/_log1.txt
	Log 		: __tsName__/_log2.txt
	Log 		: __tsName__/_log3.txt
	Log 		: __tsName__/manual_tc_testcase0001.txt
	
Automation: 2 
	Name		: __tsName__
	PreRequsite	: "__autoit__" 
	PreRequsite	: __tsName__/calc.au3				# c:/_TAF/taf.pl testsuite=c:/_autoIt2;generateAutoItTS
	PreProcessor    : $c/$_TAF/$taf testsuite=__tsName__;rmTSTempFiles
	Driver		: "__autoit__" 
	Arguments	: "__tsName__/calc.au3"
	Arguments	: " 5.5 "
	Arguments	: " 6 "
	Arguments	: "__tsName__/calc.au3  5.5 6"
 	Description	: 2. Test case : integer * integer ( 5.5 * 6) 
	Validator	: pass
	PostProcessor   : dir
	Dependency 	: C:/Program Files (x86)/AutoIt3/AutoIt3.exe	# url=http://www.autoit.com
	Dependency 	: __tsName__/calc.au3				# c:/_TAF/taf.pl testsuite=c:/_autoIt2;generateAutoItTS
	Log 		: __tsName__/_tcLogAppend_autoit_.txt
	Log 		: __tsName__/_log1.txt
	Log 		: __tsName__/_log2.txt
	Log 		: __tsName__/_log3.txt
	Log 		: __tsName__/manual_tc_testcase0002.txt


Automation: 3 
	Name		: __tsName__
	PreRequsite	: "__autoit__" 
	PreRequsite	: __tsName__/calc.au3				# c:/_TAF/taf.pl testsuite=c:/_autoIt2;generateAutoItTS
	PreProcessor    : $c/$_TAF/$taf testsuite=__tsName__;rmTSTempFiles
	Driver		: "__autoit__" 
	Arguments	: "__tsName__/calc.au3"
	Arguments	: " 5.5 "
	Arguments	: " 6.5 "
 	Description	: 3. Test case : integer * integer ( 5.5 * 6.5) 
	Validator	: pass
	PostProcessor   : dir
	Dependency 	: C:/Program Files (x86)/AutoIt3/AutoIt3.exe	# url=http://www.autoit.com
	Dependency 	: __tsName__/calc.au3				# c:/_TAF/taf.pl testsuite=c:/_autoIt2;generateAutoItTS
	Log 		: __tsName__/_tcLogAppend_autoit_.txt
	Log 		: __tsName__/_log1.txt
	Log 		: __tsName__/_log2.txt
	Log 		: __tsName__/_log3.txt
	Log 		: __tsName__/manual_tc_testcase0003.txt
		
		

Automation: 4 
	Name		: __tsName__
	PreRequsite	: "__autoit__" 
	PreRequsite	: __tsName__/calc.au3				# c:/_TAF/taf.pl testsuite=c:/_autoIt2;generateAutoItTS
	PreProcessor    : $c/$_TAF/$taf testsuite=__tsName__;rmTSTempFiles
	Driver		: "__autoit__" 
	Arguments	: "__tsName__/calc.au3"
	Arguments	: " 5.5 "
	Arguments	: " 0 "
 	Description	: 4. Test case : integer * integer ( 5.5 * 0) 
	Validator	: pass
	PostProcessor   : dir
	Dependency 	: C:/Program Files (x86)/AutoIt3/AutoIt3.exe	# url=http://www.autoit.com
	Dependency 	: __tsName__/calc.au3				# c:/_TAF/taf.pl testsuite=c:/_autoIt2;generateAutoItTS
	Log 		: __tsName__/_tcLogAppend_autoit_.txt
	Log 		: __tsName__/_log1.txt
	Log 		: __tsName__/_log2.txt
	Log 		: __tsName__/_log3.txt
	Log 		: __tsName__/manual_tc_testcase0004.txt
		
	

#	generate autoIt testsuite 
#	$c/$_TAF/taf.pl testsuite=c:/AutoItTestsuite;generateTSDesc       
#	$c/$_TAF/taf.pl testsuite=c:/AutoItTestsuite;generateTSFromDesc   
#	$c/$_TAF/taf.pl testsuite=c:/AutoItTestsuite;generateAutoItTS     
#	$c/$_TAF/taf.pl testsuite=c:/AutoItTestsuite;generateTAFTestsuite 
#	$c/$_TAF/taf.pl testsuite=c:/AutoItTestsuite;generateAutoItTS    
EOF
	$str = &template2TS($str);

	print Fout_generateIndex_txt $str;
close Fout_generateIndex_txt;
}

sub generateTSDescJmeter {goto &genTCDescJmeter}
sub genTCDescJmeter {

#	if ($SvrProjName !~ /jmeter_test/) { print "Warning: TS !~ jmeter. Exit. \n"; exit; } 
if (-e $SvrProjName) {;} else { mkpath $SvrProjName;}
open Fout_generateIndex_txt, ">$SvrProjName/${TSDescName}";
print " ->$SvrProjName/${TSDescName}\n";
#print Fout_generateIndex_txt<<'EOF';
	my $str=<<'EOF';
####################################################
# This is generated by TaaS code generator
####################################################

Automation: 1 
	Name		: __tsName__
	Description	: 1. Performance Test of __jmeter_url__   5  Threads   20 loops
	Dependency 	: __jmeter__
	Dependency 	: __tsName__/genSS.pl
	Dependency 	: __tsName__/genJmx.pl 
	PreProcessor    : c:/_TAF/taf.pl testsuite=__tsName__;generateJmeter_genJmx_pl
	PreProcessor    : c:/_TAF/taf.pl testsuite=__tsName__;generateJmeter_genSS_pl
	PreProcessor    : __tsName__/genJmx.pl __tsName__ jmx.jmx __jmeter_url__ 5 1 20
	PreProcessor    : c:/_TAF/taf.pl testsuite=__tsName__;rmTSTempFiles
	Executor	: __jmeter__  -n -t __tsName__/jmx.jmx -l __tsName__/_Jmeter_result.txt -j __tsName__/_Jmeter_log.txt
#	Executor	: __tsName__/jmeter.pl -targetURL www.sohu.com -NofThreads 5 -NofIterations 10 
	PostProcessor   : __tsName__/genSS.pl -tcName __tsName__ -site __jmeter_url__
	File     	: __tsName__/genJmx.pl
	File     	: __tsName__/jmx.jmx
	File     	: __tsName__/genSS.pl
	Log 		: __tsName__/_jmeter_result.txt
	Log 		: __tsName__/_jmeter_log.txt
	Log 		: __tsName__/_jmeter_latency.gif
	
Automation: 2 
	Name		: __tsName__
	Description	: 2. Performance Test of __jmeter_url__   50 Threads   20 loops
	Dependency 	: __jmeter__
	Dependency 	: __tsName__/genSS.pl
	Dependency 	: __tsName__/genJmx.pl
	PreProcessor    : c:/_TAF/taf.pl testsuite=__tsName__;generateJmeter_genJmx_pl
	PreProcessor    : c:/_TAF/taf.pl testsuite=__tsName__;generateJmeter_genSS_pl
	PreProcessor    : __tsName__/genJmx.pl  __tsName__ jmx.jmx __jmeter_url__ 50 5 20
	PreProcessor    : c:/_TAF/taf.pl testsuite=__tsName__;rmTSTempFiles
	Executor	: __jmeter__  -n -t __tsName__/jmx.jmx -l __tsName__/_Jmeter_result.txt -j __tsName__/_Jmeter_log.txt
#	Executor	: __tsName__/jmeter.pl -targetURL www.sohu.com -NofThreads 5 -NofIterations 10 
	PostProcessor   : __tsName__/genSS.pl -tcName __tsName__ -site __jmeter_url__
	File     	: __tsName__/genJmx.pl
	File     	: __tsName__/genSS.pl
	Log 		: __tsName__/_jmeter_result.txt
	Log 		: __tsName__/_jmeter_log.txt
	Log 		: __tsName__/_jmeter_latency.gif


Automation: 3 
	Name		: __tsName__
	Description	: 3. Performance Test of __jmeter_url__  100 Threads   20 loops
	Dependency 	: __jmeter__
	Dependency 	: __tsName__/genSS.pl
	Dependency 	: __tsName__/genJmx.pl
	PreProcessor    : c:/_TAF/taf.pl testsuite=__tsName__;generateJmeter_genJmx_pl
	PreProcessor    : c:/_TAF/taf.pl testsuite=__tsName__;generateJmeter_genSS_pl
	PreProcessor    : __tsName__/genJmx.pl  __tsName__ jmx.jmx __jmeter_url__ 100 5 20
	PreProcessor    : c:/_TAF/taf.pl testsuite=__tsName__;rmTSTempFiles
	Executor	: __jmeter__  -n -t __tsName__/jmx.jmx -l __tsName__/_Jmeter_result.txt -j __tsName__/_Jmeter_log.txt
	Arguments	: 
	Validator	: null
	PostProcessor   : __tsName__/genSS.pl -tcName __tsName__ -site __jmeter_url__
	File     	: __tsName__/genJmx.pl
	File     	: __tsName__/genSS.pl
	Log 		: __tsName__/_jmeter_result.txt
	Log 		: __tsName__/_jmeter_log.txt
	Log 		: __tsName__/_jmeter_latency.gif


Automation: 4 
	Name		: __tsName__
	Description	: 4. Performance Test of __jmeter_url__  500 Threads   20 loops
	Dependency 	: __jmeter__
	Dependency 	: __tsName__/genSS.pl
	Dependency 	: __tsName__/genJmx.pl
	PreProcessor    : c:/_TAF/taf.pl testsuite=__tsName__;generateJmeter_genJmx_pl
	PreProcessor    : c:/_TAF/taf.pl testsuite=__tsName__;generateJmeter_genSS_pl
	PreProcessor    : __tsName__/genJmx.pl  __tsName__ jmx.jmx __jmeter_url__ 500 5 20
	PreProcessor    : c:/_TAF/taf.pl testsuite=__tsName__;rmTSTempFiles
	Executor	: __jmeter__ -n -t __tsName__/jmx.jmx -l __tsName__/_Jmeter_result.txt -j __tsName__/_Jmeter_log.txt
	Arguments	: 
	Validator	: null
	PostProcessor   : __tsName__/genSS.pl -tcName __tsName__ -site __jmeter_url__
	File     	: __tsName__/genJmx.pl
	File     	: __tsName__/genSS.pl
	Log 		: __tsName__/_jmeter_result.txt
	Log 		: __tsName__/_jmeter_log.txt
	Log 		: __tsName__/_jmeter_latency.gif
EOF
#	$str =~ s/c:\/jmeter_automation/$SvrProjName/gi;
	$str = &template2TS($str);
	print Fout_generateIndex_txt $str; close Fout_generateIndex_txt;

}

sub generateTSDriverJmeter {

if (-e $SvrProjName) {;} else { mkpath $SvrProjName;}
open Fout_generateIndex_txt, ">$SvrProjName/jmeter.pl"; # todo hardcoded fname
print " ->$SvrProjName/jmeter.pl\n";
	my $str=<<'EOF';
use Getopt::Long;
my $tsName 		= "__tsName__";
my $targetURL 		= "www.yahoo.com"; 
my $jmxName  		= "jmx.jmx"; 
my $NofThreads		= 5;
my $rampUp		= 1;
my $NofIterations	= 20;
my $jmeter_bat		= "C:/apache-jmeter-2.11/bin/jmeter.bat";
my $help;
	GetOptions(
		'tsName=s'         	      => \$tsName,
		'targetURL=s'         	      => \$targetURL,
		'NofThreads=i'         	      => \$NofThreads,
		'NofIterations=i'             => \$NofIterations,
		'rampUp=i'         	      => \$rampUp,
		'help' 	        	      => \$help,
	);

	if ($help) {
print <<EOF_help;
$0 -tsName -targetURL -NofThreads -NofIterations -rampUp -help
$0 -tsName -targetURL jemter.apache.org -NofThreads 10 -NofIterations 2 -rampUp 1 
EOF_help
exit;
	}

my $cmd = "$tsName/genJmx.pl $tsName jmx.jmx $targetURL $NofThreads $rampUp $NofIterations"; 			my $rst = `$cmd`; print $rst;
my $cmd = "$jmeter_bat  -n -t $tsName/$jmxName -l $tsName/_Jmeter_result.txt -j $tsName/_Jmeter_log.txt"; 	my $rst = `$cmd`; print $rst;
my $cmd = "$tsName/genSS.pl -tcName $tsName -site $targetURL"; 							my $rst = `$cmd`; print $rst;

EOF
	$str = &template2TS($str);
	print Fout_generateIndex_txt $str; close Fout_generateIndex_txt;

}

#########################
sub rmTSTempFiles {
	my $SvrProjName_ = $SvrProjName; 
	if ($SvrProjName_ =~ /^\s*$c/) { ; } else {  $SvrProjName_ = "$c/$SvrProjName_"; }
	unlink glob "$SvrProjName_/_*";
	unlink glob "$SvrProjName_/.class";
	unlink glob "$SvrProjName_/.jar";
	return 1;
}
sub generateJmeter_genSS_pl {
	if ($SvrProjName =~ /^\s*$c/) { ; } else { print "Warn: $c is missing. Exits from generateJmeter_genSS_pl\n"; exit; }
	if ( -e $SvrProjName ) {;} else { mkpath $SvrProjName; }
	print " -> $SvrProjName/genSS.pl";
	open Fout_genSS, ">$SvrProjName/genSS.pl";
my $str=<<'EOF_genSS';
use Win32::OLE;
use Win32::OLE qw(in with);
use Win32::OLE::Variant;
use Win32::OLE::Const 'Microsoft Excel';
use Getopt::Long;
use Date::Manip;

$dateNow = &UnixDate(&ParseDate("now"),"%T %b %e, %Y");
$tcName 	="__tsName__";
$ssName 	= "currentBuild";
$projCode 	= "BLACK";
$xlInput 	= "_xlInput_.txt" ;
$site		= "jmeter.apache.org";	
$help; $genXLInput ; 
GetOptions (
	'help' => \$help,	
	'drive=s' => \$drive,	
	'tcName=s' => \$tcName,	
	'SSName=s' => \$ssName,	
	'xlInput=s' => \$xlInput,	
	'item=s' => \$item,	
	'metricsName=s' => \$item,	
	'CEDue=s' => \$ssName,	
	'CEDueRegExp=s' => \$CEDue,	
	'projCode=s' => \$projCode,	
	'genXLInput' => \$genXLInput,	
	'XLInputFname=s' => \$XLInputFname,	
	'site=s' 	=> \$site,	
);

if ($help) {
print <<EOF;
genSS.pl -item TestCase -ssName N_N_N -xlInput _xlInput_TestCase.txt" -site jmeter.apache.org
genSS.pl -metricsName TestCase -CEDue N_N_N -xlInput _xlInput_TestCase.txt [-genXLInput] [-CEDueRegExp...] [-projCode CE]
genSS.pl -metricsName TestCase -CEDue N_N_N 

EOF
	exit;
}
$XLInputFname = "__tsName__/$XLInputFname";


my $metricsName = $item;
if ($xlInput) { ; } else { $xlInput = "_xlInput_.txt"; }
my $SSNameGIF 	= "$tcName/_jmeter_latency.gif"; 	
my $SSName 	= "$tcName/_jmeter_latency.xls"; 	
my $data_file	= "$tcName/_jmeter_result.txt"; 	
#my $data_file	= "$tcName/_jmeter_data_writer.txt"; 	


$str ="[[\"serialN\",\"Latency\"]";
open Fin_, $data_file ; $ctr = 1;	 print " <- $data_file\n";
while ($_ = <Fin_>) { chop;
	if ($_ =~ /Home/i) {
	my @record = split(',',$_);
$str .= sprintf ",\n[\"$ctr\", \"$record[$#record]\"]"; # 	$ctr++; 
}
}
#while ($_ = <Fin_>) { chop;
#$str .= sprintf ",\n[\"$ctr\", \"$_\"]"; # 	$ctr++; 
#}
close Fin_;
$str .= "];";

# print $str;

my $xlInput 	= "$tcName/_xlInput_.txt"; 	
open Fout_, ">$xlInput"; print Fout_ $str; close Fout_;

print " -> $xlInput\n";
# todo $Excel = Win32::OLE->GetActiveObject('Excel.Application') || Win32::OLE->new('Excel.Application');
$Excel = Win32::OLE->new('Excel.Application');
$Excel->{'Visible'} = 0;                    #0 is hidden, 1 is visible
$Excel->{DisplayAlerts}=0;           		#0 is hide alerts

$xlBook = $Excel->Workbooks->Add;

   print " <- $xlInput\n";
 	   open Fin, $xlInput; @_ = <Fin>; close Fin;
		my $str = "@_";
		$mydata = eval $str;
	   my $tmpStr = $str;
	   my $NofRow = (split /\],/, $tmpStr); 
	   my $NofCol = (split /,/, $tmpStr); 
	   $NofCol = (($NofCol + 1) / $NofRow) -1;

	   # my $tmpStr = "A1:E$NofRow";
	   my $tmpStr = "A1:".&convert($NofCol)."$NofRow";

	   if ($NofRow <= 1) { 
		   $mydata = "no data exist\n";
	   	   $tmpStr = "A1:B1";
	   }
$rng = $xlBook->ActiveSheet->Range("$tmpStr");
$rng->{Value} = $mydata;
$Sheet = $xlBook->ActiveSheet;
my $Range = $xlBook->ActiveSheet->Range($tmpStr);
my $Chart = $Excel->Charts->Add;
$Chart->{ChartType} = xlLine;
if ($NofRow > 1) { 
	$Chart->SetSourceData({Source => $Range, PlotBy => xlColumns});
	$Chart->{HasTitle} = 1;
	$Chart->ChartTitle->{Text} = "$site Performance (ms) Measured by JMeter on $dateNow";
#toto	$Chart->Axes(xlCategory)->TickLabels->{Orientation} = -56;
} else {
; # $Chart->ChartTitle->{Text} = "Real Time has no data";
}

my $ChartObj = $Sheet->ChartObjects;
print " -> $SSNameGIF\n -> $SSName\n"; 
$Chart->Export({
               FileName   => $SSNameGIF,
               FilterName => 'GIF',
               Interactive  => 0});

$Excel->ActiveWindow->SelectedSheets->PrintOut({
               Copy => 1,
               ActivePrinter => 'Acrobat PDFWriter'});
$SSName =~ s/\//\\/g;
$xlBook->SaveAs({Filename => $SSName,
              FileFormat => xlWorkbookNormat});  
$xlBook->Close();
$Excel->Quit();  

sub convert { my $index = shift; $index ; my $a ="ABCDEFGHIJKLMNOPQRSTUVWXYZ"; @_ = split //, $a; return $_[$index]; }

EOF_genSS
$str = &template2TS($str);
print Fout_genSS $str;
	close Fout_genSS;
}

sub generateTAFTestbed { goto &generateTAFTestsuiteTestbed }
sub generateTAFTestsuiteTestbed { # Testbed is handled by the TaaS TS
	&genDriver_testbed ("force");
	&generateTAFTestsuite();	
	return 1;
}

sub generateTAFTestsuiteApacheBenchmark { goto &generateTAFTestsuiteAB}
sub generateTAFTestsuiteAB {
 	&generateTSDescAB();
 	&generate_index_ab_pl(); 
	&generateTSFromDesc();
	&generateTSManualStepAB(); 
	&generate_index_ab_cgi(); 
 	&generateTAFTestsuite();	
	&generate_index_ab_cgi(); 
	return 1;
}
sub generateTAFTestsuiteC{
	&generateTSDescC();
	&generate_index_C(); 
	&generateTSFromDesc();
	&generateTAFTestsuite();	
	&generate_index_ab_cgi(); 
	return 1;
}

sub generateTAFTestsuiteC_plusplus{
	&generateTSDescC_plusplus();
	&generate_index_C_plusplus(); 
	&generateTSFromDesc();
	&generateTAFTestsuite();	
	&generate_index_ab_cgi(); 
	return 1;
}


sub generateTAFTestsuiteManualTS { goto &generateTAFTestsuite_customTS_manualTS}
sub generateTAFTestsuite_customTS_manualTS{
	&createTS();	
	&generate_index_ab_cgi(); 
	return 1;
}

sub generateTAFTestsuiteCustomTS {goto &generateTestsuite_customTS_restoreDB}
sub generateTAFTestsuite_customTS_restoreDB{
	&generate_index_customTS_restoreDB();
	&generate_input_customTS_restoreDB();
	&generateTAFTestsuite();	
	my $SvrProjNameStr_C_no = &getTCName_C_no($SvrProjName);
	my $cmd = "$c/$_TAF/$taf testsuite=$SvrProjNameStr_C_no;testcase=testcase0002;exec"; my $rst = `$cmd`; print $rst;
	   $cmd = "$c/$_TAF/$taf testsuite=$SvrProjNameStr_C_no;testcase=testcase0003;exec";    $rst = `$cmd`; print $rst;
	&generate_index_ab_cgi(); 
	return 1;
}

sub generateTAFTestsuiteJava{
	&generateTSDescJava();
	&generate_index_java(); 
	&generateTSFromDesc();
	&generateTAFTestsuite();	
	&generate_index_ab_cgi(); 
	return 1;
}

sub generateTAFTestsuiteCsharp {
 	&generateTSDescCsharp(); 
 	&generate_index_Csharp(); 
	&generateTSFromDesc();
	&generateTAFTestsuite();	
	&generate_index_ab_cgi(); 

}

sub generateTAFTestsuiteSelenium{
 	&generateTSDescSelenium(); 
	&generateIndex_pl_Selenium(); 
	&generateTAFTestsuite();	
	&generate_index_ab_cgi(); 
	return 1;
}

sub generateTAFTestsuiteTaaS {
	&generateIndex_pl_TaaS(); 
	&generateTaaSIndexUpload_pl();
	&generateTAFTestsuite();	
	my $SvrProjNameStr_C_no = &getTCName_C_no($SvrProjName);
	my $cmd = "$c/$_TAF/$taf testsuite=$SvrProjNameStr_C_no;testcase=testcase000[2,6];exec"; my $rst = `$cmd`; print $rst;
}

sub generateTAFTestsuiteJira {
	$index_pl_arguments =~ /CompanyNameIs_(.+)_ProjectNameIs_(.+)\s*$/;
	my $CompanyName = $1; my $ProjectName = $2; 
	$SvrProjName = "$c/$CompanyName/$ProjectName";
	&generateIndexUpload_pl();
	&generateIndexIndexJira($CompanyName, $ProjectName);
	&generateJsonJira();
	&generate_index_ab_cgi(); 

	my $cmd = "$SvrProjName/indexindex.pl -CompanyName $CompanyName -ProjName  $ProjectName  -assignedIP $ip";
	my $rst = `$cmd`; print $rst;
	   $cmd = "$c/$_TAF/$taf testsuite=$c/$CompanyName/$ProjectName;generateTAFTestsuite";
	   $rst = `$cmd`; print $rst;

}

sub generateTAFTestsuiteAutoIt{
 	&generateTSDescAutoIt();	
	&generateTSFromDesc();	
	&generateTAFTestsuite();	
	&generateAutoItTS();
	&generate_index_ab_cgi(); 
	return 1;
}

sub generateTAFTestsuiteAutoItTraining {
	&generateIndex_pl_autoIt_training(); 
	&generateIndex_au3_autoIt_training();
	&generateTAFTestsuite();	
	&generate_index_ab_cgi(); 
}
sub generateTAFTestsuiteRuby{
	&generateTSDescRuby(); 
	&generateIndex_pl_Ruby (); 
	&generateIndex_rb_Ruby ();
	&generateTSFromDesc(); 
	&generateTAFTestsuite();	
	&generate_index_ab_cgi(); 
}
#sub generateTAFTestsuiteRuby{
#	&generateIndex_pl_Ruby (); 
#	&generateIndex_rb_Ruby ();
#	&generateTAFTestsuite();	
#}
sub generateTAFTestsuiteCalcRuby{
	&generateTSDescRuby(); 
	&generateTSFromDesc();	
	&generateTAFTestsuite();	
	&generate_index_ab_cgi(); 
	return 1;
}

sub generateTAFTestsuitePerl {
 	&generateTSDescPerl();	
 	&generateTSFromDesc();	
	&generateTAFTestsuite();	
	&generate_index_ab_cgi(); 
	return 1;
}


sub generateTAFTestsuiteTaaSProject {
	&generateIndex_pl_TaaSProject(); 
	&generateTAFTestsuite();	
}

sub generateIndex_pl_TaaSProject {
	my $SvrProjNameStr = &getTCName_C($SvrProjName); 
	if ( -e $SvrProjNameStr) {;} else { mkpath $SvrProjNameStr; }
	print " -> $SvrProjNameStr/index.pl\n"; 
	open  FoutIndexTaaSProject, ">$SvrProjNameStr/index.pl" ;

print FoutIndexTaaSProject<<'EOF_TaaSProj';
#!C:/strawberry/perl/bin/perl.exe
use Getopt::Long;
use Date::Manip;

my $descPattern = "_nothing_";

$tcName = "TaaSProject";
if ($^O =~ /win32/i) { $_TAF = "c:"; } if ($^O =~ /linux/i) { $_TAF = "/tmp/var/www/cgi-bin"; } 
$tcDir = "$_TAF/$tcName";

my $result = GetOptions ( "descPattern=s"  		=> \$descPattern);



my $desc=<<EOF;
1. TaaS Project Readme
2. Taas Project Tickets
3. Test case description 3 
4. Test case description 4 
5. Test case description 5 
6. Test case description 6 
EOF
;

my $index = 1; foreach $each (split /\n/, $desc) { if ($each =~ /$descPattern/i) { push (@ARGV, " $index");  $index++; } }

$tcIndexMap[1] = 1;
$tcIndexMap[2] = 2;
$tcIndexMap[3] = 3;
$tcIndexMap[4] = 4;
$tcIndexMap[5] = 5;
$tcIndexMap[6] = 6;




if ($ARGV[0]) { 
	foreach my $eachTC (@ARGV) {
	if ($eachTC =~ /^\s*(-?\d+)\s*$/) { $eachTC = $1;
	open Fout, ">$tcDir/_tcLogAppend.txt";
		if (($eachTC == $tcIndexMap[1]) || ($eachTC == -1) ) { print &tc1(); } # <<< plug in the test case 1 here e.g. print `index.pl 1` ; >>>
		if (($eachTC == $tcIndexMap[2]) || ($eachTC == -1) ) { print &tc2(); } # <<< plug in the test case 2 here e.g. print `index.pl 2`>>>
		if (($eachTC == $tcIndexMap[3]) || ($eachTC == -1) ) { print &tc3(); } # <<< plug in the test case 3 here e.g. print `index.pl 3`>>>
		if (($eachTC == $tcIndexMap[4]) || ($eachTC == -1) ) { print &tc4(); } # <<< plug in the test case 4 here e.g. print `index.pl 4`>>>
		if (($eachTC == $tcIndexMap[5]) || ($eachTC == -1) ) { print &tc5(); } # <<< plug in the test case 5 here e.g. print `index.pl 5`>>>
		if (($eachTC == $tcIndexMap[6]) || ($eachTC == -1) ) { print &tc6(); } # <<< plug in the test case 6 here e.g. print `index.pl 6`>>>
	close Fout;
	}
	}
} else { print $desc; }


sub tc1 { 
	&gengenSS(); 
	return "null"; } 
sub tc2 { 
	print " <- c:/_TAF/AutomationFramework.pm\n";
open FinTAF, "c:/_TAF/AutomationFramework.pm";
my %tafBugTicket;
while ($_ = <FinTAF>) {
	if ($_ =~ /-done/) { 
		if ($_ =~ /-done\s+((\d+)\/(\d+)\/(\d+))\s+/) {
			$tafBugTicket{$1}++;
	}
	}
}
close FinTAF;
my $NofTickets=0;
my %tafBugTickets={0};
my %tafBugTicketsAccu={0};
my $str;

foreach my $each (sort {&sortDate($a) <=> &sortDate($b)} keys %tafBugTicket) { $tafBugTickets{$each} 	+= $tafBugTicket{$each}; }
foreach my $each (sort {&sortDate($a) <=> &sortDate($b)} keys %tafBugTicket) { $NofTickets 		+= $tafBugTickets{$each}; $tafBugTicketsAccu{$each} = $NofTickets; }

$str = "[[\"_\",\"N of Tickets\"],\n";
foreach my $each (sort {&sortDate($a) <=> &sortDate($b)} keys %tafBugTicket) { $str .= sprintf "[\"$each\", \"$tafBugTicketsAccu{$each}\"\],\n"; }

chop $str; chop $str;
$str .="];";
open FoutXlInput, ">c:/TaaSProject/_xlInput_.txt";
print " -> c:/TaaSProject/_xlInput_.txt\n";
print FoutXlInput $str;
close FoutXlInput;

my $cmd = "c:/TaaSProject/_genSS.pl";
print `$cmd`;

 open FouttcLogAppend, ">c:/TaaSProject/_tcLogAppend.txt";
print FouttcLogAppend<<EOF_tcLog;

c:/TaaSProject/metrics.gif 

c:/TaaSProject/metrics.xls 




EOF_tcLog
 close FouttcLogAppend; 
	return "null"; } 
sub tc3 { return "null"; } 
sub tc4 { return "null"; } 
sub tc5 { return "null"; } 
sub tc6 { return "null"; } 

sub sortDate {
	my $date = shift;
	if ($date =~ /(\d+)\/(\d+)\/(\d+)/) {
	my $m = $1; my $d = $2; my $y = $3;
	return &Date_DaysSince1BC($m,$d,$y)
	}
}

sub gengenSS {

print " --> c:/TaaSProject/_genSS.pl\n";
open Fout_genSS, ">c:/TaaSProject/_genSS.pl";
print Fout_genSS<<'EOF_genSS';
use Win32::OLE;
use Win32::OLE qw(in with);
use Win32::OLE::Variant;
use Win32::OLE::Const 'Microsoft Excel';
use Getopt::Long;
use Date::Manip;

$dateNow = &UnixDate(&ParseDate("now"),"%T %b %e, %Y");
$tcName 	="c:/TaaSProject";
$ssName 	= "currentBuild";
$projCode 	= "SWAT";
$xlInput 	= "_xlInput_.txt" ;
$item 		= "Task";
$item_ 		= "defects";
$item__ 	= "Defects";
$CEDue 		= "3.2.1" ;
$drive 		= 'c:\\\\';
$XLInputFname = "_HistoricalRecordItems.txt";
$help; $genXLInput ;
GetOptions (
	'help' => \$help,	
	'drive=s' => \$drive,	
	'tcName=s' => \$tcName,	
	'SSName=s' => \$ssName,	
	'xlInput=s' => \$xlInput,	
	'item=s' => \$item,	
	'metricsName=s' => \$item,	
	'CEDue=s' => \$ssName,	
	'CEDueRegExp=s' => \$CEDue,	
	'projCode=s' => \$projCode,	
	'genXLInput' => \$genXLInput,	
	'XLInputFname=s' => \$XLInputFname,	
);

if ($help) {
print <<EOF;
genSS.pl -item TestCase -ssName N_N_N -xlInput _xlInput_TestCase.txt"
genSS.pl -metricsName TestCase -CEDue N_N_N -xlInput _xlInput_TestCase.txt [-genXLInput] [-CEDueRegExp...] [-projCode CE]
genSS.pl -metricsName TestCase -CEDue N_N_N 

EOF
	exit;
}
# $xlInput = $drive.$tcName.'\\\\'.$xlInput; 
$XLInputFname = "$tcName/$XLInputFname";
#if ($item =~ /defect/i) { $XLInputFname = "c:/XBOSOFT/$BLANK/_HistoricalRecord.txt"; }
# open Fin, "_HistoricalTaskRecord.txt"; while (<Fin>) { chop; printf "$_%-19s\|%-19s\|%-19s\n", "3.2.1", "tasks", "CE"; } close Fin; exit;
if ($item =~ /Tasks/i) 		{ $item_ = "tasks";  		$item__ = "Tasks"; }
if ($item =~ /TestPlan/i) 	{ $item_ = "testplan";  	$item__ = "TestPlans"; }
if ($item =~ /Requirement/i) 	{ $item_ = "requirement"; 	$item__ = "Requirements"; }
if ($item =~ /Specification/i) 	{ $item_ = "specification"; 	$item__ = "Specifications"; }
if ($item =~ /TestCase/i) 	{ $item_ = "testcase"; 		$item__ = "TestCases"; }
if ($item =~ /CodeReview/i) 	{ $item_ = "codereview"; 	$item__ = "CodeReviews"; }
if ($item =~ /Task/i) 		{ $item_ = "task"; 		$item__ = "Tasks"; }

my $metricsName = $item;
if ($xlInput) { ; } else { $xlInput = "_xlInput_.txt"; }
my $SSNameGIF 	= "$tcName/metrics.gif"; 	
my $SSName 	= "$tcName/metrics.xls"; 	
$xlInput 	= "$tcName/$xlInput"; 	

#if ($item !~ /TCCoverage|Task/i) { &genXLInput(); } 
#	if ($genXLInput) {exit;}

$Excel = Win32::OLE->GetActiveObject('Excel.Application') || Win32::OLE->new('Excel.Application');
$Excel->{'Visible'} = 1;                    #0 is hidden, 1 is visible
$Excel->{DisplayAlerts}=0;           		#0 is hide alerts

$xlBook = $Excel->Workbooks->Add;

$mydata = [["1", "12", "5.30","5","6","19"], 
           ["2", "13", "5.25","8","9","18"],
           ["3", "15", "23.00","9","3","25"],
           ["4", "18", "16.25","2",],
           ["5", "11", "5.00","7","8","9"],
           ["6", "20", "31.00","13"],
           ["7", "16", "2.25","19"]];

	   print " <- $xlInput\n";
	   open Fin, $xlInput; @_ = <Fin>; close Fin;
		my $str = "@_";
		$str =~ s/"Closed/"Closed - total number of currently Closed $item_/g;
		$str =~ s/"Resolved/"Resolved - total number of currently Resolved $item_/;
		$str =~ s/"Open/"Open - total number of currently Open $item_/;
		$str =~ s/"TotalCtr/"Total number of $item_ - sum of open, resolved and closed/;

	   $mydata = eval $str;
	   my $tmpStr = $str;
	   my $NofRow = (split /\],/, $tmpStr); 
	   my $NofCol = (split /,/, $tmpStr); 
	   $NofCol = (($NofCol + 1) / $NofRow) -1;

	   # my $tmpStr = "A1:E$NofRow";
	   my $tmpStr = "A1:".&convert($NofCol)."$NofRow";
	   if ($NofRow <= 1) { 
		   $mydata = "$tcName Real Time $item Metrics and Trends ($dateNow) has NO data"; 
	   	   $tmpStr = "A1:B1";
	   }
$rng = $xlBook->ActiveSheet->Range("$tmpStr");
$rng->{Value} = $mydata;
$Sheet = $xlBook->ActiveSheet;
my $Range = $xlBook->ActiveSheet->Range($tmpStr);
my $Chart = $Excel->Charts->Add;
$Chart->{ChartType} = xlLine;
if ($NofRow > 1) { 
	$Chart->SetSourceData({Source => $Range, PlotBy => xlColumns});
	$Chart->{HasTitle} = 1;
	$Chart->ChartTitle->{Text} = "$tcName Real Time $item Metrics and Trends ($dateNow)";
	$Chart->Axes(xlCategory)->TickLabels->{Orientation} = -56;
} else {
; # $Chart->ChartTitle->{Text} = "Real Time has no data";
}

my $ChartObj = $Sheet->ChartObjects;
print " -> $SSNameGIF\n -> $SSName\n"; 
$Chart->Export({
               FileName   => $SSNameGIF,
               FilterName => 'GIF',
               Interactive  => 0});

$Excel->ActiveWindow->SelectedSheets->PrintOut({
               Copy => 1,
               ActivePrinter => 'Acrobat PDFWriter'});

$SSName =~ s/\//\\/g;
$xlBook->SaveAs({Filename => $SSName,
              FileFormat => xlWorkbookNormal});  
$xlBook->Close();
$Excel->Quit();  


sub genXLInput { 
	my %record;
	my $str = '[["_","TotalCtr","Open","Resolved","Closed"],'."\n";
	print " <- $XLInputFname (metricsname: $metricsName  projName: $projCode    CEDue: $CEDue\n";
	open Fin, $XLInputFname;
	while (<Fin>) { chop;
		split (/\|/);
		my $dtime = $_[0]; my $total = $_[1]; my $open  = $_[2]; my $resolved = $_[3]; my $closed = $_[4]; my $cedue = $_[5]; my $metricsname = $_[6]; my $projcode = $_[7];
		if ($total !~ /^\s*$/) 		{$total =~ /^\s*(\d+)\s+/; $total= $1;} else { $total = 0;}
		if ($open !~ /^\s*$/) 		{$open =~ /^\s*(\d+)\s+/; $open = $1;} else { $open = 0;}
		if ($resolved !~ /^\s*$/) 	{$resolved =~ /^\s*(\d+)\s+/; $resolved = $1;} else { $resolved = 0;}
		if ($closed !~ /^\s*$/) 	{$closed =~ /^\s*(\d+)\s+/; $closed = $1;} else { $closed = 0;}
		if ($total =~ /^\s*$/) 		{$total = 0;}
		if ($open  =~ /^\s*$/) 		{$open  = 0;}
		if ($resolved =~ /^\s*$/) 	{$resolved = 0;}
		if ($closed =~ /^\s*$/) 	{$closed = 0;}
		$cedue =~ s/\s+$//g; $cedue =~ s/^\s+//g; $metricsname=~ s/\s+$//g; $metricsname=~ s/^\s+//g;
		if (($projcode =~ /$projCode/i) && ( $cedue =~ /$CEDue/) && ($metricsname =~ /$metricsName/i)) {
		$record{$dtime} = "\[\"$dtime\",\"$total\",\"$open\",\"$resolved\",\"$closed\"\]," if ($total != 0);
		} elsif ($metricsName =~ /defect/i) {
		$record{$dtime} = "\[\"$dtime\",\"$total\",\"$open\",\"$resolved\",\"$closed\"\]," if ($total != 0);
		}
	}	
	close Fin;	
	foreach my $each ( sort {&Date_Cmp(&ParseDate($a), &ParseDate($b))} keys %record) {
		$str .= sprintf $record{$each}."\n";
	}
	$str =~ s/,\s*$/\];/g;
	open Fo, ">$xlInput"; print Fo $str; close Fo; print " -> $xlInput\n";
}

sub convert { my $index = shift; $index ; my $a ="ABCDEFGHIJKLMNOPQRSTUVWXYZ"; @_ = split //, $a; return $_[$index]; }


EOF_genSS
close Fout_genSS;	

}

EOF_TaaSProj

	close FoutIndexTaaSProject;
}

sub generateJmeterTS {
	if (-e $_TAF) {;} else { mkpath $_TAF; }
	open Fout, "> $c/$_TAF/jmeter.pl";
	print  " -> $c/$_TAF/jmeter.pl\n";
print Fout<<'EOF_jmeter';
use Getopt::Long;
use File::Path;

my $tsName 		= "c:/JmeterTS";
my $tsName_no_C 	; # assigned later 
my $targetURL 		= "www.yahoo.com"; 
my $jmxName  		= "jmx.jmx"; 
my $NofThreads		= 5;
my $rampUp		= 1;
my $NofIterations	= 2;
my $jmeter_bat		= "C:/apache-jmeter-2.11/bin/jmeter.bat";
my $help;
	GetOptions(
		'tsName=s'         	      => \$tsName,
		'targetURL=s'         	      => \$targetURL,
		'NofThreads=i'         	      => \$NofThreads,
		'NofIterations=i'             => \$NofIterations,
		'rampUp=i'         	      => \$rampUp,
		'help' 	        	      => \$help,
	);

	if ($help) {
print <<EOF_help;
$0 -tsName -targetURL -NofThreads -NofIterations -rampUp -help
$0 -tsName c:/jmeterTS -targetURL localhost -NofThreads 10 -NofIterations 2 -rampUp 20 
EOF_help
exit;
	}

if ($tsName =~ /^\w:[\/|\\](.+)/) { $tsName_no_C = $1; }

if (-e $tsName) {;} else { mkpath $tsName; }
open Fout, ">$tsName/index.txt";
print " -> $tsName/index.txt\n";

print Fout<<EOF;
Automation: 1 
	Name		: $tsName
	Description	: URL Performance Test by Jmeter 
	Dependency 	: $jmeter_bat
	Dependency 	: $tsName/genSS.pl
	Dependency 	: $tsName/genJmx.pl
	PreProcessor	: c:/_TAF/taf.pl testsuite=$tsName;rmTSTempFiles
	PreProcessor    : c:/_TAF/taf.pl testsuite=$tsName;generateJmeter_genJmx_pl
	PreProcessor    : c:/_TAF/taf.pl testsuite=$tsName;generateJmeter_genSS_pl
	PreProcessor    : $tsName/genJmx.pl  $tsName jmx.jmx $targetURL $NofThreads $rampUp $NofIterations
	Executor	: $jmeter_bat  -n -t $tsName/jmx.jmx -l $tsName/_Jmeter_result.txt -j $tsName/_Jmeter_log.txt
	PostProcessor   : $tsName/genSS.pl -tcName $tsName -site $targetURL
	File     	: $tsName/genJmx.pl
	File     	: $tsName/genSS.pl
	File     	: $tsName/jmx.jmx
	Log 		: $tsName/_jmeter_result.txt
	Log 		: $tsName/_jmeter_log.txt
	Log 		: $tsName/_jmeter_latency.gif
EOF


my $cmd = "c:/_TAF/taf.pl testsuite=$tsName;generateTSFromDesc"; print `$cmd`;
my $cmd = "c:/_TAF/taf.pl testsuite=$tsName;generateTAFTestsuite"; print `$cmd`;
my $cmd = "c:/_TAF/taf.pl testsuite=$tsName;generate_index_jmeter_cgi"; print `$cmd`;
my $cmd = "c:/_TAF/taf.pl testsuite=$tsName_no_C;testcase=testcase0001;exec"; print `$cmd`;


EOF_jmeter
	close Fout;

}
sub generateTAFTestsuiteJmeter {
	$index_pl_arguments =~ /__url__(.+)__url__/;	# Processing jmeter_url from cgi 
	if ($1) { $jmeter_url = $1;}
	&generateTSDescJmeter();	
	&generateTSDriverJmeter ();
	&generateTSFromDesc();	
	&generateTAFTestsuite();	
	&generate_index_ab_cgi(); 
	$SvrProjName = "$c/$SvrProjName";
	&generateJmeter_genJmx_pl(); 
	&generateJmeter_genSS_pl(); 
	return 1;
}

sub generateIndex_pl_Ruby{
	my $SvrProjNameStr = &getTCName_C($SvrProjName); 
	if ( -e $SvrProjNameStr) {;} else { mkpath $SvrProjNameStr; }
	print " -> $SvrProjNameStr/index.pl\n"; 
	open  FoutIndexAutoItTraining, ">$SvrProjNameStr/index.pl" ;
# if ($ARGV[0]) { my $cmd = "\"C:/Ruby193/bin/ruby.exe\" __tsName__/index.rb $ARGV[0]"; print `$cmd`; 
my $str=<<'EOF';

use File::Copy;

if ($ARGV[0]) { my $cmd = "\"ruby.exe\" __tsName__/index.rb $ARGV[0]"; print `$cmd`; 
	open Fout, "> __tsName__/_tcLogAppend.txt"; print Fout " __tsName__/index.rb.txt\n"; close Fout;
	copy ("__tsName__/index.rb", "__tsName__/index.rb.txt");
} else { my $cmd = "C:/ruby193/bin/ruby.exe __tsName__/index.rb"; print `$cmd`; }



#if ($ARGV[0]) { my $cmd = "\"C:/Ruby193/bin/ruby.exe\" __tsName__/index.rb $ARGV[0]"; print `$cmd`; 
#} else { my $cmd = "C:/ruby193/bin/ruby.exe __tsName__/index.rb"; print `$cmd`; }

EOF

$str =~ s/__tsName__/$SvrProjNameStr/gi; 

print FoutIndexAutoItTraining $str;
	close FoutIndexAutoItTraining;
}

sub generateIndex_rb_Ruby {
	my $SvrProjNameStr = &getTCName_C($SvrProjName); 
	if ( -e $SvrProjNameStr) {;} else { mkpath $SvrProjNameStr; }
	print " -> $SvrProjNameStr/index.rb\n"; 
	open  FoutIndexRb, ">$SvrProjNameStr/index.rb" ;
my $str=<<'EOF';
def tc1() 
	return "pass" 
end
def tc2() 
	return "pass" 
end
def tc3 
	return "fail" 
end
def tc4 
	return "null" 
end
def tc5 
	return "fail" 
end
def tc6 
	return "pass" 
end

tsDesc = %{
1. Test case description 1 for | | < > \$ \% @ testing the function 1 --- Please modifyaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa _smoke_ _regression_
2. Test case description 2 for testing _smoketest__regressiontest_the function 2 --- Please modifybbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb _smoke_
3. Test case description 3 for testing _smoketest_the function 3 --- Please modifycddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd _regression_
4. Test case description 4 for testing _regressiontest_the function 4 --- Please modify _smoke_
5. Test case description 5 for testing _regressiontest_the function 5 --- Please modify
6. Test case description 6 for testing the function 6 --- Please modify
}

if ARGV[0] == "1"
	print tc1()
elsif ARGV[0] == "2"
	print tc2()
elsif ARGV[0] == "3"
	print tc3()
elsif ARGV[0] == "4"
	print tc4()
elsif ARGV[0] == "5"
	print tc5()
elsif ARGV[0] == "6"
	print tc6()
else 
	print tsDesc
end

EOF

$str =~ s/__tsName__/$SvrProjNameStr/gi; 

print FoutIndexRb $str;
	close FoutIndexAutoItTraining;
}

sub generateIndex_pl_autoIt_training {
	my $SvrProjNameStr = &getTCName_C($SvrProjName); 
	if ( -e $SvrProjNameStr) {;} else { mkpath $SvrProjNameStr; }
	print " -> $SvrProjNameStr/index.pl\n"; 
	open  FoutIndexAutoItTraining, ">$SvrProjNameStr/index.pl" ;
my $str=<<'EOF';

use File::Copy;

if ($ARGV[0]) { my $cmd = "\"C:/Program Files (x86)/AutoIt3/autoIt3.exe\" __tsName__/index.au3 $ARGV[0]"; print `$cmd`; 
	open Fout, ">> __tsName__/_tcLogAppend.txt"; print Fout "__tsName__/index.au3.txt";	close Fout;
	copy ("__tsName__/index.au3", "__tsName__/index.au3.txt") or die "copy filed: $!";
} else {  my $cmd = "\"C:/Program Files (x86)/AutoIt3/autoIt3.exe\" __tsName__/index.au3"; print `$cmd`; }



#if ($ARGV[0]) { my $cmd = "\"C:/Program Files (x86)/AutoIt3/autoIt3.exe\" __tsName__/index.au3 $ARGV[0]"; print `$cmd`; 
#} else { my $cmd = "\"C:/Program Files (x86)/AutoIt3/autoIt3.exe\" __tsName__/index.au3"; print `$cmd`; }
EOF

$str =~ s/__tsName__/$SvrProjNameStr/gi; 

print FoutIndexAutoItTraining $str;
	close FoutIndexAutoItTraining;
}


sub generateIndex_au3_autoIt_training {
	my $SvrProjNameStr = &getTCName_C($SvrProjName); 
	if ( -e $SvrProjNameStr) {;} else { mkpath $SvrProjNameStr; }
	print " -> $SvrProjNameStr/index.au3\n"; 
	open  FoutIndexAutoItTraining, ">$SvrProjNameStr/index.au3" ;
my $str=<<'EOF';

;common
#include <Constants.au3>
#include <GUIConstantsEx.au3>
#include <Timers.au3>
#include<Date.au3>
#include <GuiComboBox.au3>

;~ ;tc14
#include <NamedPipes.au3>
#include <WinAPI.au3>
#include <WindowsConstants.au3>
#include <StaticConstants.au3>

;~ ;tc 16
#include <GDIPlus.au3>

;~ ;tc20
#include <ButtonConstants.au3>

;~ ;tc21
#include <ScreenCapture.au3>

;~ ;tc22
#include <String.au3>

;~ ;tc26
#include <EditConstants.au3>

;~ ;tc32
#include <TreeViewConstants.au3>

Global Const $fileName = @ScriptDir & "\_tcLogAppend.txt"
Global $logContent = ""
Global $BREAK_LOOP = False, $GuiHnd, $Timer
  
If $CmdLine[0] = 0 Then   
   Local $msg = '1. ' & @ProgramFilesDir & '\AutoIt3\Examples\calculator.au3' & @CRLF
   $msg = $msg & '2. ' & @ProgramFilesDir & '\AutoIt3\Examples\count-do.au3' & @CRLF
   $msg = $msg & '3. ' & @ProgramFilesDir & '\AutoIt3\Examples\count-for.au3' & @CRLF
   $msg = $msg & '4. ' & @ProgramFilesDir & '\AutoIt3\Examples\count-while.au3' & @CRLF
   $msg = $msg & '5. ' & @ProgramFilesDir & '\AutoIt3\Examples\functions.au3' & @CRLF
   $msg = $msg & '6. ' & @ProgramFilesDir & '\AutoIt3\Examples\inputbox.au3' & @CRLF
   $msg = $msg & '7. ' & @ProgramFilesDir & '\AutoIt3\Examples\msgbox.au3' & @CRLF
   $msg = $msg & '8. ' & @ProgramFilesDir & '\AutoIt3\Examples\notepad1.au3' & @CRLF
   $msg = $msg & '9. ' & @ProgramFilesDir & '\AutoIt3\Examples\notepad2.au3' & @CRLF
   $msg = $msg & '10. ' & @ProgramFilesDir & '\AutoIt3\Examples\GUI\Simple\child.au3' & @CRLF
   $msg = $msg & '11. ' & @ProgramFilesDir & '\AutoIt3\Examples\GUI\Simple\editbox.au3' & @CRLF
   $msg = $msg & '12. ' & @ProgramFilesDir & '\AutoIt3\Examples\GUI\Simple\msgbox_messageloop.au3' & @CRLF
   $msg = $msg & '13. ' & @ProgramFilesDir & '\AutoIt3\Examples\GUI\Simple\msgbox_onevent.au3' & @CRLF
   $msg = $msg & '14. ' & @ProgramFilesDir & '\AutoIt3\Examples\GUI\Advanced\_NamedPipes_Client.au3' & @CRLF
   $msg = $msg & '15. ' & @ProgramFilesDir & '\AutoIt3\Examples\GUI\Advanced\_NamedPipes_Server.au3' & @CRLF
   $msg = $msg & '16. ' & @ProgramFilesDir & '\AutoIt3\Examples\GUI\Advanced\AlphaBlend.au3' & @CRLF
   $msg = $msg & '17. ' & @ProgramFilesDir & '\AutoIt3\Examples\GUI\Advanced\BMPToJPG.au3' & @CRLF
   $msg = $msg & '18. ' & @ProgramFilesDir & '\AutoIt3\Examples\GUI\Advanced\Clock.au3' & @CRLF
   $msg = $msg & '19. ' & @ProgramFilesDir & '\AutoIt3\Examples\GUI\Advanced\contextmenu.au3' & @CRLF
   $msg = $msg & '20. ' & @ProgramFilesDir & '\AutoIt3\Examples\GUI\Advanced\dice.au3' & @CRLF
   $msg = $msg & '21. ' & @ProgramFilesDir & '\AutoIt3\Examples\GUI\Advanced\Emboss.au3' & @CRLF
   $msg = $msg & '22. ' & @ProgramFilesDir & '\AutoIt3\Examples\GUI\Advanced\encrypt.au3' & @CRLF
   $msg = $msg & '23. ' & @ProgramFilesDir & '\AutoIt3\Examples\GUI\Advanced\enumicons.au3' & @CRLF
   $msg = $msg & '24. ' & @ProgramFilesDir & '\AutoIt3\Examples\GUI\Advanced\imagebutton.au3' & @CRLF
   $msg = $msg & '25. ' & @ProgramFilesDir & '\AutoIt3\Examples\GUI\Advanced\menu.au3' & @CRLF
   $msg = $msg & '26. ' & @ProgramFilesDir & '\AutoIt3\Examples\GUI\Advanced\msgboxwizard.au3' & @CRLF
   $msg = $msg & '27. ' & @ProgramFilesDir & '\AutoIt3\Examples\GUI\Advanced\Rotate.au3' & @CRLF
   $msg = $msg & '28. ' & @ProgramFilesDir & '\AutoIt3\Examples\GUI\Advanced\setlabel.au3' & @CRLF
   $msg = $msg & '29. ' & @ProgramFilesDir & '\AutoIt3\Examples\GUI\Advanced\ShowPNG.au3' & @CRLF
   $msg = $msg & '30. ' & @ProgramFilesDir & '\AutoIt3\Examples\GUI\Advanced\Slicer.au3' & @CRLF
   $msg = $msg & '31. ' & @ProgramFilesDir & '\AutoIt3\Examples\GUI\Advanced\sysinfo.au3' & @CRLF
   $msg = $msg & '32. ' & @ProgramFilesDir & '\AutoIt3\Examples\GUI\Advanced\treeview.au3' & @CRLF
   $msg = $msg & '33. ' & @ProgramFilesDir & '\AutoIt3\Examples\GUI\Advanced\Zoom.au3' & @CRLF
   
   ConsoleWrite($msg)
   ;FileClose($file)
   Exit
   
ElseIf $CmdLine[1] = 1 Then
   ; Log test case name
   $logContent = "Log for test case 1 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   
   ;execute tc
   tc1()

ElseIf $CmdLine[1] = 2 Then
   ; Log test case name
   $logContent = "Log for test case 2 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   tc2()

ElseIf $CmdLine[1] = 3 Then
   ; Log test case name
   $logContent = "Log for test case 3 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   tc3()

ElseIf $CmdLine[1] = 4 Then
   ; Log test case name
   $logContent = "Log for test case 4 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   tc4()

ElseIf $CmdLine[1] = 5 Then
   ; Log test case name
   $logContent = "Log for test case 5 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   tc5()

ElseIf $CmdLine[1] = 6 Then
   ; Log test case name
   $logContent = "Log for test case 6 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   tc6()

ElseIf $CmdLine[1] = 7 Then
   ; Log test case name
   $logContent = "Log for test case 7 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   tc7()
   
ElseIf $CmdLine[1] = 8 Then
   ; Log test case name
   $logContent = "Log for test case 8 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   tc8()
   
ElseIf $CmdLine[1] = 9 Then
   ; Log test case name
   $logContent = "Log for test case 9 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   tc9()
   
ElseIf $CmdLine[1] = 10 Then
;~    #include <GUIConstantsEx.au3>
   
   ; Log test case name
   $logContent = "Log for test case 10 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   tc10()
   
ElseIf $CmdLine[1] = 11 Then
;~    #include <GUIConstantsEx.au3>
   
   ; Log test case name
   $logContent = "Log for test case 11 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   tc11()
   
ElseIf $CmdLine[1] = 12 Then
;~    #include <GUIConstantsEx.au3>
   
   ; Log test case name
   $logContent = "Log for test case 12 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   tc12()

ElseIf $CmdLine[1] = 13 Then
;~    #include <GUIConstantsEx.au3>
   
   ; Log test case name
   $logContent = "Log for test case 13 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   Global $ExitID
   Opt("GUIOnEventMode", 1)
   tc13()
   
ElseIf $CmdLine[1] = 14 Then
;~    #include <NamedPipes.au3>
;~    #include <WinAPI.au3>
;~    #include <WindowsConstants.au3>
;~    #include <StaticConstants.au3>
;~    #include <GuiConstantsEx.au3>

   ; Log test case name
   $logContent = "Log for test case 14 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   ; ===============================================================================================================================
   ; Description ...: This is the client side of the pipe demo
   ; Author ........: Paul Campbell (PaulIA)
   ; Notes .........:
   ; ===============================================================================================================================

   ; ===============================================================================================================================
   ; Global constants
   ; ===============================================================================================================================

   Global Const $BUFSIZE = 4096
   Global Const $DEFCMD = "cmd.exe /c dir c:\windows /s"
   Global Const $PIPE_NAME = "\\$\\pipe\\AutoIt3"
   Global Const $ERROR_MORE_DATA = 234

   ; ===============================================================================================================================
   ; Global variables
   ; ===============================================================================================================================

   Global $iEdit, $iMemo, $iSend, $iServer, $hPipe

   ; ===============================================================================================================================
   ; Main
   ; ===============================================================================================================================
   tc14()
   
ElseIf $CmdLine[1] = 15 Then
;~    #include <NamedPipes.au3>
;~    #include <WinAPI.au3>
;~    #include <WindowsConstants.au3>
;~    #include <GuiConstantsEx.au3>

   ; Log test case name
   $logContent = "Log for test case 15 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   ; ===============================================================================================================================
   ; Description ...: This is the server side of the pipe demo
   ; Author ........: Paul Campbell (PaulIA)
   ; Notes .........:
   ; ===============================================================================================================================

   ; ===============================================================================================================================
   ; Global constants
   ; ===============================================================================================================================

   Global Const $DEBUGGING = False
   Global Const $BUFSIZE = 4096
   Global Const $PIPE_NAME = "\\.\\pipe\\AutoIt3"
   Global Const $TIMEOUT = 5000
   Global Const $WAIT_TIMEOUT = 258
   Global Const $ERROR_IO_PENDING = 997
   Global Const $ERROR_PIPE_CONNECTED = 535

   ; ===============================================================================================================================
   ; Global variables
   ; ===============================================================================================================================

   Global $hEvent, $iMemo, $pOverlap, $tOverlap, $hPipe, $hReadPipe, $iState, $iToWrite

   ; ===============================================================================================================================
   ; Main
   ; ===============================================================================================================================
   tc15()

ElseIf $CmdLine[1] = 16 Then
;~    #include <GDIPlus.au3>
;~    #include <WinAPI.au3>
;~    #include <WindowsConstants.au3>
;~    #include <GuiConstantsEx.au3>

   ; Log test case name
   $logContent = "Log for test case 16 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   ; ===============================================================================================================================
   ; Description ...: Shows how to create an alpha blended form
   ; Author ........: Paul Campbell (PaulIA)
   ; Notes .........: The images used for this demo MUST be 32 bpp with alpha channel
   ; Credits .......: Thanks to lod3n for supplying links to the technical documentation that was necessary to build this demo
   ; ===============================================================================================================================

   ; ===============================================================================================================================
   ; Global constants
   ; ===============================================================================================================================
   Global Const $AC_SRC_ALPHA = 1

   ; ===============================================================================================================================
   ; Global variables
   ; ===============================================================================================================================
   Global $hGUI1, $hGUI2, $iLabel1, $iLabel2, $iSlider, $hImage
   
   tc16()

ElseIf $CmdLine[1] = 17 Then
;~    #include <GDIPlus.au3>
   
   ; Log test case name
   $logContent = "Log for test case 17 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   tc17()
   
ElseIf $CmdLine[1] = 18 Then
;~    #include <GDIPlus.au3>
;~    #include <WinAPI.au3>
;~    #include <GuiConstantsEx.au3>
;~    #include <WindowsConstants.au3>

   ; Log test case name
   $logContent = "Log for test case 18 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc   
   ; ===============================================================================================================================
   ; Description ...: Simple clock using layered windows
   ; Author ........: Paul Campbell (PaulIA)
   ; Notes .........:
   ; ===============================================================================================================================

   ; ===============================================================================================================================
   ; Global constants
   ; ===============================================================================================================================

   Global Const $iCenter = 200
   Global Const $iDotOpacity = 250
   Global Const $iHourRad = 140
   Global Const $iMinRad = 200
   Global Const $iOpacity = 128
   Global Const $nPI = 3.1415926535897932384626433832795
   Global Const $iRadius = 200
   Global Const $iSecRad = 200
   Global Const $iTickLen = 0.02

   Global Const $AC_SRC_ALPHA = 1

   Global Enum $eScrDC = 0, $eMemDC, $eBitmap, $eWidth, $eHeight, $eGraphic, $ePen, $eCap, $eBrush, $eFormat, $eFamily, $eFont, $eLayout, $eLast

   ; ===============================================================================================================================
   ; Global variables
   ; ===============================================================================================================================

   Global $hDial, $hTime, $hHour, $hMin, $hSec, $hDot, $aTime, $aHour, $aMin, $aSec, $aCurr[3][2], $aLast[3][2]

   ; ===============================================================================================================================
   ; Main
   ; ===============================================================================================================================
   tc18()

ElseIf $CmdLine[1] = 19 Then
;~    #include <GUIConstantsEx.au3>
   
   ; Log test case name
   $logContent = "Log for test case 19 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   tc19()
   
ElseIf $CmdLine[1] = 20 Then
;~    #include <GUIConstantsEx.au3>
;~    #include <ButtonConstants.au3>
;~    #include <StaticConstants.au3>

   ; Log test case name
   $logContent = "Log for test case 20 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   tc20()
   
ElseIf $CmdLine[1] = 21 Then
;~    #include <GDIPlus.au3>
;~    #include <ScreenCapture.au3>

   ; Log test case name
   $logContent = "Log for test case 21 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   tc21()
   
ElseIf $CmdLine[1] = 22 Then
;~    #include <GUIConstantsEx.au3>
;~    #include <String.au3>
   
   ; Log test case name
   $logContent = "Log for test case 22 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   tc22()
   
ElseIf $CmdLine[1] = 23 Then
;~    #include <GUIConstantsEx.au3>
;~    #include <WindowsConstants.au3>
;~    #include <ButtonConstants.au3>
;~    #include <StaticConstants.au3>

   ; Log test case name
   $logContent = "Log for test case 23 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   ; Setting variables
   Global $ahIcons[30], $ahLabels[30]
   Global $iStartIndex = 1, $iCntRow, $iCntCol, $iCurIndex
   Global $sFilename = @SystemDir & "\shell32.dll"; Default file is "shell32.dll"
   Global $iOrdinal = -1

   Global $hPrev
   ;main
   tc23()

ElseIf $CmdLine[1] = 24 Then
;~    #include <GUIConstantsEx.au3>
;~    #include <ButtonConstants.au3>

   ; Log test case name
   $logContent = "Log for test case 24 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   tc24()
   
ElseIf $CmdLine[1] = 25 Then
;~    #include <GUIConstantsEx.au3>
   
   ; Log test case name
   $logContent = "Log for test case 25 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   tc25()
   
ElseIf $CmdLine[1] = 26 Then
;~    #include <GUIConstantsEx.au3>
;~    #include <WindowsConstants.au3>
;~    #include <EditConstants.au3>

   ; Log test case name
   $logContent = "Log for test case 26 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   Global $iFlag, $Button, $msgbox, $asMsgText
   Global $optWarning, $optInfo, $optCritical, $optQuestion
   Global $optNoIcon, $optApplication, $optSysModal, $optTaskModal, $optOK
   Global $optOkCancel, $optYesNo, $optYesNoCancel, $optAbortRetryIgnore
   Global $optRetryCancel, $optCancelRetryContinue, $optNothing, $optTopMost
   Global $optRightJust, $optFirst, $optSecond, $optThird
   ;main
   tc26()
   
ElseIf $CmdLine[1] = 27 Then
;~    #include <GDIPlus.au3>
;~    #include <ScreenCapture.au3>

   ; Log test case name
   $logContent = "Log for test case 27 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   tc27()
   
ElseIf $CmdLine[1] = 28 Then
;~    #include <GuiConstantsEx.au3>
   
   ; Log test case name
   $logContent = "Log for test case 28 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   tc28()
   
ElseIf $CmdLine[1] = 29 Then
;~    #include <GDIPlus.au3>
;~    #include <GuiConstantsEx.au3>

   ; Log test case name
   $logContent = "Log for test case 29 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   tc29()
   
ElseIf $CmdLine[1] = 30 Then
;~    #include <GDIPlus.au3>
;~    #include <ScreenCapture.au3>
;~    #include <WinAPI.au3>
;~    #include <GuiConstantsEx.au3>

   ; Log test case name
   $logContent = "Log for test case 30 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   tc30()
   
ElseIf $CmdLine[1] = 31 Then
;~    #include <GuiConstantsEx.au3>
;~    #include <WindowsConstants.au3>

   ; Log test case name
   $logContent = "Log for test case 31 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   tc31()
   
ElseIf $CmdLine[1] = 32 Then
;~    #include <GUIConstantsEx.au3>
;~    #include <WindowsConstants.au3>
;~    #include <TreeViewConstants.au3>

   ; Log test case name
   $logContent = "Log for test case 32 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   tc32()
   
ElseIf $CmdLine[1] = 33 Then
;~    #include <GDIPlus.au3>
;~    #include <ScreenCapture.au3>
;~    #include <WinAPI.au3>
;~    #include <GuiConstantsEx.au3>

   ; Log test case name
   $logContent = "Log for test case 33 - " & _NowDate() & @CRLF & "-----start at " & _NowTime() & "-----" & @CRLF
   ;execute tc
   tc33()
   
EndIf

;write log file
Local $file = FileOpen($fileName, 2)

If $file = -1 Then
    MsgBox(0, "Error", "Unable to open file.", 4)
	ConsoleWrite("fail" & @CRLF)
    Exit
 EndIf

$logContent = $logContent & "-----finish at " & _NowTime() & "-----" & @CRLF & @CRLF
FileWrite($file, $logContent)
FileClose($file)
ConsoleWrite(@CRLF & "pass" & @CRLF)

Exit


#region "..\AutoIt3\Examples\calculator.au3"
;===========================================================
;..\AutoIt3\Examples\calculator.au3
;===========================================================
Func tc1 ()
;Local $answer = MsgBox(4, "AutoIt Example (English Only)", "This script will run the calculator and type in 2 x 4 x 8 x 16 and then quit.  Run?")

;
; AutoIt Version: 3.0
; Language:       English
; Platform:       Win9x/NT
; Author:         Jonathan Bennett (jon@hiddensoft.com)
;
; Script Function:
;   Plays with the calculator.
;

; Prompt the user to run the script - use a Yes/No prompt (4 - see help file)
Local $answer = MsgBox(4, "AutoIt Example (English Only)", "This script will run the calculator and type in 2 x 4 x 8 x 16 and then quit.  Run?", 2)

; Check the user's answer to the prompt (see the help file for MsgBox return values)
; If "No" was clicked (7) then exit the script
If $answer = 7 Then
	MsgBox(0, "AutoIt", "OK.  Bye!", 2)
	; Log what is typed for debugging 
   $logContent = $logContent & "User click on No button" & @CRLF
   Return
 EndIf

; Run the calculator
Run("calc.exe")

; Wait for the calulator become active - it is titled "Calculator" on English systems
WinWaitActive("Calculator")

; Now that the calc window is active type 2 x 4 x 8 x 16
; Use AutoItSetOption to slow down the typing speed so we can see it :)
AutoItSetOption("SendKeyDelay", 400)
Send("2*4*8*16=")
$logContent = $logContent & "Input: 2*4*8*16" & @CRLF
$logContent = $logContent & "Result: 1024" & @CRLF
Sleep(2000)

; Now quit by sending a "close" request to the calc
WinClose("Calculator")

; Now wait for calc to close before continuing
WinWaitClose("Calculator")

; Finished!
EndFunc
#endregion

#region "..\AutoIt3\Examples\count-do.au3"
;===========================================================
;..\AutoIt3\Examples\count-do.au3
;===========================================================
Func tc2()
; AutoIt Version: 3.0
; Language:       English
; Platform:       Win9x/NT
; Author:         Jonathan Bennett (jon at hiddensoft com)
;
; Script Function:
;   Counts to 5 using a "do" loop


; Prompt the user to run the script - use a Yes/No prompt (4 - see help file)
Local $answer = MsgBox(4, "AutoIt Example", "This script will count to 5 using a 'Do' loop.  Run?", 4)

; Check the user's answer to the prompt (see the help file for MsgBox return values)
; If "No" was clicked (7) then exit the script
If $answer = 7 Then
	MsgBox(0, "AutoIt Example", "OK.  Bye!", 2)
	$logContent = $logContent & "User click on No button" & @CRLF
	Return
EndIf


; Set the counter
Local $count = 1

; Execute the loop "until" the counter is greater than 5
Do
	; Print the count
	MsgBox(0, "AutoIt Example", "Count is: " & $count, 2)
	$logContent = $logContent & "Count is: " & $count & @CRLF

	; Increase the count by one
	$count = $count + 1

Until $count > 5

; Finished!
sgBox(0, "AutoIt Example", "Finished!", 2)

EndFunc
#endregion

#region "..\AutoIt3\Examples\count-for.au3"
;===========================================================
;..\AutoIt3\Examples\count-for.au3
;===========================================================
Func tc3 ()
; AutoIt Version: 3.0
; Language:       English
; Platform:       Win9x/NT
; Author:         Jonathan Bennett (jon at hiddensoft com)
;
; Script Function:
;   Counts to 5 using a "for" loop


; Prompt the user to run the script - use a Yes/No prompt (4 - see help file)
Local $answer = MsgBox(4, "AutoIt Example", "This script will count to 5 using a 'For' loop.  Run?",4)


; Check the user's answer to the prompt (see the help file for MsgBox return values)
; If "No" was clicked (7) then exit the script
If $answer = 7 Then
	MsgBox(0, "AutoIt Example", "OK.  Bye!",2)
	$logContent = $logContent & "User click on No button" & @CRLF
	Return
EndIf


; Execute the loop 5 times
For $count = 1 To 5
	; Print the count
	MsgBox(0, "AutoIt Example", "Count is: " & $count,2)
	$logContent = $logContent & "Count is: " & $count & @CRLF
Next


; Finished!
sgBox(0, "AutoIt Example", "Finished!",2)

EndFunc

#endregion

#region "..\AutoIt3\Examples\count-while.au3"
;===========================================================
;..\AutoIt3\Examples\count-while.au3
;===========================================================
Func tc4 ()
; AutoIt Version: 3.0
; Language:       English
; Platform:       Win9x/NT
; Author:         Jonathan Bennett (jon at hiddensoft com)
;
; Script Function:
;   Counts to 5 using a "while" loop


; Prompt the user to run the script - use a Yes/No prompt (4 - see help file)
Local $answer = MsgBox(4, "AutoIt Example", "This script will count to 5 using a 'While' loop.  Run?", 4)


; Check the user's answer to the prompt (see the help file for MsgBox return values)
; If "No" was clicked (7) then exit the script
If $answer = 7 Then
	MsgBox(0, "AutoIt Example", "OK.  Bye!", 2)
	$logContent = $logContent & "User click on No button" & @CRLF
	Return
EndIf


; Set the counter
Local $count = 0

; Execute the loop "While" the counter is less than 5
While $count < 5
	; Increase the count by one
	$count = $count + 1

	; Print the count
	MsgBox(0, "AutoIt Example", "Count is: " & $count, 2)
	$logContent = $logContent & "Count is: " & $count & @CRLF
WEnd

; Finished!
sgBox(0, "AutoIt Example", "Finished!", 2)

EndFunc

#endregion

#region "..\AutoIt3\Examples\functions.au3"
;===========================================================
;..\AutoIt3\Examples\functions.au3
;===========================================================
Func tc5 ()
   ;
; AutoIt Version: 3.0
; Language:       English
; Platform:       Win9x/NT
; Author:         Jonathan Bennett (jon@hiddensoft.com)
;
; Script Function:
;   Demo of using functions
;


; Prompt the user to run the script - use a Yes/No prompt (4 - see help file)
Local $answer = MsgBox(4, "AutoIt Example", "This script will call a couple of example functions.  Run?", 4)


; Check the user's answer to the prompt (see the help file for MsgBox return values)
; If "No" was clicked (7) then exit the script
If $answer = 7 Then
	MsgBox(0, "AutoIt", "OK.  Bye!", 2)
	$logContent = $logContent & "User click on No button" & @CRLF
	Return
EndIf


; Run TestFunc1
tc5_TestFunc1()
$logContent = $logContent & "Call TestFunc1 without parameter" & @CRLF

; Run TestFunc2
tc5_TestFunc2(20)
$logContent = $logContent & "Call TestFunc2 with parameter is 20" & @CRLF

; Finished!
sgBox(0, "AutoIt Example", "Finished!",2)
EndFunc

; TestFunc1
Func tc5_TestFunc1()
	MsgBox(0, "AutoIt Example", "Inside TestFunc1()", 2)
EndFunc   ;==>TestFunc1


; TestFunc2
Func tc5_TestFunc2($var)
	MsgBox(0, "AutoIt Example", "Inside TestFunc2() - $var is: " & $var, 2)
EndFunc   ;==>TestFunc2
 
#endregion

#region "..\AutoIt3\Examples\inputbox.au3"
;===========================================================
;..\AutoIt3\Examples\inputbox.au3
;===========================================================
Func tc6 ()
;
; AutoIt Version: 3.0
; Language:       English
; Platform:       Win9x/NT
; Author:         Jonathan Bennett (jon@hiddensoft.com)
;
; Script Function:
;   Demonstrates the InputBox, looping and the use of @error.
;

AutoItSetOption("SendKeyDelay", 100)

; Prompt the user to run the script - use a Yes/No prompt (4 - see help file)
Local $answer = MsgBox(4, "AutoIt Example (English Only)", "This script will open an input box and get you to type in some text.  Run?",4)

; Check the user's answer to the prompt (see the help file for MsgBox return values)
; If "No" was clicked (7) then exit the script
If $answer = 7 Then
	MsgBox(4096, "AutoIt", "OK.  Bye!",2)
	$logContent = $logContent & "User click on No button" & @CRLF
	Return
 EndIf
 
 Local $counter = 1
 Local $strVal = ""

; Loop around until the user gives a valid "autoit" answer
Local $bLoop = 1
While $bLoop = 1
   If $counter = 1 Then
	  $strVal = "autoscript"
   Else
	  $strVal = "autoit"
   EndIf
   
   Local $text = InputBox("AutoIt Example", "Please type in the word ""autoit"" and click OK", $strVal, "", -1, -1, 200, 200, 3)
   $logContent = $logContent & "User input: " & $text & @CRLF
   If @error = 1 Then
	  MsgBox(4096, "Error", "You pressed 'Cancel' - try again!", 2)
	  $logContent = $logContent & "User click on Cancel button" & @CRLF
   ElseIf @error = 2 Then
	  If $counter = 1 Then
		 $counter = 2
	  ElseIf $counter = 2 Then
		 $counter = 3
	  EndIf
	  If $strVal <> "autoit" Then
		 MsgBox(4096, "Error", "You typed in the wrong thing - try again!", 2)
		 $logContent = $logContent & "User typed in the wrong thing" & @CRLF
	  Else
		 $bLoop = 0 ; Exit the loop - ExitLoop would have been an alternative too :)
	  EndIf
   Else
	  ; They clicked OK, but did they type the right thing?
	  If $text <> "autoit" Then
		 MsgBox(4096, "Error", "You typed in the wrong thing - try again!", 2)
		 $logContent = $logContent & "User typed in the wrong thing" & @CRLF
	  Else
		 $bLoop = 0 ; Exit the loop - ExitLoop would have been an alternative too :)
	  EndIf
	EndIf
WEnd

; Print the success message
sgBox(4096, "AutoIt Example", "You typed in the correct word!  Congrats.", 2)
$logContent = $logContent & "User typed in the correct word" & @CRLF

; Finished!

EndFunc

#endregion

#region "..\AutoIt3\Examples\msgbox.au3"
;===========================================================
;..\AutoIt3\Examples\msgbox.au3
;===========================================================
Func tc7 ()
; AutoIt Version: 3.0
; Language:       English
; Platform:       Win9x/NT
; Author:         Jonathan Bennett (jon@hiddensoft.com)
;
; Script Function:
;   Demo of using multiple lines in a message box
;

; Use the @CRLF macro to do a newline in a MsgBox - it is similar to the \n in v2.64
sgBox(0, "AutoIt Example", "This is line 1" & @CRLF & "This is line 2" & @CRLF & "This is line 3", 4)
$logContent = $logContent & "the message splits 3 lines in message box" & @CRLF

EndFunc

#endregion

#region "..\AutoIt3\Examples\notepad1.au3"
;===========================================================
;..\AutoIt3\Examples\notepad1.au3
;===========================================================
Func tc8 ()
;
; AutoIt Version: 3.0
; Language:       English
; Platform:       Win9x/NT
; Author:         Jonathan Bennett (jon@hiddensoft.com)
;
; Script Function:
;   Opens Notepad, types in some text and then quits.
;


; Prompt the user to run the script - use a Yes/No prompt (4 - see help file)
Local $answer = MsgBox(4, "AutoIt Example (English Only)", "This script will run Notepad type in some text and then quit.  Run?", 4)


; Check the user's answer to the prompt (see the help file for MsgBox return values)
; If "No" was clicked (7) then exit the script
If $answer = 7 Then
	MsgBox(0, "AutoIt", "OK.  Bye!", 2)
	$logContent = $logContent & "User click on No button" & @CRLF
	Return
EndIf


; Run Notepad
Run("notepad.exe")


; Wait for the Notepad become active - it is titled "Untitled - Notepad" on English systems
WinWaitActive("[CLASS:Notepad]")


; Now that the Notepad window is active type some text
Send("Hello from Notepad.{ENTER}1 2 3 4 5 6 7 8 9 10{ENTER}")
Sleep(500)
Send("+{UP 2}")
Sleep(500)


; Now quit by pressing Alt-f and then x (File menu -> Exit)
Send("!f")
Send("x")


; Now a screen will pop up and ask to save the changes, the window is called
; "Notepad" and has some text "Yes" and "No"
WinWaitActive("Notepad")
Send("n")


; Now wait for Notepad to close before continuing
WinWaitClose("[CLASS:Notepad]")

$logContent = $logContent & "Program auto writes text: Hello from Notepad. New line: 1 2 3 4 5 6 7 8 9 10" & @CRLF

; Finished!

EndFunc

#endregion

#region "..\AutoIt3\Examples\notepad2.au3"
;===========================================================
;..\AutoIt3\Examples\notepad2.au3
;===========================================================
Func tc9 ()
;
; AutoIt Version: 3.0
; Language:       English
; Platform:       Win9x/NT
; Author:         Jonathan Bennett (jon@hiddensoft.com)
;
; Script Function:
;   Opens Notepad, types in some text and then quits.
;   The text typed shows two ways of Sending special
;   characters
;


; Prompt the user to run the script - use a Yes/No prompt (4 - see help file)
Local $answer = MsgBox(4, "AutoIt Example (English Only)", "This script will run Notepad type in some text and then quit.  Run?", 4)


; Check the user's answer to the prompt (see the help file for MsgBox return values)
; If "No" was clicked (7) then exit the script
If $answer = 7 Then
	MsgBox(0, "AutoIt", "OK.  Bye!", 2)
	$logContent = $logContent & "User click on No button" & @CRLF
	Return
EndIf


; Run Notepad
Run("notepad.exe")


; Wait for the Notepad become active - it is titled "Untitled - Notepad" on English systems
WinWaitActive("[CLASS:Notepad]")


; Now that the Notepad window is active type some special characters
Send("Sending some special characters:{ENTER 2}")

; Do it the first way
Send("First way: ")
Send("{!}{^}{+}{#}")
Send("{ENTER}")

; Do it the second way (RAW mode, notice the second parameter is 1)
Send("Second way: ")
Send("!^+#", 1)

Send("{ENTER}{ENTER}Finished")
Sleep(1000)

; Now quit by pressing Alt-f and then x (File menu -> Exit)
Send("!f")
Send("x")


; Now a screen will pop up and ask to save the changes, the window is called
; "Notepad" and has some text "Yes" and "No"
WinWaitActive("Notepad")
Send("n")


; Now wait for Notepad to close before continuing
WinWaitClose("[CLASS:Notepad]")

$logContent = $logContent & "Program auto writes some special characters: !^+#" & @CRLF

; Finished!

EndFunc

#endregion

#region "..\AutoIt3\Examples\GUI\Simple\child.au3"
;===========================================================
;..\AutoIt3\Examples\GUI\Simple\child.au3
;===========================================================
Func tc10 ()
   ;Initialize variables
	Local $GUIWidth = 250, $GUIHeight = 250
	Local $ParentWin, $ParentWin_Pos, $ChildWin, $msg

	;Create main/parent window
	$ParentWin = GUICreate("Parent GUI", $GUIWidth, $GUIHeight)
	;Save the position of the parent window
	$ParentWin_Pos = WinGetPos($ParentWin, "")
	;Show the parent window/Make the parent window visible
	GUISetState(@SW_SHOW)
	
	;set timeout of GUI
	$GuiHnd = $ParentWin
	$Timer = _Timer_SetTimer($GuiHnd, 5000, "tc10_Quit")
	
	;Create child window and add the parameter to make it the child of the parent window
	$ChildWin = GUICreate("Child GUI", $GUIWidth, $GUIHeight, $ParentWin_Pos[0] + 100, $ParentWin_Pos[1] + 100, -1, -1, $ParentWin)
	;Show the child window/Make the child window visible
	GUISetState(@SW_SHOW)

	;Switch to the parent window
	GUISwitch($ParentWin)

	;Loop until:
	;- user presses Esc when focused to the parent window
	;- user presses Alt+F4 when focused to the parent window
	;- user clicks the close button of the parent window
	While 1
		;After every loop check if the user clicked something in the GUI windows
		$msg = GUIGetMsg(1)
		Select
			;Check if user clicked on a close button of any of the 2 windows
			Case $msg[0] = $GUI_EVENT_CLOSE
				;Check if user clicked on the close button of the child window
				If $msg[1] = $ChildWin Then
					MsgBox(64, "Test", "Child GUI will now close.", 2)
					;Switch to the child window
					GUISwitch($ChildWin)
					;Destroy the child GUI including the controls
					GUIDelete()
					$logContent = $logContent & "User click on close icon of child form" & @CRLF
					_Timer_KillTimer($GuiHnd,$Timer)
					$Timer = _Timer_SetTimer($GuiHnd, 5000, "tc10_Quit")
					;Check if user clicked on the close button of the parent window
				ElseIf $msg[1] = $ParentWin Then
					MsgBox(64, "Test", "Parent GUI will now close.", 2)
					;Switch to the parent window
					GUISwitch($ParentWin)
					;Destroy the parent GUI including the controls
					GUIDelete()
					$logContent = $logContent & "User click on close icon of parent form" & @CRLF
					;Exit the script
					Return
				EndIf

		EndSelect

	WEnd
 EndFunc
 
 ;close parent form if timeout
 Func tc10_Quit($hWnd, $Msg, $iIDTimer, $dwTime)
   _Timer_KillTimer($hWnd,$iIDTimer)
   WinClose($hWnd)
   $logContent = $logContent & "Time out" & @CRLF
 EndFunc 

#endregion

#region "..\AutoIt3\Examples\GUI\Simple\editbox.au3"
;===========================================================
;..\AutoIt3\Examples\GUI\Simple\editbox.au3
;===========================================================
Func tc11 ()
;====================================================
;================= Example of a GUI =================
;====================================================
; AutoIt version: 3.0.103
; Language:       English
; Author:         "SlimShady"
;
; ----------------------------------------------------------------------------
; Script Start
; ----------------------------------------------------------------------------

   ;Initialize variables
	Local $GUIWidth = 300, $GUIHeight = 250
	Local $Edit_1, $OK_Btn, $Cancel_Btn, $msg

	#forceref $Edit_1

	;Create window
	$GuiHnd = GUICreate("New GUI", $GUIWidth, $GUIHeight)

	;Create an edit box with no text in it
	$Edit_1 = GUICtrlCreateEdit("", 10, 10, 280, 190)

	;Create an "OK" button
	$OK_Btn = GUICtrlCreateButton("OK", 75, 210, 70, 25)

	;Create a "CANCEL" button
	$Cancel_Btn = GUICtrlCreateButton("Cancel", 165, 210, 70, 25)

	;Show window/Make the window visible
	GUISetState(@SW_SHOW)
		
   Local $timerInit = TimerInit()
   Local $controlID = 1
   Local $elapseTime = 0
	
	While 1
	   $elapseTime = TimerDiff($timerInit)
   
	  If $elapseTime > 3000 Then
		 $timerInit = TimerInit()	  
		 If $controlID = 1 Then
			$controlID = 2
			ControlSetText($GuiHnd, "", $Edit_1, "auto populate text")
		 ElseIf $controlID = 2 Then
			$controlID = 3
			ControlClick($GuiHnd, "", $OK_Btn)
		 ElseIf $controlID = 3 Then
			$controlID = 4
			ControlClick($GuiHnd, "", $Cancel_Btn)
		 Else
			WinClose($GuiHnd)
		 EndIf
	  EndIf
	  
	  ;After every loop check if the user clicked something in the GUI window
	 $msg = GUIGetMsg()

	 Select

		 ;Check if user clicked on the close button
		 Case $msg = $GUI_EVENT_CLOSE
			 ;Destroy the GUI including the controls
			 GUIDelete()
			 $logContent = $logContent & "User click on close icon of form" & @CRLF
			 ;Exit the script
			 Return

			 ;Check if user clicked on the "OK" button
		 Case $msg = $OK_Btn
			 MsgBox(64, "New GUI", "You clicked on the OK button!", 2)
			 $logContent = $logContent & "User click on OK button" & @CRLF

			 ;Check if user clicked on the "CANCEL" button
		 Case $msg = $Cancel_Btn
			 MsgBox(64, "New GUI", "You clicked on the Cancel button!", 2)
			 $logContent = $logContent & "User click on Cancel button" & @CRLF
			 
		  Case $msg = $Edit_1

	 EndSelect
   WEnd

EndFunc

#endregion

#region "..\AutoIt3\Examples\GUI\Simple\msgbox_messageloop.au3"
;===========================================================
;..\AutoIt3\Examples\GUI\Simple\msgbox_messageloop.au3
;===========================================================
Func tc12 ()   
   Local $YesID, $NoID, $ExitID, $msg

	$GuiHnd = GUICreate("Custom Msgbox", 210, 80)

	GUICtrlCreateLabel("Please click a button!", 10, 10)
	$YesID = GUICtrlCreateButton("Yes", 10, 50, 50, 20)
	$NoID = GUICtrlCreateButton("No", 80, 50, 50, 20)
	$ExitID = GUICtrlCreateButton("Exit", 150, 50, 50, 20)

	GUISetState() ; display the GUI
	
	$timerInit = TimerInit()
	$elapseSecond = 0
	$controlID = 1

	Do
	  $elapseSecond = TimerDiff($timerInit)
	  If $elapseSecond > 5000 Then
		 $timerInit = TimerInit()
		 If $controlID = 1 Then
			ControlClick($GuiHnd, "", $YesID)
			$controlID = 2
		 ElseIf $controlID = 2 Then
			ControlClick($GuiHnd, "", $NoID)
			$controlID = 3
		 Else
			ControlClick($GuiHnd, "", $ExitID)
		 EndIf
	  EndIf
	   
		$msg = GUIGetMsg()

		Select
			Case $msg = $YesID
				MsgBox(0, "You clicked on", "Yes", 2)
				$logContent = $logContent & "User click on close Yes button" & @CRLF
				;_Timer_KillTimer($GuiHnd,$Timer)
				;$Timer = _Timer_SetTimer($GuiHnd, 5000, "tc12_Quit")
			Case $msg = $NoID
				MsgBox(0, "You clicked on", "No", 2)
				$logContent = $logContent & "User click on No button" & @CRLF
				;_Timer_KillTimer($GuiHnd,$Timer)
				;$Timer = _Timer_SetTimer($GuiHnd, 5000, "tc12_Quit")
			Case $msg = $ExitID
				MsgBox(0, "You clicked on", "Exit", 2)
				$logContent = $logContent & "User click on Exit button" & @CRLF
			Case $msg = $GUI_EVENT_CLOSE
				MsgBox(0, "You clicked on", "Close", 2)
				$logContent = $logContent & "User click on Close button" & @CRLF
		EndSelect
	 Until $msg = $GUI_EVENT_CLOSE Or $msg = $ExitID
 EndFunc
 
#endregion

#region "..\AutoIt3\Examples\GUI\Simple\msgbox_onevent.au3"
;===========================================================
;..\AutoIt3\Examples\GUI\Simple\msgbox_onevent.au3
;===========================================================
Func tc13 ()   
   Local $YesID, $NoID

	$GuiHnd = GUICreate("Custom Msgbox", 210, 80)

	GUICtrlCreateLabel("Please click a button!", 10, 10)
	$YesID = GUICtrlCreateButton("Yes", 10, 50, 50, 20)
	GUICtrlSetOnEvent($YesID, "tc13_OnYes")
	$NoID = GUICtrlCreateButton("No", 80, 50, 50, 20)
	GUICtrlSetOnEvent($NoID, "tc13_OnNo")
	$ExitID = GUICtrlCreateButton("Exit", 150, 50, 50, 20)
	GUICtrlSetOnEvent($ExitID, "tc13_OnExit")

	GUISetOnEvent($GUI_EVENT_CLOSE, "tc13_OnExit")

	GUISetState() ; display the GUI
	
	$timerInit = TimerInit()
	$elapseSecond = 0
	$controlID = 1
	
	While Not $BREAK_LOOP
	  $elapseSecond = TimerDiff($timerInit)
	  If $elapseSecond > 3000 Then
		 $timerInit = TimerInit()
		 If $controlID = 1 Then
			ControlClick($GuiHnd, "", $YesID)
			$controlID = 2
		 ElseIf $controlID = 2 Then
			ControlClick($GuiHnd, "", $NoID)
			$controlID = 3
		 Else
			ControlClick($GuiHnd, "", $ExitID)
		 EndIf
	  EndIf
		;ControlClick($GuiHnd, "", $ExitID)
	WEnd
 EndFunc
 
 ;--------------- Functions ---------------
Func tc13_OnYes()
	MsgBox(0, "You clicked on", "Yes", 2)
	$logContent = $logContent & "User click on Yes button" & @CRLF
	_Timer_KillTimer($GuiHnd,$Timer)
	$Timer = _Timer_SetTimer($GuiHnd, 5000, "tc13_Quit")
EndFunc   ;==>OnYes

Func tc13_OnNo()
	MsgBox(0, "You clicked on", "No", 2)
	$logContent = $logContent & "User click on No button" & @CRLF
	_Timer_KillTimer($GuiHnd,$Timer)
	$Timer = _Timer_SetTimer($GuiHnd, 5000, "tc13_Quit")
EndFunc   ;==>OnNo

Func tc13_OnExit()
	If @GUI_CtrlId = $ExitID Then
		MsgBox(0, "You clicked on", "Exit", 2)
		$logContent = $logContent & "User click on Exit button" & @CRLF
	Else
		MsgBox(0, "You clicked on", "Close", 2)
		$logContent = $logContent & "User click on Close button" & @CRLF
  EndIf
	 _Timer_KillTimer($GuiHnd,$Timer)
	 $BREAK_LOOP = True
	Return
 EndFunc   ;==>OnExit
 
 ;close form if timeout
 Func tc13_Quit($hWnd, $Msg, $iIDTimer, $dwTime)
   _Timer_KillTimer($hWnd,$iIDTimer)
   MsgBox(0, "Alert", "Time out", 2)
   $logContent = $logContent & "Time out" & @CRLF
   $BREAK_LOOP = True
   Return
 EndFunc 
 
#endregion

#region "..\AutoIt3\Examples\GUI\Advanced\_NamedPipes_Client.au3"
;===========================================================
;..\AutoIt3\Examples\GUI\Advanced\_NamedPipes_Client.au3
;===========================================================
Func tc14 ()
   tc14_CreateGUI()
   tc14_MsgLoop()
EndFunc

; ===============================================================================================================================
; Creates a GUI for the client
; ===============================================================================================================================
Func tc14_CreateGUI()
	Local $hGUI = GUICreate("Pipe Client", 500, 400, -1, -1, $WS_SIZEBOX)
	GUICtrlCreateLabel("Server:", 2, 14, 52, 20, $SS_RIGHT)
	$iServer = GUICtrlCreateEdit("<local>", 56, 10, 200, 20, $SS_LEFT)
	GUICtrlCreateLabel("Command:", 2, 36, 52, 20, $SS_RIGHT)
	$iEdit = GUICtrlCreateEdit($DEFCMD, 56, 32, 370, 20, $SS_LEFT)
	$iSend = GUICtrlCreateButton("Send", 430, 32, 60, 20)
	$iMemo = GUICtrlCreateEdit("", 0, 62, _WinAPI_GetClientWidth($hGUI), 332)
	GUICtrlSetFont($iMemo, 9, 400, 0, "Courier New")
	GUISetState()
	;set timeout of GUI
	$Timer = _Timer_SetTimer($hGUI, 5000, "tc14_Quit")
EndFunc   ;==>CreateGUI

; ===============================================================================================================================
; Logs an error message to the display
; ===============================================================================================================================
Func tc14_LogError($sMessage)
	$sMessage &= " (" & _WinAPI_GetLastErrorMessage() & ")"
	GUICtrlSetData($iMemo, GUICtrlRead($iMemo) & $sMessage & @CRLF)
EndFunc   ;==>LogError

; ===============================================================================================================================
; Logs a message to the display
; ===============================================================================================================================
Func tc14_LogMsg($sMessage)
	GUICtrlSetData($iMemo, GUICtrlRead($iMemo) & $sMessage & @CRLF)
EndFunc   ;==>LogMsg

; ===============================================================================================================================
; MsgLoop
; ===============================================================================================================================
Func tc14_MsgLoop()
	While True
		Switch GUIGetMsg()
			Case $iSend
				tc14_SendCmd()				
			Case $GUI_EVENT_CLOSE
				Return
		EndSwitch
	WEnd
EndFunc   ;==>MsgLoop

; ===============================================================================================================================
; This function opens a pipe to the server
; ===============================================================================================================================
Func tc14_OpenPipe()
	Local $sName, $sPipe
	; Get pipe handle
	$sName = GUICtrlRead($iServer)
	If $sName = "<local>" Then $sName = "."
	$sPipe = StringReplace($PIPE_NAME, "$", $sName)
	$hPipe = _WinAPI_CreateFile($sPipe, 2, 6)
	If $hPipe <> -1 Then 
	   $logContent = $logContent & "OpenPipe successful" & @CRLF
	   Return True
	EndIf
	
	tc14_LogError("OpenPipe failed")
	$logContent = $logContent & "OpenPipe failed" & @CRLF
	Return False
EndFunc   ;==>OpenPipe

; ===============================================================================================================================
; This function reads a message from the pipe
; ===============================================================================================================================
Func tc14_ReadMsg()
	Local $bSuccess, $iRead, $pBuffer, $tBuffer

	$tBuffer = DllStructCreate("char Text[4096]")
	$pBuffer = DllStructGetPtr($tBuffer)
	GUICtrlSetData($iMemo, "")
	While 1
		$bSuccess = _WinAPI_ReadFile($hPipe, $pBuffer, $BUFSIZE, $iRead, 0)
		If $iRead = 0 Then ExitLoop
		If Not $bSuccess Or (_WinAPI_GetLastError() = $ERROR_MORE_DATA) Then ExitLoop
		GUICtrlSetData($iMemo, StringLeft(DllStructGetData($tBuffer, "Text"), $iRead), 1)
	WEnd
EndFunc   ;==>ReadMsg

; ===============================================================================================================================
; This function sends a command to the server
; ===============================================================================================================================
Func tc14_SendCmd()
	If tc14_OpenPipe() Then
	   $logContent = $logContent & "Pipe read mode" & @CRLF
		tc14_SetReadMode()
		$logContent = $logContent & "Write messages" & @CRLF
		tc14_WriteMsg(GUICtrlRead($iEdit))		
		$logContent = $logContent & "Read messages" & @CRLF
		tc14_ReadMsg()		
		_WinAPI_CloseHandle($hPipe)
		$logContent = $logContent & "Close handle" & @CRLF
	EndIf
EndFunc   ;==>SendCmd

; ===============================================================================================================================
; This function sets the pipe read mode
; ===============================================================================================================================
Func tc14_SetReadMode()
	If Not _NamedPipes_SetNamedPipeHandleState($hPipe, 1, 0, 0, 0) Then
		tc14_LogError("SetReadMode: _NamedPipes_SetNamedPipeHandleState failed")
		$logContent = $logContent & "SetReadMode: _NamedPipes_SetNamedPipeHandleState failed" & @CRLF
	 EndIf
EndFunc   ;==>SetReadMode

; ===============================================================================================================================
; This function writes a message to the pipe
; ===============================================================================================================================
Func tc14_WriteMsg($sMessage)
	Local $iWritten, $iBuffer, $pBuffer, $tBuffer

	$iBuffer = StringLen($sMessage) + 1
	$tBuffer = DllStructCreate("char Text[" & $iBuffer & "]")
	$pBuffer = DllStructGetPtr($tBuffer)
	DllStructSetData($tBuffer, "Text", $sMessage)
	If Not _WinAPI_WriteFile($hPipe, $pBuffer, $iBuffer, $iWritten, 0) Then
		tc14_LogError("WriteMsg: _WinAPI_WriteFile failed")
		$logContent = $logContent & "WriteMsg: _WinAPI_WriteFile failed" & @CRLF
	EndIf
 EndFunc   ;==>WriteMsg
 
 ;close form if timeout
 Func tc14_Quit($hWnd, $Msg, $iIDTimer, $dwTime)
   _Timer_KillTimer($hWnd,$iIDTimer)
   MsgBox(0, "NamedPipes Client", "Time out", 2)
   $logContent = $logContent & "Time out" & @CRLF
   WinClose($hWnd)
EndFunc 

#endregion

#region "..\AutoIt3\Examples\GUI\Advanced\_NamedPipes_Server.au3"
;===========================================================
;..\AutoIt3\Examples\GUI\Advanced\_NamedPipes_Server.au3
;===========================================================
Func tc15 ()
   tc15_CreateGUI()
   tc15_InitPipe()
   tc15_MsgLoop()
EndFunc

; ===============================================================================================================================
; Creates a GUI for the server
; ===============================================================================================================================
Func tc15_CreateGUI()
	Local $hGUI

	$hGUI = GUICreate("Pipe Server", 500, 400, -1, -1, $WS_SIZEBOX)
	$iMemo = GUICtrlCreateEdit("", 0, 0, _WinAPI_GetClientWidth($hGUI), _WinAPI_GetClientHeight($hGUI))
	GUICtrlSetFont($iMemo, 9, 400, 0, "Courier New")
	GUISetState()
	;set timeout of GUI
	$Timer = _Timer_SetTimer($hGUI, 5000, "tc15_Quit")
EndFunc   ;==>CreateGUI

; ===============================================================================================================================
; This function creates an instance of a named pipe
; ===============================================================================================================================
Func tc15_InitPipe()
	; Create an event object for the instance
	$tOverlap = DllStructCreate($tagOVERLAPPED)
	$pOverlap = DllStructGetPtr($tOverlap)
	$hEvent = _WinAPI_CreateEvent()
	If $hEvent = 0 Then
		tc15_LogError("InitPipe ..........: API_CreateEvent failed")
		$logContent = $logContent & "InitPipe ..........: API_CreateEvent failed" & @CRLF
		Return
	EndIf
	DllStructSetData($tOverlap, "hEvent", $hEvent)

	; Create a named pipe
	$hPipe = _NamedPipes_CreateNamedPipe($PIPE_NAME, _ ; Pipe name
			2, _ ; The pipe is bi-directional
			2, _ ; Overlapped mode is enabled
			0, _ ; No security ACL flags
			1, _ ; Data is written to the pipe as a stream of messages
			1, _ ; Data is read from the pipe as a stream of messages
			0, _ ; Blocking mode is enabled
			1, _ ; Maximum number of instances
			$BUFSIZE, _ ; Output buffer size
			$BUFSIZE, _ ; Input buffer size
			$TIMEOUT, _ ; Client time out
			0) ; Default security attributes
	If $hPipe = -1 Then
		tc15_LogError("InitPipe ..........: _NamedPipes_CreateNamedPipe failed")
		$logContent = $logContent & "InitPipe ..........: _NamedPipes_CreateNamedPipe failed" & @CRLF
	Else
		; Connect pipe instance to client
		$logContent = $logContent & "Connect pipe instance to client" & @CRLF
		tc15_ConnectClient()
	EndIf
EndFunc   ;==>InitPipe

; ===============================================================================================================================
; This function loops waiting for a connection event or the GUI to close
; ===============================================================================================================================
Func tc15_MsgLoop()
	Local $iEvent

	Do
		$iEvent = _WinAPI_WaitForSingleObject($hEvent, 0)
		If $iEvent < 0 Then
			tc15_LogError("MsgLoop ...........: _WinAPI_WaitForSingleObject failed")
			$logContent = $logContent & "MsgLoop ...........: _WinAPI_WaitForSingleObject failed" & @CRLF
			Return
		EndIf
		If $iEvent = $WAIT_TIMEOUT Then ContinueLoop
		tc15_Debug("MsgLoop ...........: Instance signaled")
		$logContent = $logContent & "MsgLoop ...........: Instance signaled" & @CRLF

		Switch $iState
			Case 0
				tc15_CheckConnect()
			Case 1
				tc15_ReadRequest()
			Case 2
				tc15_CheckPending()
			Case 3
				tc15_RelayOutput()
		EndSwitch
	Until GUIGetMsg() = $GUI_EVENT_CLOSE
EndFunc   ;==>MsgLoop

; ===============================================================================================================================
; Checks to see if the pending client connection has finished
; ===============================================================================================================================
Func tc15_CheckConnect()
	Local $iBytes

	; Was the operation successful?
	If Not _WinAPI_GetOverlappedResult($hPipe, $pOverlap, $iBytes, False) Then
		tc15_LogError("CheckConnect ......: Connection failed")
		$logContent = $logContent & "CheckConnect ......: Connection failed" & @CRLF
		tc15_ReconnectClient()
	Else
		tc15_LogMsg("CheckConnect ......: Connected")
		$logContent = $logContent & "CheckConnect ......: Connected" & @CRLF
		$iState = 1
	EndIf
EndFunc   ;==>CheckConnect

; ===============================================================================================================================
; This function reads a request message from the client
; ===============================================================================================================================
Func tc15_ReadRequest()
	Local $pBuffer, $tBuffer, $iRead, $bSuccess

	$tBuffer = DllStructCreate("char Text[" & $BUFSIZE & "]")
	$pBuffer = DllStructGetPtr($tBuffer)
	$bSuccess = _WinAPI_ReadFile($hPipe, $pBuffer, $BUFSIZE, $iRead, $pOverlap)

	If $bSuccess And ($iRead <> 0) Then
		; The read operation completed successfully
		tc15_Debug("ReadRequest .......: Read success")
		$logContent = $logContent & "ReadRequest .......: Read success" & @CRLF
	Else
		; Wait for read Buffer to complete
		If Not _WinAPI_GetOverlappedResult($hPipe, $pOverlap, $iRead, True) Then
			tc15_LogError("ReadRequest .......: _WinAPI_GetOverlappedResult failed")
			$logContent = $logContent & "ReadRequest .......: _WinAPI_GetOverlappedResult failed" & @CRLF
			tc15_ReconnectClient()
			Return
		Else
			; Read the command from the pipe
			$bSuccess = _WinAPI_ReadFile($hPipe, $pBuffer, $BUFSIZE, $iRead, $pOverlap)
			If Not $bSuccess Or ($iRead = 0) Then
				tc15_LogError("ReadRequest .......: _WinAPI_ReadFile failed")
				$logContent = $logContent & "ReadRequest .......: _WinAPI_ReadFile failed" & @CRLF
				tc15_ReconnectClient()
				Return
			EndIf
		EndIf
	EndIf

	; Execute the console command
	If Not tc15_ExecuteCmd(DllStructGetData($tBuffer, "Text")) Then
		tc15_ReconnectClient()
		Return
	EndIf

	; Relay console output back to the client
	$iState = 3
EndFunc   ;==>ReadRequest

; ===============================================================================================================================
; This function relays the console output back to the client
; ===============================================================================================================================
Func tc15_CheckPending()
	Local $bSuccess, $iWritten

	$bSuccess = _WinAPI_GetOverlappedResult($hPipe, $pOverlap, $iWritten, False)
	If Not $bSuccess Or ($iWritten <> $iToWrite) Then
		tc15_Debug("CheckPending ......: Write reconnecting")
		$logContent = $logContent & "CheckPending ......: Write reconnecting" & @CRLF
		tc15_ReconnectClient()
	Else
		tc15_Debug("CheckPending ......: Write complete")
		$logContent = $logContent & "CheckPending ......: Write complete" & @CRLF
		$iState = 3
	EndIf
EndFunc   ;==>CheckPending

; ===============================================================================================================================
; This function relays the console output back to the client
; ===============================================================================================================================
Func tc15_RelayOutput()
	Local $pBuffer, $tBuffer, $sLine, $iRead, $bSuccess, $iWritten

	$tBuffer = DllStructCreate("char Text[" & $BUFSIZE & "]")
	$pBuffer = DllStructGetPtr($tBuffer)
	; Read data from console pipe
	_WinAPI_ReadFile($hReadPipe, $pBuffer, $BUFSIZE, $iRead)
	If $iRead = 0 Then
		tc15_LogMsg("RelayOutput .......: Write done")
		$logContent = $logContent & "RelayOutput .......: Write done" & @CRLF
		_WinAPI_CloseHandle($hReadPipe)
		_WinAPI_FlushFileBuffers($hPipe)
		tc15_ReconnectClient()
		Return
	EndIf

	; Get the data and strip out the extra carriage returns
	$sLine = StringLeft(DllStructGetData($tBuffer, "Text"), $iRead)
	$sLine = StringReplace($sLine, @CR & @CR, @CR)
	$iToWrite = StringLen($sLine)
	DllStructSetData($tBuffer, "Text", $sLine)
	; Relay the data back to the client
	$bSuccess = _WinAPI_WriteFile($hPipe, $pBuffer, $iToWrite, $iWritten, $pOverlap)
	If $bSuccess And ($iWritten = $iToWrite) Then
		tc15_Debug("RelayOutput .......: Write success")
		$logContent = $logContent & "RelayOutput .......: Write success" & @CRLF
	Else
		If Not $bSuccess And (_WinAPI_GetLastError() = $ERROR_IO_PENDING) Then
			tc15_Debug("RelayOutput .......: Write pending")
			$logContent = $logContent & "RelayOutput .......: Write pending" & @CRLF
			$iState = 2
		Else
			; An error occurred, disconnect from the client
			tc15_LogError("RelayOutput .......: Write failed")
			$logContent = $logContent & "RelayOutput .......: Write failed" & @CRLF
			tc15_ReconnectClient()
		EndIf
	EndIf
EndFunc   ;==>RelayOutput

; ===============================================================================================================================
; This function is called to start an overlapped connection operation
; ===============================================================================================================================
Func tc15_ConnectClient()
	$iState = 0
	; Start an overlapped connection
	If _NamedPipes_ConnectNamedPipe($hPipe, $pOverlap) Then
		tc15_LogError("ConnectClient .....: ConnectNamedPipe 1 failed")
		$logContent = $logContent & "ConnectClient .....: ConnectNamedPipe 1 failed" & @CRLF
	Else
		Switch @error
			; The overlapped connection is in progress
			Case $ERROR_IO_PENDING
				tc15_Debug("ConnectClient .....: Pending")
				$logContent = $logContent & "ConnectClient .....: Pending" & @CRLF
				; Client is already connected, so signal an event
			Case $ERROR_PIPE_CONNECTED
				tc15_LogMsg("ConnectClient .....: Connected")
				$logContent = $logContent & "ConnectClient .....: Connected" & @CRLF
				$iState = 1
				If Not _WinAPI_SetEvent(DllStructGetData($tOverlap, "hEvent")) Then
					tc15_LogError("ConnectClient .....: SetEvent failed")
					$logContent = $logContent & "ConnectClient .....: SetEvent failed" & @CRLF
				EndIf
				; Error occurred during the connection event
			Case Else
				tc15_LogError("ConnectClient .....: ConnectNamedPipe 2 failed")
				$logContent = $logContent & "ConnectClient .....: ConnectNamedPipe 2 failed" & @CRLF
		EndSwitch
	EndIf
EndFunc   ;==>ConnectClient

; ===============================================================================================================================
; Dumps debug information to the screen
; ===============================================================================================================================
Func tc15_Debug($sMessage)
	If $DEBUGGING Then tc15_LogMsg($sMessage)
EndFunc   ;==>Debug

; ===============================================================================================================================
; Executes a command and returns the results
; ===============================================================================================================================
Func tc15_ExecuteCmd($sCmd)
	Local $tProcess, $tSecurity, $tStartup, $hWritePipe

	; Set up security attributes
	$tSecurity = DllStructCreate($tagSECURITY_ATTRIBUTES)
	DllStructSetData($tSecurity, "Length", DllStructGetSize($tSecurity))
	DllStructSetData($tSecurity, "InheritHandle", True)

	; Create a pipe for the child process's STDOUT
	If Not _NamedPipes_CreatePipe($hReadPipe, $hWritePipe, $tSecurity) Then
		tc15_LogError("ExecuteCmd ........: _NamedPipes_CreatePipe failed")
		$logContent = $logContent & "ExecuteCmd ........: _NamedPipes_CreatePipe failed" & @CRLF
		Return False
	EndIf

	; Create child process
	$tProcess = DllStructCreate($tagPROCESS_INFORMATION)
	$tStartup = DllStructCreate($tagSTARTUPINFO)
	DllStructSetData($tStartup, "Size", DllStructGetSize($tStartup))
	DllStructSetData($tStartup, "Flags", BitOR($STARTF_USESTDHANDLES, $STARTF_USESHOWWINDOW))
	DllStructSetData($tStartup, "StdOutput", $hWritePipe)
	DllStructSetData($tStartup, "StdError", $hWritePipe)
	If Not _WinAPI_CreateProcess("", $sCmd, 0, 0, True, 0, 0, "", DllStructGetPtr($tStartup), DllStructGetPtr($tProcess)) Then
		tc15_LogError("ExecuteCmd ........: _WinAPI_CreateProcess failed")
		$logContent = $logContent & "ExecuteCmd ........: _WinAPI_CreateProcess failed" & @CRLF
		_WinAPI_CloseHandle($hReadPipe)
		_WinAPI_CloseHandle($hWritePipe)
		Return False
	EndIf
	_WinAPI_CloseHandle(DllStructGetData($tProcess, "hProcess"))
	_WinAPI_CloseHandle(DllStructGetData($tProcess, "hThread"))

	; Close the write end of the pipe so that we can read from the read end
	_WinAPI_CloseHandle($hWritePipe)

	tc15_LogMsg("ExecuteCommand ....: " & $sCmd)
	$logContent = $logContent & "ExecuteCommand ....: " & $sCmd & @CRLF
	Return True
EndFunc   ;==>ExecuteCmd

; ===============================================================================================================================
; Logs an error message to the display
; ===============================================================================================================================
Func tc15_LogError($sMessage)
	$sMessage &= " (" & _WinAPI_GetLastErrorMessage() & ")"
	ConsoleWrite($sMessage & @LF)
EndFunc   ;==>LogError

; ===============================================================================================================================
; Logs a message to the display
; ===============================================================================================================================
Func tc15_LogMsg($sMessage)
	GUICtrlSetData($iMemo, $sMessage & @CRLF, 1)
EndFunc   ;==>LogMsg

; ===============================================================================================================================
; This function is called when an error occurs or when the client closes its handle to the pipe
; ===============================================================================================================================
Func tc15_ReconnectClient()
	; Disconnect the pipe instance
	If Not _NamedPipes_DisconnectNamedPipe($hPipe) Then
		tc15_LogError("ReconnectClient ...: DisonnectNamedPipe failed")
		$logContent = $logContent & "ReconnectClient ...: DisonnectNamedPipe failed" & @CRLF
		Return
	EndIf

	; Connect to a new client
	tc15_ConnectClient()
 EndFunc   ;==>ReconnectClient
 
 ;close form if timeout
 Func tc15_Quit($hWnd, $Msg, $iIDTimer, $dwTime)
   _Timer_KillTimer($hWnd,$iIDTimer)
   MsgBox(0, "NamedPipes Server", "Time out", 2)
   $logContent = $logContent & "Time out" & @CRLF
   WinClose($hWnd)
EndFunc 

#endregion

#region "..\AutoIt3\Examples\GUI\Advanced\AlphaBlend.au3"
;===========================================================
;..\AutoIt3\Examples\GUI\Advanced\AlphaBlend.au3
;===========================================================
Func tc16 ()
   ; Create GUI
   $hGUI1 = GUICreate("Alpha Blend", 400, 100)
   $iLabel1 = GUICtrlCreateLabel("Adjust slider to change opacity level: (0-255)", 84, 10, 380, 20)
   $iSlider = GUICtrlCreateSlider(10, 32, 380, 40)
   $iLabel2 = GUICtrlCreateLabel("Drag the layered window around your desktop", 80, 74, 380, 20)
   GUICtrlSetLimit($iSlider, 255, 0)
   GUICtrlSetData($iSlider, 255)
   GUISetState()
      
   ; Create layered child window
   $hGUI2 = GUICreate("Test", 250, 250, -1, -1, -1, $WS_EX_LAYERED, $hGUI1)

   ; Load layered image
   _GDIPlus_Startup()
   $logContent = $logContent & "Loading image from " & @ScriptDir & "\Images\Button.png" & @CRLF
   $hImage = _GDIPlus_ImageLoadFromFile(@ScriptDir & "\Images\Button.png")
   ;~ $hImage = _GDIPlus_ImageLoadFromFile(@ScriptDir & "\Images\Torus.png")
   tc16_SetBitMap($hGUI2, $hImage, 255)
   GUISetState()

   ; Register notification messages
   GUIRegisterMsg($WM_HSCROLL, "tc16_WM_HSCROLL")
   GUIRegisterMsg($WM_NCHITTEST, "tc16_WM_NCHITTEST")
   
   Sleep(2000)
   GUICtrlSetData($iSlider, 50)
   _SendMessage($hGUI1, $WM_HSCROLL, -1, -1)
   $logContent = $logContent & "Slider's value is 50" & @CRLF
   
   Sleep(2000)
   GUICtrlSetData($iSlider, 150)
   _SendMessage($hGUI1, $WM_HSCROLL, -1, -1)
   $logContent = $logContent & "Slider's value is 150" & @CRLF
   
   Sleep(2000)
   WinMove($hGUI2, "", 100, 100)
   $logContent = $logContent & "Child window location is X:100, Y:100" & @CRLF
   
   Sleep(1000)

   ; Loop until user exits
;~    Do
;~    Until GUIGetMsg() = $GUI_EVENT_CLOSE

   ; Release resources
   _GDIPlus_ImageDispose($hImage)
   _GDIPlus_Shutdown()
EndFunc

; ===============================================================================================================================
; Handle the WM_HSCROLL notificaton so that we can change the opacity in real time
; ===============================================================================================================================
Func tc16_WM_HSCROLL($hWnd, $iMsg, $iwParam, $ilParam)
	#forceref $hWnd, $iMsg, $iwParam, $ilParam
	tc16_SetBitMap($hGUI2, $hImage, GUICtrlRead($iSlider))
	$logContent = $logContent & "Change opacity of buttons" &  @CRLF
EndFunc   ;==>WM_HSCROLL

; ===============================================================================================================================
; Handle the WM_NCHITTEST for the layered window so it can be dragged by clicking anywhere on the image.
; ===============================================================================================================================
Func tc16_WM_NCHITTEST($hWnd, $iMsg, $iwParam, $ilParam)
	#forceref $hWnd, $iMsg, $iwParam, $ilParam
	If ($hWnd = $hGUI2) And ($iMsg = $WM_NCHITTEST) Then Return $HTCAPTION
	   $logContent = $logContent & "Change position of form" &  @CRLF
EndFunc   ;==>WM_NCHITTEST

; ===============================================================================================================================
; SetBitMap
; ===============================================================================================================================
Func tc16_SetBitmap($hGUI, $hImage, $iOpacity)
	Local $hScrDC, $hMemDC, $hBitmap, $hOld, $pSize, $tSize, $pSource, $tSource, $pBlend, $tBlend

	$hScrDC = _WinAPI_GetDC(0)
	$hMemDC = _WinAPI_CreateCompatibleDC($hScrDC)
	$hBitmap = _GDIPlus_BitmapCreateHBITMAPFromBitmap($hImage)
	$hOld = _WinAPI_SelectObject($hMemDC, $hBitmap)
	$tSize = DllStructCreate($tagSIZE)
	$pSize = DllStructGetPtr($tSize)
	DllStructSetData($tSize, "X", _GDIPlus_ImageGetWidth($hImage))
	DllStructSetData($tSize, "Y", _GDIPlus_ImageGetHeight($hImage))
	$tSource = DllStructCreate($tagPOINT)
	$pSource = DllStructGetPtr($tSource)
	$tBlend = DllStructCreate($tagBLENDFUNCTION)
	$pBlend = DllStructGetPtr($tBlend)
	DllStructSetData($tBlend, "Alpha", $iOpacity)
	DllStructSetData($tBlend, "Format", $AC_SRC_ALPHA)
	_WinAPI_UpdateLayeredWindow($hGUI, $hScrDC, 0, $pSize, $hMemDC, $pSource, 0, $pBlend, $ULW_ALPHA)
	_WinAPI_ReleaseDC(0, $hScrDC)
	_WinAPI_SelectObject($hMemDC, $hOld)
	_WinAPI_DeleteObject($hBitmap)
	_WinAPI_DeleteDC($hMemDC)
 EndFunc   ;==>SetBitmap
 
 ;close form if timeout
 Func tc16_Quit($hWnd, $Msg, $iIDTimer, $dwTime)
   _Timer_KillTimer($hWnd,$iIDTimer)
   MsgBox(0, "AlphaBlend", "Time out", 2)
   WinClose($hWnd)
   $logContent = $logContent & "Timeout" & @CRLF
EndFunc

#endregion

#region "..\AutoIt3\Examples\GUI\Advanced\BMPToJPG.au3"
;===========================================================
;..\AutoIt3\Examples\GUI\Advanced\BMPToJPG.au3
;===========================================================
Func tc17 ()
; ===============================================================================================================================
; Description ...: Shows how to convert a BMP file to JPG
; Author ........: Paul Campbell (PaulIA)
; Notes .........:
; ===============================================================================================================================

; ===============================================================================================================================
; Global variables
; ===============================================================================================================================
Global $sImage, $hImage, $sCLSID

; Get BMP file to convert
$sImage = InputBox("BMP to JPG", "Enter File Name:", @ScriptDir & "\Images\Red.bmp", "", 200, 130, 200, 200, 3)
If @error Then
   $sImage = @ScriptDir & "\Images\Red.bmp"
EndIf

If Not FileExists($sImage) Then
   MsgBox(0, "BMP to JPG", "File does not exist.", 3)
   $logContent = $logContent & "File not exist" & @CRLF
   Return
EndIf

$logContent = $logContent & "Loading image from " & @ScriptDir & "\Images\Red.bmp" & @CRLF
sgBox(0, "BMP to JPG", "bmp image is loading...", 3)
; Initialize GDI+ library
_GDIPlus_Startup()

; Load image
$hImage = _GDIPlus_ImageLoadFromFile($sImage)

; Get JPG encoder CLSID
$sCLSID = _GDIPlus_EncodersGetCLSID("JPG")

; Save image as JPG
$logContent = $logContent & "Save image as " & @ScriptDir & "\Images\AutoItImage.jpg" & @CRLF
sgBox(0, "BMP to JPG", "bmp image loaded. Converting bmp to jpg image...", 3)
_GDIPlus_ImageSaveToFileEx($hImage, @ScriptDir & "\Images\AutoItImage.jpg", $sCLSID)

sgBox(0, "BMP to JPG", "the bmp image has converted to jpg image.", 3)
; Shut down GDI+ library
_GDIPlus_Shutdown()
EndFunc

#endregion

#region "..\AutoIt3\Examples\GUI\Advanced\Clock.au3"
;===========================================================
;..\AutoIt3\Examples\GUI\Advanced\Clock.au3
;===========================================================
Func tc18 ()
$logContent = $logContent & "Initial clock" & @CRLF
tc18_ClockInit()
$logContent = $logContent & "Draw dial" & @CRLF
tc18_DialDraw()
$logContent = $logContent & "Draw clock" & @CRLF
tc18_Draw()
$logContent = $logContent & "Draw dot" & @CRLF
tc18_DotDraw()
$logContent = $logContent & "Run clock" & @CRLF
tc18_ClockLoop()
$logContent = $logContent & "Terminate clock" & @CRLF
tc18_ClockDone()
EndFunc

; ===============================================================================================================================
; Finalize clock
; ===============================================================================================================================
Func tc18_ClockDone()
	; Finalize GDI+ resources
	tc18_TimeDone()
	tc18_HourDone()
	tc18_MinDone()
	tc18_SecDone()

	; Finalize GDI+ library
	_GDIPlus_Shutdown()
EndFunc   ;==>ClockDone

; ===============================================================================================================================
; Initialize clock
; ===============================================================================================================================
Func tc18_ClockInit()
	Local $iX, $iY

	; Calculate the dial frame caption size
	$iX = -(_WinAPI_GetSystemMetrics($SM_CXFRAME))
	$iY = -(_WinAPI_GetSystemMetrics($SM_CYCAPTION) + _WinAPI_GetSystemMetrics($SM_CYFRAME))

	; Allocate the window resources
	$hDial = GUICreate("Clock", $iRadius * 2, $iRadius * 2, -1, -1, 0, BitOR($WS_EX_LAYERED, $WS_EX_TOPMOST))
	GUISetState()
	$hTime = GUICreate("Time", $iRadius * 2, $iRadius * 2, $iX, $iY, 0, BitOR($WS_EX_LAYERED, $WS_EX_MDICHILD), $hDial)
	GUISetState()
	$hHour = GUICreate("Hour", $iRadius * 2, $iRadius * 2, $iX, $iY, 0, BitOR($WS_EX_LAYERED, $WS_EX_MDICHILD), $hDial)
	GUISetState()
	$hMin = GUICreate("Min", $iRadius * 2, $iRadius * 2, $iX, $iY, 0, BitOR($WS_EX_LAYERED, $WS_EX_MDICHILD), $hDial)
	GUISetState()
	$hSec = GUICreate("Sec", $iRadius * 2, $iRadius * 2, $iX, $iY, 0, BitOR($WS_EX_LAYERED, $WS_EX_MDICHILD), $hDial)
	GUISetState()
	$hDot = GUICreate("Dot", $iRadius * 2, $iRadius * 2, $iX, $iY, 0, BitOR($WS_EX_LAYERED, $WS_EX_MDICHILD), $hDial)
	GUISetState()
	
	$Timer = _Timer_SetTimer($hDial, 5000, "tc18_Quit")

	; Initialize GDI+ library
	_GDIPlus_Startup()

	; Initialize GDI+ resources
	tc18_TimeInit()
	tc18_HourInit()
	tc18_MinInit()
	tc18_SecInit()

	; Hook non client hit test message so we can move the clock
	GUIRegisterMsg($WM_NCHITTEST, "tc18_WM_NCHITTEST")
EndFunc   ;==>ClockInit

; ===============================================================================================================================
; Loop until user exits
; ===============================================================================================================================
Func tc18_ClockLoop()
	Do
		tc18_Draw()
	Until GUIGetMsg() = $GUI_EVENT_CLOSE
EndFunc   ;==>ClockLoop

; ===============================================================================================================================
; Draw the center dot
; ===============================================================================================================================
Func tc18_DotDraw()
	Local $aDot

	$aDot = tc18_ResourceInit($iRadius * 2, $iRadius * 2)
	_GDIPlus_GraphicsFillEllipse($aDot[$eGraphic], $iRadius - 10, $iRadius - 10, 20, 20)
	tc18_ResourceSet($hDot, $aDot, $iDotOpacity)
	tc18_ResourceDone($aDot)
EndFunc   ;==>DotDraw

; ===============================================================================================================================
; Draw the clock elements
; ===============================================================================================================================
Func tc18_Draw()
	; Calculate current time element position
	$aLast = $aCurr
	$aCurr[0][0] = $iCenter + Cos(tc18_TimeToRadians("sec")) * $iSecRad
	$aCurr[0][1] = $iCenter - Sin(tc18_TimeToRadians("sec")) * $iSecRad
	$aCurr[1][0] = $iCenter + Cos(tc18_TimeToRadians("min")) * $iMinRad
	$aCurr[1][1] = $iCenter - Sin(tc18_TimeToRadians("min")) * $iMinRad
	$aCurr[2][0] = $iCenter + Cos(tc18_TimeToRadians("hour")) * $iHourRad
	$aCurr[2][1] = $iCenter - Sin(tc18_TimeToRadians("hour")) * $iHourRad

	; Draw time elements
	tc18_TimeDraw()
	tc18_HourDraw()
	tc18_MinDraw()
	tc18_SecDraw()
EndFunc   ;==>Draw

; ===============================================================================================================================
; Draw the clock dial
; ===============================================================================================================================
Func tc18_DialDraw()
	Local $aDial, $hPen1, $hPen2, $iI, $iN, $iX1, $iY1, $iX2, $iY2

	$aDial = tc18_ResourceInit($iRadius * 2, $iRadius * 2)
	$hPen1 = _GDIPlus_PenCreate()
	$hPen2 = _GDIPlus_PenCreate(0xFF0000FF, 4)
	For $iI = 0 To 2 * $nPI Step $nPI / 30
		$iX1 = $iCenter + Cos($iI) * ($iRadius * (1.00 - $iTickLen))
		$iY1 = $iCenter - Sin($iI) * ($iRadius * (1.00 - $iTickLen))
		$iX2 = $iCenter + Cos($iI) * $iRadius
		$iY2 = $iCenter - Sin($iI) * $iRadius
		If Mod($iN, 5) = 0 Then
			_GDIPlus_GraphicsDrawLine($aDial[$eGraphic], $iX1, $iY1, $iX2, $iY2, $hPen2)
		Else
			_GDIPlus_GraphicsDrawLine($aDial[$eGraphic], $iX1, $iY1, $iX2, $iY2, $hPen1)
		EndIf
		$iN += 1
	Next
	_GDIPlus_PenDispose($hPen2)
	_GDIPlus_PenDispose($hPen1)

	tc18_ResourceSet($hDial, $aDial)
	tc18_ResourceDone($aDial)
EndFunc   ;==>DialDraw

; ===============================================================================================================================
; Finalize resources for the hour hand
; ===============================================================================================================================
Func tc18_HourDone()
	_GDIPlus_PenDispose($aHour[$ePen])
	_GDIPlus_ArrowCapDispose($aHour[$eCap])
	tc18_ResourceDone($aHour)
EndFunc   ;==>HourDone

; ===============================================================================================================================
; Draw the hour hand
; ===============================================================================================================================
Func tc18_HourDraw()
	If ($aLast[2][0] = $aCurr[2][0]) And ($aLast[2][1] = $aCurr[2][1]) Then Return
	_GDIPlus_GraphicsDrawLine($aHour[$eGraphic], $iCenter, $iCenter, $aCurr[2][0], $aCurr[2][1], $aHour[$ePen])
	tc18_ResourceSet($hHour, $aHour)
EndFunc   ;==>HourDraw

; ===============================================================================================================================
; Initialize resources for the hour hand
; ===============================================================================================================================
Func tc18_HourInit()
	$aHour = tc18_ResourceInit($iRadius * 2, $iRadius * 2)
	$aHour[$ePen] = _GDIPlus_PenCreate(0xFFFF00FF)
	$aHour[$eCap] = _GDIPlus_ArrowCapCreate($iHourRad / 2, 8)
	_GDIPlus_PenSetCustomEndCap($aHour[$ePen], $aHour[$eCap])
EndFunc   ;==>HourInit

; ===============================================================================================================================
; Finalize resources for the minute hand
; ===============================================================================================================================
Func tc18_MinDone()
	_GDIPlus_PenDispose($aMin[$ePen])
	_GDIPlus_ArrowCapDispose($aMin[$eCap])
	tc18_ResourceDone($aMin)
EndFunc   ;==>MinDone

; ===============================================================================================================================
; Draw the minute hand
; ===============================================================================================================================
Func tc18_MinDraw()
	If ($aLast[1][0] = $aCurr[1][0]) And ($aLast[1][1] = $aCurr[1][1]) Then Return
	_GDIPlus_GraphicsFillRect($aMin[$eGraphic], 0, 0, $iRadius * 2, $iRadius * 2)
	_GDIPlus_GraphicsDrawLine($aMin[$eGraphic], $iCenter, $iCenter, $aCurr[1][0], $aCurr[1][1], $aMin[$ePen])
	tc18_ResourceSet($hMin, $aMin)
EndFunc   ;==>MinDraw

; ===============================================================================================================================
; Initialize resources for the minute hand
; ===============================================================================================================================
Func tc18_MinInit()
	$aMin = tc18_ResourceInit($iRadius * 2, $iRadius * 2)
	$aMin[$ePen] = _GDIPlus_PenCreate(0xFFFF0000)
	$aMin[$eCap] = _GDIPlus_ArrowCapCreate($iMinRad / 2, 8)
	_GDIPlus_PenSetCustomEndCap($aMin[$ePen], $aMin[$eCap])
EndFunc   ;==>MinInit

; ===============================================================================================================================
; Finalize resources for the second hand
; ===============================================================================================================================
Func tc18_SecDone()
	_GDIPlus_PenDispose($aSec[$ePen])
	tc18_ResourceDone($aSec)
EndFunc   ;==>SecDone

; ===============================================================================================================================
; Draw the second hand
; ===============================================================================================================================
Func tc18_SecDraw()
	If ($aLast[0][0] = $aCurr[0][0]) And ($aLast[0][1] = $aCurr[0][1]) Then Return
	_GDIPlus_GraphicsFillRect($aSec[$eGraphic], 0, 0, $iRadius * 2, $iRadius * 2)
	_GDIPlus_GraphicsDrawLine($aSec[$eGraphic], $iCenter, $iCenter, $aCurr[0][0], $aCurr[0][1], $aSec[$ePen])
	tc18_ResourceSet($hSec, $aSec)
EndFunc   ;==>SecDraw

; ===============================================================================================================================
; Initialize resources for the second hand
; ===============================================================================================================================
Func tc18_SecInit()
	$aSec = tc18_ResourceInit($iRadius * 2, $iRadius * 2)
	$aSec[$ePen] = _GDIPlus_PenCreate(0xFF000000)
EndFunc   ;==>SecInit

; ===============================================================================================================================
; Finalize drawing resources
; ===============================================================================================================================
Func tc18_ResourceDone(ByRef $aInfo)
	_GDIPlus_GraphicsDispose($aInfo[$eGraphic])
	_WinAPI_ReleaseDC(0, $aInfo[$eScrDC])
	_WinAPI_DeleteObject($aInfo[$eBitmap])
	_WinAPI_DeleteDC($aInfo[$eMemDC])
EndFunc   ;==>ResourceDone

; ===============================================================================================================================
; Initialize bitmap resources
; ===============================================================================================================================
Func tc18_ResourceInit($iWidth, $iHeight)
	Local $aInfo[$eLast + 1]

	$aInfo[$eScrDC] = _WinAPI_GetDC(0)
	$aInfo[$eMemDC] = _WinAPI_CreateCompatibleDC($aInfo[$eScrDC])
	$aInfo[$eBitmap] = _WinAPI_CreateCompatibleBitmap($aInfo[$eScrDC], $iWidth, $iHeight)
	_WinAPI_SelectObject($aInfo[$eMemDC], $aInfo[$eBitmap])
	$aInfo[$eWidth] = $iWidth
	$aInfo[$eHeight] = $iHeight
	$aInfo[$eGraphic] = _GDIPlus_GraphicsCreateFromHDC($aInfo[$eMemDC])
	_GDIPlus_GraphicsFillRect($aInfo[$eGraphic], 0, 0, $iRadius * 2, $iRadius * 2)
	Return $aInfo
EndFunc   ;==>ResourceInit

; ===============================================================================================================================
; Update layered window with resource information
; ===============================================================================================================================
Func tc18_ResourceSet($hGUI, ByRef $aInfo, $iAlpha = -1)
	Local $pSize, $tSize, $pSource, $tSource, $pBlend, $tBlend

	If $iAlpha = -1 Then $iAlpha = $iOpacity
	$tSize = DllStructCreate($tagSIZE)
	$pSize = DllStructGetPtr($tSize)
	DllStructSetData($tSize, "X", $aInfo[$eWidth])
	DllStructSetData($tSize, "Y", $aInfo[$eHeight])
	$tSource = DllStructCreate($tagPOINT)
	$pSource = DllStructGetPtr($tSource)
	$tBlend = DllStructCreate($tagBLENDFUNCTION)
	$pBlend = DllStructGetPtr($tBlend)
	DllStructSetData($tBlend, "Alpha", $iAlpha)
	DllStructSetData($tBlend, "Format", $AC_SRC_ALPHA)
	_WinAPI_UpdateLayeredWindow($hGUI, $aInfo[$eScrDC], 0, $pSize, $aInfo[$eMemDC], $pSource, 0, $pBlend, $ULW_ALPHA)
EndFunc   ;==>ResourceSet

; ===============================================================================================================================
; Finalize resources for the digital time
; ===============================================================================================================================
Func tc18_TimeDone()
	_GDIPlus_FontDispose($aTime[$eFont])
	_GDIPlus_FontFamilyDispose($aTime[$eFamily])
	_GDIPlus_StringFormatDispose($aTime[$eFormat])
	_GDIPlus_BrushDispose($aTime[$eBrush])
	tc18_ResourceDone($aTime)
EndFunc   ;==>TimeDone

; ===============================================================================================================================
; Draw the digital time
; ===============================================================================================================================
Func tc18_TimeDraw()
	Local $sString, $aSize

	If ($aLast[0][0] = $aCurr[0][0]) And ($aLast[0][1] = $aCurr[0][1]) Then Return
	$sString = StringFormat("%02d:%02d:%02d", @HOUR, @MIN, @SEC)
	$aSize = _GDIPlus_GraphicsMeasureString($aTime[$eGraphic], $sString, $aTime[$eFont], $aTime[$eLayout], $aTime[$eFormat])
	DllStructSetData($aTime[$eLayout], "X", $iRadius - (DllStructGetData($aSize[0], "Width") / 2))
	DllStructSetData($aTime[$eLayout], "Y", $iRadius / 3)
	_GDIPlus_GraphicsFillRect($aTime[$eGraphic], 0, 0, $iRadius * 2, $iRadius * 2)
	_GDIPlus_GraphicsDrawStringEx($aTime[$eGraphic], $sString, $aTime[$eFont], $aTime[$eLayout], $aTime[$eFormat], $aTime[$eBrush])
	tc18_ResourceSet($hTime, $aTime)
EndFunc   ;==>TimeDraw

; ===============================================================================================================================
; Initialize resources for the digital time
; ===============================================================================================================================
Func tc18_TimeInit()
	$aTime = tc18_ResourceInit($iRadius * 2, $iRadius * 2)
	$aTime[$eBrush] = _GDIPlus_BrushCreateSolid(0xFF008080)
	$aTime[$eFormat] = _GDIPlus_StringFormatCreate()
	$aTime[$eFamily] = _GDIPlus_FontFamilyCreate("Arial")
	$aTime[$eFont] = _GDIPlus_FontCreate($aTime[$eFamily], 24, 1)
	$aTime[$eLayout] = _GDIPlus_RectFCreate(0, 0, $iRadius * 2, 40)
EndFunc   ;==>TimeInit

; ===============================================================================================================================
; Convert time value to radians
; ===============================================================================================================================
Func tc18_TimeToRadians($sTimeType)
	Switch $sTimeType
		Case "sec"
			Return ($nPI / 2) - (@SEC * ($nPI / 30))
		Case "min"
			Return ($nPI / 2) - (@MIN * ($nPI / 30)) - (Int(@SEC / 10) * ($nPI / 180))
		Case "hour"
			Return ($nPI / 2) - (@HOUR * ($nPI / 6)) - (@MIN / 12) * ($nPI / 30)
	EndSwitch
EndFunc   ;==>TimeToRadians

; ===============================================================================================================================
; Handle the WM_NCHITTEST message so our window can be dragged
; ===============================================================================================================================
Func tc18_WM_NCHITTEST($hWnd, $iMsg, $iwParam, $ilParam)
	#forceref  $iMsg, $iwParam, $ilParam
	If $hWnd = $hDial Then Return $HTCAPTION
EndFunc   ;==>WM_NCHITTEST
	
;close form if timeout
 Func tc18_Quit($hWnd, $Msg, $iIDTimer, $dwTime)
   _Timer_KillTimer($hWnd,$iIDTimer)
   MsgBox(0, "Clock", "Time out", 2)
   WinClose($hWnd)
   $logContent = $logContent & "Timeout" & @CRLF
EndFunc
	
#endregion

#region "..\AutoIt3\Examples\GUI\Advanced\contextmenu.au3"
;===========================================================
;..\AutoIt3\Examples\GUI\Advanced\contextmenu.au3
;===========================================================
Func tc19 ()
 $GuiHnd = GUICreate("GUI with simple context menu", 300, 200)

Local $trackmenu = GUICtrlCreateContextMenu()
Local $aboutitem = GUICtrlCreateMenuItem("About", $trackmenu)
; next one creates a menu separator (line)
GUICtrlCreateMenuItem("", $trackmenu)
Local $exititem = GUICtrlCreateMenuItem("Exit", $trackmenu)

GUISetState()

$Timer = _Timer_SetTimer($GuiHnd, 5000, "tc19_Quit")

Local $timerInit = TimerInit()
Local $controlID = 1
Local $elapseTime = 0
   
While 1   
   $elapseTime = TimerDiff($timerInit)
   
   If $elapseTime > 2000 Then
	  $timerInit = TimerInit()	  
	  If $controlID = 1 Then
		 $controlID = 2
		 
		 WinActivate($GuiHnd)
		 
		 Local $pos = WinGetPos("GUI with simple context menu")
		 Local $x, $y
		 
		 $x = $pos[0] + $pos[2]/2
		 $y = $pos[1] + $pos[3]/2
		 
		 MouseMove($x,$y, 10)
		 Sleep(100)
		 ControlClick($GuiHnd, "", $GuiHnd, "right")
	  EndIf
   EndIf
	  
	Local $msg = GUIGetMsg()
	If $msg = $exititem Or $msg = $GUI_EVENT_CLOSE Or $msg = -1 Then 
	   $logContent = $logContent & "User click on Exit menu" & @CRLF
	   ExitLoop
	EndIf
	
	If $msg = $aboutitem Then 
	   MsgBox(0, "About", "A simple example with a context menu!", 3)
	   $logContent = $logContent & "User click on About menu" & @CRLF
	   WinClose($GuiHnd)
	EndIf	
WEnd
EndFunc

 Func tc19_Quit($hWnd, $Msg, $iIDTimer, $dwTime)
   _Timer_KillTimer($hWnd,$iIDTimer)   
   WinActivate($hWnd)
   Send("{DOWN}")
   Sleep(200)
   Send("{ENTER}")   
 EndFunc
 
 
#endregion

#region "..\AutoIt3\Examples\GUI\Advanced\dice.au3"
;===========================================================
;..\AutoIt3\Examples\GUI\Advanced\dice.au3
;===========================================================
Func tc20 ()
   ; autoit version: 3.0
   ; language:       English
   ; author:         Larry Bailey
   ; email:          psichosis@tvn.net
   ; Date: November 15, 2004
   ;
   ; Script Function
   ; Creates a GUI based dice rolling program
   ; using the Random function
   Local $button1, $button2, $button3, $button4, $button5
	Local $button6, $button7, $button8, $button9, $button10
	Local $output, $die, $msg, $results
	
	$GuiHnd = GUICreate("Dice Roller", 265, 150, -1, -1)

	$button1 = GUICtrlCreateButton("D2", 5, 25, 50, 30)
	$button2 = GUICtrlCreateButton("D3", 65, 25, 50, 30)
	$button3 = GUICtrlCreateButton("D4", 125, 25, 50, 30)
	$button4 = GUICtrlCreateButton("D6", 5, 65, 50, 30)
	$button5 = GUICtrlCreateButton("D8", 65, 65, 50, 30)
	$button6 = GUICtrlCreateButton("D10", 125, 65, 50, 30)
	$button7 = GUICtrlCreateButton("D12", 5, 105, 50, 30)
	$button8 = GUICtrlCreateButton("D20", 65, 105, 50, 30)
	$button9 = GUICtrlCreateButton("D100", 125, 105, 50, 30)
	$button10 = GUICtrlCreateButton("Clear Dice", 185, 105, 65, 30)
	$output = GUICtrlCreateLabel("", 185, 45, 70, 50, BitOR($BS_PUSHLIKE, $SS_CENTER))
	$die = GUICtrlCreateLabel("", 185, 25, 70, 20, 0x1000)
	GUICtrlSetFont($output, 24, 800, "", "Comic Sans MS")

	GUISetState()
	
	Local $timerInit = TimerInit()
   Local $controlID = 1
   Local $elapseTime = 0

	; Run the GUI until the dialog is closed
	While 1
	   
	   $elapseTime = TimerDiff($timerInit)
   
	  If $elapseTime > 3000 Then
		 $timerInit = TimerInit()	  
		 If $controlID = 1 Then
			$controlID = 2
			ControlClick($GuiHnd, "", $button1)
		 ElseIf $controlID = 2 Then
			$controlID = 3
			ControlClick($GuiHnd, "", $button2)
		 ElseIf $controlID = 3 Then
			$controlID = 4
			ControlClick($GuiHnd, "", $button3)
		 ElseIf $controlID = 4 Then
			$controlID = 5
			ControlClick($GuiHnd, "", $button4)
		 ElseIf $controlID = 5 Then
			$controlID = 6
			ControlClick($GuiHnd, "", $button5)
		 ElseIf $controlID = 6 Then
			$controlID = 7
			ControlClick($GuiHnd, "", $button6)
		 ElseIf $controlID = 7 Then
			$controlID = 8
			ControlClick($GuiHnd, "", $button7)
		 ElseIf $controlID = 8 Then
			$controlID = 9
			ControlClick($GuiHnd, "", $button8)
		 ElseIf $controlID = 9 Then
			$controlID = 10
			ControlClick($GuiHnd, "", $button9)
		 ElseIf $controlID = 10 Then
			$controlID = 11
			ControlClick($GuiHnd, "", $button10)
		 Else
			$logContent = $logContent & "User click on Close icon" & @CRLF
			WinClose($GuiHnd)
		 EndIf
	  EndIf
	   
		$msg = GUIGetMsg()
		Select
			Case $msg = $button1
				$results = Random(1, 2, 1)
				GUICtrlSetData($output, $results)
				GUICtrlSetData($die, "2 Sided Die")
				$logContent = $logContent & "User click on D2 button" & @CRLF
			Case $msg = $button2
				$results = Random(1, 3, 1)
				GUICtrlSetData($output, $results)
				GUICtrlSetData($die, "3 Sided Die")
				$logContent = $logContent & "User click on D3 button" & @CRLF
			Case $msg = $button3
				$results = Random(1, 4, 1)
				GUICtrlSetData($output, $results)
				GUICtrlSetData($die, "4 Sided Die")
				$logContent = $logContent & "User click on D4 button" & @CRLF
			Case $msg = $button4
				$results = Random(1, 6, 1)
				GUICtrlSetData($output, $results)
				GUICtrlSetData($die, "6 Sided Die")
				$logContent = $logContent & "User click on D6 button" & @CRLF
			Case $msg = $button5
				$results = Random(1, 8, 1)
				GUICtrlSetData($output, $results)
				GUICtrlSetData($die, "8 Sided Die")
				$logContent = $logContent & "User click on D8 button" & @CRLF
			Case $msg = $button6
				$results = Random(1, 10, 1)
				GUICtrlSetData($output, $results)
				GUICtrlSetData($die, "10 Sided Die")
				$logContent = $logContent & "User click on D10 button" & @CRLF
			Case $msg = $button7
				$results = Random(1, 12, 1)
				GUICtrlSetData($output, $results)
				GUICtrlSetData($die, "12 Sided Die")
				$logContent = $logContent & "User click on D12 button" & @CRLF
			Case $msg = $button8
				$results = Random(1, 20, 1)
				GUICtrlSetData($output, $results)
				GUICtrlSetData($die, "20 Sided Die")
				$logContent = $logContent & "User click on D20 button" & @CRLF
			Case $msg = $button9
				$results = Random(1, 100, 1)
				GUICtrlSetData($output, $results)
				GUICtrlSetData($die, "100 Sided Die")
				$logContent = $logContent & "User click on D100 button" & @CRLF
			Case $msg = $button10
				GUICtrlSetData($output, "")
				GUICtrlSetData($die, "")
				$logContent = $logContent & "User click on Clear Dice button" & @CRLF
		EndSelect
		If $msg = $GUI_EVENT_CLOSE Then 
		   $logContent = $logContent & "User click on Close icon" & @CRLF
		   ExitLoop
		EndIf		
	WEnd
 EndFunc 

Func tc20_Quit($hWnd, $Msg, $iIDTimer, $dwTime)
   _Timer_KillTimer($hWnd,$iIDTimer)
   MsgBox(0, "Dice Roller", "Time out", 2)
   WinClose($hWnd)
   $logContent = $logContent & "Timeout" & @CRLF
EndFunc

#endregion

#region "..\AutoIt3\Examples\GUI\Advanced\Emboss.au3"
;===========================================================
;..\AutoIt3\Examples\GUI\Advanced\Emboss.au3
;===========================================================
Func tc21 ()
; ===============================================================================================================================
; Description ...: Shows how to emboss text on an image
; Author ........: Paul Campbell (PaulIA)
; Notes .........:
; ===============================================================================================================================

; ===============================================================================================================================
; Global variables
; ===============================================================================================================================
Local $hBitmap, $hImage, $hGraphic, $hFamily, $hFont, $tLayout, $hFormat, $aInfo, $hBrush1, $hBrush2, $iWidth, $iHeight, $hPen
Local $sString = "  Created with AutoIt  "

; ===============================================================================================================================
; Main
; ===============================================================================================================================

; Initialize GDI+ library
_GDIPlus_Startup()

; Capture screen
$logContent = $logContent & "Capture image to " & @ScriptDir & '\Images\AutoItImage.bmp' & @CRLF
$hBitmap = _ScreenCapture_Capture(@ScriptDir & '\Images\AutoItImage.bmp')

; Load image and emboss text
$logContent = $logContent & "Load image and emboss text: " & $sString & @CRLF
$hImage = _GDIPlus_ImageLoadFromFile(@ScriptDir & '\Images\AutoItImage.bmp')
$hGraphic = _GDIPlus_ImageGetGraphicsContext($hImage)
$hFamily = _GDIPlus_FontFamilyCreate("Arial")
$hFont = _GDIPlus_FontCreate($hFamily, 16, 1)
$tLayout = _GDIPlus_RectFCreate(0, 0)
$hFormat = _GDIPlus_StringFormatCreate(2)
$hBrush1 = _GDIPlus_BrushCreateSolid(0xA2FFFFFF)
$hBrush2 = _GDIPlus_BrushCreateSolid(0xC4FF0000)
$hPen = _GDIPlus_PenCreate(0xC4000000, 2)
$aInfo = _GDIPlus_GraphicsMeasureString($hGraphic, $sString, $hFont, $tLayout, $hFormat)
$iWidth = DllStructGetData($aInfo[0], "Width")
$iHeight = DllStructGetData($aInfo[0], "Height")

_GDIPlus_GraphicsFillRect($hGraphic, 0, 0, $iWidth, $iHeight, $hBrush1)
_GDIPlus_GraphicsDrawRect($hGraphic, 1, 1, $iWidth, $iHeight, $hPen)
_GDIPlus_GraphicsDrawStringEx($hGraphic, $sString, $hFont, $aInfo[0], $hFormat, $hBrush2)

; Save image
$logContent = $logContent & "Save image to " & @ScriptDir & '\Images\AutoItImage2.bmp' & @CRLF
_GDIPlus_ImageSaveToFile($hImage, @ScriptDir & '\Images\AutoItImage2.bmp')

; Free resources
_GDIPlus_PenDispose($hPen)
_GDIPlus_BrushDispose($hBrush1)
_GDIPlus_BrushDispose($hBrush2)
_GDIPlus_StringFormatDispose($hFormat)
_GDIPlus_FontDispose($hFont)
_GDIPlus_FontFamilyDispose($hFamily)
_GDIPlus_GraphicsDispose($hGraphic)
_GDIPlus_ImageDispose($hImage)
_GDIPlus_Shutdown()

; Show image
$logContent = $logContent & "Open image by MS Paint" & @CRLF
Local $PID = Run("MSPaint.exe " & '"' & @ScriptDir & '\Images\AutoItImage2.bmp"')

Sleep(4000)

If $PID Then ProcessClose($PID)
   
sgBox(0, "Capture Screen", "The screeen has captured", 4)

EndFunc

#endregion

#region "..\AutoIt3\Examples\GUI\Advanced\encrypt.au3"
;===========================================================
;..\AutoIt3\Examples\GUI\Advanced\encrypt.au3
;===========================================================
Func tc22 ()
   Local $WinMain, $EditText, $InputLevel, $InputPass, $UpDownLevel
	Local $EncryptButton, $DecryptButton, $string
	#forceref $UpDownLevel
;~~
	$WinMain = GUICreate('Encryption tool', 400, 400)
	; Creates window
;~~
	$EditText = GUICtrlCreateEdit('', 5, 5, 380, 350)
	; Creates main edit
;~~
	$InputPass = GUICtrlCreateInput('', 5, 360, 100, 20, 0x21)
	; Creates the password box with blured/centered input
;~~
	$InputLevel = GUICtrlCreateInput(1, 110, 360, 50, 20, 0x2001)
	$UpDownLevel = GUICtrlSetLimit(GUICtrlCreateUpdown($InputLevel), 10, 1)
	; These two make the level input with the Up|Down ability
;~~
	$EncryptButton = GUICtrlCreateButton('Encrypt', 170, 360, 105, 35)
	$DecryptButton = GUICtrlCreateButton('Decrypt', 285, 360, 105, 35)
	; Encryption/Decryption buttons
;~~
	GUICtrlCreateLabel('Password', 5, 385)
	GUICtrlCreateLabel('Level', 110, 385)
	; Simple text labels so you know what is what
;~~
	GUISetState()
	
   Local $timerInit = TimerInit()
   Local $controlID = 1
   Local $elapseTime = 0

	While 1
	   $elapseTime = TimerDiff($timerInit)
   
	  If $elapseTime > 2000 Then
		 $timerInit = TimerInit()	  
		 If $controlID = 1 Then
			$controlID = 2
			ControlSend($GuiHnd, "", $EditText, "auto populate text for encrypt")
			Sleep(500)
			ControlSetText($GuiHnd, "", $InputPass, "password")
			Sleep(500)
			ControlSetText($GuiHnd, "", $InputLevel, 2)
		 ElseIf $controlID = 2 Then
			$controlID = 3
			ControlClick($GuiHnd, "", $EncryptButton)
		 ElseIf $controlID = 3 Then
			$controlID = 4
			ControlClick($GuiHnd, "", $DecryptButton)
		 Else
			WinClose($GuiHnd)
		 EndIf
	  EndIf
		 
		Switch GUIGetMsg()
			Case $GUI_EVENT_CLOSE
			$logContent = $logContent & "User click on Close icon" & @CRLF
			 ExitLoop
			 
			Case $EncryptButton
				; When you press Encrypt
;~~
				GUISetState(@SW_DISABLE, $WinMain)
				; Stops you from changing anything
;~~
				$string = GUICtrlRead($EditText)
				; Saves the editbox for later
;~~
				GUICtrlSetData($EditText, 'Please wait while the text is Encrypted/Decrypted.')
				; Friendly message
;~~
				GUICtrlSetData($EditText, _StringEncrypt(1, $string, GUICtrlRead($InputPass), GUICtrlRead($InputLevel)))
				; Calls the encryption. Sets the data of editbox with the encrypted string
;~~
				GUISetState(@SW_ENABLE, $WinMain)
				; This turns the window back on
				
				$logContent = $logContent & "The text has encrypted" & @CRLF
;~~
			Case $DecryptButton
				; When you press Decrypt
;~~
				GUISetState(@SW_DISABLE, $WinMain)
				; Stops you from changing anything
;~~
				$string = GUICtrlRead($EditText)
				; Saves the editbox for later
;~~
				GUICtrlSetData($EditText, 'Please wait while the text is Encrypted/Decrypted.')
				; Friendly message
;~~
				GUICtrlSetData($EditText, _StringEncrypt(0, $string, GUICtrlRead($InputPass), GUICtrlRead($InputLevel)))
				; Calls the encryption. Sets the data of editbox with the encrypted string
;~~
				GUISetState(@SW_ENABLE, $WinMain)
				; This turns the window back on
				
				$logContent = $logContent & "The text has decrypted" & @CRLF
;~~
		EndSwitch		
	WEnd	
 EndFunc
 
#endregion

#region "..\AutoIt3\Examples\GUI\Advanced\enumicons.au3"
;===========================================================
;..\AutoIt3\Examples\GUI\Advanced\enumicons.au3
;===========================================================
Func tc23 ()
   Local $hGui, $hFile, $hFileSel, $hNext, $hToggle
	Local $iMsg, $sCurFilename, $sTmpFile

	; Creating GUI and controls
	$hGui = GUICreate("Icon Selector by Ordinal value", 385, 435, @DesktopWidth / 2 - 192, _
			@DesktopHeight / 2 - 235, -1, $WS_EX_ACCEPTFILES)
	GUICtrlCreateGroup("", 5, 1, 375, 40)
	GUICtrlCreateGroup("", 5, 50, 375, 380)
	$hFile = GUICtrlCreateInput($sFilename, 12, 15, 325, 16, -1, $WS_EX_STATICEDGE)
	GUICtrlSetState(-1, $GUI_DROPACCEPTED)
	GUICtrlSetTip(-1, "You can drop files from shell here...")
	$hFileSel = GUICtrlCreateButton("...", 345, 14, 26, 18)
	$hPrev = GUICtrlCreateButton("Previous", 10, 45, 60, 24, $BS_FLAT)
	GUICtrlSetState(-1, $GUI_DISABLE)
	$hNext = GUICtrlCreateButton("Next", 75, 45, 60, 24, $BS_FLAT)
	$hToggle = GUICtrlCreateButton("by Name", 300, 45, 60, 24, $BS_FLAT)

	; This code build two arrays of ID's of icons and labels for easily update
	For $iCntRow = 0 To 4
		For $iCntCol = 0 To 5
			$iCurIndex = $iCntRow * 6 + $iCntCol
			$ahIcons[$iCurIndex] = GUICtrlCreateIcon($sFilename, $iOrdinal * ($iCurIndex + 1), _
					60 * $iCntCol + 25, 70 * $iCntRow + 80)
			$ahLabels[$iCurIndex] = GUICtrlCreateLabel($iOrdinal * ($iCurIndex + 1), _
					60 * $iCntCol + 11, 70 * $iCntRow + 115, 60, 20, $SS_CENTER)
		Next
	Next

	GUISetState()
	Local $timerInit = TimerInit()
   Local $controlID = 1
   Local $elapseTime = 0

	While 1
	   $elapseTime = TimerDiff($timerInit)
   
	  If $elapseTime > 2000 Then
		 $timerInit = TimerInit()	  
		 If $controlID = 1 Then
			$controlID = 2
			ControlClick($GuiHnd, "", $hNext, "left", 3)
		 ElseIf $controlID = 2 Then
			$controlID = 3
			ControlClick($GuiHnd, "", $hPrev)
		 ElseIf $controlID = 3 Then
			$controlID = 4
			ControlClick($GuiHnd, "", $hToggle)
		 Else
			WinClose($GuiHnd)
		 EndIf
	  EndIf
	  
		$iMsg = GUIGetMsg()
		; Code below will check if the file is dropped (or selected)
		$sCurFilename = GUICtrlRead($hFile)
		If $sCurFilename <> $sFilename Then
			$iStartIndex = 1
			$sFilename = $sCurFilename
			tc23_GUIUpdate()
		EndIf
		; Main "Select" statement that handles other events
		Select
			Case $iMsg = $hFileSel
			   $logContent = $logContent & "User click on File menu" & @CRLF
				$sTmpFile = FileOpenDialog("Select file:", "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}", "Executables & dll's (*.exe;*.dll;*.ocx;*.icl)")
				If @error Then ContinueLoop
				GUICtrlSetData($hFile, $sTmpFile); GUI will be updated at next iteration
				
			Case $iMsg = $hPrev
				$iStartIndex = $iStartIndex - 30
				tc23_GUIUpdate()
				$logContent = $logContent & "User click on Previous button" & @CRLF
				
			Case $iMsg = $hNext
				$iStartIndex = $iStartIndex + 30
				tc23_GUIUpdate()
				$logContent = $logContent & "User click on Next button" & @CRLF
				
			Case $iMsg = $hToggle
				If $iOrdinal = -1 Then
					$iOrdinal = 1
					GUICtrlSetData($hToggle, "by Ordinal")
					WinSetTitle($hGui, "", "Icon Selector by Name value")
					$logContent = $logContent & "User click on Name button" & @CRLF				
				Else
					$iOrdinal = -1
					GUICtrlSetData($hToggle, "by Name")
					WinSetTitle($hGui, "", "Icon Selector by Ordinal value")
					$logContent = $logContent & "User click on Ordinal button" & @CRLF
				EndIf
				tc23_GUIUpdate()
				
			 Case $iMsg = $GUI_EVENT_CLOSE
				Return
		EndSelect
	WEnd
EndFunc

; Just updates GUI icons, labels and set state of "Previous" button
Func tc23_GUIUpdate()
	For $iCntRow = 0 To 4
		For $iCntCol = 0 To 5
			$iCurIndex = $iCntRow * 6 + $iCntCol
			GUICtrlSetImage($ahIcons[$iCurIndex], $sFilename, $iOrdinal * ($iCurIndex + $iStartIndex))
			If $iOrdinal = -1 Then
				GUICtrlSetData($ahLabels[$iCurIndex], -($iCurIndex + $iStartIndex))
			Else
				GUICtrlSetData($ahLabels[$iCurIndex], '"' & ($iCurIndex + $iStartIndex) & '"')
			EndIf
		Next
	Next
	; This is because we don't want negative values
	If $iStartIndex = 1 Then
		GUICtrlSetState($hPrev, $GUI_DISABLE)
	Else
		GUICtrlSetState($hPrev, $GUI_ENABLE)
	EndIf
EndFunc   ;==>_GUIUpdate

#endregion

#region "..\AutoIt3\Examples\GUI\Advanced\imagebutton.au3"
;===========================================================
;..\AutoIt3\Examples\GUI\Advanced\imagebutton.au3
;===========================================================
Func tc24 ()
   Local $button1, $button2, $button3, $button4
	Local $button5, $buttonclose

	$GuiHnd = GUICreate("test", 240, 180)
	$button1 = GUICtrlCreateButton("1", 0, 0, 40, 40, $BS_ICON)
	GUICtrlSetImage(-1, "shell32.dll", 5)
	$button2 = GUICtrlCreateButton("2", 40, 00, 40, 40, $BS_ICON)
	GUICtrlSetImage(-1, "shell32.dll", 7)
	$button3 = GUICtrlCreateButton("3", 80, 00, 40, 40, $BS_ICON)
	GUICtrlSetImage(-1, "shell32.dll", 22)
	$button4 = GUICtrlCreateButton("4", 120, 0, 40, 40, $BS_ICON)
	GUICtrlSetImage(-1, "shell32.dll", 23)
	$button5 = GUICtrlCreateButton("5", 160, 0, 40, 40, $BS_ICON)
	GUICtrlSetImage(-1, "shell32.dll", 32)
	$buttonclose = GUICtrlCreateButton("close", 200, 0, 40, 40, $BS_ICON)
	GUICtrlSetImage(-1, "shell32.dll", 28)
	GUISetState()
	
   Local $timerInit = TimerInit()
   Local $controlID = 1
   Local $elapseTime = 0

	; Run the GUI until the dialog is closed
	While 1
	   $elapseTime = TimerDiff($timerInit)
   
	  If $elapseTime > 2000 Then
		 $timerInit = TimerInit()	  
		 If $controlID = 1 Then
			$controlID = 2
			ControlClick($GuiHnd, "", $button1)
		 ElseIf $controlID = 2 Then
			$controlID = 3
			ControlClick($GuiHnd, "", $button2)
		 ElseIf $controlID = 3 Then
			$controlID = 4
			ControlClick($GuiHnd, "", $button3)
		 ElseIf $controlID = 4 Then
			$controlID = 5
			ControlClick($GuiHnd, "", $button4)
		 ElseIf $controlID = 5 Then
			$controlID = 6
			ControlClick($GuiHnd, "", $button5)
		 Else
			ControlClick($GuiHnd, "", $buttonclose)
		 EndIf
	  EndIf
	  
		Switch GUIGetMsg()
			Case $GUI_EVENT_CLOSE
			   $logContent = $logContent & "User click on Close icon" & @CRLF
				ExitLoop
			 Case $button1
				$logContent = $logContent & "User click on 1 button" & @CRLF
				
			 Case $button2
				$logContent = $logContent & "User click on 2 button" & @CRLF
				
			 Case $button3
				$logContent = $logContent & "User click on 3 button" & @CRLF
				
			 Case $button4
				$logContent = $logContent & "User click on 4 button" & @CRLF
				
			 Case $button5
				$logContent = $logContent & "User click on 5 button" & @CRLF
				
			 Case $buttonclose
				$logContent = $logContent & "User click on Close button" & @CRLF
				ExitLoop
			Case Else
		EndSwitch
	WEnd

	GUIDelete()
 EndFunc
 
#endregion

#region "..\AutoIt3\Examples\GUI\Advanced\menu.au3"
;===========================================================
;..\AutoIt3\Examples\GUI\Advanced\menu.au3
;===========================================================
Func tc25 ()
   Local $filemenu, $fileitem, $recentfilesmenu, $separator1
	Local $exititem, $helpmenu, $aboutitem, $okbutton, $cancelbutton
	Local $msg, $file
	#forceref $separator1

	$GuiHnd = GUICreate("GUI menu", 300, 200)
	
	$filemenu = GUICtrlCreateMenu("File")
	$fileitem = GUICtrlCreateMenuItem("Open...", $filemenu)
	$recentfilesmenu = GUICtrlCreateMenu("Recent Files", $filemenu)
	$separator1 = GUICtrlCreateMenuItem("", $filemenu)
	$exititem = GUICtrlCreateMenuItem("Exit", $filemenu)
	$helpmenu = GUICtrlCreateMenu("?")
	$aboutitem = GUICtrlCreateMenuItem("About", $helpmenu)

	$okbutton = GUICtrlCreateButton("OK", 50, 130, 70, 20)

	$cancelbutton = GUICtrlCreateButton("Cancel", 180, 130, 70, 20)

	GUISetState()
	
   Local $timerInit = TimerInit()
   Local $controlID = 1
   Local $elapseTime = 0

	; Run the GUI until the dialog is closed
	While 1
	   $elapseTime = TimerDiff($timerInit)
   
	  If $elapseTime > 2000 Then
		 $timerInit = TimerInit()	  
		 If $controlID = 1 Then
			$controlID = 2
			ControlClick($GuiHnd, "", $okbutton)
		 Else
			ControlClick($GuiHnd, "", $cancelbutton)
		 EndIf
	  EndIf
	  
		$msg = GUIGetMsg()

		Select
			Case $msg = $GUI_EVENT_CLOSE Or $msg = $cancelbutton
			   $logContent = $logContent & "User click on Close icon or Cancel button" & @CRLF
				ExitLoop

			Case $msg = $fileitem
			   $logContent = $logContent & "User click on File item" & @CRLF
				_Timer_KillTimer($GuiHnd,$Timer)
				$Timer = _Timer_SetTimer($GuiHnd, 5000, "tc25_Quit")
				$file = FileOpenDialog("Choose file...", @TempDir, "All (*.*)")
				If @error <> 1 Then GUICtrlCreateMenuItem($file, $recentfilesmenu)

			Case $msg = $exititem
			   $logContent = $logContent & "User click on Exit item" & @CRLF
				ExitLoop

			Case $msg = $okbutton
			   $logContent = $logContent & "User click on OK button" & @CRLF
				MsgBox(0, "Click", "You clicked OK!", 2)

			Case $msg = $aboutitem
			   $logContent = $logContent & "User click on About item" & @CRLF
				_Timer_KillTimer($GuiHnd,$Timer)
				$Timer = _Timer_SetTimer($GuiHnd, 5000, "tc25_Quit")
				MsgBox(0, "About", "GUI Menu Test", 2)
		EndSelect
	WEnd

	GUIDelete()
	Return
	
 EndFunc
 
 ;close form if timeout
 Func tc25_Quit($hWnd, $Msg, $iIDTimer, $dwTime)
   _Timer_KillTimer($hWnd,$iIDTimer)
   MsgBox(0, "Test", "Time out", 2)
   WinClose($hWnd)
   $logContent = $logContent & "Timeout" & @CRLF
EndFunc

#endregion

#region "..\AutoIt3\Examples\GUI\Advanced\msgboxwizard.au3"
;===========================================================
;..\AutoIt3\Examples\GUI\Advanced\msgboxwizard.au3
;===========================================================
Func tc26 ()
   Local $TITLE, $TEXT, $Timeout
	Local $BTNCOPY, $BTNEXIT, $BTNPREVIEW, $MSG, $sText

	$GuiHnd = GUICreate("MsgBox Wizard v.1.0", 440, 540, 100, 100) ; will create a dialog box

	GUICtrlCreateLabel("Title", 10, 5, 30)
	$TITLE = GUICtrlCreateInput("", 10, 20, 420, 20)
	GUICtrlSetState(-1, $GUI_FOCUS)
	GUICtrlSetTip(-1, "The title of the message box.")
	GUICtrlCreateLabel("Text", 10, 50, 30)
	$TEXT = GUICtrlCreateEdit("", 10, 65, 420, 100, $ES_AUTOVSCROLL + $WS_VSCROLL + $ES_MULTILINE + $ES_WANTRETURN)
	GUICtrlSetTip(-1, "The text of the message box.")

	GUICtrlCreateGroup("Icons", 10, 170, 200, 130)
	$optWarning = GUICtrlCreateRadio("Warning", 20, 190, 100, 20)
	GUICtrlSetState(-1, $GUI_CHECKED)
	$optInfo = GUICtrlCreateRadio("Informational", 20, 210, 100, 20)
	$optCritical = GUICtrlCreateRadio("Critical", 20, 230, 100, 20)
	$optQuestion = GUICtrlCreateRadio("Question", 20, 250, 100, 20)
	$optNoIcon = GUICtrlCreateRadio("None", 20, 270, 100, 20)
	GUICtrlCreateGroup("", -99, -99, 1, 1) ;close group

	GUICtrlCreateGroup("Modality", 10, 310, 200, 90)
	$optApplication = GUICtrlCreateRadio("Application", 20, 330, 100, 20)
	GUICtrlSetState(-1, $GUI_CHECKED)
	$optSysModal = GUICtrlCreateRadio("System Modal", 20, 350, 100, 20)
	$optTaskModal = GUICtrlCreateRadio("Task Modal", 20, 370, 100, 20)
	GUICtrlCreateGroup("", -99, -99, 1, 1) ;close group

	GUICtrlCreateGroup("Buttons", 230, 170, 200, 170)
	$optOK = GUICtrlCreateRadio("OK", 240, 190, 100, 20)
	GUICtrlSetState(-1, $GUI_CHECKED)
	$optOkCancel = GUICtrlCreateRadio("OK, Cancel", 240, 210, 100, 20)
	$optYesNo = GUICtrlCreateRadio("Yes, No", 240, 230, 100, 20)
	$optYesNoCancel = GUICtrlCreateRadio("Yes, No, Cancel", 240, 250, 100, 20)
	$optAbortRetryIgnore = GUICtrlCreateRadio("Abort, Retry, Ignore", 240, 270, 120, 20)
	$optRetryCancel = GUICtrlCreateRadio("Retry, Cancel", 240, 290, 100, 20)
	$optCancelRetryContinue = GUICtrlCreateRadio("Cancel, Retry, Continue", 240, 310, 130, 20)
	GUICtrlCreateGroup("", -99, -99, 1, 1) ;close group

	GUICtrlCreateGroup("Miscellaneous", 10, 410, 200, 90)
	$optNothing = GUICtrlCreateRadio("Nothing", 20, 430, 100, 20)
	GUICtrlSetState(-1, $GUI_CHECKED)
	$optTopMost = GUICtrlCreateRadio("Top-most attribute set", 20, 450, 130, 20)
	$optRightJust = GUICtrlCreateRadio("Right-justified title/text", 20, 470, 150, 20)
	GUICtrlCreateGroup("", -99, -99, 1, 1) ;close group

	GUICtrlCreateGroup("Default Buttons", 230, 350, 200, 90)
	$optFirst = GUICtrlCreateRadio("First Button", 240, 370, 130, 20)
	GUICtrlSetState(-1, $GUI_CHECKED)
	$optSecond = GUICtrlCreateRadio("Second Button", 240, 390, 130, 20)
	GUICtrlSetState(-1, $GUI_DISABLE)
	$optThird = GUICtrlCreateRadio("Third Button", 240, 410, 130, 20)
	GUICtrlSetState(-1, $GUI_DISABLE)
	GUICtrlCreateGroup("", -99, -99, 1, 1) ;close group

	GUICtrlCreateGroup("Timeout", 230, 450, 200, 50)
	$Timeout = GUICtrlCreateInput("", 240, 470, 100, 20, $ES_NUMBER)
	GUICtrlSetTip(-1, "Optional Timeout in seconds. After the timeout has elapsed the message box will be automatically closed.")
	GUICtrlCreateGroup("", -99, -99, 1, 1) ;close group

	$BTNPREVIEW = GUICtrlCreateButton("&Preview", 10, 510, 100)
	GUICtrlSetTip(-1, "Show the MessageBox")
	$BTNCOPY = GUICtrlCreateButton("&Copy", 120, 510, 100)
	GUICtrlSetTip(-1, "Copy the generated AutoIt code to the Clipboard")
	$BTNEXIT = GUICtrlCreateButton("&Exit", 230, 510, 100)
	GUICtrlSetTip(-1, "Quit the program")

	$Button = $optOK

	GUISetState() ; will display an empty dialog box
	
	Local $timerInit = TimerInit()
   Local $controlID = 1
   Local $elapseTime = 0

	; Run the GUI until the dialog is closed
	While 1
	   $elapseTime = TimerDiff($timerInit)
   
	  If $elapseTime > 2000 Then
		 $timerInit = TimerInit()	  
		 If $controlID = 1 Then
			$controlID = 2
			ControlSetText($GuiHnd, "", $TITLE, "auto populate title of message")
		 ElseIf $controlID = 2 Then
			$controlID = 3
			ControlSetText($GuiHnd, "", $TEXT, "auto populate content of message")
		 ElseIf $controlID = 3 Then
			$controlID = 4
			GUICtrlSetState($optInfo, $GUI_CHECKED)
			Sleep(200)
			ControlClick($GuiHnd, "", $optAbortRetryIgnore)
			Sleep(200)			
			GUICtrlSetState($optTopMost, $GUI_CHECKED)
			Sleep(200)
			GUICtrlSetState($optSysModal, $GUI_CHECKED)
			Sleep(200)
			ControlSetText($GuiHnd, "", $Timeout, 2)
		 ElseIf $controlID = 4 Then
			$controlID = 5
			ControlClick($GuiHnd, "", $BTNPREVIEW)
		 ElseIf $controlID = 5 Then
			$controlID = 6
			ControlClick($GuiHnd, "", $BTNCOPY)
		 Else
			ControlClick($GuiHnd, "", $BTNEXIT)			
		 EndIf
	  EndIf	  
	
		$MSG = GUIGetMsg()
		Select
			Case $MSG = $GUI_EVENT_CLOSE Or $MSG = $BTNEXIT
			   $logContent = $logContent & "User click on Close icon" & @CRLF
				Return

			Case $MSG = $optOK
				$Button = $optOK
				GUICtrlSetState($optFirst, $GUI_CHECKED)
				GUICtrlSetState($optFirst, $GUI_ENABLE)
				GUICtrlSetState($optSecond, $GUI_DISABLE)
				GUICtrlSetState($optThird, $GUI_DISABLE)
				
				$logContent = $logContent & "User click on OK radio" & @CRLF

			Case $MSG = $optOkCancel
				$Button = $optOkCancel
				GUICtrlSetState($optFirst, $GUI_CHECKED)
				GUICtrlSetState($optFirst, $GUI_ENABLE)
				GUICtrlSetState($optSecond, $GUI_ENABLE)
				GUICtrlSetState($optThird, $GUI_DISABLE)
				
				$logContent = $logContent & "User click on OK/Cancel radio" & @CRLF

			Case $MSG = $optYesNo
				$Button = $optYesNo
				GUICtrlSetState($optFirst, $GUI_CHECKED)
				GUICtrlSetState($optFirst, $GUI_ENABLE)
				GUICtrlSetState($optSecond, $GUI_ENABLE)
				GUICtrlSetState($optThird, $GUI_DISABLE)
				
				$logContent = $logContent & "User click on Yes/No radio" & @CRLF

			Case $MSG = $optYesNoCancel
				$Button = $optYesNoCancel
				GUICtrlSetState($optFirst, $GUI_CHECKED)
				GUICtrlSetState($optFirst, $GUI_ENABLE)
				GUICtrlSetState($optSecond, $GUI_ENABLE)
				GUICtrlSetState($optThird, $GUI_ENABLE)
				
				$logContent = $logContent & "User click on Yes/No/Cancel radio" & @CRLF

			Case $MSG = $optAbortRetryIgnore
				$Button = $optAbortRetryIgnore
				GUICtrlSetState($optFirst, $GUI_CHECKED)
				GUICtrlSetState($optFirst, $GUI_ENABLE)
				GUICtrlSetState($optSecond, $GUI_ENABLE)
				GUICtrlSetState($optThird, $GUI_ENABLE)
				
				$logContent = $logContent & "User click on Abort/Retry/Ignore radio" & @CRLF

			Case $MSG = $optRetryCancel
				$Button = $optRetryCancel
				GUICtrlSetState($optFirst, $GUI_CHECKED)
				GUICtrlSetState($optFirst, $GUI_ENABLE)
				GUICtrlSetState($optSecond, $GUI_ENABLE)
				GUICtrlSetState($optThird, $GUI_DISABLE)
				
				$logContent = $logContent & "User click on Retry/Cancel radio" & @CRLF

			Case $MSG = $optCancelRetryContinue
				$Button = $optCancelRetryContinue
				GUICtrlSetState($optFirst, $GUI_CHECKED)
				GUICtrlSetState($optFirst, $GUI_ENABLE)
				GUICtrlSetState($optSecond, $GUI_ENABLE)
				GUICtrlSetState($optThird, $GUI_ENABLE)
				
				$logContent = $logContent & "User click on Cancel/Retry/Continue radio" & @CRLF

			Case $MSG = $BTNPREVIEW
			   $logContent = $logContent & "User click on Preview button" & @CRLF
				MsgBox(tc26_SetFlag($iFlag), GUICtrlRead($TITLE), GUICtrlRead($TEXT), GUICtrlRead($Timeout))

			Case $MSG = $BTNCOPY
			   $logContent = $logContent & "User click on Copy button" & @CRLF
				$asMsgText = StringSplit(GUICtrlRead($TEXT), @CRLF, 1)
				If $asMsgText[0] = 1 Then
					$sText = GUICtrlRead($TEXT)
				Else
					$sText = $asMsgText[1]

					For $iCtr = 2 To $asMsgText[0]
						$sText = $sText & Chr(34) & " & @CRLF & " & Chr(34) & $asMsgText[$iCtr]
					Next

				EndIf

				Select
					Case $Button = $optOK
						If GUICtrlRead($Timeout) = "" Then
							$msgbox = "MsgBox(" & tc26_SetFlag($iFlag) & "," & Chr(34) & GUICtrlRead($TITLE) & Chr(34) & "," _
									 & Chr(34) & $sText & Chr(34) & ")"
						Else
							$msgbox = "Dim $iMsgBoxAnswer" & @CRLF & _
									"$iMsgBoxAnswer = MsgBox(" & tc26_SetFlag($iFlag) & "," & Chr(34) & GUICtrlRead($TITLE) & Chr(34) & "," _
									 & Chr(34) & $sText & Chr(34) & "," & GUICtrlRead($Timeout) & ")" & @CRLF & _
									"Select" & @CRLF & _
									"   Case $iMsgBoxAnswer = -1 ;Timeout" & @CRLF & @CRLF & _
									"   Case Else                ;OK" & @CRLF & @CRLF & _
									"EndSelect"
						EndIf

					Case $Button = $optOkCancel
						If GUICtrlRead($Timeout) = "" Then
							$msgbox = "Dim $iMsgBoxAnswer" & @CRLF & _
									"$iMsgBoxAnswer = MsgBox(" & tc26_SetFlag($iFlag) & "," & Chr(34) & GUICtrlRead($TITLE) & Chr(34) & "," _
									 & Chr(34) & $sText & Chr(34) & ")" & @CRLF & _
									"Select" & @CRLF & _
									"   Case $iMsgBoxAnswer = 1 ;OK" & @CRLF & @CRLF & _
									"   Case $iMsgBoxAnswer = 2 ;Cancel" & @CRLF & @CRLF & _
									"EndSelect"
						Else
							$msgbox = "Dim $iMsgBoxAnswer" & @CRLF & _
									"$iMsgBoxAnswer = MsgBox(" & tc26_SetFlag($iFlag) & "," & Chr(34) & GUICtrlRead($TITLE) & Chr(34) & "," _
									 & Chr(34) & $sText & Chr(34) & "," & GUICtrlRead($Timeout) & ")" & @CRLF & _
									"Select" & @CRLF & _
									"   Case $iMsgBoxAnswer = 1  ;OK" & @CRLF & @CRLF & _
									"   Case $iMsgBoxAnswer = 2  ;Cancel" & @CRLF & @CRLF & _
									"   Case $iMsgBoxAnswer = -1 ;Timeout" & @CRLF & @CRLF & _
									"EndSelect"
						EndIf

					Case $Button = $optYesNo
						If GUICtrlRead($Timeout) = "" Then
							$msgbox = "Dim $iMsgBoxAnswer" & @CRLF & _
									"$iMsgBoxAnswer = MsgBox(" & tc26_SetFlag($iFlag) & "," & Chr(34) & GUICtrlRead($TITLE) & Chr(34) & "," _
									 & Chr(34) & $sText & Chr(34) & ")" & @CRLF & _
									"Select" & @CRLF & _
									"   Case $iMsgBoxAnswer = 6 ;Yes" & @CRLF & @CRLF & _
									"   Case $iMsgBoxAnswer = 7 ;No" & @CRLF & @CRLF & _
									"EndSelect"
						Else
							$msgbox = "Dim $iMsgBoxAnswer" & @CRLF & _
									"iMsgBoxAnswer = MsgBox(" & tc26_SetFlag($iFlag) & "," & Chr(34) & GUICtrlRead($TITLE) & Chr(34) & "," _
									 & Chr(34) & $sText & Chr(34) & "," & GUICtrlRead($Timeout) & ")" & @CRLF & _
									"Select" & @CRLF & _
									"   Case $iMsgBoxAnswer = 6  ;Yes" & @CRLF & @CRLF & _
									"   Case $iMsgBoxAnswer = 7  ;No" & @CRLF & @CRLF & _
									"   Case $iMsgBoxAnswer = -1 ;Timeout" & @CRLF & @CRLF & _
									"EndSelect"
						EndIf

					Case $Button = $optYesNoCancel
						If GUICtrlRead($Timeout) = "" Then
							$msgbox = "Dim $iMsgBoxAnswer" & @CRLF & _
									"$iMsgBoxAnswer = MsgBox(" & tc26_SetFlag($iFlag) & "," & Chr(34) & GUICtrlRead($TITLE) & Chr(34) & "," _
									 & Chr(34) & $sText & Chr(34) & ")" & @CRLF & _
									"Select" & @CRLF & _
									"   Case $iMsgBoxAnswer = 6 ;Yes" & @CRLF & @CRLF & _
									"   Case $iMsgBoxAnswer = 7 ;No" & @CRLF & @CRLF & _
									"   Case $iMsgBoxAnswer = 2 ;Cancel" & @CRLF & @CRLF & _
									"EndSelect"
						Else
							$msgbox = "Dim $iMsgBoxAnswer" & @CRLF & _
									"$iMsgBoxAnswer = MsgBox(" & tc26_SetFlag($iFlag) & "," & Chr(34) & GUICtrlRead($TITLE) & Chr(34) & "," _
									 & Chr(34) & $sText & Chr(34) & "," & GUICtrlRead($Timeout) & ")" & @CRLF & _
									"Select" & @CRLF & _
									"   Case $iMsgBoxAnswer = 6  ;Yes" & @CRLF & @CRLF & _
									"   Case $iMsgBoxAnswer = 7  ;No" & @CRLF & @CRLF & _
									"   Case $iMsgBoxAnswer = 2  ;Cancel" & @CRLF & @CRLF & _
									"   Case $iMsgBoxAnswer = -1 ;Timeout" & @CRLF & @CRLF & _
									"EndSelect"
						EndIf

					Case $Button = $optAbortRetryIgnore
						If GUICtrlRead($Timeout) = "" Then
							$msgbox = "Dim $iMsgBoxAnswer" & @CRLF & _
									"$iMsgBoxAnswer = MsgBox(" & tc26_SetFlag($iFlag) & "," & Chr(34) & GUICtrlRead($TITLE) & Chr(34) & "," _
									 & Chr(34) & $sText & Chr(34) & ")" & @CRLF & _
									"Select" & @CRLF & _
									"   Case $iMsgBoxAnswer = 3 ;Abort" & @CRLF & @CRLF & _
									"   Case $iMsgBoxAnswer = 4 ;Retry" & @CRLF & @CRLF & _
									"   Case $iMsgBoxAnswer = 5 ;Ignore" & @CRLF & @CRLF & _
									"EndSelect"
						Else
							$msgbox = "Dim $iMsgBoxAnswer" & @CRLF & _
									"$iMsgBoxAnswer = MsgBox(" & tc26_SetFlag($iFlag) & "," & Chr(34) & GUICtrlRead($TITLE) & Chr(34) & "," _
									 & Chr(34) & $sText & Chr(34) & "," & GUICtrlRead($Timeout) & ")" & @CRLF & _
									"Select" & @CRLF & _
									"   Case $iMsgBoxAnswer = 3  ;Abort" & @CRLF & @CRLF & _
									"   Case $iMsgBoxAnswer = 4  ;Retry" & @CRLF & @CRLF & _
									"   Case $iMsgBoxAnswer = 5  ;Ignore" & @CRLF & @CRLF & _
									"   Case $iMsgBoxAnswer = -1 ;Timeout" & @CRLF & @CRLF & _
									"EndSelect"
						EndIf

					Case $Button = $optRetryCancel
						If GUICtrlRead($Timeout) = "" Then
							$msgbox = "Dim $iMsgBoxAnswer" & @CRLF & _
									"$iMsgBoxAnswer = MsgBox(" & tc26_SetFlag($iFlag) & "," & Chr(34) & GUICtrlRead($TITLE) & Chr(34) & "," _
									 & Chr(34) & $sText & Chr(34) & ")" & @CRLF & _
									"Select" & @CRLF & _
									"   Case $iMsgBoxAnswer = 4 ;Retry" & @CRLF & @CRLF & _
									"   Case $iMsgBoxAnswer = 2 ;Cancel" & @CRLF & @CRLF & _
									"EndSelect"
						Else
							$msgbox = "Dim $iMsgBoxAnswer" & @CRLF & _
									"$iMsgBoxAnswer = MsgBox(" & tc26_SetFlag($iFlag) & "," & Chr(34) & GUICtrlRead($TITLE) & Chr(34) & "," _
									 & Chr(34) & $sText & Chr(34) & "," & GUICtrlRead($Timeout) & ")" & @CRLF & _
									"Select" & @CRLF & _
									"   Case $iMsgBoxAnswer = 4  ;Retry" & @CRLF & @CRLF & _
									"   Case $iMsgBoxAnswer = 2  ;Cancel" & @CRLF & @CRLF & _
									"   Case $iMsgBoxAnswer = -1 ;Timeout" & @CRLF & @CRLF & _
									"EndSelect"
						EndIf

					Case $Button = $optCancelRetryContinue
						If GUICtrlRead($Timeout) = "" Then
							$msgbox = "Dim $iMsgBoxAnswer" & @CRLF & _
									"$iMsgBoxAnswer = MsgBox(" & tc26_SetFlag($iFlag) & "," & Chr(34) & GUICtrlRead($TITLE) & Chr(34) & "," _
									 & Chr(34) & $sText & Chr(34) & ")" & @CRLF & _
									"Select" & @CRLF & _
									"   Case $iMsgBoxAnswer = 2 ;Cancel" & @CRLF & @CRLF & _
									"   Case $iMsgBoxAnswer = 10 ;Try Again" & @CRLF & @CRLF & _
									"   Case $iMsgBoxAnswer = 11 ;Continue" & @CRLF & @CRLF & _
									"EndSelect"
						Else
							$msgbox = "Dim $iMsgBoxAnswer" & @CRLF & _
									"$iMsgBoxAnswer = MsgBox(" & tc26_SetFlag($iFlag) & "," & Chr(34) & GUICtrlRead($TITLE) & Chr(34) & "," _
									 & Chr(34) & $sText & Chr(34) & "," & GUICtrlRead($Timeout) & ")" & @CRLF & _
									"Select" & @CRLF & _
									"   Case $iMsgBoxAnswer = 2  ;Cancel" & @CRLF & @CRLF & _
									"   Case $iMsgBoxAnswer = 10 ;Try Again" & @CRLF & @CRLF & _
									"   Case $iMsgBoxAnswer = 11 ;Continue" & @CRLF & @CRLF & _
									"   Case $iMsgBoxAnswer = -1 ;Timeout" & @CRLF & @CRLF & _
									"EndSelect"
						EndIf
				EndSelect

				ClipPut($msgbox)
		EndSelect

	WEnd
 EndFunc
 
 ;===============================================================================
;
; Function Name:    _SetFlag()
; Description:      Set the flag that indicates the type of message box and the
;                   possible button combinations.
; Parameter(s):     $iFlag        - Flag
; Requirement(s):   None
; Return Value(s):  On Success - Returns the message box flag
;                   None
; Author(s):        Giuseppe Criaco <gcriaco@quipo.it>
;
;===============================================================================
;

Func tc26_SetFlag($iFlag)
	$iFlag = 0

	;Icons
	Select
		Case GUICtrlRead($optWarning) = $GUI_CHECKED
			$iFlag = $iFlag + 48
		Case GUICtrlRead($optInfo) = $GUI_CHECKED
			$iFlag = $iFlag + 64
		Case GUICtrlRead($optCritical) = $GUI_CHECKED
			$iFlag = $iFlag + 16
		Case GUICtrlRead($optQuestion) = $GUI_CHECKED
			$iFlag = $iFlag + 32
	EndSelect

	;Modality
	Select
		Case GUICtrlRead($optSysModal) = $GUI_CHECKED
			$iFlag = $iFlag + 4096
		Case GUICtrlRead($optTaskModal) = $GUI_CHECKED
			$iFlag = $iFlag + 8192
	EndSelect

	;Buttons
	Select
		Case GUICtrlRead($optOkCancel) = $GUI_CHECKED
			$iFlag = $iFlag + 1
		Case GUICtrlRead($optYesNo) = $GUI_CHECKED
			$iFlag = $iFlag + 4
		Case GUICtrlRead($optYesNoCancel) = $GUI_CHECKED
			$iFlag = $iFlag + 3
		Case GUICtrlRead($optAbortRetryIgnore) = $GUI_CHECKED
			$iFlag = $iFlag + 2
		Case GUICtrlRead($optRetryCancel) = $GUI_CHECKED
			$iFlag = $iFlag + 5
		Case GUICtrlRead($optCancelRetryContinue) = $GUI_CHECKED
			$iFlag = $iFlag + 6
	EndSelect

	;Miscellaneous
	Select
		Case GUICtrlRead($optTopMost) = $GUI_CHECKED
			$iFlag = $iFlag + 262144
		Case GUICtrlRead($optRightJust) = $GUI_CHECKED
			$iFlag = $iFlag + 5244288
	EndSelect

	;Default Buttons
	Select
		Case GUICtrlRead($optSecond) = $GUI_CHECKED
			$iFlag = $iFlag + 256
		Case GUICtrlRead($optThird) = $GUI_CHECKED
			$iFlag = $iFlag + 512
	EndSelect

	Return $iFlag
EndFunc   ;==>_SetFlag
 
#endregion

#region "..\AutoIt3\Examples\GUI\Advanced\Rotate.au3"
;===========================================================
;..\AutoIt3\Examples\GUI\Advanced\Rotate.au3
;===========================================================
Func tc27 ()
   ; ===============================================================================================================================
   ; Description ...: Shows how to rotate an image
   ; Author ........: Paul Campbell (PaulIA)
   ; Notes .........:
   ; ===============================================================================================================================

   ; ===============================================================================================================================
   ; Global variables
   ; ===============================================================================================================================
   Local $hBitmap, $hImage, $sCLSID, $tData, $tParams

   ; ===============================================================================================================================
   ; Main
   ; ===============================================================================================================================

   ; Capture screen
   $logContent = $logContent & "Capture the screen to " & @ScriptDir & '\Images\AutoItImage.jpg' & @CRLF
   _ScreenCapture_Capture(@ScriptDir & '\Images\AutoItImage.jpg')

   ; Initialize GDI+ library
   _GDIPlus_Startup()

   ; Load image
   $logContent = $logContent & "Load image from " & @ScriptDir & '\Images\AutoItImage.jpg' & @CRLF
   $hImage = _GDIPlus_ImageLoadFromFile(@ScriptDir & '\Images\AutoItImage.jpg')

   ; Get JPG encoder CLSID
   $sCLSID = _GDIPlus_EncodersGetCLSID("JPG")

   ; Set up parameters for 90 degree rotation
   $tData = DllStructCreate("int Data")
   DllStructSetData($tData, "Data", $GDIP_EVTTRANSFORMROTATE90)
   $tParams = _GDIPlus_ParamInit(1)
   _GDIPlus_ParamAdd($tParams, $GDIP_EPGTRANSFORMATION, 1, $GDIP_EPTLONG, DllStructGetPtr($tData, "Data"))

   ; Save image with rotation
   $logContent = $logContent & "Rotate image and save to " & @ScriptDir & '\Images\AutoItImage2.jpg' & @CRLF
   _GDIPlus_ImageSaveToFileEx($hImage, @ScriptDir & '\Images\AutoItImage2.jpg', $sCLSID, DllStructGetPtr($tParams))

   ; Shut down GDI+ library
   _GDIPlus_Shutdown()

   ; Show image
   $logContent = $logContent & "Open image by MS Paint" & @CRLF
   Local $PID = Run("MSPaint.exe " & '"' & @MyDocumentsDir & '\AutoItImage2.jpg"')
   
   Sleep(4000)

   If $PID Then ProcessClose($PID)
   
   MsgBox(0, "Rotate demo", "The screen has captured and rotated", 2)
   
EndFunc

#endregion

#region "..\AutoIt3\Examples\GUI\Advanced\setlabel.au3"
;===========================================================
;..\AutoIt3\Examples\GUI\Advanced\setlabel.au3
;===========================================================
Func tc28 ()
   Local $Label_1, $Combo_2, $button1, $msg, $data

	; Create the GUI window and controls
	$GuiHnd = GUICreate("MyGUI", 191, 157, (@DesktopWidth - 191) / 2, (@DesktopHeight - 157) / 2)
	$Label_1 = GUICtrlCreateLabel("Label1", 30, 40, 131, 21, 0x1000)
	$Combo_2 = GUICtrlCreateCombo("", 30, 60, 130, 21)
	GUICtrlSetData($Combo_2, "Item1|Item2|Item3|Item4|Item5")
	$button1 = GUICtrlCreateButton("Set Label", 30, 90, 130, 20)

	; Run the GUI until it is closed
	GUISetState()
	
	Local $timerInit = TimerInit()
   Local $controlID = 1
   Local $elapseTime = 0
	
	While 1
	   $elapseTime = TimerDiff($timerInit)
   
	  If $elapseTime > 2000 Then
		 $timerInit = TimerInit()	  
		 If $controlID = 1 Then
			$controlID = 2
			_GUICtrlComboBox_SetCurSel($Combo_2, 2)
		 ElseIf $controlID = 2 Then
			$controlID = 3
			ControlClick($GuiHnd, "", $button1)
		 Else
			WinClose($GuiHnd)
		 EndIf
	  EndIf	  
	
		$msg = GUIGetMsg()
		Select
			Case $msg = $GUI_EVENT_CLOSE
			   $logContent = $logContent & "User click on Close icon" & @CRLF
				ExitLoop
				;When button is pressed, label text is changed
				;to combobox value
			 Case $msg = $button1
				$logContent = $logContent & "User click on St Label button" & @CRLF
				$data = GUICtrlRead($Combo_2)
				GUICtrlSetData($Label_1, $data)
		EndSelect
	WEnd
	Return
	
 EndFunc
 
#endregion

#region "..\AutoIt3\Examples\GUI\Advanced\ShowPNG.au3"
;===========================================================
;..\AutoIt3\Examples\GUI\Advanced\ShowPNG.au3
;===========================================================
Func tc29 ()
   ; ===============================================================================================================================
   ; Description ...: Shows how to display a PNG image
   ; Author ........: Paul Campbell (PaulIA)
   ; Notes .........:
   ; ===============================================================================================================================

   ; ===============================================================================================================================
   ; Global variables
   ; ===============================================================================================================================
   Local $hGUI, $hImage, $hGraphic

   ; Create GUI
   $hGUI = GUICreate("Show PNG", 240, 240)
   GUISetState()

   ; Load PNG image
   _GDIPlus_Startup()
   $hImage = _GDIPlus_ImageLoadFromFile( @ScriptDir & "\Images\Untitled2.png")
   $logContent = $logContent & "Load image from " & @ScriptDir & "\Images\Untitled2.png" & @CRLF

   ; Draw PNG image
   $hGraphic = _GDIPlus_GraphicsCreateFromHWND($hGUI)
   _GDIPlus_GraphicsDrawImage($hGraphic, $hImage, 0, 0)
   
   $Timer = _Timer_SetTimer($hGUI, 3000, "tc29_Quit")

   ; Loop until user exits
   Do
   Until GUIGetMsg() = $GUI_EVENT_CLOSE
   
   $logContent = $logContent & "User click on Close icon" & @CRLF

   ; Clean up resources
   _GDIPlus_GraphicsDispose($hGraphic)
   _GDIPlus_ImageDispose($hImage)
   _GDIPlus_Shutdown()
   Return
   
EndFunc

;close form if timeout
 Func tc29_Quit($hWnd, $Msg, $iIDTimer, $dwTime)
   _Timer_KillTimer($hWnd,$iIDTimer)
   WinClose($hWnd)
EndFunc

#endregion

#region "..\AutoIt3\Examples\GUI\Advanced\Slicer.au3"
;===========================================================
;..\AutoIt3\Examples\GUI\Advanced\Slicer.au3
;===========================================================
Func tc30 ()
   ; ===============================================================================================================================
   ; Description ...: Shows how to slice up an image and then put it back together
   ; Author ........: Paul Campbell (PaulIA)
   ; Notes .........:
   ; ===============================================================================================================================

   ; ===============================================================================================================================
   ; Global variables
   ; ===============================================================================================================================
   Local $iI, $hBitmap, $hGraphic, $hGUI, $hImage, $aSlice[4]

   ; ===============================================================================================================================
   ; Main
   ; ===============================================================================================================================

   ; Capture screen region
   $hBitmap = _ScreenCapture_Capture("", 0, 0, 400, 400)
   $logContent = $logContent & "Capture screen" & @CRLF

   ; Create GUI
   $hGUI = GUICreate("Slicer", 400, 400)
   GUISetState()
   $Timer = _Timer_SetTimer($hGUI, 10000, "tc30_Quit")

   ; Initialize GDI+ library
   _GDIPlus_Startup()

   ; Slice up screen capture into 4 equal parts
   $logContent = $logContent & "Slice up screen capture into 4 equal parts" & @CRLF   
   $hImage = _GDIPlus_BitmapCreateFromHBITMAP($hBitmap)
   $aSlice[0] = _GDIPlus_BitmapCloneArea($hImage, 0, 0, 200, 200)
   $aSlice[1] = _GDIPlus_BitmapCloneArea($hImage, 200, 0, 200, 200)
   $aSlice[2] = _GDIPlus_BitmapCloneArea($hImage, 0, 200, 200, 200)
   $aSlice[3] = _GDIPlus_BitmapCloneArea($hImage, 200, 200, 200, 200)

   ; Show each slice
   $hGraphic = _GDIPlus_GraphicsCreateFromHWND($hGUI)
   For $iI = 0 To 3
	   _GDIPlus_GraphicsDrawImage($hGraphic, $aSlice[$iI], 100, 100)
	   $logContent = $logContent & "Show slice " & ($iI + 1) & @CRLF
	   Sleep(2000)
   Next

   ; Stitch slices back together again and display
   $logContent = $logContent & "Stitch slices back together again and display" & @CRLF
   _GDIPlus_GraphicsDrawImage($hGraphic, $aSlice[0], 0, 0)
   _GDIPlus_GraphicsDrawImage($hGraphic, $aSlice[1], 200, 0)
   _GDIPlus_GraphicsDrawImage($hGraphic, $aSlice[2], 0, 200)
   _GDIPlus_GraphicsDrawImage($hGraphic, $aSlice[3], 200, 200)

   ; Loop until user exits
   Do
   Until GUIGetMsg() = $GUI_EVENT_CLOSE
   $logContent = $logContent & "User click on Close iccon" & @CRLF

   ; Clean up resources
   _GDIPlus_GraphicsDispose($hGraphic)
   _GDIPlus_ImageDispose($aSlice[0])
   _GDIPlus_ImageDispose($aSlice[1])
   _GDIPlus_ImageDispose($aSlice[2])
   _GDIPlus_ImageDispose($aSlice[3])
   _GDIPlus_GraphicsDispose($hImage)
   _WinAPI_DeleteObject($hBitmap)

   ; Shut down GDI+ library
   _GDIPlus_Shutdown()
EndFunc

;close form if timeout
 Func tc30_Quit($hWnd, $Msg, $iIDTimer, $dwTime)
   _Timer_KillTimer($hWnd,$iIDTimer)
   ;MsgBox(0, "Slice", "Time out", 2)
   WinClose($hWnd)
   ;$logContent = $logContent & "Timeout" & @CRLF
EndFunc

#endregion

#region "..\AutoIt3\Examples\GUI\Advanced\sysinfo.au3"
;===========================================================
;..\AutoIt3\Examples\GUI\Advanced\sysinfo.au3
;===========================================================
Func tc31 ()
   Local $VOL, $SERIAL, $TOTAL, $FREE
	Local $Input_ComputerName, $Input_CurrentUserName, $Input_OperatingSystem
	Local $Input_ServicePack, $Input_VolumeLabel, $Input_SerialNumber
	Local $Input_TotalSpace, $Input_FreeSpace, $Input_IpAddress, $Input_StartupDirectory
	Local $Input_WindowsDirectory, $Input_SystemFolderDirectory, $Input_DesktopDirectory
	Local $Input_MyDocumentsDirectory, $Input_ProgramFilesDirectory, $Input_StartMenuDirectory
	Local $Input_TemporaryFileDirectory, $Input_DesktopWidth, $Input_DesktopHeight
	Local $Input_Date, $Input_Time, $msg

	#forceref $Input_ComputerName, $Input_CurrentUserName, $Input_OperatingSystem
	#forceref $Input_ServicePack, $Input_VolumeLabel, $Input_SerialNumber
	#forceref $Input_TotalSpace, $Input_FreeSpace, $Input_IpAddress, $Input_StartupDirectory
	#forceref $Input_WindowsDirectory, $Input_SystemFolderDirectory, $Input_DesktopDirectory
	#forceref $Input_MyDocumentsDirectory, $Input_ProgramFilesDirectory, $Input_StartMenuDirectory
	#forceref $Input_TemporaryFileDirectory, $Input_DesktopWidth, $Input_DesktopHeight
	#forceref $Input_Date, $Input_Time

	$GuiHnd = GUICreate("Computer Information - By : Para", 469, 639, (@DesktopWidth - 469) / 2, (@DesktopHeight - 639) / 2, $WS_OVERLAPPEDWINDOW + $WS_VISIBLE + $WS_CLIPSIBLINGS)

	$VOL = DriveGetLabel("C:\")
	$logContent = $logContent & "Get volumn C label: " & $VOL & @CRLF
	
	$SERIAL = DriveGetSerial("C:\")
	$logContent = $logContent & "Get volumn C serial: " & $SERIAL & @CRLF
		
	$TOTAL = DriveSpaceTotal("C:\")
	$logContent = $logContent & "Get volumn C space total: " & $TOTAL & @CRLF
	
	
	$FREE = DriveSpaceFree("C:\")
	$logContent = $logContent & "Get volumn C space free: " & $FREE & @CRLF

	GUICtrlCreateLabel("Computer Name", 10, 10, 150, 20)
	GUICtrlCreateLabel("Current User Name", 10, 40, 150, 20)
	GUICtrlCreateLabel("Operating System", 10, 70, 150, 20)
	GUICtrlCreateLabel("Service Pack", 10, 100, 150, 20)
	GUICtrlCreateLabel("C: Volume Label", 10, 130, 150, 20)
	GUICtrlCreateLabel("C: Serial Number", 10, 160, 150, 20)
	GUICtrlCreateLabel("C: Total Space", 10, 190, 150, 20)
	GUICtrlCreateLabel("C: Free Space", 10, 220, 150, 20)
	GUICtrlCreateLabel("Ip Address", 10, 250, 150, 20)
	GUICtrlCreateLabel("Startup Directory", 10, 280, 150, 20)
	GUICtrlCreateLabel("Windows Directory", 10, 310, 150, 20)
	GUICtrlCreateLabel("System Folder Directory", 10, 340, 150, 20)
	GUICtrlCreateLabel("Desktop Directory", 10, 370, 150, 20)
	GUICtrlCreateLabel("My Documents Directory", 10, 400, 150, 20)
	GUICtrlCreateLabel("Program File Directory", 10, 430, 150, 20)
	GUICtrlCreateLabel("Start Menu Directory", 10, 460, 150, 20)
	GUICtrlCreateLabel("Desktop Width (Pixels)", 10, 520, 150, 20)
	GUICtrlCreateLabel("Temporary File Directory", 10, 490, 150, 20)
	GUICtrlCreateLabel("Desktop Height (Pixels)", 10, 550, 150, 20)
	GUICtrlCreateLabel("Date", 10, 580, 150, 20)
	GUICtrlCreateLabel("Time", 10, 610, 150, 20)
	
	$Input_ComputerName = GUICtrlCreateInput("" & @ComputerName, 180, 10, 280, 20)
	$logContent = $logContent & "Computer name: " & @ComputerName & @CRLF
	
	$Input_CurrentUserName = GUICtrlCreateInput("" & @UserName, 180, 40, 280, 20)
	$logContent = $logContent & "User name: " & @UserName & @CRLF
	
	$Input_OperatingSystem = GUICtrlCreateInput("" & @OSType, 180, 70, 280, 20)
	$logContent = $logContent & "OS type: " & @OSType & @CRLF
	
	$Input_ServicePack = GUICtrlCreateInput("" & @OSServicePack, 180, 100, 280, 20)
	$logContent = $logContent & "OS service pack: " & @OSServicePack & @CRLF
	
	$Input_VolumeLabel = GUICtrlCreateInput("" & $VOL, 180, 130, 280, 20)
	$logContent = $logContent & "Volume: " & $VOL & @CRLF
	
	$Input_SerialNumber = GUICtrlCreateInput("" & $SERIAL, 180, 160, 280, 20)
	$logContent = $logContent & "Serial: " & $SERIAL & @CRLF
	
	$Input_TotalSpace = GUICtrlCreateInput("" & $TOTAL, 180, 190, 280, 20)
	$logContent = $logContent & "Driver space total: " & $TOTAL & @CRLF
	
	$Input_FreeSpace = GUICtrlCreateInput("" & $FREE, 180, 220, 280, 20)
	$logContent = $logContent & "Driver space free: " & $FREE & @CRLF
	
	$Input_IpAddress = GUICtrlCreateInput("" & @IPAddress1, 180, 250, 280, 20)
	$logContent = $logContent & "IP Address: " & @IPAddress1 & @CRLF
	
	$Input_StartupDirectory = GUICtrlCreateInput("" & @StartupDir, 180, 280, 280, 20)
	$logContent = $logContent & "Start up directory: " & @StartupDir & @CRLF
	
	$Input_WindowsDirectory = GUICtrlCreateInput("" & @WindowsDir, 180, 310, 280, 20)
	$logContent = $logContent & "Window directory: " & @WindowsDir & @CRLF
	
	$Input_SystemFolderDirectory = GUICtrlCreateInput("" & @SystemDir, 180, 340, 280, 20)
	$logContent = $logContent & "System directory: " & @SystemDir & @CRLF
	
	$Input_DesktopDirectory = GUICtrlCreateInput("" & @DesktopDir, 180, 370, 280, 20)
	$logContent = $logContent & "Desktop directory: " & @DesktopDir & @CRLF
	
	$Input_MyDocumentsDirectory = GUICtrlCreateInput("" & @MyDocumentsDir, 180, 400, 280, 20)
	$logContent = $logContent & "Document directory: " & @MyDocumentsDir & @CRLF
	
	$Input_ProgramFilesDirectory = GUICtrlCreateInput("" & @ProgramFilesDir, 180, 430, 280, 20)
	$logContent = $logContent & "Program File directory: " & @ProgramFilesDir & @CRLF
	
	$Input_StartMenuDirectory = GUICtrlCreateInput("" & @StartMenuDir, 180, 460, 280, 20)
	$logContent = $logContent & "Start Menu directory: " & @StartMenuDir & @CRLF
	
	$Input_TemporaryFileDirectory = GUICtrlCreateInput("" & @TempDir, 180, 490, 280, 20)
	$logContent = $logContent & "Temporary directory: " & @TempDir & @CRLF
	
	$Input_DesktopWidth = GUICtrlCreateInput("" & @DesktopWidth, 180, 520, 280, 20)
	$logContent = $logContent & "Descktop width: " & @DesktopWidth & @CRLF
	
	$Input_DesktopHeight = GUICtrlCreateInput("" & @DesktopHeight, 180, 550, 280, 20)
	$logContent = $logContent & "Descktop height: " & @DesktopHeight & @CRLF
	
	$Input_Date = GUICtrlCreateInput("(MONTH)(DAY)(YEAR) " & @MON & "-" & @MDAY & "-" & @YEAR, 180, 580, 280, 20)
	$logContent = $logContent & "System Date: " & @MON & "-" & @MDAY & "-" & @YEAR & @CRLF
	
	$Input_Time = GUICtrlCreateInput("(HOUR)(MIN)(SEC) " & @HOUR & ":" & @MIN & ":" & @SEC, 180, 610, 280, 20)
	$logContent = $logContent & "System Time: " & @HOUR & ":" & @MIN & ":" & @SEC & @CRLF

	GUISetState()
	$Timer = _Timer_SetTimer($GuiHnd, 4000, "tc31_Quit")
	$logContent = $logContent & "Show form information" & @CRLF
	
	While 1
		$msg = GUIGetMsg()
		Select
			Case $msg = $GUI_EVENT_CLOSE
			   $logContent = $logContent & "User click on Close icon" & @CRLF
				ExitLoop
			Case Else
				;;;
		EndSelect
	WEnd
	Return
	
 EndFunc
 
 ;close form if timeout
 Func tc31_Quit($hWnd, $Msg, $iIDTimer, $dwTime)
   _Timer_KillTimer($hWnd,$iIDTimer)
   WinClose($hWnd)
EndFunc

#endregion

#region "..\AutoIt3\Examples\GUI\Advanced\treeview.au3"
;===========================================================
;..\AutoIt3\Examples\GUI\Advanced\treeview.au3
;===========================================================
Func tc32 ()
   Local $maintree, $aboutitem, $generalitem, $toolsitem, $effectitem, $styleitem
	Local $cmditem, $miscitem, $descgroup, $effectsgroup, $effectstree
	Local $effect1, $effect2, $effect3, $effect4, $effect5
	Local $stylesgroup, $stylestree, $style1, $style2, $style3, $style4, $style5
	Local $aboutlabel, $cancelbutton, $msg

	#forceref $cmditem, $miscitem, $effect2, $effect4, $effect5, $style1, $style2, $style3

	$GuiHnd = GUICreate("GUI with more treeviews", 340, 200, -1, -1, BitOR($WS_MINIMIZEBOX, $WS_MAXIMIZEBOX, $WS_GROUP, $WS_CAPTION, $WS_POPUP, $WS_SYSMENU))

	$maintree = GUICtrlCreateTreeView(10, 10, 120, 150)
	$aboutitem = GUICtrlCreateTreeViewItem("About", $maintree)
	$generalitem = GUICtrlCreateTreeViewItem("General", $maintree)
	$toolsitem = GUICtrlCreateTreeViewItem("Tools", $maintree)
	$effectitem = GUICtrlCreateTreeViewItem("Effects", $generalitem)
	$styleitem = GUICtrlCreateTreeViewItem("Styles", $generalitem)
	$cmditem = GUICtrlCreateTreeViewItem("Commandline", $toolsitem)
	$miscitem = GUICtrlCreateTreeViewItem("Misc", $toolsitem)

	$descgroup = GUICtrlCreateGroup("Description", 140, 105, 180, 55)
	GUICtrlSetState(-1, $GUI_HIDE)

	$effectsgroup = GUICtrlCreateGroup("Effects", 140, 5, 180, 95)
	GUICtrlSetState(-1, $GUI_HIDE)
	$effectstree = GUICtrlCreateTreeView(150, 20, 160, 70, BitOR($TVS_CHECKBOXES, $TVS_DISABLEDRAGDROP), $WS_EX_CLIENTEDGE)
	GUICtrlSetState(-1, $GUI_HIDE)
	$effect1 = GUICtrlCreateTreeViewItem("Effect 1", $effectstree)
	$effect2 = GUICtrlCreateTreeViewItem("Effect 2", $effectstree)
	$effect3 = GUICtrlCreateTreeViewItem("Effect 3", $effectstree)
	$effect4 = GUICtrlCreateTreeViewItem("Effect 4", $effectstree)
	$effect5 = GUICtrlCreateTreeViewItem("Effect 5", $effectstree)

	$stylesgroup = GUICtrlCreateGroup("Styles", 140, 5, 180, 95)
	GUICtrlSetState(-1, $GUI_HIDE)
	$stylestree = GUICtrlCreateTreeView(150, 20, 160, 70, BitOR($TVS_CHECKBOXES, $TVS_DISABLEDRAGDROP), $WS_EX_CLIENTEDGE)
	GUICtrlSetState(-1, $GUI_HIDE)
	$style1 = GUICtrlCreateTreeViewItem("Style 1", $stylestree)
	$style2 = GUICtrlCreateTreeViewItem("Style 2", $stylestree)
	$style3 = GUICtrlCreateTreeViewItem("Style 3", $stylestree)
	$style4 = GUICtrlCreateTreeViewItem("Style 4", $stylestree)
	$style5 = GUICtrlCreateTreeViewItem("Style 5", $stylestree)

	$aboutlabel = GUICtrlCreateLabel("This is only a treeview demo.", 160, 80, 160, 20)

	$cancelbutton = GUICtrlCreateButton("Cancel", 130, 170, 70, 20)
	GUISetState()
	
	GUICtrlSetState($effect1, $GUI_CHECKED)
	GUICtrlSetState($effect3, $GUI_CHECKED)
	GUICtrlSetState($style4, $GUI_CHECKED)
	GUICtrlSetState($style5, $GUI_CHECKED)
	
	$logContent = $logContent & "Build tree view" & @CRLF
	
   Local $timerInit = TimerInit()
   Local $controlID = 1
   Local $elapseTime = 0
	
	While 1
	   $elapseTime = TimerDiff($timerInit)
   
	  If $elapseTime > 2000 Then
		 $timerInit = TimerInit()	  
		 If $controlID = 1 Then
			$controlID = 2
			GUICtrlSetState($generalitem, $GUI_EXPAND)
			Send("{DOWN}")
			Send("{DOWN}")
		 ElseIf $controlID = 2 Then
			$controlID = 3
			Send("{DOWN}")			
		 Else
			ControlClick($GuiHnd, "", $cancelbutton)
		 EndIf
	  EndIf
	  
		$msg = GUIGetMsg()
		Select
			Case $msg = -3 Or $msg = -1 Or $msg = $cancelbutton
			   $logContent = $logContent & "User click on Cancel button" & @CRLF
				ExitLoop
			Case $msg = $aboutitem
				GUICtrlSetState($descgroup, $GUI_HIDE)
				GUICtrlSetState($effectstree, $GUI_HIDE)
				GUICtrlSetState($effectsgroup, $GUI_HIDE)
				GUICtrlSetState($stylestree, $GUI_HIDE)
				GUICtrlSetState($stylesgroup, $GUI_HIDE)
				GUICtrlSetState($aboutlabel, $GUI_SHOW)
				$logContent = $logContent & "User click on About item" & @CRLF

			Case $msg = $effectitem
				GUICtrlSetState($stylestree, $GUI_HIDE)
				GUICtrlSetState($stylesgroup, $GUI_HIDE)
				GUICtrlSetState($aboutlabel, $GUI_HIDE)
				GUICtrlSetState($effectsgroup, $GUI_SHOW)
				GUICtrlSetState($descgroup, $GUI_SHOW)
				GUICtrlSetState($effectstree, $GUI_SHOW)
				GUICtrlSetBkColor($effectstree, 0xD0F0F0)
				;GUIctrlSetState...($effectstree,$GUI_SHOW)
				$logContent = $logContent & "User click on Effect item" & @CRLF

			Case $msg = $styleitem
				GUICtrlSetState($effectstree, $GUI_HIDE)
				GUICtrlSetState($effectsgroup, $GUI_HIDE)
				GUICtrlSetState($aboutlabel, $GUI_HIDE)
				GUICtrlSetState($stylesgroup, $GUI_SHOW)
				GUICtrlSetState($descgroup, $GUI_SHOW)
				;GUIctrlSetState.($stylestree,$GUI_SHOW)
				GUICtrlSetState($stylestree, $GUI_SHOW)
				GUICtrlSetColor($stylestree, 0xD00000)
				GUICtrlSetBkColor($stylestree, 0xD0FFD0)
				$logContent = $logContent & "User click on Style item" & @CRLF

		EndSelect
	WEnd

	GUIDelete()
	Return
	
EndFunc

#endregion

#region "..\AutoIt3\Examples\GUI\Advanced\Zoom.au3"
;===========================================================
;..\AutoIt3\Examples\GUI\Advanced\Zoom.au3
;===========================================================
Func tc33 ()
   ; ===============================================================================================================================
   ; Description ...: Shows how to magnify an image
   ; Author ........: Paul Campbell (PaulIA)
   ; Notes .........:
   ; ===============================================================================================================================

   ; ===============================================================================================================================
   ; Global variables
   ; ===============================================================================================================================

   Local $hBMP, $hGUI1, $hGUI2, $hBitmap, $hGraphic1, $hGraphic2

   ; ===============================================================================================================================
   ; Main
   ; ===============================================================================================================================

   ; Capture top left corner of the screen
   $logContent = $logContent & "Capture screen" & @CRLF
   $hBMP = _ScreenCapture_Capture("", 0, 0, 400, 300)

   ; Create a GUI for the original image
   $logContent = $logContent & "Create a GUI for the original image" & @CRLF
   $hGUI1 = GUICreate("Original", 400, 300, 0, 0)
   GUISetState()
   $Timer = _Timer_SetTimer($hGUI1, 4000, "tc33_Quit")

   ; Create a GUI for the zoomed image
   $logContent = $logContent & "Create a GUI for the zoomed image" & @CRLF
   $hGUI2 = GUICreate("Zoomed", 400, 300, 0, 400)
   GUISetState()

   ; Initialize GDI+ library and load image
   $logContent = $logContent & "Initialize GDI+ library and load image" & @CRLF
   _GDIPlus_Startup()
   $hBitmap = _GDIPlus_BitmapCreateFromHBITMAP($hBMP)

   ; Draw original image
   $logContent = $logContent & "Draw original image" & @CRLF
   $hGraphic1 = _GDIPlus_GraphicsCreateFromHWND($hGUI1)
   _GDIPlus_GraphicsDrawImage($hGraphic1, $hBitmap, 0, 0)
   
   ; Draw 2x zoomed image
   $logContent = $logContent & "Draw 2x zoomed image" & @CRLF
   $hGraphic2 = _GDIPlus_GraphicsCreateFromHWND($hGUI2)
   _GDIPlus_GraphicsDrawImageRectRect($hGraphic2, $hBitmap, 0, 0, 200, 200, 0, 0, 400, 300)

   ; Release resources
   _GDIPlus_GraphicsDispose($hGraphic1)
   _GDIPlus_GraphicsDispose($hGraphic2)
   _GDIPlus_ImageDispose($hBitmap)
   _WinAPI_DeleteObject($hBMP)
   _GDIPlus_Shutdown()

   ; Loop until user exits
   Do
   Until GUIGetMsg() = $GUI_EVENT_CLOSE
   
   $logContent = $logContent & "User click on Close icon" & @CRLF
   
   Return
   
EndFunc

;close form if timeout
 Func tc33_Quit($hWnd, $Msg, $iIDTimer, $dwTime)
   _Timer_KillTimer($hWnd,$iIDTimer)
   WinClose($hWnd)   
EndFunc

#endregion

EOF

print FoutIndexAutoItTraining $str;
	close FoutIndexAutoItTraining;
}


sub generateJmeter_genJmx_pl {
	my $jmeter_target = "jmeter.apache.org";

	if ($SvrProjName =~ /^\s*$c/) { ; } else { print "Warning: $c is missing. Exits\n"; exit; }
	if ( -e $SvrProjName ) {;} else { mkpath $SvrProjName; }
	open Fout_genJmx, ">$SvrProjName/genJmx.pl";
	print " -> $SvrProjName/genJmx.pl";
my $str=<<'EOF_genJmx';
$jmx=<<'EOF';
<?xml version="1.0" encoding="UTF-8"?>
<jmeterTestPlan version="1.2" properties="2.6" jmeter="2.11 r1554548">
  <hashTree>
    <TestPlan guiclass="TestPlanGui" testclass="TestPlan" testname="Thread Group" enabled="true">
      <stringProp name="TestPlan.comments"></stringProp>
      <boolProp name="TestPlan.functional_mode">false</boolProp>
      <boolProp name="TestPlan.serialize_threadgroups">false</boolProp>
      <elementProp name="TestPlan.user_defined_variables" elementType="Arguments" guiclass="ArgumentsPanel" testclass="Arguments" testname="User Defined Variables" enabled="true">
        <collectionProp name="Arguments.arguments"/>
      </elementProp>
      <stringProp name="TestPlan.user_define_classpath"></stringProp>
    </TestPlan>
    <hashTree>
      <ThreadGroup guiclass="ThreadGroupGui" testclass="ThreadGroup" testname="Jmeter Users" enabled="true">
        <stringProp name="ThreadGroup.on_sample_error">continue</stringProp>
        <elementProp name="ThreadGroup.main_controller" elementType="LoopController" guiclass="LoopControlPanel" testclass="LoopController" testname="Loop Controller" enabled="true">
          <boolProp name="LoopController.continue_forever">false</boolProp>
          <stringProp name="LoopController.loops">_Loop_Count_</stringProp>
        </elementProp>
        <stringProp name="ThreadGroup.num_threads">_Number_of_Threads_</stringProp>
        <stringProp name="ThreadGroup.ramp_time">_Ramp_Up_Period_</stringProp>
        <longProp name="ThreadGroup.start_time">1403181008000</longProp>
        <longProp name="ThreadGroup.end_time">1403181008000</longProp>
        <boolProp name="ThreadGroup.scheduler">false</boolProp>
        <stringProp name="ThreadGroup.duration"></stringProp>
        <stringProp name="ThreadGroup.delay"></stringProp>
      </ThreadGroup>
      <hashTree>
        <ConfigTestElement guiclass="HttpDefaultsGui" testclass="ConfigTestElement" testname="HTTP Request Defaults" enabled="true">
          <elementProp name="HTTPsampler.Arguments" elementType="Arguments" guiclass="HTTPArgumentsPanel" testclass="Arguments" testname="User Defined Variables" enabled="true">
            <collectionProp name="Arguments.arguments"/>
          </elementProp>
          <stringProp name="HTTPSampler.domain">__urlName__</stringProp>
          <stringProp name="HTTPSampler.port"></stringProp>
          <stringProp name="HTTPSampler.connect_timeout"></stringProp>
          <stringProp name="HTTPSampler.response_timeout"></stringProp>
          <stringProp name="HTTPSampler.protocol"></stringProp>
          <stringProp name="HTTPSampler.contentEncoding"></stringProp>
          <stringProp name="HTTPSampler.path"></stringProp>
          <stringProp name="HTTPSampler.concurrentPool">4</stringProp>
        </ConfigTestElement>
        <hashTree/>
        <HTTPSamplerProxy guiclass="HttpTestSampleGui" testclass="HTTPSamplerProxy" testname="Home Request" enabled="true">
          <elementProp name="HTTPsampler.Arguments" elementType="Arguments" guiclass="HTTPArgumentsPanel" testclass="Arguments" testname="User Defined Variables" enabled="true">
            <collectionProp name="Arguments.arguments"/>
          </elementProp>
          <stringProp name="HTTPSampler.domain"></stringProp>
          <stringProp name="HTTPSampler.port"></stringProp>
          <stringProp name="HTTPSampler.connect_timeout"></stringProp>
          <stringProp name="HTTPSampler.response_timeout"></stringProp>
          <stringProp name="HTTPSampler.protocol"></stringProp>
          <stringProp name="HTTPSampler.contentEncoding"></stringProp>
          <stringProp name="HTTPSampler.path">/</stringProp>
          <stringProp name="HTTPSampler.method">GET</stringProp>
          <boolProp name="HTTPSampler.follow_redirects">true</boolProp>
          <boolProp name="HTTPSampler.auto_redirects">false</boolProp>
          <boolProp name="HTTPSampler.use_keepalive">true</boolProp>
          <boolProp name="HTTPSampler.DO_MULTIPART_POST">false</boolProp>
          <boolProp name="HTTPSampler.monitor">false</boolProp>
          <stringProp name="HTTPSampler.embedded_url_re"></stringProp>
        </HTTPSamplerProxy>
        <hashTree/>
        <HTTPSamplerProxy guiclass="HttpTestSampleGui" testclass="HTTPSamplerProxy" testname="Change Request" enabled="true">
          <elementProp name="HTTPsampler.Arguments" elementType="Arguments" guiclass="HTTPArgumentsPanel" testclass="Arguments" testname="User Defined Variables" enabled="true">
            <collectionProp name="Arguments.arguments"/>
          </elementProp>
          <stringProp name="HTTPSampler.domain"></stringProp>
          <stringProp name="HTTPSampler.port"></stringProp>
          <stringProp name="HTTPSampler.connect_timeout"></stringProp>
          <stringProp name="HTTPSampler.response_timeout"></stringProp>
          <stringProp name="HTTPSampler.protocol"></stringProp>
          <stringProp name="HTTPSampler.contentEncoding"></stringProp>
          <stringProp name="HTTPSampler.path">/changes.html</stringProp>
          <stringProp name="HTTPSampler.method">GET</stringProp>
          <boolProp name="HTTPSampler.follow_redirects">true</boolProp>
          <boolProp name="HTTPSampler.auto_redirects">false</boolProp>
          <boolProp name="HTTPSampler.use_keepalive">true</boolProp>
          <boolProp name="HTTPSampler.DO_MULTIPART_POST">false</boolProp>
          <boolProp name="HTTPSampler.monitor">false</boolProp>
          <stringProp name="HTTPSampler.embedded_url_re"></stringProp>
        </HTTPSamplerProxy>
        <hashTree/>
        <ResultCollector guiclass="GraphVisualizer" testclass="ResultCollector" testname="Graph Results" enabled="true">
          <boolProp name="ResultCollector.error_logging">false</boolProp>
          <objProp>
            <name>saveConfig</name>
            <value class="SampleSaveConfiguration">
              <time>true</time>
              <latency>true</latency>
              <timestamp>true</timestamp>
              <success>true</success>
              <label>true</label>
              <code>true</code>
              <message>true</message>
              <threadName>true</threadName>
              <dataType>true</dataType>
              <encoding>false</encoding>
              <assertions>true</assertions>
              <subresults>true</subresults>
              <responseData>false</responseData>
              <samplerData>false</samplerData>
              <xml>false</xml>
              <fieldNames>false</fieldNames>
              <responseHeaders>false</responseHeaders>
              <requestHeaders>false</requestHeaders>
              <responseDataOnError>false</responseDataOnError>
              <saveAssertionResultsFailureMessage>false</saveAssertionResultsFailureMessage>
              <assertionsResultsToSave>0</assertionsResultsToSave>
              <bytes>true</bytes>
            </value>
          </objProp>
          <stringProp name="filename">__tsName__\_jmeter_graph.txt</stringProp>
        </ResultCollector>
        <hashTree/>
        <ResultCollector guiclass="SimpleDataWriter" testclass="ResultCollector" testname="Simple Data Writer" enabled="true">
          <boolProp name="ResultCollector.error_logging">false</boolProp>
          <objProp>
            <name>saveConfig</name>
            <value class="SampleSaveConfiguration">
              <time>false</time>
              <latency>true</latency>
              <timestamp>false</timestamp>
              <success>false</success>
              <label>false</label>
              <code>false</code>
              <message>false</message>
              <threadName>false</threadName>
              <dataType>false</dataType>
              <encoding>false</encoding>
              <assertions>false</assertions>
              <subresults>false</subresults>
              <responseData>false</responseData>
              <samplerData>false</samplerData>
              <xml>false</xml>
              <fieldNames>false</fieldNames>
              <responseHeaders>false</responseHeaders>
              <requestHeaders>false</requestHeaders>
              <responseDataOnError>false</responseDataOnError>
              <saveAssertionResultsFailureMessage>false</saveAssertionResultsFailureMessage>
              <assertionsResultsToSave>0</assertionsResultsToSave>
            </value>
          </objProp>
          <stringProp name="filename">__tsName__/_jmeter_data_writer.txt</stringProp>
        </ResultCollector>
        <hashTree/>
      </hashTree>
    </hashTree>
  </hashTree>
</jmeterTestPlan>
EOF

######################## NEW JMX
$jmx=<<'EOF';
<?xml version="1.0" encoding="UTF-8"?>
<jmeterTestPlan version="1.2" properties="2.6" jmeter="2.11 r1554548">
  <hashTree>
    <TestPlan guiclass="TestPlanGui" testclass="TestPlan" testname="Test Plan" enabled="true">
      <stringProp name="TestPlan.comments"></stringProp>
      <boolProp name="TestPlan.functional_mode">false</boolProp>
      <boolProp name="TestPlan.serialize_threadgroups">false</boolProp>
      <elementProp name="TestPlan.user_defined_variables" elementType="Arguments" guiclass="ArgumentsPanel" testclass="Arguments" testname="User Defined Variables" enabled="true">
        <collectionProp name="Arguments.arguments"/>
      </elementProp>
      <stringProp name="TestPlan.user_define_classpath"></stringProp>
    </TestPlan>
    <hashTree>
      <ThreadGroup guiclass="ThreadGroupGui" testclass="ThreadGroup" testname="JMeter Users" enabled="true">
        <stringProp name="ThreadGroup.on_sample_error">continue</stringProp>
        <elementProp name="ThreadGroup.main_controller" elementType="LoopController" guiclass="LoopControlPanel" testclass="LoopController" testname="Loop Controller" enabled="true">
          <boolProp name="LoopController.continue_forever">false</boolProp>
          <stringProp name="LoopController.loops">_Loop_Count_</stringProp>
        </elementProp>
        <stringProp name="ThreadGroup.num_threads">_Number_of_Threads_</stringProp>
        <stringProp name="ThreadGroup.ramp_time">_Ramp_Up_Period_</stringProp>
        <longProp name="ThreadGroup.start_time">1419573437000</longProp>
        <longProp name="ThreadGroup.end_time">1419573437000</longProp>
        <boolProp name="ThreadGroup.scheduler">false</boolProp>
        <stringProp name="ThreadGroup.duration"></stringProp>
        <stringProp name="ThreadGroup.delay"></stringProp>
      </ThreadGroup>
      <hashTree>
        <HTTPSamplerProxy guiclass="HttpTestSampleGui" testclass="HTTPSamplerProxy" testname="Home Page" enabled="true">
          <elementProp name="HTTPsampler.Arguments" elementType="Arguments" guiclass="HTTPArgumentsPanel" testclass="Arguments" testname="User Defined Variables" enabled="true">
            <collectionProp name="Arguments.arguments"/>
          </elementProp>
          <stringProp name="HTTPSampler.domain">__urlName__</stringProp>
          <stringProp name="HTTPSampler.port"></stringProp>
          <stringProp name="HTTPSampler.connect_timeout"></stringProp>
          <stringProp name="HTTPSampler.response_timeout"></stringProp>
          <stringProp name="HTTPSampler.protocol"></stringProp>
          <stringProp name="HTTPSampler.contentEncoding"></stringProp>
          <stringProp name="HTTPSampler.path">/</stringProp>
          <stringProp name="HTTPSampler.method">GET</stringProp>
          <boolProp name="HTTPSampler.follow_redirects">true</boolProp>
          <boolProp name="HTTPSampler.auto_redirects">false</boolProp>
          <boolProp name="HTTPSampler.use_keepalive">true</boolProp>
          <boolProp name="HTTPSampler.DO_MULTIPART_POST">false</boolProp>
          <boolProp name="HTTPSampler.monitor">false</boolProp>
          <stringProp name="HTTPSampler.embedded_url_re"></stringProp>
        </HTTPSamplerProxy>
        <hashTree/>
      </hashTree>
      <ConfigTestElement guiclass="HttpDefaultsGui" testclass="ConfigTestElement" testname="HTTP Request Defaults" enabled="true">
        <elementProp name="HTTPsampler.Arguments" elementType="Arguments" guiclass="HTTPArgumentsPanel" testclass="Arguments" testname="User Defined Variables" enabled="true">
          <collectionProp name="Arguments.arguments"/>
        </elementProp>
        <stringProp name="HTTPSampler.domain">jmeter.apache.org</stringProp>
        <stringProp name="HTTPSampler.port"></stringProp>
        <stringProp name="HTTPSampler.connect_timeout"></stringProp>
        <stringProp name="HTTPSampler.response_timeout"></stringProp>
        <stringProp name="HTTPSampler.protocol"></stringProp>
        <stringProp name="HTTPSampler.contentEncoding"></stringProp>
        <stringProp name="HTTPSampler.path"></stringProp>
        <stringProp name="HTTPSampler.concurrentPool">4</stringProp>
      </ConfigTestElement>
      <hashTree/>
      <CookieManager guiclass="CookiePanel" testclass="CookieManager" testname="HTTP Cookie Manager" enabled="true">
        <collectionProp name="CookieManager.cookies"/>
        <boolProp name="CookieManager.clearEachIteration">true</boolProp>
      </CookieManager>
      <hashTree/>
      <ResultCollector guiclass="GraphVisualizer" testclass="ResultCollector" testname="Graph Results" enabled="true">
        <boolProp name="ResultCollector.error_logging">false</boolProp>
        <objProp>
          <value class="SampleSaveConfiguration">
            <time>true</time>
            <latency>true</latency>
            <timestamp>true</timestamp>
            <success>true</success>
            <label>true</label>
            <code>true</code>
            <message>true</message>
            <threadName>true</threadName>
            <dataType>true</dataType>
            <encoding>false</encoding>
            <assertions>true</assertions>
            <subresults>true</subresults>
            <responseData>false</responseData>
            <samplerData>false</samplerData>
            <xml>false</xml>
            <fieldNames>false</fieldNames>
            <responseHeaders>false</responseHeaders>
            <requestHeaders>false</requestHeaders>
            <responseDataOnError>false</responseDataOnError>
            <saveAssertionResultsFailureMessage>false</saveAssertionResultsFailureMessage>
            <assertionsResultsToSave>0</assertionsResultsToSave>
            <bytes>true</bytes>
          </value>
        </objProp>
        <objProp>
          <value class="SampleSaveConfiguration">
            <time>false</time>
            <latency>true</latency>
            <timestamp>false</timestamp>
            <success>false</success>
            <label>false</label>
            <code>false</code>
            <message>false</message>
            <threadName>false</threadName>
            <dataType>false</dataType>
            <encoding>false</encoding>
            <assertions>false</assertions>
            <subresults>true</subresults>
            <responseData>false</responseData>
            <samplerData>false</samplerData>
            <xml>false</xml>
            <fieldNames>false</fieldNames>
            <responseHeaders>false</responseHeaders>
            <requestHeaders>false</requestHeaders>
            <responseDataOnError>false</responseDataOnError>
            <saveAssertionResultsFailureMessage>false</saveAssertionResultsFailureMessage>
            <assertionsResultsToSave>0</assertionsResultsToSave>
            <bytes>true</bytes>
          </value>
        </objProp>
        <stringProp name="filename"></stringProp>
      </ResultCollector>
      <hashTree/>
      <ResultCollector guiclass="SimpleDataWriter" testclass="ResultCollector" testname="Simple Data Writer" enabled="true">
        <boolProp name="ResultCollector.error_logging">false</boolProp>
        <objProp>
          <value class="SampleSaveConfiguration">
            <time>true</time>
            <latency>true</latency>
            <timestamp>true</timestamp>
            <success>true</success>
            <label>true</label>
            <code>true</code>
            <message>true</message>
            <threadName>true</threadName>
            <dataType>true</dataType>
            <encoding>false</encoding>
            <assertions>true</assertions>
            <subresults>true</subresults>
            <responseData>false</responseData>
            <samplerData>false</samplerData>
            <xml>false</xml>
            <fieldNames>false</fieldNames>
            <responseHeaders>false</responseHeaders>
            <requestHeaders>false</requestHeaders>
            <responseDataOnError>false</responseDataOnError>
            <saveAssertionResultsFailureMessage>false</saveAssertionResultsFailureMessage>
            <assertionsResultsToSave>0</assertionsResultsToSave>
            <bytes>true</bytes>
          </value>
        </objProp>
        <stringProp name="filename">__tsName__/_jmeter_data_writer.txt</stringProp>
      </ResultCollector>
      <hashTree/>
    </hashTree>
  </hashTree>
</jmeterTestPlan>

EOF
######################## NEW JMX

if (@ARGV) {
$tsname   		= "__tsName__"; $tsname   		= shift @ARGV if @ARGV;
$jmx_name 		= "__no_c_tsName__"	; $jmx_name 		= shift @ARGV if @ARGV;
$urlName    		= "jmeter.apache.org"	; $urlName    		= shift @ARGV if @ARGV;
$Number_of_threads 	= 5			; $Number_of_threads 	= shift @ARGV if @ARGV;
$Ramp_Up_Period  	= 1			; $Ramp_Up_Period 	= shift @ARGV if @ARGV;
$Loop_Count 		= 10			; $Loop_Count 		= shift @ARGV if @ARGV;

$jmx =~ s/_Number_of_Threads_/$Number_of_threads/g;
$jmx =~ s/_Ramp_Up_Period_/$Ramp_Up_Period/g;
$jmx =~ s/_Loop_Count_/$Loop_Count/g;
$jmx =~ s/__c__\/__no_c_tsName__/$tsname/gi;
$jmx =~ s/__urlName__/$urlName/gi;

open Fout , ">$tsname/$jmx_name"; print Fout $jmx; close Fout; print " -> $tsname/$jmx_name\n";
	}
	else {
print<<EOF;
	$0: tsname jmxName NofThread RampUp Loop targetUrl
	$0: "c:/jmeter_test" jmx_10_1_20.jmx 10 1 20  jmeter.apache.org
EOF
	}

EOF_genJmx

$str = &template2TS($str);
	print Fout_genJmx $str;
	close Fout_genJmx;
}

sub generateTSDescAB {

if (-e $SvrProjName ) {;} else { mkpath $SvrProjName;}
open Fout_generateIndex_txt, ">$SvrProjName/$TSDescName";
print " -> $SvrProjName/$TSDescName\n";
my $str=<<EOF;
 
 Automation: 1 
 	Name     	: "__tsName__"
 	Description	: 1. Web Performance Test A
 	PreRequsite	: "__apacheBench__"
 	PreRequsite	: "__perl__"
 	PreRequsite	: "__tsName__/ab.pl"
 	Executor	: "__perl__"
 	Arguments	: "__tsName__/ab.pl"
 	Arguments	: "1__no_print_executor__"
	#PostProcessor  : "dir"
 	#PostProcessor  : "c:/Windows/System32/taskkill.exe /im perl.exe"
 	Log 		: __tsName__/_log.txt
 	File  		: __tsName__/ab.pl
 	File  		: __tsName__/testcase0001/_cmd.txt
 	File  		: __tsName__/testcase0001/ManualSteps.txt
 	
 
 Automation: 2 
 	Name     	: "__tsName__"
 	Description	: 2. Web Performance Test B
 	PreRequsite	: "__apacheBench__"
 	PreRequsite	: "__perl__"
 	PreRequsite	: "__tsName__/ab.pl"
 	Executor	: "__perl__"
 	Arguments	: "__tsName__/ab.pl"
 	Arguments	: "2"
	#PostProcessor  : "dir"
 	#PostProcessor  : "c:/Windows/System32/taskkill.exe /im perl.exe"
 	Log 		: __tsName__/_log.txt
 	File  		: __tsName__/testcase0002/_cmd.txt
 	File  		: __tsName__/testcase0002/ManualSteps.txt
 	
EOF
$str = &template2TS($str);
print Fout_generateIndex_txt $str;
close Fout_generateIndex_txt;

}

sub generateTSManualStepAB {

if (-e $SvrProjName ) {;} else { mkpath $SvrProjName;}
if (-e "$SvrProjName/testcase0001" ) {;} else { mkpath "$SvrProjName/testcase0001";}
open Fout_generateIndex_txt, ">$SvrProjName/testcase0001/ManualSteps.txt"; # todo hard coded filename 
#open Fout_generateIndex_txt, ">$SvrProjName/manual_tc_testcase0001.txt"; # todo hard coded filename 
print " -> $SvrProjName/manual_tc_testcase0001.txt\n";
my $str=<<EOF;
 
 	Name		: __tsName__
 	Description	: Manual test URL's performance using Apache Benchmark Tool

	Manual Test Steps:
	1. Download the Apache Benchmark tool 
	2. Add the Apache Benchmark Tool (ab.exe) to the Path
	3. Start a DOS prompt
	4. Select the URL to measure performance against (www.yahoo.com)
	5. Select the number of users   (NUser)
	6. Select the number of concurrent users (CUsers)
	7. Performance Measurement "C:/Apache24/bin/ab  -n NUser -c CUser www.xbosoft.com/"
	8. Check Results: This will be captured by TaaS 

--------------------- STDOUT --------------------------------
This is ApacheBench, Version 2.3 
Copyright 1996 Adam Twiss, Zeus Technology Ltd, http://www.zeustech.net/
Licensed to The Apache Software Foundation, http://www.apache.org/

Benchmarking localhost (be patient).....done


Server Software:        Microsoft-IIS/7.5
Server Hostname:        localhost
Server Port:            18080

Document Path:          /
Document Length:        19147 bytes

Concurrency Level:      10
Time taken for tests:   0.099 seconds
Complete requests:      100
Failed requests:        0
Total transferred:      1941500 bytes
HTML transferred:       1914700 bytes
Requests per second:    1010.04 [#/sec] (mean)
Time per request:       9.901 [ms] (mean)
Time per request:       0.990 [ms] (mean, across all concurrent requests)
Transfer rate:          19150.32 [Kbytes/sec] received

Connection Times (ms)
              min  mean[+/-sd] median   max
Connect:        0    0   0.3      0       1
Processing:     3    9   1.3      9      10
Waiting:        3    8   1.2      8       9
Total:          3    9   1.3     10      10

Percentage of the requests served within a certain time (ms)
  50%     10
  66%     10
  75%     10
  80%     10
  90%     10
  95%     10
  98%     10
  99%     10
 100%     10 (longest request)

--------------------- STDOUT --------------------------------
 
EOF
$str = &template2TS($str);
print Fout_generateIndex_txt $str;
close Fout_generateIndex_txt;


if (-e "$SvrProjName/testcase0002" ) {;} else { mkpath "$SvrProjName/testcase0002";}
open Fout_generateIndex_txt, ">$SvrProjName/testcase0002/ManualSteps.txt"; # todo hard coded filename 
#open Fout_generateIndex_txt, ">$SvrProjName/manual_tc_testcase0002.txt"; # todo hard coded filename 
#print " -> $SvrProjName/manual_tc_testcase0002.txt\n";
print " -> $SvrProjName/testcase0001/ManualSteps.txt\n";
$str=<<EOF;
 
 	Name		: __tsName__
 	Description	: Manual test URL's performance using Apache Benchmark Tool

	Manual Test Steps:
	1. Download the Apache Benchmark tool 
	2. Add the Apache Benchmark Tool (ab.exe) to the Path
	3. Start a DOS prompt
	4. Select the URL to measure performance against (www.yahoo.com)
	5. Select the number of users   (NUser)
	6. Select the number of concurrent users (CUsers)
	7. Performance Measurement "C:/Apache24/bin/ab  -n NUser -c CUser www.xbosoft.com/"
	8. Check Results: This will be captured by TaaS 

--------------------- STDOUT --------------------------------
This is ApacheBench, Version 2.3 
Copyright 1996 Adam Twiss, Zeus Technology Ltd, http://www.zeustech.net/
Licensed to The Apache Software Foundation, http://www.apache.org/

Benchmarking localhost (be patient).....done


Server Software:        Microsoft-IIS/7.5
Server Hostname:        localhost
Server Port:            18080

Document Path:          /
Document Length:        19147 bytes

Concurrency Level:      10
Time taken for tests:   0.099 seconds
Complete requests:      100
Failed requests:        0
Total transferred:      1941500 bytes
HTML transferred:       1914700 bytes
Requests per second:    1010.04 [#/sec] (mean)
Time per request:       9.901 [ms] (mean)
Time per request:       0.990 [ms] (mean, across all concurrent requests)
Transfer rate:          19150.32 [Kbytes/sec] received

Connection Times (ms)
              min  mean[+/-sd] median   max
Connect:        0    0   0.3      0       1
Processing:     3    9   1.3      9      10
Waiting:        3    8   1.2      8       9
Total:          3    9   1.3     10      10

Percentage of the requests served within a certain time (ms)
  50%     10
  66%     10
  75%     10
  80%     10
  90%     10
  95%     10
  98%     10
  99%     10
 100%     10 (longest request)
--------------------- STDOUT --------------------------------

 
EOF
$str = &template2TS($str);
print Fout_generateIndex_txt $str;
close Fout_generateIndex_txt;



}



sub generateTSDescPerl {goto &genTCDescPerl}
sub genTCDescPerl {

if (-e $SvrProjName) {;} else { mkpath $SvrProjName;}
mkpath "$SvrProjName/Program Files"; 
open Fout_wait, ">$SvrProjName/Program Files/wait.pl"; print Fout_wait '$| = 1; for ($i = 0; $i < 10; $i++) { sleep 1; print "$i "; }'; close Fout_wait; print " -> $SvrProjName/Program Files/wait.pl\n";
open Fout_calc, ">$SvrProjName/calc.pl"; print Fout_calc 'eval "\$rst = @ARGV"; print $rst; open Fout, "> '.$SvrProjName.'/_log1.txt"; print Fout "This is a test log of simple _log1.txt\n"; close Fout; open Fout, "> '.$SvrProjName.'/_log1.log"; print Fout "This is a test log of simple _log1.log\n"; close Fout; open Fout, "> '.$SvrProjName.'/Program Files/_log1.txt"; print Fout "This is a sub test log with white space in logName\n"; close Fout ; sleep 1;' ; close Fout_calc; print " -> $SvrProjName/calc.pl\n"; 
open Fout_calc, ">$SvrProjName/calc2.pl"; print Fout_calc 'eval "\$rst = @ARGV"; print $rst; # This is calc2.pl'; close Fout_calc; print " -> $SvrProjName/calc2.pl\n"; 

open Fout_generateIndex_txt, ">$SvrProjName/$TSDescName";
print " -> $SvrProjName/$TSDescName\n";
	print Fout_generateIndex_txt<<EOF;

####################################################
# This is generated by TaaS code generator
#
# Automation is defined as :  A program that print STDOUT "pass or fail" and print several logs
# Automation is defined by :  A description file - c:/testsuite directory/index.txt (c:/perlTS/) as shown below 
# Example 		   :  This autoamiton verifies if "C:/Perl64/bin/perl.exe c:/perlTS/calc.pl 5 * 6 " equals 56  
# Automation: 1 										# mandatory field. foramt in regExp [ \\S+:\\s*\\d+]
#  	Name		: c:/perlTS								# mandatory filed. Test suite directory
#  	Description	: 1. Perl Calculator Test case : integer * integer ( 7 * 8) 		# opetional field. Automation will check if this file exist	
#  	Dependency 	: "C:/Perl64/bin/perl.exe"						# optional field. Automation will check if this file exist			
#  	Dependency 	: "c:/perlTS/calc.pl"							# optional field. Automation will check if this file exist
#  	PreRequsite	: "C:/Perl64/bin/perl.exe"	# url=http://www.perl.com		# optional field. Automation will check if this file exist	
#  	PreRequsite	: "c:/perlTS/calc.pl"							# optional field. Automaiton will exec this before driver exectuioin
#  	PreProcessor    : "c:/_TAF/taf.pl testsuite=c:/perlTS;rmTSTempFiles" 			# optional field. Automaiton will exec this before driver exectu (setup)	
#  	Driver		: "C:/Perl64/bin/perl.exe c:/perlTS/calc.pl" 				# mandatory field. automation driver  
#												# mandatory field. automation driver can print  pass|fail to STDOUT 
#  	Arguments       : "-jar"              							# optional field. automation arguments  
#  	Arguments       : "c:/perlTS/calc.pl" 							# optional field. automation arguments  
#  	Arguments       : "7" 								# optional field. automation arguments  
#  	Arguments       : "8" 								# optional field. automation arguments  
#  	Validator       : 56 			    	# In RegExp				# optiona field, automaiton validator   7 * 8  should equals 56 
#  	PostProcessor   : dir 									# optional field. Automation will exec this after the driver execution  (teardown)
#
#  	Log 		: c:/perlTS/_log1.txt 							# Automation generated logs 
#  	Log 		: c:/perlTS/_log2.txt 							# Automation generated logs 
#  	File      	: c:/perlTS/calc.pl 							# optional field: ignore	
#  	File      	: c:/perlTS/calc2.pl							# optional field: ignore	
#  	File      	: c:/perlTS/no_exist.pl							# optional field: ignore	
#  	File     	: c:/perlTS/manual_tc_testcase0001.txt					# optional field: ignore	
#
#
# Automation: 2 
#	Name		: c:/perlTS_xbo
#	Description	: 1. Selenium java Automation 
#	Driver		: "C:/Program Files/Java/jdk1.7.0_67/bin/java.exe"
#	Arguments	: "-jar"
#	Arguments	: "C:/Users/qabuild/Desktop/25/pro5.jar"
#	Arguments	: "D:/workspace/KW-Driven/file/testcase.xlsx"
#	Arguments	: "D:/workspace/KW-Driven/file/testpage.xlsx"
#	Arguments	: "D:/workspace/KW-Driven/file/testdata.xlsx"
#	Arguments	: "2"
#	Arguments	: "4"
#	Validator	: "pass"
#	PostProcessor   : "dir"
# 
####################################################


Automation: 1 
	Name		: $SvrProjName
	Description	: 1. Perl Calculator Test case : integer * integer ( 7 * 8) 
	Dependency 	: "$perl_"
	Dependency 	: "$SvrProjName/calc.pl"
	PreRequsite	: "$perl_"	
	PreRequsite	: "$SvrProjName/calc.pl"
	PreProcessor    : "$c/$_TAF/$taf testsuite=$SvrProjName;rmTSTempFiles"
	PreProcessor    : "$perl_" "$SvrProjName/Program Files/wait.pl" &
	Driver		: "$perl_"
	Arguments	: "$SvrProjName/calc.pl"
	Arguments       : "7 * 8"
	Validator       : 56					# in RegExp
	PostProcessor   : "dir"
	#PostProcessor   : "c:/Windows/System32/taskkill.exe /im perl.exe"
	Log 		: $SvrProjName/_log1.txt
	Log 		: $SvrProjName/_log2.txt
	Log 		: $SvrProjName/_log1.log
	Log 		: $SvrProjName/Program Files/_log1.txt
	File      	: $SvrProjName/calc.pl				
	File      	: $SvrProjName/calc2.pl				
	File      	: $SvrProjName/no_exist.pl				
	File     	: $SvrProjName/manual_tc_testcase0001.txt
	
Automation: 2 
	Name		: $SvrProjName
	Description	: 2. Perl Calculator Test case : integer * integer ( 7.5 * 8) 
	Dependency 	: $SvrProjName/calc.pl				
	PreRequsite	: $perl_	# url=http://www.perl.com
	PreRequsite	: $SvrProjName/calc.pl				
	PreProcessor    : $c/$_TAF/$taf testsuite=$SvrProjName;rmTSTempFiles
	Driver		: $perl_ $SvrProjName/calc.pl 
	Arguments       : 7.5 * 
	Arguments       : 8
	Validator       : 56
	PostProcessor   : dir
	Log 		: $SvrProjName/_log1.txt
	File      	: $SvrProjName/calc.pl				
	File      	: $SvrProjName/calc2.pl				
	File      	: $SvrProjName/no_exist.pl				
	File     	: $SvrProjName/manual_tc_testcase0002.txt

Automation: 3 
	Name		: $SvrProjName
	Description	: 3. Perl Calculator Test case : integer * integer ( 7 * 0) 
	Dependency 	: $SvrProjName/calc.pl				
	PreRequsite	: $perl_	# url=http://www.perl.com
	PreRequsite	: $SvrProjName/calc.pl				
	PreProcessor    : $c/$_TAF/$taf testsuite=$SvrProjName;rmTSTempFiles
	Driver		: $perl_ $SvrProjName/calc.pl 
	Arguments       : 7 * 
	Arguments       : 0__no_print_executor__
	Validator       : 0
	PostProcessor   : dir
	Log 		: $SvrProjName/_log1.txt
	File      	: $SvrProjName/calc.pl				
	File      	: $SvrProjName/calc2.pl				
	File      	: $SvrProjName/no_exist.pl				
	File     	: $SvrProjName/manual_tc_testcase0003.txt

Automation: 4 
	Name		: $SvrProjName
	Description	: 4. Calculator Test case : integer * integer ( 7.5 * 8.5) 
	PreRequsite	: $perl_	# url=http://www.perl.com
	Dependency 	: $SvrProjName/calc.pl				
	PreRequsite	: $SvrProjName/calc.pl				
	PreProcessor    : $c/$_TAF/$taf testsuite=$SvrProjName;rmTSTempFiles
	Driver		: $perl_ $SvrProjName/calc.pl 
	Arguments       : 7.5 * 
	Arguments       : 8.5
	Validator       : 63.75
	PostProcessor   : dir
	Log 		: $SvrProjName/_log1.txt
	File      	: $SvrProjName/calc.pl				
	File      	: $SvrProjName/calc2.pl				
	File      	: $SvrProjName/no_exist.pl				
	File     	: $SvrProjName/manual_tc_testcase0004.txt

#	generate perl testsuite 
#	$c/$_TAF/taf.pl testsuite=c:/_perlN;generateTSDescPerl
#	$c/$_TAF/taf.pl testsuite=c:/_perlN;generateTSFromDesc   
#	$c/$_TAF/taf.pl testsuite=c:/_perlN;generateTAFTestsuite 

EOF

close Fout_generateIndex_txt;
}
#########################

### Ruby Desc
sub generateTSDescRuby {

if (-e $SvrProjName) {;} else { mkpath $SvrProjName;}
open Fout_calc, ">$SvrProjName/calc.pl"; print Fout_calc 'eval "\$rst = @ARGV"; print $rst;'; close Fout_calc; print " -> $SvrProjName/calc.pl\n"; 
open Fout_calc, ">$SvrProjName/calc2.pl"; print Fout_calc 'eval "\$rst = @ARGV"; print $rst; # This is calc2.pl'; close Fout_calc; print " -> $SvrProjName/calc2.pl\n"; 

open Fout_calc, ">$SvrProjName/calc.rb"; 
print Fout_calc<<EOF_calc;
require 'open3'
arg = ""
ARGV.each do |each|
	arg = arg + " " + each
end
cmd = "$perl_ $SvrProjName/calc.pl #{arg}"
Open3.popen3(cmd) do | stdin, stdout, stderr, wait_thr|
	puts stdout.read
end

EOF_calc
print " -> $SvrProjName/calc.rb\n"; 

open Fout_calc, ">$SvrProjName/calc2.rb"; 
print Fout_calc<<EOF_calc;
require 'open3'
arg = ""
ARGV.each do |each|
	arg = arg + " " + each
end
cmd = "$perl_ calc.pl #{arg}"
Open3.popen3(cmd) do | stdin, stdout, stderr, wait_thr|
	puts stdout.read
end

EOF_calc
print " -> $SvrProjName/calc2.rb\n"; 


open Fout_generateIndex_txt, ">$SvrProjName/$TSDescName";
print " -> $SvrProjName/$TSDescName\n";
	print Fout_generateIndex_txt<<EOF;
####################################################
# This is generated by TaaS code generator
####################################################

Automation: 1 
	Name		: $SvrProjName
	Description	: 1. Ruby Calculator Test case : integer * integer ( 7 * 8) 
	Dependency 	: $perl_
	Dependency 	: $SvrProjName/calc.pl				
	PreRequsite	: $perl_	# url=http://www.perl.com
	Dependency 	: $SvrProjName/calc.rb				
	PreRequsite	: $ruby		# url=http://www.perl.com
	PreRequsite	: $SvrProjName/calc.pl				
	PreProcessor    : $c/$_TAF/$taf testsuite=$SvrProjName;rmTSTempFiles
	Driver		: $ruby $SvrProjName/calc.rb 
	Arguments       : 7*8 
	Validator       : 56
	PostProcessor   : dir
	Log 		: $SvrProjName/_log1.txt
	File      	: $SvrProjName/calc.pl				
	File      	: $SvrProjName/calc2.pl				
	File      	: $SvrProjName/no_exist.pl				
	File      	: $SvrProjName/calc.rb				
	File      	: $SvrProjName/calc2.rb				
	File      	: $SvrProjName/no_exist.rb				


Automation: 2 
	Name		: $SvrProjName
	Description	: 2. Ruby Calculator Test case : integer * integer ( 7.5 * 8) 
	Dependency 	: $perl_		# url=http://www.perl.com
	Dependency 	: $SvrProjName/calc.pl				
	PreRequsite	: $perl_	# url=http://www.perl.com
	Dependency 	: $SvrProjName/calc.rb				
	PreRequsite	: $ruby		# url=http://www.perl.com
	PreRequsite	: $SvrProjName/calc.pl				
	PreProcessor    : $c/$_TAF/$taf testsuite=$SvrProjName;rmTSTempFiles
	Driver		: $ruby $SvrProjName/calc.rb 
	Arguments       : 7.5*8
	Validator       : 56
	PostProcessor   : dir
	Log 		: $SvrProjName/_log1.txt
	File      	: $SvrProjName/calc.pl				
	File      	: $SvrProjName/calc2.pl				
	File      	: $SvrProjName/no_exist.pl				
	File      	: $SvrProjName/calc.rb				
	File      	: $SvrProjName/calc2.rb				
	File      	: $SvrProjName/no_exist.rb				
	


Automation: 3 
	Name		: $SvrProjName
	Description	: 3. Ruby Calculator Test case : integer * integer ( 7.5 * 0) 
	Dependency 	: $perl_		# url=http://www.perl.com
	Dependency 	: $SvrProjName/calc.pl				
	PreRequsite	: $perl_	# url=http://www.perl.com
	Dependency 	: $SvrProjName/calc.rb				
	PreRequsite	: $ruby		# url=http://www.perl.com
	PreRequsite	: $SvrProjName/calc.pl				
	PreProcessor    : $c/$_TAF/$taf testsuite=$SvrProjName;rmTSTempFiles
	Driver		: $ruby $SvrProjName/calc.rb 
	Arguments       : 7.5*0 
	Validator       : 0 
	PostProcessor   : dir
	Log 		: $SvrProjName/_log1.txt
	File      	: $SvrProjName/calc.pl				
	File      	: $SvrProjName/calc2.pl				
	File      	: $SvrProjName/no_exist.pl				
	File      	: $SvrProjName/calc.rb				
	File      	: $SvrProjName/calc2.rb				
	File      	: $SvrProjName/no_exist.rb		


Automation: 4 
	Name		: $SvrProjName
	Description	: 4. Ruby Calculator Test case : integer * integer ( 7.5 * 8.5) 
	Dependency 	: $perl_		# url=http://www.perl.com
	Dependency 	: $SvrProjName/calc.pl				
	PreRequsite	: $perl_	# url=http://www.perl.com
	Dependency 	: $SvrProjName/calc.rb				
	PreRequsite	: $ruby		# url=http://www.perl.com
	PreRequsite	: $SvrProjName/calc.pl				
	PreProcessor    : $c/$_TAF/$taf testsuite=$SvrProjName;rmTSTempFiles
	Driver		: $ruby $SvrProjName/calc.rb 
	Arguments       : 7.5*8.5 
	Validator       : 63.75 
	PostProcessor   : dir
	Log 		: $SvrProjName/_log1.txt
	File      	: $SvrProjName/calc.pl				
	File      	: $SvrProjName/calc2.pl				
	File      	: $SvrProjName/no_exist.pl				
	File      	: $SvrProjName/calc.rb				
	File      	: $SvrProjName/calc2.rb				
	File      	: $SvrProjName/no_exist.rb		

#	generate ruby testsuite 
#	$c/$_TAF/taf.pl testsuite=c:/_rubyN;generateTSDescRubyCalc
#	$c/$_TAF/taf.pl testsuite=c:/_rubyN;generateTSFromDesc   
#	$c/$_TAF/taf.pl testsuite=c:/_rubyN;generateTAFTestsuite 

EOF

close Fout_generateIndex_txt;
}
### Ruby Desc

sub createTS_save {		# Create Testsuite for Testbed 

	if ($SvrProjName !~ /$c/i) { print "Warning: testcase should start with $c\n"; }
	my $tsName = $SvrProjName; $tsName = shift if @_;
	$SvrProjName = $tsName; if (-e $SvrProjName) {;} else { mkdir $SvrProjName; }
	if (-e "$c/$_TAF/$createTS_indexindex" ) {
		print " --> Create $SvrProjName    <- from $c/$_TAF/$createTS_indexindex\n"; 
		copy ("$c/$_TAF/$createTS_indexindex", "$SvrProjName/$createTS_indexindex");
		print "$SvrProjName/$createTS_indexindex is running ......\n";
		my $rst = `$perl $SvrProjName/$createTS_indexindex`;
		print "$SvrProjName/$createTS_indexindex is completed.....\n";
	} elsif (-e "$c/$_TAF/$createTS_index" ) {
		print " --> Create $SvrProjName    <- from $c/$_TAF/$createTS_index\n"; 
		move ("$c/$_TAF/$createTS_index", "$SvrProjName/$TSHookNameGenerated");
	} elsif ($SvrProjName =~ s/_powershell_//i)  { 
		print " --> Create Powershell Testsuite: $SvrProjName\n"; &generatePowershell_ps1_template($SvrProjName); 
	} elsif ($NofTCinTSTemplate != -1 ) {
		&createTS_B($SvrProjName);
	} else { 
		print " --> Create Perl Testsuite: $SvrProjName\n";       &generatePerl_pl_template($SvrProjName); 
	}
	&generateTAFTestsuite ();
1;
}




sub addTS {
	my $tsName = "_testsuite_"; $tsName = shift if @_;
	if (-e $tsName) { print " --> Add Testsuite Hook : $tsName \n"; return 0; } 
	else { print "[Warning] Testsuite ($tsName) doesn't exist. No testsuite hook is added\n";
	return 1;}
}



sub deleteTS { goto &deleteTAFTestsuite }
sub updateTS {goto &listTS}
sub listTS   {
	my $tsName = $SvrProjName; $tsName = shift if @_;
	$SvrProjName = $tsName;
	&processTCs ("","tcDelay=0;performanceMode=fast;testcaseNode=$testcaseNode;testsuite=$SvrProjName;AutomationtsName=$SvrProjName;list"); 
	return 1;
}

sub generateIndexUpload_pl {

	my $SvrProjNameStr = &getTCName_C($SvrProjName); 
           $SvrProjNameStr = &getTCName_TAF($SvrProjNameStr);

	my $SvrProjNameStr_C = &getTCName_C($SvrProjName); 
	my $SvrProjNameStr_C_no = &getTCName_C_no($SvrProjName); 

	if ( -e $SvrProjNameStr) {;} else { mkpath $SvrProjNameStr; }
	print " -> $SvrProjNameStr/indexUpload.pl\n"; 
	open FoutIndexUpload_pl, ">$SvrProjNameStr/indexUpload.pl" ;
my $str=<<'EOF';
#!C:\Perl\bin\perl.exe

use CGI;
use strict;

my $PROGNAME = "indexUpload.pl";

my $cgi = new CGI();
print "Content-type: text/html\n\n";

if (! $cgi->param("button") ) {
	DisplayForm();
	exit;
}

my $upfile = $cgi->param('upfile');

my $basename = GetBasename($upfile);

my $web_ui_title = "indexUpload.pl";
no strict 'refs';

my $outfile = '__c_tsName__/'.$upfile;

if (! open(OUTFILE, ">$outfile") ) {
	print "Can't open $outfile for writing - $!";
	exit(-1);
}

# give some feedback to browser
print "Saving the file to $outfile \n";

my $nBytes = 0;
my $totBytes = 0;
my $buffer = "";
# If you're on Windows, you'll need this. Otherwise, it
# has no effect.
binmode($upfile);
while ( $nBytes = read($upfile, $buffer, 1024) ) {
	print OUTFILE $buffer;
	$totBytes += $nBytes;
}

close OUTFILE;

use strict 'refs';

print " ($totBytes bytes)<br>\n";	
print "<a href=\"http://__ip____http_port__/__no_c_tsName__/testcase0001/_tcLog.html\">Back to TC</a>";

##############################################
# Subroutines
##############################################

sub GetBasename {
	my $fullname = shift;

	my(@parts);
	if ( $fullname =~ /(\\\\)/ ) {
		@parts = split(/\\\\/, $fullname);
	} else {
		@parts = split(/\//, $fullname);
	}

	return(pop(@parts));
}

sub DisplayForm {
print <<"HTML";
<html>
<title>$web_ui_title</title>
<head>
<title>Upload Form</title>
<body>
<form method="post" action="$PROGNAME" enctype="multipart/form-data">
<left>
 Select json file to upload: <input type="file" name="upfile">  
<input type="submit" name="button" value="Upload File">
</center>
</form>

HTML
}


EOF


$str =~ s/__ip__/$ip/gi;
$str =~ s/__c_tsName__/$SvrProjNameStr_C/gi;
$str =~ s/__no_c_tsName__/$SvrProjNameStr_C_no/gi;
$str =~ s/__http_port_IIS__/$http_port_IIS/gi;
$str =~ s/__http_port__/$http_port/gi;
print FoutIndexUpload_pl $str;
	close FoutIndexUpload_pl;

}
sub generateIndexIndexJira {
	my $CompanyName = "TAFLLC"; $CompanyName = shift if @_;
	my $ProjectName = "TAF"   ; $ProjectName = shift if @_;
	my $SvrProjNameStr = &getTCName_C($SvrProjName); 
	if ( -e $SvrProjNameStr) {;} else { mkpath $SvrProjNameStr; }
	print " -> $SvrProjNameStr/indexindex.pl\n"; 
	open FoutIndexIndexJira, ">$SvrProjNameStr/indexindex.pl" ;
my $str =<<'EOFJira';
use Socket;
use File::Path;
use Getopt::Long;
my $CompanyName = "__CompanyName__";
my $ProjName 	= "__ProjectName__";
my $jiraHostName = "localhost";
my $jiraHostURL  = sprintf "<a href=\"http:\/\/$jiraHostName:8080//$each\">%8s<\/a>", $each;	# todo
my $c = "c:";
my $SvrProjName;
my $ip = __ip__;
my $http_port     = "__http_port__";
my $http_port_IIS = "__http_port_IIS__";
my $assigned_ip = -1;
# my $help;

GetOptions (
	"CompanyName=s" 		=> \$CompanyName, 
	"ProjName=s" 			=> \$ProjName, 
	"tcNames"			=> \$tcName,
	"jiraHostURL=s" 		=> \$jiraHostURL, 
	"jiraHostName=s" 		=> \$jiraHostName, 
	"jiraHostPort=s" 		=> \$http_port, 
	"assignedIP=s" 			=> \$assigned_ip, 
	'help'				=> \$help,
);

if ($help) { 
print<<EOF;

$0: -CompanyName TAFLLC -ProjName TAF3 -assignedIP 127.0.0.1  [-jiraHostName localhost] -jiraHostPort 8080

Note: assignedIP will overwrite hostIP (This is for AWS elapse IP)

EOF
exit;

}



if ( -e "$c/$CompanyName/$ProjName") {;} else { mkpath "$c/$CompanyName/$ProjName"; }
my $ping			= "C:/Windows/System32/ping.exe -n 1 "; if ( $^O =~ /MSWin32/ ) {; } elsif ($^O =~ /linux/i) { $ping = "/bin/ping -c 1 " ;	}
my $http_port			= ":8080";				if ( $^O =~ /MSWin32/ ) {; } elsif ($^O =~ /linux/i) { $http_port= ":1234" ;		}
my $hostname 			= "localhost";
my $ip 				= "127.0.0.1";

my $rst 			= `$ping $hostname`; 
if    ($rst =~ /Ping request could not/i) { $web_ui_title_tip = "Click to update every TAF testsuites";}
 	elsif ($rst  =~ /unknown/i)       { $web_ui_title_tip = "Click to update every TAF testsuites";}
else {
 		$hostname 		= `hostname`; chop $hostname; 
 		$ip			= inet_ntoa((gethostbyname($hostname))[4]);
}


if ($assigned_ip != -1) { $ip = $assigned_ip; }


$jiraHostURL  = sprintf "http:\/\/$ip:8080//", $each;	
$tcName = "$c/$CompanyName/$ProjName"; 
$jiraHostURL = "file:\/\/\/$tcName/JIRA";
&generateIndex_pl_pl();
&generateIndex_pl();
&generateIndex1_pl();
&generateGenSS_pl();
&gen_json2txt_pl ();

sub generateIndex1_pl {
my $str=<<'EOF_pl1';
# Assumption Assignee is identified by the 1st Name

use Date::Manip;
use Getopt::Long;
use File::Path;
use File::Copy;
use strict;

my $c 		= "c:";
my $_TAF 	= "_TAF";
my $CompanyName = "__COMN__";
my $ProjName 	= "__PROJ__";

my $web_ui_title = "__COMN__/__PROJ__";


my %record_all; 
my %record_all_Updated; 
my %record_all_latest;

################################ New Vars #########################
my %jiraRec; 
my %jiraAssignee; 
my %jiraCreated; 
my %jiraIssuetype;
my %jiraPriority; 
my %jiraProject; 
my %jiraReporter;
my %jiraResolution; 
my %jiraResolutiondate;  
my %jiraSecurity;
my %jiraStatus; 
my %jiraSummary; 
my %jiraUpdated; 
my %jiraLatestOpenTime; my %jiraLatestResolvedTime; my %jiraLatestClosedTime;


my %lookupAssignees;
my %lookupReporters;
my %lookupPriorities;
my %lookupStatus;
my %lookupResolutions;
my %lookupIssuetypes;

################################ New Vars #########################


my $projCode = "$ProjName";
my $tcName ="$c/$CompanyName/$ProjName";
my $tcNameTAF ="$c/$_TAF/$CompanyName/$ProjName";

my $bugJiraStatusDisplay="Open,Resolved,Closed"; # for display 
#my $item = "Defect";
my $sortOn 		= "priority";
my $jiraHostURL		= 'file:///'.$tcName."/JIRA/";
my $jiraHostURL		= 'http://192.168.0.197:8080/'."$CompanyName/$ProjName"."/JIRA";

my $startDay = 20;
my $endDay = 20;
my $step  	= 1;
######## vars for generateJiraList
my $fname    		="$tcName/_jiraList_and_Status.txt";
my $logFname 		="$tcName/_tcResult3_.html";
my $excelFname 		="$tcName/_xlInput_.txt";
my $fnameDefectList	="$tcName/_DefectJiraList.txt";
my $dateNow 		=&ParseDate("now");
	my $metricsId = 99;

my $jiraFName = "$tcName/jira.txt"; &readCapturedJiras($jiraFName); 



open File_lookup, "> $tcName/lookup.txt"; print " -> $tcName/lookup.txt\n";
printf File_lookup "%-20s:", "Assignees"	; foreach my $each (sort keys %lookupAssignees) { print File_lookup "\t$each,";}   print File_lookup "\n";
printf File_lookup "%-20s:", "Reporters"	; foreach my $each (sort keys %lookupReporters) { print File_lookup "\t$each,";}   print File_lookup "\n";
printf File_lookup "%-20s:", "Priorities"	; foreach my $each (sort keys %lookupPriorities) { print File_lookup "\t$each,";}   print File_lookup "\n";
printf File_lookup "%-20s:", "Status"		; foreach my $each (sort keys %lookupStatus) { print File_lookup "\t$each,";}   print File_lookup "\n";
printf File_lookup "%-20s:", "Resolutions"	; foreach my $each (sort keys %lookupResolutions) { print File_lookup "\t$each,";}   print File_lookup "\n";
printf File_lookup "%-20s:", "Issuetypes"	; foreach my $each (sort keys %lookupIssuetypes) { print File_lookup "\t$each,";}   print File_lookup "\n";
close File_lookup;

my $metricsName 	= "Defect";

		open Fout1, ">$tcName/1_Reporter.txt"; close Fout1;
		open Fout1, ">$tcName/2_Priority.txt"; close Fout1;
		open Fout1, ">$tcName/3_Issuetype.txt"; close Fout1;
		open Fout1, ">$tcName/4_Resolve_Close_Time.txt"; close Fout1;
		open Fout1, ">$tcName/5_Resolution.txt"; close Fout1;
		open Fout1, ">$tcName/6_Status.txt"; close Fout1;
		open Fout1, ">$tcName/7_Priority_viki.txt"; close Fout1;

		open Fout2, ">$tcName/1_Reporter_excel.txt"; close Fout2;
		open Fout2, ">$tcName/2_Priority_excel.txt"; close Fout2;
		open Fout2, ">$tcName/3_Issuetype_excel.txt"; close Fout2;
		open Fout2, ">$tcName/4_Resolve_Close_Time_excel.txt"; close Fout2;
		open Fout2, ">$tcName/5_Resolution_excel.txt"; close Fout2;
		open Fout2, ">$tcName/6_Status_excel.txt"; close Fout2;
		open Fout2, ">$tcName/7_Priority_viki_excel.txt"; close Fout2;


		open Fout2, ">$tcName/1_Reporter_excel.txt";  print Fout2 "[[\"_\",\"TotalCtr\""; foreach my $eachLookup (sort keys %lookupReporters) { print Fout2 ",\"$eachLookup\" ";} ; print Fout2 "]"; close Fout2;
		open Fout2, ">$tcName/2_Priority_excel.txt";  print Fout2 "[[\"_\",\"TotalCtr\""; foreach my $eachLookup (sort keys %lookupPriorities) { print Fout2 ",\"$eachLookup\" ";} ; print Fout2 "]"; close Fout2;
		open Fout2, ">$tcName/3_Issuetype_excel.txt"; print Fout2 "[[\"_\",\"TotalCtr\""; foreach my $eachLookup (sort keys %lookupIssuetypes) { print Fout2 ",\"$eachLookup\" ";} ; print Fout2 "]"; close Fout2;
		open Fout2, ">$tcName/5_Resolution_excel.txt";print Fout2 "[[\"_\",\"TotalCtr\""; foreach my $eachLookup (sort keys %lookupResolutions) { print Fout2 ",\"$eachLookup\" ";} ; print Fout2 "]"; close Fout2;
		open Fout2, ">$tcName/6_Status_excel.txt";    print Fout2 "[[\"_\",\"TotalCtr\""; foreach my $eachLookup (sort keys %lookupStatus) { print Fout2 ",\"$eachLookup\" ";} ; print Fout2 "]"; close Fout2;
		open Fout2, ">$tcName/7_Priority_viki_excel.txt";  print Fout2 "[[\"_\",\"TotalCtr\""; foreach my $eachLookup (sort keys %lookupPriorities) { print Fout2 ",\"$eachLookup\" ";} ; print Fout2 "]"; close Fout2;





GetOptions (
	"startDay=s" 		=> \$startDay, 
	"endDay=s" 		=> \$endDay, 
	"step=s" 		=> \$step, 
	"sortOn=s" 		=> \$sortOn, 
	"metricsName=s" 	=> \$metricsName, 
);


	 
foreach my $each (sort keys %jiraRec) 	{ 	# error checking: $updateDate is older than createDate 
	my $flag = Date_Cmp($jiraCreated{$each}, $jiraUpdated{$each}); if ($flag != -1) {print "Warning: $each UpdateDate is older than CreateDate\n";}
} 


if (&findStartEndDay() =~ /^\s*startDay\s*=\s*(\d+)\s+endDay\s*=\s*(\d+)\s*$/) { $startDay = $1; $endDay = $2; }



# $startDay = 1046; $endDay = 1036;

$step = int (($startDay - $endDay)/20);
for (my $currentTime = $startDay; $currentTime >= $endDay; $currentTime = $currentTime - $step ) { 	# Iteration in History
	my $timeDelta = "-${currentTime}day"; $dateNow = &DateCalc("now", $timeDelta); 
	# print "Processing ".&UnixDate("$dateNow", "%b %e, %Y"). " data -results->\n";
		########### Jira Data 		############
		my %lastOpenDate; my %lastResolvedDate; my %lastClosedDate;
		my %TofOpenState=0; my %TofResolvedState=0; my %TofClosedState=0;
		my %NofOpenState=0; my %NofResolvedState=0; my %NofClosedState=0;
		########### Aggrevation Data for each nowDate 	############
		my $totalNofOpen=0;
		my $totalNofResolved=0;
		my $totalNofClosed=0;

		foreach my $each (sort keys %record_all) { 						# Iteration each Jira
			$each =~ /^\s*(.+)_(\d+)\s*$/;  my $jiraId_ = $1; my $secs_ = $2;
			my $flag = &Date_Cmp(&UnixDate("$dateNow", "%b %e, %Y") ,  &UnixDate("$record_all_Updated{$each}", "%b %e, %Y") ); 
			if ($flag >= 0) {								# Till the simulated date
				$record_all_latest{$jiraId_} =  $record_all{$each};			# Get the latest for future aggregation  
				&readCapturedJira_from_record_all ( $record_all{$each});

				##################
my $L = $startDay - $endDay; my $x = $startDay - $currentTime ; my $rand =  &randomize($x, $L);


if (($jiraStatus{$jiraId_} =~ /open/i) && (7.5 < $rand ) && ( $rand <20 )) { $jiraStatus{$jiraId_} = "Resolved";}
if (($jiraStatus{$jiraId_} =~ /open/i) && (3.0 < $rand ) && ( $rand <7.5 )) { $jiraStatus{$jiraId_} = "Closed";}
if (($jiraStatus{$jiraId_} =~ /Resolved/i) && ($rand >= 7.5)) { $jiraStatus{$jiraId_} = "Closed" ;}

 $rand =  &randomize($x, $L);

if (($jiraPriority{$jiraId_} 	=~ /Major/i) && ($rand >= 7.5)) { $jiraPriority{$jiraId_} = "Minor" ;}
if (($jiraPriority{$jiraId_} 	=~ /Minor/i) && ($rand < 3.0) && ( $rand <7.5 )) { $jiraPriority{$jiraId_} = "Cosmatics";}



				##################




				if ($jiraStatus{$jiraId_} =~ /open/i) 		{ $lastOpenDate{$jiraId_} 	= $jiraUpdated{$jiraId_}; $NofOpenState{$jiraId_} ++;   $totalNofOpen ++;}
				if ($jiraStatus{$jiraId_} =~ /resolved/i) 	{ $lastResolvedDate{$jiraId_} 	= $jiraUpdated{$jiraId_}; $NofResolvedState{$jiraId_}++;$totalNofResolved++; $totalNofOpen--;}
				if ($jiraStatus{$jiraId_} =~ /closed/i) 	{ $lastClosedDate{$jiraId_} 	= $jiraUpdated{$jiraId_}; $NofClosedState{$jiraId_}++;  $totalNofClosed++; $totalNofResolved--;}

				if ($jiraStatus{$jiraId_} =~ /open/i) 		{ ; }
				if ($jiraStatus{$jiraId_} =~ /resolved/i) 	{  $TofResolvedState{$jiraId_} = DateCalc ( $lastOpenDate{$jiraId_},  $lastResolvedDate{$jiraId_})	;}	
				if ($jiraStatus{$jiraId_} =~ /closed/i) 	{  $TofClosedState{$jiraId_} = DateCalc ( $lastResolvedDate{$jiraId_},  $lastClosedDate{$jiraId_})	;
										   $TofOpenState{$jiraId_}   = DateCalc ( $lastOpenDate{$jiraId_},  $lastClosedDate{$jiraId_})		;}
			}
		} 
		# --> print " Status   Aggregation: NofOpen= $totalNofOpen NofResolved= $totalNofResolved NofClosed=$totalNofClosed   					todo1: Calc Percentage todo2: threshold\n";

		if (($metricsId == 1) || ( $metricsId == 99)){ # Metrics 1	Reporter - Counts
		open Fout1, ">>$tcName/1_Reporter.txt";
		open Fout2, ">>$tcName/1_Reporter_excel.txt";
		my %accumulation; 
		foreach my $each (sort keys %record_all_latest) { foreach my $each_sub_search (sort keys %lookupReporters) { if (($jiraStatus{$each}) && ($jiraReporter{$each} eq $each_sub_search)){ $accumulation{$each_sub_search} ++; } } }
		my $ctr=0; foreach my $each (keys %accumulation) { $ctr = $ctr + $accumulation{$each}  ; }
		my $ctr1 ; if ($ctr == 0) { $ctr1 = 1;} else {$ctr1 = $ctr; }
	        printf Fout1 "%s	Date: %s %-30s: ", "Metrics 1", &UnixDate("$dateNow", "%b %e, %Y"), "(Reporters - Defect Counts)";
		printf Fout1 "%-30s", "Totals ($ctr)"; foreach my $each (sort keys %lookupReporters) { my $pct = sprintf("%.2f", $accumulation{$each}/$ctr1); $pct = $pct * 100;  my $str = sprintf "%25s (%4d - $pct%)", $each, $accumulation{$each} ; printf Fout1 "%-20s", $str, int (($accumulation{$each}*100)/$ctr1)  ; } print Fout1 "\n";
		printf Fout2 ",\n[\"%s\", ", &UnixDate("$dateNow", "%b %e, %Y");
		printf Fout2 "\"%d\"", $ctr; foreach my $each (sort keys %lookupReporters) {   printf Fout2 ",\"%d\"", $accumulation{$each}; } print Fout2 "]";
		close Fout2;	
		close Fout1;	
		}

		if (($metricsId == 2)|| ( $metricsId == 99)) { # Metrics 2	Priority - Counts
		open Fout1, ">>$tcName/2_Priority.txt";
		open Fout2, ">>$tcName/2_Priority_excel.txt";
		my %accumulation; 
		foreach my $each (sort keys %record_all_latest) { 
			foreach my $each_sub_search (sort keys %lookupPriorities) { 
				if (($jiraStatus{$each}) && ($jiraPriority{$each} eq $each_sub_search)){ $accumulation{$each_sub_search} ++; } 
			} 
		}
		my $ctr=0; foreach my $each (keys %accumulation) { $ctr = $ctr + $accumulation{$each}  ; }
		my $ctr1 ; if ($ctr == 0) { $ctr1 = 1;} else {$ctr1 = $ctr; }
	        printf Fout1 "%s	Date: %s %-30s: ", "Metrics 2", &UnixDate("$dateNow", "%b %e, %Y"), "(Priorities - Defect Counts)";
		printf Fout1 "%-30s", "Totals ($ctr)"; foreach my $each (sort keys %lookupPriorities) { my $pct = sprintf("%.2f", $accumulation{$each}/$ctr1); $pct = $pct * 100;  my $str = sprintf "%25s (%4d - $pct%)", $each, $accumulation{$each} ; printf Fout1 "%-20s", $str, int (($accumulation{$each}*100)/$ctr1)  ; } print Fout1 "\n";
		printf Fout2 ",\n[\"%s\", ", &UnixDate("$dateNow", "%b %e, %Y");
		printf Fout2 "\"%d\"", $ctr; foreach my $each (sort keys %lookupPriorities) {   printf Fout2 ",\"%d\"", $accumulation{$each}; } print Fout2 "]";
		close Fout2;	
		close Fout1;	
		}

		if (($metricsId == 3)|| ( $metricsId == 99)) { # Metrics 3	Issuetype - Counts
		open Fout1, ">>$tcName/3_Issuetype.txt";
		open Fout2, ">>$tcName/3_Issuetype_excel.txt";
		my %accumulation; 
		foreach my $each (sort keys %record_all_latest) { 
			foreach my $each_sub_search (sort keys %lookupIssuetypes) { 
				if (($jiraStatus{$each}) && ($jiraIssuetype{$each} eq $each_sub_search)){ $accumulation{$each_sub_search} ++; } 
			} 
		}
		my $ctr=0; foreach my $each (keys %accumulation) { $ctr = $ctr + $accumulation{$each}  ; }
		my $ctr1 ; if ($ctr == 0) { $ctr1 = 1;} else {$ctr1 = $ctr; }
	        printf Fout1 "%s	Date: %s %-30s: ", "Metrics 3", &UnixDate("$dateNow", "%b %e, %Y"), "(Issuetype - Defect Counts)";
		printf Fout1 "%-30s", "Totals ($ctr)"; foreach my $each (sort keys %lookupIssuetypes) { my $pct = sprintf("%.2f", $accumulation{$each}/$ctr1); $pct = $pct * 100;  my $str = sprintf "%25s (%4d - $pct%)", $each, $accumulation{$each} ; printf Fout1 "%-20s", $str, int (($accumulation{$each}*100)/$ctr1)  ; } print Fout1 "\n";
		printf Fout2 ",\n[\"%s\", ", &UnixDate("$dateNow", "%b %e, %Y");
		printf Fout2 "\"%d\"", $ctr; foreach my $each (sort keys %lookupIssuetypes) {   printf Fout2 ",\"%d\"", $accumulation{$each}; } print Fout2 "]";
		close Fout2;	
		close Fout1;	
		}

		if (($metricsId == 4)|| ( $metricsId == 99)) { # Metrics 4	Time to fix and Time to close
		open Fout1, ">>$tcName/4_Resolve_Close_Time.txt";
		open Fout2, ">>$tcName/4_Resolve_Close_Time_excel.txt";
		my %accumulation;  my $NofResolved = 0; my $NofClosed = 0; my $NofOpen = 0;
		my $totalResolvedTime 	= 0;
		my $totalOpenTime	= 0;
		my $totalClosedTime 	= 0;
		foreach my $each (sort keys %record_all_latest) { 
			if  ($TofResolvedState{$each}	) { $NofResolved ++; $totalResolvedTime += &totalSeconds( $TofResolvedState{$each}); }
			if  ($TofClosedState{$each}	) { $NofClosed   ++; $totalClosedTime 	+= &totalSeconds( $TofClosedState{$each}); }
			if  ($TofOpenState{$each}	) { $NofOpen     ++; $totalOpenTime 	+= &totalSeconds( $TofOpenState{$each}); }
		}
		my $avgResolvedTime 	= int($totalResolvedTime/$NofResolved) if ($NofResolved != 0);
		my $avgClosedTime 	= int($totalClosedTime/$NofClosed)     if ($NofClosed   != 0);
		my $avgOpenTime 	= int($totalOpenTime/$NofOpen)         if ($NofOpen     != 0);
		printf Fout1 "%s	Date: %s %-30s: ", "Metrics 4", &UnixDate("$dateNow", "%b %e, %Y"), "(Resolve/Close/Open Time   )";
		print Fout1 "Avg Resolved Time:  ". &formatSeconds($avgResolvedTime)."   Avg Closed Time : ". &formatSeconds($avgClosedTime). "  Avg Open Time: ". &formatSeconds($avgOpenTime); print Fout1 "\n";
		#printf Fout2 ",\n[\"%s\", ", &UnixDate("$dateNow", "%b %e, %Y");
		#printf Fout2 "\"%d\"", $ctr; foreach my $each (sort keys %lookupResolve_Close_Time) {   printf Fout2 ",\"%d\"", $accumulation{$each}; } print Fout2 "]";
		close Fout2;	
		close Fout1;	
		}


		if (($metricsId == 5)|| ( $metricsId == 99)) { # Metrics 5	Resolutions - Counts
		open Fout1, ">>$tcName/5_Resolution.txt";
		open Fout2, ">>$tcName/5_Resolution_excel.txt";
		my %accumulation; 
		foreach my $each (sort keys %record_all_latest) { 
			foreach my $each_sub_search (sort keys %lookupResolutions) { 
				if (($jiraStatus{$each}) && ($jiraResolution{$each} eq $each_sub_search)){ $accumulation{$each_sub_search} ++; } 
			} 
		}
		my $ctr=0; foreach my $each (keys %accumulation) { $ctr = $ctr + $accumulation{$each}  ; }
		my $ctr1 ; if ($ctr == 0) { $ctr1 = 1;} else {$ctr1 = $ctr; }
	        printf Fout1 "%s	Date: %s %-30s: ", "Metrics 5", &UnixDate("$dateNow", "%b %e, %Y"), "(Resolution - Defect Counts)";
		printf Fout1 "%-30s", "Totals ($ctr)"; foreach my $each (sort keys %lookupResolutions) { my $pct = sprintf("%.2f", $accumulation{$each}/$ctr1); $pct = $pct * 100;  my $str = sprintf "%25s (%4d - $pct%)", $each, $accumulation{$each} ; printf Fout1 "%-20s", $str, int (($accumulation{$each}*100)/$ctr1)  ; } print Fout1 "\n";
		printf Fout2 ",\n[\"%s\", ", &UnixDate("$dateNow", "%b %e, %Y");
		printf Fout2 "\"%d\"", $ctr; foreach my $each (sort keys %lookupResolutions) {   printf Fout2 ",\"%d\"", $accumulation{$each}; } print Fout2 "]";
		close Fout2;	
		close Fout1;	
		}

		if (($metricsId == 6)|| ( $metricsId == 99)) { # Metrics 6	Status - Counts
		open Fout1, ">>$tcName/6_Status.txt";
		open Fout2, ">>$tcName/6_Status_excel.txt";
		my %accumulation; 
		foreach my $each (sort keys %record_all_latest) { 
			foreach my $each_sub_search (sort keys %lookupStatus) { 
				if (($jiraStatus{$each}) && ($jiraStatus{$each} eq $each_sub_search)){ $accumulation{$each_sub_search} ++; } 
			} 
		}
		my $ctr=1; foreach my $each (keys %accumulation) { $ctr = $ctr + $accumulation{$each}  ; }
		my $ctr1 ; if ($ctr == 0) { $ctr1 = 1;} else {$ctr1 = $ctr; }
	        printf Fout1 "%s	Date: %s %-30s: ", "Metrics 6", &UnixDate("$dateNow", "%b %e, %Y"), "(Status     - Defect Counts)";
		printf Fout1 "%-30s", "Totals ($ctr)"; foreach my $each (sort keys %lookupStatus) { my $pct = sprintf("%.2f", $accumulation{$each}/$ctr1); $pct = $pct * 100;  my $str = sprintf "%25s (%4d - $pct%)", $each, $accumulation{$each} ; printf Fout1 "%-20s", $str, int (($accumulation{$each}*100)/$ctr1)  ; } print Fout1 "\n";
		printf Fout2 ",\n[\"%s\", ", &UnixDate("$dateNow", "%b %e, %Y");
		printf Fout2 "\"%d\"", $ctr; foreach my $each (sort keys %lookupStatus) {   printf Fout2 ",\"%d\"", $accumulation{$each}; } print Fout2 "]";
		close Fout2;	
		close Fout1;	
		}

		if (($metricsId == 7)|| ( $metricsId == 99)) { # Metrics 7	Priority by Viki - Counts
		open Fout1, ">>$tcName/7_Priority_viki.txt";
		open Fout2, ">>$tcName/7_Priority_viki_excel.txt";
		my %accumulation; 
		foreach my $each (sort keys %record_all_latest) { 
			foreach my $each_sub_search (sort keys %lookupPriorities) { 
				if (($jiraReporter{$each} =~ /viki/i) && ($jiraPriority{$each}) && ($jiraPriority{$each} eq $each_sub_search)){ $accumulation{$each_sub_search} ++; } 
			} 
		}
		my $ctr=1; foreach my $each (keys %accumulation) { $ctr = $ctr + $accumulation{$each}  ; }
		my $ctr1 ; if ($ctr == 0) { $ctr1 = 1;} else {$ctr1 = $ctr; }
	        printf Fout1 "%s	Date: %s %-30s: ", "Metrics 6", &UnixDate("$dateNow", "%b %e, %Y"), "(Status     - Defect Counts)";
		printf Fout1 "%-30s", "Totals ($ctr)"; foreach my $each (sort keys %lookupPriorities) { my $pct = sprintf("%.2f", $accumulation{$each}/$ctr1); $pct = $pct * 100;  my $str = sprintf "%25s (%4d - $pct%)", $each, $accumulation{$each} ; printf Fout1 "%-20s", $str, int (($accumulation{$each}*100)/$ctr1)  ; } print Fout1 "\n";
		printf Fout2 ",\n[\"%s\", ", &UnixDate("$dateNow", "%b %e, %Y");
		printf Fout2 "\"%d\"", $ctr; foreach my $each (sort keys %lookupPriorities) {   printf Fout2 ",\"%d\"", $accumulation{$each}; } print Fout2 "]";
		close Fout2;	
		close Fout1;	
		}



	}

		if (($metricsId == 1) || ($metricsId == 99)) { # Metrics 1	Status - Counts
		my $item = "1_Reporter";
		open Fout2, ">>$tcName/${item}_excel.txt"; print Fout2 "];"; close Fout2;
		my $cmd = "$tcName/_genSS.pl -xlInput ${item}_excel.txt"; 
		my $rst = `$cmd`; print $rst;
 		move ("$tcName/metrics.gif",  "$tcName/${item}.gif");
 		move ("$tcName/metrics.xls",  "$tcName/${item}.xls");
		}

		if (($metricsId == 2) || ($metricsId == 99)){ # Metrics 2	Status - Counts
		my $item = "2_Priority";
		open Fout2, ">>$tcName/${item}_excel.txt"; print Fout2 "];"; close Fout2;
		my $cmd = "$tcName/_genSS.pl -xlInput ${item}_excel.txt"; 
		my $rst = `$cmd`; print $rst;
 		move ("$tcName/metrics.gif",  "$tcName/${item}.gif");
 		move ("$tcName/metrics.xls",  "$tcName/${item}.xls");
		}

		if (($metricsId == 3)|| ($metricsId == 99)) { # Metrics 3	Status - Counts
		my $item = "3_Issuetype";
		open Fout2, ">>$tcName/${item}_excel.txt"; print Fout2 "];"; close Fout2;
		my $cmd = "$tcName/_genSS.pl -xlInput ${item}_excel.txt"; 
		my $rst = `$cmd`; print $rst;
 		move ("$tcName/metrics.gif",  "$tcName/${item}.gif");
 		move ("$tcName/metrics.xls",  "$tcName/${item}.xls");
		}

		if (($metricsId == 4) || ($metricsId == 99)){ # Metrics 4	Status - Counts
		my $item = "4_Resolve_Close_Time";
		open Fout2, ">>$tcName/${item}_excel.txt"; print Fout2 "];"; close Fout2;
		my $cmd = "$tcName/_genSS.pl -xlInput ${item}_excel.txt"; 
		my $rst = `$cmd`; print $rst;
 		move ("$tcName/metrics.gif",  "$tcName/${item}.gif");
 		move ("$tcName/metrics.xls",  "$tcName/${item}.xls");
		}

		if (($metricsId == 5)|| ($metricsId == 99)) { # Metrics 5	Status - Counts
		my $item = "5_Resolution";
		open Fout2, ">>$tcName/${item}_excel.txt"; print Fout2 "];"; close Fout2;
		my $cmd = "$tcName/_genSS.pl -xlInput ${item}_excel.txt"; 
		my $rst = `$cmd`; print $rst;
 		move ("$tcName/metrics.gif",  "$tcName/${item}.gif");
 		move ("$tcName/metrics.xls",  "$tcName/${item}.xls");
		}
		if (($metricsId == 6)|| ($metricsId == 99)) { # Metrics 6	Status - Counts
		my $item = "6_Status";
		open Fout2, ">>$tcName/${item}_excel.txt"; print Fout2 "];"; close Fout2;
		my $cmd = "$tcName/_genSS.pl -xlInput ${item}_excel.txt"; 
		my $rst = `$cmd`; print $rst;
 		move ("$tcName/metrics.gif",  "$tcName/${item}.gif");
 		move ("$tcName/metrics.xls",  "$tcName/${item}.xls");
		}
		if (($metricsId == 7)|| ($metricsId == 99)) { # Metrics 7	Priority by viki - Counts
		my $item = "7_Priority_viki";
		open Fout2, ">>$tcName/${item}_excel.txt"; print Fout2 "];"; close Fout2;
		my $cmd = "$tcName/_genSS.pl -xlInput ${item}_excel.txt"; 
		my $rst = `$cmd`; print $rst;
 		move ("$tcName/metrics.gif",  "$tcName/${item}.gif");
 		move ("$tcName/metrics.xls",  "$tcName/${item}.xls");
		}

exit;



sub readCapturedJiras {
	my $finName= shift;  my $CEDue = shift; my $jiraId; my $changDate; my %dummy; my $jiraId; 
	my $strRead ;
	my $ctr=0;
	printf " <- %-80s (readCapturedJiras)\n", $finName; 
	open Fin,     $finName || die "Can;'t open $finName:$!"; 
	while (<Fin>) {
		if (/\-+Start\s+Jira\s+content\-*/i) { $strRead = ""; $jiraId="";}
		elsif (/\-+Stop\s+Jira\s+content\-*/i) { &readCapturedJira ($strRead); } else { $strRead .= $_ if ( $_ !~ /^\s*$/); 
		}
	}
	close Fin;
	return 0;	
}


sub readCapturedJira { # from jira webUI
	my $each = shift;
	 	my $jiraId=""; my $changeDate=""; my %recordTCStatus; my $jiraTCStatus; my $jiraTCStatusFinal; 
		my $changeDate; my $updateDate; my $ceDue; my $jiraType; my $jiraStatus; my $cePriority; my $assignee;
		my $statusChangeDate; my $statusFrom; my $statusTo; my $Updated;
		my $inChangeHistory=0; my @records = split(/\n/, $each); 
		foreach (@records) {
			if (/^\s*\[($projCode\-\d+)\]\s+(.+)/)	 {$jiraId = $1; $jiraSummary{$jiraId} = $2; $jiraRec{$jiraId} = $each;} 
			if (/^\s*Assignee\s*:\s*(.+)\s*$/) { $assignee= $1; $jiraAssignee{$jiraId} = $assignee; $lookupAssignees{$assignee}="Assignees"; }
 			if (/^\s*Created\s*:\s+(.+)\s*$/) { $jiraCreated{$jiraId} = $1; 			}	
			if (/^\s*IssueType\s*:\s*(.+)\s*$/i) { $jiraIssuetype{$jiraId} = $1;             	$lookupIssuetypes{$1}="Issuetypes";} 
			if (/^\s*Project\s*:\s*(.+)\s*$/) {  $jiraProject{$jiraId} = $1; 			}
			if (/^\s*Priority\s*:\s*(.+)\s*$/) {  $jiraPriority{$jiraId} = $1; 	         	$lookupPriorities{$1}="Priorities";}
			if (/^\s*Reporter\s*:\s*(.+)\s*$/) {  $jiraReporter{$jiraId} = $1; 	         	$lookupReporters{$1}="Reporters";}  
			if (/^\s*Resolution\s*:\s*(.+)\s*$/) {  $jiraResolution{$jiraId} = $1; 	          	$lookupResolutions{$1}="Resolutions";}  
			if (/^\s*Resolutiondate\s*:\s*(.+)\s*$/) {  $jiraResolutiondate{$jiraId} = $1; 		}  
			if (/^\s*Security\s*:\s*(.+)\s*$/) {  $jiraSecurity{$jiraId} = $1;			} 
			if (/^\s*Status\s*:\s*(.+)\s*$/) {  $jiraStatus{$jiraId} = $1;		          	$lookupStatus{$1}="Status";} 
			if (/^\s*Summary\s*:\s*(.+)\s*$/) {  $jiraSummary{$jiraId} = $1;			} 
			if (/^\s*Updated\s*:\s+(.+)/) { $jiraUpdated{$jiraId} = $1; $Updated = $1;		}
	 	}
		$lookupStatus{"Resolved"} 	= "Status";		# default lookup values 
		$lookupStatus{"Closed"} 	= "Status";
		$lookupPriorities{"Major"} 	= "Priorities";
		$lookupPriorities{"Minor"} 	= "Priorities";
		$lookupPriorities{"Cosmatics"} 	= "Priorities";
		my $secs = UnixDate($jiraUpdated{$jiraId},"%s");
		my $key = "${jiraId}_$secs"; 
		$record_all{$key}="-----------------------------Start JIRA content---------------------------\n$each-----------------------------Stop JIRA content---------------------------\n";
		$record_all_Updated{$key} = $Updated;
}

sub readCapturedJira_from_record_all { # from jira webUI
	my $each = shift;
	 	my $jiraId=""; my $changeDate=""; my %recordTCStatus; my $jiraTCStatus; my $jiraTCStatusFinal; 
		my $changeDate; my $updateDate; my $ceDue; my $jiraType; my $jiraStatus; my $cePriority; my $assignee;
		my $statusChangeDate; my $statusFrom; my $statusTo; my $Updated;
		my $inChangeHistory=0; my @records = split(/\n/, $each); 
		foreach (@records) {
			if (/^\s*\[($projCode\-\d+)\]\s+(.+)/)	 {$jiraId = $1; $jiraSummary{$jiraId} = $2; $jiraRec{$jiraId} = $each;} 
			if (/^\s*Assignee\s*:\s*(.+)\s*$/) { $assignee= $1; $jiraAssignee{$jiraId} = $assignee; }
 			if (/^\s*Created\s*:\s+(.+)\s*$/) { $jiraCreated{$jiraId} = $1; }	
			if (/^\s*IssueType\s*:\s*(.+)\s*$/i) { $jiraIssuetype{$jiraId} = $1;} 
			if (/^\s*Project\s*:\s*(.+)\s*$/) {  $jiraProject{$jiraId} = $1; }
			if (/^\s*Priority\s*:\s*(.+)\s*$/) {  $jiraPriority{$jiraId} = $1; }
			if (/^\s*Reporter\s*:\s*(.+)\s*$/) {  $jiraReporter{$jiraId} = $1; }  
			if (/^\s*Resolution\s*:\s*(.+)\s*$/) {  $jiraResolution{$jiraId} = $1; }  
			if (/^\s*Resolutiondate\s*:\s*(.+)\s*$/) {  $jiraResolutiondate{$jiraId} = $1; }  
			if (/^\s*Security\s*:\s*(.+)\s*$/) {  $jiraSecurity{$jiraId} = $1;} 
			if (/^\s*Status\s*:\s*(.+)\s*$/) {  $jiraStatus{$jiraId} = $1;} 
			if (/^\s*Summary\s*:\s*(.+)\s*$/) {  $jiraSummary{$jiraId} = $1;} 
			if (/^\s*Updated\s*:\s+(.+)/) { $jiraUpdated{$jiraId} = $1; }
	 	}
}


sub getCurrentJiraItemValue { 
	my $jiraId = shift; my $dateSearched = shift; my $jiraItem= shift; my $dateCurrent; my $return = "NoRecord"; 

	my $a = &UnixDate("$dateSearched", "%b %e, %Y");
	my $b = &UnixDate("$jiraUpdated{$jiraId}", "%b %e, %Y");
	my $c = &Date_Cmp($a, $b);
 		if ($c ==0 ) {
			if ($jiraItem =~ /Assignee/i) { $return = $jiraAssignee{$jiraId}; }
			if ($jiraItem =~ /Created/i) { $return = $jiraCreated{$jiraId}; }
			if ($jiraItem =~ /Issuetype/i) { $return = $jiraIssuetype{$jiraId}; }
			if ($jiraItem =~ /Priority/i) { $return = $jiraPriority{$jiraId}; }
			if ($jiraItem =~ /Project/i) { $return = $jiraProject{$jiraId}; }
			if ($jiraItem =~ /Reporter/i) { $return = $jiraReporter{$jiraId}; }
			if ($jiraItem =~ /Resolution/i) { $return = $jiraResolution{$jiraId}; }
			if ($jiraItem =~ /Resolutiondate/i) { $return = $jiraResolutiondate{$jiraId}; }
			if ($jiraItem =~ /Security/i) { $return = $jiraSecurity{$jiraId}; }
			if ($jiraItem =~ /Status/i) { $return = $jiraStatus{$jiraId}; }
			if ($jiraItem =~ /Summary/i) { $return = $jiraSummary{$jiraId}; }
			if ($jiraItem =~ /Updated/i) { $return = $jiraUpdated{$jiraId}; }
 		}	
	return $return;
}

sub getJiraItemValue { 
	my $jiraId = shift; my $jiraItem= shift;  my $return = "NoRecord"; 

			if ($jiraItem =~ /Assignee/i) { $return = $jiraAssignee{$jiraId}; }
			if ($jiraItem =~ /Created/i) { $return = $jiraCreated{$jiraId}; }
			if ($jiraItem =~ /Issuetype/i) { $return = $jiraIssuetype{$jiraId}; }
			if ($jiraItem =~ /Priority/i) { $return = $jiraPriority{$jiraId}; }
			if ($jiraItem =~ /Project/i) { $return = $jiraProject{$jiraId}; }
			if ($jiraItem =~ /Reporter/i) { $return = $jiraReporter{$jiraId}; }
			if ($jiraItem =~ /Resolution/i) { $return = $jiraResolution{$jiraId}; }
			if ($jiraItem =~ /Resolutiondate/i) { $return = $jiraResolutiondate{$jiraId}; }
			if ($jiraItem =~ /Security/i) { $return = $jiraSecurity{$jiraId}; }
			if ($jiraItem =~ /Status/i) { $return = $jiraStatus{$jiraId}; }
			if ($jiraItem =~ /Summary/i) { $return = $jiraSummary{$jiraId}; }
			if ($jiraItem =~ /Updated/i) { $return = $jiraUpdated{$jiraId}; }
	return $return;
}


sub i_to_date { my $i = shift; my $today = ParseDate("today"); $today = UnixDate("today","%e/%b/%Y"); return UnixDate(&DateCalc($today, "$i days ago"), "%e/%b/%Y");  }

sub findStartEndDay {
my $startDay = -100000; 
my $endDay = 100000;
my $err;
open Fin_jira, "$jiraFName";
while ($_ =<Fin_jira>) {
	if ($_ =~ /Created\s*:\s*(.+)\s*$/) {
		my $createdDate = ParseDate($1);
		my $today = ParseDate("today");
		$today = UnixDate("today","%e/%b/%y");
		my $delta = DateCalc($createdDate, $today, \$err, );		
		$delta =~ /^\s*(\d+):(\d+):(\d+):(\d+):(\d+):(\d+):(\d+)/; 	

		my $year  = $1; my $month = $2; my $week = $3; my $day = $4; my $hour = $5;
		my $days = int ($year * 365 + $month * 30 + $week * 7 + $day + $hour/24 );

		if ($days <= $endDay) { $endDay = $days; }
		if ($days >= $startDay) { $startDay = $days; }
	}
}
return "startDay = $startDay endDay = $endDay";
}



{ ####### # create /Jira/jirafiles if ARG[0] is not NULL
	if ($ARGV[0] =~ /.+/i) {
		print " --> $tcName/JIRA/jirafiles......\n";
		mkdir "$tcName/JIRA";
		print " --> $tcNameTAF/JIRA/jirafiles......\n";
		mkdir "$tcNameTAF/JIRA";
 		foreach my $each (sort keys %jiraRec) { 
			open  Jira_file, ">$tcName/JIRA/$each.txt"; 
	 		print Jira_file $jiraRec{$each};
			close Jira_file;
			open  Jira_file, ">$tcNameTAF/JIRA/$each.txt"; 
	 		print Jira_file "<pre>$jiraRec{$each}</pre>";
			close Jira_file;
		} 
 	}
}


sub totalSeconds {
	my $delta = shift;
		my ($Y,$M,$W,$D,$H,$MIN,$S) = split /:/, $delta;
 		my $totalSec =$M * 30 * 24 * 3600 + $D * 24 * 3600 + $H * 3600 + $MIN * 60 + $S;
	return $totalSec;
}

sub formatSeconds{ 
my $time = shift; if ($time) {;} else { $time = 0; }
if ($time <60) { my $ret = sprintf "00:00:00:00:00:%02d",int($time); return $ret;}
my $months  = int ($time /30/ 3600 / 24); $time = $time % (3600 * 24 * 30);
my $days  = int ($time / 3600 / 24); $time = $time % (3600 * 24);
my $hours = int ($time / 3600); $time = $time % 3600;
my $minutes = int ($time / 60); $time = $time % 60;
my $seconds = int ($time);
return sprintf "%02d:%02d:%02d:%02d:%02d:%02d",$months,0,$days,$hours,$minutes,$seconds;
}

sub appendtoFile_ { # fname, fileContent, maxTCExecTime 
	my $fname 		= "e.txt"	; $fname 	= shift if @_; 
	my $content 		= " "	 	; $content 	= shift if @_;
	my $fname_ 		= $fname."_"	;
	if (-e $fname) {;} else { &createFile($fname,"");}

	open Fout, ">>$fname_" or die $!;
		if ($content) {;} else { $content = "";}
	print Fout $content; 
	close Fout;
}

sub createFile() {  	# TH:Generic Functions: create to file (TH:Generic Functions)
    my $fname = $_[0];
    $fname =~ s/\\/\//g;
    if (-e &getDir($fname)) { chmod 0777, &getDir($fname); ;} else { umask 0000; mkpath &getDir($fname); chmod 0777, &getDir($fname); }
	umask 0000; open Fout, ">$fname"; print Fout "$_[1]\n"; close Fout; chmod 0777, $fname;
}

sub randomize () {
my $x = 0.5	; $x = shift if @_;
my $L = 20	; $L = shift if @_;
my $A1 = 50; my $A2 = 50; my $PI = 3.1415926;

my $probability = 20 + (rand($A1) * sin(($x/$L+0.5)*$PI)  + rand($A2) * sin ($x*6.0/$L*$PI)) *  $x/$L;

return sprintf "%.2f", abs ($probability);
}

EOF_pl1
	$str =~ s/\${ip}/$ip/g;
	$str =~ s/__ip__/$ip/g;
	$str =~ s/__localhost__/$ip/g;
	$str =~ s/\${http_port}/$http_port/g;
 	$str =~ s/__PROJ__/$ProjName/g;
 	$str =~ s/__COMN__/$CompanyName/g;
	open Fout, "> $tcName/_index1.pl"; print Fout $str; close Fout;
	print " -> $tcName/_index1.pl\n";

}

sub generateIndex_pl {
my $str=<<'EOF_pl';


use Date::Manip;
use Getopt::Long;
use strict;

my $c 		= "c:";
my $_TAF 	= "_TAF";
my $CompanyName = "__COMN__";
my $ProjName 	= "__PROJ__";

my $web_ui_title = "__COMN__/__PROJ__";

my %jiraRec; my %jiraStatus; my %jiraSummary; my %jiraStatusDisplay; my %jiraStatusDisplay_key_Priority; my %jiraCEPriority; my %jiraIssueType;
my %jiraCEDue; my %jiraCEQAPerson; my %jiraReporter; my %jiraAssignee; my %jiraRecordTC; my $date; my $CEPriority="noValue"; my %jiraHttp;
my $issueType; my $help; my $excelStr; my $JIRABEO ; my $action; my $jiraN; my %jiraListByStatus; my %jiraListByStatusDisplay; my %jiraListByStatus;
my %jiraHistory; my %recordCEQAPersonJira; my $genJiraLists; my $genTaskJiraList; my $genTaskJiraListDelta; my $genItemJiraList; my $genItemJiraListDelta; 
my $genItemJiraListDeltaIter; my $genItemJiraListDeltaNew; my $genItemJiraListMissed; my $genTCJiraList; my $genTCJiraListDelta; my $SSName 		;
my %jiraSubjAction; my %historicalRec; my %jiraUpdateDate; my %jiraCreateDate; my %jiraCEPriority; my $interestedBuilds;
my $CEDue 		= "^\\s*CE Due:3\\.2\\.1"; 
my $projCode = "$ProjName";
my $tcName ="$c/$CompanyName/$ProjName";
my $tcNameTAF ="$c/$_TAF/$CompanyName/$ProjName";
my $bugJiraStatus	="Created,Assigned,Reopened,Resolved,Closed,Updated,Work started"; # missing Commented
my $bugJiraStatusDisplay="Open,Resolved,Closed"; # for display 
my $item = "Defect";
my $CEDueDisplay 	= "Build 3.2.3"; 
my $CEDueSSName 	= $CEDueDisplay;
my $sortOn 		= "priority";
my $jiraHostURL		= 'file:///'.$tcName."/JIRA/";
my $jiraHostURL		= 'http://__localhost__:8080/'."$CompanyName/$ProjName"."/JIRA";
#my $jiraHostURL		= 'http://localhost:8080/'.$tcName."/JIRA/";

my $startDay = 20;
my $endDay = 20;
my $step  	= 1;
######## vars for generateJiraList
my $fname    		="$tcName/_jiraList_and_Status.txt";
my $logFname 		="$tcName/_tcResult3_.html";
my $excelFname 		="$tcName/_xlInput_.txt";
my $fnameDefectList	="$tcName/_DefectJiraList.txt";
my $dateNow 		=&ParseDate("now");

my $jiraFName = "$tcName/jira.txt"; &readCapturedJiras($jiraFName); 
my $historyFnameItems	="$tcName/_HistoricalRecordItems.txt";
my $updateHistory 	=1 ;
my $metricsName 	= "Defect";
my $genHistoryTable	= "$tcName/_genHistoryTable.html";
my $bat               	= "$tcName/_1.bat";


GetOptions (
	"startDay=s" 		=> \$startDay, 
	"endDay=s" 		=> \$endDay, 
	"step=s" 		=> \$step, 
	"sortOn=s" 		=> \$sortOn, 
	"metricsName=s" 	=> \$metricsName, 
);



sub tc1 () {
if (&findStartEndDay() =~ /^\s*startDay\s*=\s*(\d+)\s+endDay\s*=\s*(\d+)\s*$/) { $startDay = $1; $endDay = $2; }
open Fout_BAT, "> $bat";
for (my $i = $startDay; $i >= $endDay; $i = $i - $step ) { print Fout_BAT "$tcName/_index.pl -startDay $i -endDay $i\n"; }
print Fout_BAT "$tcName/_index.pl -startDay $startDay -endDay $endDay\n";
close Fout_BAT;
print " -> $bat\n";
}

sub findStartEndDay {
my $startDay = -100000; 
my $endDay = 100000;
my $err;
open Fin_jira, "$jiraFName";
while ($_ =<Fin_jira>) {
	if ($_ =~ /Created\s*:\s*(.+)\s*$/) {
		my $createdDate = ParseDate($1);
		my $today = ParseDate("today");
		$today = UnixDate("today","%e/%b/%y");
		my $delta = DateCalc($createdDate, $today, \$err, );		
		$delta =~ /^\s*(\d+):(\d+):(\d+):(\d+):(\d+):(\d+):(\d+)/; 	

		my $year  = $1;
		my $month = $2;
		my $week = $3;
		my $day = $4;
		my $hour = $5;
		my $days = int ($year * 365 + $month * 30 + $week * 7 + $day + $hour/24 );

		if ($days <= $endDay) { $endDay = $days; }
		if ($days >= $startDay) { $startDay = $days; }
	}
}
$startDay = $startDay + 5; $endDay = $endDay -5 ; 
return "startDay = $startDay endDay = $endDay";
}



 	$excelStr .= "[";
	print " -1-> $logFname\n"; open Flog, ">$logFname"; 
 	print " -2-> $excelFname\n"; open FoutExcel, ">$excelFname";	
 	print " -3-> $fname\n"; open Fout, ">$fname"; # print to log: _jiraList_Status.txt 

	if ($ARGV[0] =~ /.+/i) {
		print " --> $tcName/JIRA/jirafiles......\n";
		mkdir "$tcName/JIRA";
		print " --> $tcNameTAF/JIRA/jirafiles......\n";
		mkdir "$tcNameTAF/JIRA";
 		foreach my $each (sort keys %jiraRec) { 
			open  Jira_file, ">$tcName/JIRA/$each.txt"; 
	 		print Jira_file $jiraRec{$each};
			close Jira_file;
			open  Jira_file, ">$tcNameTAF/JIRA/$each.txt"; 
	 		print Jira_file "<pre>$jiraRec{$each}</pre>";
			close Jira_file;
		} 
 	}


	my $totalCtr = 0; my $openCtr = 0; my $resolvedCtr = 0; my $closedCtr = 0; 
  	foreach my $each (keys %jiraRec) { 
		print Fout "-- $each -- ". &getCurrentJiraStatus($each, $dateNow). "\n"; 
			$totalCtr++; 
  			if    (&getCurrentJiraStatus($each, $dateNow) =~ /Open|Assigned/i) { $openCtr++;}
 			elsif (&getCurrentJiraStatus($each, $dateNow) =~ /Resolved/i) { $resolvedCtr++;}
 			elsif (&getCurrentJiraStatus($each, $dateNow) =~ /Closed/i) { $closedCtr++;} 
 			else { ; }
	}  


print Flog<<EOF;
<A HREF="http://__ip__:8080"><IMG SRC="metrics.gif" ALT="Warning: metrics.gif is not available." style="border: solid 3px #A7A7A7;" ></A>
EOF
	&printTableTitleTop(); 		### Print output Table Title               
for (my $currentTime = $startDay; $currentTime >= $endDay; $currentTime = $currentTime - $step ) {
	my $timeDelta = "-${currentTime}day"; $dateNow = &DateCalc("now", $timeDelta); # fix CE11498 missing from Closed list
	if ((&searchHistoryRec(&UnixDate("$dateNow", "%b %e, %Y")) =~ /^\s*$/) or  ( $currentTime == $endDay )){ 
		print "Processing ".&UnixDate("$dateNow", "%b %e, %Y"). " data \n";
		if ($currentTime == $endDay) {
		&processTableRow();
		&printTableRow("n") ; 
		} else {
		&printTableRowB($dateNow, "n");
		}
		
	}
}

	print Fout "------------|"; foreach my $each (split (/,/, $bugJiraStatus)) { printf Fout "%15s", "---------------";} print Fout "\n";
my $tmp = " - ${endDay}day"; $dateNow = &DateCalc("now", $tmp); undef $tmp;
	#### Done with Processing Data

print Flog "\n\n";
	#### print Jira list
foreach my $each (sort { &sortStatus($a) <=> &sortStatus($b)} keys %jiraListByStatusDisplay) {
	my $tmpStr1 = "Status = \"<a id=\"$each\"</a>"; 
	my $tmpStr2 = "$each\""; 
	$tmpStr2 = sprintf("%-12s%-50s", $tmpStr2, "$item Counts (Opened Resolved Closed): $openCtr $resolvedCtr $closedCtr");
	printf Flog sprintf ("<span style=\"background-color:Gainsboro\">%-10s%s%-63s  %-15s%-15s%-15s%-15s</span>\n", "          ", $tmpStr1, $tmpStr2, "Priority", "Assignee", "QA Person","CE Due"); 
	print Flog $jiraListByStatusDisplay{$each} . " \n";
}

close Flog;

if ($startDay == $endDay) { &genHistoryTable(); }
else {&genHistoryTableB() ;}

open Fin, $genHistoryTable; open Flog, ">>$logFname"; print Flog "\n";
while (<Fin>) { print Flog $_; }
close Flog;
close Fin;
	$excelStr =~ s/,\s*$//; 
	$excelStr .= "];\n" ; 
	print FoutExcel "$excelStr";
close FoutExcel; print " -> $excelFname\n";
close Fout;
exit;






sub searchHistoryRec {
	my ($dateSearch) = @_;
	&readHistoryRec();
	return $historicalRec{$dateSearch};
}
sub readHistoryRec {
	my $fname = $historyFnameItems;
	if ( -e $fname ) {
		print " <- $fname\n";
		open Fin, $fname;
		while ($_ = <Fin>) { chop; 
			{ ####
				if ($_ =~ /\s*0,0,0,0,0\s*/) {;} 
				@_ = split /\|/, $_; 
				my $timeTmp = $_[0]; 
				my $dtime = $_[0]; my $total = $_[1]; my $open  = $_[2]; my $resolved = $_[3]; my $closed = $_[4]; 
				my $cedue = $_[5]; my $metricsname = $_[6]; my $projcode = $_[7];
				$cedue =~ s/\s+$//g; $cedue =~ s/^\s+//g; $metricsname=~ s/\s+$//g; $metricsname=~ s/^\s+//g;
				if (($projcode =~ /$projCode/i) && ( $cedue eq $CEDue) && ($metricsname =~ /$metricsName/i)) {
 				$historicalRec{$dtime} = $_ if ($total != 0);
				} elsif ($metricsName =~ /defect/i) {
 				$historicalRec{$dtime} = $_ if ($total != 0);
				}
			} ####
		}
		close Fin;
	}
}
sub genChartBar {
	my ($num, $numLimit, $ctr, $ctrLimit, $totalLength) = @_; 
	my $str; my $dots;
	$str = sprintf("%-${numLimit}s", $num); 
	for (my $i = 0; $i <= int($ctr*($totalLength-$numLimit)/$ctrLimit);  $i++) { $str .= "."; }	
	$str; 
}

sub genPriorityStr {
	my ($state, $num, $numLimit, $ctr, $ctrLimit, $totalLength) = @_; 
	my $str; my $dots; my $totalCtr=0; my $key;
	$str = sprintf("%-${numLimit}s", $num); 
	for (my $i = 0; $i <= int($ctr*($totalLength-$numLimit)/$ctrLimit);  $i++) { $str .= "."; }	
	$str; 

	foreach my $each (split (/,/, "Open") ) {
		foreach my $each1 (split (/,/, "P0,P1,P2,P3,P4")) {
			 $key = $each."____".$each1;
		if ($jiraStatusDisplay_key_Priority{$key} == undef ) {$jiraStatusDisplay_key_Priority{$key} = 0;}	
			$totalCtr += $jiraStatusDisplay_key_Priority{$key};
		}
	}
	$str = "$totalCtr ";
	$str = $str." ".$jiraStatusDisplay_key_Priority{"Open____P0"}; 
	$str = $str.",".$jiraStatusDisplay_key_Priority{"Open____P1"}; 
	$str = $str.",".$jiraStatusDisplay_key_Priority{"Open____P2"}; 
	$str = $str.",".$jiraStatusDisplay_key_Priority{"Open____P3"}; 
	$str = $str.",".$jiraStatusDisplay_key_Priority{"Open____P4"}; 
	$str ;
}
sub processTableRow {
	print Fout  "-- BUG status as of --- $dateNow\n";
	if ($sortOn =~ /priority/i) {
		foreach my $each (sort {&getPriority($jiraCEPriority{$a}) <=> &getPriority($jiraCEPriority{$b}) || &getJiraId($b) <=> &getJiraId($a) } keys %jiraRec) {  # Issue 6
		&genJiraListByStatusDisplay ($each); 
		}
	} elsif ($sortOn =~ /CEDue/) { # sort on jirId
		foreach my $each (sort {&getCEDue($jiraCEDue{$b}) <=> &getCEDue($jiraCEDue{$a}) ||&getPriority($jiraCEPriority{$a}) <=> &getPriority($jiraCEPriority{$b}) ||&getJiraId($b) <=> &getJiraId($a) } keys %jiraRec) {  # Issue 6 
		&genJiraListByStatusDisplay ($each); 
		} 
	} else { # sort on jirId
	  	foreach my $each (sort {&getPriority($jiraCEPriority{$a}) <=> &getPriority($jiraCEPriority{$b}) || &getJiraId($b) <=> &getJiraId($a) } keys %jiraRec) {  # Issue 6 
		&genJiraListByStatusDisplay ($each); 
		}
	}
}


sub sortStatus {
	my ($status) = @_;
	my $return = 0;
	if ($status =~ /open/i) { $return = 1; }
	if ($status =~ /resolved/i) { $return = 2; }
	if ($status =~ /closed/i) { $return = 3; }
	return $return;
}

sub getPriority { my ($str) = shift; $str =~ /^\s*P(\d+)/i;  return 1; } # todo: Major --> 1 ... .
sub getJiraId{ my ($str) = shift; $str =~ /(\w+)\-(\d+)\-?/; return $2; }
sub strLen {
	my $tmp = shift;
	my $length = shift;
	if ($length =~ /^\s*$/) { $length = 14; }
	if (length ($tmp) > $length) { $length --; $tmp = substr($tmp,0,$length)."."; }
	return $tmp;
}

sub printTableTitleBottom { ##### print the table title at the table bottom 
	printf Flog "%20s", "--------------------";
	print Flog "------------"; foreach my $each (split (/,/, $bugJiraStatusDisplay)) { printf Flog "%20s", "--------------------";} print Flog "\n";
	printf Flog "            |";
	printf Flog ("%-19s", "Total $item Ctr");
	print Flog "|"; foreach my $each (split (/,/, $bugJiraStatusDisplay)) { printf Flog "<a href =\"#$each\">%-23s|", "$each </a>";} print Flog "\n";
	printf Flog "%20s", "--------------------";
	print Flog "------------"; foreach my $each (split (/,/, $bugJiraStatusDisplay)) { printf Flog "%20s", "--------------------";} print Flog "\n";
	print Flog "*: Opened include status = Create|Assigned|Reopened|Updated|Work started\n";
}

sub printTableTitleTopB {
	printf Flog "%20s", "--------------------";
	print Flog "------------"; foreach my $each (split (/,/, $bugJiraStatusDisplay)) { printf Flog "%20s", "--------------------";} print Flog "\n";

	printf Flog "            |";
	printf Flog ("%-19s", "Total $item Ctr");
	print Flog "|"; foreach my $each (split (/,/, $bugJiraStatusDisplay)) { 
		printf Flog "<a href =\"#$each\">%-23s|", "$each </a>";
	} print Flog "\n";
 	printf Flog "%20s", "--------------------";
 	print Flog "------------"; foreach my $each (split (/,/, $bugJiraStatusDisplay)) 
	{ 
		if ($each =~ /Opened/i) { printf Flog "%20s", "|T.N.|P0|P1|P2|P3|P4|";}
		else { printf Flog "%20s", "--------------------";}
	} 
	print Flog "\n";
} 

sub genHistoryTable { # when startDay == $endday 
	print " -> $genHistoryTable\n"; 	
	open Flog, "> $genHistoryTable"; 	
	print Flog "<html><title>$web_ui_title</title><pre>\n";
	&printTableTitleTopB();
   for (my $currentTime = $endDay; $currentTime <= $startDay; $currentTime = $currentTime + $step ) {
 	my $timeDelta = "-${currentTime}day"; $dateNow = &DateCalc("now", $timeDelta); 
 	if ((&searchHistoryRec(&UnixDate("$dateNow", "%b %e, %Y")) !~ /^\s*$/) ){ 
		&printTableRowB($dateNow); 
 	}
   }
	&printTableTitleBottom();
	print Flog "</pre></html>\n";
	close Flog;
}


sub genHistoryTableB { # when startDay != endDay 
	print " -> $genHistoryTable\n"; 	
	open Flog, "> $genHistoryTable"; 	
	print Flog "<html><title>$web_ui_title</title><pre>\n";
	&printTableTitleTopB();
   for (my $currentTime = $startDay; $currentTime >= $endDay; $currentTime = $currentTime - $step ) {
 	my $timeDelta = "-${currentTime}day"; $dateNow = &DateCalc("now", $timeDelta); 
 	if ((&searchHistoryRec(&UnixDate("$dateNow", "%b %e, %Y")) !~ /^\s*$/) ){ 
		&printTableRowB($dateNow); 
 	}
   }
	&printTableTitleBottom();
	print Flog "</pre></html>\n";
	close Flog;
}


sub genJiraListByStatusDisplay {
		my $each = shift;
		my $latestStatus = &getCurrentJiraStatus($each, $dateNow); 
		        if ($latestStatus !~ /NoRecord/i) {
			 printf Fout  "%20s:%20s%20s:%20s%50s\n", $each,$jiraIssueType{$each},$jiraCEPriority{$each},$latestStatus,&UnixDate("$dateNow", "%T on %b %e, %Y");
			 $jiraStatus{$latestStatus}++ ; $jiraListByStatus{$latestStatus}= $jiraListByStatus{$latestStatus}."$each\n";
			 if ($latestStatus =~ /Create|Assigned|Reopened|Updated|Work started/i) { $latestStatus = "Open"; }
			       $jiraStatusDisplay{$latestStatus}++ ; 
			my $tmpKey = $jiraCEPriority{$each};
			$tmpKey =~ /^\s*(P\d+)\s*/;
			$tmpKey = $1;
			$tmpKey = $latestStatus."____".$tmpKey; 
			$jiraStatusDisplay_key_Priority{$tmpKey} ++ ;
			undef $tmpKey;
			my $tmpStr = sprintf "<a href=\"$jiraHostURL/$each.txt\">%8s<\/a>", $each;	# todo
			my $tmpStr = sprintf ("%-10s%-75s%-15s%-15s%-15s%-15s\n", "[$tmpStr]", &strLen($jiraSummary{$each}, 74), $jiraCEPriority{$each}, &strLen($jiraAssignee{$each}), &strLen($jiraCEQAPerson{$each}), $jiraCEDue{$each});
			$jiraListByStatusDisplay{$latestStatus}= $jiraListByStatusDisplay{$latestStatus} . $tmpStr;
		        }
}



sub printTableTitleTop {

	$excelStr .= "[\"_\",\"TotalCtr\""; foreach my $each (split (/,/, $bugJiraStatusDisplay)) { $excelStr .= ",\"$each\""; } $excelStr .= "],\n";

	print Fout "------------|"; foreach my $each (split (/,/, $bugJiraStatus)) { printf Fout "%15s", "---------------";} print Fout "\n";
	print Fout "            |		$projCode $item Historical Metrics ( $CEDueDisplay )\n";
	print Fout "------------|"; foreach my $each (split (/,/, $bugJiraStatus)) { printf Fout "%15s", "---------------";} print Fout "\n";
	print Fout "            |"; foreach my $each (split (/,/, $bugJiraStatus)) { printf Fout "%15s", $each;            } print Fout "\n";
	print Fout "------------|"; foreach my $each (split (/,/, $bugJiraStatus)) { printf Fout "%15s", "---------------";} print Fout "\n";

	print Flog "<html><title>$web_ui_title</title><body ONCLICK=\"hideMenuAll()\"> <head> <META http-equiv=\"refresh\" content=\"600\"> </head><pre>\n";
	printf Flog "%20s", "--------------------";
	print Flog "------------"; foreach my $each (split (/,/, $bugJiraStatusDisplay)) { printf Flog "%20s", "--------------------";} print Flog "\n";
	print Flog "            $projCode $item Historical Metrics (<a title=\"click to download Excel Spreadsheet\" href=\"http://10.109.30.252/excelSheets/Defects${CEDueSSName}.xls\">$CEDueDisplay</a>)  \n";
	print Flog<<EOF;
<a href="http://10.109.30.252/build_3_2_2.html">build 3.2.2</a> <a href="http://10.109.30.252/build_3.2.1.html">build 3.2.1</a> <a href="http://10.109.30.252/DefectsCEDue3_2_0_Final.html">Build 3.2.0 </a> <a href="http://10.109.30.252/CEDue3_1_3.html">Build 3.1.3</a> <a href="http://10.109.30.252/CEDue3_1_0.html">Build 3.1.0</a> <a href="http://10.109.30.252/CEDue3_0.html">Build 3.0</a>
EOF
	printf Flog "%20s", "--------------------";
	print Flog "------------"; foreach my $each (split (/,/, $bugJiraStatusDisplay)) { printf Flog "%20s", "--------------------";} print Flog "\n";
}


sub printTableRow {
	print " ------------------- printTableRow\n";
	my ($printYN) = @_;
	print " ->> $historyFnameItems for ". &UnixDate("$dateNow", "%b %e, %Y") ." metrics.\n" if ($updateHistory == 1);
 	open FoutHistoryItems, ">>$historyFnameItems" if ($updateHistory == 1); 
	print Fout "". &UnixDate("$dateNow", "%b %e, %Y") ."|";
	my $totalDefectCtr = 0; 
 	foreach my $each (split (/,/, $bugJiraStatusDisplay)) { $totalDefectCtr += $jiraStatusDisplay{"$each"}; }
	$totalDefectCtr = $totalDefectCtr + 10;

 	my $tmpTotalCtr=0; my $tmpStr;
 	foreach my $each (split (/,/, $bugJiraStatusDisplay)) { $tmpTotalCtr += $jiraStatusDisplay{"$each"}; }
	undef $tmpTotalCtr; 
	undef $tmpStr;
	foreach my $each (split (/,/, $bugJiraStatusDisplay)) { 
			if ($jiraStatusDisplay{"$each"} !~ /^\s*$/ ) {
		} else {
		}
		}

	foreach my $each (split (/,/, $bugJiraStatus)) { printf Fout "%14s|", $jiraStatus{"$each"};} print Fout "\n";
	print Flog "". &UnixDate("$dateNow", "%b %e, %Y") ."|"  if ($printYN !~ /n/i) ;
 	print FoutHistoryItems "". &UnixDate("$dateNow", "%b %e, %Y") ."|" if ($updateHistory == 1);

 	my $tmpTotalCtr=0;
 	foreach my $each (split (/,/, $bugJiraStatusDisplay)) { $tmpTotalCtr += $jiraStatusDisplay{"$each"}; }
		my $tmpStr = &genChartBar($tmpTotalCtr, 4, $tmpTotalCtr ,$totalDefectCtr, 19);
 		printf Flog "%-19s|", $tmpStr if ($printYN !~ /n/i);
  		printf FoutHistoryItems "%-19s|", $tmpStr if ($updateHistory == 1);
 	undef $tmpTotalCtr;

	foreach my $each (split (/,/, $bugJiraStatusDisplay)) { 
		my $tmpStr;
		my $tmpStrB;
		if ($each =~ /open/i) {  
			$tmpStr = &genPriorityStr($each, $jiraStatusDisplay{"$each"}, 4, $jiraStatusDisplay{"$each"} ,100, 19); 
			$tmpStrB = $tmpStr;
			$tmpStrB =~ /^\s*(\d+)\s+(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*/;
			$tmpStrB =sprintf("%-4d %-2d|%-2d|%-2d|%-2d|%-2d", $1,$2,$3,$4,$5,$6);
		} else {
			$tmpStr = &genChartBar($jiraStatusDisplay{"$each"}, 4, $jiraStatusDisplay{"$each"} ,$totalDefectCtr , 19); 
			$tmpStrB = $tmpStr;
		}
		printf Flog "%-19s|", $tmpStrB  if ($printYN !~ /n/i) ;
 		printf FoutHistoryItems "%-19s|", $tmpStr if ($updateHistory == 1);
		} 
		print Flog "\n" if ($printYN !~ /n/i);
 		printf FoutHistoryItems "%-19s\|%-19s\|%-19s\n", "Current Build", $metricsName, $projCode if ($updateHistory == 1);
		undef $tmpStr;
 		close FoutHistoryItems if ($updateHistory == 1);
}


sub printTableRowB {
	my ($dateNow, $printYN) = @_;
	my  $str = &searchHistoryRec(&UnixDate("$dateNow", "%b %e, %Y"));
	my  $str1 = $str;
	@_ = split (/\|/, $str1);
	my $timeTmp = $_[0]; 
	my $date= $_[0]; my $total= $_[1]; my $open = $_[2]; my $resolved = $_[3]; my $closed = $_[4];
	$open =~ /^\s*(\d+)\s+(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*$/;
	$str1 = sprintf("%-4d %-2d|%-2d|%-2d|%-2d|%-2d", $1, $2, $3, $4, $5, $6);
	$str1 = "$date|$total|$str1|$resolved|$closed|";
	print Flog "$str1\n"  if ($printYN !~ /n/i);
	@_ = split /\|/, $str;

	$excelStr .= "[\"". $_[0] ."\"";
	my $totalN=$_[1];
	my $openN=$_[2];
	my $resolvedN=$_[3];
	my $closedN=$_[4];
	$totalN =~ s/\.//g; $totalN =~ s/^\s*//g; $totalN =~ s/\s*$//g;
	$resolvedN =~ s/\.//g; $resolvedN =~ s/^\s*//g; $resolvedN =~ s/\s*$//g;
	$closedN =~ s/\.//g; $closedN =~ s/^\s*//g; $closedN =~ s/\s*$//g;
	$openN =~s/^\s*(\d+)//g; $openN = $1;
	if ($totalN =~ /^\s*$/) { $totalN=0;}
	if ($openN =~ /^\s*$/) { $openN=0;}
	if ($resolvedN =~ /^\s*$/) { $resolvedN=0;}
	if ($closedN =~ /^\s*$/) { $closedN=0;}
	$excelStr .= ",\"". $totalN."\"";
	$excelStr .= ",\"".$openN."\""; 
	$excelStr .= ",\"".$resolvedN."\""; 
	$excelStr .= ",\"".$closedN."\""; 
	$excelStr .= "],\n" ; 
}



sub getCurrentJiraStatus { 
	my $jiraId = shift; my $dateSearched = shift; my $jiraHistory= shift; my $dateCurrent; my $return = "NoRecord"; 
       	
 		if (&Date_Cmp(&ParseDate($dateSearched), &ParseDate($jiraCreateDate{$jiraId})) >= 0) {
			$return = $jiraStatus{$jiraId};
 		}	
	return $return;
}

sub readCapturedJiras {
	my $finName= shift; $interestedBuilds ; my $CEDue = shift; my $jiraId; my $changDate; my %dummy; my $jiraId; 
	my $strRead ;
	my $ctr=0;
	printf " <- %-80s (readCapturedJiras)\n", $finName; 
	open Fin,     $finName || die "Can;'t open $finName:$!"; 
	while (<Fin>) {
		if (/\-+Start\s+Jira\s+content\-*/i) { $strRead = ""; $jiraId="";}
		elsif (/\-+Stop\s+Jira\s+content\-*/i) { &readCapturedJira ($strRead); } else { $strRead .= $_ if ( $_ !~ /^\s*$/); 
		}
	}
	close Fin;
	return 0;	
}


sub readCapturedJira { # from jira webUI
	my $each = shift;
	 	my $jiraId=""; my $changeDate=""; my %recordTCStatus; my $jiraTCStatus; my $jiraTCStatusFinal; 
		my $changeDate; my $updateDate; my $ceDue; my $jiraType; my $jiraStatus; my $cePriority; my $assignee;
		my $statusChangeDate; my $statusFrom; my $statusTo; # for ChangeHistory parasing 
		my $inChangeHistory=0; my @records = split(/\n/, $each); 
		foreach (@records) {
			if (/^\s*\[($projCode\-\d+)\]\s+(.+)/)	 {$jiraId = $1; $jiraSummary{$jiraId} = $2; $jiraRec{$jiraId} = $each;} 
			if (/^\s*Assignee\s*:\s*Unassigned\s*\-\s*Automatic\s*-\s+/) { $_ = ""; }  # ignore hidden text
			if (/^\s*Type\s*:\s*(\S+)\s*$/) { $jiraIssueType{$jiraId} = $1; } 
			if (/^\s*Status\s*:\s*(\S+)\s*$/) {  $jiraStatus{$jiraId} = $1;} 
			if (/^\s*Assignee\s*:\s*(\S+)\s*$/) { $assignee= $1; $jiraAssignee{$jiraId} = $assignee; } 
 			if (/Created\s*:\s+(\S+)\s*$/) { $jiraCreateDate{$jiraId} = $1; }	
				  # $jiraRec{$jiraId} = $jiraCreateDate{$jiraId}."  0.0.0.0:null->Opened\n"
			if (/Updated\s*:\s+(\S+)/) { $jiraUpdateDate{$jiraId} = $1; }
			if ((/^\s*CE Due\s*:\s+(\S+)\s+/)) {$ceDue = $1; # Handle multiple Builds n.n.n.x for   todo CE
				$jiraCEDue{$jiraId} = $ceDue;
			 	if ($ceDue =~ /$CEDue/i) { $jiraTCStatus = $jiraTCStatus." "."$jiraId!$changeDate 0.0.0.0:none\n"; }
			}
			if (/^\s*Priority\s*:\s*(\S+)\s*$/) { my $tmp = $1; if ($tmp =~ /major/i){ $tmp = "P0";}; $jiraCEPriority{$jiraId} = $tmp; }  # todo priority translation
			if (/made changes\s+\-\s*(.+)\s*$/) { $changeDate = $1; }
		 	if ((/^\s*TC Status\s*:/) && (/\[/)) { s/\s+/ /g; s/^\s*\-\s*//g; s/TC Status://g; 
				s/\]\s*\[/->/ig; s/\s*\[pass\]/:Pass/ig; s/\s*\[fail\]/:Fail/ig; 
				s/\s+/ /ig; s/\s*\[/:/ig; s/\s*\]//ig; 
				if (/\-\>/) { s/:(\S+)\-\>(\S+)\s*$/:$2/;} #### handle from fail->pass situation. Solution. use toStatus
				foreach my $eachBuild (split(/:/, $interestedBuilds)) {
					if ($_ =~ /$eachBuild/) { $jiraTCStatus = $jiraTCStatus." "."$jiraId!$changeDate $_\n";	}	
				}
			} #### output TC Status
			if (/^\s*CE QAPerson\s*:\s*(\S+)\s*$/) { # todo CE 
				$recordCEQAPersonJira{$jiraId} = $1; $jiraCEQAPerson{$jiraId} = $1;
				# if ($jiraId =~ /CE\-12227/i) { print "passD: $jiraId, ". $jiraCEQAPerson{$jiraId}. "\n";}
			}
			if (/^\s*http:\/\/jira\.lab\.c\-ccc\.com:\d+\/browse\/(\w+\-\d+)\?/) {
				$jiraHttp{$1} = $_;
			}
			if (/All    Comments    Work Log    Change History    Subversion Commits/) { $inChangeHistory = 1; }
			if ($inChangeHistory == 1 ) {
				s/Open/Opened/g;
				if (/made changes\s+\-\s*(.+)\s*$/) { $statusChangeDate = $1; }
				if ((/^\s*Status\s+(\w+)\s+\[\s*\d+\s*\]\s+(\w+)\s+\[\s*\d+\s*\]/)) { $statusFrom = $1; $statusTo = $2; 
				if ($jiraRec{$jiraId} =~ /^\s*\|\|/) { $jiraRec{$jiraId} ="";} # webUI takes high precidence over Outlook/QTP-generated Jira report
					$jiraRec{$jiraId} .= "$statusChangeDate 0.0.0.0:$statusFrom->$statusTo";
				}

			}

	 	}
}





EOF_pl

	$str =~ s/\${ip}/$ip/g;
	$str =~ s/__ip__/$ip/g;
	$str =~ s/__localhost__/$ip/g;
	$str =~ s/\${http_port}/$http_port/g;
 	$str =~ s/__PROJ__/$ProjName/g;
 	$str =~ s/__COMN__/$CompanyName/g;
	open Fout, "> $tcName/_index.pl"; print Fout $str; close Fout;
	print " -> $tcName/_index.pl\n";
}

sub generateIndex_pl_pl {
my $str=<<'EOF_pl_pl'

use Date::Manip;
use Getopt::Long;
use strict;

my $c = "c:"; my $startDay; my $endDay; my $step = 1; my $perl; my $jira_txt = "jira.txt"; my $jira_json = "jira.json"; my $metrics = "metrics";
my $CompanyName = "__COMN__";
my $ProjName   = "__PROJ__";
my $tcName = "$CompanyName/$ProjName"; 
if ($^O =~ /win32/i) { $c = "c:"; $perl = "c:/strawberry/perl/bin/perl"; } if ($^O =~ /linux/i) { $c = "/tmp/var/www/cgi-bin"; } 
my $tcDir = "$c/$tcName";
my $bat 	= "$c/$tcName/_1.bat";
my $txt 	= "$c/$tcName/_1.bat.txt";
my $genSS	= "$c/$tcName/_genSS.pl";
my $jira 	= "$c/$tcName/jira.txt";


if ($ARGV[0]) { 
	open Fout, ">$tcDir/_tcLogAppend.txt";
	if ($ARGV[0] == 1) { &tc1(); print "null"; } 
	if ($ARGV[0] == 2) { &tc2(); print "null"; } 
	if ($ARGV[0] == 3) { &tc3(); print "null"; } 
	close Fout;
} else {
print <<EOF;
1. TAF Jira plugin Status and *upload* jira.json 
2. $ProjName Project's Defect Metrics
3. $ProjName Project's Complete Metrics
EOF
;
}

sub tc1()  {
print Fout<<EOF;

Jira Automaiton Setup
 	0. TAF is installed
 	1. Install all the dependent perl packages 
		perl -MCPAN -e "install Win32::OLE"
		perl -MCPAN -e "install Date::Manip"
	2. Install Jira Metrics Automation (unzip and copy the following 2 files) 
		$c/$CompanyName/$ProjName/indexindex.pl
		$c/$CompanyName/$ProjName/_json2txt.pl
		$c/$CompanyName/$ProjName/jira.txt or $c/$CompanyName/$ProjName/jira.json    
		<a href="http://__ip____http_port_IIS__/__COMN__/__PROJ__/indexUpload.pl">Upload jira.json</a>  _url_line_
 	3. Run c:/$CompanyName/$ProjName/indexindex.pl
		 -> index.pl , _index.pl , and _genSS.pl
 	4. TAF Integration $c/_TAF/taf.pl testsuite=c:/$CompanyName/$ProjName;generateTAFTestsuite
	5. Manual execution: $c/$CompanyName/$ProjName/index.pl [blank|1|2] [enter]   (A flash of the diagram indicate the automation is successful)
 	6. The Jira Automation becomes available through webUI (Please use HTA mode for this automation)


EOF
}

sub tc2() {
		`$perl $c/$tcName/_json2txt.pl`;
	if (&findStartEndDay() =~ /^\s*startDay\s*=\s*(\d+)\s+endDay\s*=\s*(\d+)\s*$/) { 
		$startDay = $1; $endDay = $2; 
		open Fout_BAT, "> $bat";
		print Fout_BAT "$perl $c/$tcName/_index.pl generateJIRA\n";
		for (my $i = $startDay; $i >= $endDay; $i = $i - $step ) { print Fout_BAT "$perl $c/$tcName/_index.pl -startDay $i -endDay $i				rem date = ".&i_to_date($i)."\n"; }
		print Fout_BAT "$perl $c/$tcName/_index.pl -startDay $startDay -endDay $endDay				rem start date = ". &i_to_date($startDay)."   end date = ".&i_to_date($endDay)."\n";	
		print Fout_BAT "$perl $c/$tcName/_genSS.pl \n";
		close Fout_BAT;

		print " -> $bat";
		open Fout_TXT, "> $txt";
		print Fout_TXT "$perl $c/$tcName/_json2txt.pl \n";
		print Fout_TXT "$perl $c/$tcName/_index.pl generateJIRA\n";
		for (my $i = $startDay; $i >= $endDay; $i = $i - $step ) { print Fout_TXT "$perl $tcName/_index.pl -startDay $i -endDay $i				rem date = ".&i_to_date($i)."\n"; }
		print Fout_TXT "$perl $c/$tcName/_index.pl -startDay $startDay -endDay $endDay	rem calc metrics  start date = ". &i_to_date($startDay)."   end date = ".&i_to_date($endDay)."\n";
		print Fout_TXT "$perl $c/$tcName/_genSS.pl 					rem generate Excel metrics\n";	
		close Fout_TXT;

		print Fout<<EOF;

$CompanyName: $ProjName Project 

_mime_file__tcResult3_.html_mime_file_   _mime_name_Jira Metrics_mime_name_ 

$c/$CompanyName/$ProjName/$metrics.gif	
$c/$CompanyName/$ProjName/$metrics.xls
EOF
		print `$bat`;
	}

}

sub tc3() {
		`$perl $c/$tcName/_json2txt.pl`;
		`$perl $c/$tcName/_index1.pl`;
print Fout<<EOF_tc3;

$CompanyName: $ProjName Project 

$c/$CompanyName/$ProjName/1_Reporter.txt 
$c/$CompanyName/$ProjName/1_Reporter.xls 
$c/$CompanyName/$ProjName/1_Reporter.gif 

$c/$CompanyName/$ProjName/2_Priority.txt 
$c/$CompanyName/$ProjName/2_Priority.xls 
$c/$CompanyName/$ProjName/2_Priority.gif 

$c/$CompanyName/$ProjName/3_Issuetype.txt 
$c/$CompanyName/$ProjName/3_Issuetype.xls 
$c/$CompanyName/$ProjName/3_Issuetype.gif 

$c/$CompanyName/$ProjName/4_Resolve_Close_Time.txt 
$c/$CompanyName/$ProjName/4_Resolve_Close_Time.xls 
$c/$CompanyName/$ProjName/4_Resolve_Close_Time.gif 

$c/$CompanyName/$ProjName/5_Resolution.txt 
$c/$CompanyName/$ProjName/5_Resolution.xls 
$c/$CompanyName/$ProjName/5_Resolution.gif 

$c/$CompanyName/$ProjName/6_Status.txt 
$c/$CompanyName/$ProjName/6_Status.xls 
$c/$CompanyName/$ProjName/6_Status.gif 

$c/$CompanyName/$ProjName/7_Priority_viki.txt 
$c/$CompanyName/$ProjName/7_Priority_viki.xls 
$c/$CompanyName/$ProjName/7_Priority_viki.gif 

EOF_tc3

}
sub findStartEndDay {
my $startDay = -100000; 
my $endDay = 100000;
my $err;
if (-e $jira) { ; } else { print Fout "Warning: $jira doesn't exist\n"; return; }
open Fin_jira, "$jira";
while ($_ =<Fin_jira>) {
	if ($_ =~ /Created\s*:\s*(.+)\s*$/) {
		my $createdDate = ParseDate($1);
		my $today = ParseDate("today");
		$today = UnixDate("today","%e/%b/%y");
		my $delta = DateCalc($createdDate, $today, \$err, );		
		$delta =~ /^\s*(\d+):(\d+):(\d+):(\d+):(\d+):(\d+):(\d+)/; 	

		my $year  = $1;
		my $month = $2;
		my $week  = $3;
		my $day   = $4;
		my $hour  = $5;
		my $days  = int ($year * 365 + $month * 30 + $week * 7 + $day + $hour/24 );		
		if ($days <= $endDay) { $endDay = $days; }
		if ($days >= $startDay) { $startDay = $days; }
	}
}
$startDay = $startDay ; $endDay = $endDay ; 
#$startDay = $startDay + 5; $endDay = $endDay -5 ; 
return "startDay = $startDay endDay = $endDay";
}

sub i_to_date { my $i = shift; my $today = ParseDate("today"); $today = UnixDate("today","%e/%b/%Y"); return UnixDate(&DateCalc($today, "$i days ago"), "%e/%b/%Y");  }
EOF_pl_pl
;

	$str =~ s/__PROJ__/$ProjName/g;
	$str =~ s/__COMN__/$CompanyName/g;
	$str =~ s/__ip__/$ip/g;
	$str =~ s/__http_port_IIS__/$http_port_IIS/g;
	open Fout, "> $tcName/index.pl"; print Fout $str; close Fout; print " -> $tcName/index.pl\n";
}

sub generateGenSS_pl {
my $str=<<'EOF_pl';
use Win32::OLE;
use Win32::OLE qw(in with);
use Win32::OLE::Variant;
use Win32::OLE::Const 'Microsoft Excel';
use Getopt::Long;
use Date::Manip;

$dateNow = &UnixDate(&ParseDate("now"),"%T %b %e, %Y");
$tcName 	="$c:/$CompanyName/$ProjName";
$ssName 	= "currentBuild";
$projCode 	= "$ProjName";
$xlInput 	= "_xlInput_.txt" ;
$item 		= "Defect";
$item_ 		= "defects";
$item__ 	= "Defects";
$CEDue 		= "3.2.1" ;
$drive 		= 'c:\\';
$XLInputFname = "_HistoricalRecordItems.txt";
$help; $genXLInput ;
GetOptions (
	'help' => \$help,	
	'drive=s' => \$drive,	
	'tcName=s' => \$tcName,	
	'SSName=s' => \$ssName,	
	'xlInput=s' => \$xlInput,	
	'item=s' => \$item,	
	'metricsName=s' => \$item,	
	'CEDue=s' => \$ssName,	
	'CEDueRegExp=s' => \$CEDue,	
	'projCode=s' => \$projCode,	
	'genXLInput' => \$genXLInput,	
	'XLInputFname=s' => \$XLInputFname,	
);

if ($help) {
print <<EOF;
genSS.pl -item TestCase -ssName N_N_N -xlInput _xlInput_TestCase.txt"
genSS.pl -metricsName TestCase -CEDue N_N_N -xlInput _xlInput_TestCase.txt [-genXLInput] [-CEDueRegExp...] [-projCode CE]
genSS.pl -metricsName TestCase -CEDue N_N_N 

EOF
	exit;
}
# $xlInput = $drive.$tcName.'\\'.$xlInput; 
$XLInputFname = "$c:/$CompanyName/$ProjName/$XLInputFname";
if ($item =~ /defect/i) { $XLInputFname = "$c:/$CompanyName/$BLANK/_HistoricalRecord.txt"; }

# open Fin, "_HistoricalTaskRecord.txt"; while (<Fin>) { chop; printf "$_%-19s\|%-19s\|%-19s\n", "3.2.1", "tasks", "CE"; } close Fin; exit;
if ($item =~ /Tasks/i) 		{ $item_ = "tasks";  		$item__ = "Tasks"; }
if ($item =~ /TestPlan/i) 	{ $item_ = "testplan";  	$item__ = "TestPlans"; }
if ($item =~ /Requirement/i) 	{ $item_ = "requirement"; 	$item__ = "Requirements"; }
if ($item =~ /Specification/i) 	{ $item_ = "specification"; 	$item__ = "Specifications"; }
if ($item =~ /TestCase/i) 	{ $item_ = "testcase"; 		$item__ = "TestCases"; }
if ($item =~ /CodeReview/i) 	{ $item_ = "codereview"; 	$item__ = "CodeReviews"; }
if ($item =~ /Task/i) 		{ $item_ = "task"; 		$item__ = "Tasks"; }

my $metricsName = $item;
if ($xlInput) { ; } else { $xlInput = "_xlInput_.txt"; }
my $SSNameGIF 	= "$tcName/metrics.gif"; 	
my $SSName 	= "$tcName/metrics.xls"; 	
$xlInput 	= "$tcName/$xlInput"; 	

#if ($item !~ /TCCoverage|Task/i) { &genXLInput(); } 
#	if ($genXLInput) {exit;}

$Excel = Win32::OLE->GetActiveObject('Excel.Application') || Win32::OLE->new('Excel.Application');
$Excel->{'Visible'} = 1;                    #0 is hidden, 1 is visible
$Excel->{DisplayAlerts}=0;           		#0 is hide alerts

$xlBook = $Excel->Workbooks->Add;

$mydata = [["1", "12", "5.30","5","6","19"], 
           ["2", "13", "5.25","8","9","18"],
           ["3", "15", "23.00","9","3","25"],
           ["4", "18", "16.25","2",],
           ["5", "11", "5.00","7","8","9"],
           ["6", "20", "31.00","13"],
           ["7", "16", "2.25","19"]];

	   print " <- $xlInput\n";
	   open Fin, $xlInput; @_ = <Fin>; close Fin;
		my $str = "@_";
		$str =~ s/"Closed/"Closed - total number of currently Closed $item_/g;
		$str =~ s/"Resolved/"Resolved - total number of currently Resolved $item_/;
		$str =~ s/"Open/"Open - total number of currently Open $item_/;
		$str =~ s/"TotalCtr/"Total number of $item_ - sum of open, resolved and closed/;

	   $mydata = eval $str;
	   my $tmpStr = $str;
	   my $NofRow = (split /\],/, $tmpStr); 
	   my $NofCol = (split /,/, $tmpStr); 
	   $NofCol = (($NofCol + 1) / $NofRow) -1;

	   #my $tmpStr = "A1:E$NofRow";
	   my $tmpStr = "A1:".&convert($NofCol)."$NofRow";

	   if ($NofRow <= 1) { 
		   $mydata = "$tcName Real Time $item Metrics and Trends ($dateNow) has NO data"; 
	   	   $tmpStr = "A1:B1";
	   }
$rng = $xlBook->ActiveSheet->Range("$tmpStr");
$rng->{Value} = $mydata;
$Sheet = $xlBook->ActiveSheet;
my $Range = $xlBook->ActiveSheet->Range($tmpStr);
my $Chart = $Excel->Charts->Add;
$Chart->{ChartType} = xlLine;
if ($NofRow > 1) { 
	$Chart->SetSourceData({Source => $Range, PlotBy => xlColumns});
	$Chart->{HasTitle} = 1;
	$Chart->ChartTitle->{Text} = "$tcName Real Time $item Metrics and Trends ($dateNow)";
	$Chart->Axes(xlCategory)->TickLabels->{Orientation} = -56;
} else {
; # $Chart->ChartTitle->{Text} = "Real Time has no data";
}

my $ChartObj = $Sheet->ChartObjects;
print " -> $SSNameGIF\n -> $SSName\n"; 
$Chart->Export({
               FileName   => $SSNameGIF,
               FilterName => 'GIF',
               Interactive  => 0});

$Excel->ActiveWindow->SelectedSheets->PrintOut({
               Copy => 1,
               ActivePrinter => 'Acrobat PDFWriter'});
$SSName =~ s/\//\\/g;
$xlBook->SaveAs({Filename => $SSName,
              FileFormat => xlWorkbookNormal});  
$xlBook->Close();
$Excel->Quit();  


sub genXLInput { 
	my %record;
	my $str = '[["_","TotalCtr","Open","Resolved","Closed"],'."\n";
	print " <- $XLInputFname (metricsname: $metricsName  projName: $projCode    CEDue: $CEDue\n";
	open Fin, $XLInputFname;
	while (<Fin>) { chop;
		split (/\|/);
		my $dtime = $_[0]; my $total = $_[1]; my $open  = $_[2]; my $resolved = $_[3]; my $closed = $_[4]; my $cedue = $_[5]; my $metricsname = $_[6]; my $projcode = $_[7];
		if ($total !~ /^\s*$/) 		{$total =~ /^\s*(\d+)\s+/; $total= $1;} else { $total = 0;}
		if ($open !~ /^\s*$/) 		{$open =~ /^\s*(\d+)\s+/; $open = $1;} else { $open = 0;}
		if ($resolved !~ /^\s*$/) 	{$resolved =~ /^\s*(\d+)\s+/; $resolved = $1;} else { $resolved = 0;}
		if ($closed !~ /^\s*$/) 	{$closed =~ /^\s*(\d+)\s+/; $closed = $1;} else { $closed = 0;}
		if ($total =~ /^\s*$/) 		{$total = 0;}
		if ($open  =~ /^\s*$/) 		{$open  = 0;}
		if ($resolved =~ /^\s*$/) 	{$resolved = 0;}
		if ($closed =~ /^\s*$/) 	{$closed = 0;}
		$cedue =~ s/\s+$//g; $cedue =~ s/^\s+//g; $metricsname=~ s/\s+$//g; $metricsname=~ s/^\s+//g;
		if (($projcode =~ /$projCode/i) && ( $cedue =~ /$CEDue/) && ($metricsname =~ /$metricsName/i)) {
		$record{$dtime} = "\[\"$dtime\",\"$total\",\"$open\",\"$resolved\",\"$closed\"\]," if ($total != 0);
		} elsif ($metricsName =~ /defect/i) {
		$record{$dtime} = "\[\"$dtime\",\"$total\",\"$open\",\"$resolved\",\"$closed\"\]," if ($total != 0);
		}
	}	
	close Fin;	
	foreach my $each ( sort {&Date_Cmp(&ParseDate($a), &ParseDate($b))} keys %record) {
		$str .= sprintf $record{$each}."\n";
	}
	$str =~ s/,\s*$/\];/g;
	open Fo, ">$xlInput"; print Fo $str; close Fo; print " -> $xlInput\n";
}

sub convert { my $index = shift; $index ; my $a ="ABCDEFGHIJKLMNOPQRSTUVWXYZ"; @_ = split //, $a; return $_[$index]; }
#sub convert { my $index = shift; $index --; my $a ="ABCDEFGHIJKLMNOPQRSTUVWXYZ"; @_ = split //, $a; return $_[$index]; }

EOF_pl

	$str =~ s/\$CompanyName/$CompanyName/gi;
	$str =~ s/\$ProjName/$ProjName/gi;
	$str =~ s/\$c:/$c/gi;
	$str =~ s/__http_port_IIS__/$http_port_IIS/gi;
	open Fout, "> $tcName/_genSS.pl"; print Fout $str; close Fout; print " -> $tcName/_genSS.pl\n";

}

sub gen_json2txt_pl {
my $str=<<'EOF_pl';
#!/usr/bin/perl
use strict;
use warnings;
 
binmode STDOUT, ":utf8";
use utf8;
use Data::Dumper qw(Dumper);
use JSON;
use Date::Manip;
my $c="c:";
my $CompanyName = "__COMN__";
my $projCode	="__PROJ__";
my $tcName 	= "$c/$CompanyName/$projCode";
my $jira_json 	= "jira.json";
my $jira_txt	= "jira.txt";

my $json;
{
  local $/; #Enable 'slurp' mode
  open my $fh, "<", "$tcName/$jira_json";
  $json = <$fh>;
  close $fh;
} my $data = decode_json($json);

# print Dumper $data; exit;
print " <-- $tcName/$jira_json\n";
open Fout_txt, ">$tcName/$jira_txt";
binmode(Fout_txt, ":utf8");
my $interestedFieldKeys = "project|created|updated|status|components|security|issueType|priority|reporter|assignee|Resolution|vote|labels|priority|description|step";
	my %jira_content ;
	my $jira_id;
	my $jira_summary;
	my $jira_projName;
foreach my $eachIssue (@{ $data->{'issues'} })  {  		# print "pa: eachIssue = $eachIssue\n"; 
	foreach my $eachKey (keys %{$eachIssue}) {       	# print " pb: each issueKey = $eachKey              ".  $eachIssue->{$eachKey}."\n"; 
		if ($eachKey =~ /^\s*id\s*$/i) { $jira_id =  $eachIssue->{$eachKey};}
		my @fieldKey =  keys ($eachIssue->{'fields'}) ; 
		%jira_content = ();
	print Fout_txt "-----------------------------Start JIRA content---------------------------\n" if ($eachKey =~ /^\s*id\s*$/);
		foreach my $fieldKeyKey (@fieldKey) {
			if     (ref($eachIssue->{'fields'}->{$fieldKeyKey}) eq "HASH") { print Fout_txt &printHash ($fieldKeyKey, $eachIssue->{'fields'}->{$fieldKeyKey}); }
				elsif  (ref($eachIssue->{'fields'}->{$fieldKeyKey}) eq "ARRAY"){ &printArray($eachIssue->{'fields'}->{$fieldKeyKey}); }
				else                                                           { # print "val: key:value = $fieldKeyKey,  ". $eachIssue->{'fields'}->{$fieldKeyKey}."\n" if ($eachIssue->{'fields'}->{$fieldKeyKey}); 
				$jira_content{$fieldKeyKey} = $eachIssue->{'fields'}->{$fieldKeyKey};
				}
		}
		#printf Fout_txt "[".$jira_content{"project _AND_ name "}."-$jira_id] ".$jira_content{"summary"}."\n" if (($jira_id) && ($eachKey =~ /^\s*id\s*$/)) ;
		printf Fout_txt "[".$projCode."-$jira_id] ".$jira_content{"summary"}."\n" if (($jira_id) && ($eachKey =~ /^\s*id\s*$/)) ;
		foreach my $eachRecord (sort keys %jira_content) { 
			if ( $jira_content{$eachRecord}) {
				$jira_content{$eachRecord} =~ s/\r?\n/_return_/g;
				my $first_field_name =""; my $second_field_name="";
				if ($eachRecord =~ /^\s*(\w+)\s+_AND_\s+(\w+)\s*$/) {
					$first_field_name = $1;
					$second_field_name = $2;
					if ($second_field_name =~ /^\s*name\s*$/) {$second_field_name ="";}
				} elsif ($eachRecord =~ /^\s*(\w+)\s*$/) {
					$first_field_name = $1;
				}

				if (($second_field_name =~ /^\s*$/) && ($first_field_name !~ /^\s*customfield_/)) {
					$first_field_name =~ s/^\s*(\w)/\U$1/g;
					if ($first_field_name =~ /created/i) { 
					my $tmp =  ParseDate($jira_content{$eachRecord})."\n"; 
					$tmp = &UnixDate($tmp, "%e/%b/%y");
					printf Fout_txt "%-40s %s \n", "$first_field_name:", $tmp                       if ($eachKey =~ /^\s*id\s*$/);


					} elsif ($first_field_name =~ /Status/i) { 
						my $tmp =  $jira_content{$eachRecord};
						$tmp =~ s/New|Open|Needs Information|In Progress|Debugging|Reopened]/Open/ig;
						printf Fout_txt "%-40s %s\n", "$first_field_name:", $tmp                       if ($eachKey =~ /^\s*id\s*$/);
					} elsif ($first_field_name =~ /Priority/i) { 
						my $tmp =  $jira_content{$eachRecord};
						printf Fout_txt "%-40s %s\n", "$first_field_name:", "Major" if ($eachKey =~ /^\s*id\s*$/);



					} else {
					printf Fout_txt "%-40s %s\n", "$first_field_name:", $jira_content{$eachRecord} if ($eachKey =~ /^\s*id\s*$/);
					}	

					#	printf Fout_txt "%-40s %s\n", "$first_field_name:", $jira_content{$eachRecord} if ($eachKey =~ /^\s*id\s*$/);
				}
			}
		}
	print Fout_txt "-----------------------------Stop JIRA content---------------------------\n" if ($eachKey =~ /^\s*id\s*$/);
	}; 

} 

close Fout_txt;
print " --> $tcName/$jira_txt\n";
exit;

sub printHash  { my $keykey = shift; my $hash_ref = shift; 
	foreach my $each (keys  %{$hash_ref} )  { 
		if (ref(${$hash_ref}{$each}) eq "HASH") { &printHash($each, ${$hash_ref}{$each} );} else {
		$jira_content{ "$keykey _AND_ $each "}=${$hash_ref}{$each};
		}
	} 
}

sub printArray { my $array_ref = shift; 
	foreach my $each (@$array_ref) { 
		if (ref($each) eq "ARRAY" ) { printArray ($each); }	else { ; }
	} 
}

EOF_pl

	$str =~ s/__COMN__/$CompanyName/gi;
	$str =~ s/__PROJ__/$ProjName/gi;
	$str =~ s/\$c:/$c/gi;
	open Fout, "> $tcName/_json2txt.pl"; print Fout $str; close Fout; print " -> $tcName/_json2txt.pl\n";

}



EOFJira
	$str =~ s/__ip__/$ip/gi;
	$str =~ s/__http_port_IIS__/$http_port_IIS/gi;
	$str =~ s/__http_port__/$http_port/gi;
	$str =~ s/__CompanyName__/$CompanyName/gi;
	$str =~ s/__ProjectName__/$ProjectName/gi;
	

	print FoutIndexIndexJira $str;
	close FoutIndexIndexJira;

}

sub generateIndex_pl_TaaS {
	my $SvrProjNameStr = &getTCName_C($SvrProjName); 
 	if ( -e $SvrProjNameStr) {;} else { mkpath $SvrProjNameStr; }
 	print " -> $SvrProjNameStr/index.pl\n"; 
 	open FoutTaaS, ">$SvrProjNameStr/index.pl" ;
my $str=<<'EOF_TaaS';
#!C:/strawberry/perl/bin/perl.exe
use File::Path;
$c	= "__c__";
$tsName = "__tsName__";
$tsName_C_no = "__no_c_tsName__";
$_TAF	= "___TAF__";
$ip	= "__ip__";
$http_port_IIS = "__http_port_IIS__";
if ($^O =~ /win32/i) { $c= "c:"; } if ($^O =~ /linux/i) { $c = "/tmp/var/www/cgi-bin"; } 


if ($ARGV[0]) { 
	open Fout, ">$tsName/_tcLogAppend.txt";
	if ($ARGV[0] == 1) { print &tc1(); } 
	if ($ARGV[0] == 2) { print &tc2(); } 
	if ($ARGV[0] == 3) { print &tc3(); } 
	if ($ARGV[0] == 4) { print &tc4(); } 
	if ($ARGV[0] == 5) { print &tc5(); } 
	if ($ARGV[0] == 6) { print &tc6(); } 
	if ($ARGV[0] == 7) { print &tc7(); } 
	close Fout;
} else {
print <<EOF;
1. Setup Automation Readme.txt 
2. Setup Automation TaaS (generates TaaS as __tsName__/index.cgi same as TC1)
3. Install TaaS TestBed
4. Execute TaaS Testbed
5. Remove  TaaS Testbed
6. Dependency check: java, perl, ruby, autoIt, selenium, and C#
7. Install default automation Perl, Ruby, AutoIt, Jmeter, etc
EOF
;
}


sub tc1 { 
	&generateIndexCGI(); 
	my $cmd = "$c/$_TAF/taf.pl testsuite=__tsName__;blocking_time=3600;set_blocking"; # my $rst = `$cmd`; 
print Fout<<EOF;
	TaaS driver generation  -> __tsName__/index.cgi
	$cmd
	$rst
	TaaS Service Setup : sc create TaaS1 binPath= "c:\\strawberry\\perl\\bin\\perl.exe c:\\_TAF\\taf.svr" DisplayName= "TaaS1" start= auto

EOF
return "null"; } 

sub tc2 { 
	&generateIndexCGI(); 
print Fout<<EOF;
<a href=\"http://$ip$http_port_IIS/$tsName/index.cgi\">TaaS Automation Management (Require IIS/Apachi CGI Support) _url_line_ </a>
print -> __tsName__/index.cgi
EOF

	return "null"; } 
# sub tc3 { my $cmd = "$c/$_TAF/taf.pl testsuite=__tsName__;testcase=testcase0004;blocking_time=3600;set_blocking"; my $rst = `$cmd`; print Fout $rst;                  
sub tc3 { my $cmd = "$c/$_TAF/taf.pl generateTAFTestsuiteTestbed"	; my $rst = `$cmd`; print Fout $rst; return "null"; } 
sub tc4 { my $cmd = "$c/$_TAF/taf.pl execTAFTestbed"			; my $rst = `$cmd`; print Fout $rst; return "null"; } 
sub tc5 { my $cmd = "$c/$_TAF/taf.pl deleteTAFTestbed"			; my $rst = `$cmd`; print Fout $rst; return "null"; } 
sub tc6 { 
#my $return = "pass";
#if ( -e 'C:/Program Files (x86)/Java/jre7/bin/java.exe'	) {printf Fout "%20s is installed\n", "java";	} else { print Fout "java is not installed\n"; $return = "fail";}
#if ( -e 'C:/apache-jmeter-2.11/bin/jmeter.bat'		) {printf Fout "%20s is installed\n", "jmeter";	} else { print Fout "jmeter is not installed\n"; $return = "fail";}
#if ( -e 'C:/strawberry/perl/bin/perl.exe'		) {printf Fout "%20s is installed\n", "Perl";	} else { print Fout "Perl is not installed\n"; $return = "fail";}
#if ( -e 'C:/Ruby193/bin/ruby.exe'			) {printf Fout "%20s is installed\n", "Ruby";	} else { print Fout "Ruby not installed\n"; $return = "fail";}
#if ( -e 'C:/Program Files (x86)/AutoIt3/AutoIt3.exe'	) {printf Fout "%20s is installed\n", "AutoIt";	} else { print Fout "AutoIt is not installed\n"; $return = "fail";}
#if ( `gem list selenium` =~ /webdriver/i		) {printf Fout "%20s is installed\n", "Selenium-webdriver";} else { print "selenium is not installed\n"; $return = "fail";}

my $return = "pass";
$cmd = "where ruby"		; $rst = `$cmd 2>&1`; $cmd =~ s/where\s*//g; chop $rst; printf Fout "----------------------------------------\n* %-20s\n%-s\n", $cmd,$rst;  if (($rst =~ /Could not find/i) || ($rst =~ /^\s*$/)) { $return = "fail";}
$cmd = "where autoIt3"		; $rst = `$cmd 2>&1`; $cmd =~ s/where\s*//g; chop $rst; printf Fout "----------------------------------------\n* %-20s\n%-s\n", $cmd,$rst;  if (($rst =~ /Could not find/i) || ($rst =~ /^\s*$/)) { $return = "fail";}
$cmd = "where java"		; $rst = `$cmd 2>&1`; $cmd =~ s/where\s*//g; chop $rst; printf Fout "----------------------------------------\n* %-20s\n%-s\n", $cmd,$rst;  if (($rst =~ /Could not find/i) || ($rst =~ /^\s*$/)) { $return = "fail";}
$cmd = "where gcc"		; $rst = `$cmd 2>&1`; $cmd =~ s/where\s*//g; chop $rst; printf Fout "----------------------------------------\n* %-20s\n%-s\n", $cmd,$rst;  if (($rst =~ /Could not find/i) || ($rst =~ /^\s*$/)) { $return = "fail";}
$cmd = "where g++"		; $rst = `$cmd 2>&1`; $cmd =~ s/where\s*//g; chop $rst; printf Fout "----------------------------------------\n* %-20s\n%-s\n", $cmd,$rst;  if (($rst =~ /Could not find/i) || ($rst =~ /^\s*$/)) { $return = "fail";}
$cmd = "where csc"		; $rst = `$cmd 2>&1`; $cmd =~ s/where\s*//g; chop $rst; printf Fout "----------------------------------------\n* %-20s\n%-s\n", $cmd,$rst;  if (($rst =~ /Could not find/i) || ($rst =~ /^\s*$/)) { $return = "fail";}
$cmd = "gem list selenium"	; $rst = `$cmd 2>&1`; $cmd =~ s/where\s*//g; chop $rst; printf Fout "----------------------------------------\n* %-20s\n%-s\n", $cmd,$rst;  if (($rst =~ /Could not find/i) || ($rst =~ /^\s*$/)) { $return = "fail";}
printf Fout "----------------------------------------\n";



return $return;
}

sub tc7 { my $cmd = "$c/$_TAF/_taf_default_ts.bat "			; my $rst = `$cmd`; print Fout $rst; return "null"; } 


sub generateIndexCGI {
	if ( -e "$c/$_TAF/$tsName_C_no") {;} else { mkpath "$c/$_TAF/$tsName_C_no";}

# print  " -> $c/$_TAF/$tsName_C_no/index.cgi\n";
open Fout_cgi, "> $c/$_TAF/$tsName_C_no/index.cgi";
print Fout_cgi<<'EOF_cgi';
use strict;
use CGI qw/:standard/;
my $c 		= "__c__";
my $_TAF 	= "___TAF__";
my $ip   	= "__ip__";
my $http_port   = "__http_port__";
my $http_port_IIS = "__http_port_IIS__";
my $tsName 	= "__tsName__";
my $tsName_C_no = "__no_c_tsName__";
my $web_ui_title = "__web_ui_title__";
my $index_http_htm = "index_http.htm";
my $content	="content";
my $main_css			=<<EOFSummary_dot;
<link rel='stylesheet' href="/main.css" type='text/css' media='all' />
EOFSummary_dot

my $taas_operations_css			=<<EOFSummary_dot;
<script type="text/javascript" src="/js/taas-operations.js"></script>
EOFSummary_dot

my @actions			= ["TaaS Operations", "Create", "Edit (add, del TC)", "Update", "Delete","Upload TS","zip->TS","Download TS","TS->zip"];
my @automationnames 		= ["<optgroup> label=\"Automation Default Names *\">", "c:/perlTS", "c:/RubyTS", "c:/javaTS","c:/cTS", "c:/c_plusplusTS","c:/Csharp","c:/AutoItTS", "c:/SeleniumTS", "c:/Jmeter_test_TS","c:/ApacheBench","c:/TaaS","</optgroup>","c:/TaaSProject","c:/AutoIt_Training","c:/customer_CGI_dbRestore","c:/Jira_Integration","c:/customerTS_manualTS","----------",">>Your Automation Request<< *","----------","Customer Automations *"];
my @automationscripts		= ["Automation Script/Tools", "Functional Automation Perl", "Functional Automation Ruby", "Functional Automation Java","Functional Automation C","Functional Automation C++","Functional Automation C#","Win UI Automation AutoIt", "Web UI Automation Selenium", "Web Perform. Test JMeter", "Web Perform. Apache B.", "TaaS Automation","Project Monitoring TaaS ","Training Program: AutoIt ", "Custom Automation CGI","Custom Integr/Automation Jira", "Manual Test Integration","TaaS/AWS Automation","Android Automation Appium","Google Expresso - Android", "codedUI","webService Test", "TaaS Selenium Auto.","Multi Svr Automation","Multi Svr Automation Puppet Lab","Google Earth Integration","Home Temperature Monitoring",">>Your Automation Request<<"];

my %options_actions		= ( main      => @actions);
my %options_automationnames     = ( main      => @automationnames);
my %options_automationscripts   = ( main      => @automationscripts);


if (-e "$c/$_TAF/__no_c_tsName__/_automationRequest.txt" ) {
open FinAutoReq, "$c/$_TAF/TaaS/_automationRequest.txt";
while ($_ = <FinAutoReq>) { chop; push $automationscripts[0], $_; }
close FinAutoReq;
}


if (-e "$c/$_TAF/_tsName.txt" ) {
open Fin, "$c/$_TAF/_tsName.txt"; 
while ($_ = <Fin>) { chop; $_ =~ s/__c__\/___TAF__/__c__/i; if ($_ !~ /___TAF__\s*$/i) {push $automationnames[0], $_;} }
close Fin;
}
push $automationnames[0], "------TS Zip files------"; 
foreach my $each (glob "__c__/___TAF__/_UploadedTS/*.zip") { push $automationnames[0], $each; }

print header, start_html('TaaS Automation'), " $main_css $taas_operations_css "; # , h2('TaaS <a href=http://__ip____http_port_IIS__/index_http.htm>Automations</a> of different Scripts/Tools');

print<<'EOF_javascript';

	<script language="JavaScript">
window.onload = function () { 
  var menu_op = document.getElementsByName('menu_actions')[0];           //col1
  var menu_as = document.getElementsByName('menu_automationscripts')[0]; //col2
  var menu_an = document.getElementsByName('menu_automationnames')[0];   //col3
  
  //Col3 optgroups
  var optgroup_adn = document.getElementById('col3-Automation-Default-Names');
  var optgroup_ca = document.getElementById('col3-Custom-Automations');
  var optgroup_zf = document.getElementById('col3-ts-zipped-file');
  
  menu_op.addEventListener("change", function(){ 
    var val = this.value.toLowerCase();
    var id = this[this.selectedIndex].id;
    
    // column 1
    switch (id) {
      case "taas-operations":
      case "edit-add-del-tc":
      case "update":
      case "delete":
      case "zipts":
      case "tszip":
      case "download-ts":
        menu_as.setAttribute('disabled', '');
        break;
      case "upload-ts":
      case "tszip":
        menu_as.setAttribute('disabled', '');
        break;
      default:
        menu_as.removeAttribute('disabled');
    }
    
    // column 2
    switch (id) {
      case "taas-operations":
      // case "download-ts":
      case "upload-ts":
        menu_an.setAttribute('disabled', '');    
        break;
      default:
        menu_an.removeAttribute('disabled');
    }
    
    // column 3
    switch (id) {
      case "create":
        optgroup_adn.removeAttribute('disabled');
        optgroup_ca.removeAttribute('disabled');
        optgroup_zf.setAttribute('disabled', '');
        selectDefaultName(menu_as);
        break;
      case "edit-add-del-tc":
      case "update":
      case "tszip":
        optgroup_adn.setAttribute('disabled', '');
        optgroup_zf.setAttribute('disabled', '');
        optgroup_ca.removeAttribute('disabled');
        optgroup_ca.children[0].setAttribute('selected', '');
        break;
      case "download-ts":
        optgroup_adn.setAttribute('disabled', '');
        optgroup_ca.setAttribute('disabled', '');
        optgroup_zf.setAttribute('disabled', '');
        optgroup_zf.removeAttribute('disabled');
        optgroup_zf.children[0].setAttribute('selected', '');
        break;
      case "delete":
        optgroup_adn.setAttribute('disabled', '');
        optgroup_zf.setAttribute('disabled', '');
        optgroup_ca.removeAttribute('disabled');
        optgroup_zf.removeAttribute('disabled');
        optgroup_ca.children[0].setAttribute('selected', '');
        break;
      case "zipts":
        optgroup_adn.setAttribute('disabled', '');
        optgroup_ca.setAttribute('disabled', '');
        optgroup_zf.removeAttribute('disabled');
        if (optgroup_zf.children[0] != null) {
          optgroup_zf.children[0].setAttribute('selected', '');
        } else {
          //alert ('There are no zip files');
        }
        break;
      default:
        optgroup_adn.removeAttribute('disabled');
        optgroup_ca.removeAttribute('disabled');
        optgroup_zf.removeAttribute('disabled');
    }
    
  });
  
  menu_as.addEventListener("change", function(){ 
    var parent_optgroup = this.options[this.selectedIndex].parentNode.id;
    
    switch (parent_optgroup) {
      case "col2-Available-Automation-ScriptTools":
        selectDefaultName(this);
        break;
      case "col2-Automation-Available-upon-Request":
      case "col2_Automation-Request":
        menu_an.setAttribute('disabled', '');
        break;
      default:
    }
  });
  
  function selectDefaultName(el){
    var val = el.value.toLowerCase();
    var the_id = el[el.selectedIndex].id;
    var stripped_id = the_id.replace('col2-', '');
    var new_id = "col3-" + stripped_id;
    var target_el = document.getElementById(new_id);
    if (target_el != null) target_el.setAttribute('selected', '');

  }
}
	</script>

EOF_javascript



my $fhandle = \*STDOUT; &prTopTitle($fhandle); 


if ( !param() ) { 
my $values_ref_actions 	    		= $options_actions{'main'};
my $values_ref_automationscripts  	= $options_automationscripts{'main'};
my $values_ref_automationnames    	= $options_automationnames{'main'};

print start_form();
print " TaaS Operations: ";
#print popup_menu( -name    => 'menu_actions'			, -values  => $values_ref_actions, -default => 'Create'); print " ";
#print popup_menu( -name    => 'menu_automationscripts'		, -values  => $values_ref_automationscripts, -default => 'Functional Automation Perl');
#print " at ";
#print popup_menu( -name    => 'menu_automationnames'		, -values  => $values_ref_automationnames, -default => 'c:/perlTS');
#print " ";


#my $actions			= ["TaaS Operations", "Create", "Edit (add, del TC)", "Update", "Delete","Upload TS","zip->TS","Download TS","TS->zip"];
my $actions			= ["Create", "Edit (add, del TC)", "Update", "Delete","Upload TS","zip->TS","Download TS","TS->zip"];
my $automationnames 		= ["<optgroup label=\"Automation Default Names\">", "c:/perlTS", "c:/RubyTS", "c:/javaTS","c:/cTS", "c:/c_plusplusTS","c:/Csharp","c:/AutoItTS", "c:/SeleniumTS", "c:/Jmeter_test_TS","c:/ApacheBench","c:/TaaS","c:/TaaSProject","c:/AutoIt_Training","c:/customer_CGI_dbRestore","c:/Jira_Integration","c:/customerTS_manualTS","Automation Request","</optgroup>","<optgroup label=\"Customer Automations\">"];
my $automationscripts		= ["<optgroup label=\"Available Automation Script/Tools\">", "Functional Automation Perl", "Functional Automation Ruby", "Functional Automation Java","Functional Automation C","Functional Automation C++","Functional Automation C#","Win UI Automation AutoIt", "Web UI Automation Selenium", "Web Perform. Test JMeter", "Web Perform. Apache B", "TaaS Automation","Project Monitoring TaaS ","Training Program: AutoIt ", "Custom Automation CGI","Custom Integr/Automation Jira", "Manual Test Integration","</optgroup>","<optgroup label=\"Automation-Available-Upon-Request\">","TaaS/AWS Automation","Android Automation Appium","Google Expresso - Android", "codedUI","webService Test", "TaaS Selenium Auto.","Multi Svr Automation","Multi Svr Automation Puppet Lab","Google Earth Integration","Home Temperature Monitoring","<optgroup label=\"Automation Request\">","Your Automation Request"];


#if (-e "__c__/___TAF__/TaaS/_automationRequest.txt" ) {			# Get customer request info
#open FinAutoReq, "__c__/___TAF__/__TaaS__/_automationRequest.txt";
#while ($_ = <FinAutoReq>) { chop; push @{$automationscripts}, $_; }
#close FinAutoReq;
#}


#if (-e "__c__/___TAF__/_tsName.txt" ) {					# Get TS name info
#open Fin, "$c/$_TAF/_tsName.txt"; 
#while ($_ = <Fin>) { chop; $_ =~ s/__c__\/___TAF__/__c__/i; if (($_ !~ /___TAF__\s*$/i) && ($_ !~ /^\s*__c__\s*$/)) {push @{$automationnames}, $_;} }
#close Fin;
#}
##push @{$automationnames}, "------TS Zip files------"; 			# get _UploadedTS/*.zip
#push @{$automationnames}, "<optgroup label=\"TS Zip Files\">"; 			# get _UploadedTS/*.zip
#foreach my $each (glob "__c__/___TAF__/_UploadedTS/*.zip") { push @{$automationnames}, $each; }
#push @{$automationnames}, "</optgroup>"; 			# get _UploadedTS/*.zip


print<<EOF;
<select name="menu_actions" id="menu_actions">
EOF

foreach my $each (@{$actions}) { 
	my $each_ = $each;
	if ($each_ !~ /optgroup/i) {
	$each_ =~ s/\s/\-/gi;
	$each_ =~ s/C\+\+/Cplusplus/gi;
	$each_ =~ s/C#/Csharp/gi;
	$each_ =~ s/->//gi;
	$each_ =~ s/<-//gi;
	$each_ =~ s/[<|>|,|(|)|\/|\\\\]//ig;
	$each_ =~ s/\-+/-/ig;
	$each_ = lc $each_;
print "<option value=\"$each\" id=\"$each_\" enabled>$each</option>\n"; 
	} else {
print $each_;	
	}
}

#<option selected=\"selected\" value=\"Create\">Create</option>
print<<EOF;
</select> <select name="menu_automationscripts" id="menu_automationscripts">
EOF


################ col 2 ########################
my $automationscripts		= ["<optgroup label=\"Available Automation Script/Tools\" id=\"col2-Available-Automation-ScriptTools\">", "Functional Automation Perl", "Functional Automation Ruby", "Functional Automation Java","Functional Automation C","Functional Automation C++","Functional Automation C#","Win UI Automation AutoIt", "Web UI Automation Selenium", "Web Perform. Test JMeter", "Web Perform. Apache B.","TaaS Automation","Project Monitoring TaaS ","Training Program: AutoIt ", "Custom Automation CGI","Custom Integr/Automation Jira", "Manual Test Integration","Automation Request","</optgroup>","<optgroup label=\"Automation Available Upon Request\" id=\"col2--Automation-Available-Upon-Request\">","TaaS/AWS Automation","Android Automation Appium","Google Expresso - Android", "codedUI","webService Test", "TaaS Selenium Auto.","Multi Svr Automation","Multi Svr Automation Puppet Lab","Google Earth Integration","Home Temperature Monitoring","</optgroup>","<optgroup label=\"Automation Request\" id=\"col2_Automation-Request\">","Your Automation Request","</optgroup>"];
my $automationnames 		= ["<optgroup label=\"Automation Default Names\" id=\"col3-Automation-Default-Names\">", "c:/perlTS", "c:/RubyTS", "c:/javaTS","c:/cTS", "c:/c_plusplusTS","c:/Csharp","c:/AutoItTS", "c:/SeleniumTS", "c:/Jmeter_test_TS","c:/ApacheBench","c:/TaaS","c:/TaaSProject","c:/AutoIt_Training","c:/customer_CGI_dbRestore","c:/Jira_Integration","c:/customerTS_manualTS","Automation Request","</optgroup>","<optgroup label=\"Customer Automations\" id=\"col3-Customer-Automations\">"];

while ($a = shift @{$automationscripts}) { 	# for 2nd column
	my $key_col2 = $a;
	my $each  = $a;
	if ($key_col2 !~ /optgroup/i) {
	$key_col2 =~ s/\s/\-/gi;
	$key_col2 =~ s/C\+\+/Cplusplus/gi;
	$key_col2 =~ s/C#/Csharp/gi;
	$key_col2 =~ s/->//gi;
	$key_col2 =~ s/<-//gi;
	$key_col2 =~ s/[<|>|,|(|)|\/|\\\\]//ig;
	$key_col2 =~ s/\-+/-/ig;
	$key_col2 = lc $key_col2;
 	print "<option value=\"$each\" id=\"col2-$key_col2\" enabled>$each</option>\n"; 
	} else {
 	print $key_col2."\n";	# optgroup 
	}
} 


#foreach my $each (@{$actions}) { 
#	my $each_ = $each;
#	if ($each_ !~ /optgroup/i) {
#	$each_ =~ s/\s/\-/gi;
#	$each_ =~ s/C\+\+/Cplusplus/gi;
#	$each_ =~ s/C#/Csharp/gi;
#	$each_ =~ s/->//gi;
#	$each_ =~ s/<-//gi;
#	$each_ =~ s/[<|>|,|(|)|\/|\\\\]//ig;
#	$each_ =~ s/\-+/-/ig;
#	$each_ = lc $each_;
#print "<option value=\"$each\" id=\"$each_\" enabled>$each</option>\n"; 
#	} else {
#print $each_;	
#	}
#}

################ col 3 ########################

#<option selected=\"selected\" value=\"Functional Automation Perl\">Functional Automation Perl</option>
print<<EOF;
</select> <select name="menu_automationnames" id="menu_automationnames">
EOF



my $automationscripts		= ["<optgroup label=\"Available Automation Script/Tools\" id=\"col2-Available-Automation-ScriptTools\">", "Functional Automation Perl", "Functional Automation Ruby", "Functional Automation Java","Functional Automation C","Functional Automation C++","Functional Automation C#","Win UI Automation AutoIt", "Web UI Automation Selenium", "Web Perform. Test JMeter", "Web Perform. Apache B.", "TaaS Automation","Project Monitoring TaaS ","Training Program: AutoIt ", "Custom Automation CGI","Custom Integr/Automation Jira", "Manual Test Integration","Automation Request","</optgroup>","<optgroup label=\"Automation Available Upon Request\" id=\"col2-Automation-Available-Upon-Request\">","TaaS/AWS Automation","Android Automation Appium","Google Expresso - Android", "codedUI","webService Test", "TaaS Selenium Auto.","Multi Svr Automation","Multi Svr Automation Puppet Lab","Google Earth Integration","Home Temperature Monitoring","</optgroup>","<optgroup label=\"Automation Request\" id=\"col2_Automation-Request\">","Your Automation Request"];
my $automationnames 		= ["<optgroup label=\"Automation Default Names\" id=\"col3-Automation-Default-Names\">", "c:/perlTS", "c:/RubyTS", "c:/javaTS","c:/cTS", "c:/c_plusplusTS","c:/Csharp","c:/AutoItTS", "c:/SeleniumTS", "c:/Jmeter_test_TS","c:/ApacheBench","c:/TaaS","c:/TaaSProject","c:/AutoIt_Training","c:/customer_CGI_dbRestore","c:/Jira_Integration","c:/customerTS_manualTS","Automation Request","</optgroup>"];

while ($a = shift @{$automationnames}) { 	# for 3rd column
	$b = shift @{$automationscripts};
	my $key_col3 = $b;
	my $each  = $a; 
	if ($key_col3 !~ /optgroup/i) {
	$key_col3 =~ s/\s/\-/gi;
	$key_col3 =~ s/C\+\+/Cplusplus/gi;
	$key_col3 =~ s/C#/Csharp/gi;
	$key_col3 =~ s/->//gi;
	$key_col3 =~ s/<-//gi;
	$key_col3 =~ s/[<|>|,|(|)|\/|\\\\]//ig;
	$key_col3 =~ s/\-+/-/ig;
	$key_col3 = lc $key_col3;
   	print "<option value=\"$each\" id=\"col3-$key_col3\" enabled>$each</option>\n"; 
	} else {
   	print $each."\n";	# optgroup 
	}
} 


push @{$automationnames}, "<optgroup label=\"Custom Automations\" id=\"col3-Custom-Automations\">";
if (-e "c:/_TAF/_tsName.txt" ) {					# Get TS name info
open Fin, "c:/_TAF/_tsName.txt"; 
while ($_ = <Fin>) { chop; $_ =~ s/c:\/_TAF/c:/i; if (($_ !~ /_TAF\s*$/i) && ($_ !~ /^\s*c:\s*$/) && ($_ !~ /^\s*$/)) {push @{$automationnames}, $_;} }
close Fin;
}
push @{$automationnames}, "</optgroup>";


push @{$automationnames}, "<optgroup label=\"TS Zip Files\" id=\"col3-ts-zipped-file\">"; 			# get _UploadedTS/*.zip
foreach my $each (glob "c:/_TAF/_UploadedTS/*.zip") { push @{$automationnames}, $each; }
push @{$automationnames}, "</optgroup>"; 			# get _UploadedTS/*.zip

while ($a = shift @{$automationnames}) { 	# for 3rd column
	my $key_col3 = $a; 
	my $each  = $a; 
	if ($key_col3 !~ /optgroup/i) {
	$key_col3 =~ s/\s/\-/gi;
	$key_col3 =~ s/C\+\+/Cplusplus/gi;
	$key_col3 =~ s/C#/Csharp/gi;
	$key_col3 =~ s/->//gi;
	$key_col3 =~ s/<-//gi;
	$key_col3 =~ s/[<|>|,|(|)|\/|\\\\]//ig;
	$key_col3 =~ s/\-+/-/ig;
	$key_col3 = lc $key_col3;
   	print "<option value=\"$each\" id=\"col3-$key_col3\" enabled>$each</option>\n"; 
	} else {
   	print $each."\n";	# optgroup 
	}

}




#foreach my $each (@{$automationnames}) { 
#
#	my $each_ = $each;
#	if ($each_ !~ /optgroup/i) {
#	$each_ =~ s/\s/\-/gi;
#	$each_ =~ s/C\+\+/Cplusplus/gi;
#	$each_ =~ s/C#/Csharp/gi;
#	$each_ =~ s/->//gi;
#	$each_ =~ s/<-//gi;
#	$each_ =~ s/[<|>|,|(|)|\/|\\\\]//ig;
#	$each_ =~ s/\-+/-/ig;
#	$each_ = lc $each_;
#print "<option value=\"$each\" id=\"$each_\" enabled>$each</option>\n"; 
#	} else {
#print $each_."\n";	
#	}
#}

# <option selected=\"selected\" value=\"c:/perlTS\">c:/perlTS</option>
print<<EOF;
</select> <input type="submit" name="submit" value="Submit" /></form>
EOF

#print submit( -name => 'submit' , -value => "Submit");
#print end_form();


} else { 

my $values_ref_menu_actions    		= param('menu_actions');
my $values_ref_menu_automationnames	= param('menu_automationnames');
my $values_ref_text_automationnames	= param('text_automationnames');
my $values_ref_text_taf            	= param('text_taf');
my $values_ref_menu_automationscripts	= param('menu_automationscripts');
my $values_ref_submit                   = param('submit');
my $values_ref_cmd                      = param('cmd');

if ($values_ref_menu_automationnames =~ /^\s*$c/) {;} else { $values_ref_menu_automationnames = "$c/$values_ref_menu_automationnames";}
if ($values_ref_text_taf             =~ /^\s*$c/) {;} else { $values_ref_text_taf             = "$c/$values_ref_text_taf"	     ;}

my $values_ref_menu_automationnames_C_no = $values_ref_menu_automationnames ;
   $values_ref_menu_automationnames_C_no =~ s/^\s*$c\///g;

#### edit scripts
if ($values_ref_menu_actions =~ /edit/i) {
print<<EOF_edit;
<a href=\"http://$ip$http_port_IIS/$values_ref_menu_automationnames_C_no/index.txt.cgi\">Edit Automation Description ($values_ref_menu_automationnames/index.txt)</a><br><a href=\"http://$ip$http_port_IIS/$values_ref_menu_automationnames_C_no/index.pl.cgi\">Edit Automation Driver ($values_ref_menu_automationnames/index.pl)</a>  
EOF_edit
}

#### upload scripts

if ($values_ref_menu_actions =~ /upload/i) {

print<<EOF_upload;
<html>
<title>$web_ui_title</title>
<head>
<title>Upload Form</title>
<body>
<form method="post" action="indexUpload.pl" enctype="multipart/form-data">
<left>
 Select Testsuite zip file to upload: <input type="file" name="upfile">  
<input type="submit" name="button" value="Upload File">
</center>
</form>
EOF_upload


#print<<EOF_upload;
#<a href=\"http://$ip$http_port_IIS/indexUpload.pl\">Upload Automation Zip</a><br>
#EOF_upload


}

#### download scripts
my $downloadNameZip = $values_ref_menu_automationnames."";
#my $downloadNameZip = $values_ref_menu_automationnames.".zip";

#$downloadNameZip =~ s/^\s*__c__\///i; 
#$downloadNameZip =~ s/^\s*__c__\\\\//i; 

my $downloadNameZipCGI = $downloadNameZip;

# my $downloadNameZip = "__c__/___TAF__/_ZippedTS/$downloadNameZip";
if ($values_ref_menu_actions =~ /download/i) {

print<<EOF_upload;
<a href=\"http://$ip$http_port_IIS/indexDownload.pl?a=$downloadNameZipCGI\">Download $downloadNameZip </a><br>
EOF_upload

}



#### run scripts 
if ($values_ref_submit =~ /run/i) {
my $tcName	= $values_ref_text_taf;   $tcName =~ s/^\s*$c\///i;
$tcName =~ /testsuite=$c\/(.+?);/;  $tcName = $1;
my $cmd = "start $values_ref_text_taf"; system $cmd;
if ($cmd =~ /generateTAFTestsuite/i) { until (-e "$c/$_TAF/$tcName/index_http.htm") {;} }
#todo   $cmd = "start $c/$_TAF/__taf_pl__ generateRootIndex"; system $cmd;
   $cmd = "start $c/$_TAF/__taf_pl__ refreshHost"; system $cmd;

#print start_html();
#print "Navigate to <a href=\"http://$ip$http_port/$tcName/index_http.htm\">$c/$_TAF/$tcName</a><br>\n";
#print "Navigate to <a href=\"http://$ip$http_port_IIS/_ZippedTS/\">$c/$_TAF/_ZippedTS/$tcName</a><br>\n";
#print "Navigate to <a href=\"http://$ip$http_port_IIS/TaaS/index.cgi\">TaaS</a> <br>\n";
print<<EOF_redirect;
<html>
<head>
<title>__web_ui_title__</title>
<meta http-equiv="Content-Type" $content="text/html; charset=iso-8859-1" />
</head>
<body>
<pre>
<div id=\"running-msg\">
<h3> Running at __ip__ </h3>
<div id=\"running-cmd\"> Running at __ip__ ...... </div>
<div id=\"running-waiting\">Please Wait ......</div>
</div>
</pre>
<meta http-equiv="refresh" $content="1; url=http://__ip____http_port_IIS__/index_http.htm">
</body>
</html>
EOF_redirect

#print end_html();
}

#### Run cmd arguments 
if ($values_ref_cmd) {
	$values_ref_cmd =~ s/_semi_/;/g;
my $cmd = "start $values_ref_cmd"; system $cmd;
   $cmd = "start $c/$_TAF/__taf_pl__ refreshHost"; system $cmd;

print<<EOF_redirect;
<html>
<head>
<title>__web_ui_title__</title>
<meta http-equiv="Content-Type" $content="text/html; charset=iso-8859-1" />
</head>
<body>
<pre>
<div id=\"running-msg\">
<h3> Running at __ip__ </h3>
<div id=\"running-cmd\"> Running $values_ref_cmd </div>
<div id=\"running-waiting\">Please Wait ...... (Refresh browser after 10 seconds) </div>
</div>
</pre>
<meta http-equiv="refresh" $content="5; url=http://__ip____http_port_IIS__/index_http.htm">
</body>
</html>
EOF_redirect

#print end_html();
}

#### Run cmd arguments 


#### Automation Logics 	* Dropdown Testsuite name overwrite the manual Testsuite name
my $testsuiteName;
if ($values_ref_menu_automationnames) {
	$testsuiteName = $values_ref_menu_automationnames; 
} else {
	$testsuiteName = $values_ref_text_automationnames; 
}

#### Automation Logics 	* Map TS type to TAF command 
my $testsuiteType;
if ($values_ref_menu_automationscripts =~ /Functional Automation perl/i) {
	$testsuiteType = "generateTAFTestsuitePerl";
} elsif ($values_ref_menu_automationscripts =~ /Functional Automation ruby/i) {
	$testsuiteType = "generateTAFTestsuiteRuby";
#} elsif (($values_ref_menu_automationscripts =~ /autoit/i) && ($values_ref_menu_automationscripts =~ /training/i)){
} elsif (($values_ref_menu_automationscripts =~ /training/i)){
	$testsuiteType = "generateTAFTestsuiteAutoItTraining";
} elsif ($values_ref_menu_automationscripts =~ /autoit/i) {
	$testsuiteType = "generateTAFTestsuiteAutoIt";
} elsif ($values_ref_menu_automationscripts =~ /selenium/i) {
	$testsuiteType = "generateTAFTestsuiteSelenium";
} elsif ($values_ref_menu_automationscripts =~ /jmeter/i) {
	$testsuiteType = "index_pl_arguments=__url__jmeter.apache.org__url__;generateTAFTestsuiteJmeter";
} elsif ($values_ref_menu_automationscripts =~ /Apache B/i) {
	$testsuiteType = "generateTAFTestsuiteAB";
} elsif ($values_ref_menu_automationscripts =~ /jira/i) {
	$testsuiteType = "index_pl_arguments=CompanyNameIs_TAFLLC_ProjectNameIs_TAFN;generateTAFTestsuiteJira";
} elsif ($values_ref_menu_automationscripts =~ /testbed/i) {
	$testsuiteType = "generateTAFTestsuiteTestbed";
} elsif ($values_ref_menu_automationscripts =~ /Project Monitoring TaaS/i) {
	$testsuiteType = "generateTAFTestsuiteTaaSProject";
} elsif ($values_ref_menu_automationscripts =~ /taas/i) {
	$testsuiteType = "generateTAFTestsuiteTaaS";
} elsif ($values_ref_menu_automationscripts =~ /paas/i) {
	$testsuiteType = "generateTAFTestsuiteTaaS";
} elsif ($values_ref_menu_automationscripts =~ /Functional Automation java/i) {
	$testsuiteType = "generateTAFTestsuiteJava";
} elsif ($values_ref_menu_automationscripts =~ /Functional Automation C\+\+/i) {
	$testsuiteType = "generateTAFTestsuiteC_plusplus";
} elsif ($values_ref_menu_automationscripts =~ /Functional Automation C#/i) {
	$testsuiteType = "generateTAFTestsuiteCsharp";
} elsif ($values_ref_menu_automationscripts =~ /Functional Automation C\b/i) {
	$testsuiteType = "generateTAFTestsuiteC";
} elsif ($values_ref_menu_automationscripts =~ /Custom Automation CGI/i) {
	$testsuiteType = "generateTAFTestsuite_customTS_restoreDB";
} elsif ($values_ref_menu_automationscripts =~ /Manual Test Integration/i) {
	$testsuiteType = "NofTCinTSTemplate=8;generateTAFTestsuite_customTS_manualTS";
} elsif ($values_ref_menu_automationscripts =~ /Your Automation Request/i) {
	$testsuiteType = "automationRequest=seleniumWD";
}

#### Compose TAF command 
my $cmd ;
if ($values_ref_menu_actions =~ /Create/i) { 
$cmd = "$c/$_TAF/taf.pl testsuite=$testsuiteName;$testsuiteType;refreshHost"; 
} elsif ($values_ref_menu_actions =~ /Update/i) { 	
$cmd = "$c/$_TAF/taf.pl testsuite=$testsuiteName;generateTSFromDesc;generateTAFTestsuite"; 
} elsif ($values_ref_menu_actions =~ /Delete/i) { 
$cmd = "$c/$_TAF/taf.pl testsuite=$testsuiteName;deleteTAFTestsuite"; 
} elsif ($values_ref_menu_actions =~ /zip->TS/i) { 
$cmd = "$c/$_TAF/taf.pl testsuite=$testsuiteName;generateTAFTestsuiteFromZip"; 
} elsif ($values_ref_menu_actions =~ /TS->zip/i) { 
$cmd = "$c/$_TAF/taf.pl testsuite=$testsuiteName;ts2zip"; 
}

#### submit the Run command 
if (($values_ref_submit =~ /submit/i) && ($values_ref_menu_actions !~ /edit|upload|download/i)){
print start_form();
print textfield ( -name    => 'text_taf'		, -value => $cmd, -size => 120, -maxlength => 428);
print " " . submit( -name => 'submit' , -value => "Run");
my $cmd_cgi = $cmd; $cmd_cgi =~ s/;/_semi_/g; 
$cmd_cgi =~ s/^/http:\/\/$ip$http_port_IIS\/$tsName_C_no\/index.cgi?cmd=/g;
print "<br><br>";
print textfield ( -name    => 'text_taf_cgi'		, -value => $cmd_cgi, -size => 120, -maxlength => 428);
print end_form();
}
} 

print end_html;

sub prTopTitle {
	my $fout = $_[0];
	if ( -e "$c/$_TAF/$index_http_htm") { ;} else { return; }
	open Fin_prTopTitle, "$c/$_TAF/$index_http_htm";
	my $inSearch = "n";
	while ($_ = <Fin_prTopTitle>) {
		if ($_ =~ /\"main-nav\"/)  { $inSearch = "y"; }
		if ($inSearch =~ /y/i) { print {$fout} $_;}
		if ($_ =~ /\"container\"/) { $inSearch = "n"; }
	}
	close Fin_prTopTitle;
}

EOF_cgi
;
close Fout_cgi;

}

EOF_TaaS
;

my $SvrProjName_C_no = &getTCName_C_no ($SvrProjName);	
$str =~ s/__c__/$c/ig;
$str =~ s/__ip__/$ip/ig;
$str =~ s/__no_c_tsName__/$SvrProjName_C_no/gi;
$str =~ s/__tsName__/$SvrProjName/gi;
$str =~ s/___TAF__/$_TAF/gi;
$str =~ s/__http_port_IIS__/$http_port_IIS/ig;
$str =~ s/__http_port__/$http_port/ig;
$str =~ s/__taf_pl__/$taf/ig;
$str =~ s/__web_ui_title__/$web_ui_title/ig;
	print FoutTaaS $str;
 	close FoutTaaS;
	return 1;
}

sub generateJsonJira {
	my $SvrProjNameStr = &getTCName_C($SvrProjName); 
	if ( -e $SvrProjNameStr) {;} else { mkpath $SvrProjNameStr; }
	print " -> $SvrProjNameStr/jira.json\n"; 
	open FoutJsonJira, ">$SvrProjNameStr/jira.json" ;
print FoutJsonJira<<'EOF';
{"expand":"schema,names","startAt":0,"maxResults":50,"total":184,"issues":[{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"23664","self":"http://10.1.3.4:8080/rest/api/latest/issue/23664","key":"TP-9","fields":{"progress":{"progress":0,"total":0},"summary":"Error message received when click OK","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=viki","name":"viki","emailAddress":"viki@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"ViKi","active":false},"updated":"2011-11-11T11:06:39.000+0800","created":"2011-11-10T16:22:36.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/6","description":"The issue is considered finished, the resolution is correct. Issues which are closed can be reopened.","iconUrl":"http://10.1.3.4:8080/images/icons/status_closed.gif","name":"Closed","id":"6"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"User should be able to login the sytem.","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-9/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":{"self":"http://10.1.3.4:8080/rest/api/2/resolution/5","id":"5","description":"All attempts at reproducing this issue failed, or not enough information was available to reproduce the issue. Reading the code produces no clues as to why this behavior would occur. If more information appears later, please reopen the issue.","name":"Cannot Reproduce"},"resolutiondate":"2011-11-10T16:27:24.000+0800","customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2685","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-9/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=viki","name":"viki","emailAddress":"viki@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"ViKi","active":false},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1. Type correct user name (\"allen\").\n2. Type correct password (\"aaaa\").\n3. Click OK button.","customfield_10345":null,"customfield_11030":"2911","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"Cannot login the system. Got error message as below:\n\"Invalid login, please correct user name and password.\"","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"23665","self":"http://10.1.3.4:8080/rest/api/latest/issue/23665","key":"TP-10","fields":{"progress":{"progress":0,"total":0},"summary":"Chair will not hold specified weight of 300 pounds","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=toi","name":"toi","emailAddress":"toi@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Toi","active":false},"updated":"2011-11-11T11:06:23.000+0800","created":"2011-11-10T16:26:55.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/6","description":"The issue is considered finished, the resolution is correct. Issues which are closed can be reopened.","iconUrl":"http://10.1.3.4:8080/images/icons/status_closed.gif","name":"Closed","id":"6"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"Chair will maintain structure.","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-10/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":{"self":"http://10.1.3.4:8080/rest/api/2/resolution/1","id":"1","description":"A fix for this issue is checked into the tree and tested.","name":"Fixed"},"resolutiondate":"2011-11-10T17:35:38.000+0800","customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2684","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-10/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=toi","name":"toi","emailAddress":"toi@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Toi","active":false},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1. Apply 299 pound weight to chair seat.\n2. Add 1 pound weight to chair seat (total 300 pounds).\n","customfield_10345":null,"customfield_11030":"2910","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"Chair collapses.","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"23666","self":"http://10.1.3.4:8080/rest/api/latest/issue/23666","key":"TP-11","fields":{"progress":{"progress":0,"total":0},"summary":"Error message received when click ok","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=viki","name":"viki","emailAddress":"viki@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"ViKi","active":false},"updated":"2011-11-11T11:05:53.000+0800","created":"2011-11-10T16:36:26.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/6","description":"The issue is considered finished, the resolution is correct. Issues which are closed can be reopened.","iconUrl":"http://10.1.3.4:8080/images/icons/status_closed.gif","name":"Closed","id":"6"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"user will be logged into system","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-11/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":{"self":"http://10.1.3.4:8080/rest/api/2/resolution/7","id":"7","description":"","name":"Postpone"},"resolutiondate":"2011-11-10T17:34:42.000+0800","customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2683","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-11/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=viki","name":"viki","emailAddress":"viki@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"ViKi","active":false},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1. type in user name\n2. type in password\n3. click ok","customfield_10345":null,"customfield_11030":"2909","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"Error message says invalid login, user name and password entered correctly","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"23668","self":"http://10.1.3.4:8080/rest/api/latest/issue/23668","key":"TP-12","fields":{"progress":{"progress":0,"total":0},"summary":"Chair height is incorrect","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=viki","name":"viki","emailAddress":"viki@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"ViKi","active":false},"updated":"2011-11-11T11:04:13.000+0800","created":"2011-11-10T16:40:25.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/6","description":"The issue is considered finished, the resolution is correct. Issues which are closed can be reopened.","iconUrl":"http://10.1.3.4:8080/images/icons/status_closed.gif","name":"Closed","id":"6"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"Chair will measure 48 inches high","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-12/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":{"self":"http://10.1.3.4:8080/rest/api/2/resolution/10","id":"10","description":"This bug is by design","name":"By design"},"resolutiondate":"2011-11-10T17:30:57.000+0800","customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2682","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-12/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=viki","name":"viki","emailAddress":"viki@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"ViKi","active":false},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1. measured chair from bottom of back leg to top of chair back ","customfield_10345":null,"customfield_11030":"2908","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"Chair measures 50 inches instead of 48 inches","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"23669","self":"http://10.1.3.4:8080/rest/api/latest/issue/23669","key":"TP-13","fields":{"progress":{"progress":0,"total":0},"summary":"Chair color does not match specs","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=viki","name":"viki","emailAddress":"viki@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"ViKi","active":false},"updated":"2011-11-11T11:03:41.000+0800","created":"2011-11-10T16:46:11.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/6","description":"The issue is considered finished, the resolution is correct. Issues which are closed can be reopened.","iconUrl":"http://10.1.3.4:8080/images/icons/status_closed.gif","name":"Closed","id":"6"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"chair will match lightest or darkest sample","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-13/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":{"self":"http://10.1.3.4:8080/rest/api/2/resolution/10","id":"10","description":"This bug is by design","name":"By design"},"resolutiondate":"2011-11-10T17:30:13.000+0800","customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2681","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-13/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=viki","name":"viki","emailAddress":"viki@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"ViKi","active":false},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1. match chair color with chair sample","customfield_10345":null,"customfield_11030":"2907","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"chair color is darker than darkest color spec","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"23670","self":"http://10.1.3.4:8080/rest/api/latest/issue/23670","key":"TP-14","fields":{"progress":{"progress":0,"total":0},"summary":"Error message received when logging into email","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=viki","name":"viki","emailAddress":"viki@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"ViKi","active":false},"updated":"2011-11-11T11:02:42.000+0800","created":"2011-11-10T16:49:17.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/6","description":"The issue is considered finished, the resolution is correct. Issues which are closed can be reopened.","iconUrl":"http://10.1.3.4:8080/images/icons/status_closed.gif","name":"Closed","id":"6"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"login in to email","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-14/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":{"self":"http://10.1.3.4:8080/rest/api/2/resolution/1","id":"1","description":"A fix for this issue is checked into the tree and tested.","name":"Fixed"},"resolutiondate":"2011-11-10T17:29:40.000+0800","customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2680","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-14/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=viki","name":"viki","emailAddress":"viki@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"ViKi","active":false},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1. enter user login\n2. enter user password\n3. click ok\n","customfield_10345":null,"customfield_11030":"2906","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"Receive error message unable to process request, system will not close","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"23671","self":"http://10.1.3.4:8080/rest/api/latest/issue/23671","key":"TP-15","fields":{"progress":{"progress":0,"total":0},"summary":"Chair legs are not tightly fastened","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=viki","name":"viki","emailAddress":"viki@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"ViKi","active":false},"updated":"2011-11-11T11:01:52.000+0800","created":"2011-11-10T16:51:57.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/6","description":"The issue is considered finished, the resolution is correct. Issues which are closed can be reopened.","iconUrl":"http://10.1.3.4:8080/images/icons/status_closed.gif","name":"Closed","id":"6"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"chair leg will not wiggle","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-15/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":{"self":"http://10.1.3.4:8080/rest/api/2/resolution/1","id":"1","description":"A fix for this issue is checked into the tree and tested.","name":"Fixed"},"resolutiondate":"2011-11-10T17:21:50.000+0800","customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":"back legs only","customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2679","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-15/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=viki","name":"viki","emailAddress":"viki@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"ViKi","active":false},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1. lift chair from floor\n2. turn chair and place top of chair back on floor\n3. hold seat with one hand and wiggle leg with other hand","customfield_10345":null,"customfield_11030":"2905","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"chair leg wiggles, is not fastened tightly","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"23672","self":"http://10.1.3.4:8080/rest/api/latest/issue/23672","key":"TP-16","fields":{"progress":{"progress":0,"total":0},"summary":"Unable to access web page","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=viki","name":"viki","emailAddress":"viki@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"ViKi","active":false},"updated":"2011-11-11T11:01:04.000+0800","created":"2011-11-10T16:54:19.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/6","description":"The issue is considered finished, the resolution is correct. Issues which are closed can be reopened.","iconUrl":"http://10.1.3.4:8080/images/icons/status_closed.gif","name":"Closed","id":"6"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"browser will open google web page","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-16/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":{"self":"http://10.1.3.4:8080/rest/api/2/resolution/3","id":"3","description":"The problem is a duplicate of an existing issue.","name":"Duplicate"},"resolutiondate":"2011-11-10T17:15:28.000+0800","customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2678","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-16/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=viki","name":"viki","emailAddress":"viki@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"ViKi","active":false},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1. open web browser\n2. enter http://www.google.com\n3. press enter key","customfield_10345":null,"customfield_11030":"2904","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"message says page not found","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"23673","self":"http://10.1.3.4:8080/rest/api/latest/issue/23673","key":"TP-17","fields":{"progress":{"progress":0,"total":0},"summary":"Chair seat not correct dimensions","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=viki","name":"viki","emailAddress":"viki@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"ViKi","active":false},"updated":"2011-11-11T11:00:24.000+0800","created":"2011-11-10T16:56:11.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/6","description":"The issue is considered finished, the resolution is correct. Issues which are closed can be reopened.","iconUrl":"http://10.1.3.4:8080/images/icons/status_closed.gif","name":"Closed","id":"6"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"seat is 16 inches wide","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-17/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":{"self":"http://10.1.3.4:8080/rest/api/2/resolution/2","id":"2","description":"The problem described is an issue which will never be fixed.","name":"Won't Fix"},"resolutiondate":"2011-11-10T17:14:35.000+0800","customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2677","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-17/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=viki","name":"viki","emailAddress":"viki@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"ViKi","active":false},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1. measure seat width from right side center to left side center","customfield_10345":null,"customfield_11030":"2903","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"seat is 12 inches wide","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"23674","self":"http://10.1.3.4:8080/rest/api/latest/issue/23674","key":"TP-18","fields":{"progress":{"progress":0,"total":0},"summary":"Time out error","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=viki","name":"viki","emailAddress":"viki@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"ViKi","active":false},"updated":"2011-11-11T11:24:18.000+0800","created":"2011-11-10T16:59:34.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/6","description":"The issue is considered finished, the resolution is correct. Issues which are closed can be reopened.","iconUrl":"http://10.1.3.4:8080/images/icons/status_closed.gif","name":"Closed","id":"6"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"google will open","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-18/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":{"self":"http://10.1.3.4:8080/rest/api/2/resolution/1","id":"1","description":"A fix for this issue is checked into the tree and tested.","name":"Fixed"},"resolutiondate":"2011-11-10T17:13:22.000+0800","customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2676","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-18/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=viki","name":"viki","emailAddress":"viki@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"ViKi","active":false},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1. open web browser\n2. type http://www.google.com\n3. press enter","customfield_10345":null,"customfield_11030":"2902","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"time out error message","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"23675","self":"http://10.1.3.4:8080/rest/api/latest/issue/23675","key":"TP-19","fields":{"progress":{"progress":0,"total":0},"summary":"Cancel and Submit buttons overlap on login screen","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/20","id":"20","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"UI Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=toi","name":"toi","emailAddress":"toi@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Toi","active":false},"updated":"2011-11-11T11:03:54.000+0800","created":"2011-11-10T16:59:37.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/6","description":"The issue is considered finished, the resolution is correct. Issues which are closed can be reopened.","iconUrl":"http://10.1.3.4:8080/images/icons/status_closed.gif","name":"Closed","id":"6"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"Log in screen displays without Cancel and Submit buttons overlapping","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-19/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":{"self":"http://10.1.3.4:8080/rest/api/2/resolution/1","id":"1","description":"A fix for this issue is checked into the tree and tested.","name":"Fixed"},"resolutiondate":"2011-11-10T17:12:04.000+0800","customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":"Defect only occurs on evry third login","customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2675","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-19/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=toi","name":"toi","emailAddress":"toi@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Toi","active":false},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1. Access wesite www.login.com\n","customfield_10345":null,"customfield_11030":"2901","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"Log in screen displays with Cancel and Submit buttons overlapping","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"23676","self":"http://10.1.3.4:8080/rest/api/latest/issue/23676","key":"TP-20","fields":{"progress":{"progress":0,"total":0},"summary":"Cannot logon system with correct username and password","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"updated":"2011-11-10T17:20:40.000+0800","created":"2011-11-10T17:20:40.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/2","iconUrl":"http://10.1.3.4:8080/images/icons/priority_critical.gif","name":"Critical","id":"2"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"Should be able to log into the system.","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-20/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":"This defect occurs in IE6. \nThis defect doesn't occur in IE7,8,9, Firefox 5,6,7, Safari 4,5.","customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2674","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-20/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1. Open www.aaa.com site in browser.\n2. Input the correct user name and password.\n3. Click Submit button.","customfield_10345":null,"customfield_11030":"2900","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"Cannot log into the system.","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"23677","self":"http://10.1.3.4:8080/rest/api/latest/issue/23677","key":"TP-21","fields":{"progress":{"progress":0,"total":0},"summary":"Chrair does not hold specified weight limit","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=toi","name":"toi","emailAddress":"toi@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Toi","active":false},"updated":"2011-11-14T13:22:28.000+0800","created":"2011-11-11T08:41:59.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/6","description":"The issue is considered finished, the resolution is correct. Issues which are closed can be reopened.","iconUrl":"http://10.1.3.4:8080/images/icons/status_closed.gif","name":"Closed","id":"6"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"Chair maintains structure","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-21/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":{"self":"http://10.1.3.4:8080/rest/api/2/resolution/1","id":"1","description":"A fix for this issue is checked into the tree and tested.","name":"Fixed"},"resolutiondate":"2011-11-14T13:22:28.000+0800","customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2673","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-21/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=toi","name":"toi","emailAddress":"toi@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Toi","active":false},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1. Place chair on solid, level surface.\n2. Place 300 pound weight in chair","customfield_10345":null,"customfield_11030":"2899","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"Chair collapses","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"23678","self":"http://10.1.3.4:8080/rest/api/latest/issue/23678","key":"TP-22","fields":{"progress":{"progress":0,"total":0},"summary":" \"Help\" dropown menu does not display","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10494","value":"2-Feature Inaccessible","id":"10494"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=toi","name":"toi","emailAddress":"toi@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Toi","active":false},"updated":"2011-11-14T13:21:42.000+0800","created":"2011-11-11T08:53:19.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/4","iconUrl":"http://10.1.3.4:8080/images/icons/priority_minor.gif","name":"Minor","id":"4"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/5","description":"A resolution has been taken, and it is awaiting verification by reporter. From here issues are either reopened, or are closed.","iconUrl":"http://10.1.3.4:8080/images/icons/status_resolved.gif","name":"Resolved","id":"5"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"Dropdown menu options \"View Help\" and \"About Notepad\" appear","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-22/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":{"self":"http://10.1.3.4:8080/rest/api/2/resolution/1","id":"1","description":"A fix for this issue is checked into the tree and tested.","name":"Fixed"},"resolutiondate":"2011-11-11T11:21:41.000+0800","customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2672","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-22/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1. Open Notepad\n2. Click \"Help\" dropdown menu","customfield_10345":null,"customfield_11030":"2898","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"No dropdown menu options appear","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"23679","self":"http://10.1.3.4:8080/rest/api/latest/issue/23679","key":"TP-23","fields":{"progress":{"progress":0,"total":0},"summary":"Cannot display webpage :www.XBOsoft.com\" from Internet Explorer","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=toi","name":"toi","emailAddress":"toi@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Toi","active":false},"updated":"2011-11-14T13:21:21.000+0800","created":"2011-11-11T09:08:52.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/4","iconUrl":"http://10.1.3.4:8080/images/icons/priority_minor.gif","name":"Minor","id":"4"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/6","description":"The issue is considered finished, the resolution is correct. Issues which are closed can be reopened.","iconUrl":"http://10.1.3.4:8080/images/icons/status_closed.gif","name":"Closed","id":"6"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"XBOsoft home page appears","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-23/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":{"self":"http://10.1.3.4:8080/rest/api/2/resolution/1","id":"1","description":"A fix for this issue is checked into the tree and tested.","name":"Fixed"},"resolutiondate":"2011-11-14T13:21:21.000+0800","customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2671","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-23/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=toi","name":"toi","emailAddress":"toi@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Toi","active":false},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1. Open Internet Explorer.\n2. Type \"www.XBOsoft.com\" in the \"Adddress\" field.","customfield_10345":null,"customfield_11030":"2897","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"Blank white screen appears","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"23681","self":"http://10.1.3.4:8080/rest/api/latest/issue/23681","key":"TP-24","fields":{"progress":{"progress":0,"total":0},"summary":"Will not type in font other than \"Calibri\"","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=toi","name":"toi","emailAddress":"toi@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Toi","active":false},"updated":"2011-11-14T13:20:50.000+0800","created":"2011-11-11T09:24:28.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/5","iconUrl":"http://10.1.3.4:8080/images/icons/priority_trivial.gif","name":"Trivial","id":"5"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/6","description":"The issue is considered finished, the resolution is correct. Issues which are closed can be reopened.","iconUrl":"http://10.1.3.4:8080/images/icons/status_closed.gif","name":"Closed","id":"6"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"Typed words will show in newly selected font","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-24/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":{"self":"http://10.1.3.4:8080/rest/api/2/resolution/1","id":"1","description":"A fix for this issue is checked into the tree and tested.","name":"Fixed"},"resolutiondate":"2011-11-14T13:20:50.000+0800","customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2670","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-24/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1. Open Microsoft Office 2007\n2. Select ay option except \"Calibri\" from the \"Font\" dropdown menu\n3. Type \"abcd\"","customfield_10345":null,"customfield_11030":"2896","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"Typed words continue to show in Calibri","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"23682","self":"http://10.1.3.4:8080/rest/api/latest/issue/23682","key":"TP-25","fields":{"progress":{"progress":0,"total":0},"summary":"Microsoft Office Outlook 2007 Email will not send attachments","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10494","value":"2-Feature Inaccessible","id":"10494"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=toi","name":"toi","emailAddress":"toi@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Toi","active":false},"updated":"2011-11-14T13:20:24.000+0800","created":"2011-11-11T09:32:28.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/5","description":"A resolution has been taken, and it is awaiting verification by reporter. From here issues are either reopened, or are closed.","iconUrl":"http://10.1.3.4:8080/images/icons/status_resolved.gif","name":"Resolved","id":"5"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"Attachment is attached in recieved email","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-25/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":{"self":"http://10.1.3.4:8080/rest/api/2/resolution/7","id":"7","description":"","name":"Postpone"},"resolutiondate":"2011-11-11T10:40:22.000+0800","customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2669","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-25/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=toi","name":"toi","emailAddress":"toi@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Toi","active":false},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"Prerequisite: Have saved word file created to use as attachment\n\n1. Open Microsoft Office Outlook 2007\n2. Click \"New\" to create a new mail message\n3. Enter your email address in \"To\" field\n4. Attach prerequiste Word document to email\n5. Click \"Send\n6. Verify in your email if attachment is attached","customfield_10345":null,"customfield_11030":"2895","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"Email is recieved but there is no attachment","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24217","self":"http://10.1.3.4:8080/rest/api/latest/issue/24217","key":"TP-101","fields":{"progress":{"progress":0,"total":0},"summary":"Got exception when click OK button.","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"updated":"2012-01-30T14:54:09.000+0800","created":"2012-01-30T14:53:23.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/2","iconUrl":"http://10.1.3.4:8080/images/icons/priority_critical.gif","name":"Critical","id":"2"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/6","description":"The issue is considered finished, the resolution is correct. Issues which are closed can be reopened.","iconUrl":"http://10.1.3.4:8080/images/icons/status_closed.gif","name":"Closed","id":"6"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"fdafda","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-101/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":{"self":"http://10.1.3.4:8080/rest/api/2/resolution/1","id":"1","description":"A fix for this issue is checked into the tree and tested.","name":"Fixed"},"resolutiondate":"2012-01-30T14:54:09.000+0800","customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2593","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-101/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1.\n2\n3\n","customfield_10345":null,"customfield_11030":"2819","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"adaf","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24234","self":"http://10.1.3.4:8080/rest/api/latest/issue/24234","key":"TP-103","fields":{"progress":{"progress":0,"total":0},"summary":"A sample defect","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"updated":"2012-01-31T14:22:35.000+0800","created":"2012-01-31T14:20:52.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/6","description":"The issue is considered finished, the resolution is correct. Issues which are closed can be reopened.","iconUrl":"http://10.1.3.4:8080/images/icons/status_closed.gif","name":"Closed","id":"6"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"Should be able to save successfully.","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-103/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":{"self":"http://10.1.3.4:8080/rest/api/2/resolution/1","id":"1","description":"A fix for this issue is checked into the tree and tested.","name":"Fixed"},"resolutiondate":"2012-01-31T14:22:03.000+0800","customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":"1. Only occurs in Windows XP.","customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2591","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-103/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1. Invoke Notepad.\n2. Input string \"Hello world\".\nkdfald\n","customfield_10345":null,"customfield_11030":"2817","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"Can't save","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24290","self":"http://10.1.3.4:8080/rest/api/latest/issue/24290","key":"TP-105","fields":{"progress":{"progress":0,"total":0},"summary":"HSEC Document doesn't exist.","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"updated":"2012-02-08T14:01:34.000+0800","created":"2012-02-07T11:40:13.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/6","description":"The issue is considered finished, the resolution is correct. Issues which are closed can be reopened.","iconUrl":"http://10.1.3.4:8080/images/icons/status_closed.gif","name":"Closed","id":"6"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":null,"project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-105/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":{"self":"http://10.1.3.4:8080/rest/api/2/resolution/1","id":"1","description":"A fix for this issue is checked into the tree and tested.","name":"Fixed"},"resolutiondate":"2012-02-08T14:01:34.000+0800","customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2589","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-105/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":null,"customfield_10345":null,"customfield_11030":"2815","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":null,"customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24349","self":"http://10.1.3.4:8080/rest/api/latest/issue/24349","key":"TP-117","fields":{"progress":{"progress":0,"total":0},"summary":"Stop wrong storey when up to 5,it stop after get 6 storey","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/20","id":"20","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"UI Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10494","value":"2-Feature Inaccessible","id":"10494"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=zhang.xuemei","name":"zhang.xuemei","emailAddress":"zhang.xuemei@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Zhang Xuemei","active":false},"updated":"2012-02-28T15:31:27.000+0800","created":"2012-02-28T15:31:27.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"elevator get 5 from 1 directly","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-117/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2577","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-117/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":"ZXM01","assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1.f","customfield_10345":null,"customfield_11030":"2803","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"e","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24350","self":"http://10.1.3.4:8080/rest/api/latest/issue/24350","key":"TP-118","fields":{"progress":{"progress":0,"total":0},"summary":"Stop wrong storey when up to 5,it stop after get 6 storey","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=zhang.xuemei","name":"zhang.xuemei","emailAddress":"zhang.xuemei@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Zhang Xuemei","active":false},"updated":"2012-02-28T15:50:15.000+0800","created":"2012-02-28T15:50:15.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"elevator stop 4 ,5,7 in  turn ","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-118/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2576","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-118/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1.click operation button\"0\";\n2.click operation button\"4,5,7\" ;\n","customfield_10345":null,"customfield_11030":"2802","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"elevator stop 4 ,6,5,7 in this turn .","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24351","self":"http://10.1.3.4:8080/rest/api/latest/issue/24351","key":"TP-119","fields":{"progress":{"progress":0,"total":0},"summary":"Up Quenue list display wrong","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=zhang.xuemei","name":"zhang.xuemei","emailAddress":"zhang.xuemei@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Zhang Xuemei","active":false},"updated":"2012-02-28T15:59:12.000+0800","created":"2012-02-28T15:59:12.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"Up Quenue list display \"7;\".","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-119/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2575","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-119/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1.Click operation button 7;\n\n","customfield_10345":null,"customfield_11030":"2801","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"Up Quenue list display \"7,1;\".","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24352","self":"http://10.1.3.4:8080/rest/api/latest/issue/24352","key":"TP-120","fields":{"progress":{"progress":0,"total":0},"summary":"Up Quenue list display wrong","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=zhang.xuemei","name":"zhang.xuemei","emailAddress":"zhang.xuemei@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Zhang Xuemei","active":false},"updated":"2012-02-28T15:59:26.000+0800","created":"2012-02-28T15:59:26.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"Up Quenue list display \"7;\".","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-120/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2574","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-120/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1.Click operation button 7;\n\n","customfield_10345":null,"customfield_11030":"2800","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"Up Quenue list display \"7,1;\".","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24353","self":"http://10.1.3.4:8080/rest/api/latest/issue/24353","key":"TP-121","fields":{"progress":{"progress":0,"total":0},"summary":"Up Quenue list display wrong","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=zhang.xuemei","name":"zhang.xuemei","emailAddress":"zhang.xuemei@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Zhang Xuemei","active":false},"updated":"2012-02-28T16:02:09.000+0800","created":"2012-02-28T16:02:09.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"Up Quenue list display \"7;\".\n","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-121/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2573","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-121/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1 click operation button 7","customfield_10345":null,"customfield_11030":"2799","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"Up Quenue list display \"7,1;\".\n","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24354","self":"http://10.1.3.4:8080/rest/api/latest/issue/24354","key":"TP-122","fields":{"progress":{"progress":0,"total":0},"summary":"Door will open two times in same floor","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=zhang.xuemei","name":"zhang.xuemei","emailAddress":"zhang.xuemei@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Zhang Xuemei","active":false},"updated":"2012-02-28T16:05:03.000+0800","created":"2012-02-28T16:05:03.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"Door will open only one time.","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-122/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2572","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-122/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1. click Operation button up\\down to aim storey;\n2. in the same time click aim's floor button to down\\up; \t","customfield_10345":null,"customfield_11030":"2798","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":" the door opened two times","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24355","self":"http://10.1.3.4:8080/rest/api/latest/issue/24355","key":"TP-123","fields":{"progress":{"progress":0,"total":0},"summary":"click same operation button continuous,elevator not stay","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=zhang.xuemei","name":"zhang.xuemei","emailAddress":"zhang.xuemei@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Zhang Xuemei","active":false},"updated":"2012-02-28T16:12:56.000+0800","created":"2012-02-28T16:12:56.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"the elevator stay at 4 and the door were opened","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-123/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2571","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-123/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1 .elevator at 5 click operation button 1.2.3.4.6.7 ;(make sure elevator was running when step 2 started)\n2when it stop 4.,click 4 operation button continuous.\n","customfield_10345":null,"customfield_11030":"2797","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"the elevator up to 6 and 7 storey .","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24356","self":"http://10.1.3.4:8080/rest/api/latest/issue/24356","key":"TP-124","fields":{"progress":{"progress":0,"total":0},"summary":"elevator have no \"0\" storey","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/20","id":"20","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"UI Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=zhang.xuemei","name":"zhang.xuemei","emailAddress":"zhang.xuemei@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Zhang Xuemei","active":false},"updated":"2012-02-28T16:15:49.000+0800","created":"2012-02-28T16:15:49.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":null,"project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-124/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2570","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-124/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"Open \"Elevator Simulator\"","customfield_10345":null,"customfield_11030":"2796","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"elevator have  \"0\" button","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24469","self":"http://10.1.3.4:8080/rest/api/latest/issue/24469","key":"TP-125","fields":{"progress":{"progress":0,"total":0},"summary":"The \"cut\" button does not work","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=li.bingyue","name":"li.bingyue","emailAddress":"li.bingyue@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&ownerId=li.bingyue&avatarId=10500","48x48":"http://10.1.3.4:8080/secure/useravatar?ownerId=li.bingyue&avatarId=10500"},"displayName":"Li Bingyue","active":true},"updated":"2012-04-26T15:33:20.000+0800","created":"2012-04-26T15:33:20.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"This two characters will be cut.","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-125/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2569","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-125/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":"L003","assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1.Input some characters in notepad.\n2.Choose two characters and click \"Cut\" button.","customfield_10345":null,"customfield_11030":"2795","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"This two characters cannot be cut.","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24470","self":"http://10.1.3.4:8080/rest/api/latest/issue/24470","key":"TP-126","fields":{"progress":{"progress":0,"total":0},"summary":"\"cut\"and \"copy\" button color should gray when the notepad be started.","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10496","value":"4-Minor Error","id":"10496"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=li.bingyue","name":"li.bingyue","emailAddress":"li.bingyue@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&ownerId=li.bingyue&avatarId=10500","48x48":"http://10.1.3.4:8080/secure/useravatar?ownerId=li.bingyue&avatarId=10500"},"displayName":"Li Bingyue","active":true},"updated":"2012-04-26T15:36:03.000+0800","created":"2012-04-26T15:36:03.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"The \"cut\"and \"copy\" button is gray but the \"paste\" button is black. ","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-126/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2568","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-126/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":"L001","assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1.start the application. \n\n2.Click the \"edit\" button of menus. \n\n3.Check the buttons of \"cut\",\"copy\",\"paste\". \n\n","customfield_10345":null,"customfield_11030":"2794","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"The \"cut\", \"copy and \"paste\" button is black.  ","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24471","self":"http://10.1.3.4:8080/rest/api/latest/issue/24471","key":"TP-127","fields":{"progress":{"progress":0,"total":0},"summary":"No response after clicking the right click","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=li.bingyue","name":"li.bingyue","emailAddress":"li.bingyue@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&ownerId=li.bingyue&avatarId=10500","48x48":"http://10.1.3.4:8080/secure/useravatar?ownerId=li.bingyue&avatarId=10500"},"displayName":"Li Bingyue","active":true},"updated":"2012-04-26T15:37:20.000+0800","created":"2012-04-26T15:37:20.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"Appear \"cut\",\"copy\",\"paste\" etc. button. ","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-127/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2567","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-127/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":"L002","assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1.Start the application. \n2.Click the right click. \n","customfield_10345":null,"customfield_11030":"2793","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"No response after clicking the right click .","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24472","self":"http://10.1.3.4:8080/rest/api/latest/issue/24472","key":"TP-128","fields":{"progress":{"progress":0,"total":0},"summary":"The cut function of Notepad does not  work.","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=wang.qibo","name":"wang.qibo","emailAddress":"wang.qibo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Wang Qibo","active":false},"updated":"2012-04-26T15:39:44.000+0800","created":"2012-04-26T15:39:44.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/4","iconUrl":"http://10.1.3.4:8080/images/icons/priority_minor.gif","name":"Minor","id":"4"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"The words should be cleared when cut and pasted correctly.","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-128/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":"Windows XP.","customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2566","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-128/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":"41203","assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1. Invoke the NotepadTest.exe.\n\n2. Enter some words.\n\n3.Select some words and click the menu cut.\n\n4.Click the menu paste.","customfield_10345":null,"customfield_11030":"2792","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"The cut  words cannot be pasted correctly.","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24473","self":"http://10.1.3.4:8080/rest/api/latest/issue/24473","key":"TP-129","fields":{"progress":{"progress":0,"total":0},"summary":"There is no warning message when close a new file with some words unsaved.","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=wang.qibo","name":"wang.qibo","emailAddress":"wang.qibo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Wang Qibo","active":false},"updated":"2012-04-26T15:44:48.000+0800","created":"2012-04-26T15:44:48.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/4","iconUrl":"http://10.1.3.4:8080/images/icons/priority_minor.gif","name":"Minor","id":"4"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"There should be a warning message when close a new file with some words in it .","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-129/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":"Windows XP.","customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2565","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-129/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":"41227","assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1. Invoke up NotepadTest.exe.\n\n2.Enter some words.\n\n3.Click the button \"X\" in the right upper.","customfield_10345":null,"customfield_11030":"2791","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"There is no message displayed when close the file with some words unsaved.","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24474","self":"http://10.1.3.4:8080/rest/api/latest/issue/24474","key":"TP-130","fields":{"progress":{"progress":0,"total":0},"summary":"Cannot cut words","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=wang.bo","name":"wang.bo","emailAddress":"wang.bo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Wang Bo","active":true},"updated":"2012-04-27T09:46:59.000+0800","created":"2012-04-26T15:48:46.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"Can see 'abcHellow'","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-130/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":"copy paste can be used\nThere is a file named f1 ,and there is 'Hellow abc' in it.","customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2564","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-130/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1.Open f1\n\n2.Select Hellow\n\n3.Press ctrl+x\n\n4.Click behind 'abc'\n\n5.Press ctrl+v\n","customfield_10345":null,"customfield_11030":"2790","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"Hellow abc","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24475","self":"http://10.1.3.4:8080/rest/api/latest/issue/24475","key":"TP-131","fields":{"progress":{"progress":0,"total":0},"summary":"Close window ,not save","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=wang.bo","name":"wang.bo","emailAddress":"wang.bo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Wang Bo","active":true},"updated":"2012-04-27T09:26:39.000+0800","created":"2012-04-26T15:55:23.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"1.There is 'http' in the end\n","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-131/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2563","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-131/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1.Open f1\n\n2.Add 'http' to te end\n\n3.Click close button\n\n4.Click yes button\n\n5.Open f1\n","customfield_10345":null,"customfield_11030":"2789","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"No 'http' in the end","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24476","self":"http://10.1.3.4:8080/rest/api/latest/issue/24476","key":"TP-132","fields":{"progress":{"progress":0,"total":0},"summary":"The \"about\" button prompt is not accurate","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/20","id":"20","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"UI Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=li.bingyue","name":"li.bingyue","emailAddress":"li.bingyue@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&ownerId=li.bingyue&avatarId=10500","48x48":"http://10.1.3.4:8080/secure/useravatar?ownerId=li.bingyue&avatarId=10500"},"displayName":"Li Bingyue","active":true},"updated":"2012-04-26T16:02:59.000+0800","created":"2012-04-26T16:02:59.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"pops-up prompts and description is right.","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-132/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2562","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-132/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":"L004","assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1.Click the \"About\" button.","customfield_10345":null,"customfield_11030":"2788","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"pops-up prompts and description is not accurate.","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24500","self":"http://10.1.3.4:8080/rest/api/latest/issue/24500","key":"TP-133","fields":{"progress":{"progress":0,"total":0},"summary":"Close button can't work.","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=ai.lian","name":"ai.lian","emailAddress":"ai.lian@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Ai Lian","active":false},"updated":"2012-05-08T11:30:57.000+0800","created":"2012-05-08T11:30:57.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"Caculater should be closed nomally.","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-133/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":"Only close butoon can't work nomally,the other buttons work well.","customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2561","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-133/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"Click close button.","customfield_10345":null,"customfield_11030":"2787","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"Caculater can't  close .","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24502","self":"http://10.1.3.4:8080/rest/api/latest/issue/24502","key":"TP-134","fields":{"progress":{"progress":0,"total":0},"summary":"The application alert \"Exception occurred\" when Click \"=\" button directly","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10493","value":"1-Crash/Data Loss","id":"10493"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=zhao.ruyong","name":"zhao.ruyong","emailAddress":"zhao.ruyong@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Zhao Ruyong","active":true},"updated":"2012-05-08T13:12:51.000+0800","created":"2012-05-08T13:12:51.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"The application should be not reaction.","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-134/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2560","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-134/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":"Calculator-001","assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1.Double-click \"Calculator.jar \"to invoke the application.\n2.Click \"=\" button in the GUI panel directly.","customfield_10345":null,"customfield_11030":"2786","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"The application alert \"Exception occurred\".","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24503","self":"http://10.1.3.4:8080/rest/api/latest/issue/24503","key":"TP-135","fields":{"progress":{"progress":0,"total":0},"summary":"Negative number is not supported","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10552","value":"Enhancement","id":"10552"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=zhao.ruyong","name":"zhao.ruyong","emailAddress":"zhao.ruyong@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Zhao Ruyong","active":true},"updated":"2012-05-08T17:34:50.000+0800","created":"2012-05-08T13:19:22.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"The number in the text field should be -5.","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-135/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2559","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-135/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":"Calculator-002","assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1. Start \"Calculator\" application.\n  \n2. Click on \"-\" button.\n  \n3. Input the number '5' by clicking number buttons.","customfield_10345":null,"customfield_11030":"2785","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"The number in the text field is 5.","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24504","self":"http://10.1.3.4:8080/rest/api/latest/issue/24504","key":"TP-136","fields":{"progress":{"progress":0,"total":0},"summary":"Test whether or not the caculator work properly.","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=ai.lian","name":"ai.lian","emailAddress":"ai.lian@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Ai Lian","active":false},"updated":"2012-05-08T13:19:27.000+0800","created":"2012-05-08T13:19:27.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"1.Click  number button and  the number  display  in the above yellow text box.\n\n2. Click operational character('+'  '-'  '*'  '/') ,they  don't show in the above yellow text box.\n\n3.Click clear button ,the above yellow text box will be empty.\n\n4 Check minimize button,maxmize button and close button  should response correctly\n\n5.Do operations(2+5=7), the result should be correct.\n","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-136/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2558","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-136/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1.Click  all the number button in turn .\n\n2.Click  four operational character button in turn .\n\n3.Click clear button.\n\n4.Click  minimize,maxmize and close butoon . \n\n5.Check equal character butoon.\n","customfield_10345":null,"customfield_11030":"2784","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"Close button can't work,ther other is ok. ","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24505","self":"http://10.1.3.4:8080/rest/api/latest/issue/24505","key":"TP-137","fields":{"progress":{"progress":0,"total":0},"summary":"The close button doesn't work.","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=zhao.ruyong","name":"zhao.ruyong","emailAddress":"zhao.ruyong@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Zhao Ruyong","active":true},"updated":"2012-05-08T13:22:39.000+0800","created":"2012-05-08T13:22:39.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"The window should be closed.","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-137/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2557","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-137/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":"Calculator-003","assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1. Start \"Calculator\" application.\n \n2. Click Close button in the GUI panel.","customfield_10345":null,"customfield_11030":"2783","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"The Close button doesn't work.","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24506","self":"http://10.1.3.4:8080/rest/api/latest/issue/24506","key":"TP-138","fields":{"progress":{"progress":0,"total":0},"summary":"Do mixed mode operation (4*5-10=10  ,   6+8/2=10),check the result is right.","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=ai.lian","name":"ai.lian","emailAddress":"ai.lian@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Ai Lian","active":false},"updated":"2012-05-08T13:26:39.000+0800","created":"2012-05-08T13:26:39.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"The result should be 10.","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-138/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":"Two eye operation is right ,three eye operation is wrong.","customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2556","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-138/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1.Click first number button,\n\n2.Click operational character button.\n\n3.Click second number button .\n\n4 Click '='button.\n","customfield_10345":null,"customfield_11030":"2782","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"caculate 4*5-10 ,result is -506.0","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24507","self":"http://10.1.3.4:8080/rest/api/latest/issue/24507","key":"TP-139","fields":{"progress":{"progress":0,"total":0},"summary":"Unexpected result occurs when divide by zero","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=zhao.ruyong","name":"zhao.ruyong","emailAddress":"zhao.ruyong@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Zhao Ruyong","active":true},"updated":"2012-05-08T17:25:11.000+0800","created":"2012-05-08T13:26:50.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"The calculator should tell \"Cannot divide by zero\".","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-139/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2555","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-139/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":"Calculator-004","assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1. Start \"Calculator\" application.\n  \n 2. Input the first number '24' by clicking number buttons.\n  \n 3. Click on \"/\" button.\n  \n 4. Input the second number '0' by clicking number buttons.\n  \n 5. Click \"=\" button.","customfield_10345":null,"customfield_11030":"2781","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"The calculator tell \"Infinity\".","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24508","self":"http://10.1.3.4:8080/rest/api/latest/issue/24508","key":"TP-140","fields":{"progress":{"progress":0,"total":0},"summary":"Incorrect results occurs in multi-steps opteration.","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10494","value":"2-Feature Inaccessible","id":"10494"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=zhao.ruyong","name":"zhao.ruyong","emailAddress":"zhao.ruyong@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Zhao Ruyong","active":true},"updated":"2012-05-09T16:57:59.000+0800","created":"2012-05-08T13:29:02.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"The calculator result should be 95.","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-140/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2554","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-140/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1. Start \"Calculator\" application.\n  \n 2. Input the first number '9' by clicking number buttons.\n  \n 3. Click on operator button '+'.\n  \n 4. Input the second number '10' by clicking number buttons.\n  \n 5. Click on operator button '*'.\n  \n 6. Input the third number '5' by click number buttons.\n  \n 7. Click \"=\" button.","customfield_10345":null,"customfield_11030":"2780","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"The calculator result is 945.0.","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24509","self":"http://10.1.3.4:8080/rest/api/latest/issue/24509","key":"TP-141","fields":{"progress":{"progress":0,"total":0},"summary":"Calculator: Incorrect results occurs in subtraction operation.","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10494","value":"2-Feature Inaccessible","id":"10494"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=zhao.ruyong","name":"zhao.ruyong","emailAddress":"zhao.ruyong@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Zhao Ruyong","active":true},"updated":"2012-05-09T17:05:34.000+0800","created":"2012-05-08T13:31:55.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"The calculator result should be 10000.","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-141/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2553","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-141/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1. Start \"Calculator\" application.\n  \n2. Input the first number '10000' by clicking number buttons.\n  \n 3. Click on \"-\" button.\n  \n 4. Input the second number '0' by clicking number buttons.\n  \n 5. Click \"=\" button.","customfield_10345":null,"customfield_11030":"2779","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"The calculator result is 9990.0.","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24510","self":"http://10.1.3.4:8080/rest/api/latest/issue/24510","key":"TP-142","fields":{"progress":{"progress":0,"total":0},"summary":"Calculator: The calculator doesn't support the float calculation.","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10552","value":"Enhancement","id":"10552"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=zhao.ruyong","name":"zhao.ruyong","emailAddress":"zhao.ruyong@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Zhao Ruyong","active":true},"updated":"2012-05-09T17:12:06.000+0800","created":"2012-05-08T13:37:04.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/5","iconUrl":"http://10.1.3.4:8080/images/icons/priority_trivial.gif","name":"Trivial","id":"5"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"The dot button should exist in the panel.","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-142/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2552","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-142/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1. Start \"Calculator\" application.\n2. Check the panel.","customfield_10345":null,"customfield_11030":"2778","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"There is no dot button in the panel.","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24511","self":"http://10.1.3.4:8080/rest/api/latest/issue/24511","key":"TP-143","fields":{"progress":{"progress":0,"total":0},"summary":"The calculation results all end with \".0\"","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=zhao.ruyong","name":"zhao.ruyong","emailAddress":"zhao.ruyong@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Zhao Ruyong","active":true},"updated":"2012-05-08T13:39:57.000+0800","created":"2012-05-08T13:39:57.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"The calculator result should be 3.","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-143/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2551","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-143/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":"Calculator-008","assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1. Start \"Calculator\" application.\n \n2. Input the first number '1' by clicking number buttons.\n  \n 3. Click on \"+\" button.\n  \n 4. Input the second number '2' by clicking number buttons.\n  \n 5. Click \"=\" button.\n","customfield_10345":null,"customfield_11030":"2777","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"The calculator result is 3.0.","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24512","self":"http://10.1.3.4:8080/rest/api/latest/issue/24512","key":"TP-144","fields":{"progress":{"progress":0,"total":0},"summary":"The text field support keyboard to input numbers or texts.","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=zhao.ruyong","name":"zhao.ruyong","emailAddress":"zhao.ruyong@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Zhao Ruyong","active":true},"updated":"2012-05-08T13:44:42.000+0800","created":"2012-05-08T13:44:42.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"The text field should not be supported keyboard to input numbers or texts.","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-144/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2550","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-144/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":"Calculator-009","assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1. Start \"Calculator\" application.\n  \n2. Input any number/text from keyboard.","customfield_10345":null,"customfield_11030":"2776","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"The text field support keyboard to input numbers or texts.","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24513","self":"http://10.1.3.4:8080/rest/api/latest/issue/24513","key":"TP-145","fields":{"progress":{"progress":0,"total":0},"summary":"Calculator: Incorrect results occurs in division operation.","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=zhao.ruyong","name":"zhao.ruyong","emailAddress":"zhao.ruyong@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Zhao Ruyong","active":true},"updated":"2012-05-09T17:07:13.000+0800","created":"2012-05-08T15:27:28.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"The calculator result should be 2.666666666666667.","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-145/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2549","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-145/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1. Start \"Calculator\" application.\n  \n 2. Input the first number '8' by clicking number buttons.\n  \n 3. Click on \"/\" button.\n  \n 4. Input the second number '3' by clicking number buttons.\n  \n 5. Click \"=\" button.","customfield_10345":null,"customfield_11030":"2775","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"The calculator result is 2.6666666666666665.","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}},{"expand":"editmeta,renderedFields,transitions,changelog,operations","id":"24516","self":"http://10.1.3.4:8080/rest/api/latest/issue/24516","key":"TP-146","fields":{"progress":{"progress":0,"total":0},"summary":"copy  fanction is abnomal","issuetype":{"self":"http://10.1.3.4:8080/rest/api/2/issuetype/14","id":"14","description":"","iconUrl":"http://10.1.3.4:8080/images/icons/genericissue.gif","name":"Functional Issue","subtask":false},"customfield_10080":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10495","value":"3-Wrong Behavior","id":"10495"},"customfield_10610":null,"timespent":null,"customfield_10140":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10520","value":"All","id":"10520"},"reporter":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=ai.lian","name":"ai.lian","emailAddress":"ai.lian@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Ai Lian","active":false},"updated":"2012-05-09T10:56:57.000+0800","created":"2012-05-09T10:56:57.000+0800","priority":{"self":"http://10.1.3.4:8080/rest/api/2/priority/3","iconUrl":"http://10.1.3.4:8080/images/icons/priority_major.gif","name":"Major","id":"3"},"description":null,"issuelinks":[],"customfield_10004":null,"subtasks":[],"customfield_10009":null,"status":{"self":"http://10.1.3.4:8080/rest/api/2/status/1","description":"The issue is open and ready for the assignee to start work on it.","iconUrl":"http://10.1.3.4:8080/images/icons/status_open.gif","name":"Open","id":"1"},"customfield_10931":null,"customfield_10007":null,"customfield_10930":null,"customfield_10006":null,"labels":[],"customfield_10005":null,"workratio":-1,"customfield_10290":[{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11070","value":"Publish","id":"11070"}],"customfield_10532":"copy fanction works well , that is 'AAA' copy success.","project":{"self":"http://10.1.3.4:8080/rest/api/2/project/TP","id":"10393","key":"TP","name":"TrainingProject","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/projectavatar?size=small&pid=10393&avatarId=10011","48x48":"http://10.1.3.4:8080/secure/projectavatar?pid=10393&avatarId=10011"}},"customfield_10154":null,"customfield_10151":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/10583","value":"XP Pro","id":"10583"},"environment":null,"aggregateprogress":{"progress":0,"total":0},"components":[],"timeoriginalestimate":null,"customfield_10726":null,"customfield_10111":null,"customfield_10360":null,"votes":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-146/votes","votes":0,"hasVoted":false},"fixVersions":[],"security":{"self":"http://10.1.3.4:8080/rest/api/2/securitylevel/10045","id":"10045","description":"","name":"All View"},"resolution":null,"resolutiondate":null,"customfield_10346":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11385","value":"TK","id":"11385"},"customfield_10347":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11391","value":"XBOSoft","id":"11391"},"customfield_10686":null,"customfield_10348":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11397","value":"Win XP_Pro SP2","id":"11397"},"customfield_10349":null,"customfield_10354":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11496","value":"6.0.37.0_02","id":"11496"},"aggregatetimeoriginalestimate":null,"customfield_10830":"2548","customfield_10353":null,"customfield_11734":null,"customfield_10356":null,"customfield_10355":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11458","value":"Hoover_VE","id":"11458"},"customfield_10350":null,"customfield_10352":null,"customfield_10351":null,"duedate":null,"customfield_10163":null,"watches":{"self":"http://10.1.3.4:8080/rest/api/2/issue/TP-146/watchers","watchCount":0,"isWatching":false},"customfield_11630":null,"customfield_11131":null,"customfield_10100":null,"assignee":{"self":"http://10.1.3.4:8080/rest/api/2/user?username=guo.jingchun","name":"guo.jingchun","emailAddress":"allen.guo@xbosoft.com","avatarUrls":{"16x16":"http://10.1.3.4:8080/secure/useravatar?size=small&avatarId=10122","48x48":"http://10.1.3.4:8080/secure/useravatar?avatarId=10122"},"displayName":"Guo Jingchun","active":true},"customfield_10370":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11462","value":"Loc bug","id":"11462"},"customfield_11730":null,"aggregatetimeestimate":null,"customfield_10077":"1. Start  'MTCP' application.\n2. Double click  a notepad  builted before.\n3. Copy selected string like 'AAA' by pressing Ctrl+c   ","customfield_10345":null,"customfield_11030":"2774","versions":[],"customfield_10344":null,"customfield_10343":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11378","value":"Manual - Language Independent","id":"11378"},"customfield_10074":"a dialog will be displayed with \"Copy failed! Please copy again\"","customfield_10342":{"self":"http://10.1.3.4:8080/rest/api/2/customFieldOption/11374","value":"ACE 2009","id":"11374"},"customfield_10340":null,"timeestimate":null,"customfield_11031":null,"aggregatetimespent":null}}]}

EOF
	close FoutJsonJira; 

}

sub template2TS {
	my $str = shift; 
	my $filetype = ""; $filetype = shift if @_;
	my $_tsName_bs;
my $SvrProjName_C_no = &getTCName_C_no ($SvrProjName);	
	$_tsName_bs= $SvrProjName;
       	$_tsName_bs =~ s/\//\\/g; 
$str =~ s/__c__/$c/ig;
$str =~ s/__ip__/$ip/ig;
$str =~ s/__no_c_tsName__/$SvrProjName_C_no/gi;
$str =~ s/__tsName__/$SvrProjName/gi;
$str =~ s/__tsName_bs__/$_tsName_bs/gi;
$str =~ s/___TAF__/$_TAF/gi;
$str =~ s/__http_port_IIS__/$http_port_IIS/ig;
$str =~ s/__http_port__/$http_port/ig;
$str =~ s/__index_http_htm__/$index_http_htm/gi;
$str =~ s/__TaaS__/$TaaS/gi;
$str =~ s/__ruby__/$ruby/gi;
$str =~ s/__java__/$java/gi;
$str =~ s/__javac__/$javac/gi;
$str =~ s/__c_plusplus__/$c_plusplus/gi;
$str =~ s/__g_plusplus__/$c_plusplus/gi;
$str =~ s/__gcc__/$gcc/gi;
$str =~ s/__csc__/$csc/gi;
$str =~ s/__autoit__/$autoit/gi;
$str =~ s/__perl__/$perl_/gi;
$str =~ s/__jmeter__/$jmeter/gi;
$str =~ s/__jmeter_url__/$jmeter_url/gi;
$str =~ s/__apacheBench__/$apacheBench/gi;
$str =~ s/__perl__/$perl_/gi;


return $str;
}



sub generateIndexIndexIndex {
my $str=<<'EOFIndex3'
use File::Path;
$tcName = "_testsuite1_";
if ($ARGV[0] =~ /\bh\b/i) {
print<<EOF;
	##############################################################################
	Purpose: create a skeleton of indexindex.pl for AF delivery testing 

	Format : $0 tsName (like _testsuit1_)

	Output c:/iiiiiiii/\$tsName/indexindex.pl 
	##############################################################################

	[WindowOS]
      * T Purpose: Delivery TS (indexindex.pl) commands
	Setup    : c:/iiiiiiii/bin/indexindexindex.pl _testsuite4_
	Execution: c:/iiiiiiii/AutomationFramework/index.pl -runAsCmd -host pdxqaywang01.iiiiiiiinp.com -action installIndexIndex -tsName _testsuite4_
	Verify.  : WebUI http://pdxqaywang01.iiiiiiiinp.com:1234/index_http.htm   has _testsuite4_
	Teardown : c:/iiiiiiii/AutomationFramework/index.pl -runAsCmd -host pdxqaywang01.iiiiiiiinp.com -action delete -tsName _testsuite3_

      *	T Purpose: Delivery TS (index.pl) commands
	Setup    : c:/_TAF/taf.pl testsuite=c:/iiiiiiii/_testsuite5_;createTS
	Execution: c:/iiiiiiii/AutomationFramework/index.pl -runAsCmd -host pdxqaywang01.iiiiiiiinp.com -action installIndex -tsName _testsuite5_ 
	Verify.  : WebUI http: http://pdxqaywang01.iiiiiiiinp.com:1234/index_http.htm   has _testsuite5_
	Teardown : c:/iiiiiiii/AutomationFramework/index.pl -runAsCmd -host pdxqaywang01.iiiiiiiinp.com -action delete -tsName _testsuite5_


	[LinuxOS]
      * T Purpose: Delivery TS (indexindex.pl) commands
	Setup    : /usr/bin/perl /tmp/var/www/cgi-bin/indexindexindex.pl _testsuite4_
	Execution: /usr/bin/perl /tmp/var/www/cgi-bin/AutomationFramework/index.pl -runAsCmd -host pdxqaywang01.iiiiiiiinp.com -action installIndexIndex -tsName _testsuite4_
	Verify.  : WebUI http://pdxqaywang01.iiiiiiiinp.com:1234/index_http.htm   has _testsuite4_
	Teardown : /usr/bin/perl /tmp/var/www/cgi-bin/AutomationFramework/index.pl -runAsCmd -host pdxqaywang01.iiiiiiiinp.com -action delete -tsName _testsuite3_

      *	T Purpose: Delivery TS (index.pl) commands
	Setup    : /usr/bin/perl /tmp/var/www/cgi-bin/_TAF/taf.pl testsuite=/tmp/var/www/cgi-bin/_testsuite5_~createTS
	Execution: /usr/bin/perl /tmp/var/www/cgi-bin/AutomationFramework/index.pl -runAsCmd -host pdxqaywang01.iiiiiiiinp.com -action installIndex -tsName _testsuite5_ 
	Verify.  : /usr/bin/perl /tmp/var/www/cgi-bin/ WebUI http: http://pdxqaywang01.iiiiiiiinp.com:1234/index_http.htm   has _testsuite5_
	Teardown : /usr/bin/perl /tmp/var/www/cgi-bin/AutomationFramework/index.pl -runAsCmd -host pdxqaywang01.iiiiiiiinp.com -action delete -tsName _testsuite5_

	Note: Remote Test Case and Test Suite Execution Commands 

	c:/iiiiiiii/AutomationFramework/index.pl          -runAsCmd -host pdxqaywang01.iiiiiiiinp.com -action installIndexIndex -tsName _testsuite4_
	/tmp/var/www/cgi-bin/AutomationFramework/index.pl -runAsCmd -host pdxqaywang01.iiiiiiiinp.com -action installIndexIndex -tsName _testsuite4_

	c:/iiiiiiii/AutomationFramework/index.pl          -runAsCmd -host pdxqaywang01.iiiiiiiinp.com -action run -tsName _testsuite4_~testcase=testcase0006
	/tmp/var/www/cgi-bin/AutomationFramework/index.pl -runAsCmd -host pdxqaywang01.iiiiiiiinp.com -action run -tsName _testsuite4_~testcase=testcase0006
	

EOF
exit;
}
if ($ARGV[0]) {$tcName = $ARGV[0]; }
my $tcDir = "/tmp/var/www/cgi-bin/$tcName"; if ($^O =~ /linux/) { $tcDir = "/tmp/var/www/cgi-bin/$tcName"; } elsif ($^O =~ /win32/i) { $tcDir = "c:/iiiiiiii/$tcName"; }

if (-e $tcDir ) {;} else { mkpath $tcDir ;}
my $index = "$tcDir/indexindex.pl"; my $ctr; my %tcExec ; my %tcDesc;

open Fout, "> $index"; 

my $str=<<'EOF3';
use File::Path;
$tcName = "_testsuite1_";

my $tcDir = "/tmp/var/www/cgi-bin/$tcName"; if ($^O =~ /linux/) { $tcDir = "/tmp/var/www/cgi-bin/$tcName"; } elsif ($^O =~ /win32/i) { $tcDir = "c:/iiiiiiii/$tcName"; }

if (-e $tcDir ) {;} else { mkpath $tcDir ;}
my $index = "$tcDir/index.pl"; my $ctr; my %tcExec ; my %tcDesc;

	open Fout, ">$index";
my $str=<<'EOF1'
#!_perl_
$tcName = "_testsuite1_";
if ($^O =~ /win32/i) { $_TAF = "c:"; } if ($^O =~ /linux/i) { $_TAF = "/tmp/var/www/cgi-bin"; } 
$tcDir = "$_TAF/$tcName";


if ($ARGV[0]) { 
	open Fout, ">$tcDir/_tcLogAppend.txt";
	if ($ARGV[0] == 1) { print "pass"; } # <<< plug in the test case 1 here e.g. print `index.pl 1` ; >>>
	if ($ARGV[0] == 2) { print "pass"; } # <<< plug in the test case 2 here e.g. print `index.pl 2`>>>
	if ($ARGV[0] == 3) { print "pass"; } # <<< plug in the test case 3 here e.g. print `index.pl 3`>>>
	if ($ARGV[0] == 4) { print "pass"; } # <<< plug in the test case 4 here e.g. print `index.pl 4`>>>
	if ($ARGV[0] == 5) { print "pass"; } # <<< plug in the test case 5 here e.g. print `index.pl 5`>>>
	if ($ARGV[0] == 6) { print "pass"; } # <<< plug in the test case 6 here e.g. print `index.pl 6`>>>
	close Fout;
} else {
print <<EOF;
1. Test case description 1 for < > \$ \% @ ( ) testing the function 1 --- Please modifyaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa _smoke_ _regression_
2. Test case description 2 for testing _smoketest__regressiontest_the function 2 --- Please modifybbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb _smoke_
3. Test case description 3 for testing _smoketest_the function 3 --- Please modifycddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd _regression_
4. Test case description 4 for testing _regressiontest_the function 4 --- Please modify _smoke_
5. Test case description 5 for testing _regressiontest_the function 5 --- Please modify
6. Test case description 6 for testing the function 6 --- Please modify
EOF
;
}

EOF1
;
$str =~ s/_testsuite1_/$tcName/g;
print Fout $str;
close Fout;
print " -> c:/iiiiiiii/_testsuite1_/index.pl";

EOF3
;

$str =~ s/_testsuite1_/$tcName/g; 

print Fout $str;
close Fout;
print " -> $index\n";
EOFIndex3
;

$str =~ s/_perl_/$perl_/ig;
my $fname ; 
if ($^O =~ /win32/i) { $fname = "$_TAF/bin/indexindexindex.pl";  }
if ($^O =~ /linux/i) { $fname = "/tmp/indexindexindex.pl";  }
if ( -e $fname) {;} else { open Fout, ">$fname"; print Fout $str; close Fout; }
}


sub createTS_B {	# $NofTCinTSTenplate is a global var
	my $cmd = $SvrProjName; my $tcDir = "c:/_TAF";
	if (-e $cmd) {;} else { mkdir $cmd; }
	mkpath $cmd;
	open Fout, "> $cmd/index.pl";
	my $tsNameTmp =	&getRoot($cmd);

my %tcDesc; my %tcExec;
for (my $i = 1; $i <= $NofTCinTSTemplate; $i++) {
	$tcExec{"$i"}="	if (\$ARGV[0] == $i) { print \&tc$i();} # <<< plug in the test case 1 here e.g. print `index.pl 1` ; >>>";
	$tcDesc{"$i"}=" Test case Desc for TC$i";
}

print Fout <<EOF;
#!/usr/bin/perl.exe
\$tcName = "$tsNameTmp";
 if (\$^O =~ /win32/i) { \$_TAF = "c:"; } if (\$^O =~ /linux/i) { \$_TAF = "/tmp/var/www/cgi-bin"; }
 \$tcDir = "\$_TAF/\$tcName";

 if (\$ARGV[0]) {
        open Fout, ">\$tcDir/_tcLogAppend.txt";

EOF

my $ctr = 1;
foreach my $each (sort {$a <=> $b} keys %tcExec) { print Fout "$tcExec{$each}\n"; }

print Fout <<EOF;
        close Fout;
        } else {

EOF
print Fout "\nprint<<EOF;\n";

   $ctr = 1;
foreach my $each (sort {$a <=> $b} keys %tcDesc) { print Fout $ctr++.". $tcDesc{$each}\n"; }

print Fout "EOF\n}\n";

for (my $i = 1; $i <= $NofTCinTSTemplate; $i++) { 
	print Fout "sub tc$i(){ return \"null\";} \n";
}


close Fout;
print " -> $cmd/index.pl\n";
}


sub createTC {
	my $tc_pl="tc.pl"; my $cmd=''; $cmd = shift; 
	if ($cmd =~ /^\s*$/) { print "Warning: createTC lack the cmd. \n"; exit; }
	if ($cmd !~ /^\s*cmd\s*=/i) { unshift @_, $cmd; } ;
	my $tcNameRoot = "@_"; my $sleep = 0;
	if ($cmd =~ /sleep\s*=\s*(\d+)/ ) { $sleep = $1; }
	my $tcName = &getTCName("@_");
	if( &detectTC($tcName) =~ /exists/ && ($cmd !~ /Over/i) && ( $overWriteTC =~ /n/i)) { # overwrite
		return "\n\tWarning $tcName already exist! (use -create;cmd=overwrite to overwrite)" ; } 
	else {
		mkpath($tcName);
		######################## tc.hta ##########################
	@_ = split "\/", $tcName;
	my $testsuite = $_[2]; my $testcase  = $_[3]; 
	my $now = &UnixDate(&DateCalc("now","+ 6 seconds") , "%H:%M:%S" );

	if ($testsuite) {;} else { print "[Info] \$testsuite is null. Note \$tcName = $tcName\n"; $testsuite ="";}
	if ($testcase ) {;} else { print "[Info] \$testcase  is null. Note \$tcName = $tcName\n"; $testcase = "";}

	my $tcNameIIS = $tcName; 
	if ($tcNameIIS) {;} else { print "[Info] \$tcName is null, \$tcNameIIS = $c.':/inetpub/wwwroot/'\n"; $tcNameIIS = $c.':/inetpub/wwwroot/';}
	&createFile( $tcNameIIS.'/'.'tc.hta', 
"
<html>
<title>$web_ui_title</title>
<head>
	<script language=\"JavaScript\">
		function RunFileHTTP(testsuite, testcase) {
//			alert(\"testsuite is \" + testsuite + \" testcase is \" + testcase );
			 WshShell = new ActiveXObject(\"WScript.Shell\");
		    	 cmd= '$c\\\\windows\\\\system32\\\\schtasks.exe /delete /tn TAF_'+ testsuite + '_' + testcase + ' /f'; 
			sleep (1000);
 //alert (cmd);
			 WshShell.Run(cmd, 1, false);
			 cmd = '$c\\\\windows\\\\system32\\\\schtasks.exe /create /TR \"$c\\\\$_TAF\\\\taf.pl testsuit='+testsuite+';testcaseExec='+testcase+';exec\" /TN TAF_'+testsuite+'_'+testcase+' /sc monthly /mo 1 /F'; 
			sleep (1000);
 //alert (cmd);
			 WshShell.Run(cmd, 1, false);
    		  	 cmd= '$c\\\\windows\\\\system32\\\\schtasks.exe /run /tn TAF_'+testsuite+'_'+testcase; 
			sleep (1000);
 //alert (cmd);
			 WshShell.Run(cmd, 1, false);
		}

	function sleep(milliseconds) {
	  var start = new Date().getTime();
	  for (var i = 0; i < 1e7; i++) {
	    if ((new Date().getTime() - start) > milliseconds){
	      break;
	    }
  	}
}


// <a onclick=\"RunFileHTTP(\'$testsuite\', \'$testcase\')\">Click this to run Run Program</button> <p>
	</script>
</head>
<body onLoad =\"RunFileHTTP(\'$testsuite\', \'$testcase\')\">Run $testsuite\/$testcase\/tc.hta</button> <p>
</body>
</html>
"
 			);

		######################## tc.hta ##########################

		if ($cmd =~ /\bPerf\b/i) {  					# PerformanceTC
		&createFile( $tcName.'/'.$tc_pl, "\$| = 1; print \"1234567.89\\n\"; sleep $sleep; ");
		} elsif ($cmd =~ /\bExpectedFail\b/i) { 				# ExpectedFailedTC
		&createFile( $tcName.'/'.$tc_pl, "\$| = 1; print \"Expected_f_a_i_l\\n\"; sleep $sleep; ");
		} elsif ($cmd =~ /\bexpF\b/i) { 					# ExpF for ExpectedFailedTC
		&createFile( $tcName.'/'.$tc_pl, "\$| = 1; print \"expF\\n\"; sleep $sleep; ");
		} elsif ($cmd =~ /\bbugF\b/i) { 					# ExpF for ExpectedFailedTC
		&createFile( $tcName.'/'.$tc_pl, "\$| = 1; print \"bugF\\n\"; sleep $sleep; ");
		} elsif ($cmd =~ /\bFail\b/i) { 					# FailedTC
		&createFile( $tcName.'/'.$tc_pl, "\$| = 1; print \"fail\\n\"; sleep $sleep; ");
		} elsif ($cmd =~ /\bcustomTC\b/i) { 				# CustomTC
			$cmd=~ /customTC:\s*(.+)\s*:customTC/; $cmd =$1; if (defined $cmd) {;} else { $cmd="";} $cmd =~ s/_space_/ /;
		if ($cmd =~ /ps1\b/) {									# Powershell plugin
			###########
			&createFile( $tcName.'/'.$tc_pl, 
"#!$perl_
use File::Copy;\n\$| = 1;
if (-e \"".&getDir($cmd)."\/_tcLogAppend.txt\"  ) {move(\"".&getDir($cmd)."\/_tcLogAppend.txt\" , \"".&getDir($cmd)."\/_tcLogAppend.bak\");}
if (-e \"".&getDir($cmd)."\/_tcLogAppend_.txt\" ) {move(\"".&getDir($cmd)."\/_tcLogAppend_.txt\", \"".&getDir($cmd)."\/_tcLogAppend_.bak\");}
if (-e \"".&getDir($cmd)."\/_tcLogAppend__.txt\" ) {move(\"".&getDir($cmd)."\/_tcLogAppend__.txt\", \"".&getDir($cmd)."\/_tcLogAppend__.bak\");}
print `powershell -executionpolicy unrestricted -file $cmd $ps1_args`;  # custom TC tc.pl 
if (-e \"".&getDir($cmd)."\/_tcLogAppend.txt\"  ) {move(\"".&getDir($cmd)."\/_tcLogAppend.txt\" , \"$tcName\/_tcLogAppend.txt\");}
if (-e \"".&getDir($cmd)."\/_tcLogAppend_.txt\" ) {move(\"".&getDir($cmd)."\/_tcLogAppend_.txt\", \"$tcName\/_tcLogAppend_.txt\");}
if (-e \"$externalLogName\") {copy(\"$externalLogName\", \"$tcName\/_tcLogAppend__.txt\");}
"
			);
			###########
			} elsif (($cmd =~ /pyanvil/i) &&( $tc_pl =~ /index_pyAnvil\.pl/i)) { 		# pyAnvil plugin
			###########
			&createFile( $tcName.'/'.$tc_pl, 
"#!$perl_
use File::Copy;\n\$| = 1;
if (-e \"".&getDir($cmd)."\/_tcLogAppend.txt\"  ) {move(\"".&getDir($cmd)."\/_tcLogAppend.txt\" , \"".&getDir($cmd)."\/_tcLogAppend.bak\");}
if (-e \"".&getDir($cmd)."\/_tcLogAppend_.txt\" ) {move(\"".&getDir($cmd)."\/_tcLogAppend_.txt\", \"".&getDir($cmd)."\/_tcLogAppend_.bak\");}
if (-e \"".&getDir($cmd)."\/_tcLogAppend__.txt\" ) {move(\"".&getDir($cmd)."\/_tcLogAppend__.txt\", \"".&getDir($cmd)."\/_tcLogAppend__.bak\");}
print `$perl_ $cmd $ps1_args $index_pl_arguments`; 	# tc.pl
if (-e \"".&getDir($cmd)."\/_tcLogAppend.txt\"  ) {move(\"".&getDir($cmd)."\/_tcLogAppend.txt\" , \"$tcName\/_tcLogAppend.txt\");}
if (-e \"".&getDir($cmd)."\/_tcLogAppend_.txt\" ) {move(\"".&getDir($cmd)."\/_tcLogAppend_.txt\", \"$tcName\/_tcLogAppend_.txt\");}
if (-e \"$externalLogName\") {copy(\"$externalLogName\", \"$tcName\/_tcLogAppend__.txt\");}
#if (-e \"".&getDir($cmd)."\/_tcLogAppend__.txt\" ) {move(\"".&getDir($cmd)."\/_tcLogAppend__.txt\", \"$tcName\/_tcLogAppend__.txt\");}
"
			);
			###########
			#} elsif  ($cmd =~ /\S+\.pl\s*/) { 						# perl plugin 
			} elsif  ($cmd =~ /\S+\.pl\b/) { 						# perl plugin 
			###########
			&createFile( $tcName.'/'.$tc_pl, 
"#!$perl_
use File::Copy;\n\$| = 1;
if (-e \"".&getDir($cmd)."\/_tcLogAppend.txt\"  ) {move(\"".&getDir($cmd)."\/_tcLogAppend.txt\" , \"".&getDir($cmd)."\/_tcLogAppend.bak\");}
if (-e \"".&getDir($cmd)."\/_tcLogAppend_.txt\" ) {move(\"".&getDir($cmd)."\/_tcLogAppend_.txt\", \"".&getDir($cmd)."\/_tcLogAppend_.bak\");}
if (-e \"".&getDir($cmd)."\/_tcLogAppend__.txt\" ) {move(\"".&getDir($cmd)."\/_tcLogAppend__.txt\", \"".&getDir($cmd)."\/_tcLogAppend__.bak\");}
print `$perl_ $cmd \@ARGV`;  # $c/$_TAF/index.pl
if (-e \"".&getDir($cmd)."\/_tcLogAppend.txt\"  ) {move(\"".&getDir($cmd)."\/_tcLogAppend.txt\" , \"$tcName\/_tcLogAppend.txt\");}
if (-e \"".&getDir($cmd)."\/_tcLogAppend_.txt\" ) {move(\"".&getDir($cmd)."\/_tcLogAppend_.txt\", \"$tcName\/_tcLogAppend_.txt\");}
if (-e \"$externalLogName\") {copy(\"$externalLogName\", \"$tcName\/_tcLogAppend__.txt\");}
#if (-e \"".&getDir($cmd)."\/_tcLogAppend__.txt\" ) {move(\"".&getDir($cmd)."\/_tcLogAppend__.txt\", \"$tcName\/_tcLogAppend__.txt\");}
"
			);
			###########
			} elsif ( $cmd =~ /taftestcase1/) {
			###########
			&createFile( $tcName.'/'.$tc_pl, 
"#!$perl_
\$| = 1; 
\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=_testcase2_${deli}propertyOP=set_property1_as_propertyValue1_doit_`;
\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=_testcase2_${deli}propertyOP=get_property1`;
if ( \$rst =~ /propertyValue1/) { print \"pass\\n\";} else {print \"fail\\n\";}
\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=_testcase2_${deli}propertyOP=set_property1_as_propertyValue0_doit_`;
"
			);
			###########
				;
			} elsif ( $cmd =~ /taftestcase2/) {
			###########
			&createFile( $tcName.'/'.$tc_pl, 
"#!$perl_
\$| = 1; 
\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=_testcase2_${deli}propertyOP=set_property1_as_propertyValue1A_doit_`;
\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=_testcase2_${deli}propertyOP=get_property1`;
if ( \$rst =~ /propertyValue1A/) { print \"pass\\n\";} else {print \"fail\\n\";}
\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=_testcase2_${deli}propertyOP=set_property1_as_propertyValue0_doit_`;
"
			);
			###########
				;
			} elsif ( $cmd =~ /taftestcase3/) {
			###########
			&createFile( $tcName.'/'.$tc_pl, 
"#!$perl_
\$| = 1; 
\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}propertyOP=set_property2_as_propertyValue2_doit_`;
\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=_testcase2_${deli}propertyOP=get_property2`;
\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}propertyOP=get_property2`;
if (( \$rst =~ /testcase1/) && (\$rst =~ /testcase2/) && (\$rst =~ /property2\\s*=\\s*propertyValue2/)) { print \"pass\\n\";} else {print \"fail\\n\";}
\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=_testcase2_${deli}propertyOP=set_property1_as_propertyValue0_doit_`;
"
			);
			###########
				;
			} elsif ( $cmd =~ /taftestcase4/) {
			###########
			&createFile( $tcName.'/'.$tc_pl, 
"#!$perl_
\$| = 1; 

\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}propertyOP=set_property2_as_propertyValue1_doit_`;
\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}propertyOP=set_property2_as_propertyValue2_doit_`;
\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}propertyOP=set_property2_as_propertyValue2A_doit_`;
\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}propertyOP=set_property1_as_propertyValue1A_doit_`;
\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=_testcase2_${deli}printTcFilters`;
if (( \$rst =~ /property1\\s+propertyValue1A/) && (\$rst =~ /property2\\s+propertyValue2A/))  { print \"pass\\n\";} else {print \"fail\\n\";}

\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=_testcase2_${deli}propertyOP=set_property1_as_propertyValue0_doit_`;
\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=_testcase2_${deli}propertyOP=set_property2_as_propertyValue0_doit_`;
"
			);
			###########
				;
			} elsif ( $cmd =~ /powershellTC/) {
			###########
			&createFile( $tcName.'/'.$tc_pl, 
"
"
			);
			###########
				;
			} else {
				;
			}
		} else {
			 &createFile( $tcName.'/'.$tc_pl, "\$| = 1; print \"pass\\n\"; sleep $sleep; ");
		}
        	&createPropertyTemplate($tcName);

		my $tmp =<<EOF;
open Fout, '>$tcName/_tcLogAppend.txt';
#!/usr/bin/perl
print Fout "* This is the content of TC log file\\n";
print Fout "* TC Log can has URL (file:///) pointed to <a href=\\"file:////$c/$_TAF/_blabla.html\\" >File Archieve</a> _url_line_ \\n";
print Fout "* TC Log can has URL (file:///) pointed to <a href=\\"file:////$c/$_TAF/_testsuite2_/testcase0002/_tcLog.html\\" >Another TC's Log _url_line_ </a>\\n";
print Fout "* TC Log can has URL (file:///) pointed to <a href=\\"file:////$c/$_TAF/index.htm\\" >TAF</a> _url_line_ \\n";
print Fout "* TC Log can has URL (http:///) pointed to <a href=\\"$urlHttp/_blabla.html\\" >File Archieve</a> _url_line_ \\n";
print Fout "* TC Log can has URL (http:///) pointed to <a href=\\"$urlHttp/_testsuite2_/testcase0002/_tcLog.html\\" >Another TC's Log _url_line_ </a>\\n";
print Fout "* TC Log can has URL (http:///) pointed to <a href=\\"$urlHttp/index.htm\\" >TAF</a> _url_line_ \\n";
print Fout "* TC Log can has special characters like Dollor \\\$, Percentage \\\% AT \\\@ \\n";
print Fout "* TC Log can display (add _url_line_ in the line) URL http://localhost$http_port   _ url_line_line	_url_line_ (_url_line_ indicates a real url. Not translation will be done.)\\n";
print Fout "* TC Log can parse log (*.txt) in log $c/$_TAF/_testLog.txt and add its Http and File links.\\n";
print Fout "* TC Log can parse log (*.txt) in log $c/$_TAF/_testLog.htm and add its Http and File links.\\n";
close Fout;
exit;
EOF
		if (($cmd =~ /genLog/i) || ($cmd =~ /addLog/i)) {&appendtoFile( $tcName.'/'.$tc_pl, $tmp) ; undef $tmp; }
	$tcName =~ s/\\\\/\\/g; # todo \\

	return "is created";
	}
}


sub execTC {
	my $tcName = &getTCName(@_); my $timeStart = &getDate(); my $rst=''			; 
	if  ( -e "$tcName/tc.pl" ) {
		my $cmd     = "$tcName/tc.pl"; $rst     = `$cmd`; my $timeEnd= &getDate()	; 
	       $rst =~ /(pass|fail|bugF|expF|todo|[\d|.]+)$/i; $rst = $1; 
	       if ($rst) {;} else {$rst = "null";} 
	       if (($rst =~ /Expected_f_a_i_l/i) || ($rst =~ /null/i)) { sleep 10; }
	       $rst =~ s/^\s*0+//g;
	       my $rstStr = sprintf "%20s|%10s|%s", "tcRunResult",$rst , $timeStart		;
	       $rstStr .= "|"; $rstStr .= "$timeEnd"; $rstStr .= "|"; $rstStr .= "0:0:0:0s"; $rstStr .= "|"; 
	       if ( $rst =~ /^\s*[\d+|\.]+\s*$/ ) { $rstStr .= "Performance Test ($rst) "; } 
	       else { $rstStr .= "Functional Test ($rst) "; } 
	       $rstStr .= '|comment2'; 
	       &addProperty(&getTCName($tcName), "add=$rstStr");
	       return $rst;
       } else {
	       return "tcName: $tcName doesn't exist.\n";
       }
}

sub dumyTC_v0 {	# create a dumy tc result 
	my $tcName = &getTCName(@_);
	my $timeStart = &getDate(); my $rst=''; 
	if  ( -e "$tcName/$tc_pl" ) { 
		my $cmd     = "$tcName/$tc_pl"; $rst = "dump"; 
		my $timeEnd= &getDate(); 
	       $rst = "dumy";
	       if ($rst) {;} else {$rst = "null";}
	       my $rstStr = sprintf "%20s|%10s|%s", "tcRunResult",$rst , $timeStart;
	       $rstStr .= "|"; $rstStr .= "$timeEnd"; $rstStr .= "|"; $rstStr .= "0:0:0:0s";
	       $rstStr .= "|"; 
	       $rstStr .= "Functional Test ($rst) ";
	       $rstStr .= '|'.$tcComment2; 
	       &addProperty(&getTCName($tcName), "add=$rstStr");
	       return $rst;
       } else {
		return "tcName: $tcName doesn't exist.\n";
       }
}

#### 

sub runBackground {
	my $cmd = shift;
print "Starting backgroun job \n";
my @threads;
for ( my $count = 1; $count <= 1; $count++) {
        my $t = threads->new(\&background, $cmd);
         push(@threads,$t);
}
foreach (@threads) { my $num = $_->join; print "done with $num\n"; }
}

sub background { my $cmd = shift; my $rst = system $cmd; }



####### back ground ##########
#
#
#
#use strict;
#use warnings;
#use threads;
#use threads::shared;
#
#my $cmd = "start perl c:/_TAF/ee.pl ";
#
#&runBackground($cmd);
#
#sub runBackground {
#	my $cmd = shift;
#print "Starting backgroun job \n";
#my @threads;
#for ( my $count = 1; $count <= 1; $count++) {
#        my $t = threads->new(\&background, $cmd);
#         push(@threads,$t);
#}
#foreach (@threads) { my $num = $_->join; print "done with $num\n"; }
#}
#
#sub background { my $cmd = shift; my $rst = exec $cmd; }

####### back ground ##########






sub markTC_ {
	my $tcName = &getTCName(@_);
	my $timeStart = &getDate(); my $rst=''; 
	if  ( -e "$tcName/$tc_pl" ) { 
		my $cmd     = "$tcName/$tc_pl"; $rst = "mark"; # $rst     = `$cmd`; 
		my $timeEnd= &getDate(); 
	       $rst =~ /(mark|pass|fail|bugF|expF|todo|[\d|.]+)$/i; $rst = $1; 
	       if ($rst) {;} else {$rst = "null";}
	       $rst =~ s/^\s*0+//g;
	       my $rstStr = sprintf "%20s|%10s|%s", "tcRunResult",$rst , $timeStart;
	       $rstStr .= "|"; $rstStr .= "$timeEnd"; $rstStr .= "|"; $rstStr .= "0:0:0:0s";
	       $rstStr .= "|"; 
	       if ( $rst =~ /^\s*[\d+|\.]+\s*$/ ) {
		$rstStr .= "Performance Test ($rst) ";
	       } else {
	       $rstStr .= "Functional Test ($rst) ";
	       } 
	       $rstStr .= '|'.$tcComment2; 
	       &addProperty(&getTCName($tcName), "add=$rstStr");
	       return $rst;
       } else {
		return "tcName: $tcName doesn't exist.\n";
       }
}


sub execTC_ {	# used sub 
	my $tcName = &getTCName(@_);
	my $timeStart = &getDate(); my $rst=''; 

$simulatedResults = "$simulatedResults"; 
my @_simulatedResults = split //, $simulatedResults;	
$tcName =~ /testcase(\d\d\d\d)/;
my $tcN = $1;  $tcN =~ s/^\s*0*//g;
my $tcNRst;
if    (($_simulatedResults[$tcN]) && ($_simulatedResults[$tcN] =~ /p/)) { $tcNRst = "pass";} 
elsif (($_simulatedResults[$tcN]) && ($_simulatedResults[$tcN] =~ /f/)) { $tcNRst = "fail";} 
elsif (($_simulatedResults[$tcN]) && ($_simulatedResults[$tcN] =~ /n/)) { $tcNRst = "null";} 
elsif (($_simulatedResults[$tcN]) && ($_simulatedResults[$tcN] =~ /b/)) { $tcNRst = "bugF";} 
elsif (($_simulatedResults[$tcN]) && ($_simulatedResults[$tcN] =~ /d/)) { $tcNRst = "dumy";} 
elsif (($_simulatedResults[$tcN]) && ($_simulatedResults[$tcN] =~ /t/)) { $tcNRst = "task";} 
elsif (($_simulatedResults[$tcN]) && ($_simulatedResults[$tcN] =~ /m/)) { $tcNRst = "mark";} 

	if  ( -e "$tcName/$tc_pl" ) { 
		if ( -e "$tcName/$tc_args") {
			open File_tc_args, "$tcName/$tc_args";
				@_ = <File_tc_args>;
				$index_pl_arguments .= "@_";
				$index_pl_arguments =~ s/\n|\r/ /g;
			close File_tc_args;
		}

		my $cmd     = "$perl_ $tcName/$tc_pl $index_pl_arguments"; 

		my @manual_results = split /,/, $manual_results;
		my  $tcNs = $tcN - 1;
	
		if (($#manual_results >= $tcNs) && ($manual_results[$tcNs] !~ /^\s*$/i)){
			$rst = $manual_results[$tcNs]; 
		} elsif ($manual_result !~ /^\s*$/) { ; $rst = $manual_result; 
		} else { 
			my $tsName = &getTSName($tcName); 				# my $blocking_time = 5000;  # in sec
			if ( -e  "$tsName/_no_blocking.txt" ) {				# non-blocking TC
				$blocking_time = &readFile("$tsName/_no_blocking.txt"); 	
				my $rst_=	&tafExec($cmd, $blocking_time); 			# in seconds
			 	$rst_=	&tafExec($cmd, $blocking_time); 			# in seconds
			} elsif ( -e  "$tcName/_no_blocking.txt" ) {			# non-blocking TC
				$blocking_time = &readFile("$tcName/_no_blocking.txt"); 	
				my $rst_ = &tafExec($cmd, $blocking_time); 			# in seconds
			} else {
				$rst     = `$cmd`; $tc_stdout= $rst;
			}
		
		}
		my $comment1 =""; $comment2 = "";
		if ($comment2 =~ /^\s*$/) { $comment2 = "placeHolder4comment2";} else { $comment1 = "$comment2"; }
		my $timeEnd= &getDate(); 
		if (defined $_simulatedResults[$tcN] ) { $rst = $tcNRst; $timeEnd = DateCalc(&getDate(), " in 10 seconds"); }

	       	$rst =~ /(pass|fail|todo|bugF|expF|expected_f_a_i_l|task|[\d|.]+)/i; $rst = $1; 
	       	if ($rst) { if ($rst =~ /expected_f_a_i_l/) { $rst = "expF"; } ;} else {$rst = "null";}
	       	$rst =~ s/^\s*0+//g;
	       	my $rstStr = sprintf "%20s|%10s|%s", "tcRunResult",$rst , $timeStart; $rstStr .= "|"; $rstStr .= "$timeEnd"; $rstStr .= "|"; $rstStr .= "0:0:0:0s"; $rstStr .= "|"; 
	       	if ( $rst =~ /^\s*[\d+|\.]+\s*$/ ) { $rstStr .= "Performance Test ($rst) "; } elsif ( $rst =~ /task/i ) { $rstStr .= "Task "; } else { $rstStr .= "Functional Test ($rst) "; } 
	       	$rstStr .= "$comment1|$comment2"; 		# fix (fail) placeHolder4comment2|placeHolder4comment2 issue for tcReportHistory
	       	&addProperty(&getTCName($tcName), "add=$rstStr");
	       	return $rst;
       } else {
		return "tcName: $tcName doesn't exist.\n";
       }
}

#######             &tafExec("e.pl", 5);
#
#


sub tafExec {
	my $cmd 	= shift if @_;
	my $timeout 	= shift if @_;
	if ($timeout =~ /^\s*$/) { $timeout = $blocking_time; }
eval {
    local $SIG{ALRM} 	= sub { die "alarm\n" }; # NB: \n required
    alarm $timeout;
    system("$cmd");
    alarm 0;
};
if ($@) { 	# timed out
    die unless $@ eq "alarm\n";   # propagate unexpected errors
}
else { 		# didn't
}

}

#######

####
sub set_blocking {
	if ($SvrTCNamePattern =~ /\*/) {
	&createFile (&getTSName_TAF($SvrProjName)."/_no_blocking.txt", $blocking_time);
	} else {
	&createFile (&getTSName_TAF($SvrProjName)."/$SvrTCNamePattern/_no_blocking.txt", $blocking_time);
	}
}
sub unset_blocking {
	if ($SvrTCNamePattern =~ /\*/) {
	 unlink &getTSName_TAF($SvrProjName)."/_no_blocking.txt";
	} else {
	 unlink &getTSName_TAF($SvrProjName)."/$SvrTCNamePattern/_no_blocking.txt";
	}
}
####

sub execTAFTestbed {
		print "Start  ***testbed*** ($c/$_TAF/taf.[bat|sh] for ininital installation.  Remove testbed script ($c/$_TAF/taf_delete.[bat|sh])\n";
		system 	"$c/$_TAF/taf.bat" if ($^O =~ /win32/i);
		system 	"$c/$_TAF/taf.sh " if ($^O =~ /linux/i);
		print "Finish ***testbed*** ($c/$_TAF/taf.[bat|sh] for ininital installation.  Remove testbed script ($c/$_TAF/taf_delete.[bat|sh])\n";
		1;
}

sub deleteTAFTestbed {
		print "Remove ***testbed*** ($c/$_TAF/taf.[bat|sh] for ininital installation.  Remove testbed script ($c/$_TAF/taf_delete.[bat|sh])\n";
		my $rst = `$c/$_TAF/taf_delete.bat` if ($^O =~ /win32/i);
		   $rst = `$c/$_TAF/taf_delete.sh` if ($^O =~ /linux/i);
		print "Finish ***testbed*** ($c/$_TAF/taf.[bat|sh] for ininital installation.  Remove testbed script ($c/$_TAF/taf_delete.[bat|sh])\n";
		print $rst;
		1;
}


sub dumyTC_ {
	my $tcName = ""; $tcName = shift if @_; # ;   = &getTCName(@_);
	my $timeStart = &getDate(); my $rst=''; 

$simulatedResults = "$simulatedResults"; 
my @_simulatedResults = split //, $simulatedResults;	
if ($tcName =~ /^\s*$/) { $tcName = "testcase9999"; }	 # Max numbe TC is 9999
$tcName =~ /testcase(\d\d\d\d)/;
my $tcN = $1;  $tcN =~ s/^\s*0*//g;
my $tcNRst;
if    (($_simulatedResults[$tcN]) && ($_simulatedResults[$tcN] =~ /p/)) { $tcNRst = "pass";} 
elsif (($_simulatedResults[$tcN]) && ($_simulatedResults[$tcN] =~ /f/)) { $tcNRst = "fail";} 
elsif (($_simulatedResults[$tcN]) && ($_simulatedResults[$tcN] =~ /n/)) { $tcNRst = "null";} 
elsif (($_simulatedResults[$tcN]) && ($_simulatedResults[$tcN] =~ /b/)) { $tcNRst = "bugF";} 
elsif (($_simulatedResults[$tcN]) && ($_simulatedResults[$tcN] =~ /d/)) { $tcNRst = "dumy";} 
elsif (($_simulatedResults[$tcN]) && ($_simulatedResults[$tcN] =~ /t/)) { $tcNRst = "task";} 
elsif (($_simulatedResults[$tcN]) && ($_simulatedResults[$tcN] =~ /m/)) { $tcNRst = "mark";} 


	if  ( -e "$tcName/$tc_pl" ) { 
		#my $cmd     = "$perl_ $tcName/$tc_pl"; 
 		my $cmd     = "$perl_ $tcName/$tc_pl $index_pl_arguments"; 
		#$rst     = `$cmd`; 
		$rst = "dumy";
		my $timeEnd= &getDate(); 
 		if (defined $_simulatedResults[$tcN] ) { $rst = $tcNRst; $timeEnd = DateCalc(&getDate(), " in 10 seconds"); }
 
 	       	$rst =~ /(pass|fail|todo|bugF|expF|expected_f_a_i_l|task|[\d|.]+)$/i; $rst = $1; 
 	       	if ($rst) { if ($rst =~ /expected_f_a_i_l/) { $rst = "expF"; } ;} else {$rst = "null";}
 	       	$rst =~ s/^\s*0+//g;
 		#### 
		$rst = "dumy";
	       	my $rstStr = sprintf "%20s|%10s|%s", "tcRunResult",$rst , $timeStart; $rstStr .= "|"; $rstStr .= "$timeEnd"; $rstStr .= "|"; $rstStr .= "0:0:0:0s"; $rstStr .= "|"; 
	       	if ( $rst =~ /^\s*[\d+|\.]+\s*$/ ) { $rstStr .= "Performance Test ($rst) "; } elsif ( $rst =~ /task/i ) { $rstStr .= "Task "; } else { $rstStr .= "Functional Test ($rst) "; } 
	       	$rstStr .= '|comment2PlaceHolder'; 
	       	&addProperty(&getTCName($tcName), "add=$rstStr");
	       	return $rst;
       } else {
		return "tcName: $tcName doesn't exist.\n";
       }
}

sub mapTC {
	my $tcName = &getTCName(@_);
	my $timeStart = &getDate(); my $rst=''; 
	if  ( -e "$tcName/$tc_pl" ) { 
	       if (-e "$c/$_TAF/$SvrProjName/_tcMap.txt") {
		       my $tcName_ = &getTCName($tcName); $tcName_ =~ s/$c\/$_TAF\///i;
			&mergethProperty($tcName_,"$c/$_TAF/$SvrProjName/_tcMap.txt");
		       }
	        return $rst;
       } else {
		return "tcName: $tcName doesn't exist.\n";
       }
}

sub mergethProperty {
my $thPropertyString ="_CRB_/AppBuildpath/_automated_testsuites_/_testsuite_pl/testcase0002"; $thPropertyString= shift if @_; 
my $tcMapFName = "_tcMap.txt"; $tcMapFName = shift if @_;
my $propertyName = "tcRunResult";my  %records; my %record_out; my $tag = "tag"; my $content_out=""; my $parent=""; my $child;
open Fin, $tcMapFName;
 	while ($_=<Fin>) { chop;
  		if ($_ =~ /$thPropertyString/) { 
			my $thPropertyFName;
			$content_out = "";
			 ($parent, $child) = split (/\s*=>\s*/, $_);
			if (($parent !~ /^\s*$/) && ($child !~ /^\s*$/)) {	
			$thPropertyFName=$parent."/thProperty.txt"; if ($thPropertyFName !~ /$c\/$_TAF/) {$thPropertyFName =~ s/$c/$c\/$_TAF/;} # TS->TAF TS conversion 
			open Fin1, $thPropertyFName or die "Can't open $thPropertyFName:$!";  
			while ($_ = <Fin1>) { 
				if ($_ =~ /$tags/) { $tag=$1;}	# todo
				if ($_ =~ /^\s*$propertyName\s*\|/) { @_ = split (/\|/, $_); $records{$_[2]}=$_; } 
				else { $content_out = $content_out.$_; }
			} 
			close Fin1;
			$thPropertyFName=$child."/thProperty.txt";    if ($thPropertyFName !~ /$c\/$_TAF/){ $thPropertyFName =~ s/$c/$c\/$_TAF/;} # TS->TAF TS conversion 
			if ( -e $thPropertyFName ) { ; } else { return ;} 
			open Fin1, "$thPropertyFName" or die "Can't open $thPropertyFName:$!";  
			while ($_ = <Fin1>) { 
				if ($_ =~ /$tags/i) { $tag=$1;}	# todo
				if ($_ =~ /^\s*$propertyName\s*\|/) { $_ =~ s/Comment2\s*$/$tag/i; @_ = split (/\|/, $_); $records{$_[2]}=$_; 
				} 
			} 
			close Fin1;
			}
		}
 	} 
close Fin;
	if (-e $parent) {
		open Fout1, ">$parent/thProperty.txt_"; 
		print Fout1 $content_out; 
		foreach my $each (sort keys %records) {print Fout1 "$records{$each}\n"; } 
		close Fout1;
		&copyFile("$parent/thProperty.txt_", "$parent/thProperty.txt");
	}

}
sub deleteTC {
	if ($_[1]) { $SvrProjName = $_[1];}
	if ($_[2]) { $SvrDrive = $_[2];}
	my $tcName = &getTCName(@_);
#### 	todo	backup deleted TCs. move ($tcName, $tcName."_".  &UnixDate( "now", "%m_%d_%Y_%H_%M_%S_%Z" ) ."_backup");
	rmtree $tcName;
	return "$tcName is deleted (saved as *_backup)";
}

sub detectTC {
	if ($_[1]) { $SvrProjName = $_[1];}
	if ($_[2]) { $SvrDrive = $_[2];}
	my $tcName = '';
	$tcName = &getTCName(@_);
     	if (-e "$tcName/tc.pl" ) { return  "exists"; } else { return 'does not exist';}
}

sub getTSName {
	my $tsname = shift;
	$tsname =~ s/\/testcase\d+.+//g;
	return $tsname;
}
sub getTSName_dir {
	my $SvrTCNameStr = shift;
	$SvrTCNameStr =~ s/^$c\///i;
	return $SvrTCNameStr;
}
sub getTSName_TAF {
	my $SvrTCNameStr = shift;
	$SvrTCNameStr =~ s/^$c\///i;
	return "$c/$_TAF/$SvrTCNameStr";
}

sub getTSName_Root {
	my $return="";
	my $SvrTCNameStr = shift;
	@_ = split /\\|\//, $SvrTCNameStr; 
	for (my $i = 0; $i < $#_; $i++ ) {
		$return .=$_[$i]."/";
	}
	$return =~ s/\/\s*$//g;
	return $return;
}

sub getTCName {
	my $SvrProjNameTmp; my $SvrDriveTmp; my $SvrTCNameTmp="" ;  
	$SvrTCNameTmp = shift if @_; 
	if ($notUsegetTCName==1) 	{  return   $SvrTCName;				}	# Do nothing
	if ($SvrTCNameTmp) 		{;} else {  $SvrTCNameTmp = $SvrTCName; 		}  	# get current SvrTCName 
	if ($SvrProjNameTmp) 		{;} else {  $SvrProjNameTmp = $SvrProjName;	}  	# do nothing
	if ($SvrDriveTmp) 		{;} else {  $SvrDriveTmp = $SvrDrive;		}  	# do nothing
	if ($SvrTCNameTmp =~ /[a-z]:/i) {   return   $SvrTCNameTmp;			}	# remove c:
	elsif ($SvrTCNameTmp =~ /$c/i)  {   return   $SvrTCNameTmp;			}	# remove c:
	else { return ($SvrDriveTmp.'/'.$SvrProjNameTmp.'/'.$SvrTCNameTmp) ; 		}	# c:/testcase/testsuite
}

sub getTCNameStr{
	my $SvrTCNameStr = shift;
	@_ = split /\\|\//, $SvrTCNameStr; 
	pop;
}

sub getTCName_TAF_no {
	my $SvrTCNameStr = shift;
	$SvrTCNameStr =~ s/$c\/$_TAF/$c/i;
	return $SvrTCNameStr;
}
sub getTCName_TAF {
	my $SvrTCNameStr = shift;
	$SvrTCNameStr =~ s/^(\w:)/$1\/$_TAF/i;
	return $SvrTCNameStr;
}
sub getTCName_C {
	my $SvrTCNameStr = shift;
	if ($SvrTCNameStr =~ /^$c/i) {;} 
	else { $SvrTCNameStr = "$c/$SvrTCNameStr"; }
	return $SvrTCNameStr;
}
sub getTCName_C_no {		# todo: research for linux porting 
	my $SvrTCNameStr = shift;
	#if ($SvrTCNameStr =~ /^\s*$c/i) { $SvrTCNameStr =~ s/^\s*$c\///; }
	$SvrTCNameStr =~ s/^\s*\w:[\\|\/]//g;
	$SvrTCNameStr =~ s/^\s*\w:[\\|\/]//g;
	$SvrTCNameStr =~ s/^\s*\w:[\\|\/]//g;
	$SvrTCNameStr =~ s/^\s*\w:[\\|\/]//g;
	return $SvrTCNameStr;
}
sub getTCName_C_no_old {
	my $SvrTCNameStr = shift;
	if ($SvrTCNameStr =~ /^\s*$c/i) { $SvrTCNameStr =~ s/^\s*$c\///; }
	$SvrTCNameStr =~ s/^\s*\w:[\\|\/]//g;
	return $SvrTCNameStr;
}

################################################################################
#	Subroutine Name : processProperty
#		Function: wrapper for property management functions
#	Input Parameters: PropertyOP
#	Output/Returns  : tcName and propertyOp
################################################################################
sub processProperty {
	shift; my $tcname = shift; my $propertyOP = shift; my $rst=""; my $prMsg=0;
	#### PropertyOp String Translation
	$propertyOP =~ s/^\s*propertyOp\s*=//g; $propertyOP =~ s/^\s*po\s*=//g; $propertyOP =~ s/_doit_//g;
	if ($propertyOP =~ /^\s*_?modify_(.+)_(as|eq)_(.+)/) { $propertyOP = "add_eq_$1_column_$3"; }
	if ($propertyOP =~ /^\s*_?set_(.+)_(as|eq)_(.+)/) { $propertyOP = "add_eq_$1_column_$3"; }
	elsif ($propertyOP =~ /^\s*_?get_history(.+)/)  { $propertyOP = "get_history$1"; }
	elsif ($propertyOP =~ /^\s*_?list_history(.+)/) { $propertyOP = "get_history$1"; }

	elsif ($propertyOP =~ /^\s*_?get_latest(.+)/)  { $propertyOP = "get_latest$1"; }
	elsif ($propertyOP =~ /^\s*_?list_latest(.+)/) { $propertyOP = "get_latest$1"; }

	elsif ($propertyOP =~ /^\s*_?get_last(.+)/)  { $propertyOP = "get_last$1"; }
	elsif ($propertyOP =~ /^\s*_?list_last(.+)/) { $propertyOP = "get_last$1"; }

	elsif ($propertyOP =~ /^\s*_?get_(.+)/) { $propertyOP = "get_$1"; }
	elsif ($propertyOP =~ /^\s*_?list_(.+)/) { $propertyOP = "get_$1"; }
	#### PropertyOp String Translation
	if (defined $propertyOP) {;} else { $rst = "Warning: wrong format. Correct format is -add=prop:value"; return $rst; }
	if ($propertyOP =~ /;\s*pr2Screen\s*/) { $prMsg = 1; $propertyOP =~ s/;\s*pr2Screen\s*(=\s*\d*\s*)?//; }
	if ( $propertyOP =~ /^\s*add/i ) {
                $rst = &addProperty( &getTCName($tcname), $propertyOP );
        }
        elsif ( $propertyOP =~ /^\s*del/i ) {
                $rst = &deleteProperty( &getTCName($tcname), $propertyOP );
        }
        elsif ( $propertyOP =~ /^\s*reset/i ) {
                ;
        }    # copy to a backup and create a property file
        elsif ( $propertyOP =~ /^\s*modify/i ) {
                $rst = &modifyProperty( &getTCName($tcname), $propertyOP );
        }
        elsif ( $propertyOP =~ /^\s*get_history|list_history_/i ) {
		$propertyOP =~ s/^\s*get_history_+\s*//g; $propertyOP =~ s/^\s*list_history_+\s*//g;
		$rst = &getProperties(&getTCName($tcname), $propertyOP, "history" );
 	}
        elsif ( $propertyOP =~ /^\s*get_latest|list_latest/i ) {
		$propertyOP =~ s/^\s*get_latest_+\s*//g; $propertyOP =~ s/^\s*list_latest_+\s*//g;
		$rst = &getProperties(&getTCName($tcname), $propertyOP, "latest" );
 	}
        elsif ( $propertyOP =~ /^\s*get_last|list_last/i ) {
		$propertyOP =~ s/^\s*get_last_+\s*//g; $propertyOP =~ s/^\s*list_last_+\s*//g;
		$rst = &getProperties(&getTCName($tcname), $propertyOP, "last" );
 	}
        elsif ( $propertyOP =~ /^\s*get|list/i ) {
		    $propertyOP =~ s/^\s*get_\s*//g; $propertyOP =~ s/^\s*list_\s*//g;
		if ($propertyOP =~ /;/ ) {
		    @_ = split /;/, $propertyOP ;
		    $rst = &getProperties(&getTCName($tcname), $_[0], $_[1]);
	    	} else {
		    $rst = &getProperties(&getTCName($tcname), $propertyOP, "value" );
		}
       }
       elsif ( $propertyOP =~ /^\s*create/i ) {
        	$rst = &createPropertyTemplate($tcname);
       }
       elsif ( $propertyOP =~ /^\s*_all_update_properties/i ) {
		 $rst = &updateProperties(&getTCName($tcname), $propertyOP, "_all_" );
		 print $rst;
       }
       elsif ( $propertyOP =~ /^\s*_all_syncProperties/i ) {
		 $rst = &syncProperties(&getTCName($tcname), $propertyOP, "_all_" );
		 print $rst;
       }
       elsif ( $propertyOP =~ /^\s*_all_syncTSDefinition/i ) {
		 $rst = &syncTSDefinition(&getTCName($tcname), $propertyOP, "_all_" );
		 print $rst;
       }
       elsif ( $propertyOP =~ /^\s*_all_4_display/i ) {
		 $rst = &getProperties(&getTCName($tcname), $propertyOP, "_all_" );
		 print $rst;
       }
       elsif ( $propertyOP =~ /^\s*display_msg/i ) {
		 print $message;
       }
       elsif ( $propertyOP =~ /^\s*display_note/i ) {
	       	if  ( -e  "$c/$_TAF/$SvrProjName/$SvrTCNamePattern/tc_note.txt"  ) {
		open Fin_note, "$c/$_TAF/$SvrProjName/$SvrTCNamePattern/tc_note.txt" ; while($_ = <Fin_note>) { print $_; } close Fin_note;
		} else { print "INFO: $c/$_TAF/$SvrProjName/$SvrTCNamePattern/tc_note.txt doens't exit. - will be created by tc.cgi later. \n";}
       }
       elsif ( $propertyOP =~ /^\s*display_executor/i ) {
	       	if  ( -e  "$c/$_TAF/$SvrProjName/$SvrTCNamePattern/tc_exec.txt"  ) {
		open Fin_exec, "$c/$_TAF/$SvrProjName/$SvrTCNamePattern/tc_exec.txt" ; while($_ = <Fin_exec>) { print $_; } close Fin_exec;
		} else { print "INFO: $c/$_TAF/$SvrProjName/$SvrTCNamePattern/tc_exec.txt doens't exit. - will be created by tc.cgi later. \n";}
       }
       elsif ( $propertyOP =~ /^\s*display_arguments/i ) {
	       	if  ( -e  "$c/$_TAF/$SvrProjName/$SvrTCNamePattern/tc_args.txt"  ) {
		open Fin_note, "$c/$_TAF/$SvrProjName/$SvrTCNamePattern/tc_args.txt" ; while($_ = <Fin_note>) { print $_; } close Fin_note;
		} else { print "INFO: $c/$_TAF/$SvrProjName/$SvrTCNamePattern/tc_args.txt doens't exit. - will be created by tc.cgi later. \n";}
       }
       elsif ( $propertyOP =~ /^\s*display_validator/i ) {
	       	if  ( -e  "$c/$_TAF/$SvrProjName/$SvrTCNamePattern/tc_vali.txt"  ) {
		open Fin_note, "$c/$_TAF/$SvrProjName/$SvrTCNamePattern/tc_vali.txt" ; while($_ = <Fin_note>) { print $_; } close Fin_note;
		} else { print "INFO: $c/$_TAF/$SvrProjName/$SvrTCNamePattern/tc_vali.txt doens't exit. - will be created by tc.cgi later. \n";}
       }
       elsif ( $propertyOP =~ /^\s*sync_definition/i ) {
	       	if  ( -e  "$c/$_TAF/$SvrProjName/$SvrTCNamePattern/tc_def.txt"  ) {
		open Fin_note, "$c/$_TAF/$SvrProjName/$SvrTCNamePattern/tc_def.txt" ; while($_ = <Fin_note>) { print $_; } close Fin_note;
		} else { print "INFO: $c/$_TAF/$SvrProjName/$SvrTCNamePattern/tc_def.txt doens't exit. - will be created by tc.cgi later. \n";}
       }
       elsif ( $propertyOP =~ /^\s*display_definition/i ) {
	       	if  ( -e  "$c/$_TAF/$SvrProjName/$SvrTCNamePattern/index.txt"  ) {
		open Fin_note, "$c/$_TAF/$SvrProjName/$SvrTCNamePattern/index.txt" ; while($_ = <Fin_note>) { print $_; } close Fin_note;
		} else { print "INFO: $c/$_TAF/$SvrProjName/$SvrTCNamePattern/index.txt doens't exit. - will be created by tc.cgi later. \n";}
       }
       elsif ( $propertyOP =~ /^\s*match|filter/i ) {
		if ($propertyOP =~ s/^\s*match\s*_//g) {
		    $propertyOP =~ /\s*(\S+)\s*_(as|eq)_\s*(\S+)\s*/; 
        	    $rst = &matchProperty($1, $3, $tcname);
	    }
       } else {
	    	    $rst = sprintf "ProcessProperty (no match OP) %40s %20s", $tcname, $propertyOP;
       }
       # $propertyOp = "";		# bug fix Execution_24_7 hangs
	    if (($rst) && ($rst =~ /^\s*$/)) { $rst = "_noMatchedPropertyOP_";}
	    if ((defined $prMsg) && ($prMsg ==1)) { print  $rst;}
	    if ($rst) { return $rst; } else { return "doen't exist"; }
}

################################################################################
#	Subroutine Name : matchProperties
#		Function: return true/false 
#	Input Parameters: Property Name in regExp  
#	Output/Returns  : True/False
################################################################################
sub matchProperty { # &matchProperty("QAOwner","ywang", "TC_tc1");
	my $propertyName = ".*"; my $propertyPattern = ".*"; my %array; my $tcname = "TC_tc1";
	$propertyName = shift if (@_);
	$propertyPattern= shift if (@_);
	$tcname = shift if (@_);


	 if (&getProperties(&getTCName($tcname), "" ) =~ /info:There is no/ ) {
		 return "False";
	 }

	foreach my $each (split /\n/,  &getProperties(&getTCName($tcname), "", "_all_")) {
		$each =~ /^\s*(\w+)\s+(\w+)\s*$/;
		$array {$1}  = $2;
	}
	foreach my $each (sort keys %array) {
		if (($array{$each} =~ /$propertyPattern/) && ( $each =~ /$propertyName/)) { 
			 return "True\n$each:$array{$each}"; }
	}
	return 'False';
}

################################################################################
#	Subroutine Name : updateProperties
################################################################################
sub syncTCDefinition() { 	# Input: SvrProjName, $SvrTCNamePattern 
	    	my %array; my $returnValue;
		my $tcname 		; $tcname 		= shift if @_ ;
		my $propertyOp		; $propertyOp  		= shift if @_ ;
		my $returnType		;


	my $SvrProjNameStr_C = &getTCName_C($SvrProjName);

	my  $tcNameTAF = &getTCName_TAF($SvrProjNameStr_C)."/$SvrTCNamePattern/index.txt";
	my  $tcName    = &getTCName    ($SvrProjNameStr_C)."/index.txt";

	my $tcId = $SvrTCNamePattern; $tcId =~ /testcase(\d\d\d\d)\s*/; $tcId = $1;  $tcId =~ s/^0*//g;


	#### Read the c:/TS/index.txt to @contents 
	my @content; my $pattern = "Automation"; my $content=""; my $id = 0;	


	if ( -e "$tcName" ) {;} else { print "Warning: $tcName doesn't exist. Exit!"; exit; } 
	open Fin_index_txt,  "$tcName";	print " <- $tcName\n";
	while ($_ = <Fin_index_txt>) {
		if (/^\s*$pattern\s*:\s*(\d+)\s*$/i) { $content[$id] = $content; $content = ""; $id = $1;} 
		$content .= $_;	
	}
	$content[$id] = $content;
 	close Fin_index_txt;

 	#### Read the c:/_TAF/TS/index.txt to @contents  and sync with the c:/_TAF/TS/tc_def.txt
     	if ( -e  $tcNameTAF ) { ; } else { print "Info:There is no $tcNameTAF\n"; return "Info:There is no $tcNameTAF"; }
	 
     	open Fin_tc_definition, $tcNameTAF || die "Can't open file: $tcNameTAF:$!";  print " <- $tcNameTAF\n";
     		@_ = <Fin_tc_definition>; 
     	close Fin_tc_definition;
 	$content[$tcId] = "   Automation : $tcId\n@_";
	
	#### Backup the old c:/TS/index.txt.bak
	if (-e "$tcName") { move ("$tcName",  "$tcName.bak"); }   print " -> $tcName.bak\n";
  	open Fout_new_desc, "> $tcName";	print " -> $tcName\n";
  		for (my $i = 0; $i <= $#content; $i++) { print Fout_new_desc "$content[$i]"; }
 	close Fout_new_desc;

}

####
sub addTSDefinition() { 	# Input: SvrProjName, $SvrTCNamePattern 
	    	my %array; my $returnValue;
		my $tcname 		; $tcname 		= shift if @_ ;
		my $propertyOp		; $propertyOp  		= shift if @_ ;
		my $returnType		;


	my $SvrProjNameStr_C = &getTCName_C($SvrProjName);

	my  $tcNameTAF = &getTCName_TAF($SvrProjNameStr_C)."/$SvrTCNamePattern/index.txt";
	my  $tcName    = &getTCName    ($SvrProjNameStr_C)."/index.txt";

	my $tcId = $SvrTCNamePattern; $tcId =~ /testcase(\d\d\d\d)\s*/; $tcId = $1;  $tcId =~ s/^0*//g;


	#### Read the c:/TS/index.txt to @contents 
	my @content; my $pattern = "Automation"; my $content=""; my $id = 0;	


	if ( -e "$tcName" ) {;} else { print "Warning: $tcName doesn't exist. Exit!"; exit; } 
	open Fin_index_txt,  "$tcName";	print " <- $tcName\n";
	while ($_ = <Fin_index_txt>) {
		if (/^\s*$pattern\s*:\s*(\d+)\s*$/i) { $content[$id] = $content; $content = ""; $id = $1;} 
		$content .= $_;	
	}
	$content[$id] = $content;
 	close Fin_index_txt;


 	#### Read the c:/_TAF/TS/index.txt to @contents  and sync with the c:/_TAF/TS/tc_def.txt
     	if ( -e  $tcNameTAF ) { ; } else { print "Info:There is no $tcNameTAF\n"; return "Info:There is no $tcNameTAF"; }
	 
     	open Fin_tc_definition, $tcNameTAF || die "Can't open file: $tcNameTAF:$!";  print " <- $tcNameTAF\n";
     		@_ = <Fin_tc_definition>; 
     	close Fin_tc_definition;
	$id++;
 	$content[$id] = "Automation: $id\n"."@_";
	
	#### Backup the old c:/TS/index.txt.bak
	if (-e "$tcName") { move ("$tcName",  "$tcName.bak"); }   print " -> $tcName.bak\n";
  	open Fout_new_desc, "> $tcName";	print " -> $tcName\n";
  		for (my $i = 0; $i <= $#content; $i++) { print Fout_new_desc "$content[$i]"; }
 	close Fout_new_desc;

}


####


################################################################################
#	Subroutine Name : updateProperties
################################################################################
sub syncProperties() { 	# get TC Property Names	(TH:TC Managements)
	    	my %array; my $returnValue;
		my $tcname 		; $tcname 		= shift if @_ ;
		my $propertyOp		; $propertyOp  		= shift if @_ ;
		my $returnType		;

    		if ($propertyOp =~ s/^\s*add\s*=\s*//ig) 	{;}
		elsif ($propertyOp =~ s/^\s*_eq_\s*//g) 	{;}
		elsif ($propertyOp =~ s/\s*_eq_\s*/=/g) 	{;}
		elsif ($propertyOp =~ s/_column_/:/g) 		{;}
		if ($propertyOp =~ /_all_?/) { $returnType = "_all_"; $propertyOp =~ s/_all_//g; }

    if ( -e  "$tcname/thProperty.txt" ) { ; } else { return "info:There is no $tcname/thProperty.txt here";}
    open Fout_property, ">>$tcname/thProperty.txt" || die "Can't open file:$!";
	print "  $tcname/thProperty.txt  <<-  $tcname/tc_prop.txt   \n";
    	&appendtoFileFile("$tcname/tc_prop.txt", "$tcname/thProperty.txt") ;
    close Fout_property;
}
################################################################################
#	Subroutine Name : updateProperties	-Not Used Function
################################################################################
sub updateProperties() { 	# get TC Property Names	(TH:TC Managements)
	    	my %array; my $returnValue;
		my $tcname 		; $tcname 		= shift if @_ ;
		my $propertyOp		; $propertyOp  		= shift if @_ ;
		my $returnType		;

    		if ($propertyOp =~ s/^\s*add\s*=\s*//ig) 	{;}
		elsif ($propertyOp =~ s/^\s*_eq_\s*//g) 	{;}
		elsif ($propertyOp =~ s/\s*_eq_\s*/=/g) 	{;}
		elsif ($propertyOp =~ s/_column_/:/g) 		{;}
		if ($propertyOp =~ /_all_?/) { $returnType = "_all_"; $propertyOp =~ s/_all_//g; }

    if ( -e  "$tcname/thProperty.txt" ) { ; } else { return "info:There is no $tcname/thProperty.txt here";}
    open Fout_property, ">>$tcname/thProperty.txt" || die "Can't open file:$!";
	print "$index_pl_arguments\n";
    close Fout_property;
}


################################################################################
#	Subroutine Name : getProperties
#		Function: return Test Case Property
#	Input Parameters: Property Name (regExp)  (tcName, tcPattern, value)
#	Output/Returns  : Property Value
################################################################################
sub getProperties() { 	# get TC Property Names	(TH:TC Managements)
	    	my %array		; my %array_all; my $returnValue;
		my $tcname 		; $tcname 		= shift if @_ ;
		my $propertyOp		; $propertyOp  		= shift if @_ ;
		my $returnType= 'latest'; $returnType 		= shift if @_ ;

    		if ($propertyOp =~ s/^\s*add\s*=\s*//ig) 	{;}
		elsif ($propertyOp =~ s/^\s*_eq_\s*//g) 	{;}
		elsif ($propertyOp =~ s/\s*_eq_\s*/=/g) 	{;}
		elsif ($propertyOp =~ s/_column_/:/g) 		{;}
		if ($propertyOp =~ /_all_?/) { $returnType = "_all_"; $propertyOp =~ s/_all_//g; }

    if ( -e  "$tcname/thProperty.txt" ) { ; } else { return "info:There is no $tcname/thProperty.txt here";}
    open Fin, "$tcname/thProperty.txt" || die "Can't open file:$!";
    while ( $_ = <Fin> ) {
	    @_= split /\|/, $_;
	    if ($#_ >0 ) { ###  Filter out non-property line 
	    my $propertyName_ = $_[0]; my $propertyValue_ = $_[1]; $propertyName_ =~ s/^\s*//g; $propertyName_ =~ s/\s*$//g; my $propertyStartTime = $_[2];
	    $propertyValue_ =~ s/^\s*//g;
	    $propertyValue_ =~ s/\s*$//g;
	    if (($propertyName_ !~ /^\s*$/) && ( $propertyValue_ !~ /^\s*$/)) {   

 	      	if (($propertyName_ =~ /$propertyOp/i) || ( $propertyOp eq '')) { # PropertyPattern Filter
		   	if ($returnType =~ /^\s*$/) { $returnValue .= sprintf "%-20s=%s\n",$propertyName_, $propertyValue_; 	# ignore this now. todo Hardcoded 20 determines the parssing in updateProperties
			} elsif ($returnType =~ /values/i) { 
				$returnValue .= sprintf "%s\n", $propertyValue_;
			} elsif ($returnType =~ /_all_/i) { 
				$propertyValue_ =~ s/^\s*//g;
				$propertyValue_ =~ s/\s*$//g;
				$returnValue = sprintf "\t%s\n", $propertyValue_;
			} elsif ($returnType =~ /history/i) { 
				$returnValue .= sprintf "%-20s=%s \@ $propertyStartTime\n",$propertyName_, $propertyValue_;
			} elsif ($returnType =~ /\blatest\b/i) {
				$returnValue = "$propertyValue_\n";
			} elsif ($returnType =~ /\blast\b/i) {
				if ($propertyValue_ !~ /dumy/) { $returnValue = "$propertyValue_\n"; }
			} elsif ($returnType =~ /\bvalue\b/i) {
				$returnValue = sprintf "%s\n", $propertyValue_;
		   	}
		} elsif ($propertyOp =~ /4_display/ ) {
				$returnValue = $propertyValue_; 
				#$returnValue = sprintf "%-20s=%s\n",$propertyName_, $propertyValue_; 
		}
		$array{$propertyName_} = $returnValue;
		chop;
		$array_all{$propertyName_} = $_;
	}
	} ###
    }
    close Fin;

	#### The local property overwrite the default property 
	#
	#

    if ( -e  "$tcname/tc_prop.txt" ) 
    { ####
    open Fin, "$tcname/tc_prop.txt" || die "Can't open file:$!";
    while ( $_ = <Fin> ) {
	    @_= split /\|/, $_;
	    if ($#_ >0 ) { ###  Filter out non-property line 
	    my $propertyName_ = $_[0]; my $propertyValue_ = $_[1]; $propertyName_ =~ s/^\s*//g; $propertyName_ =~ s/\s*$//g; my $propertyStartTime = $_[2];
	    $propertyValue_ =~ s/^\s*//g;
	    $propertyValue_ =~ s/\s*$//g;
	    if (($propertyName_ !~ /^\s*$/) && ( $propertyValue_ !~ /^\s*$/)) {   

 	      	if (($propertyName_ =~ /$propertyOp/i) || ( $propertyOp eq '')) { # PropertyPattern Filter
		   	if ($returnType =~ /^\s*$/) { $returnValue .= sprintf "%-20s=%s\n",$propertyName_, $propertyValue_; 	# ignore this now. todo Hardcoded 20 determines the parssing in updateProperties
			} elsif ($returnType =~ /values/i) { 
				$returnValue .= sprintf "%s\n", $propertyValue_;
			} elsif ($returnType =~ /_all_/i) { 
				$propertyValue_ =~ s/^\s*//g;
				$propertyValue_ =~ s/\s*$//g;
				$returnValue = sprintf "\t%s\n", $propertyValue_;
			} elsif ($returnType =~ /history/i) { 
				$returnValue .= sprintf "%-20s=%s \@ $propertyStartTime\n",$propertyName_, $propertyValue_;
			} elsif ($returnType =~ /\blatest\b/i) {
				$returnValue = "$propertyValue_\n";
			} elsif ($returnType =~ /\blast\b/i) {
				if ($propertyValue_ !~ /dumy/) { $returnValue = "$propertyValue_\n"; }
			} elsif ($returnType =~ /\bvalue\b/i) {
				$returnValue = sprintf "%s\n", $propertyValue_;
		   	}
		} elsif ($propertyOp =~ /4_display/ ) {
				$returnValue = $propertyValue_; 
				#$returnValue = sprintf "%-20s=%s\n",$propertyName_, $propertyValue_; 
		}
		$array{$propertyName_} = $returnValue;
		chop;
		$array_all{$propertyName_} = $_;
	}
	} ###
    }
    close Fin;
	}####

	$returnValue = "\n";
	if ($returnType =~ /_all_/i) {
		foreach my $each (sort keys %array) { 
			@_ = split /\|/, $array_all{$each} ; 
			my $propName   = $_[0];
			my $propValue  = $_[1]; $propValue =~ s/^\s*//g; $propValue =~ s/\s*$//g;
			my $propStartT = $_[2];
			my $propEndT   = $_[3];
			my $propCmt1   = $_[4];
			my $propCmt2   = $_[5];

			$returnValue .= sprintf "%-10s|%-100s|%s|%s|%s|%s\n", $propName, $propValue, $propStartT, $propEndT, $propCmt1, $propCmt2 ; 
			}
		return $returnValue;
	} else {
		$returnValue =  $array{$propertyOp} ; 
		if ($returnValue ) { $returnValue =~ s/\s*\n\s*$//g; if ($returnValue =~ /^\s*$/) { $returnValue = "_noMatch_";} ; return $returnValue; }
		else { return ""; }
    	}
}

#################
sub readFileThProperty { 
	my $tcname = shift;
       	my $returnValue; my $returnType="_all_"; my %array; my %array_all; my $propertyOp ;
    if ( -e  "$tcname" ) 
    { ####
    open Fin, "$tcname" || die "Can't open file:$!";
    while ( $_ = <Fin> ) {
	    @_= split /\|/, $_;
	    if ($#_ >0 ) { ###  Filter out non-property line 
	    my $propertyName_ = $_[0]; my $propertyValue_ = $_[1]; $propertyName_ =~ s/^\s*//g; $propertyName_ =~ s/\s*$//g; my $propertyStartTime = $_[2];
	    $propertyValue_ =~ s/^\s*//g;
	    $propertyValue_ =~ s/\s*$//g;
	    if (($propertyName_ !~ /^\s*$/) && ( $propertyValue_ !~ /^\s*$/)) {   

 	      	if (($propertyName_ =~ /$propertyOp/i) || ( $propertyOp eq '')) { # PropertyPattern Filter
		   	if ($returnType =~ /^\s*$/) { $returnValue .= sprintf "%-20s=%s\n",$propertyName_, $propertyValue_; 	# ignore this now. todo Hardcoded 20 determines the parssing in updateProperties
			} elsif ($returnType =~ /values/i) { 
				$returnValue .= sprintf "%s\n", $propertyValue_;
			} elsif ($returnType =~ /_all_/i) { 
				$propertyValue_ =~ s/^\s*//g;
				$propertyValue_ =~ s/\s*$//g;
				$returnValue = sprintf "\t%s\n", $propertyValue_;
			} elsif ($returnType =~ /history/i) { 
				$returnValue .= sprintf "%-20s=%s \@ $propertyStartTime\n",$propertyName_, $propertyValue_;
			} elsif ($returnType =~ /\blatest\b/i) {
				$returnValue = "$propertyValue_\n";
			} elsif ($returnType =~ /\blast\b/i) {
				if ($propertyValue_ !~ /dumy/) { $returnValue = "$propertyValue_\n"; }
			} elsif ($returnType =~ /\bvalue\b/i) {
				$returnValue = sprintf "%s\n", $propertyValue_;
		   	}
		} elsif ($propertyOp =~ /4_display/ ) {
				$returnValue = $propertyValue_; 
		}
		$array{$propertyName_} = $returnValue;
		chop;
		$array_all{$propertyName_} = $_;
	}
	} ###
    }
    close Fin;
	}####

	$returnValue = "\n";
	if ($returnType =~ /_all_/i) {
		foreach my $each (sort keys %array) { 
			@_ = split /\|/, $array_all{$each} ; 
			my $propName   = $_[0];
			my $propValue  = $_[1]; $propValue =~ s/^\s*//g; $propValue =~ s/\s*$//g;
			my $propStartT = $_[2];
			my $propEndT   = $_[3];
			my $propCmt1   = $_[4];
			my $propCmt2   = $_[5];

			$returnValue .= sprintf "%-10s|%-100s|%s|%s|%s|%s\n", $propName, $propValue, $propStartT, $propEndT, $propCmt1, $propCmt2 ; 
			}
		return $returnValue;
	} else {
		$returnValue =  $array{$propertyOp} ; 
		if ($returnValue ) { $returnValue =~ s/\s*\n\s*$//g; if ($returnValue =~ /^\s*$/) { $returnValue = "_noMatch_";} ; return $returnValue; }
		else { return ""; }
    	}
}
#################

################################################################################
#	Subroutine Name : modfyProperty
#		Function: modify Test Case Property
#	Input Parameters: Test Case Property Name
#	Output/Returns  : updated c:\TC_*\thProperty.txt
#	Subroutine Name : 
#		Function: 
#	Input Parameters: 
#	Output/Returns  : 
################################################################################
sub modifyProperty() { 	# modify TC Property (TH:TC Managements)
    my $tcname       = $_[0];
    my $propertyName = $_[1];
    my $propertyValue       ; 
    if ($propertyName =~ s/^\s*modify\s*_\s*//g) {
    $propertyName =~ /(\w+)\s*_as_\s*(\w+)\s*/;
    $propertyName = $1; $propertyValue = $2;
    }
    my $cmdStr        = "delete=$propertyName";
    &deleteProperty( $tcname, $cmdStr );
    $cmdStr = "add_${propertyName}_column_${propertyValue}"; # todo
    &addProperty( $tcname, $cmdStr );
    return "$propertyName is modified to $propertyValue for $tcname";
}

################################################################################
#	Subroutine Name : deleteProperty
#		Function: delete Test Case Property
#	Input Parameters: Test Case Property Name
#	Output/Returns  : update c:\TC_*\thProperty.txt
################################################################################
sub deleteProperty() {	# delete TC Property	(TH:TC Managements)
    my $fname = "$_[0]/thProperty.txt";
    my $fout  = $fname; $fout =~ s/\.txt/_Dumpster\.txt/;

    my $propertyName = $_[1]; 
    if ($propertyName !~ /\s*del\S*\s*_\s*/) { return "Warning: wrong format  -del=prop1;pr2Screen";} else {
    $propertyName =~ s/^\s*del\S*\s*_\s*//g; $propertyName =~ s/:\s*\S*//; }
    my %array ;
    open Fin, "$fname"; @_ = <Fin>; close Fin;

    open Fout, ">>$fout";
    foreach my $each (@_) {
        if ( $each =~ /^\s*$propertyName\s*\|/i ) { print Fout "$each"; }
    }
    close Fout;

    open Fout, ">${fname}" || die "Can't open $fname:$!";
    foreach my $each (@_) {
        if ( $each !~ /^\s*$propertyName\s*\|/i ) {
            print Fout "$each";
        }
    }
    close Fout;
    return "$propertyName is deleted from $fname";
}

################################################################################
#	Subroutine Name : createPropertyTemplate
#		Function: 
#	Input Parameters: 
#	Output/Returns  : 
################################################################################
sub createPropertyTemplate() { 	# create TC Property File (TH:TC Managements)
    my $timeStr = getDate(); $timeStr = "|$timeStr|$timeStr|0:0:0:0s|Comment1|Comment2";
    my $tcDesc = "@_"; 
    my $fname = "@_/thProperty.txt";
    if (-e $fname) { open Fout, ">>$fname"; } else { open Fout, ">$fname";} 
    printf Fout "%20s|%10s%s\n", 'tcId','TC_Func_1',$timeStr;
    printf Fout "%20s|%10s%s\n", 'tcDesc',$tcDesc,$timeStr;
    printf Fout "%20s|%10s%s\n", 'Author','QA2',$timeStr;
    printf Fout "%20s|%10s%s\n", 'Manual Test Script','http://www.taascloud.com',$timeStr;
    printf Fout "%20s|%10s%s\n", 'tcType','Function',$timeStr;
    printf Fout "%20s|%10s%s\n", 'QA Owner','QA Engineer1',$timeStr;
    printf Fout "%20s|%10s%s\n", 'Manual Tester','QA contractor1',$timeStr;
    printf Fout "%20s|%10s%s\n", 'Developer','Developer1',$timeStr;
    printf Fout "%20s|%10s%s\n", 'Business Owner','Analyst1',$timeStr;
    printf Fout "%20s|%10s%s\n", 'Automated','Yes',$timeStr;
    printf Fout "%20s|%10s%s\n", 'priority','High',$timeStr;
    printf Fout "%20s|%10s%s\n", 'Status','completed',$timeStr;
    printf Fout "%20s|%10s%s\n", 'requirementId','Function Req 1',$timeStr;
    printf Fout "%20s|%10s%s\n", 'module','Business Logic',$timeStr;
    printf Fout "%20s|%10s%s\n", 'customer property1','unset',$timeStr;
    printf Fout "%20s|%10s%s\n", 'customer property2','unset',$timeStr;
    printf Fout "%20s|%10s%s\n", 'customer property3','unset',$timeStr;
    printf Fout "%20s|%10s%s\n", 'resultN','null',$timeStr;
    printf Fout "%20s|%10s%s\n", 'TotalTimespend','8 hours',$timeStr;
    close Fout;
}

################################################################################
#	Subroutine Name : addProperty
#		Function: add Test Case Property
#	Input Parameters: Test Case Property Name
#	Output/Returns  : updated c:\TC_*\thProperty.txt
################################################################################
sub addProperty() { 	# add TC Property (TH:TC Managements)
    my $timeStr = &getDate(); $timeStr = "|$timeStr|$timeStr|0:0:0:0s|comment1|comment2";
    my $fname        = "$_[0]/thProperty.txt";
    my $propertyName = $_[1];
    $propertyName =~ s/^\s*add\s*=//g;
    $propertyName =~ s/^\s*add\s*_eq_\s*//g;
    if (-e $_[0]) {;} else { mkpath $_[0]; }
    open Fout, ">>$fname";
    	if ($propertyName =~ /\|/) { # for tcRunResult 
		$propertyName =~ /^\s*(\S+)\s*\|\s*(\S+)\s*\|(.+)\s*$/; 
		my $propName = $1		;
		my $propValue = $2		;
		my $propComment = $3		;
		$propValue =~ s/_space_/ /g	;
		$propValue =~ s/_eq_/=/g	;
		$propValue =~ s/_column_/:/g	;
        	printf Fout "%20s|%10s|%s\n",$propName, $propValue,$propComment;
	} else {
		$propertyName =~ /^\s*(\S+)_column_(\S+)\s*/; 
		my $propName = $1		;
		my $propValue = $2		;
		$propName = &match1stRegexp($propertyName, "_column_");
		$propValue= &matchRestRegexp($propertyName, "_column_");
		if ($propName && $propValue) {
		$propValue =~ s/_column_/:/g	;
		$propValue =~ s/_space_/ /g	;
		$propValue =~ s/_eq_/=/g	;
		$propValue =~ s/___/ /g		;
		$propName =~ s/^\s*add\s*=//g	;
		$propName =~ s/_space_/ /g	;
        	printf Fout "%20s|%10s%s\n",$propName, $propValue,$timeStr;
		}
	}
    close Fout;
    return "$propertyName is added to $fname";
}

sub printGlobalVars {
my $return=<<EOF;
##################### Frequently Used Setting ####################
web_ui_title                  =$web_ui_title                  
tags                          =$tags                          
ps1_args                      =$ps1_args                      
Execution_24_7                =$Execution_24_7                
Execution_24_7_title          =$Execution_24_7_title
Execution_local_only          =$Execution_local_only 
outputFromat                  =$outputFormat  (text,noOutput -todo ,html-todo)
htmlRefreshRate               =$htmlRefreshRate
htmlRefreshRateWebUI          =$htmlRefreshRateWebUI
htmlRefreshRateLogUI          =$htmlRefreshRateLogUI
##################### WebUI Setting           ####################
excelReportColumnWidth        =$excelReportColumnWidth        
pr2Screen                     =$pr2Screen                     
webUI_TCDescWidth             =$webUI_TCDescWidth             
scrollAmount                  =$scrollAmount                  
borderWidth                   =$borderWidth                   
borderStyle                   =$borderStyle                   
passFailDisplayWidth          =$passFailDisplayWidth          
maxPassFailDisplayWidth       =$maxPassFailDisplayWidth       
tsPropertyWidth               =$tsPropertyWidth               
webUITreeViewLevel            =$webUITreeViewLevel
webUIStyleColorHide           =#CEF6F5
##################### TAF  Default  Settings   ####################
ip                            =$ip                             
c                             =$c                             
taf                           =$taf                           
_TAF                          =$_TAF                          
overWriteTC                   =$overWriteTC
reportHtmlSummaryScale        =$reportHtmlSummaryScale        
reportHtmlSummaryScaleMajor   =$reportHtmlSummaryScaleMajor   
testcaseNode                  =$testcaseNode
NofExecution                  =$NofExecution                  
ExecutionLength               =$ExecutionLength               
tsFilter                      =$tsFilter                      
tcComment1                    =$tcComment1                    
tcComment2                    =$tcComment2                    
automationRequest             =$automationRequest
axTCExecTime                 =$MaxTCExecTime                 
TSHookName                    =$TSHookName                    
TSHookNameGenerated           =$TSHookNameGenerated           
TSHookIsPerl                  =$TSHookIsPerl                  
interact                      =$interact                      
tcPropertyPatternName         =$tcPropertyPatternName         
tcPropertyPatternPattern      =$tcPropertyPatternPattern      
tcPropertyPatternName1        =$tcPropertyPatternName1        
tcPropertyPatternPattern1     =$tcPropertyPatternPattern1     
tcPropertyPatternName2        =$tcPropertyPatternName2        
tcPropertyPatternPattern2     =$tcPropertyPatternPattern2     
tcPropertyPatternName3        =$tcPropertyPatternName3        
tcPropertyPatternPattern3     =$tcPropertyPatternPattern3     
tcPropertyName                =$tcPropertyName                
tcNamePattern                 =$tcNamePattern                 
tcOp                          =$tcOp                          
tcCtr                         =$tcCtr                         
tcDelta                       =$tcDelta                       
markSymbol                    =$markSymbol                    
tsFilterDefault               =$tsFilterDefault               
tcFilterDefault               =$tcFilterDefault               
SvrDrive                      =$SvrDrive                      
SvrProjName_ignore            =$SvrProjName                   
SvrTCName_ignore  	      =$SvrTCName                     
SvrTCNamePattern              =$SvrTCNamePattern              
SvrPropNamePattern            =$SvrPropNamePattern            
SvrPropValuePattern           =$SvrPropValuePattern           
SvrTCNameExecPattern          =$SvrTCNameExecPattern          
exitTAFGracefullyLock         =$exitTAFGracefullyLock         
performanceMode               =$performanceMode               
resetTSFileName               =$resetTSFileName               
externalLogName               =$externalLogName               
commandLogName                =$commandLogName                
commandLogLifeSpan            =$commandLogLifeSpan            
testType                      =$testType                      
AutomationtsName              =$AutomationtsName              
tsProperty                    =$tsProperty_txt             
sleep4Display		      =$sleep4Display
createOrAppendTS	      =$createOrAppendTS
NofTCinTSTemplate  	      =$NofTCinTSTemplate
NofTSinTSTemplate  	      =$NofTSinTSTemplate
ip                            =$ip
hostname                      =$hostname
http_port                     =$http_port
http_port_IIS                 =$http_port_IIS
http_port_mime                =$http_port_mime
http_port_exec                =$http_port_exec
formatResult                  =$formatResult
index_pl_arguments	      =$index_pl_arguments
manual_result                 =$manual_result
manual_results                =$manual_results
comment2                      =$comment2
EOF
}
################


sub printTSGlobalVars {
my $return=<<EOF;
##################### Frequently Used Setting ####################
Execution_24_7                =$Execution_24_7                
Execution_24_7_title          =$Execution_24_7_title
Execution_local_only          =$Execution_local_only 
htmlRefreshRate               =$htmlRefreshRate
htmlRefreshRateWebUI          =$htmlRefreshRateWebUI
htmlRefreshRateLogUI          =$htmlRefreshRateLogUI
##################### WebUI Setting           ####################
EOF
}

sub printTCGlobalVars {
my $return=<<EOF;
##################### Frequently Used Setting ####################
Execution_24_7                =$Execution_24_7                
Execution_24_7_title          =$Execution_24_7_title
Execution_local_only          =$Execution_local_only 
htmlRefreshRate               =$htmlRefreshRate
htmlRefreshRateWebUI          =$htmlRefreshRateWebUI
htmlRefreshRateLogUI          =$htmlRefreshRateLogUI
##################### WebUI Setting           ####################
EOF
}



###############

sub readTAFTCVars     { open Fin, "$SvrTCName/$_tafGlobalVars_txt"				; while (<Fin>) { chop; if ($_ =~ /(.+)=(.+)/ ) { &readTAFGlobalVars1($1, $2); } }; close Fin; }
sub readTAFTSVars     { open Fin, "$c/$_TAF/$SvrProjName/$_tafGlobalVars_txt"			; while (<Fin>) { chop; if ($_ =~ /(.+)=(.+)/ ) { &readTAFGlobalVars1($1, $2); } }; close Fin; }
sub readTAFGlobalVars { open Fin, "$c/$_TAF/$_tafGlobalVars_txt"					; while (<Fin>) { chop; if ($_ =~ /(.+)=(.+)/ ) { &readTAFGlobalVars1($1, $2); } }; close Fin; }
sub readTAFGlobalVars1 {
	my $varName  = shift;
	my $varValue = shift;
	$varName  =~ s/^\s*//g; $varName  =~ s/\s*$//g;
	$varValue =~ s/^\s*//g; $varValue=~ s/\s*$//g;
if ($varName eq "web_ui_title"                ) { $web_ui_title                   = $varValue; }
if ($varName eq "tags"                        ) { $tags                           = $varValue; }
if ($varName eq "ps1_args"                    ) { $ps1_args                       = $varValue; }
if ($varName eq "excelReportColumnWidth"      ) { $excelReportColumnWidth         = $varValue; }
if ($varName eq "testcaseNode"                ) { $testcaseNode                   = $varValue; }
if ($varName eq "pr2Screen"                   ) { $pr2Screen                      = $varValue; }
if ($varName eq "webUI_TCDescWidth"           ) { $webUI_TCDescWidth              = $varValue; }
if ($varName eq "webUITreeViewLevel"          ) { $webUITreeViewLevel             = $varValue; }
if ($varName eq "scrollAmount"                ) { $scrollAmount                   = $varValue; }
if ($varName eq "borderWidth"                 ) { $borderWidth                    = $varValue; }
if ($varName eq "borderStyle"                 ) { $borderStyle                    = $varValue; }
if ($varName eq "passFailDisplayWidth"        ) { $passFailDisplayWidth           = $varValue; }
if ($varName eq "maxPassFailDisplayWidth"     ) { $maxPassFailDisplayWidth        = $varValue; }
if ($varName eq "reportHtmlSummaryScale"      ) { $reportHtmlSummaryScale         = $varValue; }
if ($varName eq "reportHtmlSummaryScaleMajor" ) { $reportHtmlSummaryScaleMajor    = $varValue; }
if ($varName eq "tsPropertyWidth"             ) { $tsPropertyWidth                = $varValue; }
if ($varName eq "c"                           ) { $c                              = $varValue; }
if ($varName eq "taf"                         ) { $taf                            = $varValue; }
if ($varName eq "_TAF"                        ) { $_TAF                           = $varValue; }
if ($varName eq "Execution_24_7"              ) { $Execution_24_7                 = $varValue; }
if ($varName eq "Execution_24_7_title"        ) { $Execution_24_7_title           = $varValue; }
if ($varName eq "Execution_local_only"        ) { $Execution_local_only           = $varValue; }
if ($varName eq "Execution_from_cgi"          ) { $Execution_from_cgi             = $varValue; }
if ($varName eq "NofExecution"                ) { $NofExecution                   = $varValue; }
if ($varName eq "ExecutionLength"             ) { $ExecutionLength                = $varValue; }
if ($varName eq "tsFilter"                    ) { $tsFilter                       = $varValue; }
if ($varName eq "tcComment1"                  ) { $tcComment1                     = $varValue; }
if ($varName eq "tcComment2"                  ) { $tcComment2                     = $varValue; }
if ($varName eq "automationRequest"           ) { $automationRequest              = $varValue; }
if ($varName eq "message"                     ) { $message                        = $varValue; }
if ($varName eq "MaxTCExecTime"               ) { $MaxTCExecTime                  = $varValue; }
if ($varName eq "TSHookName"                  ) { $TSHookName                     = $varValue; }
if ($varName eq "TSHookNameGenerated"         ) { $TSHookNameGenerated            = $varValue; }
if ($varName eq "interact"                    ) { $interact                       = $varValue; }
if ($varName eq "tcPropertyPatternName"       ) { $tcPropertyPatternName          = $varValue; }
if ($varName eq "tcPropertyPatternPattern"    ) { $tcPropertyPatternPattern       = $varValue; }
if ($varName eq "tcPropertyPatternName1"      ) { $tcPropertyPatternName1         = $varValue; }
if ($varName eq "tcPropertyPatternPattern1"   ) { $tcPropertyPatternPattern1      = $varValue; }
if ($varName eq "tcPropertyPatternName2"      ) { $tcPropertyPatternName2         = $varValue; }
if ($varName eq "tcPropertyPatternPattern2"   ) { $tcPropertyPatternPattern2      = $varValue; }
if ($varName eq "tcPropertyPatternName3"      ) { $tcPropertyPatternName3         = $varValue; }
if ($varName eq "tcPropertyPatternPattern3"   ) { $tcPropertyPatternPattern3      = $varValue; }
if ($varName eq "tcPropertyName"              ) { $tcPropertyName                 = $varValue; }
if ($varName eq "tcNamePattern"               ) { $tcNamePattern                  = $varValue; }
if ($varName eq "tcOp"                        ) { $tcOp                           = $varValue; }
if ($varName eq "tcCtr"                       ) { $tcCtr                          = $varValue; }
if ($varName eq "tcDelta"                     ) { $tcDelta                        = $varValue; }
if ($varName eq "tcFrom"                      ) { $tcFrom                         = $varValue; }	# no Volatile variable
if ($varName eq "markSymbol"                  ) { $markSymbol                     = $varValue; }
if ($varName eq "tsFilterDefault"             ) { $tsFilterDefault                = $varValue; }
if ($varName eq "tcFilterDefault"             ) { $tcFilterDefault                = $varValue; }
if ($varName eq "SvrDrive"                    ) { $SvrDrive                       = $varValue; }
if ($varName eq "SvrProjName"                 ) { $SvrProjName                    = $varValue; }
if ($varName eq "SvrTCName"                   ) { $SvrTCName                      = $varValue; }
if ($varName eq "SvrTCNamePattern"            ) { $SvrTCNamePattern               = $varValue; }
if ($varName eq "SvrPropNamePattern"          ) { $SvrPropNamePattern             = $varValue; }
if ($varName eq "SvrPropValuePattern"         ) { $SvrPropValuePattern            = $varValue; }
if ($varName eq "SvrTCNameExecPattern"        ) { $SvrTCNameExecPattern           = $varValue; }
if ($varName eq "exitTAFGracefullyLock"       ) { $exitTAFGracefullyLock          = $varValue; }
if ($varName eq "performanceMode"             ) { $performanceMode                = $varValue; }
if ($varName eq "tsFrom"                      ) { $tsFrom                         = $varValue; }
if ($varName eq "tsTo"                        ) { $tsTo                           = $varValue; }
if ($varName eq "resetTSFileName"             ) { $resetTSFileName                = $varValue; }
if ($varName eq "externalLogName"             ) { $externalLogName                = $varValue; }
if ($varName eq "commandLogName"              ) { $commandLogName                 = $varValue; }
if ($varName eq "commandLogLifeSpan"          ) { $commandLogLifeSpan             = $varValue; }
if ($varName eq "testType"                    ) { $testType                       = $varValue; }
if ($varName eq "AutomationtsName"            ) { $AutomationtsName               = $varValue; }
if ($varName eq "tsProperty"                  ) { $tsProperty_txt                 = $varValue; }
if ($varName eq "TsHookIsPerl"                ) { $TSHookIsPerl                   = $varValue; }
if ($varName eq "createOrAppendTS"            ) { $createOrAppendTS               = $varValue; }
if ($varName eq "htmlRefreshRate"             ) { $htmlRefreshRate 		  = $varValue; }
if ($varName eq "htmlRefreshRateWebUI"        ) { $htmlRefreshRateWebUI 	  = $varValue; }
if ($varName eq "NofTCinTSTemplate"           ) { $NofTCinTSTemplate    	  = $varValue; }
if ($varName eq "NofTSinTSTemplate"           ) { $NofTSinTSTemplate    	  = $varValue; }
if ($varName eq "index_pl_arguments"          ) { $index_pl_arguments   	  = $varValue; }
if ($varName eq "manual_result"               ) { $manual_result        	  = $varValue; }
if ($varName eq "manual_results"              ) { $manual_results        	  = $varValue; }
if ($varName eq "comment2"                    ) { $comment2             	  = $varValue; }
if ($varName eq "webUIStyleColorHide"         ) { $webUIStyleColorHide  	  = $varValue; }
if ($varName eq "ip"         	      	      ) { $ip                             = $varValue; }
if ($varName eq "hostname"         	      ) { $hostname                       = $varValue; }
if ($varName eq "http_port"         	      ) { $http_port                      = $varValue; }
if ($varName eq "http_port_IIS"               ) { $http_port_IIS                  = $varValue; }
if ($varName eq "http_port_mime"              ) { $http_port_mime                 = $varValue; }
if ($varName eq "http_port_exec"              ) { $http_port_exec                 = $varValue; }
if ($varName eq "formatResult"                ) { $formatResult                   = $varValue; }
if ($varName eq "testcaseNode"                ) { $testcaseNode                   = $varValue; 
# &updateTAFGlobalVars(); 
if ($testcaseNode =~ /_null_/) { $testcaseNode = "";} 
}
}


sub setGlobalVars {
	shift;
	@_ = split /;/, shift;
	my $foundMatch = 0; my $lastAssign = "";
	foreach my $each (@_) {
		$lastAssign = $each;
		my $varName = ""; my $varValue = "";
		#if ($each =~ /^\s*(\S+)\s*=\s*(\S+)?\s*/) { $varName = $1; $varValue = $2; } 
		#elsif (/^\s*(\S+)\s*=\s*(\S+)?\s*/) { $varName =$1; $varValue = "";}	### white space in varialbles
		if ($each =~ /^\s*(\S+)\s*=\s*(.+)$/) { $varName = $1; $varValue = $2; } 
		elsif (/^\s*(\S+)\s*=\s*(.+)$/) { $varName =$1; $varValue = "";}
		if ($varName =~ /SysDrive/i) 			{ $SvrDrive = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /SvrDrive/i) 			{ $SvrDrive = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /SvrProjName/i) 		{ $SvrProjName = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /SvrTCName\b/i) 		{ $SvrTCName = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /SvrTCNamePattern\b/i) 	{ $SvrTCNamePattern = $varValue; $SvrTCNameExecPattern = $SvrTCNamePattern; $foundMatch = 1;}
		elsif ($varName =~ /SvrTCNameExecPattern/i) 	{ $SvrTCNameExecPattern = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /SvrPropNamePattern\b/i) 	{ $SvrPropNamePattern= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /SvrPropValuePattern/i)  	{ $SvrPropValuePattern= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bDrive\b/i) 		{ $SvrDrive = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bProjName\b/i) 		{ $SvrProjName = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bTCName\b/i) 		{ $SvrTCName = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btcFrom\b/i) 		{ $tcFrom    = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bTCNamePattern\b/i) 	{ $SvrTCNamePattern = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bTCNameExecPattern/i) 	{ $SvrTCNameExecPattern = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btcOp\b/i) 		{ $tcOp= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bPropNamePattern\b/i)  	{ $SvrPropNamePattern= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bPropValuePattern\b/i)  	{ $SvrPropValuePattern= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bTestSuit\b/i) 		{ $SvrProjName = $varValue; $foundMatch = 1; $SvrProjName =~ s/\\/\//g; $SvrProjName =~ s/$c\/$_TAF\///; }
		elsif ($varName =~ /\bTestSuite\b/i) 		{ $SvrProjName = $varValue; $foundMatch = 1; $SvrProjName =~ s/\\/\//g; $SvrProjName =~ s/$c\/$_TAF\///;}
		elsif ($varName =~ /\bsubTestSuite\b/i) 	{ $SvrProjNameSub = $varValue; $foundMatch = 1; $SvrProjNameSub =~ s/\\/\//g;  $SvrProjNameSub =~ s/$c\/$_TAF\///;}
		elsif ($varName =~ /\bTestSuiteSub\b/i) 	{ $SvrProjNameSub = $varValue; $foundMatch = 1; $SvrProjNameSub =~ s/\\/\//g;  $SvrProjNameSub =~ s/$c\/$_TAF\///;}
		elsif ($varName =~ /\bTCNameFilter\b/i) 	{ $SvrTCNamePattern = $varValue;$foundMatch = 1;}
		elsif ($varName =~ /\bTCNameExecFilter\b/i) 	{ $SvrTCNameExecPattern = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bTestCaseExec\b/i) 	{ $SvrTCNameExecPattern = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bTestCase\b/i) 		{ $SvrTCNamePattern = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bPropNameFilter\b/i)  	{ $SvrPropNamePattern= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bPropValueFilter\b/i)  	{ $SvrPropValuePattern= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btcPropertyName\b/i)  	{ $tcPropertyName = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btsuit\b/i) 		{ $SvrProjName = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btname\b/i) 		{ $SvrTCNamePattern = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bpname\b/i)  		{ $SvrPropNamePattern= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bpvalue\b/i)  		{ $SvrPropValuePattern= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btop\b/i) 			{ $tcOp= $varValue; $foundMatch = 1;}

		elsif ($varName =~ /\bts\b/i) 			{ $SvrProjName = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btn\b/i) 			{ $SvrTCNamePattern = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btc\b/i) 			{ $SvrTCNamePattern = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btne\b/i) 			{ $SvrTCNameExecPattern = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bop\b/i) 			{ $tcOp= $varValue; $foundMatch = 1;}

		elsif ($varName =~ /\bpr2Screen\b/i)  		{ $pr2Screen= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bnotUsegetTCName\b/i)  	{ $notUsegetTCName = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btc_pl\b/i)     		{ $tc_pl= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btcDriver\b/i)  		{ $tc_pl= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btsDriver\b/i)  		{ $tsDriver = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bweb_ui_title\b/i)  	{ $web_ui_title= $varValue; $foundMatch = 1; $web_ui_title =~ s/___/ /g;}
		elsif ($varName =~ /\bworkingDir\b/i)  		{ $workingDir= $varValue; $foundMatch = 1; $workingDir =~ s/\\/\//g;}
		elsif ($varName =~ /\btcIdMin\b/i)  		{ $tcIdMin = $varValue; $foundMatch = 1;}

		elsif ($varName=~/\btcPropertyPatternPattern\b/i){ $tcPropertyPatternPattern= $varValue; $foundMatch = 1; $tcPropertyPatternPattern =~ s/_pipe_/\|/gi;}
		elsif ($varName =~ /\btcPropertyPatternName\b/i){ $tcPropertyPatternName= $varValue; $foundMatch = 1;}

		elsif ($varName=~/\btcFilterFilter\b/i)		{ $tcPropertyPatternPattern= $varValue; $foundMatch = 1; $tcPropertyPatternPattern =~ s/_pipe_/\|/gi;} 
		elsif ($varName =~ /\btcFilterName\b/i)		{ $tcPropertyPatternName= $varValue; $foundMatch = 1;}

		elsif ($varName =~ /\btppp\b/i)  		{ $tcPropertyPatternPattern= $varValue; $foundMatch = 1; $tcPropertyPatternPattern =~ s/_pipe_/\|/gi;}
		elsif ($varName =~ /\btppn\b/i)			{ $tcPropertyPatternName= $varValue; $foundMatch = 1;}

		elsif ($varName =~ /\btppp1\b/i)  		{ $tcPropertyPatternPattern1= $varValue; $foundMatch = 1; $tcPropertyPatternPattern =~ s/_pipe_/\|/gi;}
		elsif ($varName =~ /\btppn1\b/i)		{ $tcPropertyPatternName1= $varValue; $foundMatch = 1;}

		elsif ($varName =~ /\btppp2\b/i)  		{ $tcPropertyPatternPattern2= $varValue; $foundMatch = 1; $tcPropertyPatternPattern =~ s/_pipe_/\|/gi;}
		elsif ($varName =~ /\btppn2\b/i)		{ $tcPropertyPatternName2= $varValue; $foundMatch = 1;}

		elsif ($varName =~ /\btppp2\b/i)  		{ $tcPropertyPatternPattern3= $varValue; $foundMatch = 1; $tcPropertyPatternPattern =~ s/_pipe_/\|/gi;}
		elsif ($varName =~ /\btppn2\b/i)		{ $tcPropertyPatternName3= $varValue; $foundMatch = 1;}

		elsif ($varName =~ /\bkeyValue\b/i)  		{ $tcPropertyPatternPattern= $varValue; $foundMatch = 1; $tcPropertyPatternPattern =~ s/_pipe_/\|/gi;}
		elsif ($varName =~ /\bkey\b/i)			{ $tcPropertyPatternName= $varValue; $foundMatch = 1;}

		elsif ($varName =~ /\btcFilters\b/i)  		{ 
			$varValue =~ /(.+)_matches_(.+)/; 
			$tcPropertyPatternName    = $1;
			$tcPropertyPatternPattern = $2;
			$foundMatch = 1;
		}

		elsif ($varName =~ /\bps1_args\b/i)		{ $ps1_args             = $varValue; $foundMatch = 1; $ps1_args =~ s/___/ /ig;}
		elsif ($varName =~ /\bsleep4Display\b/i)  	{ $sleep4Display 	= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btcDelay\b/i)  		{ $sleep4Display 	= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bc\b/i)  			{ $c		 	= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\b_TAF\b/i)  		{ $_TAF		 	= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bExecution_24_7\b/i)  	{ $Execution_24_7	= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bNofExecution\b/i)  	{ $NofExecution  	= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bExecutionLength\b/i)  	{ $ExecutionLength 	= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bExecutionType\b/i)  	{ $ExecutionType   	= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bperformanceMode\b/i)  	{ $performanceMode 	= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bpm\b/i)  			{ $performanceMode = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bpropertyOp\b/i)  		{ $propertyOp	   = $varValue; $foundMatch = 1; $propertyOp =~ s/_null_//ig;}
		elsif ($varName =~ /\bpo\b/i)  			{ $propertyOp	   = $varValue; $foundMatch = 1; $propertyOp =~ s/_null_//ig;}
		elsif ($varName =~ /\btsFilter\b/i)  		{ $tsFilter	   = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bSUTSymbol\b/i)  		{ $SUTSymbol       = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btsFilterDefault\b/i)  	{ $tsFilterDefault = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bnotUsegetTCName\b/i)  	{ $notUsegetTCName = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bTSHookName\b/i)  		{ $TSHookName      = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bTSHookNameGenerated\b/i)  { $TSHookNameGenerated  = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btestcaseNode\b/i)  	{ $testcaseNode    = $varValue; $foundMatch = 1; if ($testcaseNode =~ /_null_/) {$testcaseNode = "";}; }
		elsif ($varName =~ /\btestType\b/i)  		{ $testType        = $varValue; $foundMatch = 1; 
			#if ($testcaseNode !~ /^\s*$/) {
				if ($testType =~ /tc/i) { $testcaseNode = ".*";}
				if ($testType =~ /ts/i) { $testcaseNode = "testcase";}
				#}
		} 
		elsif ($varName =~ /\btsFrom\b/i)  		{ $tsFrom          = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btsTo\b/i)  		{ $tsTo            = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bmakeMark\b/i)  		{ $makeMark        = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bexitTAFGracefullyString\b/i) { $exitTAFGracefullyString = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bAutomationtsName\b/i)     { $AutomationtsName= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bresetTSFileName\b/i)      { $resetTSFileName = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bexitTAFTCId\b/i)          { $exitTAFTCId 	   = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btcComment1\b/i)            { $tcComment1	   = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btcComment2\b/i)            { $tcComment2	   = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bautomationRequest\b/i)     { $automationRequest = $varValue; $foundMatch = 1; &automationRequest();}
		elsif ($varName =~ /\bmessage\b/i)     	         { $message	   = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bexternalLogName\b/i)       { $externalLogName= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bexternalLogName\b/i)       { $externalLogName= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\boutputFormat\b/i)          { $outputFormat   = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bhtmlRefreshRate\b/i)       { $htmlRefreshRate= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bhtmlRefreshRateWebUI\b/i)  { $htmlRefreshRateWebUI= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bhtmlRefreshRateLogUI\b/i)  { $htmlRefreshRateLogUI= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bip\b/i)       		 { $ip		   = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\boverWriteTC\b/i)       	 { $overWriteTC    = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bTSHookIsPerl\b/i)       	 { $TSHookIsPerl   = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bcreateOrAppendTS\b/i)      { $createOrAppendTS=$varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btitleStatus\b/i)      	 { $titleStatus     =$varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bwebUITreeViewLevel\b/i)    { $webUITreeViewLevel =$varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bNofPropertyExec\b/i) 	 { $NofPropertyExec =$varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bsimulatedResults\b/i) 	 { $simulatedResults=$varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bNofTCinTSTemplate\b/i)     { $NofTCinTSTemplate=$varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bNofTSinTSTemplate\b/i)     { $NofTSinTSTemplate=$varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bindex_pl_arguments\b/i)    { $index_pl_arguments=$varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bmanual_result\b/i)         { $manual_result     =$varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bmanual_results\b/i)        { $manual_results    =$varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bcomment2\b/i)              { $comment2          =$varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bwebUIStyleColorHide\b/i)   { $webUIStyleColorHide=$varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btc_comment\b/i)   	 { $tc_comment      =$varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bblocking_time\b/i)   	 { $blocking_time   =$varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bNofExec\b/i)         	 { $NofExec         =$varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btags\b/i)       		 { $tags	    =$varValue; $foundMatch = 1;
		my $tmp = ""; foreach my $each (split (/_,_/, $tags)) { $tmp=$tmp."|".$each; } $tmp =~ s/\|_/_(/g; $tmp =~ s/_\s*$/)_/g; $tags =  $tmp;	
		}
	$url 			= 'file:///'.$SvrDrive;  		# will be updated in the sub-processTCs. Update derived Global Variable
	$urlHttp		= 'http://'.$ip.$http_port;		# will be updated in the sub-processTCs. Update derived Global Variable
	}
	 if (($lastAssign=~ /=/) && ($foundMatch == 0) && ($lastAssign !~ /create=/) && ($lastAssign !~ /Execution/i)) { print "INFO: Invalid Assginment $lastAssign  - ignored \n"; $foundMatch = 1;}
	$foundMatch;
	#### &printTAFGlobalVars(); todo Non-volatile GlobalVars
	#### Variable content verfication 
	##todo&updateTAFGlobalVars(); 
}

sub automationRequest {
	my $SvrProjName_C_no = &getTCName_C_no ($SvrProjName);
	if (-e "$c/$_TAF/$SvrProjName_C_no") {
		open FoutAutoReq, ">> $c/$_TAF/$SvrProjName_C_no/_automationRequest.txt";
		print FoutAutoReq "$automationRequest\n";
		close FoutAutoReq;
		print " ->> $c/$_TAF/$SvrProjName_C_no/_automationRequest.txt\n";

	}  else { mkpath "$c/$_TAF/$SvrProjName_C_no";
		open FoutAutoReq, "> $c/$_TAF/$SvrProjName_C_no/_automationRequest.txt";
		print FoutAutoReq "$automationRequest\n";
		close FoutAutoReq;
		print " -> $c/$_TAF/$SvrProjName_C_no/_automationRequest.txt\n";
	}

}

sub runPowershell {
	my $cmd = shift;  my $return; if ($cmd =~ /.ps1\s+/) { $cmd = "$cmd"; $return = `$cmd`;} else { $return = `$perl $cmd`; }
	$return =~ s/&/&amp;/g; $return =~ s/\%/&#37;/g; $return =~ s/\$/&#36;/g;
 	$return =~ s/\s+<\s+/ &lt; /g; $return =~ s/\s+>(\s+)/ &gt; $1/g;			# improvement : handle < > in tcDesc
 	$return =~ s/\s*\(\s*/ &#40;/g; $return =~ s/\s*\)(\s*)/ &#41;$1/g;			# improvement : handle < > in tcDesc
	$return =~ s/\|/&#166;/g;
	if ($return =~ /^\s*$/) { $return = "Testsuite has no Testcase";}		# bug fix on 2013/09/20
	return $return;
}

sub generateIndex_pyAnvil_pl {
	my $cwd = $SvrProjName; my $cmd = $SvrProjName. "\/index.ps1";
	open Fout, "> ".$cwd."/index_pyAnvil.pl";
print Fout<<EOF_;
############################ index_pyAnvil.pl ###################################
use strict;
&execTC(\$ARGV[0]);

sub execTC {
	my \$passFail='FAIL'; my \$logHtml; my \$logXml	;
	my \$pyAnvil= $c.'/pyAnvil/pyAnvil -s '		;
	my \$tcDir  = "$cwd\/"		;
	my \$testsuiteHook = "index.pl"			; 
	my \$tcId   = -1				; \$tcId   = shift if \@_;
	my \$tcDesc = "Testcase \$tcId Demo"		; \$tcDesc = shift if \@_;
	my \$tsDesc = "pyAnvil Testsuite Demo"		; \$tsDesc = shift if \@_; 

	\$testsuiteHook = \$tcDir.\$testsuiteHook		; 
	my \$tcScenario = "_tc.xml"			; \$tcScenario = \$tcDir."_tc.xml"	; 
	my \$tcLog_pyAnvil = "_tcLogAppend_.txt"         ; \$tcLog_pyAnvil = \$tcDir."\$tcLog_pyAnvil";
	if (\$tcId =~ /^\\s*\$/) { print `\$testsuiteHook`; return 0; }
my \$str=<<EOF;
<?xml version="1.0" encoding="utf-8"?>
<XMLTestCollection>
    <TestList TestCases="\$tcDesc">
	<ToolCase>
	    <Name>\$tcDesc</Name>
	    <Executable>$perl_</Executable>
	    <Parameters>\$testsuiteHook \$tcId</Parameters>
	    <StdoutContains>PASS</StdoutContains>
	</ToolCase>
    </TestList>
</XMLTestCollection>
EOF
	open Fout, ">\$tcScenario"; print Fout \$str; close Fout; my \$cmd = \$pyAnvil."\$tcScenario"; my \$rst = `\$cmd`; 
	foreach my \$each (split /\n/, \$rst) { 
		if (   \$each =~ /^\\s+PASS\\s+/)     { \$passFail = "PASS";}
		elsif (\$each =~ /^\\s+FAIL\\s+/)     { \$passFail = "FAIL";}
		elsif (\$each =~ /^\\s+XML:\\s+(.+)/) { \$logXml   = \$1;}
		elsif (\$each =~ /^\\s+HTML:\\s+(.+)/){ \$logHtml  = \$1;}
	}
open Fout, "> \$tcLog_pyAnvil "; print Fout "\$rst\n"; close Fout;  print "- > \$tcLog_pyAnvil\n"; 
	print "\$passFail\n"; 
}
############################ index_pyAnvil.pl ###################################
EOF_
	close Fout; print    "  -->".$cwd."/index_pyAnvil.pl\n";

}

sub generateDotSummaryBat {
	print " --> $c/$_TAF/_taf_dotSummary.bat\n";
	open FoutDotSummaryBat, "> $c/$_TAF/_taf_dotSummary.bat";
	for (my $ii = 1; $ii <= $NofTSinTSTemplate; $ii ++) {
		my $tsName=$SvrProjName; my $NofTC = $NofTCinTSTemplate ; my $NofExec = $NofExec;
		if ($NofTSinTSTemplate != 1) {
			$tsName = sprintf "%s%04d", $tsName, $ii;
		}
		my $cmd = "$c/$_TAF/taf.pl NofTCinTSTemplate=$NofTC;testsuite=$tsName;createTS;refreshHost";

		print FoutDotSummaryBat "$cmd\n";

		$tsName =~ s/c:\///g;
		for (my $i = 0; $i < $NofExec; $i++) {
		my $manual_results=""; for (my $i1 = 0; $i1 < $NofTC; $i1++) { my $random_number = rand(10); if ($random_number > 5) { $manual_results .= "pass,";} else { $manual_results .= "fail,";} } $manual_results =~ s/,\s*$//g;
		$cmd = "c:/_TAF/taf.pl manual_results=$manual_results;testsuite=$tsName;exec;refreshHost";
		print FoutDotSummaryBat "$cmd\n";
		}
	}
		close FoutDotSummaryBat;
}

sub generateExcelReport {
	my $key; my %listHistory; my %tcDesc; my @tcExecDateTime; my $tcExecDateTimeCtr=0; my $isPassFail = "n"; my $tsName= "MVSDK_OCSP"; my @columnWidth;
	# bug: _tc_Desc.txt and _list_history_tcRunResult are not genreated 	- fixed by NofPropertyExecCtr = 0; !!!!!!
	# bug: fix Execution_24_7: pr2Screen = 0 -> 1
	#my    $rst   = &processTCs ("","testsuite=$SvrProjName;AutomationtsName=$SvrProjName;pr2Screen=1;resetTSFileName=_list_history_tcRunResult.txt;resetTSFile;propertyOp=list_history_tcRunResult;pr2Screen=1");
	my    $rst   = &processTCs ("","testsuite=$SvrProjName;AutomationtsName=$SvrProjName;pr2Screen=0;resetTSFileName=_list_history_tcRunResult.txt;resetTSFile;propertyOp=list_history_tcRunResult;pr2Screen=1");
		$NofPropertyExecCtr=0; $propertyOp="";
	      $rst   = &processTCs ("","testsuite=$SvrProjName;AutomationtsName=$SvrProjName;pr2Screen=0;resetTSFileName=_list_tcDesc.txt;resetTSFile;propertyOp=list_tcDesc;pr2Screen=1"); 
		$NofPropertyExecCtr=0; $propertyOp="";
	my $tcDescMax=40; my $tcIdMax=10;
	if ( -e "$SvrDrive/$SvrProjName/_list_tcDesc.txt") {
		open Fin, "$SvrDrive/$SvrProjName/_list_tcDesc.txt" || die "Can't open file $!"; 
		while( $_ = <Fin>) {
		chop; 
		$_ =~ s/(list_)?tcDesc\s*=\s*(\d+\.)?//; 
		if ($_ =~ /testcase\d+(_)?\s+/) { @_ = split (/\t/, $_); 
			my $key = $_[0]; my $value = $_[1];	
			if ($_ =~ /\/_/)  {;} else { # exclude directory like /_ 
				$value = &removeTags($value);
					}
			$tcDesc{$key} = $value; 
			if (length($value) > $tcDescMax) { $tcDescMax = length ($value); }
			if (length($key) > $tcIdMax) { $tcIdMax = length ($key); }
		} 
		} 
	        close Fin;	
	} else { print "Info: $SvrDrive/$SvrProjName/_list_tcDesc.txt doesn't exist. Proceed ... (generateExcelReport won't work. Run -propertyOp=list_tcDesc)\n"; return 0 ;}

	$columnWidth[0]=$tcIdMax; $columnWidth[1]=$tcDescMax;

	if ( -e "$SvrDrive/$SvrProjName/_list_history_tcRunResult.txt") {
	open Fin, "$SvrDrive/$SvrProjName/_list_history_tcRunResult.txt" || die "Can't open file $!"; 
	while($_ = <Fin>) { chop; s/\s*=\s*/ /g;
		if ($_ =~ /list_history_tcRunResult/) { 
			if ($_ =~ /list_history_tcRunResult/) { $tcExecDateTimeCtr ++ ;}
			@_ = split (/\s+/, $_); 
			$_ =~ /(.+)\s+(.+)/;
			$key 	= $_[0]; my $value 	= $_[1];
			if ($_ =~ s/^.+list_history_tcRunResult//) {
				my $passFail=""; my $date="";
				if ($_ =~ /tcRunResult\s*(\S+)\s+\@\s+(\d\d\d\d-\d\d-\d\d\s+\d\d:\d\d:\d\d)/ ) {
				$passFail = $1; $date = $2; }
				if ($passFail =~ /pass|fail|\d+/i) { 
					my $tmp = $listHistory{$key};	# remove the unreasable error - concat undefined variables
					if ($tmp) {;} else { $tmp="";}
					$listHistory{$key} = $tmp."$passFail\t"; 
					$isPassFail = 'y';
				} else {$isPassFail = 'n'; }
				if (($isPassFail =~ /y/i) && ($tcExecDateTimeCtr == 1)) { push (@tcExecDateTime, $date) ;} 
;
			}
		} elsif ($_ =~ /tcRunResult/i) {
			my $passFail = ""; my $date = "";
			if ($_ =~ /tcRunResult\s*(\S+)\s+\@\s+(\d\d\d\d-\d\d-\d\d\s+\d\d:\d\d:\d\d)/) {
			$passFail = $1; $date = $2; 
			}
			if ($passFail =~ /pass|fail|\d+/i) { 
				my $tmp = $listHistory{$key};	# remove the unreasable error - concat undefined variables
				if ($tmp) {;} else { $tmp="";}
				$listHistory{$key} = $tmp."$passFail\t"; 
				$isPassFail = 'y';
			} else {$isPassFail = 'n'; }
			if (($isPassFail =~ /y/i) && ($tcExecDateTimeCtr == 1)) { push (@tcExecDateTime, $date) ;
} 
		} else {
			;
		}
	} 
	close Fin;
	} else { print "Info: $SvrDrive/$SvrProjName/_list_history_tcRunResult.txt doesn't exist. Proceed ... (generateExcelReport won't work. Run propertyOp=list_history_tcRunResult)\n"; return 0 ;}


open Fout, "> $SvrDrive/$SvrProjName/_generateExcelReport.txt";
open Fout1, "> $SvrDrive/$SvrProjName/_generateExcelReport.html"; print Fout1 "<html><title>$web_ui_title</title>$main_css\n";
		my $fhandle = \*Fout1; &prTopTitle($fhandle); print Fout1 "<body><pre>";
my $currentDate ="";

print Fout1 "<a href=\"http://$ip$http_port_IIS/$SvrProjName/_generateExcelReport.xlsx\">Excel</a><br>\n";
for (my $i = 0; $i <= $#tcExecDateTime; $i++) { 
	$tcExecDateTime[$i] =~ /(\d\d\d\d-\d\d-\d\d)\s+(\d\d:\d\d:\d\d)/; my $date = $1; my $time = $2; 
	if ($currentDate eq $date) { 
	$tcExecDateTime[$i] = $time; $columnWidth[$i+2] = length ($time); } elsif ($currentDate ne $date) { $currentDate = $date; $columnWidth[$i+2] = length ("$date $time"); }
} 

printf Fout "Test Suite Name: $AutomationtsName\n";
printf Fout1 "Test Suite Name: $AutomationtsName\n";

printf Fout "%-${tcIdMax}s\t%-${tcDescMax}s\t", "tcId", "Description"; for (my $i = 0; $i <= $#tcExecDateTime; $i++) { print Fout "($tcExecDateTime[$i])\t"; } print Fout "\n";
printf Fout1 "%-${tcIdMax}s %-${tcDescMax}s", "tcId", "Description"; for (my $i = 0; $i <= $#tcExecDateTime; $i++) { print Fout1 "($tcExecDateTime[$i])"; } print Fout1 "\n";

foreach my $each (sort keys %listHistory) { 
	my $each_ = $each; 
	if ($tcDesc{$each}) {
		printf Fout "%-$columnWidth[0]s\t%-$columnWidth[1]s\t", $each_, $tcDesc{$each};
		printf Fout1 "%-$columnWidth[0]s %-$columnWidth[1]s ", $each_, $tcDesc{$each};
	} else {	# for Test-AutomationFramework.t  
		printf Fout "%-$columnWidth[0]s\t%-$columnWidth[1]s\t", $each_, "";
		printf Fout1 "%-$columnWidth[0]s %-$columnWidth[1]s ", $each_, "";
	}

	my @fields = split (/\t/, $listHistory{$each}); 
	for (my $i=0; $i <= $#fields; $i++) {
		my $tmp;
		if ($columnWidth[$i + 2]) {;} else { $columnWidth[$i+2] = 10;}
		$tmp = $columnWidth[$i + 2] + 1;
		if ($tmp) {;} else { $tmp = $excelReportColumnWidth;} 
		printf Fout "%-${tmp}s\t", $fields[$i];
		printf Fout1 "%-${tmp}s ", $fields[$i];
	}
	print Fout "\n";
	print Fout1 "\n";
}

close Fout;
print Fout1 "</pre></body></html>\n";
close Fout1;

#### uncomment for debugging    print " -> $SvrDrive/$SvrProjName/_generateExcelReport.html\n";

my $excel_file = "$SvrDrive/$SvrProjName/_generateExcelReport.xlsx";
my $text_file =  "$SvrDrive/$SvrProjName/_generateExcelReport.txt";
  my($title, $headers, $datas) = &read_text_file($text_file, $text_delimiter);
  &generate_excel_file($excel_file, $title, $headers, $datas);

1;
}

########## txt2excel #########

# read excel file
sub read_excel_file {
  my($filename) = @_;

  my($title, @headers, @datas);

  my $ex = Win32::OLE->GetActiveObject('Excel.Application')
    || Win32::OLE->new('Excel.Application', 'Quit');

  $filename =~ s/\//\\/g;
  my $book  = $ex->Workbooks->Open($filename);

  $ex->{'Visible'} = 0;                    #0 is hidden, 1 is visible
  $ex->{DisplayAlerts} = 0;           		#0 is hide alerts

  # read from particular cell
  my $sheet = $book->Worksheets(1);
 
  my $last_row = $sheet->UsedRange->Find({What=>"*", SearchDirection=>'xlPrevious', SearchOrder=>'xlByRows'})->{Row};

  my $last_col = $sheet->UsedRange->Find({What=>"*", SearchDirection=>'xlPrevious', SearchOrder=>'xlByColumns'})->{Column};

  #print "max_row=$last_row, max_col=$last_col\n" if($debug);
  $title = $sheet->Cells(1,1)->{Value};

  for(my $i=1; $i<=$last_col; $i++) {
    push(@headers, $sheet->Cells(2,$i)->{Value});
  }

  for(my $i=3; $i<=$last_row; $i++) {
    my @data = ();

    for(my $j=1; $j<=$last_col; $j++) {
      push(@data, $sheet->Cells($i,$j)->{Value});
    }

    push(@datas, \@data);
  }

  $book->close;
  undef $book;
  undef $ex;

  return($title, \@headers, \@datas);

}

# generate excel file
sub generate_excel_file {
  my($filename, $title, $headers, $datas) = @_;

  my $ex; my  $book; my $sheet;
  $ex = Win32::OLE->GetActiveObject('Excel.Application');
  eval {$ex = Win32::OLE->GetActiveObject('Excel.Application')};
  die "Excel not installed: $@\n" if $@;

  unless (defined $ex) {
    $ex = Win32::OLE->new('Excel.Application', sub {$_[0]->Quit;})
      or die "Oops, cannot start Excel";
  }

  $ex = Win32::OLE->GetActiveObject('Excel.Application');

  $ex->{'Visible'} = 0;                    #0 is hidden, 1 is visible
  $ex->{DisplayAlerts} = 0;           		#0 is hide alerts

  # get a new workbook
  $book = $ex->Workbooks->Add;

  # write to a particular cell
  $sheet = $book->Worksheets(1);

  $sheet->Cells(1,1)->{Value} = $title;

  for(my $i=0; $i<@$headers; $i++) {
    $sheet->Cells(2,$i+1)->{Value} = $headers->[$i];
  }

  for(my $i=0; $i<@$datas; $i++) {
    for(my $j=0; $j<@{$datas->[$i]}; $j++) {
      $sheet->Cells($i+3,$j+1)->{Value} = $datas->[$i]->[$j];
    }
  }
  
  $sheet->Cells->EntireColumn->AutoFit(); 

  $book->SaveAs({Filename => $filename,
              FileFormat => 'xlWorkbookNormal'});  

  $filename =~ s/\//\\/g;
  $book->SaveAs($filename);
  undef $book;
  undef $ex;

}

# read text file
sub read_text_file {
  my($filename, $delimiter) = @_;

  my($title, @headers, @datas);

  my $iter = 0;
  open(IN, $filename) or die "Failed to read $filename: $!\n";
  while(my $line=<IN>) {
    chomp($line);

    next if($line =~ /^\s*$/);

    $iter +=1;
    if($iter == 1) {
      $title = $line;
    }
    elsif($iter == 2) {
      @headers = split("\\s*$delimiter\\s*", $line);
    }
    else {
      my @data = split("\\s*$delimiter\\s*", $line);
      
      push(@datas, \@data);
    }
  }

  close(IN);

  return($title, \@headers, \@datas);

}

# generate text file
sub generate_text_file {
  my($filename, $delimiter, $title, $headers, $datas) = @_;

# calculate maxlength for each column
  my @lines = @$datas;
  push(@lines, $headers);

  my %maxlength = ();
  foreach my $l(@lines) {
    for(my $i=0; $i<@$l; $i++) {
      my $l = length($l->[$i]);

      if(!defined $maxlength{$i}) {
        $maxlength{$i} = $l;
      }
      else {
        if($l > $maxlength{$i}) {
          $maxlength{$i} = $l;
        }
      }
    }
  }

# build sprinf left justify format
  my @ff=();
  foreach my $k(sort{$a<=>$b} keys %maxlength) {
    my $pad = $maxlength{$k} + 5;

    push(@ff, "%-${pad}s");
  }

  my $format = join($delimiter, @ff) . "\n";

  open(my $fh, ">$filename") or die "Failed to write to $filename: $!\n";
  print $fh $title, "\n";
  print $fh sprintf "$format", @$headers;

  foreach my $data(@$datas) {
    print $fh sprintf "$format", @$data;
  }

  close($fh);

}

########## txt2excel #########
sub generateIndex_pl {
	my $cwd = $workingDir; $cwd = shift if @_;
	open Fout, "> ".$cwd."/index.pl";
	my $ps1_args_ = $ps1_args;
	$ps1_args_ =~ s/\\/\//g;

print Fout<<EOF_;

##################### index.pl for pyAnvil ############################

my \$testsuiteHook = "powershell -executionpolicy unrestricted -file $cwd/index.ps1 ";
my \$testsuiteHookPartB = " \$ps1_args_";


if    (\$ARGV[1]) { print &call_index(\$ARGV[0], "noExec") ;	}  
elsif (\$ARGV[0]) { print &call_index(\$ARGV[0], "yesExec");    }
else             { print &call_index();                         }


sub call_index { 		my \$return ; my \$recordCtr=1;
	if (\@_) {;} else {; return `\$testsuiteHook \$testsuiteHookParkB`;}
	my \$indexCtr = 9999	; \$indexCtr = shift if \@_; 		 
	my \$execYN   = 'noExec' ; \$execYN   = shift if \@_; 
	\@_ = (split /\\n/, `\$testsuiteHook`) ;


	foreach \$each (\@_) { 
		if ((\$each) && (\$each =~ /^\\s*_/)) { \$return = \$return .\$each."\n";
		} elsif ((\$each) && (\$each !~ /^\\s*_/)) {
			\$return = \$return . sprintf "TC [%04s] %s\\n",\$recordCtr,\$each; 
			if ((\$recordCtr == \$indexCtr ) && ( \$execYN =~ /noExec/i )) { return "TC [\$recordCtr]       \$each"; } 
			if ((\$recordCtr == \$indexCtr ) && ( \$execYN =~ /yesExec/i)) { return `\$testsuiteHook \$indexCtr \$testsuiteHookPartB`  ; } 
			\$recordCtr++;
	  	} 
 	} 
	if (\$return =~ /pass/i) { return 0;} 
	if (\$return =~ /fail/i) { return 1;} 
}

##################### index.pl for pyAnvil ############################
EOF_
	close Fout; print    "  -->".$cwd."/index.pl\n";


}

sub generatePerl_pl_template {
	my $cmd = $SvrProjName; 
	if (-e $cmd) {;} else { mkdir $cmd; }
	mkpath $cmd;
	open Fout, "> $cmd/index.pl";
	my $tsNameTmp =	&getRoot($cmd);
print Fout<<EOF_;
#!$perl_
use Getopt::Long;
my \$descPattern = "_nothing_";

\$tcName = "$tsNameTmp";
if (\$^O =~ /win32/i) { \$_TAF = "$c"; } if (\$^O =~ /linux/i) { \$_TAF = "/tmp/var/www/cgi-bin"; } 
\$tcDir = "\$_TAF/\$tcName";

my \$result = GetOptions ( "descPattern=s"  		=> \\\$descPattern);



my \$desc=<<EOF;
1. Test case description 1 for | | < > \\\$ \\\% @ testing the function 1 --- Please modifyaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa _smoke_ _regression_
2. Test case description 2 for testing _smoketest__regressiontest_the function 2 --- Please modifybbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb _smoke_
3. Test case description 3 for testing _smoketest_the function 3 --- Please modifycddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd _regression_
4. Test case description 4 for testing _regressiontest_the function 4 --- Please modify _smoke_
5. Test case description 5 for testing _regressiontest_the function 5 --- Please modify
6. Test case description 6 for testing the function 6 --- Please modify
EOF
;

my \$index = 1; foreach \$each (split /\\n/, \$desc) { if (\$each =~ /\$descPattern/i) { push (\@ARGV, " \$index");  \$index++; } }

\$tcIndexMap[1] = 1;
\$tcIndexMap[2] = 2;
\$tcIndexMap[3] = 3;
\$tcIndexMap[4] = 4;
\$tcIndexMap[5] = 5;
\$tcIndexMap[6] = 6;




if (\$ARGV[0]) { 
	foreach my \$eachTC (\@ARGV) {
	if (\$eachTC =~ /^\\s*(-?\\d+)\\s*\$/) { \$eachTC = \$1;
	open Fout, ">\$tcDir/_tcLogAppend.txt";
		if ((\$eachTC == \$tcIndexMap[1]) || (\$eachTC == -1) ) { print &tc1(); } # <<< plug in the test case 1 here e.g. print `index.pl 1` ; >>>
		if ((\$eachTC == \$tcIndexMap[2]) || (\$eachTC == -1) ) { print &tc2(); } # <<< plug in the test case 2 here e.g. print `index.pl 2`>>>
		if ((\$eachTC == \$tcIndexMap[3]) || (\$eachTC == -1) ) { print &tc3(); } # <<< plug in the test case 3 here e.g. print `index.pl 3`>>>
		if ((\$eachTC == \$tcIndexMap[4]) || (\$eachTC == -1) ) { print &tc4(); } # <<< plug in the test case 4 here e.g. print `index.pl 4`>>>
		if ((\$eachTC == \$tcIndexMap[5]) || (\$eachTC == -1) ) { print &tc5(); } # <<< plug in the test case 5 here e.g. print `index.pl 5`>>>
		if ((\$eachTC == \$tcIndexMap[6]) || (\$eachTC == -1) ) { print &tc6(); } # <<< plug in the test case 6 here e.g. print `index.pl 6`>>>
	close Fout;
	}
	}
} else { print \$desc; }


sub tc1 { return \"null\"; } 
sub tc2 { return \"null\"; } 
sub tc3 { return \"null\"; } 
sub tc4 { return \"null\"; } 
sub tc5 { return \"null\"; } 
sub tc6 { return \"null\"; } 


EOF_
	close Fout;

	chmod (0660, $SvrProjName) or die "Couldn't chmod $SvrProjName: $!";

	print "\n[Warning] Creating Temporial testsuite hook --> [".$SvrProjName."/index.pl]\n"; ; 
}


sub generatePerl_pl_template_v0 {
	my $cmd = $SvrProjName; 
	if (-e $cmd) {;} else { mkdir $cmd; }
	mkpath $cmd;
	open Fout, "> $cmd/index.pl";
	my $tsNameTmp =	&getRoot($cmd);
print Fout<<EOF_;
#!$perl_
\$tcName = "$tsNameTmp";
if (\$^O =~ /win32/i) { \$_TAF = "$c"; } if (\$^O =~ /linux/i) { \$_TAF = "/tmp/var/www/cgi-bin"; } 
\$tcDir = "\$_TAF/\$tcName";


if (\$ARGV[0]) { 
	open Fout, ">\$tcDir/_tcLogAppend.txt";
	if (\$ARGV[0] == 1) { print &tc1(); } # <<< plug in the test case 1 here e.g. print `index.pl 1` ; >>>
	if (\$ARGV[0] == 2) { print &tc2(); } # <<< plug in the test case 2 here e.g. print `index.pl 2`>>>
	if (\$ARGV[0] == 3) { print &tc3(); } # <<< plug in the test case 3 here e.g. print `index.pl 3`>>>
	if (\$ARGV[0] == 4) { print &tc4(); } # <<< plug in the test case 4 here e.g. print `index.pl 4`>>>
	if (\$ARGV[0] == 5) { print &tc5(); } # <<< plug in the test case 5 here e.g. print `index.pl 5`>>>
	if (\$ARGV[0] == 6) { print &tc6(); } # <<< plug in the test case 6 here e.g. print `index.pl 6`>>>
	close Fout;
} else {
print \<\<EOF;
1. Test case description 1 for | | < > \\\$ \\\% @ testing the function 1 --- Please modifyaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa _smoke_ _regression_
2. Test case description 2 for testing _smoketest__regressiontest_the function 2 --- Please modifybbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb _smoke_
3. Test case description 3 for testing _smoketest_the function 3 --- Please modifycddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd _regression_
4. Test case description 4 for testing _regressiontest_the function 4 --- Please modify _smoke_
5. Test case description 5 for testing _regressiontest_the function 5 --- Please modify
6. Test case description 6 for testing the function 6 --- Please modify
EOF
;
}


sub tc1 { return \"null\"; } 
sub tc2 { return \"null\"; } 
sub tc3 { return \"null\"; } 
sub tc4 { return \"null\"; } 
sub tc5 { return \"null\"; } 
sub tc6 { return \"null\"; } 

EOF_
	close Fout;
	print "\n[Warning] Creating Temporial testsuite hook --> [".$SvrProjName."/index.pl]\n"; ; 
}

sub generatePowershell_ps1_template {
	my $cmd = $SvrProjName; 
	open Fout, "> $cmd/index.ps1";
	my $tsNameTmp =	&getRoot($cmd);
	my $tmpWorkingDir = $tsNameTmp; $tmpWorkingDir =~ s/\\/\//g;
print Fout<<EOF_;

###########################
param([INT]\$index = "-1", \$buildpath="")

if(\$verbose -eq \$true) { cls }

\$subHtml = "/auto_html/LBP_automation.html"
\$index = \$index -1 		
######################################################################################
# Dictionary for pre-canned test scenarios.
######################################################################################
\$testDictionary = \@()

\$testDictionary += \@( `
		\@{	"desc" = "Testcase1 description $SvrProjName"; 
			"result" = "PASS";
		} `
)
\$testDictionary += \@( `
		\@{	"desc" = "Testcase2 description $SvrProjName _smoketest_ _regression_ _regressiontest_"; 
			"result" = "FAIL"; 
		} `
)
\$testDictionary += \@( `
		\@{	"desc" = "Testcase3 Description $SvrProjName _smoketest_ _regression"; 
			"result" = "FAIL"; `
		} `
)
\$testDictionary += \@( `
		\@{	"desc" = "Testcase4 Description $SvrProjName _smoketest_"; `
			"result" = "PASS"; `
		} `
)


################################################################################################

\$idx = [Int32]::Parse(\$index)
\$testDictionaryCount =  \$testDictionary.length - 1
\$count = 1
if((\$idx -lt 0) -or (\$idx -gt \$testDictionaryCount)) 
{
	foreach(\$dictionaryDesc in \$testDictionary) 
	{
		Write-Host "\$count :"\$dictionaryDesc.desc
		\$count++
	}
	exit
}

write-host \$testDictionary[\$idx].result;



###########################

EOF_
	close Fout;
	print "\n[Warning] Creating Temporial testsuite hook --> [".$SvrProjName."/index.ps1]\n"; ; 
}

sub eraseTAFTestsuite {goto &deleteTAFTestsuite}


sub deleteTAFTestsuite {
        my $c_ = $c; my $_TAF_ = $_TAF; my $SvrProjName_ = $SvrProjName;
        if (($SvrProjName_ =~ /^$c_/ ) || ($^O =~ /linux/i)) {
        	if ($^O =~ /win/i) { $SvrProjName_ =~ s/^$c//;}
        	my $TSDir = "$c/$_TAF/$SvrProjName_"; $TSDir =~ s/\/\//\//g;
                if ( -e $TSDir ) {
			unlink glob "$TSDir/index*.*";
			unlink glob "$TSDir/_*";
			# rmtree $TSDir;
                        print "Delete TAF Testsuite $TSDir\n";
			&generateRootIndex();
			# &refreshHost();
                } else {
                        print "Warning: TAF Testsuite $c_/${_TAF}$SvrProjName_ doesn't exist!\n";
                }
        } else {
                print "\nWarning: $SvrProjName_ is NOT a TAF testsuite. \n($SvrProjName_ !~ $c_)\n\n";
        }
}

########### index2index

sub index2index {       #### Generate subIndex from TAF-generate-index.pl       # input $tcDir, $matchStr
	my $tcDir = $SvrProjName; 
	my $matchStr = "2013.09.13"; $matchStr = shift if @_;
        my @tcExec_; my @tcDesc_;        my $is_tcDesc="n";  my %tcDesc_; my %tcExec_;
        if (-e "$tcDir/index.pl") {;} else {print "Warning: There is no $tcDir/index.pl. taf.pl exits\n"; exit; }
        open Fin, "$tcDir/index.pl"; my @index = <Fin>; close Fin;
        foreach my $each (@index) {
                if ($each =~ /ARGV\[0\]\s*==/) 	{ push (@tcExec_, $each); }
                if ($each =~ /print\s*<<EOF;/) 	{ $is_tcDesc = 'y'; }
                elsif ($each =~ /^EOF\b/) 	{ $is_tcDesc = 'n'; }
                elsif ($is_tcDesc =~ /y/i) 	{ chop $each; 
			push (@tcDesc_, $each);} 
	}

	my $ctrctr=1;
	print " -> $tcDir/_tcMap.txt\n";
	if ( -e "$tcDir/_tcMap.txt" ) { open Foutmap, ">> $tcDir/_tcMap.txt"; } else { open Foutmap, "> $tcDir/_tcMap.txt"; }
        for (my $i = 0; $i <= $#tcDesc_; $i++ )  {
                if ($tcDesc_[$i] =~ /$matchStr/i) {
			my $tmp = $tcDir; 
			printf Foutmap "$tmp/testcase%04d => $tmp/$matchStr/testcase%04d\n", $i+1, $ctrctr; $ctrctr++;
                $tcDesc_{$i} = $tcDesc_[$i];
                $tcExec_{$i} = $tcExec_[$i];
                } else {
			my $tmp = $tcDir;
			printf Foutmap "$tmp/testcase%04d => $tmp/testcase%04d\n", $i+1, $i+1;

		}
        }
	close Foutmap;

if (-e "$tcDir/$matchStr") {;} else { mkpath ("$tcDir/$matchStr"); print " -dir-> $tcDir/$matchStr\n";} #### create new TS dir

open INDEX , ">$tcDir/$matchStr/index.pl";
print INDEX <<EOF;
#!/usr/bin/perl.exe
\$tcName = "subTestsuit";
 if (\$^O =~ /win32/i) { \$_TAF = "c:"; } if (\$^O =~ /linux/i) { \$_TAF = "/tmp/var/www/cgi-bin"; }
 \$tcDir = "\$_TAF/\$tcName";

 if (\$ARGV[0]) {
        open Fout, ">\$tcDir/$matchStr/_tcLogAppend.txt";
EOF
my $ctr = 1;
foreach my $each ( sort keys %tcExec_) { 
	my $tmp = $tcExec_{$each}; 	
	$tmp =~ s/==\s*(\d+)\s*\)/== $ctr )/; $ctr++;
	print INDEX $tmp;
}
print INDEX <<EOF;
        close Fout;
        } else {
EOF
print INDEX "\nprint<<EOF;\n";
   $ctr = 1;
foreach my $each (sort keys %tcDesc_) { print INDEX $ctr++.". $tcDesc_{$each}\n"; }

print INDEX "EOF\n}\n";

close INDEX;
print " -> $tcDir/$matchStr/index.pl\n";
}

########### index2index


sub generateTAFTestsuite {goto &generateTestsuite}
sub generateTestsuite { 						# Generating 1. index.pl 2. index.pl + index_pyAnvil.pl 



 	$performanceMode		= "fast4cmd"; 			# fast4cmd
	my $cmd = $SvrProjName ;  $cmd = shift if @_;

	if ($SvrProjNameSub !~ /^\s*$/) { &index2index($SvrProjNameSub);  exit;}
       

	if ( $^O =~ /win32/i ) {	# window only logic
		if ($cmd !~ /$c\//i) { $cmd = $c.'/'.$_TAF.'/'.$cmd; }
	}

	$cmd =~ s/\/\//\//g;		# Fix the // problem in the linux coding

	my $cwd = $cmd;
	### create host reportSummaryDot file 
	if (-e "$c/$_TAF/$reportHtmlSummaryDot") {;} else {
		open FoutSummaryDot, "> $c/$_TAF/$reportHtmlSummaryDot";
		print FoutSummaryDot "";
print FoutSummaryDot<<EOF_summaryDot;
<link rel='stylesheet' href="/main.css" type='text/css' media='all' />
EOF_summaryDot
		close FoutSummaryDot;
	}

	if ( -e $cwd) {;} else { mkpath $cwd;		#### bug fix 
	if ($tsDriver =~ /null/i) { $tsDriver = "$cmd\/index.pl"; }	
		&generatePerl_pl_template();	
	}				
	if (-e "$cmd\/index.ps1") { $cmd = $cmd . "\/index.ps1";	#### pre-existing testsuiteHook is index.ps1 
		&generateIndex_pl ($cwd)			  ; 	# --> generate index.pl 
		$cmd =~ s/index.ps1/index.pl/; 
		}
	elsif (-e "$cmd\/index.pl")     { 
		$cmd = $cmd . "\/index.pl";}				#### pre-existing testsuiteHook is index.pl 
	else  { 							####  No pre-existing index.pl 
		if ($tsDriver =~ /null/i) { $tsDriver = "$cmd\/index.pl"; }	
		&generatePerl_pl_template();
	}								
	##############################################  subroutine Main ###########################################
	$cmd = shift if @_; my $testsuiteName="_default_testsuiteblas_"; my $testsuitePropertyFName=$tsProperty_txt; my $testDriverName = $cmd; 
	my $tsPropertyStr = "web_ui_title: "; my $tcCtr=1; my $TAF= $SvrDrive ;
 	$testsuiteName = &getRoot_4($cwd);  			############ $testsuiteName = &getRoot(&getcwd());  


	### create TS reportSummaryDot file 
	if (-e "$c/$_TAF/$testsuiteName/$reportHtmlSummaryDot") {;} else {
		mkpath "$c/$_TAF/$testsuiteName";
		open  FoutSummaryDot, ">$c/$_TAF/$testsuiteName/$reportHtmlSummaryDot";
		print FoutSummaryDot "";
print FoutSummaryDot<<EOF_summaryDot;
<link rel='stylesheet' href="/main.css" type='text/css' media='all' />
EOF_summaryDot
		close FoutSummaryDot;
	}

if ($^O =~ /win32/i) { $testsuiteName =~ s/^\s*$_TAF//g; }
	if (($TSHookIsPerl =~ /y/i) && ($cmd =~ /index\.ps1\s*$/))    { $cmd =~ s/index\.ps1\s*$/index\.pl /g;}	 

	############ Generate Property file for webUI tc description
	if ($ps1_args =~ /^\s*$/) { $ps1_args = "-ps1_args powershell_args";}
 	if ($cmd =~ /\.ps1\s*$/) { $cmd = "powershell -executionpolicy unrestricted -file ". $cmd. " $ps1_args"; }

	foreach my $each (split "\n", &runPowershell($cmd)) {	# get testsuiteName _testsuitename_: (\w+)and _testdrivername_: (\w+)
		if    ($each =~ /_testsuitename_/i)  { $each =~ /_testsuitename_\s*:\s*(.+)\s*$/i;  $testsuiteName  = $1; if ($testsuiteName =~ /\s/) { print "white space in testsuitename\n";exit; }}
		elsif ($each =~ /_testdrivername_/i) { $each =~ /_testdrivername_\s*:\s*(.+)\s*$/i; $testDriverName = $1; }
		else { ; }
	}
####  <--$cmd       _testsuitename_ : [$testsuiteName] 
####  <--$cmd       _testdrivername_: [$testDriverName] 
$testsuiteName =~ s/^\///g; # linux
print<<EOF;
  <-- $cmd 
  --> $c/$_TAF/$testsuiteName ...... (Can take several minutes)
EOF

	if ($web_ui_title =~ /Test Automation Framework/) {$tcCtr=1; $tsPropertyStr = $tsPropertyStr . " $testsuiteName : web_ui_title\n";} # overwrite web_ui_title 
	else {$tcCtr=1; $tsPropertyStr = $tsPropertyStr . " $web_ui_title: web_ui_title\n";}

	foreach my $each (split "\n", &runPowershell($cmd)) { # get testsuitePropertyString
		if    ($each =~ /_testsuitename_/i)  { $each =~ /testsuitename_\s*:\s*(.+)\s*$/i;	$testsuiteName  = $1; }
		elsif ($each =~ /_testdrivername_/i) { $each =~ /testdrivername_\s*:\s*(.+)\s*$/i; 	$testDriverName = $1; }
		elsif ($each =~ /^\s*\n/i) { ; }
		elsif ($each =~ /^\s*$/i) { ; }
		else { 
			my $cgi_fname = sprintf "$c/$_TAF\/$testsuiteName\/testcase%04d/tc.cgi", $tcCtr;
			my $testcase  = sprintf "testcase%04d", $tcCtr;
			if ($each =~ /^\s*\d/) { 		#### Fix duplicated serial # problem  - double serial # problem
			$tsPropertyStr = $tsPropertyStr . sprintf "$c/$_TAF\/$testsuiteName\/testcase%04d\|%s\n", $tcCtr, $each; $tcCtr++;
	  		} else {	
			$tsPropertyStr = $tsPropertyStr . sprintf "$c/$_TAF\/$testsuiteName\/testcase%04d\|%4d  %s\n", $tcCtr, $tcCtr, $each; $tcCtr++;
			}
		} 
	}
	############ Generate Property file for webUI tc description

	############ add tcDesc Property #############

	my $tcCtr_ = 0;
	foreach my $each (split "\n", &runPowershell($cmd)) { # get testsuitePropertyString
		if    ($each =~ /_testsuitename_/i)  { $each =~ /testsuitename_\s*:\s*(.+)\s*$/i;	$testsuiteName  = $1; }
		elsif ($each =~ /_testdrivername_/i) { $each =~ /testdrivername_\s*:\s*(.+)\s*$/i; 	$testDriverName = $1; }
		elsif ($each =~ /^\s*\n/i) { ; }
		elsif ($each =~ /^\s*$/i) { ; }
		else { 
			$each =~ s/\s/_space_/g;
			$each =~ s/:/_column_/g;
			$each =~ s/=/_eq_/g;
			$tcDesc[$tcCtr_] = $each ; $tcCtr_ ++; 
			$propertyOp = "tcDescAuto";
		} 
	}
	############ add tcDesc Property #############
	############ Generate Tags Property ################

	my @tcDescPropertyList; my $ctr=0; my $maxPropertyNameLength=1; my %propertyList;

	foreach my $each (split "\n", &runPowershell($cmd)) { # get testsuitePropertyString
		$each =~ s/__/_ _/g; @_ = ($each =~ /_\w+_/gi ) ; 
		for (my $i=0; $i <= $#_;$i++) { $propertyList{$_[$i]}=$_[$i];
			if ($maxPropertyNameLength < length($propertyList{$_[$i]})) { $maxPropertyNameLength = length($propertyList{$_[$i]}); }
		}
	}
	############ Generate Tags Property ################

	############ Create Testsuite/Testcase
	$tcCtr=1;
	foreach my $each (split "\n", &runPowershell($cmd)) { # get testsuitePropertyString
		if    ($each =~ /_testsuitename_/i)  { $each =~ /testsuitename_\s*:\s*(.+)\s*$/i;	$testsuiteName  = $1; }
		elsif ($each =~ /_testdrivername_/i) { $each =~ /testdrivername_\s*:\s*(.+)\s*$/i; 	$testDriverName = $1; }
		elsif ($each =~ /^\s*\n/i) { ; }
		elsif ($each =~ /^\s*$/i) { ; }
		else { 
			if ($tsDriver !~ /null/) { $testDriverName = $tsDriver; } # tsDriver overwrite testDriverName
			#### todo: need to decide to generate pl or ps1 
		
			my $ps1_args_; my $cmd_; 	
			if (    $cmd =~ /index\.ps1\s*$/) {
				$ps1_args_ = $ps1_args; $ps1_args_ =~ s/ /___/g; $ps1_args_ =~ s/\\/\//g; # ps1_args 
				$cmd_ = sprintf "ps1_args=$ps1_args_;testsuite=$testsuiteName;create=testcase%04d/customTC:${testDriverName}_space_${tcCtr}:customTC\n", $tcCtr  ; 
			} elsif ( $cmd =~ /index\.pl\s*$/) {
				$cmd_ = sprintf "testsuite=$testsuiteName;create=testcase%04d/customTC:${testDriverName}_space_${tcCtr}:customTC\n", $tcCtr  ; 
			}

			&processTCs("",$cmd_);

			#my $tcnameTmp = sprintf "$c/$_TAF/$testsuiteName/testcase%04d", $tcCtr++;
			my $tcnameTmp = sprintf "$c/$_TAF/$testsuiteName/testcase%04d", $tcCtr;
			my $propertyTmp = $each;
			$propertyTmp =~ s/ /_space_/g; 
			$propertyTmp =~ s/:/_column_/g; 
			$propertyTmp =~ s/=/_eq_/g; 
			$propertyTmp =~ s/ /__/g; 
			&processProperty("",$tcnameTmp, "set_tcDesc_as_$propertyTmp");
			foreach $each (split (",", $tags)) { if ($propertyTmp =~ /$each/i) { &processProperty("",$tcnameTmp, "_add_${each}_as_y"); } }

			$propertyTmp=""; #### reuse the variable
			foreach my $propertyName (sort keys %propertyList) {
				if ($each=~ /\b$propertyName\b/i) {
					$propertyTmp = sprintf "$propertyTmp%-${maxPropertyNameLength}s",$propertyName;
				} else {
					$propertyTmp = sprintf "$propertyTmp%-${maxPropertyNameLength}s","_null_";
				}
			}
			$propertyTmp =~ s/ /_space_/g; 
			$propertyTmp =~ s/:/_column_/g; 
			$propertyTmp =~ s/=/_eq_/g; 
			$propertyTmp =~ s/ /__/g; 
			&processProperty("",$tcnameTmp, "set_tcTags_as_$propertyTmp");


			################
						my $cgi_fname = sprintf "$c/$_TAF\/$testsuiteName\/testcase%04d/tc.cgi", $tcCtr;
						my $cgi_TC_args  = sprintf "$c/$_TAF\/$testsuiteName\/testcase%04d/tc_args.txt", $tcCtr;
						my $cgi_TC_note  = sprintf "$c/$_TAF\/$testsuiteName\/testcase%04d/tc_note.txt", $tcCtr;
						my $cgi_TC_vali  = sprintf "$c/$_TAF\/$testsuiteName\/testcase%04d/tc_vali.txt", $tcCtr;
						my $cgi_TC_prop  = sprintf "$c/$_TAF\/$testsuiteName\/testcase%04d/tc_prop.txt", $tcCtr;
						my $cgi_TC_defi  = sprintf "$c/$_TAF\/$testsuiteName\/testcase%04d/index.txt", $tcCtr;
						my $cgi_TC_exec  = sprintf "$c/$_TAF\/$testsuiteName\/testcase%04d/tc_exec.txt", $tcCtr;
						my $cgi_TC_step  = sprintf "$c/$testsuiteName\/manual_tc_testcase%04d.txt", $tcCtr;
						my $cgi_TC_cmd   = sprintf "$c/$testsuiteName\/cmd.txt", $tcCtr;


			if (-e $cgi_TC_args) {;} else { open Fout_tmp, ">$cgi_TC_args"; close Fout_tmp; }
			if (-e $cgi_TC_note) {;} else { open Fout_tmp, ">$cgi_TC_note"; close Fout_tmp; }
			if (-e $cgi_TC_vali) {;} else { open Fout_tmp, ">$cgi_TC_vali"; close Fout_tmp; }
			if (-e $cgi_TC_prop) {;} else { open Fout_tmp, ">$cgi_TC_prop"; close Fout_tmp; }
			if (-e $cgi_TC_cmd ) {;} else { open Fout_tmp, ">$cgi_TC_cmd" ; close Fout_tmp; }
			if (-e $cgi_TC_defi) {;} else { open Fout_tmp, ">$cgi_TC_defi"; close Fout_tmp; }
			if (-e $cgi_TC_exec) {;} else { open Fout_tmp, ">$cgi_TC_exec"; close Fout_tmp; }
						      { open Fout_tmp, ">$cgi_TC_note";
print Fout_tmp<<EOF_Fout_tmp;
$testsuiteName/testcase$tcCtr Manual Test Steps (Tamplate)
Test Purpose: Evaluate calc function 

Manual Test Steps:
	1. start calc
	2. input "1 + 2"
	3. press "="
	4. verify result = 3

EOF_Fout_tmp
			    								close Fout_tmp; }

			                          if ($cgi_TC_step ) {
							  copy ($cgi_TC_step, $cgi_TC_note);
							  ;
						  } 
						  else { open Fout_tmp, ">$cgi_TC_step";
print Fout_tmp<<EOF_Fout_tmp;
$testsuiteName/testcase$tcCtr Manual Test Steps (Template)
Test Purpose: Evaluate calc function 

Manual Test Steps:
	1. start calc
	2. input "1 + 2"
	3. press "="
	4. verify result = 3

EOF_Fout_tmp
			    								close Fout_tmp; }

## tc.cgi CGICGI	
			my $testcase  = sprintf "testcase%04d", $tcCtr;
			if (-e "$c/$_TAF/$testsuiteName") {;} else { mkpath "$c/$_TAF/$testsuiteName"; }
			open Fout_CGI, "> $cgi_fname"; sleep 1;
			
print Fout_CGI<<EOF_CGI;
#use Date::Manip;
use CGI qw/:standard/;
my %desc;
my \$desc;
my \$web_ui_title = "Test Automation Framework";
my \$index_http_htm = "index_http.htm";
my \$ip  	    = \"$ip\";

print header, start_html('TAF Manual Test Management'), " $main_css_raw ", h2("");
my \$fhandle = \\*STDOUT; &prTopTitle(\$fhandle); 

if ( !param() ) { 
#\$cmd = "$c/$_TAF/$taf pr2Screen=0;testsuite=$SvrProjName;testcase=$testcase;propertyOp=_all_4_display_doit_"; \$defaultProperty = `\$cmd`; \$defaultProperty = "--- $c/$testsuiteName/$testcase/_thProperty.txt ---".\$defaultProperty; 
#\$cmd = "$c/$_TAF/$taf pr2Screen=0;testsuite=$SvrProjName;testcase=$testcase;propertyOp=display_note_doit_"; \$tcNote          = `\$cmd`; if (\$tcNote =~ /^\\s*\$\/) { \$tcNote = "Test Note"; } 
#\$cmd = "$c/$_TAF/$taf pr2Screen=0;testsuite=$SvrProjName;testcase=$testcase;propertyOp=display_arguments_doit_"; \$tcArguments = `\$cmd`;
#\$cmd = "$c/$_TAF/$taf pr2Screen=0;testsuite=$SvrProjName;testcase=$testcase;propertyOp=display_validator_doit_"; \$tcValidator= `\$cmd`;
#\$cmd = "$c/$_TAF/$taf pr2Screen=0;testsuite=$SvrProjName;testcase=$testcase;propertyOp=display_definition_doit_"; \$tcDefinition= `\$cmd`;
#\$cmd = "$c/$_TAF/$taf pr2Screen=0;testsuite=$SvrProjName;testcase=$testcase;propertyOp=display_executor_doit_"; \$tcExecutor= `\$cmd`;  \$tcExecutor =~ s/_\\|_//gi;


# \$defaultProperty = &readFile("$c/$_TAF/$SvrProjName/$testcase/thProperty.txt"); \$defaultProperty = "--- $c/$testsuiteName/$testcase/thProperty.txt ---".\$defaultProperty; 
\$defaultProperty = &readFileThProperty("$c/$_TAF/$SvrProjName/$testcase/thProperty.txt"); \$defaultProperty = "--- $c/$testsuiteName/$testcase/thProperty.txt ---".\$defaultProperty; 
\$tcNote          = &readFile("$c/$_TAF/$SvrProjName/$testcase/tc_note.txt"); if (\$tcNote =~ /^\\s*\$\/) { \$tcNote = "Test Note"; } 
\$tcNote          = &readFile("$c/$SvrProjName/$testcase/ManualSteps.txt"); if (\$tcNote =~ /^\\s*\$\/) { \$tcNote = "Test Note"; } 
\$tcArguments 	  = &readFile("$c/$_TAF/$SvrProjName/$testcase/tc_args.txt"); 
\$tcValidator 	  = &readFile("$c/$_TAF/$SvrProjName/$testcase/tc_vali.txt"); 
\$tcDefinition	  = &readFile("$c/$_TAF/$SvrProjName/$testcase/tc_def.txt"); 
\$tcExecutor      = &readFile("$c/$_TAF/$SvrProjName/$testcase/tc_exec.txt"); \$tcExecutor =~ s/_\\|_//gi;

&readTSProperty (); 	# saved in \$desc
\@_ = split /\\n|\\r/, \$tcNote; 
print start_form();
print "Test Management ($c/$testsuiteName/$testcase) ";
print "&nbsp;&nbsp;&nbsp;&nbsp" ;
print "&nbsp;&nbsp;&nbsp;&nbsp" ;
print "&nbsp;&nbsp;&nbsp;&nbsp" ;
print submit(-value=>'Update Manual Result',-name=>"UpdateTCManualResult");
print "<br>";
print radio_group(-name=>'Result', -rows=>1, -values=>['pass','fail','null','bug fix','dummy','task','mark'], -default=>'null', -linebreak=>'true', -labels=>\\%labels, -attributes=>\\%attributes);
print "<br>";
print textarea(-name=>'ManualTestNote', -id=>'textarea-adjustable-width', -default=>\$tcNote, -rows=>\$#_, -columns=>90). "<br><br>";
print "Test Automation ($c/$testsuiteName/$testcase) "; print '<a href="http://${ip}$http_port_IIS/$testsuiteName/index.cgi"> Test Semi-Manual-Auto Execution</a>'; 
print "&nbsp;&nbsp;&nbsp;&nbsp" ;
print "&nbsp;&nbsp;&nbsp;&nbsp" ;
#print submit(-value=>'New TC',-name=>"createTC");
print "<br><br>";

#print textfield(-name=>'tcExecutor', -default=>\$tcExecutor, -rows=>1, -size=>50);
#print "&nbsp;&nbsp;&nbsp;&nbsp" ;
#print textfield(-name=>'index_arguments', -default=>\$tcArguments, -rows=>1, -size=>20);
#print "&nbsp;&nbsp;&nbsp;&nbsp" ;
#print "&nbsp;&nbsp;&nbsp;&nbsp" ;

print textfield(-name=>'tcExecutor', -default=>"\$tcExecutor  \$tcArguments", -rows=>1, -size=>80);
print "&nbsp;&nbsp;&nbsp;&nbsp" ;
print "matches &nbsp;&nbsp;";
print  textfield(-name=>'tc_validator', -default=>\$tcValidator, -rows=>1, -size=>22);
print "&nbsp;&nbsp;&nbsp;&nbsp" ;
print "&nbsp;&nbsp;&nbsp;&nbsp" ;
print "&nbsp;&nbsp;&nbsp;&nbsp" ;
print "<br>";
print "<br>";
print "Test Definition ($c/$testsuiteName/$testcase)";
print "&nbsp;&nbsp;&nbsp;&nbsp" ;
print "&nbsp;&nbsp;&nbsp;&nbsp" ;
print "&nbsp;&nbsp;&nbsp;&nbsp" ;
print submit(-value=>'Update Definition',-name=>"UpdateTCDefinition");
print "<br><br>";
print textarea(-name=>'tcDefinition', -id=>'textarea-adjustable-width', -default=>\$tcDefinition, -wrap=>'OFF', -rows=>10, -columns=>90). "<br><br>";
print "Test Properties ($c/$testsuiteName/$testcase)";
print "&nbsp;&nbsp;&nbsp;&nbsp" ;
print "&nbsp;&nbsp;&nbsp;&nbsp" ;
print "&nbsp;&nbsp;&nbsp;&nbsp" ;
print submit(-value=>'Update Properties',-name=>"UpdateTCProperties");
print "<br>";
print "<br>";
print textarea(-name=>'TCProperty', -id=>'textarea-adjustable-width', -default=>\$defaultProperty, -wrap=>'OFF', -rows=>10, -columns=>90). "<br><br>";

print endform;

} else { 
\$value_Note   = param('ManualTestNote'); \$value_Result = param('Result'); \$value_index_arguments= param('index_arguments');  \$value_updateTCManualResult = param('UpdateTCManualResult');
\$value_CreateNewTC = param('CreateNewTC'); \$value_validator = param('tc_validator'); 
\$value_UpdateTCProperties = param('UpdateTCProperties');
\$value_UpdateTCDefinition= param('UpdateTCDefinition');
\$value_tcProperties = param('TCProperty');
\$value_tcExecutor   = param('tcExecutor');
\$value_UpdateTSProperties = param('UpdateTSProperties');
\$value_UpdateTSDefinition = param('UpdateTSDefinition');
\$value_tcDefinition  = param('tcDefinition');
\$value_createTC= param('createTC');
\$value_validator =~ s/^\\s*//g;
\$value_validator =~ s/\\s*\$//g;
\$value_tcProperties =~ s/\\r//g;
\$value_tcDefinition=~ s/\\r//g;
\$value_tcExecutor  =~ s/\\r//g;

\$value_Result =~ s/Bug\\s*Fix/bugf/gi;
\$value_Result =~ s/Dummy/dumy/gi;
\$value_Result = lc \$value_Result;


if (\$value_updateTCManualResult =~ /Update/i) { 
if (\$value_Result =~ /plan/i) {
print<<EOF_;
<a href=\"http://$ip$http_port\/index_http.htm\">Manual Test </a> is updated 
EOF_
} else {
print<<EOF_;
<a href="http://${ip}$http_port_IIS//taf.cgi?tafArgs=Execution_from_cgi=y_semi_Execution_local_only=n_semi_SysDrive=$c/${_TAF}_semi_tcPropertyPatternName=tcRunResult_semi_tcPropertyPatternPattern=.*_semi_testsuit=${testsuiteName}_semi_testcase=${testcase}_semi_ExecutionType=runTC_semi_manual_result=\${value_Result}_semi_comment2=\${value_Note}_semi_exec_semi_perl_index_arguments=\${value_index_arguments}_semi_generateTCArguments;tafRedirectory=http://${ip}$http_port_IIS/$testsuiteName/index_http.htm" title="Run Test (manual_result = \$value_Result, Note = \$value_Note )">Click to Set (Manual Test = \$value_Result)</a>
EOF_
	}
} else {
print<<EOF_;
<a href=\"http://$ip$http_port\/index_http.htm\">Automation</a> is updated 
EOF_

	}
#<a href="http://${ip}$http_port/$testsuiteName/index_http.htm">Goto Testsuite page</a>
#my \$cmd = \"$perl_ $c/$_TAF/$taf testsuite=${testsuiteName}${deli}testcase=${testcase}${deli}manual_result=\$value_Result${deli}comment2=\\\"\$value_Note\\\"${deli}exec\";
#my \$rst = `\$cmd`;
#exec \$cmd;
#print \$rst;
# <a href="http://${ip}$http_port_IIS//taf.cgi?tafArgs=Execution_from_cgi=y_semi_Execution_local_only=n_semi_SysDrive=$c/${_TAF}_semi_tcPropertyPatternName=tcRunResult_semi_tcPropertyPatternPattern=.*_semi_testsuit=${testsuiteName}_semi_testcase=${testcase}_semi_ExecutionType=runTC_semi_manual_result=\${value_Result}_semi_comment2=\${value_Note}_semi_exec;tafRedirectory=http://${ip}$http_port/$testsuiteName/index_http.htm" title="Run Test (manual_result = \$value_Result, Note = \$value_Note )">Click to Proceed</a>


{open  Fout_out, "> $cgi_TC_args"; print Fout_out "\$value_index_arguments\\n"   ; close Fout_out;} 
{open  Fout_out, "> $cgi_TC_note"; print Fout_out "\$value_Note\\n"		 ; close Fout_out;} 
{open  Fout_out, "> $cgi_TC_vali"; print Fout_out "\$value_validator\\n"	 ; close Fout_out;} 
{open  Fout_out, "> $cgi_TC_prop"; print Fout_out "\$value_tcProperties\\n"	 ; close Fout_out;} 
{open  Fout_out, "> $cgi_TC_defi"; print Fout_out "\$value_tcDefinition\\n"	 ; close Fout_out;} 
{open  Fout_out, "> $cgi_TC_exec"; print Fout_out "\$value_tcExecutor\\n"	 ; close Fout_out;} 


if (\$value_CreateNewTC =~ /ON/i) {
print "<br><br>--------------------------- Debug Info --------------------------------<br><pre>";
my \$cmd = "$c/$_TAF/$taf testsuite=$c/${testsuiteName}${deli}testcase=$testcase${deli}tcFrom=$tcCtr${deli}index_pl_arguments=\\\"\$value_index_arguments\\\"${deli}addTCToDesc"; my \$rst = `\$cmd`; print "Debug info: \$rst<br>";
my \$cmd = "$c/$_TAF/$taf testsuite=$c/${testsuiteName}${deli}generateTSFromDesc"; my \$rst = `\$cmd`;  print "Debug info: \$rst<br>";
my \$cmd = "$c/$_TAF/$taf testsuite=$c/${testsuiteName}${deli}deleteTAFTestsuite"; my \$rst = `\$cmd`;  print "Debug info: \$rst<br>";
my \$cmd = "$c/$_TAF/$taf testsuite=$c/${testsuiteName}${deli}generateTAFTestsuite"; my \$rst = `\$cmd`;  print "Debug info: \$rst<br>";
print "--------------------------- Debug Info --------------------------------<br><br></pre>";
}

if (\$value_createTC =~ /New TC/i) {
print "<br><br>--------------------------- Debug Info --------------------------------<br><pre>";
my \$cmd = "$c/$_TAF/$taf testsuite=$c/${testsuiteName}${deli}testcase=$testcase${deli}addTSDefinition"; my \$rst = `\$cmd`; print "Debug info: \$rst<br>";
my \$cmd = "$c/$_TAF/$taf testsuite=$c/${testsuiteName}${deli}generateTSFromDesc"; my \$rst = `\$cmd`;  print "Debug info: \$rst<br>";
my \$cmd = "$c/$_TAF/$taf testsuite=$c/${testsuiteName}${deli}deleteTAFTestsuite"; my \$rst = `\$cmd`;  print "Debug info: \$rst<br>";
my \$cmd = "$c/$_TAF/$taf testsuite=$c/${testsuiteName}${deli}generateTAFTestsuite"; my \$rst = `\$cmd`;  print "Debug info: \$rst<br>";
print "--------------------------- Debug Info --------------------------------<br><br></pre>";
}



if (\$value_UpdateTCProperties) {
	;
	# print "pa: updateTSProperties\\n";
# my \$cmd = "C:/strawberry/perl/bin/perl.exe c:/_TAF/taf.pl testsuite=${testsuiteName}${deli}testcase=$testcase${deli}propertyOp=_all_syncProperties_doit_"; my \$rst = `\$cmd`; print "<br><br>Debug info: \$rst<br>";
}

if (\$value_UpdateTCDefinition) {
#my \$cmd = "C:/strawberry/perl/bin/perl.exe c:/_TAF/taf.pl testsuite=${testsuiteName}${deli}testcase=$testcase${deli}propertyOp=_all_syncTSDefinition_doit_"; my \$rst = `\$cmd`; print "<br><br>Debug info: \$rst<br>";
#my \$cmd = "$perl_ $c/$_TAF/$taf testsuite=${testsuiteName}${deli}testcase=$testcase${deli}syncTCDefinition"; my \$rst = `\$cmd`; print "<br><br>Debug info: \$rst<br>";
my \$cmd = "$c/$_TAF/$taf testsuite=${testsuiteName}${deli}testcase=$testcase${deli}syncTCDefinition"; my \$rst = `\$cmd`; print "<br><br>Debug info: \$rst<br>";
	# print "pa: updateTSProperties\\n";
	;
}



print end_html;

}


EOF_CGI
			close Fout_CGI;

open Fout_CGI, ">> $cgi_fname"; 
print Fout_CGI<<EOF_CGI;
sub readTSProperty {
open fin, "$c/$_TAF/$testsuiteName/$testcase/index.txt"; \@_ = <fin>; close fin;
EOF_CGI
print Fout_CGI<<'EOF_CGI';
foreach my $each (@_) { chop $each;
	$each =~ /(.+?):(.+)/ ;
	my $key = $1; my $val = $2; 
	$key =~ s/^\s*//g; $key =~ s/\s*$//g;
	$val =~ s/^\s*//g; $val =~ s/\s*$//g;
	$desc{$key} =  $desc{$key}. sprintf "  %-20s : %-s\n", $key, $val if ($key !~ /^\s*$/); 
}
EOF_CGI

print Fout_CGI<<EOF_CGI;
	open FinDesc, "$c/$_TAF/$testsuiteName/$testcase/tc_args.txt"; \$desc{"Arguments"} = sprintf "  %-20s : %-s", "Arguments", <FinDesc>; close FinDesc; 
	open FinDesc, "$c/$_TAF/$testsuiteName/$testcase/tc_exec.txt"; \$desc{"Executor"}  = sprintf "  %-20s : %-s", "Executor", <FinDesc>; close FinDesc; 
	open FinDesc, "$c/$_TAF/$testsuiteName/$testcase/tc_vali.txt"; \$desc{"Validator"} = sprintf "  %-20s : %-s", "Validator", <FinDesc>; close FinDesc; 
EOF_CGI

print Fout_CGI<<'EOF_CGI';
foreach my $each (keys %desc) { 
	# printf "%s", $desc{$each}; 
	$desc = $desc . $desc{$each};  
}
}


sub readFile() {  	# TH:Generic Functions: read file (TH:Generic Functions)
    my $fname = $_[0];
    if ( -e $fname ) {
    open Fin, "$fname";
    @_ = <Fin>;
    close Fin;
    return " @_";
    } else { return "";}
}

#################
sub readFileThProperty { 
	my $tcname = shift;
       	my $returnValue; my $returnType="_all_"; my %array; my %array_all; my $propertyOp ;
    if ( -e  "$tcname" ) 
    { ####
    #open Fin, "$tcname/tc_prop.txt" || die "Can't open file:$!";
    open Fin, "$tcname" || die "Can't open file:$!";
    while ( $_ = <Fin> ) {
	    @_= split /\|/, $_;
	    if ($#_ >0 ) { ###  Filter out non-property line 
	    my $propertyName_ = $_[0]; my $propertyValue_ = $_[1]; $propertyName_ =~ s/^\s*//g; $propertyName_ =~ s/\s*$//g; my $propertyStartTime = $_[2];
	    $propertyValue_ =~ s/^\s*//g;
	    $propertyValue_ =~ s/\s*$//g;
	    if (($propertyName_ !~ /^\s*$/) && ( $propertyValue_ !~ /^\s*$/)) {   

 	      	if (($propertyName_ =~ /$propertyOp/i) || ( $propertyOp eq '')) { # PropertyPattern Filter
		   	if ($returnType =~ /^\s*$/) { $returnValue .= sprintf "%-20s=%s\n",$propertyName_, $propertyValue_; 	# ignore this now. todo Hardcoded 20 determines the parssing in updateProperties
			} elsif ($returnType =~ /values/i) { 
				$returnValue .= sprintf "%s\n", $propertyValue_;
			} elsif ($returnType =~ /_all_/i) { 
				$propertyValue_ =~ s/^\s*//g;
				$propertyValue_ =~ s/\s*$//g;
				$returnValue = sprintf "\t%s\n", $propertyValue_;
			} elsif ($returnType =~ /history/i) { 
				$returnValue .= sprintf "%-20s=%s \@ $propertyStartTime\n",$propertyName_, $propertyValue_;
			} elsif ($returnType =~ /\blatest\b/i) {
				$returnValue = "$propertyValue_\n";
			} elsif ($returnType =~ /\blast\b/i) {
				if ($propertyValue_ !~ /dumy/) { $returnValue = "$propertyValue_\n"; }
			} elsif ($returnType =~ /\bvalue\b/i) {
				$returnValue = sprintf "%s\n", $propertyValue_;
		   	}
		} elsif ($propertyOp =~ /4_display/ ) {
				$returnValue = $propertyValue_; 
				#$returnValue = sprintf "%-20s=%s\n",$propertyName_, $propertyValue_; 
		}
		$array{$propertyName_} = $returnValue;
		chop;
		$array_all{$propertyName_} = $_;
	}
	} ###
    }
    close Fin;
	}####

	$returnValue = "\n";
	if ($returnType =~ /_all_/i) {
		foreach my $each (sort keys %array) { 
			@_ = split /\|/, $array_all{$each} ; 
			my $propName   = $_[0];
			my $propValue  = $_[1]; $propValue =~ s/^\s*//g; $propValue =~ s/\s*$//g;
			my $propStartT = $_[2];
			my $propEndT   = $_[3];
			my $propCmt1   = $_[4];
			my $propCmt2   = $_[5];

			$returnValue .= sprintf "%-10s|%-100s|%s|%s|%s|%s\n", $propName, $propValue, $propStartT, $propEndT, $propCmt1, $propCmt2 ; 
			#$returnValue .= sprintf "%s\n", $array_all{$each}; 
			#$returnValue .= sprintf "%-20s %s\n", $each, $array_all{$each}; 
			#$returnValue .= sprintf "%-20s %s\n", $each, $array{$each}; 
			}
		return $returnValue;
	} else {
		$returnValue =  $array{$propertyOp} ; 
		if ($returnValue ) { $returnValue =~ s/\s*\n\s*$//g; if ($returnValue =~ /^\s*$/) { $returnValue = "_noMatch_";} ; return $returnValue; }
		else { return ""; }
    	}
}
#################


EOF_CGI

close Fout_CGI;

open Fout_CGI, ">> $cgi_fname"; 

print Fout_CGI<<EOF_CGI;

####
sub prTopTitle {
	my \$fout = \$_[0];
	if ( -e "$c/$_TAF/$index_http_htm") { ;} else { return; }
	open Fin_prTopTitle, "$c/$_TAF/$index_http_htm";
	my \$inSearch = "n";
	while (\$_ = <Fin_prTopTitle>) {
		if (\$_ =~ /\\"main-nav\\"/)  { \$inSearch = "y"; }
		if (\$inSearch =~ /y/i) { print {\$fout} \$_;}
		if (\$_ =~ /\\"container\\"/) { \$inSearch = "n"; }
	}
	close Fin_prTopTitle;
}
####
EOF_CGI

close Fout_CGI;

			$tcCtr++;

			################

		}
	}

	$tcCtr = 1;
	############ Create Testsuite/Testcase
	open Fout, ">>$c/$_TAF/$testsuiteName/$testsuitePropertyFName" || die "Can't create file\n"; print Fout "<pre>\n$tsPropertyStr\n</pre>"; close Fout;
	&addHtmlToolBar("$c/$_TAF/$testsuiteName/$testsuitePropertyFName");
	print    "  -->$c/$_TAF/$testsuiteName/$testsuitePropertyFName\n";
#	&generateGenerateTestsuite(); 
	#### print    "  -->$c/$_TAF/$testsuiteName/generateTestsuite.pl\n";

	if ( -e "$c/$testsuiteName/_tcMap.txt" ) { 
		open Fin2, "$c/$testsuiteName/_tcMap.txt" ;
		open Fout2, ">$c/$_TAF/$testsuiteName/_tcMap.txt"; 
		while ($_=<Fin2>) { $_ =~ s/$c/$c\/$_TAF/ig; print Fout2 $_; }
		close Fout2; 
		close Fin2;
		print    "  -->$c/$_TAF/$testsuiteName/_tcMap.txt\n";
	}
	$testsuiteName = $testsuiteName;
			if ($testcaseNode =~ /^\s*$/) { $testcaseNode = "_null_"; }
			#$cmd = sprintf "$c/$_TAF/taf.pl tcDelay=0;performanceMode=fast;testcaseNode=$testcaseNode;testsuite=$testsuiteName;list"; 
			#print "\nlist: todo> $cmd\n". `$cmd`;
			#### !!!!!!!!!! the processTCs works !!!!!!!!!!!!!!!
			#### updateTS in stead of recreate TS $cmd = sprintf "tcDelay=0;testcaseNode=$testcaseNode;testsuite=$testsuiteName;list";  &processTCs("",$cmd); # todo
			$cmd = sprintf "tcDelay=0;testcaseNode=$testcaseNode;testsuite=$testsuiteName;mark";  &processTCs("",$cmd); # todo
			&generateRootIndex();
	if ($interact =~ /\by\b/) {system ("C:/Program Files/Internet Explorer/iexplore.exe", "$c/$_TAF/$testsuiteName/index.htm");}

	my $SvrProjName_C_no = &getTCName_C_no ($SvrProjName);	
	&gen_ts_tc_cgi($c, $ip, $SvrProjName_C_no, $TSDescName);		# index.txt.cgi
	&gen_ts_tc_cgi($c, $ip, $SvrProjName_C_no, $TSHookName);		# index.pl.cgi

	print "\n";	#todo <- new line? 
	1;
}


#### sub ####
sub addTCTSDesc_save {
my $tcId = 1; $tcId = shift if @_; 			my %desc; my $desc;
my $Fin_TSDesc 		= sprintf "%s/index.txt", &getTSName_TAF($SvrProjName);
my $Fin_TSDescLocal 	= sprintf "%s/testcase%04d/index.txt", &getTSName_TAF($SvrProjName), $tcId;

}
sub readTSDescLocal{
my $tcId = 1; $tcId = shift if @_; 			my %desc; my $desc;
my $Fin_TSDescLocal = sprintf "%s/testcase%04d/index.txt", &getTSName_TAF($SvrProjName), $tcId;

open Fin_TSDescLocal , $Fin_TSDescLocal; @_ = <Fin_TSDescLocal>; close Fin_TSDescLocal;
foreach my $each (@_) { chop $each;
	if ($each =~ /(.+?):(.+)/)
	{
	my $key = $1; my $val = $2; 
	$key =~ s/^\s*//g; $key =~ s/\s*$//g;
	$val =~ s/^\s*//g; $val =~ s/\s*$//g;
	if ($desc{$key}) {;} else { $desc{$key} =""; }
	$desc{$key} =  $desc{$key}. sprintf "  %-20s : %-s\n", $key, $val if ($key !~ /^\s*$/); 
	}
}
my $return="";
foreach my $each (keys %desc) { $return .= sprintf "%s", $desc{$each} if ($each =~ /^\s*name/i); }
foreach my $each (keys %desc) { $return .= sprintf "%s", $desc{$each} if ($each =~ /^\s*description/i); }
foreach my $each (keys %desc) { $return .= sprintf "%s", $desc{$each} if ($each =~ /^\s*dependency/i); }
foreach my $each (keys %desc) { $return .= sprintf "%s", $desc{$each} if ($each =~ /^\s*preRequsite/i); }
foreach my $each (keys %desc) { $return .= sprintf "%s", $desc{$each} if ($each =~ /^\s*preProcessor/i); }
foreach my $each (keys %desc) { $return .= sprintf "%s", $desc{$each} if ($each =~ /^\s*Executor/i); }
foreach my $each (keys %desc) { $return .= sprintf "%s", $desc{$each} if ($each =~ /^\s*Driver/i); }
foreach my $each (keys %desc) { $return .= sprintf "%s", $desc{$each} if ($each =~ /^\s*Arguments/i); }
foreach my $each (keys %desc) { $return .= sprintf "%s", $desc{$each} if ($each =~ /^\s*Validator/i); }
foreach my $each (keys %desc) { $return .= sprintf "%s", $desc{$each} if ($each =~ /^\s*PostProcessor/i); }
foreach my $each (keys %desc) { $r