/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.FeatureOperations;
import org.apache.sis.feature.Property;
import org.apache.sis.internal.feature.FeatureUtilities;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;

final class StringJoinOperation
extends AbstractOperation {
    private static final long serialVersionUID = 2303047827010821381L;
    static final char ESCAPE = '\\';
    private static final ParameterDescriptorGroup EMPTY_PARAMS = FeatureUtilities.parameters("StringJoin", new ParameterDescriptor[0]);
    private final String[] attributeNames;
    private final ObjectConverter<? super String, ?>[] converters;
    private transient Set<String> dependencies;
    private final DefaultAttributeType<String> resultType;
    final String prefix;
    final String suffix;
    final String delimiter;

    StringJoinOperation(Map<String, ?> map, String string, String string2, String string3, AbstractIdentifiedType[] abstractIdentifiedTypeArray) throws UnconvertibleObjectException {
        super(map);
        this.attributeNames = new String[abstractIdentifiedTypeArray.length];
        this.converters = new ObjectConverter[abstractIdentifiedTypeArray.length];
        for (int i = 0; i < abstractIdentifiedTypeArray.length; ++i) {
            AbstractIdentifiedType abstractIdentifiedType = abstractIdentifiedTypeArray[i];
            ArgumentChecks.ensureNonNullElement("singleAttributes", i, abstractIdentifiedType);
            GenericName genericName = abstractIdentifiedType.getName();
            if (abstractIdentifiedType instanceof AbstractOperation) {
                abstractIdentifiedType = ((AbstractOperation)abstractIdentifiedType).getResult();
            }
            if (!(abstractIdentifiedType instanceof DefaultAttributeType)) {
                Class<AbstractIdentifiedType>[] classArray = Classes.getLeafInterfaces(Classes.getClass(abstractIdentifiedType), AbstractIdentifiedType.class);
                throw new IllegalArgumentException(Resources.forProperties(map).getString((short)10, genericName, classArray.length != 0 ? classArray[0] : null));
            }
            if (((DefaultAttributeType)abstractIdentifiedType).getMaximumOccurs() > 1) {
                throw new IllegalArgumentException(Resources.forProperties(map).getString((short)14, genericName));
            }
            this.attributeNames[i] = genericName.toString();
            this.converters[i] = ObjectConverters.find(String.class, ((DefaultAttributeType)abstractIdentifiedType).getValueClass());
        }
        this.resultType = FeatureOperations.POOL.unique(new DefaultAttributeType<Object>(this.resultIdentification(map), String.class, 1, 1, null, new DefaultAttributeType[0]));
        this.delimiter = string;
        this.prefix = string2 == null ? "" : string2;
        this.suffix = string3 == null ? "" : string3;
    }

    @Override
    public ParameterDescriptorGroup getParameters() {
        return EMPTY_PARAMS;
    }

    @Override
    public AbstractIdentifiedType getResult() {
        return this.resultType;
    }

    @Override
    public synchronized Set<String> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = CollectionsExt.immutableSet(true, this.attributeNames);
        }
        return this.dependencies;
    }

    static <S> Object format(ObjectConverter<S, ?> objectConverter, Object object) {
        return objectConverter.apply(objectConverter.getSourceClass().cast(object));
    }

    @Override
    public Property apply(AbstractFeature abstractFeature, ParameterValueGroup parameterValueGroup) {
        ArgumentChecks.ensureNonNull("feature", abstractFeature);
        return new Result(abstractFeature);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Arrays.hashCode(this.attributeNames) + 37 * Objects.hash(this.delimiter, this.prefix, this.suffix);
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            StringJoinOperation stringJoinOperation = (StringJoinOperation)object;
            return Arrays.equals(this.attributeNames, stringJoinOperation.attributeNames) && Arrays.equals(this.converters, stringJoinOperation.converters) && Objects.equals(this.delimiter, stringJoinOperation.delimiter) && Objects.equals(this.prefix, stringJoinOperation.prefix) && Objects.equals(this.suffix, stringJoinOperation.suffix);
        }
        return false;
    }

    @Override
    void formatResultFormula(Appendable appendable) throws IOException {
        if (this.prefix != null) {
            appendable.append(this.prefix);
        }
        for (int i = 0; i < this.attributeNames.length; ++i) {
            if (i != 0) {
                appendable.append(this.delimiter);
            }
            appendable.append(this.attributeNames[i]);
        }
        if (this.suffix != null) {
            appendable.append(this.suffix);
        }
    }

    private final class Result
    extends AbstractAttribute<String> {
        private static final long serialVersionUID = -8435975199763452547L;
        private final AbstractFeature feature;

        Result(AbstractFeature abstractFeature) {
            super(StringJoinOperation.this.resultType);
            this.feature = abstractFeature;
        }

        @Override
        public String getValue() throws UnconvertibleObjectException {
            StringBuilder stringBuilder = new StringBuilder();
            String string = StringJoinOperation.this.prefix;
            String string2 = null;
            Object object = null;
            try {
                for (int i = 0; i < StringJoinOperation.this.attributeNames.length; ++i) {
                    string2 = StringJoinOperation.this.attributeNames[i];
                    object = this.feature.getPropertyValue(string2);
                    object = StringJoinOperation.format(StringJoinOperation.this.converters[i].inverse(), object);
                    stringBuilder.append(string);
                    string = StringJoinOperation.this.delimiter;
                    if (object == null) continue;
                    int n = stringBuilder.length();
                    int n2 = stringBuilder.append(object).length();
                    while (--n2 >= n) {
                        if (stringBuilder.charAt(n2) != '\\') continue;
                        stringBuilder.insert(n2, '\\');
                    }
                    n2 = n;
                    while ((n2 = stringBuilder.indexOf(string, n2)) >= 0) {
                        stringBuilder.insert(n2, '\\');
                        n2 += string.length() + 1;
                    }
                }
            }
            catch (ClassCastException classCastException) {
                if (object == null) {
                    throw classCastException;
                }
                throw new UnconvertibleObjectException(Errors.format((short)63, string2), classCastException);
            }
            return stringBuilder.append(StringJoinOperation.this.suffix).toString();
        }

        @Override
        public void setValue(String string) throws IllegalArgumentException {
            int n;
            int n2;
            int n3 = string.length() - StringJoinOperation.this.suffix.length();
            boolean bl = string.startsWith(StringJoinOperation.this.prefix);
            if (!bl || !string.endsWith(StringJoinOperation.this.suffix)) {
                throw new IllegalArgumentException(Errors.format((short)136, this.getName(), bl ? 1 : 0, bl ? StringJoinOperation.this.suffix : StringJoinOperation.this.prefix, bl ? string.substring(Math.max(0, n3)) : CharSequences.token(string, 0)));
            }
            Object[] objectArray = new Object[StringJoinOperation.this.attributeNames.length];
            int n4 = n2 = StringJoinOperation.this.prefix.length();
            int n5 = 0;
            boolean bl2 = false;
            do {
                if ((n4 = string.indexOf(StringJoinOperation.this.delimiter, n4)) >= 0 && n4 < n3) {
                    for (n = n4; n != 0 && string.charAt(n - 1) == '\\'; --n) {
                    }
                    if ((n4 - n & 1) != 0) {
                        n4 += StringJoinOperation.this.delimiter.length() + 1;
                        continue;
                    }
                } else {
                    n4 = n3;
                    bl2 = true;
                }
                String string2 = string.substring(n2, n4);
                int n6 = 0;
                while ((n6 = string2.indexOf(92, n6)) >= 0) {
                    if (n6 >= (string2 = new StringBuilder(string2.length() - 1).append(string2, 0, n6).append(string2, n6 + 1, string2.length()).toString()).length()) continue;
                    if (string2.charAt(n6) == '\\') {
                        ++n6;
                        continue;
                    }
                    assert (string2.regionMatches(n6, StringJoinOperation.this.delimiter, 0, StringJoinOperation.this.delimiter.length())) : string2;
                    n6 += StringJoinOperation.this.delimiter.length();
                }
                if (!string2.isEmpty() && n5 < objectArray.length) {
                    try {
                        objectArray[n5] = StringJoinOperation.this.converters[n5].apply(string2);
                    }
                    catch (UnconvertibleObjectException unconvertibleObjectException) {
                        throw new IllegalArgumentException(Errors.format((short)4, StringJoinOperation.this.attributeNames[n5], string2), unconvertibleObjectException);
                    }
                }
                ++n5;
                n2 = n4 += StringJoinOperation.this.delimiter.length();
            } while (!bl2);
            if (objectArray.length != n5) {
                throw new IllegalArgumentException(Resources.format((short)17, this.getName(), string, objectArray.length, n5));
            }
            for (n = 0; n < objectArray.length; ++n) {
                this.feature.setPropertyValue(StringJoinOperation.this.attributeNames[n], objectArray[n]);
            }
        }
    }
}

