/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class ErodeOpImage
extends AreaOpImage {
    protected KernelJAI kernel;
    private int kw;
    private int kh;
    private int kx;
    private int ky;
    private float[] kdata;

    public ErodeOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, KernelJAI kernelJAI) {
        super(renderedImage, imageLayout, map, true, borderExtender, kernelJAI.getLeftPadding(), kernelJAI.getRightPadding(), kernelJAI.getTopPadding(), kernelJAI.getBottomPadding());
        this.kernel = kernelJAI;
        this.kw = kernelJAI.getWidth();
        this.kh = kernelJAI.getHeight();
        this.kx = kernelJAI.getXOrigin();
        this.ky = kernelJAI.getYOrigin();
        this.kdata = kernelJAI.getKernelData();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rasterAccessor2);
                break;
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int n8 = 0;
        while (n8 < n3) {
            byte[] byArray3 = byArray[n8];
            byte[] byArray4 = byArray2[n8];
            int n9 = nArray2[n8];
            int n10 = nArray[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                int n14 = 0;
                while (n14 < n) {
                    int n15;
                    int n16 = 0;
                    int n17 = n12;
                    float f = Float.POSITIVE_INFINITY;
                    int n18 = 0;
                    while (n18 < this.kh) {
                        n15 = n17;
                        int n19 = 0;
                        while (n19 < this.kw) {
                            float f2 = (float)(byArray4[n15] & 0xFF) - this.kdata[n16 + n19];
                            if (f2 < f) {
                                f = f2;
                            }
                            n15 += n6;
                            ++n19;
                        }
                        n16 += this.kw;
                        n17 += n7;
                        ++n18;
                    }
                    if (Float.isInfinite(f)) {
                        f = 0.0f;
                    }
                    if ((n15 = (int)f) < 0) {
                        n15 = 0;
                    } else if (n15 > 255) {
                        n15 = 255;
                    }
                    byArray3[n13] = (byte)n15;
                    n12 += n6;
                    n13 += n4;
                    ++n14;
                }
                n9 += n7;
                n10 += n5;
                ++n11;
            }
            ++n8;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int n8 = 0;
        while (n8 < n3) {
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            int n9 = nArray2[n8];
            int n10 = nArray[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                int n14 = 0;
                while (n14 < n) {
                    int n15;
                    int n16 = 0;
                    int n17 = n12;
                    float f = Float.POSITIVE_INFINITY;
                    int n18 = 0;
                    while (n18 < this.kh) {
                        n15 = n17;
                        int n19 = 0;
                        while (n19 < this.kw) {
                            float f2 = (float)sArray4[n15] - this.kdata[n16 + n19];
                            if (f2 < f) {
                                f = f2;
                            }
                            n15 += n6;
                            ++n19;
                        }
                        n16 += this.kw;
                        n17 += n7;
                        ++n18;
                    }
                    if (Float.isInfinite(f)) {
                        f = 0.0f;
                    }
                    if ((n15 = (int)f) < Short.MIN_VALUE) {
                        n15 = Short.MIN_VALUE;
                    } else if (n15 > Short.MAX_VALUE) {
                        n15 = Short.MAX_VALUE;
                    }
                    sArray3[n13] = (short)n15;
                    n12 += n6;
                    n13 += n4;
                    ++n14;
                }
                n9 += n7;
                n10 += n5;
                ++n11;
            }
            ++n8;
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int n8 = 0;
        while (n8 < n3) {
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            int n9 = nArray2[n8];
            int n10 = nArray[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                int n14 = 0;
                while (n14 < n) {
                    int n15;
                    int n16 = 0;
                    int n17 = n12;
                    float f = Float.POSITIVE_INFINITY;
                    int n18 = 0;
                    while (n18 < this.kh) {
                        n15 = n17;
                        int n19 = 0;
                        while (n19 < this.kw) {
                            float f2 = (float)(sArray4[n15] & 0xFFFF) - this.kdata[n16 + n19];
                            if (f2 < f) {
                                f = f2;
                            }
                            n15 += n6;
                            ++n19;
                        }
                        n16 += this.kw;
                        n17 += n7;
                        ++n18;
                    }
                    if (Float.isInfinite(f)) {
                        f = 0.0f;
                    }
                    if ((n15 = (int)f) < 0) {
                        n15 = 0;
                    } else if (n15 > 65535) {
                        n15 = 65535;
                    }
                    sArray3[n13] = (short)n15;
                    n12 += n6;
                    n13 += n4;
                    ++n14;
                }
                n9 += n7;
                n10 += n5;
                ++n11;
            }
            ++n8;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int[][] nArray3 = rasterAccessor2.getIntDataArrays();
        int[][] nArray4 = rasterAccessor.getIntDataArrays();
        int n8 = 0;
        while (n8 < n3) {
            int[] nArray5 = nArray3[n8];
            int[] nArray6 = nArray4[n8];
            int n9 = nArray2[n8];
            int n10 = nArray[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                int n14 = 0;
                while (n14 < n) {
                    int n15 = 0;
                    int n16 = n12;
                    float f = Float.POSITIVE_INFINITY;
                    int n17 = 0;
                    while (n17 < this.kh) {
                        int n18 = n16;
                        int n19 = 0;
                        while (n19 < this.kw) {
                            float f2 = (float)nArray6[n18] - this.kdata[n15 + n19];
                            if (f2 < f) {
                                f = f2;
                            }
                            n18 += n6;
                            ++n19;
                        }
                        n15 += this.kw;
                        n16 += n7;
                        ++n17;
                    }
                    if (Float.isInfinite(f)) {
                        f = 0.0f;
                    }
                    nArray5[n13] = (int)f;
                    n12 += n6;
                    n13 += n4;
                    ++n14;
                }
                n9 += n7;
                n10 += n5;
                ++n11;
            }
            ++n8;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int n8 = 0;
        while (n8 < n3) {
            float[] fArray3 = fArray[n8];
            float[] fArray4 = fArray2[n8];
            int n9 = nArray2[n8];
            int n10 = nArray[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                int n14 = 0;
                while (n14 < n) {
                    int n15 = 0;
                    int n16 = n12;
                    float f = Float.POSITIVE_INFINITY;
                    int n17 = 0;
                    while (n17 < this.kh) {
                        int n18 = n16;
                        int n19 = 0;
                        while (n19 < this.kw) {
                            float f2 = fArray4[n18] - this.kdata[n15 + n19];
                            if (f2 < f) {
                                f = f2;
                            }
                            n18 += n6;
                            ++n19;
                        }
                        n15 += this.kw;
                        n16 += n7;
                        ++n17;
                    }
                    if (Float.isInfinite(f)) {
                        f = 0.0f;
                    }
                    fArray3[n13] = f;
                    n12 += n6;
                    n13 += n4;
                    ++n14;
                }
                n9 += n7;
                n10 += n5;
                ++n11;
            }
            ++n8;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int n8 = 0;
        while (n8 < n3) {
            double[] dArray3 = dArray[n8];
            double[] dArray4 = dArray2[n8];
            int n9 = nArray2[n8];
            int n10 = nArray[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                int n14 = 0;
                while (n14 < n) {
                    int n15 = 0;
                    int n16 = n12;
                    double d = Double.POSITIVE_INFINITY;
                    int n17 = 0;
                    while (n17 < this.kh) {
                        int n18 = n16;
                        int n19 = 0;
                        while (n19 < this.kw) {
                            double d2 = dArray4[n18] - (double)this.kdata[n15 + n19];
                            if (d2 < d) {
                                d = d2;
                            }
                            n18 += n6;
                            ++n19;
                        }
                        n15 += this.kw;
                        n16 += n7;
                        ++n17;
                    }
                    if (Double.isInfinite(d)) {
                        d = 0.0;
                    }
                    dArray3[n13] = d;
                    n12 += n6;
                    n13 += n4;
                    ++n14;
                }
                n9 += n7;
                n10 += n5;
                ++n11;
            }
            ++n8;
        }
    }
}

