/*
Copyright (c) 2005, John Fraser C<< <raptnor@yahoo.com> >>. All rights reserved.

This module is free software; you can redistribute it and/or
modify it under the same terms as Perl itself. See L<perlartistic>.


=head1 DISCLAIMER OF WARRANTY

BECAUSE THIS SOFTWARE IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE SOFTWARE, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE SOFTWARE "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE SOFTWARE IS WITH
YOU. SHOULD THE SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL
NECESSARY SERVICING, REPAIR, OR CORRECTION.

IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE SOFTWARE AS PERMITTED BY THE ABOVE LICENCE, BE
LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE
THE SOFTWARE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING
RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A
FAILURE OF THE SOFTWARE TO OPERATE WITH ANY OTHER SOFTWARE), EVEN IF
SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF
SUCH DAMAGES.
 */
package com.raptnor.psp.statistics;

/**
 * @author johnfraser
 *
 **/

public class StandardDeviation {
	public static double compute(double[] values){
		return Math.sqrt(variance(values));
	}
	
	public static double mean(double[] values){
		long sum = 0;
		int count = values.length;
		for(int i=0;i<count;i++){
			sum += values[i];
		}
		return sum/count;
	}
	
	public static double variance(double[] values){
		double mean = mean(values);
		long sum = 0;
		int count = values.length;
		for(int i=0;i<count;i++){
			sum += Math.pow((values[i] - mean), 2);
		}
		return sum / (count -1);
	}
	
	/*
	 * Hack from: http://www.experts-exchange.com/Programming/Programming_Languages/Java/Q_21226646.html
	 */
	public static double roundDouble(double value, int decimalPlaces){
		double inflated = Math.pow(10, decimalPlaces);
		return Math.round(value * inflated) / inflated;
	}
	
	public static void main(String[] argv){
		
		
		// test1
		System.out.println("Should be close to 572.03");
		System.out.println(StandardDeviation.roundDouble(
				StandardDeviation.compute(test1), 2));
		
		// test2
		System.out.println("Should be close to 625.63");
		System.out.println();
		
		//	test3
		System.out.println("Should be close to 62.26");
		System.out.println(StandardDeviation.roundDouble(
				StandardDeviation.compute(test3), 2));
		}
}