#! /usr/bin/perl -I..
################################################################################
#
# benchmark.pl (Benchmark PML)
#
################################################################################
#
# Includes
#
################################################################################
use strict;
use Benchmark;
use PML;
################################################################################
#
# Global Variables and Default Settings
#
################################################################################
use vars qw($VERSION $DATE);
$VERSION	= '0.01';
$DATE		= 'Mon Nov 15 12:38:02 1999';

my $t;
my $count = 100;
my $file = shift || 'benchmark.pml';
################################################################################
#
# Code Start
#
################################################################################
$t = timeit($count, \&run);
print "$count calls to PML took: ", timestr($t), "\n";
################################################################################
#
# ==== run ==== ################################################################
#
#   Arguments:
#	None
#
#     Returns:
#	None
#
# Description:
#	Talks to PML
#
################################################################################
sub run
{
	my $pml = new PML;
	
	$pml->parse($file);
	$pml->execute;
} # <-- End run -->
################################################################################
#                              END-OF-SCRIPT                                   #
################################################################################
