package WebService::Mattermost::V4::API::Object::User::Session;

# ABSTRACT: A user session item.

use Moo;
use Types::Standard qw(ArrayRef Bool Maybe Str);

extends 'WebService::Mattermost::V4::API::Object';
with    qw(
    WebService::Mattermost::V4::API::Object::Role::BelongingToUser
    WebService::Mattermost::V4::API::Object::Role::CreatedAt
    WebService::Mattermost::V4::API::Object::Role::ExpiresAt
    WebService::Mattermost::V4::API::Object::Role::ID
    WebService::Mattermost::V4::API::Object::Role::LastActivityAt
    WebService::Mattermost::V4::API::Object::Role::Props
    WebService::Mattermost::V4::API::Object::Role::Roles
);

################################################################################

has device_id    => (is => 'ro', isa => Maybe[Str],      lazy => 1, builder => 1);
has is_oauth     => (is => 'ro', isa => Maybe[Bool],     lazy => 1, builder => 1);
has team_members => (is => 'ro', isa => Maybe[ArrayRef], lazy => 1, builder => 1);
has token        => (is => 'ro', isa => Maybe[Str],      lazy => 1, builder => 1);

################################################################################

sub _build_device_id    { shift->raw_data->{device_id}        }
sub _build_is_oauth     { shift->raw_data->{is_oauth} ? 1 : 0 }
sub _build_team_members { shift->raw_data->{team_members}     }
sub _build_token        { shift->raw_data->{token}            }

################################################################################

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::Mattermost::V4::API::Object::User::Session - A user session item.

=head1 VERSION

version 0.23

=head1 DESCRIPTION

=head2 METHODS

=over 4

=item C<device_id>

=item C<is_oauth>

=item C<team_members>

=item C<token>

=back

=head1 SEE ALSO

=over 4

=item L<WebService::Mattermost::V4::API::Object::Role::BelongingToUser>

=item L<WebService::Mattermost::V4::API::Object::Role::CreatedAt>

=item L<WebService::Mattermost::V4::API::Object::Role::ExpiresAt>

=item L<WebService::Mattermost::V4::API::Object::Role::ID>

=item L<WebService::Mattermost::V4::API::Object::Role::LastActivityAt>

=item L<WebService::Mattermost::V4::API::Object::Role::Props>

=back

=head1 AUTHOR

Mike Jones <mike@netsplit.org.uk>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2020 by Mike Jones.

This is free software, licensed under:

  The MIT (X11) License

=cut
