package Google::Ads::AdWords::v201402::Attribute;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/o/v201402' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %Attribute__Type_of :ATTR(:get<Attribute__Type>);

__PACKAGE__->_factory(
    [ qw(        Attribute__Type

    ) ],
    {
        'Attribute__Type' => \%Attribute__Type_of,
    },
    {
        'Attribute__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'Attribute__Type' => 'Attribute.Type',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201402::Attribute

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
Attribute from the namespace https://adwords.google.com/api/adwords/o/v201402.

{@link Attribute}s encompass the core information about a particular {@link com.google.ads.api.services.targetingideas.TargetingIdea}. Some attributes are for {@code KEYWORD} {@link IdeaType}s, some are for {@code PLACEMENT} {@link IdeaType}s, and some are for both. Ultimately, an {@link Attribute} instance simply wraps an actual value of interest. For example, {@link KeywordAttribute} wraps the keyword itself, while a {@link BooleanAttribute} simply wraps a boolean describing some information about the keyword idea. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Attribute__Type

Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

 Attribute.Type




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

