package App::Manoc::Form::TraitFor::CSRF;
#ABSTRACT: Role for CSRF support in Manoc forms

use HTML::FormHandler::Moose::Role;

our $VERSION = '2.99.3'; ##TRIAL VERSION


has_field 'csrf_token' => (
    type       => 'Hidden',
    noupdate   => 1,
    do_wrapper => 0,
);

sub default_csrf_token {
    my $self = shift;

    return $self->ctx->get_token;
}

no HTML::FormHandler::Moose::Role;

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::Form::TraitFor::CSRF - Role for CSRF support in Manoc forms

=head1 VERSION

version 2.99.3

=head1 DESCRIPTION

Include this role to include a CSRF hidden form.

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
