

package AsposeCellsCloud::CellsApi;

require 5.6.0;
use strict;
use warnings;
use utf8; 
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use AsposeCellsCloud::ApiClient;

use base "Class::Data::Inheritable";

my $VERSION = '20.4.6';



__PACKAGE__->mk_classdata('method_documentation' => {});



sub new {
    my $class = shift;
    my $api_client;

    if ($_[0] && ref $_[0] && ref $_[0] eq 'AsposeCellsCloud::ApiClient' ) {
        $api_client = $_[0];
    } else {
        $api_client = AsposeCellsCloud::ApiClient->new(@_);
    }

    my $access_token  =  $api_client->o_auth_post('grant_type' => "client_credentials", 'client_id' => $api_client->{config}->{app_sid}, 'client_secret' =>$api_client->{config}->{app_key})->access_token;
    $api_client->{config}->{access_token} = $access_token;
    my $base_url =  $api_client->{config}->{base_url};
    
    if( substr( $base_url,length($base_url)-1,1) eq '/'){
         $base_url =  $base_url . $api_client->{config}->{api_version};
    }else{
         $base_url =  $base_url . '/'.$api_client->{config}->{api_version};
    }
    
    $api_client->{config}->{base_url} =  $base_url;
    
    bless { api_client => $api_client }, $class;

}


#
# cells_auto_filter_delete_worksheet_date_filter
#
# Removes a date filter.             
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $field_index  (required)
# @param string $date_time_grouping_type  (required)
# @param int $year  (optional, default to 0)
# @param int $month  (optional, default to 0)
# @param int $day  (optional, default to 0)
# @param int $hour  (optional, default to 0)
# @param int $minute  (optional, default to 0)
# @param int $second  (optional, default to 0)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'field_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'date_time_grouping_type' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'year' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'month' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'day' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'hour' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'minute' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'second' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_auto_filter_delete_worksheet_date_filter' } = { 
    	summary => 'Removes a date filter.             ',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_auto_filter_delete_worksheet_date_filter {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_auto_filter_delete_worksheet_date_filter");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_auto_filter_delete_worksheet_date_filter");
    }

    # verify the required parameter 'field_index' is set
    unless (exists $args{'field_index'}) {
      croak("Missing the required parameter 'field_index' when calling cells_auto_filter_delete_worksheet_date_filter");
    }

    # verify the required parameter 'date_time_grouping_type' is set
    unless (exists $args{'date_time_grouping_type'}) {
      croak("Missing the required parameter 'date_time_grouping_type' when calling cells_auto_filter_delete_worksheet_date_filter");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autoFilter/dateFilter';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'field_index'}) {
        $query_params->{'fieldIndex'} = $self->{api_client}->to_query_value($args{'field_index'});
    }

    # query params
    if ( exists $args{'date_time_grouping_type'}) {
        $query_params->{'dateTimeGroupingType'} = $self->{api_client}->to_query_value($args{'date_time_grouping_type'});
    }

    # query params
    if ( exists $args{'year'}) {
        $query_params->{'year'} = $self->{api_client}->to_query_value($args{'year'});
    }

    # query params
    if ( exists $args{'month'}) {
        $query_params->{'month'} = $self->{api_client}->to_query_value($args{'month'});
    }

    # query params
    if ( exists $args{'day'}) {
        $query_params->{'day'} = $self->{api_client}->to_query_value($args{'day'});
    }

    # query params
    if ( exists $args{'hour'}) {
        $query_params->{'hour'} = $self->{api_client}->to_query_value($args{'hour'});
    }

    # query params
    if ( exists $args{'minute'}) {
        $query_params->{'minute'} = $self->{api_client}->to_query_value($args{'minute'});
    }

    # query params
    if ( exists $args{'second'}) {
        $query_params->{'second'} = $self->{api_client}->to_query_value($args{'second'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_auto_filter_delete_worksheet_filter
#
# Delete a filter for a filter column.             
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $field_index  (required)
# @param string $criteria  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'field_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'criteria' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_auto_filter_delete_worksheet_filter' } = { 
    	summary => 'Delete a filter for a filter column.             ',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_auto_filter_delete_worksheet_filter {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_auto_filter_delete_worksheet_filter");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_auto_filter_delete_worksheet_filter");
    }

    # verify the required parameter 'field_index' is set
    unless (exists $args{'field_index'}) {
      croak("Missing the required parameter 'field_index' when calling cells_auto_filter_delete_worksheet_filter");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autoFilter/filter';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'field_index'}) {
        $query_params->{'fieldIndex'} = $self->{api_client}->to_query_value($args{'field_index'});
    }

    # query params
    if ( exists $args{'criteria'}) {
        $query_params->{'criteria'} = $self->{api_client}->to_query_value($args{'criteria'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_auto_filter_get_worksheet_auto_filter
#
# Get Auto filter Description
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_auto_filter_get_worksheet_auto_filter' } = { 
    	summary => 'Get Auto filter Description',
        params => $params,
        returns => 'AutoFilterResponse',
        };
}
# @return AutoFilterResponse
#
sub cells_auto_filter_get_worksheet_auto_filter {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_auto_filter_get_worksheet_auto_filter");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_auto_filter_get_worksheet_auto_filter");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autoFilter';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('AutoFilterResponse', $response);
    return $_response_object;
}

#
# cells_auto_filter_post_worksheet_auto_filter_refresh
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_auto_filter_post_worksheet_auto_filter_refresh' } = { 
    	summary => '',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_auto_filter_post_worksheet_auto_filter_refresh {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_auto_filter_post_worksheet_auto_filter_refresh");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_auto_filter_post_worksheet_auto_filter_refresh");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autoFilter/refresh';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_auto_filter_post_worksheet_match_blanks
#
# Match all blank cell in the list.
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $field_index  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'field_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_auto_filter_post_worksheet_match_blanks' } = { 
    	summary => 'Match all blank cell in the list.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_auto_filter_post_worksheet_match_blanks {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_auto_filter_post_worksheet_match_blanks");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_auto_filter_post_worksheet_match_blanks");
    }

    # verify the required parameter 'field_index' is set
    unless (exists $args{'field_index'}) {
      croak("Missing the required parameter 'field_index' when calling cells_auto_filter_post_worksheet_match_blanks");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autoFilter/matchBlanks';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'field_index'}) {
        $query_params->{'fieldIndex'} = $self->{api_client}->to_query_value($args{'field_index'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_auto_filter_post_worksheet_match_non_blanks
#
# Match all not blank cell in the list.             
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $field_index  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'field_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_auto_filter_post_worksheet_match_non_blanks' } = { 
    	summary => 'Match all not blank cell in the list.             ',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_auto_filter_post_worksheet_match_non_blanks {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_auto_filter_post_worksheet_match_non_blanks");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_auto_filter_post_worksheet_match_non_blanks");
    }

    # verify the required parameter 'field_index' is set
    unless (exists $args{'field_index'}) {
      croak("Missing the required parameter 'field_index' when calling cells_auto_filter_post_worksheet_match_non_blanks");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autoFilter/matchNonBlanks';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'field_index'}) {
        $query_params->{'fieldIndex'} = $self->{api_client}->to_query_value($args{'field_index'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_auto_filter_put_worksheet_color_filter
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $range  (required)
# @param int $field_index  (required)
# @param ColorFilterRequest $color_filter  (optional)
# @param boolean $match_blanks  (optional)
# @param boolean $refresh  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'range' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'field_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'color_filter' => {
        data_type => 'ColorFilterRequest',
        description => '',
        required => '0',
    },
    'match_blanks' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'refresh' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_auto_filter_put_worksheet_color_filter' } = { 
    	summary => '',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_auto_filter_put_worksheet_color_filter {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_auto_filter_put_worksheet_color_filter");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_auto_filter_put_worksheet_color_filter");
    }

    # verify the required parameter 'range' is set
    unless (exists $args{'range'}) {
      croak("Missing the required parameter 'range' when calling cells_auto_filter_put_worksheet_color_filter");
    }

    # verify the required parameter 'field_index' is set
    unless (exists $args{'field_index'}) {
      croak("Missing the required parameter 'field_index' when calling cells_auto_filter_put_worksheet_color_filter");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autoFilter/colorFilter';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'range'}) {
        $query_params->{'range'} = $self->{api_client}->to_query_value($args{'range'});
    }

    # query params
    if ( exists $args{'field_index'}) {
        $query_params->{'fieldIndex'} = $self->{api_client}->to_query_value($args{'field_index'});
    }

    # query params
    if ( exists $args{'match_blanks'}) {
        $query_params->{'matchBlanks'} = $self->{api_client}->to_query_value($args{'match_blanks'});
    }

    # query params
    if ( exists $args{'refresh'}) {
        $query_params->{'refresh'} = $self->{api_client}->to_query_value($args{'refresh'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'color_filter'}) {
        $_body_data = $args{'color_filter'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_auto_filter_put_worksheet_custom_filter
#
# Filters a list with a custom criteria.             
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $range  (required)
# @param int $field_index  (required)
# @param string $operator_type1  (required)
# @param string $criteria1  (required)
# @param boolean $is_and  (optional)
# @param string $operator_type2  (optional)
# @param string $criteria2  (optional)
# @param boolean $match_blanks  (optional)
# @param boolean $refresh  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'range' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'field_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'operator_type1' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'criteria1' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'is_and' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'operator_type2' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'criteria2' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'match_blanks' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'refresh' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_auto_filter_put_worksheet_custom_filter' } = { 
    	summary => 'Filters a list with a custom criteria.             ',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_auto_filter_put_worksheet_custom_filter {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_auto_filter_put_worksheet_custom_filter");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_auto_filter_put_worksheet_custom_filter");
    }

    # verify the required parameter 'range' is set
    unless (exists $args{'range'}) {
      croak("Missing the required parameter 'range' when calling cells_auto_filter_put_worksheet_custom_filter");
    }

    # verify the required parameter 'field_index' is set
    unless (exists $args{'field_index'}) {
      croak("Missing the required parameter 'field_index' when calling cells_auto_filter_put_worksheet_custom_filter");
    }

    # verify the required parameter 'operator_type1' is set
    unless (exists $args{'operator_type1'}) {
      croak("Missing the required parameter 'operator_type1' when calling cells_auto_filter_put_worksheet_custom_filter");
    }

    # verify the required parameter 'criteria1' is set
    unless (exists $args{'criteria1'}) {
      croak("Missing the required parameter 'criteria1' when calling cells_auto_filter_put_worksheet_custom_filter");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autoFilter/custom';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'range'}) {
        $query_params->{'range'} = $self->{api_client}->to_query_value($args{'range'});
    }

    # query params
    if ( exists $args{'field_index'}) {
        $query_params->{'fieldIndex'} = $self->{api_client}->to_query_value($args{'field_index'});
    }

    # query params
    if ( exists $args{'operator_type1'}) {
        $query_params->{'operatorType1'} = $self->{api_client}->to_query_value($args{'operator_type1'});
    }

    # query params
    if ( exists $args{'criteria1'}) {
        $query_params->{'criteria1'} = $self->{api_client}->to_query_value($args{'criteria1'});
    }

    # query params
    if ( exists $args{'is_and'}) {
        $query_params->{'isAnd'} = $self->{api_client}->to_query_value($args{'is_and'});
    }

    # query params
    if ( exists $args{'operator_type2'}) {
        $query_params->{'operatorType2'} = $self->{api_client}->to_query_value($args{'operator_type2'});
    }

    # query params
    if ( exists $args{'criteria2'}) {
        $query_params->{'criteria2'} = $self->{api_client}->to_query_value($args{'criteria2'});
    }

    # query params
    if ( exists $args{'match_blanks'}) {
        $query_params->{'matchBlanks'} = $self->{api_client}->to_query_value($args{'match_blanks'});
    }

    # query params
    if ( exists $args{'refresh'}) {
        $query_params->{'refresh'} = $self->{api_client}->to_query_value($args{'refresh'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_auto_filter_put_worksheet_date_filter
#
# add date filter in worksheet 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $range  (required)
# @param int $field_index  (required)
# @param string $date_time_grouping_type  (required)
# @param int $year  (optional, default to 0)
# @param int $month  (optional, default to 0)
# @param int $day  (optional, default to 0)
# @param int $hour  (optional, default to 0)
# @param int $minute  (optional, default to 0)
# @param int $second  (optional, default to 0)
# @param boolean $match_blanks  (optional)
# @param boolean $refresh  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'range' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'field_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'date_time_grouping_type' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'year' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'month' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'day' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'hour' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'minute' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'second' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'match_blanks' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'refresh' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_auto_filter_put_worksheet_date_filter' } = { 
    	summary => 'add date filter in worksheet ',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_auto_filter_put_worksheet_date_filter {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_auto_filter_put_worksheet_date_filter");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_auto_filter_put_worksheet_date_filter");
    }

    # verify the required parameter 'range' is set
    unless (exists $args{'range'}) {
      croak("Missing the required parameter 'range' when calling cells_auto_filter_put_worksheet_date_filter");
    }

    # verify the required parameter 'field_index' is set
    unless (exists $args{'field_index'}) {
      croak("Missing the required parameter 'field_index' when calling cells_auto_filter_put_worksheet_date_filter");
    }

    # verify the required parameter 'date_time_grouping_type' is set
    unless (exists $args{'date_time_grouping_type'}) {
      croak("Missing the required parameter 'date_time_grouping_type' when calling cells_auto_filter_put_worksheet_date_filter");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autoFilter/dateFilter';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'range'}) {
        $query_params->{'range'} = $self->{api_client}->to_query_value($args{'range'});
    }

    # query params
    if ( exists $args{'field_index'}) {
        $query_params->{'fieldIndex'} = $self->{api_client}->to_query_value($args{'field_index'});
    }

    # query params
    if ( exists $args{'date_time_grouping_type'}) {
        $query_params->{'dateTimeGroupingType'} = $self->{api_client}->to_query_value($args{'date_time_grouping_type'});
    }

    # query params
    if ( exists $args{'year'}) {
        $query_params->{'year'} = $self->{api_client}->to_query_value($args{'year'});
    }

    # query params
    if ( exists $args{'month'}) {
        $query_params->{'month'} = $self->{api_client}->to_query_value($args{'month'});
    }

    # query params
    if ( exists $args{'day'}) {
        $query_params->{'day'} = $self->{api_client}->to_query_value($args{'day'});
    }

    # query params
    if ( exists $args{'hour'}) {
        $query_params->{'hour'} = $self->{api_client}->to_query_value($args{'hour'});
    }

    # query params
    if ( exists $args{'minute'}) {
        $query_params->{'minute'} = $self->{api_client}->to_query_value($args{'minute'});
    }

    # query params
    if ( exists $args{'second'}) {
        $query_params->{'second'} = $self->{api_client}->to_query_value($args{'second'});
    }

    # query params
    if ( exists $args{'match_blanks'}) {
        $query_params->{'matchBlanks'} = $self->{api_client}->to_query_value($args{'match_blanks'});
    }

    # query params
    if ( exists $args{'refresh'}) {
        $query_params->{'refresh'} = $self->{api_client}->to_query_value($args{'refresh'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_auto_filter_put_worksheet_dynamic_filter
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $range  (required)
# @param int $field_index  (required)
# @param string $dynamic_filter_type  (required)
# @param boolean $match_blanks  (optional)
# @param boolean $refresh  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'range' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'field_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'dynamic_filter_type' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'match_blanks' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'refresh' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_auto_filter_put_worksheet_dynamic_filter' } = { 
    	summary => '',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_auto_filter_put_worksheet_dynamic_filter {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_auto_filter_put_worksheet_dynamic_filter");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_auto_filter_put_worksheet_dynamic_filter");
    }

    # verify the required parameter 'range' is set
    unless (exists $args{'range'}) {
      croak("Missing the required parameter 'range' when calling cells_auto_filter_put_worksheet_dynamic_filter");
    }

    # verify the required parameter 'field_index' is set
    unless (exists $args{'field_index'}) {
      croak("Missing the required parameter 'field_index' when calling cells_auto_filter_put_worksheet_dynamic_filter");
    }

    # verify the required parameter 'dynamic_filter_type' is set
    unless (exists $args{'dynamic_filter_type'}) {
      croak("Missing the required parameter 'dynamic_filter_type' when calling cells_auto_filter_put_worksheet_dynamic_filter");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autoFilter/dynamicFilter';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'range'}) {
        $query_params->{'range'} = $self->{api_client}->to_query_value($args{'range'});
    }

    # query params
    if ( exists $args{'field_index'}) {
        $query_params->{'fieldIndex'} = $self->{api_client}->to_query_value($args{'field_index'});
    }

    # query params
    if ( exists $args{'dynamic_filter_type'}) {
        $query_params->{'dynamicFilterType'} = $self->{api_client}->to_query_value($args{'dynamic_filter_type'});
    }

    # query params
    if ( exists $args{'match_blanks'}) {
        $query_params->{'matchBlanks'} = $self->{api_client}->to_query_value($args{'match_blanks'});
    }

    # query params
    if ( exists $args{'refresh'}) {
        $query_params->{'refresh'} = $self->{api_client}->to_query_value($args{'refresh'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_auto_filter_put_worksheet_filter
#
# Adds a filter for a filter column.             
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $range  (required)
# @param int $field_index  (required)
# @param string $criteria  (required)
# @param boolean $match_blanks  (optional)
# @param boolean $refresh  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'range' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'field_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'criteria' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'match_blanks' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'refresh' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_auto_filter_put_worksheet_filter' } = { 
    	summary => 'Adds a filter for a filter column.             ',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_auto_filter_put_worksheet_filter {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_auto_filter_put_worksheet_filter");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_auto_filter_put_worksheet_filter");
    }

    # verify the required parameter 'range' is set
    unless (exists $args{'range'}) {
      croak("Missing the required parameter 'range' when calling cells_auto_filter_put_worksheet_filter");
    }

    # verify the required parameter 'field_index' is set
    unless (exists $args{'field_index'}) {
      croak("Missing the required parameter 'field_index' when calling cells_auto_filter_put_worksheet_filter");
    }

    # verify the required parameter 'criteria' is set
    unless (exists $args{'criteria'}) {
      croak("Missing the required parameter 'criteria' when calling cells_auto_filter_put_worksheet_filter");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autoFilter/filter';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'range'}) {
        $query_params->{'range'} = $self->{api_client}->to_query_value($args{'range'});
    }

    # query params
    if ( exists $args{'field_index'}) {
        $query_params->{'fieldIndex'} = $self->{api_client}->to_query_value($args{'field_index'});
    }

    # query params
    if ( exists $args{'criteria'}) {
        $query_params->{'criteria'} = $self->{api_client}->to_query_value($args{'criteria'});
    }

    # query params
    if ( exists $args{'match_blanks'}) {
        $query_params->{'matchBlanks'} = $self->{api_client}->to_query_value($args{'match_blanks'});
    }

    # query params
    if ( exists $args{'refresh'}) {
        $query_params->{'refresh'} = $self->{api_client}->to_query_value($args{'refresh'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_auto_filter_put_worksheet_filter_top10
#
# Filter the top 10 item in the list
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $range  (required)
# @param int $field_index  (required)
# @param boolean $is_top  (required)
# @param boolean $is_percent  (required)
# @param int $item_count  (required)
# @param boolean $match_blanks  (optional)
# @param boolean $refresh  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'range' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'field_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'is_top' => {
        data_type => 'boolean',
        description => '',
        required => '1',
    },
    'is_percent' => {
        data_type => 'boolean',
        description => '',
        required => '1',
    },
    'item_count' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'match_blanks' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'refresh' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_auto_filter_put_worksheet_filter_top10' } = { 
    	summary => 'Filter the top 10 item in the list',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_auto_filter_put_worksheet_filter_top10 {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_auto_filter_put_worksheet_filter_top10");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_auto_filter_put_worksheet_filter_top10");
    }

    # verify the required parameter 'range' is set
    unless (exists $args{'range'}) {
      croak("Missing the required parameter 'range' when calling cells_auto_filter_put_worksheet_filter_top10");
    }

    # verify the required parameter 'field_index' is set
    unless (exists $args{'field_index'}) {
      croak("Missing the required parameter 'field_index' when calling cells_auto_filter_put_worksheet_filter_top10");
    }

    # verify the required parameter 'is_top' is set
    unless (exists $args{'is_top'}) {
      croak("Missing the required parameter 'is_top' when calling cells_auto_filter_put_worksheet_filter_top10");
    }

    # verify the required parameter 'is_percent' is set
    unless (exists $args{'is_percent'}) {
      croak("Missing the required parameter 'is_percent' when calling cells_auto_filter_put_worksheet_filter_top10");
    }

    # verify the required parameter 'item_count' is set
    unless (exists $args{'item_count'}) {
      croak("Missing the required parameter 'item_count' when calling cells_auto_filter_put_worksheet_filter_top10");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autoFilter/filterTop10';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'range'}) {
        $query_params->{'range'} = $self->{api_client}->to_query_value($args{'range'});
    }

    # query params
    if ( exists $args{'field_index'}) {
        $query_params->{'fieldIndex'} = $self->{api_client}->to_query_value($args{'field_index'});
    }

    # query params
    if ( exists $args{'is_top'}) {
        $query_params->{'isTop'} = $self->{api_client}->to_query_value($args{'is_top'});
    }

    # query params
    if ( exists $args{'is_percent'}) {
        $query_params->{'isPercent'} = $self->{api_client}->to_query_value($args{'is_percent'});
    }

    # query params
    if ( exists $args{'item_count'}) {
        $query_params->{'itemCount'} = $self->{api_client}->to_query_value($args{'item_count'});
    }

    # query params
    if ( exists $args{'match_blanks'}) {
        $query_params->{'matchBlanks'} = $self->{api_client}->to_query_value($args{'match_blanks'});
    }

    # query params
    if ( exists $args{'refresh'}) {
        $query_params->{'refresh'} = $self->{api_client}->to_query_value($args{'refresh'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_auto_filter_put_worksheet_icon_filter
#
# Adds an icon filter.
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $range  (required)
# @param int $field_index  (required)
# @param string $icon_set_type  (required)
# @param int $icon_id  (required)
# @param boolean $match_blanks  (optional)
# @param boolean $refresh  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'range' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'field_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'icon_set_type' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'icon_id' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'match_blanks' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'refresh' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_auto_filter_put_worksheet_icon_filter' } = { 
    	summary => 'Adds an icon filter.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_auto_filter_put_worksheet_icon_filter {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_auto_filter_put_worksheet_icon_filter");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_auto_filter_put_worksheet_icon_filter");
    }

    # verify the required parameter 'range' is set
    unless (exists $args{'range'}) {
      croak("Missing the required parameter 'range' when calling cells_auto_filter_put_worksheet_icon_filter");
    }

    # verify the required parameter 'field_index' is set
    unless (exists $args{'field_index'}) {
      croak("Missing the required parameter 'field_index' when calling cells_auto_filter_put_worksheet_icon_filter");
    }

    # verify the required parameter 'icon_set_type' is set
    unless (exists $args{'icon_set_type'}) {
      croak("Missing the required parameter 'icon_set_type' when calling cells_auto_filter_put_worksheet_icon_filter");
    }

    # verify the required parameter 'icon_id' is set
    unless (exists $args{'icon_id'}) {
      croak("Missing the required parameter 'icon_id' when calling cells_auto_filter_put_worksheet_icon_filter");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autoFilter/iconFilter';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'range'}) {
        $query_params->{'range'} = $self->{api_client}->to_query_value($args{'range'});
    }

    # query params
    if ( exists $args{'field_index'}) {
        $query_params->{'fieldIndex'} = $self->{api_client}->to_query_value($args{'field_index'});
    }

    # query params
    if ( exists $args{'icon_set_type'}) {
        $query_params->{'iconSetType'} = $self->{api_client}->to_query_value($args{'icon_set_type'});
    }

    # query params
    if ( exists $args{'icon_id'}) {
        $query_params->{'iconId'} = $self->{api_client}->to_query_value($args{'icon_id'});
    }

    # query params
    if ( exists $args{'match_blanks'}) {
        $query_params->{'matchBlanks'} = $self->{api_client}->to_query_value($args{'match_blanks'});
    }

    # query params
    if ( exists $args{'refresh'}) {
        $query_params->{'refresh'} = $self->{api_client}->to_query_value($args{'refresh'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_autoshapes_get_worksheet_autoshape
#
# Get autoshape info.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $autoshape_number The autoshape number. (required)
# @param string $format Exported format. (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'autoshape_number' => {
        data_type => 'int',
        description => 'The autoshape number.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Exported format.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_autoshapes_get_worksheet_autoshape' } = { 
    	summary => 'Get autoshape info.',
        params => $params,
        returns => 'string',
        };
}
# @return string
#
sub cells_autoshapes_get_worksheet_autoshape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_autoshapes_get_worksheet_autoshape");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_autoshapes_get_worksheet_autoshape");
    }

    # verify the required parameter 'autoshape_number' is set
    unless (exists $args{'autoshape_number'}) {
      croak("Missing the required parameter 'autoshape_number' when calling cells_autoshapes_get_worksheet_autoshape");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autoshapes/{autoshapeNumber}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'format'}) {
        $query_params->{'format'} = $self->{api_client}->to_query_value($args{'format'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'autoshape_number'}) {
        my $_base_variable = "{" . "autoshapeNumber" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'autoshape_number'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('string', $response);
    return $_response_object;
}

#
# cells_autoshapes_get_worksheet_autoshapes
#
# Get worksheet autoshapes info.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_autoshapes_get_worksheet_autoshapes' } = { 
    	summary => 'Get worksheet autoshapes info.',
        params => $params,
        returns => 'AutoShapesResponse',
        };
}
# @return AutoShapesResponse
#
sub cells_autoshapes_get_worksheet_autoshapes {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_autoshapes_get_worksheet_autoshapes");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_autoshapes_get_worksheet_autoshapes");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autoshapes';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('AutoShapesResponse', $response);
    return $_response_object;
}

#
# cells_chart_area_get_chart_area
#
# Get chart area info.
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $chart_index The chart index. (required)
# @param string $folder Workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'chart_index' => {
        data_type => 'int',
        description => 'The chart index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_chart_area_get_chart_area' } = { 
    	summary => 'Get chart area info.',
        params => $params,
        returns => 'ChartAreaResponse',
        };
}
# @return ChartAreaResponse
#
sub cells_chart_area_get_chart_area {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_chart_area_get_chart_area");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_chart_area_get_chart_area");
    }

    # verify the required parameter 'chart_index' is set
    unless (exists $args{'chart_index'}) {
      croak("Missing the required parameter 'chart_index' when calling cells_chart_area_get_chart_area");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/chartArea';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'chart_index'}) {
        my $_base_variable = "{" . "chartIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'chart_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ChartAreaResponse', $response);
    return $_response_object;
}

#
# cells_chart_area_get_chart_area_border
#
# Get chart area border info.
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $chart_index The chart index. (required)
# @param string $folder Workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'chart_index' => {
        data_type => 'int',
        description => 'The chart index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_chart_area_get_chart_area_border' } = { 
    	summary => 'Get chart area border info.',
        params => $params,
        returns => 'LineResponse',
        };
}
# @return LineResponse
#
sub cells_chart_area_get_chart_area_border {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_chart_area_get_chart_area_border");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_chart_area_get_chart_area_border");
    }

    # verify the required parameter 'chart_index' is set
    unless (exists $args{'chart_index'}) {
      croak("Missing the required parameter 'chart_index' when calling cells_chart_area_get_chart_area_border");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/chartArea/border';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'chart_index'}) {
        my $_base_variable = "{" . "chartIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'chart_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('LineResponse', $response);
    return $_response_object;
}

#
# cells_chart_area_get_chart_area_fill_format
#
# Get chart area fill format info.
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $chart_index The chart index. (required)
# @param string $folder Workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'chart_index' => {
        data_type => 'int',
        description => 'The chart index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_chart_area_get_chart_area_fill_format' } = { 
    	summary => 'Get chart area fill format info.',
        params => $params,
        returns => 'FillFormatResponse',
        };
}
# @return FillFormatResponse
#
sub cells_chart_area_get_chart_area_fill_format {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_chart_area_get_chart_area_fill_format");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_chart_area_get_chart_area_fill_format");
    }

    # verify the required parameter 'chart_index' is set
    unless (exists $args{'chart_index'}) {
      croak("Missing the required parameter 'chart_index' when calling cells_chart_area_get_chart_area_fill_format");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/chartArea/fillFormat';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'chart_index'}) {
        my $_base_variable = "{" . "chartIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'chart_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('FillFormatResponse', $response);
    return $_response_object;
}

#
# cells_charts_delete_worksheet_chart_legend
#
# Hide legend in chart
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $chart_index The chart index. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'chart_index' => {
        data_type => 'int',
        description => 'The chart index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_charts_delete_worksheet_chart_legend' } = { 
    	summary => 'Hide legend in chart',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_charts_delete_worksheet_chart_legend {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_charts_delete_worksheet_chart_legend");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_charts_delete_worksheet_chart_legend");
    }

    # verify the required parameter 'chart_index' is set
    unless (exists $args{'chart_index'}) {
      croak("Missing the required parameter 'chart_index' when calling cells_charts_delete_worksheet_chart_legend");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/legend';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'chart_index'}) {
        my $_base_variable = "{" . "chartIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'chart_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_charts_delete_worksheet_chart_title
#
# Hide title in chart
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $chart_index The chart index. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'chart_index' => {
        data_type => 'int',
        description => 'The chart index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_charts_delete_worksheet_chart_title' } = { 
    	summary => 'Hide title in chart',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_charts_delete_worksheet_chart_title {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_charts_delete_worksheet_chart_title");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_charts_delete_worksheet_chart_title");
    }

    # verify the required parameter 'chart_index' is set
    unless (exists $args{'chart_index'}) {
      croak("Missing the required parameter 'chart_index' when calling cells_charts_delete_worksheet_chart_title");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/title';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'chart_index'}) {
        my $_base_variable = "{" . "chartIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'chart_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_charts_delete_worksheet_clear_charts
#
# Clear the charts.
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_charts_delete_worksheet_clear_charts' } = { 
    	summary => 'Clear the charts.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_charts_delete_worksheet_clear_charts {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_charts_delete_worksheet_clear_charts");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_charts_delete_worksheet_clear_charts");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_charts_delete_worksheet_delete_chart
#
# Delete worksheet chart by index.
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $chart_index The chart index. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'chart_index' => {
        data_type => 'int',
        description => 'The chart index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_charts_delete_worksheet_delete_chart' } = { 
    	summary => 'Delete worksheet chart by index.',
        params => $params,
        returns => 'ChartsResponse',
        };
}
# @return ChartsResponse
#
sub cells_charts_delete_worksheet_delete_chart {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_charts_delete_worksheet_delete_chart");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_charts_delete_worksheet_delete_chart");
    }

    # verify the required parameter 'chart_index' is set
    unless (exists $args{'chart_index'}) {
      croak("Missing the required parameter 'chart_index' when calling cells_charts_delete_worksheet_delete_chart");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'chart_index'}) {
        my $_base_variable = "{" . "chartIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'chart_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ChartsResponse', $response);
    return $_response_object;
}

#
# cells_charts_get_worksheet_chart
#
# Get chart info.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $chart_number The chart number. (required)
# @param string $format The exported file format. (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'chart_number' => {
        data_type => 'int',
        description => 'The chart number.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'The exported file format.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_charts_get_worksheet_chart' } = { 
    	summary => 'Get chart info.',
        params => $params,
        returns => 'string',
        };
}
# @return string
#
sub cells_charts_get_worksheet_chart {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_charts_get_worksheet_chart");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_charts_get_worksheet_chart");
    }

    # verify the required parameter 'chart_number' is set
    unless (exists $args{'chart_number'}) {
      croak("Missing the required parameter 'chart_number' when calling cells_charts_get_worksheet_chart");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts/{chartNumber}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'format'}) {
        $query_params->{'format'} = $self->{api_client}->to_query_value($args{'format'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'chart_number'}) {
        my $_base_variable = "{" . "chartNumber" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'chart_number'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('string', $response);
    return $_response_object;
}

#
# cells_charts_get_worksheet_chart_legend
#
# Get chart legend
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $chart_index The chart index. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'chart_index' => {
        data_type => 'int',
        description => 'The chart index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_charts_get_worksheet_chart_legend' } = { 
    	summary => 'Get chart legend',
        params => $params,
        returns => 'LegendResponse',
        };
}
# @return LegendResponse
#
sub cells_charts_get_worksheet_chart_legend {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_charts_get_worksheet_chart_legend");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_charts_get_worksheet_chart_legend");
    }

    # verify the required parameter 'chart_index' is set
    unless (exists $args{'chart_index'}) {
      croak("Missing the required parameter 'chart_index' when calling cells_charts_get_worksheet_chart_legend");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/legend';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'chart_index'}) {
        my $_base_variable = "{" . "chartIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'chart_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('LegendResponse', $response);
    return $_response_object;
}

#
# cells_charts_get_worksheet_chart_title
#
# Get chart title
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $chart_index The chart index. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'chart_index' => {
        data_type => 'int',
        description => 'The chart index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_charts_get_worksheet_chart_title' } = { 
    	summary => 'Get chart title',
        params => $params,
        returns => 'TitleResponse',
        };
}
# @return TitleResponse
#
sub cells_charts_get_worksheet_chart_title {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_charts_get_worksheet_chart_title");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_charts_get_worksheet_chart_title");
    }

    # verify the required parameter 'chart_index' is set
    unless (exists $args{'chart_index'}) {
      croak("Missing the required parameter 'chart_index' when calling cells_charts_get_worksheet_chart_title");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/title';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'chart_index'}) {
        my $_base_variable = "{" . "chartIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'chart_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('TitleResponse', $response);
    return $_response_object;
}

#
# cells_charts_get_worksheet_charts
#
# Get worksheet charts info.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_charts_get_worksheet_charts' } = { 
    	summary => 'Get worksheet charts info.',
        params => $params,
        returns => 'ChartsResponse',
        };
}
# @return ChartsResponse
#
sub cells_charts_get_worksheet_charts {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_charts_get_worksheet_charts");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_charts_get_worksheet_charts");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ChartsResponse', $response);
    return $_response_object;
}

#
# cells_charts_post_worksheet_chart
#
# Update chart propreties
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $chart_index  (required)
# @param Chart $chart  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'chart_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'chart' => {
        data_type => 'Chart',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_charts_post_worksheet_chart' } = { 
    	summary => 'Update chart propreties',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_charts_post_worksheet_chart {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_charts_post_worksheet_chart");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_charts_post_worksheet_chart");
    }

    # verify the required parameter 'chart_index' is set
    unless (exists $args{'chart_index'}) {
      croak("Missing the required parameter 'chart_index' when calling cells_charts_post_worksheet_chart");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'chart_index'}) {
        my $_base_variable = "{" . "chartIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'chart_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'chart'}) {
        $_body_data = $args{'chart'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_charts_post_worksheet_chart_legend
#
# Update chart legend
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $chart_index The chart index. (required)
# @param Legend $legend  (optional)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'chart_index' => {
        data_type => 'int',
        description => 'The chart index.',
        required => '1',
    },
    'legend' => {
        data_type => 'Legend',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_charts_post_worksheet_chart_legend' } = { 
    	summary => 'Update chart legend',
        params => $params,
        returns => 'LegendResponse',
        };
}
# @return LegendResponse
#
sub cells_charts_post_worksheet_chart_legend {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_charts_post_worksheet_chart_legend");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_charts_post_worksheet_chart_legend");
    }

    # verify the required parameter 'chart_index' is set
    unless (exists $args{'chart_index'}) {
      croak("Missing the required parameter 'chart_index' when calling cells_charts_post_worksheet_chart_legend");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/legend';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'chart_index'}) {
        my $_base_variable = "{" . "chartIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'chart_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'legend'}) {
        $_body_data = $args{'legend'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('LegendResponse', $response);
    return $_response_object;
}

#
# cells_charts_post_worksheet_chart_title
#
# Update chart title
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $chart_index The chart index. (required)
# @param Title $title Chart title (optional)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'chart_index' => {
        data_type => 'int',
        description => 'The chart index.',
        required => '1',
    },
    'title' => {
        data_type => 'Title',
        description => 'Chart title',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_charts_post_worksheet_chart_title' } = { 
    	summary => 'Update chart title',
        params => $params,
        returns => 'TitleResponse',
        };
}
# @return TitleResponse
#
sub cells_charts_post_worksheet_chart_title {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_charts_post_worksheet_chart_title");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_charts_post_worksheet_chart_title");
    }

    # verify the required parameter 'chart_index' is set
    unless (exists $args{'chart_index'}) {
      croak("Missing the required parameter 'chart_index' when calling cells_charts_post_worksheet_chart_title");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/title';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'chart_index'}) {
        my $_base_variable = "{" . "chartIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'chart_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'title'}) {
        $_body_data = $args{'title'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('TitleResponse', $response);
    return $_response_object;
}

#
# cells_charts_put_worksheet_add_chart
#
# Add new chart to worksheet.
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $chart_type Chart type, please refer property Type in chart resource. (required)
# @param int $upper_left_row New chart upper left row. (optional, default to 0)
# @param int $upper_left_column New chart upperleft column. (optional, default to 0)
# @param int $lower_right_row New chart lower right row. (optional, default to 0)
# @param int $lower_right_column New chart lower right column. (optional, default to 0)
# @param string $area Specifies values from which to plot the data series.  (optional)
# @param boolean $is_vertical Specifies whether to plot the series from a range of cell values by row or by column.  (optional, default to true)
# @param string $category_data Gets or sets the range of category Axis values. It can be a range of cells (such as, \&quot;d1:e10\&quot;).  (optional)
# @param boolean $is_auto_get_serial_name Specifies whether auto update serial name.  (optional, default to true)
# @param string $title Specifies chart title name. (optional)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'chart_type' => {
        data_type => 'string',
        description => 'Chart type, please refer property Type in chart resource.',
        required => '1',
    },
    'upper_left_row' => {
        data_type => 'int',
        description => 'New chart upper left row.',
        required => '0',
    },
    'upper_left_column' => {
        data_type => 'int',
        description => 'New chart upperleft column.',
        required => '0',
    },
    'lower_right_row' => {
        data_type => 'int',
        description => 'New chart lower right row.',
        required => '0',
    },
    'lower_right_column' => {
        data_type => 'int',
        description => 'New chart lower right column.',
        required => '0',
    },
    'area' => {
        data_type => 'string',
        description => 'Specifies values from which to plot the data series. ',
        required => '0',
    },
    'is_vertical' => {
        data_type => 'boolean',
        description => 'Specifies whether to plot the series from a range of cell values by row or by column. ',
        required => '0',
    },
    'category_data' => {
        data_type => 'string',
        description => 'Gets or sets the range of category Axis values. It can be a range of cells (such as, \&quot;d1:e10\&quot;). ',
        required => '0',
    },
    'is_auto_get_serial_name' => {
        data_type => 'boolean',
        description => 'Specifies whether auto update serial name. ',
        required => '0',
    },
    'title' => {
        data_type => 'string',
        description => 'Specifies chart title name.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_charts_put_worksheet_add_chart' } = { 
    	summary => 'Add new chart to worksheet.',
        params => $params,
        returns => 'ChartsResponse',
        };
}
# @return ChartsResponse
#
sub cells_charts_put_worksheet_add_chart {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_charts_put_worksheet_add_chart");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_charts_put_worksheet_add_chart");
    }

    # verify the required parameter 'chart_type' is set
    unless (exists $args{'chart_type'}) {
      croak("Missing the required parameter 'chart_type' when calling cells_charts_put_worksheet_add_chart");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'chart_type'}) {
        $query_params->{'chartType'} = $self->{api_client}->to_query_value($args{'chart_type'});
    }

    # query params
    if ( exists $args{'upper_left_row'}) {
        $query_params->{'upperLeftRow'} = $self->{api_client}->to_query_value($args{'upper_left_row'});
    }

    # query params
    if ( exists $args{'upper_left_column'}) {
        $query_params->{'upperLeftColumn'} = $self->{api_client}->to_query_value($args{'upper_left_column'});
    }

    # query params
    if ( exists $args{'lower_right_row'}) {
        $query_params->{'lowerRightRow'} = $self->{api_client}->to_query_value($args{'lower_right_row'});
    }

    # query params
    if ( exists $args{'lower_right_column'}) {
        $query_params->{'lowerRightColumn'} = $self->{api_client}->to_query_value($args{'lower_right_column'});
    }

    # query params
    if ( exists $args{'area'}) {
        $query_params->{'area'} = $self->{api_client}->to_query_value($args{'area'});
    }

    # query params
    if ( exists $args{'is_vertical'}) {
        $query_params->{'isVertical'} = $self->{api_client}->to_query_value($args{'is_vertical'});
    }

    # query params
    if ( exists $args{'category_data'}) {
        $query_params->{'categoryData'} = $self->{api_client}->to_query_value($args{'category_data'});
    }

    # query params
    if ( exists $args{'is_auto_get_serial_name'}) {
        $query_params->{'isAutoGetSerialName'} = $self->{api_client}->to_query_value($args{'is_auto_get_serial_name'});
    }

    # query params
    if ( exists $args{'title'}) {
        $query_params->{'title'} = $self->{api_client}->to_query_value($args{'title'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ChartsResponse', $response);
    return $_response_object;
}

#
# cells_charts_put_worksheet_chart_legend
#
# Show legend in chart
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $chart_index The chart index. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'chart_index' => {
        data_type => 'int',
        description => 'The chart index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_charts_put_worksheet_chart_legend' } = { 
    	summary => 'Show legend in chart',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_charts_put_worksheet_chart_legend {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_charts_put_worksheet_chart_legend");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_charts_put_worksheet_chart_legend");
    }

    # verify the required parameter 'chart_index' is set
    unless (exists $args{'chart_index'}) {
      croak("Missing the required parameter 'chart_index' when calling cells_charts_put_worksheet_chart_legend");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/legend';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'chart_index'}) {
        my $_base_variable = "{" . "chartIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'chart_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_charts_put_worksheet_chart_title
#
# Add chart title / Set chart title visible
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $chart_index The chart index. (required)
# @param Title $title Chart title. (optional)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'chart_index' => {
        data_type => 'int',
        description => 'The chart index.',
        required => '1',
    },
    'title' => {
        data_type => 'Title',
        description => 'Chart title.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_charts_put_worksheet_chart_title' } = { 
    	summary => 'Add chart title / Set chart title visible',
        params => $params,
        returns => 'TitleResponse',
        };
}
# @return TitleResponse
#
sub cells_charts_put_worksheet_chart_title {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_charts_put_worksheet_chart_title");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_charts_put_worksheet_chart_title");
    }

    # verify the required parameter 'chart_index' is set
    unless (exists $args{'chart_index'}) {
      croak("Missing the required parameter 'chart_index' when calling cells_charts_put_worksheet_chart_title");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/title';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'chart_index'}) {
        my $_base_variable = "{" . "chartIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'chart_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'title'}) {
        $_body_data = $args{'title'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('TitleResponse', $response);
    return $_response_object;
}

#
# cells_conditional_formattings_delete_worksheet_conditional_formatting
#
# Remove conditional formatting
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $index  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_conditional_formattings_delete_worksheet_conditional_formatting' } = { 
    	summary => 'Remove conditional formatting',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_conditional_formattings_delete_worksheet_conditional_formatting {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_conditional_formattings_delete_worksheet_conditional_formatting");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_conditional_formattings_delete_worksheet_conditional_formatting");
    }

    # verify the required parameter 'index' is set
    unless (exists $args{'index'}) {
      croak("Missing the required parameter 'index' when calling cells_conditional_formattings_delete_worksheet_conditional_formatting");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/conditionalFormattings/{index}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'index'}) {
        my $_base_variable = "{" . "index" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_conditional_formattings_delete_worksheet_conditional_formatting_area
#
# Remove cell area from conditional formatting.
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $start_row  (required)
# @param int $start_column  (required)
# @param int $total_rows  (required)
# @param int $total_columns  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'start_row' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'start_column' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'total_rows' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'total_columns' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_conditional_formattings_delete_worksheet_conditional_formatting_area' } = { 
    	summary => 'Remove cell area from conditional formatting.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_conditional_formattings_delete_worksheet_conditional_formatting_area {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_conditional_formattings_delete_worksheet_conditional_formatting_area");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_conditional_formattings_delete_worksheet_conditional_formatting_area");
    }

    # verify the required parameter 'start_row' is set
    unless (exists $args{'start_row'}) {
      croak("Missing the required parameter 'start_row' when calling cells_conditional_formattings_delete_worksheet_conditional_formatting_area");
    }

    # verify the required parameter 'start_column' is set
    unless (exists $args{'start_column'}) {
      croak("Missing the required parameter 'start_column' when calling cells_conditional_formattings_delete_worksheet_conditional_formatting_area");
    }

    # verify the required parameter 'total_rows' is set
    unless (exists $args{'total_rows'}) {
      croak("Missing the required parameter 'total_rows' when calling cells_conditional_formattings_delete_worksheet_conditional_formatting_area");
    }

    # verify the required parameter 'total_columns' is set
    unless (exists $args{'total_columns'}) {
      croak("Missing the required parameter 'total_columns' when calling cells_conditional_formattings_delete_worksheet_conditional_formatting_area");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/conditionalFormattings/area';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'start_row'}) {
        $query_params->{'startRow'} = $self->{api_client}->to_query_value($args{'start_row'});
    }

    # query params
    if ( exists $args{'start_column'}) {
        $query_params->{'startColumn'} = $self->{api_client}->to_query_value($args{'start_column'});
    }

    # query params
    if ( exists $args{'total_rows'}) {
        $query_params->{'totalRows'} = $self->{api_client}->to_query_value($args{'total_rows'});
    }

    # query params
    if ( exists $args{'total_columns'}) {
        $query_params->{'totalColumns'} = $self->{api_client}->to_query_value($args{'total_columns'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_conditional_formattings_delete_worksheet_conditional_formattings
#
# Clear all condition formattings
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_conditional_formattings_delete_worksheet_conditional_formattings' } = { 
    	summary => 'Clear all condition formattings',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_conditional_formattings_delete_worksheet_conditional_formattings {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_conditional_formattings_delete_worksheet_conditional_formattings");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_conditional_formattings_delete_worksheet_conditional_formattings");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/conditionalFormattings';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_conditional_formattings_get_worksheet_conditional_formatting
#
# Get conditional formatting
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $index  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_conditional_formattings_get_worksheet_conditional_formatting' } = { 
    	summary => 'Get conditional formatting',
        params => $params,
        returns => 'ConditionalFormattingResponse',
        };
}
# @return ConditionalFormattingResponse
#
sub cells_conditional_formattings_get_worksheet_conditional_formatting {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_conditional_formattings_get_worksheet_conditional_formatting");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_conditional_formattings_get_worksheet_conditional_formatting");
    }

    # verify the required parameter 'index' is set
    unless (exists $args{'index'}) {
      croak("Missing the required parameter 'index' when calling cells_conditional_formattings_get_worksheet_conditional_formatting");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/conditionalFormattings/{index}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'index'}) {
        my $_base_variable = "{" . "index" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ConditionalFormattingResponse', $response);
    return $_response_object;
}

#
# cells_conditional_formattings_get_worksheet_conditional_formattings
#
# Get conditional formattings 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_conditional_formattings_get_worksheet_conditional_formattings' } = { 
    	summary => 'Get conditional formattings ',
        params => $params,
        returns => 'ConditionalFormattingsResponse',
        };
}
# @return ConditionalFormattingsResponse
#
sub cells_conditional_formattings_get_worksheet_conditional_formattings {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_conditional_formattings_get_worksheet_conditional_formattings");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_conditional_formattings_get_worksheet_conditional_formattings");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/conditionalFormattings';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ConditionalFormattingsResponse', $response);
    return $_response_object;
}

#
# cells_conditional_formattings_put_worksheet_conditional_formatting
#
# Add a condition formatting.
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $cell_area  (required)
# @param FormatCondition $formatcondition  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'cell_area' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'formatcondition' => {
        data_type => 'FormatCondition',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_conditional_formattings_put_worksheet_conditional_formatting' } = { 
    	summary => 'Add a condition formatting.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_conditional_formattings_put_worksheet_conditional_formatting {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_conditional_formattings_put_worksheet_conditional_formatting");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_conditional_formattings_put_worksheet_conditional_formatting");
    }

    # verify the required parameter 'cell_area' is set
    unless (exists $args{'cell_area'}) {
      croak("Missing the required parameter 'cell_area' when calling cells_conditional_formattings_put_worksheet_conditional_formatting");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/conditionalFormattings';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'cell_area'}) {
        $query_params->{'cellArea'} = $self->{api_client}->to_query_value($args{'cell_area'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'formatcondition'}) {
        $_body_data = $args{'formatcondition'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_conditional_formattings_put_worksheet_format_condition
#
# Add a format condition.
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $index  (required)
# @param string $cell_area  (required)
# @param string $type  (required)
# @param string $operator_type  (required)
# @param string $formula1  (required)
# @param string $formula2  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'cell_area' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'type' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'operator_type' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'formula1' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'formula2' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_conditional_formattings_put_worksheet_format_condition' } = { 
    	summary => 'Add a format condition.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_conditional_formattings_put_worksheet_format_condition {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_conditional_formattings_put_worksheet_format_condition");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_conditional_formattings_put_worksheet_format_condition");
    }

    # verify the required parameter 'index' is set
    unless (exists $args{'index'}) {
      croak("Missing the required parameter 'index' when calling cells_conditional_formattings_put_worksheet_format_condition");
    }

    # verify the required parameter 'cell_area' is set
    unless (exists $args{'cell_area'}) {
      croak("Missing the required parameter 'cell_area' when calling cells_conditional_formattings_put_worksheet_format_condition");
    }

    # verify the required parameter 'type' is set
    unless (exists $args{'type'}) {
      croak("Missing the required parameter 'type' when calling cells_conditional_formattings_put_worksheet_format_condition");
    }

    # verify the required parameter 'operator_type' is set
    unless (exists $args{'operator_type'}) {
      croak("Missing the required parameter 'operator_type' when calling cells_conditional_formattings_put_worksheet_format_condition");
    }

    # verify the required parameter 'formula1' is set
    unless (exists $args{'formula1'}) {
      croak("Missing the required parameter 'formula1' when calling cells_conditional_formattings_put_worksheet_format_condition");
    }

    # verify the required parameter 'formula2' is set
    unless (exists $args{'formula2'}) {
      croak("Missing the required parameter 'formula2' when calling cells_conditional_formattings_put_worksheet_format_condition");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/conditionalFormattings/{index}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'cell_area'}) {
        $query_params->{'cellArea'} = $self->{api_client}->to_query_value($args{'cell_area'});
    }

    # query params
    if ( exists $args{'type'}) {
        $query_params->{'type'} = $self->{api_client}->to_query_value($args{'type'});
    }

    # query params
    if ( exists $args{'operator_type'}) {
        $query_params->{'operatorType'} = $self->{api_client}->to_query_value($args{'operator_type'});
    }

    # query params
    if ( exists $args{'formula1'}) {
        $query_params->{'formula1'} = $self->{api_client}->to_query_value($args{'formula1'});
    }

    # query params
    if ( exists $args{'formula2'}) {
        $query_params->{'formula2'} = $self->{api_client}->to_query_value($args{'formula2'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'index'}) {
        my $_base_variable = "{" . "index" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_conditional_formattings_put_worksheet_format_condition_area
#
# add a cell area for format condition             
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $index  (required)
# @param string $cell_area  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'cell_area' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_conditional_formattings_put_worksheet_format_condition_area' } = { 
    	summary => 'add a cell area for format condition             ',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_conditional_formattings_put_worksheet_format_condition_area {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_conditional_formattings_put_worksheet_format_condition_area");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_conditional_formattings_put_worksheet_format_condition_area");
    }

    # verify the required parameter 'index' is set
    unless (exists $args{'index'}) {
      croak("Missing the required parameter 'index' when calling cells_conditional_formattings_put_worksheet_format_condition_area");
    }

    # verify the required parameter 'cell_area' is set
    unless (exists $args{'cell_area'}) {
      croak("Missing the required parameter 'cell_area' when calling cells_conditional_formattings_put_worksheet_format_condition_area");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/conditionalFormattings/{index}/area';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'cell_area'}) {
        $query_params->{'cellArea'} = $self->{api_client}->to_query_value($args{'cell_area'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'index'}) {
        my $_base_variable = "{" . "index" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_conditional_formattings_put_worksheet_format_condition_condition
#
# Add a condition for format condition.
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $index  (required)
# @param string $type  (required)
# @param string $operator_type  (required)
# @param string $formula1  (required)
# @param string $formula2  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'type' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'operator_type' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'formula1' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'formula2' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_conditional_formattings_put_worksheet_format_condition_condition' } = { 
    	summary => 'Add a condition for format condition.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_conditional_formattings_put_worksheet_format_condition_condition {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_conditional_formattings_put_worksheet_format_condition_condition");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_conditional_formattings_put_worksheet_format_condition_condition");
    }

    # verify the required parameter 'index' is set
    unless (exists $args{'index'}) {
      croak("Missing the required parameter 'index' when calling cells_conditional_formattings_put_worksheet_format_condition_condition");
    }

    # verify the required parameter 'type' is set
    unless (exists $args{'type'}) {
      croak("Missing the required parameter 'type' when calling cells_conditional_formattings_put_worksheet_format_condition_condition");
    }

    # verify the required parameter 'operator_type' is set
    unless (exists $args{'operator_type'}) {
      croak("Missing the required parameter 'operator_type' when calling cells_conditional_formattings_put_worksheet_format_condition_condition");
    }

    # verify the required parameter 'formula1' is set
    unless (exists $args{'formula1'}) {
      croak("Missing the required parameter 'formula1' when calling cells_conditional_formattings_put_worksheet_format_condition_condition");
    }

    # verify the required parameter 'formula2' is set
    unless (exists $args{'formula2'}) {
      croak("Missing the required parameter 'formula2' when calling cells_conditional_formattings_put_worksheet_format_condition_condition");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/conditionalFormattings/{index}/condition';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'type'}) {
        $query_params->{'type'} = $self->{api_client}->to_query_value($args{'type'});
    }

    # query params
    if ( exists $args{'operator_type'}) {
        $query_params->{'operatorType'} = $self->{api_client}->to_query_value($args{'operator_type'});
    }

    # query params
    if ( exists $args{'formula1'}) {
        $query_params->{'formula1'} = $self->{api_client}->to_query_value($args{'formula1'});
    }

    # query params
    if ( exists $args{'formula2'}) {
        $query_params->{'formula2'} = $self->{api_client}->to_query_value($args{'formula2'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'index'}) {
        my $_base_variable = "{" . "index" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_delete_worksheet_columns
#
# Delete worksheet columns.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $column_index The column index. (required)
# @param int $columns The columns. (required)
# @param boolean $update_reference The update reference. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'column_index' => {
        data_type => 'int',
        description => 'The column index.',
        required => '1',
    },
    'columns' => {
        data_type => 'int',
        description => 'The columns.',
        required => '1',
    },
    'update_reference' => {
        data_type => 'boolean',
        description => 'The update reference.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_delete_worksheet_columns' } = { 
    	summary => 'Delete worksheet columns.',
        params => $params,
        returns => 'ColumnsResponse',
        };
}
# @return ColumnsResponse
#
sub cells_delete_worksheet_columns {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_delete_worksheet_columns");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_delete_worksheet_columns");
    }

    # verify the required parameter 'column_index' is set
    unless (exists $args{'column_index'}) {
      croak("Missing the required parameter 'column_index' when calling cells_delete_worksheet_columns");
    }

    # verify the required parameter 'columns' is set
    unless (exists $args{'columns'}) {
      croak("Missing the required parameter 'columns' when calling cells_delete_worksheet_columns");
    }

    # verify the required parameter 'update_reference' is set
    unless (exists $args{'update_reference'}) {
      croak("Missing the required parameter 'update_reference' when calling cells_delete_worksheet_columns");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/columns/{columnIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'columns'}) {
        $query_params->{'columns'} = $self->{api_client}->to_query_value($args{'columns'});
    }

    # query params
    if ( exists $args{'update_reference'}) {
        $query_params->{'updateReference'} = $self->{api_client}->to_query_value($args{'update_reference'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'column_index'}) {
        my $_base_variable = "{" . "columnIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'column_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ColumnsResponse', $response);
    return $_response_object;
}

#
# cells_delete_worksheet_row
#
# Delete worksheet row.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet bame. (required)
# @param int $row_index The row index. (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet bame.',
        required => '1',
    },
    'row_index' => {
        data_type => 'int',
        description => 'The row index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_delete_worksheet_row' } = { 
    	summary => 'Delete worksheet row.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_delete_worksheet_row {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_delete_worksheet_row");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_delete_worksheet_row");
    }

    # verify the required parameter 'row_index' is set
    unless (exists $args{'row_index'}) {
      croak("Missing the required parameter 'row_index' when calling cells_delete_worksheet_row");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/rows/{rowIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'row_index'}) {
        my $_base_variable = "{" . "rowIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'row_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_delete_worksheet_rows
#
# Delete several worksheet rows.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet bame. (required)
# @param int $startrow The begin row index to be operated. (required)
# @param int $total_rows Number of rows to be operated. (optional, default to 1)
# @param boolean $update_reference Indicates if update references in other worksheets. (optional, default to true)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet bame.',
        required => '1',
    },
    'startrow' => {
        data_type => 'int',
        description => 'The begin row index to be operated.',
        required => '1',
    },
    'total_rows' => {
        data_type => 'int',
        description => 'Number of rows to be operated.',
        required => '0',
    },
    'update_reference' => {
        data_type => 'boolean',
        description => 'Indicates if update references in other worksheets.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_delete_worksheet_rows' } = { 
    	summary => 'Delete several worksheet rows.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_delete_worksheet_rows {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_delete_worksheet_rows");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_delete_worksheet_rows");
    }

    # verify the required parameter 'startrow' is set
    unless (exists $args{'startrow'}) {
      croak("Missing the required parameter 'startrow' when calling cells_delete_worksheet_rows");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/rows';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'startrow'}) {
        $query_params->{'startrow'} = $self->{api_client}->to_query_value($args{'startrow'});
    }

    # query params
    if ( exists $args{'total_rows'}) {
        $query_params->{'totalRows'} = $self->{api_client}->to_query_value($args{'total_rows'});
    }

    # query params
    if ( exists $args{'update_reference'}) {
        $query_params->{'updateReference'} = $self->{api_client}->to_query_value($args{'update_reference'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_get_cell_html_string
#
# Read cell data by cell's name.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param string $cell_name The cell&#39;s  name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'cell_name' => {
        data_type => 'string',
        description => 'The cell&#39;s  name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_get_cell_html_string' } = { 
    	summary => 'Read cell data by cell&#39;s name.',
        params => $params,
        returns => 'object',
        };
}
# @return object
#
sub cells_get_cell_html_string {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_get_cell_html_string");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_get_cell_html_string");
    }

    # verify the required parameter 'cell_name' is set
    unless (exists $args{'cell_name'}) {
      croak("Missing the required parameter 'cell_name' when calling cells_get_cell_html_string");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/{cellName}/htmlstring';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_name'}) {
        my $_base_variable = "{" . "cellName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('object', $response);
    return $_response_object;
}

#
# cells_get_worksheet_cell
#
# Read cell data by cell's name.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param string $cell_or_method_name The cell&#39;s or method name. (Method name like firstcell, endcell etc.) (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'cell_or_method_name' => {
        data_type => 'string',
        description => 'The cell&#39;s or method name. (Method name like firstcell, endcell etc.)',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_get_worksheet_cell' } = { 
    	summary => 'Read cell data by cell&#39;s name.',
        params => $params,
        returns => 'object',
        };
}
# @return object
#
sub cells_get_worksheet_cell {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_get_worksheet_cell");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_get_worksheet_cell");
    }

    # verify the required parameter 'cell_or_method_name' is set
    unless (exists $args{'cell_or_method_name'}) {
      croak("Missing the required parameter 'cell_or_method_name' when calling cells_get_worksheet_cell");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/{cellOrMethodName}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_or_method_name'}) {
        my $_base_variable = "{" . "cellOrMethodName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_or_method_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('object', $response);
    return $_response_object;
}

#
# cells_get_worksheet_cell_style
#
# Read cell's style info.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param string $cell_name Cell&#39;s name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'cell_name' => {
        data_type => 'string',
        description => 'Cell&#39;s name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_get_worksheet_cell_style' } = { 
    	summary => 'Read cell&#39;s style info.',
        params => $params,
        returns => 'StyleResponse',
        };
}
# @return StyleResponse
#
sub cells_get_worksheet_cell_style {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_get_worksheet_cell_style");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_get_worksheet_cell_style");
    }

    # verify the required parameter 'cell_name' is set
    unless (exists $args{'cell_name'}) {
      croak("Missing the required parameter 'cell_name' when calling cells_get_worksheet_cell_style");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/{cellName}/style';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_name'}) {
        my $_base_variable = "{" . "cellName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('StyleResponse', $response);
    return $_response_object;
}

#
# cells_get_worksheet_cells
#
# Get cells info.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $offest Begginig offset. (optional, default to 0)
# @param int $count Maximum amount of cells in the response. (optional, default to 0)
# @param string $folder Document&#39;s folder name. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'offest' => {
        data_type => 'int',
        description => 'Begginig offset.',
        required => '0',
    },
    'count' => {
        data_type => 'int',
        description => 'Maximum amount of cells in the response.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder name.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_get_worksheet_cells' } = { 
    	summary => 'Get cells info.',
        params => $params,
        returns => 'CellsResponse',
        };
}
# @return CellsResponse
#
sub cells_get_worksheet_cells {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_get_worksheet_cells");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_get_worksheet_cells");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'offest'}) {
        $query_params->{'offest'} = $self->{api_client}->to_query_value($args{'offest'});
    }

    # query params
    if ( exists $args{'count'}) {
        $query_params->{'count'} = $self->{api_client}->to_query_value($args{'count'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsResponse', $response);
    return $_response_object;
}

#
# cells_get_worksheet_column
#
# Read worksheet column data by column's index.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $column_index The column index. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'column_index' => {
        data_type => 'int',
        description => 'The column index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_get_worksheet_column' } = { 
    	summary => 'Read worksheet column data by column&#39;s index.',
        params => $params,
        returns => 'ColumnResponse',
        };
}
# @return ColumnResponse
#
sub cells_get_worksheet_column {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_get_worksheet_column");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_get_worksheet_column");
    }

    # verify the required parameter 'column_index' is set
    unless (exists $args{'column_index'}) {
      croak("Missing the required parameter 'column_index' when calling cells_get_worksheet_column");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/columns/{columnIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'column_index'}) {
        my $_base_variable = "{" . "columnIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'column_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ColumnResponse', $response);
    return $_response_object;
}

#
# cells_get_worksheet_columns
#
# Read worksheet columns info.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $folder The workdook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workdook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_get_worksheet_columns' } = { 
    	summary => 'Read worksheet columns info.',
        params => $params,
        returns => 'ColumnsResponse',
        };
}
# @return ColumnsResponse
#
sub cells_get_worksheet_columns {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_get_worksheet_columns");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_get_worksheet_columns");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/columns';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ColumnsResponse', $response);
    return $_response_object;
}

#
# cells_get_worksheet_row
#
# Read worksheet row data by row's index.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $row_index The row index. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'row_index' => {
        data_type => 'int',
        description => 'The row index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_get_worksheet_row' } = { 
    	summary => 'Read worksheet row data by row&#39;s index.',
        params => $params,
        returns => 'RowResponse',
        };
}
# @return RowResponse
#
sub cells_get_worksheet_row {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_get_worksheet_row");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_get_worksheet_row");
    }

    # verify the required parameter 'row_index' is set
    unless (exists $args{'row_index'}) {
      croak("Missing the required parameter 'row_index' when calling cells_get_worksheet_row");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/rows/{rowIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'row_index'}) {
        my $_base_variable = "{" . "rowIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'row_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('RowResponse', $response);
    return $_response_object;
}

#
# cells_get_worksheet_rows
#
# Read worksheet rows info.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $folder The workdook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workdook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_get_worksheet_rows' } = { 
    	summary => 'Read worksheet rows info.',
        params => $params,
        returns => 'RowsResponse',
        };
}
# @return RowsResponse
#
sub cells_get_worksheet_rows {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_get_worksheet_rows");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_get_worksheet_rows");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/rows';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('RowsResponse', $response);
    return $_response_object;
}

#
# cells_hypelinks_delete_worksheet_hyperlink
#
# Delete worksheet hyperlink by index.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $hyperlink_index The hyperlink&#39;s index. (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'hyperlink_index' => {
        data_type => 'int',
        description => 'The hyperlink&#39;s index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_hypelinks_delete_worksheet_hyperlink' } = { 
    	summary => 'Delete worksheet hyperlink by index.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_hypelinks_delete_worksheet_hyperlink {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_hypelinks_delete_worksheet_hyperlink");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_hypelinks_delete_worksheet_hyperlink");
    }

    # verify the required parameter 'hyperlink_index' is set
    unless (exists $args{'hyperlink_index'}) {
      croak("Missing the required parameter 'hyperlink_index' when calling cells_hypelinks_delete_worksheet_hyperlink");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/hyperlinks/{hyperlinkIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'hyperlink_index'}) {
        my $_base_variable = "{" . "hyperlinkIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'hyperlink_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_hypelinks_delete_worksheet_hyperlinks
#
# Delete all hyperlinks in worksheet.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_hypelinks_delete_worksheet_hyperlinks' } = { 
    	summary => 'Delete all hyperlinks in worksheet.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_hypelinks_delete_worksheet_hyperlinks {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_hypelinks_delete_worksheet_hyperlinks");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_hypelinks_delete_worksheet_hyperlinks");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/hyperlinks';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_hypelinks_get_worksheet_hyperlink
#
# Get worksheet hyperlink by index.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $hyperlink_index The hyperlink&#39;s index. (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'hyperlink_index' => {
        data_type => 'int',
        description => 'The hyperlink&#39;s index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_hypelinks_get_worksheet_hyperlink' } = { 
    	summary => 'Get worksheet hyperlink by index.',
        params => $params,
        returns => 'HyperlinkResponse',
        };
}
# @return HyperlinkResponse
#
sub cells_hypelinks_get_worksheet_hyperlink {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_hypelinks_get_worksheet_hyperlink");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_hypelinks_get_worksheet_hyperlink");
    }

    # verify the required parameter 'hyperlink_index' is set
    unless (exists $args{'hyperlink_index'}) {
      croak("Missing the required parameter 'hyperlink_index' when calling cells_hypelinks_get_worksheet_hyperlink");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/hyperlinks/{hyperlinkIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'hyperlink_index'}) {
        my $_base_variable = "{" . "hyperlinkIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'hyperlink_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('HyperlinkResponse', $response);
    return $_response_object;
}

#
# cells_hypelinks_get_worksheet_hyperlinks
#
# Get worksheet hyperlinks.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_hypelinks_get_worksheet_hyperlinks' } = { 
    	summary => 'Get worksheet hyperlinks.',
        params => $params,
        returns => 'HyperlinksResponse',
        };
}
# @return HyperlinksResponse
#
sub cells_hypelinks_get_worksheet_hyperlinks {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_hypelinks_get_worksheet_hyperlinks");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_hypelinks_get_worksheet_hyperlinks");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/hyperlinks';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('HyperlinksResponse', $response);
    return $_response_object;
}

#
# cells_hypelinks_post_worksheet_hyperlink
#
# Update worksheet hyperlink by index.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $hyperlink_index The hyperlink&#39;s index. (required)
# @param Hyperlink $hyperlink Hyperlink object (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'hyperlink_index' => {
        data_type => 'int',
        description => 'The hyperlink&#39;s index.',
        required => '1',
    },
    'hyperlink' => {
        data_type => 'Hyperlink',
        description => 'Hyperlink object',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_hypelinks_post_worksheet_hyperlink' } = { 
    	summary => 'Update worksheet hyperlink by index.',
        params => $params,
        returns => 'HyperlinkResponse',
        };
}
# @return HyperlinkResponse
#
sub cells_hypelinks_post_worksheet_hyperlink {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_hypelinks_post_worksheet_hyperlink");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_hypelinks_post_worksheet_hyperlink");
    }

    # verify the required parameter 'hyperlink_index' is set
    unless (exists $args{'hyperlink_index'}) {
      croak("Missing the required parameter 'hyperlink_index' when calling cells_hypelinks_post_worksheet_hyperlink");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/hyperlinks/{hyperlinkIndex}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'hyperlink_index'}) {
        my $_base_variable = "{" . "hyperlinkIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'hyperlink_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'hyperlink'}) {
        $_body_data = $args{'hyperlink'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('HyperlinkResponse', $response);
    return $_response_object;
}

#
# cells_hypelinks_put_worksheet_hyperlink
#
# Add worksheet hyperlink.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $first_row  (required)
# @param int $first_column  (required)
# @param int $total_rows  (required)
# @param int $total_columns  (required)
# @param string $address  (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'first_row' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'first_column' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'total_rows' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'total_columns' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'address' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_hypelinks_put_worksheet_hyperlink' } = { 
    	summary => 'Add worksheet hyperlink.',
        params => $params,
        returns => 'HyperlinkResponse',
        };
}
# @return HyperlinkResponse
#
sub cells_hypelinks_put_worksheet_hyperlink {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_hypelinks_put_worksheet_hyperlink");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_hypelinks_put_worksheet_hyperlink");
    }

    # verify the required parameter 'first_row' is set
    unless (exists $args{'first_row'}) {
      croak("Missing the required parameter 'first_row' when calling cells_hypelinks_put_worksheet_hyperlink");
    }

    # verify the required parameter 'first_column' is set
    unless (exists $args{'first_column'}) {
      croak("Missing the required parameter 'first_column' when calling cells_hypelinks_put_worksheet_hyperlink");
    }

    # verify the required parameter 'total_rows' is set
    unless (exists $args{'total_rows'}) {
      croak("Missing the required parameter 'total_rows' when calling cells_hypelinks_put_worksheet_hyperlink");
    }

    # verify the required parameter 'total_columns' is set
    unless (exists $args{'total_columns'}) {
      croak("Missing the required parameter 'total_columns' when calling cells_hypelinks_put_worksheet_hyperlink");
    }

    # verify the required parameter 'address' is set
    unless (exists $args{'address'}) {
      croak("Missing the required parameter 'address' when calling cells_hypelinks_put_worksheet_hyperlink");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/hyperlinks';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'first_row'}) {
        $query_params->{'firstRow'} = $self->{api_client}->to_query_value($args{'first_row'});
    }

    # query params
    if ( exists $args{'first_column'}) {
        $query_params->{'firstColumn'} = $self->{api_client}->to_query_value($args{'first_column'});
    }

    # query params
    if ( exists $args{'total_rows'}) {
        $query_params->{'totalRows'} = $self->{api_client}->to_query_value($args{'total_rows'});
    }

    # query params
    if ( exists $args{'total_columns'}) {
        $query_params->{'totalColumns'} = $self->{api_client}->to_query_value($args{'total_columns'});
    }

    # query params
    if ( exists $args{'address'}) {
        $query_params->{'address'} = $self->{api_client}->to_query_value($args{'address'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('HyperlinkResponse', $response);
    return $_response_object;
}

#
# cells_list_objects_delete_worksheet_list_object
#
# Delete worksheet list object by index
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $list_object_index List object index (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'list_object_index' => {
        data_type => 'int',
        description => 'List object index',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_list_objects_delete_worksheet_list_object' } = { 
    	summary => 'Delete worksheet list object by index',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_list_objects_delete_worksheet_list_object {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_list_objects_delete_worksheet_list_object");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_list_objects_delete_worksheet_list_object");
    }

    # verify the required parameter 'list_object_index' is set
    unless (exists $args{'list_object_index'}) {
      croak("Missing the required parameter 'list_object_index' when calling cells_list_objects_delete_worksheet_list_object");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/listobjects/{listObjectIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'list_object_index'}) {
        my $_base_variable = "{" . "listObjectIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'list_object_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_list_objects_delete_worksheet_list_objects
#
# Delete worksheet list objects
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_list_objects_delete_worksheet_list_objects' } = { 
    	summary => 'Delete worksheet list objects',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_list_objects_delete_worksheet_list_objects {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_list_objects_delete_worksheet_list_objects");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_list_objects_delete_worksheet_list_objects");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/listobjects';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_list_objects_get_worksheet_list_object
#
# Get worksheet list object info by index.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $listobjectindex list object index. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'listobjectindex' => {
        data_type => 'int',
        description => 'list object index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_list_objects_get_worksheet_list_object' } = { 
    	summary => 'Get worksheet list object info by index.',
        params => $params,
        returns => 'ListObjectResponse',
        };
}
# @return ListObjectResponse
#
sub cells_list_objects_get_worksheet_list_object {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_list_objects_get_worksheet_list_object");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_list_objects_get_worksheet_list_object");
    }

    # verify the required parameter 'listobjectindex' is set
    unless (exists $args{'listobjectindex'}) {
      croak("Missing the required parameter 'listobjectindex' when calling cells_list_objects_get_worksheet_list_object");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/listobjects/{listobjectindex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'listobjectindex'}) {
        my $_base_variable = "{" . "listobjectindex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'listobjectindex'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ListObjectResponse', $response);
    return $_response_object;
}

#
# cells_list_objects_get_worksheet_list_objects
#
# Get worksheet listobjects info.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_list_objects_get_worksheet_list_objects' } = { 
    	summary => 'Get worksheet listobjects info.',
        params => $params,
        returns => 'ListObjectsResponse',
        };
}
# @return ListObjectsResponse
#
sub cells_list_objects_get_worksheet_list_objects {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_list_objects_get_worksheet_list_objects");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_list_objects_get_worksheet_list_objects");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/listobjects';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ListObjectsResponse', $response);
    return $_response_object;
}

#
# cells_list_objects_post_worksheet_list_object
#
# Update  list object 
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $list_object_index list Object index (required)
# @param ListObject $list_object listObject dto in request body. (optional)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'list_object_index' => {
        data_type => 'int',
        description => 'list Object index',
        required => '1',
    },
    'list_object' => {
        data_type => 'ListObject',
        description => 'listObject dto in request body.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_list_objects_post_worksheet_list_object' } = { 
    	summary => 'Update  list object ',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_list_objects_post_worksheet_list_object {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_list_objects_post_worksheet_list_object");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_list_objects_post_worksheet_list_object");
    }

    # verify the required parameter 'list_object_index' is set
    unless (exists $args{'list_object_index'}) {
      croak("Missing the required parameter 'list_object_index' when calling cells_list_objects_post_worksheet_list_object");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/listobjects/{listObjectIndex}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'list_object_index'}) {
        my $_base_variable = "{" . "listObjectIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'list_object_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'list_object'}) {
        $_body_data = $args{'list_object'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_list_objects_post_worksheet_list_object_convert_to_range
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $list_object_index  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'list_object_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_list_objects_post_worksheet_list_object_convert_to_range' } = { 
    	summary => '',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_list_objects_post_worksheet_list_object_convert_to_range {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_list_objects_post_worksheet_list_object_convert_to_range");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_list_objects_post_worksheet_list_object_convert_to_range");
    }

    # verify the required parameter 'list_object_index' is set
    unless (exists $args{'list_object_index'}) {
      croak("Missing the required parameter 'list_object_index' when calling cells_list_objects_post_worksheet_list_object_convert_to_range");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/listobjects/{listObjectIndex}/ConvertToRange';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'list_object_index'}) {
        my $_base_variable = "{" . "listObjectIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'list_object_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_list_objects_post_worksheet_list_object_sort_table
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $list_object_index  (required)
# @param DataSorter $data_sorter  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'list_object_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'data_sorter' => {
        data_type => 'DataSorter',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_list_objects_post_worksheet_list_object_sort_table' } = { 
    	summary => '',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_list_objects_post_worksheet_list_object_sort_table {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_list_objects_post_worksheet_list_object_sort_table");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_list_objects_post_worksheet_list_object_sort_table");
    }

    # verify the required parameter 'list_object_index' is set
    unless (exists $args{'list_object_index'}) {
      croak("Missing the required parameter 'list_object_index' when calling cells_list_objects_post_worksheet_list_object_sort_table");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/listobjects/{listObjectIndex}/sort';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'list_object_index'}) {
        my $_base_variable = "{" . "listObjectIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'list_object_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'data_sorter'}) {
        $_body_data = $args{'data_sorter'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_list_objects_post_worksheet_list_object_summarize_with_pivot_table
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $list_object_index  (required)
# @param string $destsheet_name  (required)
# @param CreatePivotTableRequest $request  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'list_object_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'destsheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'request' => {
        data_type => 'CreatePivotTableRequest',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_list_objects_post_worksheet_list_object_summarize_with_pivot_table' } = { 
    	summary => '',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_list_objects_post_worksheet_list_object_summarize_with_pivot_table {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_list_objects_post_worksheet_list_object_summarize_with_pivot_table");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_list_objects_post_worksheet_list_object_summarize_with_pivot_table");
    }

    # verify the required parameter 'list_object_index' is set
    unless (exists $args{'list_object_index'}) {
      croak("Missing the required parameter 'list_object_index' when calling cells_list_objects_post_worksheet_list_object_summarize_with_pivot_table");
    }

    # verify the required parameter 'destsheet_name' is set
    unless (exists $args{'destsheet_name'}) {
      croak("Missing the required parameter 'destsheet_name' when calling cells_list_objects_post_worksheet_list_object_summarize_with_pivot_table");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/listobjects/{listObjectIndex}/SummarizeWithPivotTable';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'destsheet_name'}) {
        $query_params->{'destsheetName'} = $self->{api_client}->to_query_value($args{'destsheet_name'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'list_object_index'}) {
        my $_base_variable = "{" . "listObjectIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'list_object_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'request'}) {
        $_body_data = $args{'request'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_list_objects_put_worksheet_list_object
#
# Add a list object into worksheet.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $start_row The start row of the list range. (required)
# @param int $start_column The start row of the list range. (required)
# @param int $end_row The start row of the list range. (required)
# @param int $end_column The start row of the list range. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
# @param boolean $has_headers Whether the range has headers. (optional, default to true)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'start_row' => {
        data_type => 'int',
        description => 'The start row of the list range.',
        required => '1',
    },
    'start_column' => {
        data_type => 'int',
        description => 'The start row of the list range.',
        required => '1',
    },
    'end_row' => {
        data_type => 'int',
        description => 'The start row of the list range.',
        required => '1',
    },
    'end_column' => {
        data_type => 'int',
        description => 'The start row of the list range.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    'has_headers' => {
        data_type => 'boolean',
        description => 'Whether the range has headers.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_list_objects_put_worksheet_list_object' } = { 
    	summary => 'Add a list object into worksheet.',
        params => $params,
        returns => 'ListObjectResponse',
        };
}
# @return ListObjectResponse
#
sub cells_list_objects_put_worksheet_list_object {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_list_objects_put_worksheet_list_object");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_list_objects_put_worksheet_list_object");
    }

    # verify the required parameter 'start_row' is set
    unless (exists $args{'start_row'}) {
      croak("Missing the required parameter 'start_row' when calling cells_list_objects_put_worksheet_list_object");
    }

    # verify the required parameter 'start_column' is set
    unless (exists $args{'start_column'}) {
      croak("Missing the required parameter 'start_column' when calling cells_list_objects_put_worksheet_list_object");
    }

    # verify the required parameter 'end_row' is set
    unless (exists $args{'end_row'}) {
      croak("Missing the required parameter 'end_row' when calling cells_list_objects_put_worksheet_list_object");
    }

    # verify the required parameter 'end_column' is set
    unless (exists $args{'end_column'}) {
      croak("Missing the required parameter 'end_column' when calling cells_list_objects_put_worksheet_list_object");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/listobjects';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'start_row'}) {
        $query_params->{'startRow'} = $self->{api_client}->to_query_value($args{'start_row'});
    }

    # query params
    if ( exists $args{'start_column'}) {
        $query_params->{'startColumn'} = $self->{api_client}->to_query_value($args{'start_column'});
    }

    # query params
    if ( exists $args{'end_row'}) {
        $query_params->{'endRow'} = $self->{api_client}->to_query_value($args{'end_row'});
    }

    # query params
    if ( exists $args{'end_column'}) {
        $query_params->{'endColumn'} = $self->{api_client}->to_query_value($args{'end_column'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if ( exists $args{'has_headers'}) {
        $query_params->{'hasHeaders'} = $self->{api_client}->to_query_value($args{'has_headers'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ListObjectResponse', $response);
    return $_response_object;
}

#
# cells_ole_objects_delete_worksheet_ole_object
#
# Delete OLE object.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worsheet name. (required)
# @param int $ole_object_index Ole object index (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worsheet name.',
        required => '1',
    },
    'ole_object_index' => {
        data_type => 'int',
        description => 'Ole object index',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ole_objects_delete_worksheet_ole_object' } = { 
    	summary => 'Delete OLE object.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_ole_objects_delete_worksheet_ole_object {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ole_objects_delete_worksheet_ole_object");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ole_objects_delete_worksheet_ole_object");
    }

    # verify the required parameter 'ole_object_index' is set
    unless (exists $args{'ole_object_index'}) {
      croak("Missing the required parameter 'ole_object_index' when calling cells_ole_objects_delete_worksheet_ole_object");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/oleobjects/{oleObjectIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'ole_object_index'}) {
        my $_base_variable = "{" . "oleObjectIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'ole_object_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_ole_objects_delete_worksheet_ole_objects
#
# Delete all OLE objects.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worsheet name. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worsheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ole_objects_delete_worksheet_ole_objects' } = { 
    	summary => 'Delete all OLE objects.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_ole_objects_delete_worksheet_ole_objects {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ole_objects_delete_worksheet_ole_objects");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ole_objects_delete_worksheet_ole_objects");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/oleobjects';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_ole_objects_get_worksheet_ole_object
#
# Get OLE object info.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $object_number The object number. (required)
# @param string $format The exported object format. (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'object_number' => {
        data_type => 'int',
        description => 'The object number.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'The exported object format.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ole_objects_get_worksheet_ole_object' } = { 
    	summary => 'Get OLE object info.',
        params => $params,
        returns => 'string',
        };
}
# @return string
#
sub cells_ole_objects_get_worksheet_ole_object {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ole_objects_get_worksheet_ole_object");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ole_objects_get_worksheet_ole_object");
    }

    # verify the required parameter 'object_number' is set
    unless (exists $args{'object_number'}) {
      croak("Missing the required parameter 'object_number' when calling cells_ole_objects_get_worksheet_ole_object");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/oleobjects/{objectNumber}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'format'}) {
        $query_params->{'format'} = $self->{api_client}->to_query_value($args{'format'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'object_number'}) {
        my $_base_variable = "{" . "objectNumber" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'object_number'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('string', $response);
    return $_response_object;
}

#
# cells_ole_objects_get_worksheet_ole_objects
#
# Get worksheet OLE objects info.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ole_objects_get_worksheet_ole_objects' } = { 
    	summary => 'Get worksheet OLE objects info.',
        params => $params,
        returns => 'OleObjectsResponse',
        };
}
# @return OleObjectsResponse
#
sub cells_ole_objects_get_worksheet_ole_objects {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ole_objects_get_worksheet_ole_objects");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ole_objects_get_worksheet_ole_objects");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/oleobjects';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('OleObjectsResponse', $response);
    return $_response_object;
}

#
# cells_ole_objects_post_update_worksheet_ole_object
#
# Update OLE object.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worsheet name. (required)
# @param int $ole_object_index Ole object index (required)
# @param OleObject $ole Ole Object (optional)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worsheet name.',
        required => '1',
    },
    'ole_object_index' => {
        data_type => 'int',
        description => 'Ole object index',
        required => '1',
    },
    'ole' => {
        data_type => 'OleObject',
        description => 'Ole Object',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ole_objects_post_update_worksheet_ole_object' } = { 
    	summary => 'Update OLE object.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_ole_objects_post_update_worksheet_ole_object {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ole_objects_post_update_worksheet_ole_object");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ole_objects_post_update_worksheet_ole_object");
    }

    # verify the required parameter 'ole_object_index' is set
    unless (exists $args{'ole_object_index'}) {
      croak("Missing the required parameter 'ole_object_index' when calling cells_ole_objects_post_update_worksheet_ole_object");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/oleobjects/{oleObjectIndex}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'ole_object_index'}) {
        my $_base_variable = "{" . "oleObjectIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'ole_object_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'ole'}) {
        $_body_data = $args{'ole'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_ole_objects_put_worksheet_ole_object
#
# Add OLE object
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worsheet name. (required)
# @param OleObject $ole_object Ole Object (optional)
# @param int $upper_left_row Upper left row index (optional, default to 0)
# @param int $upper_left_column Upper left column index (optional, default to 0)
# @param int $height Height of oleObject, in unit of pixel (optional, default to 0)
# @param int $width Width of oleObject, in unit of pixel (optional, default to 0)
# @param string $ole_file OLE filename (optional)
# @param string $image_file Image filename (optional)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worsheet name.',
        required => '1',
    },
    'ole_object' => {
        data_type => 'OleObject',
        description => 'Ole Object',
        required => '0',
    },
    'upper_left_row' => {
        data_type => 'int',
        description => 'Upper left row index',
        required => '0',
    },
    'upper_left_column' => {
        data_type => 'int',
        description => 'Upper left column index',
        required => '0',
    },
    'height' => {
        data_type => 'int',
        description => 'Height of oleObject, in unit of pixel',
        required => '0',
    },
    'width' => {
        data_type => 'int',
        description => 'Width of oleObject, in unit of pixel',
        required => '0',
    },
    'ole_file' => {
        data_type => 'string',
        description => 'OLE filename',
        required => '0',
    },
    'image_file' => {
        data_type => 'string',
        description => 'Image filename',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ole_objects_put_worksheet_ole_object' } = { 
    	summary => 'Add OLE object',
        params => $params,
        returns => 'OleObjectResponse',
        };
}
# @return OleObjectResponse
#
sub cells_ole_objects_put_worksheet_ole_object {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ole_objects_put_worksheet_ole_object");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ole_objects_put_worksheet_ole_object");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/oleobjects';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'upper_left_row'}) {
        $query_params->{'upperLeftRow'} = $self->{api_client}->to_query_value($args{'upper_left_row'});
    }

    # query params
    if ( exists $args{'upper_left_column'}) {
        $query_params->{'upperLeftColumn'} = $self->{api_client}->to_query_value($args{'upper_left_column'});
    }

    # query params
    if ( exists $args{'height'}) {
        $query_params->{'height'} = $self->{api_client}->to_query_value($args{'height'});
    }

    # query params
    if ( exists $args{'width'}) {
        $query_params->{'width'} = $self->{api_client}->to_query_value($args{'width'});
    }

    # query params
    if ( exists $args{'ole_file'}) {
        $query_params->{'oleFile'} = $self->{api_client}->to_query_value($args{'ole_file'});
    }

    # query params
    if ( exists $args{'image_file'}) {
        $query_params->{'imageFile'} = $self->{api_client}->to_query_value($args{'image_file'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'ole_object'}) {
        $_body_data = $args{'ole_object'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('OleObjectResponse', $response);
    return $_response_object;
}

#
# cells_page_breaks_delete_horizontal_page_break
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $index  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_page_breaks_delete_horizontal_page_break' } = { 
    	summary => '',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_page_breaks_delete_horizontal_page_break {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_page_breaks_delete_horizontal_page_break");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_page_breaks_delete_horizontal_page_break");
    }

    # verify the required parameter 'index' is set
    unless (exists $args{'index'}) {
      croak("Missing the required parameter 'index' when calling cells_page_breaks_delete_horizontal_page_break");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/horizontalpagebreaks/{index}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'index'}) {
        my $_base_variable = "{" . "index" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_page_breaks_delete_horizontal_page_breaks
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $row  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'row' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_page_breaks_delete_horizontal_page_breaks' } = { 
    	summary => '',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_page_breaks_delete_horizontal_page_breaks {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_page_breaks_delete_horizontal_page_breaks");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_page_breaks_delete_horizontal_page_breaks");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/horizontalpagebreaks';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'row'}) {
        $query_params->{'row'} = $self->{api_client}->to_query_value($args{'row'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_page_breaks_delete_vertical_page_break
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $index  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_page_breaks_delete_vertical_page_break' } = { 
    	summary => '',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_page_breaks_delete_vertical_page_break {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_page_breaks_delete_vertical_page_break");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_page_breaks_delete_vertical_page_break");
    }

    # verify the required parameter 'index' is set
    unless (exists $args{'index'}) {
      croak("Missing the required parameter 'index' when calling cells_page_breaks_delete_vertical_page_break");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/verticalpagebreaks/{index}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'index'}) {
        my $_base_variable = "{" . "index" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_page_breaks_delete_vertical_page_breaks
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $column  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'column' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_page_breaks_delete_vertical_page_breaks' } = { 
    	summary => '',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_page_breaks_delete_vertical_page_breaks {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_page_breaks_delete_vertical_page_breaks");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_page_breaks_delete_vertical_page_breaks");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/verticalpagebreaks';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'column'}) {
        $query_params->{'column'} = $self->{api_client}->to_query_value($args{'column'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_page_breaks_get_horizontal_page_break
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $index  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_page_breaks_get_horizontal_page_break' } = { 
    	summary => '',
        params => $params,
        returns => 'HorizontalPageBreakResponse',
        };
}
# @return HorizontalPageBreakResponse
#
sub cells_page_breaks_get_horizontal_page_break {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_page_breaks_get_horizontal_page_break");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_page_breaks_get_horizontal_page_break");
    }

    # verify the required parameter 'index' is set
    unless (exists $args{'index'}) {
      croak("Missing the required parameter 'index' when calling cells_page_breaks_get_horizontal_page_break");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/horizontalpagebreaks/{index}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'index'}) {
        my $_base_variable = "{" . "index" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('HorizontalPageBreakResponse', $response);
    return $_response_object;
}

#
# cells_page_breaks_get_horizontal_page_breaks
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_page_breaks_get_horizontal_page_breaks' } = { 
    	summary => '',
        params => $params,
        returns => 'HorizontalPageBreaksResponse',
        };
}
# @return HorizontalPageBreaksResponse
#
sub cells_page_breaks_get_horizontal_page_breaks {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_page_breaks_get_horizontal_page_breaks");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_page_breaks_get_horizontal_page_breaks");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/horizontalpagebreaks';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('HorizontalPageBreaksResponse', $response);
    return $_response_object;
}

#
# cells_page_breaks_get_vertical_page_break
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $index  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_page_breaks_get_vertical_page_break' } = { 
    	summary => '',
        params => $params,
        returns => 'VerticalPageBreakResponse',
        };
}
# @return VerticalPageBreakResponse
#
sub cells_page_breaks_get_vertical_page_break {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_page_breaks_get_vertical_page_break");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_page_breaks_get_vertical_page_break");
    }

    # verify the required parameter 'index' is set
    unless (exists $args{'index'}) {
      croak("Missing the required parameter 'index' when calling cells_page_breaks_get_vertical_page_break");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/verticalpagebreaks/{index}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'index'}) {
        my $_base_variable = "{" . "index" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('VerticalPageBreakResponse', $response);
    return $_response_object;
}

#
# cells_page_breaks_get_vertical_page_breaks
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_page_breaks_get_vertical_page_breaks' } = { 
    	summary => '',
        params => $params,
        returns => 'VerticalPageBreaksResponse',
        };
}
# @return VerticalPageBreaksResponse
#
sub cells_page_breaks_get_vertical_page_breaks {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_page_breaks_get_vertical_page_breaks");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_page_breaks_get_vertical_page_breaks");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/verticalpagebreaks';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('VerticalPageBreaksResponse', $response);
    return $_response_object;
}

#
# cells_page_breaks_put_horizontal_page_break
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $cellname  (optional)
# @param int $row  (optional)
# @param int $column  (optional)
# @param int $start_column  (optional)
# @param int $end_column  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'cellname' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'row' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'column' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'start_column' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'end_column' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_page_breaks_put_horizontal_page_break' } = { 
    	summary => '',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_page_breaks_put_horizontal_page_break {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_page_breaks_put_horizontal_page_break");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_page_breaks_put_horizontal_page_break");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/horizontalpagebreaks';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'cellname'}) {
        $query_params->{'cellname'} = $self->{api_client}->to_query_value($args{'cellname'});
    }

    # query params
    if ( exists $args{'row'}) {
        $query_params->{'row'} = $self->{api_client}->to_query_value($args{'row'});
    }

    # query params
    if ( exists $args{'column'}) {
        $query_params->{'column'} = $self->{api_client}->to_query_value($args{'column'});
    }

    # query params
    if ( exists $args{'start_column'}) {
        $query_params->{'startColumn'} = $self->{api_client}->to_query_value($args{'start_column'});
    }

    # query params
    if ( exists $args{'end_column'}) {
        $query_params->{'endColumn'} = $self->{api_client}->to_query_value($args{'end_column'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_page_breaks_put_vertical_page_break
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $cellname  (optional)
# @param int $column  (optional)
# @param int $row  (optional)
# @param int $start_row  (optional)
# @param int $end_row  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'cellname' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'column' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'row' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'start_row' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'end_row' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_page_breaks_put_vertical_page_break' } = { 
    	summary => '',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_page_breaks_put_vertical_page_break {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_page_breaks_put_vertical_page_break");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_page_breaks_put_vertical_page_break");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/verticalpagebreaks';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'cellname'}) {
        $query_params->{'cellname'} = $self->{api_client}->to_query_value($args{'cellname'});
    }

    # query params
    if ( exists $args{'column'}) {
        $query_params->{'column'} = $self->{api_client}->to_query_value($args{'column'});
    }

    # query params
    if ( exists $args{'row'}) {
        $query_params->{'row'} = $self->{api_client}->to_query_value($args{'row'});
    }

    # query params
    if ( exists $args{'start_row'}) {
        $query_params->{'startRow'} = $self->{api_client}->to_query_value($args{'start_row'});
    }

    # query params
    if ( exists $args{'end_row'}) {
        $query_params->{'endRow'} = $self->{api_client}->to_query_value($args{'end_row'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_page_setup_delete_header_footer
#
# clear header footer
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_page_setup_delete_header_footer' } = { 
    	summary => 'clear header footer',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_page_setup_delete_header_footer {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_page_setup_delete_header_footer");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_page_setup_delete_header_footer");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pagesetup/clearheaderfooter';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_page_setup_get_footer
#
# get page footer information
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_page_setup_get_footer' } = { 
    	summary => 'get page footer information',
        params => $params,
        returns => 'PageSectionsResponse',
        };
}
# @return PageSectionsResponse
#
sub cells_page_setup_get_footer {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_page_setup_get_footer");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_page_setup_get_footer");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pagesetup/footer';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('PageSectionsResponse', $response);
    return $_response_object;
}

#
# cells_page_setup_get_header
#
# get page header information
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_page_setup_get_header' } = { 
    	summary => 'get page header information',
        params => $params,
        returns => 'PageSectionsResponse',
        };
}
# @return PageSectionsResponse
#
sub cells_page_setup_get_header {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_page_setup_get_header");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_page_setup_get_header");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pagesetup/header';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('PageSectionsResponse', $response);
    return $_response_object;
}

#
# cells_page_setup_get_page_setup
#
# Get Page Setup information.             
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_page_setup_get_page_setup' } = { 
    	summary => 'Get Page Setup information.             ',
        params => $params,
        returns => 'PageSetupResponse',
        };
}
# @return PageSetupResponse
#
sub cells_page_setup_get_page_setup {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_page_setup_get_page_setup");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_page_setup_get_page_setup");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pagesetup';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('PageSetupResponse', $response);
    return $_response_object;
}

#
# cells_page_setup_post_footer
#
# update  page footer information 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $section  (required)
# @param string $script  (required)
# @param boolean $is_first_page  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'section' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'script' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'is_first_page' => {
        data_type => 'boolean',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_page_setup_post_footer' } = { 
    	summary => 'update  page footer information ',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_page_setup_post_footer {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_page_setup_post_footer");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_page_setup_post_footer");
    }

    # verify the required parameter 'section' is set
    unless (exists $args{'section'}) {
      croak("Missing the required parameter 'section' when calling cells_page_setup_post_footer");
    }

    # verify the required parameter 'script' is set
    unless (exists $args{'script'}) {
      croak("Missing the required parameter 'script' when calling cells_page_setup_post_footer");
    }

    # verify the required parameter 'is_first_page' is set
    unless (exists $args{'is_first_page'}) {
      croak("Missing the required parameter 'is_first_page' when calling cells_page_setup_post_footer");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pagesetup/footer';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'section'}) {
        $query_params->{'section'} = $self->{api_client}->to_query_value($args{'section'});
    }

    # query params
    if ( exists $args{'script'}) {
        $query_params->{'script'} = $self->{api_client}->to_query_value($args{'script'});
    }

    # query params
    if ( exists $args{'is_first_page'}) {
        $query_params->{'isFirstPage'} = $self->{api_client}->to_query_value($args{'is_first_page'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_page_setup_post_header
#
# update  page header information 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $section  (required)
# @param string $script  (required)
# @param boolean $is_first_page  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'section' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'script' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'is_first_page' => {
        data_type => 'boolean',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_page_setup_post_header' } = { 
    	summary => 'update  page header information ',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_page_setup_post_header {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_page_setup_post_header");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_page_setup_post_header");
    }

    # verify the required parameter 'section' is set
    unless (exists $args{'section'}) {
      croak("Missing the required parameter 'section' when calling cells_page_setup_post_header");
    }

    # verify the required parameter 'script' is set
    unless (exists $args{'script'}) {
      croak("Missing the required parameter 'script' when calling cells_page_setup_post_header");
    }

    # verify the required parameter 'is_first_page' is set
    unless (exists $args{'is_first_page'}) {
      croak("Missing the required parameter 'is_first_page' when calling cells_page_setup_post_header");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pagesetup/header';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'section'}) {
        $query_params->{'section'} = $self->{api_client}->to_query_value($args{'section'});
    }

    # query params
    if ( exists $args{'script'}) {
        $query_params->{'script'} = $self->{api_client}->to_query_value($args{'script'});
    }

    # query params
    if ( exists $args{'is_first_page'}) {
        $query_params->{'isFirstPage'} = $self->{api_client}->to_query_value($args{'is_first_page'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_page_setup_post_page_setup
#
# Update Page Setup information.
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param PageSetup $page_setup  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'page_setup' => {
        data_type => 'PageSetup',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_page_setup_post_page_setup' } = { 
    	summary => 'Update Page Setup information.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_page_setup_post_page_setup {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_page_setup_post_page_setup");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_page_setup_post_page_setup");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pagesetup';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'page_setup'}) {
        $_body_data = $args{'page_setup'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_pictures_delete_worksheet_picture
#
# Delete a picture object in worksheet
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worsheet name. (required)
# @param int $picture_index Picture index (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worsheet name.',
        required => '1',
    },
    'picture_index' => {
        data_type => 'int',
        description => 'Picture index',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pictures_delete_worksheet_picture' } = { 
    	summary => 'Delete a picture object in worksheet',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_pictures_delete_worksheet_picture {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pictures_delete_worksheet_picture");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pictures_delete_worksheet_picture");
    }

    # verify the required parameter 'picture_index' is set
    unless (exists $args{'picture_index'}) {
      croak("Missing the required parameter 'picture_index' when calling cells_pictures_delete_worksheet_picture");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pictures/{pictureIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'picture_index'}) {
        my $_base_variable = "{" . "pictureIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'picture_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_pictures_delete_worksheet_pictures
#
# Delete all pictures in worksheet.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pictures_delete_worksheet_pictures' } = { 
    	summary => 'Delete all pictures in worksheet.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_pictures_delete_worksheet_pictures {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pictures_delete_worksheet_pictures");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pictures_delete_worksheet_pictures");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pictures';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_pictures_get_worksheet_picture
#
# GRead worksheet picture by number.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $picture_index The picture index. (required)
# @param string $format The exported object format. (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'picture_index' => {
        data_type => 'int',
        description => 'The picture index.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'The exported object format.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pictures_get_worksheet_picture' } = { 
    	summary => 'GRead worksheet picture by number.',
        params => $params,
        returns => 'string',
        };
}
# @return string
#
sub cells_pictures_get_worksheet_picture {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pictures_get_worksheet_picture");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pictures_get_worksheet_picture");
    }

    # verify the required parameter 'picture_index' is set
    unless (exists $args{'picture_index'}) {
      croak("Missing the required parameter 'picture_index' when calling cells_pictures_get_worksheet_picture");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pictures/{pictureIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'format'}) {
        $query_params->{'format'} = $self->{api_client}->to_query_value($args{'format'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'picture_index'}) {
        my $_base_variable = "{" . "pictureIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'picture_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('string', $response);
    return $_response_object;
}

#
# cells_pictures_get_worksheet_pictures
#
# Read worksheet pictures.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pictures_get_worksheet_pictures' } = { 
    	summary => 'Read worksheet pictures.',
        params => $params,
        returns => 'PicturesResponse',
        };
}
# @return PicturesResponse
#
sub cells_pictures_get_worksheet_pictures {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pictures_get_worksheet_pictures");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pictures_get_worksheet_pictures");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pictures';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('PicturesResponse', $response);
    return $_response_object;
}

#
# cells_pictures_post_worksheet_picture
#
# Update worksheet picture by index.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $picture_index The picture&#39;s index. (required)
# @param Picture $picture Picture object (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'picture_index' => {
        data_type => 'int',
        description => 'The picture&#39;s index.',
        required => '1',
    },
    'picture' => {
        data_type => 'Picture',
        description => 'Picture object',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pictures_post_worksheet_picture' } = { 
    	summary => 'Update worksheet picture by index.',
        params => $params,
        returns => 'PictureResponse',
        };
}
# @return PictureResponse
#
sub cells_pictures_post_worksheet_picture {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pictures_post_worksheet_picture");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pictures_post_worksheet_picture");
    }

    # verify the required parameter 'picture_index' is set
    unless (exists $args{'picture_index'}) {
      croak("Missing the required parameter 'picture_index' when calling cells_pictures_post_worksheet_picture");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pictures/{pictureIndex}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'picture_index'}) {
        my $_base_variable = "{" . "pictureIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'picture_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'picture'}) {
        $_body_data = $args{'picture'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('PictureResponse', $response);
    return $_response_object;
}

#
# cells_pictures_put_worksheet_add_picture
#
# Add a new worksheet picture.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worsheet name. (required)
# @param Picture $picture Pictute object (optional)
# @param int $upper_left_row The image upper left row. (optional, default to 0)
# @param int $upper_left_column The image upper left column. (optional, default to 0)
# @param int $lower_right_row The image low right row. (optional, default to 0)
# @param int $lower_right_column The image low right column. (optional, default to 0)
# @param string $picture_path The picture path, if not provided the picture data is inspected in the request body. (optional)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worsheet name.',
        required => '1',
    },
    'picture' => {
        data_type => 'Picture',
        description => 'Pictute object',
        required => '0',
    },
    'upper_left_row' => {
        data_type => 'int',
        description => 'The image upper left row.',
        required => '0',
    },
    'upper_left_column' => {
        data_type => 'int',
        description => 'The image upper left column.',
        required => '0',
    },
    'lower_right_row' => {
        data_type => 'int',
        description => 'The image low right row.',
        required => '0',
    },
    'lower_right_column' => {
        data_type => 'int',
        description => 'The image low right column.',
        required => '0',
    },
    'picture_path' => {
        data_type => 'string',
        description => 'The picture path, if not provided the picture data is inspected in the request body.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pictures_put_worksheet_add_picture' } = { 
    	summary => 'Add a new worksheet picture.',
        params => $params,
        returns => 'PicturesResponse',
        };
}
# @return PicturesResponse
#
sub cells_pictures_put_worksheet_add_picture {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pictures_put_worksheet_add_picture");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pictures_put_worksheet_add_picture");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pictures';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'upper_left_row'}) {
        $query_params->{'upperLeftRow'} = $self->{api_client}->to_query_value($args{'upper_left_row'});
    }

    # query params
    if ( exists $args{'upper_left_column'}) {
        $query_params->{'upperLeftColumn'} = $self->{api_client}->to_query_value($args{'upper_left_column'});
    }

    # query params
    if ( exists $args{'lower_right_row'}) {
        $query_params->{'lowerRightRow'} = $self->{api_client}->to_query_value($args{'lower_right_row'});
    }

    # query params
    if ( exists $args{'lower_right_column'}) {
        $query_params->{'lowerRightColumn'} = $self->{api_client}->to_query_value($args{'lower_right_column'});
    }

    # query params
    if ( exists $args{'picture_path'}) {
        $query_params->{'picturePath'} = $self->{api_client}->to_query_value($args{'picture_path'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'picture'}) {
        $_body_data = $args{'picture'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('PicturesResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_delete_pivot_table_field
#
# Delete pivot field into into pivot table
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $pivot_table_index Pivot table index (required)
# @param string $pivot_field_type The fields area type. (required)
# @param PivotTableFieldRequest $request Dto that conrains field indexes (optional)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'pivot_table_index' => {
        data_type => 'int',
        description => 'Pivot table index',
        required => '1',
    },
    'pivot_field_type' => {
        data_type => 'string',
        description => 'The fields area type.',
        required => '1',
    },
    'request' => {
        data_type => 'PivotTableFieldRequest',
        description => 'Dto that conrains field indexes',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_delete_pivot_table_field' } = { 
    	summary => 'Delete pivot field into into pivot table',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_pivot_tables_delete_pivot_table_field {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_delete_pivot_table_field");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_delete_pivot_table_field");
    }

    # verify the required parameter 'pivot_table_index' is set
    unless (exists $args{'pivot_table_index'}) {
      croak("Missing the required parameter 'pivot_table_index' when calling cells_pivot_tables_delete_pivot_table_field");
    }

    # verify the required parameter 'pivot_field_type' is set
    unless (exists $args{'pivot_field_type'}) {
      croak("Missing the required parameter 'pivot_field_type' when calling cells_pivot_tables_delete_pivot_table_field");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotField';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'pivot_field_type'}) {
        $query_params->{'pivotFieldType'} = $self->{api_client}->to_query_value($args{'pivot_field_type'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivot_table_index'}) {
        my $_base_variable = "{" . "pivotTableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivot_table_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'request'}) {
        $_body_data = $args{'request'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_delete_worksheet_pivot_table
#
# Delete worksheet pivot table by index
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $pivot_table_index Pivot table index (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'pivot_table_index' => {
        data_type => 'int',
        description => 'Pivot table index',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_delete_worksheet_pivot_table' } = { 
    	summary => 'Delete worksheet pivot table by index',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_pivot_tables_delete_worksheet_pivot_table {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_delete_worksheet_pivot_table");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_delete_worksheet_pivot_table");
    }

    # verify the required parameter 'pivot_table_index' is set
    unless (exists $args{'pivot_table_index'}) {
      croak("Missing the required parameter 'pivot_table_index' when calling cells_pivot_tables_delete_worksheet_pivot_table");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivot_table_index'}) {
        my $_base_variable = "{" . "pivotTableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivot_table_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_delete_worksheet_pivot_table_filter
#
# delete  pivot filter for piovt table             
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $pivot_table_index  (required)
# @param int $field_index  (required)
# @param boolean $need_re_calculate  (optional, default to false)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'pivot_table_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'field_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'need_re_calculate' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_delete_worksheet_pivot_table_filter' } = { 
    	summary => 'delete  pivot filter for piovt table             ',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_pivot_tables_delete_worksheet_pivot_table_filter {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_delete_worksheet_pivot_table_filter");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_delete_worksheet_pivot_table_filter");
    }

    # verify the required parameter 'pivot_table_index' is set
    unless (exists $args{'pivot_table_index'}) {
      croak("Missing the required parameter 'pivot_table_index' when calling cells_pivot_tables_delete_worksheet_pivot_table_filter");
    }

    # verify the required parameter 'field_index' is set
    unless (exists $args{'field_index'}) {
      croak("Missing the required parameter 'field_index' when calling cells_pivot_tables_delete_worksheet_pivot_table_filter");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotFilters/{fieldIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'need_re_calculate'}) {
        $query_params->{'needReCalculate'} = $self->{api_client}->to_query_value($args{'need_re_calculate'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivot_table_index'}) {
        my $_base_variable = "{" . "pivotTableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivot_table_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'field_index'}) {
        my $_base_variable = "{" . "fieldIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'field_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_delete_worksheet_pivot_table_filters
#
# delete all pivot filters for piovt table
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $pivot_table_index  (required)
# @param boolean $need_re_calculate  (optional, default to false)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'pivot_table_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'need_re_calculate' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_delete_worksheet_pivot_table_filters' } = { 
    	summary => 'delete all pivot filters for piovt table',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_pivot_tables_delete_worksheet_pivot_table_filters {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_delete_worksheet_pivot_table_filters");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_delete_worksheet_pivot_table_filters");
    }

    # verify the required parameter 'pivot_table_index' is set
    unless (exists $args{'pivot_table_index'}) {
      croak("Missing the required parameter 'pivot_table_index' when calling cells_pivot_tables_delete_worksheet_pivot_table_filters");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotFilters';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'need_re_calculate'}) {
        $query_params->{'needReCalculate'} = $self->{api_client}->to_query_value($args{'need_re_calculate'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivot_table_index'}) {
        my $_base_variable = "{" . "pivotTableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivot_table_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_delete_worksheet_pivot_tables
#
# Delete worksheet pivot tables
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_delete_worksheet_pivot_tables' } = { 
    	summary => 'Delete worksheet pivot tables',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_pivot_tables_delete_worksheet_pivot_tables {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_delete_worksheet_pivot_tables");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_delete_worksheet_pivot_tables");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_get_pivot_table_field
#
# Get pivot field into into pivot table
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $pivot_table_index Pivot table index (required)
# @param int $pivot_field_index The field index in the base fields. (required)
# @param string $pivot_field_type The fields area type. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'pivot_table_index' => {
        data_type => 'int',
        description => 'Pivot table index',
        required => '1',
    },
    'pivot_field_index' => {
        data_type => 'int',
        description => 'The field index in the base fields.',
        required => '1',
    },
    'pivot_field_type' => {
        data_type => 'string',
        description => 'The fields area type.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_get_pivot_table_field' } = { 
    	summary => 'Get pivot field into into pivot table',
        params => $params,
        returns => 'PivotFieldResponse',
        };
}
# @return PivotFieldResponse
#
sub cells_pivot_tables_get_pivot_table_field {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_get_pivot_table_field");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_get_pivot_table_field");
    }

    # verify the required parameter 'pivot_table_index' is set
    unless (exists $args{'pivot_table_index'}) {
      croak("Missing the required parameter 'pivot_table_index' when calling cells_pivot_tables_get_pivot_table_field");
    }

    # verify the required parameter 'pivot_field_index' is set
    unless (exists $args{'pivot_field_index'}) {
      croak("Missing the required parameter 'pivot_field_index' when calling cells_pivot_tables_get_pivot_table_field");
    }

    # verify the required parameter 'pivot_field_type' is set
    unless (exists $args{'pivot_field_type'}) {
      croak("Missing the required parameter 'pivot_field_type' when calling cells_pivot_tables_get_pivot_table_field");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotField';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'pivot_field_index'}) {
        $query_params->{'pivotFieldIndex'} = $self->{api_client}->to_query_value($args{'pivot_field_index'});
    }

    # query params
    if ( exists $args{'pivot_field_type'}) {
        $query_params->{'pivotFieldType'} = $self->{api_client}->to_query_value($args{'pivot_field_type'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivot_table_index'}) {
        my $_base_variable = "{" . "pivotTableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivot_table_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('PivotFieldResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_get_worksheet_pivot_table
#
# Get worksheet pivottable info by index.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $pivottable_index  (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'pivottable_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_get_worksheet_pivot_table' } = { 
    	summary => 'Get worksheet pivottable info by index.',
        params => $params,
        returns => 'PivotTableResponse',
        };
}
# @return PivotTableResponse
#
sub cells_pivot_tables_get_worksheet_pivot_table {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_get_worksheet_pivot_table");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_get_worksheet_pivot_table");
    }

    # verify the required parameter 'pivottable_index' is set
    unless (exists $args{'pivottable_index'}) {
      croak("Missing the required parameter 'pivottable_index' when calling cells_pivot_tables_get_worksheet_pivot_table");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivottableIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivottable_index'}) {
        my $_base_variable = "{" . "pivottableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivottable_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('PivotTableResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_get_worksheet_pivot_table_filter
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $pivot_table_index  (required)
# @param int $filter_index  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'pivot_table_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'filter_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_get_worksheet_pivot_table_filter' } = { 
    	summary => '',
        params => $params,
        returns => 'PivotFilterResponse',
        };
}
# @return PivotFilterResponse
#
sub cells_pivot_tables_get_worksheet_pivot_table_filter {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_get_worksheet_pivot_table_filter");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_get_worksheet_pivot_table_filter");
    }

    # verify the required parameter 'pivot_table_index' is set
    unless (exists $args{'pivot_table_index'}) {
      croak("Missing the required parameter 'pivot_table_index' when calling cells_pivot_tables_get_worksheet_pivot_table_filter");
    }

    # verify the required parameter 'filter_index' is set
    unless (exists $args{'filter_index'}) {
      croak("Missing the required parameter 'filter_index' when calling cells_pivot_tables_get_worksheet_pivot_table_filter");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotFilters/{filterIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivot_table_index'}) {
        my $_base_variable = "{" . "pivotTableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivot_table_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'filter_index'}) {
        my $_base_variable = "{" . "filterIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'filter_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('PivotFilterResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_get_worksheet_pivot_table_filters
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $pivot_table_index  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'pivot_table_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_get_worksheet_pivot_table_filters' } = { 
    	summary => '',
        params => $params,
        returns => 'PivotFiltersResponse',
        };
}
# @return PivotFiltersResponse
#
sub cells_pivot_tables_get_worksheet_pivot_table_filters {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_get_worksheet_pivot_table_filters");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_get_worksheet_pivot_table_filters");
    }

    # verify the required parameter 'pivot_table_index' is set
    unless (exists $args{'pivot_table_index'}) {
      croak("Missing the required parameter 'pivot_table_index' when calling cells_pivot_tables_get_worksheet_pivot_table_filters");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotFilters';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivot_table_index'}) {
        my $_base_variable = "{" . "pivotTableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivot_table_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('PivotFiltersResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_get_worksheet_pivot_tables
#
# Get worksheet pivottables info.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_get_worksheet_pivot_tables' } = { 
    	summary => 'Get worksheet pivottables info.',
        params => $params,
        returns => 'PivotTablesResponse',
        };
}
# @return PivotTablesResponse
#
sub cells_pivot_tables_get_worksheet_pivot_tables {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_get_worksheet_pivot_tables");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_get_worksheet_pivot_tables");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('PivotTablesResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_post_pivot_table_cell_style
#
# Update cell style for pivot table
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $pivot_table_index Pivot table index (required)
# @param int $column  (required)
# @param int $row  (required)
# @param Style $style Style dto in request body. (optional)
# @param boolean $need_re_calculate  (optional, default to false)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'pivot_table_index' => {
        data_type => 'int',
        description => 'Pivot table index',
        required => '1',
    },
    'column' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'row' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'style' => {
        data_type => 'Style',
        description => 'Style dto in request body.',
        required => '0',
    },
    'need_re_calculate' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_post_pivot_table_cell_style' } = { 
    	summary => 'Update cell style for pivot table',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_pivot_tables_post_pivot_table_cell_style {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_post_pivot_table_cell_style");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_post_pivot_table_cell_style");
    }

    # verify the required parameter 'pivot_table_index' is set
    unless (exists $args{'pivot_table_index'}) {
      croak("Missing the required parameter 'pivot_table_index' when calling cells_pivot_tables_post_pivot_table_cell_style");
    }

    # verify the required parameter 'column' is set
    unless (exists $args{'column'}) {
      croak("Missing the required parameter 'column' when calling cells_pivot_tables_post_pivot_table_cell_style");
    }

    # verify the required parameter 'row' is set
    unless (exists $args{'row'}) {
      croak("Missing the required parameter 'row' when calling cells_pivot_tables_post_pivot_table_cell_style");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/Format';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'column'}) {
        $query_params->{'column'} = $self->{api_client}->to_query_value($args{'column'});
    }

    # query params
    if ( exists $args{'row'}) {
        $query_params->{'row'} = $self->{api_client}->to_query_value($args{'row'});
    }

    # query params
    if ( exists $args{'need_re_calculate'}) {
        $query_params->{'needReCalculate'} = $self->{api_client}->to_query_value($args{'need_re_calculate'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivot_table_index'}) {
        my $_base_variable = "{" . "pivotTableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivot_table_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'style'}) {
        $_body_data = $args{'style'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_post_pivot_table_field_hide_item
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $pivot_table_index  (required)
# @param string $pivot_field_type  (required)
# @param int $field_index  (required)
# @param int $item_index  (required)
# @param boolean $is_hide  (required)
# @param boolean $need_re_calculate  (optional, default to false)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'pivot_table_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'pivot_field_type' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'field_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'item_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'is_hide' => {
        data_type => 'boolean',
        description => '',
        required => '1',
    },
    'need_re_calculate' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_post_pivot_table_field_hide_item' } = { 
    	summary => '',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_pivot_tables_post_pivot_table_field_hide_item {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_post_pivot_table_field_hide_item");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_post_pivot_table_field_hide_item");
    }

    # verify the required parameter 'pivot_table_index' is set
    unless (exists $args{'pivot_table_index'}) {
      croak("Missing the required parameter 'pivot_table_index' when calling cells_pivot_tables_post_pivot_table_field_hide_item");
    }

    # verify the required parameter 'pivot_field_type' is set
    unless (exists $args{'pivot_field_type'}) {
      croak("Missing the required parameter 'pivot_field_type' when calling cells_pivot_tables_post_pivot_table_field_hide_item");
    }

    # verify the required parameter 'field_index' is set
    unless (exists $args{'field_index'}) {
      croak("Missing the required parameter 'field_index' when calling cells_pivot_tables_post_pivot_table_field_hide_item");
    }

    # verify the required parameter 'item_index' is set
    unless (exists $args{'item_index'}) {
      croak("Missing the required parameter 'item_index' when calling cells_pivot_tables_post_pivot_table_field_hide_item");
    }

    # verify the required parameter 'is_hide' is set
    unless (exists $args{'is_hide'}) {
      croak("Missing the required parameter 'is_hide' when calling cells_pivot_tables_post_pivot_table_field_hide_item");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotField/Hide';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'pivot_field_type'}) {
        $query_params->{'pivotFieldType'} = $self->{api_client}->to_query_value($args{'pivot_field_type'});
    }

    # query params
    if ( exists $args{'field_index'}) {
        $query_params->{'fieldIndex'} = $self->{api_client}->to_query_value($args{'field_index'});
    }

    # query params
    if ( exists $args{'item_index'}) {
        $query_params->{'itemIndex'} = $self->{api_client}->to_query_value($args{'item_index'});
    }

    # query params
    if ( exists $args{'is_hide'}) {
        $query_params->{'isHide'} = $self->{api_client}->to_query_value($args{'is_hide'});
    }

    # query params
    if ( exists $args{'need_re_calculate'}) {
        $query_params->{'needReCalculate'} = $self->{api_client}->to_query_value($args{'need_re_calculate'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivot_table_index'}) {
        my $_base_variable = "{" . "pivotTableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivot_table_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_post_pivot_table_field_move_to
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $pivot_table_index  (required)
# @param int $field_index  (required)
# @param string $from  (required)
# @param string $to  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'pivot_table_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'field_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'from' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'to' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_post_pivot_table_field_move_to' } = { 
    	summary => '',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_pivot_tables_post_pivot_table_field_move_to {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_post_pivot_table_field_move_to");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_post_pivot_table_field_move_to");
    }

    # verify the required parameter 'pivot_table_index' is set
    unless (exists $args{'pivot_table_index'}) {
      croak("Missing the required parameter 'pivot_table_index' when calling cells_pivot_tables_post_pivot_table_field_move_to");
    }

    # verify the required parameter 'field_index' is set
    unless (exists $args{'field_index'}) {
      croak("Missing the required parameter 'field_index' when calling cells_pivot_tables_post_pivot_table_field_move_to");
    }

    # verify the required parameter 'from' is set
    unless (exists $args{'from'}) {
      croak("Missing the required parameter 'from' when calling cells_pivot_tables_post_pivot_table_field_move_to");
    }

    # verify the required parameter 'to' is set
    unless (exists $args{'to'}) {
      croak("Missing the required parameter 'to' when calling cells_pivot_tables_post_pivot_table_field_move_to");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotField/Move';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'field_index'}) {
        $query_params->{'fieldIndex'} = $self->{api_client}->to_query_value($args{'field_index'});
    }

    # query params
    if ( exists $args{'from'}) {
        $query_params->{'from'} = $self->{api_client}->to_query_value($args{'from'});
    }

    # query params
    if ( exists $args{'to'}) {
        $query_params->{'to'} = $self->{api_client}->to_query_value($args{'to'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivot_table_index'}) {
        my $_base_variable = "{" . "pivotTableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivot_table_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_post_pivot_table_style
#
# Update style for pivot table
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $pivot_table_index Pivot table index (required)
# @param Style $style Style dto in request body. (optional)
# @param boolean $need_re_calculate  (optional, default to false)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'pivot_table_index' => {
        data_type => 'int',
        description => 'Pivot table index',
        required => '1',
    },
    'style' => {
        data_type => 'Style',
        description => 'Style dto in request body.',
        required => '0',
    },
    'need_re_calculate' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_post_pivot_table_style' } = { 
    	summary => 'Update style for pivot table',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_pivot_tables_post_pivot_table_style {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_post_pivot_table_style");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_post_pivot_table_style");
    }

    # verify the required parameter 'pivot_table_index' is set
    unless (exists $args{'pivot_table_index'}) {
      croak("Missing the required parameter 'pivot_table_index' when calling cells_pivot_tables_post_pivot_table_style");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/FormatAll';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'need_re_calculate'}) {
        $query_params->{'needReCalculate'} = $self->{api_client}->to_query_value($args{'need_re_calculate'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivot_table_index'}) {
        my $_base_variable = "{" . "pivotTableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivot_table_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'style'}) {
        $_body_data = $args{'style'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_post_worksheet_pivot_table_calculate
#
# Calculates pivottable's data to cells.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $pivot_table_index Pivot table index (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'pivot_table_index' => {
        data_type => 'int',
        description => 'Pivot table index',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_post_worksheet_pivot_table_calculate' } = { 
    	summary => 'Calculates pivottable&#39;s data to cells.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_pivot_tables_post_worksheet_pivot_table_calculate {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_post_worksheet_pivot_table_calculate");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_post_worksheet_pivot_table_calculate");
    }

    # verify the required parameter 'pivot_table_index' is set
    unless (exists $args{'pivot_table_index'}) {
      croak("Missing the required parameter 'pivot_table_index' when calling cells_pivot_tables_post_worksheet_pivot_table_calculate");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/Calculate';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivot_table_index'}) {
        my $_base_variable = "{" . "pivotTableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivot_table_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_post_worksheet_pivot_table_move
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $pivot_table_index  (required)
# @param int $row  (optional)
# @param int $column  (optional)
# @param string $dest_cell_name  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'pivot_table_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'row' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'column' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'dest_cell_name' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_post_worksheet_pivot_table_move' } = { 
    	summary => '',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_pivot_tables_post_worksheet_pivot_table_move {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_post_worksheet_pivot_table_move");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_post_worksheet_pivot_table_move");
    }

    # verify the required parameter 'pivot_table_index' is set
    unless (exists $args{'pivot_table_index'}) {
      croak("Missing the required parameter 'pivot_table_index' when calling cells_pivot_tables_post_worksheet_pivot_table_move");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/Move';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'row'}) {
        $query_params->{'row'} = $self->{api_client}->to_query_value($args{'row'});
    }

    # query params
    if ( exists $args{'column'}) {
        $query_params->{'column'} = $self->{api_client}->to_query_value($args{'column'});
    }

    # query params
    if ( exists $args{'dest_cell_name'}) {
        $query_params->{'destCellName'} = $self->{api_client}->to_query_value($args{'dest_cell_name'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivot_table_index'}) {
        my $_base_variable = "{" . "pivotTableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivot_table_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_put_pivot_table_field
#
# Add pivot field into into pivot table
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $pivot_table_index Pivot table index (required)
# @param string $pivot_field_type The fields area type. (required)
# @param PivotTableFieldRequest $request Dto that conrains field indexes (optional)
# @param boolean $need_re_calculate  (optional, default to false)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'pivot_table_index' => {
        data_type => 'int',
        description => 'Pivot table index',
        required => '1',
    },
    'pivot_field_type' => {
        data_type => 'string',
        description => 'The fields area type.',
        required => '1',
    },
    'request' => {
        data_type => 'PivotTableFieldRequest',
        description => 'Dto that conrains field indexes',
        required => '0',
    },
    'need_re_calculate' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_put_pivot_table_field' } = { 
    	summary => 'Add pivot field into into pivot table',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_pivot_tables_put_pivot_table_field {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_put_pivot_table_field");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_put_pivot_table_field");
    }

    # verify the required parameter 'pivot_table_index' is set
    unless (exists $args{'pivot_table_index'}) {
      croak("Missing the required parameter 'pivot_table_index' when calling cells_pivot_tables_put_pivot_table_field");
    }

    # verify the required parameter 'pivot_field_type' is set
    unless (exists $args{'pivot_field_type'}) {
      croak("Missing the required parameter 'pivot_field_type' when calling cells_pivot_tables_put_pivot_table_field");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotField';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'pivot_field_type'}) {
        $query_params->{'pivotFieldType'} = $self->{api_client}->to_query_value($args{'pivot_field_type'});
    }

    # query params
    if ( exists $args{'need_re_calculate'}) {
        $query_params->{'needReCalculate'} = $self->{api_client}->to_query_value($args{'need_re_calculate'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivot_table_index'}) {
        my $_base_variable = "{" . "pivotTableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivot_table_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'request'}) {
        $_body_data = $args{'request'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_put_worksheet_pivot_table
#
# Add a pivot table into worksheet.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param CreatePivotTableRequest $request CreatePivotTableRequest dto in request body. (optional)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
# @param string $source_data The data for the new PivotTable cache. (optional)
# @param string $dest_cell_name The cell in the upper-left corner of the PivotTable report&#39;s destination range. (optional)
# @param string $table_name The name of the new PivotTable report. (optional)
# @param boolean $use_same_source Indicates whether using same data source when another existing pivot table has used this data source. If the property is true, it will save memory. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'request' => {
        data_type => 'CreatePivotTableRequest',
        description => 'CreatePivotTableRequest dto in request body.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    'source_data' => {
        data_type => 'string',
        description => 'The data for the new PivotTable cache.',
        required => '0',
    },
    'dest_cell_name' => {
        data_type => 'string',
        description => 'The cell in the upper-left corner of the PivotTable report&#39;s destination range.',
        required => '0',
    },
    'table_name' => {
        data_type => 'string',
        description => 'The name of the new PivotTable report.',
        required => '0',
    },
    'use_same_source' => {
        data_type => 'boolean',
        description => 'Indicates whether using same data source when another existing pivot table has used this data source. If the property is true, it will save memory.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_put_worksheet_pivot_table' } = { 
    	summary => 'Add a pivot table into worksheet.',
        params => $params,
        returns => 'PivotTableResponse',
        };
}
# @return PivotTableResponse
#
sub cells_pivot_tables_put_worksheet_pivot_table {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_put_worksheet_pivot_table");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_put_worksheet_pivot_table");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if ( exists $args{'source_data'}) {
        $query_params->{'sourceData'} = $self->{api_client}->to_query_value($args{'source_data'});
    }

    # query params
    if ( exists $args{'dest_cell_name'}) {
        $query_params->{'destCellName'} = $self->{api_client}->to_query_value($args{'dest_cell_name'});
    }

    # query params
    if ( exists $args{'table_name'}) {
        $query_params->{'tableName'} = $self->{api_client}->to_query_value($args{'table_name'});
    }

    # query params
    if ( exists $args{'use_same_source'}) {
        $query_params->{'useSameSource'} = $self->{api_client}->to_query_value($args{'use_same_source'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'request'}) {
        $_body_data = $args{'request'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('PivotTableResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_put_worksheet_pivot_table_filter
#
# Add pivot filter for piovt table index
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $pivot_table_index  (required)
# @param PivotFilter $filter  (optional)
# @param boolean $need_re_calculate  (optional, default to false)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'pivot_table_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'filter' => {
        data_type => 'PivotFilter',
        description => '',
        required => '0',
    },
    'need_re_calculate' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_put_worksheet_pivot_table_filter' } = { 
    	summary => 'Add pivot filter for piovt table index',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_pivot_tables_put_worksheet_pivot_table_filter {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_put_worksheet_pivot_table_filter");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_put_worksheet_pivot_table_filter");
    }

    # verify the required parameter 'pivot_table_index' is set
    unless (exists $args{'pivot_table_index'}) {
      croak("Missing the required parameter 'pivot_table_index' when calling cells_pivot_tables_put_worksheet_pivot_table_filter");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotFilters';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'need_re_calculate'}) {
        $query_params->{'needReCalculate'} = $self->{api_client}->to_query_value($args{'need_re_calculate'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivot_table_index'}) {
        my $_base_variable = "{" . "pivotTableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivot_table_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'filter'}) {
        $_body_data = $args{'filter'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_post_cell_calculate
#
# Cell calculate formula
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $cell_name  (required)
# @param CalculationOptions $options  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'cell_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'options' => {
        data_type => 'CalculationOptions',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_cell_calculate' } = { 
    	summary => 'Cell calculate formula',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_post_cell_calculate {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_cell_calculate");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_cell_calculate");
    }

    # verify the required parameter 'cell_name' is set
    unless (exists $args{'cell_name'}) {
      croak("Missing the required parameter 'cell_name' when calling cells_post_cell_calculate");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/{cellName}/calculate';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_name'}) {
        my $_base_variable = "{" . "cellName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'options'}) {
        $_body_data = $args{'options'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_post_cell_characters
#
# Set cell characters 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $cell_name  (required)
# @param ARRAY[FontSetting] $options  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'cell_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'options' => {
        data_type => 'ARRAY[FontSetting]',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_cell_characters' } = { 
    	summary => 'Set cell characters ',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_post_cell_characters {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_cell_characters");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_cell_characters");
    }

    # verify the required parameter 'cell_name' is set
    unless (exists $args{'cell_name'}) {
      croak("Missing the required parameter 'cell_name' when calling cells_post_cell_characters");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/{cellName}/characters';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_name'}) {
        my $_base_variable = "{" . "cellName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'options'}) {
        $_body_data = $args{'options'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_post_clear_contents
#
# Clear cells contents.
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param string $range The range. (optional)
# @param int $start_row The start row. (optional)
# @param int $start_column The start column. (optional)
# @param int $end_row The end row. (optional)
# @param int $end_column The end column. (optional)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'range' => {
        data_type => 'string',
        description => 'The range.',
        required => '0',
    },
    'start_row' => {
        data_type => 'int',
        description => 'The start row.',
        required => '0',
    },
    'start_column' => {
        data_type => 'int',
        description => 'The start column.',
        required => '0',
    },
    'end_row' => {
        data_type => 'int',
        description => 'The end row.',
        required => '0',
    },
    'end_column' => {
        data_type => 'int',
        description => 'The end column.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_clear_contents' } = { 
    	summary => 'Clear cells contents.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_post_clear_contents {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_clear_contents");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_clear_contents");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/clearcontents';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'range'}) {
        $query_params->{'range'} = $self->{api_client}->to_query_value($args{'range'});
    }

    # query params
    if ( exists $args{'start_row'}) {
        $query_params->{'startRow'} = $self->{api_client}->to_query_value($args{'start_row'});
    }

    # query params
    if ( exists $args{'start_column'}) {
        $query_params->{'startColumn'} = $self->{api_client}->to_query_value($args{'start_column'});
    }

    # query params
    if ( exists $args{'end_row'}) {
        $query_params->{'endRow'} = $self->{api_client}->to_query_value($args{'end_row'});
    }

    # query params
    if ( exists $args{'end_column'}) {
        $query_params->{'endColumn'} = $self->{api_client}->to_query_value($args{'end_column'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_post_clear_formats
#
# Clear cells contents.
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param string $range The range. (optional)
# @param int $start_row The start row. (optional)
# @param int $start_column The start column. (optional)
# @param int $end_row The end row. (optional)
# @param int $end_column The end column. (optional)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'range' => {
        data_type => 'string',
        description => 'The range.',
        required => '0',
    },
    'start_row' => {
        data_type => 'int',
        description => 'The start row.',
        required => '0',
    },
    'start_column' => {
        data_type => 'int',
        description => 'The start column.',
        required => '0',
    },
    'end_row' => {
        data_type => 'int',
        description => 'The end row.',
        required => '0',
    },
    'end_column' => {
        data_type => 'int',
        description => 'The end column.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_clear_formats' } = { 
    	summary => 'Clear cells contents.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_post_clear_formats {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_clear_formats");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_clear_formats");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/clearformats';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'range'}) {
        $query_params->{'range'} = $self->{api_client}->to_query_value($args{'range'});
    }

    # query params
    if ( exists $args{'start_row'}) {
        $query_params->{'startRow'} = $self->{api_client}->to_query_value($args{'start_row'});
    }

    # query params
    if ( exists $args{'start_column'}) {
        $query_params->{'startColumn'} = $self->{api_client}->to_query_value($args{'start_column'});
    }

    # query params
    if ( exists $args{'end_row'}) {
        $query_params->{'endRow'} = $self->{api_client}->to_query_value($args{'end_row'});
    }

    # query params
    if ( exists $args{'end_column'}) {
        $query_params->{'endColumn'} = $self->{api_client}->to_query_value($args{'end_column'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_post_column_style
#
# Set column style
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $column_index The column index. (required)
# @param Style $style Style dto (optional)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'column_index' => {
        data_type => 'int',
        description => 'The column index.',
        required => '1',
    },
    'style' => {
        data_type => 'Style',
        description => 'Style dto',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_column_style' } = { 
    	summary => 'Set column style',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_post_column_style {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_column_style");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_column_style");
    }

    # verify the required parameter 'column_index' is set
    unless (exists $args{'column_index'}) {
      croak("Missing the required parameter 'column_index' when calling cells_post_column_style");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/columns/{columnIndex}/style';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'column_index'}) {
        my $_base_variable = "{" . "columnIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'column_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'style'}) {
        $_body_data = $args{'style'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_post_copy_cell_into_cell
#
# Copy cell into cell
# 
# @param string $name Workbook name. (required)
# @param string $dest_cell_name Destination cell name (required)
# @param string $sheet_name Destination worksheet name. (required)
# @param string $worksheet Source worksheet name. (required)
# @param string $cellname Source cell name (optional)
# @param int $row Source row (optional)
# @param int $column Source column (optional)
# @param string $folder Folder name (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'dest_cell_name' => {
        data_type => 'string',
        description => 'Destination cell name',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Destination worksheet name.',
        required => '1',
    },
    'worksheet' => {
        data_type => 'string',
        description => 'Source worksheet name.',
        required => '1',
    },
    'cellname' => {
        data_type => 'string',
        description => 'Source cell name',
        required => '0',
    },
    'row' => {
        data_type => 'int',
        description => 'Source row',
        required => '0',
    },
    'column' => {
        data_type => 'int',
        description => 'Source column',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Folder name',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_copy_cell_into_cell' } = { 
    	summary => 'Copy cell into cell',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_post_copy_cell_into_cell {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_copy_cell_into_cell");
    }

    # verify the required parameter 'dest_cell_name' is set
    unless (exists $args{'dest_cell_name'}) {
      croak("Missing the required parameter 'dest_cell_name' when calling cells_post_copy_cell_into_cell");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_copy_cell_into_cell");
    }

    # verify the required parameter 'worksheet' is set
    unless (exists $args{'worksheet'}) {
      croak("Missing the required parameter 'worksheet' when calling cells_post_copy_cell_into_cell");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/{destCellName}/copy';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'worksheet'}) {
        $query_params->{'worksheet'} = $self->{api_client}->to_query_value($args{'worksheet'});
    }

    # query params
    if ( exists $args{'cellname'}) {
        $query_params->{'cellname'} = $self->{api_client}->to_query_value($args{'cellname'});
    }

    # query params
    if ( exists $args{'row'}) {
        $query_params->{'row'} = $self->{api_client}->to_query_value($args{'row'});
    }

    # query params
    if ( exists $args{'column'}) {
        $query_params->{'column'} = $self->{api_client}->to_query_value($args{'column'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'dest_cell_name'}) {
        my $_base_variable = "{" . "destCellName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'dest_cell_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_post_copy_worksheet_columns
#
# Copy worksheet columns.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $source_column_index Source column index (required)
# @param int $destination_column_index Destination column index (required)
# @param int $column_number The copied column number (required)
# @param string $worksheet The Worksheet (optional, default to )
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'source_column_index' => {
        data_type => 'int',
        description => 'Source column index',
        required => '1',
    },
    'destination_column_index' => {
        data_type => 'int',
        description => 'Destination column index',
        required => '1',
    },
    'column_number' => {
        data_type => 'int',
        description => 'The copied column number',
        required => '1',
    },
    'worksheet' => {
        data_type => 'string',
        description => 'The Worksheet',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_copy_worksheet_columns' } = { 
    	summary => 'Copy worksheet columns.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_post_copy_worksheet_columns {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_copy_worksheet_columns");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_copy_worksheet_columns");
    }

    # verify the required parameter 'source_column_index' is set
    unless (exists $args{'source_column_index'}) {
      croak("Missing the required parameter 'source_column_index' when calling cells_post_copy_worksheet_columns");
    }

    # verify the required parameter 'destination_column_index' is set
    unless (exists $args{'destination_column_index'}) {
      croak("Missing the required parameter 'destination_column_index' when calling cells_post_copy_worksheet_columns");
    }

    # verify the required parameter 'column_number' is set
    unless (exists $args{'column_number'}) {
      croak("Missing the required parameter 'column_number' when calling cells_post_copy_worksheet_columns");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/columns/copy';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'source_column_index'}) {
        $query_params->{'sourceColumnIndex'} = $self->{api_client}->to_query_value($args{'source_column_index'});
    }

    # query params
    if ( exists $args{'destination_column_index'}) {
        $query_params->{'destinationColumnIndex'} = $self->{api_client}->to_query_value($args{'destination_column_index'});
    }

    # query params
    if ( exists $args{'column_number'}) {
        $query_params->{'columnNumber'} = $self->{api_client}->to_query_value($args{'column_number'});
    }

    # query params
    if ( exists $args{'worksheet'}) {
        $query_params->{'worksheet'} = $self->{api_client}->to_query_value($args{'worksheet'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_post_copy_worksheet_rows
#
# Copy worksheet rows.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $source_row_index Source row index (required)
# @param int $destination_row_index Destination row index (required)
# @param int $row_number The copied row number (required)
# @param string $worksheet worksheet (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'source_row_index' => {
        data_type => 'int',
        description => 'Source row index',
        required => '1',
    },
    'destination_row_index' => {
        data_type => 'int',
        description => 'Destination row index',
        required => '1',
    },
    'row_number' => {
        data_type => 'int',
        description => 'The copied row number',
        required => '1',
    },
    'worksheet' => {
        data_type => 'string',
        description => 'worksheet',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_copy_worksheet_rows' } = { 
    	summary => 'Copy worksheet rows.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_post_copy_worksheet_rows {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_copy_worksheet_rows");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_copy_worksheet_rows");
    }

    # verify the required parameter 'source_row_index' is set
    unless (exists $args{'source_row_index'}) {
      croak("Missing the required parameter 'source_row_index' when calling cells_post_copy_worksheet_rows");
    }

    # verify the required parameter 'destination_row_index' is set
    unless (exists $args{'destination_row_index'}) {
      croak("Missing the required parameter 'destination_row_index' when calling cells_post_copy_worksheet_rows");
    }

    # verify the required parameter 'row_number' is set
    unless (exists $args{'row_number'}) {
      croak("Missing the required parameter 'row_number' when calling cells_post_copy_worksheet_rows");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/rows/copy';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'source_row_index'}) {
        $query_params->{'sourceRowIndex'} = $self->{api_client}->to_query_value($args{'source_row_index'});
    }

    # query params
    if ( exists $args{'destination_row_index'}) {
        $query_params->{'destinationRowIndex'} = $self->{api_client}->to_query_value($args{'destination_row_index'});
    }

    # query params
    if ( exists $args{'row_number'}) {
        $query_params->{'rowNumber'} = $self->{api_client}->to_query_value($args{'row_number'});
    }

    # query params
    if ( exists $args{'worksheet'}) {
        $query_params->{'worksheet'} = $self->{api_client}->to_query_value($args{'worksheet'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_post_group_worksheet_columns
#
# Group worksheet columns.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $first_index The first column index to be operated. (required)
# @param int $last_index The last column index to be operated. (required)
# @param boolean $hide columns visible state (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'first_index' => {
        data_type => 'int',
        description => 'The first column index to be operated.',
        required => '1',
    },
    'last_index' => {
        data_type => 'int',
        description => 'The last column index to be operated.',
        required => '1',
    },
    'hide' => {
        data_type => 'boolean',
        description => 'columns visible state',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_group_worksheet_columns' } = { 
    	summary => 'Group worksheet columns.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_post_group_worksheet_columns {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_group_worksheet_columns");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_group_worksheet_columns");
    }

    # verify the required parameter 'first_index' is set
    unless (exists $args{'first_index'}) {
      croak("Missing the required parameter 'first_index' when calling cells_post_group_worksheet_columns");
    }

    # verify the required parameter 'last_index' is set
    unless (exists $args{'last_index'}) {
      croak("Missing the required parameter 'last_index' when calling cells_post_group_worksheet_columns");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/columns/group';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'first_index'}) {
        $query_params->{'firstIndex'} = $self->{api_client}->to_query_value($args{'first_index'});
    }

    # query params
    if ( exists $args{'last_index'}) {
        $query_params->{'lastIndex'} = $self->{api_client}->to_query_value($args{'last_index'});
    }

    # query params
    if ( exists $args{'hide'}) {
        $query_params->{'hide'} = $self->{api_client}->to_query_value($args{'hide'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_post_group_worksheet_rows
#
# Group worksheet rows.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $first_index The first row index to be operated. (required)
# @param int $last_index The last row index to be operated. (required)
# @param boolean $hide rows visible state (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'first_index' => {
        data_type => 'int',
        description => 'The first row index to be operated.',
        required => '1',
    },
    'last_index' => {
        data_type => 'int',
        description => 'The last row index to be operated.',
        required => '1',
    },
    'hide' => {
        data_type => 'boolean',
        description => 'rows visible state',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_group_worksheet_rows' } = { 
    	summary => 'Group worksheet rows.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_post_group_worksheet_rows {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_group_worksheet_rows");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_group_worksheet_rows");
    }

    # verify the required parameter 'first_index' is set
    unless (exists $args{'first_index'}) {
      croak("Missing the required parameter 'first_index' when calling cells_post_group_worksheet_rows");
    }

    # verify the required parameter 'last_index' is set
    unless (exists $args{'last_index'}) {
      croak("Missing the required parameter 'last_index' when calling cells_post_group_worksheet_rows");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/rows/group';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'first_index'}) {
        $query_params->{'firstIndex'} = $self->{api_client}->to_query_value($args{'first_index'});
    }

    # query params
    if ( exists $args{'last_index'}) {
        $query_params->{'lastIndex'} = $self->{api_client}->to_query_value($args{'last_index'});
    }

    # query params
    if ( exists $args{'hide'}) {
        $query_params->{'hide'} = $self->{api_client}->to_query_value($args{'hide'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_post_hide_worksheet_columns
#
# Hide worksheet columns.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $start_column The begin column index to be operated. (required)
# @param int $total_columns Number of columns to be operated. (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'start_column' => {
        data_type => 'int',
        description => 'The begin column index to be operated.',
        required => '1',
    },
    'total_columns' => {
        data_type => 'int',
        description => 'Number of columns to be operated.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_hide_worksheet_columns' } = { 
    	summary => 'Hide worksheet columns.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_post_hide_worksheet_columns {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_hide_worksheet_columns");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_hide_worksheet_columns");
    }

    # verify the required parameter 'start_column' is set
    unless (exists $args{'start_column'}) {
      croak("Missing the required parameter 'start_column' when calling cells_post_hide_worksheet_columns");
    }

    # verify the required parameter 'total_columns' is set
    unless (exists $args{'total_columns'}) {
      croak("Missing the required parameter 'total_columns' when calling cells_post_hide_worksheet_columns");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/columns/hide';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'start_column'}) {
        $query_params->{'startColumn'} = $self->{api_client}->to_query_value($args{'start_column'});
    }

    # query params
    if ( exists $args{'total_columns'}) {
        $query_params->{'totalColumns'} = $self->{api_client}->to_query_value($args{'total_columns'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_post_hide_worksheet_rows
#
# Hide worksheet rows.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $startrow The begin row index to be operated. (required)
# @param int $total_rows Number of rows to be operated. (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'startrow' => {
        data_type => 'int',
        description => 'The begin row index to be operated.',
        required => '1',
    },
    'total_rows' => {
        data_type => 'int',
        description => 'Number of rows to be operated.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_hide_worksheet_rows' } = { 
    	summary => 'Hide worksheet rows.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_post_hide_worksheet_rows {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_hide_worksheet_rows");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_hide_worksheet_rows");
    }

    # verify the required parameter 'startrow' is set
    unless (exists $args{'startrow'}) {
      croak("Missing the required parameter 'startrow' when calling cells_post_hide_worksheet_rows");
    }

    # verify the required parameter 'total_rows' is set
    unless (exists $args{'total_rows'}) {
      croak("Missing the required parameter 'total_rows' when calling cells_post_hide_worksheet_rows");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/rows/hide';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'startrow'}) {
        $query_params->{'startrow'} = $self->{api_client}->to_query_value($args{'startrow'});
    }

    # query params
    if ( exists $args{'total_rows'}) {
        $query_params->{'totalRows'} = $self->{api_client}->to_query_value($args{'total_rows'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_post_row_style
#
# Set row style.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $row_index The row index. (required)
# @param Style $style Style dto (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'row_index' => {
        data_type => 'int',
        description => 'The row index.',
        required => '1',
    },
    'style' => {
        data_type => 'Style',
        description => 'Style dto',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_row_style' } = { 
    	summary => 'Set row style.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_post_row_style {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_row_style");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_row_style");
    }

    # verify the required parameter 'row_index' is set
    unless (exists $args{'row_index'}) {
      croak("Missing the required parameter 'row_index' when calling cells_post_row_style");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/rows/{rowIndex}/style';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'row_index'}) {
        my $_base_variable = "{" . "rowIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'row_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'style'}) {
        $_body_data = $args{'style'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_post_set_cell_html_string
#
# Set htmlstring value into cell
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param string $cell_name The cell name. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'cell_name' => {
        data_type => 'string',
        description => 'The cell name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_set_cell_html_string' } = { 
    	summary => 'Set htmlstring value into cell',
        params => $params,
        returns => 'CellResponse',
        };
}
# @return CellResponse
#
sub cells_post_set_cell_html_string {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_set_cell_html_string");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_set_cell_html_string");
    }

    # verify the required parameter 'cell_name' is set
    unless (exists $args{'cell_name'}) {
      croak("Missing the required parameter 'cell_name' when calling cells_post_set_cell_html_string");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/{cellName}/htmlstring';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_name'}) {
        my $_base_variable = "{" . "cellName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellResponse', $response);
    return $_response_object;
}

#
# cells_post_set_cell_range_value
#
# Set cell range value 
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param string $cellarea Cell area (like \&quot;A1:C2\&quot;) (required)
# @param string $value Range value (required)
# @param string $type Value data type (like \&quot;int\&quot;) (required)
# @param string $folder Folder name (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'cellarea' => {
        data_type => 'string',
        description => 'Cell area (like \&quot;A1:C2\&quot;)',
        required => '1',
    },
    'value' => {
        data_type => 'string',
        description => 'Range value',
        required => '1',
    },
    'type' => {
        data_type => 'string',
        description => 'Value data type (like \&quot;int\&quot;)',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Folder name',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_set_cell_range_value' } = { 
    	summary => 'Set cell range value ',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_post_set_cell_range_value {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_set_cell_range_value");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_set_cell_range_value");
    }

    # verify the required parameter 'cellarea' is set
    unless (exists $args{'cellarea'}) {
      croak("Missing the required parameter 'cellarea' when calling cells_post_set_cell_range_value");
    }

    # verify the required parameter 'value' is set
    unless (exists $args{'value'}) {
      croak("Missing the required parameter 'value' when calling cells_post_set_cell_range_value");
    }

    # verify the required parameter 'type' is set
    unless (exists $args{'type'}) {
      croak("Missing the required parameter 'type' when calling cells_post_set_cell_range_value");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'cellarea'}) {
        $query_params->{'cellarea'} = $self->{api_client}->to_query_value($args{'cellarea'});
    }

    # query params
    if ( exists $args{'value'}) {
        $query_params->{'value'} = $self->{api_client}->to_query_value($args{'value'});
    }

    # query params
    if ( exists $args{'type'}) {
        $query_params->{'type'} = $self->{api_client}->to_query_value($args{'type'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_post_set_worksheet_column_width
#
# Set worksheet column width.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $column_index The column index. (required)
# @param double $width The width. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'column_index' => {
        data_type => 'int',
        description => 'The column index.',
        required => '1',
    },
    'width' => {
        data_type => 'double',
        description => 'The width.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_set_worksheet_column_width' } = { 
    	summary => 'Set worksheet column width.',
        params => $params,
        returns => 'ColumnResponse',
        };
}
# @return ColumnResponse
#
sub cells_post_set_worksheet_column_width {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_set_worksheet_column_width");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_set_worksheet_column_width");
    }

    # verify the required parameter 'column_index' is set
    unless (exists $args{'column_index'}) {
      croak("Missing the required parameter 'column_index' when calling cells_post_set_worksheet_column_width");
    }

    # verify the required parameter 'width' is set
    unless (exists $args{'width'}) {
      croak("Missing the required parameter 'width' when calling cells_post_set_worksheet_column_width");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/columns/{columnIndex}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'width'}) {
        $query_params->{'width'} = $self->{api_client}->to_query_value($args{'width'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'column_index'}) {
        my $_base_variable = "{" . "columnIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'column_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ColumnResponse', $response);
    return $_response_object;
}

#
# cells_post_ungroup_worksheet_columns
#
# Ungroup worksheet columns.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $first_index The first column index to be operated. (required)
# @param int $last_index The last column index to be operated. (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'first_index' => {
        data_type => 'int',
        description => 'The first column index to be operated.',
        required => '1',
    },
    'last_index' => {
        data_type => 'int',
        description => 'The last column index to be operated.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_ungroup_worksheet_columns' } = { 
    	summary => 'Ungroup worksheet columns.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_post_ungroup_worksheet_columns {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_ungroup_worksheet_columns");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_ungroup_worksheet_columns");
    }

    # verify the required parameter 'first_index' is set
    unless (exists $args{'first_index'}) {
      croak("Missing the required parameter 'first_index' when calling cells_post_ungroup_worksheet_columns");
    }

    # verify the required parameter 'last_index' is set
    unless (exists $args{'last_index'}) {
      croak("Missing the required parameter 'last_index' when calling cells_post_ungroup_worksheet_columns");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/columns/ungroup';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'first_index'}) {
        $query_params->{'firstIndex'} = $self->{api_client}->to_query_value($args{'first_index'});
    }

    # query params
    if ( exists $args{'last_index'}) {
        $query_params->{'lastIndex'} = $self->{api_client}->to_query_value($args{'last_index'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_post_ungroup_worksheet_rows
#
# Ungroup worksheet rows.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $first_index The first row index to be operated. (required)
# @param int $last_index The last row index to be operated. (required)
# @param boolean $is_all Is all row to be operated (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'first_index' => {
        data_type => 'int',
        description => 'The first row index to be operated.',
        required => '1',
    },
    'last_index' => {
        data_type => 'int',
        description => 'The last row index to be operated.',
        required => '1',
    },
    'is_all' => {
        data_type => 'boolean',
        description => 'Is all row to be operated',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_ungroup_worksheet_rows' } = { 
    	summary => 'Ungroup worksheet rows.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_post_ungroup_worksheet_rows {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_ungroup_worksheet_rows");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_ungroup_worksheet_rows");
    }

    # verify the required parameter 'first_index' is set
    unless (exists $args{'first_index'}) {
      croak("Missing the required parameter 'first_index' when calling cells_post_ungroup_worksheet_rows");
    }

    # verify the required parameter 'last_index' is set
    unless (exists $args{'last_index'}) {
      croak("Missing the required parameter 'last_index' when calling cells_post_ungroup_worksheet_rows");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/rows/ungroup';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'first_index'}) {
        $query_params->{'firstIndex'} = $self->{api_client}->to_query_value($args{'first_index'});
    }

    # query params
    if ( exists $args{'last_index'}) {
        $query_params->{'lastIndex'} = $self->{api_client}->to_query_value($args{'last_index'});
    }

    # query params
    if ( exists $args{'is_all'}) {
        $query_params->{'isAll'} = $self->{api_client}->to_query_value($args{'is_all'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_post_unhide_worksheet_columns
#
# Unhide worksheet columns.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $startcolumn The begin column index to be operated. (required)
# @param int $total_columns Number of columns to be operated. (required)
# @param double $width The new column width. (optional, default to 50.0)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'startcolumn' => {
        data_type => 'int',
        description => 'The begin column index to be operated.',
        required => '1',
    },
    'total_columns' => {
        data_type => 'int',
        description => 'Number of columns to be operated.',
        required => '1',
    },
    'width' => {
        data_type => 'double',
        description => 'The new column width.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_unhide_worksheet_columns' } = { 
    	summary => 'Unhide worksheet columns.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_post_unhide_worksheet_columns {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_unhide_worksheet_columns");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_unhide_worksheet_columns");
    }

    # verify the required parameter 'startcolumn' is set
    unless (exists $args{'startcolumn'}) {
      croak("Missing the required parameter 'startcolumn' when calling cells_post_unhide_worksheet_columns");
    }

    # verify the required parameter 'total_columns' is set
    unless (exists $args{'total_columns'}) {
      croak("Missing the required parameter 'total_columns' when calling cells_post_unhide_worksheet_columns");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/columns/unhide';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'startcolumn'}) {
        $query_params->{'startcolumn'} = $self->{api_client}->to_query_value($args{'startcolumn'});
    }

    # query params
    if ( exists $args{'total_columns'}) {
        $query_params->{'totalColumns'} = $self->{api_client}->to_query_value($args{'total_columns'});
    }

    # query params
    if ( exists $args{'width'}) {
        $query_params->{'width'} = $self->{api_client}->to_query_value($args{'width'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_post_unhide_worksheet_rows
#
# Unhide worksheet rows.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $startrow The begin row index to be operated. (required)
# @param int $total_rows Number of rows to be operated. (required)
# @param double $height The new row height. (optional, default to 15.0)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'startrow' => {
        data_type => 'int',
        description => 'The begin row index to be operated.',
        required => '1',
    },
    'total_rows' => {
        data_type => 'int',
        description => 'Number of rows to be operated.',
        required => '1',
    },
    'height' => {
        data_type => 'double',
        description => 'The new row height.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_unhide_worksheet_rows' } = { 
    	summary => 'Unhide worksheet rows.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_post_unhide_worksheet_rows {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_unhide_worksheet_rows");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_unhide_worksheet_rows");
    }

    # verify the required parameter 'startrow' is set
    unless (exists $args{'startrow'}) {
      croak("Missing the required parameter 'startrow' when calling cells_post_unhide_worksheet_rows");
    }

    # verify the required parameter 'total_rows' is set
    unless (exists $args{'total_rows'}) {
      croak("Missing the required parameter 'total_rows' when calling cells_post_unhide_worksheet_rows");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/rows/unhide';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'startrow'}) {
        $query_params->{'startrow'} = $self->{api_client}->to_query_value($args{'startrow'});
    }

    # query params
    if ( exists $args{'total_rows'}) {
        $query_params->{'totalRows'} = $self->{api_client}->to_query_value($args{'total_rows'});
    }

    # query params
    if ( exists $args{'height'}) {
        $query_params->{'height'} = $self->{api_client}->to_query_value($args{'height'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_post_update_worksheet_cell_style
#
# Update cell's style.
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param string $cell_name The cell name. (required)
# @param Style $style with update style settings. (optional)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'cell_name' => {
        data_type => 'string',
        description => 'The cell name.',
        required => '1',
    },
    'style' => {
        data_type => 'Style',
        description => 'with update style settings.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_update_worksheet_cell_style' } = { 
    	summary => 'Update cell&#39;s style.',
        params => $params,
        returns => 'StyleResponse',
        };
}
# @return StyleResponse
#
sub cells_post_update_worksheet_cell_style {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_update_worksheet_cell_style");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_update_worksheet_cell_style");
    }

    # verify the required parameter 'cell_name' is set
    unless (exists $args{'cell_name'}) {
      croak("Missing the required parameter 'cell_name' when calling cells_post_update_worksheet_cell_style");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/{cellName}/style';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_name'}) {
        my $_base_variable = "{" . "cellName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'style'}) {
        $_body_data = $args{'style'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('StyleResponse', $response);
    return $_response_object;
}

#
# cells_post_update_worksheet_range_style
#
# Update cell's range style.
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param string $range The range. (required)
# @param Style $style with update style settings. (optional)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'range' => {
        data_type => 'string',
        description => 'The range.',
        required => '1',
    },
    'style' => {
        data_type => 'Style',
        description => 'with update style settings.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_update_worksheet_range_style' } = { 
    	summary => 'Update cell&#39;s range style.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_post_update_worksheet_range_style {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_update_worksheet_range_style");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_update_worksheet_range_style");
    }

    # verify the required parameter 'range' is set
    unless (exists $args{'range'}) {
      croak("Missing the required parameter 'range' when calling cells_post_update_worksheet_range_style");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/style';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'range'}) {
        $query_params->{'range'} = $self->{api_client}->to_query_value($args{'range'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'style'}) {
        $_body_data = $args{'style'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_post_update_worksheet_row
#
# Update worksheet row.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $row_index The row index. (required)
# @param double $height The new row height. (optional, default to 0.0)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'row_index' => {
        data_type => 'int',
        description => 'The row index.',
        required => '1',
    },
    'height' => {
        data_type => 'double',
        description => 'The new row height.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_update_worksheet_row' } = { 
    	summary => 'Update worksheet row.',
        params => $params,
        returns => 'RowResponse',
        };
}
# @return RowResponse
#
sub cells_post_update_worksheet_row {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_update_worksheet_row");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_update_worksheet_row");
    }

    # verify the required parameter 'row_index' is set
    unless (exists $args{'row_index'}) {
      croak("Missing the required parameter 'row_index' when calling cells_post_update_worksheet_row");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/rows/{rowIndex}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'height'}) {
        $query_params->{'height'} = $self->{api_client}->to_query_value($args{'height'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'row_index'}) {
        my $_base_variable = "{" . "rowIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'row_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('RowResponse', $response);
    return $_response_object;
}

#
# cells_post_worksheet_cell_set_value
#
# Set cell value.
# 
# @param string $name The document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $cell_name The cell name. (required)
# @param string $value The cell value. (optional)
# @param string $type The value type. (optional)
# @param string $formula Formula for cell (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'cell_name' => {
        data_type => 'string',
        description => 'The cell name.',
        required => '1',
    },
    'value' => {
        data_type => 'string',
        description => 'The cell value.',
        required => '0',
    },
    'type' => {
        data_type => 'string',
        description => 'The value type.',
        required => '0',
    },
    'formula' => {
        data_type => 'string',
        description => 'Formula for cell',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_worksheet_cell_set_value' } = { 
    	summary => 'Set cell value.',
        params => $params,
        returns => 'CellResponse',
        };
}
# @return CellResponse
#
sub cells_post_worksheet_cell_set_value {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_worksheet_cell_set_value");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_worksheet_cell_set_value");
    }

    # verify the required parameter 'cell_name' is set
    unless (exists $args{'cell_name'}) {
      croak("Missing the required parameter 'cell_name' when calling cells_post_worksheet_cell_set_value");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/{cellName}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'value'}) {
        $query_params->{'value'} = $self->{api_client}->to_query_value($args{'value'});
    }

    # query params
    if ( exists $args{'type'}) {
        $query_params->{'type'} = $self->{api_client}->to_query_value($args{'type'});
    }

    # query params
    if ( exists $args{'formula'}) {
        $query_params->{'formula'} = $self->{api_client}->to_query_value($args{'formula'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_name'}) {
        my $_base_variable = "{" . "cellName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellResponse', $response);
    return $_response_object;
}

#
# cells_post_worksheet_merge
#
# Merge cells.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $start_row The start row. (required)
# @param int $start_column The start column. (required)
# @param int $total_rows The total rows (required)
# @param int $total_columns The total columns. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'start_row' => {
        data_type => 'int',
        description => 'The start row.',
        required => '1',
    },
    'start_column' => {
        data_type => 'int',
        description => 'The start column.',
        required => '1',
    },
    'total_rows' => {
        data_type => 'int',
        description => 'The total rows',
        required => '1',
    },
    'total_columns' => {
        data_type => 'int',
        description => 'The total columns.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_worksheet_merge' } = { 
    	summary => 'Merge cells.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_post_worksheet_merge {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_worksheet_merge");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_worksheet_merge");
    }

    # verify the required parameter 'start_row' is set
    unless (exists $args{'start_row'}) {
      croak("Missing the required parameter 'start_row' when calling cells_post_worksheet_merge");
    }

    # verify the required parameter 'start_column' is set
    unless (exists $args{'start_column'}) {
      croak("Missing the required parameter 'start_column' when calling cells_post_worksheet_merge");
    }

    # verify the required parameter 'total_rows' is set
    unless (exists $args{'total_rows'}) {
      croak("Missing the required parameter 'total_rows' when calling cells_post_worksheet_merge");
    }

    # verify the required parameter 'total_columns' is set
    unless (exists $args{'total_columns'}) {
      croak("Missing the required parameter 'total_columns' when calling cells_post_worksheet_merge");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/merge';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'start_row'}) {
        $query_params->{'startRow'} = $self->{api_client}->to_query_value($args{'start_row'});
    }

    # query params
    if ( exists $args{'start_column'}) {
        $query_params->{'startColumn'} = $self->{api_client}->to_query_value($args{'start_column'});
    }

    # query params
    if ( exists $args{'total_rows'}) {
        $query_params->{'totalRows'} = $self->{api_client}->to_query_value($args{'total_rows'});
    }

    # query params
    if ( exists $args{'total_columns'}) {
        $query_params->{'totalColumns'} = $self->{api_client}->to_query_value($args{'total_columns'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_post_worksheet_unmerge
#
# Unmerge cells.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $start_row The start row. (required)
# @param int $start_column The start column. (required)
# @param int $total_rows The total rows (required)
# @param int $total_columns The total columns. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'start_row' => {
        data_type => 'int',
        description => 'The start row.',
        required => '1',
    },
    'start_column' => {
        data_type => 'int',
        description => 'The start column.',
        required => '1',
    },
    'total_rows' => {
        data_type => 'int',
        description => 'The total rows',
        required => '1',
    },
    'total_columns' => {
        data_type => 'int',
        description => 'The total columns.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_post_worksheet_unmerge' } = { 
    	summary => 'Unmerge cells.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_post_worksheet_unmerge {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_post_worksheet_unmerge");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_post_worksheet_unmerge");
    }

    # verify the required parameter 'start_row' is set
    unless (exists $args{'start_row'}) {
      croak("Missing the required parameter 'start_row' when calling cells_post_worksheet_unmerge");
    }

    # verify the required parameter 'start_column' is set
    unless (exists $args{'start_column'}) {
      croak("Missing the required parameter 'start_column' when calling cells_post_worksheet_unmerge");
    }

    # verify the required parameter 'total_rows' is set
    unless (exists $args{'total_rows'}) {
      croak("Missing the required parameter 'total_rows' when calling cells_post_worksheet_unmerge");
    }

    # verify the required parameter 'total_columns' is set
    unless (exists $args{'total_columns'}) {
      croak("Missing the required parameter 'total_columns' when calling cells_post_worksheet_unmerge");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/unmerge';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'start_row'}) {
        $query_params->{'startRow'} = $self->{api_client}->to_query_value($args{'start_row'});
    }

    # query params
    if ( exists $args{'start_column'}) {
        $query_params->{'startColumn'} = $self->{api_client}->to_query_value($args{'start_column'});
    }

    # query params
    if ( exists $args{'total_rows'}) {
        $query_params->{'totalRows'} = $self->{api_client}->to_query_value($args{'total_rows'});
    }

    # query params
    if ( exists $args{'total_columns'}) {
        $query_params->{'totalColumns'} = $self->{api_client}->to_query_value($args{'total_columns'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_properties_delete_document_properties
#
# Delete all custom document properties and clean built-in ones.
# 
# @param string $name The document name. (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_properties_delete_document_properties' } = { 
    	summary => 'Delete all custom document properties and clean built-in ones.',
        params => $params,
        returns => 'CellsDocumentPropertiesResponse',
        };
}
# @return CellsDocumentPropertiesResponse
#
sub cells_properties_delete_document_properties {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_properties_delete_document_properties");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/documentproperties';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsDocumentPropertiesResponse', $response);
    return $_response_object;
}

#
# cells_properties_delete_document_property
#
# Delete document property.
# 
# @param string $name The document name. (required)
# @param string $property_name The property name. (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'property_name' => {
        data_type => 'string',
        description => 'The property name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_properties_delete_document_property' } = { 
    	summary => 'Delete document property.',
        params => $params,
        returns => 'CellsDocumentPropertiesResponse',
        };
}
# @return CellsDocumentPropertiesResponse
#
sub cells_properties_delete_document_property {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_properties_delete_document_property");
    }

    # verify the required parameter 'property_name' is set
    unless (exists $args{'property_name'}) {
      croak("Missing the required parameter 'property_name' when calling cells_properties_delete_document_property");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/documentproperties/{propertyName}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'property_name'}) {
        my $_base_variable = "{" . "propertyName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'property_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsDocumentPropertiesResponse', $response);
    return $_response_object;
}

#
# cells_properties_get_document_properties
#
# Read document properties.
# 
# @param string $name The document name. (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_properties_get_document_properties' } = { 
    	summary => 'Read document properties.',
        params => $params,
        returns => 'CellsDocumentPropertiesResponse',
        };
}
# @return CellsDocumentPropertiesResponse
#
sub cells_properties_get_document_properties {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_properties_get_document_properties");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/documentproperties';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsDocumentPropertiesResponse', $response);
    return $_response_object;
}

#
# cells_properties_get_document_property
#
# Read document property by name.
# 
# @param string $name The document name. (required)
# @param string $property_name The property name. (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'property_name' => {
        data_type => 'string',
        description => 'The property name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_properties_get_document_property' } = { 
    	summary => 'Read document property by name.',
        params => $params,
        returns => 'CellsDocumentPropertyResponse',
        };
}
# @return CellsDocumentPropertyResponse
#
sub cells_properties_get_document_property {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_properties_get_document_property");
    }

    # verify the required parameter 'property_name' is set
    unless (exists $args{'property_name'}) {
      croak("Missing the required parameter 'property_name' when calling cells_properties_get_document_property");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/documentproperties/{propertyName}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'property_name'}) {
        my $_base_variable = "{" . "propertyName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'property_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsDocumentPropertyResponse', $response);
    return $_response_object;
}

#
# cells_properties_put_document_property
#
# Set/create document property.
# 
# @param string $name The document name. (required)
# @param string $property_name The property name. (required)
# @param CellsDocumentProperty $property with new property value. (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'property_name' => {
        data_type => 'string',
        description => 'The property name.',
        required => '1',
    },
    'property' => {
        data_type => 'CellsDocumentProperty',
        description => 'with new property value.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_properties_put_document_property' } = { 
    	summary => 'Set/create document property.',
        params => $params,
        returns => 'CellsDocumentPropertyResponse',
        };
}
# @return CellsDocumentPropertyResponse
#
sub cells_properties_put_document_property {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_properties_put_document_property");
    }

    # verify the required parameter 'property_name' is set
    unless (exists $args{'property_name'}) {
      croak("Missing the required parameter 'property_name' when calling cells_properties_put_document_property");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/documentproperties/{propertyName}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'property_name'}) {
        my $_base_variable = "{" . "propertyName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'property_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'property'}) {
        $_body_data = $args{'property'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsDocumentPropertyResponse', $response);
    return $_response_object;
}

#
# cells_put_insert_worksheet_columns
#
# Insert worksheet columns.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $column_index The column index. (required)
# @param int $columns The columns. (required)
# @param boolean $update_reference The update reference. (optional, default to true)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'column_index' => {
        data_type => 'int',
        description => 'The column index.',
        required => '1',
    },
    'columns' => {
        data_type => 'int',
        description => 'The columns.',
        required => '1',
    },
    'update_reference' => {
        data_type => 'boolean',
        description => 'The update reference.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_put_insert_worksheet_columns' } = { 
    	summary => 'Insert worksheet columns.',
        params => $params,
        returns => 'ColumnsResponse',
        };
}
# @return ColumnsResponse
#
sub cells_put_insert_worksheet_columns {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_put_insert_worksheet_columns");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_put_insert_worksheet_columns");
    }

    # verify the required parameter 'column_index' is set
    unless (exists $args{'column_index'}) {
      croak("Missing the required parameter 'column_index' when calling cells_put_insert_worksheet_columns");
    }

    # verify the required parameter 'columns' is set
    unless (exists $args{'columns'}) {
      croak("Missing the required parameter 'columns' when calling cells_put_insert_worksheet_columns");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/columns/{columnIndex}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'columns'}) {
        $query_params->{'columns'} = $self->{api_client}->to_query_value($args{'columns'});
    }

    # query params
    if ( exists $args{'update_reference'}) {
        $query_params->{'updateReference'} = $self->{api_client}->to_query_value($args{'update_reference'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'column_index'}) {
        my $_base_variable = "{" . "columnIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'column_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ColumnsResponse', $response);
    return $_response_object;
}

#
# cells_put_insert_worksheet_row
#
# Insert new worksheet row.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $row_index The new row index. (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'row_index' => {
        data_type => 'int',
        description => 'The new row index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_put_insert_worksheet_row' } = { 
    	summary => 'Insert new worksheet row.',
        params => $params,
        returns => 'RowResponse',
        };
}
# @return RowResponse
#
sub cells_put_insert_worksheet_row {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_put_insert_worksheet_row");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_put_insert_worksheet_row");
    }

    # verify the required parameter 'row_index' is set
    unless (exists $args{'row_index'}) {
      croak("Missing the required parameter 'row_index' when calling cells_put_insert_worksheet_row");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/rows/{rowIndex}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'row_index'}) {
        my $_base_variable = "{" . "rowIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'row_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('RowResponse', $response);
    return $_response_object;
}

#
# cells_put_insert_worksheet_rows
#
# Insert several new worksheet rows.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $startrow The begin row index to be operated. (required)
# @param int $total_rows Number of rows to be operated. (optional, default to 1)
# @param boolean $update_reference Indicates if update references in other worksheets. (optional, default to true)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'startrow' => {
        data_type => 'int',
        description => 'The begin row index to be operated.',
        required => '1',
    },
    'total_rows' => {
        data_type => 'int',
        description => 'Number of rows to be operated.',
        required => '0',
    },
    'update_reference' => {
        data_type => 'boolean',
        description => 'Indicates if update references in other worksheets.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_put_insert_worksheet_rows' } = { 
    	summary => 'Insert several new worksheet rows.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_put_insert_worksheet_rows {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_put_insert_worksheet_rows");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_put_insert_worksheet_rows");
    }

    # verify the required parameter 'startrow' is set
    unless (exists $args{'startrow'}) {
      croak("Missing the required parameter 'startrow' when calling cells_put_insert_worksheet_rows");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/cells/rows';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'startrow'}) {
        $query_params->{'startrow'} = $self->{api_client}->to_query_value($args{'startrow'});
    }

    # query params
    if ( exists $args{'total_rows'}) {
        $query_params->{'totalRows'} = $self->{api_client}->to_query_value($args{'total_rows'});
    }

    # query params
    if ( exists $args{'update_reference'}) {
        $query_params->{'updateReference'} = $self->{api_client}->to_query_value($args{'update_reference'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_ranges_get_worksheet_cells_range_value
#
# Get cells list in a range by range name or row column indexes  
# 
# @param string $name workbook name (required)
# @param string $sheet_name worksheet name (required)
# @param string $namerange range name, for example: &#39;A1:B2&#39; or &#39;range_name1&#39; (optional)
# @param int $first_row the first row of the range (optional)
# @param int $first_column the first column of the range (optional)
# @param int $row_count the count of rows in the range (optional)
# @param int $column_count the count of columns in the range (optional)
# @param string $folder Workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'workbook name',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'worksheet name',
        required => '1',
    },
    'namerange' => {
        data_type => 'string',
        description => 'range name, for example: &#39;A1:B2&#39; or &#39;range_name1&#39;',
        required => '0',
    },
    'first_row' => {
        data_type => 'int',
        description => 'the first row of the range',
        required => '0',
    },
    'first_column' => {
        data_type => 'int',
        description => 'the first column of the range',
        required => '0',
    },
    'row_count' => {
        data_type => 'int',
        description => 'the count of rows in the range',
        required => '0',
    },
    'column_count' => {
        data_type => 'int',
        description => 'the count of columns in the range',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ranges_get_worksheet_cells_range_value' } = { 
    	summary => 'Get cells list in a range by range name or row column indexes  ',
        params => $params,
        returns => 'RangeValueResponse',
        };
}
# @return RangeValueResponse
#
sub cells_ranges_get_worksheet_cells_range_value {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ranges_get_worksheet_cells_range_value");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ranges_get_worksheet_cells_range_value");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/ranges/value';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'namerange'}) {
        $query_params->{'namerange'} = $self->{api_client}->to_query_value($args{'namerange'});
    }

    # query params
    if ( exists $args{'first_row'}) {
        $query_params->{'firstRow'} = $self->{api_client}->to_query_value($args{'first_row'});
    }

    # query params
    if ( exists $args{'first_column'}) {
        $query_params->{'firstColumn'} = $self->{api_client}->to_query_value($args{'first_column'});
    }

    # query params
    if ( exists $args{'row_count'}) {
        $query_params->{'rowCount'} = $self->{api_client}->to_query_value($args{'row_count'});
    }

    # query params
    if ( exists $args{'column_count'}) {
        $query_params->{'columnCount'} = $self->{api_client}->to_query_value($args{'column_count'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('RangeValueResponse', $response);
    return $_response_object;
}

#
# cells_ranges_post_worksheet_cells_range_column_width
#
# Set column width of range
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param double $value  (required)
# @param Range $range  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'value' => {
        data_type => 'double',
        description => '',
        required => '1',
    },
    'range' => {
        data_type => 'Range',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ranges_post_worksheet_cells_range_column_width' } = { 
    	summary => 'Set column width of range',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_ranges_post_worksheet_cells_range_column_width {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ranges_post_worksheet_cells_range_column_width");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ranges_post_worksheet_cells_range_column_width");
    }

    # verify the required parameter 'value' is set
    unless (exists $args{'value'}) {
      croak("Missing the required parameter 'value' when calling cells_ranges_post_worksheet_cells_range_column_width");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/ranges/columnWidth';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'value'}) {
        $query_params->{'value'} = $self->{api_client}->to_query_value($args{'value'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'range'}) {
        $_body_data = $args{'range'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_ranges_post_worksheet_cells_range_merge
#
# Combines a range of cells into a single cell.              
# 
# @param string $name workbook name (required)
# @param string $sheet_name worksheet name (required)
# @param Range $range range in worksheet  (optional)
# @param string $folder Workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'workbook name',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'worksheet name',
        required => '1',
    },
    'range' => {
        data_type => 'Range',
        description => 'range in worksheet ',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ranges_post_worksheet_cells_range_merge' } = { 
    	summary => 'Combines a range of cells into a single cell.              ',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_ranges_post_worksheet_cells_range_merge {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ranges_post_worksheet_cells_range_merge");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ranges_post_worksheet_cells_range_merge");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/ranges/merge';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'range'}) {
        $_body_data = $args{'range'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_ranges_post_worksheet_cells_range_move_to
#
# Move the current range to the dest range.             
# 
# @param string $name workbook name (required)
# @param string $sheet_name worksheet name (required)
# @param int $dest_row The start row of the dest range. (required)
# @param int $dest_column The start column of the dest range. (required)
# @param Range $range range in worksheet  (optional)
# @param string $folder Workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'workbook name',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'worksheet name',
        required => '1',
    },
    'dest_row' => {
        data_type => 'int',
        description => 'The start row of the dest range.',
        required => '1',
    },
    'dest_column' => {
        data_type => 'int',
        description => 'The start column of the dest range.',
        required => '1',
    },
    'range' => {
        data_type => 'Range',
        description => 'range in worksheet ',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ranges_post_worksheet_cells_range_move_to' } = { 
    	summary => 'Move the current range to the dest range.             ',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_ranges_post_worksheet_cells_range_move_to {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ranges_post_worksheet_cells_range_move_to");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ranges_post_worksheet_cells_range_move_to");
    }

    # verify the required parameter 'dest_row' is set
    unless (exists $args{'dest_row'}) {
      croak("Missing the required parameter 'dest_row' when calling cells_ranges_post_worksheet_cells_range_move_to");
    }

    # verify the required parameter 'dest_column' is set
    unless (exists $args{'dest_column'}) {
      croak("Missing the required parameter 'dest_column' when calling cells_ranges_post_worksheet_cells_range_move_to");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/ranges/moveto';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'dest_row'}) {
        $query_params->{'destRow'} = $self->{api_client}->to_query_value($args{'dest_row'});
    }

    # query params
    if ( exists $args{'dest_column'}) {
        $query_params->{'destColumn'} = $self->{api_client}->to_query_value($args{'dest_column'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'range'}) {
        $_body_data = $args{'range'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_ranges_post_worksheet_cells_range_outline_border
#
# Sets outline border around a range of cells.
# 
# @param string $name workbook name (required)
# @param string $sheet_name worksheet name (required)
# @param RangeSetOutlineBorderRequest $range_operate Range Set OutlineBorder Request  (optional)
# @param string $folder Workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'workbook name',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'worksheet name',
        required => '1',
    },
    'range_operate' => {
        data_type => 'RangeSetOutlineBorderRequest',
        description => 'Range Set OutlineBorder Request ',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ranges_post_worksheet_cells_range_outline_border' } = { 
    	summary => 'Sets outline border around a range of cells.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_ranges_post_worksheet_cells_range_outline_border {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ranges_post_worksheet_cells_range_outline_border");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ranges_post_worksheet_cells_range_outline_border");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/ranges/outlineBorder';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'range_operate'}) {
        $_body_data = $args{'range_operate'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_ranges_post_worksheet_cells_range_row_height
#
# set row height of range
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param double $value  (required)
# @param Range $range  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'value' => {
        data_type => 'double',
        description => '',
        required => '1',
    },
    'range' => {
        data_type => 'Range',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ranges_post_worksheet_cells_range_row_height' } = { 
    	summary => 'set row height of range',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_ranges_post_worksheet_cells_range_row_height {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ranges_post_worksheet_cells_range_row_height");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ranges_post_worksheet_cells_range_row_height");
    }

    # verify the required parameter 'value' is set
    unless (exists $args{'value'}) {
      croak("Missing the required parameter 'value' when calling cells_ranges_post_worksheet_cells_range_row_height");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/ranges/rowHeight';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'value'}) {
        $query_params->{'value'} = $self->{api_client}->to_query_value($args{'value'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'range'}) {
        $_body_data = $args{'range'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_ranges_post_worksheet_cells_range_style
#
# Sets the style of the range.             
# 
# @param string $name workbook name (required)
# @param string $sheet_name worksheet name (required)
# @param RangeSetStyleRequest $range_operate Range Set Style Request  (optional)
# @param string $folder Workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'workbook name',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'worksheet name',
        required => '1',
    },
    'range_operate' => {
        data_type => 'RangeSetStyleRequest',
        description => 'Range Set Style Request ',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ranges_post_worksheet_cells_range_style' } = { 
    	summary => 'Sets the style of the range.             ',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_ranges_post_worksheet_cells_range_style {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ranges_post_worksheet_cells_range_style");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ranges_post_worksheet_cells_range_style");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/ranges/style';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'range_operate'}) {
        $_body_data = $args{'range_operate'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_ranges_post_worksheet_cells_range_unmerge
#
# Unmerges merged cells of this range.             
# 
# @param string $name workbook name (required)
# @param string $sheet_name worksheet name (required)
# @param Range $range range in worksheet  (optional)
# @param string $folder Workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'workbook name',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'worksheet name',
        required => '1',
    },
    'range' => {
        data_type => 'Range',
        description => 'range in worksheet ',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ranges_post_worksheet_cells_range_unmerge' } = { 
    	summary => 'Unmerges merged cells of this range.             ',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_ranges_post_worksheet_cells_range_unmerge {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ranges_post_worksheet_cells_range_unmerge");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ranges_post_worksheet_cells_range_unmerge");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/ranges/unmerge';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'range'}) {
        $_body_data = $args{'range'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_ranges_post_worksheet_cells_range_value
#
# Puts a value into the range, if appropriate the value will be converted to other data type and cell's number format will be reset.             
# 
# @param string $name workbook name (required)
# @param string $sheet_name worksheet name (required)
# @param string $value Input value (required)
# @param Range $range range in worksheet  (optional)
# @param boolean $is_converted True: converted to other data type if appropriate. (optional, default to false)
# @param boolean $set_style True: set the number format to cell&#39;s style when converting to other data type (optional, default to false)
# @param string $folder Workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'workbook name',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'worksheet name',
        required => '1',
    },
    'value' => {
        data_type => 'string',
        description => 'Input value',
        required => '1',
    },
    'range' => {
        data_type => 'Range',
        description => 'range in worksheet ',
        required => '0',
    },
    'is_converted' => {
        data_type => 'boolean',
        description => 'True: converted to other data type if appropriate.',
        required => '0',
    },
    'set_style' => {
        data_type => 'boolean',
        description => 'True: set the number format to cell&#39;s style when converting to other data type',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ranges_post_worksheet_cells_range_value' } = { 
    	summary => 'Puts a value into the range, if appropriate the value will be converted to other data type and cell&#39;s number format will be reset.             ',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_ranges_post_worksheet_cells_range_value {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ranges_post_worksheet_cells_range_value");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ranges_post_worksheet_cells_range_value");
    }

    # verify the required parameter 'value' is set
    unless (exists $args{'value'}) {
      croak("Missing the required parameter 'value' when calling cells_ranges_post_worksheet_cells_range_value");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/ranges/value';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'value'}) {
        $query_params->{'Value'} = $self->{api_client}->to_query_value($args{'value'});
    }

    # query params
    if ( exists $args{'is_converted'}) {
        $query_params->{'isConverted'} = $self->{api_client}->to_query_value($args{'is_converted'});
    }

    # query params
    if ( exists $args{'set_style'}) {
        $query_params->{'setStyle'} = $self->{api_client}->to_query_value($args{'set_style'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'range'}) {
        $_body_data = $args{'range'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_ranges_post_worksheet_cells_ranges
#
# copy range in the worksheet
# 
# @param string $name workbook name (required)
# @param string $sheet_name worksheet name (required)
# @param RangeCopyRequest $range_operate copydata,copystyle,copyto,copyvalue (optional)
# @param string $folder Workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'workbook name',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'worksheet name',
        required => '1',
    },
    'range_operate' => {
        data_type => 'RangeCopyRequest',
        description => 'copydata,copystyle,copyto,copyvalue',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ranges_post_worksheet_cells_ranges' } = { 
    	summary => 'copy range in the worksheet',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_ranges_post_worksheet_cells_ranges {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ranges_post_worksheet_cells_ranges");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ranges_post_worksheet_cells_ranges");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/ranges';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'range_operate'}) {
        $_body_data = $args{'range_operate'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_save_as_post_document_save_as
#
# Convert document and save result to storage.
# 
# @param string $name The document name. (required)
# @param SaveOptions $save_options Save options. (optional)
# @param string $newfilename The new file name. (optional)
# @param boolean $is_auto_fit_rows Autofit rows. (optional, default to false)
# @param boolean $is_auto_fit_columns Autofit columns. (optional, default to false)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'save_options' => {
        data_type => 'SaveOptions',
        description => 'Save options.',
        required => '0',
    },
    'newfilename' => {
        data_type => 'string',
        description => 'The new file name.',
        required => '0',
    },
    'is_auto_fit_rows' => {
        data_type => 'boolean',
        description => 'Autofit rows.',
        required => '0',
    },
    'is_auto_fit_columns' => {
        data_type => 'boolean',
        description => 'Autofit columns.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_save_as_post_document_save_as' } = { 
    	summary => 'Convert document and save result to storage.',
        params => $params,
        returns => 'SaveResponse',
        };
}
# @return SaveResponse
#
sub cells_save_as_post_document_save_as {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_save_as_post_document_save_as");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/SaveAs';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'newfilename'}) {
        $query_params->{'newfilename'} = $self->{api_client}->to_query_value($args{'newfilename'});
    }

    # query params
    if ( exists $args{'is_auto_fit_rows'}) {
        $query_params->{'isAutoFitRows'} = $self->{api_client}->to_query_value($args{'is_auto_fit_rows'});
    }

    # query params
    if ( exists $args{'is_auto_fit_columns'}) {
        $query_params->{'isAutoFitColumns'} = $self->{api_client}->to_query_value($args{'is_auto_fit_columns'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'save_options'}) {
        $_body_data = $args{'save_options'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaveResponse', $response);
    return $_response_object;
}

#
# cells_shapes_delete_worksheet_shape
#
# Delete a shape in worksheet
# 
# @param string $name document name. (required)
# @param string $sheet_name worksheet name. (required)
# @param int $shapeindex shape index in worksheet shapes. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'worksheet name.',
        required => '1',
    },
    'shapeindex' => {
        data_type => 'int',
        description => 'shape index in worksheet shapes.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_shapes_delete_worksheet_shape' } = { 
    	summary => 'Delete a shape in worksheet',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_shapes_delete_worksheet_shape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_shapes_delete_worksheet_shape");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_shapes_delete_worksheet_shape");
    }

    # verify the required parameter 'shapeindex' is set
    unless (exists $args{'shapeindex'}) {
      croak("Missing the required parameter 'shapeindex' when calling cells_shapes_delete_worksheet_shape");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/shapes/{shapeindex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shapeindex'}) {
        my $_base_variable = "{" . "shapeindex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shapeindex'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_shapes_delete_worksheet_shapes
#
# delete all shapes in worksheet
# 
# @param string $name document name. (required)
# @param string $sheet_name worksheet name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_shapes_delete_worksheet_shapes' } = { 
    	summary => 'delete all shapes in worksheet',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_shapes_delete_worksheet_shapes {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_shapes_delete_worksheet_shapes");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_shapes_delete_worksheet_shapes");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/shapes';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_shapes_get_worksheet_shape
#
# Get worksheet shape
# 
# @param string $name document name. (required)
# @param string $sheet_name worksheet name. (required)
# @param int $shapeindex shape index in worksheet shapes. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'worksheet name.',
        required => '1',
    },
    'shapeindex' => {
        data_type => 'int',
        description => 'shape index in worksheet shapes.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_shapes_get_worksheet_shape' } = { 
    	summary => 'Get worksheet shape',
        params => $params,
        returns => 'ShapeResponse',
        };
}
# @return ShapeResponse
#
sub cells_shapes_get_worksheet_shape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_shapes_get_worksheet_shape");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_shapes_get_worksheet_shape");
    }

    # verify the required parameter 'shapeindex' is set
    unless (exists $args{'shapeindex'}) {
      croak("Missing the required parameter 'shapeindex' when calling cells_shapes_get_worksheet_shape");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/shapes/{shapeindex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shapeindex'}) {
        my $_base_variable = "{" . "shapeindex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shapeindex'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ShapeResponse', $response);
    return $_response_object;
}

#
# cells_shapes_get_worksheet_shapes
#
# Get worksheet shapes 
# 
# @param string $name document name. (required)
# @param string $sheet_name worksheet name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_shapes_get_worksheet_shapes' } = { 
    	summary => 'Get worksheet shapes ',
        params => $params,
        returns => 'ShapesResponse',
        };
}
# @return ShapesResponse
#
sub cells_shapes_get_worksheet_shapes {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_shapes_get_worksheet_shapes");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_shapes_get_worksheet_shapes");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/shapes';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ShapesResponse', $response);
    return $_response_object;
}

#
# cells_shapes_post_worksheet_shape
#
# Update a shape in worksheet
# 
# @param string $name document name. (required)
# @param string $sheet_name worksheet name. (required)
# @param int $shapeindex shape index in worksheet shapes. (required)
# @param Shape $dto  (optional)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'worksheet name.',
        required => '1',
    },
    'shapeindex' => {
        data_type => 'int',
        description => 'shape index in worksheet shapes.',
        required => '1',
    },
    'dto' => {
        data_type => 'Shape',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_shapes_post_worksheet_shape' } = { 
    	summary => 'Update a shape in worksheet',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_shapes_post_worksheet_shape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_shapes_post_worksheet_shape");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_shapes_post_worksheet_shape");
    }

    # verify the required parameter 'shapeindex' is set
    unless (exists $args{'shapeindex'}) {
      croak("Missing the required parameter 'shapeindex' when calling cells_shapes_post_worksheet_shape");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/shapes/{shapeindex}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shapeindex'}) {
        my $_base_variable = "{" . "shapeindex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shapeindex'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'dto'}) {
        $_body_data = $args{'dto'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_shapes_put_worksheet_shape
#
# Add shape in worksheet
# 
# @param string $name document name. (required)
# @param string $sheet_name worksheet name. (required)
# @param string $drawing_type shape object type (required)
# @param int $upper_left_row Upper left row index. (required)
# @param int $upper_left_column Upper left column index. (required)
# @param int $top Represents the vertical offset of Spinner from its left row, in unit of pixel. (required)
# @param int $left Represents the horizontal offset of Spinner from its left column, in unit of pixel. (required)
# @param int $width Represents the height of Spinner, in unit of pixel. (required)
# @param int $height Represents the width of Spinner, in unit of pixel. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'worksheet name.',
        required => '1',
    },
    'drawing_type' => {
        data_type => 'string',
        description => 'shape object type',
        required => '1',
    },
    'upper_left_row' => {
        data_type => 'int',
        description => 'Upper left row index.',
        required => '1',
    },
    'upper_left_column' => {
        data_type => 'int',
        description => 'Upper left column index.',
        required => '1',
    },
    'top' => {
        data_type => 'int',
        description => 'Represents the vertical offset of Spinner from its left row, in unit of pixel.',
        required => '1',
    },
    'left' => {
        data_type => 'int',
        description => 'Represents the horizontal offset of Spinner from its left column, in unit of pixel.',
        required => '1',
    },
    'width' => {
        data_type => 'int',
        description => 'Represents the height of Spinner, in unit of pixel.',
        required => '1',
    },
    'height' => {
        data_type => 'int',
        description => 'Represents the width of Spinner, in unit of pixel.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_shapes_put_worksheet_shape' } = { 
    	summary => 'Add shape in worksheet',
        params => $params,
        returns => 'ShapeResponse',
        };
}
# @return ShapeResponse
#
sub cells_shapes_put_worksheet_shape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_shapes_put_worksheet_shape");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_shapes_put_worksheet_shape");
    }

    # verify the required parameter 'drawing_type' is set
    unless (exists $args{'drawing_type'}) {
      croak("Missing the required parameter 'drawing_type' when calling cells_shapes_put_worksheet_shape");
    }

    # verify the required parameter 'upper_left_row' is set
    unless (exists $args{'upper_left_row'}) {
      croak("Missing the required parameter 'upper_left_row' when calling cells_shapes_put_worksheet_shape");
    }

    # verify the required parameter 'upper_left_column' is set
    unless (exists $args{'upper_left_column'}) {
      croak("Missing the required parameter 'upper_left_column' when calling cells_shapes_put_worksheet_shape");
    }

    # verify the required parameter 'top' is set
    unless (exists $args{'top'}) {
      croak("Missing the required parameter 'top' when calling cells_shapes_put_worksheet_shape");
    }

    # verify the required parameter 'left' is set
    unless (exists $args{'left'}) {
      croak("Missing the required parameter 'left' when calling cells_shapes_put_worksheet_shape");
    }

    # verify the required parameter 'width' is set
    unless (exists $args{'width'}) {
      croak("Missing the required parameter 'width' when calling cells_shapes_put_worksheet_shape");
    }

    # verify the required parameter 'height' is set
    unless (exists $args{'height'}) {
      croak("Missing the required parameter 'height' when calling cells_shapes_put_worksheet_shape");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/shapes';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'drawing_type'}) {
        $query_params->{'DrawingType'} = $self->{api_client}->to_query_value($args{'drawing_type'});
    }

    # query params
    if ( exists $args{'upper_left_row'}) {
        $query_params->{'upperLeftRow'} = $self->{api_client}->to_query_value($args{'upper_left_row'});
    }

    # query params
    if ( exists $args{'upper_left_column'}) {
        $query_params->{'upperLeftColumn'} = $self->{api_client}->to_query_value($args{'upper_left_column'});
    }

    # query params
    if ( exists $args{'top'}) {
        $query_params->{'top'} = $self->{api_client}->to_query_value($args{'top'});
    }

    # query params
    if ( exists $args{'left'}) {
        $query_params->{'left'} = $self->{api_client}->to_query_value($args{'left'});
    }

    # query params
    if ( exists $args{'width'}) {
        $query_params->{'width'} = $self->{api_client}->to_query_value($args{'width'});
    }

    # query params
    if ( exists $args{'height'}) {
        $query_params->{'height'} = $self->{api_client}->to_query_value($args{'height'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ShapeResponse', $response);
    return $_response_object;
}

#
# cells_task_post_run_task
#
# Run tasks  
# 
# @param String $task_data  (required)
{
    my $params = {
    'task_data' => {
        data_type => 'String',
        description => '',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_task_post_run_task' } = { 
    	summary => 'Run tasks  ',
        params => $params,
        returns => 'object',
        };
}
# @return object
#
sub cells_task_post_run_task {
    my ($self, %args) = @_;

    # verify the required parameter 'task_data' is set
    unless (exists $args{'task_data'}) {
      croak("Missing the required parameter 'task_data' when calling cells_task_post_run_task");
    }

    # parse inputs
    my $_resource_path = '/cells/task/runtask';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'task_data'}) {
        $_body_data = $args{'task_data'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('object', $response);
    return $_response_object;
}

#
# cells_workbook_delete_decrypt_document
#
# Decrypt document.
# 
# @param string $name The document name. (required)
# @param WorkbookEncryptionRequest $encryption Encryption settings, only password can be specified. (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'encryption' => {
        data_type => 'WorkbookEncryptionRequest',
        description => 'Encryption settings, only password can be specified.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_delete_decrypt_document' } = { 
    	summary => 'Decrypt document.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_workbook_delete_decrypt_document {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_delete_decrypt_document");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/encryption';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'encryption'}) {
        $_body_data = $args{'encryption'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_workbook_delete_document_unprotect_from_changes
#
# Unprotect document from changes.
# 
# @param string $name The document name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_delete_document_unprotect_from_changes' } = { 
    	summary => 'Unprotect document from changes.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_workbook_delete_document_unprotect_from_changes {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_delete_document_unprotect_from_changes");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/writeProtection';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_workbook_delete_unprotect_document
#
# Unprotect document.
# 
# @param string $name The document name. (required)
# @param WorkbookProtectionRequest $protection Protection settings, only password can be specified. (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'protection' => {
        data_type => 'WorkbookProtectionRequest',
        description => 'Protection settings, only password can be specified.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_delete_unprotect_document' } = { 
    	summary => 'Unprotect document.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_workbook_delete_unprotect_document {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_delete_unprotect_document");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/protection';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'protection'}) {
        $_body_data = $args{'protection'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_workbook_delete_workbook_background
#
# Set worksheet background image.
# 
# @param string $name  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_delete_workbook_background' } = { 
    	summary => 'Set worksheet background image.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_workbook_delete_workbook_background {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_delete_workbook_background");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/background';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_workbook_delete_workbook_name
#
# Clean workbook's names.
# 
# @param string $name The workbook name. (required)
# @param string $name_name The name. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'name_name' => {
        data_type => 'string',
        description => 'The name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_delete_workbook_name' } = { 
    	summary => 'Clean workbook&#39;s names.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_workbook_delete_workbook_name {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_delete_workbook_name");
    }

    # verify the required parameter 'name_name' is set
    unless (exists $args{'name_name'}) {
      croak("Missing the required parameter 'name_name' when calling cells_workbook_delete_workbook_name");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/names/{nameName}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'name_name'}) {
        my $_base_variable = "{" . "nameName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_workbook_delete_workbook_names
#
# Clean workbook's names.
# 
# @param string $name The workbook name. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_delete_workbook_names' } = { 
    	summary => 'Clean workbook&#39;s names.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_workbook_delete_workbook_names {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_delete_workbook_names");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/names';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_workbook_get_workbook
#
# Read workbook info or export.
# 
# @param string $name The document name. (required)
# @param string $password The document password. (optional)
# @param string $format The exported file format. (optional)
# @param boolean $is_auto_fit Set document rows to be autofit. (optional, default to false)
# @param boolean $only_save_table Only save table data. (optional, default to false)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
# @param string $out_path The document output folder. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'The document password.',
        required => '0',
    },
    'format' => {
        data_type => 'string',
        description => 'The exported file format.',
        required => '0',
    },
    'is_auto_fit' => {
        data_type => 'boolean',
        description => 'Set document rows to be autofit.',
        required => '0',
    },
    'only_save_table' => {
        data_type => 'boolean',
        description => 'Only save table data.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    'out_path' => {
        data_type => 'string',
        description => 'The document output folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_get_workbook' } = { 
    	summary => 'Read workbook info or export.',
        params => $params,
        returns => 'string',
        };
}
# @return string
#
sub cells_workbook_get_workbook {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_get_workbook");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'password'}) {
        $query_params->{'password'} = $self->{api_client}->to_query_value($args{'password'});
    }

    # query params
    if ( exists $args{'format'}) {
        $query_params->{'format'} = $self->{api_client}->to_query_value($args{'format'});
    }

    # query params
    if ( exists $args{'is_auto_fit'}) {
        $query_params->{'isAutoFit'} = $self->{api_client}->to_query_value($args{'is_auto_fit'});
    }

    # query params
    if ( exists $args{'only_save_table'}) {
        $query_params->{'onlySaveTable'} = $self->{api_client}->to_query_value($args{'only_save_table'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if ( exists $args{'out_path'}) {
        $query_params->{'outPath'} = $self->{api_client}->to_query_value($args{'out_path'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('string', $response);
    return $_response_object;
}

#
# cells_workbook_get_workbook_default_style
#
# Read workbook default style info.
# 
# @param string $name The workbook name. (required)
# @param string $folder The document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_get_workbook_default_style' } = { 
    	summary => 'Read workbook default style info.',
        params => $params,
        returns => 'StyleResponse',
        };
}
# @return StyleResponse
#
sub cells_workbook_get_workbook_default_style {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_get_workbook_default_style");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/defaultstyle';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('StyleResponse', $response);
    return $_response_object;
}

#
# cells_workbook_get_workbook_name
#
# Read workbook's name.
# 
# @param string $name The workbook name. (required)
# @param string $name_name The name. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'name_name' => {
        data_type => 'string',
        description => 'The name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_get_workbook_name' } = { 
    	summary => 'Read workbook&#39;s name.',
        params => $params,
        returns => 'NameResponse',
        };
}
# @return NameResponse
#
sub cells_workbook_get_workbook_name {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_get_workbook_name");
    }

    # verify the required parameter 'name_name' is set
    unless (exists $args{'name_name'}) {
      croak("Missing the required parameter 'name_name' when calling cells_workbook_get_workbook_name");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/names/{nameName}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'name_name'}) {
        my $_base_variable = "{" . "nameName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('NameResponse', $response);
    return $_response_object;
}

#
# cells_workbook_get_workbook_name_value
#
# Get workbook's name value.
# 
# @param string $name The workbook name. (required)
# @param string $name_name The name. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'name_name' => {
        data_type => 'string',
        description => 'The name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_get_workbook_name_value' } = { 
    	summary => 'Get workbook&#39;s name value.',
        params => $params,
        returns => 'RangeValueResponse',
        };
}
# @return RangeValueResponse
#
sub cells_workbook_get_workbook_name_value {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_get_workbook_name_value");
    }

    # verify the required parameter 'name_name' is set
    unless (exists $args{'name_name'}) {
      croak("Missing the required parameter 'name_name' when calling cells_workbook_get_workbook_name_value");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/names/{nameName}/value';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'name_name'}) {
        my $_base_variable = "{" . "nameName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('RangeValueResponse', $response);
    return $_response_object;
}

#
# cells_workbook_get_workbook_names
#
# Read workbook's names.
# 
# @param string $name The workbook name. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_get_workbook_names' } = { 
    	summary => 'Read workbook&#39;s names.',
        params => $params,
        returns => 'NamesResponse',
        };
}
# @return NamesResponse
#
sub cells_workbook_get_workbook_names {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_get_workbook_names");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/names';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('NamesResponse', $response);
    return $_response_object;
}

#
# cells_workbook_get_workbook_settings
#
# Get Workbook Settings DTO
# 
# @param string $name Document name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_get_workbook_settings' } = { 
    	summary => 'Get Workbook Settings DTO',
        params => $params,
        returns => 'WorkbookSettingsResponse',
        };
}
# @return WorkbookSettingsResponse
#
sub cells_workbook_get_workbook_settings {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_get_workbook_settings");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/settings';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('WorkbookSettingsResponse', $response);
    return $_response_object;
}

#
# cells_workbook_get_workbook_text_items
#
# Read workbook's text items.
# 
# @param string $name The workbook name. (required)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_get_workbook_text_items' } = { 
    	summary => 'Read workbook&#39;s text items.',
        params => $params,
        returns => 'TextItemsResponse',
        };
}
# @return TextItemsResponse
#
sub cells_workbook_get_workbook_text_items {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_get_workbook_text_items");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/textItems';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('TextItemsResponse', $response);
    return $_response_object;
}

#
# cells_workbook_post_autofit_workbook_rows
#
# Autofit workbook rows.
# 
# @param string $name Document name. (required)
# @param AutoFitterOptions $auto_fitter_options Auto Fitter Options. (optional)
# @param int $start_row Start row. (optional)
# @param int $end_row End row. (optional)
# @param boolean $only_auto Only auto. (optional, default to false)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'auto_fitter_options' => {
        data_type => 'AutoFitterOptions',
        description => 'Auto Fitter Options.',
        required => '0',
    },
    'start_row' => {
        data_type => 'int',
        description => 'Start row.',
        required => '0',
    },
    'end_row' => {
        data_type => 'int',
        description => 'End row.',
        required => '0',
    },
    'only_auto' => {
        data_type => 'boolean',
        description => 'Only auto.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_post_autofit_workbook_rows' } = { 
    	summary => 'Autofit workbook rows.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_workbook_post_autofit_workbook_rows {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_post_autofit_workbook_rows");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/autofitrows';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'start_row'}) {
        $query_params->{'startRow'} = $self->{api_client}->to_query_value($args{'start_row'});
    }

    # query params
    if ( exists $args{'end_row'}) {
        $query_params->{'endRow'} = $self->{api_client}->to_query_value($args{'end_row'});
    }

    # query params
    if ( exists $args{'only_auto'}) {
        $query_params->{'onlyAuto'} = $self->{api_client}->to_query_value($args{'only_auto'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'auto_fitter_options'}) {
        $_body_data = $args{'auto_fitter_options'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_workbook_post_encrypt_document
#
# Encript document.
# 
# @param string $name The document name. (required)
# @param WorkbookEncryptionRequest $encryption Encryption parameters. (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'encryption' => {
        data_type => 'WorkbookEncryptionRequest',
        description => 'Encryption parameters.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_post_encrypt_document' } = { 
    	summary => 'Encript document.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_workbook_post_encrypt_document {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_post_encrypt_document");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/encryption';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'encryption'}) {
        $_body_data = $args{'encryption'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_workbook_post_import_data
#
# 
# 
# @param string $name  (required)
# @param String $importdata  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'importdata' => {
        data_type => 'String',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_post_import_data' } = { 
    	summary => '',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_workbook_post_import_data {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_post_import_data");
    }

    # verify the required parameter 'importdata' is set
    unless (exists $args{'importdata'}) {
      croak("Missing the required parameter 'importdata' when calling cells_workbook_post_import_data");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/importdata';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'importdata'}) {
        $_body_data = $args{'importdata'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_workbook_post_protect_document
#
# Protect document.
# 
# @param string $name The document name. (required)
# @param WorkbookProtectionRequest $protection The protection settings. (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'protection' => {
        data_type => 'WorkbookProtectionRequest',
        description => 'The protection settings.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_post_protect_document' } = { 
    	summary => 'Protect document.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_workbook_post_protect_document {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_post_protect_document");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/protection';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'protection'}) {
        $_body_data = $args{'protection'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_workbook_post_workbook_calculate_formula
#
# Calculate all formulas in workbook.
# 
# @param string $name Document name. (required)
# @param CalculationOptions $options Calculation Options. (optional)
# @param boolean $ignore_error ignore Error. (optional)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'options' => {
        data_type => 'CalculationOptions',
        description => 'Calculation Options.',
        required => '0',
    },
    'ignore_error' => {
        data_type => 'boolean',
        description => 'ignore Error.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_post_workbook_calculate_formula' } = { 
    	summary => 'Calculate all formulas in workbook.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_workbook_post_workbook_calculate_formula {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_post_workbook_calculate_formula");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/calculateformula';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'ignore_error'}) {
        $query_params->{'ignoreError'} = $self->{api_client}->to_query_value($args{'ignore_error'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'options'}) {
        $_body_data = $args{'options'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_workbook_post_workbook_get_smart_marker_result
#
# Smart marker processing result.
# 
# @param string $name The workbook name. (required)
# @param string $xml_file The xml file full path, if empty the data is read from request body. (optional)
# @param string $folder The workbook folder full path. (optional)
# @param string $storage storage name. (optional)
# @param string $out_path Path to save result (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'xml_file' => {
        data_type => 'string',
        description => 'The xml file full path, if empty the data is read from request body.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder full path.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    'out_path' => {
        data_type => 'string',
        description => 'Path to save result',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_post_workbook_get_smart_marker_result' } = { 
    	summary => 'Smart marker processing result.',
        params => $params,
        returns => 'string',
        };
}
# @return string
#
sub cells_workbook_post_workbook_get_smart_marker_result {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_post_workbook_get_smart_marker_result");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/smartmarker';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'xml_file'}) {
        $query_params->{'xmlFile'} = $self->{api_client}->to_query_value($args{'xml_file'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if ( exists $args{'out_path'}) {
        $query_params->{'outPath'} = $self->{api_client}->to_query_value($args{'out_path'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('string', $response);
    return $_response_object;
}

#
# cells_workbook_post_workbook_settings
#
# Update Workbook setting 
# 
# @param string $name Document name. (required)
# @param WorkbookSettings $settings Workbook Setting DTO (optional)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'settings' => {
        data_type => 'WorkbookSettings',
        description => 'Workbook Setting DTO',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_post_workbook_settings' } = { 
    	summary => 'Update Workbook setting ',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_workbook_post_workbook_settings {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_post_workbook_settings");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/settings';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'settings'}) {
        $_body_data = $args{'settings'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_workbook_post_workbook_split
#
# Split workbook.
# 
# @param string $name The workbook name. (required)
# @param string $format Split format. (optional)
# @param int $from Start worksheet index. (optional, default to 0)
# @param int $to End worksheet index. (optional, default to 0)
# @param int $horizontal_resolution Image horizontal resolution. (optional, default to 0)
# @param int $vertical_resolution Image vertical resolution. (optional, default to 0)
# @param string $folder The workbook folder. (optional)
# @param string $out_folder out Folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Split format.',
        required => '0',
    },
    'from' => {
        data_type => 'int',
        description => 'Start worksheet index.',
        required => '0',
    },
    'to' => {
        data_type => 'int',
        description => 'End worksheet index.',
        required => '0',
    },
    'horizontal_resolution' => {
        data_type => 'int',
        description => 'Image horizontal resolution.',
        required => '0',
    },
    'vertical_resolution' => {
        data_type => 'int',
        description => 'Image vertical resolution.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'out_folder' => {
        data_type => 'string',
        description => 'out Folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_post_workbook_split' } = { 
    	summary => 'Split workbook.',
        params => $params,
        returns => 'SplitResultResponse',
        };
}
# @return SplitResultResponse
#
sub cells_workbook_post_workbook_split {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_post_workbook_split");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/split';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'format'}) {
        $query_params->{'format'} = $self->{api_client}->to_query_value($args{'format'});
    }

    # query params
    if ( exists $args{'from'}) {
        $query_params->{'from'} = $self->{api_client}->to_query_value($args{'from'});
    }

    # query params
    if ( exists $args{'to'}) {
        $query_params->{'to'} = $self->{api_client}->to_query_value($args{'to'});
    }

    # query params
    if ( exists $args{'horizontal_resolution'}) {
        $query_params->{'horizontalResolution'} = $self->{api_client}->to_query_value($args{'horizontal_resolution'});
    }

    # query params
    if ( exists $args{'vertical_resolution'}) {
        $query_params->{'verticalResolution'} = $self->{api_client}->to_query_value($args{'vertical_resolution'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'out_folder'}) {
        $query_params->{'outFolder'} = $self->{api_client}->to_query_value($args{'out_folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SplitResultResponse', $response);
    return $_response_object;
}

#
# cells_workbook_post_workbooks_merge
#
# Merge workbooks.
# 
# @param string $name Workbook name. (required)
# @param string $merge_with The workbook to merge with. (required)
# @param string $folder Source workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'merge_with' => {
        data_type => 'string',
        description => 'The workbook to merge with.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Source workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_post_workbooks_merge' } = { 
    	summary => 'Merge workbooks.',
        params => $params,
        returns => 'WorkbookResponse',
        };
}
# @return WorkbookResponse
#
sub cells_workbook_post_workbooks_merge {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_post_workbooks_merge");
    }

    # verify the required parameter 'merge_with' is set
    unless (exists $args{'merge_with'}) {
      croak("Missing the required parameter 'merge_with' when calling cells_workbook_post_workbooks_merge");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/merge';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'merge_with'}) {
        $query_params->{'mergeWith'} = $self->{api_client}->to_query_value($args{'merge_with'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('WorkbookResponse', $response);
    return $_response_object;
}

#
# cells_workbook_post_workbooks_text_replace
#
# Replace text.
# 
# @param string $name Document name. (required)
# @param string $old_value The old value. (required)
# @param string $new_value The new value. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'old_value' => {
        data_type => 'string',
        description => 'The old value.',
        required => '1',
    },
    'new_value' => {
        data_type => 'string',
        description => 'The new value.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_post_workbooks_text_replace' } = { 
    	summary => 'Replace text.',
        params => $params,
        returns => 'WorkbookReplaceResponse',
        };
}
# @return WorkbookReplaceResponse
#
sub cells_workbook_post_workbooks_text_replace {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_post_workbooks_text_replace");
    }

    # verify the required parameter 'old_value' is set
    unless (exists $args{'old_value'}) {
      croak("Missing the required parameter 'old_value' when calling cells_workbook_post_workbooks_text_replace");
    }

    # verify the required parameter 'new_value' is set
    unless (exists $args{'new_value'}) {
      croak("Missing the required parameter 'new_value' when calling cells_workbook_post_workbooks_text_replace");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/replaceText';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'old_value'}) {
        $query_params->{'oldValue'} = $self->{api_client}->to_query_value($args{'old_value'});
    }

    # query params
    if ( exists $args{'new_value'}) {
        $query_params->{'newValue'} = $self->{api_client}->to_query_value($args{'new_value'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('WorkbookReplaceResponse', $response);
    return $_response_object;
}

#
# cells_workbook_post_workbooks_text_search
#
# Search text.
# 
# @param string $name Document name. (required)
# @param string $text Text sample. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'text' => {
        data_type => 'string',
        description => 'Text sample.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_post_workbooks_text_search' } = { 
    	summary => 'Search text.',
        params => $params,
        returns => 'TextItemsResponse',
        };
}
# @return TextItemsResponse
#
sub cells_workbook_post_workbooks_text_search {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_post_workbooks_text_search");
    }

    # verify the required parameter 'text' is set
    unless (exists $args{'text'}) {
      croak("Missing the required parameter 'text' when calling cells_workbook_post_workbooks_text_search");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/findText';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'text'}) {
        $query_params->{'text'} = $self->{api_client}->to_query_value($args{'text'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('TextItemsResponse', $response);
    return $_response_object;
}

#
# cells_workbook_put_convert_workbook
#
# Convert workbook from request content to some format.
# 
# @param string $workbook File to convert (required)
# @param string $format The format to convert. (optional)
# @param string $password The workbook password. (optional)
# @param string $out_path Path to save result (optional)
{
    my $params = {
    'workbook' => {
        data_type => 'string',
        description => 'File to convert',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'The format to convert.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'The workbook password.',
        required => '0',
    },
    'out_path' => {
        data_type => 'string',
        description => 'Path to save result',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_put_convert_workbook' } = { 
    	summary => 'Convert workbook from request content to some format.',
        params => $params,
        returns => 'string',
        };
}
# @return string
#
sub cells_workbook_put_convert_workbook {
    my ($self, %args) = @_;

    # verify the required parameter 'workbook' is set
    unless (exists $args{'workbook'}) {
      croak("Missing the required parameter 'workbook' when calling cells_workbook_put_convert_workbook");
    }

    # parse inputs
    my $_resource_path = '/cells/convert';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'format'}) {
        $query_params->{'format'} = $self->{api_client}->to_query_value($args{'format'});
    }

    # query params
    if ( exists $args{'password'}) {
        $query_params->{'password'} = $self->{api_client}->to_query_value($args{'password'});
    }

    # query params
    if ( exists $args{'out_path'}) {
        $query_params->{'outPath'} = $self->{api_client}->to_query_value($args{'out_path'});
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'workbook'}) {
        $_body_data = $args{'workbook'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('string', $response);
    return $_response_object;
}

#
# cells_workbook_put_document_protect_from_changes
#
# Protect document from changes.
# 
# @param string $name Document name. (required)
# @param PasswordRequest $password Modification password. (optional)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'PasswordRequest',
        description => 'Modification password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_put_document_protect_from_changes' } = { 
    	summary => 'Protect document from changes.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_workbook_put_document_protect_from_changes {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_put_document_protect_from_changes");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/writeProtection';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'password'}) {
        $_body_data = $args{'password'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_workbook_put_workbook_background
#
# Set workbook background image.
# 
# @param string $name  (required)
# @param string $png  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'png' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_put_workbook_background' } = { 
    	summary => 'Set workbook background image.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_workbook_put_workbook_background {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_put_workbook_background");
    }

    # verify the required parameter 'png' is set
    unless (exists $args{'png'}) {
      croak("Missing the required parameter 'png' when calling cells_workbook_put_workbook_background");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/background';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'png'}) {
        $_body_data = $args{'png'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_workbook_put_workbook_create
#
# Create new workbook using deferent methods.
# 
# @param string $name The new document name. (required)
# @param string $template_file The template file, if the data not provided default workbook is created. (optional)
# @param string $data_file Smart marker data file, if the data not provided the request content is checked for the data. (optional)
# @param boolean $is_write_over write over file. (optional)
# @param string $folder The new document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The new document name.',
        required => '1',
    },
    'template_file' => {
        data_type => 'string',
        description => 'The template file, if the data not provided default workbook is created.',
        required => '0',
    },
    'data_file' => {
        data_type => 'string',
        description => 'Smart marker data file, if the data not provided the request content is checked for the data.',
        required => '0',
    },
    'is_write_over' => {
        data_type => 'boolean',
        description => 'write over file.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The new document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_workbook_put_workbook_create' } = { 
    	summary => 'Create new workbook using deferent methods.',
        params => $params,
        returns => 'WorkbookResponse',
        };
}
# @return WorkbookResponse
#
sub cells_workbook_put_workbook_create {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_workbook_put_workbook_create");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'template_file'}) {
        $query_params->{'templateFile'} = $self->{api_client}->to_query_value($args{'template_file'});
    }

    # query params
    if ( exists $args{'data_file'}) {
        $query_params->{'dataFile'} = $self->{api_client}->to_query_value($args{'data_file'});
    }

    # query params
    if ( exists $args{'is_write_over'}) {
        $query_params->{'isWriteOver'} = $self->{api_client}->to_query_value($args{'is_write_over'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('WorkbookResponse', $response);
    return $_response_object;
}

#
# cells_worksheet_validations_delete_worksheet_validation
#
# Delete worksheet validation by index.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $validation_index The validation index. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'validation_index' => {
        data_type => 'int',
        description => 'The validation index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheet_validations_delete_worksheet_validation' } = { 
    	summary => 'Delete worksheet validation by index.',
        params => $params,
        returns => 'ValidationResponse',
        };
}
# @return ValidationResponse
#
sub cells_worksheet_validations_delete_worksheet_validation {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheet_validations_delete_worksheet_validation");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheet_validations_delete_worksheet_validation");
    }

    # verify the required parameter 'validation_index' is set
    unless (exists $args{'validation_index'}) {
      croak("Missing the required parameter 'validation_index' when calling cells_worksheet_validations_delete_worksheet_validation");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/validations/{validationIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'validation_index'}) {
        my $_base_variable = "{" . "validationIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'validation_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ValidationResponse', $response);
    return $_response_object;
}

#
# cells_worksheet_validations_delete_worksheet_validations
#
# Clear all validation in worksheet.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheet_validations_delete_worksheet_validations' } = { 
    	summary => 'Clear all validation in worksheet.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_worksheet_validations_delete_worksheet_validations {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheet_validations_delete_worksheet_validations");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheet_validations_delete_worksheet_validations");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/validations';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_worksheet_validations_get_worksheet_validation
#
# Get worksheet validation by index.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $validation_index The validation index. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'validation_index' => {
        data_type => 'int',
        description => 'The validation index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheet_validations_get_worksheet_validation' } = { 
    	summary => 'Get worksheet validation by index.',
        params => $params,
        returns => 'ValidationResponse',
        };
}
# @return ValidationResponse
#
sub cells_worksheet_validations_get_worksheet_validation {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheet_validations_get_worksheet_validation");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheet_validations_get_worksheet_validation");
    }

    # verify the required parameter 'validation_index' is set
    unless (exists $args{'validation_index'}) {
      croak("Missing the required parameter 'validation_index' when calling cells_worksheet_validations_get_worksheet_validation");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/validations/{validationIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'validation_index'}) {
        my $_base_variable = "{" . "validationIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'validation_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ValidationResponse', $response);
    return $_response_object;
}

#
# cells_worksheet_validations_get_worksheet_validations
#
# Get worksheet validations.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param string $folder Document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheet_validations_get_worksheet_validations' } = { 
    	summary => 'Get worksheet validations.',
        params => $params,
        returns => 'ValidationsResponse',
        };
}
# @return ValidationsResponse
#
sub cells_worksheet_validations_get_worksheet_validations {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheet_validations_get_worksheet_validations");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheet_validations_get_worksheet_validations");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/validations';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ValidationsResponse', $response);
    return $_response_object;
}

#
# cells_worksheet_validations_post_worksheet_validation
#
# Update worksheet validation by index.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $validation_index The validation index. (required)
# @param Validation $validation  (optional)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'validation_index' => {
        data_type => 'int',
        description => 'The validation index.',
        required => '1',
    },
    'validation' => {
        data_type => 'Validation',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheet_validations_post_worksheet_validation' } = { 
    	summary => 'Update worksheet validation by index.',
        params => $params,
        returns => 'ValidationResponse',
        };
}
# @return ValidationResponse
#
sub cells_worksheet_validations_post_worksheet_validation {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheet_validations_post_worksheet_validation");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheet_validations_post_worksheet_validation");
    }

    # verify the required parameter 'validation_index' is set
    unless (exists $args{'validation_index'}) {
      croak("Missing the required parameter 'validation_index' when calling cells_worksheet_validations_post_worksheet_validation");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/validations/{validationIndex}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'validation_index'}) {
        my $_base_variable = "{" . "validationIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'validation_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'validation'}) {
        $_body_data = $args{'validation'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ValidationResponse', $response);
    return $_response_object;
}

#
# cells_worksheet_validations_put_worksheet_validation
#
# Add worksheet validation at index.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param string $range Specified cells area (optional)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'range' => {
        data_type => 'string',
        description => 'Specified cells area',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheet_validations_put_worksheet_validation' } = { 
    	summary => 'Add worksheet validation at index.',
        params => $params,
        returns => 'ValidationResponse',
        };
}
# @return ValidationResponse
#
sub cells_worksheet_validations_put_worksheet_validation {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheet_validations_put_worksheet_validation");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheet_validations_put_worksheet_validation");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/validations';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'range'}) {
        $query_params->{'range'} = $self->{api_client}->to_query_value($args{'range'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ValidationResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_delete_unprotect_worksheet
#
# Unprotect worksheet.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param ProtectSheetParameter $protect_parameter with protection settings. Only password is used here. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'protect_parameter' => {
        data_type => 'ProtectSheetParameter',
        description => 'with protection settings. Only password is used here.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_delete_unprotect_worksheet' } = { 
    	summary => 'Unprotect worksheet.',
        params => $params,
        returns => 'WorksheetResponse',
        };
}
# @return WorksheetResponse
#
sub cells_worksheets_delete_unprotect_worksheet {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_delete_unprotect_worksheet");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_delete_unprotect_worksheet");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/protection';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'protect_parameter'}) {
        $_body_data = $args{'protect_parameter'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('WorksheetResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_delete_worksheet
#
# Delete worksheet.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_delete_worksheet' } = { 
    	summary => 'Delete worksheet.',
        params => $params,
        returns => 'WorksheetsResponse',
        };
}
# @return WorksheetsResponse
#
sub cells_worksheets_delete_worksheet {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_delete_worksheet");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_delete_worksheet");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('WorksheetsResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_delete_worksheet_background
#
# Set worksheet background image.
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_delete_worksheet_background' } = { 
    	summary => 'Set worksheet background image.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_worksheets_delete_worksheet_background {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_delete_worksheet_background");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_delete_worksheet_background");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/background';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_delete_worksheet_comment
#
# Delete worksheet's cell comment.
# 
# @param string $name The document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $cell_name The cell name (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'cell_name' => {
        data_type => 'string',
        description => 'The cell name',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_delete_worksheet_comment' } = { 
    	summary => 'Delete worksheet&#39;s cell comment.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_worksheets_delete_worksheet_comment {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_delete_worksheet_comment");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_delete_worksheet_comment");
    }

    # verify the required parameter 'cell_name' is set
    unless (exists $args{'cell_name'}) {
      croak("Missing the required parameter 'cell_name' when calling cells_worksheets_delete_worksheet_comment");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/comments/{cellName}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_name'}) {
        my $_base_variable = "{" . "cellName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_delete_worksheet_comments
#
# Delete all comments for worksheet.
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_delete_worksheet_comments' } = { 
    	summary => 'Delete all comments for worksheet.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_worksheets_delete_worksheet_comments {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_delete_worksheet_comments");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_delete_worksheet_comments");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/comments';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_delete_worksheet_freeze_panes
#
# Unfreeze panes
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $row  (required)
# @param int $column  (required)
# @param int $freezed_rows  (required)
# @param int $freezed_columns  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'row' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'column' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'freezed_rows' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'freezed_columns' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_delete_worksheet_freeze_panes' } = { 
    	summary => 'Unfreeze panes',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_worksheets_delete_worksheet_freeze_panes {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_delete_worksheet_freeze_panes");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_delete_worksheet_freeze_panes");
    }

    # verify the required parameter 'row' is set
    unless (exists $args{'row'}) {
      croak("Missing the required parameter 'row' when calling cells_worksheets_delete_worksheet_freeze_panes");
    }

    # verify the required parameter 'column' is set
    unless (exists $args{'column'}) {
      croak("Missing the required parameter 'column' when calling cells_worksheets_delete_worksheet_freeze_panes");
    }

    # verify the required parameter 'freezed_rows' is set
    unless (exists $args{'freezed_rows'}) {
      croak("Missing the required parameter 'freezed_rows' when calling cells_worksheets_delete_worksheet_freeze_panes");
    }

    # verify the required parameter 'freezed_columns' is set
    unless (exists $args{'freezed_columns'}) {
      croak("Missing the required parameter 'freezed_columns' when calling cells_worksheets_delete_worksheet_freeze_panes");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/freezepanes';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'row'}) {
        $query_params->{'row'} = $self->{api_client}->to_query_value($args{'row'});
    }

    # query params
    if ( exists $args{'column'}) {
        $query_params->{'column'} = $self->{api_client}->to_query_value($args{'column'});
    }

    # query params
    if ( exists $args{'freezed_rows'}) {
        $query_params->{'freezedRows'} = $self->{api_client}->to_query_value($args{'freezed_rows'});
    }

    # query params
    if ( exists $args{'freezed_columns'}) {
        $query_params->{'freezedColumns'} = $self->{api_client}->to_query_value($args{'freezed_columns'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_get_named_ranges
#
# Read worksheets ranges info.
# 
# @param string $name Document name. (required)
# @param string $folder Document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_get_named_ranges' } = { 
    	summary => 'Read worksheets ranges info.',
        params => $params,
        returns => 'RangesResponse',
        };
}
# @return RangesResponse
#
sub cells_worksheets_get_named_ranges {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_get_named_ranges");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/ranges';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('RangesResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_get_worksheet
#
# Read worksheet info or export.
# 
# @param string $name The document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $format The exported file format. (optional)
# @param int $vertical_resolution Image vertical resolution. (optional, default to 0)
# @param int $horizontal_resolution Image horizontal resolution. (optional, default to 0)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'The exported file format.',
        required => '0',
    },
    'vertical_resolution' => {
        data_type => 'int',
        description => 'Image vertical resolution.',
        required => '0',
    },
    'horizontal_resolution' => {
        data_type => 'int',
        description => 'Image horizontal resolution.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_get_worksheet' } = { 
    	summary => 'Read worksheet info or export.',
        params => $params,
        returns => 'string',
        };
}
# @return string
#
sub cells_worksheets_get_worksheet {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_get_worksheet");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_get_worksheet");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'format'}) {
        $query_params->{'format'} = $self->{api_client}->to_query_value($args{'format'});
    }

    # query params
    if ( exists $args{'vertical_resolution'}) {
        $query_params->{'verticalResolution'} = $self->{api_client}->to_query_value($args{'vertical_resolution'});
    }

    # query params
    if ( exists $args{'horizontal_resolution'}) {
        $query_params->{'horizontalResolution'} = $self->{api_client}->to_query_value($args{'horizontal_resolution'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('string', $response);
    return $_response_object;
}

#
# cells_worksheets_get_worksheet_calculate_formula
#
# Calculate formula value.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param string $formula The formula. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'formula' => {
        data_type => 'string',
        description => 'The formula.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_get_worksheet_calculate_formula' } = { 
    	summary => 'Calculate formula value.',
        params => $params,
        returns => 'SingleValueResponse',
        };
}
# @return SingleValueResponse
#
sub cells_worksheets_get_worksheet_calculate_formula {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_get_worksheet_calculate_formula");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_get_worksheet_calculate_formula");
    }

    # verify the required parameter 'formula' is set
    unless (exists $args{'formula'}) {
      croak("Missing the required parameter 'formula' when calling cells_worksheets_get_worksheet_calculate_formula");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/formulaResult';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'formula'}) {
        $query_params->{'formula'} = $self->{api_client}->to_query_value($args{'formula'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SingleValueResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_get_worksheet_comment
#
# Get worksheet comment by cell name.
# 
# @param string $name The document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $cell_name The cell name (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'cell_name' => {
        data_type => 'string',
        description => 'The cell name',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_get_worksheet_comment' } = { 
    	summary => 'Get worksheet comment by cell name.',
        params => $params,
        returns => 'CommentResponse',
        };
}
# @return CommentResponse
#
sub cells_worksheets_get_worksheet_comment {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_get_worksheet_comment");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_get_worksheet_comment");
    }

    # verify the required parameter 'cell_name' is set
    unless (exists $args{'cell_name'}) {
      croak("Missing the required parameter 'cell_name' when calling cells_worksheets_get_worksheet_comment");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/comments/{cellName}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_name'}) {
        my $_base_variable = "{" . "cellName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CommentResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_get_worksheet_comments
#
# Get worksheet comments.
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_get_worksheet_comments' } = { 
    	summary => 'Get worksheet comments.',
        params => $params,
        returns => 'CommentsResponse',
        };
}
# @return CommentsResponse
#
sub cells_worksheets_get_worksheet_comments {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_get_worksheet_comments");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_get_worksheet_comments");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/comments';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CommentsResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_get_worksheet_merged_cell
#
# Get worksheet merged cell by its index.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $merged_cell_index Merged cell index. (required)
# @param string $folder Document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'merged_cell_index' => {
        data_type => 'int',
        description => 'Merged cell index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_get_worksheet_merged_cell' } = { 
    	summary => 'Get worksheet merged cell by its index.',
        params => $params,
        returns => 'MergedCellResponse',
        };
}
# @return MergedCellResponse
#
sub cells_worksheets_get_worksheet_merged_cell {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_get_worksheet_merged_cell");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_get_worksheet_merged_cell");
    }

    # verify the required parameter 'merged_cell_index' is set
    unless (exists $args{'merged_cell_index'}) {
      croak("Missing the required parameter 'merged_cell_index' when calling cells_worksheets_get_worksheet_merged_cell");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/mergedCells/{mergedCellIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'merged_cell_index'}) {
        my $_base_variable = "{" . "mergedCellIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'merged_cell_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('MergedCellResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_get_worksheet_merged_cells
#
# Get worksheet merged cells.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The workseet name. (required)
# @param string $folder Document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The workseet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_get_worksheet_merged_cells' } = { 
    	summary => 'Get worksheet merged cells.',
        params => $params,
        returns => 'MergedCellsResponse',
        };
}
# @return MergedCellsResponse
#
sub cells_worksheets_get_worksheet_merged_cells {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_get_worksheet_merged_cells");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_get_worksheet_merged_cells");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/mergedCells';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('MergedCellsResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_get_worksheet_text_items
#
# Get worksheet text items.
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $folder The workbook&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_get_worksheet_text_items' } = { 
    	summary => 'Get worksheet text items.',
        params => $params,
        returns => 'TextItemsResponse',
        };
}
# @return TextItemsResponse
#
sub cells_worksheets_get_worksheet_text_items {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_get_worksheet_text_items");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_get_worksheet_text_items");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/textItems';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('TextItemsResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_get_worksheets
#
# Read worksheets info.
# 
# @param string $name Document name. (required)
# @param string $folder Document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_get_worksheets' } = { 
    	summary => 'Read worksheets info.',
        params => $params,
        returns => 'WorksheetsResponse',
        };
}
# @return WorksheetsResponse
#
sub cells_worksheets_get_worksheets {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_get_worksheets");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('WorksheetsResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_post_autofit_worksheet_columns
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $first_column  (required)
# @param int $last_column  (required)
# @param AutoFitterOptions $auto_fitter_options  (optional)
# @param int $first_row  (optional)
# @param int $last_row  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'first_column' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'last_column' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'auto_fitter_options' => {
        data_type => 'AutoFitterOptions',
        description => '',
        required => '0',
    },
    'first_row' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'last_row' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_post_autofit_worksheet_columns' } = { 
    	summary => '',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_worksheets_post_autofit_worksheet_columns {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_post_autofit_worksheet_columns");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_post_autofit_worksheet_columns");
    }

    # verify the required parameter 'first_column' is set
    unless (exists $args{'first_column'}) {
      croak("Missing the required parameter 'first_column' when calling cells_worksheets_post_autofit_worksheet_columns");
    }

    # verify the required parameter 'last_column' is set
    unless (exists $args{'last_column'}) {
      croak("Missing the required parameter 'last_column' when calling cells_worksheets_post_autofit_worksheet_columns");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autofitcolumns';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'first_column'}) {
        $query_params->{'firstColumn'} = $self->{api_client}->to_query_value($args{'first_column'});
    }

    # query params
    if ( exists $args{'last_column'}) {
        $query_params->{'lastColumn'} = $self->{api_client}->to_query_value($args{'last_column'});
    }

    # query params
    if ( exists $args{'first_row'}) {
        $query_params->{'firstRow'} = $self->{api_client}->to_query_value($args{'first_row'});
    }

    # query params
    if ( exists $args{'last_row'}) {
        $query_params->{'lastRow'} = $self->{api_client}->to_query_value($args{'last_row'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'auto_fitter_options'}) {
        $_body_data = $args{'auto_fitter_options'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_post_autofit_worksheet_row
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $row_index  (required)
# @param int $first_column  (required)
# @param int $last_column  (required)
# @param AutoFitterOptions $auto_fitter_options  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'row_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'first_column' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'last_column' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'auto_fitter_options' => {
        data_type => 'AutoFitterOptions',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_post_autofit_worksheet_row' } = { 
    	summary => '',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_worksheets_post_autofit_worksheet_row {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_post_autofit_worksheet_row");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_post_autofit_worksheet_row");
    }

    # verify the required parameter 'row_index' is set
    unless (exists $args{'row_index'}) {
      croak("Missing the required parameter 'row_index' when calling cells_worksheets_post_autofit_worksheet_row");
    }

    # verify the required parameter 'first_column' is set
    unless (exists $args{'first_column'}) {
      croak("Missing the required parameter 'first_column' when calling cells_worksheets_post_autofit_worksheet_row");
    }

    # verify the required parameter 'last_column' is set
    unless (exists $args{'last_column'}) {
      croak("Missing the required parameter 'last_column' when calling cells_worksheets_post_autofit_worksheet_row");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autofitrow';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'row_index'}) {
        $query_params->{'rowIndex'} = $self->{api_client}->to_query_value($args{'row_index'});
    }

    # query params
    if ( exists $args{'first_column'}) {
        $query_params->{'firstColumn'} = $self->{api_client}->to_query_value($args{'first_column'});
    }

    # query params
    if ( exists $args{'last_column'}) {
        $query_params->{'lastColumn'} = $self->{api_client}->to_query_value($args{'last_column'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'auto_fitter_options'}) {
        $_body_data = $args{'auto_fitter_options'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_post_autofit_worksheet_rows
#
# Autofit worksheet rows.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param AutoFitterOptions $auto_fitter_options Auto Fitter Options. (optional)
# @param int $start_row Start row. (optional)
# @param int $end_row End row. (optional)
# @param boolean $only_auto Only auto. (optional, default to false)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'auto_fitter_options' => {
        data_type => 'AutoFitterOptions',
        description => 'Auto Fitter Options.',
        required => '0',
    },
    'start_row' => {
        data_type => 'int',
        description => 'Start row.',
        required => '0',
    },
    'end_row' => {
        data_type => 'int',
        description => 'End row.',
        required => '0',
    },
    'only_auto' => {
        data_type => 'boolean',
        description => 'Only auto.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_post_autofit_worksheet_rows' } = { 
    	summary => 'Autofit worksheet rows.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_worksheets_post_autofit_worksheet_rows {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_post_autofit_worksheet_rows");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_post_autofit_worksheet_rows");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autofitrows';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'start_row'}) {
        $query_params->{'startRow'} = $self->{api_client}->to_query_value($args{'start_row'});
    }

    # query params
    if ( exists $args{'end_row'}) {
        $query_params->{'endRow'} = $self->{api_client}->to_query_value($args{'end_row'});
    }

    # query params
    if ( exists $args{'only_auto'}) {
        $query_params->{'onlyAuto'} = $self->{api_client}->to_query_value($args{'only_auto'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'auto_fitter_options'}) {
        $_body_data = $args{'auto_fitter_options'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_post_copy_worksheet
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $source_sheet  (required)
# @param CopyOptions $options  (optional)
# @param string $source_workbook  (optional)
# @param string $source_folder  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'source_sheet' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'options' => {
        data_type => 'CopyOptions',
        description => '',
        required => '0',
    },
    'source_workbook' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'source_folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_post_copy_worksheet' } = { 
    	summary => '',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_worksheets_post_copy_worksheet {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_post_copy_worksheet");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_post_copy_worksheet");
    }

    # verify the required parameter 'source_sheet' is set
    unless (exists $args{'source_sheet'}) {
      croak("Missing the required parameter 'source_sheet' when calling cells_worksheets_post_copy_worksheet");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/copy';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'source_sheet'}) {
        $query_params->{'sourceSheet'} = $self->{api_client}->to_query_value($args{'source_sheet'});
    }

    # query params
    if ( exists $args{'source_workbook'}) {
        $query_params->{'sourceWorkbook'} = $self->{api_client}->to_query_value($args{'source_workbook'});
    }

    # query params
    if ( exists $args{'source_folder'}) {
        $query_params->{'sourceFolder'} = $self->{api_client}->to_query_value($args{'source_folder'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'options'}) {
        $_body_data = $args{'options'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_post_move_worksheet
#
# Move worksheet.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param WorksheetMovingRequest $moving with moving parameters. (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'moving' => {
        data_type => 'WorksheetMovingRequest',
        description => 'with moving parameters.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_post_move_worksheet' } = { 
    	summary => 'Move worksheet.',
        params => $params,
        returns => 'WorksheetsResponse',
        };
}
# @return WorksheetsResponse
#
sub cells_worksheets_post_move_worksheet {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_post_move_worksheet");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_post_move_worksheet");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/position';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'moving'}) {
        $_body_data = $args{'moving'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('WorksheetsResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_post_rename_worksheet
#
# Rename worksheet
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $newname  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'newname' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_post_rename_worksheet' } = { 
    	summary => 'Rename worksheet',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_worksheets_post_rename_worksheet {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_post_rename_worksheet");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_post_rename_worksheet");
    }

    # verify the required parameter 'newname' is set
    unless (exists $args{'newname'}) {
      croak("Missing the required parameter 'newname' when calling cells_worksheets_post_rename_worksheet");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/rename';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'newname'}) {
        $query_params->{'newname'} = $self->{api_client}->to_query_value($args{'newname'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_post_update_worksheet_property
#
# Update worksheet property
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param Worksheet $sheet  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet' => {
        data_type => 'Worksheet',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_post_update_worksheet_property' } = { 
    	summary => 'Update worksheet property',
        params => $params,
        returns => 'WorksheetResponse',
        };
}
# @return WorksheetResponse
#
sub cells_worksheets_post_update_worksheet_property {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_post_update_worksheet_property");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_post_update_worksheet_property");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'sheet'}) {
        $_body_data = $args{'sheet'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('WorksheetResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_post_update_worksheet_zoom
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $value  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'value' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_post_update_worksheet_zoom' } = { 
    	summary => '',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_worksheets_post_update_worksheet_zoom {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_post_update_worksheet_zoom");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_post_update_worksheet_zoom");
    }

    # verify the required parameter 'value' is set
    unless (exists $args{'value'}) {
      croak("Missing the required parameter 'value' when calling cells_worksheets_post_update_worksheet_zoom");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/zoom';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'value'}) {
        $query_params->{'value'} = $self->{api_client}->to_query_value($args{'value'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_post_worksheet_comment
#
# Update worksheet's cell comment.
# 
# @param string $name The document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $cell_name The cell name (required)
# @param Comment $comment Comment object (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'cell_name' => {
        data_type => 'string',
        description => 'The cell name',
        required => '1',
    },
    'comment' => {
        data_type => 'Comment',
        description => 'Comment object',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_post_worksheet_comment' } = { 
    	summary => 'Update worksheet&#39;s cell comment.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_worksheets_post_worksheet_comment {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_post_worksheet_comment");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_post_worksheet_comment");
    }

    # verify the required parameter 'cell_name' is set
    unless (exists $args{'cell_name'}) {
      croak("Missing the required parameter 'cell_name' when calling cells_worksheets_post_worksheet_comment");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/comments/{cellName}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_name'}) {
        my $_base_variable = "{" . "cellName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'comment'}) {
        $_body_data = $args{'comment'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_post_worksheet_range_sort
#
# Sort worksheet range.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $cell_area The range to sort. (required)
# @param DataSorter $data_sorter with sorting settings. (optional)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'cell_area' => {
        data_type => 'string',
        description => 'The range to sort.',
        required => '1',
    },
    'data_sorter' => {
        data_type => 'DataSorter',
        description => 'with sorting settings.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_post_worksheet_range_sort' } = { 
    	summary => 'Sort worksheet range.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_worksheets_post_worksheet_range_sort {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_post_worksheet_range_sort");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_post_worksheet_range_sort");
    }

    # verify the required parameter 'cell_area' is set
    unless (exists $args{'cell_area'}) {
      croak("Missing the required parameter 'cell_area' when calling cells_worksheets_post_worksheet_range_sort");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/sort';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'cell_area'}) {
        $query_params->{'cellArea'} = $self->{api_client}->to_query_value($args{'cell_area'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'data_sorter'}) {
        $_body_data = $args{'data_sorter'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_post_worksheet_text_search
#
# Search text.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $text Text to search. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'text' => {
        data_type => 'string',
        description => 'Text to search.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_post_worksheet_text_search' } = { 
    	summary => 'Search text.',
        params => $params,
        returns => 'TextItemsResponse',
        };
}
# @return TextItemsResponse
#
sub cells_worksheets_post_worksheet_text_search {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_post_worksheet_text_search");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_post_worksheet_text_search");
    }

    # verify the required parameter 'text' is set
    unless (exists $args{'text'}) {
      croak("Missing the required parameter 'text' when calling cells_worksheets_post_worksheet_text_search");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/findText';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'text'}) {
        $query_params->{'text'} = $self->{api_client}->to_query_value($args{'text'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('TextItemsResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_post_worsheet_text_replace
#
# Replace text.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param string $old_value The old text to replace. (required)
# @param string $new_value The new text to replace by. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'old_value' => {
        data_type => 'string',
        description => 'The old text to replace.',
        required => '1',
    },
    'new_value' => {
        data_type => 'string',
        description => 'The new text to replace by.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_post_worsheet_text_replace' } = { 
    	summary => 'Replace text.',
        params => $params,
        returns => 'WorksheetReplaceResponse',
        };
}
# @return WorksheetReplaceResponse
#
sub cells_worksheets_post_worsheet_text_replace {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_post_worsheet_text_replace");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_post_worsheet_text_replace");
    }

    # verify the required parameter 'old_value' is set
    unless (exists $args{'old_value'}) {
      croak("Missing the required parameter 'old_value' when calling cells_worksheets_post_worsheet_text_replace");
    }

    # verify the required parameter 'new_value' is set
    unless (exists $args{'new_value'}) {
      croak("Missing the required parameter 'new_value' when calling cells_worksheets_post_worsheet_text_replace");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/replaceText';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'old_value'}) {
        $query_params->{'oldValue'} = $self->{api_client}->to_query_value($args{'old_value'});
    }

    # query params
    if ( exists $args{'new_value'}) {
        $query_params->{'newValue'} = $self->{api_client}->to_query_value($args{'new_value'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('WorksheetReplaceResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_put_add_new_worksheet
#
# Add new worksheet.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The new sheet name. (required)
# @param int $position The new sheet position. (optional)
# @param string $sheettype The new sheet type. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The new sheet name.',
        required => '1',
    },
    'position' => {
        data_type => 'int',
        description => 'The new sheet position.',
        required => '0',
    },
    'sheettype' => {
        data_type => 'string',
        description => 'The new sheet type.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_put_add_new_worksheet' } = { 
    	summary => 'Add new worksheet.',
        params => $params,
        returns => 'WorksheetsResponse',
        };
}
# @return WorksheetsResponse
#
sub cells_worksheets_put_add_new_worksheet {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_put_add_new_worksheet");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_put_add_new_worksheet");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'position'}) {
        $query_params->{'position'} = $self->{api_client}->to_query_value($args{'position'});
    }

    # query params
    if ( exists $args{'sheettype'}) {
        $query_params->{'sheettype'} = $self->{api_client}->to_query_value($args{'sheettype'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('WorksheetsResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_put_change_visibility_worksheet
#
# Change worksheet visibility.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param boolean $is_visible New worksheet visibility value. (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'is_visible' => {
        data_type => 'boolean',
        description => 'New worksheet visibility value.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_put_change_visibility_worksheet' } = { 
    	summary => 'Change worksheet visibility.',
        params => $params,
        returns => 'WorksheetResponse',
        };
}
# @return WorksheetResponse
#
sub cells_worksheets_put_change_visibility_worksheet {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_put_change_visibility_worksheet");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_put_change_visibility_worksheet");
    }

    # verify the required parameter 'is_visible' is set
    unless (exists $args{'is_visible'}) {
      croak("Missing the required parameter 'is_visible' when calling cells_worksheets_put_change_visibility_worksheet");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/visible';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'is_visible'}) {
        $query_params->{'isVisible'} = $self->{api_client}->to_query_value($args{'is_visible'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('WorksheetResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_put_protect_worksheet
#
# Protect worksheet.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param ProtectSheetParameter $protect_parameter with protection settings. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'protect_parameter' => {
        data_type => 'ProtectSheetParameter',
        description => 'with protection settings.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_put_protect_worksheet' } = { 
    	summary => 'Protect worksheet.',
        params => $params,
        returns => 'WorksheetResponse',
        };
}
# @return WorksheetResponse
#
sub cells_worksheets_put_protect_worksheet {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_put_protect_worksheet");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_put_protect_worksheet");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/protection';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'protect_parameter'}) {
        $_body_data = $args{'protect_parameter'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('WorksheetResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_put_worksheet_background
#
# Set worksheet background image.
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $png  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'png' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_put_worksheet_background' } = { 
    	summary => 'Set worksheet background image.',
        params => $params,
        returns => 'CellsCloudResponse',
        };
}
# @return CellsCloudResponse
#
sub cells_worksheets_put_worksheet_background {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_put_worksheet_background");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_put_worksheet_background");
    }

    # verify the required parameter 'png' is set
    unless (exists $args{'png'}) {
      croak("Missing the required parameter 'png' when calling cells_worksheets_put_worksheet_background");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/background';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'png'}) {
        $_body_data = $args{'png'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CellsCloudResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_put_worksheet_comment
#
# Add worksheet's cell comment.
# 
# @param string $name The document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $cell_name The cell name (required)
# @param Comment $comment Comment object (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'cell_name' => {
        data_type => 'string',
        description => 'The cell name',
        required => '1',
    },
    'comment' => {
        data_type => 'Comment',
        description => 'Comment object',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_put_worksheet_comment' } = { 
    	summary => 'Add worksheet&#39;s cell comment.',
        params => $params,
        returns => 'CommentResponse',
        };
}
# @return CommentResponse
#
sub cells_worksheets_put_worksheet_comment {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_put_worksheet_comment");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_put_worksheet_comment");
    }

    # verify the required parameter 'cell_name' is set
    unless (exists $args{'cell_name'}) {
      croak("Missing the required parameter 'cell_name' when calling cells_worksheets_put_worksheet_comment");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/comments/{cellName}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_name'}) {
        my $_base_variable = "{" . "cellName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    $self->{api_client}->check_access_token();
    my $_body_data;
    # body params
    if ( exists $args{'comment'}) {
        $_body_data = $args{'comment'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CommentResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_put_worksheet_freeze_panes
#
# Set freeze panes
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $row  (required)
# @param int $column  (required)
# @param int $freezed_rows  (required)
# @param int $freezed_columns  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'row' => {
