.\" Copyright (c) 1985, 1987, 1990 Regents of the University of California.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms are permitted provided
.\" that: (1) source distributions retain this entire copyright notice and
.\" comment, and (2) distributions including binaries display the following
.\" acknowledgement:  ``This product includes software developed by the
.\" University of California, Berkeley and its contributors'' in the
.\" documentation or other materials provided with the distribution and in
.\" all advertising materials mentioning features or use of this software.
.\" Neither the name of the University nor the names of its contributors may
.\" be used to endorse or promote products derived from this software without
.\" specific prior written permission.
.\" THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
.\" WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
.\" MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
.\"
.\"     @(#)vacation.1	6.8 (Berkeley) 6/24/90
.\"
.TH VACATION 1 "February 7, 1989"
.UC 6
.SH NAME
vacation \- reply to mail automatically
.SH SYNOPSIS
.B vacation
start
.br
.B vacation
stop
.br
.B vacation
.B -i
[
.B -r
interval ]
.br
.B vacation
[
.B -a
alias ] login
.SH DESCRIPTION
.I Vacation
returns a message to the sender of a message telling them that you
are currently not reading your mail.  The intended use is in a
.I .forward
file.  For example, your
.I .forward
file might have:
.PP
.ti +5
eric, "|$MAILBIN/bin/vacation -a allman eric"
.PP
which would send messages to you (assuming your login name was eric) and
reply to any messages for ``eric'' or ``allman''.
.PP
No message will be sent unless
.I login
(or an
.I alias
supplied using the
.B -a
option) is part of either the ``To:'' or ``Cc:'' headers of the mail.
No messages from ``???-REQUEST'', ``Postmaster'', ``UUCP'', ``MAILER'',
or ``MAILER-DAEMON'' will be replied to (where these strings are
case insensitive) nor is a notification sent if a ``Precedence: bulk''
or ``Precedence: junk'' line is included in the mail headers.
.SH USAGE
.LP
To start
.IR vacation ,
run the command
.br
	vacation start
.br
It will create a 
.I \&.vacation.msg
file (if you don't already have one) in your home directory containing the
message you want to send people who send you mail, and a 
.I \&.forward
file in your home directory containing a line of the form:
.IP
\fL\fIname\fL, "|$MAILBIN/bin/vacation \fIname\fL"\fR
.LP
where 
.I name
is your login name.
.LP
To stop
.IR vacation ,
run the command
.br
	vacation stop
.br
It will move the
.I \&.forward
file to
.I \&.vacforward,
and the automatic replies will stop.
.PP
The people who have sent you messages are maintained as an
.IR ndbm (3)
database in the files
.I .vacation.pag
and
.I .vacation.dir
in your home directory.
.PP
The
.B -i
flag initializes the vacation database files.  It should be used
before you modify your
.I .forward
file.
.PP
The
.B -r
flag sets the reply interval to
.I interval
days.  The default is one week.  An interval of ``0'' means that
a reply is sent to each message, and an interval of ``infinite''
(actually, any non-numeric character) will never send more than
one reply.  It should be noted that intervals of ``0'' are quite
dangerous, as it allows mailers to get into ``I am on vacation''
loops.
.PP
.I Vacation
expects a file
.IR .vacation.msg ,
in your home directory, containing a message to be sent back to each
sender.  It should be an entire message (including headers).  For
example, it might contain:
.PP
.in +5
.nf
From: eric@ucbmonet.Berkeley.EDU (Eric Allman)
Subject: I am on vacation
Delivered-By-The-Graces-Of: The Vacation program
Precedence: bulk

I am on vacation until July 22.  If you have something urgent,
please contact Joe Kalash <kalash@ucbingres.Berkeley.EDU>.
	--eric
.fi
.in -5
.PP
.I Vacation
reads the first line from the standard input for a \s-1UNIX\s0-style
``From'' line to determine the sender.
.IR Sendmail (8)
includes this ``From'' line automatically.
.PP
Fatal errors, such as calling
.I vacation
with incorrect arguments, or with non-existent
.IR login s,
are logged in the system log file, using
.IR syslog (8).
.SH FILES
.nf
.ta \w'~/.vacation.msg    'u
~/.vacation.dir	database file
~/.vacation.msg	message to send
~/.vacation.pag	database file
.fi
.SH "SEE ALSO"
sendmail(8), syslog(8)
