/* Semantic Operations */

typedef enum {
	oCall = 0,					/* 0 */
	oReturn,					/* 1 */
	oRuleEnd,					/* 2 */
	oJump,						/* 3 */
	oInput,						/* 4 */
	oInputAny,					/* 5 */
	oInputChoice,					/* 6 */
	oEmit,						/* 7 */
	oError,						/* 8 */
	oChoice,					/* 9 */
	oChoiceEnd,					/* 10 */
	oSetParameter,					/* 11 */
	oSetResult,					/* 12 */
	oSetResultFromInput,				/* 13 */
	oIdentWord,					/* 14 */
	oIdentifyKeyword,				/* 15 */
	oUngetKeyword,					/* 16 */
	oBufferClear,					/* 17 */
	oBufferAppend,					/* 18 */
	oBufferAppendCaret,				/* 19 */
	oBufferAppendDollar,				/* 20 */
	oBufferTerminate,				/* 21 */
	oBufferEmit,					/* 22 */
	oBufferEmitPattern,				/* 23 */
	oBufferUsed,					/* 24 */
	oBranchPushNullOrigin,				/* 25 */
	oBranchPushOrigin,				/* 26 */
	oBranchPatch,					/* 27 */
	oBranchPatchBack,				/* 28 */
	oBranchPopOrigin,				/* 29 */
	oBranchSwapTop,					/* 30 */
	oEmitBranchOrigin,				/* 31 */
	oHereSaveStop,					/* 32 */
	oHereCompareStop,				/* 33 */
	oHereCutBuffer,					/* 34 */
	oFlagsPush,					/* 35 */
	oFlagsPop,					/* 36 */
	oFlagsSet,					/* 37 */
	oFlagsTest,					/* 38 */
	oCounterIncrement,				/* 39 */
	oCounterDecrement,				/* 40 */
	oCounterClear,					/* 41 */
	oCounterTest,					/* 42 */
	lastOfTableOperation
} TableOperation;

/* Input Tokens */

typedef enum {
	tSyntaxError = -1,				/* -1 */
	tAmpersand,					/* 0 */
	tAnd,						/* 1 */
	tAngleLeft,					/* 2 */
	tAngleRight,					/* 3 */
	tAppendLeft,					/* 4 */
	tAppendRight,					/* 5 */
	tAt,						/* 6 */
	tBackQuote,					/* 7 */
	tBackQuoteLeft,					/* 8 */
	tBackSlash,					/* 9 */
	tBraceLeft,					/* 10 */
	tBraceRight,					/* 11 */
	tCaret,						/* 12 */
	tComma,						/* 13 */
	tColon,						/* 14 */
	tDash,						/* 15 */
	tDigit,						/* 16 */
	tDollar,					/* 17 */
	tDoubleQuote,					/* 18 */
	tEndOfFile,					/* 19 */
	tEqual,						/* 20 */
	tExclamation,					/* 21 */
	tLabelEnd,					/* 22 */
	tLetter,					/* 23 */
	tNewLine,					/* 24 */
	tOr,						/* 25 */
	tParenLeft,					/* 26 */
	tParenRight,					/* 27 */
	tPercent,					/* 28 */
	tPeriod,					/* 29 */
	tPlus,						/* 30 */
	tPipe,						/* 31 */
	tSemicolon,					/* 32 */
	tSharp,						/* 33 */
	tSingleQuote,					/* 34 */
	tSlash,						/* 35 */
	tSquareLeft,					/* 36 */
	tSquareRight,					/* 37 */
	tStar,						/* 38 */
	tTilde,						/* 39 */
	tQuestionMark,					/* 40 */
	tUnderscore,					/* 41 */
	tWhiteSpace,					/* 42 */
	lastOfInputTokens
} InputTokens;

/* Output Tokens */

typedef enum {
	sBufferSet = 0,					/* 0 */
	sBufferAppend,					/* 1 */
	sBufferExpand,					/* 2 */
	sBufferQuote,					/* 3 */
	sBufferSetFromArgV,				/* 4 */
	sArgVpush,					/* 5 */
	sArgList,					/* 6 */
	sVariablePush,					/* 7 */
	sVariablePop,					/* 8 */
	sVariableCdr,					/* 9 */
	sVariableBuffer,				/* 10 */
	sVariableAppend,				/* 11 */
	sVariableLoopAttach,				/* 12 */
	sCommandPush,					/* 13 */
	sCommandPop,					/* 14 */
	sCommandCarryBuffer,				/* 15 */
	sIOopen,					/* 16 */
	sIOopenString,					/* 17 */
	sIOopenPortal,					/* 18 */
	sIOopenPipe,					/* 19 */
	sIOintoBuffer,					/* 20 */
	sIOclose,					/* 21 */
	sIOdup,						/* 22 */
	sIOsetIn,					/* 23 */
	sIOsetInOut,					/* 24 */
	sIOsetOut,					/* 25 */
	sIOsetAppend,					/* 26 */
	sIOsetDesc,					/* 27 */
	sIObufIn,					/* 28 */
	sIObufOut,					/* 29 */
	sIObufFree,					/* 30 */
	sIObufString,					/* 31 */
	sAssign,					/* 32 */
	sAssignTemporary,				/* 33 */
	sFunction,					/* 34 */
	sParameter,					/* 35 */
	sJump,						/* 36 */
	sBranchOrigin,					/* 37 */
	sJumpFork,					/* 38 */
	sJumpIfFailure,					/* 39 */
	sJumpIfSuccess,					/* 40 */
	sJumpIfNilVariable,				/* 41 */
	sJumpIfMatch,					/* 42 */
	sJumpIfFindVarNil,				/* 43 */
	sJumpIfOrValueNil,				/* 44 */
	sJumpLoopBreak,					/* 45 */
	sJumpLoopContinue,				/* 46 */
	sLoopEnter,					/* 47 */
	sLoopExit,					/* 48 */
	sLocalVariable,					/* 49 */
	sScopePush,					/* 50 */
	sScopePop,					/* 51 */
	sDollarExpand,					/* 52 */
	sNoOp,						/* 53 */
	sPrintAndExit,					/* 54 */
	sBackground,					/* 55 */
	sSiftPush,					/* 56 */
	sSiftBody,					/* 57 */
	sSiftCompileRegexp,				/* 58 */
	sSiftReevaluate,				/* 59 */
	sSiftPop,					/* 60 */
	sSiftBufferAppend,				/* 61 */
	sJumpIfRegmatch,				/* 62 */
	lastOfOutputTokens
} OutputTokens;

/* Input/Output Tokens */


/* Error Codes */

typedef enum {
	eNoError = 0,					/* 0 */
	eSyntaxError,					/* 1 */
	ePrematureEndOfFile,				/* 2 */
	eExtraneousProgramText,				/* 3 */
	eFirstUserError = 10,				/* 10 */
	eIllegalArgumentSeparator = 10,			/* 10 */
	eMissingDo,					/* 11 */
	eMissingDoOrIn,					/* 12 */
	eMissingDone,					/* 13 */
	eMissingEndOfPattern,				/* 14 */
	eMissingEsac,					/* 15 */
	eMissingFi,					/* 16 */
	eMissingIOopTarget,				/* 17 */
	eMissingKeywordIn,				/* 18 */
	eMissingThen,					/* 19 */
	eMissingRightBrace,				/* 20 */
	eUnknownDollarOperand,				/* 21 */
	eUnmatchedEndOfGroup,				/* 22 */
	eIllegalLeftParen,				/* 23 */
	eIllegalConnector,				/* 24 */
	eIllegalTokenUnbalancedList,			/* 25 */
	eSslStackOverflow = 40,				/* 40 */
	lastOfErrorCodes
} ErrorCodes;

/* Type Values */

typedef enum {
	sDoubleQuote = 0,				/* 0 */
	sSingleQuote,					/* 1 */
	sBackQuote,					/* 2 */
	lastOfStringTerminator
} StringTerminator;

typedef enum {
	sName = 0,					/* 0 */
	sWord,						/* 1 */
	lastOfWordKind
} WordKind;

typedef enum {
	kCase = 0,					/* 0 */
	kDo,						/* 1 */
	kDone,						/* 2 */
	kElif,						/* 3 */
	kElse,						/* 4 */
	kEsac,						/* 5 */
	kFi,						/* 6 */
	kFor,						/* 7 */
	kIf,						/* 8 */
	kIn,						/* 9 */
	kLocalVariable,					/* 10 */
	kNull,						/* 11 */
	kSift,						/* 12 */
	kTfis,						/* 13 */
	kThen,						/* 14 */
	kUntil,						/* 15 */
	kWhile,						/* 16 */
	lastOfKeyword
} Keyword;

typedef enum {
	off = 0,					/* 0 */
	on,						/* 1 */
	lastOfFlag
} Flag;

typedef enum {
	bitHereData = 0,				/* 0 */
	bitQuotingHereData,				/* 1 */
	bitStripTabs,					/* 2 */
	bitTwoJumps,					/* 3 */
	bitInQuotes,					/* 4 */
	bitEmittedBuffer,				/* 5 */
	lastOfFlagBit
} FlagBit;

typedef enum {
	countDoubleQuoteNestingLevel = 0,		/* 0 */
	countBackQuoteNestingLevel,			/* 1 */
	countDollarInSiftLabel,				/* 2 */
	lastOfCounter
} Counter;

typedef enum {
	same = 0,					/* 0 */
	different,					/* 1 */
	lastOfHereCompare
} HereCompare;

typedef enum {
	empty = 0,					/* 0 */
	used,						/* 1 */
	lastOfBufferState
} BufferState;

typedef enum {
	noIO = 0,					/* 0 */
	yesIO,						/* 1 */
	lastOfIOop
} IOop;

