/*
 *	Copyright 1988 by Rayan S. Zachariassen, all rights reserved.
 *	This will be free software, but only when it is finished.
 */

#include <stdio.h>
#include "hostenv.h"
#include "mail.h"

/*
 * Return this machine's name in the uucp world.
 */
int
getmyuucpname(namebuf, len)
	char *namebuf;
	int len;
{
	FILE *fp;
	char *cp;

	/*
	 * Preferred method: use the UUCPNAME config variable.
	 */
	if ((cp = getzenv("UUCPNAME")) != NULL && strlen(cp) < len) {
		strcpy(namebuf, cp);
		return 0;
	}
	/*
	 * Failing that, check a couple of files.
	 */
	if ((fp = fopen("/etc/name.uucp", "r")) != NULL ||
	    (fp = fopen("/etc/uucpname", "r")) != NULL) {
		namebuf[len-1] = '\0';
		cp = fgets(namebuf, len, fp);
		fclose(fp);
		if (cp != NULL && cp[len-1] == '\0') {
			if (cp[strlen(cp)-1] == '\n')
				cp[strlen(cp)-1] = '\0';
			return 0;
		}
	}
	/*
	 * Default to the official hostname.
	 */
	return getmyhostname(namebuf, len);
}
