/*  This file should be edited with 4-column tabs! */
/*  Author: Mark Moraes <moraes@csri.toronto.edu> */

/*LINTLIBRARY*/

#include "defs.h"
#include "globals.h"
#include "trace.h"

RCSID("$Header: /j/moraes/shmem/malloc/malloc/RCS/_realloc.c,v 1.8 89/10/31 02:01:21 moraes Exp $");

univptr_t
__realloc(cp, nbytes, fname, linenum)
univptr_t cp;
size_t nbytes;
const char *fname;
int linenum;
{
	univptr_t old;
	
	PRTRACE(sprintf(_malloc_statsbuf, "%s:%d:", fname, linenum));
	old = cp;
	cp = realloc(cp, nbytes);
	if (old != cp) {
		DELETE_RECORD(old);
		RECORD_FILE_AND_LINE(cp, fname, linenum);
	}
	return(cp);
}
