/* File: list_box.C
 * Created: 4/4/92 by John Butare(jb7p@andrew.cmu.edu)
 * Description:
 *	
 * Modifications:
 */

#include <InterViews/label.h>
#include <InterViews/margin.h>
#include <InterViews/box.h>
#include <InterViews/glue.h>
#include <InterViews/action.h>
#include <InterViews/style.h>

#include "kit.h"
#include "generic_button.h"
#include "radio_button.h"
#include "rbbox.h"
#include "text_editor.h"
#include "label.h"

#include "list_box.h"
#include "string_list.h"

/*
 * ListBox
 */

declare(ActionCallback, ListBox);
implement(ActionCallback, ListBox);

ListBox::ListBox(StringList* list, GemsTextEditor* editor, Style* style) 
   : MonoGlyph(nil)
{
  GemsKit* gemsKit = GemsKit::instance();

  _list = list;
  _editor = editor;

  body(_buttons = 
       new RBBox(
       	   new TBBox(
       	       new VGlue(0.0, 0.0, 0.0),
       	       new HGlue(0.0, fil, fil)
       	   ),
       	   style       	   
       )
   );

  Glyph* stretch_hsep = new HGlue(2.0, fil, 0.0);

  Action* button_press = new ActionCallback(ListBox)(this, &ListBox::button_press);

  for (int i = 0 ; i < list->count() ; ++i) {
    _buttons->append(new VGlue(2.0, 0.0, 0.0));
    _buttons->append(
       new LRBox(
       	   stretch_hsep, 
       	   gemsKit->label(list->item(i), style),
       	   stretch_hsep
       ),
       style,
       button_press
   );
  }
    

  _buttons->append(new VGlue(2.0, fil, fil));
  _buttons->choose(1);
}

void ListBox::button_press()
{
  _editor->string(_list->item(_buttons->chosen()-1));
}
