/* File: selector.h
 * Created: 4/28/92 by Jason Barshay(jb6o@andrew.cmu.edu) 
 *                     John Butare(jb7p@andrew.cmu.edu)
 * Description:
 *	
 * Modifications:
 */

/*
 * Selector
 */

#ifndef selector_h
#define selector_h

#include "drawing.h"

class Action;
class SelectorTool;

class Selector : public Drawing {
public:
  Selector(DrawingBox* box, Window* window, Action* update =nil);
  ~Selector();
  
  virtual void sense(Event&);
  virtual void press(Event&);
  virtual void drag(Event&);
  virtual void release(Event&);

  void move(Coord x, Coord y, Coord width =-1.0, Coord height =-1.0);
  void size(Coord width, Coord height);
  void location(Coord& x, Coord&y, Coord& width, Coord& height);
  void zoom_info(float& px, float& py, float& pwidth, float& pheight);

private:
  void fix_cursor();
  SelectorTool* _tool;
  class Page* _page;
  Patch* _patch;
  Window* _window;
};

#endif
