/* File: map.c
 * Created: 3/26/92 by John Butare(jb7p@andrew.cmu.edu)
 * Description:
 *	
 * Modifications:
 */

/*
 * Map
 */

#include <InterViews/display.h>
#include <InterViews/background.h>
#include <InterViews/session.h>
#include <InterViews/style.h>
#include <InterViews/window.h>
#include <InterViews/box.h>
#include <InterViews/glue.h>
#include <InterViews/margin.h>
#include <InterViews/action.h>
#include <InterViews/color.h>
#include <InterViews/hit.h>

#include <IV-look/kit.h>
#include <IV-look/menu.h>
#include <IV-look/field.h>

#include <stdio.h>

#include <UI/kit.h>

#include "figure.h"
#include "drawing.h"
#include "gems.h"
#include "map.h"
#include "toolbox.h"
#include "query.h"
#include "selector.h"
#include "selection.h"

#include <UI/label.h>

declare(ActionCallback, Map);
implement(ActionCallback, Map);

Map::Map(char* name)
{
  Gems* gems = Gems::instance();
  Kit* kit = Kit::instance();
  GemsKit* gemsKit = GemsKit::instance();
  Style* style = gems->style();
   Display* d = gems->display();

  Glyph* stretch_vsep = new VGlue(2.0, fil, 0.0);
  Glyph* fixed_vsep = new VGlue(2.0, 0.0, 0.0);
  Glyph* stretch_hsep = new HGlue(2.0, fil, 0.0);
  Glyph* fixed_hsep = new HGlue(2.0, 0.0, 0.0);

  _drawing_box = new DrawingBox(500.0, 500.0);
  _selection = new Selection(this);
  
  /*
   * Menu
   */
  Menu* menubar = kit->menubar(style);
  Menu* pull1 = kit->pulldown(style);
  Telltale* pullname1 = kit->menubar_item(kit->label("File", style), style);
  pull1->add_item(kit->menu_item(kit->label("Quit", style), style), kit->quit());
  menubar->add_item(pullname1, pull1);

  Menu* pull3 = kit->pulldown(style);
  Telltale* pullname3 = kit->menubar_item(kit->label("Help", style), style);
  pull3->add_item(kit->menu_item(kit->label("Help on...", style), style));
  pull3->add_item(kit->menu_item(kit->label("Help with GEMS", style), style));
  pull3->add_item(kit->menu_item(kit->label("Help with Help", style), style));
  menubar->add_item(pullname3, pull3);

  /* 
   * Status Line
   */
  char* label = new char[1];
  label[0] = '\0';
  _status_line = new GemsLabel(label, style->font(), style->foreground());

  /*
   * Layout
   */

  Glyph* map =
    new Background(
       new TBBox(
       	   new VGlue(0.0, 0.0, 0.0),
	   fixed_vsep,
	   new LRBox(fixed_hsep, menubar, fixed_hsep),
	   fixed_vsep,
       	   _status_line,
	   fixed_vsep,
       	   new Margin(_drawing_box, 2.0)
       ),
       style->flat()
   );

  _window = new TopLevelWindow(map);

//  _selector = new Selector(_drawing_box, _window, 
// 		new ActionCallback(Map)(this, &Map::selection_cb));
//  _selector->visible(true);

  _window->name(name);
  _window->place(d->width() / 2.0, d->height() / 2.0);
  _window->align(0.5, 0.5);
}

char* Map::status_line() 
{
  return(_status_line->string());
}

void Map::status_line(char *value) 
{
  _status_line->string(value);
}

void Map::selection_cb()
{
  float px, py, a, b;
  _selector->zoom_info(px, py, a, b);
  printf("Map::selection_cb()\n");
/*  Coord x, y, width, height;
  _selector->location(x, y, width, height);
  Hit h = Hit(x, y, x+width, y+height);
  _drawing_box->repick(h);
  int depth = h->count();
  int num_glyphs;
  int i, j;
  for (i = 0; i < depth; i++)
    {
      num_glyphs = h->depth(i);
      _selection->replace_selection((Figure *) h->target(i, j));
      for (j = 1; j < num_glyphs; j++)
	_selection->add_selection((Figure *) h->target(i, j));
    }
*/
}

void Map::set_name(char* name)
{
  _name = name;
  _window->name(name);
}

  
void Map::display()
{
//  _viewer->zoom_to_fit(width, height);
  _window->map();
}
