/****************************************************************************
 *
 * Class:  TextBuf implementation
 * Author: Mark Roseman
 * 
 * This class is the beginnings of a glyph version of the 2.5 TextBuffer
 * class, which provides a series of operations (typically coming from a
 * terminal Emulator) to manipulate a text buffer.  Not quite done yet!
 *
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 08/14/92 MR        initial version
 *
 ****************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#include <gk-ui/text.h>


#include <InterViews/style.h>
#include <InterViews/texcomp.h>
#include <stdio.h>
#include <stream.h>
#include <osfcn.h>
#include <InterViews/character.h>
#include <InterViews/label.h>
#include <InterViews/patch.h>
#include <InterViews/font.h>
#include <InterViews/canvas.h>

TextBuf::TextBuf(
    WidgetKit* kit, int cols, int rows
) {
  cols_ = cols;
  rows_ = rows;
  LayoutKit& layout = *LayoutKit::instance();
  f_ = kit->font();
  fg_ = kit->foreground();
  
  lines_ = layout.vbox();
  num_lines_ = 0;
  region_start_ = 1;
  region_stop_ = rows_;
  for(int i = 0; i < rows_; i++) 
     lines_->append( empty_line() );
  patch_ = new Patch(lines_);
  body(patch_);
  width_ = -1;
}

PolyGlyph* TextBuf::empty_line() {
  PolyGlyph* line = LayoutKit::instance()->hbox();
  for(int i=0; i < cols_; i++)
    line->append(new Character(' ', f_, fg_));
  return line;
}

TextBuf::~TextBuf() {
}


void TextBuf::FlushLine() {
}


void TextBuf::AddChar(char c) {

  if (y_ > num_lines_) {
    num_lines_++;
  }

  PolyGlyph* line = (PolyGlyph*)lines_->component(y_);
  line->replace( x_, new Character(c, f_, fg_));
  if((width_ == -1.0) && (patch_->canvas())) {
    width_ = patch_->canvas()->to_coord(f_->Width("m"));
    height_ = patch_->canvas()->to_coord(f_->Height());
  }

   if(x_ < cols_ - 1) {
    if(width_ != -1.0) {
       patch_->canvas()->damage(
 		     patch_->allocation().left() + x_ * width_,
		     patch_->allocation().top() - (y_+1) * height_,
 		     patch_->allocation().left() + (x_+1) * width_,
 		     patch_->allocation().top() - (y_) * height_);
    } 
    CursorRight(1); 
  } else {
    CarriageReturn();
    ForwardScroll();
  }
}

void TextBuf::BackSpace() {
  if (x_ >= 1) 
    --x_;
  else if (y_ >= 1) {
    x_ = cols_-1;
    --y_;
  }
}


void TextBuf::Blink(boolean) {
  /* unimplemented */
}


void TextBuf::Bold(boolean) {
  /* unimplemented */
}


void TextBuf::CarriageReturn() {
  x_ = 0;
}


void TextBuf::CheckScroll(const char*, int, int) {

}



void TextBuf::SetNorCharSet(int) {
}



void TextBuf::CursorDown(int n) {
  y_ += n;
  if(y_ >= rows_)
    y_ = rows_ - 1;
}


void TextBuf::CursorLeft(int n) {
  x_ -= n;
  if(x_ < 0)
    x_ = 0;
}


void TextBuf::CursorOff() {

}


void TextBuf::CursorOn() {

}


void TextBuf::CursorRight(int n) {
  x_ += n;
  if( x_ >= cols_)
    x_ = cols_ - 1;
}


void TextBuf::CursorUp(int n) {
  y_ -= n;
  if (y_ < 0)
    y_ = 0;
}


void TextBuf::DeleteCharacters(int n) {
  n = (x_ + n >= cols_ ? cols_ - x_ : n );
  PolyGlyph* line = (PolyGlyph*)lines_->component(y_);
  for(int i = 0; i < n; i++) {
    line->remove(x_);
    line->append(new Character(' ', f_, fg_));
  }
}


void TextBuf::DeleteLines(int n) {
  n = (y_ + n >= rows_ ? rows_ - y_ : n );
  for(int i = 0; i < n ; i++) {
    lines_->remove(y_);
    lines_->append(empty_line());
  }
}


void TextBuf::EraseBOL() {
  PolyGlyph* line = (PolyGlyph*)lines_->component(y_);
  for(int i = 0; i < x_; i++)
       line->replace(i, new Character(' ', f_, fg_));
  patch_->canvas()->damage(
     patch_->allocation().left(),
     patch_->allocation().top() - (y_+1) * height_,
     patch_->allocation().left() + x_ * width_,
     patch_->allocation().top() - (y_) * height_);
}


void TextBuf::EraseEOL() {
  PolyGlyph* line = (PolyGlyph*)lines_->component(y_);
  for (int i = 0; i<80; i++) {
    line->remove(x_);
    line->append(new Character(' ', f_, fg_));
  }
  patch_->canvas()->damage(
     patch_->allocation().left() + x_ * width_,
     patch_->allocation().top() - (y_+1) * height_,
     patch_->allocation().left() + 80 * width_,
     patch_->allocation().top() - (y_) * height_);
}


void TextBuf::EraseLine() {
  lines_->replace( y_, empty_line());
}


void TextBuf::EraseScreen(int mode) {  // (to-end, to-begin, all)

  int savey = y_;
  switch(mode) {
  case 0:
    EraseEOL();
    for(y_ = y_ + 1; y_ <= num_lines_ ; y_++) 
      EraseLine();
    y_ = savey;
    num_lines_ = y_;
    break;
  case 1:
    EraseBOL();
    for(y_ = 0; y_ < savey; y_++)
      EraseLine();
    y_ = savey;
    break;
  case 2:
    for(y_ = 0; y_ <= num_lines_ ; y_++) 
      EraseLine();
    num_lines_ = 0;
    y_ = savey;
    break;
  default:
    break;
  }
  patch_->redraw();
}

void TextBuf::ForwardScroll() {
  if (y_ == (region_stop_ - 1)) { 
    lines_->remove(region_start_ -1 );
    if (region_stop_ == rows_)
      lines_->append(empty_line());
    else
      lines_->insert(region_stop_ - 1 ,empty_line());
    patch_->redraw();
  } else
    CursorDown(1);
}

void TextBuf::ReverseScroll() {
  if (y_ == (region_start_ -1)) {
   lines_->insert(region_start_ -1, empty_line());
   lines_->remove(region_stop_);
    patch_->redraw();
  } else
    CursorUp(1);
}

int TextBuf::GetHeight() {
  return rows_;
}


void TextBuf::Goto(int y,int x) {
  x_ = x-1; y_ = y-1;
}


void TextBuf::InsertCharacters(int n) {
  PolyGlyph* line = (PolyGlyph*)lines_->component(y_);
  for(int i=0; i< n; i++) {
    line->insert( x_, new Character(' ', f_, fg_));
    line->remove(cols_);
  }
}


void TextBuf::InsertLines(int n) {
  for(int i = 0; i < n; i++) {
    lines_->insert( y_ + 1 , empty_line());
    lines_->remove(rows_);
  }
}


void TextBuf::Inverse(boolean) {
  /* unimplemented */
}


void TextBuf::RestoreCursor() {

}


void TextBuf::SaveCursor() {

}


void TextBuf::SavePos() {
}


void TextBuf::SetAltCharSet(int) {

}


void TextBuf::SetRegion(int i, int j) {

  region_start_ = i;
  region_stop_ = j;

}


void TextBuf::Tab() {
  CursorRight(8 - x_ % 8);
}


void TextBuf::Underline(boolean) {
  /* unimplemented */
}


void TextBuf::UseAlt(boolean) {

}



