/**************************************************************************
 * 
 * Monitor users in conference.  More typically this would not run as
 * the only glyph in the application, but as part of another one (e.g.
 * another window in a facilitated conference monitor).
 *
 **************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */


#include <gk/groupsession.h>
#include <InterViews/window.h>
#include <stdio.h>
#include "usermon.h"
#include <IV-look/kit.h>

int main(int argc, char** argv) {
  GroupSession* session = new GroupSession("UserMonitor", argc, argv);
  session->run_window(
    new ApplicationWindow(
      new UserMonitor(WidgetKit::instance(), session->conference())
    )
  );
}

