/**************************************************************************
 *
 * Class:  MsgSender and StrMsgSender
 * Author: Mark Roseman
 * 
 * A MessageSender is a virtual class provided to allow routines to send
 * messages over multiple sockets.  The particular subclass defines the
 * actual message to be sent.  This is used e.g. in the conference "toAll"
 * method.
 *
 * A string message sender accepts a message number (command) and also a 
 * string (command options) to send.
 *
 * 
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 02/17/92 MR        initial version
 * 08/14/92 MR        clean up
 * 
 ***************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#ifndef __msgsender_h
#define __msgsender_h


class MsgSender {
public:

  /*
  ** constructor
  */
  MsgSender();

  /*
  ** routine to send a message - should use
  **    w->server() << RpcHdr(w, msg_code) << other stuff << flush;
  */
  virtual void sendOn(class Writer* w) = 0;
};


class StrMsgSender : public MsgSender {
public:
  StrMsgSender(int msg_code, char *msg);
  virtual void sendOn(class Writer* w);
private:
  int code;
  char* msg;
};

#endif
