/**************************************************************************
 *
 * Class:  ConferenceGlyph
 * Author: Mark Roseman
 *
 * A conference glyph is a glyph (ActiveHandler) which contains a pointer
 * to its associated conference object.
 *
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 06/08/92 MR        initial version
 * 08/14/92 MR        clean up
 * 
 ***************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#ifndef __confglyph_h
#define __confglyph_h

#include <InterViews/input.h>

class ConferenceGlyph: public ActiveHandler {
public:
  ConferenceGlyph(class Glyph*, class Style*, class Conference*);
  class Conference* conference();
protected:
  class Conference* conf_;
};

#endif
