/****************************************************************************
 *
 * Class:  TextBuf
 * Author: Mark Roseman
 * 
 * This class is the beginnings of a glyph version of the 2.5 TextBuffer
 * class, which provides a series of operations (typically coming from a
 * terminal Emulator) to manipulate a text buffer.  Not quite done yet!
 *
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 08/14/92 MR        initial version
 *
 ****************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#ifndef __text_h
#define __text_h

#include <InterViews/monoglyph.h>
#include <IV-look/kit.h>
#include <OS/file.h>
#include <InterViews/composition.h>
#include <InterViews/layout.h>
#include <OS/string.h>
#include <InterViews/font.h>
#include <InterViews/color.h>

class TextBuf : public MonoGlyph {
public:
  TextBuf(WidgetKit* kit, int cols, int rows);
  virtual ~TextBuf();

  void FlushLine();
  void AddChar(char c);
  void BackSpace();
  void Blink(boolean);
  void Bold(boolean);
  void CarriageReturn();
  void CheckScroll(const char*, int, int);
  void SetNorCharSet(int);
  void CursorDown(int);
  void CursorLeft(int);
  void CursorOff();
  void CursorOn();
  void CursorRight(int);
  void CursorUp(int);
  void DeleteCharacters(int);
  void DeleteLines(int);
  void EraseBOL();
  void EraseEOL();
  void EraseLine();
  void EraseScreen(int);
  void ForwardScroll();
  int GetHeight();
  void Goto(int,int);
  void InsertCharacters(int);
  void InsertLines(int);
  void Inverse(boolean);
  void RestoreCursor();
  void ReverseScroll();
  void SaveCursor();
  void SavePos();
  void SetAltCharSet(int);
  void SetRegion(int,int);
  void Tab();
  void Underline(boolean);
  void UseAlt(boolean);
protected:
  PolyGlyph* empty_line();
private:
  PolyGlyph* lines_;
  int cols_, rows_;
  int x_, y_;
  int lastx_, lasty_;
  int num_lines_, region_start_, region_stop_;
  const Font* f_;
  const Color* fg_;
  class Patch* patch_;
  Coord width_, height_;
};

#endif

