/****************************************************************************
 *
 * Class:  Shell
 * Author: Mark Roseman
 * 
 * This class manages a Unix shell process, using an emulator and a
 * text buffer.
 *
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 08/14/92 MR        initial version
 *
 ****************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#include <Dispatch/iohandler.h>
#include <InterViews/input.h>
#include <stdio.h>

class Shell : public InputHandler, public IOHandler {
public:
	Shell(class WidgetKit*);
	virtual int inputReady(int fd);
	virtual void keystroke(const Event&);
private:
	class Emulator* em_;
	FILE* in_file;
	FILE* out_file;
};
