@echo OFF

rem
rem     check TCP/IP installed
rem

IF EXIST %SystemRoot%\system32\tcpsvcs.exe goto TCPOK

echo DNS Service not installed.
echo .
echo You must install TCP/IP before installing the DNS service.
echo .

goto LAST

:TCPOK

rem
rem     check for previous executable
rem

if not exist %SystemRoot%\system32\dnssvc.dll goto COPY

echo .
echo A previous version of the DNS server exists on this machine.
echo .
echo To update DNS service manually:
echo     - net stop DNS
echo     - cd to System32 directory and save old version of dnssvc.dll
echo     - copy new dnssvc.dll to System32 directory
echo     - restart the DNS service
echo .

pause Hit any key, for automatic update of DNS service. Cntrl-C to cancel.

net stop DNS
copy    %SystemRoot%\system32\dnssvc.dll %SystemRoot%\system32\dnssvc.bak


:COPY
rem
rem     copy the executable
rem

copy dnssvc.dll %SystemRoot%\system32\dnssvc.dll

rem
rem     configure the registry
rem

dnssetup %SystemRoot%\system32\tcpsvcs.exe %SystemRoot%\system32\dnssvc.dll


echo .
echo The DNS Service is now installed.
echo .
echo If you are creating a new installation, you may find the sample
echo database files helpful.  Copy them to the system32\drivers\etc
echo directory and edit them appropriately for your site.
echo See readme.txt for more information.
echo .
echo If you are using files from a BIND installation, copy the database
echo files to system32\drivers\etc.  Then make sure the boot file --
echo often called "named.boot" in UNIX installations -- is renamed
echo "boot".
echo .
echo After modifying the database files, try starting the service:
echo    "net start dns"
echo at the command line, or use the services control panel applet.
echo .
echo If the service fails to start check the event log for information
echo on database configuration problems.  Most configuration problems
echo will cause an event describing the specific cause of the failure.
echo .

:LAST
