LS(1)                   USER COMMANDS                     LS(1)

NAME
     ls - list the contents of a directory.               [Version 1.5]

SYNOPSIS
     ls [-aAcCdDFgGhIlLRrtuz1] file1 file2 ...

DESCRIPTION
     ls is a command similar to DIR, but gives additional information
     about files and directories such as owner, group and permissions
     associated with each file and directory.

     The -l option shows information in long format. Output is divided
     into several fields: the permissions field, the file's owner, the
     groups field (showing all other users and groups who have been
     granted specific rights to the file/directory), the file's size,
     the modification date and the name:

	-rwxdr-x----- tomas      Users      43008 Aug 02 17:43 ls.exe
	_____________ _____      _____      _____ ____________ ______
	permissions   owner      group      size  mod.date     name

    
     In addition, it is possible to add two more fields: the attribute field
     (-z option) and DOS short file name (-D option).


  Permissions Field
     The permissions field, which is printed with the -l option on NTFS
     file-systems, should be interpreted as follows:

     The first character shows the file type:
          - = entry is a plain file
          d = entry is a directory
	  t = entry is a temporary file
          s = entry is a system file
          c = entry is a compressed file

     The next 12 characters should be interpreted as three sets of four(!)
     characters each. The first set refers to the owner's permissions; 
     the next set shows access rights explicitly granted to other users
     or groups; the last set refers to permissions for everyone else.
     Within each set, the 4 fields indicate permission to read; to write;
     to execute the file as a program; and to delete it (rwxd).
     
     It felt necessary to extend the Unix "ls" output format slightly since
     NT interprets access-rights differently, i.e. an explicit delete right
     can be assigned a file. (Upon request, I can add an option not to show
     this entry.)
     
     The four letter positions in each set should be interpreted as follows.
     In general, anything but the four lower-case letters "rwxd" indicates
     that some kind of limitation applies:

	-------
	1 | r  file is readable/directory is listable
	-------
	  | w  write allowed, no restrictions
	  | W  write allowed but not append on files/directory allows file
	  |	 creation only (no subdirs)
	2 | a  only append allowed/directory allows subdir creation only
	  | *  the file is not writable, but ownership or protection
	  |      can be changed (this should be seen as a warning)
	  | =  the file is writable according to the access list, but the
	  |	 read-only attribute prevents writing (see the -z flag)
	-------
	3 | x  file is executable/directory is traversable
	-------
	  | d  delete is granted for this file or directory as well as for
	4 |      all subdirectories
	  | D  delete is granted but not for subdirectories
	  | c  delete is only granted for subdirectories
	-------

       The following two letters may also appear:
	  -  the indicated permission is not granted
	  ?  the indicated permission is not known by ls (only occurs in 
	       some rare cases when negative access rights are present)


  Attribute Field
     The attribute field replaces the permissions field on non NTFS file
     systems. (It is also printed on NTFS file systems when -z option is
     specified.) It contains the following 7 fields (characters):

	  d = entry is a directory
	  s = entry is a system file
	  r = entry is read-only (see the ATTRIB command)
	  h = entry is hidden (ls needs -a option to show these files)
	  a = entry has the archive bit set
	  T = entry is a temporary file
	  c = entry is a compressed file / all files created in this dir will
		be compressed

  Owner and group fields
      The owner field shows the owner of the file. The group field shows
      all(!) users and groups who are explicitly granted permission to
      the file or the directory. (This interpretation differs from the POSIX
      interpretation since POSIX groups are ignored by NT).
      For example, if user A has permission to read a file (r), and user
      B has permission to write (w), the group permission field will show
      "rw--" and the group field shows "A,B".
      
      Thus, group permissions should be interpreted as a super-set of all
      access rights EXPLICITLY given to other users on the system. Note that
      all other users' rights are shown in the third set of the permissions
      field. Also note that Administrator's and System's rights are not
      included anywhere, i.e. they may have full access to all files even
      if ls doesn't tell you!

OPTIONS
     The following command-line options can be given to ls. ls will also
     recognize these options if they are present in the environment variable
     LSFLAGS which is useful when customizing output. 

     -a   List all entries; in the absence of this option,
           hidden entries and . and .. do not show up
     -A   Same as -a, except don't show  `.' and `..'
     -c   Show creation time instead of last modification time
     -C   Force multi-column output, with entries sorted down the
           columns;  this is the default when output is to a terminal.
     -1   Force one column output; this is the default when output is not
	   to a terminal.
     -d   If argument is a directory, list only its name (not its contents);
	   often  used  with -l to get the status of a directory.
     -D   Show MS-DOS short filenames (8+3 characters)
     -F   Mark directories with a trailing slash /
     -g   Show group ownership together with -l. See above for explanation.
     -G   Same as -g, except that when group field becomes too long, only the
	   number of entries is shown, e.g. <10>. This makes the output
	   readable when many entries are present.
     -h   Print version number and usage information
     -I   Ignore case when sorting
     -l   List in long format (required for many other options)
     -L   Show names in lower case (non NTFS file-systems only)
     -r   Reverse the order of sort to get reverse alphabetic or oldest first
     -R   Recursively list subdirectories encountered
     -t   Sort by time modified (latest first) instead of by name
     -u   Show time for last access instead of last modification time
     -z   Show DOS attributes


BUGS
     The ? output for owner protection should be removed. This involves
     some work to check owner's group membership.

     The output window is assumed to be 80 columns wide.

COPYRIGHT
     This program can be freely distributed and used as long as it is
     not sold or made part of any commercial product. No responsibility
     is taken for the program, for its output, correctness etc. 

AUTHOR
     Please send comments, suggestions and questions to:
	Tomas Olovsson  [olovsson@ce.chalmers.se]

