;; trans-mode.el --- File translation mode support staff.
;; Copyright (C) 1993 Free Software Foundation, Inc.

;; Author: Manabu Higashida <manabu@sigmath.es.osaka-u.ac.jp>
;; Version: 2.0

;; This file is part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Commentary:

;;; 92.11.2  created for Mule Ver.0.9.6 with DOS support
;;; 93.7.16  modified for GNU Emacs Ver.19.16

;;; code:

(setq-default mode-line-format
  (list (purecopy "")
   'mode-line-modified
   'mode-line-buffer-identification
   (purecopy "   ")
   'global-mode-string
   (purecopy "   %[(")
   (purecopy '(buffer-file-translation-mode "T:"))
   'mode-name 'minor-mode-alist "%n" 'mode-line-process
   (purecopy ")%]--")
   (purecopy '(line-number-mode "L%l--"))
   (purecopy '(-3 . "%p"))
   (purecopy "-%-")))

;; utilities

(defconst *file-translation-mode-obarray* (make-vector 10 0))

;;; nil		: Do Nothing (ex. MS-DOS Binary)
;;; *dos-text*	: MS-DOS Text
(intern "nil" *file-translation-mode-obarray*)
(intern "*dos-text*" *file-translation-mode-obarray*)

(defun check-file-translation-mode (mode)
  (let (found)
    (mapatoms '(lambda (atom)
		 (if (string= (symbol-name atom) (symbol-name mode))
		     (setq found t)))
	      *file-translation-mode-obarray*)
    (if (null found) (error "Invalid file-translation-mode: %s" mode))))

(defmacro read-file-translation-mode (prompt)
  (list 'intern
	(list 'completing-read prompt '*file-translation-mode-obarray*
	      nil t)))

(defun set-buffer-file-translation-mode (mode &optional buffer)
  (interactive (list (read-file-translation-mode "file-translation-mode: ")))
  (check-file-translation-mode mode)
  (save-excursion
    (set-buffer (or buffer (current-buffer)))
    (setq buffer-file-translation-mode mode))
  ;;; Force mode-line updates
  (progn
    (save-excursion (set-buffer (other-buffer)))
    (set-buffer-modified-p (buffer-modified-p))
    (siet-for 0)))

(defun set-default-file-translation-mode (mode)
  (interactive (list (read-file-translation-mode "file-translation-mode: ")))
  (check-file-translation-mode mode)
  (setq-default buffer-file-translation-mode mode))

;;;

(defun dos-text ()
  "Execute a command with dos-text file translation mode."
  (interactive)
  (let* ((old (default-value 'buffer-file-translation-mode))
	 (prefix-arg current-prefix-arg)
	 (key (read-key-sequence "DOS-Text: "))
	 (cmd (key-binding key)))
    (message "")
    (if (null cmd)
	(beep)
      (let ((last-command-char (string-to-char key)))
	(unwind-protect
	    (progn
	      (setq-default buffer-file-translation-mode *dos-text*)
	      (command-execute cmd))
	  (setq-default buffer-file-translation-mode old))))))

;; 92.11.2 by M.Higashida
(defun invoke-find-file-translation-mode (filename)
  (save-excursion
    (funcall find-file-translation-mode filename)))

;; 92.11.2 by M.Higashida
(setq find-file-translation-mode
      'find-file-translation-mode-from-file-name)

(defvar file-name-file-translation-mode-alist nil)

(defun find-file-translation-mode-from-file-name (filename)
  (let ((alist file-name-file-translation-mode-alist)
	(found nil)
	(code (default-value 'buffer-file-translation-mode)))
    (let ((case-fold-search (eq system-type 'ms-dos)))
      (setq filename (file-name-sans-versions filename))
      (while (and (not found) alist)
	(if (string-match (car (car alist)) filename)
	    (setq code (cdr (car alist))
		  found t))
	(setq alist (cdr alist))))
    code))

(defun define-file-name-file-translation-mode (filename code)
  (let* ((place (assoc filename file-name-file-translation-mode-alist)))
    (if place
	(setcdr place code)
      (setq place (cons filename code))
      (setq file-name-file-translation-mode-alist
	    (cons place file-name-file-translation-mode-alist)))
    place))

;;;

(defun find-file-not-found-set-file-translation-mode ()
  (save-excursion
    (set-buffer (current-buffer))
    (setq buffer-file-translation-mode
	  (find-file-type-from-file-name (buffer-file-name))))
  nil)
