
;;; sample startup file
;;; semi-colon(s), beginning of line means that the line is commented out.

; If you have some trouble, uncomment the next-line and try again
; (setq debug-on-error t)

;;;
;;; Reading News:
;;;
;;; These should be set up with the appropriate values for your
;;; organization
;;;
(setq gnus-nntp-server "rsd0")
(setq gnus-local-domain "rsd.dl.nec.com")
(setq gnus-local-organization "Aggie Apline Uphill Ski Team")

;;; For example:
;;;
;;; (setq gnus-nntp-server  "congrunt")
;;; (setq gnus-local-domain "congruent.com")
;;; (setq gnus-local-organization "Congruent Corporation")
;;;
;;;

(load "tcp")
(setq tcp-program-name "/usr/local/bin/tcp.exe")

(autoload 'gnus "gnus" "Read network news." t)
(autoload 'gnus-post-news "gnuspost" "Post a news." t)


;;;
;;; Check if .el files are compiled, if not then 
;;; byte compile them...

(let* ((dir     "/usr/local/emacs/lisp")
       (compile (concat dir "/bytecomp.el"))
       (run     (concat dir "/byte-run.el"))
       (opt     (concat dir "/byte-opt.el"))
       )

  (if (not (file-exists-p (concat compile "c")))
      (let* ((buf (get-buffer-create "Emacs Initialization"))
	     )
	(switch-to-buffer-other-window buf)
	(insert "Emacs build complete, please exit and restart emacs.")

	;; First compile the byte compiler (this speeds things up!)
	(byte-compile-file compile)
	(load (concat compile "c"))
	(byte-compile-file run)
	(load (concat run "c"))
	(byte-compile-file opt)
	(load (concat opt "c"))
	(byte-recompile-directory "/usr/local/emacs/lisp" 0)       
	)))

